<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hotpot', language 'cs', version '3.8'.
 *
 * @package     hotpot
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'nedokončeno';
$string['abandonhotpot'] = 'Vaše dosavadní výsledky budou uloženy, ale nelze pokračovat nebo tuto činnost restartujte později.';
$string['activitycloses'] = 'Aktivity uzavřeny';
$string['activitygrade'] = 'Hodnocení aktivity';
$string['activityopens'] = 'Aktivity otevřeny';
$string['added'] = 'Přidáno';
$string['addquizchain'] = 'Přidat sadu testů';
$string['addquizchain_help'] = 'Měly by být přidány všechny testy v řetězci testů?

** Ne **
: ke kurzu bude přidán pouze jeden test

** Ano **
: pokud je zdrojový soubor a ** quiz file **, je považován za začátek řetězce testů a všechny testy v řetězci budou přidány do kurzu se stejnými nastaveními. Každý test v řetězci musí mít odkaz na další soubor řetězce.

Pokud je zdrojovým souborem **složka **, všechny rozpoznatelné testy ve složce budou přidány do kurzu a vytvoří řetězec testů s identickými nastaveními.

Pokud je zdrojový soubor ** unit file **, jako je například soubor Hot Potatoes masher nebo index.html, testy uvedené v souboru jednotky budou přidány do kurzu jako řetězec testů se stejnými nastaveními.';
$string['allowpaste'] = 'Povolit vložení';
$string['allowpaste_help'] = 'Pokud je toto nastavení povoleno, budou moct studenti kopírovat, vkládat a přetahovat text do textových vstupních polí.';
$string['allowreview'] = 'Povolit prohlédnutí';
$string['allowreview_help'] = 'Je-li zvoleno, studenti mají možnost nahlédnout do svých pokusů po ukončení testu.';
$string['analysisreport'] = 'Položková analýza';
$string['attempted'] = 'Pokus proběhl';
$string['attemptlimit'] = 'Limit pokusů';
$string['attemptlimit_help'] = 'Maximální počet pokusů, které má student k dispozici pro tuto činnost.';
$string['attemptnumber'] = 'Počet pokusů';
$string['attempts'] = 'Pokusy';
$string['attemptscore'] = 'Skóre pokusů';
$string['attemptsunlimited'] = 'Neomezené pokusy';
$string['average'] = 'Průměr';
$string['averagescore'] = 'Průměr skóre';
$string['bodystyles'] = 'Styl';
$string['bodystylesbackground'] = 'Barva pozadí a obrázek';
$string['bodystylescolor'] = 'Barva písma';
$string['bodystylesfont'] = 'Velikost a typ písma';
$string['bodystylesmargin'] = 'Levý a pravý okraj';
$string['cacherecords'] = 'Záznamy mezipaměti HotPot';
$string['canrestarthotpot'] = 'Vaše dosavadní výsledky budou uloženy a můžete znovu pracovat "{$a}" později';
$string['canresumehotpot'] = 'Vaše dosavadní výsledky budou uloženy a pokračovat můžete "{$a}" později.';
$string['checks'] = 'Checks (Odpovědi)';
$string['checksomeboxes'] = 'Zkontrolujte některá pole';
$string['clearcache'] = 'Vymazat mezipaměť HotPot';
$string['cleardetails'] = 'Vymazat detaily HotPot';
$string['clearedcache'] = 'Vyrovnávací paměť HotPot byla vymazána';
$string['cleareddetails'] = 'Detaily  HotPot byly vymazány';
$string['clickreporting'] = 'Podrobný protokol o průchodu';
$string['clickreporting_help'] = 'Pokud je povoleno, je zapsán samostatný záznam vždy, když student klikne na tlačítko "tip", "nápověda" nebo "kontrola". To umožňuje učiteli vidět velmi podrobnou zprávu, o stavu testu při každém kliknutí. V opačném případě zůstane pouze jeden záznam o pokusu v testu.';
$string['clicktrailreport'] = 'Stopa kliků';
$string['closed'] = 'Tyto aktivity byly uzavřeny';
$string['clues'] = 'Nápovědy (Clues)';
$string['completed'] = 'dokončeno';
$string['completioncompleted'] = 'Vyžadovat splnění činnosti';
$string['completionmingrade'] = 'Minimální požadovaná známka';
$string['completionpass'] = 'Vyžadovat potřebnou známku';
$string['completionwarning'] = 'Tato pole jsou deaktivována, pokud je limit pro tuto aktivitu "Bez známky" nebo váha známky je "Bez váhy"';
$string['configbodystyles'] = 'Ve výchozím nastavení budou styly motivů Moodle přepsat styly aktivity HotPot. Pro všechny styly, které jsou zde zvoleny, však budou styly motivů HotPot upřednostněny před styly motivů Moodle.';
$string['configenablecache'] = 'Údržba mezipaměti testů HotPot může výrazně urychlit předání testů studentům.';
$string['configenablecron'] = 'Určete hodiny ve vaší časové zóně, ve kterých může spouštět skript HotPot cron';
$string['configenablemymoodle'] = 'Toto nastavení určuje, zda jsou položky HotPots uvedené na stránce MyMoodle nebo nikoliv';
$string['configenableobfuscate'] = 'Zablokování textových řetězců a adres URL v kódu javascript ztěžuje hádat odpovědi zobrazením zdroje stránky HTML v prohlížeči.';
$string['configenableswf'] = 'Povolte vkládání souborů SWF do aktivit HotPot. Je-li zapnuta, toto nastavení přepíše filter_mediaplugin_enable_swf.';
$string['configfile'] = 'Konfigurační soubor';
$string['configframeheight'] = 'Když se v rámci snímku zobrazí test, je tato hodnota výšky (v pixelech) horního rámce, který obsahuje navigační lištu Moodle.';
$string['configlocation'] = 'Umístění konfiguračního souboru';
$string['configlockframe'] = 'Je-li toto nastavení zapnuté, navigační rámeček, pokud je použit, bude uzamčen tak, aby nebyl posunovatelný, neměnitelný a bez hranic';
$string['configmaxeventlength'] = 'Pokud je HotPot zadán jak otevřený, tak uzavřený čas a rozdíl mezi dvěma časy je větší než zde zadaný počet dnů, do kalendáře kurzu budou přidány dvě samostatné události kalendáře. Pro kratší doby trvání nebo pokud je zadán pouze jeden čas, bude přidána pouze jedna událost kalendáře. Není-li zadán žádný čas, nebude přidána žádná událost kalendáře.';
$string['configstoredetails'] = 'Je-li toto nastavení povoleno, pak se v tabulce hotpot_details uloží uložené podrobnosti XML pokusů testů HotPot. To umožňuje pokusy testů v budoucnu přehodnotit, aby odrážely změny v systému hodnocení bodů HotPot. Aktivace této možnosti na obsazeném webu však způsobí, že tabulka hotpot_details bude velmi rychle růst.';
$string['confirmdeleteattempts'] = 'Chcete skutečně vymazat tyto pokusy?';
$string['confirmstop'] = 'Jste si jisti, že chcete odstranit z této stránky navigaci?';
$string['correct'] = 'Správně';
$string['couldnotinsertsubmissionform'] = 'Nelze vložit formulář pro odpovědi';
$string['d_index'] = 'Diskriminační index';
$string['delay1'] = 'Prodleva 1';
$string['delay1_help'] = 'Prodleva mezi prvními a druhými pokusy.';
$string['delay1summary'] = 'Časová prodleva mezi prvním a druhým pokusem';
$string['delay2'] = 'Prodleva 2';
$string['delay2_help'] = 'Minimální prodleva po druhém pokusu.';
$string['delay2summary'] = 'Časová prodleva po dalších pokusech';
$string['delay3'] = 'Prodleva 3';
$string['delay3_help'] = 'Toto nastavení určuje zpoždění mezi dokončením činnosti a návratem do běžného prostředí kurzu.

<b>Zadejte určený čas (ve vteřinách)</b>
<p>Návrat do běžného prostředí kurzu nastane po uplynutí zadaného času.</p>
<b>Použijte nastavení ve zdrojovém/vzorovém souboru</b>
<p>Návrat do prostředí kurzu nastane po uplynutí času specifikovaném ve zdrojovém souboru nebo v šablonách pro tento výstupní formát.</p>
<b>Čeká do stisknutí tlačítka OK</b>
<p>Návrat do prostředí kurzu nastane po stisknutí tlačítka OK (na zprávě o plnění konkrétní činnosti).</p>
<b>Nepokračuje automaticky</b>
<p>Po skončení činnosti nenastane návrat do běžného prostředí kurzu. Student bude mít možnost využít navigační tlačítka od stránky skončené činnosti.</p>

Výsledky činnosti jsou odeslány do kurzu vždy po skončení testu bez ohledu na tato nastavení.';
$string['delay3afterok'] = 'Čeká do stisknutí tlačítka OK';
$string['delay3disable'] = 'Nepokračuje automaticky';
$string['delay3specific'] = 'Zadejte určený čas (ve vteřinách)';
$string['delay3summary'] = 'Zbývající čas do konce testu';
$string['delay3template'] = 'Použijte nastavení ve zdrojovém/vzorovém souboru';
$string['deleteallattempts'] = 'Vymazat všechny pokusy';
$string['deleteattempts'] = 'Vymazat pokusy';
$string['detailsrecords'] = 'Detaily HotPot záznamů';
$string['duration'] = 'Trvání';
$string['enablecache'] = 'Povolit mezipaměť HotPot';
$string['enablecron'] = 'Povolit cron HotPot';
$string['enablemymoodle'] = 'Zobrazit HotPots na Nástěnce';
$string['enableobfuscate'] = 'Povolit mlžení textových a multimediálních přehrávačů';
$string['enableswf'] = 'Povolit vkládání SWF souborů v HotPot činnostech';
$string['entry_attempts'] = 'Pokusy';
$string['entry_dates'] = 'Data';
$string['entry_grading'] = 'Hodnocení';
$string['entry_title'] = 'Jméno jednotky jako titulek';
$string['entrycm'] = 'Předchozí aktivity';
$string['entrycm_help'] = 'Toto nastavení specifikuje předchozí aktivity a jejich minimální ohodnocení, kterých musí být dosaženo, než bude studentovi umožněn průchod touto HotPot činností.

Vyučující si může zvolit konkrétní činnost, nebo si vybrat jednu z obecných přednastavených možností:

* Předchozí aktivity v tomto kurzu
* Předchozí aktivity v této sekci kurzu
* Předchozí HotPot v tomto kurzu
* Předchozí HotPot v této sekci kurzu';
$string['entrycmcourse'] = 'Předchozí aktivity v tomto kurzu';
$string['entrycmsection'] = 'Předchozí aktivity v této sekci kurzu';
$string['entrycompletionwarning'] = 'Před zahájením této aktivity se musíte podívat na {$a}.';
$string['entrygrade'] = 'Hodnocení předchozích aktivit';
$string['entrygradewarning'] = 'Nemůžete začít tuto aktivitu, dokud nedosáhnete skóre {$a->entrygrade} % za aktivitu {$a->entryactivity}. Momentálně je vaše skóre {$a->usergrade} %.';
$string['entryhotpotcourse'] = 'Předchozí HotPot v tomto kurzu';
$string['entryhotpotsection'] = 'Předchozí HotPot v této sekci kurzu';
$string['entryoptions'] = 'Volby vstupní stránky';
$string['entryoptions_help'] = 'Tato zaškrtávací políčka ovlivňují, jaké položky budou zobrazeny na vstupní stránce.

<b>Nadpis</b><br>
Pokud je vybrána tato volba, bude název činnosti stejný jako název vstupní stránky.

<b>Hodnocení</b><br>
Pokud je vybrána tato volba, bude na vstupní stránce zobrazeno hodnocení.

<b>Data</b><br>
Pokud je vybrána tato volba, budou na vstupní stránce zobrazeny informace o datech otevření a uzavření pokusů.

<b>Pokusy</b><br>
Pokud je vybrána tato volba, bude na vstupní stránce zobrazena tabulka s informacemi o pokusech HotPot činnosti jednotlivých uživatelů. U pokusů, které mohou být obnoveny, bude v pravém sloupci umístěno tlačítko Pokračovat.';
$string['entrypage'] = 'Zobrazit vstupní stránku';
$string['entrypage_help'] = 'Má se studentům zobrazit vstupní stránka před zahájením činnosti HotPot?

<b>Ano</b><br>
Studentům bude zobrazena vstupní stránka před zahájením činnosti HotPot. Podoba obsahu vstupní stránky je limitována nastavením ""Voleb vstupní stránky"".

<b>Ne</b><br>
Studentům se zobrazí pouze činnost Hotpot bez vstupní stránky.

Vstupní stránka je vždy zobrazena vyučujícímu kvůli možnosti prohlížení údajů o činnosti a editování stránky činnosti.';
$string['entrypagehdr'] = 'Vstupní stránka';
$string['entrytext'] = 'Text vstupní stránky';
$string['event_attempt_reviewed'] = 'Pokus Hotpot byl zobrazen';
$string['event_attempt_reviewed_description'] = 'Uživatel s id "{$a->userid}" zobrazil pokus v "HotPot" činnosti kurzu v modulu id "{$a->cmid}"';
$string['event_attempt_reviewed_explanation'] = 'Uživatel právě prohlíží pokus v HotPot modulu';
$string['event_attempt_started'] = 'Pokus HotPot zahájen';
$string['event_attempt_started_description'] = 'Uživatel s id "{$a->userid}" zahájil pokus v "HotPot" činnosti kurzu v modulu id "{$a->cmid}"';
$string['event_attempt_started_explanation'] = 'Uživatel právě zahájil pokus v HotPot modulu';
$string['event_attempt_submitted'] = 'Pokus HotPot odeslán';
$string['event_attempt_submitted_description'] = 'Uživatel s id "{$a->userid}" odeslal pokus v "HotPot" činnosti kurzu v modulu id "{$a->cmid}"';
$string['event_attempt_submitted_explanation'] = 'Uživatel právě odeslal pokus v HotPot modulu';
$string['event_base'] = 'Zjištěna HotPot událost';
$string['event_base_description'] = 'Uživatel s id "{$a->userid}" zahájil událost v "HotPot" činnosti kurzu v modulu id "{$a->cmid}"';
$string['event_base_explanation'] = 'Událost byla zjištěna modulem HotPot';
$string['event_report_viewed'] = 'Zobrazena sestava HotPot';
$string['event_report_viewed_description'] = 'Uživatel s id "{$a->userid}" zobrazil sestavu o pokusech v "HotPot" činnosti kurzu v modulu id "{$a->cmid}"';
$string['event_report_viewed_explanation'] = 'Uživatel právě zobrazil sestavu o pokusech v HotPot činnosti';
$string['exit_areyouok'] = 'Ahoj, jste tam ještě?';
$string['exit_attemptscore'] = 'Vaše skóre v tomto pokusu bylo  {$a}';
$string['exit_course'] = 'Kurz';
$string['exit_course_text'] = 'Návrat na hlavní stránku kurzu';
$string['exit_encouragement'] = 'Zpětná vazba';
$string['exit_excellent'] = 'Výborně!';
$string['exit_feedback'] = 'Podoba výstupní stránky';
$string['exit_feedback_help'] = 'Tato nastavení povolují nebo zakazují zobrazování zpětné vazby z absolvované činnosti HotPot na výstupní straně.

<b>Nadpis</b><br>
Pokud je vybrána tato volba, zobrazí se na výstupní stránce název činnosti.

<b>Zpětná vazba</b><br>
Pokud je vybrána tato volba, bude na výstupní straně zobrazena zpětná vazba. Zpětná vazba závisí na stupni hodnocení: <br>
<b>> 90 %:</b> Výborně!<br>
<b>> 60 %:</b> Dobře!<br>
<b>> 0 %:</b> Ještě ujde.<br>
<b>= 0 %:</b> Vše v pořádku?<br>

<b>Vaše skóre v tomto pokusu bylo</b><br>
Pokud je vybrána tato volba, bude hodnocení dokončeného pokusu zobrazeno na výstupní stránce.

<b>Vaše hodnocení pro tuto aktivitu je</b><br>
Pokud je vybrána tato volba, na výstupní stránce bude zobrazeno hodnocení HotPot činnosti.';
$string['exit_goodtry'] = 'Ještě ujde.';
$string['exit_grades'] = 'Hodnocení';
$string['exit_grades_text'] = 'Prohlédněte si dosavadní hodnocení v kurzu';
$string['exit_hotpotgrade'] = 'Vaše hodnocení pro tuto aktivitu je {$a}';
$string['exit_hotpotgrade_average'] = 'Vaše průměrné hodnocení pro tuto aktivitu je zatím {$a}';
$string['exit_hotpotgrade_highest'] = 'Vaše nejvyšší  hodnocení pro tuto aktivitu je zatím {$a}';
$string['exit_hotpotgrade_highest_equal'] = 'Vyrovnal jste nejlepší výkon této aktivity!';
$string['exit_hotpotgrade_highest_previous'] = 'Vaše nejvyšší předchozí hodnocení pro tuto aktivitu bylo {$a}';
$string['exit_hotpotgrade_highest_zero'] = 'Zatím jset nezískal vyšší skóre než {$a} v této aktivitě';
$string['exit_index'] = 'Index';
$string['exit_index_text'] = 'Přejít na seznam aktivit';
$string['exit_links'] = 'Odkaz na poslední stránku';
$string['exit_links_help'] = 'Toto nastavení povoluje nebo zakazuje zobrazení určitých navigačních odkazů na výstupní stránce.

<b>Opakovat</b><br>
pokud je povoleno absolvovat v rámci této činnosti více pokusů a student ještě nemá vyčerpány všechny pokusy, zobrazí se mu možnost opakovat činnost Hotpot.

<b>Index</b><br>
pokud je vybrána tato možnost, zobrazí se odkaz na seznam aktivit.

<b>Kurz</b><br>
pokud je vybrána tato možnost, zobrazí se odkaz na hlavní stránku kurzu.

<b>Hodnocení</b><br>
pokud je vybrána tato možnost, zobrazí se odkaz na stránku s dosavadní hodnocením v kurzu.';
$string['exit_next'] = 'Další';
$string['exit_next_text'] = 'Zkusit další činnost';
$string['exit_noscore'] = 'Úspěšně jste dokončil tuto činnost!';
$string['exit_retry'] = 'Opakovat';
$string['exit_retry_text'] = 'Opakovat tuto aktivitu';
$string['exit_welldone'] = 'Dobře!';
$string['exit_whatnext_0'] = 'Jak chcete pokračovat?';
$string['exit_whatnext_1'] = 'Vyberte si svůj osud ...';
$string['exit_whatnext_default'] = 'Vyberte si prosím z následujícího:';
$string['exitcm'] = 'Další aktivita';
$string['exitcm_help'] = 'Toto nastavení specifikuje aktivitu v kurzu, která má nastat po dokončení činnosti HotPot. Volitelná známka je minimální známka za tuto HotPot činnost, která je nutná pro zobrazení další činnosti.

Vyučující si může zvolit konkrétní činnost, nebo si vybrat jednu z obecných přednastavených možností:

* Další aktivita v tomto kurzu
* Další aktivita v této sekci kurzu
* Další HotPot v kurzu
* Další HotPot v tématu kurzu

Pokud je Další aktivita nastavena na "Žádná" a student dosáhl požadované známky pro tuto HotPot činnost, zobrazí se další činnost ihned. V opačném případě se studentům zobrazí odkaz na další činnost. Na tuto pak mohou přejít, když jsou připraveni.';
$string['exitcmcourse'] = 'Další aktivita v tomto kurzu';
$string['exitcmsection'] = 'Další aktivita v této sekci kurzu';
$string['exitgrade'] = 'Hodnocení následující aktivity';
$string['exithotpotcourse'] = 'Další HotPot v kurzu';
$string['exithotpotsection'] = 'Další HotPot v tématu kurzu';
$string['exitoptions'] = 'Volby výstupní stránky';
$string['exitpage'] = 'Zobrazit výstupní stránku';
$string['exitpage_help'] = 'Chcete, aby byla zobrazena výstupní stránka po dokončení činnosti?

<b>Ano</b><br>
Studentům bude zobrazena výstupní stránka po dokončení činnosti HotPot. Podoba obsahu výstupní stránky je ovlivněna nastavením ""Podoba výstupní stránky"" a různými přídatnými odkazy.

<b>Ne</b><br>
Výstupní stránka nebude studentům zobrazena. Místo ní studenti buď přejdou na následující činnost, nebo se vrátí na hlavní stránku kurzu.';
$string['exitpagehdr'] = 'Výstupní stránka';
$string['exittext'] = 'Text výstupní stránky';
$string['feedbackdiscuss'] = 'Diskutujte o tomto test ve fóru';
$string['feedbackformmail'] = 'Formulář';
$string['feedbackmoodleforum'] = 'Příspěvek ve fóru';
$string['feedbackmoodlemessaging'] = 'Soukromá zpráva';
$string['feedbacknone'] = 'Žádná';
$string['feedbacksendmessage'] = 'Pošlete zprávu vašemu instruktorovi';
$string['feedbackwebpage'] = 'Webová stránka';
$string['firstattempt'] = 'První pokus';
$string['forceplugins'] = 'Vnutit multimediální pluginy';
$string['forceplugins_help'] = 'Pokud je povoleno, bude Moodle-kompatibilní přehrávač médií přehrávat soubory, jako AVI, MPEG, MPG, MP3, MOV a WMV. V opačném případě Moodle v testu nezmění nastavení veškerých multimediálních přehrávačů.';
$string['frameheight'] = 'Výška rámu';
$string['giveup'] = 'Vzdávám to';
$string['grademethod'] = 'Metoda hodnocení';
$string['grademethod_help'] = 'Toto nastavení určuje, z jakých pokusů činnosti HotPot bude vypočtena výsledná známka.

<b>Nejvyšší skóre</b><br>
Bude vybrána nejvyšší známka z absolvovaných pokusů.

<b>Průměr skóre</b><br>
Z hodnocení všech absolvovaných pokusů bude vypočteno průměrné hodnocení.

<b>První pokus</b><br>
Známka bude nastavena podle hodnocení z prvního absolvovaného pokusu.

<b>Poslední pokus</b><br>
Známka bude nastavena podle hodnocení z posledního absolvovaného pokusu.';
$string['gradeweighting'] = 'Váha hodnocení';
$string['gradeweighting_help'] = 'Známky této HotPot činnosti budou zmenšeny ve známkách kurzu podle zvoleného procentuálního poměru.

Př.:
- <b>100</b>: do hodnocení bude započítáno 100 % ze získané známky
- <b>50</b>: do hodnocení bude započítána polovina ze získané známky

Je-li zvolena možnost <b>Bez známky</b>, nebude hodnocení získané v této HotPot činnosti zařazeno do celkového hodnocení kurzu.';
$string['highestscore'] = 'Nejvyšší skóre';
$string['hints'] = 'Hints (Nápovědy)';
$string['hotpot:addinstance'] = 'Přidat novou činnost HotPot';
$string['hotpot:attempt'] = 'Pokusit se o zvládnutí testu';
$string['hotpot:deleteallattempts'] = 'Odstranit pokusy některých uživatelů v HotPot činnosti';
$string['hotpot:deletemyattempts'] = 'Odstranit své vlastní pokusy v činnosti HotPot';
$string['hotpot:ignoretimelimits'] = 'Ignoruje časová omezení v rámci činnosti HotPot';
$string['hotpot:manage'] = 'Změnit nastavení činnosti HotPot';
$string['hotpot:preview'] = 'Náhled činnosti HotPot';
$string['hotpot:reviewallattempts'] = 'Zobrazit pokusy libovolného uživatele v činnosti HotPot';
$string['hotpot:reviewmyattempts'] = 'Zobrazit vlastní pokusy v činnosti HotPot';
$string['hotpot:view'] = 'Používat test';
$string['hotpotname'] = 'Jméno činnosti HotPot';
$string['ignored'] = 'Nevybráno';
$string['inprogress'] = 'probíhá';
$string['isgreaterthan'] = 'větší než';
$string['islessthan'] = 'menší než';
$string['lastaccess'] = 'Poslední přístup';
$string['lastattempt'] = 'Poslední pokus';
$string['lockframe'] = 'Zamknout rámec okna';
$string['maxeventlength'] = 'Maximální počet dní pro jednu kalendářní událost';
$string['mediafilter_hotpot'] = 'Multimediální filtr HotPot';
$string['mediafilter_moodle'] = 'Standardní multimediální filtr Moodle';
$string['migratingfiles'] = 'Migrace souborů testu Hot Potatoes';
$string['migratinglogs'] = 'Migrace protokolů Hot Potatoes';
$string['missingsourcetype'] = 'HotPot záznamu chybí typ zdrojového souboru';
$string['modulename'] = 'HotPot';
$string['modulename_help'] = 'Modul HotPot umožňuje vyučujícím nahrát interaktivní výukový materiál vytvořený v programech HotPot a zobrazit výsledky a reakce uživatelů v těchto cvičeních.

Modul Hotpot se skládá z volitelné vstupní stránky, HotPot cvičení a volitelné výstupní stránky. E-learningové cvičení může mít podobu statické webové stránky nebo interaktivní webové stránky s audiovizuálními prvky. E-learningové cvičení je vytvořeno na samostatném softwaru vyučujícího a nahráno do Moodlu.

Modul HotPot umí pracovat se cvičeními vytvořenými s tímto softwarem:

* Hot Potatoes (verze 6)
* Qedoc
* Xerte
* iSpring
* jakýkoliv HTML editor';
$string['modulenameplural'] = 'Testy Hot Potatoes';
$string['nameadd'] = 'Jméno';
$string['nameadd_help'] = 'Název může být konkrétní text zadaný uživatelem, nebo může být automaticky generovaný podle zvolených parametrů.

<b>Získat ze zdrojového souboru</b><br>
Název bude získaný ze zdrojového souboru.

<b>Použít jméno souboru</b><br>
Název bude totožný s názvem souboru.

<b>Použít cestu souboru</b><br>
Cesta k souboru bude použita jako název. Jsou-li v cestě uvedena lomítka, budou nahrazena mezerami.

<b>Zadat nyní</b><br>
Jako jméno bude sloužit konkrétní text zadaný uživatelem.';
$string['nameedit'] = 'Jméno';
$string['nameedit_help'] = 'Konkrétní text, který bude zobrazen studentům';
$string['navigation'] = 'Navigace';
$string['navigation_embed'] = 'Vložená stránka';
$string['navigation_frame'] = 'Navigační rám (frame) Moodlu';
$string['navigation_give_up'] = 'Pouze tlačítko &quot;Vzdávám to&quot;';
$string['navigation_help'] = 'Toto nastavení specifikuje navigaci používanou v činnosti HotPot.

<b>Standardní navigace Moodle (hlavička a blok navigace)</b><br>
Navigační lišta je zobrazena v horní části stránky ve stejném okně jako činnost HotPot.

<b>Zobrazení hlavičky Moodle (bez bloku navigace)</b><br>
Navigační lišta se zobrazí v samostatném rámečku v horní části kvízu.

<b>Navigační rám (frame) Moodlu</b><br>
Navigační lišta se zobrazí v činnosti HotPot jako samostatně vložený rám v rámci aktuálního okna. Velikost tohoto rámu lze upravovat posuvnou lištou.

<b>Vložená stránka</b><br>
Navigační lišta bude zobrazena v kvízu vloženém na stránku.

<b>Původní navigace HotPot</b><br>
V činnost budou zobrazena další navigační tlačítka (sloužící např. pro pohyb mimo kurz, popř. k nasměrování k jiným činnostem) v horní části stránky. Tato tlačítka musí být definována již při tvorbě HotPot činnosti.

<b>Žádná</b><br>
Činnost se zobrazí bez navigačních tlačítek. Po správném zodpovězení všech otázek se v závislosti na nastavení ""Zobrazit další kvíz"" bude buď pokračovat další HotPot činností nebo se student automaticky vrátí na hlavní stránku.';
$string['navigation_moodle'] = 'Standardní navigace Moodle (hlavička a blok navigace)';
$string['navigation_none'] = 'Žádná';
$string['navigation_original'] = 'Původní navigace HotPot';
$string['navigation_topbar'] = 'Zobrazení hlavičky Moodle (bez bloku navigace)';
$string['noactivity'] = 'Žádná činnost';
$string['nohotpots'] = 'Nenalezena HotPot';
$string['nomoreattempts'] = 'Bohužel, v této aktivitě nemáte žádné zbývající pokusy';
$string['noresponses'] = 'Nebyly nalezeny žádné informace o individuálních otázkách a odpovědích.';
$string['noreview'] = 'Bohužel, nemáte povoleno zobrazit si detaily pokusů testu.';
$string['noreviewafterclose'] = 'Bohužel, tento test je uzavřen. Nemůžete si již prohlédnout detaily pokusů tohoto testu.';
$string['noreviewbeforeclose'] = 'Bohužel, nemáte povoleno zobrazit si detaily pokusů testu před {$a}';
$string['nosourcefilesettings'] = 'HotPot záznamu chybí informace o zdrojovém souboru';
$string['notattemptedyet'] = 'Dosud bez pokusů';
$string['notavailable'] = 'Bohužel, tato aktivita není pro vás dostupná.';
$string['outputformat'] = 'Výstupní formát';
$string['outputformat_best'] = 'nejvhodnější';
$string['outputformat_help'] = 'Výstupní formát určuje, jak bude obsah zobrazen studentům.

Výstupní formáty, které jsou k dispozici, závisí na zdrojovém souboru. Některé typy zdrojových souborů mají pouze jeden výstupní formát, jiné je možno zobrazit ve více výstupních formátech.

Po výběru volby "nejvhodnější" se zobrazí ideální formát pro prohlížeč, který je studentem právě používán.';
$string['outputformat_hp_6_jcloze_html'] = 'JCloze (v6) z html';
$string['outputformat_hp_6_jcloze_html_findit_a'] = 'FindIt (a) z html';
$string['outputformat_hp_6_jcloze_html_findit_b'] = 'FindIt (b) z html';
$string['outputformat_hp_6_jcloze_xml_anctscan'] = 'ANCT-Scan z HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_dropdown'] = 'DropDown z HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_a'] = 'FindIt (a) z HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_b'] = 'FindIt (b) z HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_jgloss'] = 'JGloss z HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_v6'] = 'JCloze (v6) z HP6 xml';
$string['outputformat_hp_6_jcloze_xml_v6_autoadvance'] = 'JCloze (v6) z HP6 xml (Auto-advance)';
$string['outputformat_hp_6_jcross_html'] = 'JCross (v6) z html';
$string['outputformat_hp_6_jcross_xml_v6'] = 'JCross (v6) z xml';
$string['outputformat_hp_6_jmatch_html'] = 'JMatch (v6) z html';
$string['outputformat_hp_6_jmatch_html_sort'] = 'JMatch Sort z html';
$string['outputformat_hp_6_jmatch_xml_flashcard'] = 'JMatch (flashcard) z xml';
$string['outputformat_hp_6_jmatch_xml_jmemori'] = 'JMemori z xml';
$string['outputformat_hp_6_jmatch_xml_sort'] = 'JMatch Sort z xml';
$string['outputformat_hp_6_jmatch_xml_v6'] = 'JMatch (v6) z xml';
$string['outputformat_hp_6_jmatch_xml_v6_plus'] = 'JMatch (v6+) z xml';
$string['outputformat_hp_6_jmix_html'] = 'JMix (v6) z html';
$string['outputformat_hp_6_jmix_xml_v6'] = 'JMix (v6) z xml';
$string['outputformat_hp_6_jmix_xml_v6_plus'] = 'JMix (v6+) z xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_deluxe'] = 'JMix (v6+ with prefix, suffix s oddělovači) z xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_keypress'] = 'JMix (v6+ with key press) z xml';
$string['outputformat_hp_6_jquiz_html'] = 'JQuiz (v6) z html';
$string['outputformat_hp_6_jquiz_xml_v6'] = 'JQuiz (v6) z xml';
$string['outputformat_hp_6_jquiz_xml_v6_autoadvance'] = 'Quiz (v6) z xml (Auto-advance)';
$string['outputformat_hp_6_jquiz_xml_v6_exam'] = 'JQuiz (v6) z xml (Exam)';
$string['outputformat_hp_6_rhubarb_html'] = 'Rhubarb (v6) z html';
$string['outputformat_hp_6_rhubarb_xml'] = 'Rhubarb (v6) z xml';
$string['outputformat_hp_6_sequitur_html'] = 'Sequitur (v6) z html';
$string['outputformat_hp_6_sequitur_html_incremental'] = 'Sequitur (v6) z html, incremental scoring';
$string['outputformat_hp_6_sequitur_xml'] = 'Sequitur (v6) z xml';
$string['outputformat_hp_6_sequitur_xml_incremental'] = 'Sequitur (v6) z xml, incremental scoring';
$string['outputformat_html_ispring'] = 'iSpring HTML soubor';
$string['outputformat_html_xerte'] = 'Xerte HTML soubor';
$string['outputformat_html_xhtml'] = 'Standardní HTML soubor';
$string['outputformat_qedoc'] = 'Soubor Qedoc';
$string['overviewreport'] = 'Náhled';
$string['penalties'] = 'Penalizace';
$string['percent'] = 'Procent';
$string['pluginadministration'] = 'Administrace HotPot';
$string['pluginname'] = 'Test Hot Potatoes';
$string['pressoktocontinue'] = 'Pro pokračování stiskněte OK nebo stiskněte Zrušit, když chcete zůstat na aktuální stránce';
$string['questionshort'] = 'Ot. {$a}';
$string['quizname_help'] = 'text nápovědy pro název testu';
$string['quizzes'] = 'Testy';
$string['responses'] = 'Odpovědi';
$string['responsesreport'] = 'Odpovědi';
$string['reviewafterattempt'] = 'Povolit prohlížení po skončení pokusu';
$string['reviewafterclose'] = 'Povolit prohlížení po uzavření činnosti HotPot';
$string['reviewduringattempt'] = 'Povolit prohlížení během pokusu';
$string['reviewoptions'] = 'Možnosti prohlídky';
$string['score'] = 'Skóre';
$string['scoresreport'] = 'Skóre';
$string['selectattempts'] = 'Vybrat pokusy';
$string['showerrormessage'] = 'Chyba HotPot: {$a}';
$string['sourcefile'] = 'Zdrojový  soubor';
$string['sourcefile_help'] = 'Toto nastavení určuje soubor, jehož obsah se zobrazí studentům.

Zpravidla je zdrojový soubor vytvořen mimo Moodle a až po té je do Moodlu nahrán. Tímto zdrojovým souborem může být html soubor nebo jiný typ souboru vytvořený v autorizovaném softwaru, jako je Hotpot nebo Qedoc.

Zdrojový soubor může být zadán pomocí určení cesty ke konkrétnímu souboru, nebo je zadán jako URL adresa začínající http: // nebo https: //

Pro činnosti Qedoc musí být zadána URL adresa zdrojového souboru vedoucí ke Qedoc modulu, který byl nahrán na server Qedoc.

<ul><li>Více informací o nahrávání modulů Qedoc naleznete na:
<a href="http://www.qedoc.org/index.php?title=Uploading_modules">http://www.qedoc.org/Uploading_modules</a></ul>';
$string['sourcefilenotfound'] = 'Zdrojový soubor nenalezen (nebo prázdný): {$a}';
$string['status'] = 'Stav';
$string['stopbutton'] = 'Zobrazit tlačítko stop';
$string['stopbutton_help'] = 'Pokud je povoleno, bude do činnosti HotPot vloženo tlačítko pro ukončení činnosti (stop tlačítko).

V okamžiku, kdy student klikne na toto tlačítko, budou dosavadní výsledky uloženy a stav pokusu činnosti bude změněn na "Nedokončeno".

Text, který je zobrazen na tlačítku, může být předdefinovaný ("Vzdej to"), nebo může vyučující pro tlačítko napsat vlastní text.';
$string['stopbutton_langpack'] = 'Z jazykového balíčku';
$string['stopbutton_specific'] = 'Použijte konkrétní text';
$string['stoptext'] = 'Text tlačítka Stop';
$string['storedetails'] = 'Uložit detailní XML HotPot pokusů testu';
$string['studentfeedback'] = 'Zpětná vazba od studentů';
$string['studentfeedback_help'] = 'Pokud je toto nastavení povoleno, zobrazí se odkaz na vyskakovací okno se zpětnou vazbou vždy, když student klikne na tlačítko pro kontrolu (toto tlačítko se může měnit v závislosti na konkrétní činnosti).

Okno se zpětnou vazbou umožňuje studentům, aby o této HotPot činnosti diskutovali s vyučujícím a dalšími spolužáky, a to pomocí jedné z následujících forem:<br>

<b>Webová stránka</b>
<p>Vyžaduje URL adresu webové stránky.</p>
<b>Formulář</b>
<p>Vyžaduje URL adresu formuláře.</p>
<b>Příspěvek ve fóru</b>
<p>Zobrazí se odkaz na fórum kurzu.</p>
<b>Soukromá zpráva</b>
<p>Zobrazí se okno sloužící k napsání zprávy v kurzu. Pokud má kurz více učitelů, bude student vyzván k výběru konkrétního učitele. </p>';
$string['submits'] = 'Odpovědi';
$string['subplugintype_hotpotattempt'] = 'Výstupní formát';
$string['subplugintype_hotpotattempt_plural'] = 'Výstupní formáty';
$string['subplugintype_hotpotreport'] = 'Sestava';
$string['subplugintype_hotpotreport_plural'] = 'Sestavy';
$string['subplugintype_hotpotsource'] = 'Zdrojový soubor';
$string['subplugintype_hotpotsource_plural'] = 'Zdrojové soubory';
$string['textsourcefile'] = 'Získat ze zdrojového souboru';
$string['textsourcefilename'] = 'Použít jméno souboru';
$string['textsourcefilepath'] = 'Použít cestu k souboru';
$string['textsourcequiz'] = 'Převzít z testu';
$string['textsourcespecific'] = 'Zadat nyní';
$string['timeclose'] = 'Dostupné do';
$string['timedout'] = 'vypršel čas';
$string['timelimit'] = 'Limit času';
$string['timelimit_help'] = 'Toto nastavení určuje maximální dobu trvání jednoho pokusu.

<b>Použijte nastavení ze zdrojového/pracovního souboru</b><br>
Časový limit bude převzat ze zdrojového souboru.

<b>Použijte zadaný čas</b><br>
Vámi stanovený časový limit nastavený zde bude použit pro pokus této HotPot činnosti. Toto nastavení přepíše případné nastavení ve zdrojovém souboru.

<b>Zakázat</b><br>
Pro pokus této HotPot činnosti nebude stanoven žádný časový limit.


Poznámka: v případě obnovení pokusu, bude časovač pokračovat od limitu, v kterém byl původní pokus zastaven.';
$string['timelimitexpired'] = 'Čas pro tento pokus vypršel';
$string['timelimitspecific'] = 'Použijte zadaný čas';
$string['timelimitsummary'] = 'Limit pro jeden pokus';
$string['timelimittemplate'] = 'Použijte nastavení ze zdrojového/pracovního souboru';
$string['timeopen'] = 'Dostupné od';
$string['timeopenclose'] = 'Doby otevření a uzavření testu';
$string['timeopenclose_help'] = 'Umožňuje určit dobu, ve které je činnost přístupná.
Mimo nastavený rozsah je činnost studentům nedostupná.';
$string['title'] = 'Nadpis';
$string['title_help'] = 'Toto nastavení určuje, jaký nadpis se zobrazí na stránce.

<b>Jméno činnosti HotPot<b>
<p>Jméno této činnosti bude použito jako nadpis.</p>

<b>Získat ze zdrojového souboru</b>
<p>Jako nadpis stránky bude použit název definovaný ve zdrojovém souboru.</p>

<b>Použít jméno souboru</b>
<p>Název zdrojového souboru bude použit jako nadpis stránky.</p>

<b>Použít cestu k souboru</b>
<p>Jako nadpis stránky bude použita cesta k danému souboru, a to včetně názvů složek uvedených v cestě.</p>';
$string['toolsindex'] = 'Index HotPot nástrojů';
$string['unitname_help'] = 'text nápovědy pro název jednotky';
$string['unrecognizedsourcefile'] = 'Lituji, HotPot modul nemohl rozpoznat typ zdrojového souboru: {$a}';
$string['updated'] = 'Aktualizováno';
$string['updatinggrades'] = 'Aktualizování známek Hotpot';
$string['usefilters'] = 'Použití filtrů';
$string['usefilters_help'] = 'Pokud je povoleno toto nastavení, budou na obsah ještě před odesláním do prohlížeče aplikovány filtry Moodlu.';
$string['useglossary'] = 'Použití slovníku';
$string['useglossary_help'] = 'Pokud je povoleno, bude na obsah aplikováno automatické propojování slovníku ještě před odesláním do prohlížeče.

<b>Pozor!</b><br>
Toto nastavení potlačí původní nastavení stránky povolující nebo zakazující filtr Automatické propojování slovníku.';
$string['usemediafilter'] = 'Použití filtrů pro media';
$string['usemediafilter_help'] = 'Toto nastavení specifikuje mediální filtr, který bude použit.

<b>Žádný</b><br>
Na obsah nebude aplikován žádný filtr.

<b>Standardní multimediální filtr Moodle</b><br>
Na obsah bude aplikován standardní multimediální filtr Moodle. Tento filtr hledá v obsahu odkazy na běžné zvukové a filmové soubory a převádí tyto odkazy na vhodné mediální přehrávače spustitelné přímo na stránce kurzu.

<b>Multimediální filtr HotPot</b><br>
Na obsah budou aplikovány filtry detekující odkazy, obrázky, zvuky a filmy, které jsou ohraničeny hranatou závorkou.

Zápis v hranaté závorce má následující podobu:

<div style=""margin-left: 40px""><code>[url přehrávač šířka výška volby]</code></div>

<b>url</b><br>
Relativní nebo absolutní adresa k mediálnímu souboru


<b>přehrávač (volitelné)</b><br>
Jméno přehrávače, který má být vložen. Jako výchozí je nastavena hodnota ""moodle"". Standardní modul HotPot nabízí rovněž tyto přehrávače:

<div style=""margin-left: 40px;"">


<b>dew</b>: mp3 přehrávač<br>

<b>dyer</b>: mp3 přehrávač od Bernarda Dyera<br>

<b>hbs</b>: mp3 přehrávač od Half-Baked Software<br>

<b>image</b>: vkládání obrázku na webovou stránku<br>

<b>link</b>: vkládání odkazu na jinou webovou stránku<br>
</div>

<b>šířka (volitelné)</b><br>
požadovaná šířka přehrávače

<b>výška (volitelné)</b><br>
požadovaná výška přehrávače. Pokud je tato hodnota vynechána, bude automaticky nastavena na stejnou hodnotu jako výška.

<b>volby (volitelné)</b><br>
Volby přehrávače oddělené čárkou. Každá volba může být ve stavu on/off , nebo může být zadána dvojicí název, hodnota.

**jméno=hodnota<br>
**jméno="nějaká hodnota s mezerami"';
$string['viewreports'] = 'Zobrazit sestavy pro {$a} uživatelů';
$string['views'] = 'Zobrazení';
$string['weighting'] = 'Váhy';
$string['wrong'] = 'Nesprávně';
$string['zeroduration'] = 'Bez doby trvání';
$string['zeroscore'] = 'Nulové skóre';
