<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'cs', version '3.8'.
 *
 * @package     feedback
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Přidat otázku';
$string['add_pagebreak'] = 'Vložit zalomení stránky';
$string['adjustment'] = 'Rozmístění';
$string['after_submit'] = 'Zobrazit po odevzdání dotazníku';
$string['allowfullanonymous'] = 'Umožnit úplnou anonymitu';
$string['analysis'] = 'Analýza';
$string['anonymous'] = 'Anonymní';
$string['anonymous_edit'] = 'Zaznamenat jména uživatelů';
$string['anonymous_entries'] = 'Anonymní záznamy ({$a})';
$string['anonymous_user'] = 'Anonymní uživatel';
$string['answerquestions'] = 'Odpovězte na otázky';
$string['append_new_items'] = 'Přidat nové položky';
$string['autonumbering'] = 'Automaticky číslovat každou otázku';
$string['autonumbering_help'] = 'Povolit nebo nepovolit automatické číslování otázek';
$string['average'] = 'Průměr';
$string['bold'] = 'Tučně';
$string['calendarend'] = '{$a} - uzavřeno';
$string['calendarstart'] = '{$a} - otevřeno';
$string['cannotaccess'] = 'V kurzu můžete přistupovat pouze do tohoto dotazníku';
$string['cannotsavetempl'] = 'Ukládání šablon není povoleno';
$string['captcha'] = 'Captcha';
$string['captchanotset'] = 'Captcha nebyla nastavena.';
$string['check'] = 'Více možností - více odpovědí';
$string['check_values'] = 'Možné odpovědi';
$string['checkbox'] = 'Více možností - více možných odpovědí (zaškrtávací políčko)';
$string['choosefile'] = 'Vyberte soubor';
$string['chosen_feedback_response'] = 'Zvolená odpověď';
$string['closebeforeopen'] = 'Zadali jste datum ukončení před datem zahájení.';
$string['complete_the_form'] = 'Odpovězte na otázky';
$string['completed'] = 'Hotovo';
$string['completed_feedbacks'] = 'Odevzdané odpovědi';
$string['completedon'] = 'Dokončeno {$a}';
$string['completionsubmit'] = 'Zobrazit jako dokončené, je-li dotazník odeslán';
$string['configallowfullanonymous'] = 'Je-li zvolena volba "Ano", může být dotazník vyplněni bez přihlášení. Tato možnost platí pro dotazník na hlavní stránce.';
$string['confirmdeleteentry'] = 'Opravdu odstranit tento záznam?';
$string['confirmdeleteitem'] = 'Opravdu odstranit tuto položku?';
$string['confirmdeletetemplate'] = 'Opravdu odstranit tuto šablonu?';
$string['confirmusetemplate'] = 'Opravdu použít tuto šablonu?';
$string['continue_the_form'] = 'Pokračovat v zodpovídání otázek';
$string['count_of_nums'] = 'Počet čísel';
$string['courseid'] = 'ID kurzu';
$string['creating_templates'] = 'Uložit tyto otázky jako novou šablonu';
$string['delete_entry'] = 'Odstranit záznam';
$string['delete_item'] = 'Odstranit otázku';
$string['delete_old_items'] = 'Odstranit staré položky';
$string['delete_pagebreak'] = 'Odstranit konec stránky';
$string['delete_template'] = 'Smazat šablonu';
$string['delete_templates'] = 'Smazat šablonu...';
$string['depending'] = 'Závislé položky';
$string['depending_help'] = 'Tato funkce umožňuje zobrazovat položky v závislosti na vyplněných hodnotách jiných položek dotazníku..<br />
<strong>Příklad</strong><br />
<ul>
<li>Nejprve vytvořte položku, na jejíž hodnotě budou záviset jiné položky</li>
<li>Za ní vložte oddělovač stránky</li>
<li>Poté vložte závislé položky. Vyberte z nabídky pole, na jehož hodnotě položka závisí a zadejte hodnotu, která musí být vyplněna, aby závislé pole bylo dostupné.</li>
</ul>
<strong>Struktura položek může vypadat takto:</strong>
<ol>
<li> Otázka 1: máte auto? (ano / ne)</li>
<li>Oddělovač stránky</li>
<li>Otázka 2: jakou barvu má vaše auto? (položka závisí na otázce 1 a vyplněné odpovědi "ano")</li>
<li> Otázka 3: proč nemáte auto? (položka závisí na otázce 1 a vyplněné odpovědi "ne")</li>
</ol>';
$string['dependitem'] = 'Záviset na položce';
$string['dependvalue'] = 'Záviset na hodnotě';
$string['description'] = 'Popis';
$string['do_not_analyse_empty_submits'] = 'Neanalyzovat prázdné odpovědi';
$string['downloadresponseas'] = 'Stáhnout všechny odpovědi jako:';
$string['drop_feedback'] = 'Odebrat dotazník z tohoto kurzu';
$string['dropdown'] = 'Více možností - povolena jedna možná odpověď (rozbalovací nabídka)';
$string['dropdown_values'] = 'Odpovědi';
$string['dropdownlist'] = 'Více možností - jedna odpověď (rozbalovací nabídka)';
$string['dropdownrated'] = 'Rozbalovací nabídka (s číselným ohodnocením)';
$string['edit_item'] = 'Upravit otázku';
$string['edit_items'] = 'Upravit otázky';
$string['email_notification'] = 'Posílat emailová upozornění';
$string['email_notification_help'] = 'Je-li povoleno, obdrží učitelé e-mailové upozornění o odevzdání dotazníku.';
$string['emailteachermail'] = '{$a->username} vyplnil(a) dotazník "{$a->feedback}"

Prohlédnout si ho můžete zde:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} vyplnil(a) dotazník: <i>"{$a->feedback}"</i></p> <p>
Prohlédnout si ho můžete  <a href="{$a->url}">zde</a>.</p>';
$string['entries_saved'] = 'Vaše odpovědi byly uloženy. Děkujeme.';
$string['eventresponsedeleted'] = 'Odpovědi odstraněny';
$string['eventresponsesubmitted'] = 'Odpovědi odeslány';
$string['export_questions'] = 'Exportovat otázky';
$string['export_to_excel'] = 'Export do Excelu';
$string['feedback:addinstance'] = 'Přidat nový dotazník';
$string['feedback:complete'] = 'Vyplňovat dotazník';
$string['feedback:createprivatetemplate'] = 'Vytvářet privátní šablony';
$string['feedback:createpublictemplate'] = 'Vytvářet veřejné šablony';
$string['feedback:deletesubmissions'] = 'Odstraňovat odevzdané odpovědi';
$string['feedback:deletetemplate'] = 'Odstraňovat šablony';
$string['feedback:edititems'] = 'Upravovat položky dotazníku';
$string['feedback:mapcourse'] = 'Mapovat kurzy globálními dotazníky';
$string['feedback:receivemail'] = 'Dostávat upozornění e-mailem';
$string['feedback:view'] = 'Zobrazit dotazník';
$string['feedback:viewanalysepage'] = 'Po odeslání zobrazit analýzu';
$string['feedback:viewreports'] = 'Zobrazit sestavy';
$string['feedback_is_not_for_anonymous'] = 'Dotazník není pro anonymní uživatele';
$string['feedback_is_not_open'] = 'Dotazník není přístupný';
$string['feedbackclose'] = 'Povolit odpovědi';
$string['feedbackcompleted'] = '{$a->username} ukončil {$a->feedbackname}';
$string['feedbackopen'] = 'Dostupné od';
$string['file'] = 'Soubor';
$string['filter_by_course'] = 'Filtrovat podle kurzů';
$string['handling_error'] = 'V modulu Dotazník vznikla chyba při obsluze akcí';
$string['hide_no_select_option'] = 'Skrýt možnost "Nevybráno"';
$string['horizontal'] = 'Vodorovně';
$string['import_questions'] = 'Importovat otázky';
$string['import_successfully'] = 'Úspěšně importováno';
$string['importfromthisfile'] = 'Importovat z tohoto souboru';
$string['includeuserinrecipientslist'] = 'Zahrnout {$a} do seznamu příjemců';
$string['indicator:cognitivedepth'] = 'Kognitivní Dotazník';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na studentem získané kognitivní hloubce v aktivitě Dotazník.';
$string['indicator:cognitivedepthdef'] = 'Kognitivní Dotazník';
$string['indicator:cognitivedepthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta kognitivní angažovanosti nabízené aktivitami Dotazník (Úrovně = Bez zobrazení, Zobrazení, Odevzdání)';
$string['indicator:socialbreadth'] = 'Sociální Dotazník';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě Dotazník.';
$string['indicator:socialbreadthdef'] = 'Sociální Dotazník';
$string['indicator:socialbreadthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta sociální angažovanosti nabízené aktivitou Dotazník (Úrovně = Bez účasti, Účastník sám, Účastník s ostatními)';
$string['info'] = 'Informace';
$string['infotype'] = 'Typ informace';
$string['insufficient_responses'] = 'neúplné odpovědi';
$string['insufficient_responses_for_this_group'] = 'V této skupině je nedostatek odpovědí';
$string['insufficient_responses_help'] = 'Má-li být dotazník anonymní, musejí být k dispozici nejméně dva vyplněné dotazníky.';
$string['item_label'] = 'Popisek';
$string['item_name'] = 'Otázka';
$string['label'] = 'Popisek';
$string['labelcontents'] = 'Obsah';
$string['mapcourse'] = 'Mapovat kurzy';
$string['mapcourse_help'] = 'Ve výchozím nastavení jsou dotazníky vytvořené na titulní stránce dostupné na celém serveru a objeví se ve všech kurzech, které obsahují blok Dotazník. Lze zařídit, že se tento blok bude povinně objevovat ve všech kurzech. Pomocí funkce mapování pak můžete sbírat údaje jen ve vybraných kurzech.';
$string['mapcourseinfo'] = 'Toto je veřejný dotazník, dostupný ze všech kurzů pomocí postranního dotazníkového bloku. Můžete však omezit kurzy, v nichž bude tento dotazník dostupný, tím, že je k němu namapujete. Najděte kurz a namapujte ho na tento dotazník.';
$string['mapcoursenone'] = 'Nenamapovány žádné kurzy. Dotazník je přístupný ze všech kurzů.';
$string['mapcourses'] = 'Mapování kurzů';
$string['mappedcourses'] = 'Mapované kurzy';
$string['mappingchanged'] = 'Mapování kurzu bylo změněno';
$string['maximal'] = 'Maximum';
$string['messageprovider:message'] = 'Upozornění na vyplněný dotazník';
$string['messageprovider:submission'] = 'Oznámení o vyplnění dotazníku';
$string['minimal'] = 'Minimum';
$string['mode'] = 'Režim';
$string['modulename'] = 'Dotazník';
$string['modulename_help'] = 'Modul Dotazník umožňuje realizovat dotazníkové šetření. Slouží pro získání zpětné vazby od účastníků kurzu. Při návrhu dotazníku lze použít řadu typů položek včetně výběru z daných hodnot nebo volné tvořené odpovědi.

Vyplněné dotazníky mohou být anonymní, je-li to žádoucí. Výsledky mohou být k dispozici i studentům nebo pouze vyučujícím. Dotazníky na titulní stránce serveru mohou vyplňovat též nepřihlášení uživatelé.

Dotazník lze využít např.

* pro evaluaci kurzu směřující ke zvýšení kvality jeho obsahu pro další účastníky
* pro přihlašování se účastníků k různým událostem
* k získání anonymní zpětné vazby od náhodných návštěvníků vašich stránek
* ke sběru anonymním reportů, např. hlášení školní šikany apod.';
$string['modulenameplural'] = 'Dotazníky';
$string['move_item'] = 'Přesunout tuto otázku';
$string['multichoice'] = 'Výběr z možných odpovědí';
$string['multichoice_values'] = 'Nabízené odpovědi';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'Výběr z možných odpovědí (s číselným ohodnocením)';
$string['multichoicetype'] = 'Výběr z možných odpovědí';
$string['multiplesubmit'] = 'Povolit vícenásobná odevzdání';
$string['multiplesubmit_help'] = 'Jsou-li povoleny anonymní průzkumy, mohou uživatelé odevzdat dotazník neomezeněkrát.';
$string['name'] = 'Název';
$string['name_required'] = 'Název je vyžadován';
$string['nameandlabelformat'] = '({$a->label}) {$a->name}';
$string['next_page'] = 'Další stránka';
$string['no_handler'] = 'Neexistuje ovladač pro';
$string['no_itemlabel'] = 'Žádný popisek';
$string['no_itemname'] = 'Chybí název položky';
$string['no_items_available_yet'] = 'Ještě nebyly vloženy žádné otázky';
$string['no_templates_available_yet'] = 'Nejsou dostupné žádné šablony';
$string['non_anonymous'] = 'Jména respondentů budou zaznamenána a ukázána s odpověďmi';
$string['non_anonymous_entries'] = 'Neanonymní záznamy ({$a})';
$string['non_respondents_students'] = 'Uživatelé, kteří ještě neodpověděli ({$a})';
$string['not_completed_yet'] = 'Dosud nedokončeno';
$string['not_selected'] = 'Nevybráno';
$string['not_started'] = 'Nebylo spuštěno';
$string['numberoutofrange'] = 'Číslo je mimo rozsah';
$string['numeric'] = 'Číselná odpověď';
$string['numeric_range_from'] = 'Rozsah od';
$string['numeric_range_to'] = 'Rozsah do';
$string['of'] = 'z';
$string['oldvaluespreserved'] = 'Staré otázky a přiřazené odpovědi budou zachovány';
$string['oldvalueswillbedeleted'] = 'Stávající otázky a odpovědi všech účasníků budou odstraněny';
$string['only_one_captcha_allowed'] = 'V dotazníku je povolena jen jedna captcha';
$string['openafterclose'] = 'Zadali jste datum ukončení před datem zahájení';
$string['overview'] = 'Přehled';
$string['page'] = 'Stránka';
$string['page-mod-feedback-x'] = 'Jakákoliv stránka dotazníku';
$string['page_after_submit'] = 'Zpráva o dokončení';
$string['pagebreak'] = 'Zalomení stránky';
$string['pluginadministration'] = 'Správa dotazníku';
$string['pluginname'] = 'Dotazník';
$string['position'] = 'Pozice';
$string['previous_page'] = 'Předchozí stránka';
$string['privacy:metadata:completed'] = 'Zápis odeslané zpětné vazby';
$string['privacy:metadata:completed:anonymousresponse'] = 'Zda má být odesláno jako anonymní.';
$string['privacy:metadata:completed:timemodified'] = 'Čas úpravy zprávy.';
$string['privacy:metadata:completed:userid'] = 'ID uživatele, který dotazník dokončil.';
$string['privacy:metadata:completedtmp'] = 'Přehled dosud probíhajících plnění dotazníků.';
$string['privacy:metadata:value'] = 'Zápis odpovědi na otázku.';
$string['privacy:metadata:value:value'] = 'Zvolená odpověď.';
$string['privacy:metadata:valuetmp'] = 'Zápis odpovědi na otázku v probíhajícím vyplňování dotazníku.';
$string['public'] = 'Veřejná';
$string['question'] = 'Otázka';
$string['questionandsubmission'] = 'Možnosti odevzdání dotazníku';
$string['questions'] = 'Otázky';
$string['questionslimited'] = 'Zobrazit pouze {$a} prvních otázek, zobrazit jednotlivé odpovědi nebo stáhnout data k zobrazení všech dat.';
$string['radio'] = 'Více možností - jedna odpověď';
$string['radio_values'] = 'Možné odpovědi';
$string['ready_feedbacks'] = 'Připravené dotazníky';
$string['required'] = 'Vyžadováno';
$string['resetting_data'] = 'Resetovat možné odpovědi dotazníku';
$string['resetting_feedbacks'] = 'Reset dotazníku';
$string['response_nr'] = 'Číslo odpovědi';
$string['responses'] = 'Odpovědi';
$string['responsetime'] = 'Čas odpovědí';
$string['save_as_new_item'] = 'Uložit jako novou otázku';
$string['save_as_new_template'] = 'Uložit jako novou šablonu';
$string['save_entries'] = 'Odevzdejte své odpovědi';
$string['save_item'] = 'Uložit otázku';
$string['saving_failed'] = 'Uložení se nezdařilo';
$string['search:activity'] = 'Dotazník - informace';
$string['search_course'] = 'Prohledat kurz';
$string['searchcourses'] = 'Vyhledat kurzy';
$string['searchcourses_help'] = 'Vložte celý nebo krátký název kurzu, který chcete mapovat pomocí tohoto dotazníku.';
$string['selected_dump'] = 'Vybrané indexy proměnné $SESSION jsou vypsány níže';
$string['send'] = 'Odeslat';
$string['send_message'] = 'Odeslat zprávu';
$string['show_all'] = 'Ukázat vše';
$string['show_analysepage_after_submit'] = 'Po odeslání zobrazit stránku analýzy';
$string['show_entries'] = 'Ukázat odpovědi';
$string['show_entry'] = 'Ukázat odpověď';
$string['show_nonrespondents'] = 'Ukázat uživatele, kteří neodpověděli';
$string['site_after_submit'] = 'Adresa stránky po dokončení';
$string['sort_by_course'] = 'Seřadit podle kurzu';
$string['started'] = 'Spuštěno';
$string['startedon'] = 'Spuštěno v  {$a}';
$string['subject'] = 'Předmět';
$string['switch_item_to_not_required'] = 'Nastavit jako volitelná odpověď';
$string['switch_item_to_required'] = 'Nastavit jako vyžadovaná odpověď';
$string['template'] = 'Šablona';
$string['template_deleted'] = 'Šablona odstraněna';
$string['template_saved'] = 'Šablony uložena';
$string['templates'] = 'Šablony';
$string['textarea'] = 'Delší textová odpověď';
$string['textarea_height'] = 'Počet řádek';
$string['textarea_width'] = 'Šířka';
$string['textfield'] = 'Krátká textová odpověď';
$string['textfield_maxlength'] = 'Maximum povolených znaků';
$string['textfield_size'] = 'Délka textového pole';
$string['there_are_no_settings_for_recaptcha'] = 'Není dostupné nastavení pro captcha';
$string['this_feedback_is_already_submitted'] = 'Tento dotazník jste již vyplnili.';
$string['typemissing'] = 'Chybějící hodnota "typ"';
$string['update_item'] = 'Uložit změny otázky';
$string['url_for_continue'] = 'Odkaz pro tlačítko Pokračovat';
$string['url_for_continue_help'] = 'Po odeslání dotazníku se zobrazí tlačítko Pokračovat, které odkazuje na hlavní stránku kurzu. Přejete-li si přejít po vyplnění dotazníku na jinou stránku, vložte sem příslušnou adresu stránky.';
$string['use_one_line_for_each_value'] = 'Každou odpověď umístěte na jeden řádek!';
$string['use_this_template'] = 'Použít tuto šablonu';
$string['using_templates'] = 'Použít šablonu';
$string['vertical'] = 'Svisle';
