<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_recommender', language 'es_mx', version '3.8'.
 *
 * @package     block_recommender
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity_filter_activities'] = 'Todas las actividades del módulo';
$string['activity_filter_activity'] = 'Tipo de item';
$string['activity_filter_activity_help'] = '<p>Usted puede filtrar los resultados en la tabla debajo controlando el recurso y/o la actividad incluida.</p> <p>Por defecto, todas las actividades y recursos estarán incluidos dentro de la tabla de resultados.</p> <p>Si Usted desea solamente ver recursos que hayan sido vistos (estos serían archivos y páginas de recursos), u otras actividades (estos serían por ejemplo, foro, wiki, glosario o blog), Usted puede emplear la lista desplegable para elegir entre las siguientes tres opciones:</p>
<ol><li>Todos</li>
<li>Solamente Recursos</li>
<li>Solamente Actividades</li>
</ol><p>Por favor observe que si su sitio web no incluye alguno de los tipos de recursos o actividades superiores, la opción de filtro no estará disponible.</p> <p>Si Usted navega lejos de la página, sus opciones de filtro regresarán a las opciones por defecto.</p>';
$string['activity_filter_all'] = 'Todas';
$string['activity_filter_apply'] = 'Aplicar';
$string['activity_filter_daterange'] = 'Rango de fechas';
$string['activity_filter_daterange_help'] = '<p>Usted puede filtrar los resultados en la tabla inferior controlando el rango de fechas en los que se incluya la actividad y/o recurso.</p> <p>Por defecto, el rango de fechas es desde la última fecha que visitó el sitio web o desde el mes pasado; la que sea más reciente de las dos. Por lo tanto, si Usted visita el sitio regularmente Usted verá actividad basada en su última visita; pero si no visita regularmente el sitio, por defecto estará basado en la actividad del mes pasado.</p><p> Use la lista desplegable para elegir entre las siguientes cuatro opciones:</p><ol><li>Desde la última visita al sitio</li><li>Desde el mes pasado</li><li>Desde la semana pasada</li><li>Desde ayer</li></ol> <p> Una vez que haya seleccionado la opción que requiera se actualizarán los resultados, mostrando solamente aquellos que caigan dentro del rango de fechas que haya elegido.</p><p>Si Usted navega fuera de la página, sus opciones de filtro volverán a las opciones por defecto.</p>';
$string['activity_filter_resources'] = 'Todos los recursos del módulo';
$string['activity_filter_sort'] = 'Ordenar por';
$string['activity_filter_sort_az'] = 'A a-la Z';
$string['activity_filter_sort_help'] = '<p>Usted puede ordenar los resultados en la tabla inferior.</p>
<p>Por defecto los resultados se ordenan con las actividades y recursos más populares hasta arriba. Estos serían los resultados con el mayor número dentro de la columna \'Vistas\'.</p> <p>Usted también puede seleccionar los resultados menos vistos, o con mayor o menor número de contribuciones (participaciones), o re-ordenar los items alfabéticamente.</p>
<p>Si Usted navega fuera de la página, sus opciones de filtro volverán a las opciones por defecto.</p>';
$string['activity_filter_sort_leastp'] = 'Menos contribuciones';
$string['activity_filter_sort_leastviewed'] = 'Menos vistas';
$string['activity_filter_sort_mostp'] = 'Más contribuciones';
$string['activity_filter_sort_mostviewed'] = 'Más vistas';
$string['activity_filter_sort_za'] = 'Z a-la A';
$string['activity_items'] = 'Items';
$string['activity_lastmonth'] = 'Desde el mes pasado';
$string['activity_lastvisit'] = 'Desde la última vez que visitó este sitio web';
$string['activity_lastweek'] = 'Desde la semana pasada';
$string['activity_moduleincluded'] = '{$a->modname} incluído';
$string['activity_more'] = 'Items más populares';
$string['activity_participateactions'] = 'Acciones participantes';
$string['activity_participations'] = 'Participaciones';
$string['activity_popularactivitiestitle'] = 'Actividades populares';
$string['activity_servicetitle'] = 'Actividades y recursos populares';
$string['activity_sort'] = 'Resultados';
$string['activity_viewactions'] = 'Ver acciones';
$string['activity_views'] = 'Vistas';
$string['activity_yesterday'] = 'Desde ayer';
$string['add'] = 'Añadir';
$string['bookmark_addbookmark'] = 'Añadir marcador';
$string['bookmark_bookmarktitle'] = 'Marcadores';
$string['bookmark_category'] = 'Categoría';
$string['bookmark_categoryn_description'] = 'El título a usar para la categoría {$a}';
$string['bookmark_categoryn_title'] = 'Categoría {$a}';
$string['bookmark_categorytitlen'] = 'Categoría {$a}';
$string['bookmark_confirmdeletionfull'] = '¿Está seguro de querer remover la liga \'{$a->title}\' ({$a->url})?';
$string['bookmark_create'] = 'crear';
$string['bookmark_create_alt'] = 'Crear un nuevo marcador compartido';
$string['bookmark_createbookmark_text'] = 'Usted puede también {$a} un nuevo marcador';
$string['bookmark_defaultcategory'] = 'Categoría por defecto';
$string['bookmark_delete'] = 'Eliminar marcador';
$string['bookmark_deletetitle'] = 'Eliminar Marcador';
$string['bookmark_displaytype_categoryn'] = 'Las ligas superiores de la categoría {$a}';
$string['bookmark_displaytype_defaultcategory'] = 'Las ligas superiores de la categoría por defecto';
$string['bookmark_displaytype_description'] = 'Cuales ligas deberían mostrarse en el bloque';
$string['bookmark_displaytype_title'] = 'Mostrar';
$string['bookmark_displaytype_top'] = 'La liga superior de cada categoría';
$string['bookmark_edit'] = 'Editar marcador';
$string['bookmark_editbookmark'] = 'Editar Marcador';
$string['bookmark_errormoving'] = 'Error al mover item de marcador.';
$string['bookmark_more'] = 'Más marcadores';
$string['bookmark_more_title'] = 'Detalles de Marcador';
$string['bookmark_move'] = 'Mover marcador';
$string['bookmark_movehere'] = 'Mover marcador aquí';
$string['bookmark_servicetitle'] = 'Marcadores compartidos';
$string['bookmark_title'] = 'Título';
$string['bookmark_titleinuse'] = 'Este título ya está usado con la URL \'{$a->url}\' dentro de este curso';
$string['bookmark_url'] = 'URL';
$string['bookmark_urlinuse'] = 'Este título ya está usado con el marcador \'{$a->title}\' dentro de este curso';
$string['bookmark_urlinvalid'] = 'Este URL es inválido';
$string['course_course_shortname_pattern_description'] = 'Esta expresión regular se aplica al nombrecorto del curso';
$string['course_course_shortname_pattern_title'] = 'Expresión Regular Nombrecorto';
$string['course_course_url_description'] = 'La URL a usar si se encontrara una coincidencia en el nombrecorto del curso. Cualquier coincidencia encontrada en el patrón puede usarse dentro de la URL empleando la notación $1';
$string['course_course_url_title'] = 'URL de liga';
$string['course_role'] = 'Rol para Cursos Populares';
$string['course_roledescription'] = '¿Cual rol debería usarse para evaluar si un curso es popular ?';
$string['course_servicetitle'] = 'Sitios web populares';
$string['enabledservices'] = 'Servicios habilitados';
$string['errorcallingservice'] = 'Error al llamar al servicio \'{$a}\'.';
$string['erroremptyfield'] = 'El campo \'{$a}\' está vacío.';
$string['errormissingfield'] = 'El campo \'{$a}\' falta.';
$string['errornosuchservice'] = 'El servicio \'{$a}\' no existe.';
$string['notifynoenabledservices'] = 'Debe habilitarse al menos un servicio en el {$a} para hacer útil este bloque.';
$string['pluginname'] = 'Recomendador';
$string['recommender:addbookmark'] = 'Añadir item al servicio de Marcadores';
$string['recommender:viewactivity'] = 'Ver servicio de Actividades Populares';
$string['recommender:viewbookmark'] = 'Ver servicio de Marcadores';
$string['recommender:viewcourse'] = 'Ver servicio de Cursos Populares';
$string['recommendertitle'] = 'Recomendador';
$string['recommendertitle_help'] = '<p>Este bloque le permite ver la actividad más reciente de otros usuarios de este sitio. Usted puede ver los recursos y actividades más populares que hayan sido vistos y, si fuera apropiado, hayan participado dentro del sitio.</p>
<p>Si Usted elige el enlace inferior para \'Actividades populares en este sitio\', Usted verá los tres resultados superiores (Usted puede elegir alguno para ir directamente a ese recurso o actividad enlistado) y habrá un enlace hacia \'más\', donde Usted podrá acceder a una página donde estarán enlistados todos los resultados para este sitio web.</p> <p>Usted podrá filtrar los resultados por rango de fechas, tipo de actividad, título del item y por el número de vistas y participaciones.</p>';
$string['servicedisabled'] = 'El servicio de \'{$a->servicename}\' está actualmente dehabilitado';
$string['sortby'] = '. Ordenar por';
