<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'no', version '3.8'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aggregategrades'] = 'Omberegn karakterer';
$string['aggregation'] = 'Karakterberegning';
$string['allocate'] = 'Fordel innleveringer';
$string['allocatedetails'] = 'forventet:  {$a->expected}<br />innlevert: {$a->submitted}<br />til fordeling: {$a->allocate}';
$string['allocation'] = 'Innleveringsfordeling';
$string['allocationconfigured'] = 'Fordeling er satt opp';
$string['allocationdone'] = 'Fordelingen utført';
$string['allocationerror'] = 'Fordelingsfeil';
$string['allowedfiletypesforoverallfeedback'] = 'Tillatte filtyper i vedlegg';
$string['allowedfiletypesforoverallfeedback_help'] = 'Tillatte filtyper for tilbakemelding kan begrenses med en liste med godkjente filtyper. Dersom feltet er tomt aksepteres alle filtyper.';
$string['allowedfiletypesforsubmission'] = 'Tillat følgende filtyper i innleveringen';
$string['allowedfiletypesforsubmission_help'] = 'Tillatte filtyper for innlevering kan begrenses med en liste med godkjente filtyper. Dersom feltet er tomt aksepteres alle filtyper.';
$string['allsubmissions'] = 'Alle innleveringer ({$a})';
$string['alreadygraded'] = 'Allerede vurdert';
$string['areaconclusion'] = 'Konklusjonstekst';
$string['areainstructauthors'] = 'Innleveringsinstrukser';
$string['areainstructreviewers'] = 'Vurderingsinstruksjoner';
$string['areaoverallfeedbackattachment'] = 'Vedlegg til generell tilbakemelding';
$string['areaoverallfeedbackcontent'] = 'Tekst til generell tilbakemelding';
$string['areasubmissionattachment'] = 'Vedlegg til innleveringen';
$string['areasubmissioncontent'] = 'Innleveringstekster';
$string['assess'] = 'Vurdér';
$string['assessedexample'] = 'Vurderte eksempelinnleveringer';
$string['assessedsubmission'] = 'Vurderte innleveringer';
$string['assessingexample'] = 'Vurderer eksempelinnlevering';
$string['assessingsubmission'] = 'Vurderer innlevering';
$string['assessment'] = 'Vurdering';
$string['assessmentby'] = 'av  <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Vurdert av {$a}';
$string['assessmentbyyourself'] = 'Din vurdering';
$string['assessmentdeleted'] = 'Omfordeling av vurdering';
$string['assessmentend'] = 'Slutt på vurderinger';
$string['assessmentendbeforestart'] = 'Frist for vurdering kan ikke være før datoen det åpnes for vurdering';
$string['assessmentenddatetime'] = 'Vurderingsfrist: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} frist for vurdering.';
$string['assessmentform'] = 'Vurderingsskjema';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Vurdering</a> av <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Referansevurdering';
$string['assessmentreferenceconflict'] = 'Det er ikke mulig å vurdere en eksempelinnlevering som du har gitt en referansevurdering for';
$string['assessmentreferenceneeded'] = 'Du må vurdere denne eksempelinnleveringen for å etablere en referansevurdering. Klikk på "Fortsett" for å vurdere denne innleveringen.';
$string['assessments'] = 'Vurderinger';
$string['assessmentsettings'] = 'Vurderingsinnstillinger';
$string['assessmentstart'] = 'Vurderinger kan starte fra';
$string['assessmentstartdatetime'] = 'Åpen for vurdering fra  {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} åpnes for vurdering';
$string['assessmentweight'] = 'Vurderingsvekting';
$string['assignedassessments'] = 'Tildelte innleveringer for vurdering';
$string['assignedassessmentsnone'] = 'Du har ingen tildelte innleveringer å vurdere';
$string['backtoeditform'] = 'Tilbake til redigeringsskjemaet';
$string['byfullname'] = 'av <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'av {$a}';
$string['calculategradinggrades'] = 'Beregn vurderingskarakterer';
$string['calculategradinggradesdetails'] = 'forventet: {$a->expected}<br />beregnet: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Beregn innleveringskarakterer';
$string['calculatesubmissiongradesdetails'] = 'forventet: {$a->expected}<br />beregnet: {$a->calculated}';
$string['chooseuser'] = 'Velg bruker...';
$string['clearaggregatedgrades'] = 'Slett alle summerte karakterer';
$string['clearaggregatedgrades_help'] = 'Sammenlagte karakterer for innlevering og vurderingskarakterer vil bli tilbakestilt. Du kan senere omberegne disse karakterene fra bunnen av i fasen "Endelig karaktersetting",';
$string['clearaggregatedgradesconfirm'] = 'Er du sikker på at du vil slette alle beregnede karakterer for innleveringer og vurderingskarakterer?';
$string['clearassessments'] = 'Slett vurderinger';
$string['clearassessments_help'] = 'Beregnede karakterer for innleveringer og vurderingskarakterer vil bli tilbakestilt. Informasjonen om hvordan evalueringsskjemaet er utfylt vil bli beholdt, men alle som vurderer må gjenåpne skjemaet og lagre det på nytt for at det skal settes karakter igjen.';
$string['clearassessmentsconfirm'] = 'Er du sikker på at du vil slette alle vurderingskarakterer? Du vil ikke kunne hente tilbake informasjonen selv senere og alle fordelte innleveringer må vurderes på nytt.';
$string['conclusion'] = 'Konklusjon';
$string['conclusion_help'] = 'Konklusjonen er en tekst som vises til deltakerne på slutten av aktiviteten.';
$string['configexamplesmode'] = 'Standardmodus for eksempelvurdering i Workshop';
$string['configgrade'] = 'Standard maksimumskarakter for innleveringer i Workshop';
$string['configgradedecimals'] = 'Standard antall desimaler ved visning av karakterer.';
$string['configgradinggrade'] = 'Standard maksimumskarakter for vurderinger i Workshop';
$string['configmaxbytes'] = 'Standard maksimumsstørrelse på filvedlegg i innleveringer i alle Workshop på portalen (avhenger også av kursgrenser og andre lokale innstillinger)';
$string['configstrategy'] = 'Standard karakterstrategi for workshoper';
$string['createsubmission'] = 'Legg til innsending';
$string['crontask'] = 'Bakgrunnsbehandling for workshopmodulen';
$string['daysago'] = 'for {$a} dager siden';
$string['daysleft'] = '{$a} dager igjen';
$string['daystoday'] = 'i dag';
$string['daystomorrow'] = 'i morgen';
$string['daysyesterday'] = 'i går';
$string['deadlinesignored'] = 'Tidsrestriksjoner gjelder ikke deg';
$string['deletesubmission'] = 'Slett innlevering';
$string['editassessmentform'] = 'Endre vurderingsskjemaet';
$string['editassessmentformstrategy'] = 'Endre vurderingsskjema ({$a})';
$string['editingassessmentform'] = 'Endrer vurderingsskjema';
$string['editingsubmission'] = 'Endrer innlevering';
$string['editsubmission'] = 'Rediger innlevering';
$string['err_multiplesubmissions'] = 'Mens du endret dette skjema, er en annen versjon av innleveringen lagret. Flere innleveringer pr. bruker er ikke tillatt.';
$string['err_removegrademappings'] = 'Ikke i stand til å fjerne ubrukte karakterkoblinger';
$string['evaluategradeswait'] = 'Vennligst vent til vurderingen er evaluert og karakterer er beregnet. Det kan ta noe tid.

I karakterboka vil du se to karakterer, en for oppgaven du leverte og en for hvor godt du traff i vurderingen av andres arbeider.';
$string['evaluation'] = 'Endelig karaktersetting';
$string['evaluationmethod'] = 'Metode for endelig karaktersetting';
$string['evaluationmethod_help'] = 'Metode for endelig karakter bestemmer hvordan endelig karakter skal beregnes. Du kan la den beregne karakterer gjentatte ganger med forskjellige innstillinger hvis du ikke er tilfreds med resultatet.';
$string['evaluationsettings'] = 'Karakterevaluering innstillinger';
$string['eventassessableuploaded'] = 'En innlevering har blitt lastet opp';
$string['eventassessmentevaluated'] = 'Innlevering evaluert';
$string['eventassessmentevaluationsreset'] = 'Vuderingsevalueringer tilbakestilt';
$string['eventassessmentreevaluated'] = 'Vurdering er revurdert';
$string['eventphaseswitched'] = 'Fasen er byttet';
$string['eventsubmissionassessed'] = 'Innlevering vurdert';
$string['eventsubmissionassessmentsreset'] = 'Innleveringsvurderinger ryddet';
$string['eventsubmissioncreated'] = 'Innlevering opprettet';
$string['eventsubmissiondeleted'] = 'Innlevering slettet';
$string['eventsubmissionreassessed'] = 'Innlevering revurdert';
$string['eventsubmissionupdated'] = 'Innlevering oppdatert';
$string['eventsubmissionviewed'] = 'Innlevering vist';
$string['example'] = 'Eksempelinnlevering';
$string['exampleadd'] = 'Legg til eksempelinnlevering';
$string['exampleassess'] = 'Vurder eksempelinnlevering';
$string['exampleassessments'] = 'Eksempelinnleveringer til vurdering';
$string['exampleassesstask'] = 'Vurder eksempler';
$string['exampleassesstaskdetails'] = 'forventet: {$a->expected}<br />vurdert: {$a->assessed}';
$string['examplecomparing'] = 'Sammenligner vurderinger av eksempelinnlevering';
$string['exampledelete'] = 'Slett eksempel';
$string['exampledeleteconfirm'] = 'Er du sikker på at du vil slette følgende eksempelinnlevering? Klikk på "Fortsett"-knappen for å slette innleveringen.';
$string['exampleedit'] = 'Endre eksempel';
$string['exampleediting'] = 'Redigerer eksempel';
$string['exampleneedassessed'] = 'Du må vurdere alle eksempelinnleveringene først';
$string['exampleneedsubmission'] = 'Du må foreta en innlevering og vurdere alle eksempelinnleveringene først.';
$string['examplesbeforeassessment'] = 'Eksempler er tilgjengelige etter at du har levert selv, og du må vurdere eksemplene før du kan vurdere andres innleveringer.';
$string['examplesbeforesubmission'] = 'Eksempler må vurderes før du kan levere selv.';
$string['examplesmode'] = 'Modus for eksempelinnlevering';
$string['examplesubmissions'] = 'Eksempler på innleveringer';
$string['examplesvoluntary'] = 'Vurdering av eksempelinnlevering er frivillig';
$string['exportsubmission'] = 'Eksporter denne siden';
$string['feedbackauthor'] = 'Tilbakemelding til forfatteren';
$string['feedbackauthorattachment'] = 'Vedlegg';
$string['feedbackby'] = 'Tilbakemelding fra {$a}';
$string['feedbackreviewer'] = 'Tilbakemelding fra den som vurderer';
$string['feedbacksettings'] = 'Tilbakemelding';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Gitte karakterer';
$string['grade_grading_name'] = 'Vurdering';
$string['grade_submission_name'] = 'Innlevering';
$string['gradecalculated'] = 'Beregn karakter for innlevering';
$string['gradedecimals'] = 'Antall desimaler i karakterer';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Karakter: {$a->received} av {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (vurdering)';
$string['gradeitemsubmission'] = '{$a->workshopname} (innlevering)';
$string['gradeover'] = 'Overstyr innleveringskarakter';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Workshop karakterrapport';
$string['gradetopassgrading'] = 'Vurderingskarakter for bestått';
$string['gradetopasssubmission'] = 'Innleveringskarakter for bestått';
$string['gradinggrade'] = 'Karakter for vurdering';
$string['gradinggrade_help'] = 'Denne innstillingen angir maksimum karakter som kan oppnås i en vurdering av innlevering.';
$string['gradinggradecalculated'] = 'Beregnet karakter for vurdering';
$string['gradinggradeof'] = 'Karakter for vurdering (av {$a})';
$string['gradinggradeover'] = 'Overstyr karakter for vurdering';
$string['gradingsettings'] = 'Karakterinnstillinger';
$string['groupnoallowed'] = 'Du har ikke tilgang til noen gruppe i denne workshopen';
$string['iamsure'] = 'Ja, jeg er sikker';
$string['indicator:cognitivedepth'] = 'Kognitiv workshop';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på den kognitive dybden vist av studenten i en Workshop-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Workshop - kognitivt engasjement';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av Workshop-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen visning, Vis, Send, Se tilbakemelding, Kommenter på tilbakemelding, Send inn igjen etter å ha sett tilbakemelding)';
$string['indicator:socialbreadth'] = 'Sosial workshop';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på den sosiale bredden vist av studenten i en Workshop-aktivitet.';
$string['indicator:socialbreadthdef'] = 'Workshop - sosialt engasjement';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandel av den sosiale inngrep tilbys av the Workshop aktivitetene i løpet av dette analyseintervall (Nivåer = Nei deltakelse, Deltaker alene, Deltaker med andre)';
$string['info'] = 'Info';
$string['instructauthors'] = 'Instruksjoner for innlevering';
$string['instructreviewers'] = 'Instruksjoner for vurdering';
$string['introduction'] = 'Beskrivelse';
$string['latesubmissions'] = 'For sene innleveringer';
$string['latesubmissions_desc'] = 'Tillat innleveringer etter fristen';
$string['latesubmissions_help'] = 'Dersom aktivert, kan en forfatter levere inn deres arbeid etter innleveringsfristen eller i løpet av vurderingsfasen. For sene innleveringer dog ikke endres.';
$string['latesubmissionsallowed'] = 'For sene innleveringer godtas';
$string['legacyallocationplugincron'] = 'Arvet cron workshoptildeling';
$string['maxbytes'] = 'Maksimum filstørrelse for vedlegget';
$string['modulename'] = 'Workshop';
$string['modulename_help'] = 'Workshopmodulen gjør det mulig å foreta innsamling, gjennomgang og medstudentevaluering (fagfellevurdering) av studenters arbeid.

Studenter kan levere inn digitalt innhold av alle slag (filer), som f.eks. tekstbehandlede dokumenter eller regneark, og kan også skrive tekst direkte inn i feltet med teksteditoren.

Innleveringer evalueres ved hjelp av et multi-kriteriums evalueringsskjema som defineres av læreren. Medstudent-evalueringsprosessen og forståelsen av evalueringsskjemaet kan øves på i forkant med f.eks. innleveringer gitt av læreren sammen med en referanseevaluering. Studenter får sjansen til å evaluere en eller flere av sine medstudenters innleveringer. Innleveringer og evalueringer kan være anonyme hvis det er ønskelig.

Studenter får to karakterer i en workshopaktivitet - en karakter for innleveringen og en for evalueringen av medstudenten(e). Begge karakterene registreres i karakterboken.';
$string['modulenameplural'] = 'Workshoper';
$string['myassessments'] = 'Mine vurderinger';
$string['mysubmission'] = 'Min innlevering';
$string['nattachments'] = 'Maksimum antall vedlegg i innleveringen';
$string['noexamples'] = 'Ingen eksempler ennå i denne workshopen';
$string['noexamplesformready'] = 'Du må sette opp evalueringsskjemaet før du lager eksempelinnleveringer.';
$string['nogradeyet'] = 'Ingen karakter ennå';
$string['nosubmissionfound'] = 'Ingen innlevering funnet for denne brukeren';
$string['nosubmissions'] = 'Ingen innleveringer ennå i denne workshopen';
$string['nosubmissiontype'] = 'Minst en innleverngstype må være tilgjengelig';
$string['notassessed'] = 'Ikke vurdert ennå';
$string['nothingfound'] = 'Ingenting å vise';
$string['nothingtoreview'] = 'Ingenting å vise';
$string['notoverridden'] = 'Ikke overstyrt';
$string['noworkshops'] = 'Det er ingen workshoper i dette kurset';
$string['noyoursubmission'] = 'Du har ikke levert inn arbeidet ditt ennå';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Generell tilbakemelding';
$string['overallfeedbackfiles'] = 'Maks antall vedlegg til generell tilbakemelding';
$string['overallfeedbackmaxbytes'] = 'Maksimum filstørrelse for vedlegget til tilbakemeldingen';
$string['overallfeedbackmode'] = 'Generell tilbakemelding';
$string['overallfeedbackmode_0'] = 'Deaktivert';
$string['overallfeedbackmode_1'] = 'Aktivert og valgfri';
$string['overallfeedbackmode_2'] = 'Aktivert og påkrevd';
$string['overallfeedbackmode_help'] = 'Hvis aktivert, vises et tekstfelt nederst på evalueringsskjemaet. De som skal evaluere kan legge inn den generelle evalueringen av innleveringen der, eller gi en nærmere forklaring på evalueringen.';
$string['page-mod-workshop-x'] = 'Alle sider i workshopmodulen';
$string['participant'] = 'Deltaker';
$string['participantrevierof'] = 'Deltakeren kan vurdere ';
$string['participantreviewedby'] = 'Deltakeren blir vurdert av ';
$string['phaseassessment'] = 'Vurderingsfase';
$string['phaseclosed'] = 'Stengt';
$string['phaseevaluation'] = 'Karakterberegningsfase';
$string['phasesetup'] = 'Oppsettsfase';
$string['phasesoverlap'] = 'Innleveringsfasen og vurderingsfasen kan ikke overlappe';
$string['phasesubmission'] = 'Innleveringsfase';
$string['pluginadministration'] = 'Workshop administrasjon';
$string['pluginname'] = 'Workshop';
$string['prepareexamples'] = 'Forbered eksempelinnleveringer';
$string['previewassessmentform'] = 'Forhåndsvisning';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Sammenlagt karakter for alle vurderinger gjort av brukeren i denne workshopaktiviteten';
$string['privacy:metadata:assessmentgrade'] = 'Sammenlagt karakter for innleveringen ut fra denne vurderingen';
$string['privacy:metadata:assessmentgradinggrade'] = 'Krakter for å utføre denne vurderingen';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Manuelt overskrevet verdi på karakter for denne vurderingen.';
$string['privacy:metadata:assessmentid'] = 'Innleveringens ID';
$string['privacy:metadata:authorid'] = 'IDen til innleverings forfatter';
$string['privacy:metadata:dimensiongrade'] = 'Karakter for den kitte vurderingstypen';
$string['privacy:metadata:dimensionid'] = 'ID til vurderingstypen.';
$string['privacy:metadata:example'] = 'Om denne oppføringen representerer en eksempelinnlevering';
$string['privacy:metadata:feedbackauthor'] = 'Tilbakemelding for forfatteren';
$string['privacy:metadata:feedbackauthorformat'] = 'Tekstformat av tilbakemeldingen for forfatteren';
$string['privacy:metadata:feedbackreviewer'] = 'Tilbakemelding til brukeren som utførte vurderingen.';
$string['privacy:metadata:feedbackreviewerformat'] = 'Tekstformatet på tilbakemeldingen for brukeren som utfører vurderingen';
$string['privacy:metadata:late'] = 'Om innleveringen er levert etter fristen';
$string['privacy:metadata:peercomment'] = 'Kommentar til den gitte karakteren fra brukeren som har gitt vurderingen';
$string['privacy:metadata:peercommentformat'] = 'Tekstformatet på kommentarer til den gitte karakteren';
$string['privacy:metadata:preference:perpage'] = 'Antall innleveringer brukeren foretrekker å se per side';
$string['privacy:metadata:published'] = 'Om innleveringen skal publiseres til alle deltakere med en gang workshopen stenges';
$string['privacy:metadata:reviewerid'] = 'ID\'en til bruken som ga vurderingen.';
$string['privacy:metadata:strategy'] = 'Navnet på karakterstraegimodulen som tolker verdiene';
$string['privacy:metadata:submissioncontent'] = 'Innleveringens innhold';
$string['privacy:metadata:submissioncontentformat'] = 'Tekstformat på innleveringsinnholdet';
$string['privacy:metadata:submissiongrade'] = 'Sammenlagt karakter for innleveringen på et desimalformat i intervallet 0 til 100';
$string['privacy:metadata:submissiongradeover'] = 'Manuelt overstyrt verdi for den aggregerte karakteren';
$string['privacy:metadata:submissionid'] = 'Innleverings ID';
$string['privacy:metadata:submissiontitle'] = 'Innleveringens tittel';
$string['privacy:metadata:subsystem:corefiles'] = 'Workshopmodulen lagrer filer bygd inn i  eller lagt ved innleveringen';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Workshopmodulen har innebygget støtte for plagiatkontrollsystemer';
$string['privacy:metadata:timeaggregated'] = 'Når den aggregerte karakteren sist ble beregnet';
$string['privacy:metadata:timecreated'] = 'Når denne oppføringen ble opprettet i databasen';
$string['privacy:metadata:timemodified'] = 'Når denne oppføringen sist ble redigert i databasen';
$string['privacy:metadata:userid'] = 'ID\'en til brukeren hvis aggregerte karakter er beregnet';
$string['privacy:metadata:weight'] = 'Vekting av vurdering';
$string['privacy:metadata:workshopaggregations'] = 'Inneholder aggregerte karakterer for vurdering';
$string['privacy:metadata:workshopassessments'] = 'Inneholder informasjon om tildelte workshop-innleveringer.';
$string['privacy:metadata:workshopgrades'] = 'Inneholder informasjon om hvordan vurderingsskjemaet er fylt ut med karakterer og kommentarer.';
$string['privacy:metadata:workshopid'] = 'Workshopaktivitetens ID';
$string['privacy:metadata:workshopsubmissions'] = 'Inneholder informasjon om workshop-innleveringer.';
$string['privacy:request:delete:content'] = 'Innholdet har blitt slettet (etter en forespørsel fra brukeren eller utløpt)';
$string['privacy:request:delete:title'] = '[Slettet]';
$string['publishedsubmissions'] = 'Publiserte innleveringer';
$string['publishsubmission'] = 'Publiser innlevering';
$string['publishsubmission_help'] = 'Publiserte innleveringer er tilgjengelige for andre når workshopen er stengt.';
$string['reassess'] = 'Vurder på nytt';
$string['receivedgrades'] = 'Mottatte karakterer';
$string['recentassessments'] = 'Workshop vurderinger:';
$string['recentsubmissions'] = 'Workshop innleveringer:';
$string['resetassessments'] = 'Slett alle vurderingene';
$string['resetassessments_help'] = 'Du kan velge å kun slette tildelte vurderinger uten at det påvirker innleveringene. Dersom innleveringene slettes, vil også tildelingene slettes og dette valget ignoreres. Merk at dette også påvirker tildelinger av eksempelinnleveringer.';
$string['resetphase'] = 'Bytt til oppsettsfase';
$string['resetphase_help'] = 'Når aktivert, vil alle workshoper settes i oppsettsfasen.';
$string['resetsubmissions'] = 'Slett alle innleveringer';
$string['resetsubmissions_help'] = 'Alle innleveringer og deres vurderinger vil bli slettet. Dette påvirker ikke eksempelinnleveringer.';
$string['saveandclose'] = 'Lagre og lukk';
$string['saveandcontinue'] = 'Lagre og fortsett redigeringen';
$string['saveandpreview'] = 'Lagre og forhåndsvis';
$string['saveandshownext'] = 'Lagre og vis neste';
$string['search:activity'] = 'Workshop - aktivitetsinformasjon';
$string['selfassessmentdisabled'] = 'Egenvurdering er deaktivert';
$string['showingperpage'] = 'Viser {$a} elementer per side';
$string['showingperpagechange'] = 'Endre...';
$string['someuserswosubmission'] = 'Det er minst en forfatter som ikke har levert inn arbeidet sitt ennå';
$string['sortasc'] = 'Stigende sortering';
$string['sortdesc'] = 'Synkende sortering';
$string['strategy'] = 'Karakterstrategi';
$string['strategy_help'] = 'Karakterstrategien bestemmer hvilket evalueringsskjema som skal brukes og metoden for å vurdere innleveringer. Det er fire valg:

* Akkumulativ karaktersetting - Kommentarer og en karakter blir gitt på bestemte aspekter
* Kommentarer - Kommentarer blir gitt på bestemte aspekter, men det gis ingen karakter.
* Antall feil - Kommentarer og en Ja / Nei vurdering blir gitt på bestemte påstander.
* Rubrikk - En nivåbasert vurdering blir gitt basert på bestemte kriterier.';
$string['strategyhaschanged'] = 'Karakterstrategien for workshopen er endret siden dette skjemaet ble åpnet for redigering.';
$string['submission'] = 'Innlevering';
$string['submissionattachment'] = 'Vedlegg';
$string['submissionby'] = 'Innlevert av {$a}';
$string['submissioncontent'] = 'Innleveringsinnhold';
$string['submissiondeleteconfirm'] = 'Er du sikker på at du ønsker å slette følgende innlevering?';
$string['submissiondeleteconfirmassess'] = 'Er du sikker på at du ønsker å slette følgende innlevering? Merk at dette også vil slette {$a->count} vurderinger knyttet til denne innleveringen, noe som kan påvirke anmeldernes karakterer.';
$string['submissionend'] = 'Slutt på innleveringer';
$string['submissionendbeforestart'] = 'Innleveringsfristen kan ikke være før datoen det åpnes for innlevering';
$string['submissionenddatetime'] = 'Frist for innlevering:  {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} innleveringsfrist';
$string['submissionendswitch'] = 'Gå over til den neste fasen etter innleveringsfristen';
$string['submissionendswitch_help'] = 'Hvis innleveringsfristen er angitt og denne boksen er merket av, går workshopen automatisk over til vurderingsfasen etter innleveringsfristen.

Hvis du aktiverer denne funksjonen, anbefales det at du setter opp metoden planlagt fordeling også. Hvis innleveringene ikke er fordelt, kan ikke evalueringen starte selv om workshopen er i vurderingsfasen.';
$string['submissiongrade'] = 'Karakter for innlevering';
$string['submissiongrade_help'] = 'Denne innstillingen angir maksimum karakter som kan oppnås for innleveringen.';
$string['submissiongradeof'] = 'Karakter for innlevering (av {$a})';
$string['submissionlastmodified'] = 'List endret';
$string['submissionrequiredcontent'] = 'Du må enten skrive inn tekst eller legge ved en fil';
$string['submissionrequiredfile'] = 'Du må enten skrive inn tekst eller legge ved en fil';
$string['submissionsettings'] = 'Innleveringsinnstillinger';
$string['submissionsreport'] = 'Workshop innleveringsrapport';
$string['submissionstart'] = 'Innleveringer starter';
$string['submissionstartdatetime'] = 'Åpen for innleveringer fra  {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} åpnes for innleveringer';
$string['submissiontitle'] = 'Tittel';
$string['submissiontypedisabled'] = 'Denne innleveringstypen er dektivert for denne workshopen';
$string['submissiontypefileavailable'] = 'Filvedlegg<span class="accesshide"> tilgjengeling</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Filvedlegg </span>Påkrevd';
$string['submissiontypes'] = 'Innleveringstyper';
$string['submissiontypetextavailable'] = 'Online tekst<span class="accesshide"> tilgjengelig</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Online tekst </span>Påkrevd';
$string['submittednotsubmitted'] = 'Innlevert ({$a->submitted}) / ikke innlevert ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Fordelingsmetode for innleveringer';
$string['subplugintype_workshopallocation_plural'] = 'Fordelingsmetoder for innleveringer';
$string['subplugintype_workshopeval'] = 'Metode for endelig karaktersetting';
$string['subplugintype_workshopeval_plural'] = 'Metoder for endelig karaktersetting';
$string['subplugintype_workshopform'] = 'Strategi for karaktersetting';
$string['subplugintype_workshopform_plural'] = 'Strategier for karaktersetting';
$string['switchingphase'] = 'Fasebytte';
$string['switchphase'] = 'Bytt fase';
$string['switchphase10'] = 'Bytt til oppsettsfasen';
$string['switchphase10info'] = 'Du skal nå gjøre endelige vurderinger basert på studentenes vurderinger av hverandres arbeider. I denne fasen kan ikke brukerne endre på innleveringer eller vurderinger. Lærere kan bruke karakterevaluerings-verktøyene til å beregne endelig karakter og gi tilbakemelding til studentene.';
$string['switchphase20'] = 'Bytt til innleveringsfasen';
$string['switchphase20info'] = 'Du er i ferd med å bytte fase workshopen til <strong>Innleveringsfasen</strong>. Studenter kan levere inn egne arbeider i denne fasen (innenfor de datoer som er satt - hvis satt). Lærere kan fordele innleveringer for medstudent vurdering.';
$string['switchphase30'] = 'Bytt til vurderingsfasen';
$string['switchphase30auto'] = 'Workshopen går automatisk over til vurderingsfasen etter {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Du er i ferd med å bytte fase workshopen til <strong>Vurderingsfasen</strong>. I denne fasen kan medstudenter vurdere innleveringer de er blitt tildelt (innenfor de datoer som er satt - hvis satt).';
$string['switchphase40'] = 'Bytt til evalueringsfasen';
$string['switchphase40info'] = 'Du er i ferd med å bytte workshopens fase til <strong>Karakterevaluerings-fasen</strong>. I denne fasen kan ikke brukerne endre på innleveringer eller vurderinger. Lærere kan bruke karakterevaluerings-verktøyene til å beregne endelig karakter og gi tilbakemelding til vurdererne.';
$string['switchphase50'] = 'Steng workshop';
$string['switchphase50info'] = 'Du er i ferd med å lukke workshopen. Dette vil resultere i at beregnede karakterer overføres til karakterboken. Studenter kan se på egne innleveringer og vurderingene som er gitt.';
$string['switchphaseauto'] = 'Byttet har blitt planlagt';
$string['switchphasenext'] = 'Bytt til neste fase';
$string['taskassesspeers'] = 'Vurder medstudenter';
$string['taskassesspeersdetails'] = 'totalt: {$a->total}<br />ventende: {$a->todo}';
$string['taskassessself'] = 'Vurder deg selv';
$string['taskconclusion'] = 'Oppgi en konklusjon for aktiviteten';
$string['taskdone'] = 'Oppgave fullført';
$string['taskfail'] = 'Oppgave mislyktes';
$string['taskinfo'] = 'Oppgaveinformasjon';
$string['taskinstructauthors'] = 'Angi innleveringsinstrukser';
$string['taskinstructreviewers'] = 'Angi vurderingsinstrukser';
$string['taskintro'] = 'Angi beskrivelse for workshopen';
$string['tasksubmit'] = 'Send inn arbeidet ditt';
$string['tasktodo'] = 'Oppgaver som må gjøres';
$string['toolbox'] = 'Workshop verktøykasse';
$string['undersetup'] = 'Workshopen er i ferd med å settes opp. Vennligst vent til den har skiftet til neste fase.';
$string['useexamples'] = 'Bruk eksempler';
$string['useexamples_desc'] = 'Eksempelinnleveringer er lagt til for øving i vurdering.';
$string['useexamples_help'] = 'Dersom aktivert kan brukere forsøke seg på vurdering av en eller flere innleveringer og sammenligne vurderingene med en referansevurdering. Karakteren i denne øvingen teller ikke i endelig karakter.';
$string['usepeerassessment'] = 'Vurdering av medstudenter';
$string['usepeerassessment_desc'] = 'Studenter kan vurdere andres arbeider';
$string['usepeerassessment_help'] = 'Dersom aktivert, kan en bruker til tildelt innleveringer for vurdering fra andre brukere, og vil motta en karakter for vurderingen i tillegg til en karakter for egen innlevering.';
$string['userdatecreated'] = 'innlevert  <span>{$a}</span>';
$string['userdatemodified'] = 'modifisert <span>{$a}</span>';
$string['userplan'] = 'Workshop planlegger';
$string['userplan_help'] = 'Workshop-planleggeren vser alle faser i aktiviteten og lister opp oppgavene for hver fase. Gjeldende fase utheves og fullførte oppgaver markeres med en hake.';
$string['userplanaccessibilityskip'] = 'Fortsett til nåværende oppgaver';
$string['userplanaccessibilitytitle'] = 'Workshopens tidslinje med {$a} faser';
$string['userplancurrentphase'] = 'Nåværende fase';
$string['useselfassessment'] = 'Bruk egenvurdering';
$string['useselfassessment_desc'] = 'Studenter kan vurdere eget arbeid';
$string['useselfassessment_help'] = 'Dersom aktivert, kan en bruker tildeles egen innlevering for vurdering og vil motta en karakter for vurderingen i tillegg til en karakter for innleveringen.';
$string['viewworkshopsummary'] = 'Vis workshop-oppsummering';
$string['weightinfo'] = 'Vekting: {$a}';
$string['withoutsubmission'] = 'Medstudent uten egen innlevering';
$string['workshop:addinstance'] = 'Legg til en ny workshop';
$string['workshop:allocate'] = 'Fordel innleveringer for vurdering';
$string['workshop:deletesubmissions'] = 'Slett innleveringer';
$string['workshop:editdimensions'] = 'Endre vurderingsskjemaer';
$string['workshop:exportsubmissions'] = 'Eksporter innleveringer';
$string['workshop:ignoredeadlines'] = 'Ignorer tidsrestriksjoner';
$string['workshop:manageexamples'] = 'Administrere eksempelinnleveringer';
$string['workshop:overridegrades'] = 'Overstyr beregnede karakterer';
$string['workshop:peerassess'] = 'Medstudentvurdering';
$string['workshop:publishsubmissions'] = 'Publiser innleveringer';
$string['workshop:submit'] = 'Send inn';
$string['workshop:switchphase'] = 'Bytt fase';
$string['workshop:view'] = 'Vis Workshop';
$string['workshop:viewallassessments'] = 'Vis alle vurderinger';
$string['workshop:viewallsubmissions'] = 'Vis alle innleveringer';
$string['workshop:viewauthornames'] = 'Vis forfatternavn';
$string['workshop:viewauthorpublished'] = 'Vis forfattere av publiserte innsendinger';
$string['workshop:viewpublishedsubmissions'] = 'Vis publiserte innleveringer';
$string['workshop:viewreviewernames'] = 'Vis vurderernes navn';
$string['workshopname'] = 'Workshop navn';
$string['yourassessmentfor'] = 'Din vurdering for {$a}';
$string['yourgrades'] = 'Dine karakterer';
$string['yoursubmission'] = 'Din innlevering';
