<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'no', version '3.8'.
 *
 * @package     webservice
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Unntak fra tilgangskontroll';
$string['actwebserviceshhdr'] = 'Aktiv webtjenesteprotokoller';
$string['addaservice'] = 'Legg til tjeneste';
$string['addcapabilitytousers'] = 'Sjekk brukeradgang';
$string['addcapabilitytousersdescription'] = 'Brukere bør ha ha to rettigheter: webservice:createtoken med tilsvarende rettigheter, f.eks. webservice/rest:use, webservice/soap:use. For å oppnå dette, opprett en webtjeneste-rolle med disse rettighetene tillatt og tildel rollen som systemrolle til webtjeneste-brukeren.';
$string['addfunction'] = 'Legg til funksjon';
$string['addfunctionhelp'] = 'Velg funksjon å legge til tjenesten';
$string['addfunctions'] = 'Legg til funksjoner';
$string['addfunctionsdescription'] = 'Velg påkrevde funksjoner for den nylig opprettede tjenesten.';
$string['addrequiredcapability'] = 'Tildel/Fradel påkrevd rettighet';
$string['addservice'] = 'Legg til en ny tjeneste:  {$a->name} (id: {$a->id})';
$string['addservicefunction'] = 'Legg til funksjoner i tjenesten "{$a}"';
$string['allusers'] = 'Alle brukere';
$string['apiexplorer'] = 'API utforsker';
$string['apiexplorernotavalaible'] = 'API utforskeren er ikke tilgjengelig ennå';
$string['arguments'] = 'Argumenter';
$string['authmethod'] = 'Autentiseringsmetode';
$string['callablefromajax'] = 'Kallbart fra AJAX';
$string['cannotcreatetoken'] = 'Ingen tillatelse til å opprette webtjeneste-token for tjeneste {$a}.';
$string['cannotgetcoursecontents'] = 'Kan ikke hente opp kursinnhold';
$string['checkusercapability'] = 'Sjekk brukerrettigheter';
$string['checkusercapabilitydescription'] = 'Brukeren burde ha passende rettigheter i forhold til benyttet protokoll, f.eks. webservice/rest:use, webservice/soap:use. For å få til dette må du lage en webtjenesterolle med protokollrettigheter og tildele den til webtjenestebrukeren som en systemrolle.';
$string['configwebserviceplugins'] = 'Av sikkerhetsgrunner bør du bare aktivere de protokollerne som trengs.';
$string['context'] = 'Kontekst';
$string['createservicedescription'] = 'En tjeneste er et sett av webtjenestefunksjoner. Du kan tillate brukeren tilgang til en ny webtjeneste. På siden <strong>Legg til tjeneste</strong> haker du av for "Aktiver" og "Autoriserte brukere"-valgene. Velg "Ingen påkrevd rettighet".';
$string['createserviceforusersdescription'] = 'En tjeneste er et sett av webtjenestefunksjoner. Du kan tillate brukeren tilgang til en ny webtjeneste. På siden <strong>Legg til tjeneste</strong> haker du av for "Aktiver" og fjern avmerking for  "Autoriserte brukere". Velg "Ingen påkrevd rettighet".';
$string['createtoken'] = 'Opprett token';
$string['createtokenforuser'] = 'Opprett et token for en bruker';
$string['createtokenforuserdescription'] = 'Opprett et token for webtjenestebrukeren.';
$string['createuser'] = 'Opprett en bestemt bruker';
$string['createuserdescription'] = 'En webtjenestebruker kreves for å representere systemet som kontrollerer Moodle.';
$string['criteriaerror'] = 'Mangler tillatelse til å søke på kriterier.';
$string['default'] = 'Standard til "{$a}"';
$string['deleteaservice'] = 'Slett tjeneste';
$string['deleteservice'] = 'Slett denne tjenesten:  {$a->name} (id: {$a->id})';
$string['deleteserviceconfirm'] = 'Sletting av en tjeneste vil også slette token som er relatert til denne tjenesten. Vil du virkelig slette den eksterne tjenesten "{$a}"?';
$string['deletetokenconfirm'] = 'Ønsker du virkelig å slette dette webtjenestetoken for <strong>{$a->user}</strong> på tjenesten <strong>{$a->service}</strong>?';
$string['disabledwarning'] = 'Alle webtjenesteprotokoller er deaktivert.  Du finner "Aktiver webtjenester"-innstillingen under Avanserte funksjoner.';
$string['doc'] = 'Dokumentasjon';
$string['docaccessrefused'] = 'Du har ikke rett til å se dokumentasjonen for dette tokenet.';
$string['documentation'] = 'webtjeneste dokumentasjon';
$string['downloadfiles'] = 'Kan laste ned filer';
$string['downloadfiles_help'] = 'Hvis denne funksjonen er aktivert, kan brukeren laste ned filer med sikkerhetsnøklene sine. Dette gjelder selvfølgelig bare filer som de har tilgang til å laste ned på portalen.';
$string['editaservice'] = 'Rediger tjeneste';
$string['editservice'] = 'Endre tjenesten:  {$a->name} (id: {$a->id})';
$string['enabled'] = 'Slått på';
$string['enabledocumentation'] = 'Slå på utviklerdokumentasjon';
$string['enabledocumentationdescription'] = 'Detaljert dokumentasjon for webtjenesten er tilgjengelig for aktiverte protokoller.';
$string['enableprotocols'] = 'Slå på protokoller';
$string['enableprotocolsdescription'] = 'Minst en protokoll bør aktiveres. Av sikkerhetsgrunner bør du ikke aktivere protokoller som ikke skal brukes.';
$string['enablews'] = 'Slå på webtjenester';
$string['enablewsdescription'] = 'Webtjenester må slås på i Avanserte innstillinger.';
$string['entertoken'] = 'Skriv inn en sikkerhetsnøkkel/token:';
$string['error'] = 'Feil: {$a}';
$string['errorcatcontextnotvalid'] = 'Du kan ikke kjøre funksjoner i kategorikonteksten (category id:{$a->catid}). Kontekstfeilmeldingen var: {$a->message}';
$string['errorcodes'] = 'Feilmelding';
$string['errorcoursecontextnotvalid'] = 'Du kan ikke kjøre funksjoner i kurskonteksten (course id:{$a->courseid}). Kontekstfeilmeldingen var: {$a->message}';
$string['errorinvalidparam'] = 'Parameteren "{$a}" var ugyldig.';
$string['errornotemptydefaultparamarray'] = 'Webtjenestens beskrivelsesparameter \'{$a}\' er en enkel eller multippel struktur. Standard kan bare være en tom mamtrise. Sjekk webtjenestebeskrivelsen.';
$string['erroroptionalparamarray'] = 'Webtjenesten beskrivelsesparameter \'{$a}\' er en enkel eller multippel struktur. Den kan ikke angis som VALUE_OPTIONAL. Sjekk webtjenestebeskrivelsen.';
$string['eventwebservicefunctioncalled'] = 'Webservice funksjonen er kontaktet';
$string['eventwebserviceloginfailed'] = 'Innlogging via webservice mislykkes';
$string['eventwebserviceservicecreated'] = 'Webservice opprettet';
$string['eventwebserviceservicedeleted'] = 'Webservice slettet';
$string['eventwebserviceserviceupdated'] = 'Webservice oppdatert';
$string['eventwebserviceserviceuseradded'] = 'Webservice-tjeneste bruker opprettet';
$string['eventwebserviceserviceuserremoved'] = 'Webservice-tjenestebruker fjernet';
$string['eventwebservicetokencreated'] = 'Webservice token opprettet';
$string['eventwebservicetokensent'] = 'Webservice token sendt';
$string['execute'] = 'Kjør';
$string['executewarnign'] = 'ADVARSEL: Dersom du klikker Kjør vil databasen bli modifisert og kan deretter ikke tilbakestilles på noen automatisk måte!';
$string['externalservice'] = 'Ekstern tjeneste';
$string['externalservicefunctions'] = 'Eksterne tjenestefunksjoner';
$string['externalservices'] = 'Eksterne tjenester';
$string['externalserviceusers'] = 'Eksterne tjenestebrukere';
$string['failedtolog'] = 'Logging mislykkes';
$string['filenameexist'] = 'Filnavnet eksisterer allerede: {$a}';
$string['forbiddenwsuser'] = 'Kan ikke opprette et token for en ubekreftet, slettet eller utestengt bruker eller gjest.';
$string['function'] = 'Funksjon';
$string['functions'] = 'Funksjoner';
$string['generalstructure'] = 'Generell struktur';
$string['information'] = 'Informasjon';
$string['installexistingserviceshortnameerror'] = 'En webtjeneste med kortnavnet "{$a}" finnes allerede. Kan ikke installere/oppdatere en annen webtjeneste med samme kortnavn.';
$string['installserviceshortnameerror'] = 'Kodefeil: Tjenestens kortnavn "{$a}" kan bare inneholde tall, bokstaver og tegnene understrek (_), bindestrek (-) og punktum (.).';
$string['invalidextparam'] = 'Ugyldig ekstern parameter: {$a}';
$string['invalidextresponse'] = 'Ugyldig ekstern api-respons: {$a}';
$string['invalidiptoken'] = 'Ugyldig token - IP-adressen din er ikke støttet';
$string['invalidtimedtoken'] = 'Ugyldig token - tokenet er utløpt';
$string['invalidtoken'] = 'Ugyldig token - tokenet kunne ikke finnes';
$string['iprestriction'] = 'IP-begrensninger';
$string['iprestriction_help'] = 'Brukeren vil være nødt til å kalle opp webtjenesten fra de opplistede IP-adressene (separert med komma).';
$string['key'] = 'Nøkkel';
$string['keyshelp'] = 'Nøklene brukes tl å få tilgang til din Moodle-konto fra eksterne programmer.';
$string['loginrequired'] = 'Begrens til innloggede brukere';
$string['manageprotocols'] = 'Administrere protokoller';
$string['managetokens'] = 'Administrere token';
$string['missingcaps'] = 'Manglende rettigheter';
$string['missingcaps_help'] = 'Oversikt over påkrevde rettigheter for tjenesten som valgte brukere ikke innehar. Manglende rettigheter må legges til brukernes rolle for å få tilgang til tjenesten.';
$string['missingpassword'] = 'Manglende passord';
$string['missingrequiredcapability'] = 'Rettigheten {$a} er nødvendig.';
$string['missingusername'] = 'Manglende  brukernavn';
$string['missingversionfile'] = 'Kodefeil: Filen version.php mangler for komponenten {$a}';
$string['nameexists'] = 'Dette navnet er allerede i bruk av en annen service';
$string['nocapabilitytouseparameter'] = 'Brukeren har ikke den påkrevde rettigheten til å bruke innstillingen {$a}';
$string['nofunctions'] = 'Denne tjenesten har ingen funksjoner';
$string['norequiredcapability'] = 'Nødvendig rettighet';
$string['notoken'] = 'Tokenet er tomt';
$string['onesystemcontrolling'] = 'Tillat et eksternt system å kontrollere Moodle.';
$string['onesystemcontrollingdescription'] = 'Følgende trinn vil hjelpe deg med å sette opp Moodles webtjeneste slik at den tillater et eksternt system å kommunisere med Moodle. Disse trinnene vil også sette opp den anbefalte tokenbaserte (sikkerhetsnøkkel) autentiseringsmetoden.';
$string['onlyseecreatedtokens'] = 'Alle token kan slettes, men du kan bare se tokens du har laget selv.';
$string['operation'] = 'Operasjon';
$string['optional'] = 'Valgfritt';
$string['passwordisexpired'] = 'Passordet er utgått.';
$string['phpparam'] = 'XML-RPC (PHP-struktur)';
$string['phpresponse'] = 'XML-RPC (PHP-struktur)';
$string['postrestparam'] = 'PHP-kode for REST (POST request)';
$string['potusers'] = 'Ikke autoriserte brukere';
$string['potusersmatching'] = 'Ikke autoriserte brukere som samsvarer';
$string['print'] = 'Skriv ut alt';
$string['privacy:metadata:serviceusers'] = 'En liste med brukere som kan bruke en bestemt ekstern tjeneste';
$string['privacy:metadata:serviceusers:iprestriction'] = 'IP-restriksjon for bruk av tjenesten';
$string['privacy:metadata:serviceusers:timecreated'] = 'Data for når oppføringen ble opprettet';
$string['privacy:metadata:serviceusers:userid'] = 'ID\'en til brukeren';
$string['privacy:metadata:serviceusers:validuntil'] = 'Datoen for når autorisasjonen blir ugyldig';
$string['privacy:metadata:tokens'] = 'En oppføring med tokens som samhandler med Moodle gjennom webservicer eller mobilapplikasjon.';
$string['privacy:metadata:tokens:creatorid'] = 'IDen til brukeren som opprettet denne tokenen.';
$string['privacy:metadata:tokens:iprestriction'] = 'IP-restriksjon for bruk av token';
$string['privacy:metadata:tokens:lastaccess'] = 'Datoen tokenen sist ble brukt';
$string['privacy:metadata:tokens:privatetoken'] = 'En mer privat token som brukes til å validere enkelte operasjoner som f.eks. SSO.';
$string['privacy:metadata:tokens:timecreated'] = 'Dato for opprettelse av token';
$string['privacy:metadata:tokens:token'] = 'Brukerens token';
$string['privacy:metadata:tokens:tokentype'] = 'Tokentype';
$string['privacy:metadata:tokens:userid'] = 'ID\'en på brukeren som eier tokenen';
$string['privacy:metadata:tokens:validuntil'] = 'Datoen tokenen blir ugyldig';
$string['privacy:request:notexportedsecurity'] = 'Ikke eksportert på grunn av sikkerhetshensyn';
$string['protocol'] = 'Protokoll';
$string['removefunction'] = 'Fjern';
$string['removefunctionconfirm'] = 'Ønsker du virkelig å fjerne funksjonen "{$a->function}" fra tjenesten "{$a->service}"?';
$string['requireauthentication'] = 'Denne metoden krever autentisering med xxx tillatelse.';
$string['required'] = 'Nødvendig';
$string['requiredcapability'] = 'Nødvendig rettighet';
$string['requiredcapability_help'] = 'Dersom satt, kan bare brukere med nødvendig rettighet får tilgang til tjenesten.';
$string['requiredcaps'] = 'Nødvendig rettighet';
$string['resettokenconfirm'] = 'Ønsker du virkelig  tilbakestille webtjenestenøkkelen for  <strong>{$a->user}</strong> på tjenesten <strong>{$a->service}</strong>?';
$string['resettokenconfirmsimple'] = 'Vil du virkelig tilbakestille denne nøkkelen? Alle lagrede lenker som inneholder den gamle nøkkelen vil ikke virke lenger.';
$string['response'] = 'Respons';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST (POST parametre)';
$string['restoredaccountresetpassword'] = 'Den gjenopprettede kontoen må tilbakestille passordet før den kan motta et token.';
$string['restparam'] = 'REST (POST parametre)';
$string['restrictedusers'] = 'Bare autoriserte brukere';
$string['restrictedusers_help'] = 'Denne innstillingen bestemmer hvorvidt alle brukere med tillatelse til å  opprette en webtjeneste skal kunne generere en token for denne tjenesten via deres sikkerhetsside eller om det bare er autoriserte brukere som kan gjøre dette.';
$string['securitykey'] = 'Sikkerhetsnøkkel (token)';
$string['securitykeys'] = 'Sikkerhetsnøkler';
$string['selectauthorisedusers'] = 'velg autoriserte brukere';
$string['selectedcapability'] = 'Valgte';
$string['selectedcapabilitydoesntexit'] = 'Gjeldende sett med nødvendig rettighet ({$a}) eksisterer ikke lenger. Vennligst endre den og lagre endringene.';
$string['selectservice'] = 'Velg en tjeneste';
$string['selectspecificuser'] = 'Velg en bestemt bruker';
$string['selectspecificuserdescription'] = 'Legg til webtjenestebrukeren som en autorisert bruker.';
$string['service'] = 'Tjeneste';
$string['servicehelpexplanation'] = 'En tjeneste er et sett av funksjoner. En tjeneste kan tillates tilgang til fra alle brukere eller bestemte brukere.';
$string['servicename'] = 'Tjenestenavn';
$string['servicenotavailable'] = 'Webtjenesten er ikke tilgjengelig (den finnes ikke eller så er den deaktivert)';
$string['servicerequireslogin'] = 'Webservicen er ikke tilgjengelig- (Sesjon har blott logget ut eller er utløpt)';
$string['servicesbuiltin'] = 'Innebygged tjeneste';
$string['servicescustom'] = 'Egendefinert tjeneste';
$string['serviceusers'] = 'Autoriserte brukere';
$string['serviceusersettings'] = 'Brukerinnstillinger';
$string['serviceusersmatching'] = 'Autoriserte brukere som samsvarer';
$string['serviceuserssettings'] = 'Endre innstillinger for autoriserte brukere';
$string['shortnametaken'] = 'Kortnavn er allerde i bruk for en annen webservice ({a})';
$string['simpleauthlog'] = 'Logg inn via enkel autorisering';
$string['step'] = 'Trinn';
$string['supplyinfo'] = 'Mer informasjon';
$string['testauserwithtestclientdescription'] = 'Simulerer ekstern tilgang til tjenesten via webtjenestens testklient. Før du gjør dette, logg inn som en brukere med rettigheten moodle/webservice:createtoken og hent en sikkerhetsnøkkel (token) via innstillingene i Min profil. Du vil trenge dette tokenet i testklienten. I testklienten - velg en aktivert protokoll med token-autentisering.

<strong>ADVARSEL: Funksjonen du tester vil BLI UTFØRT for denne brukeren, så vær forsiktig med hva du velger å teste!</strong>';
$string['testclient'] = 'Testklient for webtjenester';
$string['testclientdescription'] = '* Webtjenstens testklient <strong>UTFØRER</strong> funksjonene <strong>på ordentlig</strong>. Ikke test funksjoner som du ikke kjenner.<br />
* Alle eksisterende webtjenestefunksjoner er ennå ikke implementert i testklienten. <br />
* Dersom du skal sjekke at brukere ikke har tilgang til bestemte funksjoner, kan du teste noen funksjoner du ikke har tillatt.<br />
* For å se bedre feilmeldinger bør du slå på debugging <strong>{$a->mode}</strong> i {$a->atag}<br/>.';
$string['testwithtestclient'] = 'Test tjenestene';
$string['testwithtestclientdescription'] = 'Simulerer tilgang til tjenesten ved å bruke testklienten for webtjenester. Bruk en aktivert protokoll med token autentisering. <strong>ADVARSEL: Funksjonen du tester vil BLI UTFØRT for denne brukeren, så vær forsiktig med hva du velger å teste!</strong>';
$string['token'] = 'Token';
$string['tokenauthlog'] = 'Token autentisering';
$string['tokencreatedbyadmin'] = 'Kan bare tilbakestilles av en administrator (*)';
$string['tokencreator'] = 'Oppretter';
$string['unknownoptionkey'] = 'Ukjent valgnøkkel ({$a})';
$string['unnamedstringparam'] = 'En strenginnstilling har ikke navn.';
$string['updateusersettings'] = 'Oppdater';
$string['uploadfiles'] = 'Kan laste opp filer';
$string['uploadfiles_help'] = 'Hvis aktivert, kan en bruker laste opp filer med egne sikkerhetsnøkler til private filområder eller et område for midlertidige filer. Filkvoter vil fortsatt gjelde.';
$string['userasclients'] = 'Brukere som klienter med token';
$string['userasclientsdescription'] = 'Følgende trinn vil hjelpe deg å sette opp Moodle webtjenester for brukere som klienter. Disse trinnene er også til hjelp når du skal sette opp den anbefalte token (sikkerhetsnøkkel) autoriseringsmetoden. I dette brukstilfellet, skal brukeren generere sin token fra siden for sikkerhetsnøkler i innstillingene sine';
$string['usermissingcaps'] = 'Manglende rettigheter: {$a}';
$string['usernameorid'] = 'Brukernavn/bruker-ID';
$string['usernameorid_help'] = 'Skriv inn brukernavn eller bruker-ID';
$string['usernameoridnousererror'] = 'Fant ingen brukere med dette brukernavnet/denne bruker-IDen';
$string['usernameoridoccurenceerror'] = 'Fant flere brukere med dette brukernavnet. Vennligst oppgi bruker-ID.';
$string['usernotallowed'] = 'Brukeren har ikke tilgang til denne tjenesten. Først må du tillate denne brukeren på {$a}\'s administrasjonsside for tillatte brukere.';
$string['userservices'] = 'Brukertjenester: {$a}';
$string['usersettingssaved'] = 'Brukerinnstillingene lagret';
$string['validuntil'] = 'Gyldig til';
$string['validuntil_help'] = 'Dersom angitt vil tjenesten bli deaktivert for denne brukeren etter denne datoen.';
$string['webservice'] = 'Webtjeneste';
$string['webservices'] = 'Webtjenester';
$string['webservicesoverview'] = 'Oversikt';
$string['webservicetokens'] = 'Webtjeneste token';
$string['wrongusernamepassword'] = 'Feil brukernavn eller passord';
$string['wsaccessuserdeleted'] = 'Nektet webtjenestetilgang for slettet brukernavn: {$a}';
$string['wsaccessuserexpired'] = 'Nektet webtjenestetilgang for brukernavn med utgått passord: {$a}';
$string['wsaccessusernologin'] = 'Nektet webtjenestetilgang for brukernavn med nologin-autentisering: {$a}';
$string['wsaccessusersuspended'] = 'Nektet webservice-tilgang for utestengt brukernavn: {$a}';
$string['wsaccessuserunconfirmed'] = 'Nektet webtjenestetilgang for ikke bekreftet brukernavn: {$a}';
$string['wsclientdoc'] = 'Moodle dokumentasjon for webtjenesteklienten';
$string['wsdocapi'] = 'API-dokumentasjon';
$string['wsdocumentation'] = 'Webtjeneste dokumentasjon';
$string['wsdocumentationdisable'] = 'Webtjenestedokumentasjonen er deaktivert.';
$string['wsdocumentationintro'] = 'For å opprette en klient råder vi deg til å lese {$a->doclink}';
$string['wsdocumentationlogin'] = 'eller skriv inn ditt brukernavn og passord for webtjenesten: ';
$string['wspassword'] = 'Passord for webtjenesten';
$string['wsusername'] = 'Brukernavn for webtjenesten';
