<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_mobile', language 'no', version '3.8'.
 *
 * @package     tool_mobile
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adodbdebugwarning'] = 'ADOdb debugging er aktivert. Det burde vært deaktivert i den eksterne databaseautentiseringen eller databasepåmeldingsmodulen.';
$string['androidappid'] = 'Android-appens unike identifikator.';
$string['androidappid_desc'] = 'Denne innstillingen bør bare endres om du har en skreddersydd Android-app.';
$string['apppolicy'] = 'URL til appens retningslinjer';
$string['apppolicy_help'] = 'URLen til retningslinjene for appens brukere som vises på "Om"-siden i appen. Dersom feltet er tomt vil portalens retningslinjer bl';
$string['apprequired'] = 'Denne funksjonaliteten er kun tilgjengelig i Moodle Mobile og Moodle Desktop';
$string['autologinkeygenerationlockout'] = 'Autologin nøkkelgenerering er blokkert. du må vente minst 6 minutter mellom hver forespørsel.';
$string['autologinnotallowedtoadmins'] = 'Det er ikke tillatt for portaladministratorer å bruke autologin.';
$string['cachedef_plugininfo'] = 'Dette lagrer listenfor moduler med mobiltillegg.';
$string['clickheretolaunchtheapp'] = 'Kikk her hvis appen ikke åpnes automatisk';
$string['configmobilecssurl'] = 'En CSS-fil til å tilpasse brukergrensesnittet på mobilappen din.';
$string['customlangstrings'] = 'Språktilpasninger';
$string['customlangstrings_desc'] = 'Ord og uttrykk i appen kan defineres her. Legg til hver språkstreng du ønsker å definere på en egen linje med formatet: strengidentifikator, egendefinert språkstreng og språkkode, seperarert med pipetegn. For eksempel:
<pre>
mm.user.student|Learner|en
mm.user.student|Aprendiz|es
</pre>
For en komplett liste med strengidentifikatorer bør du sjekke dokumentasjonen.';
$string['custommenuitems'] = 'Egendefinerte menyelementer';
$string['custommenuitems_desc'] = 'Ytterligere elementer kan legges til appens hovedmeny ved å spesifisere dem her. Skriv inn hvert tilpassede menyelement på en ny linje med format: varetekst, lenke-URL, link-åpningsmetode og språkkode (valgfritt, for å vise elementet til brukere av bare det spesifiserte språket), atskilt med rørkarakterer.

Link-åpningsmetoder er: app (for kobling til en aktivitet som støttes av appen), inappbrowser (for å åpne en kobling i en nettleser uten å forlate appen), nettleser (for å åpne linken i enhetens standard nettleser utenfor appen) og innebygd (for å vise lenken i en iframe på en ny side i appen).

Når elementer mangler en oversettelse for et gitt språk, vil de bruke andre språk som tilbakelevering med mindre "_ bare" er lagt til språkkoden.

For eksempel:
<Pre>
Apphjelp | https: //someurl.xyz/help | inappbrowser
Karakterene mine | https: //someurl.xyz/local/mygrades/index.php | innebygd | no
Mis calificaciones | https: //someurl.xyz/local/mygrades/index.php | innebygd | es
Du vil bare se dette på engelsk | https: //someurl.xyz/english | nettleser | en_only
</ Pre>';
$string['darkmode'] = 'Mørk modus';
$string['disabledfeatures'] = 'Deaktiverte funksjoner';
$string['disabledfeatures_desc'] = 'Her kan du velge hvilke funksjoner du ønsker å deaktiverer i mobilappen for din portal. Du bør være klar over at noen av funksjonene som er listet opp her allerede kan være deaktivert via andre portalinnstillinger. Du må logge ut og inn igjen av appen for å se endringene.';
$string['displayerrorswarning'] = 'Visning av debugmeldinger er aktivert. Det bør være deaktivert.';
$string['downloadcourse'] = 'Last ned kurs';
$string['downloadcourses'] = 'Last ned kurs';
$string['enablesmartappbanners'] = 'Aktiver App-bannere';
$string['enablesmartappbanners_desc'] = 'Hvis aktivert, vil et banner med reklame for mobilappen vises når portalen besøkes via en nettleser på mobil eller nettbrett.';
$string['forcedurlscheme'] = 'Hvis du vil tillate at bare den tilpassede appen åpnes via et nettleservindu, angir du URL-skjemaet her. Hvis du bare vil tillate den offisielle appen, angir du standardverdien. La feltet være tomt hvis du vil tillate alle apper.';
$string['forcedurlscheme_key'] = 'URL-skjema';
$string['forcelogout'] = 'Tving utlogging';
$string['forcelogout_desc'] = 'Hvis aktivert vil valget "Bytt portal" i appen erstattes med "Log ut". Dette gjør at brukeren vil logges helt ut av appen. De må da skrive inn passordet sitt på nytt neste gang de ønsker å få tilgang til portalen.';
$string['getmoodleonyourmobile'] = 'Hent mobilappen';
$string['h5poffline'] = 'Vis H5P innhold offline';
$string['httpsrequired'] = 'HTTPS påkrevd';
$string['insecurealgorithmwarning'] = 'Det ser ut som om HTTPS-sertifikatet bruker en usikker algoritme for signering (SHA-a). Vennligst prøv å oppdatere sertifikatet.';
$string['invalidcertificatechainwarning'] = 'Sertifikatkjeden er ugyldig.';
$string['invalidcertificateexpiredatewarning'] = 'HTTPS-sertifikatet for denne portalen er utløpt.';
$string['invalidcertificatestartdatewarning'] = 'Det ser ut til at HTTPS-sertifikatet for denne portalen ikke er gyldig fordi det har en fremtidig dato som startdato';
$string['invalidprivatetoken'] = 'Ugyldig privat token. Token skal ikke være tom eller sendt via en GET parameter.';
$string['invaliduserquotawarning'] = 'Brukerkvoten (userquota) er satt til et ugyldig tall. Det må settes til et gyldig tall (heltall) i portalens sikkerhetsinnstillinger.';
$string['iosappid'] = 'iOS-appens unike identifikator';
$string['iosappid_desc'] = 'Du trenger bare endre denne verdien om du har en egendefinert iOS-app';
$string['loginintheapp'] = 'Via appen';
$string['logininthebrowser'] = 'Via et nettleservindu (for SSO-moduler)';
$string['loginintheembeddedbrowser'] = 'Via et innebygd nettleservindu (for SSO-moduler)';
$string['mainmenu'] = 'Hovedmeny';
$string['minimumversion'] = 'Hvis en appversjon er spesifisert (3.8.0 eller nyere), vil brukere som bruker en eldre appversjon bli bedt om å oppgradere appen sin før de får tilgang til nettstedet.';
$string['minimumversion_key'] = 'Minimum appversjon kreves';
$string['mobileapp'] = 'Mobilapp';
$string['mobileappconnected'] = 'Koblet til mobilappen';
$string['mobileappearance'] = 'Mobilvisning';
$string['mobileappenabled'] = 'Denne portalen har aktivert tilgangen via mobilappen. <br /><a href="{$a}">Last ned mobilappen</a>.';
$string['mobileauthentication'] = 'Mobilautentisering';
$string['mobilecssurl'] = 'CSS';
$string['mobilefeatures'] = 'Mobilfunksjoner';
$string['mobilenotificationsdisabledwarning'] = 'Mobilvarsler er ikke aktivert. De skal være aktivert i Varslingsinnstillinger.';
$string['mobilesettings'] = 'Mobilinnstillinger';
$string['moodleappsportalfeatureswarning'] = 'Vennligst merk at noen funksjoner kan være begrenset avhengig av ditt Moodle app abonnement. For detaljer, besøk <a href="{$a}" target="_blank">Moodle Apps Portal</a>.';
$string['oauth2identityproviders'] = 'OAuth 2 identitstilbydere';
$string['offlineuse'] = 'Offline bruk';
$string['pluginname'] = 'Moodle appverktøy';
$string['pluginnotenabledorconfigured'] = 'Modulen er ikke aktivert eller konfigurert';
$string['privacy:metadata:core_userkey'] = 'Brukernes nøkler brukt til å opprette autologinnøkkel for gjeldende bruker.';
$string['privacy:metadata:preference:tool_mobile_autologin_request_last'] = 'Datoen for siste autologinnøkkelforespørsel. Det kreves en ventetid på 6 minutter mellom hver forespørsel.';
$string['readingthisemailgettheapp'] = 'Leser du dette i en epost? <a href="{$a}">Last ned Moodle Mobile og motta varslinger på din mobil enhet</a>.';
$string['remoteaddons'] = 'Eksterne tillegsmoduler';
$string['responsivemainmenuitems'] = 'Responsive menyelementer';
$string['selfsignedoruntrustedcertificatewarning'] = 'Det ser ut til at HTTPS-sertifikatet er egensignert eller usikkert. Mobilappen fungerer bare for sikrede portaler.';
$string['setuplink'] = 'Nedlastingsside for appen.';
$string['setuplink_desc'] = 'URL til side med alternativer for å laste ned mobilappen fra App Store og Google Play. Applenken for nedlasting av sider vises i bunnteksten og i brukerprofilen. La være tomt for ikke å vise en kobling.';
$string['smartappbanners'] = 'App-bannere';
$string['typeoflogin'] = 'Innloggingsmetode';
$string['typeoflogin_desc'] = 'Dersom portalen bruker en SSO autentiseringsmetode, velg enten via nettleservindu eller via en innbygd nettleser. En innbygd nettleser gir en bedre brukeropplevelse, men det fungerer ikke med alle SSO-moduler.';
