<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'no', version '3.8'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutdemosite'] = 'Vår demonettsted er en full Moodle installasjon med noen eksempelkurs du kan teste ut som Lærer, Student og Administrator. I bekymre deg for om noe blir ødelagt - hele installasjonen blir resatt hver time.';
$string['aboutdemositetitle'] = 'Demonstrasjonsnettsted';
$string['aboutintro'] = 'Moodle er et åpen kildekode administrasjonssystem (CMS), også kjent som Læringsplattform (LMS) eller Virtuelt Læringsmiljø (VLE). Systemet har blitt meget populært blant utdannere verden over som et effektivt verktøy å lage dynamiske nettsteder for læring for studentene. Systemet må installeres på en webserver - enten en servere dere har selv eller på et webhotell.';
$string['aboutoverview'] = '<p>Moodleprosjektets hovedfokus har alltid vært å gi utdannere de beste tilgjengelige verktøy for å administrere og tilby læring via nett, men det er mange måter å bruke Moodle på:<7p>
<ul>
<li>Moodle skalerer helt til veldig store installasjoner med hundretusener av studenter, men kan like godt brukes av en enkelt skole eller organisasjon/bedrift.</li>
<li>Mange institusjoner bruker Moodle til å tilby rene nettbaserte kurs, mens andre bruker Moodle i kombinasjon med ansikt til ansikt-opplæring (kombinert læring).</li>
<li>Mange av våre brukere er glade i alle de aktivitetsmodulene som finnes (som Forum, Wiki, Database osv) og bruker dem aktivt til å sette opp gode interaktive læringsressurser i egne kurs. Andre igjen foretrekker å bruke Moodle som plattform for levering av nettbaserte kurs over internett (som f.eks. SCORM-pakker) og evaluerer læringene gjennom innleveringer og tester.</li>
</ul>';
$string['aboutoverviewtitle'] = 'Hva er Moodle?';
$string['aboutstatistics'] = 'Moodle er gratis å laste ned og registrering er frivillig, så vi har ikke all informasjon om alle som bruker det. Likevel bruker vi det vi vet, det blir automatisk generert en del interessante grafer og tall på statistikksiden vår.';
$string['aboutstatisticsheading'] = 'Moodle statistikk';
$string['aboutstatisticstitle'] = 'Moodle.org: Moodle Statistikk';
$string['activeusers24hours'] = 'Registrerte brukere siste 24 timer:';
$string['activeuserspastmonth'] = 'Registrerte brukere siste måneden:';
$string['communityintro'] = 'Moodle har en meget stor og sammensatt brukermasse med over <a href="http://moodle.org/userpics">{$a->usercount} registrerte brukere</a> på dette Moodle-nettstedet alene. Moodle er oversatt til over <a href="http://download.moodle.org/lang16/">{$a->langcount} språl</a> i <a href="http://moodle.org/sites">{$a->countrycount} land</a> (Her finner du mer <a href="http://moodle.org/stats">statistikk</a>).';
$string['conferencecenter'] = 'Moodle konferansesenter';
$string['connectedsites'] = 'Noen Moodle-nettsteder er koblet til Moodle.org via Moodle Nettverk og da kan du logge inn direkte straks du er godkjent brukere her.';
$string['contactbugs'] = 'Du kan melde feil på Moodle programvare og alle moodle.org nettsteder ved å sende inn en feilmelding til Moodle Tracker.';
$string['contactbugstitle'] = 'Feilmelding';
$string['contactintro'] = 'Vennligst velg en av kontaktmulighetene:';
$string['contactlogin'] = 'For alle andre forespørsler, logg inn i nettstedet og deretter bruk kontaktskjemaet som fremkommer.';
$string['contactmoodlecom'] = 'For alle forespørsler som gjelder lisensiering, varemerke eller kommersielle ting, likeså Moodle utvikling, vennligst kontakt Support på <a href="http://moodle.com/">Moodle.com</a>';
$string['contactmoodlecomhelpdesk'] = 'Moodle.com Support';
$string['contactmoodlecomtitle'] = 'Moodle.com';
$string['contactmoodleorgemail'] = 'Dersom du har problemer med din moodle.org-konto, kan du sende en e-post til:';
$string['contactmoodleorglogin'] = 'Logg inn på denne siden nå';
$string['contactmoodleorgother'] = 'For alle andre spørsmål, vær vennlig å bruk kontaktskjemaet under';
$string['contactmoodleorgtitle'] = 'Moodle.org';
$string['contactsecurity'] = 'Sikkerhetstrusler kan også postes sikkert i Tracker, og gir deg muligheten til å sette korrekt sikkerhetsnivå på feilmeldingen.';
$string['contactsent'] = 'Meldingen din er sendt via e-post til Moodle Community Manager.';
$string['contactsupport'] = 'For Support på Moodle programvare, vennligst gå til vår supportside som også lister opp en rekke gode hjelp-ressurser du kan bruke.';
$string['contactsupporttitle'] = 'Support';
$string['developerlist'] = 'Totaloversikt over utviklere med skriverettigheter';
$string['developermeetings'] = 'Utviklermøter';
$string['developers'] = 'Hovedutviklingen av Moodle blir ledet av et kjerneteam hos Moodle.org, og de støttes av hundrevis av andre utviklere verden rundt. Mange av disse utviklerne er også direkte ansvarlige for en rekke moduler og tilleggsfunksjoner.';
$string['developerstitle'] = 'Utviklere';
$string['developmentdocs'] = 'All dokumentasjon på Moodle finnes i Moodle Docs - inkludert spesifikasjoner, idemyldringer, prosedyrer, standarder og ferdige brukerguider.';
$string['developmentdocstitle'] = 'Utviklerdokumentasjon';
$string['developmentintro'] = 'Vi er for en transparent og åpen utviklingsprosess som inviterer alle våre brukere til å bidra. Vi ønsker særlig velkommen PHP-programmerere, men du kan også bidra gjennom diskusjoner, testing, tilbakemelding og dokumentasjon.';
$string['developmenttracker'] = 'Alle sider ved utviklingsarbeidet (som feil, nye funksjoner og forbedringer) logges og administreres i Moodle Tracker. Du kan se hvem som jobber med hva og bidra i enhver diskusjon. Du bør alltid søke i Tracker før du foretar en henvendelse om en bestemt sak, og vennligst pass på at du <strong>stemmer</strong> på den saken du synes er viktigst å få fikset først. Din stemme bidrar til bedre prioriteringer.';
$string['donations'] = 'Moodle krever ingen finansielle forpliktelser av deg, men mange har donert noe til ett eller flere av våre prosjekter for å avhjelpe utviklingskostnadene.';
$string['donationsmoney'] = 'Du kan også bidra med pengestøtte direkte til fondet. Alle disse pengene brukes til å virkeliggjøre alle ønskene på "veikartet" til funksjoner vi alle kan bruke. For å gjøre en donasjon, vær vennlig å bruke et kredittkort, trykk Paypal-knappen under.<br /><br />Donasjoner over NOK 60/$10 kan få navnet sitt på denne siden et år. Husk å trykke "Continue/fortsett" knappen etter at du har betalt for å se skjemaet hvor du kan redigere hvor navnet ditt kommer.';
$string['donationsservices'] = 'Hvis du trenger en Moodle-tjeneste som f.eks vert, support, installasjon, spesialprogrammering, kursutvikling eller konsulenttjenester vær vennlig å kontakte en autorisert <a href="http://moodle.com/">Moodlepartner fra moodle.com</a>(du ser bannere reklamere rundt omkring på nettstedet). Partnere bidrar med en viss prosentandel av det de tjener til Utviklingsfondet til Moodle, slik at alle gagner av det.';
$string['donationstitle'] = 'Donasjoner';
$string['donationstrust'] = 'Moodle har et utviklingsfond som styres av Moodle Trust som leier inn programmerere til å arbeide med Moodle, og som også støtter utgifter til f.eks moodle.org.';
$string['downloadcore'] = 'Hovedmetoden for distribusjon er via standard pakker. De inneholder et antall moduler som vedlikeholdes av kjerneutviklerne, og fungerer på nær sagt alle plattformer med PHP og en database installert.';
$string['downloadcoretitle'] = 'Standard Moodlepakker';
$string['downloadintro'] = 'Moodle er åpen kildekode underlagt <a href="http://docs.moodle.org/en/License">GPL lisens</a>. Alt vi utvikler er gratis tilgjengelig for alle.';
$string['downloadlang'] = 'I gjeldende versjon av Moodle legger du  automatisk til nye språkpakker fra administrasjonsmenyen. I noen eldre versjoner av Moodle må du laste ned og installere nye språkpakker manuelt.';
$string['downloadlangtitle'] = 'Språkpakker';
$string['downloadlogotitle'] = 'Moodlelogoer';
$string['downloadmac'] = 'Dersom du ikke allerede har satt opp en webserver, vil denne alt-i-ett pakken være ideell for enkel installasjon av Moodle på alle Apple maskiner som kjører Mac OS X.';
$string['downloadmactitle'] = 'Moodle for Mac OS X';
$string['downloadmodules'] = 'Se gjennom vår store database over tilleggsmoduler og -komponenter som kan legges til Moodle-installasjonen din. Tilleggsmodulene gir installasjonen ekstra funksjonalitet utover kjernepakkene.';
$string['downloadmodulestitle'] = 'Moduler og plugins';
$string['downloadthemes'] = 'Moodles utseende kan endres dramatisk ved å bruke et annet design. Vi vedlikeholder en database over design som Moodle-brukere har laget og delt.';
$string['downloadthemestitle'] = 'Temaer';
$string['downloadwin'] = 'Dersom du ikke allerede har satt opp en webserver, vil denne alt-i-ett pakken gjøre det meget enkelt å installere Moodle på alle Windowsmaskiner.';
$string['downloadwintitle'] = 'Moodle for Windows';
$string['erroradminonly'] = 'Bare administratorer kan logge inn her.';
$string['erroralreadyvoted'] = 'Du har allerede stemt på {$a}';
$string['errormaxmessages'] = 'Beklager, men du kan ikke sende mer enn 3 meldinger.';
$string['errornomainnews'] = 'Kan ikke finne eller opprette et hovednyhetsforum for';
$string['errorsendingmail'] = 'Det oppstod en feil under sending av meldingen. Vennligst prøv senere, eller kontakt nettstedsadministratoren.';
$string['events'] = 'Selv om vi har spesialisert oss på nettbasert læring, er det fortsatt trivelig å komme sammen med andre! Se lenkene for mer informasjon om våre konferanser (vi kaller dem MoodleMoots) og andre arrangementer.';
$string['eventstitle'] = 'Arrangementer';
$string['frontpagewelcome1'] = 'Moodle er et kursadministrativt system ( Course Management System - CMS), også kjent som Læringsplattform (LMS) og Virtuelt læringsmiljø (VLE). Moodle er en gratis webapplikasjon som utdannere kan bruke for å lage effektive nettsteder for nettbasert læring.';
$string['frontpagewelcome2'] = 'Moodle.org er hovednettstedet hvor Moodle blir utviklet og diskutert. Vennligst bruk menyene for å utforske nettstedet og registrer deg gjerne!';
$string['frontpagewelcometitle'] = 'Velkommen til Moodle-samfunnet!';
$string['generaldeveloperforum'] = 'Generelt utviklerforum';
$string['graphpopulation'] = 'Graf over Moodleutvikling';
$string['graphregistrationmap'] = 'Moodleregistreringer kart';
$string['graphregistrationmapdesc'] = 'Top 10 fra registrerte hjemmesider i {$a} land';
$string['graphusersites'] = 'Moodle brukere i forhold til nettsteder';
$string['heroslide_link_sites'] = 'Registrerte nettsteder';
$string['jobs'] = 'Besøk vår jobb-database for informasjon om Moodle-relaterte jobber verden rundt.';
$string['moodledocs'] = 'Moodledokumentasjon';
$string['mycoursesintro'] = 'Du er påmeldt følgende "kurs" på dette nettstedet. Hver av dem inneholder ett eller flere forum.';
$string['nameabout'] = 'Om';
$string['nameaboutmoodle'] = 'Om Moodle';
$string['namecommercial'] = 'Kommersielle tjenester';
$string['namecommunity'] = 'Samfunn';
$string['namecontact'] = 'Kontakt';
$string['namedevelopment'] = 'Utvikling';
$string['namedocumentation'] = 'Dokumentasjon';
$string['namedownloads'] = 'Nedlastinger';
$string['nameevents'] = 'Arrangementer';
$string['nameforums'] = 'Forum';
$string['namemycourses'] = 'Mine kurs';
$string['namenetwork'] = 'Tilkoblede nettsteder';
$string['namenews'] = 'Nyheter';
$string['namesecurity'] = 'Sikkerhetsmeldinger';
$string['namesupport'] = 'Support';
$string['networkintro'] = 'Følgende Moodle nettsteder er tilkoblet moodle.org og bruker Moodle Nettverk. Du kan derfor logge rett inn på disse herfra.';
$string['newregistrations'] = 'Nye registreringer';
$string['noenrolledcoursesyet'] = 'Du har ennå ikke meldt deg på noen kurs på dette nettstedet';
$string['permalink'] = 'Permalink';
$string['popularissues'] = 'Mest populære saker';
$string['recentpart'] = 'Denne siden viser noen av de som bruker moodle.org i dag.';
$string['registeredsites'] = 'Det er ikke påkrevd for institusjoner å registrere bruken av Moodle, siden dette er åpen kildekode. Likevel er det mange som registrerer seg og disse kan du se her.';
$string['registeredsitestitle'] = 'Registrerte nettsteder';
$string['registereduserslastday'] = 'Nye brukere siste 24 timer:';
$string['registereduserstotal'] = 'Registrerte brukere totalt:';
$string['registrationgraphalt'] = 'Alle Moodleregistreringer oppigjennom tiden';
$string['registrationgraphdesc'] = 'Vi utfører en <a href="http://docs.moodle.org/en/Usage">normal massesjekk av hjemmesider</a> for å sjekke at de fremdeles eksisterer, så av og til kan du se reduksjoner i antallet.';
$string['registrationslast6months'] = 'Registreringer siste 6 måneder';
$string['registrationstotal'] = 'Alle nåværende registreringer';
$string['roadmap'] = 'Moodle utviklingsplan';
$string['shop'] = 'Ser du etter en måte å vise at du er en del av fellesskapet? Ta en titt på vår butikk med T-skjorter, kopper og mye annet.';
$string['statscountries'] = 'Land';
$string['statscourses'] = 'Kurs';
$string['statsenrolments'] = 'Kursinnmeldinger';
$string['statsposts'] = 'Forumposter';
$string['statsquestions'] = 'Prøvespørsmål';
$string['statsresources'] = 'Ressurser';
$string['statsteachers'] = 'Lærere';
$string['statsusers'] = 'Brukere';
$string['supportbooks'] = 'Vi vedlikeholder en liste over Moodlebøker som kan kjøpes';
$string['supportcommercial'] = 'Våre <a href="http://moodle.com/">Moodle Partnere</a> er en global gruppe av autoriserte selskaper som bidrar til finanseringen av Moodleutviklingen. De tilbyr en rekke kommersielle tjenester for Moodlebrukere verden over.';
$string['supportdocs1'] = 'Moodle Docs er et utmerket sted å starte - se spesielt på våre Ofte Spurte Spørsmål-sider (FAQ).';
$string['supportdocs2'] = 'En fin måte å få tilgang til relevant dokumentasjon er å bruke lenkene nederst på hver Moodle-side på ditt nettsted. Lenken er merket "Moodle Docs for denne siden."';
$string['supportdocsfaq'] = 'Ofte stilte spørsmål';
$string['supportdocslang'] = 'Moodle Docs på andre språk';
$string['supportforums'] = 'Våre brukere kontakter hverandre hovedsaklig via forum i kurs på dette Moodlebaserte nettstedet. Du må derfor melde deg inn i kurset for å kunne poste nye meldinger eller svare på andres. (Påmeldingen er gratis)';
$string['supportforumsenglish'] = 'Hovedsupport og utviklerdiskusjoner mellom brukere og  utviklere foregår på engelsk her:';
$string['supportforumsenglishname'] = 'Bruke Moodle';
$string['supportforumslang'] = 'Hovedforumet for Moodlere på engelsk er her:';
$string['supportforumslangname'] = 'Moodle nettkafe';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Vi har mange andre forum også, på mange språk:';
$string['supportforumslistname'] = 'Liste over alle forum';
$string['supportintro'] = 'Du er ikke alene! Det finnes mange måter å få hjelp med Moodle på hvis du trenger det.';
$string['top10sitesbycourses'] = 'Topp 10-liste ifht. kurs';
$string['top10sitesbyusers'] = 'Topp 10-liste ifht. brukere';
