<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'no', version '3.8'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = 'Legg til kategori';
$string['addcomment'] = 'Legg til kommentar';
$string['addentry'] = 'Legg til ny oppføring';
$string['addingcomment'] = 'Legg til en kommentar';
$string['alias'] = 'Nøkkelord';
$string['aliases'] = 'Synonym(er)';
$string['aliases_help'] = '<p>Hver oppførong i ordboka kan være assossiert med en liste over nøkkelord (eller aliaser).</p>

<p><b>Skriv inn hvert alias på en ny linje</b> (skal ikke skilles med komma).</p>

<p>Aliaset for et ord eller en frase kan brukes som en alternative måte for å vise til oppføringen. F.eks. om du bruker autolenking i ordbok vil aliaset også gi treff på samme måte som selve oppslagsordet.</p>';
$string['allcategories'] = 'Alle kategorier';
$string['allentries'] = 'ALLE';
$string['allowcomments'] = 'Tillat kommentarer til oppføringer';
$string['allowcomments_help'] = '<p>Det er mulig å la andre legge til kommentarer til ordbokoppføringer. </p>

<p>Du velger om dette tillates eller ikke. </p>';
$string['allowduplicatedentries'] = 'Tillat duplikate oppføringer';
$string['allowduplicatedentries_help'] = '<p>Hvis du slår dette valget på kan flere oppføringer ha samme begrepsnavn. </p>';
$string['allowprintview'] = 'Tillat utskriftsvisning';
$string['allowprintview_help'] = '<p>Brukerne kan tillates å vise utskriftsvisning av ordboka. Du kan velge mellom å slå utskriftsvisning på eller av. En lærer kan alltid  benytte utskriftsvisningen.</p>';
$string['andmorenewentries'] = 'og {$a} flere nye oppføringer.';
$string['answer'] = 'Svar';
$string['approvaldisplayformat'] = 'Format for godkjenningsvisning';
$string['approvaldisplayformat_help'] = 'Når du skal godkjenne ordbokoppslag ønsker du kanskje å bruke en litt bedre visning.';
$string['approve'] = 'Godkjenn';
$string['areaattachment'] = 'Vedlegg';
$string['areaentry'] = 'Definisjoner';
$string['areyousuredelete'] = 'Er du sikker på at du vil slette denne oppføringen?';
$string['areyousuredeletecomment'] = 'Er du sikker på at du vil slette denne kommentaren?';
$string['areyousureexport'] = 'Er du sikker på at du vil eksportere denne oppføringen til';
$string['ascending'] = 'stigende';
$string['attachment'] = 'Vedlegg';
$string['attachment_help'] = '<p>Du har muligheten til ETT filvedlegg til hver oppføring. Denne filen blir lastet opp og lagret på serveren sammen med oppføringen din.</p>

<p>Dette er en nyttig funksjon når du vil dele et bilde, en figur, pdf eller et worddokument.</p>

<p>Du kan legge ved alle slags filer, men det er sterkt anbefalt at du bruker filnavn med standard 3-bokstavers endelse som viser filtypen.  (f.eks: .doc for Word, .pdf for Adobe Acrobat-filer, .jpg eller .png for et bilde osv.) Dette gjør det mye enklere for andre å laste ned for å se vedlegget ditt.</p>

<p>Hvis du endrer på en oppføring og legger til en ny fil vil eksisterende fil bli overskrevet av den nye.</p>

<p>Hvis du endrer på en oppføring og lar vedleggsfeltet være blankt vil det opprinnelige filvedlegget beholdes.</p>';
$string['author'] = 'forfatter';
$string['authorview'] = 'Sorter etter forfatter';
$string['back'] = 'Tilbake';
$string['cachedef_concepts'] = 'Begrepslenking';
$string['cantinsertcat'] = 'Kan ikke sette inn kategori';
$string['cantinsertrec'] = 'Kan ikke sette inn oppføring';
$string['cantinsertrel'] = 'Kan ikke sette inn relatert kategoriinnlegg';
$string['casesensitive'] = 'Store og små bokstaver må stemme i denne oppføringen';
$string['casesensitive_help'] = '<P>Dette angir om store og små bokstaver må stemme når det lenkes automatisk til
disse oppføringene. </p>

<p>Eksempel: Hvis dette er slått på vil ordet "html" i et foruminnlegg IKKE bli
lenket til oppføringen i ordboken kalt "HTML".</p>';
$string['cat'] = 'kat';
$string['categories'] = 'Kategorier';
$string['category'] = 'Kategori';
$string['categorydeleted'] = 'Kategori slettet';
$string['categoryview'] = 'Sorter etter kategori';
$string['changeto'] = 'endre til {$a}';
$string['cnfallowcomments'] = 'Bestem om ordboken skal tillate kommentarer til oppføringer som standard';
$string['cnfallowdupentries'] = 'Bestem om ordboken skal tillate duplikate oppføringer som standard';
$string['cnfapprovalstatus'] = 'Bestem standard godkjenningsstatus for oppføringer lagt inn av studenter';
$string['cnfcasesensitive'] = 'Bestem om oppføringer som skal lenkes må passe med store/små bokstaver som standard';
$string['cnfdefaulthook'] = 'Velg standardvalg som skal vises når ordboken vises for første gang';
$string['cnfdefaultmode'] = 'Velg standard ramme som skal vises når ordboken vises første gang';
$string['cnffullmatch'] = 'Bestem om oppføringer som skal lenkes må passe med store/små bokstaver som standard i målteksten';
$string['cnflinkentry'] = 'Velg om oppføringer skal lenkes automatisk som standard';
$string['cnflinkglossaries'] = 'Velg om ordbøker skal lenkes automatisk som standard';
$string['cnfrelatedview'] = 'Velg visningsformat som skal brukes i automatisk lenking og visning av oppføringer';
$string['cnfshowgroup'] = 'Velg om skille mellom grupper skal vises eller ikke';
$string['cnfsortkey'] = 'Velog standard sorteringsnøkkel';
$string['cnfsortorder'] = 'Velg standard sorteringsrekkefølge';
$string['cnfstudentcanpost'] = 'Bestem om studenter kan eller ikke kan lage oppføringer som standard';
$string['cnftabs'] = 'Velg synlige faner for detteordbokformatet';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentaren er slettet.';
$string['comments'] = 'Kommentarer';
$string['commentson'] = 'Kommentar til';
$string['commentupdated'] = 'Kommentaren er oppdatert.';
$string['completionentries'] = 'Studenten må lage oppføringer:';
$string['completionentriesdesc'] = 'Deltakeren må opprette minst {$a} oppføring(er)';
$string['completionentriesgroup'] = 'Krev bidrag';
$string['concept'] = 'Begrep';
$string['concepts'] = 'Begreper';
$string['configenablerssfeeds'] = 'Denne bryteren gjør det mulig å lage RSS-matninger av alle ordbøkene. Du vil allikevel måtte slå på slike matninger manuelt i innstillingene for hver enkelt ordbok.';
$string['current'] = 'Gjeldende sortering {$a}';
$string['currentglossary'] = 'Gjeldende ordbok';
$string['date'] = 'dato';
$string['dateview'] = 'Sorter etter dato';
$string['defaultapproval'] = 'Standard godkjenningstatus';
$string['defaultapproval_help'] = '<p>Du kan bestemme om nye oppføringer fra studenter automatisk skal være
tilgjengelige for alle eller om de først må godkjennes av læreren. </p>
<p>&nbsp;</p>';
$string['defaulthook'] = 'Standard hook';
$string['defaultmode'] = 'Standard modus';
$string['defaultsortkey'] = 'Standard sorteringsnøkkel';
$string['defaultsortorder'] = 'Standard sorteringsrekkefølge';
$string['definition'] = 'Definisjon';
$string['definitions'] = 'Definisjoner';
$string['deletecategory'] = 'Slett kategri';
$string['deleteentry'] = 'Slett oppføring';
$string['deleteentrya'] = 'Slett oppføring: {$a}';
$string['deletenotenrolled'] = 'Slett oppføringer fra brukere som ikke er påmeldt';
$string['deletingcomment'] = 'Sletter kommentar';
$string['deletingnoneemptycategory'] = 'Dersom du sletter denne kategorien vil du ikke slette oppføringene den inneholder - de vil markeres som \'ikke kategorisert\'.';
$string['descending'] = 'synkende';
$string['destination'] = 'Mål for importerte oppføringer';
$string['destination_help'] = '<P>Du kan spesifisere hvor du vil importere oppføringene: </p>
<ul>
<li><strong>Gjeldende ordbok:</strong> Vil legge de importerte oppføringene til
gjeldende ordbok. </li>
<li><strong>Ny ordbok:</strong> Vil lage en ny ordbok basert på informasjonen
funnet i valgt XML-fil og vil legge oppføringene dit. </li>
</ul>';
$string['disapprove'] = 'Underkjenn';
$string['displayformat'] = 'Visningsformat';
$string['displayformat_help'] = 'Det finnes 7 visningsformater:

* Enkel ordlistestil - Ingen forfattere
vises og vedlegg vises som lenker.
* Fortløpende uten forfatter - Viser oppføringene en etter en uten noen form for skille bortsett fra \'Rediger\'-ikonet.
*Full med forfatter - En forumlignende visning som viser informasjon om forfatteren. Vedlegg vises
som lenker.
* Full uten forfatter - En forumlignende visning som ikke viser informasjon om forfatteren. Vedlegg
vises som lenker.
* Leksikon - Som \'Full med forfatter\' men vedlegg vises i oppføringen.
* Oppføringsliste - Viser begrepene som lenker i liste
* OSS - Ofte Stilte Spørsmål - Nyttig for å vise liste over ofte stilte spørsmål. Det setter automatisk
\'Spørsmål\' i feltet \'Begrep\' og \'Svar\' i feltet \'Definisjon\'.';
$string['displayformatcontinuous'] = 'Kontinuerlig uten forfatter';
$string['displayformatdefault'] = 'Bruk samme som standard visningsformat';
$string['displayformatdictionary'] = 'Enkel ordboksstil';
$string['displayformatencyclopedia'] = 'Encyclopaedia';
$string['displayformatentrylist'] = 'Oppføringsliste';
$string['displayformatfaq'] = 'OSS';
$string['displayformatfullwithauthor'] = 'Full, med forfatter';
$string['displayformatfullwithoutauthor'] = 'Full, uten forfatter';
$string['displayformats'] = 'Visningsformater';
$string['displayformatssetup'] = 'Vis formatoppsett';
$string['duplicatecategory'] = 'Dupliser kategori';
$string['duplicateentry'] = 'Dupliser oppføring';
$string['editalways'] = 'Alltid tillat redigering';
$string['editalways_help'] = '<p>Dette valget lar deg bestemme om brukerne skal få redigere egne innlegg selv om det er publisert.</p>

<p>Du har disse valgene:</p>

<ul>
<li><b>Ja:</b> Innleggene er alltid redigerbare.</li>

<li><b>Nei:</b> Innleggene er bare redigerbare inntil fastsatt tid for publisering (vanligvis 30 min).</li>
</ul>';
$string['editcategories'] = 'Rediger kategorier';
$string['editcategory'] = 'Rediger kategori';
$string['editentry'] = 'Rediger oppføring';
$string['editentrya'] = 'Rediger oppføring: {$a}';
$string['editingcomment'] = 'Rediger kommentar';
$string['entbypage'] = 'Oppføringer vist per side';
$string['entries'] = 'Oppføringer';
$string['entrieswithoutcategory'] = 'Oppføringer uten kategori';
$string['entry'] = 'Oppføring';
$string['entryalreadyexist'] = 'Oppføringen eksisterer allerede';
$string['entryapproved'] = 'Denne oppføringen er godkjent';
$string['entrydeleted'] = 'Oppføringen er slettet';
$string['entryexported'] = 'Oppføringen er vellykket eksportert';
$string['entryishidden'] = '(oppføringen er skjult)';
$string['entryleveldefaultsettings'] = 'Standardinnstillinger -Begynnernivå';
$string['entrylink'] = 'Oppføringslenke: {$a}';
$string['entrynotapproved'] = 'Oppføring ikke godkjent';
$string['entrysaved'] = 'Oppføringen er lagret';
$string['entryupdated'] = 'Oppføringen er oppdatert';
$string['entryusedynalink'] = 'Lag automatisk lenker til denne oppføringen';
$string['entryusedynalink_help'] = '<p>Dersom aktivert vil denne oppføringen automatisk bli lenket opp alle steder i kurset hvor uttrykket forekommer. Dette inkluderer foruminnlegg, interne nettside  osv.</p>

<p>Hvis du ikke ønsker at en bestemt oppføring skal autolenkes (f.eks. i et forum eller et spørsmål) bør du legge til &lt;nolink&gt; and &lt;/nolink&gt; tagger foran og bak teksten.</p>

<p>For å aktivere denne funksjonen må også autolenking være aktivert i egenskaper for ordboken.</p>';
$string['errcannoteditothers'] = 'Du kan ikke redigere andre brukeres oppføringer.';
$string['errconceptalreadyexists'] = 'Dette begrepet eksisterer allerede. Ingen duplikater tillatt i denne ordboka.';
$string['errdeltimeexpired'] = 'Du kan ikke slette dette siden fristen er ute!';
$string['erredittimeexpired'] = 'Redigeringstiden for denne oppføringen er utløpt.';
$string['errorparsingxml'] = 'Det oppstod en feil i behandlingen av fila. Sjekk at du har gyldig XML-syntaks.';
$string['eventcategorycreated'] = 'Kategori er opprettet';
$string['eventcategorydeleted'] = 'Kategori er slettet';
$string['eventcategoryupdated'] = 'Kategori er oppdatert';
$string['evententryapproved'] = 'Oppføringen er godkjent';
$string['evententrycreated'] = 'Oppføringen er laget';
$string['evententrydeleted'] = 'Oppføringen er slettet';
$string['evententrydisapproved'] = 'Oppføringen er underkjent';
$string['evententryupdated'] = 'Oppføringen er oppdatert';
$string['evententryviewed'] = 'Oppføringen er vist';
$string['explainaddentry'] = 'Legg til en oppføring til gjeldende ordbok. <br />\'Begrep\' og \'Definisjon\' er obligatoriske felter.';
$string['explainall'] = 'Vis ALLE oppføringene på en side';
$string['explainalphabet'] = 'Bla gjennom ordboken med denne indeksen';
$string['explainexport'] = 'En fil er opprettet.<br /><small>(Se lenken nederst på siden, \'Eksportert fil\'.)</small><br />Last den ned og lagre den. Du kan importere den senere i denne klassen eller i andre klasser.
Last den ned og';
$string['explainimport'] = '<b>Du må velge:</b><li>Hvilken fil du vil importere (Klikk \'Bla gjennom...\')<li>Til hvilken ordliste den skal (Velg \'Mål\')<li>Skal kategorier også importeres (Sett en hake i boksen \'Importer kategorier\')<li>Velg det du ønsker nedenfor og klikk \'Lagre endringer\' for å se resultatet.';
$string['explainspecial'] = 'Vis oppføringer som starter med andre tegn enn bokstaver';
$string['exportedentry'] = 'Eksportert oppføring';
$string['exportentries'] = 'Eksporter oppføringer';
$string['exportentriestoxml'] = 'Eksporter oppføringer til en XML-fil';
$string['exportfile'] = 'Eksporter oppføringer til fil';
$string['exportglossary'] = 'Eksporter ordbok';
$string['exporttomainglossary'] = 'Eksporter til hovedordbok';
$string['filetoimport'] = 'Fil du vil importere';
$string['filetoimport_help'] = '<P>Velg XML-filen som inneholder oppføringene som skal importeres. </p>';
$string['fillfields'] = '\'Begrep\' og \'Definisjon\' er obligatoriske felter.';
$string['filtername'] = 'Automatisk lenking til ordbok';
$string['fullmatch'] = 'Bare hele ord blir lenket<br /><small>(når det lenkes automatisk)</small>';
$string['fullmatch_help'] = '<p>Hvis du angir at en oppføring kan lenkes automatisk fra andre ressurser, vil
(dersom du slår på dette valget) bare ord som passer denne oppføringen nøyaktig
bli lenket. </p>
<p>Eksempel: En ordbokoppføring kalt &quot;lekeskole&quot; vil ikke lage en lenke inne i
ordet &quot;lekeskolen&quot;. </p>';
$string['glossary:addinstance'] = 'Legg til en ny ordbok';
$string['glossary:approve'] = 'Godkjenn nye oppføringer, eller underkjenn tidligere godkjente';
$string['glossary:comment'] = 'Lag kommentarer';
$string['glossary:export'] = 'Eksporter oppføringer';
$string['glossary:exportentry'] = 'Eksporter en enkelt oppføring';
$string['glossary:exportownentry'] = 'Eksporter en av dine oppføringer';
$string['glossary:import'] = 'Importer oppføringer';
$string['glossary:managecategories'] = 'Administrere kategorier';
$string['glossary:managecomments'] = 'Administrere kommentarer';
$string['glossary:manageentries'] = 'Administrere oppføringer';
$string['glossary:rate'] = 'Vurder oppføringer';
$string['glossary:view'] = 'Vis ordbok';
$string['glossary:viewallratings'] = 'Vis alle vurderinger brukere har gitt';
$string['glossary:viewanyrating'] = 'Vis totalvurderinger som enkeltbrukere har mottatt';
$string['glossary:viewrating'] = 'Vis vurderinger du har fått';
$string['glossary:write'] = 'Opprett ny oppføring';
$string['glossaryleveldefaultsettings'] = 'Standardinnstillinger på Ordbok-nivå';
$string['glossarytype'] = 'Ordboktype';
$string['glossarytype_help'] = 'En hovedordbok er en ordbok som kan importere oppføringer fra sekundære ordbøker. Det kan bare være en hovedordbok i hvert kurs. Dersom importering av ordbokoppføringer ikke er påkrevd kan alle kursets ordbøker være sekundære ordbøker.';
$string['guestnoedit'] = 'Gjester kan ikke endre i ordbøker';
$string['importcategories'] = 'Importer kategorier';
$string['importedcategories'] = 'Importerte kategorier';
$string['importedentries'] = 'Importerte oppføringer';
$string['importentries'] = 'Importer oppføringer';
$string['importentriesfromxml'] = 'Importer oppføringer fra XML-fil';
$string['includegroupbreaks'] = 'Inkluder gruppebrudd';
$string['indicator:cognitivedepth'] = 'Kognitiv ordbok';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på kognitiv dybde vist av studenten i en Ordbok-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Ordbok - kognitivt engasjement';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av ordliste-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen visning, visning, innsending)';
$string['indicator:socialbreadth'] = 'Sosial ordbok';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på sosial bredde vist av studenten i en Ordbok-aktivitet.';
$string['indicator:socialbreadthdef'] = 'Ordbok - sosialt engasjement';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av ordliste-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen deltakelse, deltaker alene)';
$string['isglobal'] = 'Skal denne ordboken være tilgjengelig for andre klasser?';
$string['isglobal_help'] = '<p>Systemet med ordbøker lar deg definere begreper som kan være tilgjengelig på
hele nettstedet. De beskrives som globale. </p>
<p>For å gjøre dette må du definere hvilken ordbok som er global. </p>
<p>Du kan ha så mange globale ordbøker du vil, og de kan høre til hvilken klasse
som helst. Alle regler som gjelder for vanlige ordbøker gjelder også for de
globale.&nbsp; </p>
<p><b>Merk: </b>Kun administrator kan lage globale ordbøker. </p>';
$string['letter'] = 'letter';
$string['linkcategory'] = 'Lag lenker til denne kategorien automatisk';
$string['linkcategory_help'] = '<P>Du kan velge om kategoriene skal lenkes til automatisk eller ikke. </p>

<p>Merk: Kategorilenkene er kun basert på bokstavsensitivitet (store/små
bokstaver) og nøyaktige treff. </p>';
$string['linking'] = 'Autolenking';
$string['mainglossary'] = 'Hovedordbok';
$string['maxtimehaspassed'] = 'Beklager, men maksimumtiden for redigering av denne kommentaren ({$a}) har gått ut!';
$string['modulename'] = 'Ordbok';
$string['modulename_help'] = 'Ordbokmodulen lar deltakere opprette og vedlikeholde en liste over definisjoner, som f.eks. en ordliste eller for å samle og organisere ressurser eller informasjon.

Lærere kan tillate at filer kan legges ved ordbokoppføringer. Vedlagte bilder vises i oppføringen. Du kan søke i oppføringene eller bla i dem i alfabetisk rekkefølge eller etter kategori, dato eller forfatter. Oppføringer kan godkjennes som standard eller kreve godkjenning av en lærer før de kan vises av alle.

Hvis filteret Ordliste autolinking er slått på, lenkes oppslag automatisk på de stedene i kurset hvor begrepene og/eller uttrykkene kommer opp.

Læreren kan tillate kommentarer på oppføringer. Oppføringer kan også vurderes av lærere eller studenter. Vurderinger kan legges sammen til en endelig karakter som registreres i karakterboken.

Ordbøker kan brukes til mye forskjellig, som f.eks.

* En begrepsbank basert på et samarbeid mellom alle i kurset
* En \'bli kjent\' plass hvor nye studenter legger inn navnet sitt og skriver litt om seg selv
* En ressurs med \'nyttige tips\' om best praksis i et praktisk fag
* En delingsarena for nyttige videoer, bilder eller lydfiler
* En faktabank som inneholder fakta som er viktig å huske til eksamen/quizer. Nyttig ressurs i eksamens/prøveforberedelsene.';
$string['modulenameplural'] = 'Ordbøker';
$string['newentries'] = 'Nye ordbokoppføringer';
$string['newglossary'] = 'Ny ordbok';
$string['newglossarycreated'] = 'Ny ordbok opprettet';
$string['newglossaryentries'] = 'Nye ordbokoppføringer:';
$string['nocomment'] = 'Ingen kommentarer funnet';
$string['nocomments'] = '(Ingen kommentarer funnet til denne oppføringen)';
$string['noconceptfound'] = 'Ingen begreper eller definisjoner funnet.';
$string['noentries'] = 'Ingen oppføringer funnet i denne kategorien';
$string['noentry'] = 'Ingen oppføring funnet';
$string['nopermissiontodelcomment'] = 'Du kan ikke slette andre brukeres kommentarer!';
$string['nopermissiontodelinglossary'] = 'Du kan ikke kommenetere i denne ordboken!';
$string['nopermissiontoviewresult'] = 'Du kan bare se på resultater fra dine egne oppføringer';
$string['notapproved'] = 'ordbokoppslaget er ikke godkjent ennå.';
$string['notcategorised'] = 'Ikke kategorisert';
$string['numberofentries'] = 'Antall oppføringer';
$string['onebyline'] = '(en per linje)';
$string['page-mod-glossary-edit'] = 'Siden for å endre/legge til ordbokoppslag';
$string['page-mod-glossary-view'] = 'Vis redigeringssiden for ordboken';
$string['page-mod-glossary-x'] = 'Alle sider i ordbokmodulen';
$string['pluginadministration'] = 'Ordbok administrasjon';
$string['pluginname'] = 'Ordbok';
$string['popupformat'] = 'Popup-format';
$string['print'] = 'Skriv ut';
$string['printerfriendly'] = 'Utskriftsvennlig versjon';
$string['printviewnotallowed'] = 'Utskriftsvisning er ikke tillatt';
$string['privacy'] = 'Personvern for resultater';
$string['privacy:metadata:core_comments'] = 'Kommentarer til ordbokoppføringer lagres med core_comment systemet';
$string['privacy:metadata:core_files'] = 'Filer lenket til ordbokdefinisjoner blir lagret med core_files systemet';
$string['privacy:metadata:core_rating'] = 'Vurderinger lagt til for ordbokoppføringer lagres med system core_rating.';
$string['privacy:metadata:core_tag'] = 'Tagger lagt til i ordbokdefinisjoner lagres med core_tag systemet';
$string['privacy:metadata:glossary_entries'] = 'Informsjon for en brukers oppføringer i en bestemt ordbok';
$string['privacy:metadata:glossary_entries:attachment'] = 'Vedlegget brukeren la ved oppføringen';
$string['privacy:metadata:glossary_entries:concept'] = 'Navnet på oppføringen brukeren la til.';
$string['privacy:metadata:glossary_entries:definition'] = 'Beskrivelsen brukeren la til i oppføringen.';
$string['privacy:metadata:glossary_entries:glossaryid'] = 'ID\'en til ordbokaktiviteten';
$string['privacy:metadata:glossary_entries:timemodified'] = 'Tidspunktet for når ordbokoppføringen ble endret av brukeren';
$string['privacy:metadata:glossary_entries:userid'] = 'IDen til brukeren som legger til denne ordbokoppføringen';
$string['question'] = 'Spørsmål';
$string['rejectedentries'] = 'Avviste oppføringer';
$string['rejectionrpt'] = 'Rapport over avviste oppføringer';
$string['removeallglossarytags'] = 'Fjern alle ordboktagger';
$string['resetglossaries'] = 'Slett oppføringer fra';
$string['resetglossariesall'] = 'Slett oppføringer fra alle ordbøker';
$string['rssarticles'] = 'Antall nye oppføringer som skal vises via RSS';
$string['rssarticles_help'] = '<p>Dette valget lar deg velge antallet utsendinger for RSS</p>

<p>En tall mellom 5 og 20 er normalt for de fleste ordbøker. Øk dette tallet hvis ordboka blir hyppig oppdatert.</p>';
$string['rsssubscriberss'] = 'Vis RSS-agenten for \'{$a}\' begreper';
$string['rsstype'] = 'RSS-agent for denne aktiviteten';
$string['rsstype_help'] = '<p>Dette valget slår på RSS-utsending fra denne ordboken.</p>

<p>Du kan velge mellom to typer utsendinger:</p>

<ul>
<li><b>Med forfatter:</b> Genererer RSS-utsendiger med forfatterens navn i hver oppføring.</li>

<li><b>Uten forfatter:</b> Genererer RSS-utsendinger uten forfatterangivelse.</li>
</ul>';
$string['search:activity'] = 'Ordbok - aktivitetsinformasjon';
$string['search:entry'] = 'Ordbok - oppføringer';
$string['searchindefinition'] = 'Søk i hele teksten';
$string['secondaryglossary'] = 'Sekundær ordbok';
$string['showall'] = 'Vis lenken \'ALLE\\';
$string['showall_help'] = '<P>Du kan standardisere hvordan brukerne søker seg gjennom en ordbok. Du kan
alltid søke på kategorier og dato. Du kan i tillegg definere tre flere
muligheter: </p>

<p><b>VIS SPESIELLE TEGN </b>Slår av eller på muligheten for å bla også etter
tegn som @, #, etc.</p>

<p><b>VIS ALFABET</b> Slår av eller på mulighet for å bla etter bokstaver. </p>

<p><b>VIS ALLE</b> Slår av eller på søking der alle oppføringene vises på en
gang etter hverandre. </p>';
$string['showalphabet'] = 'Vis alfabetslenker';
$string['showalphabet_help'] = '<P>Du kan standardisere hvordan brukerne søker seg gjennom en ordbok. Du kan
alltid søke på kategorier og dato. Du kan i tillegg definere tre flere
muligheter: </p>

<p><b>VIS SPESIELLE TEGN </b>Slår av eller på muligheten for å bla også etter
tegn som @, #, etc.</p>

<p><b>VIS ALFABET</b> Slår av eller på mulighet for å bla etter bokstaver. </p>

<p><b>VIS ALLE</b> Slår av eller på søking der alle oppføringene vises på en
gang etter hverandre. </p>';
$string['showspecial'] = 'Vis lenken \'Spesielle tegn\\';
$string['showspecial_help'] = '<P>Du kan standardisere hvordan brukerne søker seg gjennom en ordbok. Du kan
alltid søke på kategorier og dato. Du kan i tillegg definere tre flere
muligheter: </p>

<p><b>VIS SPESIELLE TEGN </b>Slår av eller på muligheten for å bla også etter
tegn som @, #, etc.</p>

<p><b>VIS ALFABET</b> Slår av eller på mulighet for å bla etter bokstaver. </p>

<p><b>VIS ALLE</b> Slår av eller på søking der alle oppføringene vises på en
gang etter hverandre. </p>';
$string['sortby'] = 'Sorter etter';
$string['sortbycreation'] = 'Etter dato opprettet';
$string['sortbylastupdate'] = 'Etter siste oppdatering';
$string['sortchronogically'] = 'Sorter kronologisk';
$string['special'] = 'Spesielle tegn';
$string['standardview'] = 'Sorter alfabetisk';
$string['studentcanpost'] = 'Studenter kan legge til oppføringer';
$string['tagarea_glossary_entries'] = 'Ordbokoppføringer';
$string['tagsdeleted'] = 'Ordbokoppføringer hr blitt fjernet';
$string['totalentries'] = 'Totalt antall oppføringer';
$string['usedynalink'] = 'Lag lenker til ordbokoppføringer automatisk';
$string['usedynalink_help'] = '<P ALIGN=CENTER><B>Å lenke ordbokoppføringer automatisk til andre moduler</B></P>

<p>Om du velger at en ordliste skal lenkes automatisk vil oppføringene i
ordboken lenkes til fra der ordene fins i andre ressurser og aktiviteter.
(Forum, journaler, oppgaver osv.)</p>
<p>Hvis du ikke vil at en bestemt tekst skal lenkes (f.eks. i et foruminnlegg)
må du skrive teksten mellom HTML-taggene &lt;nolink&gt; og &lt;/nolink&gt;. </p>
<p>Merk at kategorinavn også lenkes til. </p>';
$string['visibletabs'] = 'Synlige faner';
$string['waitingapproval'] = 'Venter på godkjenning';
$string['warningstudentcapost'] = '(Gjelder bare dersom ordboken ikke er hovedordboken)';
$string['withauthor'] = 'Begreper med forfatter';
$string['withoutauthor'] = 'Begreper uten forfatter';
$string['writtenby'] = 'av';
$string['youarenottheauthor'] = 'Du er ikke forfatteren av denne kommentaren, så du kan ikke redigere den.';
