<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'fr', version '3.8'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Actions';
$string['activityoresourceis'] = 'L\'activité ou ressource est {$a}';
$string['addacondition'] = 'Ajouter une condition';
$string['addarule'] = 'Ajouter une règle';
$string['addinstructions'] = 'Ajouter plus d\'information';
$string['additionalresources'] = 'Ressources supplémentaires';
$string['addrulesformhelp'] = 'La dernière colonne définit la quantité de points d\'expérience acquise lorsque le critère est rempli.';
$string['admindefaultrulesintro'] = 'Les règles suivantes seront utilisées par défaut dans les cours où le bloc est ajouté.';
$string['admindefaultsettingsintro'] = 'Les réglages ci-dessous seront utilisés par défaut quand le bloc est ajouté dans un cours. Certains réglages peuvent être verrouillés, auquel cas leur valeur est imposée dans toutes les instances du plugin.';
$string['admindefaultvisualsintro'] = 'Le visuel suivant sera utilisé par défaut quand le bloc est ajouté dans un cours.';
$string['anonymity'] = 'Anonymat';
$string['anonymity_help'] = 'Ce réglage contrôle si les participants peuvent voir les noms et avatars des autres participants.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> points d\'expérience sont attribués quand :';
$string['basexp'] = 'Base de l\'algorithme';
$string['blockappearance'] = 'Apparence du bloc';
$string['cachedef_filters'] = 'Filtres de niveau';
$string['cachedef_ruleevent_eventslist'] = 'Liste de quelques événements';
$string['changelevelformhelp'] = 'Si vous changez le nombre de niveaux, les badges de niveau personnalisés seront temporairement désactivés pour éviter d\'éventuels niveaux sans badges. Si vous changez le nombre de niveaux, une fois ce formulaire enregistré, visitez la page \'Visuels\' pour réactiver les badges personnalisés.';
$string['cheatguard'] = 'Protection anti-triche';
$string['clicktoselectcm'] = 'Cliquer pour choisir une activité ou une ressource';
$string['cmselector'] = 'Sélecteur de module';
$string['coefxp'] = 'Coefficient de l\'algorithme';
$string['colon'] = '{$a->a} : {$a->b}';
$string['configdescription'] = 'Description à ajouter';
$string['configdescription_help'] = 'Une courte introduction est affichée dans le bloc, sous le niveau de l\'étudiant. Les étudiants ont la possibilité de masquer ce message pour ne plus le voir.';
$string['configheader'] = 'Réglages';
$string['configrecentactivity'] = 'Afficher les récompenses récentes';
$string['configrecentactivity_help'] = 'Si c\'est activé, le bloc affichera une courte liste d\'événements récents qui ont récompensé l\'étudiant avec des points.';
$string['configtitle'] = 'Titre';
$string['configtitle_help'] = 'Le titre du bloc.';
$string['congratulationsyouleveledup'] = 'Félicitations !';
$string['coolthanks'] = 'Merci c\'est cool !';
$string['courselog'] = 'Journal du cours';
$string['coursereport'] = 'Rapport du cours';
$string['courserules'] = 'Règles du cours';
$string['courseselectedcolon'] = 'Cours sélectionné&nbsp;:';
$string['coursesettings'] = 'Réglages du cours';
$string['coursevisuals'] = 'Visuels de cours';
$string['customizelevels'] = 'Personnaliser les niveaux';
$string['dangerzone'] = 'Zone de danger';
$string['defaultlevels'] = 'Niveaux par défaut';
$string['defaultrules'] = 'Règles par défaut';
$string['defaultrulesformhelp'] = 'Ce sont les règles par défaut fournies par le plugin, Elles attribuent automatiquement des points d\'expérience par défaut et ignorent certains événements redondants. Les règles personnalisées ont priorité sur elles.';
$string['defaultsettings'] = 'Réglages par défaut';
$string['defaultvisuals'] = 'Visuels par défaut';
$string['deletecondition'] = 'Supprimer la condition';
$string['deleterule'] = 'Supprimer la règle';
$string['description'] = 'Description';
$string['difference'] = 'Diff.';
$string['discoverlevelupplus'] = 'Découvrez Progressez ! Plus';
$string['dismissnotice'] = 'Masquer la note';
$string['displayeveryone'] = 'Afficher tout le monde';
$string['displaynneighbours'] = 'Afficher {$a} voisins';
$string['displayoneneigbour'] = 'Afficher un voisin';
$string['displayparticipantsidentity'] = 'Afficher l\'identité des participants';
$string['displayrank'] = 'Afficher le rang';
$string['displayrelativerank'] = 'Afficher un rang relatif';
$string['documentation'] = 'Documentation';
$string['editinstructions'] = 'Modifier l\'information';
$string['enablecheatguard'] = 'Activer la mise en garde sur la triche';
$string['enablecheatguard_help'] = 'La mise en garde sur la triche offre une technique simple qui empêche les étudiants d\'abuser du système en utilisant des techniques évidentes telles que rafraîchir la page sans arrêt ou répéter la même action en boucle.';
$string['enableinfos'] = 'Activer la page d\'infos';
$string['enableinfos_help'] = 'Lorsque ce réglage est sur «Non», les étudiants ne seront pas en mesure d\'afficher la page d\'infos.';
$string['enableladder'] = 'Activer l\'échelle';
$string['enableladder_help'] = 'Lorsque ce réglage est sur «Non», les étudiants ne seront pas en mesure d\'afficher l\'échelle.';
$string['enablelevelupnotif'] = 'Activer la notification de progression';
$string['enablelevelupnotif_help'] = 'Lorsque ce réglage est à \'Oui\', une fenêtre surgissante sera affichée pour féliciter les étudiants du nouveau niveau atteint.';
$string['enablelogging'] = 'Activer l\'historique';
$string['enablexpgain'] = 'Activer le gain d\'expérience';
$string['enablexpgain_help'] = 'Si ce réglage est à \'Non\', personne ne pourra gagner des points d\'expérience dans ce cours. Ceci peut être utile pour bloquer l\'expérience acquise, ou pour la débloquer à un certain moment.

S\'il vous plait notez que ceci peut être contrôlé de manière plus fine  par la permission \'block/xp:earnxp\'.';
$string['entersearchterm'] = 'Entrez un terme de recherche';
$string['errorformvalues'] = 'll y a quelques problèmes dans les valeurs de formulaire, veuillez les corriger.';
$string['errorlevelsincorrect'] = 'Le nombre minimum de niveaux est 2';
$string['errornotalllevelsbadgesprovided'] = 'Tous les badges de niveau n\'ont pas été fournis. Manquant : {$a}';
$string['errorunknownevent'] = 'Erreur : événement inconnu';
$string['errorunknownmodule'] = 'Erreur : module inconnu';
$string['errorxprequiredlowerthanpreviouslevel'] = 'L\'expérience requise est inférieure ou égale à celle du précédent niveau.';
$string['event_user_leveledup'] = 'Utilisateur promu';
$string['eventis'] = 'L\'événement est {$a}';
$string['eventname'] = 'Nom de l\'événement';
$string['eventproperty'] = 'Propriété de l\'événement';
$string['eventsrules'] = 'Règles pour les événements';
$string['eventsrules_help'] = 'Ce plugin utilise les événements pour attribuer des points aux actions effectuées par les étudiants.
Vous pouvez utiliser le formulaire ci-dessous pour ajouter vos propres règles et modifier celles par défaut.

Il est conseillé de consulter la page _Log_ du plugin pour identifier les événements déclenchés lorsque les étudiants effectuent des actions dans le cours.

Ressources additionnelles:

- [Comment sont calculés les points d\'expérience?] (Https://levelup.plus/docs/article/how-are-experience-points-calculated?ref=blockxp_help)
- [Règles de dépannage] (https://levelup.plus/docs/article/event-rule-not-working?ref=blockxp_help)';
$string['eventtime'] = 'Heure de l\'événement';
$string['filtermodules'] = 'Filtrer les modules';
$string['for1day'] = 'Pour 1 jour';
$string['for1month'] = 'Pour 1 mois';
$string['for1week'] = 'Pour une semaine';
$string['for3days'] = 'Pour 3 jours';
$string['forever'] = 'Pour toujours';
$string['forthewholesite'] = 'Pour tout le site';
$string['give'] = 'donne';
$string['gotofullladder'] = 'Aller au classement complet';
$string['grid'] = 'Grille';
$string['hideparticipantsidentity'] = 'Masquer l\'identité des participants';
$string['hiderank'] = 'Masquer le rang';
$string['incourses'] = 'Dans les cours';
$string['ineffective'] = 'Ineffectif';
$string['infos'] = 'Informations';
$string['instructions'] = 'Plus d\'information';
$string['invalidxp'] = 'Valeur d\'expérience invalide';
$string['keeplogs'] = 'Conserver l\'historique';
$string['ladder'] = 'Echelle';
$string['ladderadditionalcols'] = 'Colonnes additionnelles';
$string['ladderadditionalcols_help'] = 'Ce réglage détermine quelles colonnes additionnelles sont affichées sur l\'échelle. Maintenez la touche Ctrl ou Cmd appuyée tout en cliquant pour sélectionner plus d\'une colonne, ou pour enlever une colonne déjà sélectionnée.';
$string['ladderempty'] = 'Le classement est pour l\'instant vide, revenez voir plus tard !';
$string['level'] = 'Niveau';
$string['levelbadges'] = 'Badges de niveau';
$string['levelbadgesformhelp'] = 'Nommez les fichiers [niveau].[extension de fichier] par exemple 1.png, 2.jpg, etc. La taille d\'image recommandée est 100 x 100.';
$string['levelcount'] = 'Nombre de niveaux';
$string['leveldesc'] = 'Description du niveau';
$string['levelname'] = 'Nom du niveau';
$string['levels'] = 'Niveaux';
$string['levelswillbereset'] = 'Attention ! Sauver ce formulaire recalculera le niveau de chaque participant !';
$string['levelup'] = 'Progressez !';
$string['levelupplus'] = 'Progressez ! Plus';
$string['levelx'] = 'Niveau #{$a}';
$string['likenotice'] = '<strong>Aimez-vous le plugin ?</strong> Prenez un moment pour <a href="{$a->moodleorg}" target="_blank">l\'ajouter à vos favoris</a> sur Moodle.org et <a href="{$a->github}" target="_blank">donnez-lui une étoile sur GitHub</a>.';
$string['limitparticipants'] = 'Limiter les participants';
$string['limitparticipants_help'] = 'Ce réglage contrôle ce qui est affiché dans le classement. Les voisins sont les participants classés au-dessus ou en-dessous de l\'utilisateur actuel. Par exemple, si vous choisissez « Afficher 2 voisins », seuls les deux participants classés directement au-dessus et en-dessous de l\'utilisateur actuel seront affichés.';
$string['list'] = 'Liste';
$string['logging'] = 'Historiques';
$string['manually'] = 'Manuellement';
$string['maxactionspertime'] = 'Nombre max d\'actions par intervalle de temps';
$string['maxactionspertime_help'] = 'Le nombre maximal d\'actions qui seront prises en compte pour le calcul de l\'expérience au cours de la période de temps donnée. Toute action ultérieure sera ignorée.';
$string['movecondition'] = 'Déplacer la condition';
$string['moverule'] = 'Déplacer la règle';
$string['name'] = 'Nom';
$string['navinfos'] = 'Infos';
$string['navladder'] = 'Echelle';
$string['navlevels'] = 'Niveaux';
$string['navlog'] = 'Historique';
$string['navpromo'] = 'Plus';
$string['navreport'] = 'Rapport';
$string['navrules'] = 'Règles';
$string['navsettings'] = 'Réglages';
$string['navvisuals'] = 'Visuels';
$string['nodescription'] = 'Pas de description';
$string['nologsrecordedyet'] = 'Aucun journal n\'a été capturé jusqu\'à présent.';
$string['noname'] = 'Pas de nom';
$string['notesomesettingslocked'] = 'Notez que certains paramètres ne pourront pas être modifiés si ils ont été verrouillés par un administrateur.';
$string['participant'] = 'Participant';
$string['participatetolevelup'] = 'Participez au cours pour gagner des points d\'expérience et progresser !';
$string['perpagecolon'] = 'Par page :';
$string['pickaconditiontype'] = 'Choisissez un type de condition';
$string['pluginname'] = 'Progressez !';
$string['pointsintimelinker'] = 'par';
$string['pointsrequired'] = 'Points requis';
$string['privacy:metadata:log'] = 'Enregistre le journal d\'événements';
$string['privacy:metadata:log:eventname'] = 'Le nom de l\'événement';
$string['privacy:metadata:log:time'] = 'La date à laquelle cela a eu lieu';
$string['privacy:metadata:log:userid'] = 'L\'utilisateur recevant les points';
$string['privacy:metadata:log:xp'] = 'Les points accordés à l\'événement';
$string['privacy:metadata:prefintro'] = 'Enregistre si l\'utilisateur a fermé l\'information introductive';
$string['privacy:metadata:preflevelup'] = 'Enregistre si l\'utilisateur doit voir la notification de niveau';
$string['privacy:metadata:prefnotices'] = 'Enregistre si l\'utilisateur a fermé l\'information d\'assistance';
$string['privacy:metadata:prefseenpromo'] = 'Enregistre si l\'utilisateur a vu la page de promo';
$string['privacy:metadata:xp'] = 'Enregistre les points et niveau des utilisateurs';
$string['privacy:metadata:xp:lvl'] = 'Le niveau de l\'utilisateur';
$string['privacy:metadata:xp:userid'] = 'L\'utilisateur';
$string['privacy:metadata:xp:xp'] = 'Les points de l\'utilisateur';
$string['privacy:path:addon'] = 'Extension';
$string['privacy:path:level'] = 'Niveau';
$string['privacy:path:logs'] = 'Journaux';
$string['progress'] = 'Progression';
$string['progressbar'] = 'Barre de progression';
$string['promocontactintro'] = 'Contactez-nous pour plus d\'informations. On ne mord pas et on répond rapidement !';
$string['promocontactus'] = 'Entrez en contact';
$string['promoemailusat'] = 'Écrivez-nous à levelup@branchup.tech.';
$string['promoerrorsendingemail'] = 'Oups ! Nous n\'avons pas pu envoyer le message… Veuillez nous écrire directement à l\'adresse {$a}. Merci !';
$string['promoifpreferemailusat'] = 'Psst ! Si vous préférez, écrivez-nous directement à l\'adresse {$a}.';
$string['promointro'] = 'L\'extension de _Level up!_ qui libère son vrai potentiel !';
$string['promoyourmessagewassent'] = 'Merci ! Votre message a été envoyé. Nous vous recontacterons bientôt.';
$string['property:action'] = 'Action de l\'événement';
$string['property:component'] = 'Composant de l\'événement';
$string['property:crud'] = 'Event CRUD';
$string['property:eventname'] = 'Nom de l\'événement';
$string['property:target'] = 'Cible de l\'événement';
$string['rank'] = 'Rang';
$string['ranking'] = 'Classement';
$string['ranking_help'] = 'Le rang est la position réelle de l\'utilisateur actuel sur l\'échelle. Le rang relatif est la différence en points d\'expérience entre un utilisateur et ses voisins.';
$string['reallyresetdata'] = 'Really reset the levels and experience points of everyone in this course?';
$string['reallyresetgroupdata'] = 'Voulez-vous vraiment remettre à zéro les niveaux et points d\'expérience de tout le monde dans ce groupe ?';
$string['reallyreverttopluginsdefaults'] = 'Voulez-vous vraiment rétablir les règles par défaut suggérées par le plugin ? Cette action est irréversible.';
$string['recentrewards'] = 'Récompenses récentes';
$string['reportisempty'] = 'Le rapport est vide, les étudiants n\'ont pas encore gagné de points.';
$string['reportisemptyenrolstudents'] = 'Le rapport est vide, est-ce que les étudiants ont été inscrits au cours ?';
$string['requires'] = 'Requiert';
$string['resetallcoursestodefaults'] = 'Rétablir tous les cours aux paramètres par défaut.';
$string['resetallcoursestodefaultsintro'] = 'Cliquez le bouton ci-dessous pour rétablir tous les cours aux paramètres par défaut ci-dessus.';
$string['resetcoursedata'] = 'Réinitialiser les données du cours';
$string['resetcourserulestodefaults'] = 'Rétablir le cours aux règles par défaut.';
$string['resetgroupdata'] = 'Remettre à zéro les données du groupe';
$string['reverttopluginsdefaults'] = 'Revenir aux réglages par défaut du plugin';
$string['reverttopluginsdefaultsintro'] = 'Utilisez le bouton ci-dessous si vous voulez revenir aux réglages par défaut du plugin.';
$string['reward'] = 'Récompense';
$string['rule'] = 'Règle';
$string['rule:contains'] = 'contient';
$string['rule:eq'] = 'est égal à';
$string['rule:eqs'] = 'est strictement égal à';
$string['rule:gt'] = 'est supérieur à';
$string['rule:gte'] = 'est supérieur ou égal à';
$string['rule:lt'] = 'est inférieur à';
$string['rule:lte'] = 'est inférieur ou égal à';
$string['rule:regex'] = 'correspond à l\'expression rationnelle';
$string['rulecm'] = 'Activité ou ressource';
$string['rulecm_help'] = 'Cette condition est remplie quand l\'événement se produit dans l\'activité ou la ressourc indiquée.';
$string['rulecmdesc'] = 'L\'activité ou ressource est « {$a->contextname} ».';
$string['rulecmdescwithcourse'] = 'L\'activité ou ressource est : « {$a->contextname} » dans « {$a->coursename} ».';
$string['rulecminfo'] = 'Cette condition requiert que l\'action se produise dans une activité our ressource spécifique.';
$string['ruleevent'] = 'Événement précis';
$string['ruleeventdesc'] = 'L\'événement est « {$a->eventname} »';
$string['ruleeventinfo'] = 'Choisissez l\'action que les utilisateurs doivent effectuer à partir d\'une liste d\'événements préparée.';
$string['ruleproperty'] = 'Propriété de l\'événement';
$string['rulepropertydesc'] = 'La propriété « {$a->property} » {$a->compare} « {$a->value} ».';
$string['rulepropertyinfo'] = 'Cette condition est pour les utilisateurs avancés avec une connaissance technique des événements et de leurs propriétés.';
$string['ruleset'] = 'Groupe de conditions';
$string['ruleset:all'] = 'TOUTES les conditions sont vraies';
$string['ruleset:any'] = 'UNE des conditions est vraie';
$string['ruleset:none'] = 'AUCUNE des conditions n\'est vraie';
$string['rulesetinfo'] = 'Combinez plusieurs conditions en une seule.';
$string['rulesformhelp'] = '<p> Ce plugin utilise les événements pour attribuer des points d\'expérience aux étudiants selon les actions effectuées. Vous pouvez utiliser le formulaire ci-dessous pour ajouter vos propres règles et voir celles par défaut. </p>
<p> Il est conseillé de vérifier le plugin <a href="{$a->log}">historique</a> pour identifier les événements qui sont déclenchés lorsque vous effectuez des actions dans le cours, et aussi pour en savoir plus sur les événements eux-mêmes: <a href="{$a->list}">liste de tous les événements</a> , <a href="{$a->doc}">documentation développeur</a> . </p>
<p> Enfin, veuillez noter que le plugin ignore toujours:
<ul>
    <li> Les actions effectuées par les administrateurs, invités ou non connectés. </li>
    <li> Les actions réalisées par des utilisateurs n\'ayant pas la permission <em>block/xp:earnxp</em>.</li>
    <li> Les actions répétées dans un court intervalle de temps, pour éviter la tricherie. </li>
    <li> Et les événements de niveau d\'éducation différent de <em>participation.</em> </li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Cherchez et sélectionnez un cours';
$string['searchandselectmodule'] = 'Rechercher et sélectionner une activité ou une ressource';
$string['send'] = 'Envoyer';
$string['setpoints'] = 'Définir les points';
$string['shortcode:xpbadge'] = 'Le badge correspondant au niveau actuel de l\'utilisateur.';
$string['shortcode:xpiflevel'] = 'Afficher le contenu correspondant au niveau actuel de l\'utilisateur.';
$string['shortcode:xpladder'] = 'Affiche une partie du classement autour du rang de l\'utilisateur actuel.';
$string['shortcode:xplevelname'] = 'Affiche le nom du niveau.';
$string['shortcode:xpprogressbar'] = 'La barre de progression de l\'utilisateur actuel vers le prochain niveau.';
$string['someoneelse'] = 'Quelqu\'un d\'autre';
$string['somethinghappened'] = 'Quelque chose est arrivé';
$string['taskcollectionloggerpurge'] = 'Supprimer les journaux de collection';
$string['thankyou'] = 'Merci&nbsp;!';
$string['timebetweensameactions'] = 'Temps requis entre deux actions identiques';
$string['timebetweensameactions_help'] = 'Temps minimum nécessaire en secondes entre les actions identiques. Une action est considéré comme identique si elle concerne le même contexte et le même objet, la lecture d\'un message sur le forum sera considérée comme identique si le même message est relu.';
$string['timeformaxactions'] = 'Temps max pour un nombre max d\'actions';
$string['timeformaxactions_help'] = 'Le laps de temps (en secondes) pendant lequel l\'utilisateur ne doit pas excéder un nombre maximal d\'actions.';
$string['tinytimedays'] = '{$a} j';
$string['tinytimehours'] = '{$a} h';
$string['tinytimeminutes'] = '{$a} m';
$string['tinytimenow'] = 'mnt';
$string['tinytimeseconds'] = '{$a} s';
$string['tinytimeweeks'] = '{$a} sem.';
$string['total'] = 'Total';
$string['unknowneventa'] = 'Événement inconnu ({$a})';
$string['updateandpreview'] = 'Mise à jour et aperçu';
$string['upgradingplugins'] = 'Mettre à jour les plugins';
$string['urlaccessdeprecated'] = 'L\'accès via ce lien est déconseillé, veuillez mettre à jour vos liens.';
$string['usealgo'] = 'Utiliser l\'algorithme';
$string['usecustomlevelbadges'] = 'Utiliser les badges de niveau personnalisés';
$string['usecustomlevelbadges_help'] = 'Lorsque cette option est sur \'Oui\', vous devez fournir une image pour chaque niveau.';
$string['usingalgo'] = 'Avec l\'algorithme';
$string['value'] = 'Valeur';
$string['valuessaved'] = 'Les valeurs ont été enregistrées avec succès';
$string['viewas'] = 'Voir en';
$string['viewtheladder'] = 'Voir l\'échelle';
$string['visualsintro'] = 'Déposez des images pour personnaliser l\'apparence des niveaux.';
$string['wewillreplyat'] = 'Nous vous répondrons à : _{$a}_.';
$string['when'] = 'Quand';
$string['wherearexpused'] = 'Où les points d\'expériences sont-ils utilisés ?';
$string['wherearexpused_desc'] = 'Quand « Dans les cours » est sélectionné, les points d\'expérience sont seulement acquis dans les cours où le bloc a été ajouté. Quand « Pour tout le site » est sélectionné, un utilisateur augmentera de niveau dans le site plutôt que par cours, toute l\'expérience reçue à travers le site sera utilisée.';
$string['whoops'] = 'Oups !';
$string['xp'] = 'Points d\'expérience';
$string['xp:addinstance'] = 'Ajouter un nouveau bloc XP';
$string['xp:earnxp'] = 'Gagner des points d\'expérience';
$string['xp:myaddinstance'] = 'Ajouter le bloc à mon tableau de bord';
$string['xp:view'] = 'Voir le bloc et ses pages relatives';
$string['xp:viewlogs'] = 'Voir le journal';
$string['xpgaindisabled'] = 'Gain d\'expérience désactivé';
$string['xprequired'] = 'Expérience requise';
$string['xptogo'] = '[[{$a}]] restant';
$string['youreachedlevel'] = 'Vous avez atteint le niveau :';
$string['youreachedlevela'] = 'Vous avez atteint le niveau {$a} !';
$string['yourmessage'] = 'Votre message';
$string['yourownrules'] = 'Vos propres règles';
