<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hsuforum', language 'de', version '3.8'.
 *
 * @package     hsuforum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessible'] = 'Zugänglich';
$string['activityoverview'] = 'Es gibt neue Forenbeiträge';
$string['addanewdiscussion'] = 'Ein neues Diskussionsthema hinzufügen';
$string['addanewtopic'] = 'Neues Thema erstellen';
$string['addareply'] = 'Antworten';
$string['addyourdiscussion'] = 'Thema hinzufügen';
$string['advancedsearch'] = 'Erweiterte Suche';
$string['ajaxrequesterror'] = 'Fehler beim Vervollständigen der Anfrage. Bitte versuchen Sie es noch einmal.';
$string['all'] = 'Alle';
$string['allforums'] = 'Alle Foren';
$string['allowanonymous'] = 'Anonyme Beiträge erlauben';
$string['allowanonymous_help'] = 'Wenn aktiviert, werden die Namen der Autor/innen für alle Beiträge unterdrückt';
$string['allowdiscussions'] = 'Kann ein {$a} in dieses Forum schreiben?';
$string['allowsallsubscribe'] = 'In diesem Forum kann ein Abonnement frei gewählt werden';
$string['allowsdiscussions'] = 'In diesem Forum kann jede Person ein Thema eröffnen.';
$string['allsubscribe'] = 'Alle Foren abonnieren';
$string['allunsubscribe'] = 'Aus allen Foren abmelden';
$string['alreadyfirstpost'] = 'Dies ist der erste Beitrag zum Thema';
$string['anonymousalternatename'] = 'Anonym';
$string['anonymousfirstname'] = 'Anonymer';
$string['anonymousfirstnamephonetic'] = 'Anonymer';
$string['anonymouslastname'] = 'Nutzer';
$string['anonymouslastnamephonetic'] = 'Nutzer';
$string['anonymousrecentactivity'] = 'Es gibt möglicherweise neue Aktivitäten in diesem Forum, aber die Details können nicht angezeigt werden, da das Forum anonym ist.';
$string['anonymouswarning'] = 'Durch das Verschieben dieses Diskussionsthemas enthüllen Sie möglicherweise anonyme Informationen. Sie Sie sicher, dass Sie das tun wollen?';
$string['anyfile'] = 'Jede Datei';
$string['areapost'] = 'Nachrichten';
$string['articledateformat'] = '%l:%M%P %b %e, %Y';
$string['attachment'] = 'Anhänge';
$string['attachment_help'] = 'Sie können eine oder mehrere Dateien an einen Forenbeitrag anhängen. Wenn Sie ein Bild anhängen, wird es unter dem Nachrichtentext angezeigt.';
$string['attachmentnopost'] = 'Sie können keine Anhänge ohne Beitrags-ID exportieren.';
$string['attachments'] = 'Anhänge';
$string['attachments:x'] = 'Anhänge: {$a}';
$string['author'] = 'Autor/in';
$string['blockafter'] = 'Beitragsgrenze für Sperre';
$string['blockafter_help'] = 'Diese Einstellung legt die maximale Anzahl von Beiträgen fest, die eine Person im angegebenen Zeitraum veröffentlichen kann. Personen mit der Berechtigung mod/hsuforum:postwithoutthrottling sind von dieser Beschränkung ausgenommen.';
$string['blockperiod'] = 'Zeitraum für Sperre';
$string['blockperiod_help'] = 'Teilnehmer/innen können gesperrt werden, wenn Sie innerhalb eines bestimmten Zeitraums eine vorgegebene Beitragsgrenze überschreiten. Nutzer/innen mit der Berechtigung mod/hsuforum:postwithoutthrottling sind von dieser Grenze ausgenommen.';
$string['blockperioddisabled'] = 'Nicht blockieren';
$string['blogforum'] = 'Standard-Forum in einem blog-ähnlichen Format anzeigen';
$string['bynameondate'] = 'von {$a->name} - {$a->date}';
$string['byx'] = 'von {$a}';
$string['cannnotdeletesinglediscussion'] = 'Entschuldigung, aber Sie sind nicht berechtigt, dieses Thema zu löschen!';
$string['cannotadd'] = 'Das Thema konnte nicht zum Forum hinzugefügt werden';
$string['cannotadddiscussion'] = 'Um diesem Forum Themen hinzufügen zu können, ist eine Gruppenmitgliedschaft erforderlich.';
$string['cannotadddiscussionall'] = 'Sie sind nicht berechtigt ein neues Diskussionsthema für alle Teilnehmer/innen hinzuzufügen.';
$string['cannotadddiscussiongroup'] = 'Sie können kein Thema erstellen, da Sie keiner Gruppe angehören.';
$string['cannotaddsubscriber'] = 'Abonnent mit id {$a} konnte diesem Forum nicht hinzugefügt werden!';
$string['cannotcreatediscussion'] = 'Es konnte kein neues Thema erstellt werden';
$string['cannotdeletepost'] = 'Sie können diesen Beitrag nicht löschen!';
$string['cannoteditposts'] = 'Sie können die Beiträge anderer Personen nicht bearbeiten!';
$string['cannotfinddiscussion'] = 'Das Thema konnte in diesem Forum nicht gefunden werden';
$string['cannotfindfirstpost'] = 'Der erste Beitrag in diesem Forum konnte nicht gefunden werden';
$string['cannotfindparentpost'] = 'Der übergeordnete Element zu Beitrag {$a} konnte nicht gefunden werden';
$string['cannotmakeprivatereplies'] = 'Entschuldigung, aber in diesem Forum sind private Antworten nicht zulässig';
$string['cannotmovefromsingleforum'] = 'Das Thema kann nicht von einem einfachen einzelnen Diskussionsforum aus verschoben werden.';
$string['cannotmovenotvisible'] = 'Forum nicht sichtbar';
$string['cannotmovetonotexist'] = 'Sie können nichts in dieses Forum verschieben - es existiert nicht!';
$string['cannotmovetonotfound'] = 'Das Zielforum wurde in diesem Kurs nicht gefunden.';
$string['cannotmovetosingleforum'] = 'Das Thema kann nicht in ein Ein-Themen-Diskussionsforum verschoben werden';
$string['cannotremovesubscriber'] = 'Der Abonnent mit der ID {$a} kann nicht aus diesem Forum abgemeldet werden!';
$string['cannotreply'] = 'Sie können auf diesen Beitrag nicht antworten';
$string['cannotsplit'] = 'Themen aus diesem Forum können nicht geteilt werden';
$string['cannotsubscribe'] = 'Entschuldigung, aber Sie müssen Mitglied einer Gruppe sein, um abonnieren zu können';
$string['cannottrack'] = 'Die Leseverfolgung kann für dieses Forum nicht deaktiviert werden';
$string['cannotunsubscribe'] = 'Sie können sich aus diesem Forum nicht abmelden';
$string['cannotupdatepost'] = 'Sie können diesen Beitrag nicht aktualisieren';
$string['cannotviewpostyet'] = 'Sie können die Fragen anderer Nutzer zu diesem Thema nicht lesen, weil Sie noch keinen Beitrag veröffentlicht haben';
$string['cannotviewusersposts'] = 'Von dieser Nutzerin / diesem Nutzer gibt es keine Beiträge, die Sie sehen können.';
$string['cansubscribediscerror'] = 'Sie können dieses Thema nicht abonnieren.';
$string['cleanreadtime'] = 'Stunde, zu der alte Beiträge als gelesen markiert werden';
$string['clicktocollapse'] = 'Anklicken um Beitragstext und alle Antworten zu verbergen';
$string['clicktoexpand'] = 'Anklicken um Beitragstext und alle Antworten anzuzeigen';
$string['collapseall'] = 'Alle ausblenden';
$string['completiondiscussions'] = 'Teilnehmer/innen müssen Themen anlegen:';
$string['completiondiscussionsdesc'] = 'Teilnehmer/innen müssen mindestens {$a} Themen anlegen';
$string['completiondiscussionsgroup'] = 'Themen notwendig';
$string['completiondiscussionshelp'] = 'Themen zum Abschluss notwendig';
$string['completionposts'] = 'Teilnehmer/innen müssen Themen oder Antworten verfassen:';
$string['completionpostsdesc'] = 'Teilnehmer/innen müssen mindestens  {$a} Themen oder Antworten verfassen';
$string['completionpostsgroup'] = 'Beitrag notwendig';
$string['completionpostshelp'] = 'Die Erstellung von Themen oder Antworten ist zum Abschluss notwendig';
$string['completionreplies'] = 'Teilnehmer/innen müssen Antworten verfassen:';
$string['completionrepliesdesc'] = 'Teilnehmer/innen müssen mindestens {$a} Antworten verfassen';
$string['completionrepliesgroup'] = 'Antworten notwendig';
$string['completionreplieshelp'] = 'Antworten zum Abschluss notwendig';
$string['completionusegradeerror'] = 'Eine Bewertung kann nicht notwendig sein, da dieses Forum nicht bewertet wird. Entweder Sie entfernen diese Bedingung oder machen dieses Forum zu einem bewerteten.';
$string['configdigestmailtime'] = 'Personen, die gewählt haben Themenzusammenfassungen per E-Mail zu erhalten, bekommen diese täglich. Diese Einstellung legt fest, zu welcher Tageszeit diese Zusammenfassungen versendet werden (der nächste cron, der nach dieser Stunde läuft, wird sie versenden).';
$string['confighiderecentposts'] = 'Auf Ja stellen um das Anzeigen von neuen Forenbeiträgen auf der Kursseite zu stoppen.';
$string['configlongpost'] = 'Alle Beiträge über dieser Länge (in Zeichen, nicht HTML) werden als lang angesehen. Beiträge, die auf der Startseite, Kursstartseite im sozialen Format oder in Nutzerprofilen angezeigt werden, werden an einer natürlichen Stelle zwischen den Werten von hsuforum_shortpost und hsuforum_longpost gekürzt.';
$string['configmanydiscussions'] = 'Maximale Anzahl von Themen, die in einem Forum pro Seite angezeigt werden';
$string['configmaxattachments'] = 'Maximale Anzahl an Anhängen, die pro Beitrag erlaubt sind.';
$string['configmaxbytes'] = 'Maximale Größe für alle Anhänge in Foren auf der Plattform (unterliegt kursbezogenen Einschränkungen und der jeweiligen lokalen Einstellung)';
$string['configoldpostdays'] = 'Anzahl der Tage, an denen ein Beitrag als gelesen gilt.';
$string['configreplytouser'] = 'Wenn ein Forenbeitrag verschickt wird, sollte er die E-Mail-Adresse der Nutzerin / des Nutzers enthalten, damit die Empfänger persönlich und nicht über das Forum antworten können? Auch wenn dies auf \'Ja\' gestellt ist, können Nutzer/innen in ihrem Profil ihre E-Mail Adresse als privat einstellen (verbergen).';
$string['configrssarticlesdefault'] = 'Wenn RSS-Feeds aktiviert sind, wird die Standardanzahl der Artikel festgelegt (entweder Diskussionen oder Beiträge).';
$string['configrsstypedefault'] = 'Wenn RSS Feeds eingeschaltet sind, bestimmt dies die Standardeinstellungen des Aktivitätstyps.';
$string['configshortpost'] = 'Jeder Beitrag unterhalb dieser Länge (in Zeichen, ohne HTML-Tags) wird als kurz angesehen (siehe unten).';
$string['configsubscriptiontype'] = 'Standardeinstellung für die Art des Abonnements.';
$string['configusermarksread'] = 'Wenn \'ja\', muss der Nutzer einen Beitrag manuell als gelesen markieren. Wenn \'nein\' wird der Beitrag beim Ansehen als gelesen markiert.';
$string['confirmsubscribe'] = 'Wollen Sie das Forum  \'{$a}\' wirklich abonnieren?';
$string['confirmunsubscribe'] = 'Wollen Sie sich wirklich aus dem Forum  \'{$a}\' abmelden?';
$string['couldnotadd'] = 'Sie können Ihren Beitrag aufgrund eines unbekannten Fehlers nicht veröffentlichen';
$string['couldnotdeletereplies'] = 'Entschuldigung, dieser Beitrag kann nicht gelöscht werden, da andere Nutzer bereits darauf geantwortet haben';
$string['couldnotupdate'] = 'Ihr Beitrag konnte aufgrund eines unbekannten Fehlers nicht aktualisiert werden';
$string['createdbynameondate'] = 'Erstellt von {$a->name} am {$a->date}';
$string['crontask'] = 'Moodlerooms Advanced Forum E-Mail- und Wartungs-Jobs';
$string['csv'] = 'CSV';
$string['date'] = 'Datum';
$string['default'] = 'Standard';
$string['delete'] = 'Löschen';
$string['deleteattachments'] = 'Anhänge löschen';
$string['deleteattachmentx'] = '{$a} löschen';
$string['deleteddiscussion'] = 'Das Thema wurde gelöscht';
$string['deletedpost'] = 'Der Beitrag wurde gelöscht';
$string['deletedposts'] = 'Diese Beiträge wurden gelöscht';
$string['deletesure'] = 'Sind Sie sicher, dass Sie diesen Beitrag löschen wollen?';
$string['deletesureplural'] = 'Sind Sie sicher, dass Sie diesen Beitrag und alle Antworten löschen wollen? ({$a} Beiträge)';
$string['digestmailheader'] = 'Das ist Ihre tägliche Zusammenfassung neuer Beiträge aus den {$a->sitename} Foren. Um Ihre Standardeinstellungen für Forenmails zu ändern gehen Sie zu {$a->userprefs}.';
$string['digestmailpost'] = 'Ändern Sie Ihre Einstellungen für die Foren-Zusammenfassung';
$string['digestmailpostlink'] = 'Ändern Sie Ihre Einstellungen für die Foren-Zusammenfassung: {$a}';
$string['digestmailprefs'] = 'Ihr Benutzerprofil';
$string['digestmailsubject'] = '{$a}: Foren-Zusammenfassung';
$string['digestmailtime'] = 'Versendezeit für E-Mail-Zusammenfassungen';
$string['digestsentusers'] = 'E-Mail-Zusammenfassungen wurden erfolgreich an {$a} Nutzer/innen gesendet.';
$string['disallowsubscribe'] = 'Abonnements nicht erlaubt';
$string['disallowsubscribeteacher'] = 'Abonnements nicht erlaubt (außer für Lehrer)';
$string['discussion'] = 'Thema';
$string['discussion:x'] = 'Thema: {$a}';
$string['discussiondisplay'] = 'Themenanzeige';
$string['discussionlocked'] = 'Dieses Thema wurde geschlossen. Daher sind keine Antworten mehr möglich.';
$string['discussionlockingdisabled'] = 'Themensperrung deaktiviert';
$string['discussionlockingheader'] = 'Themensperrung';
$string['discussionmoved'] = 'Das Thema wurde verschoben nach  \'{$a}\'.';
$string['discussionmovedpost'] = 'Dieses Thema wurde <a href="{$a->discusshref}">hierher</a> im Forum <a href="{$a->forumhref}">{$a->forumname}</a> verschoben';
$string['discussionname'] = 'Name des Themas';
$string['discussionpin'] = 'Pin';
$string['discussionpinned'] = 'Angepinnt';
$string['discussionpinned_help'] = 'Angepinnte Themen erscheinen am Anfang des Forums.';
$string['discussions'] = 'Themen';
$string['discussionsortkey:created'] = 'Erstelldatum';
$string['discussionsortkey:lastreply'] = 'Neueste';
$string['discussionsortkey:replies'] = 'Aktivste';
$string['discussionsortkey:subscribe'] = 'Abonniert';
$string['discussionsplit'] = 'Dieses Thema wurde geteilt';
$string['discussionsstartedby'] = 'Themen begonnen von {$a}';
$string['discussionsstartedbyrecent'] = 'Themen kürzlich begonnen von {$a}';
$string['discussionsstartedbyuserincourse'] = 'Themen begonnen von {$a->fullname} in {$a->coursename}';
$string['discussionsubscribers'] = 'Themenabonnenten';
$string['discussionsummary'] = 'Eine Tabelle aller Themen von {$a}. Der Tabellenkopf ist eine Kombination aus Vorname, Nachname und Bild des Benutzers.';
$string['discussionunpin'] = 'Pin entfernen';
$string['discussthistopic'] = 'Diskutieren Sie dieses Thema';
$string['displaydiscussionreplies'] = 'Antworten auf das Thema anzeigen';
$string['displayend'] = 'Anzeigeende';
$string['displayend_help'] = 'Diese Einstellung legt fest, ob ein Forenbeitrag nach einem bestimmten Datum verborgen wird. Beachten Sie, dass Administratoren Forenbeiträge immer sehen können.';
$string['displayperiod'] = 'Anzeigezeitraum';
$string['displaystart'] = 'Anzeigebeginn';
$string['displaystart_help'] = 'Diese Einstellung legt fest, ob ein Forenbeitrag erst ab einem bestimmten Datum angezeigt wird. Beachten Sie, dass Administratoren Forenbeiträge immer sehen können.';
$string['displaywordcount'] = 'Wortzahl anzeigen';
$string['displaywordcount_help'] = 'Diese Einstellung legt fest, ob die Wortzahl jedes Beitrags angezeigt werden soll oder nicht.';
$string['eachuserforum'] = 'Jede Person kann ein Thema eröffnen.';
$string['edit'] = 'Bearbeiten';
$string['editedby'] = 'Bearbeitet von {$a->name} - Originalbeitrag {$a->date}';
$string['editedpostupdated'] = '{$a}\'s Beitrag wurde aktualisiert';
$string['editing'] = 'Bearbeitung';
$string['editingpost'] = 'Beitrag bearbeiten';
$string['emaildigestcompleteshort'] = 'Komplette Beiträge';
$string['emaildigestdefault'] = 'Standard ({$a})';
$string['emaildigestoffshort'] = 'Keine Zusammenfassung';
$string['emaildigestsubjectsshort'] = 'Nur Betreff';
$string['emaildigesttype'] = 'Art der E-Mail-Zusammenfassung';
$string['emaildigesttype_help'] = 'Die Art der Benachrichtigung, die Sie für jedes Forum erhalten.

* Standard - nutzt die Zusammenfassungseinstellungen aus Ihrem Nutzerprofil. Wenn Sie Ihr Profil aktualisieren, wird das hier automatisch übernommen;
* Keine Zusammenfassung - Sie erhalten eine E-Mail je Forenbeitrag;
* Zusammenfassung - komplette Beiträge - Sie erhalten eine E-Mail-Zusammenfassung pro Tag mit dem kompletten Inhalt aller Forenbeiträge;
* Zusammenfassung - nur Betreff - Sie erhalten eine E-Mail-Zusammenfassung pro Tag, die nur den Betreff aller Forenbeiträge enthält.';
$string['emptymessage'] = 'Etwas stimmt mit Ihrem Beitrag nicht. Vielleicht haben Sie ihn leer gelassen oder der Anhang war zu groß. Ihre Änderungen wurden NICHT gespeichert.';
$string['erroremptymessage'] = 'Der Nachrichtentext des Beitrags darf nicht leer sein.';
$string['erroremptysubject'] = 'Der Betreff des Beitrags darf nicht leer sein.';
$string['errorenrolmentrequired'] = 'Sie müssen in diesen Kurs eingeschrieben sein, um auf diesen Inhalt zugreifen zu können.';
$string['errortimestartgreater'] = 'Der Beginn kann nicht nach dem Ende liegen.';
$string['errorwhiledelete'] = 'Beim Löschen des Datensatzes trat ein Fehler auf.';
$string['eventassessableuploaded'] = 'Es wurde Inhalt veröffentlicht.';
$string['eventcoursesearched'] = 'Kurs durchsucht';
$string['eventdiscussioncreated'] = 'Thema erstellt';
$string['eventdiscussiondeleted'] = 'Thema gelöscht';
$string['eventdiscussionmoved'] = 'Thema verschoben';
$string['eventdiscussionpinned'] = 'Thema angepinnt';
$string['eventdiscussionunpinned'] = 'Pin für das Thema entfernt';
$string['eventdiscussionupdated'] = 'Thema aktualisiert';
$string['eventdiscussionviewed'] = 'Thema gelesen';
$string['eventpostcreated'] = 'Beitrag erstellt';
$string['eventpostdeleted'] = 'Beitrag gelöscht';
$string['eventpostupdated'] = 'Beitrag aktualisiert';
$string['eventreadtrackingdisabled'] = 'Leseverfolgung deaktiviert';
$string['eventreadtrackingenabled'] = 'Leseverfolgung aktiviert';
$string['eventsubscribersviewed'] = 'Abonnenten angezeigt';
$string['eventsubscriptioncreated'] = 'Abonnement erstellt';
$string['eventsubscriptiondeleted'] = 'Abonnement gelöscht';
$string['eventuserreportviewed'] = 'Nutzerreport angezeigt';
$string['everyonecanchoose'] = 'Jeder kann entscheiden dieses Forum zu abonnieren';
$string['everyonecannowchoose'] = 'Jeder kann sich nun entscheiden dieses Forum zu abonnieren';
$string['everyoneisnowsubscribed'] = 'Jeder hat jetzt dieses Forum abonniert';
$string['everyoneissubscribed'] = 'Jeder hat dieses Forum abonniert';
$string['existingsubscribers'] = 'Bestehende Abonnenten';
$string['expandall'] = 'Alles aufklappen';
$string['export'] = 'Exportieren';
$string['exportattachments'] = 'Anhänge exportieren';
$string['exportdiscussion'] = 'Das ganze Thema ins Portfolio exportieren';
$string['exportformat'] = 'Exportformat';
$string['forcessubscribe'] = 'Dieses Forum muss verpflichtend abonniert werden';
$string['forum'] = 'Forum';
$string['forumauthorhidden'] = 'Autor (versteckt)';
$string['forumblockingalmosttoomanyposts'] = 'Sie erreichen die Beitragsobergrenze. Sie haben in den letzten {$a->blockperiod} {$a->numposts} Beiträge veröffentlicht. Die Grenze liegt bei {$a->blockafter} Beiträgen.';
$string['forumbodydeleted'] = 'Der Inhalt dieses Forenposts wurde entfernt und kann nicht mehr abgerufen werden.';
$string['forumbodyhidden'] = 'Dieser Beitrag kann nicht von Ihnen angesehen werden. Vielleicht haben Sie noch keinen Beitrag zum Thema veröffentlicht, ist die Bearbeitungsfrist noch nicht angelaufen, das Thema noch nicht gestartet oder das Thema abgeschlossen.';
$string['forumintro'] = 'Beschreibung';
$string['forumname'] = 'Forenname';
$string['forumposts'] = 'Forenbeiträge';
$string['forums'] = 'Foren';
$string['forumsubjectdeleted'] = 'Dieser Forenpost wurde entfernt';
$string['forumsubjecthidden'] = 'Betreff (verborgen)';
$string['forumtracked'] = 'Ungelesene Beiträge werden markiert';
$string['forumtrackednot'] = 'Ungelesene Beiträge werden nicht markiert';
$string['forumtype'] = 'Forentyp';
$string['forumtype_help'] = 'Es gibt fünf verschiedene Forentypen:

* Diskussion zu einem Thema - Forum zu einem einzigen Thema, zu dem alle antworten dürfen. Dieser Typ funktioniert nicht mit separaten Gruppen.
* Jede Person darf genau ein Thema anlegen - Forum, in dem jede Person genau ein Thema beginnen darf. Alle Personen dürfen dann zu allen Themen antworten.
* Frage-Antwort-Forum - Forum, bei dem alle Personen zuerst einem eigenen Beitrag schreiben müssen, bevor sie die Beiträge der anderen sehen und darauf antworten können.
* Standardforum in blog-ähnlicher Anzeige - offenes Forum, in dem jeder zu jeder Zeit ein neues Thema beginnen und auf alle Beiträge antworten kann. In einer Übersicht sind Betreffzeilen und die Beitragsanfänge sichtbar, zum jeweiligen Gesamtbeitrag und zu dessen Antworten führt ein Link.
* Standardforum - offenes Forum, in dem jeder zu jeder Zeit ein neues Thema eröffnen und auf alle Beiträge antworten kann. In einer Übersicht sind alle Betreffzeilen zu sehen.';
$string['general'] = 'Allgemein';
$string['generalforum'] = 'Standardforum für allgemeine Nutzung';
$string['generalforums'] = 'Standardforen';
$string['grade'] = 'Bewertung';
$string['gradetype'] = 'Bewertungstyp';
$string['gradetype_help'] = 'Der Bewertungytyp wird verwendet, um die Bewertungsmethode festzulegen.

* Keine: Dieses Forum wird nicht bewertet.
* Manuell: Dieses Forum muss manuell von einem Trainer / einer Trainerin über die Leistungsübersicht bewertet werden.
* Wertung: Nutzt Wertungen für die Bewerung.';
$string['gradetypemanual'] = 'Manuell';
$string['gradetypenone'] = 'Keine';
$string['gradetyperating'] = 'Bewertung';
$string['gradingmethodpreview'] = 'Bewertungskriterien';
$string['hiddenforumpost'] = 'Verborgener Forenbeitrag';
$string['hiderecentposts'] = 'Neueste Beiträge verstecken';
$string['hsuforum:addinstance'] = 'Ein neues Forum hinzufügen';
$string['hsuforum:addnews'] = 'Ankündigungen hinzufügen';
$string['hsuforum:addquestion'] = 'Frage hinzufügen';
$string['hsuforum:allowforcesubscribe'] = 'Verpflichtendes Abonnement erlauben';
$string['hsuforum:allowprivate'] = 'Nutzer/innen private Antworten erlauben';
$string['hsuforum:canoverridediscussionlock'] = 'Auf gesperrte Themen antworten';
$string['hsuforum:canposttomygroups'] = 'Sie können an alle Gruppen schreiben, auf die Sie Zugriff haben';
$string['hsuforum:createattachment'] = 'Anhänge erstellen';
$string['hsuforum:deleteanypost'] = 'Beliebige Beiträge löschen (jederzeit)';
$string['hsuforum:deleteownpost'] = 'Eigene Beiträge löschen (innerhalb Frist)';
$string['hsuforum:editanypost'] = 'Beliebige Beiträge bearbeiten';
$string['hsuforum:exportdiscussion'] = 'Gesamtes Thema exportieren';
$string['hsuforum:exportownpost'] = 'Eigenen Beitrag exportieren';
$string['hsuforum:exportpost'] = 'Beitrag exportieren';
$string['hsuforum:managesubscriptions'] = 'Abonnements verwalten';
$string['hsuforum:movediscussions'] = 'Themen verschieben';
$string['hsuforum:pindiscussions'] = 'Themen anpinnen';
$string['hsuforum:postwithoutthrottling'] = 'Von der Beitragsobergrenze ausgenommen';
$string['hsuforum:rate'] = 'Beiträge bewerten';
$string['hsuforum:replynews'] = 'Auf Ankündigungen antworten';
$string['hsuforum:replypost'] = 'Auf Beiträge antworten';
$string['hsuforum:revealpost'] = 'Gibt Sie in einem anonymen Forum zu erkennen';
$string['hsuforum:splitdiscussions'] = 'Themen aufteilen';
$string['hsuforum:startdiscussion'] = 'Neue Themen beginnen';
$string['hsuforum:viewdiscussion'] = 'Themen sehen';
$string['hsuforum:viewhiddentimedposts'] = '';
$string['hsuforum:viewposters'] = 'Teilnehmer/innen mit Forenbeiträgen anzeigen';
$string['hsuforum:viewqandawithoutposting'] = 'F & A-Beiträge immer sehen';
$string['hsuforum:viewrating'] = 'Ihre Gesamtbewertung anzeigen';
$string['hsuforum:viewsubscribers'] = 'Abonnent/innen anzeigen';
$string['id'] = 'ID';
$string['inforum'] = 'in {$a}';
$string['inprivatereplyto'] = 'in privater Antwort auf';
$string['inreplyto'] = 'in Antwort auf';
$string['introblog'] = 'Die Beiträge in diesem Forum wurden automatisch aus Blogeinträgen von Kursteilnehmern hierher kopiert, weil diese Blogeinträge nicht länger verfügbar sind';
$string['intronews'] = 'Allgemeine Neuigkeiten und Ankündigungen';
$string['introsocial'] = 'Ein offenes Forum, in dem Sie sich über alles unterhalten können';
$string['introteacher'] = 'Forum für Ankündigungen nur von Trainer/innen';
$string['invalidaccess'] = 'Auf diese Seite wurde nicht korrekt zugegriffen';
$string['invaliddigestsetting'] = 'Ungültige Einstellung für die E-Mail-Zusammenfassung';
$string['invaliddiscussionid'] = 'Themen-ID war falsch oder existiert nicht mehr';
$string['invalidforcesubscribe'] = 'Ungültiges verpflichtendes Abonnement';
$string['invalidforumid'] = 'Forum-ID war falsch';
$string['invalidparentpostid'] = 'Die ID des übergeordneten Beitrags war falsch';
$string['invalidpostid'] = 'Ungültige Beitrags-ID - {$a}';
$string['javascriptdisableddisplayformat'] = 'Javascript wurde in Ihrem Browser deaktiviert. Aktivieren Sie Javascript und laden Sie die Seite neu oder wählen Sie eine andere Forendarstellung.';
$string['jsondecodeerror'] = 'Die Antwort konnte nicht dekodiert werden, bitte versuchen Sie es noch einmal.';
$string['lastpostbyx'] = 'Letzter Beitrag von {$a->name} am {$a->time}';
$string['lastposttimeago'] = 'Letzter {$a}';
$string['learningforums'] = 'Lernforen';
$string['loadmorediscussions'] = 'Weitere Themen laden';
$string['lockdiscussionafter'] = 'Themen nach längerer Inaktivität sperren';
$string['lockdiscussionafter_help'] = 'Themen werden automatisch gesperrt, wenn seit der letzten Antwort eine festgelegte Zeit verstrichen ist.

Benutzer mit der Berechtigung, auf gesperrte Themen zu antworten, können das Thema entsperren, indem sie darauf antworten.';
$string['longpost'] = 'Langer Beitrag';
$string['mailnow'] = 'E-Mail-Benachrichtigungen ohne Zeitverzögerung';
$string['manageforumsubscriptions'] = 'Forenabonnements verwalten';
$string['managesubscriptionsoff'] = 'Abonnementsverwaltung beenden';
$string['managesubscriptionson'] = 'Abonnements verwalten';
$string['manualwarning'] = 'Bewertung der Aktivität wird noch nicht unterstützt. Eine Bewertung ist nur über die Bewertungsübersicht des Kurses möglich.';
$string['manydiscussions'] = 'Themen pro Seite';
$string['markalldread'] = 'Alle Beiträge zu diesem Thema als gelesen markieren.';
$string['markallread'] = 'Alle Beiträge in diesem Forum als gelesen markieren.';
$string['markasreadonnotification'] = 'Beim Versenden von Benachrichtigungen';
$string['markasreadonnotification_help'] = 'Sie können wählen, ob durch das Versenden einer Benachrichtigung der Beitrag als gelesen markiert werden soll.';
$string['markasreadonnotificationno'] = 'Beitrag als ungelesen markieren';
$string['markasreadonnotificationyes'] = 'Beitrag als gelesen markieren';
$string['markread'] = 'Als gelesen markieren';
$string['markreadbutton'] = 'Gelesen';
$string['markunread'] = 'Als ungelesen markieren';
$string['markunreadbutton'] = 'Ungelesen';
$string['maxattachments'] = 'Maximale Anzahl von Anhängen';
$string['maxattachments_help'] = 'Diese Einstellung legt die maximale Anzahl von Dateien fest, die an einen Forenbeitrag angehängt werden können.';
$string['maxattachmentsize'] = 'Maximale Dateigröße';
$string['maxattachmentsize_help'] = 'Diese Einstellung legt die maximale Größe eines Dateianhangs für einen Forenbeitrag fest.';
$string['maxtimehaspassed'] = 'Die maximale Bearbeitungszeit für diesen Beitrag ({$a}) ist abgelaufen!';
$string['message'] = 'Nachricht';
$string['messageinboundattachmentdisallowed'] = 'Ihre Antwort kann nicht veröffentlicht werden, da sie einen Anhang enthält und Anhänge in diesem Forum nicht zugelassen sind.';
$string['messageinboundfilecountexceeded'] = 'Ihre Antwort kann nicht veröffentlicht werden, da sie mehr Anhänge enthält, als in diesem Forum zugelassen sind ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Ihre Antwort kann nicht veröffentlicht werden, da die Gesamtgröße der Anhänge  ({$a->filesize}) die zugelassenen Maximalgröße ({$a->maxbytes}) überschreitet.';
$string['messageinboundforumhidden'] = 'Ihre Antwort kann nicht veröffentlicht werden, da das Forum im Augebnlick nicht verfügbar ist.';
$string['messageinboundnopostforum'] = 'Ihre Antwort kann nicht veröffentlicht werden, da Sie keine Berechtigung haben, im Forum {$a->forum->name} Beiträge zu veröffentlichen.';
$string['messageinboundthresholdhit'] = 'Ihre Antwort kann nicht veröffentlicht werden. Sie haben die Beitragsobergrenze für dieses Forum überschritten.';
$string['messageisrequired'] = 'Ein Beitrag ist erforderlich';
$string['messageplaceholder'] = 'Beitrag schreiben';
$string['messageprovider:digests'] = 'Abonnierte Open Forum Zusammenfassungen';
$string['messageprovider:posts'] = 'Abonnierte Open Forum Beiträge';
$string['missingsearchterms'] = 'Die folgenden Suchbegriffe kommen nur im HTML Markup dieser Nachricht vor:';
$string['modulename'] = 'Open Forum';
$string['modulename_help'] = 'Die Aktivität Open Forum erlaubt Teilnehmenden asynchrone Diskussionen zu führen, also Diskussionen die über einen längeren Zeitraum stattfinden.

Es gibt mehrere Forentypen zur Auswahl, das Standard Forum wo jeder zu jeder Zeit ein neues Thema anfangen kann; ein Forum wo jeder Teilnehmende genau ein Thema anfangen kann; ein Frage-Antwort Forum, wo Teilnehmende erst Antworten müssen bevor sie die Antworten der anderen sehen können. Trainer/innen können Dateianhänge an Beiträgen erlauben. Angehängte Bilder werden im Beitrag angezeigt.

Teilnehmer/innen können ein Forum abonnieren um Benachrichtigungen über neue Beiträge zu erhalten. Trainer/innen können die Art des Abonnements als optional, verpflichtend, automatisch oder deaktiviert einstellen. Wenn notwendig können Nutzer/innen ab einer bestimmten Zahl von Beiträgen in einer bestimmten Zeitspanne vom Schreiben neuer Beiträge gesperrt werden. So kann ausgeschlossen werden, dass Einzelne eine Diskussion dominieren.

Forenbeiträge können von Trainer/innen oder Teilnehmer/innen bewertet werden. Bewertungen können zusammengefasst werden um eine entgültige Bewertung in der Bewertungsübersicht des Kurses zu ergeben.

Foren haben viele Einsatzmöglichkeiten, wie z.B.:

* Ein sozialer Raum, in dem Teilnehmer/innen sich gegenseitig kennenlernen können
* Für Ankündigungen im Kurs
* Um die Kursinhalte zu diskutieren
* Um online eine Diskussion weiterzuführen, die in Person begonnen wurde
* Ein Hilfebreich, wo Tutoren und Teilnehmer/innen Rat geben können
* Für Diskussionen nur unter Trainer/innen (in einem versteckten Forum)
* Eine eins-zu-eins Hilfe für private Gespräche zwischen einem Teilnehmenden und einem Trainer/einer Trainerin (mit separaten Gruppen, in denen jeweils nur ein Teilnehmender ist)
* Für weiterführende Aktivitäten, beispielsweise \'Anreize\' um die Teilnehmenden zum Überlegen und Diskutieren zu bringen';
$string['modulenameplural'] = 'Open Forums';
$string['more'] = 'mehr';
$string['movedmarker'] = '(verschoben)';
$string['movethisdiscussionto'] = 'Thema verschieben nach ...';
$string['mustprovidediscussionorpost'] = 'Sie müssen entweder eine Themen ID der eine Beitrags ID angeben und exportieren zu können';
$string['myprofileotherdis'] = 'Open Forum Themen';
$string['myprofileotherpost'] = 'Open Forum Beiträge';
$string['myprofileowndis'] = 'Meine Open Forum Themen';
$string['myprofileownpost'] = 'Meine Open Forum Beiträge';
$string['namenews'] = 'Ankündigungen';
$string['namenews_help'] = 'Das Ankündigungsforum ist ein spezielles Forum für Ankündigungen und wird automatisch erzeugt, wenn ein Kurs angelegt wird. In einem Kurs kann es nur ein Ankündigungsforum geben. Nur Trainer/innen und Administrator/innen können Ankündigungen veröffentlichen. Der Block "Neue Ankündigungen" zeigt die neuesten Beiträge.';
$string['namesocial'] = 'Soziales Forum';
$string['nested'] = 'Verschachtelt';
$string['newforumposts'] = 'Neueste Beiträge';
$string['nextdiscussion'] = 'Nächstes Thema';
$string['nextdiscussionx'] = '({$a}) Nächstes >';
$string['noattachments'] = 'Es gibt keine Anhänge zu diesem Beitrag.';
$string['nodiscussionsstartedby'] = '{$a} hat kein Thema eröffnet.';
$string['nodiscussionsstartedbyyou'] = 'Sie haben noch kein Thema begonnen.';
$string['noguestpost'] = 'Gäste dürfen keine Beiträge veröffentlichen.';
$string['noguesttracking'] = 'Gäste dürfen die Einstellungen für die Nachverfolgung nicht ändern.';
$string['nomorepostscontaining'] = 'Es wurden keine weiteren Beiträge mit \'{$a}\' gefunden.';
$string['nonanonymous'] = 'Nicht anonym';
$string['nonews'] = 'Es wurden noch keine Ankündigungen veröffentlicht.';
$string['noonecansubscribenow'] = 'Abonnentments sind jetzt nicht erlaubt.';
$string['nopermissiontosubscribe'] = 'Sie haben nicht die Berechtigung die Forenabonnenten zu sehen';
$string['nopermissiontoview'] = 'Sie haben keine Leseberechtigung für diesen Beitrag.';
$string['nopostforum'] = 'Sie haben keine Schreibberechtigung für dieses Forum.';
$string['noposts'] = 'Keine Beiträge';
$string['nopostsmadebyuser'] = '{$a} hat keinen Beiträge veröffentlicht';
$string['nopostsmadebyyou'] = 'Sie haben keine Beitrag veröffentlicht.';
$string['nosubscribers'] = 'Es gibt keine Abonnenten für dieses Forum.';
$string['notexists'] = 'Das Thema existiert nicht mehr.';
$string['nothingnew'] = 'Nichts neues für {$a}';
$string['notingroup'] = 'Sie müssen Mitglied einer Gruppe sein, um dieses Forum zu sehen.';
$string['notinstalled'] = 'Das Forenmodul ist nicht installiert.';
$string['notpartofdiscussion'] = 'Dieser Beitrag gehört zu keinem Thema!';
$string['notrackforum'] = 'Ungelesene Beiträge nicht verfolgen';
$string['notuploadedfile'] = 'Es gab ein Problem beim Upload Ihrer Datei. Versuchen Sie es noch einmal.';
$string['noviewdiscussionspermission'] = 'Sie haben keine Leseberechtigung für die Themen in diesem Forum.';
$string['nowallsubscribed'] = 'Sie haben nun alle Foren in {$a} abonniert.';
$string['nowallunsubscribed'] = 'Sie haben nun alle Forenabonnements in {$a} abbestellt.';
$string['nownotsubscribed'] = '{$a->name} wird NICHT über neue Beiträge in \'{$a->forum}\' benachrichtigt.';
$string['nownottracking'] = '{$a->name} verfolgt nicht länger \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} wird über neue Beiträge in \'{$a->forum}\' benachrichtigt';
$string['nowtracking'] = '{$a->name} verfolgt jetzt \'{$a->forum}\'.';
$string['numposts'] = '{$a} Beiträge';
$string['olderdiscussions'] = 'Ältere Diskussionen';
$string['oldertopics'] = 'Ältere Themen';
$string['oldpostdays'] = 'Gelesen nach Tagen';
$string['onediscussion'] = '1 Thema';
$string['onereply'] = '1 Antwort';
$string['openmode0'] = 'Keine Themen, keine Antworten';
$string['openmode1'] = 'Keine Themen, aber Antworten sind erlaubt';
$string['openmode2'] = 'Themen und Antworten sind erlaubt';
$string['options'] = 'Optionen';
$string['orderdiscussionsby'] = 'Sortiert nach';
$string['overviewnumpostssince'] = '{$a} Beiträge seit dem letzten Login';
$string['overviewnumunread'] = '{$a} insgesamt ungelesen';
$string['page-mod-hsuforum-discuss'] = 'Forenmodul Diskussionsthemenseite';
$string['page-mod-hsuforum-view'] = 'Forenmodulhauptseite';
$string['page-mod-hsuforum-x'] = 'Jede Forenmodulseite';
$string['parent'] = 'Übergeordnetes zeigen';
$string['parentofthispost'] = 'Übergeordneter Beitrag';
$string['participants'] = 'Teilnehmer';
$string['plaintext'] = 'Klartext';
$string['pluginadministration'] = 'Forenadministration';
$string['pluginname'] = 'Open Forum';
$string['postadded'] = '<p>Ihr Beitrag wurde erfolgreich hinzugefügt.</p> <p>Sie haben {$a} zur Bearbeitung, wenn Sie Änderungen vornehmen wollen.</p>';
$string['postaddedsuccess'] = 'Ihr Beitrag wurde erfolgreich hinzugefügt.';
$string['postaddedtimeleft'] = 'Sie haben {$a} zur Bearbeitung, wenn Sie Änderungen vornehmen wollen.';
$string['postbymailsuccess'] = 'Glückwunsch, Ihr Beitrag mit dem Betreff "{$a->subject}" wurde erfolgreich hinzugefügt. Sie können Ihn unter {$a->discussionurl} sehen.';
$string['postbymailsuccess_html'] = 'Glückwunsch, Ihr <a href="{$a->discussionurl}">Forenbeitrag</a> mit dem Betreff "{$a->subject}" wurde erfolgreich veröffentlicht.';
$string['postbyuser'] = '{$a->post} von {$a->user}';
$string['postbyx'] = 'Beitrag von {$a}';
$string['postbyxinprivatereplytox'] = 'Private Antwort auf {$a->parent} von {$a->author}';
$string['postbyxinreplytox'] = 'Antwort auf {$a->parent} von {$a->author} {$a->parentpost}';
$string['postcreated'] = 'Beitrag erstellt';
$string['postdeleted'] = 'Beitrag gelöscht';
$string['postincontext'] = 'Diesen Beitrag im Kontext sehen';
$string['postmailinfolink'] = 'Dies ist die Kopie einer Mitteilung, die in {$a->coursename} geschrieben wurde.

Um zu antworten klicken Sie auf diesen Link: {$a->replylink}';
$string['postmailnow'] = '<p>Dieser Beitrag wird sofort per E-Mail an alle Forenabonnenten verschickt.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postoptions'] = 'Beitragsoptionen';
$string['posts'] = 'Beiträge';
$string['postsfor'] = 'Beiträge für';
$string['postsmadebyuser'] = 'Beiträge erstellt von {$a}';
$string['postsmadebyuserincourse'] = 'Beiträge erstellt von {$a->fullname} in {$a->coursename}';
$string['posttoforum'] = 'Im Forum veröffentlichen';
$string['posttomygroups'] = 'Kopie für alle Gruppen';
$string['posttomygroups_help'] = 'Veröffentlich eine Kopie dieser Nachricht in allen Gruppen, zu den Sie Zugang haben. Teilnehmer/innen anderer Gruppen werden diesen Beitrag nicht sehen';
$string['postupdated'] = 'Ihr Beitrag wurde aktualisiert';
$string['postwasupdated'] = 'Der Beitrag wurde aktualisiert';
$string['potentialsubscribers'] = 'Mögliche Abonnenten';
$string['prevdiscussionx'] = '< Voriges ({$a})';
$string['previousdiscussion'] = 'Ältere Themen';
$string['print'] = 'Drucken';
$string['privacy:digesttypepreference'] = 'Sie haben ausgewählt die folgende Art der Forenzusammenfassungen zu erhalten: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Sie haben die folgende Art des Themenabonnements für dieses Forum ausgewählt: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Das Open Forum nutzt Wertungen, um die Bewertung von Beiträgen zu unterstützen.';
$string['privacy:metadata:core_tag'] = 'Das Open Forum nutzt das Schlagwortesystem um die Verschlagwortung von Beiträgen zu unterstützen.';
$string['privacy:metadata:hsuforum_digests'] = 'Informationen zu den Zusammenfassungspräferenzen für jedes Open Forum.';
$string['privacy:metadata:hsuforum_digests:maildigest'] = 'Die präferierte Art der Zusammenfassung.';
$string['privacy:metadata:hsuforum_digests:userid'] = 'Die ID des Nutzers/ der Nutzerin mit der Zusammenfassungspräferenz.';
$string['privacy:metadata:hsuforum_discussion_subs'] = 'Informationen über das Abonnement von einzelnen Forumsthemen';
$string['privacy:metadata:hsuforum_discussions'] = 'Informationen über die individuellen Forums Themen, die ein Nutzer/ eine Nutzerin erstellt hat.';
$string['privacy:metadata:hsuforum_discussions:assessed'] = 'Bewertungstyp für das Thema';
$string['privacy:metadata:hsuforum_discussions:name'] = 'Der Name des Themas, wie er vom Autor gewählt wurde.';
$string['privacy:metadata:hsuforum_discussions:timemodified'] = 'Der Zeitpunkt, zu dem ein Thema zuletzt verändert wurde.';
$string['privacy:metadata:hsuforum_discussions:userid'] = 'Die ID des Nutzers, der das Thema erstellt hat';
$string['privacy:metadata:hsuforum_discussions:usermodified'] = 'Die ID des Nutzers, der das Thema zuletzt in einer Art verändert hat.';
$string['privacy:metadata:hsuforum_posts'] = 'Informationen über die Zusammenfassungspräferenzen für jedes Open Forum.';
$string['privacy:metadata:hsuforum_posts:created'] = 'Die Zeit, zu der der Beitrag erstellt wurde.';
$string['privacy:metadata:hsuforum_posts:discussion'] = 'Das Thema, in dem der Beitrag ist.';
$string['privacy:metadata:hsuforum_posts:message'] = 'Die Nachricht des Open Forum Beitrags.';
$string['privacy:metadata:hsuforum_posts:modified'] = 'Die Zeit, zu der der Beitrag zuletzt geändert wurde.';
$string['privacy:metadata:hsuforum_posts:parent'] = 'Der übergeordnete Beitrag, auf den geantwortet wurde.';
$string['privacy:metadata:hsuforum_posts:subject'] = 'Der Betreff des Open Forum Beitrags.';
$string['privacy:metadata:hsuforum_posts:userid'] = 'Die ID des Nutzers, der den Open Forum Post verfasst hat.';
$string['privacy:metadata:hsuforum_queue:discussionid'] = 'Die Themen ID.';
$string['privacy:metadata:hsuforum_queue:postid'] = 'Die Beitrags ID.';
$string['privacy:metadata:hsuforum_queue:timemodified'] = 'Die Bearbeitungszeit des Original Beitrags.';
$string['privacy:metadata:hsuforum_queue:userid'] = 'Die ID des Nutzers, der benachrichtigt wird.';
$string['privacy:metadata:hsuforum_read'] = 'Inforamtion, welche Beiträge von dem Nutzer gelesen wurden.';
$string['privacy:metadata:hsuforum_read:discussionid'] = 'Das Thema, zu dem der Beitrag gehört.';
$string['privacy:metadata:hsuforum_read:firstread'] = 'Der erste Zeitpunkt, zu dem der Beitrag gelesen wurde.';
$string['privacy:metadata:hsuforum_read:lastread'] = 'Der letzte Zeitpunkt, zu dem der Beitrag gelesen wurde.';
$string['privacy:metadata:hsuforum_read:postid'] = 'Der Beitrag, der gelesen wurde.';
$string['privacy:metadata:hsuforum_read:userid'] = 'Die ID des Nutzers, zu dem dieser Bericht gehört.';
$string['privacy:metadata:hsuforum_subscriptions'] = 'Informationen darüber, welche Open Forum Aktivitäten der Nutzer abonniert hat.';
$string['privacy:metadata:hsuforum_subscriptions:forum'] = 'Das Forum, welches abonniert wurde.';
$string['privacy:metadata:hsuforum_subscriptions:userid'] = 'Die ID des Nutzers, zu der dieses Open Forum Abonnement gehört.';
$string['privacy:metadata:hsuforum_subscriptions_disc'] = 'Informationen über die Abonnements  individueller Open Forum Themen.';
$string['privacy:metadata:hsuforum_subscriptions_disc:discussion'] = 'Die ID des Themas, das abonniert wurde.';
$string['privacy:metadata:hsuforum_subscriptions_disc:userid'] = 'Die ID des Nutzers, der das Thema abonniert hat.';
$string['privacy:metadata:preference:autosubscribe'] = 'Ob Foren abonniert werden sollen, wenn auf ein Thema darin geantwortet wird.';
$string['privacy:metadata:preference:maildigest'] = 'Die systemweite Einstellungsvorgabe für die E-Mail Zusammenfassungspräferenz.';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Ob Forenbeiträge als gelesen markiert werden sollen, wenn sie als Nachrichten erhalten wurden.';
$string['privacy:postwasread'] = 'Dieser beiträg wurde zuerst gelesen am  {$a->firstread} und zuletzte gelesen am  {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Sie haben gewählt Beiträge nicht zu verfolgen, die Sie in diesem Forum gelesen haben.';
$string['privacy:request:delete:discussion:name'] = 'Auf Wunsch des Verfassers / der Verfasserin löschen';
$string['privacy:request:delete:post:message'] = 'Der Inhalt dieses beitrags wurde auf Wunsch des Verfassers / der Verfasserin gelöscht.';
$string['privacy:request:delete:post:subject'] = 'Auf Wunsch des Verfassers / der Verfasserin löschen';
$string['privacy:subscribedtoforum'] = 'Sie haben dieses Forum abonniert.';
$string['privatereplies'] = 'Private Antworten erlauben';
$string['privatereplies_help'] = 'Mit dieser Funktion können Trainer/innen eine private Antwort auf einen Forenbeitrag senden. Diese Antwort ist nur für die Person sichtbar, die den Beitrag verfasst hat und für alle anderen Teilnehmer/innen unsichtbar.';
$string['privaterepliesdisabledglobally'] = 'Private Antworten wurden global deaktiviert.';
$string['privatereply'] = 'Private Antwort';
$string['privatereply_help'] = 'Wenn angeklickt ist dieser Beitrag nur für die Person sichtbar, auf dessen Beitrag Sie antworten. Niemand kann auf diesen Beitrag antworten.';
$string['privatereplybyx'] = 'Private Antwort von {$a}';
$string['processingdigest'] = 'E-Mail-Zusammenfassung für Nutzer/in {$a} in Bearbeitung';
$string['processingpost'] = 'Beitrag {$a} in Bearbeitung';
$string['prune'] = 'Teilen';
$string['prunedpost'] = 'Aus diesem Beitrag wurde ein neues Thema erzeugt';
$string['pruneheading'] = 'Teile das Thema und verschiebe diesen Beitrag in ein neues Thema';
$string['qandaforum'] = 'F & A-Forum';
$string['qandanotify'] = 'Dies ist ein Frage & Antwort-Forum. Um andere Antworten auf diese Fragen zu sehen, müssen Sie zuerst selbst eine Antwort veröffentlichen';
$string['re'] = 'Re:';
$string['readtherest'] = 'Rest dieses Themas lesen';
$string['removeallforumtags'] = 'Alle Schlagwörter des Forums entfernen';
$string['replies'] = 'Antworten';
$string['repliesmany'] = '{$a} Antworten bisher';
$string['repliesone'] = '{$a} Antwort bisher';
$string['repliesx'] = 'Antworten:  {$a}';
$string['reply'] = 'Antwort';
$string['reply_handler'] = 'Auf einen Open Forum Beitrag per E-Mail antworten';
$string['reply_handler_name'] = 'Auf einen Open Forum Beitrag antworten';
$string['replybuttontitle'] = 'Antwort an {$a}';
$string['replybyx'] = 'Antwort von {$a}';
$string['replyforum'] = 'Antwort ans Forum';
$string['replytopostbyemail'] = 'Sie können hierauf per E-Mail antworten';
$string['replytouser'] = 'E-Mail-Adresse für die Antwort verwenden';
$string['replytox'] = 'Antworten auf {$a}';
$string['resetdigests'] = 'Alle Einstellungen für die E-Mail-Zusammenfassung löschen';
$string['resetforums'] = 'Beiträge löschen von';
$string['resetforumsall'] = 'Alle Beiträge löschen';
$string['resetsubscriptions'] = 'Alle Forenabonnements löschen';
$string['resettrackprefs'] = 'Alle Einstellungen Lesenachverfolgung löschen';
$string['reveal'] = 'Identität preisgeben';
$string['reveal_help'] = 'Wenn ausgewählt, wird Ihr Name im Beitrag gezeigt und Sie sind nicht länger anonym.';
$string['rssarticles'] = 'Anzahl Artikel im RSS-Feed';
$string['rssarticles_help'] = 'Diese Einstellung legt die Anzahl der Artikel (Thmen oder Beiträge) fest, die im RSS-Feed angezeigt werden. Im allgemeinen wird ein Wert zwischen 5 und 20 empfohlen.';
$string['rsssubscriberssdiscussions'] = 'RSS-Feed für Themen';
$string['rsssubscriberssposts'] = 'RSS-Feed für Beiträge';
$string['rsstype'] = 'RSS-Feed für diese Aktivität';
$string['rsstype_help'] = 'Um einen RSS-Feed für diese Aktivität zu aktivieren, wählen Sie, ob Themen oder Beiträge im Feed angezeigt werden sollen.';
$string['rsstypedefault'] = 'RSS-Typ';
$string['search'] = 'Suche';
$string['search:activity'] = 'Open Forum - Aktivitätsinformationen';
$string['search:post'] = 'Open Forum - Beiträge';
$string['searchdatefrom'] = 'Beiträge müssen neuer sein als';
$string['searchdateto'] = 'Beiträge müssen älter sein als';
$string['searchforumintro'] = 'Geben Sie Suchbegriffe in eines oder mehrere der folgenden Felder ein:';
$string['searchforums'] = 'Suchen';
$string['searchfullwords'] = 'Diese Wörter sollten als ganze Wörter erscheinen';
$string['searchnotwords'] = 'Diese Wörter sollten NICHT enthalten sein';
$string['searcholderposts'] = 'Ältere Beiträge durchsuchen...';
$string['searchphrase'] = 'Genau diese Phrase muss im Beitrag erscheinen';
$string['searchresults'] = 'Suchergebnisse';
$string['searchsubject'] = 'Diese Wörter sollten im Betreff stehen';
$string['searchtags'] = 'hat diese Schlagworte';
$string['searchuser'] = 'Dieser Name sollte mit dem Autor übereinstimmen';
$string['searchuserid'] = 'Moodle-ID des Autors';
$string['searchwhichforums'] = 'Wählen Sie, welche Foren durchsucht werden';
$string['searchwords'] = 'Diese Worte können irgendwo im Beitrag auftauchen';
$string['seeallposts'] = 'Alle Beiträge dieses Nutzers ansehen';
$string['shortpost'] = 'Kurzbeitrag';
$string['showbookmark'] = 'Lesezeichen für Beiträge erlauben';
$string['showbookmark_help'] = 'Wenn diese Option aktiviert ist, kann auf Forenbeiträge ein Lesezeichen gesetzt werden';
$string['showbookmarkdisabledglobally'] = 'Lesezeichen wurden global für Plugins deaktiviert.';
$string['showdiscussionsubscribers'] = 'Abonnenten des Themas anzeigen/bearbeiten';
$string['showrecent'] = 'Neueste Beiträge auf der Kursseite anzeigen';
$string['showrecent_help'] = 'Wenn diese Option aktiviert ist, werden die neuesten Beiträge auf der Kursseite angezeigt.';
$string['showsubscribers'] = 'Abonnenten des Forums anzeigen/bearbeiten';
$string['showsubstantive'] = 'Kennzeichnung als "wertvoll" erlauben';
$string['showsubstantive_help'] = 'Wenn diese Option aktiviert wurde, könnten Trainer Beiträge als "wertvoll" kennzeichnen';
$string['showsubstantivedisabledglobally'] = 'Die Kennzeichnung als "wertvoll" wurde global deaktiviert.';
$string['singleforum'] = 'Ein einfaches Diskussionsforum';
$string['smallmessage'] = '{$a->user} hat in {$a->forumname} einen Beitrag erstellt';
$string['smallmessagedigest'] = 'Die Forenzusammenfassung enthält {$a} Nachrichten';
$string['sortdiscussions'] = 'Themen sortieren';
$string['sortdiscussionsby'] = 'Sortieren';
$string['splitprivatewarning'] = 'Sie teilen eine private Antwort. Nach dem Teilen wird dieser Beitrag nicht länger privat sein.';
$string['startedby'] = 'Begonnen von';
$string['startedbyx'] = 'Begonnen von {$a}';
$string['startedbyxgroupx'] = 'Begonnen von {$a->name} für Gruppe {$a->group}';
$string['subject'] = 'Betreff';
$string['subjectbyprivateuserondate'] = '{$a->subject} (privat) von {$a->author} am {$a->date}';
$string['subjectbyuserondate'] = '{$a->subject} von {$a->author} am {$a->date}';
$string['subjectisrequired'] = 'Der Betreff ist erforderlich';
$string['subjectplaceholder'] = 'Ihr Betreff';
$string['submit'] = 'Absenden';
$string['subscribe'] = 'Dieses Forum abonnieren';
$string['subscribeall'] = 'Abonnement für alle Benutzer';
$string['subscribed'] = 'Abonniert';
$string['subscribedisc'] = 'Dieses Thema abonnieren';
$string['subscribeenrolledonly'] = 'Entschuldigung, nur eingeschriebene Teilnehmer/innen können Forenbeiträge abonnieren.';
$string['subscribenone'] = 'Abonnement für alle Nutzer/innen aufheben';
$string['subscribers'] = 'Abonnent/innen';
$string['subscriberstowithcount'] = 'Abonnent/innen von  "{$a->name}" ({$a->count})';
$string['subscribeshort'] = 'Abonnieren';
$string['subscribestart'] = 'Ich möchte über neue Beiträge in diesem Forum informiert werden';
$string['subscribestop'] = 'Ich möchte nicht mehr über neue Beiträge in diesem Forum informiert werden';
$string['subscription'] = 'Abonnement';
$string['subscription_help'] = 'Wenn Sie ein Forum abonniert haben, erhalten Sie eine Benachrichtigung über neue Forenbeiträge. Normalerweise können Sie wählen, ob Sie ein Forum abonnieren wollen oder nicht, aber manchmal ist ein Abonnement verpflichtend, so dass alle Teilnehmer eine Benachrichtigung erhalten.';
$string['subscriptionauto'] = 'Auto-Abonnement';
$string['subscriptiondisabled'] = 'Abonnement deaktviert';
$string['subscriptionforced'] = 'Verpflichtendes Abonnement';
$string['subscriptionmode'] = 'Art des Abonnements';
$string['subscriptionmode_help'] = 'Wenn ein Teinehmer / eine Teilnehmerin ein Forum abonniert hat, bedeutet dies, dass sie über neue Forenbeiträge benachrichtigt werden. Es gibt 4 Optionen des Abonnements:

* Optionales Abonnement - Nutzer/innen können entscheiden ob sie abonnieren wollen.
* Verpflichtendes Abonnement - Alle haben das Forum abonniert und niemand kann es abbestellen.
* Automatisches Abonnement - Alle haben das Forum zunächst abonniert, dürfen es aber jederzeit abbestellen.
* Abonnement deaktiviert - Das Forum kann von niemandem abonniert werden.';
$string['subscriptionoptional'] = 'Optionales Abonnement';
$string['subscriptions'] = 'Abonnements';
$string['substantive'] = 'Wertvoll';
$string['switchtoaccessible'] = 'Zu aufrufbarer Ansicht wechseln';
$string['tagarea_hsuforum_posts'] = 'Forenbeiträge';
$string['tagsdeleted'] = 'Schlagwörter des Forums wurden gelöscht';
$string['thisforumisthrottled'] = 'Dieses Forum hat eine Obergrenze für Beiträge die innerhalb eines festgelegten Zeitraums veröffentlicht werden können - diese Grenze liegt aktuell bei {$a->blockafter} Beiträgen in {$a->blockperiod}';
$string['thisisanonymous'] = 'Dieses Forum ist anonym';
$string['timedhidden'] = 'Status Zeitsteuerung: Für Teilnehmer verborgen';
$string['timedposts'] = 'Zeitgesteuerte Beiträge';
$string['timedvisible'] = 'Status Zeitsteuerung: Für alle Nutzer/innen sichtbar';
$string['timestartenderror'] = 'Das Enddatum für die Anzeige kann nciht vor dem Startdatum liegen.';
$string['toggle:bookmark'] = 'Lesezeichen';
$string['toggle:subscribe'] = 'Abonnieren';
$string['toggle:substantive'] = 'Wertvoll';
$string['toggled:bookmark'] = 'Lesezeichen gesetzt';
$string['toggled:subscribe'] = 'Abonniert';
$string['toggled:substantive'] = 'Als wertvoll markiert';
$string['totaldiscussions'] = 'Beiträge: {$a}';
$string['totalposts'] = 'Beiträge insgesamt';
$string['totalpostsanddiscussions'] = 'Beiträge insgesamt: {$a}';
$string['totalrating'] = 'Bewertung: {$a}';
$string['totalreplies'] = 'Antworten: {$a}';
$string['totalsubstantive'] = 'Wertvolle Beiträge: {$a}';
$string['trackforum'] = 'Ungelesene Beiträge markieren';
$string['trackingoptions'] = 'Nachverfolgungsoptionen';
$string['trackreadposts_header'] = 'Forumnachverfolgung';
$string['tree'] = 'Baum';
$string['unread'] = 'Neu';
$string['unreadposts'] = 'Ungelesene Beiträge';
$string['unreadpostsnumber'] = '{$a} ungelesene Beiträge';
$string['unreadpostsone'] = '1 ungelesener Beitrag';
$string['unreadx'] = 'Ungelesen: {$a}';
$string['unsubscribe'] = 'Abonnement dieses Forums aufheben';
$string['unsubscribeall'] = 'Alle Abonnements aufheben';
$string['unsubscribeallconfirm'] = 'Sie haben  {$a} Foren abonniert. Wollen Sie wirklich alle Abonnements aufheben und das Auto-Abonnement deaktivieren?';
$string['unsubscribealldone'] = 'Alle optionalen Forenabonnements wurden aufgehoben. Sie erhalten weiterhin Benachrichtigungen von Foren mit verpflichtendem Abonnement. Um die Forenbenachrichtigungen zu verwalten gehen Sie zu Nachrichten in Ihren Profileinstellungen.';
$string['unsubscribeallempty'] = 'Sie haben kein Forum abonniert. Um alle Beachrichtigungen von diesem Server auszuschalten, gehen Sie zu Mitteilungen in Ihren Profileinstellungen.';
$string['unsubscribed'] = 'Abgemeldet';
$string['unsubscribedisc'] = 'Von diesem Thema abmelden';
$string['unsubscribediscussion'] = 'Von diesem Thema abmelden';
$string['unsubscribediscussionlink'] = 'Von diesem Thema abmelden:  {$a}';
$string['unsubscribelink'] = 'Von diesem Forum abmelden:  {$a}';
$string['unsubscribeshort'] = 'Abmelden';
$string['useadvancededitor'] = 'Erweiterten Editor und zusätzliche Optionen nutzen';
$string['usermarksread'] = 'Manuelle Gelesen-Markierung';
$string['validationerrorsx'] = 'Es gab {$a->count} Fehler mit Ihrem Abonnement: {$a->errors}';
$string['validationerrorx'] = 'Es gab einen Fehler beim Absenden: {$a}';
$string['viewalldiscussions'] = 'Alle Themen ansehen';
$string['viewposters'] = 'Autor/in von Beiträgen ansehen';
$string['viewthediscussion'] = 'Das Thema ansehen';
$string['warnafter'] = 'Beitragsgrenze für Warnung';
$string['warnafter_help'] = 'Teilnehmer/innen können gewarnt werden, wenn sie sich der Beitragsgrenze nähern, die für einen bestimmten Zeitraum erlaubt ist. Diese Einstellung legt fest, nach wie vielen Beiträgen gewarnt wird. Nutzer/innen mit der Berechtigung mod/hsuforum:postwithoutthrottling sind von dieser Grenze ausgenommen.';
$string['warnformorepost'] = 'Achtung! Es gibt mehr als ein Thema in diesem Forum - das neueste wird verwendet';
$string['xdiscussions'] = '{$a} Themen';
$string['xreplies'] = '{$a} Antworten';
$string['xunread'] = '{$a} neu';
$string['yournewquestion'] = 'Ihre neue Frage';
$string['yournewtopic'] = 'Ihr neues Diskussionsthema';
$string['yourreply'] = 'Ihre Antwort';
