<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'et', version '3.8'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Sul on saabuvaid BigBlueButtonBN-i seansse';
$string['bbbduetimeoverstartingtime'] = 'Tegevuse tähtaeg peab olema algusajast hilisem';
$string['bbbdurationwarning'] = 'Selle seansi maksimumkestus on %duration% minutit.';
$string['bbbrecordallfromstartwarning'] = 'Seda seanssi salvestatakse algusest.';
$string['bbbrecordwarning'] = 'Selle seansi võib salvestada.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Lisa uus koosolek';
$string['bigbluebuttonbn:join'] = 'Liitu koosolekuga';
$string['bigbluebuttonbn:managerecordings'] = 'Halda salvestusi';
$string['bigbluebuttonbn:meeting'] = 'Loo reaalajas kohtumise võimekusega instantse';
$string['bigbluebuttonbn:recording'] = 'Loo salvestamise võimekusega instantse';
$string['bigbluebuttonbn:view'] = 'Vaata ruumi/tegevust';
$string['calendarstarts'] = '{$a} on planeeritud';
$string['completionattendance'] = 'Õpilane peab koosolekul osalema:';
$string['completionattendancedesc'] = 'Õpilane peab koosolekul osalema ja sessioonil viibima vähemalt {$a} minutit';
$string['completionattendancegroup'] = 'Nõua osalemist';
$string['completionattendancegroup_help'] = 'Lõpetamiseks on vajalik koosolekul osalemine (n) minutit';
$string['completionengagementchats'] = 'Vestluse sündmused';
$string['completionengagementdesc'] = 'Õpilane peab koosoleku ajal osalema tegevustes';
$string['completionengagementemojis'] = 'Emotikonid';
$string['completionengagementgroup'] = 'Nõua osalemist';
$string['completionengagementgroup_help'] = 'Lõpetamiseks on vajalik aktiivne osalemine seansi ajal';
$string['completionengagementpollvotes'] = 'Küsitluse hääled';
$string['completionengagementraisehand'] = 'Tõsta käsi sündmused';
$string['completionengagementtalks'] = 'Rääkimise sündmused';
$string['completionengagementtalktime'] = 'Rääkimise aeg';
$string['completionupdatestate'] = 'Lõpetamise värskenduse olek';
$string['completionvalidatestate'] = 'Kinnita lõpetamine';
$string['completionvalidatestatetriggered'] = 'Valideerimise lõpetamine on käivitatud.';
$string['config_clienttype'] = 'Seadistus veebikliendi tüübi jaoks';
$string['config_clienttype_default'] = 'Vaikimisi veebikliendi tüüp';
$string['config_clienttype_default_description'] = 'Vali klassikalise Adobe Flach kliendi või uue HTML5 vahel.';
$string['config_clienttype_description'] = 'See säte lubab / keelab veebikliendi valiku igas toas.';
$string['config_clienttype_editable'] = 'Veebikliendi valikut saab muuta';
$string['config_clienttype_editable_description'] = 'See valik võimaldab ruumi muutmise vormil valida veebiklienti (AdobeFlash/HTML5)';
$string['config_disablecam_default'] = 'Keela vaikimisi kaamera';
$string['config_disablecam_default_description'] = 'Kui see on lubatud, keelatakse veebikaamerad.';
$string['config_disablecam_editable'] = 'Keela kaamera saab muuta';
$string['config_disablecam_editable_description'] = 'Vaikimisi kaamera keelamise saab muuta, kui instantsi lisatakse või värskendatakse.';
$string['config_disablemic_default'] = 'Keela mikrofon vaikimisi lubatud';
$string['config_disablemic_default_description'] = 'Kui see on lubatud, keelatakse mikrofonid.';
$string['config_disablemic_editable'] = 'Keela mikrofon sätet saab muuta';
$string['config_disablemic_editable_description'] = 'Vaikimisi mikrofoni keelamist saab muuta, kui instantsi lisatakse või värskendatakse.';
$string['config_disablenote_default'] = 'Keela jagatud märkmed on vaikimisi lubatud';
$string['config_disablenote_default_description'] = 'Kui see on lubatud, keelatakse jagatud märkmed.';
$string['config_disablenote_editable'] = 'Keela jagatud märkmeid seadet saab muuta';
$string['config_disablenote_editable_description'] = 'Keela vaikimisi jagatud märkmeid saab muuta, kui instantsi lisatakse või värskendatakse.';
$string['config_disableprivatechat_default'] = 'Privaatsõnumite keelamine on vaikimisi lubatud';
$string['config_disableprivatechat_default_description'] = 'Kui see on lubatud, keelatakse privaatne vestlus.';
$string['config_disableprivatechat_editable'] = 'Keela privaatne vestlus seadet saab muuta';
$string['config_disableprivatechat_editable_description'] = 'Keela  privaatvestlus seadet saab muuta, kui instantsi lisatakse või värskendatakse.';
$string['config_disablepublicchat_default'] = 'Keela avalik vestlus on vaikimisi lubatud';
$string['config_disablepublicchat_default_description'] = 'Kui lubatud, siis avalik vestlus on keelatud';
$string['config_disablepublicchat_editable'] = 'Keela avalik vestlus seadet saab muuta';
$string['config_disablepublicchat_editable_description'] = 'Keela avalik vestlus vaikimisi seadet saab muuta kui instantsi lisatakse või uuendatakse';
$string['config_experimental_features'] = 'Eksperimentaalsete funktsioonide seadistamine';
$string['config_experimental_features_description'] = 'Eksperimentaalsete funktsioonide seadistamine';
$string['config_extended_capabilities'] = 'Laiendatud tegevuslubade konfiguratsioon';
$string['config_extended_capabilities_description'] = 'Laiendatud tegevuslubade konfiguratsioon, kui BigBlueButtoni server neid pakub.';
$string['config_general'] = 'Üldine konfiguratsioon';
$string['config_general_description'] = 'Neid sätteid kasutatakse <b>alati</b>';
$string['config_hideuserlist_default'] = 'Peida kasutajate nimekiri on vaikimisi lubatud';
$string['config_hideuserlist_default_description'] = 'Kui lubatud, on sessiooni kasutajate nimekiri peidetud.';
$string['config_hideuserlist_editable'] = 'Peida kasutajate nimekiri sätet on võimalik muuta';
$string['config_hideuserlist_editable_description'] = 'Peida vaikimisi kasutajate nimekiri seadet saab muuta kui instants lisatakse või uuendatakse.';
$string['config_importrecordings'] = 'Seadistus "Impordi salvestused" funktsiooni jaoks';
$string['config_importrecordings_description'] = 'Need seaded on funktsioonipõhised';
$string['config_importrecordings_enabled'] = 'Salvestuste importimine on võimaldatud';
$string['config_importrecordings_enabled_description'] = 'Kui see seadistus on võimaldatud, on tegevuse külge võimalik importida salvestusi erinevate kursuste küljest.';
$string['config_importrecordings_from_deleted_enabled'] = 'Salvestuste importimine kustutatud tegevuste küljest on võimaldatud.';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Kui see ja salvestuste importimise funktsioon on lubatud, on võimalik importida salvestusi tegevustest, mis ei ole enam kursuse küljes.';
$string['config_lockedlayout_default'] = 'Lukustatud paigutus on vaikimisi lubatud';
$string['config_lockedlayout_default_description'] = 'Kui lubatud sessiooni paigutus on lukustatud.';
$string['config_lockedlayout_editable'] = 'Lukustatud paigutuse seadet saab muuta';
$string['config_lockedlayout_editable_description'] = 'Vaikimisi lukustatud paigutust saab muuta kui instants lisatakse või uuendatakse.';
$string['config_lockonjoin_default'] = 'Ignoreeri liitumisel lukustust on vaikimisi lubatud';
$string['config_lockonjoin_default_description'] = 'Kui see on lubatud, eiratakse lukustusseadeid. Selle rakendamiseks peab olema lubatud lukukonfiguratsioon.';
$string['config_lockonjoin_editable'] = 'Ignoreeri liitumisel lukustuste seadet saab muuta';
$string['config_lockonjoin_editable_description'] = 'Ignoreeri vaikimisi liitumise seadet saab muuta kui instantsi lisatakse või uuendatakse.';
$string['config_lockonjoinconfigurable_default'] = 'Lukusta konfiguratsioon on vaikimisi lubatud';
$string['config_lockonjoinconfigurable_default_description'] = 'Kui see on lubatud, saab seansiluku seadeid lubada või keelata ülaltoodud juhtnupu abil.';
$string['config_lockonjoinconfigurable_editable'] = 'Lukustuse seadeid saab muuta';
$string['config_lockonjoinconfigurable_editable_description'] = 'Vaikimisi saab lukustamise konfiguratsiooni muuta, kui instantsi lisatakse või värskendatakse.';
$string['config_locksettings'] = 'Konfiguratsioon lukustamise seadete jaoks';
$string['config_locksettings_description'] = 'Need sätted lubavad või keelavad kasutajaliidese seadete lukustamise seaded ja määravad ka nende seadete vaikeväärtused.';
$string['config_meetingevents_enabled'] = 'Registreeri otseülekanne';
$string['config_meetingevents_enabled_description'] = 'Luba pluginal pärast seansi lõppu aktsepteerida ja töödelda otseülekandeid. (See funktsioon on katseline ja töötab ainult juhul kui BBB server on võimeline töötlema post_events tüüpi skripte)';
$string['config_muteonstart'] = 'Seadistsus "Vaigista algusest" funktsioon';
$string['config_muteonstart_default'] = 'Seadistus "Vaigista alguses" on vaikimisi lubatud';
$string['config_muteonstart_default_description'] = 'Kui lubatud, on seanss selle alguses vaigistatud.';
$string['config_muteonstart_description'] = 'Need seaded lubavad või keelavad valikud kasutajaliideses. Samuti defineerivad nende valikute vaikeväärtused.';
$string['config_muteonstart_editable'] = '"Vaigista alguses" funktsiooni saab muuta';
$string['config_muteonstart_editable_description'] = '"Vaigista alguses" vaikeseadet saab muuta instantsi lisamisel ja uuendamisel.';
$string['config_participant'] = 'Osalejate seadistamine';
$string['config_participant_description'] = 'Need seaded määratlevad konverentsil osalejatel vaikimisi rolli.';
$string['config_participant_moderator_default'] = 'Vaikimisi moderaator';
$string['config_participant_moderator_default_description'] = 'Seda reeglit kasutatakse vaikimisi uue ruumi lisamisel.';
$string['config_presentation_default'] = 'Vaikefail "Esitluse eellaadimise" funktsiooni jaoks.';
$string['config_presentation_default_description'] = 'See säte võimaldab valida faili, mida kasutada vaikimisi kõigil BBB-instantsidel, kui funktsioon "Eellaaditav esitlus" on lubatud.';
$string['config_preuploadpresentation'] = 'Seaditus "Eellaaditava esitlus" funktsiooni jaoks';
$string['config_preuploadpresentation_description'] = 'Need seaded lubavad või keelavad valikud kasutajaliideses. Samuti defineerivad nende valikute vaikeväärtused. Funktsioon töötab ainult siis kui Moodle\'i server on BigBlueButtonile kättesaadav.';
$string['config_preuploadpresentation_enabled'] = 'Eellaaditava esitluse funktsioon on lubatud';
$string['config_preuploadpresentation_enabled_description'] = 'Esitluse eellaadimise funktsioon on kasutajaliideses lubatud juhul kui ruum või konverents on lisatud või uuendatud.';
$string['config_recording'] = 'Seadistus "Salvesta kohtumine" funktsiooni jaoks';
$string['config_recording_all_from_start_default'] = 'Salvesta kõik algusest';
$string['config_recording_all_from_start_default_description'] = 'Kui valitud, salvestatakse kohtumine algusest';
$string['config_recording_all_from_start_editable'] = 'Valikut "Salvesta kõik algusest" saab muuta';
$string['config_recording_all_from_start_editable_description'] = 'Kui see on märgitud, sisaldab liides võimalust lubada ja keelata funktsioon algusest peale.';
$string['config_recording_default'] = 'Salvestamise funktsioon on vaikimisi lubatud';
$string['config_recording_default_description'] = 'Kui lubatud, on loodud BigBlueButtoni seanssidel salvetamise võimekus.';
$string['config_recording_description'] = 'Need seaded on funktsioonipõhised';
$string['config_recording_editable'] = 'Salvestuste funktsiooni saab muuta';
$string['config_recording_editable_description'] = 'Kui märgitud, sisaldab kasutajaliides valikut salvestuse funktsiooni võimaldada/mitte võimaldada.';
$string['config_recording_hide_button_default'] = 'Peida salvestamise nupp';
$string['config_recording_hide_button_default_description'] = 'Kui märgitud, on salvestamise nupp peidetud';
$string['config_recording_hide_button_editable'] = 'Peida salvetamise nupu funktsiooni saab muuta';
$string['config_recording_hide_button_editable_description'] = 'Kui märgitud, sisaldab kasutajaliides võimalust lubada/mitte lubada salvestamise nupu peitmise.';
$string['config_recording_icons_enabled'] = 'Salvetamise haldamise ikoonid';
$string['config_recording_icons_enabled_description'] = 'Kui lubatud, kuvatakse salvestuse halduspaneelil avaldatud/avaldamata ja kustuta ikoone.';
$string['config_recordingready_enabled'] = 'Saada teade kui salvestus on valmis';
$string['config_recordingready_enabled_description'] = 'Luba pluginal saata teateid kui salvestused on valmis. (Töötab ainult siis kui skript post_publich_recording_ready_callback on BBB serveris lubatud)';
$string['config_recordings'] = 'Funktsiooni "Kuva salvestused" seaded';
$string['config_recordings_deleted_default'] = 'Luba vaikimisi funktsioon "kaasa salvestused kustutatud tegevuste küljest"';
$string['config_recordings_deleted_default_description'] = 'Kui see on lubatud, sisaldab tabel salvestusi mis kuuluvad kustutatud tegevuste külge.';
$string['config_recordings_deleted_editable'] = 'Funktsiooni "kaasa salvestused kustutatud tegevuste küljest" saab muuta';
$string['config_recordings_deleted_editable_description'] = 'Funktsiooni "kaasa salvestused kustutatud tegevuste küljest" saab muuta kui kirje on lisatud või uuendatud.';
$string['config_recordings_description'] = 'Need seaded on funtsiooni põhised';
$string['config_recordings_general'] = 'Kuva salvestuste seaded';
$string['config_recordings_general_description'] = 'Neid seadistusi kasutatakse ainult salvestuste kuvamisel';
$string['config_recordings_html_default'] = 'Kasutajaliides kui html on vaikimisi lubatud';
$string['config_recordings_html_default_description'] = 'Kui lubatud, kuvatakse salvestuste tabel vaikimisi HTML-ina.';
$string['config_recordings_html_editable'] = 'Kasutajaliidest kui html-i saab muuta';
$string['config_recordings_html_editable_description'] = 'Kasutajaliidest kui html-i väärtust saab muuta kui kirje on lisatud või seda on uuendatud.';
$string['config_recordings_imported_default'] = 'Kuva ainult vaikimisi lubatud imporditud lingid';
$string['config_recordings_imported_default_description'] = 'Kui see on lubatud, sisaldab salvestustabel ainult imporditud linke salvestustele.';
$string['config_recordings_imported_editable'] = '"Näita ainult imporditud linke" funktsiooni saab muuta';
$string['config_recordings_imported_editable_description'] = '"Näita vaikimisi ainult imporditud linke" funktsiooni saab muuta kui kirje on lisatud või seda on uuendatud.';
$string['config_recordings_preview_default'] = 'Eelvaade on vaikimisi lubatud';
$string['config_recordings_preview_default_description'] = 'Kui lubatud, sisaldab tabel esitluse eelvaadet.';
$string['config_recordings_preview_editable'] = 'Eelvaate funktsiooni saab muuta';
$string['config_recordings_preview_editable_description'] = 'Eelvaate funktsiooni saab muuta kui kirje on lisatud või seda on uuendatud.';
$string['config_recordings_sortorder'] = 'Kuva salvestised kasvavas järjekorras.';
$string['config_recordings_sortorder_description'] = 'Vaikimisi on salvestised kuvatud kahanevas järjekorras. Kui märgitud, kuvatakse need kasvavas järjekorras.';
$string['config_recordings_validate_url'] = 'Valideeri URL';
$string['config_recordings_validate_url_description'] = 'Kui see on märgitud, kinnitatakse taasesituse URL enne, kui kasutaja sellele juurde pääseb.';
$string['config_scheduled'] = 'Funktsiooni „Plaanitud seansid“ konfiguratsioon';
$string['config_scheduled_description'] = 'Need sätted määratlevad plaanitud seansside jaoks teatud vaikekäitumise.';
$string['config_scheduled_duration_compensation'] = 'Kompenseeriv aeg (minutites)';
$string['config_scheduled_duration_compensation_description'] = 'Plaanitud sulgemisajale lisatud minutid kestuse arvutamisel.';
$string['config_scheduled_duration_enabled'] = 'Kestuse arvutamine on lubatud';
$string['config_scheduled_duration_enabled_description'] = 'Plaanitud seansi kestus arvutatakse avamis- ja sulgemisaegade põhjal.';
$string['config_scheduled_pre_opening'] = 'Juurdepääsetav enne avamisaega (minutites)';
$string['config_scheduled_pre_opening_description'] = 'Aeg minutites, mille jooksul on seanss enne plaanitud avamisaega juurdepääsetav.';
$string['config_sendnotifications'] = 'Funktsiooni "Teavituste saatmine" seaded';
$string['config_sendnotifications_description'] = 'Need seaded lubavad või keelavad valikud kasutajaliideses. Samuti defineerivad nende valikute vaikeväärtused.';
$string['config_sendnotifications_enabled'] = 'Teadete saatmine on lubatud';
$string['config_sendnotifications_enabled_description'] = 'Kui lubatud, sisaldab kasutajaliides võimalust saata teateid registreerunud kasutajatele kui tegevus on lisatud või seda on uuendatud.';
$string['config_server_url'] = 'BigBlueButtoni serveri URL';
$string['config_server_url_description'] = 'BigBlueButtoni serveri URL-i lõpus peab olema string /bigbluebutton/. (See vaike-URL on mõeldud Blindside Networksi pakutava BigBlueButtoni serveri jaoks, mida saate kasutada testimiseks.)';
$string['config_shared_secret'] = 'BigBlueButtoni ühissaladus';
$string['config_shared_secret_description'] = 'Teie BigBlueButtoni serveri turbesool. (See vaikesool on mõeldud Blindside Networksi pakutava BigBlueButtoni serveri jaoks, mida saate kasutada testimiseks.)';
$string['config_uidelegation_enabled'] = 'Kasutajaliidese delegeerimine on lubatud';
$string['config_uidelegation_enabled_description'] = 'Need seadistused lubavad või keelavad kasutajaliidese delegeerimise BigBlueButtoni serverisse.';
$string['config_userlimit'] = 'Funktsiooni "Kasutajate limiit" seadistamine';
$string['config_userlimit_default'] = 'Kasutajate limiit on vaikimisi lubatud';
$string['config_userlimit_default_description'] = 'Uue ruumi või konverentsi lisamisel vaikimisi sessioonile lubatud kasutajate arv. Kui arv on seatud 0-le, siis limiiti ei seata';
$string['config_userlimit_description'] = 'Need seaded lubavad või keelavad valikud kasutajaliideses. Samuti defineerivad nende valikute vaikeväärtused.';
$string['config_userlimit_editable'] = 'Funktsiooni "Kasutajate limiit" saab muuta';
$string['config_userlimit_editable_description'] = 'Vaikimisi seatud kasutajate limiidi väärtust saab muuta kui lisatakse ruum/konverents või neid on muudetud.';
$string['config_voicebridge'] = 'Funktsiooni "Voice brige" seaded';
$string['config_voicebridge_description'] = 'Need seaded lubavad või keelavad valikud kasutajaliideses. Samuti defineerivad nende valikute vaikeväärtused.';
$string['config_voicebridge_editable'] = 'Konverentsi häälesilda saab muuta';
$string['config_voicebridge_editable_description'] = 'Konverentsi hääle silla numbri saab ruumikonverentsile püsivalt määrata. Kui number on määratud, ei saa seda kasutada üheski teises ruumis ega konverentsil';
$string['config_waitformoderator'] = 'Funktsiooni "Oota moderaatorit" seaded';
$string['config_waitformoderator_cache_ttl'] = 'Oota moderaatori vahemälu TTL (sekundit)';
$string['config_waitformoderator_cache_ttl_description'] = 'Klientide suure koormuse toetamiseks kasutab see plugin vahemälu. See parameeter määrab vahemälu säilitamise aja enne järgmise päringu saatmist BigBlueButtoni serverisse.';
$string['config_waitformoderator_default'] = '"Oota moderaatorit" on vaikimisi lubatud';
$string['config_waitformoderator_default_description'] = '"Oota moderaatorit" funktsioon on vaikimisi lubatud kui lisatakse uus ruum või konverents.';
$string['config_waitformoderator_description'] = 'Need seaded on funktsioonipõhised';
$string['config_waitformoderator_editable'] = '"Oota moderaatorit" funktsiooni saab muuta';
$string['config_waitformoderator_editable_description'] = '"Oota moderatoorit" vaikeväärtusi saab muuta kui lisatakse ruum/konverents või neid on muudetud.';
$string['config_waitformoderator_ping_interval'] = 'Oota moderaatori pingimist (sekundit)';
$string['config_waitformoderator_ping_interval_description'] = 'Kui moderaatori ootamise funktsioon on lubatud, annab klient seansi oleku iga [number] sekundi järel. See parameeter määrab Moodle\'i serverile tehtud päringute intervalli';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonBN kasutab config.php-d globaalse muutujaga, mis on iganenud. Teisenda fail, kuna seda ei toetata järgmistes versioonides';
$string['config_warning_curl_not_installed'] = 'Selle funktsiooni kasutamiseks peab CURL-laiend olema PHP jaoks installitud ja lubatud. Sätetele pääseb juurde ainult siis, kui see tingimus on täidetud.';
$string['email_body_notification_meeting_by'] = 'autor';
$string['email_body_notification_meeting_description'] = 'Kirjeldus';
$string['email_body_notification_meeting_details'] = 'Üksikasjad';
$string['email_body_notification_meeting_end_date'] = 'Lõppkuupäev';
$string['email_body_notification_meeting_has_been'] = 'on olnud';
$string['email_body_notification_meeting_start_date'] = 'Alguskuupäev';
$string['email_body_notification_meeting_title'] = 'Pealkiri';
$string['email_body_recording_ready_for'] = 'Salvestus järgmise jaoks:';
$string['email_body_recording_ready_is_ready'] = 'on valmis';
$string['email_footer_sent_by'] = 'Selle automaatse teatissõnumi saatis';
$string['email_footer_sent_from'] = 'kursuselt';
$string['ends_at'] = 'Lõpeb';
$string['event_activity_created'] = 'BigBlueButtonBNi tegevus on loodud';
$string['event_activity_deleted'] = 'BigBlueButtonBNi tegevus on kustutatud';
$string['event_activity_updated'] = 'Tegevus uuendatud';
$string['event_activity_viewed'] = 'BigBlueButtonBNi tegevust on vaadatud';
$string['event_live_session'] = 'Sessiooni otseülekanne';
$string['event_meeting_created'] = 'BigBlueButtonBNi koosolek on loodud';
$string['event_meeting_ended'] = 'BigBlueButtonBNi koosolek sundlõpetati';
$string['event_meeting_joined'] = 'BigBlueButtonBNi koosolekuga liitutud';
$string['event_meeting_left'] = 'BigBlueButtonBNi koosolekult lahkutud';
$string['event_recording_deleted'] = 'Salvestus on kustutatud';
$string['event_recording_edited'] = 'Salvestus muudetud';
$string['event_recording_imported'] = 'Salvestus on imporditud';
$string['event_recording_protected'] = 'Salvestus kaitstud';
$string['event_recording_published'] = 'Salvestus on avaldatud';
$string['event_recording_unprotected'] = 'Salvestus on kaitsmata';
$string['event_recording_unpublished'] = 'Salvestuse avaldamine on tühistatud';
$string['event_recording_viewed'] = 'Salvestus on vaadatud';
$string['general_error_not_allowed_to_create_instances'] = 'Kasutajal ei ole lubatud luua ühtegi kirjet';
$string['general_error_unable_connect'] = 'Ei saa ühendust luua. Kontrollige, kas BigBlueButtoni serveri URL on õige JA server ise töökorras.';
$string['index_confirm_end'] = 'Kas soovite veebiseminari lõpetada?';
$string['index_disabled'] = 'keelatud';
$string['index_enabled'] = 'lubatud';
$string['index_ending'] = 'Veebiseminari lõpetamine... oodake';
$string['index_error_bbtn'] = 'BigBlueButtoni ID {$a} on vale';
$string['index_error_checksum'] = 'Kontrollsumma viga. Kontrollige, kas sisestasite õige soola.';
$string['index_error_forciblyended'] = 'Selle veebiseminariga ei saa liituda, kuna see on lõpetatud.';
$string['index_error_noinstances'] = 'BigBlueButtoni instantsid puuduvad';
$string['index_error_unable_display'] = 'Koosolekute loendi kuvamine nurjus. Kontrollige, kas BigBlueButtoni serveri URL on õige JA server ise töökorras.';
$string['index_heading'] = 'BigBlueButtoni ruumid';
$string['index_heading_actions'] = 'Toimingud';
$string['index_heading_group'] = 'Rühm';
$string['index_heading_moderator'] = 'Juhatajad';
$string['index_heading_name'] = 'Ruum';
$string['index_heading_recording'] = 'Salvestus';
$string['index_heading_users'] = 'Kasutajad';
$string['index_heading_viewer'] = 'Vaatajad';
$string['indicator:cognitivedepth'] = 'Kognitiivne BigBlueButtonBN';
$string['indicator:cognitivedepth_help'] = 'See indikaator põhineb tunnetuslikul sügavusel, mille õpilane on saavutanud BigBlueButtonBN tegevuses.';
$string['indicator:socialbreadth'] = 'Sotsiaalne BigBlueButtonBN';
$string['indicator:socialbreadth_help'] = 'See näitaja põhineb sotsiaalsel laiusel, mille õpilane on BigBlueButtonBN tegevuses saavutanud.';
$string['instance_type_default'] = 'Ruum/tegevus salvestustega';
$string['instance_type_recording_only'] = 'Ainult salvestused';
$string['instance_type_room_only'] = 'Ainult ruum/tegevus';
$string['minute'] = 'minut';
$string['minutes'] = 'minutid';
$string['mod_form_block_clienttype'] = 'Veebikliendi tehnoloogia';
$string['mod_form_block_clienttype_flash'] = 'Adobe Flash tehnoloogial põhinev klientprogramm';
$string['mod_form_block_clienttype_html5'] = 'HTML5 tehnoloogial põhinev klientprogramm';
$string['mod_form_block_general'] = 'Üldsätted';
$string['mod_form_block_participants'] = 'Live-seansi ajal määratud roll';
$string['mod_form_block_presentation'] = 'Esitluse sisu';
$string['mod_form_block_presentation_default'] = 'Presentatsiooni vaike sisu';
$string['mod_form_block_record'] = 'Salvestussätted';
$string['mod_form_block_recordings'] = 'Salvestuste vaade';
$string['mod_form_block_room'] = 'Tegevuste/ruumide seaded';
$string['mod_form_block_schedule'] = 'Sündmuse ajakava';
$string['mod_form_field_block_clienttype'] = 'Veebikliendi tehnoloogia';
$string['mod_form_field_closingtime'] = 'Liitumine on suletud';
$string['mod_form_field_conference_name'] = 'Konverentsi nimi';
$string['mod_form_field_disablecam'] = 'Keela veebikaamerad';
$string['mod_form_field_disablemic'] = 'Keela mikrofonid';
$string['mod_form_field_disablenote'] = 'Keela jagatud märkmed';
$string['mod_form_field_disableprivatechat'] = 'Keela privaatsed vestlused';
$string['mod_form_field_disablepublicchat'] = 'Keela avalikud vestlused';
$string['mod_form_field_duration'] = 'Kestus';
$string['mod_form_field_duration_help'] = 'Koosolekuaja kestuse määramisega määratakse ka maksimumaeg, kui kaua koosolekut salvestatakse';
$string['mod_form_field_hideuserlist'] = 'Peida kasutajate nimekiri';
$string['mod_form_field_instanceprofiles'] = 'Kirje tüüp';
$string['mod_form_field_instanceprofiles_help'] = 'Vali tüüp sellele BigBlueButtonBNi kirjele';
$string['mod_form_field_intro'] = 'Kirjeldus';
$string['mod_form_field_intro_help'] = 'Ruumi või konverentsi lühikirjeldus.';
$string['mod_form_field_lockedlayout'] = 'Lukusta ruumi paigutus';
$string['mod_form_field_lockonjoin'] = 'Ignoreeri lukustusseadeid';
$string['mod_form_field_lockonjoinconfigurable'] = 'Luba lukustusseadeid ignoreerida';
$string['mod_form_field_muteonstart'] = 'Vaigista alustamisel';
$string['mod_form_field_name'] = 'Veebiseminari pealkiri';
$string['mod_form_field_nosettings'] = 'Ühtegi seadistust ei saa muuta';
$string['mod_form_field_notification'] = 'Teavita registreerunuid sellest muudatusest';
$string['mod_form_field_notification_created_help'] = 'Saada kõigile registreerunud kasutajatele teatis, et anda teada, et see tegevus on loodud';
$string['mod_form_field_notification_help'] = 'Saada kõigile registreerunud kasutajatele teatis, et anda neile teada, et see tegevus on lisatud või värskendatud';
$string['mod_form_field_notification_modified_help'] = 'Saada kõigile registreerunud kasutajatele teatis, et anda neile teada, et seda tegevust on värskendatud';
$string['mod_form_field_notification_msg_at'] = 'kell';
$string['mod_form_field_notification_msg_created'] = 'lisatud';
$string['mod_form_field_notification_msg_modified'] = 'uuendatud';
$string['mod_form_field_openingtime'] = 'Liitumine on avatud';
$string['mod_form_field_participant_add'] = 'Lisa osaleja';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Juhataja';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Vaataja';
$string['mod_form_field_participant_list'] = 'Osalejate loend';
$string['mod_form_field_participant_list_action_add'] = 'Lisa';
$string['mod_form_field_participant_list_action_remove'] = 'Eemalda';
$string['mod_form_field_participant_list_text_as'] = 'ühine sessiooniga kui';
$string['mod_form_field_participant_list_type_all'] = 'Kõik kasutajad on registreerunud';
$string['mod_form_field_participant_list_type_owner'] = 'Omanik';
$string['mod_form_field_participant_list_type_role'] = 'Roll';
$string['mod_form_field_participant_list_type_user'] = 'Kasutaja';
$string['mod_form_field_record'] = 'Seansi saab salvestada';
$string['mod_form_field_recordallfromstart'] = 'Salvesta algusest';
$string['mod_form_field_recordhidebutton'] = 'Peida salvestuse nupp';
$string['mod_form_field_recordings_deleted'] = 'Kaasa kustutatud tegevuste salvestused';
$string['mod_form_field_recordings_html'] = 'Näita tabelit html-is';
$string['mod_form_field_recordings_imported'] = 'Kuva ainult imporditud linke';
$string['mod_form_field_recordings_preview'] = 'Kuva salvestuste eelvaade';
$string['mod_form_field_room_name'] = 'Ruumi nimi';
$string['mod_form_field_userlimit'] = 'Kasutajate limiit';
$string['mod_form_field_userlimit_help'] = 'Koosolekule lubatud kasutajate ülempiir. Kui limiidiks on seatud 0, on kasutajate arv piiramatu.';
$string['mod_form_field_voicebridge'] = 'Helisild [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Vormingutõrge. Sisestatud number peab olema vahemikus 1–9999.';
$string['mod_form_field_voicebridge_help'] = 'Helisilla number, mille osalejad saavad sisestada helikonverentsiga liitumiseks. Number peab jääma vahemikku 1–9999. Kui selle väärtus on 0, siis helisilla püsinumbrit ignoreeritakse ja BigBlueButton loob uue suvalise numbri. Neljale sisestatud numbrile eelneb number 7';
$string['mod_form_field_voicebridge_notunique_error'] = 'Pole unikaalne väärtus. Seda numbrit kasutab teine ruum või konverents.';
$string['mod_form_field_wait'] = 'Oota juhatajat';
$string['mod_form_field_wait_help'] = 'Vaatajad peavad ootama, et juhataja seansiga liituks, enne kui saavad seda ise teha';
$string['mod_form_field_welcome'] = 'Tervitussõnum';
$string['mod_form_field_welcome_default'] = '<br>Tere tulemast veebiseminarile <b>%%CONFNAME%%</b>!<br><br>Kui soovite teada saada, kuidas moodul BigBlueButton toimib, siis <a href="event:http://www.bigbluebutton.org/content/videos"><u>tutvuge õpetusvideotega</u></a>.<br><br>Kui soovite veebiseminariga liituda helisilla kaudu, siis klõpsake vasakpoolses ülaservas kõrvaklapiikooni. <b>Teiste veebiseminaril osalejate häirimise vältimiseks kasutage peakomplekti (kõrvaklappide ja mikrofoniga).</b>';
$string['mod_form_field_welcome_help'] = 'Asendab veebiseminariga liitujatele vaikimisi kuvatava tervitussõnumi. Tervitussõnumis saab kasutada märksõnu (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%), mis asendatakse sobiva teabega automaatselt, ja HTML-silte <b>...</b> või <i> ... </i>';
$string['mod_form_locksettings'] = 'Lukusta seaded';
$string['modulename'] = 'BigBlueButtonBN';
$string['modulename_help'] = 'BigBlueButtonBN võimaldab luua veebiseminari vormis toimiva virtuaalse klassiruumi otse oma Moodle’i kursusele.

BigBlueButtonBNis saate määrata veebiseminari pealkirja, kirjelduse, kalendrikirje (veebiseminariga liitumise ajavahemikuga), rühmad ja salvestuse üksikasjad.

Veebiseminaride salvestuste vaatamiseks lisage sellele kursusele moodul RecordingsBN.';
$string['modulename_link'] = 'BigBlueButtonBN/view';
$string['modulenameplural'] = 'BigBlueButtonBN';
$string['pluginadministration'] = 'BigBlueButtoni haldus';
$string['pluginname'] = 'BigBlueButtonBN';
$string['privacy:metadata:bigbluebutton'] = 'BigBlueButtoni seansside loomiseks ja nendega liitumiseks tuleb kasutaja andmeid serveriga vahetada.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'BigBlueButtoni serverisse sisenenud kasutaja täisnimi.';
$string['privacy:metadata:bigbluebutton:userid'] = 'BigBlueButtoni serverisse sisenenud kasutaja ID.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Salvestab ruumi või tegevuse seaded, mis määravad BigBlueButton seansi funktsioonid ja üldise käitumise.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Reeglite loend, mis määrab kasutajate rolli reaalajas koosolekul. Kasutaja ID võidakse salvestada, kuna igale rollile või kasutajale saab anda õigusi.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Salvestab plugina kasutamisel käivitatud sündmused.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Kasutaja käivitatud sündmuse tüüp.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Kohtumise ID millele kasutajal on ligipääs.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Võib sisaldada lisateavet koosoleku või sündmuse poolt mõjutatud salvestuse kohta.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Logi loomise aeg.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Sündmuse käivitanud kasutaja ID';
$string['removedevents'] = 'Kustutatud sündmused';
$string['removedlogs'] = 'Kustutatud kohandatud logid';
$string['removedrecordings'] = 'Kustutatud salvestused';
$string['removedtags'] = 'Kustutatud silt';
$string['resetevents'] = 'Kustuta sündmused';
$string['resetlogs'] = 'Kustuta kohandatud logid';
$string['resetlogs_help'] = 'Logi kustutamine kaotab viited salvestustele';
$string['resetrecordings'] = 'Kustuta salvestused';
$string['resetrecordings_help'] = 'Salvestiste kustutamine muudab need kõikjal juurdepääsmatuks ja seda toimingut ei saa tagasi võtta';
$string['resettags'] = 'Kustuta sildid';
$string['search:activity'] = 'BigBlueButtonBN - tegevuste info';
$string['search:tags'] = 'BigBlueButtonBN - siltide info';
$string['sendnotification'] = 'Saada teade';
$string['started_at'] = 'Alustatud';
$string['starts_at'] = 'Algab';
$string['view_conference_action_end'] = 'Lõpeta seanss';
$string['view_conference_action_join'] = 'Liitu seansiga';
$string['view_error_action_not_completed'] = 'Tegevust ei saanud teostada';
$string['view_error_bigbluebutton'] = 'BigBlueButton tagastas tõrked. {$a}';
$string['view_error_create'] = 'BigBlueButtoni server tagastas tõrketeate, et koosolekut ei saanud luua.';
$string['view_error_current_state_not_found'] = 'Hetkeseisu ei leitud. Võimalik, et salvestus on kustutatud või BigBlueButton-i server ei ühildu tehtud toiminguga.';
$string['view_error_import_no_courses'] = 'Salvestuste otsimiseks pole ühtegi kursust';
$string['view_error_import_no_recordings'] = 'Sellel kursusel pole importimiseks ühtegi salvestust';
$string['view_error_invalid_session'] = 'Sessioon on aegunud. Mine tagasi tegevuste pealehele.';
$string['view_error_max_concurrent'] = 'Samaaegselt lubatud koosolekute piirarv on täis.';
$string['view_error_meeting_not_running'] = 'Midagi läks valesti, koosolekut ei toimu.';
$string['view_error_no_group'] = 'Ühtegi rühma pole veel konfigureeritud. Häälestage rühmad, enne kui üritate koosolekuga liituda.';
$string['view_error_no_group_student'] = 'Teid pole rühma registreeritud. Pöörduge oma õpetaja või administraatori poole.';
$string['view_error_no_group_teacher'] = 'Ühtegi rühma pole veel konfigureeritud. Häälestage rühmad või pöörduge administraatori poole.';
$string['view_error_unable_join'] = 'Ei saa koosolekuga liituda. Kontrollige, kas BigBlueButtoni serveri URL on õige JA server ise töökorras.';
$string['view_error_unable_join_student'] = 'Ei saa BigBlueButtoni serveriga ühendust luua. Pöörduge oma õpetaja või administraatori poole.';
$string['view_error_unable_join_teacher'] = 'Ei saa BigBlueButtoni serveriga ühendust luua. Pöörduge administraatori poole.';
$string['view_error_url_missing_parameters'] = 'Selles URL-is on parameetrid puudu';
$string['view_error_userlimit_reached'] = 'Koosolekul lubatud kasutajate arv on saavutatud.';
$string['view_groups_nogroups_warning'] = 'Ruum seadistati kasutamiseks rühmadele aga kursusel ei ole rühmad defineeritud.';
$string['view_groups_notenrolled_warning'] = 'Ruum seadistati kasutamiseks rühmadele aga sa ei ole registreerunud ühtegi rühma.';
$string['view_groups_selection'] = 'Valige rühm, millega soovite liituda, ja kinnitage toiming';
$string['view_groups_selection_join'] = 'Liitu';
$string['view_groups_selection_warning'] = 'Iga rühma jaoks on olemas konverentsiruum. Kui teil on juurdepääs mitmele konverentsiruumile, valige kindlasti õige konverentsiruum.';
$string['view_login_moderator'] = 'Juhatajana sisselogimine...';
$string['view_login_viewer'] = 'Vaatajana sisselogimine...';
$string['view_message_and'] = 'ja';
$string['view_message_conference_has_ended'] = 'See konverents on lõppenud.';
$string['view_message_conference_in_progress'] = 'See konverents on pooleli.';
$string['view_message_conference_not_started'] = 'See konverents pole veel alanud.';
$string['view_message_conference_room_ready'] = 'See konverentsiruum on valmis. Saate nüüd seansiga liituda.';
$string['view_message_conference_wait_for_moderator'] = 'Liitumiseks oodatakse juhatajat.';
$string['view_message_finished'] = 'See tegevus on lõppenud.';
$string['view_message_has_joined'] = 'on liitunud';
$string['view_message_have_joined'] = 'on liitunud';
$string['view_message_hour'] = 'tund';
$string['view_message_hours'] = 'tundi';
$string['view_message_importrecordings_disabled'] = 'Salvestuslinkide impordi funktsioon on selles serveris keelatud.';
$string['view_message_minute'] = 'minut';
$string['view_message_minutes'] = 'minutit';
$string['view_message_moderator'] = 'juhataja';
$string['view_message_moderators'] = 'juhatajat';
$string['view_message_norecordings'] = 'Sellel koosolekul pole salvestusi.';
$string['view_message_notavailableyet'] = 'See seanss pole veel saadaval.';
$string['view_message_recordings_disabled'] = 'Salvestused olid selles serveris keelatud. Ainult lindistamiseks mõeldud BigBlueButtonBN-i eksemplare ei saa kasutada.';
$string['view_message_room_closed'] = 'See ruum on suletud.';
$string['view_message_room_open'] = 'See ruum on avatud.';
$string['view_message_room_ready'] = 'See ruum on valmis.';
$string['view_message_session_for'] = 'sessioon';
$string['view_message_session_has_user'] = 'On';
$string['view_message_session_has_users'] = 'On';
$string['view_message_session_no_users'] = 'Sellel seansil pole ühtegi kasutajat';
$string['view_message_session_running_for'] = 'See seanss on kestnud';
$string['view_message_session_started_at'] = 'See seanss algas';
$string['view_message_tab_close'] = 'See vahekaart/aken tuleb käsitsi sulgeda';
$string['view_message_times'] = 'ajad';
$string['view_message_user'] = 'kasutaja';
$string['view_message_users'] = 'kasutajat';
$string['view_message_viewer'] = 'vaataja';
$string['view_message_viewers'] = 'vaatajat';
$string['view_mobile_message_groups_not_supported'] = 'See instants võimaldab töötada rühmadega, kuid mobiilirakendus ei toeta seda. Kui soovid kasutada rühmi, ava rakendus tööarvutis.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Sa ületasid 45 sekundit sellel lehel. Koosolekuga liitumiseks laadi leht uuesti.';
$string['view_noguests'] = 'BigBlueButtonBN pole külalistele kättesaadav';
$string['view_nojoin'] = 'Kahjuks teie roll ei luba selle seansiga liituda.';
$string['view_recording'] = 'salvestus';
$string['view_recording_actionbar'] = 'Tööriistariba';
$string['view_recording_activity'] = 'Tegevus';
$string['view_recording_button_import'] = 'Impordi salvestuste lingid';
$string['view_recording_button_return'] = 'Mine tagasi';
$string['view_recording_course'] = 'Kursus';
$string['view_recording_date'] = 'Kuupäev';
$string['view_recording_delete_confirmation'] = 'Kas soovite selle salvestuse {$a} kindlasti kustutada?';
$string['view_recording_delete_confirmation_warning_p'] = 'Selle salvestusega on seotud {$a} linki, mis imporditi teistsugustes kursustes või tegevustes. Salvestuse kustutamisel eemaldatakse ka need lingid';
$string['view_recording_delete_confirmation_warning_s'] = 'Selle salvestusega on seotud {$a} link, mis imporditi teistsuguses kursuses või tegevuses. Salvestuse kustutamisel eemaldatakse ka see link';
$string['view_recording_description'] = 'Kirjeldus';
$string['view_recording_duration'] = 'Kestus';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Selle salvestusvormingu URL on kättesaamatu.';
$string['view_recording_format_notes'] = 'Märkmed';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'esitlus';
$string['view_recording_format_screenshare'] = 'Ekraani jagamine';
$string['view_recording_format_statistics'] = 'Statistika';
$string['view_recording_format_video'] = 'video';
$string['view_recording_import_confirmation'] = 'Kas soovite selle salvestuse kindlasti importida?';
$string['view_recording_length'] = 'Pikkus';
$string['view_recording_link'] = 'imporditud link';
$string['view_recording_link_warning'] = 'See link osutab salvestusele, mis loodi teistsuguses kursuses või tegevuses';
$string['view_recording_list_action_delete'] = 'Kustutamine';
$string['view_recording_list_action_edit'] = 'Uuendamine';
$string['view_recording_list_action_play'] = 'Mängi';
$string['view_recording_list_action_process'] = 'Töötlemine';
$string['view_recording_list_action_protect'] = 'Kaitsmine';
$string['view_recording_list_action_publish'] = 'Avalikustamine';
$string['view_recording_list_action_unprotect'] = 'Kaitsmata';
$string['view_recording_list_action_unpublish'] = 'Avalikustamata';
$string['view_recording_list_action_update'] = 'Uuendamine';
$string['view_recording_list_actionbar'] = 'Tööriistariba';
$string['view_recording_list_actionbar_delete'] = 'Kustuta';
$string['view_recording_list_actionbar_edit'] = 'Muuda';
$string['view_recording_list_actionbar_hide'] = 'Peida';
$string['view_recording_list_actionbar_import'] = 'Impordi';
$string['view_recording_list_actionbar_protect'] = 'Märgi privaatseks';
$string['view_recording_list_actionbar_publish'] = 'Avalda';
$string['view_recording_list_actionbar_show'] = 'Kuva';
$string['view_recording_list_actionbar_unprotect'] = 'Märgi avalikuks';
$string['view_recording_list_actionbar_unpublish'] = 'Tühista avaldamine';
$string['view_recording_list_activity'] = 'Tegevus';
$string['view_recording_list_course'] = 'Kursus';
$string['view_recording_list_date'] = 'Kuupäev';
$string['view_recording_list_description'] = 'Kirjeldus';
$string['view_recording_list_duration'] = 'Kestus';
$string['view_recording_list_recording'] = 'Salvestus';
$string['view_recording_meeting'] = 'Kohtumine';
$string['view_recording_modal_button'] = 'Rakenda';
$string['view_recording_modal_title'] = 'Määra salvestuse väärtused';
$string['view_recording_name'] = 'Nimi';
$string['view_recording_playback'] = 'Taasesitus';
$string['view_recording_preview'] = 'Eelvaade';
$string['view_recording_preview_help'] = 'Pildi täissuuruses nägemiseks liigu hiirega sellest üle';
$string['view_recording_publish_link_deleted'] = 'Seda linki ei saa uuesti avaldada, kuna tegelikku salvestust praeguses BigBlueButton serveris ei eksisteeri. Link tuleb eemaldada.';
$string['view_recording_publish_link_not_published'] = 'Seda linki ei saa uuesti avaldada, sest algne salvestus on avaldamata.';
$string['view_recording_recording'] = 'Salvestus';
$string['view_recording_tags'] = 'Sildid';
$string['view_recording_unprotect_link_deleted'] = 'Seda linki ei saa seadistada kaitsmata olekusse, kuna tegelikku salvestust praeguses BigBlueButton serveris ei eksisteeri. Link tuleks eemaldada.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Seda linki ei saa seadistada kaitsmata olekusse kuna algne salvestus on kaitstud olekus.';
$string['view_recording_unpublish_confirmation'] = 'Kas soovite selle salvestuse {$a} avaldamise kindlasti tühistada?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Selle salvestusega on seotud {$a} linki, mis imporditi teistsugustes kursustes või tegevustes. Salvestuse avaldamise tühistamisel tühistatakse ka nende linkide avaldamine';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Selle salvestusega on seotud {$a} link, mis imporditi teistsuguses kursuses või tegevuses. Salvestuse avaldamise tühistamisel tühistatakse ka selle lingi avaldamine';
$string['view_recording_yui_first'] = 'Esimene';
$string['view_recording_yui_go'] = 'Alusta';
$string['view_recording_yui_last'] = 'Viimane';
$string['view_recording_yui_next'] = 'Järgmine';
$string['view_recording_yui_page'] = 'Lehekülg';
$string['view_recording_yui_prev'] = 'Eelmine';
$string['view_recording_yui_rows'] = 'Read';
$string['view_recording_yui_show_all'] = 'Kuva kõik';
$string['view_room'] = 'Vaata ruumi';
$string['view_section_title_presentation'] = 'Esitlusfail';
$string['view_section_title_recordings'] = 'Salvestused';
$string['view_warning_default_server'] = 'See Moodle\'i server kasutab BigBlueButtoni testiserverit, mis on vaikimisi eelkonfigureeritud. See tuleb tööbasis välja vahetada.';
