<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'cs', version '3.11'.
 *
 * @package     scorm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Aktivace';
$string['activityloading'] = 'Budete automaticky přesměrováni -';
$string['activityoverview'] = 'Modul SCORM vyžaduje vaši pozornost';
$string['activitypleasewait'] = 'Činnost se načítá, čekejte ...';
$string['adminsettings'] = 'Nastavení správce';
$string['advanced'] = 'Parametry';
$string['aicchacpkeepsessiondata'] = 'Data relace AICC HACP';
$string['aicchacpkeepsessiondata_desc'] = 'Délka času v dnech na uchování dat externí AICC HACP relace (nastavení s vysokým číslem vyplní tabulku starými daty, ale může to být užitečné při odstraňování chyb)';
$string['aicchacptimeout'] = 'Časový limit AICC HACP';
$string['aicchacptimeout_desc'] = 'Délka času v minutách, během kterého externí AICC HACP relace může zůstat otevřená';
$string['aiccuserid'] = 'Uživatelské ID - číselní heslo pro AICC';
$string['aiccuserid_desc'] = 'AICC standard pro uživatelské jména je velmi omezující v porovnaní s Moodle. Povoluje pouze alfanumerické znaky, pomlčku (-) a podtržítko (_). Tečky, mezery a symbol @ nejsou povoleny. Je-li tato možnost aktivována, do AICC balíku jsou odevzdávány ID čísla uživatelů namísto jejich uživatelských jmen.';
$string['aliasonly'] = 'Když si zvolíte soubor imsmanifest.xml z úložiště, musíte pro tento soubor použít alias/zkratku.';
$string['allowapidebug'] = 'Aktivovat API odstraňování chyb a sledování (nastavte masku zachycení pomocí API masky odstraňování chyb apidebugmask)';
$string['allowtypeaicchacp'] = 'Povoleno externí AICC HACP';
$string['allowtypeaicchacp_desc'] = 'Je-li tato možnost aktivována, umožní se AICC HACP externí komunikace bez používání uživatelského loginu pro následné požadavky z externího AICC balíku.';
$string['allowtypeexternal'] = 'Povolit externí balíček';
$string['allowtypeexternalaicc'] = 'Povoleno přímé AICC URL';
$string['allowtypeexternalaicc_desc'] = 'Pokud je povoleno, je povoleno přímé URL na jednoduchý balíček AICC';
$string['allowtypelocalsync'] = 'Povolit stáhnutelný balíček';
$string['apidebugmask'] = 'API maska zachycení chyb - použijte jednoduchý regex na &lt;username&gt;:&lt;activityname&gt; např. admin:.* ukáže oznámení odstraňování chyb pouze pro uživatele - administrátora';
$string['areacontent'] = 'Soubor obsahu';
$string['areapackage'] = 'Soubor balíčku';
$string['asset'] = 'Komponenta';
$string['assetlaunched'] = 'Komponenta - prohlédnuto';
$string['attempt'] = 'Pokus';
$string['attempt1'] = 'Pokus: 1';
$string['attempts'] = 'Pokusy';
$string['attemptsmanagement'] = 'Správa pokusů';
$string['attemptstatusall'] = 'Nástěnka a vstupní stránky';
$string['attemptstatusentry'] = 'Pouze vstupní stránka';
$string['attemptstatusmy'] = 'Pouze Nástěnka';
$string['attemptsx'] = 'Pokusů: {$a}';
$string['attr_error'] = 'Špatná hodnota atributu ({$a->attr}) ve značce {$a->tag}.';
$string['autocommit'] = 'Automatické ukládání';
$string['autocommit_help'] = 'Pokud je povoleno, SCORM automaticky uloží data do databáze. Vhodné pro SCORM objekty, které neukládají svá data pravidelně.';
$string['autocommitdesc'] = 'Automaticky ukládat data SCORM balíčku, pokud to SCORM nedělá sám.';
$string['autocontinue'] = 'Automatické pokračování';
$string['autocontinue_help'] = '<p>Je-li tato volba nastavena na "Ano", spustí se automaticky další dostupný
učební objekt, jakmile aktuální učební objekt vyvolá metodu "ukončit
komunikaci".</p>

<p>Je-li Automatické pokračování nastaveno na "Ne", musí uživatel pro
pokračování použít tlačítko "Pokračovat".</p>';
$string['autocontinuedesc'] = 'Jaká má být výchozí hodnota nastavení "Automatické pokračování", jinak je nutno použít tlačítko Pokračovat.';
$string['averageattempt'] = 'Průměr ze všech pokusů';
$string['badarchive'] = 'Je třeba zadat platný ZIP soubor';
$string['badimsmanifestlocation'] = 'Soubor imsmanifest.xml byl nalezen, ale nebylo to v kořenovém adresáři souboru zip, zabalte znovu svůj SCORM';
$string['badmanifest'] = 'Chyby v manifestu: více v protokolu o chybách';
$string['browse'] = 'Náhled';
$string['browsed'] = 'Prohlédnuto';
$string['browsemode'] = 'Režim náhledu';
$string['browserepository'] = 'Procházet repositář';
$string['calculatedweight'] = 'Vypočítaná váha';
$string['calendarend'] = '{$a} - uzavřeno';
$string['calendarstart'] = '{$a} - otevřeno';
$string['cannotaccess'] = 'Nemůžete tímto způsobem volat tento skript';
$string['cannotfindsco'] = 'Nepodařilo se najít SCO';
$string['chooseapacket'] = 'Vybrat nebo aktualizovat balíček SCORM/AICC';
$string['closebeforeopen'] = 'Zadali jste datum brzo před datem zahájení.';
$string['collapsetocwinsize'] = 'Je-li velikost okna nižší, sbalte Obsah';
$string['collapsetocwinsizedesc'] = 'Toto nastavení umožňuje určit velikost okna, pod kterou by měl automaticky Obsah sbalit.';
$string['compatibilitysettings'] = 'Nastavení kompatibility';
$string['completed'] = 'Dokončeno';
$string['completiondetail:allscos'] = 'Proveďte všechny části této činnosti';
$string['completiondetail:completionscore'] = 'Získat skóre {$a} nebo více';
$string['completiondetail:completionstatuscompleted'] = 'Dokončit aktivitu';
$string['completiondetail:completionstatuscompletedandpassed'] = 'Dokončit a projít aktivitu';
$string['completiondetail:completionstatuspassed'] = 'Projít aktivitu';
$string['completionscorerequired'] = 'Požadované minimální skóre';
$string['completionscorerequired_help'] = 'Aktivování tohoto nastavení bude požadovat, aby uživatel měl zadán minimální počet bodů, aby tato SCORM aktivita mohla být označena za dokončenou; to platí také pro jakékoliv ostatní požadavky na dokončení činnosti.';
$string['completionscorerequireddesc'] = 'Pro splnění činnosti je požadována minimální známka {$a}';
$string['completionstatus_completed'] = 'Dokončeno';
$string['completionstatus_passed'] = 'Splněno';
$string['completionstatusallscos'] = 'Požadovat všechny "scos"  k návratu se stavem dokončení';
$string['completionstatusallscos_help'] = 'Některé SCORM balíčky obsahují více komponent nebo "scos" - je-li to povoleno, všechny scos uvnitř balíčku musí vrátit příslušnou lesson_status k této činnosti, které mají být označeny splněné.';
$string['completionstatusrequired'] = 'Požadovaný stav';
$string['completionstatusrequired_help'] = 'Volba jednoho nebo více stavů bude požadovat, aby studující dosáhl minimálně jeden z označených stavů, aby mohla být tato jeho SCORM aktivita označena za dokončenou; to platí také pro jakékoliv ostatní požadavky na dokončení činnosti.';
$string['completionstatusrequireddesc'] = 'Student musí dosáhnout alespoň jednoho z následujících stavů: {$a}';
$string['confirmloosetracks'] = 'UPOZORNĚNÍ: byla zjištěna změna v balíčku. Pokud se změnila i jeho struktura, může při aktualizaci dojít ke ztrátě informací o průchodu některých uživatelů obsahem balíčku.';
$string['contents'] = 'Obsah';
$string['coursepacket'] = 'Balík kurzu';
$string['coursestruct'] = 'Struktura kurzu';
$string['crontask'] = 'Zpracování SCORM na pozadí';
$string['currentwindow'] = 'Stávající okno';
$string['datadir'] = 'Chyba souborového systému: Nelze vytvořit adresář s daty kurzu';
$string['defaultdisplaysettings'] = 'Výchozí nastavení zobrazení';
$string['defaultgradesettings'] = 'Výchozí nastavení hodnocení';
$string['defaultothersettings'] = 'Další výchozí nastavení';
$string['deleteallattempts'] = 'Odstranit všechny pokusy o průchod SCORMem';
$string['deleteattemptcheck'] = 'Jste si jistí, že chcete úplně vymazat tyto pokusy?';
$string['deleteselected'] = 'Odstranit vybrané pokusy';
$string['deleteuserattemptcheck'] = 'Jste si jisti, že chcete zcela vymazat všechny své pokusy?';
$string['details'] = 'Podrobnosti o průchodu';
$string['directories'] = 'Ukazovat lištu s odkazy';
$string['disabled'] = 'Zakázáno';
$string['display'] = 'Zobrazit balíček';
$string['displayactivityname'] = 'Zobrazit název činnosti';
$string['displayactivityname_help'] = 'Zda se má zobrazit název činnosti nad SCORM přehrávačem.';
$string['displayattemptstatus'] = 'Zobraz stav pokusu';
$string['displayattemptstatus_help'] = 'Pokud je povoleno, jsou  známky a hodnocení pokusů zobrazeny v přehledu na Nástěnce a/nebo na vstupní stránce SCORM.';
$string['displayattemptstatusdesc'] = 'Zda má být výchozí zobrazení stavu pokusů v přehledu na Nástěnce a/nebo na vstupní stránce SCORM.';
$string['displaycoursestructure'] = 'Zobrazit strukturu kurzu na vstupní stránce';
$string['displaycoursestructure_help'] = 'Pokud je povoleno, je tabulka obsahu zobrazena na stránce osnovy SCORM.';
$string['displaycoursestructuredesc'] = 'Pokud je povoleno, je tabulka obsahu zobrazena na stránce osnovy SCORM.';
$string['displaydesc'] = 'Zda se má zobrazit SCORM balíček v novém okně.';
$string['displaysettings'] = 'Nastavení zobrazení';
$string['dnduploadscorm'] = 'Přidat SCORM balíček';
$string['domxml'] = 'Externí knihovna DOMXML';
$string['duedate'] = 'Datum platnosti';
$string['element'] = 'Prvek';
$string['enter'] = 'Vstoupit';
$string['entercourse'] = 'Vstoupit do kurzu';
$string['errorlogs'] = 'Protokol o chybách';
$string['eventattemptdeleted'] = 'Pokus odstraněn';
$string['eventinteractionsviewed'] = 'Zobrazené interakce';
$string['eventreportviewed'] = 'Sestava zobrazena';
$string['eventscolaunched'] = 'Zahájeno SCO';
$string['eventscorerawsubmitted'] = 'Odesláno prvotní skóre SCORM';
$string['eventstatussubmitted'] = 'Odeslán stav SCORM';
$string['eventtracksviewed'] = 'Zobrazen průchod';
$string['eventuserreportviewed'] = 'Zobrazena uživatelská sestava';
$string['everyday'] = 'Každý den';
$string['everytime'] = 'Pokaždé, kdy je použito';
$string['exceededmaxattempts'] = 'Dosáhli jste nejvyššího možného počtu pokusů.';
$string['exit'] = 'Opustit kurz';
$string['exitactivity'] = 'Opustit činnost';
$string['expired'] = 'Promiňte, ale tato činnost byla {$a} uzavřena a již není k dispozici';
$string['external'] = 'Aktualizovat časování externích balíčků';
$string['failed'] = 'Nedokončeno úspěšně';
$string['finishscorm'] = 'Pokud jste skončili s prací s tímto materiálem, {$a}';
$string['finishscormlinkname'] = 'klikněte sem pro návrat na stránku kurzu';
$string['firstaccess'] = 'První přístup';
$string['firstattempt'] = 'První pokus';
$string['floating'] = 'Volně';
$string['forceattemptalways'] = 'Vždy';
$string['forceattemptoncomplete'] = 'Když byl předchozí pokus dokončen, prošel nebo selhal';
$string['forcecompleted'] = 'Vynuceně ukončeno';
$string['forcecompleted_help'] = 'Pokud je povoleno, stav aktuálního pokusu je nastaven na "dokončeno". (Platí pouze pro SCORM 1.2 balíčky.)';
$string['forcecompleteddesc'] = 'Jaké má být výchozí nastavení vynuceného dokončení';
$string['forcejavascript'] = 'Vnutit uživateli povolit JavaScript';
$string['forcejavascript_desc'] = 'Je-li tato možnost aktivována (doporučuje se), zabrání se přístupu k SCORM objektům v případě, že JavaScript není podporován/povolen v prohlížeči uživatelů. Je-li tato možnost deaktivována, uživatel si může SCORM balík prohlížet, ale API komunikace bude neúspěšná a žádné informace o hodnocení nebudou uloženy.';
$string['forcejavascriptmessage'] = 'Pro zobrazení tohoto objektu je vyžadován JavaScript, povolte v prohlížeči JavaScript a zkuste to znovu.';
$string['forcenewattempts'] = 'Vynutit nový pokus';
$string['forcenewattempts_help'] = 'Jsou 3 možnosti:

* Ne - Pokud byl předchozí pokus dokončen, úspěšně nebo neúspěšně, bude studentovi poskytnuta možnost vstoupit do režimu náhledu nebo zahájit nový pokus.
* Když bul předchozí pokus dokončen, úspěšně nebo neúspěšně - To vychází z balíčku SCORM, který nastavuje stav "dokončeno", "splnil" nebo "nesplnil".
* Vždy - každý opakovaný vstup do aktivity SCORM vygeneruje nový pokus a student nebude pokračovat ve stejném místě, ve kterém skončil při svém předchozím pokusu.';
$string['found'] = 'Manifest nalezen';
$string['frameheight'] = 'Tato předvolba nastavuje výchozí výšku rámce nebo okna.';
$string['framewidth'] = 'Tato předvolba nastavuje výchozí šířku rámce nebo okna.';
$string['fromleft'] = 'Zleva';
$string['fromtop'] = 'Shora';
$string['fullscreen'] = '‌Zobrazit na celou obrazovku';
$string['general'] = 'Obecná data';
$string['gradeaverage'] = 'Průměrný bodový zisk';
$string['gradeforattempt'] = 'Hodnocení pokusu';
$string['gradehighest'] = 'Nejvyšší bodový zisk';
$string['grademethod'] = 'Metoda známkování';
$string['grademethod_help'] = 'Metoda hodnocení definuje, jak se určuje známka pro jeden pokus o aktivitu.

Existují 4 metody hodnocení:

*Učební objekty - Počet dokončených/úspěšně ukončených učebních objektů
*Nejvyšší známka  - Nejvyšší skóre získané ve všech předaných učebních objektech
*Průměr známek  - Průměr bodového zisku
*Součet známek - Součet všech skóre';
$string['grademethoddesc'] = 'Metoda známkování určuje jak se známkují jednotlivé pokusy.';
$string['gradereported'] = 'Zobrazené hodnocení';
$string['gradescoes'] = 'Učební objekty';
$string['gradesettings'] = 'Nastavení hodnocení';
$string['gradesum'] = 'Souhrnný bodový zisk';
$string['height'] = 'Výška';
$string['hidden'] = 'Skrýt';
$string['hidebrowse'] = 'Zakázat režim náhledu';
$string['hidebrowse_help'] = 'Režim náhledu umožňuje studentům procházet činnost před normálním pokusem. Pokud je režim náhledu vypnut, nebude se tlačítko pro spuštění náhledu zobrazovat.';
$string['hidebrowsedesc'] = 'Režim náhledu umožňuje studentovi prohlédnou si činnosti před tím, než se pokusí o jejich zvládnutí.';
$string['hideexit'] = 'Skrýt odkaz k opuštění';
$string['hidereview'] = 'Skrýt tlačítko k prohlédnutí';
$string['hidetoc'] = 'Zobrazit navigační strukturu kurzu';
$string['hidetoc_help'] = 'Jakým způsobem má být obsah balíčku SCORM zobrazen';
$string['hidetocdesc'] = 'Toto nastavení určuje jakým způsobem má být obsah balíčku SCORM zobrazen.';
$string['highestattempt'] = 'Nejlepší pokus';
$string['identifier'] = 'Identifikátor otázky';
$string['incomplete'] = 'Nedokončeno';
$string['indicator:cognitivedepth'] = 'Kognitivní SCORM';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na studentem získané kognitivní hloubce v aktivitě SCORM.';
$string['indicator:cognitivedepthdef'] = 'Kognitivní SCORM';
$string['indicator:cognitivedepthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta kognitivní angažovanosti nabízené aktivitami SCORM (Úrovně = Bez zobrazení, Zobrazení, Příspěvek, Zobrazení zpětné vazby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociální SCORM';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě SCORM.';
$string['indicator:socialbreadthdef'] = 'Sociální SCORM';
$string['indicator:socialbreadthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta sociální angažovanosti nabízené aktivitou SCORM (Úrovně = Bez účasti, Účastník sám)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Informace';
$string['interactions'] = 'Interakce';
$string['invalidactivity'] = 'Neplatná činnost SCORM';
$string['invalidhacpsession'] = 'Neplatná relace HACP';
$string['invalidmanifestname'] = 'Mohou být vybrány pouze soubory imsmanifest.xml nebo ZIP';
$string['invalidmanifestresource'] = 'Upozornění: Následující prostředky byly referencovány v  manifestu, ale nebyly nalezeny:';
$string['invalidstatus'] = 'Neplatný stav';
$string['invalidurl'] = 'Chybná specifikace URL';
$string['invalidurlhttpcheck'] = 'Neplatná adresa URL. Ladící zpráva: <pre> {$a->cmsg} </pre>';
$string['last'] = 'Poslední přístup';
$string['lastaccess'] = 'Poslední přístup';
$string['lastattempt'] = 'Poslední pokus';
$string['lastattemptlock'] = 'Uzamknout po posledním pokusu';
$string['lastattemptlock_help'] = 'Pokud je povoleno, není studentovi umožněno spuštění SCORM přehrávače po vyčerpání všech jeho pokusů.';
$string['lastattemptlockdesc'] = 'Pokud je zaškrtnuto, studentovi je zabráněno spustit balíček SCORM po využití všech jemu přidělených pokusů.';
$string['location'] = 'Ukazovat adresní řádek';
$string['masteryoverride'] = 'Celkové skóre přepíše status';
$string['masteryoverride_help'] = 'Pokud je povoleno a je poskytováno celkové skóre, když je voláno LMSFinish a bylo nastaveno hrubé skóre, stav se přepočítá z hrubého skóre a celkové skóre a bude potlačen jakýkoli stav poskytnutý SCORM (včetně "nesplněno").';
$string['masteryoverridedesc'] = 'Tato předvolba nastaví výchozí hodnotu pro změnu stavu dle celkového skóre';
$string['max'] = 'Nejvyšší bodový zisk';
$string['maximumattempts'] = 'Nejvyšší počet pokusů';
$string['maximumattempts_help'] = 'Toto nastavení umožňuje omezit počet pokusů. Je použitelné pouze pro SCORM 1.2 a AICC balíčky.';
$string['maximumattemptsdesc'] = 'Jaká má být výchozí hodnota nastavení "Nejvyšší počet pokusů"';
$string['maximumgradedesc'] = 'Jaká má být výchozí hodnota nastavení "Nejvyšší známka"';
$string['menubar'] = 'Ukazovat lištu s hlavní nabídkou';
$string['min'] = 'Minimální skóre';
$string['missing_attribute'] = 'Chybějící atribut {$a->attr} ve značce {$a->tag}';
$string['missing_tag'] = 'Chybějící značka {$a->tag}';
$string['missingparam'] = 'Požadovaný parametre chybí nebo je chybný';
$string['mode'] = 'Režim';
$string['modulename'] = 'Balíček SCORM';
$string['modulename_help'] = 'Balíček SCORM umožňuje do kurzu vložit obsah ve formátu dle specifikací SCORM a AICC. Jedná se o soubory, které jsou zabaleny podle standardu pro výukové objekty.

Obsah je většinou zobrazen na několika stránkách spolu s prvkem pro navigaci mezi stránkami. Pro zobrazení obsahu existují různé možnosti - ve vyskakovacím okně, s obsahem, s navigačními tlačítky apod. Činnosti SCORM obecně zahrnují úlohy, jejichž hodnocení se zapisuje do klasifikace v kurzu.

SCORM činnosti mohou být použity

* pro prezentaci multimediálního obsahu a animací
* jako nástroj hodnocení';
$string['modulename_link'] = 'mod/scorm/view';
$string['modulenameplural'] = 'SCORM balíčky';
$string['myaiccsessions'] = 'Moje relace AICC';
$string['myattempts'] = 'Moje pokusy';
$string['nav'] = 'Zobrazit navigaci';
$string['nav_help'] = 'Toto nastavení určuje, zda chcete zobrazit nebo skrýt navigační tlačítka a jejich umístění.

K dispozici jsou 3 možnosti:

* Ne - Navigační tlačítka nejsou zobrazena
* Za obsahem - Navigační tlačítka jsou uvedeny pod obsahem SCORM balíčku
* Volně - Navigační tlačítka jsou plovoucí, s polohou stanovenou umístěním vzhledem k zobrazení balíčku.';
$string['navdesc'] = 'Toto nastavení určuje, zda chcete zobrazit nebo skrýt navigační tlačítka a jejich umístění.';
$string['navigation'] = 'Navigace';
$string['navpositionleft'] = 'Poloha navigačních tlačítek zleva v pixelech.';
$string['navpositiontop'] = 'Poloha navigačních tlačítek shora v pixelech.';
$string['networkdropped'] = 'Přehrávač SCORM zjistil, že vaše internetové spojení je nespolehlivé nebo bylo přerušeno. Budete-li pokračovat v této SCORM aktivitě, váš postup nemusí být uložen. <br /> Měl byste nyní odejít z činnosti a vrátit se tehdy, když budete mít spolehlivé internetové spojení.';
$string['newattempt'] = 'Začít nový pokus';
$string['next'] = 'Pokračovat';
$string['no_attributes'] = 'Značka {$a->tag} musí mít atributy';
$string['no_children'] = 'Značka {$a->tag} musí mít potomky';
$string['noactivity'] = 'Nic k zobrazení';
$string['noattemptsallowed'] = 'Počet povolených pokusů';
$string['noattemptsmade'] = 'Počet pokusů, které jste vyčerpali';
$string['nolimit'] = 'Neomezený počet pokusů';
$string['nomanifest'] = 'Chybný balíček souborů - chybí imsmanifest.xml nebo AICC struktura';
$string['noprerequisites'] = 'Bohužel, nesplňujete požadované předpoklady pro přístup k této aktivitě.';
$string['noreports'] = 'Žádný protokol k zobrazení';
$string['normal'] = 'Normální';
$string['noscriptnoscorm'] = 'Váš prohlížeč nepodporuje javascript, nebo byla podpora javascriptu ve vašem prohlížeči zakázána. Tento balíček SCORM nemusí přehrávat nebo ukládat data správně.';
$string['not_corr_type'] = 'Nesoulad typů ve značce {$a->tag}';
$string['notattempted'] = 'Bez pokusů';
$string['notopenyet'] = 'Promiňte, ale tato činnost nebude dostupná až do {$a}';
$string['objectives'] = 'Cíle';
$string['openafterclose'] = 'Zadali jste datum otevření po datu uzavření';
$string['optallstudents'] = 'všichni uživatelé';
$string['optattemptsonly'] = 'pouze uživatelé s pokusy';
$string['options'] = 'Volby (v některých prohlížečích nepodporované)';
$string['optionsadv'] = 'Volby (Pokročilé)';
$string['optionsadv_desc'] = 'Pokud je zaškrtnuto, budou výška a šířka považovány za pokročilá nastavení.';
$string['optnoattemptsonly'] = 'pouze uživatelé bez pokusů';
$string['organization'] = 'Organizace';
$string['organizations'] = 'Organizace';
$string['othersettings'] = 'Další nastavení';
$string['package'] = 'Soubor s balíčkem';
$string['package_help'] = '<p>Balík SCORM/AICC je soubor s příponou <b>zip</b> (nebo pif), který obsahuje
platné soubory AICC nebo SCORM.</p>

<p>Balík <b>SCORM</b> musí v kořenové složce souboru zip obsahovat soubor s
názvem <b>imsmanifest.xml</b>, který definuje strukturu kurzu SCORM, umístění
studijních materiálů a mnoho dalších vlastností.</p>

<p>Balík <b>AICC</b> je definován více soubory (čtyřmi až sedmi) s určenými
příponami. Význam jednotlivých přípon:</p>

<ul>
  <li>CRS &ndash; Course Description file (Soubor popisu kurzu &ndash; povinný)</li>

  <li>AU &ndash; Assignable Unit file (Soubor s popisem jednotek kurzu &ndash;
  povinný)</li>

  <li>DES &ndash; Descriptor file (Soubor s popisem bloků kurzu &ndash; povinný)</li>

  <li>CST &ndash; Course Structure file (Soubor se strukturovanými daty kurzu &ndash;
  povinný)</li>

  <li>ORE &ndash; Objective Relationship file (Soubor s popisem cílů jednotek a bloků
  &ndash; volitelný)</li>

  <li>PRE &ndash; Prerequisites file (Soubor s popisem předpokladů &ndash; volitelný)</li>

  <li>CMP &ndash; Completition Requirements file (Soubor podmínek ukončení kurzu &ndash;
  volitelný)</li>
</ul>';
$string['packagedir'] = 'Chyba souborového systému: Nelze vytvořit adresář balíčku';
$string['packagefile'] = 'Nebyl určen soubor s balíčkem SCORM/AICC.';
$string['packagehdr'] = 'Balíček';
$string['packageurl'] = 'URL';
$string['packageurl_help'] = 'Toto nastavení umožní zadat URL adresu SCORM balíčku místo toho, aby byl nahráván ručně přes Prohlížeč souborů.';
$string['page-mod-scorm-x'] = 'Jakákoliv stránka modulu SCORM';
$string['pagesize'] = 'Velikost stránky';
$string['passed'] = 'Splněno';
$string['php5'] = 'PHP 5 (DOMXML nativní knihovna)';
$string['pluginadministration'] = 'Správa SCORM/AICC';
$string['pluginname'] = 'SCORM balíček';
$string['popup'] = 'Nové okno';
$string['popuplaunched'] = 'Tento SCORM balíček byl spuštěn ve vyskakovacím okně, Pokud jste dokončili prohlížení, klikněte sem pro návrat na hlavní stránku kurzu';
$string['popupmenu'] = 'V rozbalovací nabídce';
$string['popupopen'] = 'Otevřít balíček v novém okně';
$string['popupsblocked'] = 'Vyskakovací okna jsou blokována, zastaveno přehrávání SCORM modulu. Před opakováním zkontrolujte nastavení vašeho prohlížeče.';
$string['position_error'] = 'Značka {$a->tag} nemůže být potomkem značky {$a->parent}.';
$string['preferencespage'] = 'Předvolby pouze pro tuto stránku';
$string['preferencesuser'] = 'Předvolby pro tento přehled';
$string['prev'] = 'Předchozí';
$string['privacy:metadata:aicc:data'] = 'Osobní údaje přešly z podsystému AICC/SCORM.';
$string['privacy:metadata:aicc:externalpurpose'] = 'Tento modul odesílá data externě pomocí AICC HACP.';
$string['privacy:metadata:aicc_session:lessonstatus'] = 'Stav lekce, kterou chcete sledovat';
$string['privacy:metadata:aicc_session:scormmode'] = 'Režim sledovaného prvku';
$string['privacy:metadata:aicc_session:scormstatus'] = 'Stav sledovaného prvku';
$string['privacy:metadata:aicc_session:sessiontime'] = 'Čas sezení, který chcete sledovat';
$string['privacy:metadata:aicc_session:timecreated'] = 'Čas, kdy byl vytvořen sledovaný prvek';
$string['privacy:metadata:attempt'] = 'Číslo pokusu';
$string['privacy:metadata:scoes_track:element'] = 'Název sledovaného prvku';
$string['privacy:metadata:scoes_track:value'] = 'Hodnota daného prvku';
$string['privacy:metadata:scorm_aicc_session'] = 'Informace o sezení HACP AICC';
$string['privacy:metadata:scorm_scoes_track'] = 'Sledované údaje SCO patřící do aktivity';
$string['privacy:metadata:timemodified'] = 'Čas, kdy byl sledovaný prvek naposledy změněn';
$string['privacy:metadata:userid'] = 'ID uživatele, který přistupuje k aktivitě SCORM';
$string['protectpackagedownloads'] = 'Zamezit stahování balíčků';
$string['protectpackagedownloads_desc'] = 'Pokud je povoleno, SCORM balíčky lze stáhnout pouze v případě, že uživatel má oprávnění course:manageactivities. Pokud je zakázáno, SCORM balíčky lze vždy stáhnout (prostřednictvím mobilu nebo jiným způsobem).';
$string['raw'] = 'Hrubý skór';
$string['regular'] = 'Správný manifest';
$string['report'] = 'Protokol';
$string['reportcountallattempts'] = '{$a->nbattempts} pokusů od {$a->nbusers} uživatelů, celkem z {$a->nbresults} výsledků';
$string['reportcountattempts'] = '{$a->nbresults} - výsledky ({$a->nbusers} uživatelů)';
$string['reports'] = 'Sestavy';
$string['repositorynotsupported'] = 'Podporovány jsou pouze taková úložiště souborových systémů, které odkazují přímo na soubor imsmanifest.xml.';
$string['response'] = 'Odpověď';
$string['result'] = 'Výsledek';
$string['results'] = 'Výsledky';
$string['review'] = 'Opakovaný náhled';
$string['reviewmode'] = 'Režim opakovaného náhledu';
$string['rightanswer'] = 'Správná odpověď';
$string['scoes'] = 'Učební objekty';
$string['score'] = 'Bodový zisk';
$string['scorm:addinstance'] = 'Přidat nový SCORM balíček';
$string['scorm:deleteownresponses'] = 'Odstranit vlastní pokusy';
$string['scorm:deleteresponses'] = 'Odstraňovat SCORM pokusy';
$string['scorm:savetrack'] = 'Ukládat záznamy o průchodu';
$string['scorm:skipview'] = 'Přeskočit přehled';
$string['scorm:viewreport'] = 'Zobrazit přehledy';
$string['scorm:viewscores'] = 'Zobrazit hodnocení';
$string['scormclose'] = 'Dostupné do';
$string['scormcourse'] = 'Kurz SCORM';
$string['scormloggingoff'] = 'API logování VYPNUTO';
$string['scormloggingon'] = 'API logování ZAPNUTO';
$string['scormopen'] = 'Dostupné od';
$string['scormresponsedeleted'] = 'Pokusy odstraněných uživatelů';
$string['scormstandard'] = 'Režim standardů SCORM';
$string['scormstandarddesc'] = 'Pokud není povoleno, umožňuje Moodle balíčkům SCORM 1.2 ukládat více, než to dovoluje specifikace, a při předávání uživatelského jména do balíčku SCORM používá nastavení formátu celého jména v Moodle.';
$string['scormtype'] = 'Typ';
$string['scormtype_help'] = 'Toto nastavení určuje, jako se balík začlení do kurzu. Jsou maximálně 4 možnosti:

* Nahraný balík - Umožňuje, aby se SCORM balík zvolil přes vyběr souborů.
* Externí SCORM manifest - umožňuje určení URL adresy směrující k souboru imsmanifest.xml. Poznámka: Má-li URL adresa jinou doménu jako váš portál, potom je lepší možnost "Stáhnutý balík", v opačném případě nebudou hodnocení uložena.
* Stáhnutý balík - umožňuje určení URL adresy. Balík bude rozbalen a uložen lokálně, případně aktualizován v případě, že je aktualizován externí SCORM balík.
* Externí AICC URL adresa - tato URL adresa je spouštěcí URL adresa pro jednu AICC aktivitu. Kolem ní se vytvoří "pseudo" balík.';
$string['scrollbars'] = 'Povolit svislý posuvník';
$string['search:activity'] = 'SCORM balíček - informace';
$string['selectall'] = 'Vybrat vše';
$string['selectnone'] = 'Zrušit výběr';
$string['show'] = 'Zobrazit';
$string['sided'] = 'Na straně';
$string['skipview'] = 'Student přeskakuje stránku se strukturou obsahu';
$string['skipview_help'] = 'Toto nastavení určuje, zda stránka s obsahem kurzu nebude zobrazeno.  V případě, že balíček obsahuje pouze jeden studijní objekt bude stránka s obsahem přeskočena vždy.';
$string['skipviewdesc'] = 'Jaká má být výchozí hodnota nastavení "Student přeskakuje stránku se strukturou obsahu"';
$string['slashargs'] = 'UPOZORNĚNÍ: argumenty zadávané lomítkem byly na tomto serveru zakázány. Mohou se vyskytnout problémy s funkčností.';
$string['stagesize'] = 'Velikost okna/rámce';
$string['stagesize_help'] = 'Tato nastavení určují výšku a šířku rámu/okna, ve kterém je vzdělávací objekt zobrazen.';
$string['started'] = 'Započetí';
$string['status'] = 'Stav';
$string['statusbar'] = 'Ukazovat stavový řádek';
$string['student_response'] = 'Odpověď';
$string['subplugintype_scormreport'] = 'Přehled';
$string['subplugintype_scormreport_plural'] = 'Přehledy';
$string['suspended'] = 'Pozastaveno';
$string['syntax'] = 'Chybná syntaxe';
$string['tag_error'] = 'Neznámá značka ({$a->tag}) s tímto obsahem: {$a->value}';
$string['time'] = 'Čas';
$string['title'] = 'Název';
$string['toc'] = 'Obsah';
$string['too_many_attributes'] = 'Značka {$a->tag} má příliš mnoho atributů';
$string['too_many_children'] = 'Značka {$a->tag} má příliš mnoho potomků';
$string['toolbar'] = 'Ukazovat lištu s ovládacími tlačítky';
$string['totaltime'] = 'Čas';
$string['trackcorrectcount'] = 'Správný součet';
$string['trackcorrectcount_help'] = 'Počet správných výsledků na otázku';
$string['trackid'] = 'ID';
$string['trackid_help'] = 'Toto je identifikátor nastavený vaším SCORM balíkem pro tuto úlohu, specifikace SCORM nepovoluje poskytnutí úplného textu otázky.';
$string['trackingloose'] = 'UPOZORNĚNÍ: Údaje o průchodu tímto balíčkem SCORM/AICC budou ztraceny!';
$string['tracklatency'] = 'Zpoždění';
$string['tracklatency_help'] = 'Čas, který uplyne od momentu, kdy byla úloha zpřístupněna studujícímu na zodpovězení, do momentu první odpovědi.';
$string['trackpattern'] = 'Vzor';
$string['trackpattern_help'] = 'Toto by měla být správná odpověď na tuto otázku. Nezobrazuje odpověď studujících.';
$string['trackresponse'] = 'Odpověď';
$string['trackresponse_help'] = 'To je reakce studenta na tento úkol';
$string['trackresult'] = 'Výsledek';
$string['trackresult_help'] = 'Zobrazuje se studentovi při správné odpovědi.';
$string['trackscoremax'] = 'Maximální počet bodů';
$string['trackscoremax_help'] = 'Maximální hodnota hrubého skóru';
$string['trackscoremin'] = 'Minimální počet bodů';
$string['trackscoremin_help'] = 'Minimální hodnota hrubého skóru';
$string['trackscoreraw'] = 'Hrubé skóre';
$string['trackscoreraw_help'] = 'Hodnota, které odráží výkon žáka vzhledem k rozsahu, který je vymezen hodnotami minimum a maximum';
$string['tracksuspenddata'] = 'Pozastavit dat';
$string['tracksuspenddata_help'] = 'Poskytuje prostor pro ukládání a načítání dat mezi relacemi studentů';
$string['tracktime'] = 'Čas';
$string['tracktime_help'] = 'Čas, kdy byl zahájen pokus';
$string['tracktype'] = 'Typ';
$string['tracktype_help'] = 'Typ úlohy, například "výběr" nebo "krátká odpověď".';
$string['trackweight'] = 'Váha';
$string['trackweight_help'] = 'Váha známky přiřazené úkolu při výpočtu skóre.';
$string['type'] = 'Typ';
$string['typeaiccurl'] = 'Externí AICC URL';
$string['typeexternal'] = 'Externí SCORM manifest';
$string['typelocal'] = 'Nahraný balíček';
$string['typelocalsync'] = 'Stažený balíček';
$string['undercontent'] = 'Za obsah';
$string['unziperror'] = 'Vyskytla se chyba při rozbalování balíčku';
$string['updatefreq'] = 'Frekvence automatické aktualizace';
$string['updatefreq_error'] = 'Frekvence automatické aktualizace lze nastavit pouze tehdy, když je soubor balíčku  externě hostovan';
$string['updatefreq_help'] = 'To dovoluje automaticky stáhnout externí balíček a aktualizovat';
$string['updatefreqdesc'] = 'Jaká má být výchozí hodnota nastavení "Frekvence automatické aktualizace"';
$string['validateascorm'] = 'Ověřit balíček SCORM/AICC';
$string['validation'] = 'Výsledek ověření';
$string['validationtype'] = 'Tato volba nastavuje knihovnu DOMXML, která bude použita při ověřování manifestu SCORM. Nevíte-li, co zvolit, ponechte vybrané nastavení.';
$string['value'] = 'Hodnota';
$string['versionwarning'] = 'Verze manifestu je starší než 1.3, upozornění u značky {$a->tag}.';
$string['viewallreports'] = 'Zobrazit protokoly pro {$a} pokusů';
$string['viewalluserreports'] = 'Zobrazit protokoly pro {$a} uživatelů';
$string['whatgrade'] = 'Známkování pokusů';
$string['whatgrade_help'] = '<p>Povolíte-li účastníkům více pokusů, můžete si vybrat, jak budou použity jejich výsledky v hodnocení. Můžete vybrat možnosti: nejvyšší skóre, průměrné skóre, prvý nebo poslední pokus pro zaznamenání do ohodnocení. Možnost poslední pokus neznamená, že pokus, který zaznamenal stav "neúspěšný" bude zaznamenán.</p>';
$string['whatgradedesc'] = 'Pokud je povoleno více pokusů, která hodnota bude zapsána do klasifikace; buď nejvyšší, průměr, první nebo poslední dokončený pokus.';
$string['width'] = 'Šířka';
$string['window'] = 'Okno';
$string['youmustselectastatus'] = 'Musíte vybrat vyžadovaný stav';
