<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qbehaviour_deferredcbm', language 'cs', version '3.11'.
 *
 * @package     qbehaviour_deferredcbm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accuracy'] = 'Přesnost';
$string['accuracyandbonus'] = 'Přesnost + Bonus';
$string['assumingcertainty'] = 'Nevybrali jste úroveň jistoty. Započítává se: {$a}.';
$string['averagecbmmark'] = 'Průměrná známka s mírou jistoty';
$string['basemark'] = 'Základní známka {$a}';
$string['breakdownbycertainty'] = 'Rozpad podle úrovní míry jistoty';
$string['cbmbonus'] = 'Bonus';
$string['cbmgradeexplanation'] = 'Při hodnocení s mírou jistoty je výsledná známka zobrazena jakožto relativní vzhledem k maximu, které je chápáno jako počet bodů získaný za zodpovězení všech úloh správně při úrovni jistoty J=1 (Nejisti).';
$string['cbmgrades'] = 'Známky testu s mírou jistoty';
$string['cbmgrades_help'] = 'Při hodnocení s mírou jistoty funguje známkování tak, že za zodpovězení všech úloh správně při úrovni jistoty J=1 (tj. nízká jistota) získáváte známku 100 %. Známka může být maximálně 300 %, pokud jsou všechny otázky zodpovězeny s vysokou úrovní jistoty, tj. J=3. Chybné posouzení vlastní jistoty může vést dokonce k negativnímu celkovému hodnocení. Pokud budete uvádět vysokou míru jístoty a přitom na otázky odpovídat nesprávně, bude se vám hodnocení snižovat mnohem více, než když uznáte, že si nejste jisti.

**Přesnost** odpovídá procentu správně zodpovězených úloh při ignorování míry jistoty ale zachování váhy pro maximální známku za každou úlohu. Úspěšné rozlišování více a méně spolehlivých odpovědí (tj. vlastní úrovně jistoty) dává lepší známku, než výběr stejné úrovně jistoty pro každou úlohu. To je reflektováno v rámci *Bonusu*.

**Přesnost** + **Bonus** je lepší metrikou pro hodnocení znalostí než *Přesnost*. Chybné posuzování vlastní jistoty může vést k negativnímu bonusu, což je varováním pro pečlivější posuzování toho, co člověk zná a nezná.';
$string['cbmgrades_link'] = 'qbehaviour/deferredcbm/certaintygrade';
$string['cbmmark'] = 'Známka testu s mírou jistoty {$a}';
$string['certainty'] = 'Jistota';
$string['certainty-1'] = 'Nevím';
$string['certainty1'] = 'J=1 (Nejisti: < 67%)';
$string['certainty2'] = 'J=2 (Středně jisti: > 67%)';
$string['certainty3'] = 'J=3 (Docela jisti: > 80%)';
$string['certainty_help'] = 'Známkování s mírou jistoty vyžaduje, abyste uvedli, jak jste si jisti svojí odpovědí. Dostupné možnosti jsou následující:

<table>
<tr>
<th>Úroveň jistoty</th><th>J=1</th><th>J=2</th><th>J=3</th>
</tr>
<tr>
<td>Známka za správnou odpověď</td><td>1</td><td>2</td><td>3</td>
</tr>
<tr>
<td>Známka za nesprávnou odpověď</td><td>0</td><td>-2</td><td>-6</td>
</tr>
<tr>
<td>Pravděpodobnost správné odpovědi</td><td>< 67%</td><td>67-80%</td><td>> 80%</td>
</tr>
</table>
<br>
Nejlepších známek budete dosahovat při adekvátním posouzení vlastní úroveň (ne)jistoty. Například, pokud je podle vás šance 1 ku 3 (či větší), že vaše odpověď je nesprávná, měli byste zadat úroveň jistoty J=1 (Nejisti) a vyhnout se tak riziku získání negativní známky.';
$string['certainty_link'] = 'qbehaviour/deferredcbm/certainty';
$string['certaintyshort-1'] = 'Nevím';
$string['certaintyshort1'] = 'J=1';
$string['certaintyshort2'] = 'J=2';
$string['certaintyshort3'] = 'J=3';
$string['dontknow'] = 'Nevím';
$string['foransweredquestions'] = 'Výsledky jen pro zodpovězené otázky ({$a}).';
$string['forentirequiz'] = 'Výsledky pro celý test ({$a} otázek)';
$string['howcertainareyou'] = 'Jak jste si jisti? {$a->help}: {$a->choices}';
$string['judgementok'] = 'v pořádku';
$string['judgementsummary'] = 'Odpovědi: {$a->responses}. Přesnost: {$a->fraction}. (Optimální rozsah {$a->idealrangelow} až {$a->idealrangehigh}). Na této úrovni bylo hodnocení vlastní jistoty {$a->judgement}.';
$string['noquestions'] = 'Žádné odpovědi';
$string['overconfident'] = 'nadhodnoceno';
$string['pluginname'] = 'Odložený výsledek s mírou jistoty';
$string['privacy:metadata'] = 'Modul Chování Odložený výsledek s mírou jistoty neukládá žádné osobní údaje.';
$string['slightlyoverconfident'] = 'mírně nadhodnoceno';
$string['slightlyunderconfident'] = 'mírně podhodnoceno';
$string['underconfident'] = 'podhodnoceno';
$string['weightx'] = 'Váha {$a}';
