<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'no', version '3.11'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Du har kommende BigBlueButton-sesjoner';
$string['bbbduetimeoverstartingtime'] = 'Sluttiden for denne aktiviteten må være senere enn starttiden';
$string['bbbdurationwarning'] = 'Maksimal varighet for denne sesjonen er %duration% minutes.';
$string['bbbrecordallfromstartwarning'] = 'Denne sesjonen tas opp fra start';
$string['bbbrecordwarning'] = 'Denne sesjonen kan tas opp';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Legg til et nytt BBB-møte';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Opprett sesjoner med funksjoner for livemøter';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Lag sesjoner med opptaksmuligheter';
$string['bigbluebuttonbn:deleterecordings'] = 'Slett opptak';
$string['bigbluebuttonbn:importrecordings'] = 'Importér opptak';
$string['bigbluebuttonbn:join'] = 'Delta i et BBB-møte';
$string['bigbluebuttonbn:managerecordings'] = 'Administrer BigBlueButton-opptak';
$string['bigbluebuttonbn:protectrecordings'] = 'Bli med på et BBB-møte';
$string['bigbluebuttonbn:publishrecordings'] = 'Publiser opptak';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Ubeskyttede opptak';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Upubliserte opptak';
$string['bigbluebuttonbn:view'] = 'Vis et rom/aktivitet';
$string['cachedef_currentfetch'] = 'Data for å liste opp opptak som er hentet nylig.';
$string['cachedef_recordings'] = 'Registrering av metadata';
$string['cachedef_serverinfo'] = 'Informasjon om ekstern server';
$string['cachedef_validatedurls'] = 'Buffer for validerte URL-sjekker';
$string['calendarstarts'] = '{$a} er planlagt for';
$string['cannotperformaction'] = 'Kan ikke utføre handlingen {$a} på dette opptaket';
$string['completionattendance'] = 'Studenten må delta på møtet i:';
$string['completionattendance_desc'] = 'Studenten må delta på møtet og forbli i økten i minst {$a} minutt(er)';
$string['completionattendance_event_desc'] = 'Studenten har deltatt på møtet eller vært i økten i minst {$a} minutt(er)';
$string['completionattendancegroup'] = 'Krev tilstedeværelse';
$string['completionattendancegroup_help'] = 'Det kreves deltakelse på møtet i (n) minutter for å fullføre';
$string['completionengagement_desc'] = 'Eleven skal delta i aktiviteter under møtet';
$string['completionengagementchats'] = 'Chatter';
$string['completionengagementchats_desc'] = 'Studenten må delta i {$a} chat(er)-hendelser for å fullføre den';
$string['completionengagementchats_event_desc'] = 'Har startet {$a} chat(er)-begivenhet(er)';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Eleven må sende {$a} emoji(er) til avstemninger for å fullføre den';
$string['completionengagementemojis_event_desc'] = 'Har vist {$a} Emoji(er)';
$string['completionengagementgroup'] = 'Krev engasjement';
$string['completionengagementgroup_help'] = 'Aktiv deltakelse under økten kreves for gjennomføring';
$string['completionengagementpollvotes'] = 'Avstemningsstemmer';
$string['completionengagementpollvotes_desc'] = 'Studenten må stemme i avstemningen {$a} gang(er) for å fullføre den';
$string['completionengagementpollvotes_event_desc'] = 'Har deltatt på {$a} avstemninger';
$string['completionengagementraisehand'] = 'Krev "rekk opp hånda"';
$string['completionengagementraisehand_desc'] = 'Eleven må rekke opp hånden {$a} gang(er) for å fullføre den';
$string['completionengagementraisehand_event_desc'] = 'Har rukket opp hånda {$a} ganger';
$string['completionengagementtalks'] = 'Snakk hendelser';
$string['completionengagementtalks_desc'] = 'Eleven må snakke {$a} gang(er) for å fullføre det';
$string['completionengagementtalks_event_desc'] = 'Har snakket {$a} ganger';
$string['completionupdatestate'] = 'Fullført oppdateringsstatus';
$string['completionvalidatestate'] = 'Bekreft fullføring';
$string['completionvalidatestatetriggered'] = 'Valideringsfullføring har blitt utløst.';
$string['completionview'] = 'Krever visning';
$string['completionview_desc'] = 'Eleven må vise et rom for å fullføre det.';
$string['completionview_event_desc'] = 'Har sett på Rom-siden.';
$string['config_checksum_algorithm'] = 'BigBlueButton Checksum algoritme';
$string['config_checksum_algorithm_description'] = 'Sjekksumalgoritmen til BigBlueButton-serveren.
(SHA1 garanterer kompatibilitet med eldre serverversjoner, men er mindre sikker mens SHA512 er FIPS 140-2-kompatibel.)';
$string['config_default_messages'] = 'Standard meldinger';
$string['config_default_messages_description'] = 'Angi meldingsstandarder for aktiviteter';
$string['config_disablecam_default'] = 'Deaktiver kamera aktivert som standard';
$string['config_disablecam_default_description'] = 'Hvis aktivert, vil webkameraene bli deaktivert.';
$string['config_disablecam_editable'] = 'Deaktiver kamera kan redigeres';
$string['config_disablecam_editable_description'] = 'Deaktiver kamera som standard kan redigeres når sesjonen legges til eller oppdateres.';
$string['config_disablemic_default'] = 'Deaktiver mikrofon aktivert som standard';
$string['config_disablemic_default_description'] = 'Hvis aktivert, vil mikrofonene bli deaktivert.';
$string['config_disablemic_editable'] = 'Deaktiver mikrofon kan redigeres';
$string['config_disablemic_editable_description'] = 'Deaktiver mikrofon som standard kan redigeres når sesjonen legges til eller oppdateres.';
$string['config_disablenote_default'] = 'Deaktiver delte notater aktivert som standard';
$string['config_disablenote_default_description'] = 'Hvis den er aktivert, vil de delte notatene bli deaktivert.';
$string['config_disablenote_editable'] = 'Deaktiver delte notater kan redigeres';
$string['config_disablenote_editable_description'] = 'Deaktiver delte notater som standard kan redigeres når sesjonen legges til eller oppdateres.';
$string['config_disableprivatechat_default'] = 'Deaktiver privat chat aktivert som standard';
$string['config_disableprivatechat_default_description'] = 'Hvis den er aktivert, vil den private chatten bli deaktivert.';
$string['config_disableprivatechat_editable'] = 'Deaktiver privat chat kan redigeres';
$string['config_disableprivatechat_editable_description'] = 'Deaktiver privat chat som standard kan redigeres når sesjonen legges til eller oppdateres.';
$string['config_disablepublicchat_default'] = 'Deaktiver offentlig chat aktivert som standard';
$string['config_disablepublicchat_default_description'] = 'Hvis den er aktivert, vil den offentlige chatten bli deaktivert.';
$string['config_disablepublicchat_editable'] = 'Deaktiver offentlig chat kan redigeres';
$string['config_disablepublicchat_editable_description'] = 'Deaktiver offentlig chat som standard kan redigeres når forekomsten legges til eller oppdateres.';
$string['config_experimental_features'] = 'Konfigurasjon for eksperimentelle funksjoner';
$string['config_experimental_features_description'] = 'Konfigurasjon for eksperimentelle funksjoner.';
$string['config_extended_capabilities'] = 'Konfigurasjon for utvidede rettigheter';
$string['config_extended_capabilities_description'] = 'Konfigurasjon for utvidede rettigheter når BigBlueButton serveren tilbyr dem.';
$string['config_general'] = 'Generell konfigurasjon';
$string['config_general_description'] = 'Disse innstillinge blir <b>alltid</b> brukt';
$string['config_hideuserlist_default'] = 'Skjul brukerliste aktivert som standard';
$string['config_hideuserlist_default_description'] = 'Hvis aktivert, vil deltakerlisten for sesjonen skjules.';
$string['config_hideuserlist_editable'] = 'Skjul deltakerliste kan redigeres';
$string['config_hideuserlist_editable_description'] = 'Skjul deltakerliste kan som standard redigeres når sesjonen legges til eller oppdateres.';
$string['config_importrecordings'] = 'Konfigurasjon for funksjonen "Importer opptak"';
$string['config_importrecordings_description'] = 'Disse innstillingene er funksjonsspesifikke';
$string['config_importrecordings_enabled'] = 'Importer opptak er aktivert';
$string['config_importrecordings_enabled_description'] = 'Når denne og opptaksfunksjonen er aktivert er det mulig å importere opptak fra andre kurs inn i en aktivitet.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importer opptak fra slettede aktiviteter er aktivert';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Når denne og opptaksfunksjonen er aktivert er det mulig å importere opptak fra aktiviteter som ikke lengre er i kurset.';
$string['config_lockonjoin_default'] = 'Ignorer lås ved sammenføyning aktivert som standard';
$string['config_lockonjoin_default_description'] = 'Hvis aktivert, vil låseinnstillingene bli ignorert. Låsekonfigurasjon må være aktivert for at dette skal gjelde.';
$string['config_lockonjoin_editable'] = 'Ignorer lås ved sammenføyning kan redigeres';
$string['config_lockonjoin_editable_description'] = 'Ignorer lås ved sammenføyning kan som standard redigeres når sesjonen legges til eller oppdateres.';
$string['config_locksettings'] = 'Konfigurasjon for låseinnstillinger';
$string['config_locksettings_description'] = 'Disse innstillingene aktiverer eller deaktiverer alternativer i brukergrensesnittet for låseinnstillinger, og definerer også standardverdier for disse alternativene.';
$string['config_meetingevents_enabled'] = 'Registrer live-arrangementer';
$string['config_meetingevents_enabled_description'] = 'Aktiver programtillegget for å godta og behandle live-hendelser etter at sesjonen er over. (Den må være aktivert for "Aktivitetsfullføring" og vil bare fungere hvis BigBlueButton-serveren er i stand til å behandle post_events-skript)';
$string['config_muteonstart'] = 'Konfigurasjon for funksjonen "Demp lyd i starten"';
$string['config_muteonstart_default'] = '"Demp lyd i starten" aktivert som standard';
$string['config_muteonstart_default_description'] = 'Hvis aktivert vil lyden være dempet ved start';
$string['config_muteonstart_description'] = 'Disse innstillingene aktiverer eller deaktiverer valg i brukergrensesnittet og definerer også standardverdier for disse valgene.';
$string['config_muteonstart_editable'] = '"Demp lyd i starten" kan redigeres';
$string['config_muteonstart_editable_description'] = '"Demp lyd i start" som standard kan redigeres når instansen leggestil eller oppdateres.';
$string['config_participant'] = 'Deltakerkonfigurasjon';
$string['config_participant_description'] = 'Disse innstillingene definerer standardrollen for deltakere i en konferanse.';
$string['config_participant_moderator_default'] = 'Moderator som standard';
$string['config_participant_moderator_default_description'] = 'Denne regelen brukes som standard når et nytt rom legges til';
$string['config_presentation_default'] = 'Standardfil for funksjonen "Forhåndsopplastet presentasjon"';
$string['config_presentation_default_description'] = 'Denne innstillingen tillater valge av en fil som brukes som standard i alle BBB instanser dersom "Forhåndsopplastet presentasjon" er aktivert.';
$string['config_preuploadpresentation'] = 'Innstillinger for funksjonen "Forhåndsopplastet presentasjon"';
$string['config_preuploadpresentation_description'] = 'Disse innstillingene aktiverer eller deaktiverer valg i brukergrensesnittet og definerer standardinnstillingene for disse valgene. Funksjonen fungerer bare dersom Moodleserveren er tilgjengelig for BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Presentasjon som kan redigeres på forhånd';
$string['config_preuploadpresentation_editable_description'] = 'Presentasjonsfunksjonen for forhåndsopplasting kan redigeres i brukergrensesnittet når rommet eller konferansen legges til eller oppdateres.';
$string['config_recording'] = 'Innstillinger for funksjonen "Ta opp møte"';
$string['config_recording_all_from_start_default'] = 'Ta opp alle fra start';
$string['config_recording_all_from_start_default_description'] = 'Ved avkrysning vil møte tas opp fra starten';
$string['config_recording_all_from_start_editable'] = 'Ta opp alle fra start kan redigeres';
$string['config_recording_all_from_start_editable_description'] = 'Ved aktivering vil brukergrensesnittet inludere et valg for aktivering og deaktivering av opptak fra start-funksjonen.';
$string['config_recording_default'] = 'Opptaksfunksjonen er aktivert som standard';
$string['config_recording_default_description'] = 'Hvis aktivert vil sesjonene opprettet i BigBlueButton ha opptaksmuligheter.';
$string['config_recording_description'] = 'Disse innstillingene er funksjonsspesifikke';
$string['config_recording_editable'] = 'Opptaksfunksjonen kan redigeres';
$string['config_recording_editable_description'] = 'Ved avkrysning vil brukergrensesnittet et alternativ for aktivering eller deaktivering av opptaksfunksjonen.';
$string['config_recording_hide_button_default'] = 'Skjul opptaksknappen';
$string['config_recording_hide_button_default_description'] = 'Ved avkrysning vil opptaksknappen være skjult';
$string['config_recording_hide_button_editable'] = 'Skjul opptaksknappen kan redigeres';
$string['config_recording_hide_button_editable_description'] = 'Ved avkrysning vil brukergrensesnitet inkludere et valg for aktivering og deaktivering opptaksknappen.';
$string['config_recording_protect_editable'] = 'Status for beskyttede opptak kan redigeres';
$string['config_recording_protect_editable_description'] = 'Hvis det er merket av, inkluderer grensesnittet et alternativ for å beskytte/oppheve beskyttelse av opptak.';
$string['config_recording_refresh_period'] = 'Oppdateringsperiode for opptak (i sekunder)';
$string['config_recording_refresh_period_description'] = 'Hvor ofte bør BigBlueButton-serveren spørres for å oppdatere ekstern informasjon for et opptak?';
$string['config_recordingready_enabled'] = 'Send varsler når et opptak er klart';
$string['config_recordingready_enabled_description'] = 'Aktiver plugin for å sende varsler når opptaket er klart. (Det vil bare fungere hvis skriptet post_publish_recording_ready_callback er aktivert i BigBlueButton-serveren)';
$string['config_recordings'] = 'Innstillinger for funksjonen "Vis opptak"';
$string['config_recordings_description'] = 'Disse innstillingene er funksjonsspesifikke';
$string['config_recordings_general'] = 'Vis opptaksinnstillinger';
$string['config_recordings_general_description'] = 'Disse innstillingene brukes kun ved visning av opptak';
$string['config_recordings_imported_default'] = 'Vis kun importerte lenker som standard';
$string['config_recordings_imported_default_description'] = 'Hvis aktivert vil opptakstabellen kun inkludere importerte lenker til opptakene.';
$string['config_recordings_imported_editable'] = 'Funksjonen "Vis kun importe lenker" kan redigeres';
$string['config_recordings_imported_editable_description'] = 'Funksjonen "Vis kun importe lenker" som standard kan redigeres når instansen legges til eller oppdateres.';
$string['config_recordings_preview_default'] = 'Forhåndsvisning er aktivert som standard';
$string['config_recordings_preview_default_description'] = 'Hvis aktivert vil tabellen inkludere en forhåndsvisning av presentasjonen.';
$string['config_recordings_preview_editable'] = 'Forhåndsvisningsfunksjonen kan redigeres';
$string['config_recordings_preview_editable_description'] = 'Forhåndsvisningsfunksjonen kan redigeres når instansen legges til eller oppdateres.';
$string['config_recordings_sortorder'] = 'Sorter opptakene i stigende rekkefølge.';
$string['config_recordings_sortorder_description'] = 'Som standard vises opptak i synkende rekkefølge. Ved avkrysning vil sorteringen være i stigende rekkefølge.';
$string['config_scheduled'] = 'Innstillinger for planlagte sesjoner';
$string['config_scheduled_description'] = 'Disse innstillingene definerer noe av standardoppførselen for planlagte sesjoner.';
$string['config_scheduled_pre_opening'] = 'Tilgjengelighet før åpningstid (minutter)';
$string['config_scheduled_pre_opening_description'] = 'Antall minutter før starttiden som sesjonen skal være tilgjengelig.';
$string['config_sendnotifications'] = 'Innstilinger for funksjonen  "Send varsler"';
$string['config_sendnotifications_description'] = 'Disse innstillingene aktiverer eller deaktiverer alternativer i brukergrensesnittet og definerer også verdier for disse alternativene.';
$string['config_sendnotifications_enabled'] = 'Send varslinger er aktivert';
$string['config_sendnotifications_enabled_description'] = 'Hvis aktivert, inkluderer brukergrensesnittet for redigering av aktiviteten et alternativ for å sende et varsel til en registrert bruker når aktiviteten legges til eller oppdateres.';
$string['config_server_url'] = 'BigBlueButton serverURL';
$string['config_server_url_description'] = 'URLen til BigBlueButton-serveren må ende med/bigbluebutton/. (Denne standardURLen er for en BigBlueButton-server som tilbys av Blindside Networks og som du kan bruke for testing).';
$string['config_shared_secret'] = 'BigBlueButton Shared Secret';
$string['config_shared_secret_description'] = 'Sikkerhetssaltet til BigBlueButton-serveren din. (Standardsaltet brukes for en BigBlueButton-server tilbdt av BigBlueButton Networks som kan brukes for testing)';
$string['config_uidelegation_enabled'] = 'UI-delegering er aktivert';
$string['config_uidelegation_enabled_description'] = 'Disse innstillingene aktiverer eller deaktiverer UI delegeringen til BigBlueButton-serveren.';
$string['config_userlimit'] = 'Innstillinger for funksjonen "Brukerbegrensning"';
$string['config_userlimit_default'] = 'Brukerbegrensning aktivert som standard';
$string['config_userlimit_default_description'] = 'Antallet bruker tillatt som standard i en sesjon når et nytt rom eller konferanse legges til. Dersom den settes til 0 vil antallet være ubegrenset.';
$string['config_userlimit_description'] = 'Disse innstillingene aktiverer eller deaktiverer valg i brukergensesnitt og definerer også standardverdier for disse valgene.';
$string['config_userlimit_editable'] = 'Brukbegrensningsfunksjonen kan redigeres';
$string['config_userlimit_editable_description'] = 'Standardverdien for brukerbegrensning kan redigeres når rommet eller konferansen legges til eller oppdateres.';
$string['config_voicebridge'] = 'Konfigurasjon for funksjonen "Voice bridge"';
$string['config_voicebridge_description'] = 'Disse innstillingene aktiverer eller deaktiverer valg i brukergensesnitt og definerer også standardverdier for disse valgene.';
$string['config_voicebridge_editable'] = 'Konferansen "voice bridge" kan redigeres';
$string['config_voicebridge_editable_description'] = 'Konferanse "Voice bridge" kan tildeles permanent til et rom eller konferanse. Når tildelt kan ikke nummeret brukes av et annet rom eller konferanse.';
$string['config_waitformoderator'] = 'Innstillinger for funksjonen "Vent på moderator"';
$string['config_waitformoderator_cache_ttl'] = 'Ventr på moderator mellomlagring TTL (sekunder)';
$string['config_waitformoderator_cache_ttl_description'] = 'For å støtte store antall brukere benytter denne modulen seg av mellomlagring. Denne variabelen definerer hvor lenge mellomlageret beholdes for den neste forespørselen sendes til BigBlueButton-serveren.';
$string['config_waitformoderator_default'] = 'Vent på moderator er aktivert som standard';
$string['config_waitformoderator_default_description'] = 'Vent på moderator er aktivert som standard når et nytt rom eller konferanse legges til.';
$string['config_waitformoderator_description'] = 'Disse innstillingene er funksjonsspesifikke';
$string['config_waitformoderator_editable'] = 'Funksjonen "Vent på moderator" kan redigeres';
$string['config_waitformoderator_editable_description'] = 'Standarderdien for "Vent på moderator" kan endres når rommet eller konferansen opprettes eller oppdateres.';
$string['config_waitformoderator_ping_interval'] = 'Vent på moderator ping (sekunder)';
$string['config_waitformoderator_ping_interval_description'] = 'Når funksjoen "Vent på moderator" er aktivert vil klienten pinge sesjonsstatusen med et visst intervall.';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton bruker config.php med en global variabel som har blitt avviklet. Vennligst konverter filen siden den ikke vil bli støttet i fremtidige versjoner';
$string['config_warning_curl_not_installed'] = 'Denne funksjonen krever at CURL-utvidelsen for php er installert og aktivert. Innstillingen vil bare være tilgjengelig om denne betingelsen er oppfylt.';
$string['config_welcome_default'] = 'Standard velkomstmelding';
$string['config_welcome_default_description'] = 'Velkomstmeldingen vises når deltakerne kommer inn i rommet. Hvis feltet er tomt, vises en melding satt på BigBlueButton-serveren.';
$string['config_welcome_editable'] = 'Standard velkomst melding kan redigeres av lærere';
$string['config_welcome_editable_description'] = 'Velkomstmelding kan redigeres når eksempelet legges til eller oppdateres';
$string['email_body_notification_meeting_by'] = 'av';
$string['email_body_notification_meeting_description'] = 'Beskrivelse';
$string['email_body_notification_meeting_details'] = 'Detaljer';
$string['email_body_notification_meeting_end_date'] = 'Sluttdato';
$string['email_body_notification_meeting_has_been'] = 'har vært';
$string['email_body_notification_meeting_start_date'] = 'Startdato';
$string['email_body_notification_meeting_title'] = 'Tittel';
$string['email_body_recording_ready_for'] = 'Opptak for';
$string['email_body_recording_ready_in_course'] = 'i kurset';
$string['email_footer_sent_by'] = 'Denne automatiske varslingen ble sent av';
$string['email_footer_sent_from'] = 'fra kurset';
$string['end_session_confirm'] = 'Er du sikker på at du vil avslutte sesjonen?';
$string['end_session_confirm_title'] = 'Virkelig avslutte sesjonen?';
$string['end_session_notification'] = 'Sesjonen er nå avsluttet.';
$string['ends_at'] = 'Slutter';
$string['event_activity_created'] = 'Aktivitet opprettet';
$string['event_activity_deleted'] = 'Aktivitet slettet';
$string['event_activity_updated'] = 'Aktivitet oppdatert';
$string['event_live_session'] = 'Live-sesjon';
$string['event_meeting_created'] = 'Møte opprettet';
$string['event_meeting_ended'] = 'Møtet ble avsluttet';
$string['event_meeting_joined'] = 'Ble med i møte';
$string['event_meeting_left'] = 'Forlot møte';
$string['event_recording_deleted'] = 'Opptak slettet';
$string['event_recording_edited'] = 'Opptak redigert';
$string['event_recording_imported'] = 'Opptak importert';
$string['event_recording_protected'] = 'Opptak beskyttet';
$string['event_recording_published'] = 'Opptak publisert';
$string['event_recording_unprotected'] = 'pptak ubeskyttet';
$string['event_recording_unpublished'] = 'Opptak upublisert';
$string['event_recording_viewed'] = 'Opptak vist';
$string['event_unknown'] = 'Ukjent hendelse';
$string['general_error_cannot_create_meeting'] = 'Kan ikke opprette sesjon.';
$string['general_error_cannot_get_recordings'] = 'Kan ikke hente opptak.';
$string['general_error_no_answer'] = 'Tomt svar. Vennligst sjekk URL-en til BigBlueButton-serveren OG sjekk om BigBlueButton-serveren kjører.';
$string['general_error_not_allowed_to_create_instances'] = 'Bruker har ikke tillatelsen til å opprette noen instanser.';
$string['general_error_not_found'] = 'Entitet ikke funnet: {$a}.';
$string['general_error_unable_connect'] = 'Kan ikke koble til. Vennligst sjekk url\'en til BigBlueButton-serveren OG sjekk at BigBlueButton-serveren kjører.';
$string['index_confirm_end'] = 'Ønsker du å avslutte det virtuelle klasserommet?';
$string['index_disabled'] = 'deaktivert';
$string['index_enabled'] = 'aktivert';
$string['index_ending'] = 'Avslutter det virtuelle klasserommet... vennligst vent';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} er feil';
$string['index_error_checksum'] = 'En sjekksumfeil oppstoForsikre deg om at du har det korrekte saltet.';
$string['index_error_forciblyended'] = 'Det er ikke mulig å bli med i dette møtet fordi det har blitt avsluttet.';
$string['index_error_noinstances'] = 'Det er ingen instanser av bigbluebuttonbn';
$string['index_error_unable_display'] = 'Kan ikke vises møtene. Vennligst sjekk url\'en til BigBlueButton-serveren og sjekk om serveren kjører.';
$string['index_heading'] = 'BigBlueButton rom';
$string['index_heading_actions'] = 'Handlinger';
$string['index_heading_group'] = 'Gruppe';
$string['index_heading_moderator'] = 'Moderatorer';
$string['index_heading_name'] = 'Rom';
$string['index_heading_recording'] = 'Opptak';
$string['index_heading_users'] = 'Brukere';
$string['index_heading_viewer'] = 'Seere';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på den kognitive forståelsen studenten har vist i en BigBlueButtonBN-aktivitet.';
$string['indicator:socialbreadth'] = 'BigBlueButton sosial';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på den sosiale forståelsen studenten har vist i en BigBlueButton-aktivitet';
$string['instance_type_default'] = 'Rom/aktivitet med opptak';
$string['instance_type_recording_only'] = 'Kun opptak';
$string['instance_type_room_only'] = 'Kun rom/aktivitet';
$string['instanceprofilewithoutrecordings'] = 'Denne forekomstprofilen kan ikke vise opptak';
$string['messageprovider:instance_updated'] = 'BigBlueButton-sesjonen oppdatert';
$string['messageprovider:recording_ready'] = 'BigBlueButton-opptak klar til visning';
$string['minute'] = 'minutt';
$string['minutes'] = 'minutter';
$string['mod_form_block_general'] = 'Generelle innstillinger';
$string['mod_form_block_participants'] = 'Rolle tildelt under live-sesjon';
$string['mod_form_block_presentation'] = 'Presentasjonsinnhold';
$string['mod_form_block_presentation_default'] = 'Standard presentasjonsinnhold';
$string['mod_form_block_record'] = 'Opptaksinnstillinger';
$string['mod_form_block_recordings'] = 'Vis for opptak';
$string['mod_form_block_room'] = 'Aktivitet/rom innstillinger';
$string['mod_form_block_schedule'] = 'Sesjonsplan';
$string['mod_form_field_closingtime'] = 'Frist for å bli med';
$string['mod_form_field_conference_name'] = 'Konferansenavn';
$string['mod_form_field_disablecam'] = 'Deaktiver webkameraer';
$string['mod_form_field_disablemic'] = 'Deaktiver mikrofoner';
$string['mod_form_field_disablenote'] = 'Deaktiver delte notater';
$string['mod_form_field_disableprivatechat'] = 'Deaktiver privat chat';
$string['mod_form_field_disablepublicchat'] = 'Deaktiver felles chat';
$string['mod_form_field_duration'] = 'Varighet';
$string['mod_form_field_duration_help'] = 'Ved å sette en varighet for møtet vil det etablere en makstid som møtet vil være aktivt før opptaket avsluttes.';
$string['mod_form_field_hideuserlist'] = 'Skjul deltakerliste';
$string['mod_form_field_instanceprofiles'] = 'Instanstype';
$string['mod_form_field_instanceprofiles_help'] = 'Velg type for denne BigBlueButton instansen.';
$string['mod_form_field_intro'] = 'Beskrivelse';
$string['mod_form_field_intro_help'] = 'En kort beskrivelse for rommet eller konferansen';
$string['mod_form_field_lockonjoin'] = 'Ingnorér låseinnstillinger';
$string['mod_form_field_muteonstart'] = 'Demp lyd ved start';
$string['mod_form_field_name'] = 'Navn på virtuelt klasserom';
$string['mod_form_field_nosettings'] = 'Ingen innstillinger kan redigeres';
$string['mod_form_field_notification'] = 'Varsle denne endringen til brukere som er registrert';
$string['mod_form_field_notification_created_help'] = 'Send et varsel til alle registrerte brukere for å fortelle dem at denne aktiviteten er opprettet';
$string['mod_form_field_notification_help'] = 'Send et varsel til innmeldte brukere slik at de kan få vite at denne aktiviteten har blitt opprettet eller endret.';
$string['mod_form_field_notification_modified_help'] = 'Send et varsel til innmeldte brukere slik at de kan få vite at denne aktiviteten har blitt endret.';
$string['mod_form_field_notification_msg_at'] = 'på';
$string['mod_form_field_notification_msg_created'] = 'opprettet';
$string['mod_form_field_notification_msg_modified'] = 'endret';
$string['mod_form_field_openingtime'] = 'Åpningstidspunkt';
$string['mod_form_field_participant_add'] = 'Legg til oppgave';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Seer';
$string['mod_form_field_participant_list'] = 'Oppgaveliste';
$string['mod_form_field_participant_list_action_add'] = 'Legg til';
$string['mod_form_field_participant_list_action_remove'] = 'Fjern';
$string['mod_form_field_participant_list_text_as'] = 'blir med på økt som';
$string['mod_form_field_participant_list_type_all'] = 'Alle innmeldte brukere';
$string['mod_form_field_participant_list_type_owner'] = 'Eier';
$string['mod_form_field_participant_list_type_role'] = 'Rolle';
$string['mod_form_field_participant_list_type_user'] = 'Bruker';
$string['mod_form_field_record'] = 'Sesjon kan tas opp';
$string['mod_form_field_recordallfromstart'] = 'Ta opp fra start';
$string['mod_form_field_recordhidebutton'] = 'Skjul opptaksknappen';
$string['mod_form_field_recordings_html'] = 'Vis tabell i ren html';
$string['mod_form_field_recordings_imported'] = 'Vis kun importerte lenker';
$string['mod_form_field_recordings_preview'] = 'Vis opptaksforhåndsvisning';
$string['mod_form_field_room_name'] = 'Romnavn';
$string['mod_form_field_userlimit'] = 'Brukergrense';
$string['mod_form_field_userlimit_help'] = 'Maks antall brukere i et møte. Om grensen settes til 0 vil antall brukere være ubegrenset.';
$string['mod_form_field_voicebridge'] = 'Voice bridge [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Feil format. Du må legge inn et tall mellom 1 og 9999.';
$string['mod_form_field_voicebridge_help'] = 'Telefonkonferansenummer som deltakerne må bruke for å bli med i en telefonkonferanse via telefon. Et nummer mellom 1 og 9999 må brukes. Dersom verdien er 0 vil det bli ignorert og et tilfeldig nummer vil genereres av BigBlueButton. Et nummer 7 vil legges til foran de fire sifrene som er lagt inn.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Ikke en unik verdi. Dette nummeret brukes av et annet rom eller konferanse.';
$string['mod_form_field_wait'] = 'Vent på moderator';
$string['mod_form_field_wait_help'] = 'Deltakere må vente til en moderator blir med i sesjonen før de kan bli med.';
$string['mod_form_field_welcome'] = 'Velkomstmelding';
$string['mod_form_field_welcome_default'] = '<br>Velkommen til <b>%%CONFNAME%%</b>!<br><br>For hjelp til bruk av BigBlueButton se disse (korte) <a href="event:http://www.bigbluebutton.org /content/videos"><u>opplæringsvideoer</u></a>.<br><br>For å bli med i lydbroen, klikk på telefonikonet (øverst i midten). <b>Bruk et hodesett for å unngå å forårsake bakgrunnsstøy for andre.</b>';
$string['mod_form_field_welcome_help'] = 'Erstatter standardmeldingen som er satt opp for BigBlueButton-serveren. Meldingen kan inneholde nøkkelord (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) som vil bli erstattet automatisk, og også html-koder som &lt;b>...&lt;/b>, &lt; br />, &lt;u>&lt;/u> eller &lt;i>&lt;/i>';
$string['mod_form_locksettings'] = 'Lås innstillinger';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton lar deg lage fra Moodle-lenker til sanntids online klasserom ved hjelp av BigBlueButton, et åpen kildekode-nettkonferansesystem for fjernundervisning.

Ved å bruke BigBlueButton kan du spesifisere for tittel, beskrivelse, kalenderoppføring (som gir en datoperiode for å bli med i økten), grupper og detaljer om opptak av nettøkten.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton aktivitet';
$string['nosuchinstance'] = 'Ingen slik forekomst {$a->entity} med id: {$a->id}';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton-aktiviteten er opprettet.';
$string['notification_instance_created_small'] = 'Et nytt BigBlueButton-rom kalt {$a->name} ble opprettet';
$string['notification_instance_created_subject'] = 'En ny BigBlueButton-rom er opprettet';
$string['notification_instance_description'] = 'Beskrivelse';
$string['notification_instance_end_date'] = 'Sluttdato';
$string['notification_instance_name'] = 'Tittel';
$string['notification_instance_start_date'] = 'Startdato';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton-rom har blitt oppdatert.';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButton-rommet ble oppdatert';
$string['notification_instance_updated_subject'] = 'Din BigBlueButton-rom har blitt oppdatert';
$string['notification_recording_ready_html'] = 'Et opptak er nå tilgjengelig for sesjonen i <b><a href="{$a->link}">{$a->name}</a></b>.';
$string['notification_recording_ready_plain'] = 'Et opptak er nå tilgjengelig for sesjonen {$a->name}. Se {$a->link} for å se opptak av sesjonen.';
$string['notification_recording_ready_small'] = 'Et nytt opptak er tilgjengelig for {$a->name} BigBlueButton-rommet';
$string['notification_recording_ready_subject'] = 'Opptak klar til visning';
$string['pluginadministration'] = 'BigBlueButton administrasjon';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'For å opprette og bli med i BigBlueButton-økter, må brukerdata utveksles med serveren.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Fullt navn på brukeren som har tilgang til BigBlueButton-serveren.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Bruker-ID-en til brukeren som har tilgang til BigBlueButton-serveren.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Lagrer konfigurasjonen for rommet eller aktiviteten som definerer funksjonene og den generelle oppførselen til BigBlueButton-økten.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'En liste over regler som definerer rollen brukerne skal ha i live-møtet. En bruker-ID kan lagres ettersom tillatelser kan gis per rolle eller bruker.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Lagrer hendelser som utløses ved bruk av modulen.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Typen hendelse utløst av brukeren.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Møtet som brukeren hadde tilgang til.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Kan inneholde ekstra informasjon knyttet til møtet eller opptaket som er berørt av arrangementet.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Tidspunktet da loggen ble opprettet.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Bruker-ID-en til brukeren som utløste hendelsen.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Lagrer metadata om opptak.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Bruker-ID-en til brukeren som sist endret et opptak.';
$string['recordings_from_deleted_activities'] = 'Opptak fra slettede aktiviteter';
$string['recordingurlnotfound'] = 'Opptakets URL er ugyldig.';
$string['removedevents'] = 'Slettede hendelser';
$string['removedlogs'] = 'Slettet logger';
$string['removedrecordings'] = 'Slettede opptak';
$string['removedtags'] = 'Slettede tagger';
$string['report_join_info'] = 'Har blitt med i rommet {$a} gang(er)';
$string['report_play_recording_info'] = 'Har spilt et opptak {$a} gang(er)';
$string['report_room_view'] = 'Har sett på Rom-siden';
$string['resetevents'] = 'Slettede hendelser';
$string['resetlogs'] = 'Slett logger';
$string['resetlogs_help'] = 'Sletting av loggene vil gjøre at opptaksreferansene blir borte';
$string['resetrecordings'] = 'Slett opptak';
$string['resetrecordings_help'] = 'Sletting av opptakene vil gjøre de utilgjengelige over alt og kan ikke angres';
$string['resettags'] = 'Slett tagger';
$string['search:activity'] = 'BigBlueButton - aktivitetsinformasjon';
$string['search:tags'] = 'BigBlueButton - taggeinformasjon';
$string['sendnotification'] = 'Send melding';
$string['settings'] = 'BigBlueButton innstillinger';
$string['started_at'] = 'Startet';
$string['starts_at'] = 'Starter';
$string['taskname:check_dismissed_recordings'] = 'Se etter avviste opptak';
$string['taskname:check_pending_recordings'] = 'Hent ventende opptak';
$string['userlimitreached'] = 'Antall deltakere som er tillatt i en sesjon er nådd.';
$string['view_conference_action_end'] = 'Avslutt sesjon';
$string['view_conference_action_join'] = 'Bli med i sesjon';
$string['view_error_action_not_completed'] = 'Handlingen kunne ikke fullføres';
$string['view_error_bigbluebutton'] = 'BigBlueButton svarte med feil. {$a}';
$string['view_error_create'] = 'BigBlueButton-serveren svarte med en feilmelding. Møtet kunne ikke opprettes.';
$string['view_error_current_state_not_found'] = 'Nåværende status ikke funnet. Opptaket kan være slettet eller så er ikke BigBlueButton-serveren kompatibel med den utførte handlingen.';
$string['view_error_import_no_courses'] = 'Ingen kurs med opptak';
$string['view_error_import_no_recordings'] = 'Ingen opptak i dette kurset kan importeres';
$string['view_error_invalid_session'] = 'Sesjonen er utløpt. Vennligst gå tilbake til aktivitetens hovedside.';
$string['view_error_max_concurrent'] = 'Maks antall samtidige møter er nådd.';
$string['view_error_meeting_not_running'] = 'Noe gikk galt, møtet kjører ikke.';
$string['view_error_no_group'] = 'Ingen grupper er opprettet. Vennligst opprett gruppene før du fosøker å bli med i møtet.';
$string['view_error_no_group_student'] = 'Du er ikke meldt inn i noen gruppe. Vennligst kontakt læreren din.';
$string['view_error_no_group_teacher'] = 'Ingen grupper er satt opp. Vennligst opprett grupper eller kontakt systemadministratoren.';
$string['view_error_unable_join'] = 'Kan ikke bli med i møtet. Vennligst sjekk URL\'en til BigBlueButton-servern og sjekk om BigBlueButton-serveren kjører.';
$string['view_error_unable_join_student'] = 'Kan ikke koble til BigBlueButton-serveren. Vennligst kontakt læreren eller systemadministraoren din.';
$string['view_error_unable_join_teacher'] = 'Kan ikke koble til BigBlueButton-serveren. Vennligst kontakt administraoren.';
$string['view_error_url_missing_parameters'] = 'URLen mangler parametre';
$string['view_error_userlimit_reached'] = 'Maks antall brukere i møtet har blitt nådd.';
$string['view_groups_nogroups_warning'] = 'Dette er rommet er satt opp til å bruke grupper, men kurset har ingen grupper.';
$string['view_groups_notenrolled_warning'] = 'Dette er rommet er satt opp til å bruke grupper, men du er ikke meldt inn i noen grupper.';
$string['view_groups_selection'] = 'Velg gruppen du ønsker å bli med i og bekreft.';
$string['view_groups_selection_join'] = 'Bli med';
$string['view_groups_selection_warning'] = 'Det er et konferanserom for hver gruppe og du har tilgang til mmer enn ett. Vennligst velg det';
$string['view_login_moderator'] = 'Logger på som moderator...';
$string['view_login_viewer'] = 'Logger på som tilskuer...';
$string['view_message_and'] = 'og';
$string['view_message_conference_has_ended'] = 'Denne konferansen er avsluttet.';
$string['view_message_conference_in_progress'] = 'Denne konferansen pågår.';
$string['view_message_conference_not_started'] = 'Denne konferansen har ikke startet ennå.';
$string['view_message_conference_room_ready'] = 'Dette konferanserommet er klart. Du kan bli med i sesjonen nå.';
$string['view_message_conference_user_limit_reached'] = 'Maks antallet brukere i en økt har blitt nådd.';
$string['view_message_conference_wait_for_moderator'] = 'Venter på at en moderator skal bli med.';
$string['view_message_finished'] = 'Denne aktiiteten er avsluttet.';
$string['view_message_has_joined'] = 'har blitt med';
$string['view_message_have_joined'] = 'har blitt med';
$string['view_message_hour'] = 'time';
$string['view_message_hours'] = 'timer';
$string['view_message_importrecordings_disabled'] = 'Funksjonen for import av opptakslenker er deaktivert på denne serveren.';
$string['view_message_minute'] = 'minutt';
$string['view_message_minutes'] = 'minutter';
$string['view_message_moderator'] = 'moderator';
$string['view_message_moderators'] = 'moderatorer';
$string['view_message_norecordings'] = 'Det er ingen opptak å vise.';
$string['view_message_notavailableyet'] = 'Denne sesjonen er ikke tilgjengelig ennå.';
$string['view_message_recordings_disabled'] = 'Opptak er deaktivert på denne serveren. BigBlueButton instanser kun for opptak kan ikke brukes.';
$string['view_message_room_closed'] = 'Dette rommet er stengt.';
$string['view_message_room_open'] = 'Dette rommet er åpent.';
$string['view_message_room_ready'] = 'Dette rommet er klart.';
$string['view_message_session_for'] = 'sesjonen for';
$string['view_message_session_has_user'] = 'Det er';
$string['view_message_session_has_users'] = 'Det er';
$string['view_message_session_no_users'] = 'Det er ingen brukere i denne sesjonen';
$string['view_message_session_running_for'] = 'Denne sesjonen har pågått i';
$string['view_message_session_started_at'] = 'Denne sesjonen startet';
$string['view_message_tab_close'] = 'Denne fanen/vinduet må lukkes manuelt';
$string['view_message_times'] = 'ganger';
$string['view_message_user'] = 'bruker';
$string['view_message_users'] = 'brukere';
$string['view_message_viewer'] = 'seer';
$string['view_message_viewers'] = 'seere';
$string['view_mobile_message_groups_not_supported'] = 'Mobilappen støtter ikke gruppefunksjonen for dene aktiviteten. Vennligst bruk en nettleser for å bruke gruppefunksjonen i denne aktiviteten.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Du har vært på denne siden i mer enn 45 sekunder. Vennligst last inn siden på nytt før du blir med i møtet.';
$string['view_noguests'] = 'BigBlueButton er ikke tilgjengelig for gjester';
$string['view_nojoin'] = 'Du har ikke en rolle som kreves for å bli med i denne sesjonen.';
$string['view_recording'] = 'tar opp';
$string['view_recording_actionbar'] = 'Verktøylinje';
$string['view_recording_activity'] = 'Aktivitet';
$string['view_recording_button_import'] = 'Importer opptakslenker';
$string['view_recording_button_return'] = 'Gå tilbake';
$string['view_recording_course'] = 'Kurs';
$string['view_recording_date'] = 'Dato';
$string['view_recording_delete_confirmation'] = 'Er du sikker på at du ønsker å slette dette {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Dette opptaket har {$a} assosierte lenker som ble importert i et annet kurs eller aktivitet. Dersom opptaket er slettet vil lenken også fjernes.';
$string['view_recording_delete_confirmation_warning_s'] = 'Dette opptaket har {$a} assosiert lenke som ble importert i et annet kurs eller aktivitet. Dersom opptaket er slettet vil lenken også fjernes.';
$string['view_recording_description'] = 'Beskrivelse';
$string['view_recording_description_edithint'] = 'Rediger beskrivelsen. Det vil hjelpe for å finne opptaket senere';
$string['view_recording_description_editlabel'] = 'Rediger beskrivelse';
$string['view_recording_duration'] = 'Varighet';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'URLen til dette opptaksformater kan ikke nås.';
$string['view_recording_format_notes'] = 'Notater';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentasjon';
$string['view_recording_format_screenshare'] = 'Skjermdeling';
$string['view_recording_format_statistics'] = 'Statistikk';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Er du sikker på at du ønsker å importere dette opptaket?';
$string['view_recording_length'] = 'Lengde';
$string['view_recording_link'] = 'importet lenke';
$string['view_recording_link_warning'] = 'Dette er en lenke som peker til et opptak som ble gjort i et annet kurs eller aktivitet';
$string['view_recording_list_action_delete'] = 'Sletter';
$string['view_recording_list_action_edit'] = 'Oppdaterer';
$string['view_recording_list_action_play'] = 'Spill';
$string['view_recording_list_action_process'] = 'Behandler';
$string['view_recording_list_action_protect'] = 'Beskytter';
$string['view_recording_list_action_publish'] = 'Publisering';
$string['view_recording_list_action_unprotect'] = 'Ubeskyttet';
$string['view_recording_list_action_unpublish'] = 'Avpubliserer';
$string['view_recording_list_action_update'] = 'Oppdatering';
$string['view_recording_list_actionbar'] = 'Verktøylinje';
$string['view_recording_list_actionbar_delete'] = 'Slett';
$string['view_recording_list_actionbar_edit'] = 'Rediger';
$string['view_recording_list_actionbar_hide'] = 'Skjul';
$string['view_recording_list_actionbar_import'] = 'Importer';
$string['view_recording_list_actionbar_protect'] = 'Gjør privat';
$string['view_recording_list_actionbar_publish'] = 'Publiser';
$string['view_recording_list_actionbar_show'] = 'Vis';
$string['view_recording_list_actionbar_unprotect'] = 'Gjør offentlig';
$string['view_recording_list_actionbar_unpublish'] = 'Avpubliser';
$string['view_recording_list_activity'] = 'Aktivitet';
$string['view_recording_list_course'] = 'Kurs';
$string['view_recording_list_date'] = 'Dato';
$string['view_recording_list_description'] = 'Beskrivelse';
$string['view_recording_list_duration'] = 'Varighet';
$string['view_recording_list_recording'] = 'Tar opp';
$string['view_recording_meeting'] = 'Møte';
$string['view_recording_modal_button'] = 'Anvend';
$string['view_recording_modal_title'] = 'Sett opptaksverdier';
$string['view_recording_name'] = 'Navn';
$string['view_recording_name_edithint'] = 'Rediger navnet. Det vil hjelpe å finne opptaket senere';
$string['view_recording_name_editlabel'] = 'Rediger navn';
$string['view_recording_playback'] = 'Spill på nytt';
$string['view_recording_preview'] = 'Forhåndsvisning';
$string['view_recording_preview_help'] = 'Dra musepekeren over et bilde for å vise i full størrelse';
$string['view_recording_protect_confirmation'] = 'Er du sikker på å beskytte denne {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Dette opptaket har {$a} lenker tilknyttet som ble importert i forskjellige kurs eller aktiviteter. Hvis opptaket er beskyttet, vil det også påvirke de importerte koblingene';
$string['view_recording_protect_confirmation_warning_s'] = 'Dette opptaket har tilknyttet {$a} kobling som ble importert i et annet kurs eller aktivitet. Hvis opptaket er beskyttet, vil det også påvirke de importerte koblingene.';
$string['view_recording_publish_confirmation'] = 'Er du sikker på at du vil publisere denne {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Dette opptaket har {$a} lenker tilknyttet som ble importert i forskjellige kurs eller aktiviteter. Hvis opptaket publiseres, vil disse lenkene også bli publisert';
$string['view_recording_publish_confirmation_warning_s'] = 'Dette opptaket har tilknyttet {$a} kobling som ble importert i et annet kurs eller aktivitet. Hvis opptaket publiseres, vil denne lenken også bli publisert';
$string['view_recording_publish_link_deleted'] = 'Denne lenken kan ikke republiseres siden det aktuelle opptaket ikke eksisterer på BigBlueButton-serveren. Lenken bør fjernes';
$string['view_recording_publish_link_not_published'] = 'Denne lenken kan ikke republiseres siden det aktuelle opptaket er upublisert.';
$string['view_recording_recording'] = 'Opptak';
$string['view_recording_select_course'] = 'Velg et kurs først i rullegardinmenyen';
$string['view_recording_tags'] = 'Tagger';
$string['view_recording_unprotect_confirmation'] = 'Er du sikker på at du vil oppheve beskyttelsen av denne {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Dette opptaket har {$a} lenker tilknyttet som ble importert i forskjellige kurs eller aktiviteter. Hvis opptaket er ubeskyttet, vil det også påvirke de importerte koblingene';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Dette opptaket har {$a} lenker tilknyttet som ble importert i forskjellige kurs eller aktiviteter. Hvis opptaket er ubeskyttet, vil det også påvirke de importerte koblingene';
$string['view_recording_unprotect_link_deleted'] = 'Denne lenken kan ikke være ubeskyttet siden opptaket  ikke eksisterer på BigBlueButton-serveren. Lenken bør fjernes';
$string['view_recording_unprotect_link_not_unprotected'] = 'Denne lenken kan ikke være ubeskyttet siden opptaket er beskyttet';
$string['view_recording_unpublish_confirmation'] = 'Er du sikker på at du ønsker å avpublisere dette {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Dette opptaket har {$a} assosierte lenker som ble importert i ulike kurs eller aktiviteter. Om opptaket avpubliseres vil også disse lenkene avpubliseres.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Dette opptaket har {$a} assosiert lenke som ble importert et kurs eller aktiviteter. Om opptaket avpubliseres vil også denne lenken avpubliseres.';
$string['view_recording_yui_first'] = 'Første';
$string['view_recording_yui_go'] = 'Start';
$string['view_recording_yui_last'] = 'Siste';
$string['view_recording_yui_next'] = 'Neste';
$string['view_recording_yui_page'] = 'Side';
$string['view_recording_yui_prev'] = 'Forrige';
$string['view_recording_yui_rows'] = 'Rekker';
$string['view_recording_yui_show_all'] = 'Vis alle';
$string['view_room'] = 'Vis romm';
$string['view_section_title_presentation'] = 'Presentasjonsfil';
$string['view_section_title_recordings'] = 'Opptak';
$string['view_warning_default_server'] = 'Denne Moodle-installasjonen bruker BigBlueButtons testserver som er forhåndsinntilt som standard. Den bør erstattes for produksjon.';
$string['waitformoderator'] = 'Venter på at en moderator skal bli med.';
