<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_o365', language 'sv', version '3.11'.
 *
 * @package     local_o365
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acp_coursesynccustom'] = 'Anpassning av kurssynkronisering';
$string['acp_coursesynccustom_bulk'] = 'Massåtgärder';
$string['acp_coursesynccustom_bulk_disable'] = 'Inaktivera kurssynkronisering för kurser på denna sida';
$string['acp_coursesynccustom_bulk_enable'] = 'Aktivera kurssynkronisering för kurser på denna sida';
$string['acp_coursesynccustom_confirm_all_action'] = 'Är du säker på att du vill ändra synkroniseringsinställningarna för alla kurserna? Åtgärden kan inte ångras.';
$string['acp_coursesynccustom_controlled_per_course'] = 'Tillåt konfigurering av synkroniseringsinställningar för kurs';
$string['acp_coursesynccustom_controlled_per_course_desc'] = 'Om det här alternativet är aktiverat kan användare som är registrerade i Moodle-kurser och som är berättigade att agera som teamägare (med funktionsbehörighet "Teamägare" [<code>local/o365:teamowner</code>]) styra kurssynkronisering från Microsoft-blocket i kursen.';
$string['acp_coursesynccustom_disable_all'] = 'Inaktivera kurssynkronisering för alla kurser';
$string['acp_coursesynccustom_enable_all'] = 'Aktivera kurssynkronisering för alla kurser';
$string['acp_coursesynccustom_enabled'] = 'Aktiverad';
$string['acp_coursesynccustom_new_course'] = 'Aktivera som standard för nya kurser';
$string['acp_coursesynccustom_new_course_desc'] = 'Om aktiverat är kurssynkronisering aktiverad som standard för alla nya kurser.';
$string['acp_coursesynccustom_off'] = 'Inaktiverad<br />Inaktivera skapande av Team för alla kurser.';
$string['acp_coursesynccustom_onall'] = 'Alla egenskaper aktiverade<br />Aktiverar skapande av Team för alla kurser.';
$string['acp_coursesynccustom_oncustom'] = 'Anpassa<br />Låter behöriga användare välja vilka kurser det ska skapas Teams för. <br> <span id="adminsetting_coursesync" style="font-weight: bold"><a href="{$a}">Anpassa kurssynkronisering</a></span>';
$string['acp_coursesynccustom_savemessage'] = 'Dina ändringar har sparats.';
$string['acp_coursesynccustom_sds_course'] = 'Låst för SDS-kurs';
$string['acp_coursesynccustom_searchwarning'] = 'OBS! Sökningar medför att osparade ändringar går förlorade. Tryck på spara för att försäkra dig om att dina ändringar sparats.';
$string['acp_coursesynccustom_settings_header'] = 'Synkroniseringsalternativ';
$string['acp_healthcheck'] = 'Hälsokontroll';
$string['acp_maintenance'] = 'Underhållsverktyg';
$string['acp_maintenance_cleandeltatoken'] = 'Städa upp delta synkroniseringstoken för användare';
$string['acp_maintenance_cleandeltatoken_completed'] = 'Rensade användares synkroninserings- och överhoppningsdeltatoken.';
$string['acp_maintenance_cleandeltatoken_desc'] = 'Om användarsynkroniseringen inte fungerar fullt ut efter uppdateringen av synkroniseringsinställningarna för användare kan detta bero på ett gammalt delta synkroniseringstoken. Städa upp token kommer påtvinga en fullständig återsynkronisering nästa gång användarsynkroniseringen körs.';
$string['acp_maintenance_debugdata'] = 'Skapa paket med debugdata';
$string['acp_maintenance_debugdata_desc'] = 'Detta kommer att generera ett paket som innehåller olika bitar av information om din Moodle och Microsoft 365 miljö för att hjälpa utvecklare att lösa eventuella problem du kan ha. Om en utvecklare begär det ska du köra det här verktyget och skicka denfil som laddas ned. OBS! Även om detta paket inte innehåller känsliga tokendata, ber vi att du inte publicerar den här filen offentligt eller skickar den till en icke betrodd part.';
$string['acp_maintenance_desc'] = 'De här verktygen kan hjälpa dig lösa några vanligt förekommande problem.';
$string['acp_maintenance_recreatedeletedgroups'] = 'Återskapa borttagna Microsoft 365-grupper';
$string['acp_maintenance_recreatedeletedgroups_all_groups_exist'] = 'Alla grupper anslutna till Moodlekurser och -grupper existerar.';
$string['acp_maintenance_recreatedeletedgroups_course'] = 'Kurs';
$string['acp_maintenance_recreatedeletedgroups_course_group'] = 'Kursgrupp';
$string['acp_maintenance_recreatedeletedgroups_desc'] = 'Detta söker efter eventuella Microsoft Team-team som tagits bort manuellt och återskapar dem.';
$string['acp_maintenance_recreatedeletedgroups_group_type'] = 'Moodle-objekttyp';
$string['acp_maintenance_recreatedeletedgroups_group_type_course'] = 'Kurs';
$string['acp_maintenance_recreatedeletedgroups_group_type_course_group'] = 'Kursgrupp';
$string['acp_maintenance_recreatedeletedgroups_status'] = 'Status';
$string['acp_maintenance_recreatedeletedgroups_status_created_fail'] = 'Återskapande av grupp misslyckades';
$string['acp_maintenance_recreatedeletedgroups_status_created_success'] = 'Gruppen skapades';
$string['acp_maintenance_recreatedeletedgroups_status_sync_disabled'] = 'Kurssynkroninsering är inaktiverad';
$string['acp_maintenance_resyncgroupusers'] = 'Synkronisera om användare i Microsoft 365-grupper med kurser';
$string['acp_maintenance_resyncgroupusers_course_output'] = 'Resultat från omsynkronisering';
$string['acp_maintenance_resyncgroupusers_desc'] = 'Detta synkroniserar om användarmedlemskapet för alla Microsoft 365-grupper som skapats för alla Moodle-kurser. Detta säkerställer att alla, och endast, användare som är inskrivna i Moodle-kursen finns i Microsoft 365-gruppen. <br /><strong>OBS!</strong> Om du har lagt till ytterligare användare i en Microsoft 365-grupp som inte är registterade i den associerade Moodle-kursen tas de bort.';
$string['acp_maintenance_resyncgroupusers_no_course'] = 'Ingen kurs ansluten till Microsoft 365';
$string['acp_maintenance_warning'] = 'Varning! Detta är avancerade verktyg. Vänligen använd dem enbart om du är säker på vad du gör.';
$string['acp_parentsite_desc'] = 'Webbplats för delad kursdata i Moodle.';
$string['acp_parentsite_name'] = 'Moodle';
$string['acp_teamconnection'] = 'Hantera Team-anslutning';
$string['acp_teamconnections'] = 'Hantera Team-anslutningar';
$string['acp_teamconnections_actions'] = 'Åtgärder';
$string['acp_teamconnections_cache_last_updated'] = 'Teamscachen uppdaterades senast {$a->lastupdated}. <a href="{$a->updateurl}">Klicka här</a> för att uppdatera cachen.';
$string['acp_teamconnections_cache_never_updated'] = 'Teamscachen uppdaterades aldrig. <a href="{$a->updateurl}">Klicka här</a> för att uppdatera cachen.';
$string['acp_teamconnections_connected_team'] = 'Anslutet Team';
$string['acp_teamconnections_connection_completed'] = 'Kursen har anslutits till Teamet.';
$string['acp_teamconnections_course_connected'] = 'Kursen har anslutits till Teamet.';
$string['acp_teamconnections_current_connection'] = 'NUVARANDE ANSLUTNING';
$string['acp_teamconnections_exception_course_not_exist'] = 'Kursen som ska anslutas finns inte.';
$string['acp_teamconnections_exception_invalid_team_id'] = 'Ogiltigt Team-ID';
$string['acp_teamconnections_exception_no_unified_token'] = 'Det gick inte att hämta enhetlig token för att utföra API-anrop.';
$string['acp_teamconnections_exception_not_configured'] = 'Microsoft 365 är inte färdigkonfigurerat.';
$string['acp_teamconnections_exception_team_already_connected'] = 'Teamet är redan anslutet till en annan kurs';
$string['acp_teamconnections_exception_team_creation'] = 'Ett fel uppstod när Teamet skulle skapas. Information: {$a}';
$string['acp_teamconnections_exception_team_no_owner'] = 'Kan inte hitta en lämplig Team-ägare.';
$string['acp_teamconnections_form_connect_course'] = 'Hantera Team-anslutningar för kursen {$a}';
$string['acp_teamconnections_form_sds_warning'] = '<strong>OBS!</strong> Att manuellt ansluta en Moodle-kurs med ett Team skapat via Student Data Sync (SDS) kan resultera i oväntade beteenden i både Moodle- och SDS-synkroniseringen. Detta är därför inte tillåtet.';
$string['acp_teamconnections_form_team'] = 'Välj Team';
$string['acp_teamconnections_group_only'] = '(Endast grupp)';
$string['acp_teamconnections_invalid_connection'] = 'Ogiltig anslutning';
$string['acp_teamconnections_no_owner'] = 'Lägg till ägare att ansluta till Teams.';
$string['acp_teamconnections_not_connected'] = 'Ej ansluten';
$string['acp_teamconnections_sync_disabled'] = 'Kurssynkroniseringe måste aktiveras innan det går att hantera Teams-anslutningar.';
$string['acp_teamconnections_table_cannot_create_team_from_group'] = 'Kan inte skapa Team från grupp - ägare saknas';
$string['acp_teamconnections_table_connect'] = 'Anslut';
$string['acp_teamconnections_table_connect_to_different_team'] = 'Anslut till ett annat Team';
$string['acp_teamconnections_table_missing_team'] = 'Kursen är ansluten till ett team som inte finns. Försök uppdatera Teams-cachen.';
$string['acp_teamconnections_table_update'] = 'Uppdatera';
$string['acp_teamconnections_team_already_connected'] = 'Kursen är redan ansluten till ett Team.';
$string['acp_teamconnections_team_created'] = 'Teamet skapades för kursen.';
$string['acp_teamconnections_team_exists_but_not_connected'] = 'Kursen är konfigurerad för att endast vara ansluten till en grupp, men det finns redan ett Team som är anslutet till gruppen.';
$string['acp_teamconnections_team_missing'] = '(Team saknas)';
$string['acp_teamconnections_teams_cache_updated'] = 'Team-cachen uppdaterades.';
$string['acp_tenants_actions'] = 'Åtgärder';
$string['acp_tenants_add'] = 'Lägg till ny Tenant';
$string['acp_tenants_additional_tenants'] = 'Ytterligare Tenants';
$string['acp_tenants_delete'] = 'Ta bort';
$string['acp_tenants_errornotsetup'] = 'Vänligen slutför installationsprocessen för pluginmodulen innan du lägger till ytterligare tenants.';
$string['acp_tenants_hosttenant'] = 'Värd-tenant: {$a}';
$string['acp_tenants_intro'] = '<b>Så här fungerar multipla Tenants:</b><br />Multipla Tenants tillåter flera Microsoft 365 Tenants att komma åt din Moodle-webbplats. <br /><br />
    Så här gör du för att få ställa in det:
    <ol>
        <li>Logga in på Moodle som en administratörsanvändare som <strong>inte</strong> använder <em>OpenID Connect Pluginmodulen</em>.</li>
        <li>Inaktivera OpenID Connect autentiserings-modulen i Moodle. (Gå till <a href="{$a}/admin/settings.php?section=manageauths">Hantera autentisering</a>.) </li>
        <li>Navigera till Azure AD, och leta upp programmet du konfigurerat för Moodle.</li>
        <li>Aktivera multipla Tenants i Azure AD-programmet och spara ändringarna.</li>
        <li>För varje klient du vill aktivera klickar du på "Lägg till ny Tenant" och loggar in med ett administratörskonto från den Tenant du vill aktivera.</li>
        <li>När du har lagt till alla de tenants du vill, aktiverar du OpenID Connect autentisering-pluginmodulen i Moodle igen.</li>
<li>Nu är du klar! Om du vill lägga till ytterligare tenants klickar du bara på "Lägg till ny Tenant" och logga in med ett administratörskonto från den tenant du vill lägga till.</li>
</ol> <b>OBS!</b> Om du aktiverat multipla Tenants i Azure AD får alla Microsoft 365 Tenants åtkomst till din applikation. Genom att lägga till tenants här kan vi begränsa Moodle-åtkomst till de tenants du konfigurerar. <b>Om du tar bort alla tenants från den här listan innan du inaktiverar multipla tenants i Azure AD, eller aktiverar OpenID Connect-autentisering i Moodle med en tom lista, kommer din Moodle-webbplats att vara öppen för alla Microsoft 365 Tenants.</b>';
$string['acp_tenants_legacy_tenants'] = 'Äldre tenanttyp (Åtgärd krävs)';
$string['acp_tenants_legacy_tenants_help'] = 'Ytterligare klienter nedan som lagts till tidigare kanske inte fungerar i det uppdaterade arbetsflödet för multipla Tenants och måste åtgärdas.<br/>
Använd knappen "Lägg till ny Tenant" ovan för att lägga till igen.';
$string['acp_tenants_none'] = 'Du har inte konfigurerat några Tenants. Om du aktiverat stöd för flera Tenants i Azure AD kan Moodle-webbplatsen vara öppen för alla Microsoft 365-användare.';
$string['acp_tenants_revokeaccess'] = 'Återkalla åtkomst';
$string['acp_tenants_tenant'] = 'Tenant';
$string['acp_tenants_title'] = 'Flera Tenants';
$string['acp_tenants_title_desc'] = 'Denna sida hjälper dig konfigurera åtkomst för flera Microsoft 365 Tenants till Moodle.';
$string['acp_tenantsadd_desc'] = 'Om du vill bevilja åtkomst till ytterligare en tenant klickar du på knappen nedan och loggar in på Microsoft 365 med hjälp av ett administratörskonto för den nya tenanten. Du kommer att returneras till listan över ytterligare tenants där den nya tenanten kommer att listas. Du kommer då att kunna använda Moodle med den nya tenanten.';
$string['acp_tenantsadd_linktext'] = 'Fortsätt till inloggningssidan för Microsoft 365';
$string['acp_userconnections'] = 'Hantera användaranslutningar';
$string['acp_userconnections_column_actions'] = 'Åtgärder';
$string['acp_userconnections_column_muser'] = 'Moodleanvändare';
$string['acp_userconnections_column_o365user'] = 'Microsoft 365-användare';
$string['acp_userconnections_column_status'] = 'Anslutningsstatus';
$string['acp_userconnections_column_usinglogin'] = 'Användarinloggning';
$string['acp_userconnections_filtering_muserfullname'] = 'Fullständigt namn på användare i Moodle';
$string['acp_userconnections_filtering_musername'] = 'Användarnamn i Moodle';
$string['acp_userconnections_filtering_o365username'] = 'Användarnamn i Microsoft 365';
$string['acp_userconnections_manualmatch_details'] = 'Denna sida låter dig matcha en användare i Moodle med en användare i Microsoft 365.';
$string['acp_userconnections_manualmatch_error_muserconnected'] = 'Moodleanvändaren är redan ansluten till en Microsoft 365-användare';
$string['acp_userconnections_manualmatch_error_muserconnected2'] = 'Moodleanvändaren är redan ansluten till en Microsoft 365-användare (2)';
$string['acp_userconnections_manualmatch_error_musermatched'] = 'Denna Moodle-användare matchar redan en Microsoft 365-användare.';
$string['acp_userconnections_manualmatch_error_o365userconnected'] = 'Denna Microsoft 365-användare är redan ansluten till annan Moodle-användare.';
$string['acp_userconnections_manualmatch_error_o365usermatched'] = 'Denna Microsoft 365-användare matchar redan en annan Moodle-användare.';
$string['acp_userconnections_manualmatch_musername'] = 'Moodleanvändare';
$string['acp_userconnections_manualmatch_o365username'] = 'Användarnamn i Microsoft 365';
$string['acp_userconnections_manualmatch_title'] = 'Manuell användarmatchning';
$string['acp_userconnections_manualmatch_uselogin'] = 'Logga in med Microsoft 365';
$string['acp_userconnections_resync_nodata'] = 'Kunde inte hitta sparad Microsoft 365-information för denna användare.';
$string['acp_userconnections_resync_notconnected'] = 'Denna användare är inte ansluten till Microsoft 365';
$string['acp_userconnections_table_connected'] = 'Ansluten';
$string['acp_userconnections_table_disconnect'] = 'Koppla från';
$string['acp_userconnections_table_disconnect_confirmmsg'] = 'Detta kopplar från användare "{$a}" från Microsoft 365. Klicka på länken nedan för att fortsätta.';
$string['acp_userconnections_table_match'] = 'Matcha';
$string['acp_userconnections_table_matched'] = 'Matchad med befintlig användare.<br/>Avvaktar slutförande.';
$string['acp_userconnections_table_noconnection'] = 'Ingen anslutning';
$string['acp_userconnections_table_resync'] = 'Synka om';
$string['acp_userconnections_table_synced'] = 'Synkroniserade från Azure AD.<br />Avvaktar initial inloggning.';
$string['acp_userconnections_table_unmatch'] = 'Ta bort matchning';
$string['acp_userconnections_table_unmatch_confirmmsg'] = 'Detta tar bort matchningen av Moodleanvändare "{$a}" från Microsoft 365. Klicka på nedanstående länk för att fortsätta.';
$string['acp_usermatch'] = 'Användarmatchning';
$string['acp_usermatch_desc'] = 'Detta verktyg låter dig matcha Moodleanvändare med användare i Microsoft 365. Du laddar upp en fil med Moodleanvändare och motsvarande Microsoft 365-användare. Ett cron-jobb verifierar informationen och konfigurerar matchningen.';
$string['acp_usermatch_matchqueue'] = 'Steg 2: Matchningskö';
$string['acp_usermatch_matchqueue_clearall'] = 'Rensa allt';
$string['acp_usermatch_matchqueue_clearerrors'] = 'Rensa fel';
$string['acp_usermatch_matchqueue_clearqueued'] = 'Rensa köade';
$string['acp_usermatch_matchqueue_clearsuccess'] = 'Rensa lyckade';
$string['acp_usermatch_matchqueue_column_muser'] = 'Användarnamn i Moodle';
$string['acp_usermatch_matchqueue_column_o365user'] = 'Användarnamn i Microsoft 365';
$string['acp_usermatch_matchqueue_column_openidconnect'] = 'OpenID Connect';
$string['acp_usermatch_matchqueue_column_status'] = 'Status';
$string['acp_usermatch_matchqueue_desc'] = 'Denna tabell visar nuvarande status för matchningsoperationen. Varje gång matchningsjobbet körs av cron kommer en uppsättning av följande användare bearbetas.<br /><b>OBS!</b> Den här sidan uppdateras inte automatiskt. Uppdatera sidan manuellt för att se aktuell status.';
$string['acp_usermatch_matchqueue_empty'] = 'Matchningskön är för närvarande tom. Ladda upp en datafil med hjälp av filväljaren för att lägga till användare i kön.';
$string['acp_usermatch_matchqueue_status_error'] = 'Fel: {$a}';
$string['acp_usermatch_matchqueue_status_queued'] = 'Köad';
$string['acp_usermatch_matchqueue_status_success'] = 'Lyckades';
$string['acp_usermatch_upload'] = 'Steg 1: Ladda upp nya matchningar';
$string['acp_usermatch_upload_desc'] = 'Ladda upp en datafil som innehåller Moodle- och Microsoft 365-användarnamn för att matcha Moodle-användare till Microsoft 365-användare.<br />
<br />
Den här filen ska vara en CSV-fil i klartext som innehåller tre objekt per rad:
<ul>
<li>Moodle-användarnamnet,</li>
<li>Användarnamneti  Microsoft 365,</li>
<li>1 eller 0, där 1 innebär att användarens autentiseringsmetod ändras till OpenID Connect, och 0 innebär att den befintliga autentiseringsmetoden behålls och att den används som ett länkat konto.</li>
</ul>
Inkludera inte några rubriker eller ytterligare data.<br />
Till exempel: <pre>moodleuser1,bob.smith@example.onmicrosoft.com,1<br />moodleuser2,john.doe@example.onmicrosoft.com,0</pre>';
$string['acp_usermatch_upload_err_badmime'] = 'Typen {$a} stöds inte. Vänligen ladda upp en CSV-formaterad textfil.';
$string['acp_usermatch_upload_err_data'] = 'Rad #{$a} innehöll ogiltig data. Varje rad i CSV-filen ska innehålla två datafält: Moodle-användarnamnet och Microsoft 365-användarnamnet.';
$string['acp_usermatch_upload_err_fileopen'] = 'Kunde inte öppna fil för bearbetning. Har du rätt behörigheter i Moodledata-katalogen?';
$string['acp_usermatch_upload_err_nofile'] = 'Ingen fil att lägga till i kön.';
$string['acp_usermatch_upload_submit'] = 'Lägg till datafil till matchningskön';
$string['assignment'] = 'Tilldelning';
$string['cachedef_groups'] = 'Lagrar Microsoft 365-gruppdata';
$string['calendar_event'] = 'Visa detaljer';
$string['calendar_setting'] = 'Aktivera synkronisering av Outlook-kalender';
$string['calendar_site'] = 'Webbplatsövergripande kalender';
$string['calendar_user'] = 'Personlig (användare) kalender';
$string['course_assignment_submitted_due'] = 'Kurs - {$a->course} &nbsp; |  &nbsp; Uppgift -{$a->assignment} <br />
                        Inlämnad - {$a->submittedon} &nbsp; |  &nbsp; Förfallodatum - {$a->duedate}';
$string['course_selector_label'] = 'Välj befintlig kurs';
$string['due_date'] = 'Förfallodatum - {$a}';
$string['error_missing_app_id'] = 'Applikations-ID saknas.';
$string['error_missing_bot_settings'] = 'Bot-funktionen är aktiverad, men Bot-inställningar saknas.';
$string['erroracpapcantgettenant'] = 'Kunde inte hämta Azure AD tenant. Vänligen ange värdet manuellt.';
$string['erroracpauthoidcnotconfig'] = 'Vänligen ange applikationens inloggningsuppgifter i <code>auth_oidc</code> först.';
$string['erroracpcantgettenant'] = 'Kunde inte hämta OneDrive URL. Vänligen ange värdet manuellt.';
$string['erroracplocalo365notconfig'] = 'Vänligen konfigurera local_o365 först.';
$string['errorchecksystemapiuser'] = 'Det gick inte att hämta ett system API-användartoken. Kör hälsokontrollen, se till att Moodle cron körs och uppdatera system API-användaren om det behövs.';
$string['errorcouldnotrefreshtoken'] = 'Kunde inte uppdatera token';
$string['errorhttpclientbadtempfileloc'] = 'Kunde inte öppna en temporär plats att lagra filen på.';
$string['errorhttpclientnofileinput'] = 'Ingen filparameter i <code>httpclient::put</code>';
$string['errornodirectaccess'] = 'Direkt sidåtkomst förbjuden';
$string['erroro365apibadcall'] = 'Fel i API-anrop.';
$string['erroro365apibadcall_message'] = 'Fel i API-anrop: {$a}';
$string['erroro365apibadpermission'] = 'Behörighet kunde inte hittas';
$string['erroro365apicouldnotcreatesite'] = 'Ett problem uppstod då webbplatsen skulle skapas.';
$string['erroro365apicoursenotfound'] = 'Kursen hittades inte.';
$string['erroro365apiinvalidmethod'] = 'Ogiltig http-metod angavs i API-anropet';
$string['erroro365apiinvalidtoken'] = 'Ogiltigt eller utgånget token.';
$string['erroro365apinoparentinfo'] = 'Kunde inte hitta information om överliggande katalog';
$string['erroro365apinotimplemented'] = 'Detta ska åsidosättas.';
$string['erroro365apinotoken'] = 'Hade inget token för den angivna resursen och användaren och kunde inte hämta ett. Har användarens uppdateringstoken upphört att gälla?';
$string['erroro365apisiteexistsnolocal'] = 'Webbplatsen finns redan, men det gick inte att hitta den lokala posten.';
$string['errorprovisioningapp'] = 'Kunde inte konfigurera upp Moodle-appen i Teamet.';
$string['errorusermatched'] = 'Microsoft 365-kontot "{$a->aadupn}" är redan matchat med Moodle-användare "{$a->username}". För att slutföra anslutningen, logga in som den Moodle-användaren först och följ sedan instruktionerna i Microsoft-blocket.';
$string['eventapifail'] = 'API-fel';
$string['eventcalendarsubscribed'] = 'Användare prenumererade på en kalender';
$string['eventcalendarunsubscribed'] = 'Användare avprenumererade på en kalender';
$string['grade_date'] = 'Betyg - {$a->grade} &nbsp; | &nbsp; Datum - {$a->date}';
$string['healthcheck_fixlink'] = 'Klicka här för att lösa det.';
$string['healthcheck_ratelimit_result_disabled'] = 'Hastighetsbegränsande funktioner har inaktiverats.';
$string['healthcheck_ratelimit_result_notice'] = 'Lätt begränsning har aktiverats för att hantera ökad belastning på Moodle-webbplatsen. <br / ><br / >Alla Microsoft 365 funktioner är funktionella, detta sprider bara ut förfrågningarna något för att förhindra avbrott i Microsoft 365-tjänsten. När Moodle-aktiviteten minskar kommer allt att återgå till det normala. <br />(Nivå {$a->level} / startades {$a->timestart})';
$string['healthcheck_ratelimit_result_passed'] = 'Microsoft 365 API-anropen fungerar som de ska.';
$string['healthcheck_ratelimit_result_warning'] = 'Hastighetsbegränsning har aktiverats för att hantera den ökade Moodle-webbplatsbelastningen. Alla Microsoft 365-funktioner fungerar fortfarande, men Microsoft 365-begäranden kan ta längre tid att slutföra. När Moodles webbplatsaktivitet har minskat kommer allt att återgå till det normala. (Nivå {$a->level} / började {$a->timestart})';
$string['healthcheck_ratelimit_title'] = 'API-strypning';
$string['healthcheck_systemapiuser_title'] = 'System API-användare';
$string['healthcheck_systemtoken_result_badtoken'] = 'Det uppstod ett problem med att kommunicera med Microsoft 365 som system API-användare. Detta kan vanligtvis lösas genom att återställa system API-användaren.';
$string['healthcheck_systemtoken_result_noclientcreds'] = 'Det finns inga programautentiseringsuppgifter i Pluginmodulen <em>OpenID Connect</em>. Utan dessa autentiseringsuppgifter kan Moodle inte kommunicera med Microsoft 365. Klicka här om du vill gå till inställningssidan och ange dina autentiseringsuppgifter.';
$string['healthcheck_systemtoken_result_notoken'] = 'Moodle har ingen token för att kommunicera med Microsoft 365 som system API-användare. Detta kan vanligtvis lösas genom att återställa system API-användaren.';
$string['healthcheck_systemtoken_result_passed'] = 'Moodle kan kommunicera med Microsoft 365 som system API-användare.';
$string['help_message'] = 'Hej! Jag är din Moodle-assistent. Du kan ställa följande frågor till mig:';
$string['help_user_appassign'] = 'Hjälp om Tilldela användare till applikation';
$string['help_user_appassign_help'] = 'Detta gör att alla Azure AD-konton med matchande Moodle-konton tilldelas det Azure-program som skapats för den här Moodle-installationen, om de inte redan har tilldelats.';
$string['help_user_create'] = 'Hjälp om Skapa konto';
$string['help_user_create_help'] = 'Detta skapar användare i Moodle från varje användare i det länkade Azure AD:t. Endast användare som för närvarande inte har Moodle-konton kommer att få konton skapade. Nya konton kommer att konfigureras för att använda sina Microsoft 365-autentiseringsuppgifter för att logga in på Moodle (med hjälp av OpenID Connect-autentiseringsplugin) och kommer att kunna använda alla Microsoft 365/Moodle-integrationsfunktioner.';
$string['help_user_delete'] = 'Hjälp om Ta bort konton';
$string['help_user_delete_help'] = 'Detta tar bort användare från Moodle om de markerats som borttagna i Azure Active Directory. Detta kommer bara att fungera om alternativet <em>Inaktivera tidigare synkroniserade konton i Moodle när de tas bort från Azure AD</em> är aktiverat. Moodle-kontot tas bort och all associerad användarinformation tas bort från Moodle. <strong>Var försiktig!</strong>';
$string['help_user_disabledsync'] = 'Hjälp för status för inaktiverad synkronisering';
$string['help_user_disabledsync_help'] = 'Detta kommer att inaktivera/aktivera användare i Moodle om deras anslutna konton i Azure AD markeras som förhindrade/tillåtna att logga in.';
$string['help_user_emailsync'] = 'Hjälp för Synkronisera Azure-användarnamn till Moodle e-postmeddelanden';
$string['help_user_emailsync_help'] = 'Om du aktiverar det här alternativet matchas Azure-användarnamn med Moodle e-postmeddelanden, i stället för standardbeteendet som är Azure-användarnamn med Moodle-användarnamn.';
$string['help_user_guestsync'] = 'Hjälp för synkronisering av gästanvändare';
$string['help_user_guestsync_help'] = 'Om det här alternativet är aktiverat synkroniseras gästanvändare i Azure AD till Moodle av den schemalagda bakgrundsaktiviteten.';
$string['help_user_match'] = 'Hjälp med kontomatchning';
$string['help_user_match_help'] = 'Detta kommer att titta på varje användare i den länkade Azure Active Directory och försöka matcha dem med en användare i Moodle. Den här matchningen baseras på användarnamn i Azure AD och Moodle. Matchningar är skiftlägeskänsliga och ignorerar Microsoft 365-klienten. Till exempel skulle "BoB.SmiTh" i Moodle matcha "bob.smith@example.onmicrosoft.com". Användare som matchas kommer att få sina Moodle- och Microsoft 365-konton anslutna och kommer att kunna använda alla Microsoft 365/Moodle-integrationsfunktioner. Användarens autentiseringsmetod ändras inte om inte inställningen nedan är aktiverad.';
$string['help_user_matchswitchauth'] = 'Hjälp med att växla matchade konto';
$string['help_user_matchswitchauth_help'] = 'Detta kräver att inställningen <em>"Matcha befintliga Moodle-användare…"</em> ovan är aktiverad. När en användare matchas byts autentiseringsmetoden till OpenID Connect om den här inställningen är aktiverad. Användaren kommer då att kunna logga in på Moodle med sina Microsoft 365-autentiseringsuppgifter. Se till att autentiseringsmodulen OpenID Connect är aktiverad om du vill använda den här inställningen.';
$string['help_user_nodelta'] = 'Hjälp om Genomför fullständig synkronisering';
$string['help_user_nodelta_help'] = 'Som standard synkroniseras endast ändringar från Azure AD. Om du kontrollerar det här alternativet genomförs en fullständig användarsynkronisering varje gång.';
$string['help_user_photosync'] = 'Hjälp för <em>Synkronisera Microsoft 365-profilbilder (Cron)</em>';
$string['help_user_photosync_help'] = 'Detta gör att alla användares Moodle-profilbilder synkroniseras med deras respektive Microsoft 365-profilbilder.';
$string['help_user_photosynconlogin'] = 'Hjälp för <em>Synkronisera Microsoft 365-profilbilder (vid inloggning)</em>';
$string['help_user_photosynconlogin_help'] = 'Detta gör att en användares Moodle-profilbilder synkroniseras med deras Microsoft 365-profilbilder när användaren loggar in. Observera att detta kräver att användaren besöker en sida som innehåller Microsoft-blocket i Moodle.';
$string['help_user_reenable'] = 'Hjälp för återaktivering av konton';
$string['help_user_reenable_help'] = 'Detta aktiverar inaktiva Moodle-konton igen om de returneras från Azure AD.';
$string['help_user_suspend'] = 'Hjälp med inaktiverade konton';
$string['help_user_suspend_help'] = 'Detta inaktiverar användare i Moodle om de markeras som borttagna i Azure AD.';
$string['help_user_tzsync'] = 'Hjälp för <em>Synkronisera Outlook-tidzon (Cron)</em>';
$string['help_user_tzsync_help'] = 'Detta gör att alla användares Moodle-tidszoner synkroniseras med deras respektive Outlook-tidzonsinställningar.';
$string['help_user_tzsynconlogin'] = 'Hjälp för <em>Synkronisera Outlook-tidzon (vid inloggning)</em>';
$string['help_user_tzsynconlogin_help'] = 'Detta gör att en användares Moodle-tidszon synkroniseras med deras respektive Outlook-tidzonsinställningar. Observera att detta kräver att användaren besöker en sida som innehåller Microsoft-blocket i Moodle.';
$string['help_user_update'] = 'Hjälp för uppdatera alla konton';
$string['help_user_update_help'] = 'Detta uppdaterar alla användare i Moodle från varje användare i det länkade Azure AD:t.';
$string['last_login_date'] = 'Senaste inloggningsdatum - {$a}';
$string['list_of_absent_students'] = 'Lista över studenter som var frånvarande denna månad:';
$string['list_of_assignments_grades_compared'] = 'Det här är listan över dina betyg för inlämningsuppgifterna jämfört med klassgenomsnittet:';
$string['list_of_assignments_needs_grading'] = 'Det här är listan över de uppgifter som behöver betygsättas:';
$string['list_of_due_assignments'] = 'Detta är listan över försenade inlämningsuppgifter';
$string['list_of_incomplete_assignments'] = 'Detta är listan med ofullständiga inlämningsuppgifter:';
$string['list_of_last_logged_students'] = 'Det här är listan över senast loggade deltagare:';
$string['list_of_late_submissions'] = 'Detta är listan över studenter som lämnade in sent:';
$string['list_of_latest_logged_students'] = 'Det här är listan över de senaste loggade deltagarna:';
$string['list_of_recent_grades'] = 'Detta är listan över dina senaste betyg:';
$string['list_of_students_with_least_score'] = 'Det här är listan över elever med lägsta poäng i den senaste inlämningsuppgiften:';
$string['list_of_students_with_name'] = 'Det här är studenterna med namnet {$s}:';
$string['multi_tenants_settings_needs_update'] = 'Inställningarna för multipla Tenants måste uppdateras. Gå till konfigurationssidan för <a href="{$a}">Multipla tenants</a>.';
$string['never'] = 'Aldrig';
$string['no_absent_users_found'] = 'Inga frånvarande studenter hittades';
$string['no_assignments_for_grading_found'] = 'Hittade inga inlämningsuppgifter som ska betygsättas';
$string['no_assignments_found'] = 'Inga uppgifter hittades';
$string['no_due_assignments_found'] = 'Inga försenade uppgifter hittades';
$string['no_due_incomplete_assignments_found'] = 'Inga försenade eller ofullständiga uppgifter hittades';
$string['no_graded_assignments_found'] = 'Inga betygsatta uppgifter hittades';
$string['no_grades_found'] = 'Inga betyg hittades';
$string['no_late_submissions_found'] = 'Inga försenade inlämningar hittades';
$string['no_user_with_name_found'] = 'Hittade ingen användare med det namnet';
$string['no_users_found'] = 'Hittade inga användare';
$string['notification_content_invalid_secret'] = 'Hej Admin,

Azure-apphemligheten som används i din Moodle- och Microsoft 365-integrering verkar vara ogiltig. Detta kan antingen orsakas av att hemligheten har upphört att gälla eller att den har tagits bort.
Granska hemligheten för att säkerställa att integreringen fungerar som förväntat.';
$string['notification_content_secret_almost_expired'] = 'Hej Admin,

Azure-apphemligheten som används i din Moodle- och Microsoft 365-integrering upphör att gälla om {$a}.
Skapa en ny hemlighet i Azureportalen och uppdatera den i integreringskonfigurationen för att undvika avbrott.';
$string['notification_content_secret_expired'] = 'Hej Admin,

Azure-apphemligheten som används i din Moodle- och Microsoft 365-integreringen har upphört att gälla.
Skapa en ny hemlighet i Azureportalen och uppdatera den i integreringskonfigurationen för att återställa funktionaliteten.';
$string['notification_days_days'] = '{$a} dagar';
$string['notification_days_less_than_one_day'] = 'mindre än 1 dag';
$string['notification_days_one_day'] = '1 dag';
$string['notification_subject_invalid_secret'] = 'Åtgärd krävs: ogiltig Azure applikationshemlighet hittades';
$string['notification_subject_secret_almost_expired'] = 'Åtgärd krävs: Applikationshemligheten för Azure förfaller snart';
$string['notification_subject_secret_expired'] = 'Åtgärd krävs: förfallen Azure applikationshemlighet';
$string['o365:accessbotstudentdata'] = 'Få åtkomst till studentbotdata';
$string['o365:accessbotteacherdata'] = 'Få åtkomst till lärarbotdata';
$string['o365:manageconnectionlink'] = 'Hantera anslutning (Länka)';
$string['o365:manageconnectionunlink'] = 'Hantera anslutning (Ta bort länk)';
$string['o365:managegroups'] = 'Visa länkar till Microsoft 365-tjänster och hanteringsalternativ i Microsoft-blocket i kurser där synkronisering är aktiverad';
$string['o365:teammember'] = 'Teammedlem';
$string['o365:teamowner'] = 'Teamägare';
$string['o365:viewgroups'] = 'Visa länkar till Microsoft 365-tjänster i Microsoft-blocket i kurser där synkronisering är aktiverad';
$string['other_login'] = 'Manuell inloggning';
$string['participants_submitted_needs_grading'] = 'Deltagare - {$a->participants}  &nbsp; |  &nbsp; Lämnade in - {$a->submitted}  &nbsp; |  &nbsp;
                        Behöver betygsättas - {$a->needsgrading}';
$string['pending_submissions_due_date'] = 'Väntande inlämningar - {$a->incomplete} / {$a->total} &nbsp; |  &nbsp; Senaste inlämningstid - {$a->duedate}';
$string['personal_calendar'] = 'Personlig';
$string['pluginname'] = 'Microsoft 365-integration';
$string['privacy:metadata:local_o365'] = 'Lokal pluginmodul för Microsoft 365';
$string['privacy:metadata:local_o365_appassign'] = 'Information om rolltilldelningar för Microsoft 365-appar';
$string['privacy:metadata:local_o365_appassign:assigned'] = 'Om användaren har tilldelats till appen';
$string['privacy:metadata:local_o365_appassign:muserid'] = 'Moodle-användarens ID';
$string['privacy:metadata:local_o365_appassign:photoid'] = 'ID:et för användarens foto i Microsoft 365';
$string['privacy:metadata:local_o365_appassign:photoupdated'] = 'När användarens foto senast uppdaterades från Microsoft 365';
$string['privacy:metadata:local_o365_calidmap'] = 'Information om länkar mellan Kalenderhändelser i Microsoft 365- och Moodle-kalenderhändelser.';
$string['privacy:metadata:local_o365_calidmap:eventid'] = 'ID för händelsen i Moodle';
$string['privacy:metadata:local_o365_calidmap:origin'] = 'Var händelsen härstammar från. Antingen Moodle eller Microsoft 365.';
$string['privacy:metadata:local_o365_calidmap:outlookeventid'] = 'ID:t för händelsen i Outlook.';
$string['privacy:metadata:local_o365_calidmap:userid'] = 'ID:t för den användare som äger händelsen.';
$string['privacy:metadata:local_o365_calsettings'] = 'Information om synkroniseringsinställningarna för kalendern';
$string['privacy:metadata:local_o365_calsettings:o365calid'] = 'Kalenderns ID i Microsoft 365';
$string['privacy:metadata:local_o365_calsettings:timecreated'] = 'Den tid då posten skapades.';
$string['privacy:metadata:local_o365_calsettings:user_id'] = 'Moodle-användarens ID';
$string['privacy:metadata:local_o365_calsub'] = 'Information om synkroniseringsprenumerationer mellan Moodle- och Outlook-kalendrar';
$string['privacy:metadata:local_o365_calsub:caltype'] = 'Type av Moodle-kalender (webbplats, kurs, användare)';
$string['privacy:metadata:local_o365_calsub:caltypeid'] = 'Det associerade ID:t för Moodle-kalendern';
$string['privacy:metadata:local_o365_calsub:isprimary'] = 'Om detta är den primära kalendern';
$string['privacy:metadata:local_o365_calsub:o365calid'] = 'ID:t för Microsoft 365-kalendern';
$string['privacy:metadata:local_o365_calsub:syncbehav'] = 'Synkroniseringsbeteendet (dvs. Moodle till Outlook eller Outlook till Moodle)';
$string['privacy:metadata:local_o365_calsub:timecreated'] = 'Den tidpunkt då prenumerationen skapades.';
$string['privacy:metadata:local_o365_calsub:user_id'] = 'Moodle-användarens ID som prenumerationen är till för';
$string['privacy:metadata:local_o365_connections'] = 'Information om anslutningar mellan Moodle- och Microsoft 365-användare som ännu inte har bekräftats';
$string['privacy:metadata:local_o365_connections:aadupn'] = 'UPN för Microsoft 365-användaren.';
$string['privacy:metadata:local_o365_connections:muserid'] = 'ID för Moodle-användaren';
$string['privacy:metadata:local_o365_connections:uselogin'] = 'Om användarens autentiseringsmetod ska bytas när den är klar.';
$string['privacy:metadata:local_o365_matchqueue'] = 'Information om Moodle-användare till Microsoft 365-användarmatchning';
$string['privacy:metadata:local_o365_matchqueue:completed'] = 'Om posten har bearbetats';
$string['privacy:metadata:local_o365_matchqueue:errormessage'] = 'Felmeddelandet (om det finns något)';
$string['privacy:metadata:local_o365_matchqueue:musername'] = 'Användarnamnet för Moodle-användaren.';
$string['privacy:metadata:local_o365_matchqueue:o365username'] = 'Användarnamnet för Microsoft 365-användaren.';
$string['privacy:metadata:local_o365_matchqueue:openidconnect'] = 'Om användaren ska byta till OpenID Connect-autentisering när matchningen görs';
$string['privacy:metadata:local_o365_objects'] = 'Information om förhållandet mellan Moodle- och Microsoft 365-objekt';
$string['privacy:metadata:local_o365_objects:metadata'] = 'Alla associerade metadata';
$string['privacy:metadata:local_o365_objects:moodleid'] = 'Objektets ID i Moodle';
$string['privacy:metadata:local_o365_objects:o365name'] = 'Objektets människoläsbara namn i Microsoft 365';
$string['privacy:metadata:local_o365_objects:objectid'] = 'Microsoft 365 objekt-ID';
$string['privacy:metadata:local_o365_objects:subtype'] = 'Objektundertypen.';
$string['privacy:metadata:local_o365_objects:tenant'] = 'Klienten som objektet tillhör (i miljöer med flera Tenants)';
$string['privacy:metadata:local_o365_objects:timecreated'] = 'Den tid då posten skapades.';
$string['privacy:metadata:local_o365_objects:timemodified'] = 'Den tidpunkt då posten ändrades.';
$string['privacy:metadata:local_o365_objects:type'] = 'Typ av objekt (grupp, användare, kurs osv.)';
$string['privacy:metadata:local_o365_token'] = 'Information om Microsoft 365 API-tokens för användare';
$string['privacy:metadata:local_o365_token:expiry'] = 'Tokens utgångstid.';
$string['privacy:metadata:local_o365_token:refreshtoken'] = 'Uppdateringstoken.';
$string['privacy:metadata:local_o365_token:scope'] = 'Tokenomfånget.';
$string['privacy:metadata:local_o365_token:token'] = 'Token';
$string['privacy:metadata:local_o365_token:tokenresource'] = 'Tokenresursen.';
$string['privacy:metadata:local_o365_token:user_id'] = 'Moodle-användarens ID';
$string['question_student_assignments_compared'] = 'Hur gick det i mina senaste inlämningsuppgifter jämfört med klassen?';
$string['question_student_assignments_due'] = 'Vilka inlämningsuppgifter ska lämnas in härnäst?';
$string['question_student_latest_grades'] = 'Vilka är de senaste betygen jag har fått?';
$string['question_teacher_absent_students'] = 'Vilka elever har varit frånvarande den här månaden?';
$string['question_teacher_assignments_for_grading'] = 'Vilka uppgifter har ännu inte bedömts?';
$string['question_teacher_assignments_incomplete_submissions'] = 'Hur många inlämningsuppgifter har ofullständiga inlämningar?';
$string['question_teacher_last_logged_students'] = 'Vilka studenter har loggat in på Moodle (senast först)?';
$string['question_teacher_late_submissions'] = 'Vilka studenter har lämnat in sent?';
$string['question_teacher_latest_logged_students'] = 'Vilka studenter har loggat in på Moodle (äldsta först)?';
$string['question_teacher_least_scored_in_assignment'] = 'Vilka elever fick minst poäng på den senaste inlämningsuppgiften?';
$string['question_teacher_student_last_logged'] = 'När loggade Förnamn Efternamn senast in i Moodle?';
$string['settings_aadsync'] = 'Synkronisera användare med Azure AD';
$string['settings_aadsync_appassign'] = 'Tilldela användare till applikation vid synkronisering';
$string['settings_aadsync_create'] = 'Skapa konton i Moodle för användare i Azure AD';
$string['settings_aadsync_delete'] = 'Ta bort tidigare synkroniserade konton i Moodle när de tas bort från Azure AD (kräver "Inaktivera tidigare…"-alternativet ovan)';
$string['settings_aadsync_details'] = 'När detta är aktiverat synkroniseras Moodle- och Azure AD-användare enligt ovanstående alternativ.<br /><br /><b>OBS! </b>Synkroniseringsjobbet körs via Moodle cron och synkroniserar 1000 användare åt gången. Som standard körs detta en gång per dag klockan 1:00 i severns lokala tidzon. Om du vill synkronisera stora uppsättningar användare snabbare kan du öka frekvensen för den schemalagda aktiviteten <b>Synkronisera användare med Azure AD</b> under <a href="{$a}">Schemalagda aktiviteter</a> i administrationen.<br /><br />';
$string['settings_aadsync_disabledsync'] = 'Synkronisera inaktiverad-status';
$string['settings_aadsync_emailsync'] = 'Matcha Azure-användarnamn till Moodle e-post istället för användarnamnet i Moodle vid synkroniseringen';
$string['settings_aadsync_guestsync'] = 'Synkronisera gästanvändare';
$string['settings_aadsync_match'] = 'Matcha befintliga Moodle-användare med identiskt namngivna konton i Azure AD';
$string['settings_aadsync_matchswitchauth'] = 'Växla matchade användare till Microsoft 365-autentisering (OpenID Connect)';
$string['settings_aadsync_nodelta'] = 'Genomför en fullständig synkronisering vid varje cron-körning';
$string['settings_aadsync_photosync'] = 'Synkronisera Microsoft 365-profilbilder till Moodle vid cron-körning';
$string['settings_aadsync_photosynconlogin'] = 'Synkronisera Microsoft 365-profilbilder till Moodle vid inloggning';
$string['settings_aadsync_reenable'] = 'Återaktivera inaktiva konton för användare i Azure AD';
$string['settings_aadsync_suspend'] = 'Inaktivera tidigare synkroniserade konton i Moodle när de tas bort i Azure AD';
$string['settings_aadsync_update'] = 'Uppdatera alla konton i Moodle för användare i Azure AD';
$string['settings_aadtenant'] = 'Azure AD-tenant';
$string['settings_aadtenant_details'] = 'Används för att identifiera din organisation i Azure AD. Exempel: "contoso.onmicrosoft.com".';
$string['settings_aadtenant_error'] = 'Vi kunde inte identifiera din Azure AD-klient.<br />Vänligen se till att "Windows Azure Active Directory" har lagts till i ditt registrerade Azure AD-program och att behörigheten "Läs katalogdata" är aktiverad.';
$string['settings_addsync_tzsync'] = 'Synkronisera tidszon i Outlook med Moodle vid cron-körning';
$string['settings_addsync_tzsynconlogin'] = 'Synkronisera tidszon i Outlook med Moodle vid inloggning';
$string['settings_adminconsent'] = 'Administratörsmedgivande';
$string['settings_adminconsent_btn'] = 'Ge administratörsmedgivande';
$string['settings_adminconsent_details'] = 'För att ge åtkomst till några av de behörigheter som behövs måste en administratör ge administratörs medgivande. Klicka på den här knappen och logga sedan in med ett Azure-administratörs konto för att ge medgivande. Detta måste göras när du ändrar "Admin"-behörigheter i Azure.';
$string['settings_azuresetup'] = 'Azure AD-konfiguration';
$string['settings_azuresetup_appdatadesc'] = 'Verifierar att korrekta parametrar används för Azure AD.';
$string['settings_azuresetup_appdataheader'] = 'Registrering av Azure AD-program';
$string['settings_azuresetup_appdatareplyurlcorrect'] = 'Svars-URL är korrekt';
$string['settings_azuresetup_appdatareplyurlgeneralerror'] = 'Det gick inte att kontrollera svarsadressen.';
$string['settings_azuresetup_appdatareplyurlincorrect'] = 'Felaktig svars-URL';
$string['settings_azuresetup_appdatasignonurlcorrect'] = 'Inloggnings-URL korrekt.';
$string['settings_azuresetup_appdatasignonurlgeneralerror'] = 'Det gick inte att kontrollera inloggnings-URL:en';
$string['settings_azuresetup_appdatasignonurlincorrect'] = 'Felaktig inloggnings-URL';
$string['settings_azuresetup_apppermscorrect'] = 'Programbehörigheterna är korrekta.';
$string['settings_azuresetup_checking'] = 'Kontrollerar...';
$string['settings_azuresetup_correctval'] = 'Korrekt värde:';
$string['settings_azuresetup_details'] = 'Det här verktyget kontrollerar med Azure AD för att se till att allt är korrekt konfigurerat. <br /><b>OBS!</b> Det kan ta en stund innan ändringar i Azure AD slår igenom och syns här. Om du har gjort en ändring i Azure AD och inte ser den här, väntar du en stund och försöker igen.';
$string['settings_azuresetup_detectedval'] = 'Funnet värde:';
$string['settings_azuresetup_errorcheck'] = 'Ett fel inträffade då Azure AD-konfigurationen skulle kontrolleras.';
$string['settings_azuresetup_missingappperms'] = 'Saknade programbehörigheter:';
$string['settings_azuresetup_missingperms'] = 'Saknade delegerade behörigheter:';
$string['settings_azuresetup_noinfo'] = 'Vi har ingen information om din Azure AD-installation ännu. Klicka på knappen Uppdatera för att kontrollera.';
$string['settings_azuresetup_permscorrect'] = 'Delegerade behörigheter är korrekta';
$string['settings_azuresetup_strtenanterror'] = 'Vänligen använd "Upptäck"-knappen för att ställa in din Azure AD Tenant innan du uppdaterar inställningarna.';
$string['settings_azuresetup_strunifiedpermerror'] = 'Ett fel uppstod när Microsoft Graph API-behörigheter skulle kontrolleras.';
$string['settings_azuresetup_unifiedactive'] = 'Microsoft Graph API är aktivt';
$string['settings_azuresetup_unifieddesc'] = 'Microsoft Graph API:t tillåter kommunikation mellan Moodle och Microsoft 365.';
$string['settings_azuresetup_unifiederror'] = 'Ett fel uppstod när stöd för Microsoft Graph API skulle kontrolleras.';
$string['settings_azuresetup_unifiedheader'] = 'Microsoft Graph API';
$string['settings_azuresetup_unifiedmissing'] = 'Microsoft Graph API hittades inte i det här programmet.';
$string['settings_azuresetup_update'] = 'Uppdatera';
$string['settings_bot_app_id'] = 'Applikations-ID';
$string['settings_bot_app_id_desc'] = '';
$string['settings_bot_app_password'] = 'Klienthemlighet';
$string['settings_bot_app_password_desc'] = 'Gå till avsnittet \'Certifikat & hemligheter\' under \'Hantera\' i applikationsinställningarna och klicka på \'Ny klienthemlighet\'. Klistra in engångs-hemligheten här.';
$string['settings_bot_feature_enabled'] = 'Bot-funktionalitet aktiverad';
$string['settings_bot_feature_enabled_desc'] = '';
$string['settings_bot_sharedsecret'] = 'Delad Moodle-hemlighet';
$string['settings_bot_sharedsecret_desc'] = 'Den här delade hemligheten läggs också till i fältet "Delad Moodle-hemlighet" i Azure Bot-mallen för att skydda kommunikationen mellan Moodle och Botten.';
$string['settings_bot_webhook_endpoint'] = 'Ändpunkt för Bot-webhook';
$string['settings_bot_webhook_endpoint_desc'] = 'Format: https://<b><moodlebotname\\></b>.azurewebsites.net/api/webhook';
$string['settings_check_moodle_settings'] = 'Kontrollera Moodle-inställningarna';
$string['settings_course_reset_teams'] = 'Teams cache har uppdaterats.';
$string['settings_course_reset_teams_details'] = 'Åtgärder som ska utföras i ett Team eller en grupp som är ansluten till en kurs när kursen återställs.';
$string['settings_course_reset_teams_option_archive_only'] = 'Koppla bort kursen med endast team eller grupp<br />Det befintliga teamet eller gruppen som är ansluten till kursen kommer att byta namn så som konfigurerats. Om ett team är anslutet arkiveras det. Inget nytt team eller någon ny grupp kommer att skapas.';
$string['settings_course_reset_teams_option_do_nothing'] = 'Gör ingenting<br>Teamet eller gruppen är fortfarande ansluten till kursen. Avregistrering av användare resulterar i borttagning av medlemskapet i Teamet eller gruppen.';
$string['settings_course_reset_teams_option_force_archive'] = 'Koppla från kursen med teamet eller gruppen och skapa ett nytt<br>Det befintliga Teamet eller gruppen som är ansluten till kursen kommer att byta namn så som konfigurerats. Om ett team är anslutet arkiveras detta. Ett nytt team eller en ny grupp skapas och kopplas till kursen.';
$string['settings_course_reset_teams_option_per_course'] = 'Tillåt enskilda inställningar per kurs<br>Det här kräver att Microsoft-blocket läggs till i kursen. Användare med möjlighet att återställa kursen kan välja vad de vill göra vid kursåterställning i blocket.';
$string['settings_coursesync'] = 'Kurssynkronisering';
$string['settings_coursesync_courses_per_task'] = 'Antal kurser att synkronisera vid varje bakgrundsuppdatering';
$string['settings_coursesync_courses_per_task_details'] = 'Antalet kurser vars Team/gruppsynkroniseringsstatus som ska behandlas vid varje bakgrundsuppdatering.';
$string['settings_coursesync_delete_group_on_course_deletion'] = 'Ta bort Microsoft 365-grupper när anslutna Moodlekurser tas bort';
$string['settings_coursesync_delete_group_on_course_deletion_details'] = 'Om det här alternativet är aktiverat försöker Moodle ta bort Microsoft 365-gruppen (och tillhörande team) när den anslutna kursen tas bort från Moodle. Observera att detta inte gäller för kurser som skapats från SDS-synkronisering.';
$string['settings_coursesync_delete_group_on_course_sync_disabled'] = 'Ta bort Microsoft 365-grupper när kurssynkroniseringen inaktiveras';
$string['settings_coursesync_delete_group_on_course_sync_disabled_details'] = 'Om det här alternativet är aktiverat försöker Moodle ta bort den anslutna Microsoft 365-gruppen (och tillhörande team) när kurssynkronisering inaktiveras för en Moodle-kurs.';
$string['settings_coursesync_details'] = 'Om det här alternativet är aktiverat skapas och underhålls Teams för kurser på Moodle-webbplatsen (standard: Inaktiverat). Detta skapar alla nödvändiga Teams vid varje cron-körning och lägger till alla aktuella registrerade användare som teamägare eller medlemmar, beroende på deras funktionsbehörighet. Därefter underhålls teammedlemskapet när användarna registreras eller avregistreras från Moodle-kurser.';
$string['settings_customtheme'] = 'Anpassat tema (Avancerat)';
$string['settings_customtheme_desc'] = 'Rekommenderat tema är <em>"boost_o365teams"</em>. Du kan dock välja ett annat tema om du har ett eget tema som är anpassat för att användas i Teams-fliken.
Observera att en anpassad temauppsättning på antingen kurs- eller kategorinivå skulle ha företräde framför inställningar här, dvs. en kurs skulle använda kurs- eller kategoritemat i Moodle-appen för Teams som standard. Detta kan åtgärdas genom att uppdatera <em>$CFG->themeorder</em> i <em>config.php</em> till <code>array(\'session\', \'course\', \'category\', \'user\', \'cohort\', \'site\');</code>.';
$string['settings_debugmode'] = 'Felsökningsläge';
$string['settings_debugmode_details'] = 'Om aktiverat kommer information som kan hjälpa till vid felsökning sparas i Moodles logg. <a href="{$a}">Visa sparade loggmeddelanden.</a>';
$string['settings_deploy_bot'] = 'Publicera bot till Azure';
$string['settings_detectoidc'] = 'Autentiseringsuppgifter för applikation';
$string['settings_detectoidc_credsinvalid'] = 'Autentiseringsuppgifter har inte angetts eller är ofullständiga.';
$string['settings_detectoidc_credsvalid'] = 'Autentiseringsuppgifter har angivits.';
$string['settings_detectoidc_details'] = 'För att kommunicera med Microsoft 365 behöver Moodle autentiseringsuppgifter för att identifiera sig. Dessa anges i autentiseringspluginmodulen "OpenID Connect".';
$string['settings_detectperms'] = 'Programbehörigheter';
$string['settings_detectperms_details'] = 'För att kunna använda plugin-funktionerna måste  korrekta behörigheter ställas in för programmet i Azure AD.';
$string['settings_detectperms_errorfix'] = 'Ett fel uppstod när behörigheter skulle åtgärdas. Ange dessa manuellt i Azure AD.';
$string['settings_detectperms_fixperms'] = 'Åtgärda behörigheter';
$string['settings_detectperms_fixprereq'] = 'För att åtgärda detta automatiskt måste system API-användaren vara administratör och behörigheten "Komma åt organisationens katalog" måste vara aktiverad i Azure AD för programmet "Windows Azure Active Directory".';
$string['settings_detectperms_invalid'] = 'Kontrollera behörigheter i Azure AD';
$string['settings_detectperms_missing'] = 'Saknas:';
$string['settings_detectperms_nocreds'] = 'Autentiseringsuppgifter för applikationen måste anges först. Se inställningen ovan.';
$string['settings_detectperms_nounified'] = 'Microsoft Graph API finns inte, vissa nya funktioner kanske inte går att använda.';
$string['settings_detectperms_unifiednomissing'] = 'Alla enhetliga behörigheter finns.';
$string['settings_detectperms_update'] = 'Uppdatera';
$string['settings_detectperms_valid'] = 'Behörigheter har konfigurerats.';
$string['settings_download_teams_tab_app_manifest'] = 'Ladda ner manifestfil';
$string['settings_download_teams_tab_app_manifest_reminder'] = 'Vänligen spara alla ändringar innan manifestet laddas ned.';
$string['settings_enableapponlyaccess'] = 'Applikationsåtkomst';
$string['settings_enableapponlyaccess_details'] = '<b>Rekommenderad metod</b>. Med den här metoden kommer integrationen åt Microsoft 365 direkt med Hjälp av Azures "Programbehörigheter". Detta är det enklaste och rekommenderade sättet att ansluta till Microsoft 365, men det kräver att du aktiverar några extra behörigheter i Azure.<br /><br /><b>- Eller -</b><br />';
$string['settings_fieldmap'] = 'Mappning av användarfält';
$string['settings_fieldmap_details'] = 'Den här inställningen har flyttat till <a href="{$a}">Open ID Connect</a>-modulen.';
$string['settings_group_mail_alias_course'] = 'Kursnamnsdel i mail-aliaset för gruppen';
$string['settings_group_mail_alias_course_desc'] = '';
$string['settings_group_mail_alias_prefix'] = 'Prefix för grupp e-postadress';
$string['settings_group_mail_alias_suffix'] = 'Suffix för gruppens e-postalias';
$string['settings_group_mail_alias_suffix_desc'] = '';
$string['settings_header_advanced'] = 'Avancerat';
$string['settings_header_moodle_app'] = 'Moodle-app för Teams';
$string['settings_header_sds'] = 'School Data Sync';
$string['settings_header_setup'] = 'Inställningar';
$string['settings_header_syncsettings'] = 'Synkroniseringsinställningar';
$string['settings_header_teams'] = 'Teams-inställningar';
$string['settings_header_tools'] = 'Verktyg';
$string['settings_healthcheck'] = 'Hälsokontroll';
$string['settings_healthcheck_details'] = 'Om det är något som inte fungerar som det ska kan en hälsokontroll vanligtvis identifiera problemet och föreslå en lösning.';
$string['settings_healthcheck_linktext'] = 'Utför hälsokontroll';
$string['settings_main_name_option_full_name'] = 'Fullständigt namn';
$string['settings_main_name_option_id'] = 'Moodle-skapat ID';
$string['settings_main_name_option_id_number'] = 'ID-nummer';
$string['settings_main_name_option_short_name'] = 'Kortnamn';
$string['settings_maintenance'] = 'Underhåll';
$string['settings_maintenance_details'] = 'Olika underhållsaktiviteter finns tillgängliga för att lösa några vanliga problem.';
$string['settings_maintenance_linktext'] = 'Visa underhållsverktyg';
$string['settings_moodle_app_id'] = 'Moodle-app ID';
$string['settings_moodle_app_id_desc'] = 'ID för den uppladdade Moodle-appen i Teams-app kataloger.<br/>
Om konfigurerat försöker Moodle skapa en Moodle-flik som länkar till Moodle-kursen i kanalen "Allmänt" i det skapade/anslutna teamet.';
$string['settings_moodle_app_id_desc_auto_id'] = '<br/>
Automatiskt upptäckta värdet är "<span class="local_o365_settings_moodle_app_id">{$a}</span>".';
$string['settings_moodlesettingssetup'] = 'Konfigurera Moodle';
$string['settings_moodlesettingssetup_details'] = 'Detta säkerställer att:
<ul class="local_o365_settings_teams_horizontal_spacer">
<li>Open ID är aktiverat.</li>
<li>Inbäddning i ramar är aktiverat.</li>
<li>Webbtjänster är aktiverade.</li>
<li>REST-protokollet är aktiverat.</li>
<li>Webbtjänster för Microsoft 365 är aktiverade.</li>
<li>Autentiserade användare har behörighet att skapa webbtjänst-token.</li>
<li>Autentiserade användare har behörighet att använda REST-protokollet.</li>
</ul>';
$string['settings_moodlesetup_checking'] = 'Kontrollerar...';
$string['settings_notice_createtokenallowed'] = 'Behörighet att skapa ett webbtjänsttoken beviljad';
$string['settings_notice_createtokenalreadyallowed'] = 'Behörighet att skapa webbtjänsttoken är beviljad';
$string['settings_notice_createtokennotallowed'] = 'Det uppstod ett problem då behörigheter att skapa ett webbtjänsttoken skulle beviljas';
$string['settings_notice_o365servicealreadyenabled'] = 'O365-webbtjänster är aktiverade';
$string['settings_notice_o365serviceenabled'] = 'O365-webbtjänster har aktiverats';
$string['settings_notice_oidcalreadyenabled'] = 'Open ID Connect är aktiverat';
$string['settings_notice_oidcenabled'] = 'Open ID Connect aktiverat';
$string['settings_notice_oidcnotenabled'] = 'Det gick inte att aktivera Open ID Connect';
$string['settings_notice_restalreadyenabled'] = 'REST-protokollet är aktiverat';
$string['settings_notice_restenabled'] = 'REST-protokollet aktiverat';
$string['settings_notice_restnotenabled'] = 'REST-protokollet kunde inte aktiveras';
$string['settings_notice_restusageallowed'] = 'Behörighet att använda REST-protokoll beviljad';
$string['settings_notice_restusagealreadyallowed'] = 'Behörighet att använda REST-protokoll är beviljad';
$string['settings_notice_restusagenotallowed'] = 'Det uppstod ett problem då behörigheter att använda REST-protokollet skulle beviljas';
$string['settings_notice_webservicesframealreadyenabled'] = 'Webbtjänster är aktiverade och raminbäddning är tillåten';
$string['settings_notice_webservicesframeenabled'] = 'Webbtjänster aktiverade och raminbäddning är också tillåten nu';
$string['settings_o365china'] = 'Microsoft 365 för Kina';
$string['settings_o365china_details'] = 'Markera om du använder Microsoft 365 för Kina.';
$string['settings_odburl'] = 'Länk till OneDrive för företag';
$string['settings_odburl_details'] = 'URL:en som används för att komma åt OneDrive för företag. Detta kan vanligtvis bestämmas av din Azure AD-klient. Om din Azure AD-klient till exempel är "contoso.onmicrosoft.com" är detta troligtvis "contoso-my.sharepoint.com". Ange bara domännamnet, inkludera inte http:// eller https://';
$string['settings_odburl_error'] = 'Vi kunde inte avgöra URL:en för OneDrive för företag.<br />Vänligen se till att "Microsoft 365 SharePoint Online" har lagts till i ditt registrerade program i Azure AD.';
$string['settings_odburl_error_graph'] = 'Vi kunde inte avgöra din URL för OneDrive för företag. Vänligen ange denna manuellt. Detta kan vanligtvis bestämmas med hjälp av URL:en du använder för att komma åt OneDrive.';
$string['settings_options_usersync'] = 'Användarsynkronisering';
$string['settings_options_usersync_desc'] = 'Följande inställningar styr användarsynkronisering mellan Microsoft 365 och Moodle.';
$string['settings_photoexpire'] = 'Uppdateringsintervall för profilbild';
$string['settings_photoexpire_details'] = 'Uppdateringsintervallet (i timmar) mellan uppdateringarna av profilbilderna. Ett längre intervall kan förbättra prestandan.';
$string['settings_publish_manifest_instruction'] = '<a href="https://docs.microsoft.com/en-us/microsoftteams/platform/concepts/apps/apps-upload" target="_blank">Klicka här</a> för att lära dig hur du publicerar den nedladdade manifestfilen för din Moodle-applikation till alla användare i Microsoft Teams.';
$string['settings_reset_group_name_prefix'] = 'Återställ gruppnamnsprefix';
$string['settings_reset_group_name_prefix_details'] = 'När du återställer en kurs som är ansluten till en grupp kommer namnet på den befintliga gruppen att föregås av detta.';
$string['settings_reset_team_name_prefix'] = 'Återställ Teamnamnprefix';
$string['settings_reset_team_name_prefix_details'] = 'När du återställer en kurs som är ansluten till ett team kommer namnet på det befintliga anslutna teamet att föregås av detta.';
$string['settings_sds_coursecreation'] = 'Kursskapande';
$string['settings_sds_coursecreation_desc'] = 'Dessa alternativ styr skapande av kurser i Moodle baserat på information SDS.';
$string['settings_sds_coursecreation_enabled'] = 'Synkroniserade skolor';
$string['settings_sds_coursecreation_enabled_desc'] = 'Skapa kurser för de här skolorna.';
$string['settings_sds_enrolment_enabled'] = 'Registrera användare';
$string['settings_sds_enrolment_enabled_desc'] = 'Anmäl SDS-klasslärare och medlemmar till Moodle-kurser som skapats från klasserna.<br />
För att synkronisera ändringar av SDS-klasslärare/medlemsrolländringar till Moodle-klasser måste <b>Avancerad registreringssynkronisering med SDS-klasser</b> aktiveras och inställningar för rollen <b>Lärare</b> och <b>Medlem</b> måste konfigureras.';
$string['settings_sds_enrolment_student_role'] = 'Medlemsroll';
$string['settings_sds_enrolment_student_role_desc'] = 'Om "Registrera användare"-alternativet är aktiverat registreras studenter i SDS-klassen till den anslutna Moodlekursen med denna roll.';
$string['settings_sds_enrolment_teacher_role'] = 'Lärarroll';
$string['settings_sds_enrolment_teacher_role_desc'] = 'Om "Registrera användare"-alternativet är aktiverat registreras lärare i SDS-klassen till den anslutna Moodlekursen med denna roll.';
$string['settings_sds_get_schools_error'] = '<div class="alert alert-info error">Kunde inte hämta SDS-skolor. Kontrollera att Azure-appen har nödvändiga behörigheter.</div>';
$string['settings_sds_intro'] = '';
$string['settings_sds_intro_desc'] = 'School data sync  ("SDS") låter dig synkronisera information importerad till Azure AD från externa SIS-system till Moodle. <a href="https://sis.microsoft.com/" target="_blank">Mer information</a><br /><br />Synkroniseringen sker via Moodle cron och sker 03:00 lokal servertid. För att ändra detta schema, gå till <a href="{$a}">Schemalagda aktiviteter</a> i administrationen.<br /><br />';
$string['settings_sds_intro_previewwarning'] = '<div class="alert"><b>Detta är en förhandsgranskningsfunktion</b><br />Förhandsgranskningsfunktioner kanske inte fungerar som tänkt eller kan fallera utan förvarning. Vänligen fortsätt med försiktighet.</div>';
$string['settings_sds_noschools'] = '<div class="alert alert-info">Det finns inga tillgängliga skolor i <em>School data sync</em>.</div>';
$string['settings_sds_profilesync'] = 'Synkronisera profildata från skola';
$string['settings_sds_profilesync_desc'] = 'Dessa alternativ styr synkronisering av profilinformation mellan SDS och Moodle.';
$string['settings_sds_profilesync_disabled'] = 'Inaktiverad';
$string['settings_sds_profilesync_header'] = 'Profildatasynkronisering';
$string['settings_sds_profilesync_header_desc'] = 'De här inställningarna styr profildatasynkroniseringen mellan SDS och Moodle.';
$string['settings_sds_school_disabled_action'] = 'Åtgärd vid inaktiverad synkronisering';
$string['settings_sds_school_disabled_action_desc'] = 'Åtgärd för de redan anslutna Moodle-kurserna när synkronisering är inaktiverad på en SDS-skola.';
$string['settings_sds_school_disabled_action_disconnect'] = 'Ta bort koppling från Moodlekursen till Teamet';
$string['settings_sds_school_disabled_action_keep_connected'] = 'Behåll kopplingen mellan Moodlekursen och Teamet';
$string['settings_sds_sync_enrolment_to_sds'] = 'Avancerad registreringssynkronisering med SDS-klasser';
$string['settings_sds_sync_enrolment_to_sds_desc'] = 'Det här alternativet kräver att <b>Registrera användare</b>-alternativet är aktiverat för att fungera.<br />
Om den här inställningen är aktiverad gör SDS-klassynkroniseringen följande:
<ul>
<li>Ändringar i SDS-klassägarskap/medlemskapsstatus synkroniseras med Moodle-kursen och återspeglas i Moodles användarrolländringar.</li>
<li>Användarregistreringsändringar, till exempel registreringar och avregistreringar, som görs i en Moodle-kurs som är ansluten till SDS-klasser synkroniseras tillbaka till SDS-klasser. Användarens ägar-/medlemskapsstatus beror på funktionerna <code>local/o365:teamowner</code> och <code>local/o365:teammember</code> i kurskontextet.</li>
</ul>';
$string['settings_sds_teams_enabled'] = 'Skapande av Team aktiverat';
$string['settings_sds_teams_enabled_desc'] = 'Detta styr om Moodle-kurser som skapats från synkroniserande SDS-klasser automatiskt ansluts till Microsoft Team i SDS-klassen. Detta bör endast aktiveras om Teams skapas automatiskt från SDS-klasserna.';
$string['settings_secthead_advanced'] = 'Avancerade inställningar';
$string['settings_secthead_advanced_desc'] = 'De här inställningarna styr övriga egenskaper hos plugin-uppsättningen. Var försiktig! Felaktiga inställningar kan medföra oväntade effekter.';
$string['settings_secthead_coursesync'] = 'Kurssynkronisering';
$string['settings_secthead_coursesync_desc'] = 'Följande inställningar styr synkroniseringen av kurser mellan Moodle och Microsoft Teams.';
$string['settings_secthead_team_group_name'] = 'Team-/gruppnamn';
$string['settings_secthead_team_group_name_desc'] = 'Om en kurs är konfigurerad för att synkroniseras kommer namnet på teamet och gruppen att konstrueras enligt följande.<br/>
<ul>
<li>Gruppens e-postalias och teamets visningsnamn kan definieras.</li>
<li>Microsoft 365-gruppen skapas först med hjälp av gruppens <code>mailNickname</code> och teamets visningsnamn som konfigureras först varefter ett team skapas från gruppen.</li>
<li>Om namngivningsprinciper för Azure AD-grupper används skapas inte grupper om visningsnamnet som skapats enligt konfigurationen inte matchar principerna.</li>
<li>Ändringar som görs här påverkar bara framtida team och inte befintliga.</li>
<li>Alla blanksteg tas bort från gruppens e-postalias.</li>
<li>Endast stora och små bokstäver, siffror - och _ är tillåtna i gruppens e-postalias.</li>
<li>Grupppostalias, inklusive prefix och suffix får inte överstiga 64 tecken.</li>
<li>Gruppens e-postalias måste vara unikt, annars läggs ett slumpmässigt 4-siffrigt nummer till för att säkerställa unikhet.</li>
</ul>';
$string['settings_serviceresourceabstract_detect'] = 'Upptäck';
$string['settings_serviceresourceabstract_detecting'] = 'Kontrollerar...';
$string['settings_serviceresourceabstract_empty'] = 'Ange ett värde eller klicka på "Identifiera" för att försöka identifiera rätt värde.';
$string['settings_serviceresourceabstract_error'] = 'Ett fel uppstod när inställningen skulle identifieras. Vänlige ställ in manuellt.';
$string['settings_serviceresourceabstract_invalid'] = 'Det här värdet verkar inte gå att använda.';
$string['settings_serviceresourceabstract_nocreds'] = 'Vänligen ange autentiseringsuppgifter för applikationen först.';
$string['settings_serviceresourceabstract_noperms'] = 'Vi kunde inte identifiera den här inställningen.<br />Se till att "Windows Azure Active Directory" har lagts till i din registrerade Azure AD-applikation och att behörigheten "Läs katalogdata" är aktiverad.';
$string['settings_serviceresourceabstract_valid'] = '{$a} är användbar.';
$string['settings_set_moodle_app_id_instruction'] = 'Så här hittar du Moodle-app ID:et manuellt:

<ol> <li>Ladda upp den nedladdade manifestfilen till Teams-appkatalogen i din tenant.</li> <li>I Teams-appkatalogen hittar du appen.</li> <li>Klicka på appens ikon för alternativ, som finns längst upp till höger i appbilden.</li> <li>Klicka på "Kopiera länk".</li> <li>I en textredigerare klistrar du in det kopierade innehållet. Det ska innehålla en URL som https://teams.microsoft.com/l/app/00112233-4455-6677-8899-aabbccddeeff.</li> </ol> Den sista delen i URL:en, dvs. <span class="local_o365_settings_moodle_app_id">00112233-4455-6677-8899-aabbccddeeff</span>, motsvarar app-ID:t.';
$string['settings_setup_step1'] = 'Steg 1/3: Registrera Moodle i Azure AD';
$string['settings_setup_step1_continue'] = '<b>När du angivit Program-ID och klienthemlighet, klicka på "Spara" nederst på sidan för att fortsätta.</b><br /><br /><br /><br /><br />';
$string['settings_setup_step1_credentials_end'] = 'Om du inte kan installera AzureAD-appen via PowerShell, <a href="https://aka.ms/MoodleTeamsManualSetup" target="_blank">klicka här</a> för instruktioner hur du gör detta manuellt.

OBS! De här inställningarna sparas i <em>OpenID Connect</em> autentiseringsmodulen. För att konfigurera avancerade inställningar, gå till <a href="{$a->oidcsettings}">inställningarna för OpenID Connect</a>.<br /><br />';
$string['settings_setup_step1_desc'] = 'Registrera en ny Azure AD-applikation för din Microsoft 365 tenant genom att använda Windows PowerShell:

<a href="{$a}/local/o365/scripts/Moodle-AzureAD-Powershell.zip" class="btn btn-primary" target="_blank">Hämta PowerShell-skript</a>

<p style="margin-top:10px"><a href="https://aka.ms/MoodleTeamsPowerShellReadMe" target="_blank">Klicka här </a> för instruktioner hur du kör skriptet. När du ombeds ange länken till Moodle, använd följande:</p><h5><b>{$a}</b></h5>';
$string['settings_setup_step1_existing_settings'] = '<h5>Nuvarande inställningar</h5>';
$string['settings_setup_step1clientcreds'] = '<br />Efter att skriptet körts, kopiera Program-ID och den klienthemlighet som erhållits och klistra in dessa i fälten nedan:';
$string['settings_setup_step2'] = 'Steg 2/3: Välj anslutningsmetod';
$string['settings_setup_step2_continue'] = '<b>Välj en anslutningsmetod och klicka sedan på "Spara ändringar" för att fortsätta.</b><br /><br /><br /><br /><br />';
$string['settings_setup_step2_desc'] = 'I det här avsnittet kan du välja hur Microsoft 365-integrationssviten ska ansluta till Microsoft 365-tjänsterna.<br />
Historiskt sett har integrationen mot Microsoft 365-tjänsterna kunnat göras med hjälp av "Applikationsåtkomst" eller via en dedicerad användare som du har angivit som "system"-användare.<br />
<b>Från och med mars 2022 stöds endast alternativet "Applikationsåtkomst". Alla framtida nya funktioner kommer endast att implementeras och testas med anslutningsmetoden "Applikationsåtkomst".</b>';
$string['settings_setup_step2_desc_additional'] = '<br /><br />
<span class="error">Du använder för närvarande anslutningsmetoden "System API user", som inte stöds sedan mars 2022. Ändra till anslutningsmetoden "Application Access".</span>';
$string['settings_setup_step3'] = 'Steg 3/3: Samtycke &amp; övrig information';
$string['settings_setup_step3_desc'] = 'I det här sista steget kan du ge administratörsmedgivande för vissa Azure-behörigheter. Här samlas även ytterligare information om din Microsoft 365-miljö in.<br /><br />';
$string['settings_setup_step4'] = 'Verifiera inställningarna';
$string['settings_setup_step4_desc'] = 'Installationen är klar. Klicka på knappen "Uppdatera" nedan för att verifiera din installation.';
$string['settings_switchauthminupnsplit0'] = 'Minsta inexakta användarnamnslängd att byta till Microsoft 365';
$string['settings_switchauthminupnsplit0_details'] = 'Om du aktiverar inställningen "Växla matchade användare till Microsoft 365-autentisering" anger detta minsta längd för användarnamn utan en tenant (@example.onmicrosoft.com-delen) som kan växlas. Detta hjälper till att undvika att byta konton med allmänna namn, som "admin", som inte nödvändigtvis är samma i Moodle och Azure AD.';
$string['settings_team_name_course'] = 'Kursnamnsdel i Teams-namnet';
$string['settings_team_name_course_desc'] = '';
$string['settings_team_name_prefix'] = 'Prefix för Teams-namn';
$string['settings_team_name_prefix_desc'] = '';
$string['settings_team_name_sample'] = 'Antag att en kurs har:
<ul>
<li>Fullständigt namn: <b>Sample course 15</b>
<li>Kortnamn: <b>sample 15</b></li>
<li>Moodle-skapat ID: <b>2</b></li>
<li>ID-nummer: <b>Sample ID 15</b></li>
</ul>
Din nuvarande inställning skapar en grupp med e-postadressen "<strong>{$a->mailalias}</strong>" samt ett Team med namnet "<strong>{$a->teamname}</strong>".<br/>
Klicka på "Spara" nedan för att se hur dina inställningar kommer att ändra detta.';
$string['settings_team_name_suffix'] = 'Suffix för Team-namn';
$string['settings_team_name_suffix_desc'] = '';
$string['settings_team_name_sync'] = 'Uppdatera Teamnamn vid kursuppdatering';
$string['settings_team_name_sync_desc'] = 'Om aktiverat uppdateras namnet på Teamet när Moodle-kursen uppdateras enligt de senaste Teams-namninställningarna.';
$string['settings_teamconnections'] = 'Teams-anslutningar';
$string['settings_teamconnections_details'] = 'Granska och hantera anslutningar mellan Moodle-kursen och Microsoft Teams.';
$string['settings_teamconnections_linktext'] = 'Hantera Teams-anslutningar';
$string['settings_teams_additional_instructions'] = '<p class="local_o365_settings_teams_horizontal_spacer">
Gå till avsnittet <a href="https://aka.ms/MoodleBotRegistration" target="_blank">App-registreringar i Azure Portal</a> och registrera en ny app. Ange Program-ID och klienthemlighet nedan:
</p>';
$string['settings_teams_banner_1'] = 'Moodle-appen för <a href="https://aka.ms/MoodleLearnTeams" target="_blank">Microsoft Teams</a> gör att du enkelt kan komma åt och samarbeta kring dina Moodle-kurser i Teams. Moodle-appen innehåller också en Moodle Assistent-bot som skickar Moodle-meddelanden till elever och lärare och svarar på frågor om deras kurser, uppgifter, betyg och elever - direkt i Teams!';
$string['settings_teams_banner_2'] = 'Om du vill sätta upp Moodles Assistent-bot i din Microsoft 365-tenant måste du publicera den till <a href="https://aka.ms/MoodleLearnAzure" target="_blank">Microsoft Azure</a>. Om du inte har en aktiv Azure-prenumeration kan du <a href="https://aka.ms/MoodleTeamsAzureFree" target="_blank">få en gratis</a> idag!';
$string['settings_teams_deploy_bot_1'] = 'När du har slutfört ovanstående steg och har en aktiv Azure-prenumeration, klicka här för att publicera botten:';
$string['settings_teams_deploy_bot_2'] = 'Behöver du hjälp?';
$string['settings_teams_download_json'] = 'Ladda ned JSON';
$string['settings_teams_download_json_desc'] = 'När du har angett klient-ID och hemlighet ovan klickar du på knappen nedan för att ladda ner JSON-filen för distribution.';
$string['settings_teams_moodle_app_external_id'] = 'Microsoft applikations-ID för Moodle Teams-appen';
$string['settings_teams_moodle_app_external_id_desc'] = 'Detta bör sättas till standardvärdet såvida inte flera Moodle Teams-appar krävs i din tenant för att ansluta till olika Moodle-webbplatser.';
$string['settings_teams_moodle_app_short_name'] = 'Teams applikationsnamn';
$string['settings_teams_moodle_app_short_name_desc'] = 'Detta kan sättas till standardvärdet såvida inte flera Moodle Teams-applikationer krävs i din tenant för att ansluta till olika Moodle-webbplatser.';
$string['settings_teams_moodle_setup_heading'] = '<h4 class="local_o365_settings_teams_h4_spacer">Konfigurera din Moodle-applikation för Microsoft Teams</h4>';
$string['settings_tools_tenants'] = 'Tenants';
$string['settings_tools_tenants_details'] = 'Hantera åtkomst till ytterligare Microsoft 365 Tenants';
$string['settings_tools_tenants_linktext'] = 'Konfigurera ytterligare Microsoft 365 Tenants';
$string['settings_userconnections'] = 'Användaranslutningar';
$string['settings_userconnections_details'] = 'Granska och hantera anslutningar mellan Moodle- och Microsoft 365-användare.';
$string['settings_userconnections_linktext'] = 'Hantera användaranslutningar';
$string['settings_usermatch'] = 'Användarmatchning';
$string['settings_usermatch_details'] = 'Detta verktyg låter dig matcha Moodle-användare med Microsoft 365-användare baserat på en anpassad uppladdningsfil.';
$string['settings_usersynccreationrestriction'] = 'Begränsning vid skapande av användare';
$string['settings_usersynccreationrestriction_details'] = 'Om aktiverad kommer endast användare som har det angivna värdet för det angivna Azure AD-fältet att skapas under användarsynkroniseringen.';
$string['settings_usersynccreationrestriction_fieldval'] = 'Fältvärde';
$string['settings_usersynccreationrestriction_o365group'] = 'Microsoft 365 gruppmedlemskap';
$string['settings_usersynccreationrestriction_regex'] = 'Värdet är ett reguljärt uttryck';
$string['sorry_do_not_understand'] = 'Jag är ledsen, men, jag förstår inte';
$string['spsite_group_contributors_desc'] = 'Alla användare som har behörighet att hantera filer för {$a}-kursen';
$string['sso_login'] = 'Logga in till Microsoft 365';
$string['tab_moodle'] = 'Moodle';
$string['tab_name'] = 'Namn på flik';
$string['task_bot'] = 'Bearbetning av Bot-meddelanden';
$string['task_calendarsyncin'] = 'Synkronisera O365-händelser till Moodle';
$string['task_coursesync'] = 'Synkronisera Moodlekurser med Microsoft Teams';
$string['task_notifysecretexpiry'] = 'Meddela administratören vid förfallen Azure applikationshemlighet';
$string['task_processmatchqueue'] = 'Bearbeta Matchningskö';
$string['task_processmatchqueue_err_museralreadymatched'] = 'Moodle-användaren är redan matchad med en Microsoft 365-användare.';
$string['task_processmatchqueue_err_museralreadyo365'] = 'Moodle-användaren är redan ansluten till Microsoft 365.';
$string['task_processmatchqueue_err_nomuser'] = 'Ingen Moodle-användare med det här användarnamnet hittades.';
$string['task_processmatchqueue_err_noo365user'] = 'Ingen Microsoft 365-användare med det här användarnamnet hittades.';
$string['task_processmatchqueue_err_o365useralreadyconnected'] = 'Microsoft 365-användaren är redan ansluten till en Moodle-användare.';
$string['task_processmatchqueue_err_o365useralreadymatched'] = 'Microsoft 365-användaren är redan ansluten till en Moodle-användare.';
$string['task_refreshsystemrefreshtoken'] = 'Uppdatera System-API användarens uppdateringstoken';
$string['task_sds_sync'] = 'Synkronisera med SDS';
$string['task_syncusers'] = 'Synkronisera användare med Azure AD';
$string['teams_no_course'] = 'Det finns ingen kurs att lägga till.';
$string['ucp_calsync_availcal'] = 'Tillgängliga Moodle-kalendrar';
$string['ucp_calsync_desc'] = 'Markerade kalendrar kommer att synkroniseras från Moodle till din Outlook-kalender.';
$string['ucp_calsync_title'] = 'Synkroniseringsinställningar för Outlook-kalender';
$string['ucp_connection_aadlogin'] = 'Använd dina inloggningsuppgifter från Microsoft 365 för att logga in i Moodle<br />';
$string['ucp_connection_aadlogin_active'] = 'Du använder Microsoft 365-kontot "{$a}" för att logga in i Moodle.';
$string['ucp_connection_aadlogin_desc_authcode'] = 'Istället för att ange ett användarnamn och lösenord på Moodles inloggningssida kommer du att se ett avsnitt som säger "Logga in med ditt konto på {$a}" på inloggningssidan. Du klickar på länken och omdirigeras till Microsoft 365 för att logga in. Efter att du har loggat in på Microsoft 365 kommer du att returneras till Moodle och bli inloggad på ditt konto.';
$string['ucp_connection_aadlogin_desc_rocreds'] = 'I stället för ditt Moodle-användarnamn och lösenord anger du ditt Användarnamn och lösenord för Microsoft 365 på Moodle-inloggningssidan.';
$string['ucp_connection_aadlogin_start'] = 'Börja använda Microsoft 365 för att logga in i Moodle.';
$string['ucp_connection_aadlogin_stop'] = 'Sluta använda Microsoft 365 för att logga in i Moodle.';
$string['ucp_connection_desc'] = 'Här kan du konfigurera hur du ansluter till Microsoft 365. För att kunna använda Microsoft 365-funktioner måste du vara ansluten till ett Microsoft 365-konto. Detta kan åstadkommas som beskrivs nedan.';
$string['ucp_connection_disconnected'] = 'Du är inte ansluten till Microsoft 365.';
$string['ucp_connection_linked'] = 'Länka dina Moodle- och Microsoft 365-konton';
$string['ucp_connection_linked_active'] = 'Du är länkad till Microsoft 365-kontot "{$a}".';
$string['ucp_connection_linked_desc'] = 'Genom att länka dina Moodle- och Microsoft 365-konton kan du använda Moodlefunktionerna i Microsoft 365 utan att ändra hur du loggar in på Moodle. <br />Genom att klicka på länken nedan kommer att omdirigeras till Microsoft 365 för att utföra en engångsinloggning varefter du kommer tillbaka hit. Du kommer att kunna använda alla Microsoft 365-funktionerna utan att göra några andra ändringar av ditt Moodle-konto - du kommer att logga in på Moodle som du alltid har gjort.';
$string['ucp_connection_linked_migrate'] = 'Byt till länkat konto.';
$string['ucp_connection_linked_start'] = 'Länka ditt Moodle-konto till ett Microsoft 365-konto.';
$string['ucp_connection_linked_stop'] = 'Ta bort länken till Moodle-kontot från Microsoft 365-kontot.';
$string['ucp_connection_options'] = 'Anslutningsalternativ:';
$string['ucp_connection_start'] = 'Anslut till Microsoft 365';
$string['ucp_connection_status'] = 'Microsoft 365-anslutningen är:';
$string['ucp_connection_stop'] = 'Koppla ned från Microsoft 365';
$string['ucp_connectionstatus'] = 'Anslutningsstatus';
$string['ucp_features'] = 'Funktioner i Microsoft 365';
$string['ucp_features_intro'] = 'Nedan ser du en lista med funktioner du kan använda för att utöka Moodle med Microsoft 365.';
$string['ucp_features_intro_notconnected'] = 'Vissa av funktionerna kanske inte är tillgängliga förrän du är ansluten till Microsoft 365.';
$string['ucp_general_intro'] = 'Här kan du hantera din anslutning till Microsoft 365.';
$string['ucp_general_intro_notconnected_nopermissions'] = 'Om du vill ansluta till Microsoft 365 måste du kontakta webbplatsadministratören.';
$string['ucp_index_aadlogin_active'] = 'Du använder Microsoft 365 för att logga in i Moodle';
$string['ucp_index_aadlogin_desc'] = 'Du kan använda inloggningsuppgifterna i Microsoft 365 för att logga in i Moodle.';
$string['ucp_index_aadlogin_inactive'] = 'För närvarande använder du inte Microsoft 365 för att logga in i Moodle';
$string['ucp_index_aadlogin_title'] = 'Microsoft 365-inloggning';
$string['ucp_index_calendar_desc'] = 'Här kan du konfigurera synkronisering mellan Moodle- och Outlook-kalendrarna. Du kan exportera Moodle-kalenderhändelser till Outlook och synkronisera Outlook-händelser till Moodle.';
$string['ucp_index_calendar_title'] = 'Synkroniseringsinställningar för Outlook-kalender';
$string['ucp_index_connection_desc'] = 'Ställ in hur du ansluter till Microsoft 365.';
$string['ucp_index_connection_title'] = 'Anslutningsinställningar för Microsoft 365';
$string['ucp_index_connectionstatus_connect'] = 'Klicka här för att ansluta.';
$string['ucp_index_connectionstatus_connected'] = 'Du är ansluten till Microsoft 365';
$string['ucp_index_connectionstatus_disconnect'] = 'Ta bort anslutning';
$string['ucp_index_connectionstatus_login'] = 'Klicka här för att logga in.';
$string['ucp_index_connectionstatus_manage'] = 'Hantera anslutning';
$string['ucp_index_connectionstatus_matched'] = 'Du har matchats med Microsoft 365-användaren <small>"{$a}"</small>. Klicka på länken nedan för att slutföra anslutningen och logga in i Microsoft 365.';
$string['ucp_index_connectionstatus_notconnected'] = 'Du är för närvarande inte ansluten till Microsoft 365';
$string['ucp_index_connectionstatus_reconnect'] = 'Uppdatera anslutning';
$string['ucp_index_connectionstatus_title'] = 'Anslutningsstatus';
$string['ucp_index_connectionstatus_usinglinked'] = 'Du är länkad till ett Microsoft 365 konto.';
$string['ucp_index_connectionstatus_usinglogin'] = 'Du använder för närvarande Microsoft 365 för att logga in i Moodle.';
$string['ucp_index_onenote_desc'] = 'Integrationen mot OneNote gör att du kan använda OneNote med Moodle. Du kan genomföra hemuppgifter med hjälp av OneNote och det gör det också lätt att föra anteckningar i dina kurser.';
$string['ucp_index_onenote_title'] = 'OneNote';
$string['ucp_notconnected'] = 'Vänligen anslut till Microsoft 365 innan du kommer hit.';
$string['ucp_o365accountconnected'] = 'Detta Microsoft 365 konto är redan länkat till ett annat Moodle-konto.';
$string['ucp_options'] = 'Alternativ';
$string['ucp_status_disabled'] = 'Ej ansluten';
$string['ucp_status_enabled'] = 'Aktiv';
$string['ucp_syncdir_both'] = 'Uppdatera både Outlook och Moodle';
$string['ucp_syncdir_in'] = 'Från Outlook till Moodle';
$string['ucp_syncdir_out'] = 'Från Moodle till Outlook';
$string['ucp_syncdir_title'] = 'Synkbeteende:';
$string['ucp_syncwith_title'] = 'Namn på Outlook-kalender att synkronisera med:';
$string['ucp_title'] = 'Kontrollpanel för Microsoft 365 / Moodle';
$string['webservices_error_assignnotfound'] = 'Det gick inte att hitta den mottagna modulens tilldelningspost.';
$string['webservices_error_couldnotsavegrade'] = 'Kunde inte spara betyg.';
$string['webservices_error_invalidassignment'] = 'Det går inte att använda det mottagna tilldelnings-ID:t med den här webbtjänstfunktionen.';
$string['webservices_error_modulenotfound'] = 'Det mottagna modul-ID:t kunde inte hittas.';
$string['webservices_error_sectionnotfound'] = 'Kursavsnittet hittades inte.';
$string['your_grade'] = 'Ditt betyg - {$a}';
$string['your_grade_class_grade'] = 'Ditt betyg - {$a->usergrade} &nbsp; |  &nbsp; Genomsnittligt betyg för klassen - {$a->classgrade}';
