<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'sv', version '3.11'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Åtgärder';
$string['activate'] = 'Aktivera tillgång';
$string['activatesuccess'] = 'Aktivering av tillgång till märken lyckades.';
$string['addalignment'] = 'Lägg till extern färdighet eller standard';
$string['addbackpack'] = 'Lägg till ryggsäck';
$string['addbadge'] = 'Lägg till märken';
$string['addbadge_help'] = 'Välj de märken som ska läggas till i kraven för att kunna få detta märke. Håll ner CTRL-tangenten för att välja flera.';
$string['addbadgecriteria'] = 'Lägg till märkeskriteria';
$string['addcohort'] = 'Lägg till kohort';
$string['addcohort_help'] = 'Välj de kohorter som ska läggas till kraven för att få detta märke. Håll ner CTRL-tangenten för att välja flera.';
$string['addcompetency'] = 'Lägg till kompetens';
$string['addcompetency_help'] = 'Välj de kompetenser som ska läggas till kraven för att få detta märke. Håll ner CTRL-tangenten för att välja flera.';
$string['addcourse'] = 'Lägg till kurser';
$string['addcourse_help'] = 'Välj de kurser som ska läggas till kraven för att få detta märke. Håll ner CTRL-tangenten för att välja flera.';
$string['addcriteria'] = 'Lägg till kriterier';
$string['addcriteriatext'] = 'För att börja lägga till kriterier, vänligen välj ett av alternativen i listrutan.';
$string['addedtobackpack'] = 'Märket lades till i ryggsäcken';
$string['addrelated'] = 'Lägg till relaterat märke';
$string['addtobackpack'] = 'Lägg till i ryggsäck';
$string['adminonly'] = 'Den här sidan är begränsad till enbart webbplatsadministratörer.';
$string['after'] = 'efter datum för utfärdande.';
$string['aggregationmethod'] = 'Aggregeringsmetod';
$string['alignment'] = 'Inriktning';
$string['all'] = 'Alla';
$string['allmethod'] = 'Alla de valda villkoren är uppfyllda';
$string['allmethodactivity'] = 'Alla de valda aktiviteterna är slutförda';
$string['allmethodbadges'] = 'Alla de valda märkena har erhållits';
$string['allmethodcohort'] = 'Medlemskap i alla valda kohorter';
$string['allmethodcompetencies'] = 'Alla valda kompetenser har slutförts';
$string['allmethodcourseset'] = 'Alla de valda kurserna är slutförda';
$string['allmethodmanual'] = 'Alla valda roller tilldelar märket';
$string['allmethodprofile'] = 'Alla de valda profilfälten har fyllts i';
$string['allowcoursebadges'] = 'Aktivera märken för kurser';
$string['allowcoursebadges_desc'] = 'Tillåt att märken skapas och tilldelas i kurser.';
$string['allowexternalbackpack'] = 'Extern anslutning till ryggsäck';
$string['allowexternalbackpack_desc'] = 'Om aktiverat kan användare ansluta till en extern ryggsäck och dela sina märken från den här webbplatsen. Användare kan också välja att visa alla offentliga märkessamlingar från sin externa ryggsäck på sin profilsida på denna webbplats. Vi rekommenderar att du lämnar det här alternativet inaktiverat om webbplatsen inte är tillgänglig från Internet.';
$string['any'] = 'Något';
$string['anymethod'] = 'Något av de valda villkoren är uppfyllt';
$string['anymethodactivity'] = 'Någon av de valda aktiviteterna är slutförd';
$string['anymethodbadges'] = 'Något av de valda märkena har erhållits';
$string['anymethodcohort'] = 'Medlemskap i någon av de valda kohorterna';
$string['anymethodcompetencies'] = 'Någon av de valda kompetenserna har slutförts';
$string['anymethodcourseset'] = 'Någon av de valda kurserna är slutförd';
$string['anymethodmanual'] = 'Någon av de valda rollerna tilldelar märket';
$string['anymethodprofile'] = 'Något av de valda profilfälten är ifyllt';
$string['apiversion'] = 'API-version som stöds';
$string['archivebadge'] = 'Vill du ta bort märket <strong>\'{$a}\'</strong> men behålla befintliga utdelade märken?';
$string['archiveconfirm'] = 'Ta bort och behåll befintliga utdelade märken';
$string['archivehelp'] = '<p>Detta alternativ betyder att märket kommer att markeras som "pensionerat" och därför inte längre kommer att synas i listan med märken. Användare kommer inte längre kunna erhålla detta märke. Befintliga mottagare av märket kommer dock kunna visa det i sin profil och de kommer att kunna ladda upp det till sin externa ryggsäck.<p>
<p>Om du vill att dina användare ska kunna behålla tillgången till sina intjänade märken är det viktigt att du väljer detta alternativ istället för att helt radera märkena.<p>';
$string['attachment'] = 'Bifoga märke till meddelande';
$string['attachment_help'] = 'Om ikryssad kommer ett utfärdat märke bifogas till mottagarens e-post för nedladdning. (Bilagor måste vara aktiverade under <em>Administrera webbplats / Server / E-post / Konfiguration av utgående E-post</em> för att denna funktion ska vara möjlig att använda.)';
$string['award'] = 'Tilldela märke';
$string['awardedto'] = 'Utfärdat till {$a}';
$string['awardedtoyou'] = 'Utfärdade till mig';
$string['awardoncron'] = 'Aktivering av åtkomst till märken lyckades. Det här märket kan omedelbart tas av för många användare, för att säkerställa webbplatsens prestanda så kommer denna åtgärd att ta lite tid att bearbeta.';
$string['awards'] = 'Mottagare';
$string['backpackapiurl'] = 'URL till ryggsäcks-API';
$string['backpackavailability'] = 'Extern verifikation av märke';
$string['backpackavailability_help'] = 'För att mottagare av märken ska ha möjlighet att bevisa att de tagit märken från er så måste en extern ryggsäcks-tjänst kunna komma åt er webbplats och verifiera märken som utfärdats från den. För tillfället verkar er webbplats inte vara tillgänglig, vilket betyder att märken som ni redan utfärdat, eller kommer utfärda i framtiden, inte kan verifieras.

**Varför ser jag det här meddelandet?

Det kan vara så att er brandvägg förhindrar åtkomst från användare utanför ert nätverk, att er webbplats är lösenordsskyddad eller att webbplatsen körs på en dator som inte är tillgänglig via Internet (som t.ex. en lokal utvecklingsmaskin).

**Är det här ett problem?

Du bör åtgärda det här problemet på alla produktionswebbplatser där ni planerar att utfärda märken, annars kommer mottagarna inte kunna bevisa att de tagit märken från er. Om er webbplats inte ännu är live så kan ni skapa och utfärda testmärken, så länge er webbplats är tillgänglig innan ni går live.

**Vad händer om jag inte kan göra hela webbplatsen publikt tillgänglig?

Den enda URL som krävs för verifikation är [din-webbplats-url]/badges/assertion.php så om du kan konfigurera din brandvägg för extern åtkomst till den filen så kommer verifikation av märken fortfarande fungera.';
$string['backpackbadgessettings'] = 'Ändra ryggsäcksinställningar';
$string['backpackbadgessummary'] = 'Du ser {$a->totalbadges} märken från {$a->totalcollections} samling(ar).';
$string['backpackcannotsendverification'] = 'Kan inte skicka e-post verifikation';
$string['backpackconnected'] = 'Ryggsäcken är ansluten';
$string['backpackconnection'] = 'Anslutning till ryggsäck';
$string['backpackconnection_help'] = 'Genom att ansluta till en ryggsäck kan du dela dina märken från den här webbplatsen och visa offentliga märkessamlingar från din ryggsäck på din profilsida på den här webbplatsen.';
$string['backpackconnectioncancelattempt'] = 'Anslut med en annan e-postadress';
$string['backpackconnectionconnect'] = 'Anslut till ryggsäck';
$string['backpackconnectionnottested'] = 'Anslutningen kan inte testas för denna ryggsäck eftersom enbart ryggsäckar som stödjer Open Badges v2.0 har stöd för detta.';
$string['backpackconnectionok'] = 'Anslutningen till ryggsäcken lyckades';
$string['backpackconnectionresendemail'] = 'Skicka om bekräftelsemejlet';
$string['backpackconnectionunexpectedmessage'] = 'Ryggsäcken returnerade felet: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Det gick inte att ansluta till ryggsäcken. Kontrollera autentiseringsuppgifterna och försök igen.';
$string['backpackdetails'] = 'Ryggsäcksinställningar';
$string['backpackdisconnected'] = 'Ryggsäcken är frånkopplad';
$string['backpackemail'] = 'E-postadress';
$string['backpackemail_help'] = 'E-postadressen som är kopplad till din ryggsäck. När du är ansluten kommer alla märken som erhålls på den här webbplatsen att associeras med den här e-postadressen.';
$string['backpackemailverificationpending'] = 'Väntar på bekräftelse';
$string['backpackemailverifyemailbody'] = 'Hej,

En ny anslutning till din ryggsäck med märken har begärts från \'{$a->sitename}\' med hjälp av din e-postadress.

För att bekräfta och aktivera anslutningen till din ryggsäck, vänligen gå till:

{$a->link}

I de flesta e-post program borde detta visas som en blå länk du kan klicka på. Om det inte går kan du itället klippa ut och klistra in adressen i adressfältet i din webbläsare.

Om du behöver hjälp kan du kontakta webbplatsen administratör,
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: E-postbekräftelse av märkesryggsäck';
$string['backpackemailverifypending'] = 'Ett bekräftelsemejl har skickats till <strong>{$a}</strong>. Klicka på bekräftelselänken för att aktivera anslutningen till din ryggsäck.';
$string['backpackemailverifysuccess'] = 'Tack för att du har bekräftat din e-postadress. Du är nu ansluten till din ryggsäck.';
$string['backpackemailverifytokenmismatch'] = 'Det token som angivits i den länk du klickade på matchar inte det sparade. Försäkra dig om att du klickade på länken i det senaste e-postmeddelandet du fick.';
$string['backpackexporterror'] = 'Kan inte exportera märket till ryggsäcken';
$string['backpackimport'] = 'Inställningar för märkesimport';
$string['backpackimport_help'] = 'Efter lyckad anslutning av ryggsäck så kan märken från din ryggsäck visas på din <em>Mina märken</em>-sida och din profilsida.

I detta område kan du välja samlingar av märken från din ryggsäck som du vill visa i din profil.';
$string['backpackneedsupdate'] = 'Ryggsäcken som anslutits till denna profil stämmer inte överens med ryggsäcken på webbplatsen. Du behöver koppla ifrån och ansluta ryggsäcken på nytt.';
$string['backpackprovider'] = 'Ryggsäckstjänsteleverantör';
$string['backpacksettings'] = 'Ryggsäcksinställningar';
$string['backpackweburl'] = 'URL till ryggsäck';
$string['badgedetails'] = 'Märkesdetaljer';
$string['badgeimage'] = 'Bild';
$string['badgeimage_help'] = 'Bilden ska vara minst 300 x 300 pixlar. Den visas som 300 x 300 pixlar på märkessidan och 100 x 100 pixlar på användarens profilsida.';
$string['badgeprivacysetting'] = 'Sekretessinställningar för märke';
$string['badgeprivacysetting_help'] = 'Märken som du tar kan visas på din profilsida. Den här inställningen tillåter dig att automatiskt ställa in synligheten på nyligen tagna märken.

Du kan fortfarande göra individuella sekretessinställningar för märken på din "Mina märken"-sida.';
$string['badgeprivacysetting_str'] = 'Visa automatiskt märken jag tagit på min profilsida';
$string['badges'] = 'Märken';
$string['badgesalt'] = 'Salt för att hasha mottagarens e-postadress';
$string['badgesalt_desc'] = 'Genom att använda en hash kan ryggsäckstjänster bekräfta märkesägaren utan att behöva avslöja dess e-postadress. Den här inställningen bör bara använda siffror och bokstäver.

För mottagarverifieringsändamål bör du undvika att ändra den här inställningen när du börjat utfärda märken.';
$string['badgesdisabled'] = 'Märken är inte aktiverade på den här webbplatsen.';
$string['badgesearned'] = 'Antal tagna märken: {$a}';
$string['badgesettings'] = 'Märkesinställningar';
$string['badgestatus_0'] = 'Ej tillgängligt';
$string['badgestatus_1'] = 'Tillgängligt';
$string['badgestatus_2'] = 'Ej tillgängligt (villkor låsta)';
$string['badgestatus_3'] = 'Tillgängligt (villkor låsta)';
$string['badgestatus_4'] = 'Arkiverade';
$string['badgestoearn'] = 'Antal tillgängliga märken: {$a}';
$string['badgesview'] = 'Märken för kurs';
$string['badgeurl'] = 'Länk till utfärdat märke';
$string['balignment'] = 'Inriktningar ({$a})';
$string['bawards'] = 'Mottagare ({$a})';
$string['bcriteria'] = 'Kriterier';
$string['bdetails'] = 'Redigera detaljer';
$string['bendorsement'] = 'Rekommendation';
$string['bmessage'] = 'Meddelande';
$string['boverview'] = 'Översikt';
$string['brelated'] = 'Relaterade märken ({$a})';
$string['bydate'] = 'slutför senast';
$string['claim'] = 'Rekommendation';
$string['claimcomment'] = 'Kommentar';
$string['claimid'] = 'URL till rekommendation';
$string['clearsettings'] = 'Rensa inställningar';
$string['completioninfo'] = 'Det här märket utfärdades för slutförandet av:';
$string['completionnotenabled'] = 'Slutförande av kurs är inte aktiverad för den här kursen så den kan inte inkluderas i kriterierna för märket. Slutförande av kurs kan aktiveras i inställningarna för kurser.';
$string['configenablebadges'] = 'Om aktiverad låter den här funktionen dig skapa märken och tilldela dem till användare på webbplatsen.';
$string['configuremessage'] = 'Märkesmeddelande';
$string['connect'] = 'Anslut';
$string['connected'] = 'Ansluten';
$string['connecting'] = 'Ansluter ...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'En e-postadress associerad med utfärdaren av märken.';
$string['copyof'] = 'Kopia av {$a}';
$string['course'] = 'Kurs: {$a}';
$string['coursebadges'] = 'Märken';
$string['coursebadgesdisabled'] = 'Märken för kurser är inte aktiverade på den här webbplatsen.';
$string['coursebadgetitle'] = '{$a}-kursmärke';
$string['coursecompletion'] = 'Användare måste slutföra den här kursen.';
$string['create'] = 'Nytt märke';
$string['createbutton'] = 'Skapa märke';
$string['creatorbody'] = '<p>{$a->user} har uppnått alla krav för märket och har tilldelats det. Visa det utfärdade märket via {$a->link} </p>';
$string['creatorsubject'] = '\'{$a} har tilldelats!';
$string['criteria_0'] = 'Det här märket tilldelas när...';
$string['criteria_1'] = 'Slutförande av aktivitet';
$string['criteria_1_help'] = 'Låter ett märke tilldelas en användare baserat på slutförandet av en uppsättning aktiviteter inom en kurs.';
$string['criteria_2'] = 'Manuellt utförande genom roll';
$string['criteria_2_help'] = 'Låter ett märke tilldelas manuellt av användare med en specifik roll inom webbplatsen eller kursen.';
$string['criteria_3'] = 'Social medverkan';
$string['criteria_3_help'] = 'Socialt';
$string['criteria_4'] = 'Slutförande av kurs';
$string['criteria_4_help'] = 'Låter ett märke tilldelas en användare som slutfört kursen. Det här kriteriet kan ha ytterligare parametrar som t.ex. lägst tillåtna betyg och datum för slutförande av kurs.';
$string['criteria_5'] = 'Slutförande av en uppsättning kurser';
$string['criteria_5_help'] = 'Låter ett märke tilldelas en användare som slutfört en uppsättning kurser. Varje kurs kan ha ytterligare parametrar som t.ex. lägst tillåtna betyg och datum för slutförande av kurs.';
$string['criteria_6'] = 'Ifyllnad av profil';
$string['criteria_6_help'] = 'Låter ett märke tilldelas en användare för att de fyllt i vissa fält i deras profil. Du kan välja bland de profilfält, standard och anpassade, som är tillgängliga för användarna.';
$string['criteria_7'] = 'Tilldelade märken';
$string['criteria_7_help'] = 'Tillåter utdelning av ett märke till användare baserat på andra märken de erhållit.';
$string['criteria_8'] = 'Medlemskap i kohort';
$string['criteria_8_help'] = 'Tillåter utdelning av ett märke till användare baserat på medlemskap i en kohort.';
$string['criteria_9'] = 'Kompetenser';
$string['criteria_9_help'] = 'Tillåter utdelning av ett märke till användare baserat på de kompetenser de uppnått.';
$string['criteria_descr'] = 'Användare tilldelas det här märket när de uppnått följande krav:';
$string['criteria_descr_0'] = 'Användare tilldelas det här märket när de uppnått <strong>{$a}</strong> av de listade kraven.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> av de följande aktiviteterna är slutförda:';
$string['criteria_descr_2'] = 'Det här märket behöver tilldelas av användare med <strong>{$a}</strong> av de följande rollerna:';
$string['criteria_descr_4'] = 'Användare måste slutföra kursen';
$string['criteria_descr_5'] = '<strong>{$a}</strong> av de följande kurserna måste slutföras:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> av de följande användarprofilfälten måste fyllas i:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> av följande märken måste erhållas:';
$string['criteria_descr_8'] = 'Medlemskap i <strong>{$a}</strong> av följande kohorter krävs:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> av följande kompetenser måste uppnås:';
$string['criteria_descr_bydate'] = 'senast <em>{$a}</em>';
$string['criteria_descr_grade'] = 'med lägst betyget <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Slutför <strong>{$a}</strong> av:';
$string['criteria_descr_short1'] = 'Slutför <strong>{$a}</strong> av:';
$string['criteria_descr_short2'] = 'Tilldelat genom <strong>{$a}</strong> av:';
$string['criteria_descr_short4'] = 'Slutför kursen';
$string['criteria_descr_short5'] = 'Slutför <strong>{$a}</strong> av:';
$string['criteria_descr_short6'] = 'Slutför <strong>{$a}</strong> av:';
$string['criteria_descr_short7'] = 'Slutför <strong>{$a}</strong> av:';
$string['criteria_descr_short8'] = 'Medlemskap i <strong>{$a}</strong> av följande kohorter:';
$string['criteria_descr_short9'] = 'Slutför <strong>{$a}</strong> av:';
$string['criteria_descr_single_1'] = 'Följande aktivitet måste slutföras:';
$string['criteria_descr_single_2'] = 'Det här märket behöver tilldelas av en användare med följande roll:';
$string['criteria_descr_single_4'] = 'Användare måste slutföra kursen';
$string['criteria_descr_single_5'] = 'Den följande kursen måste slutföras:';
$string['criteria_descr_single_6'] = 'Det följande användarprofilfältet måste fyllas i:';
$string['criteria_descr_single_7'] = 'Följande märke måste erhållas:';
$string['criteria_descr_single_8'] = 'Medlemskap i följande kohorter krävs:';
$string['criteria_descr_single_9'] = 'Följande kompetenser måste uppnås:';
$string['criteria_descr_single_short1'] = 'Slutför:';
$string['criteria_descr_single_short2'] = 'Tilldelad av:';
$string['criteria_descr_single_short4'] = 'Slutför kursen';
$string['criteria_descr_single_short5'] = 'Slutför:';
$string['criteria_descr_single_short6'] = 'Slutför:';
$string['criteria_descr_single_short7'] = 'Färdigt:';
$string['criteria_descr_single_short8'] = 'Medlemskap i:';
$string['criteria_descr_single_short9'] = 'Slutför:';
$string['criteriacreated'] = 'Skapandet av märkeskriterierna lyckades';
$string['criteriadeleted'] = 'Raderingen av märkeskriterierna lyckades';
$string['criteriasummary'] = 'Sammanfattning av kriterier';
$string['criteriaupdated'] = 'Uppdateringen av märkeskriterierna lyckades';
$string['criterror'] = 'Aktuella problem med parametrar';
$string['criterror_help'] = 'Den här fältuppsättningen visar alla parametrar som ursprungligen lades till i det här märkeskravet men som inte längre är tillgängliga. Vi rekommenderar att du avmarkerar dessa parametrar för att se till att användarna kan erhålla detta märke i framtiden.';
$string['currentimage'] = 'Aktuell bild';
$string['currentstatus'] = 'Aktuell status:';
$string['dateawarded'] = 'Utfärdandedatum';
$string['dateearned'] = 'Datum: {$a}';
$string['day'] = 'Dag(ar)';
$string['deactivate'] = 'Inaktivera åtkomst';
$string['deactivatesuccess'] = 'Inaktivering av åtkomst till märken lyckades.';
$string['defaultissuercontact'] = 'E-postadress till utfärdare av märket';
$string['defaultissuercontact_desc'] = 'En e-postadress som är kopplad till utfärdaren av märket. För en Open Badges v2.0-ryggsäck används denna för autentisering vid publicering av märken till en ryggsäck.';
$string['defaultissuername'] = 'Namn på utfärdare av märket';
$string['defaultissuername_desc'] = 'Namn på utfärdarombud eller -auktoritet.';
$string['defaultissuerpassword'] = 'Lösenord för märkesutfärdaren';
$string['defaultissuerpassword_help'] = 'Det krävs ett konto på webbplatsen för rycksäcken med den e-postadress som angivits under inställningen \'Kontaktuppgifter för standardutfärdaren av märken\'. Inställningen hittar du under Administration av webbplats / Märken / Inställningar för märken. Lösenordet för kontot ska anges här.';
$string['delbadge'] = 'Vill du ta bort märket \'{$a}\' och alla utfärdade märken?';
$string['delconfirm'] = 'Ta bort befintliga utfärdade märken';
$string['delcritconfirm'] = 'Är du säker på att du vill ta bort det här kriteriet?';
$string['deletehelp'] = '<p>Att fullständigt radera ett märke betyder att all information och kriterier associerade med märket tas bort permanent. Användare som tilldelats märket kommer inte längre ha tillgång till det eller möjlighet att visa det i sin profil.</p>
<p>OBS! Användare som tilldelats detta märke och som redan laddat upp det till sin externa ryggsäck kommer fortfarande ha tillgång till sitt märke. Dock kommer de inte längre ha tillgång till den information om utfärdande och intyg som lagrades på denna webbplats.</p>';
$string['delexternalbackpack'] = 'Radera webbplatsens ryggsäck';
$string['delexternalbackpackconfirm'] = 'Ta bort ryggsäcken <strong>\'{$a}\'</strong> från denna webbplats?';
$string['delparamconfirm'] = 'Är du säker på att du vill ta bort den här parametern?';
$string['description'] = 'Beskrivning';
$string['disconnect'] = 'Koppla från';
$string['donotaward'] = 'För närvarande är det här märket inte aktivt så det kan inte tilldelas användare. Om du skulle vilja tilldela det här märket, var god att aktivera dess status.';
$string['editsettings'] = 'Redigera inställningar';
$string['enablebadges'] = 'Aktivera märken';
$string['endorsement'] = 'Rekommendation';
$string['error:backpackdatainvalid'] = 'Den data som returnerades från ryggsäcken var ogiltig.';
$string['error:backpackemailnotfound'] = 'E-postadressen \'{$a}\' är inte ansluten till någon ryggsäck. Du behöver antingen i <a href="http://backpack.openbadges.org">skapa en ryggsäck </a> för detta e-postkonto eller logga in med en annan e-postadress.';
$string['error:backpacknotavailable'] = 'Din webbplats är inte tillgänlig via Internet så märken som utfärdats från den här webbplatsen kan inte verifieras av externa ryggsäcks-tjänster.';
$string['error:backpackproblem'] = 'Anslutningen till din ryggsäcktjänst misslyckades. Vänligen försök senare.';
$string['error:badgeawardnotfound'] = 'Detta märke kan inte verifieras. Möjligtvis har det återkallats.';
$string['error:badgenotfound'] = 'Märket kunde inte hittas';
$string['error:cannotact'] = 'Kan inte aktivera märket.';
$string['error:cannotawardbadge'] = 'Kan inte tilldela märke till en användare.';
$string['error:cannotdeletecriterion'] = 'Detta kriterium kan inte tas bort.';
$string['error:cannotrevokebadge'] = 'Kan inte återkalla märket från en användare.';
$string['error:clone'] = 'Kan inte klona märket.';
$string['error:connectionunknownreason'] = 'Anslutningen misslyckades, men orsaken angavs inte.';
$string['error:duplicatename'] = 'Ett märke med det namnet finns redan i systemet.';
$string['error:externalbadgedoesntexist'] = 'Märke ej hittat';
$string['error:guestuseraccess'] = 'Du är inloggad som gäst. För att kunna se märken behöver du logga in med ditt användarkonto.';
$string['error:invalidcriteriatype'] = 'Ogiltig kriterietyp.';
$string['error:invalidexpiredate'] = 'Förfallodatum måste vara i framtiden.';
$string['error:invalidexpireperiod'] = 'Förfallotid kan inte vara negativ eller noll.';
$string['error:invalidparambadge'] = 'Märket finns inte.';
$string['error:invalidparamcohort'] = 'Kohorten finns inte.';
$string['error:noactivities'] = 'Det finns inga aktiviteter med kriterier för slutförande som är aktiverade i den här kursen.';
$string['error:nobadges'] = 'Det finns för närvarande inga märken med åtkomst aktiverad för att läggas till som villkor. Ett webbplatsmärke kan bara ha andra platsmärken som kriterier. Ett kursmärke kan ha andra kursmärken eller platsmärken som kriterier.';
$string['error:nocohorts'] = 'Inga kohorter';
$string['error:nocourses'] = 'Slutförande av kurs är inte aktiverad för någon av webbplatsens kurser så därför kan inga visas. Slutförande av kurs kan aktiveras i inställningarna för kurser.';
$string['error:nogroupslink'] = '<p>Endast publika samlingar visas. <a href="{$a}" target="_blank" rel="nofollow">Besök din ryggsäck</a> för att skapa publika samlingar.</p>';
$string['error:nogroupssummary'] = '<p>Det finns inga publika samlingar av märken i din ryggsäck. </p>';
$string['error:nopermissiontoview'] = 'Du har inte rättigheter att visa mottagare av märken';
$string['error:nosuchbadge'] = 'Det finns inget märke med id {$a}.';
$string['error:nosuchcohort'] = 'Varning: Denna kohort är inte längre tillgänglig.';
$string['error:nosuchcourse'] = 'Varning: Den här kursen är inte längre tillgänglig.';
$string['error:nosuchfield'] = 'Varning: Det här användarprofilfältet är inte längre tillgängligt.';
$string['error:nosuchmod'] = 'Varning: Den här aktiviteten är inte längre tillgänglig.';
$string['error:nosuchrole'] = 'Varning: Den här rollen är inte längre tillgänglig.';
$string['error:nosuchuser'] = 'Användaren med den här e-postadressen har inget konto hos den aktuella ryggsäcks-leverantören.';
$string['error:notifycoursedate'] = 'Varning: Märken associerade med kursen och slutförande av aktiviteter kommer inte att utfärdas förrän kursens startdatum.';
$string['error:parameter'] = 'Varning: Minst en parameter måste väljas för att garantera ett korrekt arbetsflöde för utfärdande av märken.';
$string['error:relatedbadgedoesntexist'] = 'Det finns inget publikt märke med denna identifierare';
$string['error:requesterror'] = 'Begäran om anslutning misslyckades (felkod: {$a}).';
$string['error:requesttimeout'] = 'Tidsgränsen för begäran om anslutning överskreds innan den kunde slutföras.';
$string['error:save'] = 'Kan inte spara märket.';
$string['error:userdeleted'] = '{$a->user} (Denna användare finns inte längre på {$a->site})';
$string['eventbadgearchived'] = 'Märket har arkiverats';
$string['eventbadgeawarded'] = 'Märke tilldelat';
$string['eventbadgecreated'] = 'Märke skapat';
$string['eventbadgecriteriacreated'] = 'Kriterium för märke skapat';
$string['eventbadgecriteriadeleted'] = 'Kriterium för märket raderat';
$string['eventbadgecriteriaupdated'] = 'Kriterium för märket uppdaterat';
$string['eventbadgedeleted'] = 'Märke borttaget';
$string['eventbadgedisabled'] = 'Märke inaktiverat';
$string['eventbadgeduplicated'] = 'En kopia av märket har skapats';
$string['eventbadgeenabled'] = 'Märke aktiverat';
$string['eventbadgelistingviewed'] = 'Lista över märken visad';
$string['eventbadgerevoked'] = 'Märke återkallat';
$string['eventbadgeupdated'] = 'Märke uppdaterat';
$string['eventbadgeviewed'] = 'Märke visat';
$string['evidence'] = 'Bevis';
$string['existingrecipients'] = 'Befintliga märkesmottagare';
$string['existsinbackpack'] = 'Märket finns redan i ryggsäcken';
$string['expired'] = 'Förfallet';
$string['expiredate'] = 'Det här märket förfaller {$a}.';
$string['expireddate'] = 'Det här märket förföll {$a}.';
$string['expiredin'] = 'Giltigheten upphörde {$a}';
$string['expireperiod'] = 'Det här märket förfaller {$a} dag(ar) efter utfärdande.';
$string['expireperiodh'] = 'Det här märket förfaller {$a} timmar efter utfärdande.';
$string['expireperiodm'] = 'Det här märket förfaller {$a} minuter efter utfärdande.';
$string['expireperiods'] = 'Det här märket förfaller {$a} sekunder efter  utfärdande.';
$string['expiresin'] = 'Giltigheten upphör {$a}';
$string['expirydate'] = 'Förfallodatum';
$string['expirydate_help'] = 'Alternativt så kan märken förfalla på ett specifikt datum, eller så kan datumet beräknas baserat på datumet när märket utfärdades till en användare.';
$string['externalbadges'] = 'Mina märken från andra webbplatser';
$string['externalbadges_help'] = 'Den här arean visar märken från din externa ryggsäck.';
$string['externalbadgesp'] = 'Märken från andra webbplatser:';
$string['externalconnectto'] = 'För att visa externa märken så behöver du <a href="{$a}">ansluta till en ryggsäck</a>.';
$string['fixed'] = 'Fast datum';
$string['hidden'] = 'Dold';
$string['hiddenbadge'] = 'Tyvärr, ägaren av märket har inte gjort den här informationen tillgänglig.';
$string['hostedurl'] = 'Extern URL';
$string['hostedurldescription'] = 'Extern URL till märkets värdplats';
$string['imageauthoremail'] = 'E-postadress till bildens upphovsman';
$string['imageauthoremail_help'] = 'Om angiven visas e-postadressen till bildens upphovsman på sidan för märken.';
$string['imageauthorname'] = 'Namn på bildens upphovsman';
$string['imageauthorname_help'] = 'Om angivet visas namnet på bildens upphovsman på sidan för märken.';
$string['imageauthorurl'] = 'URL till bildens upphovsman.';
$string['imageauthorurl_help'] = 'Om angiven visas en länk till bildens upphovsmans webbplats på sidan för märken. URL:en ska ha prefixen http:// eller http://.';
$string['imagecaption'] = 'Bildtitel';
$string['imagecaption_help'] = 'Om bildtiteln angivits kommer denna visas på sidan för märken.';
$string['includeauthdetails'] = 'Inkludera autentiseringsuppgifter med ryggsäcken';
$string['invalidurl'] = 'Ogiltig URL';
$string['issuancedetails'] = 'Förfallodatum för märke';
$string['issuedbadge'] = 'Information för utfärdat märke';
$string['issuedby'] = 'Utfärdat av {$a}';
$string['issuedon'] = 'Utfärdat {$a}';
$string['issuerdetails'] = 'Utfärdare';
$string['issueremail'] = 'E-post';
$string['issueremail_help'] = 'E-postadress till den organisation som utfärdade rekommendationen.';
$string['issuername'] = 'Utfärdarens namn';
$string['issuername_endorsement'] = 'Namn';
$string['issuername_endorsement_help'] = 'Namn på den som utfärdar rekommendationen.';
$string['issuername_help'] = 'Namn på utfärdarombud eller -auktoritet.';
$string['issuerurl'] = 'Utfärdarens URL';
$string['issuerurl_help'] = 'Adressen till webbplatsen för den organisation som utfärdar rekommendationen. URL:en ska ha prefixen http:// eller http://.';
$string['language'] = 'Språk';
$string['language_help'] = 'Det språk som används på sidan för märken.';
$string['listbackpacks'] = 'Ryggsäckar';
$string['localbadges'] = 'Mina märken från {$a}-webbplatsen';
$string['localbadgesh'] = 'Mina märken från den här webbplatsen';
$string['localbadgesh_help'] = 'Alla märken som tagits inom den här webbplatsen genom att slutföra kurser, kursaktiviteter eller andra krav.

Du kan administrera dina märken här genom att göra dem publika eller privata för din profilsida.

Du kan ladda ned alla dina märken, eller varje märke separat, och spara dem på din dator. Nedladdade märken kan adderas till din externa ryggsäckstjänst.';
$string['localbadgesp'] = 'Märken från {$a}:';
$string['localconnectto'] = 'För att dela de här märkena utanför den här webbplatsen så behöver du <a href="{$a}">ansluta till en ryggsäck</a>.';
$string['makeprivate'] = 'Gör privat';
$string['makepublic'] = 'Gör publik';
$string['managebackpacks'] = 'Hantera ryggsäckar';
$string['managebadges'] = 'Hantera märken';
$string['message'] = 'Meddelandets brödtext';
$string['messagebody'] = '<p>Du har tilldelats märket "%badgename%"!</p>
<p>Mer information om det här märket kan du hitta på %badgelink%.</p>
<p>Du kan administrera och ladda ned märket från {$a}-sidan.</p>';
$string['messagesubject'] = 'Grattis! Du har just tagit ett märke!';
$string['method'] = 'Det här kriteriet är uppfyllt när...';
$string['mingrade'] = 'Lägsta betyg som krävs';
$string['month'] = 'Månad(er)';
$string['moredetails'] = 'Ytterligare detaljer';
$string['mybackpack'] = 'Mina ryggsäcksinställningar';
$string['mybadges'] = 'Mina märken';
$string['never'] = 'Aldrig';
$string['newbackpack'] = 'Lägg till en ny ryggsäck';
$string['newbadge'] = 'Lägg till nytt märke';
$string['newimage'] = 'Ny bild';
$string['noalignment'] = 'Det finns inga externa färdigheter eller standarder angivna för detta märke.';
$string['noawards'] = 'Det här märket har inte tagits ännu.';
$string['nobackpack'] = 'Ingen tjänst för ryggsäckar är ansluten till det här kontot.<br/>';
$string['nobackpackbadgessummary'] = 'Det finns inga märken i de valda samlingarna.';
$string['nobackpackcollectionssummary'] = 'Ingen märkessamling har valts.';
$string['nobackpacks'] = 'Det finns inga tillgängliga ryggsäckar.';
$string['nobadges'] = 'Det finns för närvarande inga märken tillgängliga för användare att erhålla.';
$string['nocompetencies'] = 'Inga kompetenser valda.';
$string['nocriteria'] = 'Kriterier för det här märket har inte konfigurerats ännu.';
$string['noendorsement'] = 'Detta märke har ingen rekommendation.';
$string['noexpiry'] = 'Det här märket har inget förfallodatum.';
$string['noparamstoadd'] = 'Det finns inga ytterligare parametrar tillgängliga att lägga till kraven för det här märket.';
$string['norelated'] = 'Detta märke har inga relaterade märken.';
$string['notacceptedrole'] = 'Din nuvarande rolltilldelning finns inte bland de roller som manuellt kan tilldela det här märket.<br/>
Om du skulle vilja se vilka användare som redan tagit det här märket så kan du besöka sidan {$a}.';
$string['notconnected'] = 'Inte ansluten';
$string['notealignment'] = 'Externa färdigheter eller standarder detta märke är inriktat mot kan anges här. Dessa visas på sidan för märken.';
$string['noteendorsement'] = 'En rekommendation från tredjepart kan användas för att addera värde till märket. Ett märke utfärdat av en lärare kan t.ex. vara rekommenderat av skolan, eller så kan ett märke utfärdat av en lokal utfärdarorganisation vara rekommenderat av den nationella utfärdarorganisationen.';
$string['noterelated'] = 'Märken som har en relation kan markeras som relaterade. T.ex. kan märken som bygger på samma kriterium, men som visas med olika språk markeras som relaterade. Relaterade märken visas på sidan för märken.';
$string['nothingtoadd'] = 'Det finns inga tillgängliga kriterier att lägga till.';
$string['notification'] = 'Notifiera skaparen av märket';
$string['notification_help'] = 'Den här inställningen administrerar notifieringarna som skickas till skaparen av ett märke för att låta dem veta att märket tilldelats.

Följande alternativ är tillgängliga:

* **ALDRIG** – Skicka inte notiser.

* **VARJE GÅNG** – Skicka en notis varje gång det här märket tilldelats.

* **DAGLIGEN** – Skicka notiser en gång per dag.

* **VECKOVIS** – Skicka notiser en gång per vecka.

* **MÅNADSVIS** – Skicka notiser en gång per månad.';
$string['notifydaily'] = 'Dagligen';
$string['notifyevery'] = 'Varje gång';
$string['notifymonthly'] = 'Månadsvis';
$string['notifyweekly'] = 'Veckovis';
$string['numawards'] = 'Det här märket har tilldelats <a href="{$a->link}">{$a->count}</a> användare.';
$string['numawardstat'] = 'Det här märket har tilldelats {$a} användare.';
$string['oauth2issuer'] = 'OAuth 2-tjänster';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['overallcrit'] = 'av de valda kriterierna är slutförda.';
$string['potentialrecipients'] = 'Potentiella mottagare av märket';
$string['preferences'] = 'Märkesinställningar';
$string['privacy:metadata:backpack'] = 'En förteckning över användarens ryggsäckar';
$string['privacy:metadata:backpack:backpackuid'] = 'Unik identifierare för ryggsäcken';
$string['privacy:metadata:backpack:email'] = 'E-postadress associerad med ryggsäcken';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Ryggsäckens ID';
$string['privacy:metadata:backpack:userid'] = 'ID för den användare vars ryggsäck det är';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2-information när en användare ansluter till en extern ryggsäck';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2-tjänsten ID';
$string['privacy:metadata:backpackoauth2:scope'] = 'Lista omfattning av ryggsäcksanslutning';
$string['privacy:metadata:backpackoauth2:token'] = 'Token för ryggsäcksanslutning';
$string['privacy:metadata:backpackoauth2:userid'] = 'Användar-ID för kopplingen till ryggsäcken';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Användar-ID för den som redigerade anslutningen';
$string['privacy:metadata:badge'] = 'En samling märken';
$string['privacy:metadata:badge:timecreated'] = 'Tidpunkten då märket skapades';
$string['privacy:metadata:badge:timemodified'] = 'Tidpunkten då märket senast ändrades';
$string['privacy:metadata:badge:usercreated'] = 'ID för användaren som skapade märket';
$string['privacy:metadata:badge:usermodified'] = 'ID för användaren som modifierade märket';
$string['privacy:metadata:criteriamet'] = 'En samling kriterier som har uppfyllts';
$string['privacy:metadata:criteriamet:datemet'] = 'Datum då kriteriumet uppfylldes';
$string['privacy:metadata:criteriamet:userid'] = 'Användar-ID för användaren som uppfyllde kriteriet';
$string['privacy:metadata:external:backpacks'] = 'Information som delas när användare skickar in sina märken till en extern ryggsäck';
$string['privacy:metadata:external:backpacks:badge'] = 'Märkets namn';
$string['privacy:metadata:external:backpacks:description'] = 'Beskrivningen av märket';
$string['privacy:metadata:external:backpacks:image'] = 'Bilden för märket';
$string['privacy:metadata:external:backpacks:issuer'] = 'Lite information om utfärdaren';
$string['privacy:metadata:external:backpacks:url'] = 'Moodle-URL:en till där information om det utfärdade märket kan ses';
$string['privacy:metadata:issued'] = 'En anteckning rörande de utfärdade märkena';
$string['privacy:metadata:issued:dateexpire'] = 'Datum då märket förfaller';
$string['privacy:metadata:issued:dateissued'] = 'Datum för utfärdande';
$string['privacy:metadata:issued:userid'] = 'Användare-ID för mottagaren av märket';
$string['privacy:metadata:manualaward'] = 'Anteckning om manuella utfärdanden';
$string['privacy:metadata:manualaward:datemet'] = 'Datum då användaren tilldelades märket';
$string['privacy:metadata:manualaward:issuerid'] = 'Användar-ID för utfärdaren av märket';
$string['privacy:metadata:manualaward:issuerrole'] = 'Roll för utfärdaren av märket';
$string['privacy:metadata:manualaward:recipientid'] = 'Användar-ID för den som manuellt utfärdade märket';
$string['recipientdetails'] = 'Mottagaredetaljer';
$string['recipientidentificationproblem'] = 'Kan inte hitta någon mottagare av detta märke bland befintliga användare.';
$string['recipients'] = 'Mottagare av märket';
$string['recipientvalidationproblem'] = 'Denna användare kan inte verifieras som mottagare av märket.';
$string['relatedbages'] = 'Relaterade märken';
$string['relative'] = 'Relativt datum';
$string['requiredbadge'] = 'Minst ett märke bör läggas till i märkeskriteriet.';
$string['requiredcohort'] = 'Minst en kohort bör läggas till i kohortkriteriet.';
$string['requiredcompetency'] = 'Minst en kompetens bör läggas till i kompetenskriteriet.';
$string['requiredcourse'] = 'Åtminstone en kurs måste läggas till kriteriet för uppsättningen kurser.';
$string['reviewbadge'] = 'Ändringar för märkesåtkomst';
$string['reviewconfirm'] = '<p>Detta gör ditt märke synligt för användarna och låter dem börja erhålla det.</p>
<p>Det är möjligt att vissa användare redan uppfyller detta märkes kriterier och kommer därför att tilldelas detta märke omedelbart efter att du aktiverar det.</p>
<p>När ett märke väl utfärdats kommer det att vara <strong>låst</strong> - vissa inställningar, inklusive kriterier och inställningar för förfallodatum, kan inte längre ändras.</p>
<p>Är du säker på att du vill aktivera åtkomst till märket \'{$a}\'?</p>';
$string['revoke'] = 'Återkalla märke';
$string['save'] = 'Spara';
$string['searchname'] = 'Sök via namn';
$string['selectaward'] = 'Välj rollen du skulle vilja använda för att tilldela det här märket:';
$string['selectgroup_end'] = 'Endast publika samlingar visas. <a href="{$a}">Gå till din ryggsäck</a> för att skapa fler publika samlingar.';
$string['selectgroup_start'] = 'Välj samlingar från din ryggsäck att visa på den här webbplatsen:';
$string['selecting'] = 'Med valda märken...';
$string['setup'] = 'Konfigurera anslutning';
$string['sitebackpack'] = 'Aktiv extern ryggsäck';
$string['sitebackpack_help'] = 'Den externa ryggsäck som användare kan ansluta till från denna webbplats. Observera att om denna inställning ändras efter det att användare har anslutit sina ryggsäckar kommer det att krävas att varje användare går till sina ryggsäcksinställningar och förnyar kopplingen.';
$string['sitebackpackdeleted'] = 'Webbplatsens ryggsäck har tagits bort.';
$string['sitebackpacknotdeleted'] = 'Den här ryggsäcken kunde inte tas bort eftersom den för närvarande är webbplatsens standardryggsäck';
$string['sitebackpackverify'] = 'Ryggsäcksanslutning';
$string['sitebackpackwarning'] = 'Kunde inte ansluta till ryggsäck. <br/><br/> Kontrollera att inställningen "Märkesutfärdarens e-postadress" är ett giltigt konto på webbplatsen för ryggsäcken. <br/><br/> Kontrollera att "Märkesutfärdarens lösenord" på <a href="{$a->url}">sidan för märkesinställningar</a> är rätt lösenord för kontot på ryggsäckens webbplats. <br/><br/> Ryggsäcken returnerade: "{$a->warning}"';
$string['sitebadges'] = 'Märken för webbplatsen';
$string['sitebadges_help'] = 'Märken för webbplatsen kan enbart tilldelas användare för aktiviteter som rör webbplatsen. Det kan inkludera slutförandet av en uppsättning kurser eller delar av användarprofiler. Märken för webbplatser kan också tilldelas manuellt av en användare till en annan.

Märken för kursrelaterade aktiviteter måste skapas på kursnivå. Märken för kurser hanteras under <em>Administrera kurs &#10132; Märken</em>.';
$string['sitebadgetitle'] = '{$a}-webplatsmärke';
$string['status'] = 'Status';
$string['status_help'] = 'Statusen för ett märke avgör dess beteende i systemet:

* **TILLGÄNGLIGT** – Betyder att märket kan tas av användarna. Om ett märke är tillgängligt kan dess kriterier inte ändras.

* **INTE TILLGÄNGLIGT** – Betyder att märket inte är tillgängligt för användarna och det kan därför inte tas eller manuellt tilldelas. Så länge märket aldrig tilldelats någon kan dess kriterier ändras.

Så snart ett märke tilldelats åtminstone en användare blir det automatiskt **LÅST**. Låsta märken kan fortfarande tas av användare men deras kriterier kan inte längre ändras. Om du behöver ändra detaljer eller kriterier för ett låst märke kan du duplicera märket och göra ändringarna på kopian.

*Varför låses märken?*

Ett märke låses för att säkerställa att alla användare uppfyller samma krav när de tar ett märke. För närvarande är det inte möjligt att återkalla märken. Om det vore tillåtet att kraven för märken ändrades när som helst skulle det sannolikt till slut uppstå en situation där olika användare innehar samma märke, men att de uppfyllt helt olika krav för att erhålla det.';
$string['statusmessage_0'] = 'För närvarande är det här märket inte tillgängligt för användarna. Aktivera tillgång om du vill att det här märket ska kunna tas.';
$string['statusmessage_1'] = 'För närvarande är det här märket tillgängligt för användare. Inaktivera tillgång för att göra ändringar.';
$string['statusmessage_2'] = 'För närvarande är det här märket inte tillgängligt för användare och dess kriterier är låsta. Aktivera tillgång om du vill att användare ska kunna ta det här märket.';
$string['statusmessage_3'] = 'För närvarande är det här märket tillgängligt för användare och dess kriterier är låsta.';
$string['statusmessage_4'] = 'För närvarande är det här märket arkiverat.';
$string['subject'] = 'Meddelanderubrik';
$string['targetcode'] = 'Kod';
$string['targetcode_help'] = 'En unik strängidentifierare som refererar till den externa färdigheten eller standarden inom dess ramverk.';
$string['targetdescription'] = 'Beskrivning';
$string['targetdescription_help'] = 'Kort beskrivning av den externa färdigheten eller standarden.';
$string['targetframework'] = 'Ramverk';
$string['targetframework_help'] = 'Namnet på den externa färdigheten eller standardramverket.';
$string['targetname'] = 'Namn';
$string['targetname_help'] = 'Den externa färdighet eller standard som märket är i linje med.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'En länk till en sida som beskriver den externa färdigheten eller standarden. Webbadressen ska ha ett prefix http:// eller https://.';
$string['testbackpack'] = 'Testa ryggsäcken \'{$a}\'';
$string['testsettings'] = 'Testa inställningar';
$string['type'] = 'Typ';
$string['variablesubstitution'] = 'Variabelersättning i meddelanden.';
$string['variablesubstitution_help'] = 'I ett märkesmeddelande kan vissa variabler läggas in i ämnesraden och/eller brödtexten så att de kan ersättas med riktiga värden när meddelandet sänds. Variablerna ska infogas i texten exakt som de visas nedan. Följande variabler kan användas:

%badgename%
:   Det här kommer ersättas av märkets fullständiga namn.

%username%
:   Det här kommer ersättas av mottagarens fullständiga namn.

%badgelink%
:   Det här kommer ersättas av den publika URL som leder till information om det utfärdade märket.';
$string['version'] = 'Version';
$string['version_help'] = 'Versionsfältet kan användas för att hålla reda på märkets utveckling. Om det anges visas versionen på sidan för märket.';
$string['viewbadge'] = 'Visa utfärdat märke';
$string['visible'] = 'Synlig';
$string['warnexpired'] = '(Det här märket har förfallit!)';
$string['year'] = 'År';
