<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'certificate', language 'sr_cr', version '3.11'.
 *
 * @package     certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addlinklabel'] = 'Додај још једну опцију повезане активности';
$string['addlinktitle'] = 'Кликните како бисте додалиј још једну опцију повезане активности';
$string['areaintro'] = 'Уводни део сертификата';
$string['awarded'] = 'Додељено';
$string['awardedto'] = 'Додељује се полазнику';
$string['back'] = 'Назад';
$string['border'] = 'Бордура';
$string['borderblack'] = 'Црна';
$string['borderblue'] = 'Плава';
$string['borderbrown'] = 'Браон';
$string['bordercolor'] = 'Линије бордуре';
$string['bordercolor_help'] = 'С обзиром да слике могу значајно повећати величину pdf датотеке, можете одабрати штампање бордуре од линија уместо слике (проверите да је опција \'Слика бордуре\' подешена на "Не"). Опција \'\'Линије бордуре\' ће штампати лепу бордуру састављену од три линија различитих дебљина у одабраној боји.';
$string['bordergreen'] = 'Зелена';
$string['borderlines'] = 'Линије';
$string['borderstyle'] = 'Слика бордуре';
$string['borderstyle_help'] = 'Опција \'Слика бордуре\' вам даје могућност да изаберете слику бордуре серифтиката из директоријума certificate/pix/borders. Изаберите слику коју желите да буде на ивицама сертификата, или изаберите опцију \'без бордуре\'.';
$string['certificate'] = 'Потврда кôда сертификата';
$string['certificate:addinstance'] = 'Додај инстанцу сертификата';
$string['certificate:manage'] = 'Управљање инстанцом сертификата';
$string['certificate:printteacher'] = 'Бити наведен као предавач на сертификату ако је укључено подешавање за штампање имена предавача';
$string['certificate:student'] = 'Преузми сертификат';
$string['certificate:view'] = 'Прикажи сертификат';
$string['certificatename'] = 'Назив сертификата';
$string['certificatereport'] = 'Извештај о сертификатима';
$string['certificatesfor'] = 'Сертификати за';
$string['certificatetype'] = 'Тип сертификата';
$string['certificatetype_help'] = 'Ово је место где можете одредити графички изглед сертификата. Директоријум са типовима сертификата садржи четири стандардна сертификата:
\'А4 уграђено\' штампа сертификат на папиру А4 формата са уграђеним фонтовима.
\'А4 не-уграђено\' штампа сертификат на папиру А4 формата без уграђених фонтова.
\'Писмо уграђено\' штампа сертификат на папиру у формату писма са уграђеним фонтовима.
\'Писмо не-уграђено\' штампа сертификат на папиру у формату писма без уграђених фонтова.

Неуграђени типови користе фонтове Helvetica и Times Ако мислите да ваши корисници немају ове фонтове на свом рачунару, или ако ваш језик користи знакове или симболе који нису прилагођени за наведене фонтове, онда изаберите уграђени тип. Уграђени типови користе фонтове Dejavusans и Dejavuserif. С обзиром да је овако креирана .pdf датотека прилично велика, уграђени тип се не препоручује, па га користите само ако морате.

Директоријуми нових типова сертификата могу да се додају директоријуму certificate/type. У том случају, језичкој датотеци сертификата морају се додати назив директоријума и сви нови језички стрингови за нови тип сертификата.';
$string['certify'] = 'Овим се потврђује да је';
$string['code'] = 'Кôд';
$string['completiondate'] = 'Завршетак курса';
$string['course'] = 'За';
$string['coursegrade'] = 'Оцена на курсу';
$string['coursename'] = 'Курс';
$string['coursetimereq'] = 'Неопходан број минута проведених на курсу';
$string['coursetimereq_help'] = 'Унесите овде минимум времена, у минутима, које студент мора да проведе на курсу пре него што буде могао да добије сертификат.';
$string['credithours'] = 'Број кредита (бодова) у сатима';
$string['customtext'] = 'Прилагођени текст';
$string['customtext_help'] = 'Ако желите да на сертификату одштампате име предавача које је различито од имена онога коме је на курсу била додељена улога предавача, онда немојте изабрати опцију \'Штампај име предавача\', нити слику потписа, осим слике линије. У ово поље за текст унесите имена предавача, онако како желите да се она појаве на сертификату. Стандардно, овај текст се смешта у доњи леви угао сертификата. Доступнe су следеће HTML ознаке: &lt;br&gt;, &lt;p&gt;, &lt;b&gt;, &lt;i&gt;, &lt;u&gt;, &lt;img&gt; (ознаке src и width (или height) су обавезне), <a> (ознака href је обавезна), <font> (могући атрибути су: color, (hex color code), face, (arial, times, courier, helvetica, symbol)).';
$string['date'] = 'Dana';
$string['datefmt'] = 'Формат датума';
$string['datefmt_help'] = 'Изаберите формат у којем ће бити одштампан датум на сертификату, или, изаберите последњу опцију како би датум био одштампан у формату корисниковог изабраног језика.';
$string['datehelp'] = 'Датум';
$string['deletissuedcertificates'] = 'Обриши издате сертификате';
$string['delivery'] = 'Достава сертификата';
$string['delivery_help'] = 'Изаберите овде како желите да ваши студенти добију сертификат.
Отвори у веб читачу: отвара сертификат у новом прозору веб читача.
Обавезно преузимање: отвара прозор читача за преузимање датотеке.
Пошаљи сертификат е-поштом: ако је изабрана ова опција сертификат се шаље студенту као прилог е-поруци. Након што корисник добије свој сертификат, уколико кликне на линк сертификата на насловној страници курса, видеће датум када је добио сертификат и моћи ће да га прегледа.';
$string['designoptions'] = 'Опције за дизајн';
$string['download'] = 'Обавезно преузимање';
$string['emailcertificate'] = 'Пошаљи сертификат е-поштом (такође мора изабрати сачувај!)';
$string['emailothers'] = 'Пошаљи е-поштом другима';
$string['emailothers_help'] = 'Унесите оведе електронске адресе, раздвојене зарезом, оних које треба обавестити електронско поштом сваки пут када студенти добију сертификат.';
$string['emailstudenttext'] = 'У прилогу је Ваш сертификат за курс {$a->course}.';
$string['emailteachermail'] = '{$a->student} је примио свој сертификат: \'{$a->certificate}\' за курс {$a->course}.

Можете га прегледати овде:

{$a->url}';
$string['emailteachermailhtml'] = '{$a->student} је примио свој сертификат: \'<i>{$a->certificate}</i>\' за курс {$a->course}.

Можете га прегледати овде:

<a href="{$a->url}">Извештај о сертификату</a>.';
$string['emailteachers'] = 'Пошаљи е-пошту предавачима';
$string['emailteachers_help'] = 'Ако је ова опција омогућена, онда ће предавачи бити обавештени е-поштом сваки пут када студенти добију сертификат';
$string['entercode'] = 'Унеси кôд сертификата за потврду:';
$string['getcertificate'] = 'Преузмите свој сертификат';
$string['grade'] = 'Оцена';
$string['gradedate'] = 'Датум оцењивања';
$string['gradefmt'] = 'Формат оцене';
$string['gradefmt_help'] = 'Ако желите да на сертификату одштампате оцену постоје три доступна формата:

Процентуална оцена: штампа оцену као проценат.
Бодовна оцена: штампа оцену као број бодова.
Словна оцена: штампа оцену као слово.';
$string['gradeletter'] = 'Словна оцена';
$string['gradepercent'] = 'Процентуална оцена';
$string['gradepoints'] = 'Бодовна оцена';
$string['imagetype'] = 'Тип слике';
$string['incompletemessage'] = 'Да бисте преузели свој сертификат, прво морате завршити све обавезне активности. Молимо вас да се вратите на курс и завршите своје обавезе на курсу.';
$string['intro'] = 'Увод';
$string['issued'] = 'Издат';
$string['issueddate'] = 'Датум издавања';
$string['issueoptions'] = 'Опције за издавање';
$string['landscape'] = 'Положена страница';
$string['lastviewed'] = 'Последњи пут сте добили сертификат дана:';
$string['letter'] = 'Писмо';
$string['lockingoptions'] = 'Опције за закључавање';
$string['modulename'] = 'Сертификат';
$string['modulename_link'] = 'Certificate_module';
$string['modulenameplural'] = 'Сертификати';
$string['mycertificates'] = 'Моји сертификати';
$string['nocertificates'] = 'Не постоје сертификати';
$string['nocertificatesissued'] = 'Не постоје сертификати који су издати';
$string['nocertificatesreceived'] = 'није добило/ла ниједан сертификат.';
$string['nofileselected'] = 'Морате изабрати датотеку за постављање';
$string['nogrades'] = 'Нема доступних оцена';
$string['notapplicable'] = 'Није применљиво';
$string['notfound'] = 'Број сертификата није било могуће потврдити.';
$string['notissued'] = 'Није издат';
$string['notissuedyet'] = 'Још није издат';
$string['notreceived'] = 'Још нисте добили овај сертификат';
$string['openbrowser'] = 'Отвори у новом прозору';
$string['opendownload'] = 'Кликните доње дугме да бисте сачували сертификат на свом рачунару';
$string['openemail'] = 'Кликните доње дугме и сертификат ће Вам бити послат као прилог е-поруци.';
$string['openwindow'] = 'Кликните доње дугме да бисте отворили сертификат у новом прозору веб читача';
$string['or'] = 'или';
$string['orientation'] = 'Оријентација';
$string['orientation_help'] = 'Изаберите да ли желите да оријентација сертификата буде усправна и положена';
$string['pluginadministration'] = 'Администрација сертификата';
$string['pluginname'] = 'Сертификат';
$string['portrait'] = 'Усправна страница';
$string['printdate'] = 'Штампај датум';
$string['printdate_help'] = 'Ово је датум који ће бити одштампан ако изаберете опцију \'Штампај датум\'. У случају да је изабран датум завршетка курса, а студент курс није завршио, биће одштампан датум добијања серtификата. Такође, можете да изаберете да као датум буде одштампан дан када је активност оцењена. Ако се сертификат издаје пре оцењивања активности, биће одштампан датум добијања сертификата.';
$string['printerfriendly'] = 'Страница прилагођена за штампање';
$string['printgrade'] = 'Штампај оцену';
$string['printgrade_help'] = 'Можете да изаберете било коју доступну ставку из књиге оцена како бисте ту оцену штампали на сертификату, Ставке оцена поређане су истом редоследом којим се појављују у књизи оцена. Изаберите формат оцене доле.';
$string['printhours'] = 'Штампај број кредита (бодова)';
$string['printhours_help'] = 'Упишите овде број кредита (бодова) које треба одштампати на сертификату';
$string['printnumber'] = 'Штампај кôд';
$string['printnumber_help'] = 'На сертификату ће бити одштампан јединствен кôд од 10 насумично одабраних слова и бројева. Овај број може бити потврђен упоређивањем са кôдним бројем који се приказуује у извештају о сертификату.';
$string['printoutcome'] = 'Штампај исход';
$string['printoutcome_help'] = 'Можете да изаберете било који исход курса како бисте на сертификату одштампали назив исхода и резултат који је студент/корисник постигао. На пример: Исход задатака: Одличан (Вешт).';
$string['printseal'] = 'Печат или слика логотипа';
$string['printseal_help'] = 'Ова опција вам омогућава да из директоријума certificate/pix/seals изаберете печат или логотип који ће бити одштампан на сертификату. Стандардно, ова слика се смешта у доњи десни угао сертификата.';
$string['printsignature'] = 'Слика потписа';
$string['printsignature_help'] = 'Ова опција вам омогућава да на сертификату одштампате слику потписа из директоријума certificate/pix/signatures. Можете да штампате графички приказ потписа, или да штампате линију за својеручни потпис. Стандардно, ова слика се смешта у доњи леви угао сертификата.';
$string['printteacher'] = 'Штампај име(на) предавача';
$string['printteacher_help'] = 'За штампање имена предавача на сертификату подесите улогу предавача на нивоу модула. Урадите ово уколико, на пример, имате више од једног предавача на курсу, или ако имате више од једног сертификата и желите да штампате различита имена предавача на сваком сертификату. Кликните да бисте уредили сертификат, а затим кликните на картицу \'Локално додељене улоге\'. Затим доделите улогу предавача за сертфикат (ови корисници НЕ МОРАЈУ да буду предавачи на нивоу курса - тј. улогу можете доделити било ком кориснику). Ова имена биће одштампана на сертификату.';
$string['printwmark'] = 'Слика воденог жига';
$string['printwmark_help'] = 'Датотека са воденим жигом може бити постављена у позадину сертификатa. Водени жиг представља избледелу верзија графике. Као жиг се може користи лого, печат, грб, текст или било шта што желите да користите као графичку позадину.';
$string['receivedcerts'] = 'Добијени сертификати';
$string['receiveddate'] = 'Датум добијања';
$string['reissuecert'] = 'Поново издај сертификате';
$string['reissuecert_help'] = 'Ако овде изаберете \'Да\'. онда ће овај сертификат бити поново издат са новим датумом, оценом и кодним бројем сваки пут када корисник кликне на линк за сертификат. Напомена: иако ће табела приказати претходне датуме добијања сертификата, корисницима неће бити доступно дугме за преглед. У извештају о сертификату ће се појавити само последњи издати сертификат.';
$string['removecert'] = 'Издати сертификовати су уклоњени';
$string['report'] = 'Извештај';
$string['reportcert'] = 'Извештај о сертификатима';
$string['reportcert_help'] = 'Ако овде изаберете \'Да\', онда ће овај датум добијања сертификата, кôдни број и назив курса бити приказани у извештају о сертификатима корисника. Ако изаберете да штампате оцену на овом сертификату, онда ће и та оцена бити приказана у извештају.';
$string['requiredtimenotmet'] = 'Да бисте могли да приступите овом сертификату морате да проведете најмање {$a->requiredtime} минута на курсу.';
$string['requiredtimenotvalid'] = 'Неопходно време мора да буде исправан број већи од 0';
$string['reviewcertificate'] = 'Прегледајте свој сертификат';
$string['savecert'] = 'Сачувај сертификат';
$string['savecert_help'] = 'Ако изаберете ову опцију. онда ће копија сваке .pdf датотеке сертификата бити сачувана у директоријуму moddata одговарајућег курса. У извештају о сертификату биће приказан линк ка сваком сачуваном сертификату корисника.';
$string['seal'] = 'Печат';
$string['sigline'] = 'линија';
$string['signature'] = 'Потпис';
$string['statement'] = 'је завршио/ла курс';
$string['summaryofattempts'] = 'Резиме раније добијених сертификата';
$string['textoptions'] = 'Опције за текст';
$string['title'] = 'СЕРТИФИКАТ ПОСТИГНУЋА';
$string['to'] = 'Додељује се полазнику';
$string['typeA4_embedded'] = 'A4 уграђено';
$string['typeA4_non_embedded'] = 'A4 не-уграђено';
$string['typeletter_embedded'] = 'Писмо уграђено';
$string['typeletter_non_embedded'] = 'Писмо не-уграђено';
$string['unsupportedfiletype'] = 'Датотека мора да буде у  jpeg или png формату';
$string['uploadimage'] = 'Постави слику';
$string['uploadimagedesc'] = 'Ово дугме ће вас одвести на нови екран где ћете моћи да поставите слике';
$string['userdateformat'] = 'Датум у формату језика корисника';
$string['validate'] = 'Потврди';
$string['verifycertificate'] = 'Потврди сертификат';
$string['viewcertificateviews'] = 'Погледај {$a} издатa/их сертификата';
$string['viewed'] = 'Овај сертификат добили сте дана:';
$string['viewtranscript'] = 'Погледај сертификате';
$string['watermark'] = 'Водени жиг';
