<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_foundation', language 'es_mx', version '3.11'.
 *
 * @package     theme_foundation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminlayout'] = 'Administrador';
$string['alertdanger'] = 'Peligro';
$string['alertdark'] = 'Oscuro';
$string['alertinfo'] = 'Información';
$string['alertlight'] = 'Claro';
$string['alertpage'] = 'Página {$a->number} de alerta';
$string['alertpagedesc'] = 'Mostrar alerta {$a->number} en la página dada o \'Todasl\'.';
$string['alertprimary'] = 'Primaria';
$string['alertsecondary'] = 'Secundaria';
$string['alertsettingheading'] = 'Configuraciones de alerta {$a->number}';
$string['alertsheading'] = 'Configuraciones de alerta';
$string['alertsheadingdesc'] = 'Ajustar las cnfiguraciones de alerta';
$string['alertsuccess'] = 'Éxito';
$string['alerttext'] = 'Texto de alerta {$a->number}';
$string['alerttextdesc'] = 'Texto para alerta {$a->number}';
$string['alerttitle'] = 'Título de alerta {$a->number}';
$string['alerttitledesc'] = 'Título para alerta {$a->number}. Si el título está vacío no se mostrará,pero cualquier texto si se mostrará.';
$string['alerttype'] = 'Típo de alerta {$a->number}';
$string['alerttypedesc'] = 'Configurar el tipo de alerta apropiado para mejor informar a sus usuarios.';
$string['alertwarning'] = 'Advertencia';
$string['asconfigintlower'] = '{$a->value} es menos que el límite inferior del rango de {$a->lower}';
$string['asconfigintnan'] = '{$a->value} no es un número';
$string['asconfigintupper'] = '{$a->value} es mayor que el  límite superior del rango de {$a->upper}';
$string['backtotop'] = 'Regresar a superior';
$string['baselayout'] = 'Base';
$string['brandiconname'] = 'Nombre del ícono {$a->number} de la marca';
$string['brandiconnamedesc'] = 'Nombre del ícono para la marca {$a->number}';
$string['brandiconurl'] = 'URL del ícono {$a->number} de la marca';
$string['brandiconurldesc'] = 'URL para ícono de la marca {$a->number} a';
$string['brandsettingheading'] = 'Configuraciones de la marca {$a->number}';
$string['brandsheading'] = 'Configuraciones de los íconos de la marca';
$string['brandsheadingdesc'] = 'Configurar las configuraciones del ícono de marca.  El  \'nombre\' del ícono de la marca es  - este es el nombre FontAwesome sin el prefijo \'fa-\' por lo que por ejemplo \'fa-train\' simplemente se vuelve \'train\'.  Dependiendo de la configuración \'fav\' para habilitar el uso de FontAwsome 5, por favor vea \'<a href="//fontawesome.com/icons?d=gallery&s=brands&m=free" target="_blank">fontawesome.com/icons?d=gallery&s=brands&m=free</a>\'si está activado y \'<a href="//fontawesome.com/v4.7.0/icons/#brand" target="_blank">fontawesome.com/v4.7.0/icons/#brand</a>\' en caso que no estuviera, para el nombre del ícono.  El tema hará el resto con los nombres de las clases.';
$string['cachedef_foundationfontawesomeiconmapping'] = 'Cachear íconos de Font Awesome';
$string['choosereadme'] = '<div class="clearfix">
<h2>Foundation (Fundación)</h2>
<h3>Acerca de</h3>
<p>Foundation es un tema básico.</p>
<h3>Créditos del tema</h3>
<p>Author: G J Barnard<br>
Contacto: <a href="http://moodle.org/user/profile.php?id=442195">Moodle profile</a><br>
Website: <a href="http://about.me/gjbarnard">about.me/gjbarnard</a>
</p>
<h3>Más información</h3>
<p><a href="foundation/Readme.md">Como usar este tema.</a></p>
</div></div>';
$string['closedrawer'] = 'Cerrar cajón';
$string['configtabtitle'] = 'Configuraciones';
$string['configtitle'] = 'Foundation (Fundación)';
$string['coursecategorylayout'] = 'Categoría del curso';
$string['courseendblocksperrow'] = 'Bloques por fila Fin del curso';
$string['courseendblocksperrowdesc'] = 'Número de bloques por fila al usar la región de bloque horizontal \'Fin del curso\'. Nota: Al editarlos, todos los bloques serán del mismo tamaño para facilitar su uso.';
$string['courselayout'] = 'Curso';
$string['coursesmenuheadingdesc'] = 'Configurar aquí los ajustes para el menú de cursos de Foundation.';
$string['coursesmenuheadingsub'] = 'Configuraciones del menú de cursos';
$string['customscss'] = 'SCSS personalizado';
$string['customscssdesc'] = 'Añadir SCSS personalizado al tema.';
$string['displayhiddenmycourses'] = 'Mostrar cursos ocultos';
$string['displayhiddenmycoursesdesc'] = 'Mostrar cursos ocultos para usuarios en el \'Menú de cursos\' si ellos tienen permiso para ver cursos ocultos';
$string['displaymycourses'] = 'Mostrar cursos';
$string['displaymycoursesdesc'] = 'Mostrar cursos inscritos para usuarios en la \'Barra de Navegación\'.';
$string['displaythiscourse'] = 'Mostrar menú \'Este curso\'';
$string['displaythiscoursedesc'] = 'Mostrar el menú \'Este curso\' en la \'Barra de Navegación en un curso.';
$string['embeddedlayout'] = 'Incrustado';
$string['enablealert'] = 'Alerta {$a->number} habilitar';
$string['enablealertdesc'] = 'Habilitar o deshabilitar alerta {$a->number}.';
$string['enablebrand'] = 'Habilitar marca {$a->number}';
$string['enablebranddesc'] = 'Habilitar o deshabilitar marca {$a->number}';
$string['fa5name'] = 'FontAwesome 5 Free';
$string['fa6name'] = 'FontAwesome 6 Free';
$string['faiv'] = 'Calzas gratuitas v4 para FontAwesome';
$string['faivdesc'] = 'Cuando se use FontAwesome Free para los íconos, añadir soporte para nombres de clase 4 de íconos.';
$string['fav'] = 'FontAwesome 5 o 6 Free';
$string['favdesc'] = 'Use FontAwesome 5 o 6 Free para íconos.  Nota: Por favor vea la licencia en la carpeta fonts del tema.';
$string['favicon'] = 'Favicon personalizado';
$string['favicondesc'] = 'Subir su propio favicon. Debería de ser un archivo .ico.';
$string['favoff'] = 'Desactivado';
$string['featuresheading'] = 'Destacados';
$string['featuresheadingdesc'] = 'Configurar aquí los ajustes para las características de Foundation.';
$string['featuresheadingsub'] = 'Configuraciones de Destacados';
$string['footerantigravityhorizontaloffset'] = 'Sesgo horizontal anti-gravedad de pantalla';
$string['footerantigravityhorizontaloffsetdesc'] = 'Configurar el sesgo horizontal de los botones anti-gravedad en la pantalla (no en Barra de Navegación) diferente del predeterminado. Esto puede ser un número positivo (mover a la derecha) o negativo (mover a la izquierda) . Las unidades son pixeles. Nota: Invierta esta lógica para idiomas que se escriben de-derecha-a-izquierda.';
$string['footerantigravityverticaloffset'] = 'Sesgo vertical anti-gravedad de pantalla';
$string['footerantigravityverticaloffsetdesc'] = 'Configurar el sesgo vertical de los botones anti-gravedad en la pantalla (no en Barra de Navegación) diferente del predeterminado. Esto puede ser un número positivo (mover hacia abajo) o negativo (mover hacia arriba) . Las unidades son pixeles.';
$string['frametoplayout'] = 'Superiordelmarco';
$string['frontpagecarouselheading'] = 'Carrusel de la Portada';
$string['frontpagecarouselheadingdesc'] = 'Configurar aquí los ajustes para el carrusel de la Portada de Foundation.';
$string['frontpagecarouselheadingsub'] = 'Configuraciones de carrusel de Portada';
$string['frontpagecarouselslides'] = 'Imágenes de la Portada';
$string['frontpagecarouselslidesdesc'] = 'Número de imágenes de portada entre {$a->lower} y {$a->upper}. Después de cambiar y \'Guardar cambios\', refresque la página.';
$string['frontpageenableslide'] = 'Imagen {$a->number} de portada habilitar';
$string['frontpageenableslidedesc'] = 'Habilitar o deshabilitar imagen {$a->number} de portada.';
$string['frontpagelayout'] = 'PáginaInicial';
$string['frontpageslidecaption'] = 'Subtítulo de imagen  {$a->number} de Portada';
$string['frontpageslidecaptiondesc'] = 'Subtítulo para imagen {$a->number} de portada.';
$string['frontpageslideimage'] = 'Imagen {$a->number} de portada';
$string['frontpageslideimagedesc'] = 'Imagen para imagen {$a->number} de portada';
$string['frontpageslideno'] = 'Imagen {$a->number} de Portada';
$string['frontpageslidenodesc'] = 'Ingresar las configuraciones para imagen {$a->number} de Portada.';
$string['frontpageslidetitle'] = 'Título de imagen {$a->number} de Portada';
$string['frontpageslidetitledesc'] = 'Título para la imagen {$a->number} de Portada.';
$string['frontpageslideurl'] = 'Enlace de imagen{$a->number} de Portada';
$string['frontpageslideurldesc'] = 'Ingrese el destino del enlace de imagen de imagen {$a->number} de Portada';
$string['generalheading'] = 'General';
$string['generalheadingdesc'] = 'Configurar las configuraciones generales para Fundation aquí.';
$string['generalheadingsub'] = 'Configuraciones generales';
$string['generalmenuheadingdesc'] = 'Configurar aquí las configuraciones generales del menú para Foundation.';
$string['generalmenuheadingsub'] = 'General';
$string['gotobottom'] = 'Ir al fondo de la página';
$string['header'] = 'Encabezado';
$string['headerbackground'] = 'Fondo del Encabezado';
$string['headerbackgroundbottomcolour'] = 'Color del botón del Fondo del Encabezado';
$string['headerbackgroundbottomcolourdesc'] = 'Configurar el color del texto para la parte baja del encabezado cuando hay un fondo. Escriba \'-\' para ignorar esta configuración.';
$string['headerbackgroundbottomopacity'] = 'Opacidad del botón del Fondo del Encabezado';
$string['headerbackgroundbottomopacitydesc'] = 'Opacidad de la parte más baja del fondo del encabezado cuando hay una imagen de fondo. El color está configurado por la variable SCSS \'body-bg\'.';
$string['headerbackgrounddesc'] = 'Imagen del Fondo del Encabezado.';
$string['headerbackgroundposition'] = 'Posición del Fondo del Encabezado';
$string['headerbackgroundpositiondesc'] = 'Seleccionar la posición para la imagen subida.';
$string['headerbackgroundstyle'] = 'Estilo del Fondo del Encabezado.';
$string['headerbackgroundstyledesc'] = 'Seleccionar el estilo para la imagen subida.';
$string['headerbackgroundtopcolour'] = 'Color superior del fondo del encabezado';
$string['headerbackgroundtopcolourdesc'] = 'Configurar el color del texto para la parte superior del encabezado cuando hay un fondo. Escriba  \'-\' para ignorar esta configuración.';
$string['headerbackgroundtopopacity'] = 'Opacidad superior del fondo del encabezado';
$string['headerbackgroundtopopacitydesc'] = 'Opacidad superior del fondo del encabezado cuando hay una imagen de fondo. El color está configurado por la variable SCSS \'body-bg\'.';
$string['headerdesc'] = 'Descripción del encabezado';
$string['headerheading'] = 'Encabezado';
$string['headerheadingdesc'] = 'Configurar aquí los ajustes del encabezado para Foundation.';
$string['headerheadingsub'] = 'Configuraciones del encabezado';
$string['headerlangmenu'] = 'Menú de idiomas del encabezado';
$string['headerlangmenudesc'] = 'Configurar los diseños de página en donde usted quiere que se muestre el menú de idiomas.  Use la tecla \'Ctrl\' para seleccionar a más de uno.  Notas:  La lógica Estándar de Moodle podría evitar que se muestre el menú de idiomas, en cuyo caso esta configuración no tendrá efecto. Configure los valores predeterminados en el archivo \'config.php\' del tema; por ejemplo,  "\'options\' => array(\'langmenu\' => true)" para el diseño dado.';
$string['hvpcustomcss'] = 'CSS Personalizado para H5P';
$string['hvpcustomcssdesc'] = 'CSS Personalizado para el módulo H5P';
$string['hvpfontcss'] = 'CSS de Font H5P';
$string['hvpfontcssdesc'] = 'CSS del font para el módulo H5P. Ponga las declaraciones de cara al font (\'font-face\') aquí usando la sintaxis \'font:theme\' de Moodle para la URL y asegúrese de que el archivo del font esté dentro de la carpeta de font del tema. Después, aplique con declaraciones \'font-family\' CSS en las configuraciones de CSS personalizado.';
$string['hvpheading'] = 'H5P';
$string['hvpheadingdesc'] = 'Configurar aquí las configuraciones H5P para Foundation. Estas configuraciones solamente tendrán efecto si el módulo H5P  (moodle.org/plugins/mod_hvp) está instalado.';
$string['hvpheadingsub'] = 'Configuraciones de H5P';
$string['incourselayout'] = 'En curso';
$string['informationheading'] = 'Información';
$string['loginbackground'] = 'Imagen del fondo de la página de ingreso al sitio';
$string['loginbackgrounddesc'] = 'Suba su propia imagen del fondo de página para ingreso. Seleccione el estilo de la imagen debajo.';
$string['loginbackgroundheading'] = 'Configuraciones para imagen del fondo de página para ingreso';
$string['loginbackgroundheadingdesc'] = 'Configurar los ajustes de la imagen del fondo para página de ingreso al sitio.';
$string['loginbackgroundopacity'] = 'Opacidad de fondo de caja para ingresar';
$string['loginbackgroundopacitydesc'] = 'Opacidad de fondo del ingreso para la caja de ingreso cuando hay una imagen de fondo.';
$string['loginbackgroundstyle'] = 'Estilo del fondo para página para ingreso';
$string['loginbackgroundstyledesc'] = 'Seleccionar el estilo para imagen subida';
$string['loginlayout'] = 'Ingresar (iniciar sesión)';
$string['love'] = 'amor';
$string['maintenancelayout'] = 'Mantenimiento';
$string['marketingblocksperrow'] = 'Bloques publicitarios por fila';
$string['marketingblocksperrowdesc'] = 'Número de bloques por fila al usar la región de bloque \'Publicidad\' horizontal. Nota: Al editarla, todos los bloques serán del mismo tamaño para facilitar su uso.';
$string['menusheading'] = 'Menúes';
$string['moduleheading'] = 'Módulo';
$string['moduleheadingdesc'] = 'Configurar las configuraciones del módulo para Fundation aquí.';
$string['moduleheadingsub'] = 'Configuraciones del módulo';
$string['myclasses'] = 'Mis clases';
$string['mycourses'] = 'Mis cursos';
$string['mycoursesmax'] = 'Máx cursos';
$string['mycoursesmaxdesc'] = 'Configurar cuantos cursos deberían de ser enlistados entre {$a->lower} y {$a->upper} donde \'{$a->lower}\' representa a todos.';
$string['mycoursesorder'] = 'Orden de cursos';
$string['mycoursesorderdesc'] = 'Configurar como deberían ser ordenados los cursos. El orden de ordenamiento de cursos puede ser configurado por la configuración de navegación del núcleo \'navsortmycoursessort\'.';
$string['mycoursesorderenrolbackcolour'] = 'Color del fondo para curso inscrito y no accesado';
$string['mycoursesorderenrolbackcolourdesc'] = 'El color del fondo para cursos inscritos pero no accedidos. para cuando \'mycourseorder\' está configurado a \'Último accedido...\'.';
$string['mycoursesorderid'] = 'ID del curso';
$string['mycoursesorderidasc'] = 'Ascendente';
$string['mycoursesorderiddes'] = 'Descendente';
$string['mycoursesorderidorder'] = 'Ordenamiento de ID del curso';
$string['mycoursesorderidorderdesc'] = 'Orden de ID de curso cuando \'ID de curso\' está configurado como el \'Orden de ordenamiento del curso\'.';
$string['mycoursesorderlast'] = 'Último momento de acceso o la fecha de inicio de la inscripción si nunca ha accedido';
$string['mycoursesordersort'] = 'Ordenamiento para curso';
$string['mycoursetitle'] = 'Terminología';
$string['mycoursetitledesc'] = 'Cambiar la terminología para el título del menú de "Mis cursos" . Cuando \'mycoursesorder\' está configurado a \'Último accesado...\' entonces serán añadidas las palabras \'más reciente(s)\'.';
$string['mydashboardlayout'] = 'Mi Tablero';
$string['mylatestclasses'] = 'Mis clases más recientes';
$string['mylatestcourses'] = 'Mis cursos más recientes';
$string['mylatestmodules'] = 'Mis módulos más recientes';
$string['mylatestunits'] = 'Mis unidades más recientes';
$string['mymodules'] = 'Mis módulos';
$string['mypubliclayout'] = 'Mi público';
$string['myunits'] = 'Mis unidades';
$string['navbarmenus'] = 'Menús de Barra de Navegación';
$string['navbarposition'] = 'Posición de Barra de Navegación';
$string['navbarpositiondesc'] = 'Configurar la Posición de la Barra de Navegación.';
$string['navbarstyle'] = 'Estilo de Barra de Navegación';
$string['navbarstyledark'] = 'Oscuro';
$string['navbarstyledesc'] = 'Claro u Oscuro.';
$string['navbarstylelight'] = 'Claro';
$string['noenrolments'] = 'Usted no tiene inscripciones vigentes';
$string['numberofalerts'] = 'Alertas';
$string['numberofalertsdesc'] = 'Número de alertas entre {$a->lower} y {$a->upper}. Después de cambiar elija \'Guardar cambios\' para obtener el número que configuró.';
$string['numberofbrands'] = 'Marcas';
$string['numberofbrandsdesc'] = 'Número de marcas entre {$a->lower} y {$a->upper}.  Después de cambiarlo, haga clic en \'Guardar cambios\' para obtener el número que configuró.';
$string['opendrawer'] = 'Abrir cajón';
$string['pluginname'] = 'Foundation (Fundación)';
$string['popuplayout'] = 'Emergente';
$string['prescss'] = 'Pre SCSS';
$string['prescssdesc'] = 'Ponga el SCSS que debería de usarse antes de que cualquier SCSS sea añadido al tema.';
$string['printlayout'] = 'Imprimir';
$string['privacy:metadata:preference:collapseblock'] = 'El estado de los bloques en una página';
$string['privacy:metadata:preference:drawerclosed'] = 'El estado del cajón.';
$string['privacy:request:preference:collapseblock'] = 'La preferencia del usuario "{$a->name}" para bloque id "{$a->blockid}" tiene el valor "{$a->value}" que representa "{$a->decoded}" para el estado del bloque.';
$string['privacy:request:preference:drawerclosed'] = 'La preferencia del usuario para "{$a->name}" tiene el valor "{$a->value}" lo cual representa "{$a->decoded}" para el estado del cajón.';
$string['privacynote'] = 'Nota: El tema  Foundation tiene ajustes que tienen que ver con su configuración. Las configuraciones epecíficas del usuario están descritas en el \'Registro de privacidad del plugin\'. Para las otras configuraciones, es responsabilidad de Usted  el asegurarse de que no se ingresen datos del usuario en ninguno de los campos de texto libre. El ajustar una configuración resultará en que esa acción se registre en bitácoras dentro del sistema de bitácoras de Moodle contra el usuario que la ajustó; esto está fuera del control de los temas. Por favor vea el sistema de bitácoras del núcleo para el cumplimiento de privacidad para esto. Cuando se suban imágenes, Usted debería de evitar subir imágenes con datos de ubicación incrustados (EXIF GPS) incluidos o algunos otros datos personales. Sería posible extraer cualquier dato de ubicación / personal. Por favor examine el código cuidadosamente para asegurarse de que cumple con su interpretación de las leyes de privacidad. Yo no soy abogado y mi análisis está basado en mi interpretación. Si Usted tiene cualquier duda entonces quite el tema de inmediato.';
$string['properties'] = 'Configuraciones para importar / exportar';
$string['propertiesdesc'] = 'En esta sección Usted puede importar / exportar configuraciones actuales del tema Foundation (propiedades) en formato JSON. Usted también puede ver todas las configuraciones actuales en esta instalación Moodle.';
$string['propertiesexport'] = 'Exportar propiedades como una cadena de caracteres JSON';
$string['propertiesproperty'] = 'Propiedad';
$string['propertiesreturn'] = 'Regresar';
$string['propertiessub'] = 'Configuraciones actuales del tema';
$string['propertiesvalue'] = 'Valor';
$string['putpropertiesadded'] = 'Añadido:';
$string['putpropertieschanged'] = 'Cambiado:';
$string['putpropertiesdesc'] = 'Pegar la cadena de caracteres JSON y \'Guardar cambios\'. ¡ Advertencia !  Esto no valida los valores de configuración y realiza una acción para \'Purgar todas las cachés\'.';
$string['putpropertiesfrom'] = 'desde';
$string['putpropertiesheading'] = 'Configuraciones de importación del tema';
$string['putpropertiesignorecti'] = 'Ignorar todas las configuraciones de imagendel título del curso.';
$string['putpropertiesignored'] = 'Ignorado:';
$string['putpropertiesname'] = 'Importar propiedades';
$string['putpropertiesreportfiles'] = 'Recordar subir los archivos siguientes a sus configuraciones:';
$string['putpropertiessettingsreport'] = 'Reporte de configuraciones:';
$string['putpropertiesunchanged'] = 'Sin cambios:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Nuestro';
$string['putpropertyproperties'] = 'Propiedades';
$string['putpropertyreport'] = 'Reporte:';
$string['putpropertyversion'] = 'versión:';
$string['region-content'] = 'Contenido';
$string['region-courseend'] = 'Fin del Curso';
$string['region-drawer'] = 'Cajón';
$string['region-marketing'] = 'Mercadotecnia';
$string['region-poster'] = 'Poster';
$string['region-side-post'] = 'Izquierda';
$string['region-side-pre'] = 'Derecha';
$string['reportlayout'] = 'Reporte';
$string['securelayout'] = 'Seguro';
$string['standardlayout'] = 'Estándar';
$string['stylebottom'] = 'Fondo';
$string['stylecenter'] = 'Centro';
$string['stylecontain'] = 'Contiene';
$string['stylecover'] = 'Cubierta';
$string['styleleft'] = 'Izquierda';
$string['styleright'] = 'Derecha';
$string['stylestretch'] = 'Estirar';
$string['styletop'] = 'Superior';
$string['swatch'] = 'Swatch';
$string['swatchcustomcolour'] = 'color {$a}';
$string['swatchcustomcolourdesc'] = 'Configurar el color {$a}.  Escribir \'-\' para ignorar esta configuración.';
$string['swatchcustomcolours'] = 'Colores personalizados de swatch';
$string['swatchcustomcoloursdesc'] = 'Activar configuraciones personalizadas de color de swatch.';
$string['swatchcustomcoloursheading'] = 'Colores personalizados de swatch';
$string['swatchcustomcoloursheadingdesc'] = 'Configurar aquí las configuraciones personalizadas de color de swatch para Foundation.';
$string['swatchcustomcoloursheadingsub'] = 'Configuraciones personalizadas de color de swatch';
$string['swatchcustomfontsizebase'] = 'BAse de tamaño del Font';
$string['swatchcustomfontsizebasedesc'] = 'Configurar eltamaño base del Font como un número. Las unidades son internamente \'rem\'.';
$string['swatchcustomlineheightbase'] = 'Base de altura de linea';
$string['swatchcustomlineheightbasedesc'] = 'Configurar la altura de linea base como un número.';
$string['swatchcustomtypography'] = 'Tipografía personalizada de swatch';
$string['swatchcustomtypographydesc'] = 'Activar configuraciones de tipografía personalizada.';
$string['swatchcustomtypographyheading'] = 'Tipografía personalizada de swatch';
$string['swatchcustomtypographyheadingdesc'] = 'Configurar aquí las configuraciones tipográficas personalizadas de swatch para Foundation.';
$string['swatchcustomtypographyheadingsub'] = 'Configuraciones personalizadas tipográficas de swatch';
$string['swatchdesc'] = 'Elegir el swatch para el tema. Un \'Swatch\' es una manera de cambiar la apariencia del tema usando una lista de pre-configuraciones de definiciones a la que Usted anexa un nombre. Todos los swatches (exceptuando \'Seventies\' que yo he creado) son de \'Bootswatch.com\' y están licenciados bajo la \'MIT License\'. Nota: Los Google font CDN\'s han sido eliminados debido a limitaciones con el compilador PHP SCSS y yo no quiero tener las complicaciones de actualizar también la privacidad.';
$string['swatchheading'] = 'Swatch';
$string['swatchheadingdesc'] = 'Configurar aquí las configuraciones de swatch para Foundation.';
$string['swatchheadingsub'] = 'Configuraciones de swatch';
$string['syntaxhighlightheading'] = 'Configuraciones de resaltado de sintaxis';
$string['syntaxhighlightheadingdesc'] = 'Configurar las configuraciones de resaltado de sintaxis';
$string['syntaxhighlightremoved'] = 'Resaltado de sintaxis eliminado';
$string['syntaxhighlightremoveddesc'] = 'La funcionalidad del resaltado de sintaxis en Foundation ha sido quitada.  Por favor use el filtro \'<a href="https://moodle.org/plugins/filter_synhi" target="_blank">SynHi</a>\' como un sustituto.';
$string['themechanges'] = 'Cambios';
$string['themereadme'] = 'Léame';
$string['themesupport'] = 'Soporte';
$string['thiscourse'] = 'Este curso';
$string['thiscoursemenuheadingdesc'] = 'Configurar aquí las configuraciones para el menú \'Este curso\' de Foundation.';
$string['thiscoursemenuheadingsub'] = 'Configuraciones del menú de Este curso';
$string['trio'] = 'Tres columnas';
$string['triodesc'] = 'Usar tres columnas en lugar de dos en páginas de dos columnas. El área del bloque del cajón no cuenta como una \'columna\' en esta terminología. Nota: Cuando se cambia esta configuración, la(s) región(es) de bloque podrían verse extrañas hasta que la página sea refrescada.';
$string['urltarget'] = 'Destino del enlace';
$string['urltargetdesc'] = 'Elegir como debería abrirse el enlace';
$string['urltargetnew'] = 'Página nueva';
$string['urltargetparent'] = 'Marco paterno';
$string['urltargetself'] = 'Página actual';
$string['usermenulogouturl'] = 'URL para salir del menú del usuario';
$string['usermenulogouturldesc'] = 'Configurar una URL personalizada para el elemento \'Salir\' del menú del usuario. Dejar vacío para el predeterminado del sistema. Cuando se configura, solamente funcionará si Foundation no está instalado en  $CFG->themedir.';
$string['versionalpha'] = 'Versión alfa - Casi seguramente contiene errores. ¡Esta es una versión en desarrollo solamente apta para desarrolladores! ¡Ni de chiste se le ocurra pensar en instalarla en un servidor en producción!';
$string['versionbeta'] = 'Versión beta - Probablemente contiene errores. Listo para probarse por administradores solamente en un servidor de prueba.';
$string['versioninfo'] = 'Liberación {$a->release}, versión {$a->version} en Moodle {$a->moodle}.  Hecho con {$a->love} en Gran Bretaña.';
$string['versionrc'] = 'Versión candidato  a liberación - Podría contener errores. Compruebe completamente en un servidor de pruebas antes de instalar en su servidor de producción.';
$string['versionstable'] = 'Versión estable - Podría contener errores. Compruebe en un servidor de pruebas antes de instalar en su servidor de producción.';
