<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_generator', language 'sr_lt', version '3.11'.
 *
 * @package     tool_generator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bigfile'] = 'Velika datoteka {$a}';
$string['courseexplanation'] = 'Ovo ima za cilj da obezbedi standardizovano merilo za proveru pouzdanosti
i performanse različitih komponenti sistema (kao što je kreiranje rezervne kopije i njeno restauriranje).

Ovaj test je važan zato što je prethodno bilo mnogo slučajeva gde sistem, suočen sa upotrebom u realnim situacijama (npr. kurs sa 1, 000 aktivnosti), nije radio.

Kursevi kreirani pomoću ovog alata mogu da zauzmu veliki deo baze podataka i prostora za smeštaj datoteka (desetine gigabajta). Moraćete da obrišete kurseve (i sačekate da različiti alati za čišćenja budu pokrenuti) kako biste ponovo oslobodite ovaj prostor.

**Nemojte koristiti ovaj alat na produkcionom serveru**.
Koristite ga isključivo na razvojnom serveru.
(Da bi se izbeglo slučajno korišćenje, ovaj alat je onemogućen, osim ako u sistemu poruka za otklanjanje grešaka niste  izabrali opciju RAZVOJNE.)';
$string['coursesize_0'] = 'XS (~10KB; kreiraj za ~1 sekund)';
$string['coursesize_1'] = 'S (~10MB; kreiraj za ~30 sekundi)';
$string['coursesize_2'] = 'M (~100MB; kreiraj za ~2 minuta)';
$string['coursesize_3'] = 'L (~1GB; kreiraj za ~30 minuta)';
$string['coursesize_4'] = 'XL (~10GB; kreiraj za ~2 sata)';
$string['coursesize_5'] = 'XXL (~20GB; kreiraj za ~4 sata)';
$string['coursewithoutusers'] = 'Izabrani kursevi nemaju korisnike';
$string['createcourse'] = 'Kreiraj kurs';
$string['createtestplan'] = 'Kreiraj plan testiranja';
$string['creating'] = 'Kreira se kurs';
$string['done'] = 'urađeno ({$a})';
$string['downloadtestplan'] = 'Preuzmi plan testiranja';
$string['downloadusersfile'] = 'Preuzmi korisničke datoteke';
$string['error_nocourses'] = 'Ne postoje kursevi za generisanje pkana testiranja';
$string['error_noforumdiscussions'] = 'Izabrani kurs ne sadrži diskusije na forumima';
$string['error_noforuminstances'] = 'Izabrani kurs ne sadrži instance modula "Forum"';
$string['error_noforumreplies'] = 'Izabrani kurs ne sadrži odgovore na forumima';
$string['error_nonexistingcourse'] = 'Navedeni kurs ne postoji';
$string['error_nopageinstances'] = 'Izabrani kurs ne sadrži instance modula "Stranica"';
$string['error_notdebugging'] = 'Nije dostupno na ovom serveru jer sistem poruka za otklanjanje grešaka nije postavljen na opciju RAZVOJNE';
$string['error_nouserspassword'] = 'Potrebno je da u  datoteci config.php podesite $CFG->tool_generator_users_password za generisanje plana testiranja';
$string['fullname'] = 'Probni kurs: {$a->size}';
$string['maketestcourse'] = 'Napravi probni kurs';
$string['maketestplan'] = 'Napravi JMeter plan testiranja';
$string['notenoughusers'] = 'Izabrani kurs nema dovoljan broj korisnika';
$string['pluginname'] = 'Generator razvojnih podataka';
$string['privacy:metadata'] = 'Dodatak Generator razvojnih podataka ne čuva nikakve lične podatke.';
$string['progress_checkaccounts'] = 'Proveravaju se korisnički nalozi ({$a})';
$string['progress_coursecompleted'] = 'Kurs je završen ({$a}s)';
$string['progress_createaccounts'] = 'Kreiraju se korisnički nalozi ({$a->from} - {$a->to})';
$string['progress_createassignments'] = 'Kreiraju se zadaci ({$a})';
$string['progress_createbigfiles'] = 'Kreiraju se velike datoteke ({$a})';
$string['progress_createcourse'] = 'Kreira se kurs {$a}';
$string['progress_createforum'] = 'Kreira se forum ({$a} poruka)';
$string['progress_createpages'] = 'Kreiraju se stranice ({$a})';
$string['progress_createsmallfiles'] = 'Kreiraju se male datoteke ({$a})';
$string['progress_enrol'] = 'Upisuju se korisnici na kurs ({$a})';
$string['progress_sitecompleted'] = 'Sajt je završen ({$a}s)';
$string['shortsize_0'] = 'XS';
$string['shortsize_1'] = 'S';
$string['shortsize_2'] = 'M';
$string['shortsize_3'] = 'L';
$string['shortsize_4'] = 'XL';
$string['shortsize_5'] = 'XXL';
$string['sitesize_0'] = 'XS (~10MB; 3 kursa, kreiran za ~30 sekundi)';
$string['sitesize_1'] = 'S (~50MB; 8 kurseva, kreiran za ~2 minuta)';
$string['sitesize_2'] = 'M (~200MB; 73 kursa, kreiran za ~10 minuta)';
$string['sitesize_3'] = 'L (~1\'5GB; 277 kurseva, kreiran za ~1\'5 sat)';
$string['sitesize_4'] = 'XL (~10GB; 1065 kurseva, kreiran za ~5 sati)';
$string['sitesize_5'] = 'XXL (~20GB; 4177 kurseva, kreiran za ~10 sati)';
$string['size'] = 'Veličina kursa';
$string['smallfiles'] = 'Male datoteke';
$string['targetcourse'] = 'Testiraj ciljni kurs';
$string['testplanexplanation'] = 'Ovaj alat kreira JMeter datoteku sa planom testiranja zajedno sa datotekom sa korisničkim imenima i lozinkama.

Ovaj plan testiranja je dizajniran tako da radi zajedno sa {$a}, koji olakšava da se test pokrene u specifičnom Moodle okruženju, prikupe informacije o pokrenutim testiranjima, kao i da se uporede rezultati. Zato će biti potrebno da ga preuzmete i upotrebite njegov skript test_runner.sh ili da pratite uputstva o instalaciji i korišćenju.

Potrebno je da podesite lozinku za korisnike kursa u datoteci config.php (npr. $CFG->tool_generator_users_password = \'moodle\';). Kako bi se sprečila nenamerna upotreba alata, ne postoji standardna vrednost za ovu lozinku. Potrebno je da koristite opciju za ažuriranje lozinki u slučaju da korisnici vašeg kursa imaju druge lozinke ili u slučaju da su lozinke kreirane pomoću alata tool_generator, ali bez podešavanja vrednosti $CFG->tool_generator_users_password.

Alat je deo tool_generatora tako da dobro radi sa kursevima koji su kreirani pomoću generatora sajta i kurseva. Takođe, alat se može koristiti sa bilo kojim kursom koji sadrži barem:

* Dovoljan broj upisanih korisnika (zavisno od veličine plana testiranja koji izaberete) sa lozinkom resetovanom na  \'moodle\'
* Instancu modula \'Stranica\'
* Instancu modula \'Forum\' sa najmanje jednom diskusijom i jednim odgovorom

Kada budete pokretali velike planove testiranja, bilo bi dobro da uzmete u obzir performanse vašeg servera,  pošto količina podataka za učitavanje, koje generiše JMeter, može biti posebno velika. Period ubrzanja je prilagođen broju niti (korisnika) kako bi se smanjila ova vrsta problema, ali je opterećenje i dalje ogromno.


**Nemojte pokretati plan testiranja na produkcionom serveru**. Ova funkcija samo kreira datoteke za potrebe JMeter testiranja tako da sam po sebi nije opasna, ali **NIKADA** ne treba pokretati ovaj test na produkcionom serveru.';
$string['testplansize_0'] = 'XS broj korisnika: ({$a->users}, broj petlji: {$a->loops} i period ubrzanja {$a->rampup})';
$string['testplansize_1'] = 'S broj korisnika: ({$a->users}, broj petlji: {$a->loops} i period ubrzanja {$a->rampup})';
$string['testplansize_2'] = 'M broj korisnika: ({$a->users}, broj petlji: {$a->loops} i period ubrzanja {$a->rampup})';
$string['testplansize_3'] = 'L broj korisnika: ({$a->users}, broj petlji: {$a->loops} i period ubrzanja {$a->rampup})';
$string['testplansize_4'] = 'XL broj korisnika: ({$a->users}, broj petlji: {$a->loops} i period ubrzanja {$a->rampup})';
$string['testplansize_5'] = 'XXL broj korisnika: ({$a->users}, broj petlji: {$a->loops} i period ubrzanja {$a->rampup})';
$string['updateuserspassword'] = 'Ažuriraj lozinke korisnika kursa';
$string['updateuserspassword_help'] = 'Potrebno je da se JMeter prijavi kao korisnik kursa; korisničke lozinke možete da podesite koristeći podešavanje $CFG->tool_generator_users_password u datoteci config.php; ovo podešavanje ažurira lozinke korisnika kursa na osnovu $CFG->tool_generator_users_password. To može biti korisno u slučaju da koristite kurs koji nije generisan pomoću alatke za generisanje probnih kurseva ili ako  $CFG->tool_generator_users_password nije bio podešen kada stre kreirali probne kurseve.';
