<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'sr_lt', version '3.11'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'O meni';
$string['actingasrole'] = 'Trenutno imate drugu ulogu';
$string['activebreadcrumb'] = 'Boja pozadine aktivne stavke navigacione putanje';
$string['activebreadcrumbdesc'] = 'Podesite boju pozadine trenutno aktivne stavke u navigacionoj putanji, kao i ostatka trake navigacione putanje.';
$string['activitiesheading'] = 'Aktivnosti';
$string['alertaccess'] = 'Vidljivost važnog obaveštenja';
$string['alertaccessadmins'] = 'Vidljivo administratorima';
$string['alertaccessdesc'] = 'Podesite tip ograničenja pristupa za vidljivost okvira sa važnim obaveštenjem. Napomena: ako koristite opciju ”Dodaj ograničenje vezano za prilagođeno polje profila” moraćete da unesete vrednosti za polja profila u donje polje.';
$string['alertaccessglobal'] = 'Vidljivo svima';
$string['alertaccessprofile'] = 'Dodaj ograničenje vezano za prilagođeno polje profila';
$string['alertaccessusers'] = 'Vidljivo prijavljenim korisnicima';
$string['alertannounce'] = 'Oglas';
$string['alertannouncedesc'] = 'Prikazuje oglas u okviru za važna obaveštenja.';
$string['alertbackgroundcolorinfo'] = 'Informacija - boja pozadine';
$string['alertbackgroundcolorinfodesc'] = 'Boja pozadine okvira za važna obaveštenja tipa "Informacija"';
$string['alertbackgroundcolorsuccess'] = 'Oglas - boja pozadine';
$string['alertbackgroundcolorsuccessdesc'] = 'Boja pozadine okvira za važna obaveštenja tipa "Oglas"';
$string['alertbackgroundcolorwarning'] = 'Upozorenje - boja pozadine';
$string['alertbackgroundcolorwarningdesc'] = 'Boja pozadine okvira za važna obaveštenja tipa "Upozorenje"';
$string['alertbordercolorinfo'] = 'Informacija - boja bordure';
$string['alertbordercolorinfodesc'] = 'Boja bordure okvira za važna obaveštenja tipa "Informacija"';
$string['alertbordercolorsuccess'] = 'Oglas - boja bordure';
$string['alertbordercolorsuccessdesc'] = 'Boja bordure okvira za važna obaveštenja tipa "Oglas"';
$string['alertbordercolorwarning'] = 'Upozorenje - boja bordure';
$string['alertbordercolorwarningdesc'] = 'Boja bordure okvira za važna obaveštenja tipa "Upozorenje"';
$string['alertcolorinfo'] = 'Informacija - boja ikonice';
$string['alertcolorinfodesc'] = 'Boja ikonice okvira za važna obaveštenja tipa "Informacija"';
$string['alertcolorsheading'] = 'Prilagodite okvire sa važnim obaveštenjem na vrhu stranice';
$string['alertcolorsheadingdesc'] = 'Podesite boje i ikonice';
$string['alertcolorsuccess'] = 'Oglas - boja ikonice';
$string['alertcolorsuccessdesc'] = 'Boja ikonice okvira za važna obaveštenja tipa "Oglas"';
$string['alertcolorwarning'] = 'Upozorenje - boja ikonice';
$string['alertcolorwarningdesc'] = 'Boja ikonice okvira za važna obaveštenja tipa "Upozorenje"';
$string['alertcount'] = 'Broj važnih obaveštenja';
$string['alertcountdesc'] = 'Broj važnih obaveštenje koji se prikazuje u nastavku ove stranice za uređivanje.';
$string['alertdesc'] = 'Unesite i prilagodite tekst koji će biti prikazan na vrhu sajta kao važno obaveštenje. Moguće je podesiti više od jednog važnog obaveštenja, tako da svako bude namenjeno različitim tipovima korisnika. Takođe, imate mogućnost da obaveštenja prikažete na čitavom sajtu ili samo na naslovnoj stranici. <br /><br /><strong>Napomena:</strong> Sada je moguće prikazati važno obaveštenje na stranicama kursa kako biste upozorili predavače da su kursevi skriveni.';
$string['alertdisabled'] = 'Onemogućeno';
$string['alertdisabledesc'] = 'Onemogući ovo važno obaveštenje.';
$string['alerthiddencourse'] = 'Upozorenje o skrivenom kursu';
$string['alerthiddencoursedesc'] = 'Prikazuje važno obaveštenje na stranici kursa ako je kurs skriven';
$string['alerthiddencoursetext-1'] = 'Ovaj kurs je skriven i polaznici ne mogu da mu pristupe.';
$string['alerthiddencoursetext-2'] = 'Kliknite ovde da biste ažurirali podešavanja';
$string['alerticoninfo'] = 'Ikonica "Informacija"';
$string['alerticoninfodesc'] = 'Podesite <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome ikonicu</a> koja će se koristiti za važna obaveštenja tipa "Informacija". Unesite naziv ikonice bez prefiksa fa-.';
$string['alerticonsuccess'] = 'Ikonica "Oglas"';
$string['alerticonsuccessdesc'] = 'Podesite <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome ikonicu</a> koja će se koristiti za važna obaveštenja tipa "Oglas". Unesite naziv ikonice bez prefiksa fa-.';
$string['alerticonwarning'] = 'Ikonica "Upozorenje"';
$string['alerticonwarningdesc'] = 'Podesite <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome ikonicu</a> koja će se koristiti za važna obaveštenja tipa "Uozorenje". Unesite naziv ikonice bez prefiksa fa-.';
$string['alertinfo'] = 'Informacija';
$string['alertinfodesc'] = 'Prikazuje informaciju u okviru za važna obaveštenja.';
$string['alertkeyvalue'] = 'Ključ važnog obaveštenja';
$string['alertkeyvalue_details'] = 'Ključ koji razlikuje ovo važno obaveštenje od prethodnih. Ako promenite ovaj ključ, svi korisnici koji su prethodno odbacili obaveštenje, videće ga ponovo. Ako izmenite obaveštenje, verovatno ćete hteti da promenite i ključ kako biste bili sigurni da će korisnici videti obaveštenje.';
$string['alertprofilefield'] = 'Naziv prilagođenog polja profila=vrednost (opciono)';
$string['alertprofilefielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: "usertype=student"';
$string['alertsettings'] = 'Okvir sa važnim obaveštenjem {$a}';
$string['alertsettingscourse'] = 'Podešavanja važnih obaveštenja na kursu';
$string['alertsettingsgeneral'] = 'Opšta podešavanja važnih obaveštenja';
$string['alertsettingsheading'] = 'Prilagodite okvir sa važnim obaveštenjem na vrhu stranice. Pogledajte primer rasporeda elemenata na stranici <a href="./../theme/adaptable/pix/layout.png" target="_blank">ovde</a>';
$string['alerttext'] = 'Tekst važnog obaveštenja';
$string['alerttextdesc'] = 'Uneti tekst koji će biti prikazan u okviru sa važnim obaveštenjem.';
$string['alerttype'] = 'Tip okvira sa važnim obaveštenjem';
$string['alerttypedesc'] = 'Izaberite tip obaveštenja: informacija (plavo), upozorenje (žuto) ili oglas (zeleno).';
$string['alertwarning'] = 'Upozorenje';
$string['alertwarningdesc'] = 'Prikazuje upozorenje u okviru za važna obaveštenja.';
$string['analyticscount'] = 'Broj polja analitike';
$string['analyticscountdesc'] = 'Broj polja analitike koji se prikazuje u nastavku ove stranice za uređivanje.';
$string['analyticsprofilefield'] = 'Naziv prilagođenog polja profila=vrednost (opciono)';
$string['analyticsprofilefielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: "usertype=student"';
$string['analyticssettings'] = 'Analitika';
$string['analyticssettingsdesc'] = 'Možete da podesite više kôdova za Google Analytics i povežete ih sa poljima korisničkih profila. Takođe možete da koristite Piwik, alat za analitiku, otvorenog kôda.';
$string['analyticssettingsheading'] = 'Podešavanje za Google Analytics i/ili Piwik';
$string['analyticstext'] = 'ID oznaka za Google Analytics';
$string['analyticstextdesc'] = 'Unesite ID oznaku za Google Analytics.';
$string['anonymizega'] = 'Sakrij korisničku IP adresu';
$string['anonymizegadesc'] = 'Sakrij korisničku IP adresu pre slanja podataka za Google Analytics';
$string['backcolor'] = 'Boja pozadine';
$string['backcolordesc'] = 'Podesite boju pozadine.';
$string['bcustyle'] = 'BCU stil';
$string['beta'] = 'RAZVOJNA VERZIJA. NEMOJTE JE KORISTITI NA PRODUKCIONIM SAJTOVIMA';
$string['blockbackgroundcolor'] = 'Boja pozadine bloka';
$string['blockbackgroundcolordesc'] = 'Podesite boju pozadine za sve blokove.';
$string['blockbordercolor'] = 'Boja bordure bloka';
$string['blockbordercolordesc'] = 'Podesite boju bordure bloka.';
$string['blockheaderbackgroundcolor'] = 'Boja pozadine naslova bloka';
$string['blockheaderbackgroundcolordesc'] = 'Podesite boju pozadine naslova za sve blokove.';
$string['blockheaderborderbottom'] = 'Debljina donje bordure zaglavlja bloka';
$string['blockheaderborderbottomdesc'] = 'Podesite debljinu donje bordure zaglavlja blokova.';
$string['blockheaderborderleft'] = 'Debljina leve bordure zaglavlja bloka';
$string['blockheaderborderleftdesc'] = 'Podesite debljinu leve bordure zaglavlja blokova.';
$string['blockheaderborderright'] = 'Debljina desne bordure zaglavlja bloka';
$string['blockheaderborderrightdesc'] = 'Podesite debljinu desne bordure zaglavlja blokova.';
$string['blockheaderbordertop'] = 'Debljina gornje bordure zaglavlja bloka';
$string['blockheaderbordertopdesc'] = 'Podesite debljinu gornje bordure zaglavlja blokova.';
$string['blockheaderbordertopstyle'] = 'Stil bordura zaglavlja blokova';
$string['blockheaderbordertopstyledesc'] = 'Podesite stil bordura zaglavlja blokova.';
$string['blockheaderbottomradius'] = 'Donji poluprečnik zaglavlja bloka';
$string['blockheaderbottomradiusdesc'] = 'Podesite donji poluprečnik zaglavlja bloka kako biste postigli efekat zakrivljenosti/zaobljenosti.';
$string['blockheadercolor'] = 'Boja teksta zaglavlja bloka';
$string['blockheadercolordesc'] = 'Podesite boju teksta zaglavlja bloka.';
$string['blockheadertopradius'] = 'Gornji poluprečnik zaglavlja bloka';
$string['blockheadertopradiusdesc'] = 'Podesite gornji poluprečnik zaglavlja bloka kako biste postigli efekat zakrivljenosti/zaobljenosti.';
$string['blockicons'] = 'Ikonice bloka';
$string['blockiconsdesc'] = 'Podesite ovo kako bi ikonice blokova bile prikazane u zaglavlju bloka.';
$string['blocklayoutbuilder'] = 'Regioni naslovne stranice sa blokovima';
$string['blocklayoutbuilderdesc'] = 'Ispod možete da napravite svoj raspored regiona sa blokovima na naslovnoj stranici. Da biste dodali sadržaj u ove regione moraćete da <strong> uključite uređivanje na naslovnoj stranici vašeg Moodle sajta</strong>.
Nakon toga možete da prevlačite i spuštate blokove u regione koje ste kreirali.';
$string['blocklayoutlayoutcheck'] = 'Proverite svoj raspored blokova';
$string['blocklayoutlayoutcheckdesc'] = 'Upotrebite alat u nastavku kako biste proverili broj blokova koje koristite i videli kako izgleda vaš novi raspored blokova.';
$string['blocklayoutlayoutcount1'] = 'Možete da podesite najviše';
$string['blocklayoutlayoutcount2'] = 'region/a sa blokovima. Trenutno koristite:';
$string['blocklayoutlayoutrow'] = 'Red regiona sa blokovima';
$string['blocklayoutlayoutrowdesc'] = 'Dodajte / podesite raspored blokova u redu regiona sa blokovima na naslovnoj stranici.';
$string['blockmainborderbottom'] = 'Debljina donje bordure tela bloka';
$string['blockmainborderbottomdesc'] = 'Podesite debljinu donje bordure tela bloka';
$string['blockmainborderleft'] = 'Debljina leve bordure tela bloka';
$string['blockmainborderleftdesc'] = 'Podesite debljinu leve bordure tela bloka';
$string['blockmainborderright'] = 'Debljina desne bordure tela bloka';
$string['blockmainborderrightdesc'] = 'Podesite debljinu desne bordure tela bloka';
$string['blockmainbordertop'] = 'Debljina gornje bordure tela bloka';
$string['blockmainbordertopdesc'] = 'Podesite debljinu gornje bordure tela bloka';
$string['blockmainbordertopstyle'] = 'Stil bordura tela bloka';
$string['blockmainbordertopstyledesc'] = 'Podesite stil bordura tela bloka';
$string['blockmainbottomradius'] = 'Donji poluprečnik tela bloka';
$string['blockmainbottomradiusdesc'] = 'Podesite donji poluprečnik tela bloka kako biste postigli efekat zakrivljenosti/zaobljenosti';
$string['blockmaintopradius'] = 'Gornji poluprečnik tela bloka';
$string['blockmaintopradiusdesc'] = 'Podesite gornji poluprečnik tela bloka kako biste postigli efekat zakrivljenosti/zaobljenosti';
$string['blockregionbackground'] = 'Boja pozadine regiona blokova';
$string['blockregionbackgrounddesc'] = 'Boja pozadine kontejnera koji sadrži prilagođeni raspored blokova na naslovnoj stranici';
$string['blocksettings'] = 'Podešavanja blokova';
$string['blockside'] = 'Pozicija blokova';
$string['blocksidedesc'] = 'Kontroliše da li se blokovi na stranici pojavljuju levo ili desno';
$string['breadcrumb'] = 'Boja pozadine navigacione putanje';
$string['breadcrumbbackgroundcolor'] = 'Boja pozadine navigacione trake';
$string['breadcrumbbackgroundcolordesc'] = 'Podesite boju pozadine navigacione trake.';
$string['breadcrumbhome'] = 'Oznaka početne stranice u navigacionoj putanji';
$string['breadcrumbhomedesc'] = 'Prikazuje oznaku za početnu stranicu u navigacionoj putanji kao ikonicu ili kao tekst.';
$string['breadcrumbhomeicon'] = 'Ikonica';
$string['breadcrumbhometext'] = 'Tekst';
$string['breadcrumbseparator'] = 'Graničnik navigacione putanje';
$string['breadcrumbseparatordesc'] = 'Podesite <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome ikonicu</a> koja će se koristiti kao graničnik u navigacionoj traci. Unesite naziv ikonice bez prefiksa fa-.';
$string['breadcrumbtextcolor'] = 'Boja teksta navigacione putanje';
$string['breadcrumbtextcolordesc'] = 'Podesite boju teksta navigacione putanje.';
$string['breadcrumbtitle'] = 'Naziv kursa u navigacionoj putanji';
$string['breadcrumbtitledesc'] = 'Podesite način na koji će naziv kursa biti prikazan u navigacionoj putanji.';
$string['buttoncolor'] = 'Boja dugmeta';
$string['buttoncolordesc'] = 'Boja glavne dugmadi koja se koriste na čitavom sajtu.';
$string['buttondesc'] = 'Promenite izgled dugmadi koja se koriste u ovoj temi.';
$string['buttonhovercolor'] = 'Lebdeća boja dugmeta';
$string['buttonhovercolordesc'] = 'Boja dugmeta kada se mišem pređe preko njega';
$string['buttonlogincolor'] = 'Boja dugmeta za prijavu';
$string['buttonlogincolordesc'] = 'Boja dugmeta za prijavu na sistem.';
$string['buttonloginheight'] = 'Podesi visinu dugmeta za prijavu';
$string['buttonloginheightdesc'] = 'Ovo podešavanje ima efekta samo ako se koristi obrazac za prijavu na sistem u gornjem zaglavlju';
$string['buttonloginhovercolor'] = 'Lebdeća boja dugmeta za prijavu';
$string['buttonloginhovercolordesc'] = 'Boja dugmeta za prijavu na sistem kada se mišem pređe preko njega';
$string['buttonloginmargintop'] = 'Podesi gornju marginu dugmeta za prijavu';
$string['buttonloginmargintopdesc'] = 'Omogućava da rastojanje dugmeta za prijavu od gornje ivice, odnosno njegovo pozicija bude promenjena';
$string['buttonloginpadding'] = 'Podesi razmak između ivice i teksta dugmeta za prijavu';
$string['buttonloginpaddingdesc'] = 'Veći broj = veće dugme';
$string['buttonlogintextcolor'] = 'Boja teksta dugmeta za prijavu';
$string['buttonlogintextcolordesc'] = 'Boja teksta koji se koristi na dugmetu za prijavu na sistem.';
$string['buttonradius'] = 'Podesi poluprečnik dugmeta';
$string['buttonradiusdesc'] = 'Veći poluprečnik = zakrivljena dugmad, manji poluprečnik = četvrtasta dugmad,';
$string['buttonsettings'] = 'Dugmad';
$string['buttonsettingsheading'] = 'Podesite dugmad u ovoj temi';
$string['buttontextcolor'] = 'Boja teksta dugmeta';
$string['buttontextcolordesc'] = 'Boja teksta za svu dugmad na čitavom sajtu';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
<h2>Zasluge</h2>
<h3>O temi</h3>
<p>Adaptable je Moodle prilagodljiva tema sa dva stupca, i sa velikim brojem opcija za prilagođavanje. Tema se bazira na popularnoj BCU temi.</p>
<p>Ova tema je objavljena pod GPL  licencom (GNU General Public License). Kompletnu kopiju licence možete naći na: http://www.gnu.org/licenses/</p>
<p>Menjajte je / Unapređujte / Delite</p>
<br>
<p>Ovu temu su razvili:<br>
Jeremy Hopkins (Coventry University)<br>
Fernando Acedo (3-bits.com)<br>
</p>
<br>
 <p>i mnogi drugi programeri, testeri, prevodioci i volonteri (See <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p>
<br>
<h3>Izveštaj o greškama</h3>
<p>Greške možete prijaviti (i molimo vas, <b>SAMO</b> greške) na našem <a href="https://bitbucket.org/covuni/moodle-theme_adaptable/issues" target="_blank">Bitbucket repozitorijumu</a></p>
<br>
<h3>Tehnička podrška</h3>
<p>Možete postavljati svoja pitanja i nedoumice, i deliti svoje savete na Moodle forumu:</p>
<ul>
<li>English: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a>
<li>Español: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a>
<li>Català: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a>
</ul>
<br>
<h3>Dokumentacija</h3>
<p>Uskoro</p>
<br>
<h3>Demo</h3>
<p>Demo verziju teme možete videti <a href="http://3-bits.com/demo/adaptable" target="_blank">OVDE</a></p>
<br>
</div>
</div>';
$string['colordesc'] = 'Možete da izaberete boje koje želite da koristite u okviru ove teme. Koristite heksadecimalnu ili bilo koju drugu standardnu notaciju. Alternativno, možete da koristite vrednosti "transparent" ili "inherited"';
$string['colorsettings'] = 'Boje';
$string['colorsettingsheading'] = 'Izmenite glavne boje koje se koriste u ovoj temi.';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Kurs';
$string['coursepageblocklayoutbuilder'] = 'Regioni blokova na stranici kursa';
$string['coursepageblocklayoutbuilderdesc'] = 'Ispod možete da napravite svoj raspored regiona sa blokovima na stranici kursa.
Da biste dodali sadržaj u ove regione moraćete da <strong> uključite uređivanje na stranici kursa</strong>.
Nakon toga možete da prevlačite i spuštate blokove u regione koje ste kreirali.';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Red regiona sa blokovima na dnu stranice kursa';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Dodajte / podesite raspored blokova u redu regiona sa blokovima na stranici kursa.';
$string['coursepageblocklayoutlayouttoprow'] = 'Red regiona sa blokovima na vrhu stranice kursa';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Dodajte / podesite raspored blokova u redu regiona sa blokovima na stranici kursa.';
$string['coursepageblockregionsettings'] = 'Alat za kreiranje regiona blokova na stranici kursa';
$string['coursepageblocksenabled'] = 'Omogući prilagođene regione sa blokovima na stranici kursa';
$string['coursepageblocksenableddesc'] = 'Možete da omogućite / onemogućite prilagođene regione sa blokovima (gornji i donji) na stranici kursa.
Zatim možete da prevučete i spustite blokove u regione koje ste kreirali';
$string['coursepageheaderhidesitetitle'] = 'Sakrij naziv sajta na stranicama kursa';
$string['coursepageheaderhidesitetitledesc'] = 'Sakrijte naziv sajta, logo i polje za pretragu na stranicama kursa. Koristite ovo zajedno sa podešavanjem visine zaglavlja stranice kako biste prikazali manje zaglavlje na stranicama kursa.';
$string['coursepagesidebarinfooterenabled'] = 'Premesti bočni stubac sa blokovima u podnožje stranice kursa';
$string['coursepagesidebarinfooterenableddesc'] = 'Premeštanjem stupca sa blokovima u podnožje stranice, deo stranice kursa sa sekcijama će se proširiti.';
$string['coursepagesidebarinfooterenabledsection'] = 'Položaj bočnog stupca sa blokovima';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Prikažite stranice kursa preko celog ekrana prebacivanjem bočnog stupca sa blokovima u podnožje.';
$string['coursesectionactivityassignbgcolor'] = 'Boja pozadine "Zadatka"';
$string['coursesectionactivityassignbgcolordesc'] = 'Podesite boju pozadine za aktivnost "Zadatak".';
$string['coursesectionactivityborderwidth'] = 'Širina bordure aktivnosti unutar sekcije kursa';
$string['coursesectionactivityborderwidthdesc'] = 'Podesite širinu bordure aktivnosti (Forum, Test, Zadatak) unutar sekcije kursa.';
$string['coursesectionactivitycolors'] = 'Podešavanja aktivnosti unutar sekcije kursa';
$string['coursesectionactivityforumbgcolor'] = 'Boja pozadine "Foruma"';
$string['coursesectionactivityforumbgcolordesc'] = 'Podesite boju pozadine za aktivnost "Forum".';
$string['coursesectionactivityiconsize'] = 'Veličina ikonica aktivnosti';
$string['coursesectionactivityiconsizedesc'] = 'Podesite veličinu ikonica za aktivnosti / resurse (npr. vrednost "16px" će podesiti dimenzije ikonica na veličinu 16 x 16 piksela).';
$string['coursesectionactivityquizbgcolor'] = 'Boja pozadine "Testa"';
$string['coursesectionactivityquizbgcolordesc'] = 'Podesite boju pozadine za aktivnost "Test".';
$string['coursesectionbgcolor'] = 'Pozadina sekcije kursa';
$string['coursesectionbgcolordesc'] = 'Podesite boju pozadine sekcije kursa.';
$string['coursesectionbordercolor'] = 'Boja bordura sekcije kursa';
$string['coursesectionbordercolordesc'] = 'Podesite boju bordura sekcija kursa';
$string['coursesectionborderradius'] = 'Poluprečnik bordura sekcije';
$string['coursesectionborderradiusdesc'] = 'Podesite poluprečnik bordura sekcije kursa (zaobljeni uglovi)';
$string['coursesectionborderstyle'] = 'Stil bordura sekcije';
$string['coursesectionborderstyledesc'] = 'Podesite stil bordura sekcije kursa';
$string['coursesectionborderwidth'] = 'Širina bordura sekcije';
$string['coursesectionborderwidthdesc'] = 'Podesite širinu bordura sekcija kursa';
$string['coursesectionheaderbg'] = 'Pozadina zaglavlja sekcije';
$string['coursesectionheaderbgdesc'] = 'Podesite boju pozadine zaglavlja sekcije kursa';
$string['coursesectionheaderbordercolor'] = 'Boja bordure zaglavlja sekcije';
$string['coursesectionheaderbordercolordesc'] = 'Podesite boju bordure zaglavlja sekcije (koristi se samo donja bordura pošto spoljašnji kontejner ima borduru)';
$string['coursesectionheaderborderradiusbottom'] = 'Donji poluprečnik bordure zaglavlja sekcije';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Podesite donji poluprečnik bordure zaglavlja sekcije (zaobljeni uglovi)';
$string['coursesectionheaderborderradiustop'] = 'Gornji poluprečnik bordure zaglavlja sekcije';
$string['coursesectionheaderborderradiustopdesc'] = 'Podesite gornji poluprečnik bordure zaglavlja sekcije (zaobljeni uglovi)';
$string['coursesectionheaderborderstyle'] = 'Stil bordure zaglavlja sekcije kursa';
$string['coursesectionheaderborderstyledesc'] = 'Podesite stil bordure zaglavlja sekcije kursa (samo donja bordura se koristi pošto spoljašnji kontejner takođe ime borduru)';
$string['coursesectionheaderborderwidth'] = 'Širina bordure zaglavlja sekcije kursa';
$string['coursesectionheaderborderwidthdesc'] = 'Podesite širinu bordure zaglavlja sekcije kursa (samo donja bordura se koristi pošto spoljašnji kontejner takođe ime borduru)';
$string['coursesettings'] = 'Formati kursa';
$string['coursesettingsdesc'] = 'Prilagodite neke od najčešće korišćenih formata Moodle kurseva kako bi odgovarali glavnom dizajnu.';
$string['coursesettingsheading'] = 'Podešavanja formata kursa';
$string['coursetitlemaxwidth'] = 'Maksimalna širina naslova kursa';
$string['coursetitlemaxwidthdesc'] = 'Podesite maksimalnu širinu regiona sa naslovom kursa';
$string['covbkcolor'] = 'Boja pozadine naslova na Koventri pločicama';
$string['covbkcolordesc'] = 'Podesite boju pozadine naslova kada su izabrane Koventri pločice';
$string['coventrystyle'] = 'Koventri stil';
$string['covfontcolor'] = 'Boja slova naslova na Koventri pločicama';
$string['covfontcolordesc'] = 'Podesite boju slova naslova kada su izabrane Koventri pločice';
$string['covhidebutton'] = 'Dugme kursa na Koventri pločicama';
$string['covhidebuttondesc'] = 'Podesite ovu opciju kako biste sakrili dugme za kurs kada su izabrana Koventri pločice.';
$string['currentcolor'] = 'Boja naglašavanja tekuće sekcije kursa';
$string['currentcolordesc'] = 'Podesite boju kojom će biti naglašena tekuća sekcija kursa';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcssdesc'] = 'CSS pravila koja dodate u ovo polje za tekst odraziće se na izgled svih stranica, što olakšava prilagođavanje ove teme.';
$string['customcssjssettings'] = 'Prilagođeni CSS & JS';
$string['dashblocklayoutbuilder'] = 'Regioni kontrolnog panela sa blokovima';
$string['dashblocklayoutbuilderdesc'] = 'Ispod možete da napravite svoj raspored regiona sa blokovima na stranici "Kontrolni panel".
Da biste dodali sadržaj u ove regione moraćete da <strong> uključite uređivanje na naslovnoj stranici vašeg Moodle sajta</strong>.
Nakon toga možete da prevlačite i spuštate blokove u regione koje ste kreirali.';
$string['dashblocklayoutlayoutrow'] = 'Red regiona sa blokovima na kontrolnom panelu';
$string['dashblocklayoutlayoutrowdesc'] = 'Dodajte / podesite raspored blokova u redu regiona sa blokovima na stranici "Kontrolni panel".';
$string['dashblocksenabled'] = 'Omogući prilagođeni region sa blokovima na stranici "Kontrolni panel"';
$string['dashblocksenableddesc'] = 'Možete da omogućite / onemogućite prilagođeni region sa blokovima na stranici "Kontrolni panel".
Zatim možete da prevučete i spustite blokove u regione koje ste kreirali';
$string['dashboardblockregionsettings'] = 'Alat za kreiranje regiona blokova na kontrolnom panelu';
$string['deprecated'] = 'MOODLE ZASTARELA VERZIJA. NEMOJTE KORISTITI TEMU ADAPTABLE NA OVOM SAJTU';
$string['disablecustommenu'] = 'Onemogući Moodle prilagođeni meni';
$string['disablecustommenudesc'] = 'Ovo će onemogućiti Moodle prilagođeni meni u navigacionoj traci (meni će i dalje biti vidljiv u drugim temama koje ste instalirali)';
$string['disabled'] = 'Onemogućeno';
$string['disablemenuscoursepages'] = 'Onemogući menije na stranicama kursa';
$string['disablemenuscoursepagesdesc'] = 'Uključivanje ove opcije će ograničiti prikaz gornjih menija na stranicama sajta, početnoj stranici, kontrolnom panelu (Moja početna stranica) itd. Takođe, oni neće biti prikazani na bilo kojoj stranici kursa.';
$string['discardbuttontext'] = 'Otkaži';
$string['displaylogin'] = 'Prikaz prijave na sajt';
$string['displayloginbox'] = 'Polja za prijavu';
$string['displayloginbutton'] = 'Dugme';
$string['displaylogindesc'] = 'Izaberite kako da se na ekranu prikaže prijava na sajt (kada je gore omogućeno).';
$string['displayloginno'] = 'Bez prijave';
$string['dividingline'] = 'Linija razdvajanja u zaglavlju';
$string['dividingline2'] = 'Linija razdvajanja u podnožju';
$string['dividingline2desc'] = 'Boja za liniju razdvajanja koja se nalazi u podnožju stranice';
$string['dividinglinedesc'] = 'Boja za liniju razdvajanja koja se nalazi u zaglavlju stranice';
$string['editfont'] = 'Boja fonta dugmeta ”Uredi i prilagodi ovu stranicu”';
$string['editfontdesc'] = 'Podesite boju fonta na dugmetu ”Uredi i prilagodi ovu stranicu”';
$string['edithorizontalpadding'] = 'Podesi horizontalni razmak između ivice i teksta dugmadi za uređivanje';
$string['editoffbk'] = 'Boja fonta dugmeta za isključivanje ”Uredi i prilagodi ovu stranicu”';
$string['editoffbkdesc'] = 'Podesite boju fonta na dugmetu za isključivanje režima \'Uredi i prilagodi ovu stranicu';
$string['editonbk'] = 'Boja pozadine dugmeta ”Uredi i prilagodi ovu stranicu”';
$string['editonbkdesc'] = 'Podesite boju pozadine dugmeta \'Uredi i prilagodi ovu stranicu';
$string['emoticonsize'] = 'Veličina emotikona';
$string['emoticonsizedesc'] = 'Podesite visinu i širinu Moodle emotikona.';
$string['enablealert'] = 'Omogući okvir sa važnim obaveštenjem {$a}';
$string['enablealertdesc'] = 'Omogući okvir sa važnim obaveštenjem {$a}';
$string['enablealerts'] = 'Omogući / Onemogući važna obaveštenja';
$string['enablealertsdesc'] = 'Omogućite odnosno onemogućite prikazivanje važnih obaveštenja na vašem sajtu';
$string['enablealertstriptags'] = 'Ukloni automatski html oznake iz obaveštenja';
$string['enablealertstriptagsdesc'] = 'Ako omogućite ovu opciju iz obaveštenja će automatski biti uklonjene html oznake. Ako pak onemogućite ovu opciju, onda ćete moći da koristite html oznake/linkove u svojim obaveštenjima, ali ćete morati ručno da ih ukloniti u html prikazu.';
$string['enableanalytics'] = 'Omogući Google Analytics';
$string['enableanalyticsdesc'] = 'Omogućite  podešavanja za Google Analytics na svom Moodle sajtu';
$string['enableavailablecourses'] = 'Prikaži "Dostupni kursevi"';
$string['enableavailablecoursesdesc'] = 'Prikazuje natpis ”Dostupni kursevi” na naslovnoj stranici';
$string['enablebadges'] = 'Bedževi';
$string['enablebadgesdesc'] = 'Prikazuje link ka bedževima korisnika';
$string['enableblog'] = 'Moji blogovi';
$string['enableblogdesc'] = 'Prikazuje link ka stranicama blogova korisnika';
$string['enablecalendar'] = 'Korisnički kalendar';
$string['enablecalendardesc'] = 'Prikazuje link ka kalendaru korisnika';
$string['enableeditprofile'] = 'Uredi profil';
$string['enableeditprofiledesc'] = 'Prikazuje link za uređivanje profila korisnika';
$string['enableeventsdesc'] = 'Prikazuje link ka kalendaru';
$string['enablefeed'] = 'Moje povratne informacije';
$string['enablefeeddesc'] = 'Prikazuje link ka stranici korisnika ”Moje povratne informacije” - napomena: ovo zahteva <a href="https://moodle.org/plugins/report_myfeedback" target="blank">dodatak ”Moje povratne informacije”</a>';
$string['enablegrades'] = 'Ocene';
$string['enablegradesdesc'] = 'Prikazuje link ka ocenama korisnika';
$string['enableheading'] = 'Zaglavlje sa naslovom kursa';
$string['enableheadingdesc'] = 'Podesite režim za prikaz naslova kursa u zaglavlju kada je omogućen podrazumevan naslov Moodle sajta.';
$string['enablehelp'] = 'Link za pomoć';
$string['enablehelpdesc'] = 'Dodajte link za pomoć u navigacionu traku.';
$string['enablehomedesc'] = 'Prikazuje link ka naslovnoj stranici.';
$string['enablehomeredirect'] = 'Omogući redirekciju (redirect=0) ka naslovnoj stranici';
$string['enablehomeredirectdesc'] = 'Omogućite redirekciju (redirect=0) ka naslovnoj stranici. Ovo se koristi na sajtovima na kojima je kao podrazumevana početna stranica postavljena ”Moja početna stranica / Kontrolni panel”. Ovo će sprečiti da korisnik, kada klikne na link ”Početna stranica”, bude preusmeren na ”Moja početna stranica / Kontrolni panel”.';
$string['enablemenus'] = 'Omogući menije';
$string['enablemenusdesc'] = 'Preporučuje se da ovo ostavite isključeno, ako se meniji ne koriste zbog performansi sistema';
$string['enablemy'] = 'Moja početna stranica';
$string['enablemydesc'] = 'Prikazuje link ka ”Moja početna stranica”';
$string['enablemyhomedesc'] = 'Prikazuje link ka {$a}';
$string['enablemysitesdesc'] = 'Prikazuje padajući meni sa kursevima korisnika';
$string['enablenote'] = 'Moja obaveštenja';
$string['enablenotedesc'] = 'Prikazuje link ka stranici sa obaveštenjima za korisnika';
$string['enableposts'] = 'Moji postovi';
$string['enablepostsdesc'] = 'Prikazuje link ka stranici ”Moji postovi”';
$string['enablepref'] = 'Moja podešavanja';
$string['enableprefdesc'] = 'Prikazuje link ka stranici sa preferisanim podešavanjima korisnika';
$string['enableprivatefiles'] = 'Privatne datoteke';
$string['enableprivatefilesdesc'] = 'Prikazuje link ka ka privatnim datotekama korisnika';
$string['enableprofile'] = 'Korisnički profil';
$string['enableprofiledesc'] = 'Prikazuje link ka profilu korisnika';
$string['enableshowhideblocks'] = 'Omogući prekidač ”Prikaži/Sakrij blokove”';
$string['enableshowhideblocksdesc'] = 'Omogućava korisnicima da prikažu/sakriju sve blokove.';
$string['enablethiscoursedesc'] = 'Prikazuje padajući meni sa aktivnostima iz tekućeg kursa';
$string['enableticker'] = 'Omogući pokretnu traku sa vestima na početnoj stranici';
$string['enabletickerc'] = 'Omogući pokretnu traku sa vestima na internim stranicama';
$string['enabletickercdesc'] = 'Označite ovo kako biste omogućili pokretnu traku sa vestima na internim stranicama.';
$string['enabletickerdesc'] = 'Označite ovo kako biste omogućili pokretnu traku sa vestima na početnoj stranici.';
$string['enabletickermy'] = 'Omogući pokretnu traku sa vestima na ”Moja početna stranica / Kontrolni panel”';
$string['enabletickermydesc'] = 'Označite ovo kako biste omogućili pokretnu traku sa vestima na ”Moja početna stranica / Kontrolni panel”.';
$string['enabletoolsmenus'] = 'Omogući menije ”Alati”';
$string['enabletoolsmenusdesc'] = 'Preporučuje se da ovo ostavite isključeno, ako se meniji ne koriste zbog performansi sistema';
$string['enablezoom'] = 'Omogući zumiranje';
$string['enablezoomdesc'] = 'Dozvoljava korisnicima da menjaju prikaz stranice (između prikaza preko celog ekrana i prikaza fiksne širine).';
$string['events'] = 'Događaji';
$string['favicon'] = 'Favikonica';
$string['favicondesc'] = 'Postavite favikonicu koja će se koristiti na vašem sajtu';
$string['fontblockheadercolor'] = 'Boja fonta zaglavlja blokova';
$string['fontblockheadercolordesc'] = 'Podesite boju fonta zaglavlja u Moodle blokovima, koristeći html heksadecimalni kôd.';
$string['fontblockheadersize'] = 'Veličina fonta zaglavlja blokova';
$string['fontblockheadersizedesc'] = 'Podesite veličinu fonta koji se koristi u zaglavlju Moodle blokova. Izaberite vrednost sa spiska.';
$string['fontblockheaderweight'] = 'Debljina fonta zaglavlja blokova';
$string['fontblockheaderweightdesc'] = 'Podesite debljinu fonta koji se koristi u zaglavlju Moodle blokova. Izaberite vrednost sa spiska.';
$string['fontcolor'] = 'Boja glavnog fonta';
$string['fontcolordesc'] = 'Podesite boju fonta u temi, koristeći html heksadecimalni kôd.';
$string['fontdesc'] = 'Možete da izaberete <a href="https://www.google.com/fonts" target="_blank">Google fontove</a> koje želite da koriste u okviru teme. Izaberite željeni podskup karaktera (latinični je uvek uključen) i unesite odgovarajuću debljinu fonta, inače font neće biti prikazan.';
$string['fontheadercolor'] = 'Boja fonta zaglavlja';
$string['fontheadercolordesc'] = 'Podesite boju fonta zaglavlja u temi, koristeći html heksadecimalni kôd.';
$string['fontheadername'] = 'Font zaglavlja';
$string['fontheadernamedesc'] = 'Izaberite podrazumevani font ili <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> koji će se koristiti za zaglavlja u tekstu, kao i u zaglavljima blokova.';
$string['fontheaderweight'] = 'Debljina fonta zaglavlja';
$string['fontheaderweightdesc'] = 'Debljina fonta zaglavlja koji se koriste na sajtu. Izaberite vrednost do 100 do 900, zavisno od izabranog fonta.';
$string['fontname'] = 'Glavni font';
$string['fontnamedesc'] = 'Izaberite podrazumevani font ili <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> koji će se koristiti na sajtu.';
$string['fontsettings'] = 'Fontovi';
$string['fontsettingsheading'] = 'Izmenite fontove koji se koriste u okviru teme.';
$string['fontsize'] = 'Veličina glavnog fonta';
$string['fontsizedesc'] = 'Izaberite podrazumevanu veličinu fonta (u procentima) koja se koristi na čitavom sajtu.';
$string['fontsubset'] = 'Podskup Google fontova';
$string['fontsubsetdesc'] = 'Izaberite koji će se drugi podskup karaktera, pored latiničnog, primenjivati na sve fontove. Latinični podskup je standardno već uključen.';
$string['fonttitlecolor'] = 'Boja fonta naslova sajta /kursa';
$string['fonttitlecolorcourse'] = 'Boja fonta naslova kursa';
$string['fonttitlecolorcoursedesc'] = 'Podesite boju fonta naslova kursa u temi, koristeći html heksadecimalni kôd.';
$string['fonttitlecolordesc'] = 'Podesite boju fonta naslova sajta i naslova kursa u temi, koristeći html heksadecimalni kôd.';
$string['fonttitlename'] = 'Font naslova sajta / kursa';
$string['fonttitlenamedesc'] = 'Izaberite podrazumevani font ili <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> koji će se koristiti za naslov sajta i naslove kurseva.';
$string['fonttitlesize'] = 'Veličina fonta naslova sajta / kursa';
$string['fonttitlesizedesc'] = 'Veličina fonta naslova sajta i naslova kursa koji se koristi na sajtu. Izaberite vrednost sa spiska.';
$string['fonttitleweight'] = 'Debljina fonta naslova sajta / kursa';
$string['fonttitleweightdesc'] = 'Podesite debljinu fonta koji se koristi za naslov sajta i naslove kurseva. Izaberite vrednost do 100 do 900, zavisno od izabranog fonta.';
$string['fontweight'] = 'Debljina glavnog fonta';
$string['fontweightdesc'] = 'Podesite debljinu fonta koji se koristi na sajtu. Izaberite vrednost do 100 do 900, zavisno od izabranog fonta.';
$string['footerbkcolor'] = 'Boja pozadine podnožja';
$string['footerbkcolordesc'] = 'Podesite boju pozadine u podnožju stranice.';
$string['footerblocksplacement'] = 'Pojavljivanje blokova podnožja';
$string['footerblocksplacement1'] = 'Na čitavom sajtu';
$string['footerblocksplacement2'] = 'Samo početna stranica';
$string['footerblocksplacement3'] = 'Nigde';
$string['footerblocksplacementdesc'] = 'Ovo podešavanje kontroliše gde će se prikazivati gornji blokovi podnožja. Podrazumevana vrednost je \'Na čitavom sajtu\'.';
$string['footercontent'] = 'Sekcija sa sadržajem podnožja';
$string['footercontentdesc'] = 'Dodajte sadržaj u sekciju podnožja stranice';
$string['footerdesc'] = 'Dodaj naslov za sekciju podnožja';
$string['footerheader'] = 'Naslov sekcije podnožja';
$string['footerlayoutrow'] = 'Alat za kreiranje rasporeda blokova u podnožju';
$string['footerlayoutrowdesc'] = 'Dizajnirajte raspored blokova za region podnožja stranice sa blokovima.';
$string['footerlinkcolor'] = 'Boja linka u blokovima podnožja';
$string['footerlinkcolordesc'] = 'Boja linka u blokovima podnožja stranice.';
$string['footersettings'] = 'Podnožje';
$string['footersettingsheading'] = 'Podesite sadržaj koji treba da se pojavi u podnožju stranice. Pogledajte primer rasporeda elemenata na stranici <a href="./../theme/adaptable/pix/layout.png" target="_blank">ovde</a>';
$string['footertextcolor'] = 'Boja teksta podnožja';
$string['footertextcolor2'] = 'Boja teksta donjeg podnožja';
$string['footertextcolor2desc'] = 'Boja teksta u donjem delu podnožja stranice.';
$string['footertextcolordesc'] = 'Podesite boju teksta u podnožju stranice, koristeći html heksadecimalni kôd.';
$string['footnote'] = 'Fusnota';
$string['footnotedesc'] = 'Dodaje tekst u podnožje.';
$string['forumbodybackgroundcolor'] = 'Pozadina tela posta na forumu';
$string['forumbodybackgroundcolordesc'] = 'Boja pozadine tela posta na forumu';
$string['forumheaderbackgroundcolor'] = 'Pozadina zaglavlja posta na forumu';
$string['forumheaderbackgroundcolordesc'] = 'Boja pozadine zaglavlja posta na forumu';
$string['frnt-footer'] = 'Blokovi u ovom regionu biće vidljivi samo administratorima.';
$string['frontpagealertsettings'] = 'Okvir sa važnim obaveštenjem';
$string['frontpageblockregionsettings'] = 'Alat za kreiranje regiona blokova';
$string['frontpageblocksenabled'] = 'Omogući prilagođeni region sa blokovima na naslovnoj stranici';
$string['frontpageblocksenableddesc'] = 'Možete da omogućite / onemogućite prilagođene regione sa blokovima na naslovnoj stranici. Nakon toga, možete da prevlačite i spuštate blokove u regione koje ste kreirali.';
$string['frontpageblocksettings'] = 'Promotivni blokovi';
$string['frontpagecoursesettings'] = 'Naslovna stranica - spisak kurseva';
$string['frontpagedesc'] = 'Konfigurišite način na koji se prikazuju blokovi sa kursevima na naslovnoj stranici.';
$string['frontpagemarketenabled'] = 'Omogući promotivne blokove';
$string['frontpagemarketenableddesc'] = 'Podesite promotivne blokove na naslovnoj stranici.';
$string['frontpagemarketoption'] = 'Izaberite stil za promotivne blokove';
$string['frontpagemarketoptiondesc'] = 'Možete da primenite različite stilove na promotivne blokove. Napomena: BCU stil je dizajniran tako da radi sa slikama na vrhu bloka.';
$string['frontpagerenderer'] = 'Blokovi kurseva na naslovnoj stranici';
$string['frontpagerendererdefaultimage'] = 'Podrazumevana slika kursa';
$string['frontpagerendererdefaultimagedesc'] = 'Podrazumevana slika kursa koja će se koristiti kada ne postoji slika kursa (primenjivo samo za opciju \'Pločice sa prekrivačem\')';
$string['frontpagerendererdesc'] = 'Kontroliše način na koji se prikazuju blokovi kurseva na naslovnoj stranici.';
$string['frontpagerendereroption1'] = 'Pločice';
$string['frontpagerendereroption2'] = 'Pločice sa prekrivačem';
$string['frontpagerendereroption3'] = 'Moodle standardno';
$string['frontpagerendereroption4'] = 'Koventri pločice';
$string['frontpagesettingsheading'] = 'Prikaz naslovne stranice';
$string['frontpageslidersettings'] = 'Naslovna stranica - Slajd-šou';
$string['frontpagetickersettings'] = 'Naslovna stranica - Pokretni traka';
$string['fullscreen'] = 'Prikaz preko celog ekrana';
$string['fullscreenwidth'] = 'Širina prikaza preko celog ekrana';
$string['fullscreenwidthdesc'] = 'Podesite maksimalnu širinu teme kada je u režimu prikaza preko celog ekrana / zumiranja.';
$string['genericsettingsdescription'] = 'Ovde možete naći različita podešavanja kako biste temi dodali svoj CSS i JavaScript kôd.';
$string['genericsettingsheading'] = 'Primenite svoje modifikacije';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Možete da podesite više kôdova za Google Analytics i povežete ih sa poljima korisničkih profila.';
$string['googleanalyticssettingsheading'] = 'Google Analytics podešavanja za vaš sajt';
$string['headerbgimage'] = 'Pozadinska slika';
$string['headerbgimagedesc'] = 'Podesite pozadinsku sliku u zaglavlju. Minimalna veličina je 1600 x 180 piksela (preporučuje se 1600 x 180 piksela). Slika pokriva čitavo zaglavlje. Možete da dodate boju u \'Boja pozadine gornjeg zaglavlja\' ili da koristite opciju <i>transparent</i> kako biste prikazali pozadinsku sliku. U tom slučaju, kako bi tekst ispravno bio prikazan preko slike, modifikujte njegovu boju.';
$string['headerbkcolor'] = 'Boja pozadine gornjeg zaglavlja';
$string['headerbkcolor2'] = 'Boja pozadine donjeg zaglavlja';
$string['headerbkcolor2desc'] = 'Podesite boju pozadine donjeg zaglavlja.';
$string['headerbkcolordesc'] = 'Podesite boju pozadine gornjeg zaglavlja';
$string['headerdesc'] = 'Postavite svoju favikonicu i logo, podesite obrazac za prijavu u zaglavlju, kao i naslove u zaglavlju.<br />
Veličinu fonta i stilove za naslove možete da podesite na stranici za podešavanje <a href="./../admin/settings.php?section=theme_adaptable_font">fontova</a>.';
$string['headersettings'] = 'Zaglavlje';
$string['headersettingsheading'] = 'Prilagodite zaglavlje ove teme. Pogledajte primer rasporeda elemenata na stranici <a href="./../theme/adaptable/pix/layout.png" target="_blank">ovde</a>';
$string['headertextcolor'] = 'Boja teksta i linka gornjeg zaglavlja';
$string['headertextcolordesc'] = 'Podesite boju teksta i linka gornjeg zaglavlja';
$string['help'] = 'Pomoć';
$string['helpprofilefield'] = 'Prilagođeno polje profila za pomoć (opciono)';
$string['helpprofilefielddesc'] = 'Dodajte pravilo za pristup pomoći koristeći prilagođeno polje profila npr: usertype=student';
$string['helptarget'] = 'Odredište linka za pomoć';
$string['helptargetdesc'] = 'Da li želite da se link za pomoć otvori u novom prozoru?';
$string['helptitle'] = 'Pomoć';
$string['hiddencourses'] = 'Sakriveni kursevi';
$string['hide'] = 'Sakrij';
$string['hideblocks'] = 'Sakrij blokove';
$string['hidefootersocial'] = 'Prikaži ikonice društvenih mreža';
$string['hidefootersocialdesc'] = 'Prikažite ikonice društvenih mreža u podnožju ispod blokova.';
$string['hideinforum'] = 'Sakrij ”Pomoć” i meni ”Alati” u forumima';
$string['hideinforumdesc'] = 'Kada se koristi prikaz fiksne širine i sve opcije menija, polje za pretragu foruma može skliznuti u red ispod. Uključivanje ove opcije će sakriti \'Pomoć\' i meni \'Alati\' u forumima, što će omogućiti da stranica foruma budu ispravno prikazana.';
$string['homebk'] = 'Pozadinska slika naslovne stranice';
$string['homebkdesc'] = 'Postavite sliku koja će biti pozadinska slika naslovne stranice';
$string['infobox'] = 'Info-blok naslovne stranice';
$string['infobox2'] = 'Sekundarni info-blok naslovne stranice';
$string['infobox2desc'] = 'Sekundarni info-blok naslovne stranice (pogledajte datoteku <a href="./../theme/adaptable/README.txt" target="_blank">README.txt</a> za više informacija i savete).';
$string['infoboxdesc'] = 'Info-blok naslovne stranice HTML (pogledajte datoteku <a href="./../theme/adaptable/README.txt" target="_blank">README.txt</a> za više informacija i savete).';
$string['infoboxfullscreen'] = 'Info-blok preko celog ekrana';
$string['infoboxfullscreendesc'] = 'Ako uključite ovu opciju sadržaj info-bloka biće prikazan čitavom širinom ekrana.';
$string['jssection'] = 'Javascript sekcija';
$string['jssectiondesc'] = 'Dodajte javascript kôd na sajt.';
$string['layoutaddcontent'] = 'Zadovoljni ste sa svojim rasporedom blokova? Sada dodajte sadržaj u vaše blokove:';
$string['layoutaddcontentdesc1'] = 'Konfigurisali ste';
$string['layoutaddcontentdesc2'] = 'promotivne blokove. Ako ste zadovoljni sa ovim rasporedom dodajte u nastavku stranice sadržaj u blokove. Ako niste zadovoljni upotrebite gornji alat za kreiranje rasporeda blokova kako biste napravili promene.<br />';
$string['layoutcheck'] = 'Proverite svoj raspored blokova';
$string['layoutcheckdesc'] = 'Upotrebite alat u nastavku kako biste proverili broj blokova koje koristite i videli kako izgleda vaš novi raspored blokova.';
$string['layoutcount1'] = 'Možete da podesite najviše';
$string['layoutcount2'] = 'region/a sa blokovima. Trenutno koristite:';
$string['layoutdesc'] = 'Podesite podrazumevani raspored blokova koji korisnici vide.';
$string['layoutsettings'] = 'Izgled sajta';
$string['layoutsettingsheading'] = 'Kontrolni aspekti izgleda sajta';
$string['leftblocks'] = 'Leva strana';
$string['linkcolor'] = 'Boja linka';
$string['linkcolordesc'] = 'Podesite boju linkova u temi, koristeći html heksadecimalni kôd.';
$string['linkhover'] = 'Lebdeća boja linka';
$string['linkhoverdesc'] = 'Podesite boju linkova u temi (kada se mišem pređe preko njih), koristeći html heksadecimalni kôd.';
$string['linksmenu'] = 'Meni linkova';
$string['loadingcolor'] = 'Boja učitavanja';
$string['loadingcolordesc'] = 'Boja trake učitavanja na vrhu stranice.';
$string['loginplaceholder'] = 'Korisničko ime';
$string['logintextbutton'] = 'Prijavi se';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Postavite logo koji će se koristiti na vašem sajtu. Preporučena veličina je 200 x 80 piksela';
$string['maincolor'] = 'Glavna boja';
$string['maincolordesc'] = 'Glavna boja za blokove i podnožje stranice.';
$string['market'] = 'Promotivni blok';
$string['marketblockbordercolor'] = 'Boja bordure promotivnog bloka';
$string['marketblockbordercolordesc'] = 'Podesite boju bordure promotivnog bloka.';
$string['marketblocksbackgroundcolor'] = 'Boja pozadine regiona sa promotivnim blokovima';
$string['marketblocksbackgroundcolordesc'] = 'Podesite boju pozadine regiona sa promotivnim blokovima.';
$string['marketdesc'] = 'Dodajte HTML za promotivni blok (pogledajte datoteku <a href="./../theme/adaptable/README.txt" target="_blank">README.txt</a> za više informacija i savete).';
$string['marketingbuilderdesc'] = 'Upotrebite alat u nastavku kako biste podesili svoje promotivne blokove. Jednom kada ovde definišite broj blokova u donjem delu stranice pojaviće se podešavanja za svaki od njih.';
$string['marketingbuilderheading'] = 'Alat za raspored promotivnih blokova';
$string['marketingdesc'] = 'Postoje dva info-bloka pune širine sa različitim stilovima koje možete da koristite. Pored toga postoji i alat za kreiranje rasporeda blokova koji vam daje mogućnost da odlučite koliko blokova vam je potrebno i da definišete svoj raspored blokova. Molimo, pogledajte datoteku <a href="./../theme/adaptable/README.txt" target="_blank">README.txt</a> koja dolazi sa ovom temom.';
$string['marketingsettings'] = 'Promotivni blokovi';
$string['marketingsettingsheading'] = 'Prilagodite promotivne blokove koji se pojavljuju na naslovnoj stranici. Pogledajte primer rasporeda elemenata na stranici <a href="./../theme/adaptable/pix/layout.png" target="_blank">ovde</a>';
$string['marketlayoutrow'] = 'Red promotivnih blokova';
$string['marketlayoutrowdesc'] = 'Dodajte / podesite izgled reda sa promotivnim blokovima na naslovnoj stranici';
$string['menubkcolor'] = 'Boja pozadine glavnog menija';
$string['menubkcolordesc'] = 'Podesite boju pozadine glavnog menija';
$string['menubordercolor'] = 'Boja donje bordure glavnog menija';
$string['menubordercolordesc'] = 'Podesite boju donje bordure glavnog menija';
$string['menufontcolor'] = 'Boja fonta glavnog menija';
$string['menufontcolordesc'] = 'Podesite boju fonta glavnog menija';
$string['menufontpadding'] = 'Razmak između stavki navigacije';
$string['menufontpaddingdesc'] = 'Podesite razmak između stavki u glavnoj navigacionoj traci.';
$string['menufontsize'] = 'Veličina fonta za navigacionu traku';
$string['menufontsizedesc'] = 'Podesite veličinu fonta koji se koristi u glavnoj navigacionoj traci';
$string['menuhovercolor'] = 'Lebdeća boja glavnog menija';
$string['menuhovercolordesc'] = 'Podesite lebdeću boju glavnog menija';
$string['menuoverrideprofilefield'] = 'Naziv prilagođenog polja profila';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'Naziv prilagođenog polja profila (u formatu ”spiska”) koje se koriste za korisničke izmene.';
$string['menusdesc'] = '';
$string['menusession'] = 'Sačuvaj detalje o pristupu u sesiji korisnika';
$string['menusessiondesc'] = 'Zbog performansi sistema sugeriše se da uključite ovu opciju. Možda ćete želeti da je onemogućiti prilikom testiranja.';
$string['menusessionttl'] = 'Vreme čuvanja pravila pristupa u sesiji korisnika';
$string['menusessionttldesc'] = 'Vremenski period (broj minuta) nakon kog se pravila za pristup meniju osvežavaju u sesiji korisnika.';
$string['menusettings'] = 'Zaglavlje - meniji';
$string['menusettingsheading'] = 'Prilagodite menije u gornjem zaglavlju ove teme.';
$string['menusheading'] = 'Konfigurišite navigaciju za menije u gornjem zaglavlju';
$string['menusheadingvisibility'] = 'Opšta podešavanja za vidljivost menija gornjeg zaglavlja';
$string['menusheadingvisibilitydesc'] = 'Sledeća podešavanja omogućavaju da kontrolišete gde se pojavljuju meniji i opciono omogućavaju korisnicima da prilagode svoja podešavanja';
$string['menuslinkright'] = 'Prikaži meni linkova gore desno';
$string['menuslinkrightdesc'] = 'Ako je označeno, meni sa linkovima se prikazuje u gornjem desnom uglu odmah pored menija sa porukama';
$string['menustitledesc'] = 'Meniji ”Alati” (u navigacionoj traci) i Gornji meniji (u gornjem zaglavlju) se mogu ograničiti na osnovu prilagođenih polja u profilu korisnika (opciono). Da biste dodali ograničenje unesite naziv polja profila i očekivanu vrednost. Struktura menija sledi uobičajeni Moodle format:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = 'Dozvoli izmene od strane korisnika';
$string['menuuseroverridedesc'] = 'Ovo podešavanje može da se koristi kako bi se, putem prilagođenog polja profila, korisnicima dala kontrola nad pojavljivanjem menija. Za korišćenje ove opcije biće potrebno da kreirate prilagođeno polje profila u formatu ”spiska” sa vrednostima poređanim odgovarajućim redosledom:
<pre>1. Na čitavom sajtu (prva stavka na spisku biće za vidljivost menija na čitavom sajtu)
2. Samo početne stranice (druga stavka na spisku ograničiće vidljivost menija samo na sajt / početne stranice)
3. Skriveno (treća stavka na spisku će sakriti menije u potpunosti)</pre>
NEMOJTE koristiti opciju ”Onemogući menije na stranicama kursa” zajedno sa podešavanjima polja profila. Umesto toga, kada podešavate vaš spisak polja profila, koristite kao podrazumevanu vrednost ”Samo početne stranice”.

Napomena: da bi ova promena stupila na snagu, korisnici će morati da se odjave sa sajta i ponovo prijave. Bilo bi dobro da u prilagođeno polje profila dodate napomenu koja ovo objašnjava.';
$string['messagepopupbackground'] = 'Boja pozadine iskačućeg prozora sa porukama';
$string['messagepopupbackgrounddesc'] = 'Podesite boju pozadine zaglavlja iskačućeg prozora sa porukama.';
$string['messagepopupcolor'] = 'Boja teksta iskačućeg prozora sa porukama';
$string['messagepopupcolordesc'] = 'Podesite boju teksta zaglavlja iskačućeg prozora sa porukama.';
$string['messagingbackgroundcolor'] = 'Boja pozadine glavnog prozora privatne poruke';
$string['messagingbackgroundcolordesc'] = 'Podesite boju pozadine glavnog prozora privatnih poruka.';
$string['mobilemenubkcolor'] = 'Boja pozadine menija na mobilnim uređajima';
$string['mobilemenubkcolordesc'] = 'Podesite boju pozadine glavnog menija na mobilnim uređajima (skupljeno)';
$string['moodledocs'] = 'Link ka Moodle dokumentaciji';
$string['moodledocsdesc'] = 'Prikazuje link ka Moodle dokumentaciji u podnožju stranice';
$string['msgbadgecolor'] = 'Boja pozadina markera nepročitanih poruka';
$string['msgbadgecolordesc'] = 'Podesite boju pozadina markera (mehurića) poruka u zaglavlju (koji prikazuje broj nepročitanih poruka).';
$string['myblogs'] = 'Moji blogovi';
$string['mycoursesmenulimit'] = 'Ograničenje menija "Moji kursevi"';
$string['mycoursesmenulimitdesc'] = 'Podesite maksimalan broj kurseva koji se pojavljuju u padajućem meniju "Moji kursevi". 0 će prikazati sve kurseve.';
$string['mysites'] = 'Moji kursevi';
$string['mysitesdisabled'] = 'Onemogući';
$string['mysitesexclude'] = 'Omogući isključivanje sakrivenih kurseva';
$string['mysitesinclude'] = 'Omogući uključivanje sakrivenih kurseva';
$string['mysitesmaxlength'] = 'Maksimalna dužina naziva mojih kurseva';
$string['mysitesmaxlengthdesc'] = 'Podesite maksimalnu dužinu naziva kurseva u padajućem meniju ”Moji kursevi”.';
$string['mysitessortoverride'] = 'Omogući prilagođeno sortiranje u meniju ”Moji kursevi”';
$string['mysitessortoverridedesc'] = 'Upotrebite prilagođena polja profila ili generičke stringove (godina itd) kako biste skupili protekle kurseve u podmeniju.';
$string['mysitessortoverridefield'] = 'Prilagođena polja profila ili stringovi za meni ”Moji kursevi”';
$string['mysitessortoverridefielddesc'] = 'Spisak polja profila ili stringova, razdvojenih zarezom, za proveru u kratkim kôdovim kurseva.';
$string['mysitessortoverrideoff'] = 'Prikaži sve upisane kurseve kao običan spisak';
$string['mysitessortoverrideprofilefields'] = 'Prikaži kurseve pronađene u poljima profila u prvom spisku, ostale u podmeniju';
$string['mysitessortoverrideprofilefieldscohort'] = 'Prikaži kurseve pronađene u poljima profila i kohortama u prvom spisku, ostale u podmeniju';
$string['mysitessortoverridestrings'] = 'Prikaži upisane kurseve koji sadrže stringove u prvom spisku, ostale u podmeniju';
$string['navbarcachetime'] = 'Vreme keširanja navigacione trake';
$string['navbarcachetimedesc'] = 'Broj minuta tokom kojih se kešira navigaciona traka.';
$string['navbardesc'] = 'Omogućava vam da kontrolišete sve elemente koji se pojavljuju u navigacionoj traci.';
$string['navbarmenusettings'] = 'Navigaciona traka - meni ”Alati”';
$string['navbarmenusettingsdesc'] = 'Omogućava vam da dodate meni u navigacionu traku.';
$string['navbarmenusettingsheading'] = 'Prilagodite meni u navigacionoj traci. Pogledajte primer rasporeda elemenata na stranici <a href="./../theme/adaptable/pix/layout.png" target="_blank">ovde</a>';
$string['navbarsettings'] = 'Zaglavlje - navigaciona traka';
$string['navbarsettingsheading'] = 'Prilagodite navigacionu traku';
$string['newmenu'] = 'Gornji padajući meni';
$string['newmenu1trigger'] = 'Reč okidač za Gornji padajući meni 1';
$string['newmenu1triggerdesc'] = 'Podesite reč okidač za Gornji padajući meni 1. Mogu da se koriste  Font Awesome ikonice.';
$string['newmenu2trigger'] = 'Reč okidač za Gornji padajući meni 2';
$string['newmenu2triggerdesc'] = 'Podesite reč okidač za Gornji padajući meni 2. Mogu da se koriste  Font Awesome ikonice.';
$string['newmenudesc'] = 'Konfigurišite linkovi koji će biti prikazani u meniju gornjeg zaglavlja.';
$string['newmenufield'] = 'Naziv prilagođenog polja profila=Vrednost (opciono)';
$string['newmenufielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: "usertype=student"';
$string['newmenuheading'] = 'Gornji meni';
$string['newmenurequirelogin'] = 'Zahteva prijavu na sistem';
$string['newmenurequirelogindesc'] = 'Ako je podešavanje omogućeno, ovaj meni će videti samo prijavljeni korisnici';
$string['newmenutitle'] = 'Naslov Gornjeg menija';
$string['newmenutitledefault'] = 'Meni';
$string['newmenutitledesc'] = 'Naslov padajućeg menija koji se pojavljuje u zaglavlju vašeg sajta';
$string['newstickercount'] = 'Broj sekcija pokretne trake sa vestima';
$string['newstickercountdesc'] = 'Definišite više sekcija pokretne trake sa vestima, zajedno sa pravilima pristupa kako biste targetirali različitu publiku.';
$string['nextsection'] = 'Sledeća sekcija';
$string['noenrolments'] = 'Nije pronađen nijedan upis na kurs.';
$string['nostyle'] = 'Bez stila';
$string['pageheaderheight'] = 'Visina zaglavlja stranice';
$string['pageheaderheightdesc'] = 'Podesite visinu regiona glavnog zaglavlja (koji sadrži logo i naslove)';
$string['passwordplaceholder'] = 'Lozinka';
$string['pastcourses'] = 'Protekli kursevi';
$string['people'] = 'Ljudi';
$string['piwikenabled'] = 'Omogućeno';
$string['piwikenableddesc'] = 'Omogućite Piwik praćenje podataka za Moodle.';
$string['piwikimagetrack'] = 'Praćenje slika';
$string['piwikimagetrackdesc'] = 'Omogućite praćenje slike na Moodle sajtu za veb čitače kod kojih je isključen JavaScript.';
$string['piwiksettings'] = 'Piwik Analytics';
$string['piwiksettingsdesc'] = 'Generiše pročišćenu URL adresu za napredno praćenje.';
$string['piwiksettingsheading'] = 'Piwik podešavanja';
$string['piwiksiteid'] = 'ID oznaka sajta';
$string['piwiksiteiddesc'] = 'Unesite ID oznaku vašeg sajta';
$string['piwiksiteurl'] = 'Piwik URL adresa';
$string['piwiksiteurldesc'] = 'Unesite URL adresu za Piwik Analytics  bez http(s) i pratećih kosih crta';
$string['piwiktrackadmin'] = 'Praćenje administratora';
$string['piwiktrackadmindesc'] = 'Omogućite praćenje administratora (ne preporučuje se)';
$string['pluginname'] = 'Adaptable';
$string['previoussection'] = 'Prethodna sekcija';
$string['region-course-bottom-a'] = 'Dno stranice kursa - region 5';
$string['region-course-bottom-b'] = 'Dno stranice kursa - region 6';
$string['region-course-bottom-c'] = 'Dno stranice kursa - region 7';
$string['region-course-bottom-d'] = 'Dno stranice kursa - region 8';
$string['region-course-top-a'] = 'Vrh stranice kursa - region 1';
$string['region-course-top-b'] = 'Vrh stranice kursa - region 2';
$string['region-course-top-c'] = 'Vrh stranice kursa - region 3';
$string['region-course-top-d'] = 'Vrh stranice kursa - region 4';
$string['region-frnt-footer'] = 'Podnožje';
$string['region-frnt-market-a'] = 'Region stranice 1';
$string['region-frnt-market-b'] = 'Region stranice 2';
$string['region-frnt-market-c'] = 'Region stranice 3';
$string['region-frnt-market-d'] = 'Region stranice 4';
$string['region-frnt-market-e'] = 'Region stranice 5';
$string['region-frnt-market-f'] = 'Region stranice 6';
$string['region-frnt-market-g'] = 'Region stranice 7';
$string['region-frnt-market-h'] = 'Region stranice 8';
$string['region-frnt-market-i'] = 'Region stranice 9';
$string['region-frnt-market-j'] = 'Region stranice 10';
$string['region-frnt-market-k'] = 'Region stranice 11';
$string['region-frnt-market-l'] = 'Region stranice 12';
$string['region-frnt-market-m'] = 'Region stranice 13';
$string['region-frnt-market-n'] = 'Region stranice 14';
$string['region-frnt-market-o'] = 'Region stranice 15';
$string['region-frnt-market-p'] = 'Region stranice 16';
$string['region-frnt-market-q'] = 'Region stranice 17';
$string['region-frnt-market-r'] = 'Region stranice 18';
$string['region-frnt-market-s'] = 'Region stranice 19';
$string['region-frnt-market-t'] = 'Region stranice 20';
$string['region-side-post'] = 'Desno';
$string['region-side-pre'] = 'Levo';
$string['regionmaincolor'] = 'Boja glavnog regiona';
$string['regionmaincolordesc'] = 'Podesite boju pozadine za region sa glavnim sadržajem.';
$string['rendereroverlaycolor'] = 'Boja prekrivača';
$string['rendereroverlaycolordesc'] = 'Boja prekrivača, kada je izabrana opcija prikaza \'Pločice sa prekrivačem\'.';
$string['rendereroverlayfontcolor'] = 'Boja fonta prekrivača';
$string['rendereroverlayfontcolordesc'] = 'Boja fonta kada se mišem pređe preko polja kursa (u situaciji kada je omogućena opcija prikaza \'Pločice sa prekrivačem\').';
$string['rightblocks'] = 'Desna strana';
$string['savebuttontext'] = 'Sačuvaj promene';
$string['searchboxpadding'] = 'Slobodan prostor oko polja za pretragu';
$string['searchboxpaddingdesc'] = 'Podesite udaljenost polja za pretragu od ivica stranice (ako se ovo polje koristi umesto ikonica društvenih mreža) <br />Npr. 5px 10px 5px 10px (gore, desno, dole, levo).<br> Ikonice društvenih mreža možete podesiti na stranici za podešavanje <a href="./../admin/settings.php?section=theme_adaptable_social">Zaglavlje - društvene mreže</a>.';
$string['sectionheadingcolor'] = 'Boja teksta naslova sekcije';
$string['sectionheadingcolordesc'] = 'Podesite boju za tekst naslova sekcije';
$string['selectionbackground'] = 'Boja pozadine izabranog teksta';
$string['selectionbackgrounddesc'] = 'Podesite boju pozadine teksta koji je izabran na ekranu.';
$string['selectiontext'] = 'Boja izabranog teksta';
$string['selectiontextdesc'] = 'Podesite boju teksta koji je izabran na ekranu.';
$string['settingsalertbox'] = 'Okvir sa važnim obaveštenjem';
$string['settingsanalytics'] = 'Analitika';
$string['settingsborders'] = 'Bordure';
$string['settingsbreadcrumbcolors'] = 'Boje navigacione putanje';
$string['settingscolors'] = 'Boje';
$string['settingsfonts'] = 'Fontovi';
$string['settingsfootercolors'] = 'Boje podnožja';
$string['settingsforumheading'] = 'Forum';
$string['settingsheadercolors'] = 'Boje zaglavlja';
$string['settingsinfoboxcolors'] = 'Boje info-bloka';
$string['settingsmaincolors'] = 'Glavne boje';
$string['settingsmarketingcolors'] = 'Boje promotivnih blokova';
$string['settingsmessagescolors'] = 'Boje iskačućeg prozora sa porukama';
$string['settingsnavbarcolors'] = 'Boje navigacione trake';
$string['settingsoverlaycolors'] = 'Boje pločica prekrivača';
$string['settingssecondinfoboxcolors'] = 'Boje sekundarnog info-bloka';
$string['settingstopicsweeks'] = 'Teme/Sedmice';
$string['show'] = 'Prikaži';
$string['showblocks'] = 'Prikaži blokove';
$string['showfooterblocks'] = 'Prikaži blokove podnožja';
$string['showfooterblocksdesc'] = 'Prikaži/sakrij četiri podesiva bloka u podnožju stranice';
$string['side-post1'] = 'bočni stubac sa blokovima u podnožju';
$string['sitetitle'] = 'Prikaži naslov sajta';
$string['sitetitlecoursesdisabled'] = 'Onemogućeno - prikaži samo naslove kurseva na stranicama kurseva';
$string['sitetitlecoursesenabled'] = 'Omogućeno - prikaži naslov sajta i naslove kurseva na stranicama kurseva';
$string['sitetitlecustom'] = 'Koristite prilagođeni naslov sajta (unesite ga u donje tekstualno polje)';
$string['sitetitledefault'] = 'Koristi naslov Moodle sajta (naziv sajta)';
$string['sitetitledesc'] = 'Prikazuje podrazumevani naslov Moodle sajta preuzet iz <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Podešavanja naslovne stranice</a> ili unesite u donje polje prilagođeni naziv sajta. Ako dodate sliku logotipa onda naslov neće biti prikazan.';
$string['sitetitleoff'] = 'Onemogući naslov sajta';
$string['sitetitletext'] = 'Naslov sajta';
$string['sitetitletextdesc'] = 'Naslov sajta koji se prikazuje u zaglavlju. Možete da koristite bilo koju HTML oznaku i primeniti umetnute stilove.';
$string['slider2h3bgcolor'] = 'Slajd-šou 2 - boja pozadine H3 oznake';
$string['slider2h3bgcolordesc'] = 'Izaberite boju pozadine koju želite za oznaku H3 (za slajd-šou stil 2)';
$string['slider2h3color'] = 'Slajd-šou 2 - boja teksta oznake H3';
$string['slider2h3colordesc'] = 'Izaberite boju teksta koju želite za oznaku H3 (za slajd-šou stil 2)';
$string['slider2h4bgcolor'] = 'Slajd-šou 2 - boja pozadine H4 oznake';
$string['slider2h4bgcolordesc'] = 'Izaberite boju pozadine koju želite za oznaku H4 (za slajd-šou stil 2)';
$string['slider2h4color'] = 'Slajd-šou 2 - boja teksta oznake H4';
$string['slider2h4colordesc'] = 'Izaberite boju teksta koju želite za oznaku H4 (za slajd-šou stil 2)';
$string['slidercaption'] = 'Natpis na slajdu';
$string['slidercaptiondesc'] = 'Dodajte natpis za vaš slajd';
$string['slidercount'] = 'Broj slajdova';
$string['slidercountdesc'] = 'Izaberite koliko slajdova želite da dodate, a <strong>onda kliknite na dugme \'SAČUVAJ\'</strong> kako bi se učitala polja za unos podešavanja.';
$string['sliderenabled'] = 'Omogući slajd-šou';
$string['sliderenableddesc'] = 'Omogućite slajd-šou na vrhu vaše početne stranice';
$string['sliderfullscreen'] = 'Slajd-šou preko celog ekrana';
$string['sliderfullscreendesc'] = 'Označite ovo polje kako bi slajd-šou bio prikazan preko celog ekrana (100% širine)';
$string['sliderh3color'] = 'Slajd-šou 1 - boja H3 oznake';
$string['sliderh3colordesc'] = 'Izaberite boju koju želite za oznaku H3 (za slajd-šou stil 1)';
$string['sliderh4color'] = 'Slajd-šou 1 - boja H4 oznake';
$string['sliderh4colordesc'] = 'Izaberite boju koju želite za oznaku H4 (za slajd-šou stil 1)';
$string['sliderimage'] = 'Slika slajda';
$string['sliderimagedesc'] = 'Dodajte sliku za vaš slajd. Preporučena veličina je 1600 x 400 piksela ili veća.';
$string['slidermarginbottom'] = 'Slajd-šou - donja margina';
$string['slidermarginbottomdesc'] = 'Podesite veličinu margine ispod slajd-šou prezentacije.';
$string['slidermargintop'] = 'Slajd-šou - gornja margina';
$string['slidermargintopdesc'] = 'Podesite veličinu margine iznad slajd-šou prezentacije';
$string['slideroption2'] = 'Izaberi tip slajd-šou prezentacije';
$string['slideroption2a'] = 'Boja pozadine strelice (slajd-šou stil 2)';
$string['slideroption2adesc'] = 'Podesite boju pozadine strelice (za slajd-šou stil 2).';
$string['slideroption2color'] = 'Slajd-šou 2 - pozadina dugmeta';
$string['slideroption2colordesc'] = 'Podesite boju pozadine dugmeta (za slajd-šou stil 2)';
$string['slideroption2desc'] = 'Izaberite tip slajd-šou prezentacije, a <strong>onda kliknite na dugme \'SAČUVAJ\'</strong> kako biste videla podešavanja boja za izabrani tip prezentacije.';
$string['slideroption2snippet'] = '<p>Primer HTML-a za natpis na slajdu:</p>
<pre>
<div class="span6 col-sm-6">
<h3>Mudl Mreža Srbije</h3> <h4>Asocijacija mudlera Srbije</h4>
<a href="#" class="submit">Posetite naš sajt!</a>
</pre>';
$string['slideroption2submitcolor'] = 'Slajd-šou 2 - tekst dugmeta';
$string['slideroption2submitcolordesc'] = 'Podesite boju teksta na dugmetu (za slajd-šou stil 2)';
$string['sliderstyle1'] = 'Slajd-šou - stil 1';
$string['sliderstyle2'] = 'Slajd-šou - stil 2';
$string['slidersubmitbgcolor'] = 'Slajd-šou 1 - pozadina dugmeta';
$string['slidersubmitbgcolordesc'] = 'Izaberite boju pozadine dugmeta (za slajd-šou stil 1)';
$string['slidersubmitcolor'] = 'Slajd-šou 1 - tekst dugmeta';
$string['slidersubmitcolordesc'] = 'Izaberite boju teksta na dugmetu (za slajd-šou stil 1)';
$string['sliderurl'] = 'URL adresa linka slajda';
$string['sliderurldesc'] = 'Dodajte URL adresu sa kojom će vaš slajd biti povezan kada se klikne na njega.';
$string['slideshowdesc'] = 'Postavite slike, dodajte linkove i opis za karusel slajdova na naslovnoj stranici.';
$string['slideshowsettings'] = 'Slajd-šou';
$string['slideshowsettingsheading'] = 'Prilagodite karusel slajdova na naslovnoj stranici. Pogledajte primer rasporeda elemenata na stranici <a href="./../theme/adaptable/pix/layout.png" target="_blank">ovde</a>';
$string['socialheading'] = 'Podešavanje ikonica društvenih mreža';
$string['socialicondesc'] = 'Podesite Font Awesome ikonice, na primer: fa-facebook';
$string['socialiconlist'] = 'Spisak ikonica društvenih mreža';
$string['socialiconlistdesc'] = 'Unesite spisak sa graničnicima, kako biste podesili ikonice društvenih mreža / linkove koji su vam potrebni, koristeći format: url|title|icon';
$string['socialpaddingtop'] = 'Podesite razmak iznad ikonica društvenih mreža (menja vertikalni položaj)';
$string['socialsearchicon'] = 'Pretraži Moodle';
$string['socialsearchicondesc'] = 'Ovo podešavanje omogućava da se postavi link za pretragu uporedo sa ikonicama društvenih mreža (pošto njihovo korišćenje onemogućava polje za pretragu na čitavom sajtu).';
$string['socialsettings'] = 'Zaglavlje - društvene mreže';
$string['socialsize'] = 'Podesi veličinu fonta za ikonice društvenih mreža';
$string['socialtarget'] = 'Odredište linkova društvenih mreža';
$string['socialtargetdesc'] = 'Kako želite da se linkovi društvenih mreža otvaraju (u istom ili novom prozoru).';
$string['socialtitledesc'] = 'Možete da onemogućite polje za pretragu na čitavom sajtu i umesto njega omogućite ikonice / linkove društvenih mreža.
Da biste podesili ikonice društvenih mreža unesite spisak sa graničnicima u donje polje "Spisak ikonica društvenih mreža".
Spisak treba da bude u formatu:

url|title|icon

Na primer:
<pre>
https://example.com/course/search.php|Search Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
https://example.com|My Web|fa-globe
</pre>
Kompletan spisak Font Awesome ikonica možete naći <a href="https://fortawesome.github.io/Font-Awesome/icons/">ovde</a>.';
$string['socialwall'] = 'Društveni zid';
$string['socialwallactionlinkcolor'] = 'Boja linka akcije';
$string['socialwallactionlinkcolordesc'] = 'Boja linka reakcije korisnika (”Sviđa mi se” / Napiši komentar”) na kursu u formatu ”Društveni zid”.';
$string['socialwallactionlinkhovercolor'] = 'Lebdeća boja linka akcije';
$string['socialwallactionlinkhovercolordesc'] = 'Boja linka reakcije korisnika (”Sviđa mi se” / Napiši komentar”), kada se mišem pređe preko njega, na kursu u formatu ”Društveni zid”.';
$string['socialwallbackgroundcolor'] = 'Boja pozadine';
$string['socialwallbackgroundcolordesc'] = 'Boja pozadine kursa u formatu ”Društveni zid”';
$string['socialwallbordercolor'] = 'Boja bordure';
$string['socialwallbordercolordesc'] = 'Boja bordure sekcija kursa u formatu ”Društveni zid”.';
$string['socialwallbordertopstyle'] = 'Stil bordure';
$string['socialwallbordertopstyledesc'] = 'Boja bordure sekcija kursa u formatu ”Društveni zid”.';
$string['socialwallborderwidth'] = 'Širina bordure';
$string['socialwallborderwidthdesc'] = 'Širina bordure sekcije kursa u formatu "Društveni zid"';
$string['socialwalldesc'] = 'Prilagodite izgled <a href="https://moodle.org/plugins/format_socialwall">formata kursa ”Društveni zid”</a> (ukoliko se koristi na vašem sajtu).';
$string['socialwallheading'] = 'Društveni zid - podešavanja';
$string['socialwallsectionradius'] = 'Poluprečnik bordure';
$string['socialwallsectionradiusdesc'] = 'Poluprečnik bordure sekcije kursa u formatu "Društveni zid"';
$string['standardview'] = 'Standardni prikaz';
$string['stickynavbar'] = 'Lepljiva navigaciona traka na vrhu';
$string['stickynavbardesc'] = 'Fiksirajte navigacionu traku za vrh ekrana prilikom premotavanja sadržaja  stranice.';
$string['targetnewwindow'] = 'Novi prozor';
$string['targetsamewindow'] = 'Isti prozor';
$string['thiscourse'] = 'Ovaj kurs';
$string['ticker'] = 'Najave';
$string['tickerdefault'] = 'Nema novih vesti za prikaz';
$string['tickerdesc'] = 'Ovde možete podesiti pokretnu traku sa vestima koja se kreće preko naslovne stranice vašeg Moodle sajta.
Njena namena je da bude manje nametljiva alternativa za slajd-šou, s obzirom da zauzima vrlo malo prostora.
Da biste podesili pokretnu traku sa vestima jednostavno unesite spisak  vesti, zajedno sa  hiperlinkovima koji su vam potrebni u tekstu vesti.
<strong>Napomena:</strong> Ako se vaša pokretna traka sa vestima ne učitava ispravno prebacite se na HTML prikaz i proverite da imate samo &lt;p&gt; oznake:
<pre>
&lt;p&gt;Prva vest.....&lt;/p&gt;
&lt;p&gt; Druga vest.....&lt;/p&gt;
</pre>';
$string['tickerfullscreen'] = 'Prikaz preko celog ekrana';
$string['tickersettings'] = 'Pokretna traka sa vestima';
$string['tickersettingsheading'] = 'Prilagodite pokretnu traku sa vestima na naslovnoj stranici. Pogledajte primer rasporeda elemenata na stranici <a href="./../theme/adaptable/pix/layout.png" target="_blank">ovde</a>';
$string['tickertext'] = 'Tekst pokretne trake sa vestima';
$string['tickertextdesc'] = 'Dodajte tekst za pokretnu traku sa vestima u formatu spiska. Pogledajte readme.txt datoteku za više informacija.';
$string['tickertextprofilefield'] = 'Naziv prilagođenog polja profila=vrednost (opciono)';
$string['tickertextprofilefielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: "usertype=student"';
$string['tickerwidth'] = 'Fiksna širina';
$string['tickerwidthdesc'] = 'Možete koristiti ovo podešavanje kako biste fiksirali pokretnu traku sa  vestima na 100% širine.';
$string['tilesbordercolor'] = 'Boja bordure pločica okvira kursa';
$string['tilesbordercolordesc'] = 'Podesite boju bordure pločica okvira kursa.';
$string['tilescontactstitle'] = 'Prikaži uloge kontakt osoba';
$string['tilescontactstitledesc'] = 'Prikažite / sakrijte ulogu kontakt osoba na kursu. Ako se ne prikazuje, biće prikazana slika pored svake kontakt osobe.';
$string['tilesshowallcontacts'] = 'Prikaži sve kontakt osobe';
$string['tilesshowallcontactsdesc'] = 'Prikažite sve kontakt osobe na kursu ili samo jednu.';
$string['tilesshowcontacts'] = 'Prikaži kontakt osobe';
$string['tilesshowcontactsdesc'] = 'Prikažite / sakrijte kontakt osobe na kursu.';
$string['toolsmenu'] = 'Padajući meni \'Alati';
$string['toolsmenu2'] = 'Drugi meni \'Alati';
$string['toolsmenu2desc'] = 'Možete da konfigurišete linkove u okviru menija ”Alati”. Svaki red se sastoji od teksta stavke u meniju, odgovarajuće URL adrese linka (opciono), kratkog opisa stavke (opciono), kao i oznake jezika ili liste oznaka jezika, odvojenih zarezima, (opciono, za prikaz tog reda isključivo korisnicima navedenog jezika) koji su međusobno odvojeni vertikalnom crtom |. Možete da odredite i strukturu menija koristeći crtice. Na primer:
<pre>
Moodle zajednica|https://moodle.org
-Moodle besplatna podrška|https://moodle.org/support
-Moodle razvoj|https://moodle.org/development
--Moodle dokumentacija|https://docs.moodle.org|Moodle dokumentacija
--Moodle dokumentacija na nemačkom|http://docs.moodle.org/de|Dokumentacija na nemačkom
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenudesc'] = 'Dodajte padajući meni u glavnu navigacionu traku';
$string['toolsmenufield'] = 'Naziv prilagođenog polja profila=vrednost (opciono)';
$string['toolsmenufielddesc'] = 'Dodajte pravilo pristupa koristeći prilagođeno polje profila, npr: "usertype=student"';
$string['toolsmenuheading'] = 'Meni ”Alati”';
$string['toolsmenuheadingdesc'] = 'Možete da konfigurišete linkove u okviru menija \'Alati\' (u glavnoj navigacionoj traci. Format je sličan onom koji se koristi za Moodle prilagođene menije, ali vam omogućava da uz stavke menija dodate Font Awesome ikonice:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenulabel'] = 'Meni ”Alati”';
$string['toolsmenulabel2'] = 'Alati 2';
$string['toolsmenuscount'] = 'Broj menija ”Alati”';
$string['toolsmenuscountdesc'] = 'Podesite broj menija ”Alati” koje želite da dodate u glavnu navigacionu traku';
$string['toolsmenutitle'] = 'Naslov menija ”Alati”';
$string['toolsmenutitledefault'] = 'Alati';
$string['toolsmenutitledesc'] = 'Dodajte naslov menija koji  želite da prikažete u glavnoj navigacijionoj traci';
$string['topicsweeks'] = 'Tematski/Sedmični format kursa';
$string['topicsweeksdesc'] = 'Podesite stilove za Tematski/Sedmični format kursa';
$string['topmenufontsize'] = 'Veličina fonta Gornjeg menija';
$string['topmenufontsizedesc'] = 'Podesite veličinu fonta menija u gornjem zaglavlju';
$string['topmenuscount'] = 'Broj gornjih menija';
$string['topmenuscountdesc'] = 'Podesite broj gornjih menija koje želite da dodate u navigacionu traku';
$string['usernav'] = 'Zaglavlje - korisnički meni';
$string['usernavdesc'] = 'Omogućava vam da kontrolišete sve elemente koji se pojavljuju u korisničkom padajućem meniju.';
$string['usernavheading'] = 'Prilagodite korisnički padajući meni';
