<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'sr_lt', version '3.11'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcija';
$string['actions'] = 'Akcije';
$string['addappointment'] = 'Dodaj još jednog polaznika';
$string['addcommands'] = 'Dodaj termine';
$string['addondays'] = 'Dodaj sastanke za';
$string['addsession'] = 'Dodaj termine koji se ponavljaju';
$string['addsingleslot'] = 'Dodaj pojedinačni termin';
$string['addslot'] = 'Možete dodati još termina u svako doba.';
$string['addstudenttogroup'] = 'Dodaj ovoj polaznika zakazanoj grupi';
$string['allappointments'] = 'Svi sastanci';
$string['allononepage'] = 'Svi termini na jednoj stranici';
$string['allowgroup'] = 'Ekskluzivan termin - kliknite za izmenu statusa';
$string['alreadyappointed'] = 'Nije moguće zakazati sastanak. Termin je već potpuno popunjen.';
$string['appointagroup_help'] = 'Odaberite da li želite da zakažete sastanak samo za sebe ili za celu grupu.';
$string['appointforgroup'] = 'Napravi sastanke za: {$a}';
$string['appointingstudent'] = 'Sastanak u terminu';
$string['appointingstudentinnew'] = 'Sastanak u novom terminu';
$string['appointment'] = 'Sastanak';
$string['appointmentmode'] = 'Podešavanje režima rada za sastanak';
$string['appointmentmode_help'] = '<p>Ovde možete odabrati neke varijante realizacije sastanaka. </p>
<p><ul>
<li><strong>"<emph>n</emph> sastanak u ovom planeru":</strong> Polaznik može da zakaže precizno određen broj sastanaka u okviru ove aktivnosti. Čak i ako prvobitno zakazane sastanke predavač označi kao "Održane" , polazniku neće biti dozvoljeno da zakazuje dalje susrete. Jedini način da se resetuje sposobnost polaznika da zakazuje sastanke je da se obrišu stari termini koji su već realizovani.</li>
<li><strong>"<emph>n</emph> sastanaka odjednom":</strong> Polaznik može da zakaže precizno određen broj sastanaka. Jednom kad se neki sastanak završi i predavač ga označi "Održanim" polaznik može da zakazuje naredni susret. U svakom trenutku je ograničen na <emph>n</emph> "otvorenih" (neodržanih) termina.
</li>
</ul>
</p>';
$string['appointmentno'] = 'Sastanak {$a}';
$string['appointments'] = 'Sastanci';
$string['appointmentsgrouped'] = 'Sastanci grupisani po terminima';
$string['appointmentsummary'] = 'Sastanak u {$a->startdate} od {$a->starttime} do {$a->endtime} sa predavačem pod imenom {$a->teacher}';
$string['appointsolo'] = 'samo ja';
$string['appointsomeone'] = 'Dodaj novi sastanak';
$string['attendable'] = 'Može se prisustvovati';
$string['attendablelbl'] = 'Ukupan broj kandidata za zakazivanje';
$string['attended'] = 'Prisustvovano';
$string['attendedlbl'] = 'Broj polaznika koji su prisustvovali sastanku';
$string['attendedslots'] = 'Termini u kojima je prisustvovano';
$string['availableslots'] = 'Raspoloživi termini';
$string['availableslotsall'] = 'Svi termini';
$string['availableslotsnotowned'] = 'Nije posedovan';
$string['availableslotsowned'] = 'Posedovan';
$string['bookslot'] = 'Rezerviši termin';
$string['bookwithteacher'] = 'Predavač';
$string['bookwithteacher_help'] = 'Odaberite predavača za sastanak.';
$string['break'] = 'Pauza između termina';
$string['breaknotnegative'] = 'Dužina pauze ne sme biti negativna';
$string['canbook1appointment'] = 'Možete zakazati još jedan sastanak u ovom planeru.';
$string['canbooknappointments'] = 'Možete zakazati još {$a} sastan(a)ka u ovom planeru.';
$string['canbooknofurtherappointments'] = 'Ne možete zakazati više sastanaka u ovom planeru.';
$string['canbooksingleappointment'] = 'Možete zakazati jedan sastanak u ovom planeru.';
$string['canbookunlimitedappointments'] = 'Možete zakazati koliko god želite sastanaka u ovom planeru.';
$string['cancelbooking'] = 'Otkaži rezervaciju';
$string['chooseexisting'] = 'Izaberi postojeći';
$string['choosingslotstart'] = 'Izaberite vreme početka';
$string['choosingslotstart_help'] = 'Promenite (ili odaberite) vreme početka sastanka. Ako je ono u koliziji sa nekim drugim terminom bićete pitani da li ovaj termin zamenjuje sve sastanke s kojima se preklapa. Imajte na umu da će parametri novog termina biti sačuvani umesto svih prethodnih podešavanja.';
$string['comments'] = 'Komentari';
$string['complete'] = 'Zakazan';
$string['conflictingslots'] = 'Preklapa se';
$string['contentformat'] = 'Format';
$string['contentformat_help'] = '<p>Postoje tri osnovna formata za izvoz, koji se razlikuju po tome kako tretiraju termine sa više zakazanih sastanaka.
     <dl>
         <dt>Jedan red po terminu</dt>:
         <dd>
             Izlazna datoteka će sadržati jedan red za svaki termin. Ako termin sadrži više sastanaka umesto imena polaznika i sl. biće upisana oznaka "više".
         </dd>
         <dt>Jedan red po sastanku</dt>:
         <dd>
             Izlazna datoteka će sadržati jedan red za svaki sastanak. Ako termin sadrži više sastanaka pojaviće se više puta  na spisku (sa ponovljenim podacima o njemu).
         </dd>
         <dt>Sastanci grupisani po terminima</dt>:
         <dd>
             Svi sastanci zakazani za jedan termin se grupišu i tako upisuju u izlaznu datoteku uz liniju zaglavlja u kojoj se navodi o kom je terminu reč. Ova opcija možda neće dobro raditi u slučaju odabira CSV formata izlazne datoteke pošto broj kolona nije konstantan.
         </dd>
    </dl>
    Možete proučiti efekte aktivacije ovih opcija klikom na dugme sa natpisom "Pregled".</p>';
$string['course'] = 'Kurs';
$string['createexport'] = 'Kreiraj izlaznu datoteku';
$string['csvfieldseparator'] = 'Granični znak za CSV';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Ukupno trajanje sastanaka';
$string['datatoinclude'] = 'Podaci koje treba uključiti';
$string['datatoinclude_help'] = 'Odaberite polja koja treba uključiti u izvoz. Svako od njih će se pojaviti u posebnoj koloni izvozne datoteke.';
$string['date'] = 'Datum';
$string['datelist'] = 'Pregled';
$string['defaultslotduration'] = 'Podrazumevano trajanje termina';
$string['defaultslotduration_help'] = 'Podrazumevana dužina (u minutima) za termine sastanaka koje podešavate';
$string['deleteallslots'] = 'Obriši sve termine';
$string['deleteallunusedslots'] = 'Obriši neiskorišćene termine';
$string['deletecommands'] = 'Obriši termine';
$string['deletemyslots'] = 'Obriši sve moje termine';
$string['deleteselection'] = 'Obriši izabrane termine';
$string['deletetheseslots'] = 'Obriši ove termine';
$string['deleteunusedslots'] = 'Obriši moje neiskorišćene termine';
$string['department'] = 'Odakle?';
$string['disengage'] = 'Otkaži moje sastanke';
$string['displayfrom'] = 'Prikaz sastanaka polaznicima od dana';
$string['distributetoslot'] = 'Distribuiraj celoj grupi';
$string['divide'] = 'Podeli u termine?';
$string['duration'] = 'Trajanje';
$string['durationrange'] = 'Dužina termina mora biti između {$a->min} i {$a->max} minuta.';
$string['email_applied_html'] = '<p>Zakazan je sastanak za {$a->date} u {$a->time},<br/>
od strane polaznika pod imenom <a href="{$a->attendee_url}">{$a->attendee}</a> na kursu:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>korišćenjem planera pod naslovom "<em>{$a->module}</em>" na sajtu: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'Za sastanak je dana {$a->date} u {$a->time} prijavljen polaznik {$a->attendee} na kursu:

{$a->course_short}: {$a->course}

korišćenjem planera pod naslovom "{$a->module}" na sajtu: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Novi sastanak';
$string['email_cancelled_html'] = '<p>Vaš sastanak zakazan za <strong>{$a->date}</strong> u <strong>{$a->time}</strong>,<br/>
sa polaznikom pod imenom <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> na kursu:</p>

<p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>u planeru pod naslovom "<em>{$a->module}</em>" na sajtu: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">je otkazan ili pomeren</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Vaš sastanak za dan  {$a->date} u {$a->time},
sa polaznikom {$a->attendee} na kursu:

{$a->course_short} : {$a->course}

u planeru pod naslovom "{$a->module}" na sajtu: {$a->site}

je otkazan ili pomeren.';
$string['email_cancelled_subject'] = '{$a->course_short}: Sastanak je otkazan ili pomeren od strane polaznika';
$string['email_reminder_html'] = '<p>Približava se sastanak zakazan za <strong>{$a->date}</strong>
od <strong>{$a->time}</strong> do <strong>{$a->endtime}</strong><br/>
sa korisnikom pod imenom <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Lokacija: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Približava se sastanak zakazan za {$a->date} od {$a->time} do {$a->endtime}
sa polaznikom pod imenom {$a->attendant}.

Lokacija: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Podsetnik o sastanku';
$string['email_teachercancelled_html'] = '<p>Vaš sastanak zakazan za <strong>{$a->date}</strong> u <strong>{$a->time} </strong>,<br/>
sa {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> na kursu:</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>u planeru "<em>{$a->module}</em>" na sajtu: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">je otkazan</span></strong>. Molimo prijavite se za novi termin.</p>';
$string['email_teachercancelled_plain'] = 'Vaš sastanak planiran za {$a->date} at {$a->time},
sa {$a->staffrole} {$a->attendant} na kursu:

{$a->course_short}: {$a->course}

prema planeru pod nazivom "{$a->module}" na sajtu: {$a->site}

je otkazan. Molimo prijavite se za novi termin.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Sastanak je otkazan od strane predavača';
$string['emailreminder'] = 'Pošalji podsetnik elektronskom poštom';
$string['emailreminderondate'] = 'Pošalji podsetnik elektronskom poštom dana';
$string['end'] = 'Završetak';
$string['enddate'] = 'Ponavljaj termine do';
$string['event_appointmentlistviewed'] = 'Prikazana je lista sastanaka u planeru';
$string['event_bookingadded'] = 'Dodat je zakazan termin u planer';
$string['event_bookingformviewed'] = 'Prikazan je formular za zakazivanje u planeru';
$string['event_bookingremoved'] = 'Uklonjen je zakazan termin iz planera';
$string['everyone'] = 'Svako';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Ekskluzivno';
$string['exclusivity'] = 'Ekskluzivnost';
$string['exclusivity_help'] = '<p>Možete ograničiti broj polaznika koji se mogu prijaviti za dati termin. </p>
<p>Postavljanje ograničenja na 1 (podrazumevano) će značiti da će termin biti raspoloživ samo jednom polazniku.</p>
<p>Postavljanje ograničenja na npr. 3 će značiti da se za njega može prijaviti do 3 polaznika.</p>
<p>Ako je ovo podešavanje isključeno bilo koji broj polaznika će moći da zakaže sastanak u tom terminu; on nikad neće biti smatran "popunjenim".</p>';
$string['exclusivityoverload'] = 'Termin je zakazan za {$a} polaznika, više nego što je dozvoljeno ovim podešavanjem.';
$string['exclusivitypositive'] = 'Broj polaznika po terminu mora biti 1 ili više.';
$string['explaingeneralconfig'] = 'Ove opcije se mogu podesiti isključivo na nivou sajta kako bi se primenile na sve planere na ovoj Moodle instalaciji.';
$string['export'] = 'Izvoz';
$string['exporthdr'] = 'Izvezi temine i sastanke';
$string['field-attended'] = 'Prisustvovao/la';
$string['field-date'] = 'Datum';
$string['field-endtime'] = 'Vreme završetka';
$string['field-grade'] = 'Ocena';
$string['field-location'] = 'Lokacija';
$string['field-maxstudents'] = 'Maksimalan broj polaznika';
$string['field-slotnotes'] = 'Beleške o terminu';
$string['field-starttime'] = 'Vreme početka';
$string['field-studentemail'] = 'Polaznikova adresa elektronske pošte';
$string['field-studentfirstname'] = 'Polaznikovo ime';
$string['field-studentfullname'] = 'Polaznikovo puno ime';
$string['field-studentidnumber'] = 'Polaznikov identifikacioni broj';
$string['field-studentlastname'] = 'Polaznikovo prezime';
$string['field-studentusername'] = 'Polaznikovo korisničko ime';
$string['fileformat'] = 'Format datoteke';
$string['fileformat_help'] = 'Raspoloživi su sledeći formati:
     <ul>
          <li>Tekstualna datoteka sa vrednostima razdvojenim zarezima (CSV). Znak za razdvajanje vrednosti, podrazumevano zarez, može se odabrati niže.
               CSV datoteke se mogu otvoriti u većini aplikacija za tabelarne proračune;</li>
          <li>Microsoft Excel datoteka (Excel 2007 format);</li>
          <li>Open Document tabela za proračune (ODS);</li>
          <li>HTML format - veb stranica na kojoj se prikazuje izlazna tabela,
                koja se može štampati korišćenjem opcija za štampu koje nudi čitač;</li>
          <li>PDF dokument. Možete birati između horizontalne i vertikalne orijentacije.</li>
     </ul>';
$string['finalgrade'] = 'Konačna ocena';
$string['firstslotavailable'] = 'Prvi termin će biti otvoren na dan: {$a}';
$string['forbidgroup'] = 'Grupni termin - kliknite za izmenu statusa';
$string['forcewhenoverlap'] = 'Forsiraj pri preklapanju';
$string['forcewhenoverlap_help'] = '<h3>Forsiranje kreiranja termina kad dođe do preklapanja</h3>
<p>Ovo podešavanja određuje kako će se tretirati novi termini u slučaju njihovog preklapanja sa drugim, već postojećim terminima.</p>
<p>Ako je uključeno postojeći termin koji se preklapa s novim će biti obrisan a novi će biti kreiran.</p>
<p>Ako je isključeno, postojeći termin koji se preklapa s novim će biti zadržan a novi <em>neće</em> biti kreiran.</p>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['forcourses'] = 'Odaberite studente sa kurseva';
$string['friday'] = 'Petak';
$string['generalconfig'] = 'Opšta podešavanja';
$string['grade'] = 'Ocena';
$string['gradeingradebook'] = 'Ocena u dnevniku ocena';
$string['gradingstrategy'] = 'Strategija ocenjivanja';
$string['gradingstrategy_help'] = 'Odaberite kako da se izračunavaju ocene kad polaznici mogu da imaju više sastanaka u planeru.
    Dnevnik ocena može da prikazuje ili <ul><li>prosečnu ocenu ili</li><li>maksimalnu ocenu</li></ul> koju je polaznik dobio.';
$string['group'] = 'grupa';
$string['groupbookings'] = 'Zakazivanje u grupama';
$string['groupbookings_help'] = 'Dozvoli polaznicima da zakažu termin za sve članove svoje grupe. (Primetite da se ovo razlikuje od podešavanja grupnog moda koji kontroliše koji termini se prkazuju polaznicima.)';
$string['groupbreakdown'] = 'Prema veličini grupe';
$string['groupmodeyourgroups'] = 'Grupni mod: {$a->groupmode}. Samo polaznici u {$a->grouplist} mogu da zakažu sastanak sa Vama.';
$string['groupmodeyourgroupsempty'] = 'Grupni mod: {$a->groupmode}. Niste član nijedne grupe pa polaznici ne mogu da zakažu sastanak sa Vama.';
$string['groupscheduling'] = 'Omogući grupno zakazivanje';
$string['groupscheduling_desc'] = 'Dozvoli zakazivanje za cele grupe odjednom.
(Osim globalne opcije, podešavanje "Zakazivanje u grupama" mora biti aktivirano u postavkama konkretnog planera.)';
$string['groupsession'] = 'Grupna sesija';
$string['groupsize'] = 'Veličina grupe';
$string['guardtime'] = 'Zaštitna vremenska margina';
$string['guardtime_help'] = 'Zaštitna vremenska margina sprečava polaznike da promene svoje zakazane termine tik pred njihovu realizaciju.
<p>Ako je zaštitna vremenska margina podešena na, na primer, 2 sata, polaznici neće moći da zakažu termin koji počinje za manje od 2 sata od momenta zakazivanja, a neće moći ni da otkažu sastanak ako on treba da počne za manje od 2 sata.</p>';
$string['guestscantdoanything'] = 'Gosti ovde ne mogu ništa da rade.';
$string['howtoaddstudents'] = 'Da biste dodali polaznike u planer sa globalnim opsegom koristite podešavanje uloge za modul.<br/>Možete koristiti i definicije uloge modula da biste odredili polaznike koji će prisustvovati.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Ignoriši preklapanja termina';
$string['ignoreconflicts_help'] = 'Ako je ovo polje označeno termin će biti pomeren na zahtevan datum i vreme, čak i ako postoje drugi termini u istom vremenskom intervalu. To može dovesti do preklapanja sastanaka za neke od predavača ili polaznika i stoga ova opcija treba da se koristi vrlo pažljivo.';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Uključi prazne termine';
$string['includeslotsfor'] = 'Uključi termine za';
$string['incourse'] = 'Na kursu';
$string['introduction'] = 'Uvod';
$string['isnonexclusive'] = 'Nije ekskluzivno';
$string['landscape'] = 'Horizontalna';
$string['lengthbreakdown'] = 'Prema trajanju termina';
$string['limited'] = 'Ograničen broj mesta (preostalo ih je {$a})';
$string['location'] = 'Lokacija';
$string['location_help'] = 'Odredite lokaciju na kojoj će se održati sastanak.';
$string['markasseennow'] = 'Sad označi da je održan';
$string['markseen'] = 'Nakon što završite sastanak sa polaznikom molimo označite ga sa "Održan" klikom na polje za potvrdu pored slike korisnika iznad.';
$string['maxgrade'] = 'Uzmi najvišu ocenu.';
$string['maxstudentlistsize'] = 'Maksimalna dužina spiska polaznika';
$string['maxstudentlistsize_desc'] = 'Maksimalna dužina spiska polaznika koji treba da zakažu sastanak prikazanog u pregledu planera iz vizure predavača. Ako je na kursu više polaznika nego što je ovde naznačeno neće biti prikazana nikakva lista.';
$string['maxstudentsperslot'] = 'Maksimalan broj polaznika po terminu';
$string['maxstudentsperslot_desc'] = 'Grupni termini / termini koji nisu ekskluzivni mogu važiti za najviše ovaj broj polaznika. Primetite da se dodatno podešavanje na neograničeni broj polaznika uvek može odabrati za svaki termin.';
$string['meangrade'] = 'Uzmi prosečnu ocenu';
$string['meetingwith'] = 'Sastajete se sa korisnikom u ulozi';
$string['meetingwithplural'] = 'Sastajete se sa korisnicima u ulozi';
$string['minutes'] = 'minuta';
$string['minutesperslot'] = 'minuta po terminu';
$string['missingstudents'] = 'Broj polaznika koji još treba da zakažu sastanak:  {$a}';
$string['missingstudentsmany'] = '{$a} polaznika još treba da zakaže sastanak. Njihov spisak nije prikazan jer je predugačak.';
$string['mode'] = 'Režim rada';
$string['modeappointments'] = 'sastan(a)k(a)';
$string['modeintro'] = 'Polaznici se mogu prijaviti';
$string['modeoneatatime'] = 'odjednom';
$string['modeoneonly'] = 'u ovom planeru';
$string['modulename'] = 'Planer';
$string['modulename_help'] = 'Aktivnost planer pomaže pri pravljenju rasporeda sastanaka sa polaznicima kursa.

Predavači određuju termine sastanaka od kojih polaznici potom biraju one koji im odgovaraju. Predavači kao povratnu informaciju mogu da zabeleže ishod sastanka - i opciono ocenu - sve u okviru planera.

Grupno zakazivanje je podržano; svaki termin može da zakaže nekoliko polaznika a opciono je moguće zakazivati i sastanke za cele grupe odjednom.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Planeri';
$string['monday'] = 'Ponedeljak';
$string['multiple'] = '(više)';
$string['myappointments'] = 'Moji sastanci';
$string['myself'] = 'Ja';
$string['name'] = 'Naziv planera';
$string['needteachers'] = 'Nije moguće dodati termine jer na ovom kursu nema predavača';
$string['negativerange'] = 'Opseg je negativan. To ne može biti ispravno.';
$string['never'] = 'Nikad';
$string['noappointments'] = 'Nema sastanaka';
$string['noexistingstudents'] = 'Nema polaznika raspoloživih za zakazivanje sastanaka';
$string['nogroups'] = 'Nema grupa raspoloživih za zakazivanje.';
$string['noresults'] = 'Nema rezultata.';
$string['noschedulers'] = 'Nema planera';
$string['noslots'] = 'Nema slobodnih termina za sastanak.';
$string['noslotsavailable'] = 'Trenutno nema raspoloživih termina za zakazivanje sastanaka.';
$string['noslotsopennow'] = 'Trenutno nema otvorenih termina za zakazivanje sastanaka.';
$string['nostudents'] = 'Nijedan polaznik nije zakazao sastanak';
$string['nostudenttobook'] = 'Nema polaznika koji bi mogli da zakazuju sastanke';
$string['note'] = 'Ocena';
$string['noteacherforslot'] = 'Nema predavača za termine';
$string['noteachershere'] = 'Nema raspoloživih predavača';
$string['notenoughplaces'] = 'Žao nam je, nema dovoljno slobodnih mesta u ovom terminu.';
$string['notifications'] = 'Obaveštenja';
$string['notifications_help'] = 'Kada je ova opcija uključena predavači i polaznici će dobijati obaveštenja kad god se sastanci zakažu ili otkažu.';
$string['notseen'] = 'Nije održan';
$string['now'] = 'Sad';
$string['occurrences'] = 'Izvođenja';
$string['odsformat'] = 'ODS';
$string['on'] = 'dana';
$string['onedaybefore'] = '1 dan pre termina';
$string['onelineperappointment'] = 'Jedan red po sastanku';
$string['onelineperslot'] = 'Jedan red po terminu';
$string['oneslotadded'] = 'Dodat je 1 termin';
$string['oneweekbefore'] = '1 sedmicu pre termina';
$string['onthemorningofappointment'] = 'Ujutro na dan sastanka';
$string['options'] = 'Opcije';
$string['otherstudents'] = 'Ostali učesnici';
$string['overall'] = 'Ukupno';
$string['overlappings'] = 'Neki drugi termini se preklapaju s ovim';
$string['pageperteacher'] = 'Jedna stranica za svaki {$a}';
$string['pagination'] = 'Prelom strana';
$string['pagination_help'] = 'Odaberite da li će izlazna datoteka sadržati posebnu stranicu  za svakog predavača ili ne. U Excel i ODS formatu te stranice odgovaraju radnim listovima tabele za proračune.';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'Orijentacija strane u PDF datoteci';
$string['pluginadministration'] = 'Administracija planera';
$string['pluginname'] = 'Planer';
$string['portrait'] = 'Vertikalna';
$string['preview'] = 'Pregled';
$string['previewlimited'] = '(Pregled je ograničen na {$a} redova.)';
$string['registeredlbl'] = 'Polaznici kojima su zakazani sastanci';
$string['reminder'] = 'Podsetnik';
$string['resetappointments'] = 'Obriši sastanke i ocene';
$string['resetslots'] = 'Obriši termine u planeru';
$string['return'] = 'Nazad na kurs';
$string['revoke'] = 'Otkaži sastanak';
$string['saturday'] = 'Subota';
$string['save'] = 'Sačuvaj';
$string['savechoice'] = 'Sačuvaj moj izbor';
$string['saveseen'] = 'Sačuvaj održano';
$string['schedule'] = 'Plan';
$string['scheduleappointment'] = 'Zakaži sastanak za {$a}';
$string['schedulecancelled'] = '{$a}: Vaš sastanak je otkazan ili pomeren';
$string['schedulegroups'] = 'Zakaži kao grupa';
$string['scheduleinnew'] = 'Zakaži u novom terminu';
$string['scheduleinslot'] = 'Zakaži u terminu';
$string['scheduler'] = 'Planer';
$string['scheduler:addinstance'] = 'Dodaj novi planer';
$string['scheduler:appoint'] = 'Zakaži';
$string['scheduler:attend'] = 'Primi polaznike';
$string['scheduler:canscheduletootherteachers'] = 'Zakaži sastanke za druge članove nastavnog osoblja';
$string['scheduler:canseeotherteachersbooking'] = 'Vidi i pregledaj zakazane termine drugih predavača';
$string['scheduler:disengage'] = 'Ova mogućnost je zastarela i ne radi ništa';
$string['scheduler:manage'] = 'Upravljaj svojim terminima i sastancima';
$string['scheduler:manageallappointments'] = 'Upravljaj svim podacima planera';
$string['scheduler:seeotherstudentsbooking'] = 'Vidi rezervacije termina koje su napravili drugi polaznici';
$string['scheduler:seeotherstudentsresults'] = 'Vidi rezultat polaznika za drugi termin';
$string['scheduler:seeoverviewoutsideactivity'] = 'Koristite ekran za pregled da biste videli termine van tekućeg planera.';
$string['schedulestudents'] = 'Planer po polazniku';
$string['scopemenu'] = 'Prikaži termine u: {$a}';
$string['scopemenuself'] = 'Prikaži moje termine u: {$a}';
$string['seen'] = 'Održan';
$string['selectedtoomany'] = 'Odabrali ste previše termina. Ne možete odabrati više od {$a}.';
$string['sepcolon'] = 'Dvotačka';
$string['sepcomma'] = 'Zarez';
$string['sepsemicolon'] = 'Tačka i zarez';
$string['septab'] = 'Tabulator';
$string['showemailplain'] = 'Prikaži adresu elektronske pošte kao običan tekst';
$string['showemailplain_desc'] = 'U prikazu planera za predavače prikaži adrese polaznika kojima treba sastanak kao običan tekst, kao dodatak mailto: linkovima.';
$string['showparticipants'] = 'Prikaži učesnike';
$string['slot'] = 'Termin';
$string['slot_is_just_in_use'] = 'Izvinjavamo se, sastanak je upravo odabrao neki drugi polaznik! Molimo pokušajte ponovo.';
$string['slotdatetime'] = '{$a->shortdatetime} za {$a->duration} minuta';
$string['slotdescription'] = '{$a->status} na dan {$a->startdate} od {$a->starttime} do {$a->endtime} na lokaciji {$a->location} sa predavačem pod imenom {$a->facilitator}.';
$string['slots'] = 'Termini';
$string['slotsadded'] = 'Dodato je {$a} termina';
$string['slottype'] = 'Tip termina';
$string['slotupdated'] = 'Ažuriran je 1 termin';
$string['slotwarning'] = '<strong>Upozorenje: </strong>Pomeranje ovog termina na odabrano vreme dovodi do njegovog preklapanja sa terminom(-ima) navedenim ispod. Označite opciju "Ignoriši preklapanja termina" ako želite da pomerite termin uprkos tome.';
$string['staffbreakdown'] = 'Prema {$a}';
$string['staffrolename'] = 'Naziv uloge predavača';
$string['staffrolename_help'] = 'Natpis za ulogu onog ko prima polaznike. To ne mora nužno biti "predavač".';
$string['start'] = 'Početak';
$string['startpast'] = 'Ne možete započeti nezakazan sastanak u prošlosti.';
$string['statistics'] = 'Statistika';
$string['student'] = 'Polaznik';
$string['studentbreakdown'] = 'Prema polazniku';
$string['studentcomments'] = 'Beleške polaznika';
$string['studentdetails'] = 'Detalji o polazniku';
$string['studentmultiselect'] = 'Svaki polaznik može biti odabran samo jednom u ovom terminu';
$string['students'] = 'Polaznici';
$string['sunday'] = 'Nedelja';
$string['tab-otherappointments'] = 'Svi sastanci ovog polaznika';
$string['tab-otherstudents'] = 'Polaznici u ovom terminu';
$string['tab-thisappointment'] = 'Ovaj sastanak';
$string['teacher'] = 'Predavač';
$string['teachersmenu'] = 'Prikaži termine za: {$a}';
$string['thiscourse'] = 'ovaj kurs';
$string['thisscheduler'] = 'ovaj planer';
$string['thissite'] = 'ceo sajt';
$string['thursday'] = 'Četvrtak';
$string['totalgrade'] = 'Ukupna ocena';
$string['tuesday'] = 'Utorak';
$string['unattended'] = 'Nije prisustvovano';
$string['unlimited'] = 'Nije ograničeno';
$string['unregisteredlbl'] = 'Polaznici kojima nije zakazan sastanak';
$string['upcomingslots'] = 'Predstojeći termini';
$string['updategrades'] = 'Ažuriraj ocene';
$string['updatesingleslot'] = '';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['wednesday'] = 'Sreda';
$string['welcomebackstudent'] = 'Možete zakazati dodatne termine klikovima na odgovarajuća dugmad sa natpisom "Zakaži termin" niže.';
$string['welcomenewstudent'] = 'Tabela ispod prikazuje sve raspoložive termine za sastanak. Načinite svoj izbor klikom na odgovarajuće dugme sa natpisom "Zakaži termin". Ako kasnije budete želeli da napravite neku izmenu uvek se možete vratiti na ovu stranicu.';
$string['welcomenewteacher'] = 'Molimo kliknite na dugme ispod da biste dodali termine za sastanke.';
$string['what'] = 'Šta?';
$string['whathappened'] = 'Šta se desilo?';
$string['whatresulted'] = 'Šta je ishod?';
$string['when'] = 'Kada?';
$string['where'] = 'Gde?';
$string['who'] = 'Sa kim?';
$string['whosthere'] = 'Ko je tamo?';
$string['xdaysbefore'] = '{$a} dana pre termina';
$string['xweeksbefore'] = '{$a} sedmica pre termina';
$string['yesallgroups'] = 'Da, za sve grupe';
$string['yesingrouping'] = 'Da, u grupisanju {$a}';
$string['yourappointmentnote'] = 'Komentari samo za vaše oči';
$string['yourslotnotes'] = 'Komentari o susretu';
$string['yourtotalgrade'] = 'Vaša ukupna ocena za ovu aktivnost je <strong>{$a}</strong>.';
