<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'sr_lt', version '3.11'.
 *
 * @package     offlinequiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Dodaj';
$string['addarandomquestion'] = 'pitanja nasumično';
$string['addarandomquestion_help'] = 'Moodle dodaje nasumično izabrana pitanja višestrukog izbora (ili pitanja višestrukog izbora sa više tačnih odgovora koja se ocenjuju po principu ”sve-ili-ništa”) u tekuću grupu oflajn testa. Broj pitanja koji se dodaje može se podesiti. Pitanja se biraju iz tekuće kategorije pitanja (i, ako je izabrano, iz njenih potkategorija).';
$string['addarandomselectedquestion'] = 'Dodaj nasumično odabrano pitanje...';
$string['addlist'] = 'Dodaj spisak';
$string['addnewpagesafterselected'] = 'Dodaj prelom stranice posle izabranih pitanja';
$string['addnewquestion'] = 'novo pitanje';
$string['addnewquestionsqbank'] = 'Dodaj pitanja u kategoriju {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Dodaj korisničke izmene';
$string['addpagebreak'] = 'Dodaj prelom stranice';
$string['addpagehere'] = 'Dodaj stranicu ovde';
$string['addparts'] = 'Dodaj učesnike';
$string['addquestionfrombankatend'] = 'Dodaj iz banke pitanja  na kraj';
$string['addquestionfrombanktopage'] = 'Dodaj iz banke pitanja na stranicu {$a}';
$string['addrandom'] = 'Nasumično dodaj {$a} pitanje/a višestrukog izbora';
$string['addrandomfromcategory'] = 'pitanja nasumično iz kategorije';
$string['addrandomquestion'] = 'pitanja nasumično';
$string['addrandomquestiontoofflinequiz'] = 'Dodavanje pitanja u oflajn test {$a->name} (grupa {$a->group})';
$string['addrandomquestiontopage'] = 'Dodaj nasumično izabrano pitanje na stranicu {$a}';
$string['addtoofflinequiz'] = 'Dodaj u oflajn test';
$string['addtoqueue'] = 'Dodaj u red za čekanje';
$string['allinone'] = 'Neograničeno';
$string['alllists'] = 'Svi spiskovi';
$string['allornothing'] = 'Sve-ili-ništa';
$string['allresults'] = 'Prikaži sve rezultate';
$string['allstudents'] = 'Prikaži sve polaznike';
$string['alwaysavailable'] = 'Uvek dostupno';
$string['analysis'] = 'Analiza pitanja';
$string['answerform'] = 'Obrazac za odgovore';
$string['answerformforgroup'] = 'Obrazac za odgovore za grupu {$a}';
$string['answerforms'] = 'Obrasci za odgovore';
$string['answerpdfxy'] = 'Obrazac za odgovore ({$a}->maxquestions pitanja / {$a}->maxanswers odgovora)';
$string['areyousureremoveselected'] = 'Da li ste sigurni da želite da uklonite sva izabrana pitanja?';
$string['attemptexists'] = 'Pokušaj postoji';
$string['attemptsexist'] = 'Više ne možete da dodajete ili uklanjate pitanja.';
$string['attemptsnum'] = 'Ukupan broj pokušaja: {$a}';
$string['attemptsonly'] = 'Prikaži samo polaznike sa pokušajima';
$string['attendances'] = 'Prisutnost';
$string['basicideasofofflinequiz'] = 'Osnovne ideje o pravljenju oflajn testa';
$string['bulksavegrades'] = 'Sačuvaj ocene';
$string['calibratescanner'] = 'Kalibriši skener';
$string['cannoteditafterattempts'] = 'Ne možete da dodajete ili uklanjate pitanja jer već postoje kompletirani pokušaji. ({$a})';
$string['category'] = 'Kategorija';
$string['changed'] = 'Rezultat je promenjen.';
$string['checkparts'] = 'Obeleži izabrane učesnike kao prisutne';
$string['checkuserid'] = 'Obeleži grupu/ID oznaku korisnika';
$string['chooseagroup'] = 'Izaberi grupu...';
$string['closebeforeopen'] = 'Nije moguće ažurirati oflajn test. Naveli ste datum zatvaranja pre datuma otvaranja.';
$string['closestudentview'] = 'Zatvori pregled iz ugla polaznika';
$string['closewindow'] = 'Zatvori prozor';
$string['cmmissing'] = 'Modul kursa za oflajn test sa ID oznakom {$a} nedostaje';
$string['configdecimalplaces'] = 'Broj cifara koji treba prikazati iza decimalne tačke, kada se se prikazuju ocene za oflajn test.';
$string['configintro'] = 'Vrednosti koje ovde podesite koristiće se kao podrazumevane vrednosti za nove oflajn testove.';
$string['configkeepfilesfordays'] = 'Odredite koliko dana će se postavljene datoteke slika čuvati u privremenom skladištu. Tokom ovog perioda datoteke slika biće dostupne u administratorskom izveštaju o oflajn testu.';
$string['configonlylocalcategories'] = 'Nisu dozvoljene deljene kategorije pitanja.';
$string['configpapergray'] = 'vrednost-sive papira';
$string['configshuffleanswers'] = 'Izmešaj odgovore';
$string['configshufflequestions'] = 'Ako omogućite ovu opciju, onda će redosled pitanja u grupama oflajn testa biti nasumično izmešan svaki put kada ponovo kreirate pregled testa na kartici "Kreiraj obrasce".';
$string['configshufflewithin'] = 'Ako omogućite ovu opciju, onda će delovi koji čine pojedinačna pitanja biti nasumično izmešani kada se kreiraju obrasci za pitanja i odgovore.';
$string['configuseridentification'] = 'Formula opisuje identitet korisnika. Ova formula se koristi kako bi se dodelili obrasci za odgovore korisnicima u sistemu. Desna strana jednačine mora da označava polje u tabeli korisnika u Moodleu.';
$string['confirmremovequestion'] = 'Da li ste sigurni da želite da uklonite ovo {$a} pitanje?';
$string['copy'] = 'Kopiraj';
$string['copyright'] = '<strong>Upozorenje: Tekstovi na ovoj stranici su samo za vašu ličnu informaciju. Kao i bilo koje drugi tekst ova pitanja su zaštićena autorskim pravima. Nije vam dozvoljeno da ih kopirate ili da ih pokazujete drugim ljudima!</strong>';
$string['copyselectedtogroup'] = 'Dodaj izabrana pitanja grupi: {$a}';
$string['copytogroup'] = 'Dodaj sva pitanja grupi: {$a}';
$string['correct'] = 'tačno';
$string['correcterror'] = 'reši';
$string['correctforgroup'] = 'Tačni odgovori za grupu {$a}';
$string['correctionform'] = 'Ispravka';
$string['correctionforms'] = 'Obrasci sa tačnim odgovorima';
$string['correctionoptionsheading'] = 'Opcije ispravke';
$string['correctupdated'] = 'Ažuriran obrazac sa tačnim odgovorima za grupu {$a}.';
$string['couldnotgrab'] = 'Nije moguće dohvatiti sliku {$a}';
$string['couldnotregister'] = 'Nije moguće registrovati korisnika {$a}';
$string['createcategoryandaddrandomquestion'] = 'Kreiraj kategoriju i dodaj nasumična pitanja';
$string['createlistfirst'] = 'Dodaj učesnike';
$string['createofflinequiz'] = 'Kreiraj obrasce';
$string['createpartpdferror'] = 'PDF obrazac za spisak korisnika {$a} ne može da se kreira. Spisak je možda prazan.';
$string['createpdf'] = 'PDF obrazac';
$string['createpdferror'] = 'Obrazac za grupu {$a} ne može da se kreira. Možda ne postoje pitanja za grupu.';
$string['createpdffirst'] = 'Kreiraj prvo PDF spisak';
$string['createpdfforms'] = 'Kreiraj obrasce';
$string['createpdfs'] = 'PDF obrasci';
$string['createpdfsparticipants'] = 'PDF obrasci za spisak učesnika';
$string['createquestionandadd'] = 'Kreiraj novo pitanje i dodaj ga u test.';
$string['createquiz'] = 'Kreiraj obrasce';
$string['csvfile'] = 'CSV datoteka';
$string['csvformat'] = 'Tekstualna datoteka sa vrednostima razdvojenim zarezom (CSV)';
$string['csvplus1format'] = 'Tekstualna datoteka sa neobrađenim podacima (CSV)';
$string['csvpluspointsformat'] = 'Tekstualna datoteka sa tačkama (CSV)';
$string['darkgray'] = 'Tamno siva';
$string['datanotsaved'] = 'Nije moguće sačuvati podešavanja';
$string['decimalplaces'] = 'Decimalna mesta';
$string['decimalplaces_help'] = 'Broj cifara koji treba prikazati iza decimalne tačke, kada se se prikazuju ocene za oflajn test.';
$string['deletelistcheck'] = 'Da li zaista želite da obrišete izabranu listu i sve njene učesnike?';
$string['deletepagecheck'] = 'Da li zaista želite da obrišete izabrane stranice?';
$string['deletepagesafterselected'] = 'Ukloni prelom stranice posle izabranih pitanja';
$string['deletepartcheck'] = 'Da li zaista želite da obrišete izabrane učesnike?';
$string['deleteparticipantslist'] = 'Obriši spisak učesnika';
$string['deletepdfs'] = 'Obriši dokumente';
$string['deleteresultcheck'] = 'Da li zaista želite da obrišete izabrane rezultate?';
$string['deleteselectedpart'] = 'Obriši izabrane učesnike';
$string['deleteselectedresults'] = 'Obriši izabrane rezultate';
$string['deletethislist'] = 'Obriši ovaj spisak';
$string['deleteupdatepdf'] = 'Obriši i ažuriraj PDF obrasce';
$string['difficultytitle'] = 'Težina';
$string['difficultytitlea'] = 'Težina A';
$string['difficultytitleb'] = 'Težina B';
$string['difficultytitlediff'] = 'Razlika';
$string['displayoptions'] = 'Opcije prikaza';
$string['done'] = 'gotovo';
$string['downloadallzip'] = 'Preuzmi sve datoteke kao ZIP arhivu';
$string['downloadpartpdf'] = 'Preuzmi PDF datoteku za spisak \'{$a}\\';
$string['downloadpdfs'] = 'Preuzmi dokumente';
$string['downloadresultsas'] = 'Preuzmi rezultate kao:';
$string['dragtoafter'] = 'Posle {$a}';
$string['dragtostart'] = 'Na početak';
$string['editgroupquestions'] = 'Uredi grupu pitanja';
$string['editgroups'] = 'Uredi oflajn grupe';
$string['editingofflinequiz'] = 'Uređivanje grupe pitanja';
$string['editingofflinequiz_help'] = 'Kada se kreira oflajn test, glavni pojmovi su:
<ul><li> Oflajn test, koji sadrži pitanja na jednoj ili više strana</li>
<li> Banka pitanja, u kojoj se čuvaju kopije svih pitanja, organizovanih u kategorije</li></ul>';
$string['editingofflinequizx'] = 'Uredi oflajn test: {$a}';
$string['editlist'] = 'Uredi spisak';
$string['editlists'] = 'Uredi spiskove';
$string['editmaxmark'] = 'Uredi maksimalnu ocenu';
$string['editofflinequiz'] = 'Uredi oflajn test';
$string['editofflinesettings'] = 'Uredi oflajn podešavanja';
$string['editorder'] = 'Uredi redosled';
$string['editparticipants'] = 'Uredi učesnike';
$string['editquestion'] = 'Uredi pitanje';
$string['editquestions'] = 'Uredi pitanja';
$string['editscannedform'] = 'Uredi skenirani obrazac';
$string['editthislist'] = 'Uredi ovaj spisak';
$string['emptygroups'] = 'Neke grupe pitanja oflajn testova su prazne. Molimo, dodajte nekoliko pitanja.';
$string['enroluser'] = 'Upiši korisnika';
$string['erroraccessingreport'] = 'Nije vam dozvoljeno da vidite ovaj izveštaj.';
$string['errorreport'] = 'Izveštaj o greškama prilikom uvoza';
$string['eventattemptdeleted'] = 'Pokušaj rešavanja oflajn testa obrisan';
$string['eventattemptpreviewstarted'] = 'Pregled pokušaja rešavanja oflajn testa započet';
$string['eventattemptreviewed'] = 'Pokušaj rešavanja oflajn testa pregledan';
$string['eventattemptsummaryviewed'] = 'Rezime pokušaja rešavanja oflajn testa prikazan';
$string['eventattemptviewed'] = 'Pokušaj rešavanja oflajn testa prikazan';
$string['eventdocscreated'] = 'Obrasci za pitanja i odgovore oflajn testa kreirani';
$string['eventdocsdeleted'] = 'Obrasci za pitanja i odgovore oflajn testa obrisani';
$string['eventeditpageviewed'] = 'Stranica  za uređivanje oflajn testa prikazana';
$string['eventofflinequizattemptsubmitted'] = 'Pokušaj rešavanja oflajn testa predat';
$string['eventoverridecreated'] = 'Izmena oflajn testa kreirana';
$string['eventoverridedeleted'] = 'Izmena oflajn testa obrisana';
$string['eventoverrideupdated'] = 'Izmena oflajn testa ažurirana';
$string['eventparticipantmarked'] = 'Učesnika oflajn test ručno obeležen';
$string['eventquestionmanuallygraded'] = 'Pitanje ručno ocenjeno';
$string['eventreportviewed'] = 'Izveštaj o oflajn testu prikazan';
$string['eventresultsregraded'] = 'Rezultati oflajn testa ponovo ocenjeni';
$string['everythingon'] = 'omogućeno';
$string['excelformat'] = 'Excel radna tabela (XLSX)';
$string['fileformat'] = 'Format za listove sa pitanjima';
$string['fileformat_help'] = 'Izaberite da li želite da vaši listovi sa pitanjima budu u PDF, DOCX ili TEX formatu. Obrasci za odgovore i listovi sa tačnim odgovorima će uvek biti generisan u PDF formatu.';
$string['fileprefixanswer'] = 'answer_form';
$string['fileprefixcorrection'] = 'correction_form';
$string['fileprefixform'] = 'question_form';
$string['fileprefixparticipants'] = 'participants_list';
$string['filesizetolarge'] = 'Neke od vaših datoteka slika su vrlo velike. Dimenzije će biti promenjene tokom interpretacije skeniranih obrazaca. Molimo vas da obrasce skenirate u rezoluciji između 200 i 300 dpi (tačaka po inču) i u crno-belo režimu. Ovo će ubrzati interpretaciju sledeći put.';
$string['fontsize'] = 'Veličina fonta';
$string['forautoanalysis'] = 'Za automatsku analizu';
$string['formforcorrection'] = 'Obrazac sa tačnim odgovorima za grupu {$a}';
$string['formforgroup'] = 'Obrazac sa pitanjima za grupu {$a}';
$string['formforgroupdocx'] = 'Obrazac sa pitanjima za grupu {$a} (DOCX)';
$string['formforgrouplatex'] = 'Obrazac sa pitanjima za grupu {$a} (LATEX)';
$string['formsexist'] = 'Obrasci su već kreirani.';
$string['formsexistx'] = 'Obrasci su već kreirani (<a href="{$a}">Preuzmi obrasce</a>)';
$string['formsheetsettings'] = 'Podešavanja obrazaca';
$string['formspreview'] = 'Pregled za obrasce';
$string['formwarning'] = 'Ne postoji definisan obrazac za odgovore. Molimo kontaktirajte svog administratora.';
$string['fromquestionbank'] = 'iz banke pitanja';
$string['functiondisabledbysecuremode'] = 'Ova funkcionalnost je trenutno onemogućena';
$string['generalfeedback'] = 'Opšte povratne informacije';
$string['generalfeedback_help'] = 'Opšte povratne informacije predstavljaju tekst koji se prikazuje nakon pokušaja da se odgovori na pitanje. Za razliku od povratne informacije za pojedinačno pitanje koje zavisi od datog odgovora , iste opšte povratne informacije se uvek prikazuju.';
$string['generatepdfform'] = 'Generiši PDF obrazac';
$string['grade'] = 'Ocena';
$string['gradedon'] = 'Ocenjeno';
$string['gradedscannedform'] = 'Skenirani obrazac sa ocenama';
$string['gradeiszero'] = 'Napomena: maksimalna ocena za ovaj oflajn test je 0 bodova!';
$string['gradeswarning'] = 'Ocene za pitanja moraju biti brojevi!';
$string['gradewarning'] = 'Ocena za pitanje mora biti broj!';
$string['gradingofflinequiz'] = 'Ocene';
$string['gradingofflinequizx'] = 'Ocene: {$a}';
$string['gradingoptionsheading'] = 'Opcije ocenjivanja';
$string['greeniscross'] = 'računato kao krstić';
$string['group'] = 'Grupa';
$string['groupoutofrange'] = 'Grupa je van opsega i zamenjena je sa grupom A.';
$string['groupquestions'] = 'Pitanja grupe';
$string['hasresult'] = 'Postoji rezultat';
$string['idnumber'] = 'ID broj / Broj dosijea';
$string['imagefile'] = 'Datoteka slike';
$string['imagenotfound'] = 'Datoteka slike: {$a} nije pronađena!';
$string['imagenotjpg'] = 'Slika nije jpg ili png: {$a}';
$string['imagickwarning'] = 'Nedostaje imagemagick biblioteka: Zamolite svog administratora sistema da instalira imagemagick biblioteku i da proveri putanju do datoteke za konverziju u vašim podešavanjima filtera za TeX notaciju. TIF datoteke ne možetete da uvezete bez imagemagick biblioteke!';
$string['import'] = 'Uvezi';
$string['importedon'] = 'Uvezeno';
$string['importerror11'] = 'Postoji drugi rezultat';
$string['importerror12'] = 'Korisnik nije registrovan';
$string['importerror13'] = 'Nema podatka o grupi';
$string['importerror14'] = 'Nije moguće dohvatiti';
$string['importerror15'] = 'Nejasno obeleženi odgovori';
$string['importerror16'] = 'Greška stranice';
$string['importerror17'] = 'Stranice nepotpune';
$string['importerror21'] = 'Nije moguće dohvatiti';
$string['importerror22'] = 'Nejasno obeleženi odgovori';
$string['importerror23'] = 'Korisnik nije na spisku';
$string['importerror24'] = 'Spisak nije detektovan';
$string['importforms'] = 'Uvezi obrasce sa odgovorima';
$string['importfromto'] = 'Uvoz {$a->from} do {$a->to} od ukupno {$a->total}.';
$string['importisfinished'] = 'Uvoz za oflajn test {$a} je završen.';
$string['importlinkresults'] = 'Link za rezultate: {$a}';
$string['importlinkverify'] = 'Link za proveru: {$a}';
$string['importmailsubject'] = 'obaveštenje o uvozu oflajn testa';
$string['importnew'] = 'Uvezi';
$string['importnew_help'] = '<p>
Možete da uvezete pojedinačne datoteke skeniranih slika ili veći broj njih, upakovane u ZIP-arhivu. Modul ”Oflajn test” će obraditi datoteke slika u pozadini.
Nazivi datoteka nisu bitni ali ne bi trebalo da sadrže posebne znakove kao što su dijakritici, umlauti itd. Slike treba da budu u formatima GIF, PNG ili TIF. Preporučuje se rezolucija između 200 i 300dpi (tačaka po inču).</p>';
$string['importnumberexisting'] = 'Broj duplih obrazaca: {$a}';
$string['importnumberpages'] = 'Broj uspešno uvezenih stranica: {$a}';
$string['importnumberresults'] = 'Broj uvezenih: {$a}';
$string['importnumberverify'] = 'Broj obrazaca za koji je potrebna provera: {$a}';
$string['importtimefinish'] = 'Obrada je završena: {$a}';
$string['importtimestart'] = 'Obrada je započela: {$a}';
$string['inconsistentdata'] = 'Protivrečni podaci: {$a}';
$string['info'] = 'Informacije';
$string['infoshort'] = 'info';
$string['insecuremarkings'] = 'Nejasno obeleženi odgovori traže ručne ispravke';
$string['insecuremarkingsforquestion'] = 'Nejasno obeleženi odgovori traže ručne ispravke za pitanja';
$string['insertnumber'] = 'Molimo vas da ubacite tačan identifikacioni broj obeležen plavim okvirom.';
$string['instruction1'] = 'Ovaj obrazac sa odgovorima biće automatski skeniran. Molimo vas da ga ne savijate ili žvrljate po njemu. Za obeležavanje odgovora koristite crnu ili plavu olovku:';
$string['instruction2'] = 'Samo jasno obeleženi odgovori biće interpretirani kao ispravni. Ako želite da ispravite (poništite) svoj odgovor, kompletno ispunite polje bojom. Tako obeleženo polje, prilikom skeniranja, biće interpretirano kao prazno:';
$string['instruction3'] = 'Polja koja su ispravljena (kompletno ispunjena bojom) ne mogu više da budu ispravno obeležena. Molimo vas da ne ništa ne pišete izvan polja za obeležavanje.';
$string['introduction'] = 'Uvod';
$string['invalidformula'] = 'Neispravna formula za identifikaciju korisnika. Formula mora imati oblik &lt;prefix&gt;[&lt;#digits&gt;]&lt;suffix&gt;=&lt;db-field&gt;.';
$string['invalidnumberofdigits'] = 'Korišćen je neispravan broj cifara. Dozvoljeno je samo 1 do 9 cifara.';
$string['invaliduserfield'] = 'Korišćeno je neispravno polje korisničke tabele.';
$string['invigilator'] = 'Dežurni na ispitu';
$string['ischecked'] = 'Učešće je provereno';
$string['isnotchecked'] = 'Učešće nije provereno';
$string['itemdata'] = 'Podaci o ajtemu';
$string['keepfilesfordays'] = 'Vremenski period čuvanja datoteka (u danima)';
$string['lightgray'] = 'Svetlo siva';
$string['linktoscannedform'] = 'Prikaži skenirani obrazac';
$string['listnotdetected'] = 'Nije moguće detektovati bar kôd za spisak!';
$string['logdeleted'] = 'Zapis {$a} je obrisan.';
$string['logourl'] = 'URL adresa logotipa';
$string['logourldesc'] = 'URL adresa datoteke slike koji se prikazuje u gornjem desnom uglu obrasca sa odgovorima, tj. <b>http://www.yoursite.tld/mylogo.png</b> ili <b>../path/to/your/logo.png</b>. Maksimalna dozvoljena veličina je 520x140 piksela. Obrazac sa odgovorima ne može da se evaluira ako slika prelazi maksimalnu veličinu!';
$string['lowertrigger'] = 'Druga donja granica';
$string['lowertriggerzero'] = 'Druga donja granica je nula';
$string['lowerwarning'] = 'Prva donja granica';
$string['lowerwarningzero'] = 'Prva donja granica je nula';
$string['marginwarning'] = 'Molimo vas da odštampate sledeće PDF dokumente bez dodatnih margina!<br /> Izbegavajte da studentima dajete fotokopije. Ako imate bilo kakvu dilemu naručite kopije od tima za podršku.';
$string['marks'] = 'Ocene';
$string['matrikel'] = 'identifikacioni broj polaznika';
$string['maxgradewarning'] = 'Najveća ocena mora da bude broj!';
$string['maxmark'] = 'Maksimalna ocena';
$string['membersinplist'] = '{$a->count} učesnik/a u<a href="{$a->url}">{$a->name}</a>';
$string['missingimagefile'] = 'Nedostaje datoteka slike';
$string['missingitemdata'] = 'Nedostaje/u odgovor/i za korisnika {$a}';
$string['missinglogdata'] = 'Nedostaju podaci o zapisu za postojeći rezultat.';
$string['missingquestion'] = 'Izgleda da ovo pitanje više ne postoji';
$string['missinguserid'] = 'Nedostaje identifikacioni broj korisnika! Nije moguće pročitati bar kôd!';
$string['modulename'] = 'Oflajn test';
$string['modulename_help'] = 'Ovaj modul omogućava predavačima da dizajniraju oflajn testove koji se sastoje od pitanja višestrukog izbora.
Ova pitanja se čuvaju u banci pitanja i mogu se koristite više puta unutar kurseva, kao i na drugim kursevima.
Oflajn testovi mogu da se preuzmu kao PDF datoteke. Polaznici obeležavaju svoje odgovore na listu sa obrascem za odgovore. Listovi se skeniraju nakon čega se odgovori uvoze u sistem.';
$string['modulenameplural'] = 'Oflajn testovi';
$string['moodleprocessing'] = 'Pustite da Moodle obradi podatke';
$string['movecorners'] = 'Promenite prvo poziciju ugaonih markera. Koristite opciju \'prevuci i spusti';
$string['moveselectedonpage'] = 'Premestite izabrana pitanja na stranicu: {$a}';
$string['multianswersforsingle'] = 'Pitanje višestrukog izbora sa jednim odgovorom';
$string['multichoice'] = 'Višestruki izbor';
$string['multipleanswers'] = 'Izaberite bar jedan odgovor.';
$string['name'] = 'Naziv oflajn testa';
$string['neededcorrection'] = '<strong>Pažnja: Za neke od vaših obeleženih odgovara potrebna je ručna ispravka. Pogledajte crveni kvadrat na sledećoj slici.
<br />Ovo podrazumeva ručnu intervencije od strane predavača i odloženo objavljivanje rezultata oflajn testa!</strong>';
$string['newgrade'] = 'Ocenjeno';
$string['newpage'] = 'Nova stranica';
$string['noattemptexists'] = 'Ne postoji nijedan pokušaj';
$string['noattempts'] = 'Nije uvezen nijedan pokušaj!';
$string['noattemptsonly'] = 'Prikaži samo studente bez pokušaja';
$string['nocourse'] = 'Nedostaje kurs sa ID oznakom {$a->course} kojem pripada oflajn test sa ID oznakom {$a->offlinequiz}.';
$string['nogradesseelater'] = 'Ovaj test nije ocenjen još za {$a}. Rezultati će biti ovde objavljeni.';
$string['nogroupdata'] = 'Nema podatka o grupi za korisnika {$a}';
$string['nomcquestions'] = 'Ne postoje pitanja višestrukog izbora u grupi {$a}!';
$string['noofflinequiz'] = 'Ne postoji oflajn test sa ID oznakom {$a}!';
$string['nopages'] = 'Nije uvezena nijedna stranica';
$string['noparticipantsfound'] = 'Nije pronađen nijedan učesnik';
$string['nopdfscreated'] = 'Nije kreiran nijedan dokument!';
$string['noquestions'] = 'Neke grupe oflajn testa su prazne. Dodajte pitanja.';
$string['noquestionselected'] = 'Nije izabrano nijedno pitanje!';
$string['noquestionsfound'] = 'Ne postoje pitanja u grupi {$a}!';
$string['noquestionsonpage'] = 'Prazna stranica';
$string['noresults'] = 'Ne postoje rezultati.';
$string['noreview'] = 'Nije vam dozvoljeno da pregledate ovaj oflajn test';
$string['noscannedpage'] = 'Ne postoji skenirana stranica sa ID oznakom {$a}!';
$string['nothingtodo'] = 'Ne radi ništa';
$string['notxtfile'] = 'Nema TXT datoteke';
$string['notyetgraded'] = 'Još nije ocenjeno';
$string['nozipfile'] = 'Nema ZIP datoteke';
$string['numattempts'] = 'Broj uvezenih pokušaja: {$a}';
$string['numattemptsqueue'] = 'Broj obrazaca sa odgovorima koji su dodati na čekanje: {$a}. Nakon obrade podataka biće poslata poruka na vašu e-adresu.';
$string['numattemptsverify'] = 'Broj skeniranih obrazaca koji čekaju ispravku: {$a}';
$string['numberformat'] = 'Vrednost mora da bude broj sa {$a} cifre/cifara!';
$string['numbergroups'] = 'Broj grupa';
$string['numpages'] = 'Uvezeno strana: {$a}';
$string['numquestionsx'] = 'Pitanja: {$a}';
$string['numusersadded'] = 'Dodato učesnika: {$a}';
$string['odsformat'] = 'OpenDocument radna tabela (ODS)';
$string['offlineimplementationfor'] = 'Oflajn implementacija za';
$string['offlinequiz:addinstance'] = 'Dodaj oflajn test';
$string['offlinequiz:attempt'] = 'Pokušaj rešavanja testova';
$string['offlinequiz:createofflinequiz'] = 'Kreiraj obrasce za oflajn test';
$string['offlinequiz:deleteattempts'] = 'Obriši pokušaje rešavanja oflajn testa';
$string['offlinequiz:grade'] = 'Oceni oflajn testove ručno';
$string['offlinequiz:manage'] = 'Upravljanje oflajn testovima';
$string['offlinequiz:preview'] = 'Pregledaj oflajn testove';
$string['offlinequiz:view'] = 'Prikaži informacije o oflajn testu';
$string['offlinequiz:viewreports'] = 'Prikaži izveštaje o oflajn testu';
$string['offlinequizcloses'] = 'Oflajn test se zatvara';
$string['offlinequizcloseson'] = 'Pregled ovog oflajn testa će se zatvoriti {$a}';
$string['offlinequizisclosed'] = 'Oflajn test zatvoren';
$string['offlinequizisclosedwillopen'] = 'Oflajn test zatvoren (otvara se {$a})';
$string['offlinequizisopen'] = 'Ovaj oflajn test je otvoren';
$string['offlinequizisopenwillclose'] = 'Oflajn test otvoren (zatvara se {$a})';
$string['offlinequizopenedon'] = 'Ovaj oflajn test je otvoren {$a}';
$string['offlinequizopens'] = 'Oflajn test se otvara';
$string['offlinequizsettings'] = 'Podešavanja oflajn testa';
$string['offlinequizwillopen'] = 'Oflajn test se otvara {$a}';
$string['oneclickenrol'] = 'Upis na 1 klik';
$string['oneclickenroldesc'] = 'Ako je aktivirana ova opcija predavači imaju mogućnost da upišu korisnike jednim klikom dok ispravljaju obrasce sa odgovorima(greška "Korisnik nije upisan na kurs").';
$string['oneclickrole'] = 'Uloga za ”Upis na 1 klik”';
$string['oneclickroledesc'] = 'Izaberite ulogu koja se koristi za ”Upis na 1 klik”. Mogu biti izabrane samo uloge sa arhetipom ”student”.';
$string['onlylocalcategories'] = 'Samo lokalne kategorije pitanja';
$string['orderandpaging'] = 'Redosled i paginacija';
$string['orderandpaging_help'] = 'Brojevi 10, 20, 30... pored svakog pitanja ukazuju na redosled pitanja u testu. Brojevi se povećavaju u koracima po 10 kako bi se ostavio prostor za ubacivanje dodatnih pitanja. Da biste promenili redosled pitanja, promenite broj a onda kliknite na dugme "Promeni redosled pitanja".

Da biste dodali prelom stranice nakon određenog pitanja, označite polje za potvrdu odmah pored samog pitanja a zatim kliknite na dugme "Dodaj prelom stranice posle izabranih pitanja"

Da biste organizovali pitanja na više stranica kliknite na dugme "Reorganizuj stranice" i izaberite željeni broj pitanja po stranici.';
$string['orderingofflinequiz'] = 'Redosled i paginacija';
$string['otherresultexists'] = 'Drugačiji rezultat za {$a}  već postoji, uvoz je ignorisan! Obrišite rezultat prvo.';
$string['outof'] = '{$a->grade} od maksimalnih {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Sveobuhvatne povratne informacije';
$string['overview'] = 'Pregled';
$string['overviewdownload_help'] = '';
$string['page-mod-offlinequiz-edit'] = 'Stranica za uređivanje oflajn testa';
$string['page-mod-offlinequiz-x'] = 'Bilo koja stranica oflajn testa';
$string['pagecorrected'] = 'Ispravljeni list sa spiskom učesnika uvezen';
$string['pageimported'] = 'List sa spiskom učesnika uvezen';
$string['pagenotdetected'] = 'Nije moguće detektovati bar kôd za stranicu!';
$string['pagenumberimported'] = 'List {$a} sa spiskom učesnika uvezen';
$string['pagesizeparts'] = 'Broj učesnika prikazanih po stranici:';
$string['papergray'] = 'Vrednost beline papira';
$string['papergray_help'] = 'Ako su beli delovi vaših skeniranih obrazaca za odgovore veoma tamni, to možete da ispravite tako što ćete ovu vrednost podesiti na \'Tamno siva\'.';
$string['partcheckedwithoutresult'] = '<a href="{$a->url}">Potvrđeni učesnici bez rezultata: {$a->count}</a>';
$string['partcheckedwithresult'] = 'Potvrđeni učesnici sa rezultatom: {$a}';
$string['participants'] = 'Učesnici';
$string['participants_help'] = '<p>Spiskovi učesnika su dizajnirani za velike testove sa velikim brojem učesnika. Oni pomažu predavaču da proveri koji polaznici su pristupili testu i da li su svi rezultati ispravno uvezeni.
Možete da dodate korisnike na različite spiskove. Svaki spisak može, na primer, da sadrži učesnike u određenoj prostoriji. Učesnici mogu da budu članovi posebne grupe. Za kreiranje tih grupa može se koristiti alat za registraciju grupe.
Spiskovi učesnika mogu se preuzeti kao PDF dokumenti i odštampati. Prisutni polaznici se mogu obeležiti krstićem, baš kao što se obeležavaju odgovori u obrascu za odgovore oflajn testa. Nakon toga, skenirani spiskovi mogu da budu postavljeni na server, a polaznici obeleženi krstićem biće označeni u bazi podataka kao prisutni.
Izbegavajte mrlje na bar kôdovima jer se oni koriste za identifikaciju polaznika.</p>';
$string['participantsinlists'] = 'Učesnici na spisku';
$string['participantslist'] = 'Spisak učesnika';
$string['participantslists'] = 'Učesnici';
$string['partimportnew'] = 'Postavljanje spiska učesnika';
$string['partimportnew_help'] = 'U ovoj kartici možete da postavite popunjene spiskove učesnika. Možete da postavite pojedinačne datoteke skeniranih slika ili veći broj njih, upakovane u ZIP-arhivu. Modul ”Oflajn test” će obraditi datoteke slika u pozadini.
Nazivi datoteka nisu bitni ali ne bi trebalo da sadrže posebne znakove kao što su dijakritici, umlauti itd. Slike treba da budu u formatima GIF, PNG ili TIF. Preporučuje se rezolucija između 200 i 300dpi (tačaka po inču).</p>';
$string['partuncheckedwithoutresult'] = 'Nepotvrđeni učesnici bez rezultata: {$a}';
$string['partuncheckedwithresult'] = '<a href="{$a->url}">Nepotvrđeni učesnici sa rezultatom: {$a->count}</a>';
$string['pdfdeletedforgroup'] = 'Obrazac za grupu {$a} obrisan';
$string['pdfintro'] = 'Dodatne informacije';
$string['pdfintro_help'] = 'Ove informacije biće štampane na prvoj stranici lista sa pitanjima. One treba da sadrže uputstvo kako se popunjava obrazac sa odgovorima.';
$string['pdfintrotext'] = '<b>Kako da pravilno obeležim odgovore?</b><br />Ovaj obrazac sa odgovorima biće automatski skeniran. Molimo vas da ga ne savijate ili žvrljate po njemu. Za obeležavanje odgovora koristite crnu ili plavu olovku. Odgovor koji smatrate tačnim obeležite znakom X. Ako želite da ispravite svoj odgovor, kompletno ispunite polje bojom. Tako obeleženo polje, prilikom skeniranja, biće interpretirano kao prazno.<br />';
$string['pdfintrotoolarge'] = 'Uvod je predugačak (maksimalno 2000 znakova).';
$string['pdfscreated'] = 'PDF obrasci su kreirani';
$string['pdfsdeletedforgroup'] = 'Obrasci za grupu {$a} obrisani';
$string['pearlywhite'] = 'Biserno bela';
$string['pluginadministration'] = 'Administracija oflajn testa';
$string['pluginname'] = 'Oflajn test';
$string['point'] = 'poen';
$string['present'] = 'prisutan';
$string['preventsamequestion'] = 'Sprečite višestruko korišćenje istog pitanja u različitim grupama';
$string['preview'] = 'Pregled';
$string['previewforgroup'] = 'Pregled za grupu {$a}';
$string['previewquestion'] = 'Pregledaj pitanje';
$string['printstudycodefield'] = 'Štampaj polje za šifru studijskog programa na listu sa pitanjima';
$string['printstudycodefield_help'] = 'Ako omogućite ovu opciju, onda će na prvoj stranici obrasca sa pitanjima biti odštampano polje za upisivanje šifre studijskog programa.';
$string['questionanalysis'] = 'Analiza težine pitanja';
$string['questionanalysistitle'] = 'Tabela sa analizom težine pitanja';
$string['questionbankcontents'] = 'Sadržaj banke pitanja';
$string['questionforms'] = 'Obrasci sa pitanjima';
$string['questioninfoanswers'] = 'Broj tačnih odgovora';
$string['questioninfocorrectanswer'] = 'tačan odgovor';
$string['questioninfocorrectanswers'] = 'tačni odgovori';
$string['questioninfonone'] = 'Ništa';
$string['questioninfoqtype'] = 'Tip pitanja';
$string['questionname'] = 'Naziv pitanja';
$string['questionsheet'] = 'List sa pitanjima';
$string['questionsheetlatextemplate'] = 'documentclass[12pt,a4paper]{article}
textwidth 16truecm
textheight 23truecm
setlength{oddsidemargin}{0cm}
setlength{evensidemargin}{0cm}
setlength{topmargin}{-1cm}
usepackage{amsmath} % für implies etc
usepackage{amsfonts} % für mathbb etc
usepackage{graphicx} % zum Bilder einfügen
renewcommand{familydefault}{sfdefault} % Schriftart
newcommand{lsim}{mbox{raisebox{-.3em}{$stackrel{<}{sim}$}}} % less or approximately equal
newcommand{subs}{mbox{raisebox{-.5em}{$stackrel{subset}{neq}$}}}
newcommand{sei}{mbox{raisebox{.0em}{$stackrel{!}{=}$}}}
parindent 0pt % keine Einrückung am Beginn des Absatzes
usepackage{esvect} % für lange Vektorpfeile, z.B. vv{AB}
usepackage[colorlinks=true,urlcolor=dunkelrot,linkcolor=black]{hyperref} % Für Einfügen von Hyperlinks
renewcommandUrlFont{sf}
usepackage{ulem} % Durchstreichen: sout{gerade durchstreichen} xout{schräg durchstreichen}
newcommand{abs}[1]{leftlvert#1rightrvert}
usepackage{scrpage2} % Kopf- und Fußzeilen (http://esc-now.de/_/latex-individuelle-kopf-und-fusszeilen/?lang=en):
pagestyle{scrheadings}
clearscrheadfoot
ifoot{[Gruppe Group]}
makeatletter %%% Seitenumbrüche zwischen Antwortmöglichkeiten unterdrücken (funktioniert meistens!)
@beginparpenalty=10000
@itempenalty=10000
makeatother
%
%%% DIE FOLGENDEN ZWEI ZEILEN: Wenn erste auskommentiert -> r/f werden angezeigt, wenn zweite auskommentiert -> r/f werden verborgen
newcommand{answerIs}[1]{} %%% Zum verborgenen Anzeigen der richtigen und falschen Antworten
% newcommand{answerIs}[1]{[#1]} %%% Zum Anzeigen der richtigen und falschen Antworten
%%%

begin{document}


% ===========================================================================================================
%%% Die Lehrveranstaltungs-Daten:
begin{center}{University of Vienna}end{center}
begin{center}{LARGE {$a->coursename}}end{center}
begin{center}{Written Exam{$a->date}}end{center}
%%% In der folgenden Zeile bei Erstellen des endgültigen Fragebogens den Namen der Gruppe einfügen!
defGroup{{$a->groupname}}
begin{center}{Large Group Group}end{center}

{bf Name:}
{bf Matriculation number:}
{bf Signature:}

% ===========================================================================================================
bigskip

{$a->latexforquestions}


end{document}';
$string['questionsin'] = 'Pitanja u';
$string['questionsingroup'] = 'Pitanja u grupi';
$string['questionsinthisofflinequiz'] = 'Pitanja u ovom oflajn testu';
$string['questiontextisempty'] = '[Prazan tekst pitanja]';
$string['quizdate'] = 'Datum oflajn testa';
$string['quizopenclose'] = 'Datumi otvaranja i zatvaranja';
$string['quizopenclose_help'] = 'Polaznici mogu da vide svoj(e) pokušaj(e) nakon datum otvaranja i pre datuma zatvaranja.';
$string['quizquestions'] = 'Pitanja testa';
$string['randomfromexistingcategory'] = 'Nasumično pitanja iz postojeće kategorije';
$string['randomnumber'] = 'Broj nasumičnih pitanja';
$string['randomquestionusinganewcategory'] = 'Nasumično pitanje koristeći novu kategoriju';
$string['readjust'] = 'Podesi';
$string['recreatepdfs'] = 'Ponovo kreiraj PDF dokumente';
$string['recurse'] = 'Uključi i pitanja iz potkategorija';
$string['rediswrong'] = 'krstić pogrešan ili nedostaje';
$string['refreshpreview'] = 'Osveži pregled';
$string['regrade'] = 'Oceni ponovo';
$string['regradedisplayexplanation'] = '<b>Pažnja:</b> Ponovno ocenjivanje neće promeniti obeležene odgovore koji su ručno izmenjeni!';
$string['regradinginfo'] = 'Ako promenite ocenu za pitanje, morate ponovo da ocenite oflajn test kako biste ažurirali rezultate učesnika.';
$string['regradingquiz'] = 'Ponovno ocenjivanje';
$string['regradingresult'] = 'Ponovno ocenjivanje rezultata za korisnika {$a}...';
$string['reloadpreview'] = 'Ponovo učitaj pregled';
$string['reloadquestionlist'] = 'Ponovo učitaj spisak pitanja';
$string['remove'] = 'Ukloni';
$string['removeemptypage'] = 'Ukloni praznu stranicu';
$string['removepagebreak'] = 'Ukloni prelom stranice';
$string['removeselected'] = 'Ukloni izabrano';
$string['reordergroupquestions'] = 'Promeni redosled pitanja grupe';
$string['reorderquestions'] = 'Promeni redosled pitanja';
$string['reordertool'] = 'Prikaži alat za reorganizovanje pitanja';
$string['repaginate'] = 'Reorganizuj stranice sa {$a} pitanja po jednoj stranici';
$string['repaginatecommand'] = 'Reorganizuj stranice';
$string['repaginatenow'] = 'Reorganizuj stranice sad';
$string['reportoverview'] = 'Pregled';
$string['reportstarts'] = 'pregled rezultata';
$string['resetofflinequizzes'] = 'Resetuj podatke oflajn testa';
$string['resultexists'] = 'Isti rezultat za {$a}  već postoji, uvoz je ignorisan';
$string['resultimport'] = 'Uvezi rezultate';
$string['results'] = 'Rezultati';
$string['review'] = 'Pregled';
$string['reviewbefore'] = 'Dozvoli pregled dok je oflajn test otvoren';
$string['reviewclosed'] = 'Nakon što se oflajn test zatvori';
$string['reviewcloses'] = 'Pregled se zatvara';
$string['reviewimmediately'] = 'Odmah nakon pokušaja';
$string['reviewincludes'] = 'Pregled uključuje';
$string['reviewofresult'] = 'Pregled rezultata';
$string['reviewopens'] = 'Pregled se otvara';
$string['reviewoptions'] = 'Polaznici mogu da vide';
$string['reviewoptions_help'] = 'Sa ovim opcijama možete da kontrolišete šta polaznici mogu da vide nakon što se uvezu rezultati.
Takođe možete da definišete vremenski period tokom kojeg će biti dostupan izveštaj sa rezultatima. Polja za potvrdu imaju sledeća značenja:
<table>
<tr><td style="vertical-align: top;"><b>Pokušaj</b></td><td>
Tekst pitanja i odgovori biće prikazani polaznicima. Oni će videti odgovore koje su izabrali, ali tačni odgovori neće biti naznačeni.</td>
</td></tr>
<tr><td style="vertical-align: top;"><b>Da li je odgovor tačan</b></td><td>
Ova opcija može da bude aktivirana samo ako je uključena opcija "Pokušaj". Ako je aktivna, polaznici će moći da vide koji od odgovora koje su izabrali je tačan (zelena pozadina) a koji netačan (crvena pozadina).
</td></tr>
<tr><td style="vertical-align: top;"><b>Ocene</b></td><td>
Biće prikazana grupa testa (npr. B), rezultati (postignuta ocena, ukupna ocena za pitanja, postignuće u procentima, na primer 40/80 (50)) i ocena (npr. 50 od maksimalnih100).
Pored toga, ako je uključena opcija "Pokušaj", za svako pitanje biće prikazani postignut, kao i maksimalan rezultat.
</td></tr>
<tr><td style="vertical-align: top;"><b>Tačni odgovori</b></td><td>
Ako je ova opcija aktivirana biće pokazano koji odgovori su tačni a koji netačni. Ova opcija dostupna je samo ako je uključen "Pokušaj".
</td></tr>
<tr><td style="vertical-align: top;"><b>Skenirani obrazac</b></td><td>
Prikazuje su skenirani obrasci sa odgovorima. Obeležena polja (odgovori) su označena zelenim kvadratom.
</td></tr>
<tr><td style="vertical-align: top;"><b>Skenirani obrazac sa ocenama</b></td><td>
Prikazuje su skenirani obrasci sa odgovorima. Obeležena polja (odgovori) su označena zelenim kvadratom. Pogrešno obeleženi odgovori, kao i oni koji nisu obeleženi su istaknuti.
Pored toga, tabela prikazuje maksimalnu i postignutu ocenu za svako pitanje.
</td></tr>
</table>';
$string['reviewoptionsheading'] = 'Opcije pregleda';
$string['rimport'] = 'Postavi/Ispravi';
$string['rotate'] = 'Rotiraj';
$string['rotatingsheet'] = 'List je rotiran...';
$string['save'] = 'Sačuvaj';
$string['saveandshow'] = 'Sačuvaj i pokaži promene polaznicima';
$string['savescannersettings'] = 'Sačuvaj podešavanja skenera';
$string['scannedform'] = 'Skenirani obrazac';
$string['scannerformfortype'] = 'Obrazac za tip {$a}';
$string['scanneroptions'] = 'Podešavanja skenera';
$string['scannerpdfs'] = 'Prazni obrasci';
$string['scannerpdfstext'] = 'Preuzeti sledeća prazne obrasce ako želite da koristite svoj softver za skeniranje.';
$string['scanningoptionsheading'] = 'Opcije za skeniranje';
$string['score'] = 'Skor';
$string['select'] = 'Izaberi';
$string['selectagroup'] = 'Izaberi grupu';
$string['selectall'] = 'Izaberi sve';
$string['selectcategory'] = 'Izaberi kategoriju';
$string['selectdifferentgroup'] = 'Molimo vas, izaberite drugu grupu!';
$string['selectedattempts'] = 'Izabrani pokušaji...';
$string['selectformat'] = 'Izaberi format...';
$string['selectgroup'] = 'Izaberi grupu';
$string['selectlist'] = 'Izaberite spisak ili pokušajte da podesite list:';
$string['selectnone'] = 'Poništi izbor svega';
$string['selectpage'] = 'Izaberite broj stranice ili pokušajte da podesite list:';
$string['selectquestiontype'] = '-- Izaberi tip pitanja --';
$string['showallparts'] = 'Prikaži sve učesnike, njih {$a}';
$string['showcopyright'] = 'Prikaži izjavu o autorskim pravima';
$string['showcopyrightdesc'] = 'Ako omogućite ovu opciju, izjava o autorskim pravima biće prikazana na stranici polaznika za pregled rezultata.';
$string['showgrades'] = 'Štampaj ocene za pitanja';
$string['showgrades_help'] = 'Ova opcija određuje da li na listu sa pitanjima treba da se štampaju maksimalne ocene za pitanja oflajn testa.';
$string['showmissingattemptonly'] = 'Prikaži sve označene učesnike bez pokušaja';
$string['showmissingcheckonly'] = 'Prikaži sve označene učesnike sa rezultatom';
$string['shownumpartsperpage'] = 'Prikaži {$a} učesnika po stranici';
$string['showquestioninfo'] = 'Štampaj informacije o odgovorima';
$string['showquestioninfo_help'] = 'Pomoću ove opcije možete da odredite koje dodatne informacije o pitanju će se štampati na listu sa pitanjima.
Možete da izaberete jednu od sledećih opcija:
<ul>
<li> Ništa
<li> Tip pitanja - zavisno od tipa pitanja biće odštampano ”Višestruki izbor sa jednim tačnim odgovorom”, ”Višestruki izbor sa više tačnih odgovora”, ”Višestruki izbor sa više tačnih odgovora tipa sve-ili-ništa”
<li> Broj tačnih odgovora
</ul>';
$string['showstudentview'] = 'Prikaži pregled iz ugla polaznika';
$string['showtutorial'] = 'Prikaži polaznicima uputstvo za oflajn test.';
$string['showtutorial_help'] = 'Ova opcija određuje da li polaznici mogu da vide uputstvo sa osnovnim informacijama o oflajn testovima.
Uputstvo pruža informacije o tome kako se postupa sa različitim vrstama dokumenata unutar oflajn testova. U interaktivnom delu polaznici uče kako da pravilno unesu svoju ID oznaku.<br />
<b>Imajte u vidu:</b><br />
Ako postavite ovu opciju na "Da", ali pritom sakrijete oflajn test link ka uputstvu neće biti vidljiv. U tom slučaju možete da dodate link ka uputstvu na stranici kursa.';
$string['showtutorialdescription'] = 'Možete dodati link ka uputstvu na stranici kursa koristeći sledeću URL adresu:';
$string['shuffleanswers'] = 'Izmešaj odgovore';
$string['shufflequestions'] = 'Izmešaj pitanja';
$string['shufflequestionsanswers'] = 'Izmešaj pitanja i odgovore';
$string['shufflequestionsselected'] = 'Opcija za mešanje pitanja je uključena, tako da pojedine akcije u vezi sa stranicama nisu dostupne. Da biste promenili opciju za mešanje pitanja idite na stranicu za uređivanje oflajn testa - {$a}.';
$string['shufflewithin'] = 'Izmešaj unutar pitanja';
$string['shufflewithin_help'] = 'Ako je ova opcija omogućena, onda će odgovori unutar svih pitanja biti nasumično izmešani svaki put kada pritisnete dugme za ponovno učitavanje na stranici za pregled obrasca sa pitanjima. NAPOMENA: Ovo podešavanje se primenjuje samo na pitanja kod kojih je opcija za mešanje aktivirana.';
$string['signature'] = 'Potpis';
$string['singlechoice'] = 'Višestruki izbor sa jednim tačnim odgovorom';
$string['standard'] = 'Standardna';
$string['starttutorial'] = 'Startuj uputstvo o oflajn testiranju';
$string['statistics'] = 'Statistika';
$string['statisticsplural'] = 'Statistika';
$string['statsoverview'] = 'Pregled statistike';
$string['studycode'] = 'Šifra studijskog programa';
$string['theattempt'] = 'Pokušaj';
$string['timesup'] = 'Vreme je isteklo!';
$string['totalmarksx'] = 'Ukupna ocene za sva pitanja: {$a}';
$string['totalpointsx'] = 'Ukupna ocene za sva pitanja: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Ukupan broj pitanja u kategoriji: {$a}.';
$string['trigger'] = 'donja/gornja granica';
$string['tutorial'] = 'Uputstvo za oflajn testove';
$string['type'] = 'Tip';
$string['uncheckparts'] = 'Obeleži izabrane korisnike kao odsutne';
$string['updatedsumgrades'] = 'Zbir svih ocena za grupu {$a->letter} je preračunat na {$a->grade}.';
$string['upgradingfilenames'] = 'Ažuriranje naziva datoteka dokumenata: oflajn test {$a->done}/{$a->outof} <br/>(Oflajn test ID {$a->info})';
$string['upgradingilogs'] = 'Ažuriranje skeniranih stranica: skenirana stranica {$a->done}/{$a->outof} <br/>(Oflajn test ID {$a->info})';
$string['upgradingofflinequizattempts'] = 'Ažuriranje pokušaja rešavanja testa: oflajn test $a->done}/{$a->outof} <br/>(Oflajn test ID {$a->info})';
$string['upload'] = 'Postavi/Ispravi';
$string['uploadpart'] = 'Postavi/Ispravi spiskove učesnika';
$string['uppertrigger'] = 'Druga gornja granica';
$string['uppertriggerzero'] = 'Druga gornja granica je nula';
$string['upperwarning'] = 'Prva gornja granica';
$string['upperwarningzero'] = 'Prva gornja granica je nula';
$string['useradded'] = 'Korisnik {$a} je dodat/a';
$string['userdoesnotexist'] = 'Korisnik {$a} ne postoji u sistemu';
$string['useridentification'] = 'Identifikacija korisnika';
$string['userimported'] = 'Korisnik {$a} je uvezen/a i ocenjen/a';
$string['usernotincourse'] = 'Korisnik {$a} nije na kursu.';
$string['usernotinlist'] = 'Korisnik nije registrovan na spisku!';
$string['usernotregistered'] = 'Korisnik {$a} nije registrovan na kursu';
$string['userpageimported'] = 'Jedna stranica uvezena za korisnika {$a}';
$string['valuezero'] = 'Vrednost ne bi trebalo da bude nula';
$string['viewresults'] = 'Prikaži rezultate';
$string['white'] = 'Bela';
$string['withselected'] = 'Sa izabranim....';
$string['zerogradewarning'] = 'Upozorenje: Vaša ocena za oflajn test je 0.0!';
$string['zipfile'] = 'ZIP datoteka';
$string['zipok'] = 'ZIP datoteka uvezena';
