<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'certificate', language 'sr_lt', version '3.11'.
 *
 * @package     certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addlinklabel'] = 'Dodaj još jednu opciju povezane aktivnosti';
$string['addlinktitle'] = 'Kliknite kako biste dodalij još jednu opciju povezane aktivnosti';
$string['areaintro'] = 'Uvodni deo sertifikata';
$string['awarded'] = 'Dodeljeno';
$string['awardedto'] = 'Dodeljuje se polazniku';
$string['back'] = 'Nazad';
$string['border'] = 'Bordura';
$string['borderblack'] = 'Crna';
$string['borderblue'] = 'Plava';
$string['borderbrown'] = 'Braon';
$string['bordercolor'] = 'Linije bordure';
$string['bordercolor_help'] = 'S obzirom da slike mogu značajno povećati veličinu pdf datoteke, možete odabrati štampanje bordure od linija umesto slike (proverite da je opcija \'Slika bordure\' podešena na "Ne"). Opcija \'\'Linije bordure\' će štampati lepu borduru sastavljenu od tri linija različitih debljina u odabranoj boji.';
$string['bordergreen'] = 'Zelena';
$string['borderlines'] = 'Linije';
$string['borderstyle'] = 'Slika bordure';
$string['borderstyle_help'] = 'Opcija \'Slika bordure\' vam daje mogućnost da izaberete sliku bordure seriftikata iz direktorijuma certificate/pix/borders. Izaberite sliku koju želite da bude na ivicama sertifikata, ili izaberite opciju \'bez bordure\'.';
$string['certificate'] = 'Potvrda kôda sertifikata';
$string['certificate:addinstance'] = 'Dodaj instancu sertifikata';
$string['certificate:manage'] = 'Upravljanje instancom sertifikata';
$string['certificate:printteacher'] = 'Biti naveden kao predavač na sertifikatu ako je uključeno podešavanje za štampanje imena predavača';
$string['certificate:student'] = 'Preuzmi sertifikat';
$string['certificate:view'] = 'Prikaži sertifikat';
$string['certificatename'] = 'Naziv sertifikata';
$string['certificatereport'] = 'Izveštaj o sertifikatima';
$string['certificatesfor'] = 'Sertifikati za';
$string['certificatetype'] = 'Tip sertifikata';
$string['certificatetype_help'] = 'Ovo je mesto gde možete odrediti grafički izgled sertifikata. Direktorijum sa tipovima sertifikata sadrži četiri standardna sertifikata:
\'A4 ugrađeno\' štampa sertifikat na papiru A4 formata sa ugrađenim fontovima.
\'A4 ne-ugrađeno\' štampa sertifikat na papiru A4 formata bez ugrađenih fontova.
\'Pismo ugrađeno\' štampa sertifikat na papiru u formatu pisma sa ugrađenim fontovima.
\'Pismo ne-ugrađeno\' štampa sertifikat na papiru u formatu pisma bez ugrađenih fontova.

Neugrađeni tipovi koriste fontove Helvetica i Times Ako mislite da vaši korisnici nemaju ove fontove na svom računaru, ili ako vaš jezik koristi znakove ili simbole koji nisu prilagođeni za navedene fontove, onda izaberite ugrađeni tip. Ugrađeni tipovi koriste fontove Dejavusans i Dejavuserif. S obzirom da je ovako kreirana .pdf datoteka prilično velika, ugrađeni tip se ne preporučuje, pa ga koristite samo ako morate.

Direktorijumi novih tipova sertifikata mogu da se dodaju direktorijumu certificate/type. U tom slučaju, jezičkoj datoteci sertifikata moraju se dodati naziv direktorijuma i svi novi jezički stringovi za novi tip sertifikata.';
$string['certify'] = 'Ovim se potvrđuje da je';
$string['code'] = 'Kôd';
$string['completiondate'] = 'Završetak kursa';
$string['course'] = 'Za';
$string['coursegrade'] = 'Ocena na kursu';
$string['coursename'] = 'Kurs';
$string['coursetimereq'] = 'Neophodan broj minuta provedenih na kursu';
$string['coursetimereq_help'] = 'Unesite ovde minimum vremena, u minutima, koje student mora da provede na kursu pre nego što bude mogao da dobije sertifikat.';
$string['credithours'] = 'Broj kredita (bodova) u satima';
$string['customtext'] = 'Prilagođeni tekst';
$string['customtext_help'] = 'Ako želite da na sertifikatu odštampate ime predavača koje je različito od imena onoga kome je na kursu bila dodeljena uloga predavača, onda nemojte izabrati opciju \'Štampaj ime predavača\', niti sliku potpisa, osim slike linije. U ovo polje za tekst unesite imena predavača, onako kako želite da se ona pojave na sertifikatu. Standardno, ovaj tekst se smešta u donji levi ugao sertifikata. Dostupne su sledeće HTML oznake: &lt;br&gt;, &lt;p&gt;, &lt;b&gt;, &lt;i&gt;, &lt;u&gt;, &lt;img&gt; (oznake src i width (ili height) su obavezne), <a> (oznaka href je obavezna), <font> (mogući atributi su: color, (hex color code), face, (arial, times, courier, helvetica, symbol)).';
$string['date'] = 'Dana';
$string['datefmt'] = 'Format datuma';
$string['datefmt_help'] = 'Izaberite format u kojem će biti odštampan datum na sertifikatu, ili, izaberite poslednju opciju kako bi datum bio odštampan u formatu korisnikovog izabranog jezika.';
$string['datehelp'] = 'Datum';
$string['deletissuedcertificates'] = 'Obriši izdate sertifikate';
$string['delivery'] = 'Dostava sertifikata';
$string['delivery_help'] = 'Izaberite ovde kako želite da vaši studenti dobiju sertifikat.
Otvori u veb čitaču: otvara sertifikat u novom prozoru veb čitača.
Obavezno preuzimanje: otvara prozor čitača za preuzimanje datoteke.
Pošalji sertifikat e-poštom: ako je izabrana ova opcija sertifikat se šalje studentu kao prilog e-poruci. Nakon što korisnik dobije svoj sertifikat, ukoliko klikne na link sertifikata na naslovnoj stranici kursa, videće datum kada je dobio sertifikat i moći će da ga pregleda.';
$string['designoptions'] = 'Opcije za dizajn';
$string['download'] = 'Obavezno preuzimanje';
$string['emailcertificate'] = 'Pošalji sertifikat e-poštom (takođe mora izabrati sačuvaj!)';
$string['emailothers'] = 'Pošalji e-poštom drugima';
$string['emailothers_help'] = 'Unesite ovede elektronske adrese, razdvojene zarezom, onih koje treba obavestiti elektronsko poštom svaki put kada studenti dobiju sertifikat.';
$string['emailstudenttext'] = 'U prilogu je Vaš sertifikat za kurs {$a->course}.';
$string['emailteachermail'] = '{$a->student} je primio svoj sertifikat: \'{$a->certificate}\' za kurs {{$a->course}.

Možete ga pregledati ovde:

{$a->url}';
$string['emailteachermailhtml'] = '{$a->student} je primio svoj sertifikat: \'<i>{$a->certificate}</i>\' za kurs {$a->course}.

Možete ga pregledati ovde:

<a href="{$a->url}">Izveštaj o sertifikatu</a>.';
$string['emailteachers'] = 'Pošalji e-poštu predavačima';
$string['emailteachers_help'] = 'Ako je ova opcija omogućena, onda će predavači biti obavešteni e-poštom svaki put kada studenti dobiju sertifikat';
$string['entercode'] = 'Unesi kôd sertifikata za potvrdu:';
$string['getcertificate'] = 'Preuzmite svoj sertifikat';
$string['grade'] = 'Ocena';
$string['gradedate'] = 'Datum ocenjivanja';
$string['gradefmt'] = 'Format ocene';
$string['gradefmt_help'] = 'Ako želite da na sertifikatu odštampate ocenu postoje tri dostupna formata:

Procentualna ocena: štampa ocenu kao procenat.
Bodovna ocena: štampa ocenu kao broj bodova.
Slovna ocena: štampa ocenu kao slovo.';
$string['gradeletter'] = 'Slovna ocena';
$string['gradepercent'] = 'Procentualna ocena';
$string['gradepoints'] = 'Bodovna ocena';
$string['imagetype'] = 'Tip slike';
$string['incompletemessage'] = 'Da biste preuzeli svoj sertifikat, prvo morate završiti sve obavezne aktivnosti. Molimo vas da se vratite na kurs i završite svoje obaveze na kursu.';
$string['intro'] = 'Uvod';
$string['issued'] = 'Izdat';
$string['issueddate'] = 'Datum izdavanja';
$string['issueoptions'] = 'Opcije za izdavanje';
$string['landscape'] = 'Položena stranica';
$string['lastviewed'] = 'Poslednji put ste dobili sertifikat dana:';
$string['letter'] = 'Pismo';
$string['lockingoptions'] = 'Opcije za zaključavanje';
$string['modulename'] = 'Sertifikat';
$string['modulename_link'] = 'Certificate_module';
$string['modulenameplural'] = 'Sertifikati';
$string['mycertificates'] = 'Moji sertifikati';
$string['nocertificates'] = 'Ne postoje sertifikati';
$string['nocertificatesissued'] = 'Ne postoje sertifikati koji su izdati';
$string['nocertificatesreceived'] = 'nije dobilo/la nijedan sertifikat.';
$string['nofileselected'] = 'Morate izabrati datoteku za postavljanje';
$string['nogrades'] = 'Nema dostupnih ocena';
$string['notapplicable'] = 'Nije primenljivo';
$string['notfound'] = 'Broj sertifikata nije bilo moguće potvrditi.';
$string['notissued'] = 'Nije izdat';
$string['notissuedyet'] = 'Još nije izdat';
$string['notreceived'] = 'Još niste dobili ovaj sertifikat';
$string['openbrowser'] = 'Otvori u novom prozoru';
$string['opendownload'] = 'Kliknite donje dugme da biste sačuvali sertifikat na svom računaru';
$string['openemail'] = 'Kliknite donje dugme i sertifikat će Vam biti poslat kao prilog e-poruci.';
$string['openwindow'] = 'Kliknite donje dugme da biste otvorili sertifikat u novom prozoru veb čitača';
$string['or'] = 'ili';
$string['orientation'] = 'Orijentacija';
$string['orientation_help'] = 'Izaberite da li želite da orijentacija sertifikata bude uspravna i položena';
$string['pluginadministration'] = 'Administracija sertifikata';
$string['pluginname'] = 'Sertifikat';
$string['portrait'] = 'Uspravna stranica';
$string['printdate'] = 'Štampaj datum';
$string['printdate_help'] = 'Ovo je datum koji će biti odštampan ako izaberete opciju \'Štampaj datum\'. U slučaju da je izabran datum završetka kursa, a student kurs nije završio, biće odštampan datum dobijanja sertifikata. Takođe, možete da izaberete da kao datum bude odštampan dan kada je aktivnost ocenjena. Ako se sertifikat izdaje pre ocenjivanja aktivnosti, biće odštampan datum dobijanja sertifikata.';
$string['printerfriendly'] = 'Stranica prilagođena za štampanje';
$string['printgrade'] = 'Štampaj ocenu';
$string['printgrade_help'] = 'Možete da izaberete bilo koju dostupnu stavku iz knjige ocena kako biste tu ocenu štampali na sertifikatu, Stavke ocena poređane su istom redosledom kojim se pojavljuju u knjizi ocena. Izaberite format ocene dole.';
$string['printhours'] = 'Štampaj broj kredita (bodova)';
$string['printhours_help'] = 'Upišite ovde broj kredita (bodova) koje treba odštampati na sertifikatu';
$string['printnumber'] = 'Štampaj kôd';
$string['printnumber_help'] = 'Na sertifikatu će biti odštampan jedinstven kôd od 10 nasumično odabranih slova i brojeva. Ovaj broj može biti potvrđen upoređivanjem sa kôdnim brojem koji se prikazuuje u izveštaju o sertifikatu.';
$string['printoutcome'] = 'Štampaj ishod';
$string['printoutcome_help'] = 'Možete da izaberete bilo koji ishod kursa kako biste na sertifikatu odštampali naziv ishoda i rezultat koji je student/korisnik postigao. Na primer: Ishod zadataka: Odličan (Vešt).';
$string['printseal'] = 'Pečat ili slika logotipa';
$string['printseal_help'] = 'Ova opcija vam omogućava da iz direktorijuma certificate/pix/seals izaberete pečat ili logotip koji će biti odštampan na sertifikatu. Standardno, ova slika se smešta u donji desni ugao sertifikata.';
$string['printsignature'] = 'Slika potpisa';
$string['printsignature_help'] = 'Ova opcija vam omogućava da na sertifikatu odštampate sliku potpisa iz direktorijuma certificate/pix/signatures. Možete da štampate grafički prikaz potpisa, ili da štampate liniju za svojeručni potpis. Standardno, ova slika se smešta u donji levi ugao sertifikata.';
$string['printteacher'] = 'Štampaj ime(na) predavača';
$string['printteacher_help'] = 'Za štampanje imena predavača na sertifikatu podesite ulogu predavača na nivou modula. Uradite ovo ukoliko, na primer, imate više od jednog predavača na kursu, ili ako imate više od jednog sertifikata i želite da štampate različita imena predavača na svakom sertifikatu. Kliknite da biste uredili sertifikat, a zatim kliknite na karticu \'Lokalno dodeljene uloge\'. Zatim dodelite ulogu predavača za sertfikat (ovi korisnici NE MORAJU da budu predavači na nivou kursa - tj. ulogu možete dodeliti bilo kom korisniku). Ova imena biće odštampana na sertifikatu.';
$string['printwmark'] = 'Slika vodenog žiga';
$string['printwmark_help'] = 'Datoteka sa vodenim žigom može biti postavljena u pozadinu sertifikata. Vodeni žig predstavlja izbledelu verzija grafike. Kao žig se može koristi logo, pečat, grb, tekst ili bilo šta što želite da koristite kao grafičku pozadinu.';
$string['receivedcerts'] = 'Dobijeni sertifikati';
$string['receiveddate'] = 'Datum dobijanja';
$string['reissuecert'] = 'Ponovo izdaj sertifikate';
$string['reissuecert_help'] = 'Ako ovde izaberete \'Da\'. onda će ovaj sertifikat biti ponovo izdat sa novim datumom, ocenom i kodnim brojem svaki put kada korisnik klikne na link za sertifikat. Napomena: iako će tabela prikazati prethodne datume dobijanja sertifikata, korisnicima neće biti dostupno dugme za pregled. U izveštaju o sertifikatu će se pojaviti samo poslednji izdati sertifikat.';
$string['removecert'] = 'Izdati sertifikovati su uklonjeni';
$string['report'] = 'Izveštaj';
$string['reportcert'] = 'Izveštaj o sertifikatima';
$string['reportcert_help'] = 'Ako ovde izaberete \'Da\', onda će ovaj datum dobijanja sertifikata, kôdni broj i naziv kursa biti prikazani u izveštaju o sertifikatima korisnika. Ako izaberete da štampate ocenu na ovom sertifikatu, onda će i ta ocena biti prikazana u izveštaju.';
$string['requiredtimenotmet'] = 'Da biste mogli da pristupite ovom sertifikatu morate da provedete najmanje {$a->requiredtime} minuta na kursu.';
$string['requiredtimenotvalid'] = 'Neophodno vreme mora da bude ispravan broj veći od 0';
$string['reviewcertificate'] = 'Pregledajte svoj sertifikat';
$string['savecert'] = 'Sačuvaj sertifikat';
$string['savecert_help'] = 'Ako izaberete ovu opciju. onda će kopija svake .pdf datoteke sertifikata biti sačuvana u direktorijumu moddata odgovarajućeg kursa. U izveštaju o sertifikatu biće prikazan link ka svakom sačuvanom sertifikatu korisnika.';
$string['seal'] = 'Pečat';
$string['sigline'] = 'linija';
$string['signature'] = 'Potpis';
$string['statement'] = 'je završio/la kurs';
$string['summaryofattempts'] = 'Rezime ranije dobijenih sertifikata';
$string['textoptions'] = 'Opcije za tekst';
$string['title'] = 'SERTIFIKAT POSTIGNUĆA';
$string['to'] = 'Dodeljuje se polazniku';
$string['typeA4_embedded'] = 'A4 ugrađeno';
$string['typeA4_non_embedded'] = 'A4 ne-ugrađeno';
$string['typeletter_embedded'] = 'Pismo ugrađeno';
$string['typeletter_non_embedded'] = 'Pismo ne-ugrađeno';
$string['unsupportedfiletype'] = 'Datoteka mora da bude u  jpeg ili png formatu';
$string['uploadimage'] = 'Postavi sliku';
$string['uploadimagedesc'] = 'Ovo dugme će vas odvesti na novi ekran gde ćete moći da postavite slike';
$string['userdateformat'] = 'Datum u formatu jezika korisnika';
$string['validate'] = 'Potvrdi';
$string['verifycertificate'] = 'Potvrdi sertifikat';
$string['viewcertificateviews'] = 'Pogledaj {$a} izdata/ih sertifikata';
$string['viewed'] = 'Ovaj sertifikat dobili ste dana:';
$string['viewtranscript'] = 'Pogledaj sertifikate';
$string['watermark'] = 'Vodeni žig';
