<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'sr_lt', version '3.11'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Imate predstojeće BigBlueButton sesije';
$string['bbbduetimeoverstartingtime'] = 'Vreme završetka ove aktivnost mora biti nakon vremena njenog početka';
$string['bbbdurationwarning'] = 'Maksimalno trajanje ove sesije je %duration% minuta.';
$string['bbbrecordallfromstartwarning'] = 'Ova sesija se snima od početka.';
$string['bbbrecordwarning'] = 'Ova sesija može da se snimi.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Dodaj novi sastanak';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Kreiranje instance sesije uživo';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Kreiranje instance sa snimcima';
$string['bigbluebuttonbn:deleterecordings'] = 'Brisanje snimaka';
$string['bigbluebuttonbn:importrecordings'] = 'Uvoz snimaka';
$string['bigbluebuttonbn:join'] = 'Pristupi sastanku';
$string['bigbluebuttonbn:managerecordings'] = 'Upravljanje snimcima';
$string['bigbluebuttonbn:protectrecordings'] = 'Zaštita snimaka';
$string['bigbluebuttonbn:publishrecordings'] = 'Objavljivanje snimaka';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Uklanjanje zaštite snimaka';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Opoziv objavljenih snimaka';
$string['bigbluebuttonbn:view'] = 'Pregled BigBlueButton sobe';
$string['cachedef_currentfetch'] = 'Podaci za spisak svih snimaka nedavno preuzetih.';
$string['cachedef_recordings'] = 'Metapodaci o snimku';
$string['cachedef_serverinfo'] = 'Informacije o udaljenom serveru';
$string['cachedef_validatedurls'] = 'Keš provera potvrđenih URL adresa';
$string['calendarstarts'] = '{$a} zakazan je za';
$string['cannotperformaction'] = 'Nije moguće izvršiti akciju {$a} na ovom snimku';
$string['completionattendance'] = 'Student mora prisustvovati sesiji najmanje:';
$string['completionattendance_desc'] = 'Student mora da uđe u konferencijsku sobu i ostane na sesiji najmanje {$a} minuta.';
$string['completionattendance_event_desc'] = 'Student je ušao u konferencijsku sobu i ostao na sesiji najmanje {$a} minuta';
$string['completionattendancegroup'] = 'Zahtevajte prisustvo';
$string['completionattendancegroup_help'] = 'Za završetak aktivnosti potrebno je prisustvo  sastanku i trajanju od (n) minuta.';
$string['completionengagement_desc'] = 'Polaznik se mora uključiti u aktivnosti tokom sastanka.';
$string['completionengagementchats'] = 'Razgovori';
$string['completionengagementchats_desc'] = 'Student mora učestovati u najmanje {$a} razgovora kako bi završio aktivnost.';
$string['completionengagementchats_event_desc'] = 'Učestovao u razgovoru {$a} put(a)';
$string['completionengagementemojis'] = 'Emotikoni';
$string['completionengagementemojis_desc'] = 'Polaznik mora da pošalje {$a} emotikona kako bi završio aktivnost.';
$string['completionengagementemojis_event_desc'] = 'Poslao emotikon {$a} put(a)';
$string['completionengagementgroup'] = 'Zahtevajte učešće';
$string['completionengagementgroup_help'] = 'Za završetak aktivnosti je potrebno aktivno učešće tokom sesije.';
$string['completionengagementpollvotes'] = 'Glasovi u anketi/Odgovori na pitanja';
$string['completionengagementpollvotes_desc'] = 'Student mora da pošalje glas/odgovor najmanje {$a} put(a) kako bi završio aktivnost.';
$string['completionengagementpollvotes_event_desc'] = 'Glasao/odgovorio {$a} put(a)';
$string['completionengagementraisehand'] = 'Zahtevajte podizanje ruke';
$string['completionengagementraisehand_desc'] = 'Polaznik mora da podigne ruku barem {$a} put(a) kako bi završio aktivnost.';
$string['completionengagementraisehand_event_desc'] = 'Podigao ruku {$a} put(a)';
$string['completionengagementtalks'] = 'Uključiti se u sesiju glasom';
$string['completionengagementtalks_desc'] = 'Polaznik mora da se uključi u sesiju glasom barem {$a} put(a) kako bi završio aktivnost.';
$string['completionengagementtalks_event_desc'] = 'Uključio se u sesiji glasom {$a} put(a)';
$string['completionupdatestate'] = 'Status ažuriranja završetka';
$string['completionvalidatestate'] = 'Provera završetka';
$string['completionvalidatestatetriggered'] = 'Provera završetka je pokrenuta';
$string['completionview'] = 'Zahtevaj pregled';
$string['completionview_desc'] = 'Polaznik mora da pristupi konferencijskoj sobi kako bi završio ovu aktivnost.';
$string['completionview_event_desc'] = 'Pogledao/la  je konferencijsku sobu.';
$string['config_checksum_algorithm'] = 'BigBlueButton Checksum Algorithm';
$string['config_default_messages'] = 'Podrazumevane poruke';
$string['config_default_messages_description'] = 'Podesite podrazumevane poruke za aktivnosti';
$string['config_disablecam_default'] = 'Opcija \'Onemogući veb kameru\' je standardno omogućena';
$string['config_disablecam_default_description'] = 'Ako je ova opcija omogućena, veb kamere će biti onemogućene.';
$string['config_disablecam_editable'] = 'Opcija \'Onemogući veb kameru\' može da se uređuje';
$string['config_disablecam_editable_description'] = 'Opcija \'Onemogući veb kameru\', koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_disablemic_default'] = 'Opcija \'Onemogući mikrofon\' je standardno omogućena';
$string['config_disablemic_default_description'] = 'Ako je ova opcija omogućena, mikrofoni će biti onemogućeni.';
$string['config_disablemic_editable'] = 'Opcija \'Onemogući mikrofon\' može da se uređuje';
$string['config_disablemic_editable_description'] = 'Opcija \'Onemogući mikrofon\', koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_disablenote_default'] = 'Opcija \'Onemogući deljene beleške\' je standardno omogućena';
$string['config_disablenote_default_description'] = 'Ako je ova opcija omogućena, deljene beleške će biti onemogućene.';
$string['config_disablenote_editable'] = 'Opcija \'Onemogući deljene beleške\' može da se uređuje';
$string['config_disablenote_editable_description'] = 'Opcija \'Onemogući deljene beleške\' koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_disableprivatechat_default'] = 'Opcija \'Onemogući privatni razgovor\' je standardno omogućena';
$string['config_disableprivatechat_default_description'] = 'Ako je ova opcija omogućena, javni razgovor će biti onemogućen.';
$string['config_disableprivatechat_editable'] = 'Opcija \'Onemogući privatni razgovor\' može da se uređuje';
$string['config_disableprivatechat_editable_description'] = 'Opcija \'Onemogući privatni razgovor\'koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_disablepublicchat_default'] = 'Opcija \'Onemogući javni razgovor\' je standardno omogućena';
$string['config_disablepublicchat_default_description'] = 'Ako je ova opcija omogućena, privatni razgovor će biti onemogućen.';
$string['config_disablepublicchat_editable'] = 'Opcija \'Onemogući javni razgovor\' može da se uređuje';
$string['config_disablepublicchat_editable_description'] = 'Opcija \'Onemogući javni razgovor\', koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_experimental_features'] = 'Eksperimentalne funkcije';
$string['config_experimental_features_description'] = 'Konfiguracija za eksperimentalne funkcije.';
$string['config_extended_capabilities'] = 'Konfiguracija za dodatne mogućnosti';
$string['config_extended_capabilities_description'] = 'Konfiguracija za proširene mogućnosti kada ih nudi BigBlueButton server.';
$string['config_general'] = 'Opšta konfiguracija';
$string['config_general_description'] = 'Ova podešavanja se <b>uvek</b> koriste';
$string['config_hideuserlist_default'] = 'Opcija \'Sakrij spisak korisnika\' je standardno omogućena';
$string['config_hideuserlist_default_description'] = 'Ako je ova opcija omogućena, spisak korisnika sesije će biti sakriven.';
$string['config_hideuserlist_editable'] = 'Opcija \'Sakrij spisak korisnika\' može da se uređuje';
$string['config_hideuserlist_editable_description'] = 'Opcija \'Sakrij spisak korisnika\' koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_importrecordings'] = 'Uvoz snimaka';
$string['config_importrecordings_description'] = 'Ova podešavanja su specifična za ovu funkciju.';
$string['config_importrecordings_enabled'] = 'Uvoz snimaka je omogućen';
$string['config_importrecordings_enabled_description'] = 'Kada su ovo i funkcija snimanja omogućene, moguće je uvesti snimke sa različitih kurseva u aktivnost.';
$string['config_importrecordings_from_deleted_enabled'] = 'Uvoz snimaka iz obrisanih snimaka je omogućen';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Kada su ovo i funkcija uvoza snimaka omogućene, moguće je uvesti snimke iz aktivnosti koje više ne postoje na kursu.';
$string['config_lockonjoin_default'] = 'Opcija \'Zaključavanja podešavanja prilikom pristupa sesiji\' je standardno omogućena';
$string['config_lockonjoin_default_description'] = 'Ako je ova opcija omogućena, podešavanja zaključana konfiguracijom se primenjuju kada korisnik pristupa sesiji. Konfiguracija zaključavanja mora biti omogućena da bi se ovo primenilo.';
$string['config_lockonjoin_editable'] = 'Opcija \'Zaključavanja podešavanja prilikom pristupa sesiji\' može da se uređuje';
$string['config_lockonjoin_editable_description'] = 'Opcija \'Zaključavanja podešavanja prilikom pristupa sesiji\' koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_locksettings'] = 'Konfiguracija za zaključavanje podešavanja';
$string['config_locksettings_description'] = 'Ova podešavanja omogućavaju ili onemogućavaju opcije u korisničkom interfejsu za zaključavanja podešavanja, a takođe definišu podrazumevane vrednosti za ove opcije.';
$string['config_meetingevents_enabled'] = 'Registrujte sesije uživo';
$string['config_meetingevents_enabled_description'] = 'Ako je ova opcija omogućena, sesije uživo će biti obrađena nakon što se završi. Ova funkcija je potrebna za Završetak aktivnosti i radiće samo ako je BigBlueButton server sposoban da obrađuje post_events skripte.';
$string['config_muteonstart'] = 'Isključite zvuk na početku';
$string['config_muteonstart_default'] = 'Opcija \'Isključite zvuk na početku\' je standardno omogućena';
$string['config_muteonstart_default_description'] = 'Ako je ova opcija omogućena, zvuk će biti isključena na početku sesije.';
$string['config_muteonstart_description'] = 'Ova podešavanja omogućavaju ili onemogućavaju opcije u korisničkom interfejsu i takođe definišu podrazumevane vrednosti za ove opcije.';
$string['config_muteonstart_editable'] = 'Opcija \'Isključite zvuk na početku\' može da se uređuje';
$string['config_muteonstart_editable_description'] = 'Opcija \'Isključite zvuk na početku\' koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_participant'] = 'Učesnici';
$string['config_participant_description'] = 'Ova podešavanja definišu podrazumevane uloge za učesnike.';
$string['config_participant_moderator_default'] = 'Moderator';
$string['config_participant_moderator_default_description'] = 'Ovo pravilo se standardno koristi kada se dodaje nova konferencijska soba.';
$string['config_presentation_default'] = 'Podrazumevana prezentacija';
$string['config_presentation_default_description'] = 'Može se postaviti datoteka koja će se koristiti u svim konferencijskim sobama.';
$string['config_preuploadpresentation'] = 'Unapred postavljena prezenatacija';
$string['config_preuploadpresentation_description'] = 'Ova podešavanja omogućavaju ili onemogućavaju opcije u korisničkom interfejsu i takođe definišu podrazumevane vrednosti za ove opcije. Ovo funkcioniše samo ako je Moodle server dostupan BigBlueButtonu.';
$string['config_preuploadpresentation_editable'] = 'Opcija \'Unapred postavljena prezentacija\' može da uređuje';
$string['config_preuploadpresentation_editable_description'] = 'Opcija \'Unapred postavljena prezentacija\' može da se uređuje u korisničkom interfejsu kada se dodaje ili ažurira soba/konferencija.';
$string['config_recording'] = 'Snimanje';
$string['config_recording_all_from_start_default'] = 'Započnite snimanje od početka';
$string['config_recording_all_from_start_default_description'] = 'Da li podešavanje \'Započnite snimanje od početka\' treba da bude standardno omogućeno kada se dodaje nova BigBlueButton soba?';
$string['config_recording_all_from_start_editable'] = 'Opcija \'Započnite snimanje od početka\' može da uređuje';
$string['config_recording_all_from_start_editable_description'] = 'Da li opcija \'Započnite snimanje od početka\' može da se uređuje na stranici za podešavanje BigBlueButton aktivnosti?';
$string['config_recording_default'] = 'Snimanje je standardno omogućeno';
$string['config_recording_default_description'] = 'Da li podešavanje \'Sesija može biti snimljena\' treba da bude standardno omogućena kada se dodaje nova BigBlueButton soba?';
$string['config_recording_description'] = 'Ova podešavanja su specifična za ovu funkciju';
$string['config_recording_editable'] = 'Opcija \'Sesija se može snimiti\' može da uređuje';
$string['config_recording_editable_description'] = 'Da li opcija \'Sesija se može snimiti\' može da se uređuje na stranici za podešavanje BigBlueButton
 aktivnosti?';
$string['config_recording_hide_button_default'] = 'Sakrij dugme za snimanje';
$string['config_recording_hide_button_default_description'] = 'Ako je polje označeno, dugme za snimanje biće sakriveno';
$string['config_recording_hide_button_editable'] = 'Opcija \'Sakrij dugme za snimanje\' može da se uređuje';
$string['config_recording_hide_button_editable_description'] = 'Da li opcija \'Sakrij dugme za snimanje\' može da se uređuje na stranici za podešavanje BigBlueButton aktivnosti?';
$string['config_recording_protect_editable'] = 'Status zaštićenosti snimaka se može da se uređuje';
$string['config_recording_protect_editable_description'] = 'Ako je ovo polje označeno u korisničkom interfejsu će se videti opcija za postavljanje/uklanjanje zaštite snimaka.';
$string['config_recording_refresh_period'] = 'Period osvežavanja snimanja (u sekundama)';
$string['config_recording_refresh_period_description'] = 'Koliko često treba tražiti od BigBlueButton servera da osveži udaljene informacije za snimak?';
$string['config_recordingready_enabled'] = 'Pošaljite dostupno obaveštenje o snimku';
$string['config_recordingready_enabled_description'] = 'Ako je ova opcija omogućena, biće poslato obaveštenje kada link snimka bude dostupan. Ova funkcija zahteva da skripta post_publish_recording_ready_callback bude omogućena na BigBlueButton serveru.';
$string['config_recordings'] = 'Prikaz snimaka';
$string['config_recordings_description'] = 'Ova podešavanja su specifična za ovu funkciju';
$string['config_recordings_general'] = 'Prikaži podešavanja za snimanje';
$string['config_recordings_general_description'] = 'Ova podešavanja se koriste samo prilikom prikazivanja snimaka';
$string['config_recordings_imported_default'] = 'Opcija \'Prikaži samo uvezene linkove\' je standardno omogućena';
$string['config_recordings_imported_default_description'] = 'Ako je ova opcija omogućena tabela sa snimcima će sadržati samo linkove ka snimcima.';
$string['config_recordings_imported_editable'] = 'Opcija \'Prikaži samo uvezene linkove\' može da se menja';
$string['config_recordings_imported_editable_description'] = 'Opcija \'Prikaži samo uvezene linkove\' koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_recordings_preview_default'] = 'Opcija \'Pregled\' je standardno omogućena';
$string['config_recordings_preview_default_description'] = 'Ako je ova opcija omogućena tabela sa snimcima će sadržati pregled prezentacije.';
$string['config_recordings_preview_editable'] = 'Opcija \'Pregled\' može da se uređuje';
$string['config_recordings_preview_editable_description'] = 'Opcija \'Pregled\' može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['config_recordings_sortorder'] = 'Poređajte snimke rastućim redosledom.';
$string['config_recordings_sortorder_description'] = 'Standardno, snimci su prikazani opadajućim redosledom. Kada je ovo polje označeno, oni će biti sortirani rastućim redosledom.';
$string['config_scheduled'] = 'Konfiguracija za funkcionalnost ”Planirane sesije”';
$string['config_scheduled_description'] = 'Ova podešavanja definišu neka od standardnih ponašanja za planirane sesije.';
$string['config_scheduled_pre_opening'] = 'Sesija dostupna pre otvaranja (minuti)';
$string['config_scheduled_pre_opening_description'] = 'Vremenski period u minutima, tokom kojeg će moći da se pristupi sesiji i pre planiranog vremena njenog otvaranja.';
$string['config_server_url'] = 'URL adresa BigBlueButton servera';
$string['config_server_url_description'] = 'URL adresa vašeg BigBlueButton servera mora da se završava sa /bigbluebutton/. (Ova podrazumevana URL adresa je za BigBlueButton server koji je obezbedio Blindside Networks, i koji možete da koristite za testiranje).';
$string['config_shared_secret'] = 'BigBlueButton tajni ključ';
$string['config_shared_secret_description'] = 'Bezbednosni nasumični string (salt) vašeg BigBlueButton servera. (Ovo je podrazumevani nasumični string BigBlueButton servera koji je obezbdio Blindside Networks, i koji možete da koristite za testiranje).';
$string['config_uidelegation_enabled'] = 'Prosleđivanje korisničkog interfejsa je omogućeno';
$string['config_uidelegation_enabled_description'] = 'Ova podešavanja omogućavaju ili onemogućavaju prosleđivanje korisničkog interfejsa BigBlueButton serveru.';
$string['config_userlimit'] = 'Ograničenje broja korisnika';
$string['config_userlimit_default'] = 'Opcija \'Ograničenje broja korisnika\' je standardno omogućena';
$string['config_userlimit_default_description'] = 'Broj korisnika koji je standardno dozvoljen na sesiji kada se doda nova konferencijska soba. Podesite na 0 kako biste dozvolili neograničen broj korisnika.';
$string['config_userlimit_description'] = 'Ova podešavanja omogućavaju ili onemogućavaju opcije u korisničkom interfejsu i takođe definišu podrazumevane vrednosti za ove opcije.';
$string['config_userlimit_editable'] = 'Opcija \'Ograničenje broja korisnika\' može da se uređuje';
$string['config_userlimit_editable_description'] = 'Opcija \'Ograničenje broja korisnika\' koja je standardno omogućena može da se uređuje kada se dodaje ili ažurira konferencijska soba.';
$string['config_voicebridge'] = 'Glasovni most';
$string['config_voicebridge_description'] = 'Ova podešavanja omogućavaju ili onemogućavaju opcije u korisničkom interfejsu i takođe definišu podrazumevane vrednosti za ove opcije.';
$string['config_voicebridge_editable'] = 'Konferencijski glasovni most se može da se uređuje';
$string['config_voicebridge_editable_description'] = 'Broj konferencijskog glasovnog mosta može se trajno dodeliti sobi. Kada je dodeljen, broj se ne može koristiti ni za jednu drugu sobu.';
$string['config_waitformoderator'] = 'Sačekajte moderatora';
$string['config_waitformoderator_cache_ttl'] = 'Sačekajte moderatora - TTL keš (sekunde)';
$string['config_waitformoderator_cache_ttl_description'] = 'Kako bi podržao veliki broj klijenata, ovaj dodatak koristi keš memoriju. Ovaj parametar definiše koliko dugo će se keš čuvati pre nego što se pošalje sledeći zahtev BigBlueButton serveru.';
$string['config_waitformoderator_default'] = 'Opcija \'Sačekajte moderatora\' je standardno omogućeno';
$string['config_waitformoderator_default_description'] = 'Da li opcija \'Sačekajte moderatora\' treba da bude standardno omogućena kada se dodaje nova BigBlueButton soba?';
$string['config_waitformoderator_description'] = 'Ova podešavanja su specifična za ovu funkciju';
$string['config_waitformoderator_editable'] = 'Opcija \'Sačekajte moderatora\' može da se uređuje';
$string['config_waitformoderator_editable_description'] = 'Da li opcija \'Sačekajte moderatora\' može da se uređuje na stranici za podešavanje BigBlueButton aktivnosti?';
$string['config_waitformoderator_ping_interval'] = 'Sačekajte moderatora - ping signal (sekunde)';
$string['config_waitformoderator_ping_interval_description'] = 'Koliko često treba slati serveru ping signal da bi se proverilo da li je moderator ušao u konferencijsku sobu?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton koristi config.php datoteku sa globalnom promenljivom koja je zastarela. Konvertujte datoteku jer neće biti podržana u budućim verzijama.';
$string['config_warning_curl_not_installed'] = 'Ova funkcionalnost zahteva da php ekstenzija CURL bude instalirana i omogućena. Podešavanja će biti dostupna samo ako je ispunjen ovaj uslov.';
$string['config_welcome_default'] = 'Podrazumevana poruka dobrodošlice';
$string['config_welcome_default_description'] = 'Poruka dobrodošlice se prikazuje kada učesnici uđu u sobu. Ako je polje ostavljeno prazno, prikazuje se poruka podešena na BigBlueButton serveru.';
$string['config_welcome_editable'] = 'Opciju \'Podrazumevana poruka dobrodošlice\' mogu da uređuju predavači';
$string['config_welcome_editable_description'] = 'Poruka dobrodošlice može da se uređuje kada se dodaje ili ažurira instanca BigBlueButtona.';
$string['email_body_notification_meeting_by'] = 'od strane';
$string['email_body_notification_meeting_description'] = 'Opis';
$string['email_body_notification_meeting_details'] = 'Detaljne informacije';
$string['email_body_notification_meeting_end_date'] = 'Datum kraja';
$string['email_body_notification_meeting_has_been'] = 'je';
$string['email_body_notification_meeting_start_date'] = 'Datum početka';
$string['email_body_notification_meeting_title'] = 'Naslov';
$string['email_body_recording_ready_for'] = 'Snimak';
$string['email_footer_sent_by'] = 'Ovu automatsku poruka sa obaveštenjem poslao je';
$string['email_footer_sent_from'] = 'sa kursa';
$string['end_session_confirm'] = 'Da li ste sigurni da želite da završite sesiju?';
$string['end_session_confirm_title'] = 'Stvarno želite da završite sesiju?';
$string['end_session_notification'] = 'Sesija je završena.';
$string['ends_at'] = 'Završava se';
$string['event_activity_created'] = 'Aktivnost kreirana';
$string['event_activity_deleted'] = 'Aktivnost obrisana';
$string['event_activity_updated'] = 'Aktivnost ažurirana';
$string['event_live_session'] = 'Sesija uživo';
$string['event_meeting_created'] = 'Sastanak kreiran';
$string['event_meeting_ended'] = 'Sastanak prinudno završen';
$string['event_meeting_joined'] = 'Sastanku pristupljeno';
$string['event_meeting_left'] = 'Sastanak napušten';
$string['event_recording_deleted'] = 'Snimak obrisan';
$string['event_recording_edited'] = 'Snimak uređivan';
$string['event_recording_imported'] = 'Snimak uvezen';
$string['event_recording_protected'] = 'Snimak zaštićen';
$string['event_recording_published'] = 'Snimak objavljen';
$string['event_recording_unprotected'] = 'Zaštita sa snimka uklonjena';
$string['event_recording_unpublished'] = 'Objavljivanje snimka opozvano';
$string['event_recording_viewed'] = 'Snimak prikazan';
$string['event_unknown'] = 'Nepoznati događaj';
$string['general_error_cannot_create_meeting'] = 'Nije moguće kreirati sesiju.';
$string['general_error_cannot_get_recordings'] = 'Nije moguće pribaviti snimke.';
$string['general_error_no_answer'] = 'Prazan odgovor. Molimo, proverite URL adresu BigBlueButton servera. Takođe, proverite da li BigBlueButton server pokrenut.';
$string['general_error_not_allowed_to_create_instances'] = 'Korisniku nije dozvoljeno da kreira bilo koju vrstu instance.';
$string['general_error_not_found'] = 'Stavka nije pronađena : {$a}.';
$string['general_error_unable_connect'] = 'Nije moguće povezati se sa serverom. Molimo, proverite URL adresu BigBlueButton servera. Takođe, proverite da li BigBlueButton server radi.';
$string['index_confirm_end'] = 'Da li želite da završite virtuelni čas?';
$string['index_disabled'] = 'onemogućeno';
$string['index_enabled'] = 'omogućeno';
$string['index_ending'] = 'Virtuelna učionica se završava... molimo sačekajte';
$string['index_error_bbtn'] = 'BigBlueButton ID oznaka {$a} je neispravna';
$string['index_error_checksum'] = 'Došlo je do greške kontrolnog zbira. Proverite da li ste uneli ispravan tajni ključ.';
$string['index_error_forciblyended'] = 'Nije moguće pristupiti ovom sastanku zato što je ručno završen.';
$string['index_error_noinstances'] = 'Ne postoje instance BigBlueButton soba';
$string['index_error_unable_display'] = 'Nije moguće prikazati sastanak. Molimo, proverite URL adresu BigBlueButton servera. Takođe, proverite da li BigBlueButton server radi.';
$string['index_heading'] = 'BigBlueButton sobe';
$string['index_heading_actions'] = 'Akcije';
$string['index_heading_group'] = 'Grupa';
$string['index_heading_moderator'] = 'Moderatori';
$string['index_heading_name'] = 'Konferencijska soba';
$string['index_heading_recording'] = 'Snimak';
$string['index_heading_users'] = 'Korisnici';
$string['index_heading_viewer'] = 'Posmatrači';
$string['indicator:cognitivedepth'] = 'BigBlueButton - kognitivni aspekt';
$string['indicator:cognitivedepth_help'] = 'Ovaj indikator se zasniva na kognitivnoj dubini koju je polaznik postigao u okviru aktivnosti \'BigBlueButton\'.';
$string['indicator:socialbreadth'] = 'BigBlueButton - socijalni aspekt';
$string['indicator:socialbreadth_help'] = 'Ovaj indikator se zasniva na obimu socijalnih interakcija koji je polaznik postigao u okviru aktivnosti \'BigBlueButton\'.';
$string['instance_type_default'] = 'Konferencijska soba sa snimcima';
$string['instance_type_recording_only'] = 'Samo snimci';
$string['instance_type_room_only'] = 'Samo konferencijska soba';
$string['instanceprofilewithoutrecordings'] = 'Ovaj profil instance ne može da prikaže snimke';
$string['messageprovider:instance_updated'] = 'BigBlueButton sesija ažurirana';
$string['messageprovider:recording_ready'] = 'BigBlueButton snimak je dostupan';
$string['minute'] = 'minut';
$string['minutes'] = 'minuti';
$string['mod_form_block_general'] = 'Opšta podešavanja';
$string['mod_form_block_participants'] = 'Uloga dodeljena tokom sesije uživo';
$string['mod_form_block_presentation'] = 'Sadržaj prezentacije';
$string['mod_form_block_presentation_default'] = 'Podrazumevani sadržaj prezentacije';
$string['mod_form_block_record'] = 'Podešavanja snimanja';
$string['mod_form_block_recordings'] = 'Prikaz snimaka';
$string['mod_form_block_room'] = 'Podešavanja konferencijske sobe';
$string['mod_form_block_schedule'] = 'Raspored za sesiju';
$string['mod_form_field_closingtime'] = 'Pristup sesiji se zatvara';
$string['mod_form_field_conference_name'] = 'Naziv konferencije';
$string['mod_form_field_disablecam'] = 'Onemogući veb kamere';
$string['mod_form_field_disablemic'] = 'Onemogući mikrofone';
$string['mod_form_field_disablenote'] = 'Onemogući deljene beleške';
$string['mod_form_field_disableprivatechat'] = 'Onemogući privatni razgovor';
$string['mod_form_field_disablepublicchat'] = 'Onemogući javni razgovor';
$string['mod_form_field_duration'] = 'Trajanje';
$string['mod_form_field_duration_help'] = 'Podešavanje trajanja sastanka će utvrditi maksimalno vreme sastanka, kako bi on potrajao dok se snimanje ne završi.';
$string['mod_form_field_hideuserlist'] = 'Sakrij spisak korisnika';
$string['mod_form_field_instanceprofiles'] = 'Tip instance';
$string['mod_form_field_instanceprofiles_help'] = 'Ako sesija treba da se snima, izaberite \'Konferencijska soba sa snimcima\', u suprotnom \'Samo konferencijska soba\'. Nakon što se sesija snimi, ako više neće biti sesija, izaberite \'Samo snimci\'.';
$string['mod_form_field_intro'] = 'Opis';
$string['mod_form_field_intro_help'] = 'Kratak opis sobe ili konferencije.';
$string['mod_form_field_lockonjoin'] = 'Podešavanja zaključavanja prilikom pristupa sesiji';
$string['mod_form_field_muteonstart'] = 'Isključite zvuk na početku';
$string['mod_form_field_name'] = 'Naziv virtuelne učionice';
$string['mod_form_field_nosettings'] = 'Nijedno podešavanje se ne može menjati';
$string['mod_form_field_notification'] = 'Pošalji obaveštenje';
$string['mod_form_field_notification_created_help'] = 'Pošaljite obaveštenje upisanim korisnicima kako bi znali da je ova aktivnost kreirana';
$string['mod_form_field_notification_help'] = 'Pošaljite obaveštenje upisanim korisnicima kako bi znali da je ova aktivnost kreirana ili promenjena';
$string['mod_form_field_notification_modified_help'] = 'Pošaljite obaveštenje upisanim korisnicima kako bi znali da je ova aktivnost promenjena';
$string['mod_form_field_notification_msg_at'] = 'u';
$string['mod_form_field_notification_msg_created'] = 'kreirana';
$string['mod_form_field_notification_msg_modified'] = 'promenjena';
$string['mod_form_field_openingtime'] = 'Pristup sesiji se otvara';
$string['mod_form_field_participant_add'] = 'Dodaj učesnika';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Posmatrač';
$string['mod_form_field_participant_list'] = 'Spisak učesnika';
$string['mod_form_field_participant_list_action_add'] = 'Dodaj';
$string['mod_form_field_participant_list_action_remove'] = 'Ukloni';
$string['mod_form_field_participant_list_text_as'] = 'pristupa sesiji kao';
$string['mod_form_field_participant_list_type_all'] = 'Svi upisani korisnici';
$string['mod_form_field_participant_list_type_owner'] = 'Vlasnik';
$string['mod_form_field_participant_list_type_role'] = 'Uloga';
$string['mod_form_field_participant_list_type_user'] = 'Korisnik';
$string['mod_form_field_record'] = 'Sesija može biti snimljena';
$string['mod_form_field_recordallfromstart'] = 'Snimi sve od početka';
$string['mod_form_field_recordhidebutton'] = 'Sakrij dugme za snimanje';
$string['mod_form_field_recordings_html'] = 'Prikaži tabelu u običnom HTML formatu';
$string['mod_form_field_recordings_imported'] = 'Prikaži samo uvezene linkove';
$string['mod_form_field_recordings_preview'] = 'Prikaži pregled snimka';
$string['mod_form_field_room_name'] = 'Naziv konferencijske sobe';
$string['mod_form_field_userlimit'] = 'Ograničenje broja korisnika';
$string['mod_form_field_userlimit_help'] = 'Maksimalan broj korisnika kojima je dozvoljeno da prisustvuju sastanku. Ako je limit podešen na 0 onda je broj korisnika neograničen.';
$string['mod_form_field_voicebridge'] = 'Glasovni most [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Greška u formatu. Potrebno je da unesete broj između 1 i 9999.';
$string['mod_form_field_voicebridge_help'] = 'Broj glasovne konferencije koji korisnici unose za pristup konferenciji putem telefona. Uneti broj mora biti između 1 i 9999. Ako je vrednost 0 statični glasovni most biće ignorisan, a BigBlueButton će generisati nasumični broj. Broj 7 će prethoditi unetom četvorocifrenom broju.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Nije jedinstvena vrednost. Ovaj broj već koriste druga soba ili konferencija.';
$string['mod_form_field_wait'] = 'Sačekajte moderatora';
$string['mod_form_field_wait_help'] = 'Posmatrači moraju da sačekaju da moderator prvi uđe na sesiju pre nego što oni budu mogli to da učine';
$string['mod_form_field_welcome'] = 'Poruka dobrodošlice';
$string['mod_form_field_welcome_default'] = '<br>Dobro došli na<b>%%CONFNAME%%</b>!<br><br>Da biste razumeli kako BigBlueButton radi pogledajte naša <a href="event:http://www.bigbluebutton.org/content/videos"><u>video uputstva</u></a>.<br><br>Za pristup ”audio mostu” kliknite na ikonicu sa slušalicama (gornji levi ugao). <b>Molimo vas da koristite slušalice kako bi se izbeglo pravljenje buke.</b>';
$string['mod_form_field_welcome_help'] = 'Zamenjuje podrazumevanu poruku podešenu za BigBlueButton server. Poruka mora da uključuje ključne reči (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) koje će biti automatski zamenjene, kao i html oznake poput <b>...</b> ili <i></i>';
$string['mod_form_locksettings'] = 'Podešavanja zaključavanja';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButtonBN vam dopušta da u okviru Moodlea kreirate onlajn učionice u realnom vremenu koristeći BigBlueButton, veb-konferencijski sistem otvorenog kôda, za obrazovanje na daljinu.

Koristeći BigBlueButton može da navedete naslov, opis, vreme održavanje sesije, grupe i detaljne informacije o snimku onlajn sesije.

Kako biste kasnije mogli da pogledate snimke, dodajte resurs RecordingsBN na ovaj kurs,';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton aktivnost';
$string['nosuchinstance'] = 'Nema takve instance
 {$a->entity} sa ID oznakom {$a->id}';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton soba je kreirana.';
$string['notification_instance_created_small'] = 'Nova BigBlueButton soba pod nazivom {$a->name} je kreirana';
$string['notification_instance_created_subject'] = 'Nova BigBlueButton soba je kreirana';
$string['notification_instance_description'] = 'Opis';
$string['notification_instance_end_date'] = 'Datum završetka';
$string['notification_instance_name'] = 'Naziv';
$string['notification_instance_start_date'] = 'Datum početka';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton soba je ažurirana.';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButton sesija je ažurirana';
$string['notification_instance_updated_subject'] = 'Vaša BigBlueButton soba je ažurirana';
$string['notification_recording_ready_html'] = 'Snimak je sada dostupan za sesiju u BigBlueButton sobi <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'Snimak je sada dostupan za sesiju u BigBlueButton sobi {$a->name}. Idite na {$a->link} kako biste pristupili linku snimka';
$string['notification_recording_ready_small'] = 'Dostupan je snimak za BigBlueButton sobu {$a->name}.';
$string['notification_recording_ready_subject'] = 'Snimak dostupan';
$string['pluginadministration'] = 'Administracija BigBlueButtona';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Da biste kreirali i pristupili BigBlueButton sesiji, korisnički podaci moraju da se razmene sa serverom.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Puno ime korisnika koji pristupa BigBlueButton serveru.';
$string['privacy:metadata:bigbluebutton:userid'] = 'ID oznaka korisnika koji pristupa BigBlueButton serveru.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Konfiguracija BigBlueButton sesije';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Spisak pravila koja definišu ulogu koju će korisnici imati u BigBlueButton sesiji. ID oznaka korisnika može biti sačuvan jer se dozvole mogu dodeliti prema ulozi odnosno prema korisniku.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Čuva događaje pokrenute prilikom korišćenja dodatka.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Tip događaja koji je pokrenuo korisnik.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID oznaka sesije kojoj je korisnik imao pristup.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Dodatne informacije vezane za sesiju ili snimak.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Vreme kada je zapis kreiran.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID oznaka korisnika koji je pokrenuo događaj.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Čuva metapodatke o snimcima.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'ID oznaka korisnika koji je poslednji promenio snimak.';
$string['recordings_from_deleted_activities'] = 'Snimci iz obrisanih aktivnosti';
$string['recordingurlnotfound'] = 'URL adresa snimka je neispravna.';
$string['removedevents'] = 'Obrisani događaji';
$string['removedlogs'] = 'Obrisani prilagođeni zapisi';
$string['removedrecordings'] = 'Obrisani snimci';
$string['removedtags'] = 'Obrisane oznake';
$string['report_join_info'] = 'Pristupio/la je konferencijskoj sobi {$a} put(a)';
$string['report_play_recording_info'] = 'Pustio/la je snimak {$a} put(a)';
$string['report_room_view'] = 'Pogledao/la je konferencijsku sobu';
$string['resetevents'] = 'Obriši događaje';
$string['resetlogs'] = 'Obriši prilagođene zapise';
$string['resetlogs_help'] = 'Brisanje zapisa će za posledicu imati gubitak referenci na snimke.';
$string['resetrecordings'] = 'Obriši snimke';
$string['resetrecordings_help'] = 'Brisanje snimaka učiniće ih nedostupnim sa bilo kog mesta. Ova akcija se ne može opozvati!';
$string['resettags'] = 'Obriši oznake';
$string['search:activity'] = 'BigBlueButton - informacije o aktivnosti';
$string['search:tags'] = 'BigBlueButton - informacije o oznakama';
$string['sendnotification'] = 'Pošalji obaveštenje';
$string['settings'] = 'Podešavanja BigBlueButtona';
$string['started_at'] = 'Počelo';
$string['starts_at'] = 'Počinje';
$string['taskname:check_pending_recordings'] = 'Preuzimanje snimaka na čekanju';
$string['userlimitreached'] = 'Dostignut je broj dozvoljenih korisnika u sesiji.';
$string['view_conference_action_end'] = 'Završi sesiju';
$string['view_conference_action_join'] = 'Pristupi sesiji';
$string['view_error_action_not_completed'] = 'Akcija nije mogla da se završi';
$string['view_error_bigbluebutton'] = 'BigBlueButton je poslao poruku o grešci. {$a}';
$string['view_error_create'] = 'BigBlueButton sever je odgovorio sa porukom o grešci. Sastanak nije mogao da bude kreiran.';
$string['view_error_current_state_not_found'] = 'Trenutni status nije pronađen. Snimak je možda izbrisan ili BigBlueButton server nije kompatibilan sa izvršenom akcijom.';
$string['view_error_import_no_courses'] = 'Nema kurseva za pretragu snimaka';
$string['view_error_import_no_recordings'] = 'Na ovom kursu nema snimaka za uvoz';
$string['view_error_invalid_session'] = 'Sesija je istekla. Vratite se na stranicu aktivnosti.';
$string['view_error_max_concurrent'] = 'Dostignut je dozvoljeni broj istovremenih sastanaka.';
$string['view_error_meeting_not_running'] = 'Nešto nije bilo u redu; sesija nije pokrenuta.';
$string['view_error_no_group'] = 'Još uvek ne postoje kreirane grupe. Molimo, podesite grupe pre nego što pokušate da pristupite sastanku.';
$string['view_error_no_group_student'] = 'Niste upisani u grupu. Molimo, kontaktirajte svog predavača ili administratora.';
$string['view_error_no_group_teacher'] = 'Još uvek ne postoje kreirane grupe. Molimo, podesite grupe ili kontaktirajte administratora.';
$string['view_error_unable_join'] = 'Nije moguće pristupiti sastanku. Molimo, proverite URL adresu BigBlueButton servera. Takođe, proverite da li BigBlueButton server radi.';
$string['view_error_unable_join_student'] = 'Nije moguće uspostaviti vezu sa BigBlueButton serverom. Molimo, kontaktirajte svog predavača ili administratora.';
$string['view_error_unable_join_teacher'] = 'Nije moguće uspostaviti vezu sa BigBlueButton serverom. Molimo, kontaktirajte administratora.';
$string['view_error_url_missing_parameters'] = 'Postoje parametri koji nedostaju u ovoj URL adresi';
$string['view_error_userlimit_reached'] = 'Dostignut je dozvoljeni broj korisnika na sastanku.';
$string['view_groups_nogroups_warning'] = 'Konferencijska soba je konfigurisana za korišćenje grupa, ali na nivou kursa nema definisanih grupe.';
$string['view_groups_notenrolled_warning'] = 'Konferencijska soba je konfigurisana za korišćenje grupa, ali vi niste član nijedne grupe.';
$string['view_groups_selection'] = 'Izaberite grupu kojoj želite da pristupite i potvrdite akciju';
$string['view_groups_selection_join'] = 'Pristupite';
$string['view_groups_selection_warning'] = 'Postoji konferencijska soba za svaku grupu. Ako imate pristup većem broju soba budite sigurni da ste izabrali pravu.';
$string['view_login_moderator'] = 'Prijavljivanje kao moderator...';
$string['view_login_viewer'] = 'Prijavljivanje kao posmatrač...';
$string['view_message_and'] = 'i';
$string['view_message_conference_has_ended'] = 'Ova konferencija je završena.';
$string['view_message_conference_in_progress'] = 'Ova konferencija je u toku.';
$string['view_message_conference_not_started'] = 'Ova konferencija još nije počela.';
$string['view_message_conference_room_ready'] = 'Ova konferencijska soba je spremna. Sada možete da pristupite sesiji.';
$string['view_message_conference_user_limit_reached'] = 'Dostignut je broj dozvoljenih korisnika na sesiji';
$string['view_message_conference_wait_for_moderator'] = 'Sačekajte da moderator pristupi.';
$string['view_message_finished'] = 'Ova aktivnost je završena.';
$string['view_message_has_joined'] = 'pristupio/la je';
$string['view_message_have_joined'] = 'pristupili su';
$string['view_message_hour'] = 'sat';
$string['view_message_hours'] = 'sati';
$string['view_message_importrecordings_disabled'] = 'Uvoz linkova snimaka je onemogućen na serveru.';
$string['view_message_minute'] = 'minut';
$string['view_message_minutes'] = 'minuti';
$string['view_message_moderator'] = 'moderator';
$string['view_message_moderators'] = 'moderatori';
$string['view_message_norecordings'] = 'Ne postoji snimak ovog sastanka.';
$string['view_message_notavailableyet'] = 'Ova sesija još nije dostupna.';
$string['view_message_recordings_disabled'] = 'Snimci su onemogućeni na serveru. BigBlueButton aktivnosti tipa \'Samo snimci\' se ne mogu koristiti';
$string['view_message_room_closed'] = 'Ova konferencijska soba je zatvorena.';
$string['view_message_room_open'] = 'Ova konferencijska soba je otvorena.';
$string['view_message_room_ready'] = 'Ova konferencijska soba je spremna.';
$string['view_message_session_for'] = 'sesija za';
$string['view_message_session_has_user'] = 'Postoji';
$string['view_message_session_has_users'] = 'Postoje';
$string['view_message_session_no_users'] = 'Nema korisnika u ovoj sesiji';
$string['view_message_session_running_for'] = 'Ova sesija traje već';
$string['view_message_session_started_at'] = 'Ova sesija je počela u';
$string['view_message_tab_close'] = 'Ova kartica/prozor mora ručno da se zatvori';
$string['view_message_times'] = 'puta';
$string['view_message_user'] = 'korisnik';
$string['view_message_users'] = 'korisnici';
$string['view_message_viewer'] = 'posmatrač';
$string['view_message_viewers'] = 'posmatrači';
$string['view_mobile_message_groups_not_supported'] = 'Ova instanca je omogućena za rad sa grupama, ali je mobilna aplikacija još uvek ne podržava. Molimo vas, koristite veb verziju.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Proveli ste više od 45 sekundi na ovoj stranici. Osvežite stranicu da biste se pridružili sesiji.';
$string['view_noguests'] = 'BigBlueButtonBN nije otvoren za goste';
$string['view_nojoin'] = 'Niste u ulozi kojoj dozvoljeno da pristupi ovoj sesiji.';
$string['view_recording'] = 'snimak';
$string['view_recording_actionbar'] = 'Traka sa alatkama';
$string['view_recording_activity'] = 'Aktivnost';
$string['view_recording_button_import'] = 'Uvezi linkove snimaka';
$string['view_recording_button_return'] = 'Vrati se';
$string['view_recording_course'] = 'Kurs';
$string['view_recording_date'] = 'Datum';
$string['view_recording_delete_confirmation'] = 'Da li ste sigurni da želite da obrišete ovaj {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Ovaj snimak ima {$a} pridružena/ih link(ov)a koji su bili uvezeni u različite kurseve ili aktivnosti. Ako se snimak obriše onda će i ti linkovi biti obrisani.';
$string['view_recording_delete_confirmation_warning_s'] = 'Ovaj snimak ima {$a} pridruženi link koji je bio uvezen u različit kurs ili aktivnost.  Ako se snimak obriše onda će i taj link biti obrisani.';
$string['view_recording_description'] = 'Opis';
$string['view_recording_description_edithint'] = 'Može se dodati opis koji će pomoći u identifikaciji snimka.';
$string['view_recording_description_editlabel'] = 'Uredi opis';
$string['view_recording_duration'] = 'Trajanje';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'URL adresa za ovaj format snimka je nedostupan.';
$string['view_recording_format_notes'] = 'Beleške';
$string['view_recording_format_podcast'] = 'Potkast';
$string['view_recording_format_presentation'] = 'Prezentacija';
$string['view_recording_format_screenshare'] = 'Deljenje ekrana';
$string['view_recording_format_statistics'] = 'Statistika';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Da li ste sigurni da želite da uvezete ovaj snimak?';
$string['view_recording_length'] = 'Dužina';
$string['view_recording_link'] = 'uvezen link';
$string['view_recording_link_warning'] = 'Ovo je link koji pokazuje na snimak koji je kreiran unutar drugog kursa ili aktivnosti';
$string['view_recording_list_action_delete'] = 'Brisanje';
$string['view_recording_list_action_edit'] = 'Ažuriranje';
$string['view_recording_list_action_play'] = 'Reprodukuj snimak';
$string['view_recording_list_action_process'] = 'Obrada';
$string['view_recording_list_action_protect'] = 'Zaštita';
$string['view_recording_list_action_publish'] = 'Objavljivanje';
$string['view_recording_list_action_unprotect'] = 'Uklanjanje zaštite';
$string['view_recording_list_action_unpublish'] = 'Opoziv objavljivanja';
$string['view_recording_list_action_update'] = 'Ažuriranje';
$string['view_recording_list_actionbar'] = 'Traka sa alatkama';
$string['view_recording_list_actionbar_delete'] = 'Obriši';
$string['view_recording_list_actionbar_edit'] = 'Uredi';
$string['view_recording_list_actionbar_hide'] = 'Sakrij';
$string['view_recording_list_actionbar_import'] = 'Uvoz';
$string['view_recording_list_actionbar_protect'] = 'Učini snimak privatnim';
$string['view_recording_list_actionbar_publish'] = 'Objavi';
$string['view_recording_list_actionbar_show'] = 'Prikaži';
$string['view_recording_list_actionbar_unprotect'] = 'Učini snimak javnim';
$string['view_recording_list_actionbar_unpublish'] = 'Opozovi objavljeni snimak';
$string['view_recording_list_activity'] = 'Aktivnost';
$string['view_recording_list_course'] = 'Kurs';
$string['view_recording_list_date'] = 'Datum';
$string['view_recording_list_description'] = 'Opis';
$string['view_recording_list_duration'] = 'Trajanje';
$string['view_recording_list_recording'] = 'Snimak';
$string['view_recording_meeting'] = 'Sastanak';
$string['view_recording_modal_button'] = 'Primeni';
$string['view_recording_modal_title'] = 'Podesite vrednosti za snimanje';
$string['view_recording_name'] = 'Naziv';
$string['view_recording_name_edithint'] = 'Može se dodati naziv kako bi se lakše identifikovao snimak.';
$string['view_recording_name_editlabel'] = 'Uredi naziv';
$string['view_recording_playback'] = 'Reprodukcija';
$string['view_recording_preview'] = 'Pregled';
$string['view_recording_preview_help'] = 'Pređite kursorom preko slike kako biste je videli u punoj veličini';
$string['view_recording_protect_confirmation'] = 'Da li ste sigurni da želite da zaštitite ovaj snimak {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Ovaj snimak ima {$a} povezane/ih veze/a koje su importovane u druge kurseve ili aktivnosti. Ako je snimak zaštićen, to će uticati i na importovane veze.';
$string['view_recording_protect_confirmation_warning_s'] = 'Ovaj snimak ima {$a} povezanu vezu koja je importovana u drugi kurs ili aktivnost. Ako je snimak zaštićen, to će uticati i na importovane veze.';
$string['view_recording_publish_confirmation'] = 'Da li ste sigurni da želite da objavite ovaj snimak {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Ovaj snimak ima {$a} povezane/ih veze/a koje su importovane u druge kurseve ili aktivnosti. Ako je snimak objavljen, biće objavljeni i ovi linkovi.';
$string['view_recording_publish_confirmation_warning_s'] = 'Ovaj snimak ima {$a} povezanu vezu koja je importovana u drugi kurs ili aktivnost. Ako je snimak objavljen, biće objavljen i ovaj link.';
$string['view_recording_publish_link_deleted'] = 'Ovaj link ne može biti ponovo objavljen jer originalni snimak ne postoji na BigBlueButton serveru. Link treba ukloniti.';
$string['view_recording_publish_link_not_published'] = 'Ovaj link ne može biti ponovo objavljen jer originalni snimak nije objavljen (tj. dozvola za njegovo objavljivanje je opozvana).';
$string['view_recording_recording'] = 'Snimak';
$string['view_recording_select_course'] = 'Prvo izaberite kurs u padajućem meniju';
$string['view_recording_tags'] = 'Oznake';
$string['view_recording_unprotect_confirmation'] = 'Da li ste sigurni da želite da skinete zaštitu sa ovog snimka {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Ovaj snimak ima {$a} povezana/ih link(ov)a koje su importovani u druge kurseve ili aktivnosti. Ako snimak nije zaštićen, to će uticati i na importovane linkove.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Ovaj snimak ima {$a} povezani link koje je importovan u drugi kurs ili aktivnost. Ako snimak nije zaštićen, to će uticati i na importovane linkove.';
$string['view_recording_unprotect_link_deleted'] = 'Sa ovog linka (snimka) zaštita ne može da se ukloni jer originalni snimak ne postoji na BigBlueButton serveru. Link treba ukloniti.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Sa ovog linka (snimka) zaštita ne može da se ukloni jer je originalni snimak zaštićen.';
$string['view_recording_unpublish_confirmation'] = 'Da li ste sigurni da želite da opozovete objavu ovog snimka {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Ovaj snimak ima {$a} pridružena/ih link(ov)a koji su bili uvezeni u različite kurseve ili aktivnosti. Ako se opozove objava snimka onda će i ti linkovi biti opozvani.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Ovaj snimak ima {$a} pridruženi link koji je bio uvezen u različit kurs ili aktivnost. Ako se opozove objava snimka onda će i taj link biti opozvan.';
$string['view_recording_yui_first'] = 'Prva';
$string['view_recording_yui_go'] = 'Idi';
$string['view_recording_yui_last'] = 'Poslednja';
$string['view_recording_yui_next'] = 'Sledeća';
$string['view_recording_yui_page'] = 'Stranica';
$string['view_recording_yui_prev'] = 'Prethodna';
$string['view_recording_yui_rows'] = 'Redovi';
$string['view_recording_yui_show_all'] = 'Prikaži sve';
$string['view_room'] = 'Prikaži konferencijsku sobu';
$string['view_section_title_presentation'] = 'Datoteka prezentacije';
$string['view_section_title_recordings'] = 'Snimci';
$string['view_warning_default_server'] = 'Ovaj sajt koristi <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">besplatni BigBlueButton servis za Moodle (otvara se u novom prozoru)</a>
koji je obezbedio Blindside Networks, sa sledećim ograničenjima:
<ol>
<li>Maksimalno trajanje svake sesije je 60 minuta</li>
<li>Maksimalan broj istovremenih korisnika po sesiji je 25</li>
<li>Snimci ističu nakon sedam (7) dana i ne mogu se preuzeti</li>
<li>Veb kamere polaznika
 vidljive su samo moderatoru.</li>
</ol>';
$string['waitformoderator'] = 'Čeka se da se moderator pridruži.';
