<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'el', version '3.11'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Αποδοχή';
$string['accept_grades'] = 'Αποδοχή βαθμών από το εργαλείο';
$string['accept_grades_admin'] = 'Αποδοχή βαθμών από το εργαλείο';
$string['accept_grades_admin_help'] = 'Καθορίστε αν ο πάροχος εργαλείου μπορεί να προσθέσει, να ενημερώσει, να διαβάσει και να διαγράψει βαθμούς που σχετίζονται με στιγμιότυπα αυτού του εργαλείου.

Ορισμένοι πάροχοι εργαλείων υποστηρίζουν την αναφορά βαθμολογιών πίσω στο Moodle με βάση τις ενέργειες που έγιναν στο πλαίσιο του εργαλείου, δημιουργώντας μια πιο ολοκληρωμένη
εμπειρία.';
$string['accept_grades_help'] = 'Καθορίστε εάν ο πάροχος του εργαλείου μπορεί να προσθέσει, ενημερώσει, διαβάσει και διαγράψει, βαθμούς που συσχετίζονται μόνο με αυτό το στιγμιότυπο εξωτερικού εργαλείου. Κάποιοι πάροχοι εργαλείων υποστηρίζουν επιστροφές βαθμών πίσω στο Moodle με βάση ενέργειες που έγιναν μέσα στο εργαλείο, δημιουργώντας έτσι μια πιο ολοκληρωμένη εμπειρία. Σημειώστε ότι αυτή η ρύθμιση μπορεί να παρακαμφθεί στις ρυθμίσεις του εργαλείου.';
$string['accepted'] = 'Έγινε αποδοχή';
$string['action'] = 'Ενέργεια';
$string['activate'] = 'Δραστηριοποίηση';
$string['activatetoadddescription'] = 'Θα χρειαστεί να ενεργοποιήσετε αυτό το εργαλείο για να μπορείτε να προσθέσετε μια περιγραφή.';
$string['active'] = 'Ενεργός';
$string['activity'] = 'Δραστηριότητα';
$string['add_ltiadv'] = 'Προσθήκη LTI Advantage';
$string['add_ltilegacy'] = 'Προσθήκη παλαιού τύπου LTI';
$string['addnewapp'] = 'Ενεργοποίηση της εξωτερικής εφαρμογής';
$string['addserver'] = 'Προσθέστε νέο έμπιστο εξυπηρετητή';
$string['addtype'] = 'Προσθήκη προ-ρυθμισμένου εργαλείου';
$string['allow'] = 'Να επιτρέπεται';
$string['allowsetting'] = 'Να επιτρέπεται στο εργαλείο να αποθηκεύει 8Κ για ρυθμίσεις στο Moodle';
$string['always'] = 'Πάντα';
$string['autoaddtype'] = 'Προσθήκη εργαλείου';
$string['automatic'] = 'Αυτόματη, βάσει διεύθυνσης εργαλείου';
$string['baseurl'] = 'Βασική διεύθυνση URL/όνομα καταχώρησης εργαλείου';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'Βασική συμβολοσειρά LTI OAuth';
$string['basiclti_endpoint'] = 'Τελικό σημείο εκκίνησης LTI';
$string['basiclti_in_new_window'] = 'Η δραστηριότητα έχει ανοίξει σε νέο παράθυρο';
$string['basiclti_in_new_window_open'] = 'Άνοιγμα σε νέο παράθυρο';
$string['basiclti_parameters'] = 'Παράμετροι εκκίνησης LTI';
$string['basicltiactivities'] = 'Δραστηριότητες LTI';
$string['basicltifieldset'] = 'Προσαρμοσμένο παράδειγμα σετ πεδίων';
$string['basicltiintro'] = 'Περιγραφή δραστηριότητας';
$string['basicltiname'] = 'Όνομα δραστηριότητας';
$string['basicltisettings'] = 'Βασικές ρυθμίσεις Διαλειτουργικότητας Εργαλείων Μάθησης (LTI)';
$string['cachedef_keyset'] = 'Αποθηκεύει σε κρυφή μνήμη τις πληροφορίες συνόλου κλειδιών των εργαλείων';
$string['cancel'] = 'Άκυρο';
$string['cancelled'] = 'Ακυρώθηκε';
$string['cannot_delete'] = 'Δεν μπορείτε να διαγράψετε αυτές τις ρυθμίσεις εργαλείου.';
$string['cannot_edit'] = 'Δεν μπορείτε να τροποποιήσετε αυτές τις ρυθμίσεις εργαλείου.';
$string['capabilities'] = 'Δυνατότητες';
$string['capabilities_help'] = 'Επιλέξτε τις δυνατότητες που θέλετε να προσφέρετε στον παροχέα εργαλείων. Μπορούν να επιλεγούν περισσότερες από μία δυνατότητες.';
$string['capabilitiesrequired'] = 'Αυτό το εργαλείο απαιτεί πρόσβαση στα ακόλουθα δεδομένα για να δραστηριοποιηθεί:';
$string['cleanaccesstokens'] = 'Εξωτερικό εργαλείο - Αφαίρεση ληγμένων κουπονιών πρόσβασης';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Κάντε κλικ εδώ για συνέχεια</a>';
$string['clientidadmin'] = 'Αναγνωριστικό πελάτη';
$string['clientidadmin_help'] = 'Το αναγνωριστικό πελάτη είναι μια μοναδική τιμή που χρησιμοποιείται για την αναγνώριση ενός εργαλείου.
Δημιουργείται αυτόματα για κάθε εργαλείο που χρησιμοποιεί το προφίλ ασφαλείας JWT που εισήχθη στο LTI 1.3 και πρέπει να είναι μέρος των λεπτομερειών που διαβιβάζονται στον πάροχο του εργαλείου ώστε να μπορεί να ρυθμίζει τη σύνδεση από την πλευρά του.';
$string['comment'] = 'Σχόλιο';
$string['configpassword'] = 'Προεπιλεγμένος κωδικός πρόσβασης για το απομακρυσμένο εργαλείο';
$string['configpreferheight'] = 'Προεπιλεγμένο προτιμώμενο ύψος';
$string['configpreferwidget'] = 'Ορίστε το γραφικό στοιχείο ως προεπιλεγμένη εκκίνηση';
$string['configpreferwidth'] = 'Προεπιλεγμένο προτιμώμενο πλάτος';
$string['configresourceurl'] = 'Προεπιλεγμένη διεύθυνση URL πόρων';
$string['configtoolurl'] = 'Προεπιλεγμένη διεύθυνση URL απομακρυσμένου εργαλείου';
$string['configtypes'] = 'Ενεργοποίηση εφαρμογών LTI';
$string['configured'] = 'Διαμορφώθηκε';
$string['confirmtoolactivation'] = 'Είστε βέβαιοι ότι θέλετε να ενεργοποιήσετε αυτό το εργαλείο;';
$string['contentitem'] = 'Μήνυμα περιεχομένου-στοιχείου';
$string['contentitem_deeplinking'] = 'Υποστηρίζει βαθιά σύνδεση (μήνυμα στοιχείου περιεχομένου)';
$string['contentitem_deeplinking_help'] = 'Αν επιλεγεί, η ενέργεια «Επιλογή περιεχομένου» θα είναι διαθέσιμη κατά την προσθήκη ενός εξωτερικού εργαλείου.';
$string['contentitem_help'] = 'Αν επιλεγεί, η ενέργεια «Επιλογή περιεχομένου» θα είναι διαθέσιμη κατά την προσθήκη ενός εξωτερικού εργαλείου.';
$string['contentitem_multiple_description'] = 'Τα ακόλουθα στοιχεία θα προστεθούν στο μάθημά σας:';
$string['contentitem_multiple_graded'] = 'Βαθμολογημένη δραστηριότητα (Μέγιστος βαθμός: {$a})';
$string['course_tool_types'] = 'Εργαλεία μαθήματος';
$string['courseactivitiesorresources'] = 'Δραστηριότητες ή πόροι μαθήματος';
$string['courseid'] = 'Αναγνωριστικός αριθμός μαθήματος';
$string['courseinformation'] = 'Πληροφορίες μαθήματος';
$string['courselink'] = 'Μετάβαση στο μάθημα';
$string['coursemisconf'] = 'Το μάθημα έχει μη έγκυρες ρυθμίσεις';
$string['createdon'] = 'Δημιουργία στις';
$string['curllibrarymissing'] = 'Για το Εξωτερικό εργαλείο απαιτείται η επέκταση PHP cURL.';
$string['custom'] = 'Προσαρμοσμένες παράμετροι';
$string['custom_config'] = 'Χρήση προσαρμοσμένων ρυθμίσεων εργαλείου.';
$string['custom_help'] = 'Οι προσαρμοσμένες παράμετροι είναι οι ρυθμίσεις που χρησιμοποιούνται από τον πάροχο εργαλείων. Για παράδειγμα, μπορεί να χρησιμοποιηθεί μια προσαρμοσμένη παράμετρος για την εμφάνιση ενός συγκεκριμένου πόρου από τον πάροχο. Κάθε παράμετρος πρέπει να εισαχθεί σε ξεχωριστή γραμμή με τον μορφότυπο «name = value». για παράδειγμα, «chapter=3».

Είναι ασφαλές να αφήσετε αυτό το πεδίο αμετάβλητο, εκτός εάν σας καθοδηγεί ο πάροχος εργαλείων.';
$string['custominstr'] = 'Προσαρμοσμένες παράμετροι';
$string['debuglaunch'] = 'Επιλογές αποσφαλμάτωσης';
$string['debuglaunchoff'] = 'Κανονική εκκίνηση';
$string['debuglaunchon'] = 'Εκκίνηση αποσφαλμάτωσης';
$string['default'] = 'Προεπιλογή';
$string['default_launch_container'] = 'Προεπιλεγμένος περιέκτης εκκίνησης';
$string['default_launch_container_help'] = 'Ο περιέκτης εκκίνησης επηρεάζει την εμφάνιση του εργαλείου όταν εκκινείται από το μάθημα. Ορισμένοι περιέκτες εκκίνησης παρέχουν μεγαλύτερη έκταση στην οθόνη στο εργαλείο και άλλα παρέχουν μια πιο ολοκληρωμένη αίσθηση με το περιβάλλον Moodle.

* ** Προεπιλογή ** - Χρησιμοποιήστε τον περιέκτη εκκίνησης που καθορίζεται στις ρυθμίσεις εργαλείου.
* ** Ενσωμάτωση ** - Το εργαλείο εμφανίζεται στο υπάρχον παράθυρο Moodle, με τρόπο παρόμοιο με τους περισσότερους άλλους τύπους δραστηριοτήτων.
* ** Ενσωμάτωση, χωρίς μπλοκ ** - Το εργαλείο εμφανίζεται στο υπάρχον παράθυρο Moodle, μόνο με τα πλήκτρα πλοήγησης στο επάνω μέρος της σελίδας.
* ** Νέο παράθυρο ** - Το εργαλείο ανοίγει σε νέο παράθυρο, καταλαμβάνοντας όλο το διαθέσιμο χώρο. Ανάλογα με τον περιηγητή, θα ανοίξει σε μια νέα καρτέλα ή ένα αναδυόμενο παράθυρο. Είναι πιθανό ότι οι περιηγητές θα εμποδίσουν το άνοιγμα του νέου παραθύρου.';
$string['delegate'] = 'Εκπροσώπηση προς διδάσκοντα';
$string['delegate_tool'] = 'Όπως καθορίζεται στον ορισμό της Βαθιάς Σύνδεσης ή Απεσταλμένος σε δάσκαλο';
$string['delete'] = 'Διαγραφή';
$string['delete_confirmation'] = 'Θέλετε σίγουρα να διαγράψετε αυτό το προ-ρυθμισμένο εργαλείο;';
$string['deletetype'] = 'Διαγραφή προ-ρυθμισμένου εργαλείου';
$string['display_description'] = 'Εμφάνιση περιγραφής δραστηριότητας κατά την έναρξη';
$string['display_description_help'] = 'Εάν επιλεγεί, η περιγραφή δραστηριότητας (που καθορίζεται παραπάνω) θα εμφανιστεί πάνω από το περιεχόμενο του παρόχου εργαλείων.

Η περιγραφή μπορεί να χρησιμοποιηθεί για την παροχή επιπρόσθετων οδηγιών για όσους ξεκινούν το εργαλείο, αλλά δεν απαιτείται.

Η περιγραφή δεν εμφανίζεται ποτέ όταν ο περιέκτης εκκίνησης του εργαλείου βρίσκεται σε νέο παράθυρο.';
$string['display_name'] = 'Εμφάνιση του ονόματος δραστηριότητας κατά την εκκίνηση';
$string['display_name_help'] = 'Εάν επιλεγεί, το όνομα δραστηριότητας (που καθορίζεται παραπάνω) θα εμφανιστεί πάνω από το περιεχόμενο του παρόχου εργαλείων. Είναι πιθανό ο πάροχος εργαλείου να μπορεί επίσης να εμφανίσει τον τίτλο. Αυτή η επιλογή μπορεί να εμποδίσει την προβολή δύο φορές του τίτλου δραστηριότητας. Ο τίτλος δεν εμφανίζεται ποτέ όταν ο περιέκτης εκκίνησης του εργαλείου βρίσκεται σε νέο παράθυρο.';
$string['domain_mismatch'] = 'Ο τομέας της διεύθυνσης URL του εργαλείου δεν αντιστοιχεί στις ρυθμίσεις του εργαλείου.';
$string['donot'] = 'Να μην αποστέλλονται';
$string['donotaccept'] = 'Μη αποδεκτό';
$string['donotallow'] = 'Μη επιτρεπτό';
$string['duplicateregurl'] = 'Αυτή η διεύθυνση URL καταχώρησης είναι ήδη σε χρήση';
$string['dynreg_update_btn_new'] = 'Καταχώρηση ως νέο εξωτερικό εργαλείο';
$string['dynreg_update_btn_update'] = 'Ενημέρωση';
$string['dynreg_update_name'] = 'Όνομα εργαλείου';
$string['dynreg_update_notools'] = 'Δεν υπάρχουν εργαλεία στο πλαίσιο.';
$string['dynreg_update_text'] = 'Υπάρχουν ήδη εργαλεία συνδεδεμένα στον τομέα της εγγραφής. Θέλετε να ενημερώσετε ένα ήδη εγκατεστημένο εξωτερικό εργαλείο ή να δημιουργήσετε ένα νέο εξωτερικό εργαλείο;';
$string['dynreg_update_url'] = 'Βασική διεύθυνση URL';
$string['dynreg_update_version'] = 'Έκδοση LTI';
$string['dynreg_update_warn_dupdomain'] = 'Δεν συνιστάται η ύπαρξη πολλαπλών εξωτερικών εργαλείων στον ίδιο τομέα.';
$string['editdescription'] = 'Κάντε κλικ εδώ για να δώσετε σε αυτό το εργαλείο μια περιγραφή';
$string['edittype'] = 'Επεξεργασία προ-ρυθμισμένου εργαλείου';
$string['embed'] = 'Ένθεση';
$string['embed_no_blocks'] = 'Ένθεση, χωρίς μπλοκ';
$string['enableemailnotification'] = 'Αποστολή ειδοποιήσεων μέσω μηνυμάτων ηλε.ταχυδρομείου';
$string['enableemailnotification_help'] = 'Αν ενεργοποιηθεί, οι μαθητές θα λαμβάνουν ειδοποίηση μέσω ηλε.ταχυδρομείου όταν βαθμολογούνται οι υποβολές εργαλείων τους.';
$string['enterkeyandsecret'] = 'Εισαγάγετε το κλειδί καταναλωτή και το κοινόχρηστο μυστικό';
$string['enterkeyandsecret_help'] = 'Αν σας δόθηκε ένα κλειδί καταναλωτή και/ή ένα κοινόχρηστο μυστικό, εισάγετέ τα εδώ';
$string['errorbadurl'] = 'Η διεύθυνση URL δεν είναι έγκυρη διεύθυνση URL εργαλείου ή πακέτου μάθησης.';
$string['errorincorrectconsumerkey'] = 'Το κλειδί του καταναλωτή είναι εσφαλμένο.';
$string['errorinvaliddata'] = 'Μη έγκυρα δεδομένα: {$a}';
$string['errorinvalidmediatype'] = 'Μη έγκυρος τύπος πολυμέσου: {$a}';
$string['errorinvalidresponseformat'] = 'Μη έγκυρος μορφότυπος απόκρισης περιεχομένου-στοιχείου.';
$string['errormisconfig'] = 'Το εργαλείο έχει σφάλματα στις ρυθμίσεις. Παρακαλούμε, ζητήστε από τον διαχειριστή του Moodle σας να διορθώσει τις ρυθμίσεις του εργαλείου.';
$string['errortooltypenotfound'] = 'Ο τύπος εργαλείου LTI δεν βρέθηκε.';
$string['existing_window'] = 'Υπάρχον παράθυρο';
$string['extensions'] = 'Υπηρεσίες επέκτασης LTI';
$string['external_tool_type'] = 'Προ-ρυθμισμένο εργαλείο';
$string['external_tool_type_help'] = '* ** Αυτόματη, βάσει διεύθυνσης εργαλείου ** - Η καλύτερη διαμόρφωση εργαλείου επιλέγεται αυτόματα. Εάν δεν αναγνωρίζεται η διεύθυνση URL του εργαλείου, ενδέχεται να χρειαστεί να εισαχθούν με μη αυτόματο τρόπο οι λεπτομέρειες ρυθμίσεων εργαλείου.
* ** Ένα συγκεκριμένο προ-ρυθμισμένο εργαλείο ** - Οι ρυθμίσεις εργαλείου για το συγκεκριμένο εργαλείο θα χρησιμοποιηθούν κατά την επικοινωνία με τον εξωτερικό πάροχο εργαλείων. Εάν η διεύθυνση URL του εργαλείου δεν φαίνεται να ανήκει στον πάροχο εργαλείων, θα εμφανιστεί μια προειδοποίηση. Δεν είναι πάντα απαραίτητο να εισαγάγετε μια διεύθυνση URL εργαλείου.
* ** Προσαρμοσμένες ρυθμίσεις ** - Ένα κλειδί καταναλωτή και ένα κοινόχρηστο μυστικό ίσως χρειαστεί να εισαχθούν χειροκίνητα. Το κλειδί του καταναλωτή και το κοινόχρηστο μυστικό μπορούν να ληφθούν από τον πάροχο εργαλείων. Ωστόσο, δεν χρειάζονται όλα τα εργαλεία κλειδί καταναλωτή και κοινόχρηστο μυστικό, οπότε τα πεδία ενδέχεται να παραμείνουν κενά.

### Προ-ρυθμισμένη επεξεργασία εργαλείων.

Τρία εικονίδια είναι διαθέσιμα μετά το πτυσσόμενο μενού προεπιλεγμένων εργαλείων:

* ** Προσθήκη ** - Δημιουργία ρυθμίσεων εργαλείου επιπέδου μαθήματος. Όλα τα στιγμιότυπα εξωτερικών εργαλείων σε αυτό το μάθημα μπορεί να χρησιμοποιούν τις ρυθμίσεις του εργαλείου.
* ** Επεξεργασία ** - Επιλέξτε ένα εργαλείο επιπέδου μαθήματος από το πτυσσόμενο μενού και, στη συνέχεια, κάντε κλικ σε αυτό το εικονίδιο. Οι λεπτομέρειες των ρυθμίσεων του εργαλείου μπορούν να τροποποιηθούν.
* ** Διαγραφή ** - Αφαιρέστε το επιλεγμένο εργαλείο επιπέδου μαθήματος.';
$string['external_tool_types'] = 'Προ-ρυθμισμένα εργαλεία';
$string['failedtoconnect'] = 'Το Moodle δεν μπόρεσε να επικοινωνήσει με το σύστημα «{$a}»';
$string['failedtocreatetooltype'] = 'Αποτυχία δημιουργίας νέου εργαλείου. Παρακαλούμε, ελέγξτε τη διεύθυνση URL και δοκιμάστε ξανά.';
$string['failedtodeletetoolproxy'] = 'Αποτυχία διαγραφής καταχώρησης εργαλείου. Ίσως πρέπει να επισκεφτείτε τη «Διαχείριση καταχωρήσεων εξωτερικών εργαλείων» και να τη σβήσετε χειροκίνητα.';
$string['filter_basiclti_configlink'] = 'Διαμορφώστε τους προτιμώμενους ιστοτόπους και τους κωδικούς πρόσβασής τους';
$string['filter_basiclti_password'] = 'Ο κωδικός πρόσβασης είναι υποχρεωτικός';
$string['filterconfig'] = 'Διαχείριση LTI';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Χρησιμοποιήστε ένα υπάρχον σετ ρυθμίσεων για το μη ορθά ρυθμισμένο στιγμιότυπο';
$string['fixnew'] = 'Νέο σετ ρυθμίσεων';
$string['fixnewconf'] = 'Ορίστε ένα υπάρχον σετ ρυθμίσεων για το μη ορθά ρυθμισμένο στιγμιότυπο';
$string['fixold'] = 'Χρήση υπαρκτού';
$string['force_ssl'] = 'Το SSL να είναι υποχρεωτικό';
$string['force_ssl_help'] = 'Η ενεργοποίηση αυτής της επιλογής υποχρεώνει όλες τις εκκινήσεις σε αυτόν τον πάροχο εργαλείων να χρησιμοποιούν SSL. Επιπλέον, όλα τα αιτήματα υπηρεσίας ιστού από τον πάροχο εργαλείων θα χρησιμοποιούν SSL. Εάν χρησιμοποιείτε αυτήν την επιλογή, επιβεβαιώστε ότι αυτός ο ιστότοπος Moodle και ο πάροχος εργαλείων υποστηρίζουν SSL.';
$string['forced_help'] = 'Αυτή η ρύθμιση έχει επιβληθεί στις ρυθμίσεις κάποιου εργαλείου ή σε επίπεδο ιστοτόπου. Δεν μπορείτε να την αλλάξετε από αυτήν τη διεπαφή.';
$string['generaltool'] = 'Γενικό εργαλείο';
$string['global_tool_types'] = 'Προρυθμισμένα εργαλεία';
$string['grading'] = 'Δρομολόγηση βαθμών';
$string['icon_url'] = 'Διεύθυνση URL εικονιδίου';
$string['icon_url_help'] = 'Η διεύθυνση URL εικονιδίου επιτρέπει την τροποποίηση του εικονιδίου που εμφανίζεται στην λίστα μαθήματος για αυτήν τη δραστηριότητα. Αντί να χρησιμοποιήσετε το προεπιλεγμένο εικονίδιο LTI, μπορεί να οριστεί ένα εικονίδιο που εκφράζει τον τύπο της δραστηριότητας.';
$string['id'] = 'Αναγνωριστικό';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης Εξωτερικού εργαλείου (LTI)';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Εξωτερικού εργαλείου (LTI).';
$string['indicator:cognitivedepthdef'] = 'Βάθος κατανόησης Εξωτερικού εργαλείου (LTI)';
$string['indicator:cognitivedepthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο βάθος κατανόησης που προσφέρεται από τις δραστηριότητες LTI κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία εμφάνιση, Εμφάνιση, Υποβολή, Εμφάνιση ανατροφοδότησης)';
$string['indicator:cognitivedepthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Βάθος_κατανόησης';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος Εξωτερικού εργαλείου (LTI)';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Εξωτερικού εργαλείου (LTI).';
$string['indicator:socialbreadthdef'] = 'Κοινωνικό εύρος Εξωτερικού εργαλείου (LTI)';
$string['indicator:socialbreadthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο κοινωνικό εύρος που προσφέρεται από τις δραστηριότητες LTI κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία συμμετοχή, Συμμετέχων μόνος, Συμμετέχων με άλλους)';
$string['indicator:socialbreadthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Κοινωνικό_εύρος';
$string['initiatelogin'] = 'Διεύθυνση URL έναρξης σύνδεσης';
$string['initiatelogin_help'] = 'Η διεύθυνση URL εργαλείου στην οποία πρέπει να σταλούν οι αιτήσεις για την έναρξη της σύνδεσης. Αυτή η διεύθυνση απαιτείται πριν από την επιτυχημένη αποστολή ενός μηνύματος στο εργαλείο.';
$string['invalidid'] = 'Το αναγνωριστικό LTI ήταν εσφαλμένο';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Τύπος δημόσιου κλειδιού';
$string['keytype_help'] = 'Η μέθοδος αυθεντικοποίησης που χρησιμοποιείται για επικύρωση του εργαλείου.';
$string['keytype_keyset'] = 'Διεύθυνση URL του Keyset';
$string['keytype_rsa'] = 'Κλειδί RSA';
$string['launch_in_moodle'] = 'Εκκινήστε το εργαλείο στο Moodle';
$string['launch_in_popup'] = 'Εκκινήστε το εργαλείο σε ένα αναδυόμενο παράθυρο';
$string['launch_url'] = 'Διεύθυνση URL εργαλείου';
$string['launch_url_help'] = 'Η διεύθυνση URL του εργαλείου υποδεικνύει τη διεύθυνση ιστού του εξωτερικού εργαλείου και μπορεί να περιέχει επιπρόσθετες πληροφορίες, όπως τον πόρο που θα προβληθεί.
Εάν δεν είστε σίγουροι για το τι πρέπει να εισαγάγετε στη διεύθυνση URL του εργαλείου, επικοινωνήστε με τον πάροχο του εργαλείου για περισσότερες πληροφορίες.

Μπορείτε να εισάγετε μια διεύθυνση URL πακέτου μάθησης εάν έχετε ένα και τα υπόλοιπα στοιχεία της φόρμας θα συμπληρώνονται αυτόματα.

Αν έχετε επιλέξει ένα προδιαμορφωμένο εργαλείο, ενδέχεται να μην χρειαστεί να δώσετε μια διεύθυνση URL εργαλείου. Αν ο σύνδεσμος εργαλείου χρησιμοποιείται μόνο για την εκκίνηση στο σύστημα του παρόχου εργαλείου και δεν οδηγεί σε έναν συγκεκριμένο πόρο, πιθανόν να συμβαίνει αυτό (και να μην χρειαστεί).';
$string['launchinpopup'] = 'Περιέκτης εκκίνησης';
$string['launchinpopup_help'] = 'Ο περιέκτης εκκίνησης επηρεάζει την εμφάνιση του εργαλείου όταν εκκινείται από το μάθημα. Ορισμένοι περιέκτες εκκίνησης παρέχουν μεγαλύτερη έκταση στην οθόνη στο εργαλείο και άλλα παρέχουν μια πιο ολοκληρωμένη αίσθηση με το περιβάλλον Moodle.

* ** Προεπιλογή ** - Χρησιμοποιήστε τον περιέκτη εκκίνησης που καθορίζεται στις ρυθμίσεις εργαλείου.
* ** Ενσωμάτωση ** - Το εργαλείο εμφανίζεται στο υπάρχον παράθυρο Moodle, με τρόπο παρόμοιο με τους περισσότερους άλλους τύπους δραστηριοτήτων.
* ** Ενσωμάτωση, χωρίς μπλοκ ** - Το εργαλείο εμφανίζεται στο υπάρχον παράθυρο Moodle, με τα πλήκτρα πλοήγησης στο επάνω μέρος της σελίδας.
* ** Νέο παράθυρο ** - Το εργαλείο ανοίγει σε νέο παράθυρο, καταλαμβάνοντας όλο το διαθέσιμο χώρο. Ανάλογα με τον περιηγητή, θα ανοίξει σε μια νέα καρτέλα ή ένα αναδυόμενο παράθυρο. Είναι πιθανό ότι οι περιηγητές θα εμποδίσουν το άνοιγμα του νέου παραθύρου.';
$string['launchoptions'] = 'Επιλογές εκκίνησης';
$string['leaveblank'] = 'Αφήστε κενό, εάν δεν χρειάζονται';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Προσθήκη σετ ρυθμίσεων εργαλείου ειδικά για κάποιο μάθημα';
$string['lti:addinstance'] = 'Προσθήκη νέου εξωτερικού εργαλείου';
$string['lti:addmanualinstance'] = 'Προσθήκη ενός χειροκίνητα-ρυθμισμένου εργαλείου';
$string['lti:addpreconfiguredinstance'] = 'Προσθήκη ενός προρυθμισμένου εργαλείου';
$string['lti:admin'] = 'Να είστε διαχειριστής όταν γίνεται η εκκίνηση του εργαλείου';
$string['lti:grade'] = 'Εμφάνιση βαθμών που επιστρέφονται από το εξωτερικό εργαλείο';
$string['lti:manage'] = 'Να είστε εκπαιδευτής όταν γίνεται η εκκίνηση του εργαλείου';
$string['lti:requesttooladd'] = 'Αίτημα για ρύθμιση ενός εργαλείου σε επίπεδο ιστοτόπου';
$string['lti:view'] = 'Εκκίνηση δραστηριοτήτων εξωτερικού εργαλείου';
$string['lti_administration'] = 'Επεξεργασία προ-ρυθμισμένου εργαλείου';
$string['lti_errormsg'] = 'Το εργαλείο επέστρεψε το ακόλουθο μήνυμα λάθους: «{$a}»';
$string['lti_launch_error'] = 'Ένα σφάλμα παρουσιάστηκε κατά την εκκίνηση του εξωτερικού εργαλείου:';
$string['lti_launch_error_tool_request'] = '<p>Για να υποβάλετε αίτημα για να ολοκληρώσει ένας διαχειριστής τις ρυθμίσεις εργαλείου, κάντε κλικ <a href="{$a->admin_request_url}" target="_top">εδώ</a>.</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Αυτό το σφάλμα μπορεί να είναι το αποτέλεσμα έλλειψης κλειδιού καταναλωτή και κοινόχρηστου μυστικού για τον πάροχο εργαλείων.</p>
<p>Εάν έχετε ένα κλειδί για τον καταναλωτή και κοινόχρηστο μυστικό, μπορείτε να το εισαγάγετε κατά την επεξεργασία του εξωτερικού στιγμιότυπου εργαλείου (βεβαιωθείτε ότι οι προχωρημένες επιλογές είναι ορατές).</p>
<p>Εναλλακτικά, μπορείτε να <a href="{$a->course_tool_editor}">δημιουργήσετε ένα σετ ρυθμίσεων παρόχου εργαλείου επιπέδου μαθήματος</a>.</p>';
$string['lti_tool_request_added'] = 'Η αίτηση ρυθμίσεων εργαλείου υποβλήθηκε με επιτυχία. Ίσως χρειαστεί να επικοινωνήσετε με έναν διαχειριστή για να ολοκληρώσετε τις ρυθμίσεις του εργαλείου.';
$string['lti_tool_request_existing'] = 'Έχει ήδη υποβληθεί ένα σετ ρυθμίσεων εργαλείου για τον τομέα του εργαλείου.';
$string['ltisettings'] = 'Ρυθμίσεις LTI';
$string['ltiunknownserviceapicall'] = 'Άγνωστη κλήση API υπηρεσίας LTI.';
$string['ltiversion'] = 'Έκδοση LTI';
$string['ltiversion_help'] = 'Η έκδοση του LTI προς χρήση για την υπογραφή μηνυμάτων και αιτημάτων για υπηρεσίες: Το LTI 1.0/1.1 και το LTI 2.0 χρησιμοποιούν το προφίλ ασφαλείας OAuth 1.0A. Το LTI 1.3.0 χρησιμοποιεί JWTs.';
$string['main_admin'] = 'Γενική βοήθεια';
$string['main_admin_help'] = 'Τα εξωτερικά εργαλεία επιτρέπουν στους χρήστες του Moodle να αλληλεπιδρούν με μαθησιακούς πόρους που φιλοξενούνται σε άλλο κεντρικό Η/Υ. Μέσω ενός ειδικού πρωτοκόλλου εκκίνησης, το απομακρυσμένο εργαλείο έχει πρόσβαση σε γενικές πληροφορίες σχετικά με τον χρήστη που ζητά την εκκίνηση. Για παράδειγμα, το όνομα του ιδρύματος, το αναγνωριστικό μαθήματος, το αναγνωριστικό χρήστη και άλλες πληροφορίες, όπως το όνομα χρήστη ή η διεύθυνση ηλε.ταχυδρομείου.

Τα εργαλεία που παρατίθενται σε αυτήν τη σελίδα χωρίζονται σε τρεις κατηγορίες:

* ** Ενεργά ** - Οι πάροχοι αυτών των εργαλείων έχουν εγκριθεί και έγιναν οι ρυθμίσεις από έναν διαχειριστή. Μπορούν να χρησιμοποιηθούν από οποιοδήποτε μάθημα σε αυτόν τον ιστότοπο. Εάν εισαχθούν ένα κλειδί καταναλωτή και ένα κοινόχρηστο μυστικό, δημιουργείται μια σχέση εμπιστοσύνης μεταξύ αυτού του ιστοτόπου και του απομακρυσμένου εργαλείου, παρέχοντας ένα ασφαλές κανάλι επικοινωνίας.
* ** Σε εκκρεμότητα ** - Οι πάροχοι αυτών των εργαλείων έγιναν διαθέσιμοι κατά την εισαγωγή/εγκατάσταση ενός πακέτου, αλλά δεν έγιναν ρυθμίσεις από έναν διαχειριστή. Οι διδάσκοντες μπορούν ακόμη να χρησιμοποιούν εργαλεία από αυτούς τους παρόχους, εάν διαθέτουν κλειδί καταναλωτή και κοινόχρηστο μυστικό ή εάν δεν απαιτούνται καθόλου.
* ** Απορρίφθηκαν ** - Οι πάροχοι αυτών των εργαλείων σημαιοδοτήθηκαν έτσι διότι δεν υπάρχει πρόθεση από έναν διαχειριστή να τεθούν στη διάθεση του ιστοτόπου. Οι διδάσκοντες μπορούν ακόμη να χρησιμοποιούν εργαλεία από αυτούς τους παρόχους, εάν διαθέτουν κλειδί καταναλωτή και κοινόχρηστο μυστικό ή εάν δεν απαιτούνται καθόλου.';
$string['manage_external_tools'] = 'Διαχείριση εργαλείων';
$string['manage_tool_proxies'] = 'Διαχείριση καταχωρήσεων εξωτερικών εργαλείων';
$string['manage_tools'] = 'Διαχείριση προ-ρυθμισμένων εργαλείων';
$string['manuallyaddtype'] = 'Εναλλακτικά, μπορείτε <a href="{$a}">να διαμορφώσετε ένα εργαλείο με μη αυτόματο τρόπο</a>.';
$string['miscellaneous'] = 'Διάφορα';
$string['misconfiguredtools'] = 'Εντοπίστηκαν μη ορθά ρυθμισμένα στιγμιότυπα εργαλείων';
$string['missingparameterserror'] = 'Η σελίδα είναι μη ορθά ρυθμισμένη: «{$a}»';
$string['module_class_type'] = 'Τύπος αρθρώματος Moodle';
$string['modulename'] = 'Εξωτερικό εργαλείο';
$string['modulename_help'] = 'Το άρθρωμα δραστηριότητας εξωτερικού εργαλείου επιτρέπει στους μαθητές να αλληλεπιδρούν με τους μαθησιακούς πόρους και τις δραστηριότητες σε άλλους δικτυακούς τόπους. Για παράδειγμα, ένα εξωτερικό εργαλείο θα μπορούσε να προσφέρει πρόσβαση σε έναν νέο τύπο δραστηριότητας ή μαθησιακό υλικό από έναν εκδότη. Για να δημιουργήσετε μια δραστηριότητα εξωτερικού εργαλείου, απαιτείται πάροχος εργαλείων που να υποστηρίζει το πρότυπο LTI [Learning Tools Interoperability: Διαλειτουργικότητα Μαθησιακών Εργαλείων (λογισμικό τρίτων κατασκευαστών)]. Ο διδάσκων μπορεί να δημιουργήσει μια δραστηριότητα εξωτερικού εργαλείου ή να χρησιμοποιήσει ένα εργαλείο διαμορφωμένο από τον διαχειριστή του ιστοτόπου. Οι δραστηριότητες εξωτερικού εργαλείου διαφέρουν από τους πόρους URL με διάφορους τρόπους:

* Τα εξωτερικά εργαλεία αναγνωρίζουν το πλαίσιό τους, δηλαδή έχουν πρόσβαση σε πληροφορίες σχετικά με το χρήστη που ξεκίνησε το εργαλείο, όπως το ίδρυμα, το μάθημα και το όνομα του χρήστη.
* Τα εξωτερικά εργαλεία υποστηρίζουν την ανάγνωση, την ενημέρωση και τη διαγραφή βαθμών που σχετίζονται με το στιγμιότυπο δραστηριότητας.
* Οι ρυθμίσεις εξωτερικού εργαλείου δημιουργούν μια σχέση εμπιστοσύνης μεταξύ του ιστοτόπου σας και του παρόχου εργαλείων, επιτρέποντας ασφαλή επικοινωνία μεταξύ τους.';
$string['modulename_link'] = 'άρθρωμα/lti/εμφάνιση';
$string['modulename_shortcut_link'] = 'άρθρωμα/lti/εμφάνιση/προσαρμογή';
$string['modulenameplural'] = 'Εξωτερικά εργαλεία';
$string['modulenamepluralformatted'] = 'Στιγμιότυπα LTI';
$string['name'] = 'Όνομα';
$string['never'] = 'Ποτέ';
$string['new_window'] = 'Νέο παράθυρο';
$string['no_lti_configured'] = 'Δεν υπάρχουν ενεργά διαμορφωμένα εξωτερικά εργαλεία.';
$string['no_lti_pending'] = 'Δεν υπάρχουν εκκρεμή εξωτερικά εργαλεία.';
$string['no_lti_rejected'] = 'Δεν υπάρχουν εξωτερικά εργαλεία που να απορρίφθηκαν.';
$string['no_lti_tools'] = 'Δεν υπάρχουν διαμορφωμένα εξωτερικά εργαλεία.';
$string['no_tp_accepted'] = 'Δεν υπάρχουν αποδεκτές καταχωρήσεις εξωτερικών εργαλείων.';
$string['no_tp_cancelled'] = 'Δεν υπάρχουν ακυρωμένες καταχωρήσεις εξωτερικών εργαλείων.';
$string['no_tp_configured'] = 'Δεν υπάρχουν μη καταχωρημένες διαμορφωμένες καταχωρήσεις εξωτερικών εργαλείων.';
$string['no_tp_pending'] = 'Δεν υπάρχουν εκκρεμείς καταχωρήσεις εξωτερικών εργαλείων.';
$string['no_tp_rejected'] = 'Δεν υπάρχουν καταχωρήσεις εξωτερικών εργαλείων που να απορρίφθηκαν.';
$string['noattempts'] = 'Δεν έχουν γίνει προσπάθειες σε αυτό το στιγμιότυπο εργαλείου';
$string['noltis'] = 'Δεν υπάρχουν στιγμιότυπα εξωτερικών εργαλείων';
$string['noprofileservice'] = 'Δεν βρέθηκε υπηρεσία προφίλ';
$string['noservers'] = 'Δεν βρέθηκαν εξυπηρετητές';
$string['notypes'] = 'Αυτήν τη στιγμή, δεν υπάρχουν εργαλεία LTI που να έχουν εγκατασταθεί στο Moodle. Κάντε κλικ στο σύνδεσμο Εγκατάσταση παραπάνω για να προσθέσετε μερικά.';
$string['noviewusers'] = 'Δεν βρέθηκαν χρήστες με δικαιώματα χρήσης αυτού του εργαλείου';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'Το LTI 1.3 απαιτεί ένα έγκυρο αρχείο openssl.cnf να είναι διαμορφωμένο και διαθέσιμο στον εξυπηρετητή ιστού σας. Επικοινωνήστε με τον διαχειριστή του ιστοτόπου για να διαμορφώσετε και να ενεργοποιήσετε το openssl για αυτόν τον ιστότοπο.';
$string['optionalsettings'] = 'Προαιρετικές ρυθμίσεις';
$string['organization'] = 'Λεπτομέρειες οργανισμού';
$string['organizationdescr'] = 'Περιγραφή  οργανισμού';
$string['organizationid'] = 'Αναγνωριστικό  οργανισμού';
$string['organizationid_default'] = 'Προεπιλεγμένο αναγνωριστικό οργανισμού';
$string['organizationid_default_help'] = 'Η προεπιλεγμένη τιμή προς χρήση για αναγνωριστικό οργανισμού. Το αναγνωριστικό ιστοτόπου προσδιορίζει αυτή την εγκατάσταση του Moodle.';
$string['organizationid_help'] = 'Ένα μοναδικό αναγνωριστικό για αυτό το στιγμιότυπο Moodle. Τυπικά, χρησιμοποιείται το όνομα DNS του οργανισμού.

Αν αυτό το πεδίο αφεθεί κενό, το όνομα κεντρικού Η/Υ αυτού του ιστοτόπου Moodle θα χρησιμοποιηθεί ως η προεπιλεγμένη τιμή.';
$string['organizationidguid'] = 'Αναγνωριστικό οργανισμού';
$string['organizationidguid_help'] = 'Ένα μοναδικό αναγνωριστικό για αυτό το στιγμιότυπο Moodle που μεταβιβάζεται στο εργαλείο ως GUID στιγμιότυπου πλατφόρμας.

Εάν αυτό το πεδίο αφεθεί κενό, θα χρησιμοποιηθεί η προεπιλεγμένη τιμή.';
$string['organizationurl'] = 'Διεύθυνση URL  οργανισμού';
$string['organizationurl_help'] = 'Η βασική διεύθυνση URL αυτού του στιγμιότυπου του Moodle. Αν το πεδίο παραμείνει κενό, θα χρησιμοποιηθεί μια προεπιλεγμένη τιμή βάσει των ρυθμίσεων του ιστοτόπου.';
$string['pagesize'] = 'Υποβολές που εμφανίζονται ανά σελίδα';
$string['parameter'] = 'Παράμετροι εργαλείου';
$string['parameter_help'] = 'Οι παράμετροι εργαλείων είναι οι ρυθμίσεις που ζητούνται για να περάσουν από τον πάροχο εργαλείων στον αποδεκτό διακομιστή μεσολάβησης εργαλείου.';
$string['password'] = 'Κοινόχρηστο μυστικό';
$string['password_admin'] = 'Κοινόχρηστο μυστικό';
$string['password_admin_help'] = 'Το κοινόχρηστο μυστικό μπορεί να θεωρηθεί ως ένας κωδικός πρόσβασης που χρησιμοποιείται για την αυθεντικοποίηση της πρόσβασης στο εργαλείο. Πρέπει να παρέχεται μαζί με το κλειδί του καταναλωτή από τον πάροχο του εργαλείου.

Τα εργαλεία που δεν απαιτούν ασφαλή επικοινωνία από το Moodle και δεν παρέχουν επιπρόσθετες υπηρεσίες (όπως η αναφορά βαθμών) ενδέχεται να μην απαιτούν κοινόχρηστο μυστικό.';
$string['password_help'] = 'Για τα προεπιλεγμένα εργαλεία, δεν είναι απαραίτητο να εισαγάγετε ένα κοινόχρηστο μυστικό εδώ, καθώς το κοινόχρηστο μυστικό θα παρέχεται ως μέρος της διαδικασίας ρυθμίσεων.

Αυτό το πεδίο θα πρέπει να εισαχθεί αν δημιουργήσετε μια σύνδεση με έναν πάροχο εργαλείων ο οποίος δεν έχει ήδη ρυθμιστεί.
Αν ο πάροχος εργαλείων πρόκειται να χρησιμοποιηθεί περισσότερες από μία φορές σε αυτό το μάθημα, η προσθήκη μιας διαμόρφωσης εργαλείου μαθήματος είναι μια καλή ιδέα.

Το κοινόχρηστο μυστικό μπορεί να θεωρηθεί ως κωδικός πρόσβασης που χρησιμοποιείται για την αυθεντικοποίηση της πρόσβασης στο εργαλείο. Πρέπει να παρέχεται μαζί με το κλειδί του καταναλωτή από τον πάροχο εργαλείων.

Τα εργαλεία που δεν απαιτούν ασφαλή επικοινωνία από το Moodle και δεν παρέχουν επιπρόσθετες υπηρεσίες (όπως η αναφορά βαθμών) ενδέχεται να μην απαιτούν κοινόχρηστο μυστικό.';
$string['pending'] = 'Σε εκκρεμότητα';
$string['pluginadministration'] = 'Διαχείριση εξωτερικού εργαλείου';
$string['pluginname'] = 'Εξωτερικό εργαλείο';
$string['preferheight'] = 'Προτιμώμενο ύψος';
$string['preferwidget'] = 'Προτιμήστε την εκκίνηση του γραφικού στοιχείου (widget)';
$string['preferwidth'] = 'Προτιμώμενο πλάτος';
$string['press_to_submit'] = 'Πατήστε για εκκίνηση αυτής της δραστηριότητας';
$string['privacy'] = 'Ιδιωτικότητα';
$string['privacy:metadata:coursefullname'] = 'Το πλήρες όνομα του μαθήματος από το οποίο ο χρήστης έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:courseid'] = 'Το αναγνωριστικό του μαθήματος από το οποίο ο χρήστης έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:courseidnumber'] = 'Ο αναγνωριστικός αριθμός του μαθήματος από το οποίο ο χρήστης έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:courseshortname'] = 'Το σύντομο όνομα του μαθήματος από το οποίο ο χρήστης έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:createdby'] = 'Ο χρήστης που δημιούργησε την εγγραφή';
$string['privacy:metadata:email'] = 'Η διεύθυνση ηλε.ταχυδρομείου του χρήστη που έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:externalpurpose'] = 'Ο καταναλωτής LTI παρέχει πληροφορίες χρήστη και περιβάλλον στον πάροχο εργαλείου LTI.';
$string['privacy:metadata:firstname'] = 'Το μικρό όνομα του χρήστη που έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:fullname'] = 'Το πλήρες όνομα του χρήστη που έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:lastname'] = 'Το επώνυμο του χρήστη που έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:lti_submission'] = 'Υποβολή LTI';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Η χρονοσφραγίδα που δείχνει πότε έγινε η υποβολή';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Η χρονοσφραγίδα που δείχνει πότε τροποποιήθηκε η υποβολή';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Η βαθμολογία για το χρήστη ως ποσοστό';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Η αρχική βαθμολογία για τον χρήστη';
$string['privacy:metadata:lti_submission:userid'] = 'Το αναγνωριστικό του χρήστη που υπέβαλε τη δραστηριότητα LTI';
$string['privacy:metadata:lti_tool_proxies'] = 'Διακομιστής μεσολάβησης LTI';
$string['privacy:metadata:lti_tool_proxies:name'] = 'Όνομα διακομιστή μεσολάβησης LTI';
$string['privacy:metadata:lti_types'] = 'Τύποι LTI';
$string['privacy:metadata:lti_types:name'] = 'Όνομα τύπου LTI';
$string['privacy:metadata:role'] = 'Ο ρόλος στο μάθημα του χρήστη που έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:timecreated'] = 'Η ώρα δημιουργίας της εγγραφής';
$string['privacy:metadata:timemodified'] = 'Πότε τροποποιήθηκε η εγγραφή';
$string['privacy:metadata:userid'] = 'Το αναγνωριστικό του χρήστη που έχει πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:useridnumber'] = 'Ο αναγνωριστικός αριθμός του χρήστη που πραγματοποιεί την πρόσβαση στον καταναλωτή LTI';
$string['privacy:metadata:username'] = 'Το όνομα χρήστη του χρήστη που έχει πρόσβαση στον καταναλωτή LTI';
$string['publickey'] = 'Δημόσιο κλειδί';
$string['publickey_help'] = 'Το δημόσιο κλειδί (σε μορφότυπο PEM) που παρέχεται από το εργαλείο για την επαλήθευση της υπογραφής εισερχόμενων μηνυμάτων και αιτημάτων για υπηρεσίες.';
$string['publickeyset'] = 'Δημόσιο keyset';
$string['publickeyset_help'] = 'Το σύνολο δημόσιων κλειδιών από το οποίο αυτός ο ιστότοπος θα ανακτήσει το δημόσιο κλειδί του εργαλείου για να επιτρέψει την επαλήθευση υπογραφών εισερχόμενων μηνυμάτων και αιτήσεων εξυπηρέτησης.';
$string['quickgrade'] = 'Να επιτρέπεται η γρήγορη βαθμολόγηση';
$string['quickgrade_help'] = 'Αν ενεργοποιηθεί, πολλά εργαλεία μπορούν να βαθμολογηθούν σε μία σελίδα. Προσθέστε βαθμούς και σχόλια και στη συνέχεια κάντε κλικ στο πλήκτρο «Αποθήκευση όλων των ανατροφοδοτήσεων μου» για να αποθηκεύσετε όλες τις αλλαγές για αυτήν τη σελίδα.';
$string['redirect'] = 'Ανακατεύθυνση σε μερικά δευτερόλεπτα. Εάν όχι, πατήστε το πλήκτρο.';
$string['redirectionuris'] = 'Διεύθυνση/-εις URI ανακατεύθυνσης';
$string['redirectionuris_help'] = 'Μια λίστα διευθύνσεων URI (μία ανά γραμμή) την οποία χρησιμοποιεί το εργαλείο κατά την υποβολή αιτημάτων αυθεντικοποίησης. Πρέπει να είναι καταχωρημένη τουλάχιστον μια πριν από μια επιτυχημένη αποστολή μηνύματος στο εργαλείο.';
$string['register'] = 'Καταχώρηση';
$string['register_warning'] = 'Η σελίδα καταχώρησης φαίνεται να καθυστερεί λίγο για να ανοίξει. Εάν δεν εμφανίζεται, βεβαιωθείτε ότι έχετε εισαγάγει τη σωστή διεύθυνση URL στις ρυθμίσεις διαμόρφωσης. Αν το Moodle χρησιμοποιεί https, βεβαιωθείτε ότι το εργαλείο που ρυθμίζετε υποστηρίζει το https και ότι χρησιμοποιείτε το https στη διεύθυνση URL.';
$string['registertype'] = 'Διαμόρφωση μιας νέας καταχώρησης εξωτερικού εργαλείου';
$string['registration_options'] = 'Επιλογές καταχώρησης';
$string['registrationname'] = 'Όνομα παρόχου εργαλείων';
$string['registrationname_help'] = 'Δώστε το όνομα του παρόχου του εργαλείου που καταχωρείται.';
$string['registrationurl'] = 'Διεύθυνση URL καταχώρησης';
$string['registrationurl_help'] = 'Η διεύθυνση URL καταχώρησης πρέπει να είναι διαθέσιμη από τον πάροχο εργαλείου ως η θέση στην οποία πρέπει να σταλούν τα αιτήματα καταχώρησης.';
$string['reject'] = 'Απόρριψη';
$string['rejected'] = 'Απορρίφθηκε';
$string['resource'] = 'Πόρος';
$string['resourcekey'] = 'Κλειδί καταναλωτή';
$string['resourcekey_admin'] = 'Κλειδί καταναλωτή';
$string['resourcekey_admin_help'] = 'Το κλειδί καταναλωτή μπορεί να θεωρηθεί ως το όνομα ενός χρήστη που χρησιμοποιείται για την αυθεντικοποίηση της πρόσβασης στο εργαλείο.
Μπορεί να χρησιμοποιηθεί από τον πάροχο εργαλείων για να προσδιορίσει με μοναδικό τρόπο τον ιστότοπο Moodle από τον οποίο οι χρήστες εκκινούν το εργαλείο.

Το κλειδί καταναλωτή πρέπει να παρέχεται από τον πάροχο εργαλείου. Η μέθοδος απόκτησης ενός κλειδιού καταναλωτή ποικίλλει μεταξύ των παρόχων εργαλείων. Μπορεί να είναι μια αυτοματοποιημένη διαδικασία ή μπορεί να χρειαστεί διάλογος με τον πάροχο εργαλείων.

Εργαλεία που δεν απαιτούν ασφαλή επικοινωνία από το Moodle και δεν παρέχουν επιπρόσθετες υπηρεσίες (όπως αναφορές βαθμολογίας) ενδέχεται να μην απαιτούν κλειδί πόρου.';
$string['resourcekey_help'] = 'Για τα προ-ρυθμισμένα εργαλεία, δεν είναι απαραίτητο να εισαγάγετε εδώ ένα κλειδί πόρου, καθώς το κλειδί για τον καταναλωτή θα παρέχεται ως μέρος της διαδικασίας διαμόρφωσης.

Αυτό το πεδίο θα πρέπει να εισαχθεί αν δημιουργήσετε μια σύνδεση με έναν πάροχο εργαλείων ο οποίος δεν έχει ήδη ρυθμιστεί.
Αν ο πάροχος εργαλείων πρόκειται να χρησιμοποιηθεί περισσότερες από μία φορές σε αυτό το μάθημα, η προσθήκη μιας διάρθρωσης εργαλείου μαθήματος είναι μια καλή ιδέα.

Το κλειδί του καταναλωτή μπορεί να θεωρηθεί ως όνομα χρήστη που χρησιμοποιείται για την επαλήθευση της πρόσβασης στο εργαλείο. Μπορεί να χρησιμοποιηθεί από τον πάροχο εργαλείων για να προσδιορίσει με μοναδικό τρόπο την τοποθεσία Moodle από την οποία οι χρήστες ξεκινούν το εργαλείο.

Το κλειδί για τον καταναλωτή πρέπει να παρέχεται από τον πάροχο εργαλείων. Η μέθοδος απόκτησης ενός κλειδιού καταναλωτή ποικίλλει μεταξύ των παρόχων εργαλείων. Μπορεί να είναι μια αυτοματοποιημένη διαδικασία ή μπορεί να χρειαστεί διάλογος με τον πάροχο εργαλείων.

Τα εργαλεία που δεν απαιτούν ασφαλή επικοινωνία από το Moodle και δεν παρέχουν επιπρόσθετες υπηρεσίες (όπως η αναφορά βαθμών) ενδέχεται να μην απαιτούν ένα κλειδί πόρου.';
$string['resourceurl'] = 'Διεύθυνση URL πόρου';
$string['return_to_course'] = 'Κάντε κλικ <a href="{$a->link}" target="_top">εδώ</a> για να επιστρέψετε στο μάθημα.';
$string['saveallfeedback'] = 'Αποθήκευση όλης της ανατροφοδότησής μου';
$string['search:activity'] = 'Εξωτερικό εργαλείο - πληροφορίες δραστηριότητας';
$string['secure_icon_url'] = 'Ασφαλής διεύθυνση URL εικονιδίου';
$string['secure_icon_url_help'] = 'Παρόμοια με τη διεύθυνση URL του εικονιδίου, αλλά χρησιμοποιείται όταν η πρόσβαση στον ιστότοπο γίνεται με ασφάλεια μέσω SSL. Αυτό το πεδίο είναι για να αποτρέπει τον περιηγητή να εμφανίζει μια προειδοποίηση για μια ανασφαλή εικόνα.';
$string['secure_launch_url'] = 'Ασφαλής διεύθυνση URL εργαλείου';
$string['secure_launch_url_help'] = 'Παρόμοια με τη διεύθυνση URL του εργαλείου, αλλά χρησιμοποιείται αντί της διεύθυνσης URL του εργαλείου, εάν απαιτείται υψηλή ασφάλεια. Το Moodle θα χρησιμοποιήσει τη διεύθυνση URL του ασφαλούς εργαλείου αντί για τη διεύθυνση URL του εργαλείου αν η πρόσβαση στην τοποθεσία του Moodle γίνει μέσω SSL ή αν το εργαλείο έχει ρυθμιστεί να εκκινείται πάντα μέσω SSL.

Η διεύθυνση URL του εργαλείου μπορεί επίσης να οριστεί σε μια διεύθυνση https για να επιβληθεί η εκκίνηση μέσω SSL και αυτό το πεδίο μπορεί να παραμείνει κενό.';
$string['selectcontent'] = 'Επιλέξτε περιεχόμενο';
$string['send'] = 'Αποστολή';
$string['services'] = 'Υπηρεσίες';
$string['services_help'] = 'Επιλέξτε τις υπηρεσίες που θέλετε να προσφέρετε στον πάροχο εργαλείων. Μπορούν να επιλεγούν περισσότερες από μία υπηρεσίες.';
$string['setupoptions'] = 'Επιλογές εγκατάστασης';
$string['share_email'] = 'Κοινοποίηση στο εργαλείο της διεύθυνσης ηλε.ταχυδρομείου αυτού που έκανε την εκκίνηση';
$string['share_email_admin'] = 'Κοινοποίηση στο εργαλείο της διεύθυνσης ηλε.ταχυδρομείου αυτού που έκανε την εκκίνηση';
$string['share_email_admin_help'] = 'Καθορίστε εάν η διεύθυνση ηλε.ταχυδρομείου του χρήστη που θα εκκινήσει το εργαλείο θα μοιραστεί με τον πάροχο των εργαλείων. Ο πάροχος εργαλείων μπορεί να χρειαστεί τις διευθύνσεις ηλε.ταχυδρομείου του χρήστη που θα εκκινήσει το εργαλείο για να διακρίνει μεταξύ χρηστών με ίδιο όνομα στο περιβάλλον εργασίας ή να στέλνει μηνύματα ηλε.ταχυδρομείου στους χρήστες με βάση τις ενέργειες μέσα στο εργαλείο.';
$string['share_email_help'] = 'Καθορίστε εάν η διεύθυνση ηλε.ταχυδρομείου του χρήστη που ξεκινά το εργαλείο θα μοιράζεται με τον πάροχο του εργαλείου.

Ο πάροχος του εργαλείου μπορεί να χρειάζεται τις διευθύνσεις ηλε.ταχυδρομείου αυτών που ξεκινούν το εργαλείο για να διακρίνει χρήστες με το ίδιο όνομα, ή να στέλνει μηνύματα ηλε.ταχυδρομείου σε χρήστες βασισμένος σε ενέργειες εντός του εργαλείου.

Σημειώστε ότι αυτή η ρύθμιση μπορεί να παρακαμφθεί στις ρυθμίσεις του εργαλείου.';
$string['share_name'] = 'Κοινοποίηση στο εργαλείο του ονόματος αυτού που έκανε την εκκίνηση';
$string['share_name_admin'] = 'Κοινοποίηση στο εργαλείο του ονόματος αυτού που έκανε την εκκίνηση';
$string['share_name_admin_help'] = 'Καθορίστε εάν πρέπει να μοιραστεί το πλήρες όνομα του χρήστη που εκκινεί το εργαλείο με τον παροχέα εργαλείων.
Ο πάροχος εργαλείου ίσως χρειαστεί τα ονόματα αυτών που εκκινούν το εργαλείο για να εμφανίσει πληροφορίες με νόημα μέσα στο εργαλείο.';
$string['share_name_help'] = 'Καθορίστε εάν το πλήρες όνομα του χρήστη που ξεκινά το εργαλείο θα πρέπει να μοιράζεται με τον πάροχο του εργαλείου.

Ο πάροχος του εργαλείου μπορεί να χρειάζεται τα ονόματα αυτών που ξεκινούν το εργαλείο ώστε να εμφανίζει χρήσιμες πληροφορίες εντός του εργαλείου.

Σημειώστε ότι αυτή η ρύθμιση μπορεί να παρακαμφθεί στις ρυθμίσεις του εργαλείου.';
$string['share_roster'] = 'Επιτρέψτε στο εργαλείο να αποκτήσει πρόσβαση στη λίστα συμμετεχόντων αυτού του μαθήματος';
$string['share_roster_admin'] = 'Το εργαλείο μπορεί να έχει πρόσβαση στη λίστα συμμετεχόντων του μαθήματος';
$string['share_roster_admin_help'] = 'Καθορίστε εάν το εργαλείο μπορεί να έχει πρόσβαση στη λίστα των χρηστών που έχουν εγγραφεί σε μαθήματα από τα οποία εκκινείται αυτό το εργαλείο.';
$string['share_roster_help'] = 'Καθορίστε εάν το εργαλείο θα μπορεί να έχει πρόσβαση στη λίστα των χρηστών που έχουν εγγραφεί σε αυτό το μάθημα.

Σημειώστε ότι αυτή η ρύθμιση μπορεί να παρακαμφθεί στις ρυθμίσεις του εργαλείου.';
$string['show_in_course_activity_chooser'] = 'Εμφάνιση στον επιλογέα δραστηριότητας και ως προ-ρυθμισμένο εργαλείο';
$string['show_in_course_lti1'] = 'Χρήση ρυθμίσεων εργαλείου';
$string['show_in_course_lti1_help'] = 'Αυτό το εργαλείο μπορεί να εμφανιστεί στον επιλογέα δραστηριότητας για να το επιλέξει ένας διδάσκων, για να το προσθέσει σε ένα μάθημα. Εναλλακτικά, μπορεί να εμφανιστεί στο πτυσσόμενο μενού των προ-ρυθμισμένων εργαλείων κατά την προσθήκη ενός εξωτερικού εργαλείου σε ένα μάθημα. Μια άλλη επιλογή είναι οι ρυθμίσεις του εργαλείου να χρησιμοποιούνται μόνο αν εισαχθεί η ακριβής διεύθυνση URL του εργαλείου κατά την προσθήκη ενός εξωτερικού εργαλείου σε ένα μάθημα.';
$string['show_in_course_lti2'] = 'Χρήση ρυθμίσεων εργαλείου';
$string['show_in_course_lti2_help'] = 'Αυτό το εργαλείο μπορεί να εμφανιστεί στον επιλογέα δραστηριότητας για να το επιλέξει ένας διδάσκων, για να το προσθέσει σε ένα μάθημα ή στο πτυσσόμενο μενού των προ-ρυθμισμένων εργαλείων κατά την προσθήκη ενός εξωτερικού εργαλείου σε ένα μάθημα.';
$string['show_in_course_no'] = 'Να μην προβληθεί: χρήση μόνο όταν εισάγεται μια διεύθυνση URL εργαλείου που αντιστοιχεί';
$string['show_in_course_preconfigured'] = 'Εμφάνιση ως προδιαμορφωμένου εργαλείου όταν προστίθεται ένα εξωτερικό εργαλείο';
$string['sitehost'] = 'Όνομα Η/Υ που φιλοξενεί τον ιστότοπο';
$string['siteid'] = 'Αναγνωριστικό ιστοτόπου';
$string['size'] = 'Παράμετροι μεγέθους';
$string['submission'] = 'Υποβολή';
$string['submissions'] = 'Υποβολές';
$string['submissionsfor'] = 'Υποβολές για {$a}';
$string['subplugintype_ltiresource'] = 'Πόρος υπηρεσίας LTI';
$string['subplugintype_ltiresource_plural'] = 'Πόροι υπηρεσίας LTI';
$string['subplugintype_ltiservice'] = 'Υπηρεσία LTI';
$string['subplugintype_ltiservice_plural'] = 'Υπηρεσίες LTI';
$string['subplugintype_ltisource'] = 'Πηγή LTI';
$string['subplugintype_ltisource_plural'] = 'Πηγές LTI';
$string['successfullycreatedtooltype'] = 'Δημιουργήθηκε με επιτυχία νέο εργαλείο!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Επιτυχής κλήση/λήψη ρυθμίσεων εργαλείου από το επιλεγμένο περιεχόμενο.';
$string['toggle_debug_data'] = 'Εναλλαγή εμφάνισης/απόκρυψης δεδομένων αποσφαλμάτωσης';
$string['tool_config_not_found'] = 'Οι ρυθμίσεις εργαλείου δεν βρέθηκαν για αυτήν τη διεύθυνση URL.';
$string['tool_settings'] = 'Ρυθμίσεις εργαλείου';
$string['tooldescription'] = 'Περιγραφή εργαλείου';
$string['tooldescription_help'] = 'Η περιγραφή του εργαλείου που θα εμφανιστεί στους διδάσκοντες στη λίστα δραστηριοτήτων.

Αυτό θα πρέπει να περιγράφει ποιο είναι το εργαλείο και τι κάνει και τυχόν επιπρόσθετες πληροφορίες που μπορεί να χρειάζεται να γνωρίζει ο διδάσκων.';
$string['tooldetailsaccesstokenurl'] = 'Διεύθυνση URL κουπονιού πρόσβασης';
$string['tooldetailsauthrequesturl'] = 'Διεύθυνση URL για αιτήματα αυθεντικοποίησης';
$string['tooldetailsclientid'] = 'Αναγνωριστικό πελάτη';
$string['tooldetailsdeploymentid'] = 'Αναγνωριστικό εφαρμογής/χρήσης';
$string['tooldetailsmailtosubject'] = 'Διαμόρφωση εργαλείου LTI';
$string['tooldetailsmodalemail'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['tooldetailsmodallink'] = 'Εμφάνιση λεπτομερειών διαμόρφωσης';
$string['tooldetailsmodaltitle'] = 'Λεπτομέρειες ρύθμισης εργαλείου';
$string['tooldetailsplatformid'] = 'Αναγνωριστικό πλατφόρμας';
$string['tooldetailspublickeyseturl'] = 'Διεύθυνση URL σετ δημόσιων κλειδιών';
$string['toolisbeingused'] = 'Αυτό το εργαλείο χρησιμοποιείται {$a} φορές';
$string['toolisnotbeingused'] = 'Αυτό το εργαλείο δεν έχει χρησιμοποιηθεί ακόμα';
$string['toolproxy'] = 'Καταχωρήσεις εξωτερικού εργαλείου';
$string['toolproxy_help'] = 'Οι εξωτερικές καταχωρήσεις εργαλείων επιτρέπουν στους διαχειριστές ιστοτόπων Moodle να διαμορφώνουν εξωτερικά εργαλεία μέσω ενός διακομιστή μεσολάβησης εργαλείων που αντλεί ρυθμίσεις από έναν παροχέα (εξυπηρετητή) εργαλείων που υποστηρίζει το LTI 2.0. Μια διεύθυνση URL καταχώρισης που παρέχεται από τον παροχέα εργαλείων είναι το μόνο που απαιτείται για την έναρξη της διαδικασίας. Οι δυνατότητες και οι υπηρεσίες που προσφέρονται στον παροχέα εργαλείων επιλέγονται κατά τη διαμόρφωση μιας νέας καταχώρησης. Οι καταχωρήσεις εργαλείων που αναφέρονται στην λίστα αυτής της σελίδας χωρίζονται σε τέσσερις κατηγορίες:

* ** Διαμορφωμένες ** - Αυτές οι καταχωρήσεις εργαλείων έχουν ρυθμιστεί αλλά η διαδικασία καταχώρησης δεν έχει ξεκινήσει ακόμα.
* ** Εκκρεμείς ** - Η διαδικασία καταχώρησης για αυτές τις καταχωρήσεις εργαλείων έχει ξεκινήσει αλλά δεν έχει ολοκληρωθεί. Ανοίξτε και αποθηκεύστε τις ρυθμίσεις για να μετακινηθείτε πίσω στην κατηγορία «Διαμορφωμένες».
* ** Αποδεκτές ** - Έχουν εγκριθεί αυτές οι καταχωρήσεις εργαλείων. Οι πόροι που καθορίζονται στο διακομιστή μεσολάβησης εργαλείων θα εμφανιστούν στη σελίδα προρυθμισμένων εργαλείων με αρχική κατάσταση «Εκκρεμείς».
* ** Απορρίφθηκαν ** - Αυτές οι καταχωρήσεις εργαλείων είναι αυτές που απορρίπτονται κατά τη διαδικασία καταχώρησης. Ανοίξτε και αποθηκεύστε τις ρυθμίσεις για να μετακινηθείτε πίσω στην κατηγορία «Διαμορφωμένες», έτσι ώστε να είναι δυνατή η επανεκκίνηση της διαδικασίας καταχώρησης.';
$string['toolproxyregistration'] = 'Καταχώρηση εξωτερικού εργαλείου';
$string['toolregistration'] = 'Καταχώρηση εξωτερικού εργαλείου';
$string['toolsetup'] = 'Ρυθμίσεις εξωτερικού εργαλείου';
$string['tooltypeadded'] = 'Το προ-ρυθμισμένο εργαλείο προστέθηκε';
$string['tooltypedeleted'] = 'Το προ-ρυθμισμένο εργαλείο διαγράφηκε';
$string['tooltypenotdeleted'] = 'Η διαγραφή του προ-ρυθμισμένου εργαλείου απέτυχε';
$string['tooltypes'] = 'Εργαλεία';
$string['tooltypeupdated'] = 'Το προ-ρυθμισμένο εργαλείο ενημερώθηκε';
$string['toolurl'] = 'Διεύθυνση URL εργαλείου';
$string['toolurl_contentitemselectionrequest'] = 'Διεύθυνση URL επιλογής περιεχομένου';
$string['toolurl_contentitemselectionrequest_help'] = 'Η διεύθυνση URL επιλογής περιεχομένου θα χρησιμοποιηθεί για την εκκίνηση της σελίδας επιλογής περιεχομένου από τον παροχέα εργαλείων. Αν είναι άδεια, θα χρησιμοποιηθεί η διεύθυνση URL εργαλείου';
$string['toolurl_help'] = 'Η διεύθυνση URL εργαλείου χρησιμοποιείται για την αντιστοίχιση των εργαλείων με τις σωστές ρυθμίσεις τους. Το πρόθεμα http(s) της URL είναι προαιρετικό.

Επιπλέον, η βασική διεύθυνση URL χρησιμοποιείται ως η URL διεύθυνση του εργαλείου, εάν δεν έχει οριστεί άλλη στο στιγμιότυπο του εξωτερικού εργαλείου.

Για παράδειγμα, μια βασική διεύθυνση URL *tool.com* θα αντιστοιχιζόταν με τα ακόλουθα:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Μια βασική διεύθυνση URL *www.tool.com/quizzes* θα αντιστοιχιζόταν με τα ακόλουθα:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Μια βασική διεύθυνση URL *quiz.tool.com* θα αντιστοιχιζόταν με τα ακόλουθα:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Αν υπάρχουν δύο διαφορετικά σετ ρυθμίσεων εργαλείων για τον ίδιο τομέα, θα χρησιμοποιηθεί η πιο συγκεκριμένη αντιστοίχιση.

Μπορείτε επίσης να εισαγάγετε μια διεύθυνση URL ενός Common Cartridge («Κοινό Φυσίγγιο Μάθησης» ή «Κοινή Μαθησιακή Κασέτα»: πρότυπο ψηφιακών μαθησιακών πακέτων της IMS) αν έχετε ένα και τα στοιχεία για το εργαλείο θα συμπληρωθούν αυτόματα.';
$string['toolurlplaceholder'] = 'Διεύθυνση URL εργαλείου...';
$string['typename'] = 'Όνομα εργαλείου';
$string['typename_help'] = 'Το όνομα του εργαλείου χρησιμοποιείται για να ταυτοποιεί τον πάροχο του εργαλείου μέσα στο Moodle. Το όνομα που καταχωρείται θα είναι ορατό στους διδάσκοντες όταν προσθέτουν εξωτερικά εργαλεία μέσα στα μαθήματα.';
$string['types'] = 'Τύποι';
$string['unabletocreatetooltype'] = 'Δεν είναι δυνατή η δημιουργία εργαλείου';
$string['unabletofindtooltype'] = 'Δεν είναι δυνατή η εύρεση εργαλείου για {$a->id}';
$string['unknownstate'] = 'Άγνωστη κατάσταση';
$string['update'] = 'Ενημέρωση';
$string['useraccountinformation'] = 'Πληροφορίες λογαριασμού χρήστη';
$string['userpersonalinformation'] = 'Προσωπικές πληροφορίες χρηστών';
$string['using_tool_cartridge'] = 'Χρήση πακέτου εργαλείου';
$string['using_tool_configuration'] = 'Χρήση των ρυθμίσεων εργαλείου:';
$string['validurl'] = 'Μια έγκυρη διεύθυνση URL πρέπει να ξεκινά με http:// ή https://';
$string['viewsubmissions'] = 'Δείτε τις υποβολές και την οθόνη βαθμολόγησης';
