<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grouptool', language 'el', version '3.11'.
 *
 * @package     grouptool
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activated_group'] = 'Ενεργοποιημένη ομάδα';
$string['activated_groups'] = 'Ενεργοποιημένες ομάδες!';
$string['active'] = 'Ενεργό';
$string['activegroups'] = 'Ενεργές ομάδες';
$string['add_member'] = 'Προσθήκη του/της <strong>{$a->username}</strong> στην ομάδα <strong>{$a->groupname}</strong>';
$string['added_member'] = 'Προστέθηκε ο/η <strong>{$a->username}</strong> στην ομάδα <strong>{$a->groupname}</strong>';
$string['administration'] = 'Διαχείριση';
$string['administration_alt'] = 'Δημιουργία ομάδας (ή ομαδοποίησης) και ρυθμίσεις για ενεργές ομάδες αυτού του στιγμιοτύπου';
$string['agroups'] = 'Ενεργές ομάδες';
$string['ajax_edit_size_help'] = 'Αποθήκευση νέου μεγέθους με <Enter>, χρήση <ESC> για ματαίωση, αφήστε κενό για διαγραφή συγκεκριμένου μεγέθους';
$string['all_groups_full'] = 'Δεν ήταν δυνατή η καταχώρισή του <strong>{$a}</strong> σε καμία ομάδα επειδή όλες οι ομάδες είναι γεμάτες!';
$string['allow_multiple'] = 'Πολλαπλές καταχωρίσεις';
$string['allow_multiple_help'] = 'Δυνατότητα καταχώρισης μαθητών σε περισσότερες από 1 ομάδες ταυτόχρονα. Πρέπει να καθορίσετε πόσες ομάδες πρέπει να επιλεγούν τουλάχιστον (= ελάχιστος αριθμός ομάδων που θα επιλεγούν) και πόσες ομάδες επιτρέπεται να επιλεγούν το πολύ (= μέγιστος αριθμός ομάδων που θα επιλεγούν).';
$string['allow_reg'] = 'Ενεργοποίηση αυτο-καταχώρισης';
$string['allow_reg_help'] = 'Ενεργοποίηση της αυτόματης καταχώρισης για μαθητές, ώστε να μπορούν να αυτο-καταχωριστούν στις ενεργές ομάδες, οι οποίες επιλέγονται παρακάτω.';
$string['allow_unreg'] = 'Να επιτρέπεται κατάργηση καταχώρισης';
$string['allow_unreg_help'] = 'Να μπορούν οι μαθητές να καταργούν την καταχώριση ή να αλλάζουν σε άλλες ομάδες πριν (προαιρετικά) την προθεσμία.';
$string['allowed'] = 'Επιτρέπεται';
$string['already_marked'] = 'Αυτή η ομάδα είχε ήδη επισημανθεί για καταχώριση!';
$string['already_member'] = 'Ο/Η <strong>{$a->username}</strong> είναι ήδη μέλος της ομάδας <strong>{$a->groupname}</strong>';
$string['already_occupied'] = 'Η θέση στην ομάδα <strong>{$a->grpname}</strong> έχει ήδη καταληφθεί επειδή άλλος χρήστης ολοκλήρωσε την καταχώριση πιο γρήγορα. Παρακαλούμε, αναζητήστε μια άλλη ομάδα!';
$string['already_queued'] = '<strong>{$a->username}</strong> βρίσκεται ήδη σε ουρά στην ομάδα <strong>{$a->groupname}</strong>!';
$string['already_registered'] = '<strong>{$a->username}</strong> έχει ήδη καταχωριστεί στην ομάδα <strong>{$a->groupname}</strong>!';
$string['alwaysshowdescription'] = 'Πάντα εμφάνιση περιγραφής';
$string['alwaysshowdescription_help'] = 'Εάν απενεργοποιηθεί, η παραπάνω περιγραφή του ομαδοεργαλείου γίνει ορατή στους μαθητές μόνο μετά την ημερομηνία «Έναρξης εγγραφών».';
$string['asterisk_marks_moodle_registrations'] = 'Οι χρήστες με αστερίσκο (*) είναι ήδη καταχωρισμένοι στην αντίστοιχη ομάδα Moodle';
$string['availabledate'] = 'Έναρξη καταχώρισης';
$string['availabledate_help'] = 'Έναρξη της περιόδου καταχώρισης. Μετά από αυτήν την ημερομηνία οι μαθητές μπορούν να καταχωριστούν στις επιλεγμένες ομάδες (εάν είναι ενεργοποιημένη η δυνατότητα αυτο-καταχώρισης).';
$string['availabledateno'] = 'Πάντα διαθέσιμη';
$string['cant_enrol'] = 'Δεν γίνεται αυτόματη εγγραφή του χρήστη στο μάθημα.';
$string['cfg_addinstanceset_head'] = 'Πρόσθετες ρυθμίσεις στιγμιότυπου';
$string['cfg_addinstanceset_head_info'] = 'Πρόσθετες ρυθμίσεις για το ομαδοεργαλείο';
$string['cfg_admin_head'] = 'Προεπιλεγμένες ρυθμίσεις στην διαχείριση εμφάνισης';
$string['cfg_admin_head_info'] = 'Τυπικές ρυθμίσεις για την καρτέλα διαχείρισης σε προβολή ομαδοεργαλείου.';
$string['cfg_allow_multiple'] = 'Πολλαπλές καταχωρίσεις';
$string['cfg_allow_multiple_desc'] = 'Δυνατότητα καταχώρισης μαθητών σε περισσότερες από 1 ομάδες ταυτόχρονα από προεπιλογή.';
$string['cfg_allow_reg'] = 'Να επιτρέπεται αυτο-καταχώριση';
$string['cfg_allow_reg_desc'] = 'Να επιτρέπεται στους μαθητές η αυτο-καταχώριση, από προεπιλογή';
$string['cfg_allow_unreg'] = 'Να επιτρέπεται κατάργηση καταχώρισης';
$string['cfg_allow_unreg_desc'] = 'Να μπορούν οι χρήστες να καταργήσουν την καταχώρισή τους και να αλλάζουν ομάδες;';
$string['cfg_choose_max'] = 'Επιλογή μέγιστου';
$string['cfg_choose_max_desc'] = 'Σε πόσες ομάδες να μπορούν οι χρήστες να καταχωριστούν ταυτόχρονα από προεπιλογή;';
$string['cfg_choose_min'] = 'Επιλογή ελάχιστου';
$string['cfg_choose_min_desc'] = 'Πόσες ομάδες το ελάχιστο χρειάζεται να επιλέξουν οι χρήστες από προεπιλογή;';
$string['cfg_force_dereg'] = 'Αναγκαστική κατάργηση καταχώρισης στο ομαδοεργαλείο';
$string['cfg_force_dereg_desc'] = 'Αναγκαστική κατάργηση καταχώρισης όχι μόνο από το ομαδοεργαλείο αλλά και από την ομάδα Moodle.';
$string['cfg_force_importreg'] = 'Αναγκαστική καταχώριση στο ομαδοεργαλείο';
$string['cfg_force_importreg_desc'] = 'Επιβολή μέσω ομαδοεργαλείου στους χρήστες που εισάγονται σε ομάδες Moodle να καταχωρίζονται υποχρεωτικά και σε αυτό το στιγμιότυπο ομαδοεργαλείου.';
$string['cfg_groups_queues_limit'] = 'Τακτοποίηση θέσεων στην ουρά κατά ομάδες';
$string['cfg_groups_queues_limit_desc'] = 'Καθορίζει πόσοι διαφορετικοί μαθητές μπορούν να βρίσκονται στην ουρά σε μια ομάδα ταυτόχρονα από προεπιλογή.';
$string['cfg_grpsize'] = 'Καθολικό μέγεθος τυπικής ομάδας';
$string['cfg_grpsize_desc'] = 'Τυπικό μέγεθος ομάδας που χρησιμοποιείται παντού στο ομαδοεργαλείο';
$string['cfg_ifgroupdeleted'] = 'Εάν οι ομάδες διαγραφούν';
$string['cfg_ifgroupdeleted_desc'] = 'Θα πρέπει οι διαγραμμένες ομάδες να επαναδημιουργούνται για το στιγμιότυπο του ομαδοεργαλείου ή θα πρέπει να διαγράφονται οι αναφορές στο ομαδοεργαλείο (συμπεριλαμβανομένων δεδομένων, καταχωρίσεων και ουρών ομάδας); Σημείωση: Εάν επιλεγεί «Επαναδημιουργία ομάδας», οι ομάδες θα επαναδημιουργηθούν αυτόματα μετά τη διαγραφή στο «Διαχείριση μαθήματος / Χρήστες / Ομάδες».';
$string['cfg_ifmemberadded'] = 'Εάν προστίθενται μέλη της ομάδας';
$string['cfg_ifmemberadded_desc'] = 'Πρέπει τα νέα μέλη της ομάδας που προστίθενται μέσω του moodle να καταχωρίζονται επίσης και στο ομαδοεργαλείο ή να αγνοούνται;';
$string['cfg_ifmemberremoved'] = 'Εάν αφαιρεθούν μέλη της ομάδας';
$string['cfg_ifmemberremoved_desc'] = 'Πρέπει να διαγράφονται οι καταχωρίσεις ομαδοεργαλείου εάν οι χρήστες διαγραφούν από την αντίστοιχη ομάδα Moodle;';
$string['cfg_immediate_reg'] = 'Άμεση καταχώριση';
$string['cfg_immediate_reg_desc'] = 'Πρέπει κάθε καταχώριση να διαβιβάζεται στις ομάδες Moodle;';
$string['cfg_importfields'] = 'Σύγκριση πεδίων για εισαγωγή/κατάργηση καταχώρισης';
$string['cfg_importfields_desc'] = 'Καθορίζει ποια πεδία στον πίνακα χρηστών πρέπει να συγκρίνονται με τα δεδομένα κατά την εισαγωγή/ κατάργηση της καταχώρισης χρηστών. Τα πεδία αναζητούνται ένα προς ένα μέχρι να βρεθεί ένα μοναδικό ταίριασμα. Πιθανές/χρήσιμες τιμές είναι για παράδειγμα: όνομα χρήστη, αριθμός αναγνωριστικού, διεύθυνση ηλε.ταχυδρομείου. ΠΡΟΣΟΧΗ: δεν υπάρχει έλεγχος για σωστά ονόματα πεδίων. Επιτρεπόμενοι χαρακτήρες: a-z, A-Z και «,» (κόμμα).';
$string['cfg_instance_head'] = 'Προεπιλεγμένες ρυθμίσεις στιγμιότυπου';
$string['cfg_instance_head_info'] = 'Προεπιλεγμένες ρυθμίσεις για νέα στιγμιότυπα ομαδοεργαλείου.';
$string['cfg_max_queues'] = 'Μέγιστος αριθμός ταυτόχρονων θέσεων σε ουρά ανά συμμετέχοντα';
$string['cfg_max_queues_desc'] = 'Ορίζει σε πόσων διαφορετικών ομάδων την ουρά μπορεί ένας χρήστης να βρίσκεται ταυτόχρονα από προεπιλογή.';
$string['cfg_moodlesync_head'] = 'Συμπεριφορά συγχρονισμού';
$string['cfg_moodlesync_head_info'] = 'Πώς θα πρέπει να συμπεριφέρονται τα ομαδοεργαλεία όταν προστίθονται/διαγράφονται μέλη ομάδας ή διαγράφονται μεμονωμένες ομάδες';
$string['cfg_name_scheme'] = 'Τυπικό σχήμα ονόματος';
$string['cfg_name_scheme_desc'] = 'Τυπικό σχήμα ονόματος που χρησιμοποιείται για τη δημιουργία ομάδας';
$string['cfg_show_members'] = 'Εμφάνιση μελών ομάδας';
$string['cfg_show_members_desc'] = 'Ορίζει εάν τα μέλη ομάδας θα πρέπει να είναι ορατά από προεπιλογή';
$string['cfg_use_individual'] = 'Χρήση μεμονωμένου μεγέθους';
$string['cfg_use_individual_desc'] = 'Εάν το μέγεθος της μεμονωμένης ομάδας για κάθε ομάδα πρέπει να χρησιμοποιείται από προεπιλογή';
$string['cfg_use_queue'] = 'Χρήση ουρών';
$string['cfg_use_queue_desc'] = 'Εάν πρέπει από προεπιλογή να γίνεται χρήση ουράς σε κάθε περίπτωση προσπάθειας για καταχώριση σε πλήρη ομάδα.';
$string['cfg_use_size'] = 'Χρήση μεγέθους ομάδας';
$string['cfg_use_size_desc'] = 'Εάν το μέγεθος της ομάδας πρέπει να είναι περιορισμένο από προεπιλογή';
$string['cfg_users_queues_limit'] = 'Θέσεις ουράς ανά χρήστη';
$string['cfg_users_queues_limit_desc'] = 'Ορίζει σε πόσων διαφορετικών ομάδων την ουρά μπορεί ένας χρήστης να βρίσκεται ταυτόχρονα από προεπιλογή.';
$string['change_group'] = 'Αλλαγή ομάδας';
$string['change_group_to'] = 'Να συνεχιστεί η αλλαγή ομάδας σε <strong>{$a->groupname}</strong>;';
$string['change_group_to_success'] = 'Αλλαγή ομάδας επιτυχής! Ο/Η <strong>{$a->username}</strong> έχει πλέον καταχωριστεί στην ομάδα <strong>{$a->groupname}</strong>!';
$string['changes_saved'] = 'Οι αλλαγές αποθηκεύτηκαν';
$string['checkbox_control_header'] = 'Απο-/επιλογή ομάδων και ομαδοποιήσεων';
$string['checkbox_control_header_help'] = '<p>Με τη χρήση αυτής της λειτουργίας μπορείτε να ενεργοποιήσετε/απενεργοποιήσετε ομάδες μίας ή περισσότερων ομαδοποιήσεων μέσα στο ομαδοεργαλείο σας:
<ol>
<li>Επιλέξτε στο πεδίο πολλαπλών επιλογών «Όλα» (όλες οι διαθέσιμες ομάδες θα ενεργοποιηθούν/απενεργοποιηθούν), μία ομαδοποίηση ή πολλές ομαδοποιήσεις (μεταβαίνοντας σε πολλαπλή επιλογή χρησιμοποιώντας το μικρό εικονίδιο δίπλα του και χρησιμοποιώντας Ctrl + Click).</li>
<li>Χρησιμοποιήστε μία από τις ακόλουθες επιλογές «Επιλογή/ Αποεπιλογή/ Αναστροφή»:
<ul>
<li><b>Επιλογή:</b> Οι ομάδες των επιλεγμένων ομαδοποιήσεων θα ενεργοποιηθούν.</li>
<li><b>Αποεπιλογή:</b> Οι ομάδες των επιλεγμένων ομαδοποιήσεων θα απενεργοποιηθούν</li>
<li><b>Αντιστροφή:</b> Όλες οι ομάδες των μη επιλεγμένων ομαδοποιήσεων θα ενεργοποιηθούν.</li>
</ul>
</li>
<li>Αφού ολοκληρώσετε την επιλογή σας κάντε κλικ στο πλήκτρο «ΟΚ».</li>
</ol>
</p>';
$string['choose'] = 'Επιλογή...';
$string['choose_group'] = 'Πρέπει να επιλέξετε μια ομάδα-στόχο!';
$string['choose_max'] = 'Μέγιστος αριθμός επιλεγμένων ομάδων';
$string['choose_max_text'] = 'Μπορείτε να επιλέξετε <strong>{$a}</strong> ομάδα/-ες το πολύ!';
$string['choose_min'] = 'Ελάχιστος αριθμός επιλεγμένων ομάδων';
$string['choose_min_max_text'] = 'Πρέπει να επιλέξετε μεταξύ <strong>{$a->min}</strong> και <strong>{$a->max}</strong> ομάδες!';
$string['choose_min_text'] = 'Πρέπει να επιλεγούν τουλάχιστον <strong>{$a}</strong> ομάδα/-ες!';
$string['choose_minmax_title'] = 'Ομάδες προς επιλογή';
$string['choose_targetgroup_import'] = 'Εισαγωγή σε ομάδα/-ες';
$string['choose_targetgroup_unregister'] = 'Κατάργηση καταχώρισης από ομάδα/-ες';
$string['chooseactivity'] = 'Πρέπει να επιλέξετε μια δραστηριότητα για να εμφανιστούν τα δεδομένα!';
$string['condition_prevent_access'] = 'Οι τρέχουσες συνθήκες σας εμποδίζουν να έχετε πρόσβαση στο στιγμιότυπο ομαδοεργαλείου!';
$string['confirm_delete'] = 'Πρόκειται να διαγραφεί εντελώς την ομάδα. Αυτό θα αφαιρέσει όλα τα μέλη από αυτήν την ομάδα χωρίς δυνατότητα ανάκτησης. ΣΙΓΟΥΡΑ θέλετε να συνεχίσετε;';
$string['confirm_delete_title'] = 'Θέλετε πραγματικά να διαγράψετε αυτό το στοιχείο;';
$string['copied_grade_feedback'] = 'Ομαδική βαθμολόγηση< br />
+Υποβολή από: <strong>{$a->student}</strong><br />
+βαθμολογία από: <strong>{$a->teacher}</strong><br />
+Αρχική Ημερομηνία/Ώρα: <strong>{$a->date}</strong><br />
+Ανατροφοδότηση: <strong>{$a->feedback}</strong>';
$string['copy'] = 'Αντιγραφή';
$string['copy_chosen'] = 'Αντιγραφή επιλεγμένου';
$string['copy_grade_confirm'] = 'Να συνεχιστεί η αντιγραφή αυτού του βαθμού;';
$string['copy_grade_overwrite_confirm'] = 'Να συνεχιστεί η αντιγραφή αυτού του βαθμού; Οι υπάρχοντες προηγούμενοι βαθμοί θα αντικατασταθούν!';
$string['copy_grades_confirm'] = 'Να συνεχιστεί η αντιγραφή αυτών των βαθμών;';
$string['copy_grades_errors'] = 'Παρουσιάστηκε τουλάχιστον 1 σφάλμα κατά την αντιγραφή των βαθμών:';
$string['copy_grades_overwrite_confirm'] = 'Να συνεχιστεί η αντιγραφή αυτών των βαθμών; Οι υπάρχοντες προηγούμενοι βαθμοί αντικαθίστανται!';
$string['copy_grades_success'] = 'Οι ακόλουθοι βαθμοί ενημερώθηκαν με επιτυχία:';
$string['copy_refgrades_feedback'] = 'Αντιγραφή των βαθμών αναφοράς και των ανατροφοδοτήσεων για επιλεγμένες ομάδες άλλων μελών της ομάδας';
$string['copygrade'] = 'Αντιγραφή βαθμού';
$string['could_not_add'] = 'Αδυναμία προσθήκης του/της <strong>{$a->username}</strong> στην ομάδα <strong>{$a->groupname}</strong>';
$string['couldnt_move_down'] = 'Αδυναμία μετακίνησης της ομάδας προς τα κάτω!';
$string['couldnt_move_up'] = 'Αδυναμία μετακίνησης της ομάδας προς τα πάνω!';
$string['createGroups'] = 'Δημιουργία ομάδων';
$string['create_1_person_groups'] = 'Δημιουργία ομάδων 1 ατόμου';
$string['create_1_person_groups_help'] = 'Δημιουργία ομάδων 1 ατόμου - εδώ δημιουργείται μια ομάδα για κάθε επιλεγμένο χρήστη. Εκτός από το # και το @ μπορείτε να χρησιμοποιήσετε τις ακόλουθες ετικέτες που θα αντικατασταθούν με τα δεδομένα των χρηστών:
<ul>
<li>[username] - το όνομα χρήστη του χρήστη</li>
<li>[firstname] - το μικρό όνομα του χρήστη</li>
<li>[lastname] - το επώνυμο του χρήστη</li>
<li>[idnumber] - ο αριθμός αναγνωριστικού του χρήστη</li>
</ul>
Αν λείπουν κάποια δεδομένα, η ετικέτα θα αντικατασταθεί από το όνομαετικέτταςXX όπου το XX αντιπροσωπεύει τον αριθμό της ομάδας.';
$string['create_assign_groupings'] = 'Δημιουργία/Ανάθεση ομαδοποιήσεων';
$string['create_fromto_groups'] = 'Δημιουργία ομάδων με αριθμούς από ένα διάστημα (δηλαδή από 34 έως 89), <strong>χωρίς αυτόματη εκχώρηση</strong> των μελών της ομάδας';
$string['create_fromto_groups_help'] = 'Δημιουργία ομάδων με αριθμούς από ένα διάστημα (δηλαδή από 34 έως 89) - χρησιμοποιήστε αυτήν τη λειτουργία για να δημιουργήσετε ομάδες (που λείπουν) (δηλαδή Ομάδα 4, Ομάδα 5, Ομάδα 6). Απλώς εισαγάγετε όρια και πόσα ψηφία θέλετε να χρησιμοποιήσετε τουλάχιστον για τα ονόματα (δηλαδή 1, 01, 001, 0001...). Είναι δυνατό να ορίσετε ένα συγκεκριμένο μέγεθος ομάδας με «Αριθμός μελών ομάδας M». Δεν θα υπάρξει <strong>καμία αυτόματη εκχώρηση</strong> μελών ομάδας.';
$string['create_groupings_confirm'] = 'Συνέχιση δημιουργίας ομαδοποιήσεων όπως στην προεπισκόπηση παραπάνω;';
$string['create_groupings_confirm_problem'] = 'Παρουσιάστηκε τουλάχιστον 1 σφάλμα (ανατρέξτε στην προεπισκόπηση παραπάνω)!';
$string['create_groups_confirm'] = 'Συνέχιση δημιουργίας ομάδων όπως στην προεπισκόπηση παραπάνω;';
$string['create_groups_confirm_problem'] = 'Κατά την προσπάθεια δημιουργίας των νέων ομάδων με βάση το δεδομένο σχήμα ονόματος, προκύπτουν διενέξεις - δείτε την προεπισκόπηση - οι ομάδες Moodle πρέπει να έχουν μοναδικά ονόματα. Η διένεξη μπορεί να οφείλεται σε υπάρχουσες ομάδες με το ίδιο όνομα ή σε σφάλμα σύνταξης στο σχήμα ονομάτων (... π.χ. κενό, λείπει # σύμβολο).';
$string['create_n_m_groups'] = 'Δημιουργία N ομάδων για M μέλη, <strong>χωρίς αυτόματη εκχώρηση</strong> μελών ομάδας';
$string['create_n_m_groups_help'] = 'Δημιουργία N ομάδων για M μέλη - Δημιουργήστε με αυτόν τον τρόπο έναν συγκεκριμένο αριθμό ομάδων (N ομάδες) με συγκεκριμένο μέγεθος ομάδων (M μέλη), π.χ. επτά ομάδες με χώρο για τρία μέλη η καθεμία. Δεν θα υπάρξει <strong>καμία αυτόματη εκχώρηση</strong> μελών ομάδας.';
$string['createinsertgrouping'] = 'Προσθήκη στην ομαδοποίηση';
$string['deactivated_group'] = 'Απενεργοποιημένη ομάδα';
$string['deactivated_groups'] = 'Απενεργοποιημένες ομάδες!';
$string['define_amount_groups'] = 'Ορισμός αριθμού ομάδων N';
$string['define_amount_groups_help'] = 'Ορισμός αριθμού ομάδων Ν - Μπορείτε να επιλέξετε ποιον ρόλο θα χρησιμοποιούν οι χρήστες για τη δημιουργία ομάδας και να εισαγάγετε τον επιθυμητό αριθμό ομάδων στο πεδίο κειμένου Ομάδα/Μέλος. Στο σχήμα ονομάτων μπορείτε να εισαγάγετε ένα σχήμα ονομάτων για τις ομάδες χρησιμοποιώντας
<ul>
<li># (θα αντικατασταθεί με τον αριθμό ομάδας) και </li>
<li>@ (θα αντικατασταθεί με ένα γράμμα-αναπαράσταση του αριθμού ομάδας)</li>
</ul>
Στη συνέχεια, οι επιλεγμένοι χρήστες διαμοιράζονται στον επιθυμητό αριθμό ομάδων.';
$string['define_amount_members'] = 'Ορισμός του αριθμού των μελών της ομάδας Μ';
$string['define_amount_members_help'] = 'Ορισμός του αριθμού μελών ομάδας M - Εδώ μπορείτε να πείτε στο ομαδοεργαλείο πόσα μέλη θα πρέπει να έχει ιδανικά κάθε ομάδα. Ο απαιτούμενος αριθμός ομάδων θα υπολογιστεί αυτόματα. Εάν επιλέξετε την αποτροπή τελευταίας μικρής ομάδας, οι χρήστες αυτής της ομάδας διαμοιράζονται στις άλλες, εάν η αναλογία πληρότητας της τελευταίας ομάδας βρίσκεται κάτω από 70%.';
$string['delete_reference'] = 'Διαγραφή από το ομαδοεργαλείο';
$string['description'] = 'Περιγραφή';
$string['deselect'] = 'Αποεπιλογή';
$string['determinismerror'] = 'Το τέλος καταχωρίσεων δεν μπορεί να είναι πριν την έναρξη καταχωρίσεων ή στο παρελθόν.';
$string['digits'] = 'Ελάχιστα ψηφία';
$string['disabled'] = 'Απενεργοποιημένο';
$string['drag'] = 'Μετακίνηση';
$string['due'] = 'Προθεσμία ομαδοεργαλείου';
$string['duedate'] = 'Τέλος καταχωρίσεων';
$string['duedate_help'] = 'Τέλος περιόδου καταχωρίσεων. Μετά από αυτή την ημερομηνία οι μαθητές δεν είναι πλέον σε θέση να καταχωριστούν και ο διδάσκων έχει πρόσβαση στην λειτουργία-επίλυσης-ουρών, κλπ.';
$string['duedateno'] = 'Καμία ημερομηνία λήξης';
$string['early'] = '{$a} νωρίς';
$string['error_activating_group'] = 'Σφάλμα κατά την ενεργοποίηση της ομάδας <strong>{$a->groupid}</strong> στο ομαδοεργαλείο <strong>{$a->grouptoolid}</strong>!';
$string['error_at'] = 'Σφάλμα στο';
$string['error_deactivating_group'] = 'Σφάλμα κατά την απενεργοποίηση της ομάδας <strong>{$a->groupid}</strong> στο ομαδοεργαλείο <strong>{$a->grouptoolid}</strong>!';
$string['error_getting_data'] = 'Σφάλμα κατά τη λήψη δεδομένων ομάδας! Επιστράφηκαν ή περισσότερες από 1 ομάδες ή καμία!';
$string['error_saving_new_order'] = 'Σφάλμα κατά την αποθήκευση νέας διάταξης για ομάδες: <strong>{$a}</strong>';
$string['eventagrpcreated'] = 'Η ενεργός-ομάδα δημιουργήθηκε';
$string['eventagrpdeleted'] = 'Η ενεργός-ομάδα διαγράφηκε';
$string['eventagrpsupdated'] = 'Οι ενεργές-ομάδες ενημερώθηκαν';
$string['eventdequeuingstarted'] = 'Το άδειασμα των ουρών ξεκίνησε';
$string['eventgroupcreationstarted'] = 'Η δημιουργία-ομάδων ξεκίνησε';
$string['eventgroupgraded'] = 'Η ομάδα βαθμολογήθηκε';
$string['eventgroupingscreated'] = 'Οι ομαδοποιήσεις δημιουργήθηκαν';
$string['eventgrouprecreated'] = 'Η ομάδα επαναδημιουργήθηκε';
$string['eventoverviewexported'] = 'Η εξαγωγή της επισκόπησης πραγματοποιήθηκε';
$string['eventqueueentrycreated'] = 'Η καταχώρηση ουράς δημιουργήθηκε';
$string['eventqueueentrydeleted'] = 'Η καταχώρηση ουράς διαγράφηκε';
$string['eventregistrationcreated'] = 'Η καταχώριση δημιουργήθηκε';
$string['eventregistrationdeleted'] = 'Η καταχώριση διαγράφηκε';
$string['eventregistrationpushstarted'] = 'Η ώθηση καταχωρίσεων ξεκίνησε';
$string['eventuserimported'] = 'Η εισαγωγή του χρήστη ολοκληρώθηκε';
$string['eventuserlistexported'] = 'Η λίστα χρηστών έχει εξαχθεί';
$string['eventusermoved'] = 'Ο χρήστης μετακινήθηκε';
$string['exceedgroupqueuelimit'] = 'Ξεπεράστηκε το όριο ουράς της ομάδας!';
$string['exceedgroupsize'] = 'Ξεπεράστηκε το μέγεθος της ομάδας!';
$string['exceeduserqueuelimit'] = 'Ξεπεράστηκε το όριο ουρών του χρήστη!';
$string['exceeduserreglimit'] = 'Ξεπεράστηκε το όριο καταχωρίσεων του χρήστη!';
$string['feedbackplural'] = 'Ανατροφοδοτήσεις';
$string['filters_legend'] = 'Φιλτράρισμα δεδεμένων';
$string['filterunoccupied'] = 'Εμφάνιση μόνο ομάδων με ελεύθερες θέσεις';
$string['followchanges'] = 'Παρακολούθηση αλλαγών';
$string['forceregistration'] = 'Επιβολή καταχώρισης στο ομαδοεργαλείο';
$string['forceregistration_help'] = 'Επισημαίνεται ότι οι ομάδες του ομαδοεργαλείου διαφέρουν ουσιαστικά από τις τυπικές ομάδες μαθήματος του Moodle. Τικάρετε το πλαίσιο ελέγχου εάν θέλετε να εισαγάγετε τους χρήστες στην ομάδα ομαδοεργαλείου καθώς και στην τυπική ομάδα moodle.';
$string['found_multiple'] = 'Δεν είναι δυνατή η μοναδική αναγνώριση· βρέθηκαν πολλοί χρήστες:';
$string['free'] = 'Ελεύθερη';
$string['fromgttoerror'] = 'Η τιμή-προς πρέπει να είναι μεγαλύτερη από ή ίση με την τιμή-από';
$string['fullgroup'] = 'Η ομάδα είναι πλήρης';
$string['general_information'] = 'Γενικές πληροφορίες';
$string['general_registration_exception'] = 'Παρουσιάστηκε μια γενική εξαίρεση καταχώρισης, όμως δεν μπορεί να προσδιοριστεί αυτόματα το γιατί!';
$string['global_userstats'] = '<strong>{$a->reg_users}</strong> χρήστες από <strong>{$a->users}</strong> είναι καταχωριμένοι. <strong>{$a->notreg_users}</strong> ακόμα χωρίς καταχώριση.';
$string['grading'] = 'Βαθμολόγηση';
$string['grading_activity_title'] = 'Δραστηριότητα';
$string['grading_alt'] = 'Εργαλεία για αντιγραφή βαθμών από 1 μέλος της ομάδας σε όλους τους άλλους στην ομάδα, είτε για 1 ομάδα είτε για ένα σύνολο ομάδων.';
$string['grading_filter_select_title'] = 'Ομάδα ή ομάδες';
$string['grading_filter_select_title_help'] = 'Επιλέξτε ποια ομάδα ή ομάδες θα χρησιμοποιήσετε:<ul><li>Χωρίς διενέξεις - όλες οι ομάδες, στις οποίες μόνο 1 μέλος της ομάδας βαθμολογήθηκε για την επιλεγμένη δραστηριότητα</li><li>Όλες - όλες οι ομάδες</li><li>«Όνομα ομάδας» - μόνο η ειδικά επιλεγμένη ομάδα</li></ul>';
$string['grading_grouping_select_title'] = 'Ομαδοποίηση φίλτρων';
$string['group_administration'] = 'Διαχείριση ομάδων';
$string['group_administration_alt'] = 'Διαχείριση (ενεργών) ομάδων και ομαδοποιήσεων';
$string['group_assign_error'] = 'Αποτυχία ανάθεσης ομάδας!';
$string['group_assign_error_prev'] = 'Αδυναμία ανάθεσης ομάδας!';
$string['group_creation'] = 'Δημιουργία ομάδων';
$string['group_creation_alt'] = 'Δημιουργία ομάδων';
$string['group_creation_failed'] = 'Η δημιουργία ομάδων απέτυχε!';
$string['group_creation_success'] = 'Δημιουργία ομάδων επιτυχής!';
$string['group_not_found'] = 'Η ομάδα <strong>{$a->groupid}</strong> δεν βρέθηκε στο ομαδοεργαλείο <strong>{$a->grouptoolid}</strong>!';
$string['group_not_in_grouping'] = 'Η επιλεγμένη ομάδα δεν είναι μέλος της επιλεγμένης ομαδοποίησης!';
$string['group_or_member_count'] = 'Πλήθος ομάδων/μελών';
$string['group_places'] = 'Θέσεις ομάδας';
$string['group_places_help'] = 'Το πεδίο «θέση ομάδας» ενημερώνει (με διαχωριστικό την ανάστροφη κάθετο) πρώτα για το συνολικό αριθμό θέσεων της ομάδας, δεύτερον για τον αριθμό των ελεύθερων θέσεων και τρίτον για τον αριθμό των θέσεων ομάδας που έχουν ήδη καταληφθεί.';
$string['groupchange_from_non_unique_reg'] = 'Αδυναμία αλλαγής ομάδας λόγω μη μοναδικής προηγούμενης ομάδας!';
$string['groupcreation'] = 'Δημιουργία ομάδας';
$string['groupcreationmode'] = 'Τρόπος λειτουργίας';
$string['groupfromtodigits'] = 'Ψηφία από-μέχρι σε ονόματα ομάδων:';
$string['groupinfo'] = 'Πληροφορίες ομάδας';
$string['grouping_assign_error'] = 'Αποτυχία επιτυχούς ανάθεσης στην ομαδοποίηση:';
$string['grouping_assign_error_prev'] = 'Αδυναμία επιτυχούς ανάθεσης στην ομαδοποίηση:';
$string['grouping_assign_success'] = 'Ανατέθηκαν με επιτυχία:';
$string['grouping_assign_success_prev'] = 'Μπορεί να γίνει ανάθεση με επιτυχία:';
$string['grouping_creation_error'] = 'Αποτυχία δημιουργίας ομαδοποίησης!';
$string['grouping_creation_error_prev'] = 'Αδυναμία δημιουργίας ομαδοποίησης!';
$string['grouping_creation_only_success'] = 'Η ομαδοποίηση δημιουργήθηκε με επιτυχία!';
$string['grouping_creation_only_success_prev'] = 'Η ομαδοποίηση μπορεί να δημιουργηθεί με επιτυχία!';
$string['grouping_creation_success'] = 'Επιτυχής δημιουργία ομαδοποίησης και ανάθεσης της ομάδας <strong>{$a}</strong> σε αυτήν!';
$string['grouping_creation_success_prev'] = 'Μπορεί να δημιουργηθεί η ομαδοποίηση και να ανατεθεί η ομάδα <strong>{$a}</strong> σε αυτήν!';
$string['grouping_exists_error'] = 'Αποτυχία δημιουργίας ομαδοποίησης επειδή υπάρχει ήδη μια ομαδοποίηση με αυτό το όνομα!';
$string['grouping_exists_error_prev'] = 'Αδυναμία δημιουργίας ομαδοποίησης επειδή υπάρχει ήδη μια ομαδοποίηση με αυτό το όνομα!';
$string['groupings_created_and_groups_added'] = 'Έγινε δημιουργία ομαδοποίησης/-ων και προσθήκη ομάδας/-ων!';
$string['groupingscreation'] = 'Δημιουργία και ανάθεση ομαδοποιήσεων';
$string['groupingselect'] = 'Ομαδοποιήσεις για επιλεγμένες ομάδες';
$string['groupingselect_help'] = 'Δημιουργία ομαδοποιήσεων για επιλεγμένες ομάδες:<ul>
<li>Δημιουργία ΜΙΑΣ ομαδοποίησης για όλες τις επιλεγμένες ομάδες. Το όνομα της ομαδοποίησης μπορεί να επιλεγεί ελεύθερα.</li>
<li>Δημιουργία ομαδοποίησης για ΚΑΘΕ επιλεγμένη ομάδα. Η ομαδοποίηση ονομάζεται με βάση την αντίστοιχη ομάδα.</li>
<li>Προσθήκη επιλεγμένων ομάδων σε μια υπάρχουσα ομαδοποίηση</li></ul>';
$string['groupoverview'] = 'Επισκόπηση ομάδας';
$string['groups_created'] = 'Οι ομάδες δημιουργήθηκαν με επιτυχία!';
$string['groups_queues_limit'] = 'Θέσεις ουράς ανά ομάδα';
$string['groups_queues_limit_help'] = 'Περιορίζει τις διαθέσιμες θέσεις ουράς ανά ομάδα, εάν ενεργοποιηθεί';
$string['groupselection'] = 'Επιλογή ομάδας';
$string['groupselection_help'] = 'Επιλέξτε τις ομάδες/τα άτομα για τα οποία επιθυμείτε να αντιγράψετε τον επιλεγμένο βαθμό και ανατροφοδότηση αναφοράς ενεργοποιώντας τα αντίστοιχα πλαίσια ελέγχου. Εάν εμφανίζεται μόνο 1 ομάδα, επιλέγετε την πηγή για την αντιγραφή του επιλεγμένου βαθμού χρησιμοποιώντας το αντίστοιχο κουμπί δεξιά της καταχώρησης.';
$string['groupsize'] = 'Μέγεθος ομάδας';
$string['groupsize_gets_enabled'] = 'Αν συνεχίσετε, το μέγεθος ομάδας θα ενεργοποιηθεί αυτόματα. Αποτρέψτε αυτή τη συμπεριφορά χρησιμοποιώντας το 0 ως <strong>{$a->field}</strong>';
$string['groupsize_individual_gets_enabled'] = 'Εάν συνεχίσετε, θα ενεργοποιηθεί αυτόματατα το ιδιαίτερο μέγεθος ομάδας. Αποτρέψτε αυτήν τη συμπεριφορά χρησιμοποιώντας το 0 ως <strong>{$a->field}</strong> για να μην χρησιμοποιείται καθόλου το μέγεθος της ομάδας ή χρησιμοποιήστε το <strong>{$a->globalsize}</strong> για να ενεργοποιήσετε μόνο το καθολικό μέγεθος ομάδας!';
$string['groupstatus'] = 'Κατάσταση';
$string['groupstatus_help'] = 'Η τρέχουσα κατάσταση μιας ομάδας απεικονίζεται με χρώμα:<ul><li>Πράσινο - ενεργή ομάδα. Η ομάδα έχει ανατεθεί σε αυτό το ομαδοεργαλείο. Εάν η αυτο-καταχώριση είναι ενεργή, οι μαθητές μπορούν να καταχωριστούν σε αυτή την ομάδα.</li><li>Γκρι - ανενεργή ομάδα. Η ομάδα δεν είναι διαθέσιμη σε αυτό το ομαδοεργαλείο.</li></ul>Κάνοντας κλικ στο σύμβολο, η κατάσταση μπορεί να αλλάξει.';
$string['grouptool'] = 'Ομαδοεργαλείο';
$string['grouptool:addinstance'] = 'Προσθήκη ενός στιγμιότυπου ομαδοεργαλείου στο μάθημα.';
$string['grouptool:administrate_groups'] = 'Διαχείριση (ενεργών) ομάδων και ομαδοποιήσεων';
$string['grouptool:create_groupings'] = 'Δημιουργία ομαδοποιήσεων με χρήση του ομαδοεργαλείου.';
$string['grouptool:create_groups'] = 'Δημιουργία ομάδων με χρήση του ομαδοεργαλείου.';
$string['grouptool:export'] = 'Εξαγωγή δεδομένων ομάδας και καταχώρισης σε διαφορετικούς μορφότυπους';
$string['grouptool:grade'] = 'Αντιγραφή βαθμών από ένα μέλος ομάδας στα άλλα';
$string['grouptool:grade_own_group'] = 'Αντιγραφή βαθμών από ένα μέλος ομάδας στα άλλα, εάν ο αρχικός βαθμός έχει δοθεί από εμένα';
$string['grouptool:move_students'] = 'Μετακίνηση μαθητών σε άλλες ομάδες.';
$string['grouptool:register'] = 'Αυτο-καταχώριση σε μια ενεργή ομάδα με χρήση του ομαδοεργαλείου';
$string['grouptool:register_students'] = 'Καταχώριση μαθητών σε μια ενεργή ομάδα με χρήση του ομαδοεργαλείου. (Χρησιμοποιείται επίσης για την επίλυση ουρών)';
$string['grouptool:unregister_students'] = 'Κατάργηση καταχώρισης μαθητών από ομάδες με χρήση του ομαδοεργαλείου.';
$string['grouptool:view_description'] = 'Προβολή περιγραφής ομαδοεργαλείων';
$string['grouptool:view_groups'] = 'Προβολή ενεργών ομάδων';
$string['grouptool:view_own_registration'] = 'Προβολή της/των δικών σας καταχωρίσεων.';
$string['grouptool:view_registrations'] = 'Προβολή όσων είναι καταχωρισμένοι/σε ουρά και σε ποια ενεργή ομάδα με χρήση του ομαδοεργαλείου';
$string['grouptool:view_regs_course_overview'] = 'Προβολή λίστας χρηστών που περιέχει όσους είναι καταχωρισμένοι/σε ουρά και σε ποια ενεργή ομάδα με χρήση του ομαδοεργαλείου.';
$string['grouptool:view_regs_course_view'] = 'Προβολή μιας λίστας χρηστών που περιέχει όσους είναι καταχωρισμένοι/σε ουρά και σε ποια ενεργή ομάδα με χρήση του ομαδοεργαλείου.';
$string['grouptool:view_regs_group_overview'] = 'Προβολή ομαδοποιημένης λίστας που περιέχει όσους είναι καταχωρισμένοι/σε ουρά και σε ποια ενεργή ομάδα με χρήση του ομαδοεργαλείου.';
$string['grouptool:view_regs_group_view'] = 'Προβολή μιας ομαδοποιημένης λίστας που περιέχει όσους είναι καταχωρισμένοι/σε ουρά και σε ποια ενεργή ομάδα με χρήση του ομαδοεργαλείου.';
$string['grouptoolfieldset'] = 'Ρυθμίσεις στιγμιοτύπου';
$string['grouptoolname'] = 'Όνομα ομαδοεργαλείου';
$string['grouptoolname_help'] = 'Το όνομα του στιγμιότυπου ομαδοεργαλείου';
$string['groupuser_import'] = 'Εισαγωγή χρηστών ομάδας';
$string['groupuser_unregister'] = 'Κατάργηση καταχώρησης χρηστών ομάδας';
$string['grp_marked'] = 'Επισήμανση για καταχώρηση';
$string['grpsizezeroerror'] = 'Το μέγεθος της ομάδας πρέπει να είναι μεγαλύτερο ή ίσο με 1. Δεν επιτρέπονται γράμματα ή άλλα σημάδια.';
$string['ifgroupdeleted'] = 'Αν διαγραφούν ομάδες';
$string['ifgroupdeleted_help'] = 'Θα πρέπει διαγραμμένες ομάδες να επαναδημιουργούνται για το στιγμιότυπο του ομαδοεργαλείου ή θα πρέπει να διαγράφονται οι αναφορές στο ομαδοεργαλείο (συμπεριλαμβανομένων δεδομένων, καταχωρίσεων και ουρών ομάδας); Σημείωση: Εάν επιλεγεί «Επαναδημιουργία ομάδας», οι ομάδες θα δημιουργηθούν ξανά αυτόματα μετά τη διαγραφή στο «Διαχείριση μαθήματος / Χρήστες / Ομάδες».';
$string['ifmemberadded'] = 'Αν προστεθούν μέλη ομάδας';
$string['ifmemberadded_help'] = 'Θα πρέπει τα νέα μέλη ομάδας που προστίθονται μέσω του Moodle να καταχωρίζονται και στο ομαδοεργαλείο ή να αγνοούνται;';
$string['ifmemberremoved'] = 'Αν διαγραφούν μέλη ομάδας';
$string['ifmemberremoved_help'] = 'Θα πρέπει να διαγράφονται οι καταχωρίσεις ομαδοεργαλείου εάν οι χρήστες διαγραφούν από την αντίστοιχη ομάδα του Moodle;';
$string['ignorechanges'] = 'Παράβλεψη αλλαγών';
$string['ignored_not_found_users'] = 'Αδυναμία προσθήκης τουλάχιστον ενός χρήστη στην ομάδα!';
$string['ignored_not_found_users_unregister'] = 'Αδυναμία εύρεσης τουλάχιστον ενός χρήστη!';
$string['ignoring_not_found_users'] = 'Τουλάχιστον ένας χρήστης δεν έχει βρεθεί στη βάση δεδομένων. Όλοι αυτοί οι χρήστες θα αγνοηθούν!';
$string['immediate_reg'] = 'Άμεση καταχώριση';
$string['immediate_reg_help'] = 'Εάν ενεργοποιηθεί, οι προσθήκες/καταργήσεις καταχωρήσεων θα προωθούνται στο σύστημα Moodle. Αν απενεργοποιηθεί οι καταχωρίσεις αποθηκεύονται προσωρινά στο ομαδοεργαλείο και μπορούν να προωθηθούν στο σύστημα Moodle από τον διδάσκοντα.';
$string['import'] = 'Εισαγωγή';
$string['import_conflict_user_queued'] = 'Ο/Η χρήστης <strong>{$a->fullname}</strong> βρίσκεται ήδη στην ουρά στην ομάδα <strong>{$a->groupname}</strong>!';
$string['import_desc'] = 'Εισαγωγή χρηστών μέσω λίστας αναγνωριστικών αριθμών σε συγκεκριμένες ομάδες';
$string['import_in_inactive_group_rejected'] = 'Η καταχώριση στην ομάδα grouptool <strong>{$a}</strong> απορρίφθηκε λόγω της αδράνειάς της. Ενεργοποιήστε την ομάδα σε αυτό το ομαδοεργαλείο για να ενεργοποιήσετε την καταχώριση.';
$string['import_in_inactive_group_warning'] = 'Σημείωση: Η ομάδα <strong>{$a}</strong> είναι αυτήν τη στιγμή ανενεργή στο πλαίσιο του ομαδοεργαλείου και επομένως δεν θα εμφανίζεται.';
$string['import_progress_completed'] = 'Η εισαγωγή ολοκληρώθηκε';
$string['import_progress_import'] = 'Εισαγωγή χρήστη';
$string['import_progress_preview_completed'] = 'Η προεπισκόπηση εισαγωγής ολοκληρώθηκε';
$string['import_progress_search'] = 'Αναζήτηση χρήστη';
$string['import_progress_start'] = 'Έναρξη εισαγωγής';
$string['import_skipped'] = 'Παράλειψη χρήστη <strong>{$a->fullname}</strong> για την ομάδα <strong>{$a->groupname}</strong>!';
$string['import_user'] = 'Η εισαγωγή <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) στην ομάδα <strong>{$a->groupname}</strong> ολοκληρώθηκε με επιτυχία.';
$string['import_user_prev'] = 'Εισαγωγή <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) στην ομάδα <strong>{$a->groupname}</strong>.';
$string['import_user_problem'] = 'Πρόβλημα κατά την εισαγωγή του/της <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) στην ομάδα <strong>{$a->groupname}</strong>.';
$string['importbutton'] = 'Εισαγωγή χρηστών';
$string['inactive'] = 'Ανενεργό';
$string['inactivegroups'] = 'Ανενεργές ομάδες';
$string['inactivegroups_hide'] = 'Απόκρυψη ανενεργών ομάδων';
$string['inactivegroups_show'] = 'Εμφάνιση ανενεργών ομάδων';
$string['includedeleted'] = 'Συμπερίληψη διαγραμμένων χρηστών';
$string['includedeleted_help'] = 'Εάν επιλεγεί, οι διαγραμμένοι χρήστες δεν θα φιλτραριστούν (αποκλειστούν) από τη λίστα. Οι διαγραμμένοι λογαριασμοί χρήστη δεν μπορούν να εγγραφούν στο μάθημα κατά τη διαδικασία εισαγωγής.';
$string['incomplete_only_label'] = 'Εμφάνιση μόνο ομάδων με βαθμούς που λείπουν';
$string['incorrect_tab'] = 'Λανθασμένη καρτέλα· αυτή η καρτέλα δεν είναι διαθέσιμη!';
$string['individual_size_info'] = '* Μέγεθος ομάδας της ρύθμισης του ομαδοεργαλείου';
$string['intro'] = 'Περιγραφή';
$string['invert'] = 'Αντιστροφή';
$string['landscape'] = 'Οριζόντια';
$string['late'] = '{$a} αργά';
$string['limit'] = 'όριο';
$string['loading'] = 'φόρτωση...';
$string['max_queues_reached'] = 'Συμπληρώθηκε ο μέγιστος αριθμός ουρών!';
$string['max_regs_reached'] = 'Ο μέγιστος αριθμός καταχωρίσεων επιτεύχθηκε!';
$string['maxmembers'] = 'Καθολικό μέγεθος ομάδας';
$string['messageprovider:grouptool_moveupreg'] = 'Καταχώριση με μετακίνηση προς τα επάνω στην ουρά';
$string['missing_source_selection'] = 'Δεν επιλέχθηκε πηγή!';
$string['modulename'] = 'Ομαδοεργαλείο';
$string['modulename_help'] = 'Το άρθρωμα ομαδοεργαλείο εξυπηρετεί διάφορα είδη εργασιών σε σχέση με ομάδες:<ul><li>Επιτρέπει τη δημιουργία ομάδων με διαφορετικούς τρόπους λειτουργίας (πλήθος ομάδων/μελών ομάδας, ομάδες-ενός-ατόμου, διάστημα ομάδων) καθώς και ομαδοποιήσεις για κάθε ομάδα.</li><li>Επιπλέον μπορεί να χρησιμοποιηθεί για να δώσει στους μαθητές τη δυνατότητα να καταχωριστούν σε συγκεκριμένες ομάδες κατά τη διάρκεια μιας καθορισμένης περιόδου.</li><li>Το άρθρωμα έχει επίσης τη δυνατότητα ομαδικής βαθμολόγησης - δηλ. αντιγραφή βαθμών δραστηριότητας από 1 μέλος ομάδας στα άλλα μέλη της ομάδας.</li><li>Εισαγωγή χρηστών σε ομάδες μέσω λίστας αριθμών αναγνωριστικού</li><li>επισκόπηση για κάθε ομάδα μαθήματος, συμπεριλαμβανομένων όλων των καταχωρήσεων, μελών, ουρών κλπ. Και την δυνατότητα εξαγωγής αυτών των δεδομένων σε διαφορετικούς μορφότυπους αρχείων (PDF/XLSX/ODS/TXT).</li><li>Εξαγώγιμη λίστα όλων των χρηστών-μαθήματος, συμπεριλαμβανομένων των καταχωρίσεών τους, ουρών κλπ.</li></ul><p>(!) Επισημαίνεται ότι οι ομάδες του ομαδοεργαλείου διαφέρουν ουσιαστικά από τις τυπικές ομάδες μαθήματος του Moodle. Για να διασφαλιστεί η συνέπεια μεταξύ των τύπων ομάδων, ορίστε παραμέτρους του τμήματος «Συμπεριφορά έναντι αλλαγών στο Moodle» σε «Παρακολούθηση αλλαγών».</p>';
$string['modulenameplural'] = 'Ομαδοεργαλεία';
$string['moodlesync'] = 'Συμπεριφορά έναντι αλλαγών στο Moodle';
$string['moodlesync_help'] = 'Πώς θα πρέπει να συμπεριφέρονται τα ομαδοεργαλεία όταν προστίθονται/διαγράφονται μέλη ομάδας ή διαγράφονται μεμονωμένες ομάδες';
$string['move_user'] = 'Μετακίνηση από την ουρά στην ομάδα';
$string['movedown'] = 'Μετακίνηση 1 κάτω';
$string['moveup'] = 'Μετακίνηση 1 πάνω';
$string['multiple'] = 'Διαχείριση χρηστών ομάδας';
$string['multiple_desc'] = 'Πολλαπλές Καταχωρίσεις/Καταργήσεις καταχωρίσεων';
$string['must_specify_groupingname'] = 'Πρέπει να παρέχετε ένα όνομα για την ομαδοποίηση!';
$string['mustbegt0'] = 'Οι ελάχιστες ομάδες για να επιλέξετε πρέπει να είναι μεγαλύτερες ή ίσες με 0. Δεν επιτρέπονται γράμματα ή άλλα σημάδια.';
$string['mustbegtoeqmin'] = 'Πρέπει να είναι μεγαλύτερος ή ίσος με τον ελάχιστο';
$string['mustbeposint'] = 'Οι μέγιστες ομάδες για να επιλεγούν πρέπει να είναι μεγαλύτερες ή ίσες με 1. Δεν επιτρέπονται γράμματα ή άλλα σημάδια.';
$string['mygroups_only_label'] = 'Εμφάνιση μόνο καταχωρήσεων πηγών που βαθμολόγησα';
$string['myoverview_registrations_missing'] = 'Λείπουν καταχωρίσεις';
$string['name_scheme_tags'] = '<span class="tag firstname">[firstname]</span>
<span class="tag lastname">[lastname]</span>
<span class="tag idnumber">[idnumber]</span>
<span class="tag username">[username]</span>
<span class="tag alpha">@</span>
<span class="tag number">#</span>';
$string['nameschemenotunique'] = 'Τα ονόματα ομάδων από αυτό το σχήμα ονομάτων δεν είναι μοναδικά (<strong>{$a}</strong>). Παρακαλούμε, επιλέξτε ένα άλλο ή χρησιμοποιήστε # (αριθμητικός δείκτης) ή @ (αλφαβητικός δείκτης) για να δημιουργήσετε μοναδικά ονόματα ομάδων.';
$string['namingscheme'] = 'Σχήμα ονόματος';
$string['namingscheme_help'] = '<p>Το σχήμα ονόματος καθορίζει τον τρόπο αυτόματης ονομασίας των ομάδων όταν προσθέτετε νέες ομάδες.</p>
<p>Παρακαλώ σημειώστε:<br />
<ol><li>Το όνομα μιας ομάδας πρέπει να είναι μοναδικό μέσα στο μάθημα Moodle σας.</li>
<li>Εάν θέλετε να δημιουργήσετε περισσότερες από μία ομάδες ταυτόχρονα, πρέπει να χρησιμοποιήσετε ετικέτες για να δημιουργήσετε μοναδικά ονόματα.</li></ol></p>
<p>Κάθε μία από αυτές τις ετικέτες θα αντικατασταθεί στα τελικά ονόματα ομάδων. Οι ετικέτες στο [] σχετίζονται με τα δεδομένα των χρηστών και τα σύμβολα # και @ θα αντικατασταθούν μέσω του σειριακού αριθμού της ομάδας. Εάν η JavaScript είναι ενεργοποιημένη, μπορείτε απλά να κάνετε κλικ στις ετικέτες για να τις προσαρτήσετε στο σχήμα ονόματος. Λάβετε υπόψη ότι τα ονόματα των ομάδων πρέπει να είναι μοναδικά σε κάθε μάθημα και επομένως ίσως χρειαστεί να αλλάξετε το σχήμα ονομάτων μέχρι να μην υπάρχει καμία διένεξη.</p>';
$string['no_conflictfree_to_display'] = 'Δεν υπάρχουν ομάδες χωρίς διένεξη για εμφάνιση. Προσπαθούμε λοιπόν να τις εμφανίσουμε όλες!';
$string['no_data_to_display'] = 'Δεν υπάρχουν δεδομένα ομάδας/-ων για εμφάνιση!';
$string['no_grades_present'] = 'Κανένας βαθμός προς εμφάνιση';
$string['no_groupmembers_to_display'] = 'Δεν υπάρχει κανένα μέλος ομάδας για να εμφανιστεί. Επομένως, γίνεται προσπάθεια αντ\' αυτού, να εμφανιστούν όλες οι ομάδες.';
$string['no_groups_to_display'] = 'Καμία ομάδα προς εμφάνιση!';
$string['no_queues_to_resolve'] = 'Καμία ουρά προς επίλυση αυτή τη στιγμή!';
$string['no_registrations'] = 'Καθόλου καταχωρίσεις';
$string['no_target_selected'] = 'Δεν υπάρχει προορισμός για τη λειτουργία αντιγραφής που έχει επιλεγεί. Πρέπει να επιλέξετε τουλάχιστον 1 προορισμό!';
$string['no_users_to_display'] = 'Δεν υπάρχουν χρήστες για να εμφανιστούν!';
$string['noaccess'] = 'Δεν έχετε πρόσβαση σε αυτήν την ενότητα (ίσως δεν ανήκετε στη σωστή ομάδα;)!';
$string['nobody_queued'] = 'Δεν μπήκε κανείς στην ουρά';
$string['nodeletion'] = 'Η διαγραφή αυτής της ομάδας είναι απενεργοποιημένη, λόγω τουλάχιστον ενός στιγμιοτύπου ομαδοεργαλείου σε αυτό το μάθημα που έχει ρυθμιστεί να αναδημιουργεί την ομάδα σε περίπτωση διαγραφής!';
$string['nogroupingselected'] = 'Δεν έχει επιλεγεί ομαδοποίηση/-οιήσεις!';
$string['nogroups'] = 'Δεν υπάρχουν ομάδες σε αυτό το μάθημα.';
$string['nogroupsactive'] = 'Καμία ενεργή ομάδα σε αυτό το ομαδοεργαλείο.';
$string['nogroupschoose'] = 'Επιλογή ομάδων';
$string['nogroupscreate'] = 'Δημιουργία ομάδων';
$string['nogroupsinactive'] = 'Δεν υπάρχει καμία ανενεργή ομάδα σε αυτό το ομαδοεργαλείο.';
$string['nogrouptools'] = 'Δεν υπάρχουν καθόλου ομαδοεργαλεία!';
$string['nonconflicting'] = 'Χωρίς διενέξεις';
$string['noregistrationdue'] = 'απεριόριστο';
$string['nosmallgroups'] = 'Αποτροπή μικρών ομάδων';
$string['nosmallgroups_help'] = 'Εάν ενεργοποιηθεί, εξασφαλίζει ότι κάθε ομάδα συμπληρώνεται τουλάχιστον με το 70% του μεγέθους της! Εάν μια (ή ακριβέστερα η τελευταία) ομάδα πρόκειται να συμπληρωθεί λιγότερο από το 70%, οι χρήστες αυτής της ομάδας θα διαμοιραστούν στις άλλες ομάδες, κάνοντάς τες να έχουν περισσότερα μέλη από ό,τι καθορίστηκε!';
$string['not_allowed_to_show_members'] = 'Δεν έχετε δικαίωμα προβολής αυτών των πληροφοριών!';
$string['not_graded_by_me'] = 'Βαθμολογήθηκε από άλλο χρήστη';
$string['not_in_queue_or_registered'] = 'Ο/Η <strong>{$a >username}</strong> δεν έχει καταχωριστεί ούτε βρίσκεται σε ουρά στην ομάδα <strong>{$a->groupname}</strong>';
$string['not_permitted'] = 'Δεν επιτρέπεται';
$string['not_registered'] = 'Δεν έχετε καταχωριστεί ακόμα!';
$string['not_synced_reg_present'] = 'υπάρχουν μη συγχρονισμένες καταχωρίσεις';
$string['notenoughregs'] = 'Οι χρήστες χρειάζονται περισσότερες καταχωρίσεις!';
$string['nothing_to_push'] = 'Τίποτα προς ώθηση!';
$string['notification:group_recreated'] = 'Η ομάδα <a href="{$a->groupurl}" title="{$a->groupname}">{$a->groupname}</a> έχει επαναδημιουργηθεί λόγω του ορισμού του ομαδοεργαλείου <a href="{$a->grouptoolurl}" title="{$a->grouptoolname}">{$a->grouptoolname}</a> για την επαναδημιουργία διαγραμμένων ομάδων.';
$string['notification:registrations_recreated'] = 'Τα μέλη της ομάδας <a href="{$a->groupurl}" title="{$a->groupname}">{$a->groupname}</a> έχουν προστεθεί ξανά λόγω του ότι το ομαδοεργαλείο <a href="{$a->grouptoolurl}" title="{$a->grouptoolname}">$a->grouptoolname}</a> έχει ρυθμιστεί να επαναδημιουργεί τις διαγραμμένες ομάδες. Η ίδια η ομάδα επαναδημιουργήθηκε από ένα άλλο στιγμιότυπο ομαδοεργαλείου.';
$string['nowhere_queued'] = 'Όχι σε ουρά';
$string['number_of_groups'] = 'Αριθμός ομάδων Ν';
$string['number_of_members'] = 'Αριθμός μελών ομάδας Μ';
$string['number_of_students'] = 'Αριθμός μαθητών';
$string['occupied'] = 'Κατειλημμένη';
$string['onenewgrouping'] = 'Σε ΜΙΑ νέα ομαδοποίηση';
$string['onenewgroupingpergroup'] = 'Μία ομαδοποίηση ΑΝΑ ομάδα';
$string['orientation'] = 'Προσανατολισμός-PDF';
$string['outdated'] = 'απόκλιση';
$string['overflowwarning'] = 'Αν συνεχιστεί η εισαγωγή, το μέγεθος της ομάδας στο στιγμιότυπο <strong>{$a->instancename}</strong> θα ξεπεραστεί!';
$string['overview'] = 'Επισκόπηση';
$string['overview_alt'] = 'Επισκόπηση στις ομάδες και τα μέλη ομάδων';
$string['overview_tab'] = 'Εμφάνιση ομάδων';
$string['overview_tab_alt'] = 'Άνοιγμα εμφάνισης ομάδων';
$string['overwrite_label'] = 'Αντικατάσταση υπαρχόντων βαθμών';
$string['place_allocated_in_group_success'] = 'Η ομάδα <strong>{$a->groupname}</strong> έχει με επιτυχία επισημανθεί προς καταχώριση';
$string['pluginadministration'] = 'Διαχείριση ομαδοεργαλείου';
$string['pluginname'] = 'Ομαδοεργαλείο';
$string['portrait'] = 'Κατακόρυφος';
$string['preview'] = 'Προεπισκόπηση';
$string['privacy:metadata:agrpid'] = 'Αναγνωριστικό της ομάδας στο ομαδοεργαλείο που αντιπροσωπεύει την ομάδα του Moodle.';
$string['privacy:metadata:enrolexplanation'] = 'Το ομαδοεργαλείο εγγράφει χρήστες που δεν έχουν ήδη εγγραφεί στο μάθημα κατά την εισαγωγή, έτσι ώστε να είναι σε θέση να τους προσθέσει στην/στις ομάδες για τις οποίες προορίζονται.';
$string['privacy:metadata:gradesexplanation'] = 'Το ομαδοεργαλείο έχει τη δυνατότητα να αντιγράψει βαθμούς από έναν χρήστη σε άλλα μέλη της ίδιας ομάδας.';
$string['privacy:metadata:groupexplanation'] = 'Το ομαδοεργαλείο διαχειρίζεται τα μέλη των ομάδων του Moodle.';
$string['privacy:metadata:messageexplanation'] = 'Το ομαδοεργαλείο στέλνει μηνύματα στους χρήστες που προωθούνται από την ουρά στους καταχωρισμένους.';
$string['privacy:metadata:mod_grouptool_group_filter'] = 'Για ποιά ομάδα να εφαρμοστεί φίλτρο;';
$string['privacy:metadata:mod_grouptool_mygroups_only'] = 'Θα πρέπει να εξετάζονται/εμφανίζονται μόνο οι δικές μου ομάδες.';
$string['privacy:metadata:modified_by'] = 'Αναγνωριστικό του χρήστη, αν έχει τροποποιηθεί από κάποιον άλλο.';
$string['privacy:metadata:queued'] = 'Περιέχονται όλοι οι χρήστες σε ουρά.';
$string['privacy:metadata:registered'] = 'Περιέχει τους καταχωρισμένους χρήστες και τους χρήστες που έχουν επισημανθεί για καταχώριση.';
$string['privacy:metadata:timestamp'] = 'Ημερομηνία/ώρα τελευταίας τροποποίησης της εγγραφής.';
$string['privacy:metadata:userid'] = 'Αναγνωριστικό του χρήστη.';
$string['queue'] = 'Ουρά';
$string['queue_and_multiple_reg_title'] = 'Ουρές και πολλαπλές καταχωρίσεις';
$string['queue_in_group'] = 'Συνέχεια με την προσθήκη του/της <strong>{$a->username}</strong> στην ουρά για την ομάδα <strong>{$a->groupname}</strong>;';
$string['queue_in_group_success'] = 'Επιτυχής προσθήκη του/της <strong>{$a->username}</strong> στην ουρά για την ομάδα <strong>{$a->groupname}</strong>!';
$string['queue_you_in_group'] = 'Συνέχεια της προσθήκης σας στην ουρά για την ομάδα <strong>{$a->groupname}</strong>;';
$string['queue_you_in_group_success'] = 'Επιτυχής καταχώρισή σας στην ομάδα <strong>{$a->groupname}</strong>!';
$string['queued'] = 'Σε ουρά';
$string['queued_in_group_info'] = 'Ο/Η <strong>{$a->username}</strong> βρίσκεται σε ουρά για την ομάδα <strong>{$a->groupname}</strong>';
$string['queued_on_rank'] = 'Σε ουρά με σειρά #{$a}';
$string['queueing_is'] = 'Οι ουρές είναι';
$string['queues'] = 'Ουρές';
$string['queues_max'] = 'Μέγιστος αριθμός ταυτόχρονων θέσεων σε ουρές ανά συμμετέχοντα';
$string['queuesgrp'] = 'Ουρά και μέγιστο θέσεων ουράς';
$string['queuesgrp_help'] = 'Εάν είναι ενεργοποιημένες οι ουρές, οι μαθητές που προσπαθούν να καταχωριστούν σε μια πλήρη ομάδα, μπαίνουν στην ουρά μέχρι κάποιος να διαγραφεί από την ομάδα αυτή. Μετά την προθεσμία, ο διδάσκων έχει τη δυνατότητα να μετακινεί τους μαθητές σε άλλες ομάδες, εάν εξακολουθούν να βρίσκονται σε ουρά, οπότε οι ομάδες συμπληρώνονται με βάση την τρέχουσα σειρά ταξινόμησης της λίστας ομάδων. Πρέπει να ορίσετε έναν μέγιστο αριθμό ομάδων στις οποίες ένας χρήστης μπορεί να τεθεί σε ουρά.<br/>Περιορίζει τις μέγιστες ταυτόχρονες καταχωρήσεις ουράς για κάθε άτομο σε αυτό το ομαδοεργαλείο.';
$string['queuesizeerror'] = 'Οι θέσεις ουράς πρέπει να είναι μεγαλύτερες ή ίσες με 0. Δεν επιτρέπονται γράμματα ή άλλα σημάδια.';
$string['queuespresent'] = 'Υπάρχουν ήδη ουρές! Θα διαγραφούν αν συνεχίσετε. Για συνέχεια πιέστε το πλήκτρο αποθήκευσης ξανά!';
$string['queuespresenterror'] = 'Υπάρχουν χρήστες σε ουρές. Δεν είναι δυνατή η απενεργοποίηση ουρών μέχρι να λυθεί αυτό το θέμα.';
$string['rank'] = 'Κατάταξη';
$string['recreate_group'] = 'Επαναδημιουργία ομάδας';
$string['reference_grade_feedback'] = 'Βαθμός-Αναφοράς / Ανατροφοδότηση';
$string['refresh_table_button'] = 'Ανανέωση προεπισκόπησης';
$string['reg_in_full_group'] = 'Η καταχώριση του/της <strong>{$a->username}</strong> στην ομάδα <strong>{$a->groupname}</strong> δεν είναι δυνατή, καθώς η ομάδα είναι πλήρης!';
$string['reg_not_open'] = 'Η καταχώριση δεν είναι δυνατή αυτή τη στιγμή. Ίσως έχει λήξει η προθεσμία ή δεν επιτρεπόταν γενικότερα.';
$string['reg_you_in_full_group'] = 'Η καταχώριση στην ομάδα <strong>{$a->groupname}</strong> δεν είναι δυνατή, καθώς η ομάδα είναι πλήρης!';
$string['register'] = 'Καταχώριση';
$string['register_in_group'] = 'Σίγουρα θέλετε να καταχωριστεί ο/η <strong>{$a->username}</strong> στην ομάδα <strong>{$a->groupname}</strong>;';
$string['register_in_group_success'] = 'Επιτυχής καταχώριση του/της <strong>{$a->username}</strong> στην ομάδα <strong>{$a->groupname}</strong>!';
$string['register_you_in_group'] = 'Σίγουρα θέλετε να καταχωριστείτε στην ομάδα <strong>{$a->groupname}</strong>;';
$string['register_you_in_group_success'] = 'Καταχωριστήκατε με επιτυχία στην ομάδα <strong>{$a->groupname}</strong>!';
$string['register_you_in_group_successmail'] = 'Καταχωριστήκατε με επιτυχία στην ομάδα <strong>{$a->groupname}</strong>!';
$string['register_you_in_group_successmailhtml'] = 'Καταχωριστήκατε με επιτυχία στην ομάδα <strong>{$a->groupname}</strong>!';
$string['registered'] = 'Καταχωρισμένος';
$string['registered_in_group_info'] = 'Ο/Η {$a->username} έχει καταχωριστεί στην ομάδα <strong>{$a->groupname}</strong>';
$string['registered_on_rank'] = 'Έχει καταχωριστεί με σειρά #{$a}';
$string['registration_missing'] = 'Λείπει 1 καταχώριση';
$string['registration_period_end'] = 'Τέλος καταχώρισης για';
$string['registration_period_start'] = 'Αρχή καταχώρισης για';
$string['registrationdue'] = 'Τέλος καταχώρισης';
$string['registrationnotification'] = '{$a->course->shortname} -> {$a->modulenameplural} -> {$a->grouptoolname}
----------------------------------------------------------
{$a->message}
----------------------------------------------------------';
$string['registrations'] = 'Καταχωρίσεις ομάδας';
$string['registrations_missing'] = '{$a} καταχωρίσεις λείπουν';
$string['regpresent'] = 'Ήδη του χρήστη {$a}';
$string['rename_failed'] = 'Αποτυχία μετονομασίας!';
$string['renamed_group'] = 'Η ομάδα μετονομάστηκε!';
$string['reset_agrps'] = 'Επαναρχικοποίηση ενεργών ομάδων';
$string['reset_agrps_help'] = 'Επαναρχικοποιεί όλες τις ομάδες μαθημάτων ώστε να είναι ανενεργές για ομαδοεργαλεία. Αυτό θα διαγράψει επίσης κάθε καταχώριση και θέση σε ουρά σε ομαδοεργαλεία αυτού του μαθήματος!';
$string['reset_queues'] = 'Επαναρχικοποίηση ουρών';
$string['reset_queues_help'] = 'Οι ουρές διαγράφονται αυτόματα αν γίνει επαναρχικοποίηση των ενεργών ομάδων.';
$string['reset_registrations'] = 'Επαναρχικοποίηση καταχωρίσεων';
$string['reset_registrations_help'] = 'Οι καταχωρίσεις διαγράφονται αυτόματα αν γίνει επαναρχικοποίηση των ενεργών ομάδων.';
$string['reset_transparent_unreg'] = 'Κατάργηση καταχώρησης όλων των μελών της ομάδας που έχουν προωθηθεί';
$string['reset_transparent_unreg_help'] = 'Κατάργηση όλων των χρηστών από εκείνες τις ομάδες που αντιπροσωπεύονται από ενεργές ομάδες ομαδοεργαλείου';
$string['resize'] = 'Αλλαγή μεγέθους';
$string['resized_group'] = 'Αλλαγή μεγέθους ομάδας!';
$string['resolve_queue'] = 'Επίλυση ουρών';
$string['resolve_queue_legend'] = 'Επίλυση ουρών';
$string['resolve_queue_title'] = 'Επίλυση ουρών που εκκρεμούν';
$string['search:activity'] = 'Ομαδοεργαλείο - πληροφορίες δραστηριότητας';
$string['select'] = 'Επιλογή';
$string['selected'] = 'Επιλεγμένα';
$string['selectfromcohort'] = 'Επιλογή μελών από ομάδα χρηστών';
$string['selectmultiple'] = 'επιλογή πολλών';
$string['selectsingle'] = 'επιλογή ενός/μίας';
$string['selfregistration'] = 'Καταχώριση';
$string['selfregistration_alt'] = 'Καταχώριση σε μία ή περισσότερες ομάδες (ανάλογα με τις ρυθμίσεις)';
$string['setactive'] = 'Ενεργοποίηση';
$string['setinactive'] = 'Απενεργοποίηση';
$string['show_members'] = 'Εμφάνιση μελών ομάδας';
$string['show_members_help'] = 'Επιτρέπει στους μαθητές (υπό συγκεκριμένες συνθήκες) να βλέπουν ποιοι είναι ήδη καταχωρημένοι σε μια ομάδα.<br />
<ul>
<li><strong>Όχι:</strong> να μην εμφανίζονται τα μέλη ομάδων καθόλου</li>
<li><strong>Όλα - μετά την ημερομηνία λήξης:</strong> εμφάνιση των μελών των ομάδων για όλες τις ομάδες μετά την λήξη της προθεσμίας</li>
<li><strong>Ίδιας ομάδας - μετά την ημερομηνία λήξης:</strong>εμφάνιση των μελών των ομάδων του χρήστη μετά την ημερομηνία λήξης της προθεσμίας</li>
<li><strong>Ίδιας ομάδας - μετά την καταχώρηση:</strong> εμφάνιση μελών των ομάδων του χρήστη αφού έχει καταχωριστεί μόνος του ή από κάποιον άλλο</li>
<li><strong>Ναι:</strong> εμφάνιση των μελών των ομάδων</li>
</ul>';
$string['showafterdue'] = 'Όλα - μετά από την προθεσμία';
$string['showownafterdue'] = 'Ιδίων - μετά την προθεσμία';
$string['showownafterreg'] = 'Ιδίων - μετά την καταχώριση';
$string['size'] = 'Μέγεθος ομάδας';
$string['size_grp'] = 'Ρυθμίσεις μεγέθους ομάδας';
$string['size_grp_help'] = 'Εάν ενεργοποιηθεί το μέγεθος ομάδας, ο μέγιστος αριθμός μελών για κάθε ομάδα περιορίζεται (ρυθμίζεται για ολόκληρο το στιγμιότυπο μέσω πεδίου κειμένου). Εάν επιπρόσθετα ενεργοποιηθεί το «ιδιαίτερο μέγεθος», το μέγεθος ομάδας για κάθε ομάδα μπορεί να οριστεί στην ακόλουθη λίστα.';
$string['skip_user_import'] = 'Παράληψη για εισαγωγή';
$string['skipped'] = 'Παραλείφθηκε';
$string['sortlist_no_data'] = 'Δεν υπάρχει καμία ομάδα αυτή τη στιγμή!';
$string['source'] = 'Πηγή';
$string['source_missing'] = 'Δεν υπάρχει καμία πηγή από την οποία να γίνει αντιγραφή!';
$string['sources_missing'] = 'Υπάρχει τουλάχιστον 1 ομάδα χωρίς επιλεγμένη πηγή από την οποία να γίνει αντιγραφή!';
$string['start'] = 'Έναρξη';
$string['status'] = 'Κατάσταση';
$string['status_help'] = '<ul>
<li><strong>✔</strong> καταχωρισμένοι στην Moodle-ομάδα και στο ομαδοεργαλείο</li>
<li><strong>?</strong> καταχωρισμένοι σε Moodle-ομάδα αλλά όχι σε ομαδοεργαλείο</li>
<li><strong>+</strong> καταχωρισμένοι στο ομαδοεργαλείο αλλά όχι σε Moodle-ομάδα</li>
<li><strong>1, 2, 3... </strong> σε ουρά στο ομαδοεργαλείο</li>
</ul>';
$string['successfully_deleted_groups'] = 'Διαγραφή ομάδων επιτυχής!';
$string['swapped_groups'] = 'Ανταλλαγή ομάδων <strong>{$a->a}</strong> (διάταξη <strong>{$a->aorder}</strong>) και <strong>{$a->b}</strong> (διάταξη <strong>{$a->border}</strong>)!';
$string['switched_to_all_groups'] = 'Το φίλτρο ομάδας άλλαξε σε όλες τις ομάδες!';
$string['target'] = 'Στόχος';
$string['too_many_queue_places'] = 'Ο/Η χρήστης <strong>{$a->username}</strong> δεν μπορεί να προστεθεί στην ουρά για την ομάδα <strong>{$a->groupname}</strong> διότι είναι ήδη σε ουρά για πάρα πολλές ομάδες!';
$string['too_many_regs'] = 'Ο χρήστης είναι καταχωρισμένος/σε ουρά σε πάρα πολλές ομάδες ήδη!';
$string['toolessregspresent'] = 'Τουλάχιστον 1 χρήστης έχει καταχωρηθεί σε πολύ λιγότερες ομάδες, επομένως οι ελάχιστες ομάδες για να επιλέξετε πρέπει να είναι το πολύ {$a}.';
$string['toomanyregs'] = 'Προσοχή: Σε τουλάχιστον μία ομάδα υπάρχουν περισσότερα μέλη ομάδας από αυτά που καθορίζονται από το επιθυμητό νέο μέγεθος ομάδας.< br />Μειώστε τα μέλη ομάδας στις ομάδες πριν αλλάξετε το μέγεθος της ομάδας.';
$string['toomanyregspresent'] = 'Τουλάχιστον 1 χρήστης έχει καταχωριστεί σε πάρα πολλές ομάδες, επομένως ο μέγιστος αριθμός ομάδων για να επιλέξετε πρέπει να είναι τουλάχιστον {$a}.';
$string['total'] = 'Σύνολο';
$string['unqueue'] = 'Αφαίρεση από ουρά';
$string['unqueue_from_group'] = 'Συνέχεια αφαίρεσης του/της <strong>{$a->username}</strong> από την ουρά της ομάδας <strong>{$a->groupname}</strong>;';
$string['unqueue_from_group_success'] = 'Επιτυχής αφαίρεση του/της <strong>{$a->username}</strong> από την ουρά της ομάδας <strong>{$a->groupname}</strong>!';
$string['unqueue_you_from_group'] = 'Συνέχεια αφαίρεσής σας από την ουρά της ομάδας <strong>{$a->groupname}</strong>;';
$string['unqueue_you_from_group_success'] = 'Επιτυχής αφαίρεσή σας από την ουρά της ομάδας <strong>{$a->groupname}</strong>!';
$string['unreg'] = 'Κατάργηση καταχώρισης';
$string['unreg_from_group'] = 'Συνέχεια κατάργησης καταχώρισης του/της <strong>{$a->username}</strong> από την ομάδα <strong>{$a->groupname}</strong>;';
$string['unreg_from_group_success'] = 'Επιτυχής κατάργηση καταχώρισης του/της <strong>{$a->username}</strong> από την ομάδα <strong>{$a->groupname}</strong>!';
$string['unreg_is'] = 'Κατάργηση καταχώρισης';
$string['unreg_not_allowed'] = 'Η κατάργηση καταχώρισης δεν επιτρέπεται!';
$string['unreg_you_from_group'] = 'Να συνεχιστεί η κατάργηση καταχώρισής σας από την ομάδα <strong>{$a->groupname}</strong>;';
$string['unreg_you_from_group_success'] = 'Η κατάργηση καταχώρισής σας από την ομάδα <strong>{$a->groupname}</strong> έγινε με επιτυχία!';
$string['unregfrommgroups'] = 'Επιβολή κατάργησης καταχώρισης από το ομαδοεργαλείο';
$string['unregfrommgroups_help'] = 'Κατάργηση καταχώρισης όχι μόνο από το ομαδοεργαλείο, αλλά και από την ομάδα του Moodle.';
$string['unregister'] = 'Κατάργηση καταχώρισης';
$string['unregister_conflict_user_not_in_group'] = 'Ο/Η χρήστης <strong>{$a->fullname}</strong> δεν ανήκει στην ομάδα <strong>{$a->groupname}</strong>!';
$string['unregister_desc'] = 'Κατάργηση καταχώρισης πολλαπλών χρηστών';
$string['unregister_from_inactive_group_warning'] = 'Σημείωση: Η ομάδα <strong>{$a}</strong> είναι προς το παρόν ανενεργή στο πλαίσιο του ομαδοεργαλείου και επομένως δεν θα εμφανίζεται.';
$string['unregister_in_inactive_group_warning'] = 'Σημείωση: Η ομάδα <strong>{$a}</strong> είναι προς το παρόν ανενεργή στο πλαίσιο του ομαδοεργαλείου και επομένως δεν θα εμφανίζεται.';
$string['unregister_progress_completed'] = 'Η κατάργηση καταχώρισης ολοκληρώθηκε';
$string['unregister_progress_preview_completed'] = 'Η προεπισκόπηση κατάργησης καταχώρισης ολοκληρώθηκε';
$string['unregister_progress_start'] = 'Έναρξη κατάργησης καταχώρισης';
$string['unregister_progress_unregister'] = 'Κατάργηση καταχώρισης χρήστη';
$string['unregister_skipped'] = 'Παράλειψη του/της χρήστη <strong>{$a->fullname}</strong> από την ομάδα <strong>{$a->groupname}</strong>!';
$string['unregister_user'] = 'Η κατάργηση καταχώρισης του/της <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) από την ομάδα <strong>{$a->groupname}</strong> έγινε με επιτυχία.';
$string['unregister_user_from_moodle_group'] = 'Η κατάργηση καταχώρησης του/της <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) από την ομάδα moodle <strong>{$a->groupname}</strong> πέτυχε .';
$string['unregister_user_not_in_group'] = 'Ο/Η χρήστης <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) δεν βρίσκεται στην ομάδα <strong>{$a->groupname}</strong>!';
$string['unregister_user_only_in_moodle_group'] = 'Ο/Η χρήστης <strong>{$a->fullname}</strong> είναι μόνο στην ομάδα moodle <strong>{$a->groupname}</strong> αλλά όχι στην ομάδα ομαδοεργαλείου!';
$string['unregister_user_prev'] = 'Να συνεχιστεί η κατάργηση της καταχώρισης του/της <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) από την ομάδα <strong>{$a->groupname}</strong>;';
$string['unregisterbutton'] = 'Κατάργηση καταχώρισης χρηστών';
$string['update_grouplist_success'] = 'Οι ενεργές ομάδες ενημερώθηκαν επιτυχώς!';
$string['updatemdlgrps'] = 'Καταχώριση στις ομάδες moodle';
$string['uptodate'] = 'ενημερωμένο';
$string['use_all_or_chosen'] = 'Χρήση όλων ή επιλεγμένων';
$string['use_all_or_chosen_help'] = 'Επιλέξτε «Όλες» για να δημιουργήσετε μια ομαδοποίηση για κάθε ομάδα μαθημάτων. Χρησιμοποιήστε το «Επιλεγμένες» για να δημιουργήσετε ομαδοποιήσεις μόνο για τις επιλεγμένες ομάδες.';
$string['use_individual'] = 'Χρήση διαφορετικού μεγέθους ανά ομάδα';
$string['use_individual_help'] = 'Παράκαμψη γενικού μεγέθους ομάδας με διαφορετική τιμή για κάθε ομάδα. Αυτές ορίζονται μέσω της λίστας ομάδων με δυνατότητα ταξινόμησης, στο κάτω μέρος.';
$string['use_queue'] = 'Χρήση ουρών';
$string['use_queue_help'] = 'Οι μαθητές μπορούν να κάνουν ουρά για ήδη πλήρεις ομάδες. Αυτή η ρύθμιση μπορεί να χρησιμοποιηθεί μόνο εάν είναι ενεργοποιημένη η αυτόματη καταχώριση και έχει οριστεί όριο μεγέθους ομάδας.';
$string['use_size'] = 'Ενεργοποίηση';
$string['user_has_too_less_regs'] = 'Η κατάργηση καταχώρισης/τοποθέτησης σε ουρά δεν είναι δυνατή επειδή ο/η <strong>{$a->username}</strong> βρίσκεται καταχωρισμένος/σε ουρά σε πολύ λιγότερες ομάδες!';
$string['user_is_deleted'] = 'Ο λογαριασμός χρήστη που βρέθηκε (Αναγνωριστικό <strong>{$a->id}</strong>, Όνομα <strong>{$a->fullname}</strong>) έχει ήδη διαγραφεί. Επομένως, η εγγραφή σε αυτό το μάθημα δεν είναι δυνατή.';
$string['user_move_prev'] = 'Ο/Η χρήστης <strong>{$a->user}</strong> θα μετακινηθεί από την ουρά για την ομάδα <strong>{$a->from_group}</strong> στην (ουρά για την) ομάδα <strong>{$a->to_group}</strong>!';
$string['user_moved'] = 'Ο/Η χρήστης <strong>{$a->user}</strong> έχει μετακινηθεί από την ουρά για την ομάδα <strong>{$a->from_group}</strong> στην (ουρά για την) ομάδα <strong>{$a->to_group}</strong>!';
$string['user_not_found'] = 'Αδυναμία εύρεσης του/της χρήστη <strong>{$a}</strong>!';
$string['userlist'] = 'Λίστα χρηστών';
$string['userlist_alt'] = 'Εμφάνιση λίστας χρηστών και των καταχωρίσεών τους. Εξαγωγή δεδομένων σχετικά με τους χρήστες και τις ομάδες τους σε διαφορετικούς μορφότυπους (PDF, απλό κείμενο, Excel κ.λπ.).';
$string['userlist_help'] = 'Λίστα αναγνωριστικών αριθμών διαχωρισμένων με έναν ή περισσότερους από τους ακόλουθους χαρακτήρες <ul><li>[,] κόμμα</li><li>[;] ερωτηματικό</li><li>[ ] κενό διάστημα</li><li>[\\n] νέα γραμμή</li><li>[\\r] επαναφορά φορείου (carriage return)</li><li>[\\t] στηλοθέτης (tab)</li></ul>';
$string['userlist_tab'] = 'Εμφάνιση μαθήματος';
$string['userlist_tab_alt'] = 'Άνοιγμα εμφάνισης μαθήματος';
$string['users_queues_limit'] = 'Θέσεις ουράς ανά χρήστη';
$string['users_queues_limit_help'] = 'Περιορίζει τις διαθέσιμες θέσεις ουράς ανά χρήστη, εάν ενεργοποιηθεί';
$string['users_tab'] = 'Συμμετέχοντες';
$string['users_tab_alt'] = 'Εμφάνιση Συμμετεχόντων';
$string['view_registrations'] = 'Εμφάνιση καταχωρίσεων';
$string['viewmoodlegroups'] = 'Στις ομάδες Moodle';
$string['with_selection'] = 'Με τις επιλεγμένες...';
$string['you_are_already_marked'] = 'Έχετε ήδη επισημάνει την ομάδα <strong>{$a->groupname}</strong> για καταχώριση!';
$string['you_are_already_queued'] = 'Βρίσκεστε ήδη σε ουρά για την ομάδα <strong>{$a->groupname}</strong>!';
$string['you_are_already_registered'] = 'Είστε ήδη καταχωρισμένοι στην ομάδα <strong>{$a->groupname}</strong>!';
$string['you_are_not_in_queue_or_registered'] = 'Δεν έχετε καταχωριστεί ούτε έχετε τοποθετηθεί σε ουρά για την ομάδα <strong>{$a->groupname}</strong>';
$string['you_change_group_to_success'] = 'Επιτυχής αλλαγή ομάδας! Είστε πλέον καταχωρισμένοι στην ομάδα <strong>{$a->groupname}</strong>!';
$string['you_have_too_less_regs'] = 'Η κατάργηση καταχώρησης/αφαίρεση από την ουρά δεν είναι δυνατή, επειδή έχετε καταχωριστεί/τοποθετηθεί σε ουρά σε πολύ λιγότερες ομάδες!';
$string['you_have_too_many_queue_places'] = 'Δεν είναι δυνατή η τοποθέτησή σας σε ουρά για την ομάδα <strong>{$a->groupname}</strong>, επειδή βρίσκεστε ήδη σε ουρά σε πάρα πολλές ομάδες!';
$string['your_place_allocated_in_group_success'] = 'Επισημάνατε με επιτυχία την ομάδα <strong>{$a->groupname}</strong> για καταχώριση';
