<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'ar', version '3.11'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'لديك جلسات قادمة لغرف  BBB';
$string['bbbduetimeoverstartingtime'] = 'وقت استحقاق هذا النشاط ينبغي أن يكون بعد تاريخ البدء';
$string['bbbdurationwarning'] = 'أقصى مدة لهذه الجلسة هي %duration% دقيقة.';
$string['bbbrecordallfromstartwarning'] = 'يتم تسجيل هذه الجلسة من البداية.';
$string['bbbrecordwarning'] = 'قد يتم تسجيل هذه الجلسة.';
$string['bigbluebuttonbn'] = 'غرف اجتماعات BBB';
$string['bigbluebuttonbn:addinstance'] = 'إضافة غرفة/نشاط جديد من BBB';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'إنشاء مثيلات من الجلسات المباشرة';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'إنشاء مثيلات ذات إمكانيات التسجيل';
$string['bigbluebuttonbn:deleterecordings'] = 'حذف التسجيلات';
$string['bigbluebuttonbn:importrecordings'] = 'استيراد التسجيلات';
$string['bigbluebuttonbn:join'] = 'انضم إلى اجتماع غرف  BBB';
$string['bigbluebuttonbn:managerecordings'] = 'إدارة تسجيلات غرف اجتماعات BBB';
$string['bigbluebuttonbn:protectrecordings'] = 'حماية التسجيلات';
$string['bigbluebuttonbn:publishrecordings'] = 'نشر التسجيلات';
$string['bigbluebuttonbn:unprotectrecordings'] = 'إلغاء حماية التسجيلات';
$string['bigbluebuttonbn:unpublishrecordings'] = 'إلغاء نشر التسجيلات';
$string['bigbluebuttonbn:view'] = 'معاينة غرفة BBB';
$string['cachedef_currentfetch'] = 'بيانات لاستعراض أي تسجيلات تم جلبها مؤخرًا.';
$string['cachedef_recordings'] = 'البيانات الوصفية للتسجيل';
$string['cachedef_serverinfo'] = 'معلومات المخدم البعيد';
$string['cachedef_validatedurls'] = 'خبء عمليات التحقق من عناوين الروابط';
$string['calendarstarts'] = '{$a} مجدول لغرض';
$string['cannotperformaction'] = 'يتعذر القيام بإجراء {$a} لهذا التسجيل';
$string['completionattendance'] = 'يجب على الطالب حضور الاجتماع من أجل:';
$string['completionattendance_desc'] = 'على الطالب دخول الغرفة والبقاء في جلستها لمدة {$a} من الدقائق على الأقل';
$string['completionattendance_event_desc'] = 'قام الطالب بدخول الغرفة والبقاء في جلستها لمدة {$a} من الدقائق على الأقل';
$string['completionattendancegroup'] = 'تتطلب الحضور';
$string['completionattendancegroup_help'] = 'حضور الاجتماع لمدة (س) من الدقائق مطلوب للإكمال';
$string['completionengagement_desc'] = 'على الطالب الانخراط في النشاطات خلال الاجتماع';
$string['completionengagementchats'] = 'أحداث الدردشة';
$string['completionengagementchats_desc'] = 'على الطالب المشاركة في {$a} من المحادثات لإكماله';
$string['completionengagementchats_event_desc'] = 'قد أثار {$a} من المحادثات';
$string['completionengagementemojis'] = 'الرموز التعبيرية';
$string['completionengagementemojis_desc'] = 'على الطالب إرسال {$a} من الرموز التعبيرية في الاستطلاعات لإكماله.';
$string['completionengagementemojis_event_desc'] = 'قد أثار {$a} من الرموز التعبيرية';
$string['completionengagementgroup'] = 'تتطلب المشاركة';
$string['completionengagementgroup_help'] = 'المشاركة النشطة خلال الجلسة مطلوبة للإكمال';
$string['completionengagementpollvotes'] = 'أصوات الاستبيان';
$string['completionengagementpollvotes_desc'] = 'على الطالب التصويب في الاستطلاعات {$a} من المرات لإكماله.';
$string['completionengagementpollvotes_event_desc'] = 'قد أثار {$a} من تصويتات الاستطلاعات';
$string['completionengagementraisehand'] = 'أحداث رفع اليد';
$string['completionengagementraisehand_desc'] = 'على الطالب رفع اليد {$a} من المرات لإكماله.';
$string['completionengagementraisehand_event_desc'] = 'قد رفع اليد {$a} من المرات';
$string['completionengagementtalks'] = 'أحداث الحديث';
$string['completionengagementtalks_desc'] = 'على الطالب التحدث {$a} من المرات لإكماله';
$string['completionengagementtalks_event_desc'] = 'قد أثار {$a} من الأحاديث';
$string['completionupdatestate'] = 'حالة تحديث الإكمال';
$string['completionvalidatestate'] = 'تحقق من الإكمال';
$string['completionvalidatestatetriggered'] = 'تم تشغيل التحقق من الإكمال.';
$string['completionview'] = 'يتطلب المعاينة';
$string['completionview_desc'] = 'يجب على الطالب مشاهدة الغرفة لإكمالها.';
$string['completionview_event_desc'] = 'شاهدَ صفحة الغرفة.';
$string['config_checksum_algorithm'] = 'خوارزمية اختبار صحة BigBlueButton';
$string['config_default_messages'] = 'الرسائل الافتراضية';
$string['config_default_messages_description'] = 'ضبط إفتراضيات الرسائل للنشاطات';
$string['config_disablecam_default'] = 'تعطيل الكامرة مُمَكَّن إفتراضيًا';
$string['config_disablecam_default_description'] = 'عند تمكينه، سيتم تعطيل كامرات الويب.';
$string['config_disablecam_editable'] = 'تعطيل الكامرة يمكن تحريره';
$string['config_disablecam_editable_description'] = 'تعطيل الكامرة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_disablemic_default'] = 'تعطيل اللاقطة مُمَكَّن إفتراضيًا';
$string['config_disablemic_default_description'] = 'عند تمكينه، سيتم تعطيل اللاقطات.';
$string['config_disablemic_editable'] = 'تعطيل اللاقطة يمكن تحريره';
$string['config_disablemic_editable_description'] = 'تعطيل اللاقطة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_disablenote_default'] = 'تعطيل الملاحظات المشتركة مُمَكَّن إفتراضيًا';
$string['config_disablenote_default_description'] = 'عند تمكينه، سيتم تعطيل الملاحظات المشتركة.';
$string['config_disablenote_editable'] = 'تعطيل الملاحظات المشتركة يمكن تحريره';
$string['config_disablenote_editable_description'] = 'تعطيل الملاحظات المشتركة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_disableprivatechat_default'] = 'تعطيل المحادثة الخاصة مُمَكَّن إفتراضيًا';
$string['config_disableprivatechat_default_description'] = 'عند تمكينه، سيتم تعطيل المحادثة الخاصة.';
$string['config_disableprivatechat_editable'] = 'تعطيل المحادثة الخاصة يمكن تحريره';
$string['config_disableprivatechat_editable_description'] = 'تعطيل المحادثة الخاصة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_disablepublicchat_default'] = 'تعطيل المحادثة العامة مُمَكَّن إفتراضيًا';
$string['config_disablepublicchat_default_description'] = 'عند تمكينه، سيتم تعطيل المحادثة العامة.';
$string['config_disablepublicchat_editable'] = 'تعطيل المحادثة العامة يمكن تحريره';
$string['config_disablepublicchat_editable_description'] = 'تعطيل المحادثة العامة إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_experimental_features'] = 'التهيئة للمزايا التجريبية';
$string['config_experimental_features_description'] = 'التهيئة للمزايا التجريبية.';
$string['config_extended_capabilities'] = 'التهيئة للإمكانات الموسعة';
$string['config_extended_capabilities_description'] = 'التهيئة للإمكانات الموسعة عندما يقدمها مخدم غرف اجتماعات BBB.';
$string['config_general'] = 'التهيئة العامة';
$string['config_general_description'] = 'هذه الإعدادات مستعملة <b>دائماً</b>';
$string['config_hideuserlist_default'] = 'إخفاء قائمة المستخدمين مُمَكَّن إفتراضيًا';
$string['config_hideuserlist_default_description'] = 'عند تمكينه، ستكون قائمة المستخدمين في الجلسة مخفية.';
$string['config_hideuserlist_editable'] = 'إخفاء قائمة المستخدمين يمكن تحريره';
$string['config_hideuserlist_editable_description'] = 'إخفاء قائمة المستخدمين إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_importrecordings'] = 'التهيئة لميزة "استيراد التسجيلات"';
$string['config_importrecordings_description'] = 'هذه الإعدادات متخصصة بالميزة';
$string['config_importrecordings_enabled'] = 'استيراد التسجيلات مُمَكَّن';
$string['config_importrecordings_enabled_description'] = 'عند تمكينه مع تمكين ميزة التسجيل، سيكون ممكنًا استيراد التسجيلات من مقررات مختلفة إلى النشاط.';
$string['config_importrecordings_from_deleted_enabled'] = 'استيراد التسجيلات من نشاطات محذوفة مُمَكَّن';
$string['config_importrecordings_from_deleted_enabled_description'] = 'عند تمكين ميزة التسجيل والاستيراد ، فمن الممكن استيراد التسجيلات من الأنشطة التي لم تعد موجودة في المقرر الدراسي.';
$string['config_lockonjoin_default'] = 'تم تمكين القفل عند الانضمام افتراضيًا';
$string['config_lockonjoin_default_description'] = 'في حالة التمكين ، يتم تطبيق الإعدادات التي تم تأمينها بواسطة التكوين على المستخدم عند انضمامه. يجب تمكين تكوين القفل حتى يتم تطبيق هذا.';
$string['config_lockonjoin_editable'] = 'يمكن تحرير القفل عند الانضمام';
$string['config_lockonjoin_editable_description'] = 'يمكن تحرير القفل عند الانضمام افتراضيًا عند إضافة المثيل أو تحديثه.';
$string['config_locksettings'] = 'التهيئة لإعدادات التأمين';
$string['config_locksettings_description'] = 'هذه الإعدادات تُمكن أو تُعطل الخيارات في واجهة المستخدم لإعدادات التأمين، وكذلك تعريف القيم الافتراضية لتلك الخيارات.';
$string['config_meetingevents_enabled'] = 'تسجيل الأحداث المباشرة';
$string['config_meetingevents_enabled_description'] = 'تمكين الملحق من قبول ومعالجة الأحداث المباشرة بعد انتهاء الجلسة. (ينبغي تمكينها من أجل "إكمال النشاط" وستكون جاهزة فقط عندما تكون لمخدم غرف  BBB إمكانية معالجة نصوص post_events)';
$string['config_muteonstart'] = 'التهيئة لميزة "الكتم عند البدء"';
$string['config_muteonstart_default'] = 'الكتم عند البدء مُمَكَّن إفتراضيًا';
$string['config_muteonstart_default_description'] = 'عند تمكينه، الجلسة ستكون مكتومة عند بدئها.';
$string['config_muteonstart_description'] = 'هذه الإعدادات تُمكن أو تُعطل الخيارات في واجهة المستخدم، وكذلك تعريف القيم الافتراضية لتلك الخيارات.';
$string['config_muteonstart_editable'] = 'الكتم عند البدء يمكن تحريره';
$string['config_muteonstart_editable_description'] = 'يمكن تحرير كتم الصوت عند البدء إفتراضيًا عند إضافة المثيل أو تحديثه.';
$string['config_participant'] = 'تهيئة المشاركين';
$string['config_participant_description'] = 'هذه الإعدادات تُعرف الدور الافتراضي للمشاركين في المؤتمر.';
$string['config_participant_moderator_default'] = 'مشرف';
$string['config_participant_moderator_default_description'] = 'تسعمل هذه القاعدة إفتراضيًا عند إضافة غرفة جديدة.';
$string['config_presentation_default'] = 'الملف الافتراضي لميزة "الرفع المسبق للعرض التقديمي"';
$string['config_presentation_default_description'] = 'يسمح هذا الإعداد بتحديد الملف المستعمل تلقائيًا في كل مثيلات غرف اجتماعات BBB إذا تم تمكين "الرفع المسبق للعرض التقديمي".';
$string['config_preuploadpresentation'] = 'التهيئة لميزة "الرفع المسبق للعرض التقديمي"';
$string['config_preuploadpresentation_description'] = 'تعمل هذه الإعدادات على تمكين أو تعطيل الخيارات في واجهة المستخدم وكذلك تحديد القيم الافتراضية لهذه الخيارات. تعمل الميزة فقط إذا كان مخدم مودل قابل للوصول إليه من قبل غرف  BBB..';
$string['config_preuploadpresentation_editable'] = 'التحميل المسبق للعرض قابل للتحرير';
$string['config_preuploadpresentation_editable_description'] = 'ميزة التحميل المسبق للعرض قابلة للتعديل في واجهة المستخدم عند إضافة أو تحديث الغرفة أو المؤتمر.';
$string['config_recording'] = 'التهيئة لميزة "تسجيل الاجتماع"';
$string['config_recording_all_from_start_default'] = 'تسجيل الكل منذ البدء';
$string['config_recording_all_from_start_default_description'] = 'هل يجب تمكين الإعداد "بدء التسجيل من البداية" افتراضيًا عند إضافة غرفة BBB جديدة؟';
$string['config_recording_all_from_start_editable'] = 'تسجيل الكل منذ البدء يمكن تحريره';
$string['config_recording_all_from_start_editable_description'] = 'هل يجب أن يكون "بدء التسجيل من البداية" قابلاً للتعديل في إعدادات نشاط BBB؟';
$string['config_recording_default'] = 'ميزة التسجيل مُمَكَّنة إفتراضيًا';
$string['config_recording_default_description'] = 'هل يجب تمكين الإعداد "يمكن تسجيل الجلسة" افتراضيًا عند إضافة غرفة BBB جديدة؟';
$string['config_recording_description'] = 'هذه الإعدادات متخصصة بالميزة';
$string['config_recording_editable'] = 'ميزة التسجيل يمكن تحريرها';
$string['config_recording_editable_description'] = 'هل يجب أن تكون "الجلسة يمكن تسجيلها" قابلة للتعديل في إعدادات نشاط BBB؟';
$string['config_recording_hide_button_default'] = 'زر إخفاء التسجيل';
$string['config_recording_hide_button_default_description'] = 'عند تأشيره، زر التسجيل سيتم إخفاؤه.';
$string['config_recording_hide_button_editable'] = 'إخفاء زر التسجيل يمكن تحريره';
$string['config_recording_hide_button_editable_description'] = 'هل يجب أن يكون "إخفاء زر التسجيل" قابلاً للتعديل في إعدادات نشاط BBB؟';
$string['config_recording_protect_editable'] = 'حالة التسجيلات المحمية يمكن تحريرها';
$string['config_recording_protect_editable_description'] = 'عند تأشيره، ستتضمن الواجهة خيارًا لحماية/إلغاء حماية التسجيلات.';
$string['config_recording_refresh_period'] = 'مهلة تنشيط التسجيل (بالثواني)';
$string['config_recording_refresh_period_description'] = 'ما هو تواتر استقدام البيانات من مخدم Bigbluebutton لتحديث المعلومات لدى المستخدمين بالنسبة إلى التسجيل؟';
$string['config_recordingready_enabled'] = 'إرسال الإشعارات عند جهوزية التسجيل';
$string['config_recordingready_enabled_description'] = 'تمكين الملحق من إرسال الإشعارات عندما يصير التسجيل جاهزاً. (هذا يصلح فقط عند تمكين النص البرمجي post_publish_recording_ready_callback في مخدم غرف  BBB)';
$string['config_recordings'] = 'التهيئة لميزة "إظهار التسجيلات"';
$string['config_recordings_description'] = 'هذه الإعدادات متخصصة بالميزة';
$string['config_recordings_general'] = 'إظهار إعدادات التسجيل';
$string['config_recordings_general_description'] = 'تستعمل هذه الإعدادات فقط عند إظهار التسجيلات';
$string['config_recordings_imported_default'] = 'إظهار الروابط المستوردة فقط مُمَكَّن إفتراضيًا';
$string['config_recordings_imported_default_description'] = 'عند تمكينه، جدول التسجيل سيتضمن الروابط المستوردة للتسجيلات فقط.';
$string['config_recordings_imported_editable'] = 'إظهار الروابط المستوردة فقط يمكن تحريره';
$string['config_recordings_imported_editable_description'] = 'إظهار الروابط المستوردة فقط إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحديثه.';
$string['config_recordings_preview_default'] = 'المعاينة مُمَكَّنة إفتراضيًا';
$string['config_recordings_preview_default_description'] = 'عند تمكينه، سيتضمن الجدول معاينة للعرض التقديمي.';
$string['config_recordings_preview_editable'] = 'يمكن تحرير ميزة المعاينة';
$string['config_recordings_preview_editable_description'] = 'يمكن تحرير ميزة المعاينة عند إضافة النشاط أو تحديثه.';
$string['config_recordings_sortorder'] = 'ترتيب التسجيلات ترتيباً تصاعدياً.';
$string['config_recordings_sortorder_description'] = 'إفتراضيًا، يتم عرض التسجيلات تنازلياً. عند التأشير، ستترتب تصاعدياً.';
$string['config_scheduled'] = 'التهيئة لـ "الجلسات المجدولة"';
$string['config_scheduled_description'] = 'تحدد هذه الإعدادات بعض السلوك الافتراضي للجلسات المجدولة.';
$string['config_scheduled_pre_opening'] = 'متاح قبل وقت الفتح (بالدقائق)';
$string['config_scheduled_pre_opening_description'] = 'الوقت بالدقائق الذي تكون فيه الجلسة متاحة للوصول إليها قبل موعد فتحها.';
$string['config_sendnotifications'] = 'التهيئة لميزة "إرسال الإشعارات"';
$string['config_sendnotifications_description'] = 'هذه الإعدادات تقوم بتمكين الخيارات أو تعطيلها في واجهة المستخدم كما تُعرِّف القيم الافتراضية لتلك الخيارات.';
$string['config_sendnotifications_enabled'] = 'إرسال الإشعارات مُمَكَّن';
$string['config_sendnotifications_enabled_description'] = 'عند تمكينه، واجهة المستخدم لتحرير النشاط ستتضمن خيار إرسال الإشعارات إلى المستخدمين المنضمين عند إضافة النشاط أو تحريره.';
$string['config_server_url'] = 'عنوان الرابط لمخدم غرف  BBB';
$string['config_server_url_description'] = 'يجب أن ينتهي عنوان الرابط لمخدم غرف  BBB بـ /bigbluebutton/. (عنوان الرابط الافتراضي هذا مخصص لمخدم غرف  BBB الذي توفره Blindside Networks والذي يمكنك استعماله لأغراض الاختبار).';
$string['config_shared_secret'] = 'السر المشارك لـ BBB';
$string['config_shared_secret_description'] = 'الشفرة الفريدة لمخدم غرف  BBB. (هذ الشفرة الفريدة هي لمخدم غرف  BBB الذي توفره Blindside Networks والذي يمكنك استعماله لأغراض الاختبار).';
$string['config_uidelegation_enabled'] = 'تفويض واجهة المستخدم مُمَكَّن';
$string['config_uidelegation_enabled_description'] = 'تعمل هذه الإعدادات على تمكين أو تعطيل تفويض واجهة المستخدم لمخدم غرف اجتماعات BBB.';
$string['config_userlimit'] = 'التهيئة لميزة "تحديد المستخدمين"';
$string['config_userlimit_default'] = 'تحديد المستخدمين مُمَكَّن إفتراضيًا';
$string['config_userlimit_default_description'] = 'عدد المستخدمين المسموح لهم في الجلسة إفتراضيًا عند إضافة الغرفة الجديدة أو المؤتمر. إذا تم جعله 0، لن يكون هناك تحديد لعددهم.';
$string['config_userlimit_description'] = 'هذه الإعدادات تقوم بتمكين الخيارات أو تعطيلها في واجهة المستخدم كما تُعرِّف القيم الافتراضية لتلك الخيارات.';
$string['config_userlimit_editable'] = 'ميزة تحديد المستخدمين يمكن تحريرها';
$string['config_userlimit_editable_description'] = 'تحديد عدد المستخدمين إفتراضيًا يمكن تحريره عند إضافة المثيل أو تحريره.';
$string['config_voicebridge'] = 'التهيئة لميزة "الجسر الصوتي"';
$string['config_voicebridge_description'] = 'هذه الإعدادات تقوم بتمكين الخيارات أو تعطيلها في واجهة المستخدم كما تُعرِّف القيم الافتراضية لتلك الخيارات.';
$string['config_voicebridge_editable'] = 'الجسر الصوتي للمؤتمر يمكن تحريره';
$string['config_voicebridge_editable_description'] = 'يمكن تعيين رقم الجسر الصوتي الثابت الخاص بالمؤتمر بشكل دائم إلى غرفة فيه. عند تعيينه، لا يمكن استعمال هذا الرقم مع أي غرفة أو مؤتمر آخر.';
$string['config_waitformoderator'] = 'إنتظار المشرف';
$string['config_waitformoderator_cache_ttl'] = 'مدة استبقاء الخبء لميزة انتظار المشرف (بالثواني)';
$string['config_waitformoderator_cache_ttl_description'] = 'لدعم عدد كبير من العملاء، يستعمل هذه الإضافة الخبء. يحدد هذا العامل الوقت الذي سيتم فيه الاحتفاظ بالخبء قبل إرسال الطلب التالي إلى مخدم غرف اجتماعات BBB.';
$string['config_waitformoderator_default'] = 'إنتظار المشرف مُمَكَّن إفتراضيًا';
$string['config_waitformoderator_default_description'] = 'ميزة انتظار المشرف مُمَكَّنة إفتراضيًا عند إضافة غرفة أو مؤتمر جديدين.';
$string['config_waitformoderator_description'] = 'هذه الإعدادات متخصصة بالميزة';
$string['config_waitformoderator_editable'] = 'ميزة انتظار المشرف يمكن تحريرها';
$string['config_waitformoderator_editable_description'] = 'هل يجب أن يكون "انتظار الوسيط" قابلاً للتعديل في إعدادات نشاط BBB؟';
$string['config_waitformoderator_ping_interval'] = 'مدة استغراق إرسال ping لميزة انتظار المشرف (بالثواني)';
$string['config_waitformoderator_ping_interval_description'] = 'عند تمكين ميزة انتظار المشرف، يقوم المستخدم باختبار حالة الجلسة كل [كذا] ثانية. تحدد هذه المعامل الفاصل الزمني بين الطلبات المقدمة إلى مخدم مودل.';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'يستعمل BBB الملف config.php مع متغير عام تم إهماله. يرجى تحويل الملف لأنه لن يتم دعمه في الإصدارات المستقبلية';
$string['config_warning_curl_not_installed'] = 'هذه الميزة تتطلب تنصيب الامتداد CURL في php وتمكينه. يمكن الوصول إلى الإعدادات فقط عند تلبية هذا الشرط.';
$string['config_welcome_default'] = 'رسالة الترحيب الافتراضية';
$string['config_welcome_default_description'] = 'يستبدل الرسالة الافتراضية الموضوعة مسبقاً لمخدم BBB. يمكن للرسالة أن تتضمن الكلمات المفتاحية (%%CONFNAME%%، %%DIALNUM%%، %%CONFNUM%%) والتي سيتم استبدالها تلقائيًا، وكذلك وسوم html مثل <b>...</b> أو <i></i>';
$string['config_welcome_editable'] = 'يمكن للمعلمين تعديل رسالة الترحيب الافتراضية';
$string['config_welcome_editable_description'] = 'يمكن تحرير رسالة الترحيب عند إضافة المثيل أو تحديثه';
$string['email_body_notification_meeting_by'] = 'من قِبَل';
$string['email_body_notification_meeting_description'] = 'الوصف';
$string['email_body_notification_meeting_details'] = 'التفاصيل';
$string['email_body_notification_meeting_end_date'] = 'تاريخ الانتهاء';
$string['email_body_notification_meeting_has_been'] = 'كان';
$string['email_body_notification_meeting_start_date'] = 'تاريخ البدء';
$string['email_body_notification_meeting_title'] = 'العنوان';
$string['email_body_recording_ready_for'] = 'التسجيل لـ';
$string['email_footer_sent_by'] = 'تم إرسال الإشعار التلقائي هذا بواسطة';
$string['email_footer_sent_from'] = 'من المقرر الدراسي';
$string['end_session_confirm'] = 'هل أنت متأكد من رغبتك في إنهاء الجلسة؟';
$string['end_session_confirm_title'] = 'أحقًا تريد إنهاء الجلسة؟';
$string['end_session_notification'] = 'لقد تم إنهاء الجلسة.';
$string['ends_at'] = 'ينتهي';
$string['event_activity_created'] = 'نشاط تم إنشاؤه';
$string['event_activity_deleted'] = 'نشاط تم حذفه';
$string['event_activity_updated'] = 'نشاط تم تحديثه';
$string['event_live_session'] = 'حدث الجلسة المباشرة';
$string['event_meeting_created'] = 'اجتماع تم إنشاؤه';
$string['event_meeting_ended'] = 'اجتماع  تم إنهاؤه قسرًا';
$string['event_meeting_joined'] = 'اجتماع تم الانضمام إليه';
$string['event_meeting_left'] = 'اجتماع تمت مغادرته';
$string['event_recording_deleted'] = 'تسجيل تم حذفه';
$string['event_recording_edited'] = 'تسجيل تم تعديله';
$string['event_recording_imported'] = 'تسجيل تم استيراده';
$string['event_recording_protected'] = 'تسجيل تمت حمايته';
$string['event_recording_published'] = 'تسجيل تم نشره';
$string['event_recording_unprotected'] = 'تسجيل تم إلغاء حمايته';
$string['event_recording_unpublished'] = 'تسجيل تم إلغاء نشره';
$string['event_recording_viewed'] = 'تسجيل تمت معاينته';
$string['event_unknown'] = 'حدث غير معلوم';
$string['general_error_cannot_create_meeting'] = 'يتعذرإنشاء الجلسة.';
$string['general_error_cannot_get_recordings'] = 'يتعذرإحضار التسجيلات.';
$string['general_error_no_answer'] = 'استجابة فارغة. لطفًا تحقق من عنوان رابط مخدم BigBlueButton وتأكد من كونه شغال فعلاً.';
$string['general_error_not_allowed_to_create_instances'] = 'لا يسمح للمستخدم بإنشاء أي نوع من المثيلات.';
$string['general_error_not_found'] = 'المكون غير موجود: {$a}.';
$string['general_error_unable_connect'] = 'غير قادر على الاتصال. يرجى التحقق من عنوان رابط مخدم غرف  BBB والتحقق لمعرفة ما إذا كان المخدم قيد التشغيل.';
$string['index_confirm_end'] = 'هل ترغب في إنهاء الصف الافتراضي؟';
$string['index_disabled'] = 'معطلة';
$string['index_enabled'] = 'مُمَكَّنة';
$string['index_ending'] = 'إنهاء الصف الافتراضي ... من فضلك إنتظر';
$string['index_error_bbtn'] = 'مُعرَّف غرف اجتماعات BBB {$a} غير صحيح';
$string['index_error_checksum'] = 'وقع خطأ عند فحص السلامة. تأكد من أنك قد أدخلت الشفرة الفريدة الصحيحة.';
$string['index_error_forciblyended'] = 'لا يمكن الانضمام إلى هذه الجلسة لأنه قد قم إنهاؤها يدويًا.';
$string['index_error_noinstances'] = 'لا توجد مثيلات من غرف  BBB';
$string['index_error_unable_display'] = 'يتعذر عرض . يرجى التحقق من عنوان الرابط لمخدم غرف اجتماعات BBB والتحقق لمعرفة ما إذا كان المخدم قيد التشغيل.';
$string['index_heading'] = 'غرف  BBB';
$string['index_heading_actions'] = 'الإجراءات';
$string['index_heading_group'] = 'المجموعة';
$string['index_heading_moderator'] = 'مشرفون';
$string['index_heading_name'] = 'الغرفة';
$string['index_heading_recording'] = 'التسجيل';
$string['index_heading_users'] = 'المستخدمون';
$string['index_heading_viewer'] = 'مشاهدون';
$string['indicator:cognitivedepth'] = 'BBB معرفيًا';
$string['indicator:cognitivedepth_help'] = 'هذا المؤشر مبني على عمق الحالة المعرفية التي وصل إليها الطالب في نشاط BBB.';
$string['indicator:socialbreadth'] = 'BBB إجتماعيًا';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصل إليه الطالب في نشاط BBB.';
$string['instance_type_default'] = 'الغرفة / النشاط مع التسجيلات';
$string['instance_type_recording_only'] = 'التسجيلات فقط';
$string['instance_type_room_only'] = 'الغرفة / النشاط فقط';
$string['instanceprofilewithoutrecordings'] = 'نسخة المثيل هذه لا يمكنها عرض التسجيلات';
$string['messageprovider:instance_updated'] = 'تم تحديث جلسة BBB';
$string['messageprovider:recording_ready'] = 'تسجيل BBB جاهز للمعاينة';
$string['minute'] = 'دقيقة';
$string['minutes'] = 'دقائق';
$string['mod_form_block_general'] = 'الإعدادات العامة';
$string['mod_form_block_participants'] = 'الدور المعين في أثناء الجلسة الحية';
$string['mod_form_block_presentation'] = 'محتوى العرض';
$string['mod_form_block_presentation_default'] = 'المحتوى الافتراضي للعرض التقديمي';
$string['mod_form_block_record'] = 'إعدادات التسجيل';
$string['mod_form_block_recordings'] = 'معاينة التسجيل';
$string['mod_form_block_room'] = 'إعدادات النشاط / الغرفة';
$string['mod_form_block_schedule'] = 'جدوِل الجلسة';
$string['mod_form_field_closingtime'] = 'الانضمام مغلق';
$string['mod_form_field_conference_name'] = 'اسم المؤتمر';
$string['mod_form_field_disablecam'] = 'تعطيل كاميرات الويب';
$string['mod_form_field_disablemic'] = 'تعطيل اللاقطات';
$string['mod_form_field_disablenote'] = 'تعطيل الملاحظات المشتركة';
$string['mod_form_field_disableprivatechat'] = 'تعطيل المحادثة الخاصة';
$string['mod_form_field_disablepublicchat'] = 'تعطيل المحادثة العامة';
$string['mod_form_field_duration'] = 'المدة الزمنية';
$string['mod_form_field_duration_help'] = 'سيؤدي تعيين مدة الاجتماع إلى تحديد أطول وقت يبقى فيه الاجتماع حياً قبل انتهاء التسجيل';
$string['mod_form_field_hideuserlist'] = 'إخفاء قائمة المستخدمين';
$string['mod_form_field_instanceprofiles'] = 'نوع المثيل';
$string['mod_form_field_instanceprofiles_help'] = 'حدد النوع لمثيل BBB هذا.';
$string['mod_form_field_intro'] = 'الوصف';
$string['mod_form_field_intro_help'] = 'وصف موجز للغرفة أو المؤتمر.';
$string['mod_form_field_lockonjoin'] = 'قفل الإعدادات عند الانضمام';
$string['mod_form_field_muteonstart'] = 'إكتم الصوت عند البدء';
$string['mod_form_field_name'] = 'اسم الفصل الافتراضي';
$string['mod_form_field_nosettings'] = 'لا يمكن تعديل أي إعدادات';
$string['mod_form_field_notification'] = 'قم بإشعار المستخدمين المنضمين بهذا التغيير';
$string['mod_form_field_notification_created_help'] = 'أرسل إشعاراً إلى كل المستخدمين المنضمين لإعلامهم بأنه تم إنشاء هذا النشاط';
$string['mod_form_field_notification_help'] = 'أرسل إشعاراً إلى كل المستخدمين المنضمين لإعلامهم بإضافة هذا النشاط أو تحديثه';
$string['mod_form_field_notification_modified_help'] = 'أرسل إشعاراً إلى كل المستخدمين المنضمين لإعلامهم بأنه تم تحديث هذا النشاط';
$string['mod_form_field_notification_msg_at'] = 'في';
$string['mod_form_field_notification_msg_created'] = 'تمت إضافته';
$string['mod_form_field_notification_msg_modified'] = 'تم تحديثه';
$string['mod_form_field_openingtime'] = 'الانضمام مفتوح';
$string['mod_form_field_participant_add'] = 'أضف دوراً خاصًاً';
$string['mod_form_field_participant_bbb_role_moderator'] = 'مشرف';
$string['mod_form_field_participant_bbb_role_viewer'] = 'مشاهد';
$string['mod_form_field_participant_list'] = 'قائمة الأدوار';
$string['mod_form_field_participant_list_action_add'] = 'أضف';
$string['mod_form_field_participant_list_action_remove'] = 'إزالة';
$string['mod_form_field_participant_list_text_as'] = 'ينضم إلى الجلسة بمثابة';
$string['mod_form_field_participant_list_type_all'] = 'كل المستخدمين منضمون';
$string['mod_form_field_participant_list_type_owner'] = 'المالك';
$string['mod_form_field_participant_list_type_role'] = 'الدور';
$string['mod_form_field_participant_list_type_user'] = 'المستخدم';
$string['mod_form_field_record'] = 'يمكن تسجيل الجلسة';
$string['mod_form_field_recordallfromstart'] = 'سجِّل كل شيء من البداية';
$string['mod_form_field_recordhidebutton'] = 'إخفاء زر التسجيل';
$string['mod_form_field_recordings_html'] = 'اعرض الجدول بصيغة html';
$string['mod_form_field_recordings_imported'] = 'إظهار الروابط المستوردة فقط';
$string['mod_form_field_recordings_preview'] = 'إظهار استعراض التسجيل';
$string['mod_form_field_room_name'] = 'اسم الغرفة';
$string['mod_form_field_userlimit'] = 'محدد المستخدمين';
$string['mod_form_field_userlimit_help'] = 'الحد الأقصى لعدد المستخدمين المسموح به في الاجتماع. إذا تم تعيين الحد على 0، فسيكون عدد المستخدمين غير محدود.';
$string['mod_form_field_voicebridge'] = 'الجسرالصوتي [####]';
$string['mod_form_field_voicebridge_format_error'] = 'خطأ في التنسيق. ينبغي أن تدخل رقماً من 1 حتى 9999.';
$string['mod_form_field_voicebridge_help'] = 'رقم المؤتمر الصوتي الذي يدخله المشاركون للانضمام إلى المؤتمر الصوتي عند استعمال الاتصال الهاتفي. يجب كتابة رقم بين 1 و 9999. إذا كانت القيمة تساوي 0، فسيتم تجاهل رقم جسر الصوت الثابت وسيتم إنشاء رقم عشوائي بواسطة غرف  BBB. سيسبق الرقم 7 الأرقام الأربعة المكتوبة.';
$string['mod_form_field_voicebridge_notunique_error'] = 'ليست قيمة فريدة. هذا الرقم مستعمل من قبل غرفة أو مؤتمر آخر.';
$string['mod_form_field_wait'] = 'انتظر المشرف';
$string['mod_form_field_wait_help'] = 'يجب على المشاهدين الانتظار حتى يدخل المشرف الجلسة قبل أن يتمكنوا من القيام بذلك';
$string['mod_form_field_welcome'] = 'رسالة الترحيب';
$string['mod_form_field_welcome_default'] = '<br>مرحبًا بك في <b>%%CONFNAME%%</b>!<br><br>للمساعدة في استعمال BigBlueButton أنظر هذه <a href="event:http://www.bigbluebutton.org/content/videos"><u>الفيديوهات التدريبية</u> (القصيرة)</a>.<br><br>للانضمام إلى الجسر الصوتي أنقر أيقونة الهاتف (أعلى الوسط). <b>لطفاً، استعمل سماعة الرأس لتتجنب إثارة الضوضاء بالنسبة للآخرين.</b>';
$string['mod_form_field_welcome_help'] = 'يستبدل الرسالة الافتراضية التي تم إعدادها لمخدم غرف اجتماعات BBB. يمكن أن تتضمن الرسالة الكلمات المفتاحية (%%CONFNAME%%، %%DIALNUM%%، %%CONFNUM%%) والتي سيتم استبدالها تلقائيًا، وكذلك وسوم html مثل &lt;b>...&lt;/b>، &lt;br />، &lt;u>&lt;/u> أو &lt;i>&lt;/i>';
$string['mod_form_locksettings'] = 'تأمين الإعدادات';
$string['modulename'] = 'BBB';
$string['modulename_help'] = 'يتيح لك BigBlueButton إنشاء روابط من داخل مودل للفصول الدراسية عبر الإنترنت في الوقت الفعلي باستعمال BigBlueButton، وهو نظام مؤتمرات ويب مفتوح المصدر للتعليم عن بعد.

باستعمال BigBlueButton، يمكنك تحديد العنوان والوصف ومُدخل التقويم (الذي يعطي نطاقًا زمنيًا للانضمام إلى الجلسة) والمجموعات وتفاصيل تسجيل الجلسة عبر الإنترنت.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BBB';
$string['new_bigblubuttonbn_activities'] = 'نشاط BBB';
$string['nosuchinstance'] = 'ليس هناك مثيل كـ {$a->entity} بالمُعرَّف: {$a->id}';
$string['notification_instance_created_intro'] = 'لقد تم إنشاء غرفة BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_instance_created_small'] = 'لقد تم إنشاء غرفة BigBlueButton جديدة بالتسمية {$a->name}';
$string['notification_instance_created_subject'] = 'لقد تم إنشاء غرفة BigBlueButton جديدة';
$string['notification_instance_description'] = 'الوصف';
$string['notification_instance_end_date'] = 'تاريخ الإنهاء';
$string['notification_instance_name'] = 'العنوان';
$string['notification_instance_start_date'] = 'تاريخ البدء';
$string['notification_instance_updated_intro'] = 'تم تحديث غرفة BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_instance_updated_small'] = 'تم تحديث جلسة BigBlueButton {$a->name}.';
$string['notification_instance_updated_subject'] = 'تم تحديث غرفتك في BigBlueButton.';
$string['notification_recording_ready_html'] = 'هناك تسجيل متاح للجلسة في غرفة BBB <b><a href="{$a->link}">{$a->name}</a></b>.';
$string['notification_recording_ready_plain'] = 'هناك تسجيل متاح للجلسة التي في غرفة BBB {$a->name}. إذهب إلى {$a->link} للوصول إلى رابط التسجيل.';
$string['notification_recording_ready_small'] = 'هناك تسجيل جديد متاح لغرفة BigBlueButton {$a->name}.';
$string['notification_recording_ready_subject'] = 'التسجيل متاح';
$string['pluginadministration'] = 'إدارة غرف اجتماعات BBB';
$string['pluginname'] = 'BBB';
$string['privacy:metadata:bigbluebutton'] = 'من أجل إنشاء جلسات غرف اجتماعات BBB والانضمام إليها، يجب تبادل بيانات المستخدم مع المخدم.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'الاسم الكامل للمستخدم الذي يصل إلى مخدم غرف  BBB';
$string['privacy:metadata:bigbluebutton:userid'] = 'مُعرَّف المستخدم الذي يقوم بالوصول إلى مخدم غرف  BBB';
$string['privacy:metadata:bigbluebuttonbn'] = 'يخزن إعدادات الغرفة أو النشاط الذي يحدد الميزات والسلوك العام لجلسة غرف  BBB';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'قائمة القواعد التي تحدد أدوار المستخدمين في الجلسة المباشرة. يمكن خزن مُعرَّف المستخدم بمثابة صلاحيات يمكن منحها للدور أو للمستخدم';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'يخزن الأحداث الناتجة عن استعمال الإضافة';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'نوع الحدث الذي أطلقه المستخدم';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'مُعرَّف الاجتماع الذي يصل إليه المستخدم';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'قد يتضمن معلومات إضافية عن الاجتماع أو التسجيل المتأثر بالحدث.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'الوقت الذي تم فيه إنشاء سجل الوقوعات';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'مُعرَّف المستخدم الذي أثار الحدث';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'يخزن البيانات الوصفية للتسجيلات';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'مُعرَّف المستخدم الذي أجرى آخر تغيير في التسجيل';
$string['recordings_from_deleted_activities'] = 'التسجيلات من النشاطات المحذوفة';
$string['recordingurlnotfound'] = 'عنوان رابط الاجتماع غير صالح.';
$string['removedevents'] = 'الأحداث المحذوفة';
$string['removedlogs'] = 'سجلات الوقوعات المخصصة المحذوفة';
$string['removedrecordings'] = 'التسجيلات المحذوفة';
$string['removedtags'] = 'الوسوم المحذوفة';
$string['report_join_info'] = 'قد انضم إلى الغرفة {$a} من المرات';
$string['report_play_recording_info'] = 'قد شغَّل التسجيل {$a} من المرات';
$string['report_room_view'] = 'قد عاين صفحة الغرفة';
$string['resetevents'] = 'حذف الأحداث';
$string['resetlogs'] = 'حذف سجلات الوقوعات المخصصة';
$string['resetlogs_help'] = 'سيؤدي حذف سجلات الوقوعات إلى فقدان المراجع إلى التسجيلات';
$string['resetrecordings'] = 'حذف التسجيلات';
$string['resetrecordings_help'] = 'سيؤدي حذف التسجيلات إلى عدم إمكانية الوصول إليها من أي مكان ولا يمكن التراجع عنها';
$string['resettags'] = 'حذف الوسوم';
$string['search:activity'] = 'BBB - معلومات النشاط';
$string['search:tags'] = 'BBB - معلومات الوسوم';
$string['sendnotification'] = 'إرسال الإشعار';
$string['settings'] = 'إعدادات BigBlueButton';
$string['started_at'] = 'بدأت';
$string['starts_at'] = 'تبدأ';
$string['taskname:check_dismissed_recordings'] = 'تحقق من وجود تسجيلات مزالة';
$string['taskname:check_pending_recordings'] = 'إحضار التسجيلات التي قيد الانتظار';
$string['userlimitreached'] = 'تم بلوغ العدد المسموح به من المستخدمين في الجلسة.';
$string['view_conference_action_end'] = 'إنهاء الجلسة';
$string['view_conference_action_join'] = 'انضم إلى الجلسة';
$string['view_error_action_not_completed'] = 'تعذر إكمال الإجراء';
$string['view_error_bigbluebutton'] = 'استجاب BigBlueButton مع وجود أخطاء. {$a}';
$string['view_error_create'] = 'استجاب مخدم غرف  BBB برسالة خطأ، وتعذر إنشاء الاجتماع.';
$string['view_error_current_state_not_found'] = 'لم يتم العثور على الحالة الحالية. ربما تم حذف التسجيل أو أن مخدم غرف اجتماعات BBB غير متوافق مع الإجراء المنفذ.';
$string['view_error_import_no_courses'] = 'لا توجد مقررات دراسية للبحث فيها عن التسجيلات';
$string['view_error_import_no_recordings'] = 'لا توجد تسجيلات في هذا المقرر الدراسي لاستيرادها';
$string['view_error_invalid_session'] = 'انتهت الجلسة. إرجع إلى صفحة النشاط الرئيسية.';
$string['view_error_max_concurrent'] = 'تم الوصول إلى أقصى عدد مسموح به من الاجتماعات المتزامنة.';
$string['view_error_meeting_not_running'] = 'هناك خطأ ما، الاجتماع ليس شغالاً.';
$string['view_error_no_group'] = 'ليست هناك مجموعات مُعرَّفة بعد. يرجى تعيين المجموعات قبل محاولة الانضمام إلى الاجتماع.';
$string['view_error_no_group_student'] = 'لستَ منضمًا إلى أي مجموعة. يرجى التوال مع معلمك أو مع المشرف.';
$string['view_error_no_group_teacher'] = 'ليست هناك مجموعات مُعرَّفة بعد. يرجى تعيين المجموعات أو التواصل مع المشرف.';
$string['view_error_unable_join'] = 'تعذر الانضمام إلى الاجتماع. يرجى التحقق من عنوان الرابط لمخدم غرف  BBB والتحقق لمعرفة ما إذا كان المخدم قيد التشغيل.';
$string['view_error_unable_join_student'] = 'تعذر الاتصال بمخدم BBB.';
$string['view_error_unable_join_teacher'] = 'تعذر الاتصال بمخدم غرف  BBB. يرجى الاتصال بالمشرف.';
$string['view_error_url_missing_parameters'] = 'هناك معاملات مفقودة في عنوان الرابط هذا';
$string['view_error_userlimit_reached'] = 'لقد تم الوصول إلى العدد المسموح به من المستخدمين في الاجتماع.';
$string['view_groups_nogroups_warning'] = 'لقد تمت تهيئة الغرفة لاستعمال المجموعات ولكن لم يتم تعريف أي منها في المقرر الدراسي.';
$string['view_groups_notenrolled_warning'] = 'لقد تمت تهيئة الغرفة لاستعمال المجموعات ولكنك غير منضم إلى أي منها.';
$string['view_groups_selection'] = 'حدد المجموعة التي تريد الانضمام إليها وقم بتأكيد الإجراء';
$string['view_groups_selection_join'] = 'إنضم';
$string['view_groups_selection_warning'] = 'توجد غرفة اجتماعات لكل مجموعة، ويمكنك الوصول إلى أكثر من غرفة. تأكد من اختيارك للغرفة الصحيحة.';
$string['view_login_moderator'] = 'الدخول بصفة مشرف ...';
$string['view_login_viewer'] = 'تسجيل الدخول كمشاهد ...';
$string['view_message_and'] = 'و';
$string['view_message_conference_has_ended'] = 'هذا المؤتمر انتهى.';
$string['view_message_conference_in_progress'] = 'هذا المؤتمر قيد التنفيذ';
$string['view_message_conference_not_started'] = 'هذا المؤتمر لم يبدأ بعد.';
$string['view_message_conference_room_ready'] = 'غرفة الاجتماعات هذه جاهزة. يمكنك الانضمام إلى الجلسة الآن.';
$string['view_message_conference_user_limit_reached'] = 'تم الوصول إلى العدد الأقصى المسموح به من المستخدمين في الجلسة';
$string['view_message_conference_wait_for_moderator'] = 'بانتظار انضمام مشرف الجلسة';
$string['view_message_finished'] = 'هذا النشاط قد انتهى.';
$string['view_message_has_joined'] = 'قد انضم';
$string['view_message_have_joined'] = 'قد انضموا';
$string['view_message_hour'] = 'ساعة';
$string['view_message_hours'] = 'ساعات';
$string['view_message_importrecordings_disabled'] = 'تم تعطيل ميزة استيراد روابط التسجيل في هذا المخدم.';
$string['view_message_minute'] = 'دقيقة';
$string['view_message_minutes'] = 'دقائق';
$string['view_message_moderator'] = 'مشرف';
$string['view_message_moderators'] = 'من المشرفين';
$string['view_message_norecordings'] = 'ليس هناك تسجيل لإظهاره.';
$string['view_message_notavailableyet'] = 'هذه الجلسة غير متاحة بعد.';
$string['view_message_recordings_disabled'] = 'تم تعطيل التسجيلات في هذا المخدم. لا يمكن استعمال مثيلات BBB للتسجيلات فقط.';
$string['view_message_room_closed'] = 'هذه الغرفة مغلقة.';
$string['view_message_room_open'] = 'هذه الغرفة مفتوحة.';
$string['view_message_room_ready'] = 'هذه الغرفة جاهزة.';
$string['view_message_session_for'] = 'الجلسة من';
$string['view_message_session_has_user'] = 'يوجد';
$string['view_message_session_has_users'] = 'يوجد';
$string['view_message_session_no_users'] = 'لا يوجد مستخدمون في هذه الجلسة';
$string['view_message_session_running_for'] = 'هذه الجلسة مستمرة لمدة';
$string['view_message_session_started_at'] = 'هذه الجلسة بدأت في';
$string['view_message_tab_close'] = 'ينبغي إغلاق هذا التبويب/النافذة يدويًا';
$string['view_message_times'] = 'الأوقات';
$string['view_message_user'] = 'المستخدم';
$string['view_message_users'] = 'المستخدمون';
$string['view_message_viewer'] = 'من المشاهدين';
$string['view_message_viewers'] = 'من المشاهدين';
$string['view_mobile_message_groups_not_supported'] = 'تم تمكين هذا المثيل للعمل مع المجموعات، ولكن لا يدعم تطبيق الجوال ذلك. يرجى فتحه من سطح المكتب إن كنت ترغب باستعمال الدعم للمجموعات.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'لقد تجاوزت الدقائق 45 في هذه الصفحة، يرجى إعادة تحميلها للانضمام إلى الاجتماع بشكل صحيح.';
$string['view_noguests'] = 'غرفة BBB غير مفتوحة للضيوف.';
$string['view_nojoin'] = 'لستَ بدورٍ يسمح لك بالانضمام إلى هذه الجلسة.';
$string['view_recording'] = 'التسجيل';
$string['view_recording_actionbar'] = 'شريط الأدوات';
$string['view_recording_activity'] = 'النشاط';
$string['view_recording_button_import'] = 'استيراد روابط التسجيلات';
$string['view_recording_button_return'] = 'عودة';
$string['view_recording_course'] = 'المقرر الدراسي';
$string['view_recording_date'] = 'التاريخ';
$string['view_recording_delete_confirmation'] = 'هل أنت متأكد من رغبتك في حذف {$a}؟';
$string['view_recording_delete_confirmation_warning_p'] = 'يرتبط هذا التسجيل مع {$a} من الروابط التي تم استيرادها إلى مقررات أو نشاطات مختلفة. إذا تم حذف التسجيل، ستتم إزالة تلك الروابط أيضًا';
$string['view_recording_delete_confirmation_warning_s'] = 'يرتبط هذا التسجيل مع {$a} من الروابط التي تم استيرادها إلى مقرر أو نشاط مختلف. إذا تم حذف التسجيل، ستتم إزالة ذلك الرابط أيضًا';
$string['view_recording_description'] = 'الوصف';
$string['view_recording_description_edithint'] = 'بالإمكان إضافة وصف للمساعدة في التعرف على التسجيل.';
$string['view_recording_description_editlabel'] = 'تحرير الوصف';
$string['view_recording_duration'] = 'المدة';
$string['view_recording_duration_min'] = 'دقيقة';
$string['view_recording_format_errror_unreachable'] = 'يتعذر الوصول إلى عنوان الرابط لتنسيق التسجيل هذا.';
$string['view_recording_format_notes'] = 'الملاحظات';
$string['view_recording_format_podcast'] = 'التسجيل الصوتي';
$string['view_recording_format_presentation'] = 'العرض';
$string['view_recording_format_screenshare'] = 'مشاركة الشاشة';
$string['view_recording_format_statistics'] = 'الإحصائيات';
$string['view_recording_format_video'] = 'الفيديو';
$string['view_recording_import_confirmation'] = 'هل أنت متأكد من رغبتك في استيراد هذا التسجيل؟';
$string['view_recording_length'] = 'الطول';
$string['view_recording_link'] = 'الرابط المستورد';
$string['view_recording_link_warning'] = 'هذا رابط يشير إلى تسجيل تم إنشاؤه في مقرر أو نشاط مختلف';
$string['view_recording_list_action_delete'] = 'الحذف';
$string['view_recording_list_action_edit'] = 'التحديث';
$string['view_recording_list_action_play'] = 'التشغيل';
$string['view_recording_list_action_process'] = 'تجري المعالجة';
$string['view_recording_list_action_protect'] = 'الحماية';
$string['view_recording_list_action_publish'] = 'النشر';
$string['view_recording_list_action_unprotect'] = 'إلغاء الحماية';
$string['view_recording_list_action_unpublish'] = 'إلغاء النشر';
$string['view_recording_list_action_update'] = 'التحديث';
$string['view_recording_list_actionbar'] = 'شريط الأدوات';
$string['view_recording_list_actionbar_delete'] = 'إحذف';
$string['view_recording_list_actionbar_edit'] = 'تحرير';
$string['view_recording_list_actionbar_hide'] = 'إخفاء';
$string['view_recording_list_actionbar_import'] = 'استيراد';
$string['view_recording_list_actionbar_protect'] = 'إجعلها خاصة';
$string['view_recording_list_actionbar_publish'] = 'النشر';
$string['view_recording_list_actionbar_show'] = 'إظهار';
$string['view_recording_list_actionbar_unprotect'] = 'إجعلها عامة';
$string['view_recording_list_actionbar_unpublish'] = 'إلغاء النشر';
$string['view_recording_list_activity'] = 'النشاط';
$string['view_recording_list_course'] = 'المقرر الدراسي';
$string['view_recording_list_date'] = 'التاريخ';
$string['view_recording_list_description'] = 'الوصف';
$string['view_recording_list_duration'] = 'المدة';
$string['view_recording_list_recording'] = 'التسجيل';
$string['view_recording_meeting'] = 'الاجتماع';
$string['view_recording_modal_button'] = 'تطبيق';
$string['view_recording_modal_title'] = 'تعيين القيم للتسجيل';
$string['view_recording_name'] = 'الاسم';
$string['view_recording_name_edithint'] = 'يمكن إضافة اسم للمساعدة في التعرف على التسجيل.';
$string['view_recording_name_editlabel'] = 'تحرير الاسم';
$string['view_recording_playback'] = 'تشغيل';
$string['view_recording_preview'] = 'معاينة';
$string['view_recording_preview_help'] = 'قم بالمرور فوق الصورة لمشاهدتها بالحجم الكامل';
$string['view_recording_protect_confirmation'] = 'هل أنت متأكد من رغبتك في حماية {$a} هذا ؟';
$string['view_recording_protect_confirmation_warning_p'] = 'يحتوي هذا التسجيل على روابط {$a} متعلقة به سبق وأن تم استيرادها إلى مساقات أو نشاطات مختلفة. إذا كان التسجيل محميًا فسيؤثر هذا أيضًا على الروابط المستوردة.';
$string['view_recording_protect_confirmation_warning_s'] = 'يحتوي هذا التسجيل على رابط {$a} متعلق به سبق وأن تم استيراده إلى مساق أو نشاط مختلف. إذا كان التسجيل محميًا فسيؤثر هذا أيضًا على الروابط المستوردة.';
$string['view_recording_publish_confirmation'] = 'هل أنت متأكد من رغبتك في نشر {$a} هذا؟';
$string['view_recording_publish_confirmation_warning_p'] = 'يحتوي هذا التسجيل على روابط {$a} متعلقة به سبق وأن تم استيرادها إلى مساقات أو نشاطات مختلفة. إذا كان التسجيل منشورًا فستصير تلك الروابط منشورة أيضًا.';
$string['view_recording_publish_confirmation_warning_s'] = 'يحتوي هذا التسجيل على رابط {$a} متعلق به سبق وأن تم استيراده إلى مساق أو نشاط مختلف. إذا كان التسجيل منشورًا فسيصير ذلك الرابط منشورًا أيضًا';
$string['view_recording_publish_link_deleted'] = 'لا يمكن إعادة نشر هذا الرابط لأن التسجيل الفعلي غير موجود في مخدم غرف  BBB الحالي. يجب إزالة الرابط.';
$string['view_recording_publish_link_not_published'] = 'لا يمكن إعادة نشر الرابط لأن التسجيل الفعلي ليس منشورًا';
$string['view_recording_recording'] = 'التسجيل';
$string['view_recording_select_course'] = 'إختر المساق أولاً في الائمة المنسدلة';
$string['view_recording_tags'] = 'الوسوم';
$string['view_recording_unprotect_confirmation'] = 'هل أنت متأكد من رغبتك في إلغاء حماية {$a} هذا؟';
$string['view_recording_unprotect_confirmation_warning_p'] = 'يحتوي هذا التسجيل على روابط {$a} متعلقة به سبق وأن تم استيرادها إلى مساقات أو نشاطات مختلفة. إذا كان التسجيل غير محمي فسيؤثر هذا أيضًا على الروابط المستوردة.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'يحتوي هذا التسجيل على رابط {$a} متعلق به سبق وأن تم استيراده إلى مساق أو نشاط مختلف. إذا كان التسجيل غير محمي فسيؤثر هذا أيضًا على الروابط المستوردة.';
$string['view_recording_unprotect_link_deleted'] = 'لا يمكن إلغاء حماية هذا الرابط لأن التسجيل الفعلي غير موجود في مخدم غرف  BBB الحالي. يجب إزالة الرابط.';
$string['view_recording_unprotect_link_not_unprotected'] = 'لا يمكن إلغاء الحماية عن هذا الرابط لأن التسجيل الفعلي محمي';
$string['view_recording_unpublish_confirmation'] = 'هل أنت متأكد من رغبتك في إلغاء نشر {$a}؟';
$string['view_recording_unpublish_confirmation_warning_p'] = 'يرتبط هذا التسجيل مع {$a} من الروابط التي تم استيرادها إلى مقررات أو نشاطات مختلفة. إذا تم إلغاء نشر التسجيل، سيتم إلغاء نشر تلك الروابط أيضًا';
$string['view_recording_unpublish_confirmation_warning_s'] = 'يرتبط هذا التسجيل مع {$a} من الروابط التي تم استيرادها إلى مقرر أو نشاط مختلف. إذا تم إلغاء نشر التسجيل، سيتم إلغاء نشر ذلك الرابط أيضًا';
$string['view_recording_yui_first'] = 'الأول';
$string['view_recording_yui_go'] = 'إذهب';
$string['view_recording_yui_last'] = 'الأخير';
$string['view_recording_yui_next'] = 'التالي';
$string['view_recording_yui_page'] = 'الصفحة';
$string['view_recording_yui_prev'] = 'السابق';
$string['view_recording_yui_rows'] = 'الصفوف';
$string['view_recording_yui_show_all'] = 'إظهار الكل';
$string['view_room'] = 'معاينة الغرفة';
$string['view_section_title_presentation'] = 'ملف العرض';
$string['view_section_title_recordings'] = 'التسجيلات';
$string['view_warning_default_server'] = 'يستفيد مخدم مودل هذا من مخدم اختبار غرف  BBB الذي يأتي مسبق التهيئة إفتراضيًا. يجب استبداله للإنتاج.';
$string['waitformoderator'] = 'بانتظار المشرف لينضم.';
