
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `moodle31118`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_indicator_calc`
--

CREATE TABLE `[[dbprefix]]analytics_indicator_calc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `starttime` bigint(10) NOT NULL,
  `endtime` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `sampleorigin` varchar(255) NOT NULL DEFAULT '',
  `sampleid` bigint(10) NOT NULL,
  `indicator` varchar(255) NOT NULL DEFAULT '',
  `value` decimal(10,2) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analindicalc_staendc_ix` (`starttime`,`endtime`,`contextid`),
  KEY `[[dbprefix]]analindicalc_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stored indicator calculations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_models`
--

CREATE TABLE `[[dbprefix]]analytics_models` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `trained` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(1333) DEFAULT NULL,
  `target` varchar(255) NOT NULL DEFAULT '',
  `indicators` longtext NOT NULL,
  `timesplitting` varchar(255) DEFAULT NULL,
  `predictionsprocessor` varchar(255) DEFAULT NULL,
  `version` bigint(10) NOT NULL,
  `contextids` longtext,
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analmode_enatra_ix` (`enabled`,`trained`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Analytic models.' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]analytics_models`
--

INSERT INTO `[[dbprefix]]analytics_models` VALUES
(1, 0, 0, NULL, '\\core_course\\analytics\\target\\course_dropout', '["\\\\core\\\\analytics\\\\indicator\\\\any_access_after_end","\\\\core\\\\analytics\\\\indicator\\\\any_access_before_start","\\\\core\\\\analytics\\\\indicator\\\\any_write_action_in_course","\\\\core\\\\analytics\\\\indicator\\\\read_actions","\\\\core_course\\\\analytics\\\\indicator\\\\completion_enabled","\\\\core_course\\\\analytics\\\\indicator\\\\potential_cognitive_depth","\\\\core_course\\\\analytics\\\\indicator\\\\potential_social_breadth","\\\\mod_assign\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_assign\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_book\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_book\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_chat\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_chat\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_choice\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_choice\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_data\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_data\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_folder\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_folder\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_forum\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_forum\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_label\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_label\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lti\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lti\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_page\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_page\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_resource\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_resource\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_survey\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_survey\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_url\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_url\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\social_breadth"]', NULL, NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0),
(2, 1, 1, NULL, '\\core_course\\analytics\\target\\no_teaching', '["\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher","\\\\core_course\\\\analytics\\\\indicator\\\\no_student"]', '\\core\\analytics\\time_splitting\\single_range', NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0),
(3, 1, 1, NULL, '\\core_user\\analytics\\target\\upcoming_activities_due', '["\\\\core_course\\\\analytics\\\\indicator\\\\activities_due"]', '\\core\\analytics\\time_splitting\\upcoming_week', NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0),
(4, 1, 1, NULL, '\\core_course\\analytics\\target\\no_access_since_course_start', '["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]', '\\core\\analytics\\time_splitting\\one_month_after_start', NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0),
(5, 1, 1, NULL, '\\core_course\\analytics\\target\\no_recent_accesses', '["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]', '\\core\\analytics\\time_splitting\\past_month', NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_models_log`
--

CREATE TABLE `[[dbprefix]]analytics_models_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `version` bigint(10) NOT NULL,
  `evaluationmode` varchar(50) NOT NULL DEFAULT '',
  `target` varchar(255) NOT NULL DEFAULT '',
  `indicators` longtext NOT NULL,
  `timesplitting` varchar(255) DEFAULT NULL,
  `score` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `info` longtext,
  `dir` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analmodelog_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Analytic models changes during evaluation.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_predictions`
--

CREATE TABLE `[[dbprefix]]analytics_predictions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `sampleid` bigint(10) NOT NULL,
  `rangeindex` mediumint(5) NOT NULL,
  `prediction` decimal(10,2) NOT NULL,
  `predictionscore` decimal(10,5) NOT NULL,
  `calculations` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timestart` bigint(10) DEFAULT NULL,
  `timeend` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analpred_modcon_ix` (`modelid`,`contextid`),
  KEY `[[dbprefix]]analpred_mod_ix` (`modelid`),
  KEY `[[dbprefix]]analpred_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Predictions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_prediction_actions`
--

CREATE TABLE `[[dbprefix]]analytics_prediction_actions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `predictionid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `actionname` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analpredacti_preusea_ix` (`predictionid`,`userid`,`actionname`),
  KEY `[[dbprefix]]analpredacti_pre_ix` (`predictionid`),
  KEY `[[dbprefix]]analpredacti_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Register of user actions over predictions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_predict_samples`
--

CREATE TABLE `[[dbprefix]]analytics_predict_samples` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `analysableid` bigint(10) NOT NULL,
  `timesplitting` varchar(255) NOT NULL DEFAULT '',
  `rangeindex` bigint(10) NOT NULL,
  `sampleids` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analpredsamp_modanat_ix` (`modelid`,`analysableid`,`timesplitting`,`rangeindex`),
  KEY `[[dbprefix]]analpredsamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Samples already used for predictions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_train_samples`
--

CREATE TABLE `[[dbprefix]]analytics_train_samples` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `analysableid` bigint(10) NOT NULL,
  `timesplitting` varchar(255) NOT NULL DEFAULT '',
  `sampleids` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analtraisamp_modanat_ix` (`modelid`,`analysableid`,`timesplitting`),
  KEY `[[dbprefix]]analtraisamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Samples used for training' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_used_analysables`
--

CREATE TABLE `[[dbprefix]]analytics_used_analysables` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `action` varchar(50) NOT NULL DEFAULT '',
  `analysableid` bigint(10) NOT NULL,
  `firstanalysis` bigint(10) NOT NULL,
  `timeanalysed` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analusedanal_modact_ix` (`modelid`,`action`),
  KEY `[[dbprefix]]analusedanal_ana_ix` (`analysableid`),
  KEY `[[dbprefix]]analusedanal_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of analysables used by each model' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_used_files`
--

CREATE TABLE `[[dbprefix]]analytics_used_files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL DEFAULT '0',
  `fileid` bigint(10) NOT NULL DEFAULT '0',
  `action` varchar(50) NOT NULL DEFAULT '',
  `time` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analusedfile_modactf_ix` (`modelid`,`action`,`fileid`),
  KEY `[[dbprefix]]analusedfile_mod_ix` (`modelid`),
  KEY `[[dbprefix]]analusedfile_fil_ix` (`fileid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Files that have already been used for training and predictio' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign`
--

CREATE TABLE `[[dbprefix]]assign` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `alwaysshowdescription` tinyint(2) NOT NULL DEFAULT '0',
  `nosubmissions` tinyint(2) NOT NULL DEFAULT '0',
  `submissiondrafts` tinyint(2) NOT NULL DEFAULT '0',
  `sendnotifications` tinyint(2) NOT NULL DEFAULT '0',
  `sendlatenotifications` tinyint(2) NOT NULL DEFAULT '0',
  `duedate` bigint(10) NOT NULL DEFAULT '0',
  `allowsubmissionsfromdate` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requiresubmissionstatement` tinyint(2) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(2) NOT NULL DEFAULT '0',
  `cutoffdate` bigint(10) NOT NULL DEFAULT '0',
  `gradingduedate` bigint(10) NOT NULL DEFAULT '0',
  `teamsubmission` tinyint(2) NOT NULL DEFAULT '0',
  `requireallteammemberssubmit` tinyint(2) NOT NULL DEFAULT '0',
  `teamsubmissiongroupingid` bigint(10) NOT NULL DEFAULT '0',
  `blindmarking` tinyint(2) NOT NULL DEFAULT '0',
  `hidegrader` tinyint(2) NOT NULL DEFAULT '0',
  `revealidentities` tinyint(2) NOT NULL DEFAULT '0',
  `attemptreopenmethod` varchar(10) NOT NULL DEFAULT 'none',
  `maxattempts` mediumint(6) NOT NULL DEFAULT '-1',
  `markingworkflow` tinyint(2) NOT NULL DEFAULT '0',
  `markingallocation` tinyint(2) NOT NULL DEFAULT '0',
  `sendstudentnotifications` tinyint(2) NOT NULL DEFAULT '1',
  `preventsubmissionnotingroup` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assi_cou_ix` (`course`),
  KEY `[[dbprefix]]assi_tea_ix` (`teamsubmissiongroupingid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table saves information about an instance of mod_assign' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_comments`
--

CREATE TABLE `[[dbprefix]]assignfeedback_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `commenttext` longtext,
  `commentformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assicomm_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assicomm_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Text feedback for submitted assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_annot`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_annot` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `endx` bigint(10) DEFAULT '0',
  `endy` bigint(10) DEFAULT '0',
  `path` longtext,
  `type` varchar(10) DEFAULT 'line',
  `colour` varchar(10) DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assieditanno_grapag_ix` (`gradeid`,`pageno`),
  KEY `[[dbprefix]]assieditanno_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='stores annotations added to pdfs submitted by students' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_cmnt`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_cmnt` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `width` bigint(10) DEFAULT '120',
  `rawtext` longtext,
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `colour` varchar(10) DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assieditcmnt_grapag_ix` (`gradeid`,`pageno`),
  KEY `[[dbprefix]]assieditcmnt_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores comments added to pdfs' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_queue`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `submissionid` bigint(10) NOT NULL,
  `submissionattempt` bigint(10) NOT NULL,
  `attemptedconversions` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assieditqueu_subsub_uix` (`submissionid`,`submissionattempt`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Queue for processing.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_quick`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_quick` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `rawtext` longtext NOT NULL,
  `width` bigint(10) NOT NULL DEFAULT '120',
  `colour` varchar(10) DEFAULT 'yellow',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assieditquic_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores teacher specified quicklist comments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_rot`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_rot` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `pathnamehash` longtext NOT NULL,
  `isrotated` tinyint(1) NOT NULL DEFAULT '0',
  `degree` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assieditrot_grapag_uix` (`gradeid`,`pageno`),
  KEY `[[dbprefix]]assieditrot_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores rotation information of a page.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_file`
--

CREATE TABLE `[[dbprefix]]assignfeedback_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assifile_ass2_ix` (`assignment`),
  KEY `[[dbprefix]]assifile_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores info about the number of files submitted by a student' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignment`
--

CREATE TABLE `[[dbprefix]]assignment` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `assignmenttype` varchar(50) NOT NULL DEFAULT '',
  `resubmit` tinyint(2) NOT NULL DEFAULT '0',
  `preventlate` tinyint(2) NOT NULL DEFAULT '0',
  `emailteachers` tinyint(2) NOT NULL DEFAULT '0',
  `var1` bigint(10) DEFAULT '0',
  `var2` bigint(10) DEFAULT '0',
  `var3` bigint(10) DEFAULT '0',
  `var4` bigint(10) DEFAULT '0',
  `var5` bigint(10) DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '100000',
  `timedue` bigint(10) NOT NULL DEFAULT '0',
  `timeavailable` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assi_cou2_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignment_submissions`
--

CREATE TABLE `[[dbprefix]]assignment_submissions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  `data1` longtext,
  `data2` longtext,
  `grade` bigint(11) NOT NULL DEFAULT '0',
  `submissioncomment` longtext NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `teacher` bigint(10) NOT NULL DEFAULT '0',
  `timemarked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assisubm_use2_ix` (`userid`),
  KEY `[[dbprefix]]assisubm_mai_ix` (`mailed`),
  KEY `[[dbprefix]]assisubm_tim_ix` (`timemarked`),
  KEY `[[dbprefix]]assisubm_ass2_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Info about submitted assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignment_upgrade`
--

CREATE TABLE `[[dbprefix]]assignment_upgrade` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `oldcmid` bigint(10) NOT NULL DEFAULT '0',
  `oldinstance` bigint(10) NOT NULL DEFAULT '0',
  `newcmid` bigint(10) NOT NULL DEFAULT '0',
  `newinstance` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiupgr_old_ix` (`oldcmid`),
  KEY `[[dbprefix]]assiupgr_old2_ix` (`oldinstance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Info about upgraded assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignsubmission_file`
--

CREATE TABLE `[[dbprefix]]assignsubmission_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assifile_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assifile_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Info about file submissions for assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignsubmission_onlinetext`
--

CREATE TABLE `[[dbprefix]]assignsubmission_onlinetext` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `onlinetext` longtext,
  `onlineformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assionli_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assionli_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Info about onlinetext submission' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_grades`
--

CREATE TABLE `[[dbprefix]]assign_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `grader` bigint(10) NOT NULL DEFAULT '0',
  `grade` decimal(10,5) DEFAULT '0.00000',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assigrad_assuseatt_uix` (`assignment`,`userid`,`attemptnumber`),
  KEY `[[dbprefix]]assigrad_use_ix` (`userid`),
  KEY `[[dbprefix]]assigrad_att_ix` (`attemptnumber`),
  KEY `[[dbprefix]]assigrad_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Grading information about a single assignment submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_overrides`
--

CREATE TABLE `[[dbprefix]]assign_overrides` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) DEFAULT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `allowsubmissionsfromdate` bigint(10) DEFAULT NULL,
  `duedate` bigint(10) DEFAULT NULL,
  `cutoffdate` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiover_ass_ix` (`assignid`),
  KEY `[[dbprefix]]assiover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]assiover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The overrides to assign settings.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_plugin_config`
--

CREATE TABLE `[[dbprefix]]assign_plugin_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `plugin` varchar(28) NOT NULL DEFAULT '',
  `subtype` varchar(28) NOT NULL DEFAULT '',
  `name` varchar(28) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiplugconf_plu_ix` (`plugin`),
  KEY `[[dbprefix]]assiplugconf_sub_ix` (`subtype`),
  KEY `[[dbprefix]]assiplugconf_nam_ix` (`name`),
  KEY `[[dbprefix]]assiplugconf_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Config data for an instance of a plugin in an assignment.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_submission`
--

CREATE TABLE `[[dbprefix]]assign_submission` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `status` varchar(10) DEFAULT NULL,
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  `latest` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assisubm_assusegroa_uix` (`assignment`,`userid`,`groupid`,`attemptnumber`),
  KEY `[[dbprefix]]assisubm_use_ix` (`userid`),
  KEY `[[dbprefix]]assisubm_att_ix` (`attemptnumber`),
  KEY `[[dbprefix]]assisubm_assusegrola_ix` (`assignment`,`userid`,`groupid`,`latest`),
  KEY `[[dbprefix]]assisubm_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table keeps information about student interactions with' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_user_flags`
--

CREATE TABLE `[[dbprefix]]assign_user_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` smallint(4) NOT NULL DEFAULT '0',
  `extensionduedate` bigint(10) NOT NULL DEFAULT '0',
  `workflowstate` varchar(20) DEFAULT NULL,
  `allocatedmarker` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiuserflag_mai_ix` (`mailed`),
  KEY `[[dbprefix]]assiuserflag_use_ix` (`userid`),
  KEY `[[dbprefix]]assiuserflag_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of flags that can be set for a single user in a single ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_user_mapping`
--

CREATE TABLE `[[dbprefix]]assign_user_mapping` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiusermapp_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assiusermapp_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Map an assignment specific id number to a user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_oauth2_linked_login`
--

CREATE TABLE `[[dbprefix]]auth_oauth2_linked_login` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `username` varchar(255) NOT NULL DEFAULT '',
  `email` longtext NOT NULL,
  `confirmtoken` varchar(64) NOT NULL DEFAULT '',
  `confirmtokenexpires` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]authoautlinklogi_us_uix` (`userid`,`issuerid`,`username`),
  KEY `[[dbprefix]]authoautlinklogi_iss_ix` (`issuerid`,`username`),
  KEY `[[dbprefix]]authoautlinklogi_use_ix` (`usermodified`),
  KEY `[[dbprefix]]authoautlinklogi_us2_ix` (`userid`),
  KEY `[[dbprefix]]authoautlinklogi_is2_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Accounts linked to a users Moodle account.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_controllers`
--

CREATE TABLE `[[dbprefix]]backup_controllers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) NOT NULL DEFAULT '',
  `operation` varchar(20) NOT NULL DEFAULT 'backup',
  `type` varchar(10) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `format` varchar(20) NOT NULL DEFAULT '',
  `interactive` smallint(4) NOT NULL,
  `purpose` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `status` smallint(4) NOT NULL,
  `execution` smallint(4) NOT NULL,
  `executiontime` bigint(10) NOT NULL,
  `checksum` varchar(32) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `progress` decimal(15,14) NOT NULL DEFAULT '0.00000000000000',
  `controller` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backcont_bac_uix` (`backupid`),
  KEY `[[dbprefix]]backcont_typite_ix` (`type`,`itemid`),
  KEY `[[dbprefix]]backcont_useite_ix` (`userid`,`itemid`),
  KEY `[[dbprefix]]backcont_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To store the backup_controllers as they are used' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_courses`
--

CREATE TABLE `[[dbprefix]]backup_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `laststarttime` bigint(10) NOT NULL DEFAULT '0',
  `lastendtime` bigint(10) NOT NULL DEFAULT '0',
  `laststatus` varchar(1) NOT NULL DEFAULT '5',
  `nextstarttime` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To store every course backup status' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_logs`
--

CREATE TABLE `[[dbprefix]]backup_logs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) NOT NULL DEFAULT '',
  `loglevel` smallint(4) NOT NULL,
  `message` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backlogs_bacid_uix` (`backupid`,`id`),
  KEY `[[dbprefix]]backlogs_bac_ix` (`backupid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To store all the logs from backup and restore operations (by' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge`
--

CREATE TABLE `[[dbprefix]]badge` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usercreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuername` varchar(255) NOT NULL DEFAULT '',
  `issuerurl` varchar(255) NOT NULL DEFAULT '',
  `issuercontact` varchar(255) DEFAULT NULL,
  `expiredate` bigint(10) DEFAULT NULL,
  `expireperiod` bigint(10) DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `courseid` bigint(10) DEFAULT NULL,
  `message` longtext NOT NULL,
  `messagesubject` longtext NOT NULL,
  `attachment` tinyint(1) NOT NULL DEFAULT '1',
  `notification` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `nextcron` bigint(10) DEFAULT NULL,
  `version` varchar(255) DEFAULT NULL,
  `language` varchar(255) DEFAULT NULL,
  `imageauthorname` varchar(255) DEFAULT NULL,
  `imageauthoremail` varchar(255) DEFAULT NULL,
  `imageauthorurl` varchar(255) DEFAULT NULL,
  `imagecaption` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badg_typ_ix` (`type`),
  KEY `[[dbprefix]]badg_cou_ix` (`courseid`),
  KEY `[[dbprefix]]badg_use_ix` (`usermodified`),
  KEY `[[dbprefix]]badg_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines badge' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_alignment`
--

CREATE TABLE `[[dbprefix]]badge_alignment` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `targetname` varchar(255) NOT NULL DEFAULT '',
  `targeturl` varchar(255) NOT NULL DEFAULT '',
  `targetdescription` longtext,
  `targetframework` varchar(255) DEFAULT NULL,
  `targetcode` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgalig_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines alignment for badges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_backpack`
--

CREATE TABLE `[[dbprefix]]badge_backpack` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `email` varchar(100) NOT NULL DEFAULT '',
  `backpackuid` bigint(10) NOT NULL,
  `autosync` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(50) DEFAULT NULL,
  `externalbackpackid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgback_useext_uix` (`userid`,`externalbackpackid`),
  KEY `[[dbprefix]]badgback_use_ix` (`userid`),
  KEY `[[dbprefix]]badgback_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines settings for connecting external backpack' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_backpack_oauth2`
--

CREATE TABLE `[[dbprefix]]badge_backpack_oauth2` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `externalbackpackid` bigint(10) NOT NULL,
  `token` longtext NOT NULL,
  `refreshtoken` longtext NOT NULL,
  `expires` bigint(10) DEFAULT NULL,
  `scope` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgbackoaut_use_ix` (`usermodified`),
  KEY `[[dbprefix]]badgbackoaut_use2_ix` (`userid`),
  KEY `[[dbprefix]]badgbackoaut_iss_ix` (`issuerid`),
  KEY `[[dbprefix]]badgbackoaut_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_criteria`
--

CREATE TABLE `[[dbprefix]]badge_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '1',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgcrit_badcri_uix` (`badgeid`,`criteriatype`),
  KEY `[[dbprefix]]badgcrit_cri_ix` (`criteriatype`),
  KEY `[[dbprefix]]badgcrit_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines criteria for issuing badges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_criteria_met`
--

CREATE TABLE `[[dbprefix]]badge_criteria_met` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `issuedid` bigint(10) DEFAULT NULL,
  `critid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgcritmet_cri_ix` (`critid`),
  KEY `[[dbprefix]]badgcritmet_use_ix` (`userid`),
  KEY `[[dbprefix]]badgcritmet_iss_ix` (`issuedid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines criteria that were met for an issued badge' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_criteria_param`
--

CREATE TABLE `[[dbprefix]]badge_criteria_param` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `critid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgcritpara_cri_ix` (`critid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines parameters for badges criteria' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_endorsement`
--

CREATE TABLE `[[dbprefix]]badge_endorsement` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `issuername` varchar(255) NOT NULL DEFAULT '',
  `issuerurl` varchar(255) NOT NULL DEFAULT '',
  `issueremail` varchar(255) NOT NULL DEFAULT '',
  `claimid` varchar(255) DEFAULT NULL,
  `claimcomment` longtext,
  `dateissued` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgendo_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines endorsement for badge' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_external`
--

CREATE TABLE `[[dbprefix]]badge_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backpackid` bigint(10) NOT NULL,
  `collectionid` bigint(10) NOT NULL,
  `entityid` varchar(255) DEFAULT NULL,
  `assertion` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgexte_bac_ix` (`backpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Setting for external badges display' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_external_backpack`
--

CREATE TABLE `[[dbprefix]]badge_external_backpack` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backpackapiurl` varchar(255) NOT NULL DEFAULT '',
  `backpackweburl` varchar(255) NOT NULL DEFAULT '',
  `apiversion` varchar(12) NOT NULL DEFAULT '1.0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `oauth2_issuerid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgexteback_bac_uix` (`backpackapiurl`),
  UNIQUE KEY `[[dbprefix]]badgexteback_bac2_uix` (`backpackweburl`),
  KEY `[[dbprefix]]badgexteback_oau_ix` (`oauth2_issuerid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines settings for site level backpacks that a user can co' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]badge_external_backpack`
--

INSERT INTO `[[dbprefix]]badge_external_backpack` VALUES
(1, 'https://api.badgr.io/v2', 'https://badgr.io', '2', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_external_identifier`
--

CREATE TABLE `[[dbprefix]]badge_external_identifier` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `sitebackpackid` bigint(10) NOT NULL,
  `internalid` varchar(128) NOT NULL DEFAULT '',
  `externalid` varchar(128) NOT NULL DEFAULT '',
  `type` varchar(16) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgexteiden_sitint_uix` (`sitebackpackid`,`internalid`,`externalid`,`type`),
  KEY `[[dbprefix]]badgexteiden_sit_ix` (`sitebackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Setting for external badges mappings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_issued`
--

CREATE TABLE `[[dbprefix]]badge_issued` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `uniquehash` longtext NOT NULL,
  `dateissued` bigint(10) NOT NULL DEFAULT '0',
  `dateexpire` bigint(10) DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `issuernotified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgissu_baduse_uix` (`badgeid`,`userid`),
  KEY `[[dbprefix]]badgissu_bad_ix` (`badgeid`),
  KEY `[[dbprefix]]badgissu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines issued badges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_manual_award`
--

CREATE TABLE `[[dbprefix]]badge_manual_award` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL,
  `recipientid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `issuerrole` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgmanuawar_bad_ix` (`badgeid`),
  KEY `[[dbprefix]]badgmanuawar_rec_ix` (`recipientid`),
  KEY `[[dbprefix]]badgmanuawar_iss_ix` (`issuerid`),
  KEY `[[dbprefix]]badgmanuawar_iss2_ix` (`issuerrole`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Track manual award criteria for badges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_related`
--

CREATE TABLE `[[dbprefix]]badge_related` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `relatedbadgeid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgrela_badrel_uix` (`badgeid`,`relatedbadgeid`),
  KEY `[[dbprefix]]badgrela_bad_ix` (`badgeid`),
  KEY `[[dbprefix]]badgrela_rel_ix` (`relatedbadgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines badge related for badges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block`
--

CREATE TABLE `[[dbprefix]]block` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `cron` bigint(10) NOT NULL DEFAULT '0',
  `lastcron` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]bloc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='contains all installed blocks' AUTO_INCREMENT=45 ;

--
-- Dumping data for table `[[dbprefix]]block`
--

INSERT INTO `[[dbprefix]]block` VALUES
(1, 'accessreview', 0, 0, 1),
(2, 'activity_modules', 0, 0, 1),
(3, 'activity_results', 0, 0, 1),
(4, 'admin_bookmarks', 0, 0, 1),
(5, 'badges', 0, 0, 1),
(6, 'blog_menu', 0, 0, 1),
(7, 'blog_recent', 0, 0, 1),
(8, 'blog_tags', 0, 0, 1),
(9, 'calendar_month', 0, 0, 1),
(10, 'calendar_upcoming', 0, 0, 1),
(11, 'comments', 0, 0, 1),
(12, 'completionstatus', 0, 0, 1),
(13, 'course_list', 0, 0, 1),
(14, 'course_summary', 0, 0, 1),
(15, 'feedback', 0, 0, 1),
(16, 'globalsearch', 0, 0, 1),
(17, 'glossary_random', 0, 0, 1),
(18, 'html', 0, 0, 1),
(19, 'login', 0, 0, 1),
(20, 'lp', 0, 0, 1),
(21, 'mentees', 0, 0, 1),
(22, 'mnet_hosts', 0, 0, 1),
(23, 'myoverview', 0, 0, 1),
(24, 'myprofile', 0, 0, 1),
(25, 'navigation', 0, 0, 1),
(26, 'news_items', 0, 0, 1),
(27, 'online_users', 0, 0, 1),
(28, 'private_files', 0, 0, 1),
(29, 'quiz_results', 0, 0, 0),
(30, 'recent_activity', 0, 0, 1),
(31, 'recentlyaccessedcourses', 0, 0, 1),
(32, 'recentlyaccesseditems', 0, 0, 1),
(33, 'rss_client', 0, 0, 1),
(34, 'search_forums', 0, 0, 1),
(35, 'section_links', 0, 0, 1),
(36, 'selfcompletion', 0, 0, 1),
(37, 'settings', 0, 0, 1),
(38, 'site_main_menu', 0, 0, 1),
(39, 'social_activities', 0, 0, 1),
(40, 'starredcourses', 0, 0, 1),
(41, 'tag_flickr', 0, 0, 1),
(42, 'tag_youtube', 0, 0, 0),
(43, 'tags', 0, 0, 1),
(44, 'timeline', 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_instances`
--

CREATE TABLE `[[dbprefix]]block_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockname` varchar(40) NOT NULL DEFAULT '',
  `parentcontextid` bigint(10) NOT NULL,
  `showinsubcontexts` smallint(4) NOT NULL,
  `requiredbytheme` smallint(4) NOT NULL DEFAULT '0',
  `pagetypepattern` varchar(64) NOT NULL DEFAULT '',
  `subpagepattern` varchar(16) DEFAULT NULL,
  `defaultregion` varchar(16) NOT NULL DEFAULT '',
  `defaultweight` bigint(10) NOT NULL,
  `configdata` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocinst_parshopagsu_ix` (`parentcontextid`,`showinsubcontexts`,`pagetypepattern`,`subpagepattern`),
  KEY `[[dbprefix]]blocinst_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]blocinst_par_ix` (`parentcontextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores block instances. The type of block this is' AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]block_instances`
--

INSERT INTO `[[dbprefix]]block_instances` VALUES
(1, 'admin_bookmarks', 1, 0, 0, 'admin-*', NULL, 'side-pre', 2, '', [[timestamp]], [[timestamp]]),
(2, 'timeline', 1, 0, 0, 'my-index', '2', 'side-post', 0, '', [[timestamp]], [[timestamp]]),
(3, 'private_files', 1, 0, 0, 'my-index', '2', 'side-post', 1, '', [[timestamp]], [[timestamp]]),
(4, 'online_users', 1, 0, 0, 'my-index', '2', 'side-post', 2, '', [[timestamp]], [[timestamp]]),
(5, 'badges', 1, 0, 0, 'my-index', '2', 'side-post', 3, '', [[timestamp]], [[timestamp]]),
(6, 'calendar_month', 1, 0, 0, 'my-index', '2', 'side-post', 4, '', [[timestamp]], [[timestamp]]),
(7, 'calendar_upcoming', 1, 0, 0, 'my-index', '2', 'side-post', 5, '', [[timestamp]], [[timestamp]]),
(8, 'lp', 1, 0, 0, 'my-index', '2', 'content', 0, '', [[timestamp]], [[timestamp]]),
(9, 'recentlyaccessedcourses', 1, 0, 0, 'my-index', '2', 'content', 1, '', [[timestamp]], [[timestamp]]),
(10, 'myoverview', 1, 0, 0, 'my-index', '2', 'content', 2, '', [[timestamp]], [[timestamp]]),
(11, 'timeline', 5, 0, 0, 'my-index', '3', 'side-post', 0, '', [[timestamp]], [[timestamp]]),
(12, 'private_files', 5, 0, 0, 'my-index', '3', 'side-post', 1, '', [[timestamp]], [[timestamp]]),
(13, 'online_users', 5, 0, 0, 'my-index', '3', 'side-post', 2, '', [[timestamp]], [[timestamp]]),
(14, 'badges', 5, 0, 0, 'my-index', '3', 'side-post', 3, '', [[timestamp]], [[timestamp]]),
(15, 'calendar_month', 5, 0, 0, 'my-index', '3', 'side-post', 4, '', [[timestamp]], [[timestamp]]),
(16, 'calendar_upcoming', 5, 0, 0, 'my-index', '3', 'side-post', 5, '', [[timestamp]], [[timestamp]]),
(17, 'lp', 5, 0, 0, 'my-index', '3', 'content', 0, '', [[timestamp]], [[timestamp]]),
(18, 'recentlyaccessedcourses', 5, 0, 0, 'my-index', '3', 'content', 1, '', [[timestamp]], [[timestamp]]),
(19, 'myoverview', 5, 0, 0, 'my-index', '3', 'content', 2, '', [[timestamp]], [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_positions`
--

CREATE TABLE `[[dbprefix]]block_positions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockinstanceid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `pagetype` varchar(64) NOT NULL DEFAULT '',
  `subpage` varchar(16) NOT NULL DEFAULT '',
  `visible` smallint(4) NOT NULL,
  `region` varchar(16) NOT NULL DEFAULT '',
  `weight` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]blocposi_bloconpags_uix` (`blockinstanceid`,`contextid`,`pagetype`,`subpage`),
  KEY `[[dbprefix]]blocposi_blo_ix` (`blockinstanceid`),
  KEY `[[dbprefix]]blocposi_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the position of a sticky block_instance on a another ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_recentlyaccesseditems`
--

CREATE TABLE `[[dbprefix]]block_recentlyaccesseditems` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timeaccess` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]blocrece_usecoucmi_uix` (`userid`,`courseid`,`cmid`),
  KEY `[[dbprefix]]blocrece_use_ix` (`userid`),
  KEY `[[dbprefix]]blocrece_cou_ix` (`courseid`),
  KEY `[[dbprefix]]blocrece_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Most recently accessed items accessed by a user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_recent_activity`
--

CREATE TABLE `[[dbprefix]]block_recent_activity` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `action` tinyint(1) NOT NULL,
  `modname` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocreceacti_coutim_ix` (`courseid`,`timecreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Recent activity block' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_rss_client`
--

CREATE TABLE `[[dbprefix]]block_rss_client` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `title` longtext NOT NULL,
  `preferredtitle` varchar(64) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `shared` tinyint(2) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `skiptime` bigint(10) NOT NULL DEFAULT '0',
  `skipuntil` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Remote news feed information. Contains the news feed id, the' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_association`
--

CREATE TABLE `[[dbprefix]]blog_association` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `blogid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blogasso_con_ix` (`contextid`),
  KEY `[[dbprefix]]blogasso_blo_ix` (`blogid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Associations of blog entries with courses and module instanc' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_external`
--

CREATE TABLE `[[dbprefix]]blog_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `url` longtext NOT NULL,
  `filtertags` varchar(255) DEFAULT NULL,
  `failedlastsync` tinyint(1) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) DEFAULT NULL,
  `timefetched` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blogexte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='External blog links used for RSS copying of blog entries to ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]book`
--

CREATE TABLE `[[dbprefix]]book` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `numbering` smallint(4) NOT NULL DEFAULT '0',
  `navstyle` smallint(4) NOT NULL DEFAULT '1',
  `customtitles` tinyint(2) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines book' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]book_chapters`
--

CREATE TABLE `[[dbprefix]]book_chapters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `bookid` bigint(10) NOT NULL DEFAULT '0',
  `pagenum` bigint(10) NOT NULL DEFAULT '0',
  `subchapter` bigint(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` longtext NOT NULL,
  `contentformat` smallint(4) NOT NULL DEFAULT '0',
  `hidden` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `importsrc` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]bookchap_boo_ix` (`bookid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines book_chapters' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_filters`
--

CREATE TABLE `[[dbprefix]]cache_filters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) NOT NULL DEFAULT '',
  `version` bigint(10) NOT NULL DEFAULT '0',
  `md5key` varchar(32) NOT NULL DEFAULT '',
  `rawtext` longtext NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cachfilt_filmd5_ix` (`filter`,`md5key`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='For keeping information about cached data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_flags`
--

CREATE TABLE `[[dbprefix]]cache_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `flagtype` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext NOT NULL,
  `expiry` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cachflag_fla_ix` (`flagtype`),
  KEY `[[dbprefix]]cachflag_nam_ix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Cache of time-sensitive flags' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]cache_flags`
--

INSERT INTO `[[dbprefix]]cache_flags` VALUES
(1, 'userpreferenceschanged', '2', [[timestamp]], '1', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]capabilities`
--

CREATE TABLE `[[dbprefix]]capabilities` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `captype` varchar(50) NOT NULL DEFAULT '',
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) NOT NULL DEFAULT '',
  `riskbitmask` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]capa_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='this defines all capabilities' AUTO_INCREMENT=693 ;

--
-- Dumping data for table `[[dbprefix]]capabilities`
--

INSERT INTO `[[dbprefix]]capabilities` VALUES
(1, 'moodle/site:config', 'write', 10, 'moodle', 62),
(2, 'moodle/site:configview', 'read', 10, 'moodle', 0),
(3, 'moodle/site:readallmessages', 'read', 10, 'moodle', 8),
(4, 'moodle/site:manageallmessaging', 'write', 10, 'moodle', 8),
(5, 'moodle/site:deleteanymessage', 'write', 10, 'moodle', 32),
(6, 'moodle/site:sendmessage', 'write', 10, 'moodle', 16),
(7, 'moodle/site:senderrormessage', 'write', 10, 'moodle', 16),
(8, 'moodle/site:deleteownmessage', 'write', 10, 'moodle', 0),
(9, 'moodle/site:approvecourse', 'write', 40, 'moodle', 4),
(10, 'moodle/backup:backupcourse', 'write', 50, 'moodle', 28),
(11, 'moodle/backup:backupsection', 'write', 50, 'moodle', 28),
(12, 'moodle/backup:backupactivity', 'write', 70, 'moodle', 28),
(13, 'moodle/backup:backuptargetimport', 'read', 50, 'moodle', 28),
(14, 'moodle/backup:downloadfile', 'write', 50, 'moodle', 28),
(15, 'moodle/backup:configure', 'write', 50, 'moodle', 28),
(16, 'moodle/backup:userinfo', 'read', 50, 'moodle', 8),
(17, 'moodle/backup:anonymise', 'read', 50, 'moodle', 8),
(18, 'moodle/restore:restorecourse', 'write', 50, 'moodle', 28),
(19, 'moodle/restore:restoresection', 'write', 50, 'moodle', 28),
(20, 'moodle/restore:restoreactivity', 'write', 50, 'moodle', 28),
(21, 'moodle/restore:viewautomatedfilearea', 'write', 50, 'moodle', 28),
(22, 'moodle/restore:restoretargetimport', 'write', 50, 'moodle', 28),
(23, 'moodle/restore:uploadfile', 'write', 50, 'moodle', 28),
(24, 'moodle/restore:configure', 'write', 50, 'moodle', 28),
(25, 'moodle/restore:rolldates', 'write', 50, 'moodle', 0),
(26, 'moodle/restore:userinfo', 'write', 50, 'moodle', 30),
(27, 'moodle/restore:createuser', 'write', 10, 'moodle', 24),
(28, 'moodle/site:manageblocks', 'write', 80, 'moodle', 20),
(29, 'moodle/site:accessallgroups', 'read', 70, 'moodle', 0),
(30, 'moodle/site:viewanonymousevents', 'read', 70, 'moodle', 8),
(31, 'moodle/site:viewfullnames', 'read', 70, 'moodle', 0),
(32, 'moodle/site:viewuseridentity', 'read', 70, 'moodle', 0),
(33, 'moodle/site:viewreports', 'read', 50, 'moodle', 8),
(34, 'moodle/site:trustcontent', 'write', 70, 'moodle', 4),
(35, 'moodle/site:uploadusers', 'write', 10, 'moodle', 24),
(36, 'moodle/filter:manage', 'write', 50, 'moodle', 0),
(37, 'moodle/user:create', 'write', 10, 'moodle', 24),
(38, 'moodle/user:delete', 'write', 10, 'moodle', 40),
(39, 'moodle/user:update', 'write', 10, 'moodle', 24),
(40, 'moodle/user:viewdetails', 'read', 50, 'moodle', 0),
(41, 'moodle/user:viewalldetails', 'read', 30, 'moodle', 8),
(42, 'moodle/user:viewlastip', 'read', 30, 'moodle', 8),
(43, 'moodle/user:viewhiddendetails', 'read', 50, 'moodle', 8),
(44, 'moodle/user:loginas', 'write', 50, 'moodle', 30),
(45, 'moodle/user:managesyspages', 'write', 10, 'moodle', 0),
(46, 'moodle/user:manageblocks', 'write', 30, 'moodle', 0),
(47, 'moodle/user:manageownblocks', 'write', 10, 'moodle', 0),
(48, 'moodle/user:manageownfiles', 'write', 10, 'moodle', 0),
(49, 'moodle/user:ignoreuserquota', 'write', 10, 'moodle', 0),
(50, 'moodle/my:configsyspages', 'write', 10, 'moodle', 0),
(51, 'moodle/role:assign', 'write', 50, 'moodle', 28),
(52, 'moodle/role:review', 'read', 50, 'moodle', 8),
(53, 'moodle/role:override', 'write', 50, 'moodle', 28),
(54, 'moodle/role:safeoverride', 'write', 50, 'moodle', 16),
(55, 'moodle/role:manage', 'write', 10, 'moodle', 28),
(56, 'moodle/role:switchroles', 'read', 50, 'moodle', 12),
(57, 'moodle/category:manage', 'write', 40, 'moodle', 4),
(58, 'moodle/category:viewcourselist', 'read', 40, 'moodle', 0),
(59, 'moodle/category:viewhiddencategories', 'read', 40, 'moodle', 0),
(60, 'moodle/cohort:manage', 'write', 40, 'moodle', 0),
(61, 'moodle/cohort:assign', 'write', 40, 'moodle', 0),
(62, 'moodle/cohort:view', 'read', 50, 'moodle', 0),
(63, 'moodle/course:create', 'write', 40, 'moodle', 4),
(64, 'moodle/course:creategroupconversations', 'write', 50, 'moodle', 4),
(65, 'moodle/course:request', 'write', 40, 'moodle', 0),
(66, 'moodle/course:delete', 'write', 50, 'moodle', 32),
(67, 'moodle/course:update', 'write', 50, 'moodle', 4),
(68, 'moodle/course:view', 'read', 50, 'moodle', 0),
(69, 'moodle/course:enrolreview', 'read', 50, 'moodle', 8),
(70, 'moodle/course:enrolconfig', 'write', 50, 'moodle', 8),
(71, 'moodle/course:reviewotherusers', 'read', 50, 'moodle', 0),
(72, 'moodle/course:bulkmessaging', 'write', 50, 'moodle', 16),
(73, 'moodle/course:viewhiddenuserfields', 'read', 50, 'moodle', 8),
(74, 'moodle/course:viewhiddencourses', 'read', 50, 'moodle', 0),
(75, 'moodle/course:visibility', 'write', 50, 'moodle', 0),
(76, 'moodle/course:managefiles', 'write', 50, 'moodle', 4),
(77, 'moodle/course:ignoreavailabilityrestrictions', 'read', 70, 'moodle', 0),
(78, 'moodle/course:ignorefilesizelimits', 'write', 50, 'moodle', 0),
(79, 'moodle/course:manageactivities', 'write', 70, 'moodle', 4),
(80, 'moodle/course:activityvisibility', 'write', 70, 'moodle', 0),
(81, 'moodle/course:viewhiddenactivities', 'read', 70, 'moodle', 0),
(82, 'moodle/course:viewparticipants', 'read', 50, 'moodle', 0),
(83, 'moodle/course:changefullname', 'write', 50, 'moodle', 4),
(84, 'moodle/course:changeshortname', 'write', 50, 'moodle', 4),
(85, 'moodle/course:changelockedcustomfields', 'write', 50, 'moodle', 16),
(86, 'moodle/course:configurecustomfields', 'write', 10, 'moodle', 16),
(87, 'moodle/course:renameroles', 'write', 50, 'moodle', 0),
(88, 'moodle/course:changeidnumber', 'write', 50, 'moodle', 4),
(89, 'moodle/course:changecategory', 'write', 50, 'moodle', 4),
(90, 'moodle/course:changesummary', 'write', 50, 'moodle', 4),
(91, 'moodle/course:setforcedlanguage', 'write', 50, 'moodle', 0),
(92, 'moodle/site:viewparticipants', 'read', 10, 'moodle', 0),
(93, 'moodle/course:isincompletionreports', 'read', 50, 'moodle', 0),
(94, 'moodle/course:viewscales', 'read', 50, 'moodle', 0),
(95, 'moodle/course:managescales', 'write', 50, 'moodle', 0),
(96, 'moodle/course:managegroups', 'write', 50, 'moodle', 4),
(97, 'moodle/course:reset', 'write', 50, 'moodle', 32),
(98, 'moodle/course:viewsuspendedusers', 'read', 50, 'moodle', 0),
(99, 'moodle/course:tag', 'write', 50, 'moodle', 16),
(100, 'moodle/blog:view', 'read', 10, 'moodle', 0),
(101, 'moodle/blog:search', 'read', 10, 'moodle', 0),
(102, 'moodle/blog:viewdrafts', 'read', 10, 'moodle', 8),
(103, 'moodle/blog:create', 'write', 10, 'moodle', 16),
(104, 'moodle/blog:manageentries', 'write', 10, 'moodle', 16),
(105, 'moodle/blog:manageexternal', 'write', 10, 'moodle', 16),
(106, 'moodle/calendar:manageownentries', 'write', 50, 'moodle', 16),
(107, 'moodle/calendar:managegroupentries', 'write', 50, 'moodle', 16),
(108, 'moodle/calendar:manageentries', 'write', 50, 'moodle', 16),
(109, 'moodle/user:editprofile', 'write', 30, 'moodle', 24),
(110, 'moodle/user:editownprofile', 'write', 10, 'moodle', 16),
(111, 'moodle/user:changeownpassword', 'write', 10, 'moodle', 0),
(112, 'moodle/user:readuserposts', 'read', 30, 'moodle', 0),
(113, 'moodle/user:readuserblogs', 'read', 30, 'moodle', 0),
(114, 'moodle/user:viewuseractivitiesreport', 'read', 30, 'moodle', 8),
(115, 'moodle/user:editmessageprofile', 'write', 30, 'moodle', 16),
(116, 'moodle/user:editownmessageprofile', 'write', 10, 'moodle', 0),
(117, 'moodle/question:managecategory', 'write', 50, 'moodle', 20),
(118, 'moodle/question:add', 'write', 50, 'moodle', 20),
(119, 'moodle/question:editmine', 'write', 50, 'moodle', 20),
(120, 'moodle/question:editall', 'write', 50, 'moodle', 20),
(121, 'moodle/question:viewmine', 'read', 50, 'moodle', 0),
(122, 'moodle/question:viewall', 'read', 50, 'moodle', 0),
(123, 'moodle/question:usemine', 'read', 50, 'moodle', 0),
(124, 'moodle/question:useall', 'read', 50, 'moodle', 0),
(125, 'moodle/question:movemine', 'write', 50, 'moodle', 0),
(126, 'moodle/question:moveall', 'write', 50, 'moodle', 0),
(127, 'moodle/question:config', 'write', 10, 'moodle', 2),
(128, 'moodle/question:flag', 'write', 50, 'moodle', 0),
(129, 'moodle/question:tagmine', 'write', 50, 'moodle', 0),
(130, 'moodle/question:tagall', 'write', 50, 'moodle', 0),
(131, 'moodle/site:doclinks', 'read', 10, 'moodle', 0),
(132, 'moodle/course:sectionvisibility', 'write', 50, 'moodle', 0),
(133, 'moodle/course:useremail', 'write', 50, 'moodle', 0),
(134, 'moodle/course:viewhiddensections', 'read', 50, 'moodle', 0),
(135, 'moodle/course:setcurrentsection', 'write', 50, 'moodle', 0),
(136, 'moodle/course:movesections', 'write', 50, 'moodle', 0),
(137, 'moodle/site:mnetlogintoremote', 'read', 10, 'moodle', 0),
(138, 'moodle/grade:viewall', 'read', 50, 'moodle', 8),
(139, 'moodle/grade:view', 'read', 50, 'moodle', 0),
(140, 'moodle/grade:viewhidden', 'read', 50, 'moodle', 8),
(141, 'moodle/grade:import', 'write', 50, 'moodle', 12),
(142, 'moodle/grade:export', 'read', 50, 'moodle', 8),
(143, 'moodle/grade:manage', 'write', 50, 'moodle', 12),
(144, 'moodle/grade:edit', 'write', 50, 'moodle', 12),
(145, 'moodle/grade:managegradingforms', 'write', 50, 'moodle', 12),
(146, 'moodle/grade:sharegradingforms', 'write', 10, 'moodle', 4),
(147, 'moodle/grade:managesharedforms', 'write', 10, 'moodle', 4),
(148, 'moodle/grade:manageoutcomes', 'write', 50, 'moodle', 0),
(149, 'moodle/grade:manageletters', 'write', 50, 'moodle', 0),
(150, 'moodle/grade:hide', 'write', 50, 'moodle', 0),
(151, 'moodle/grade:lock', 'write', 50, 'moodle', 0),
(152, 'moodle/grade:unlock', 'write', 50, 'moodle', 0),
(153, 'moodle/my:manageblocks', 'write', 10, 'moodle', 0),
(154, 'moodle/notes:view', 'read', 50, 'moodle', 0),
(155, 'moodle/notes:manage', 'write', 50, 'moodle', 16),
(156, 'moodle/tag:manage', 'write', 10, 'moodle', 16),
(157, 'moodle/tag:edit', 'write', 10, 'moodle', 16),
(158, 'moodle/tag:flag', 'write', 10, 'moodle', 16),
(159, 'moodle/tag:editblocks', 'write', 10, 'moodle', 0),
(160, 'moodle/block:view', 'read', 80, 'moodle', 0),
(161, 'moodle/block:edit', 'write', 80, 'moodle', 20),
(162, 'moodle/portfolio:export', 'read', 10, 'moodle', 0),
(163, 'moodle/comment:view', 'read', 50, 'moodle', 0),
(164, 'moodle/comment:post', 'write', 50, 'moodle', 24),
(165, 'moodle/comment:delete', 'write', 50, 'moodle', 32),
(166, 'moodle/webservice:createtoken', 'write', 10, 'moodle', 62),
(167, 'moodle/webservice:managealltokens', 'write', 10, 'moodle', 42),
(168, 'moodle/webservice:createmobiletoken', 'write', 10, 'moodle', 24),
(169, 'moodle/rating:view', 'read', 50, 'moodle', 0),
(170, 'moodle/rating:viewany', 'read', 50, 'moodle', 8),
(171, 'moodle/rating:viewall', 'read', 50, 'moodle', 8),
(172, 'moodle/rating:rate', 'write', 50, 'moodle', 0),
(173, 'moodle/course:markcomplete', 'write', 50, 'moodle', 0),
(174, 'moodle/course:overridecompletion', 'write', 50, 'moodle', 0),
(175, 'moodle/badges:manageglobalsettings', 'write', 10, 'moodle', 34),
(176, 'moodle/badges:viewbadges', 'read', 50, 'moodle', 0),
(177, 'moodle/badges:manageownbadges', 'write', 30, 'moodle', 0),
(178, 'moodle/badges:viewotherbadges', 'read', 30, 'moodle', 0),
(179, 'moodle/badges:earnbadge', 'write', 50, 'moodle', 0),
(180, 'moodle/badges:createbadge', 'write', 50, 'moodle', 16),
(181, 'moodle/badges:deletebadge', 'write', 50, 'moodle', 32),
(182, 'moodle/badges:configuredetails', 'write', 50, 'moodle', 16),
(183, 'moodle/badges:configurecriteria', 'write', 50, 'moodle', 4),
(184, 'moodle/badges:configuremessages', 'write', 50, 'moodle', 16),
(185, 'moodle/badges:awardbadge', 'write', 50, 'moodle', 16),
(186, 'moodle/badges:revokebadge', 'write', 50, 'moodle', 16),
(187, 'moodle/badges:viewawarded', 'read', 50, 'moodle', 8),
(188, 'moodle/site:forcelanguage', 'read', 10, 'moodle', 0),
(189, 'moodle/search:query', 'read', 10, 'moodle', 0),
(190, 'moodle/competency:competencymanage', 'write', 40, 'moodle', 0),
(191, 'moodle/competency:competencyview', 'read', 40, 'moodle', 0),
(192, 'moodle/competency:competencygrade', 'write', 50, 'moodle', 0),
(193, 'moodle/competency:coursecompetencymanage', 'write', 50, 'moodle', 0),
(194, 'moodle/competency:coursecompetencyconfigure', 'write', 70, 'moodle', 0),
(195, 'moodle/competency:coursecompetencygradable', 'read', 50, 'moodle', 0),
(196, 'moodle/competency:coursecompetencyview', 'read', 50, 'moodle', 0),
(197, 'moodle/competency:evidencedelete', 'write', 30, 'moodle', 0),
(198, 'moodle/competency:planmanage', 'write', 30, 'moodle', 0),
(199, 'moodle/competency:planmanagedraft', 'write', 30, 'moodle', 0),
(200, 'moodle/competency:planmanageown', 'write', 30, 'moodle', 0),
(201, 'moodle/competency:planmanageowndraft', 'write', 30, 'moodle', 0),
(202, 'moodle/competency:planview', 'read', 30, 'moodle', 0),
(203, 'moodle/competency:planviewdraft', 'read', 30, 'moodle', 0),
(204, 'moodle/competency:planviewown', 'read', 30, 'moodle', 0),
(205, 'moodle/competency:planviewowndraft', 'read', 30, 'moodle', 0),
(206, 'moodle/competency:planrequestreview', 'write', 30, 'moodle', 0),
(207, 'moodle/competency:planrequestreviewown', 'write', 30, 'moodle', 0),
(208, 'moodle/competency:planreview', 'write', 30, 'moodle', 0),
(209, 'moodle/competency:plancomment', 'write', 30, 'moodle', 0),
(210, 'moodle/competency:plancommentown', 'write', 30, 'moodle', 0),
(211, 'moodle/competency:usercompetencyview', 'read', 30, 'moodle', 0),
(212, 'moodle/competency:usercompetencyrequestreview', 'write', 30, 'moodle', 0),
(213, 'moodle/competency:usercompetencyrequestreviewown', 'write', 30, 'moodle', 0),
(214, 'moodle/competency:usercompetencyreview', 'write', 30, 'moodle', 0),
(215, 'moodle/competency:usercompetencycomment', 'write', 30, 'moodle', 0),
(216, 'moodle/competency:usercompetencycommentown', 'write', 30, 'moodle', 0),
(217, 'moodle/competency:templatemanage', 'write', 40, 'moodle', 0),
(218, 'moodle/analytics:listinsights', 'read', 50, 'moodle', 8),
(219, 'moodle/analytics:managemodels', 'write', 10, 'moodle', 2),
(220, 'moodle/competency:templateview', 'read', 40, 'moodle', 0),
(221, 'moodle/competency:userevidencemanage', 'write', 30, 'moodle', 0),
(222, 'moodle/competency:userevidencemanageown', 'write', 30, 'moodle', 0),
(223, 'moodle/competency:userevidenceview', 'read', 30, 'moodle', 0),
(224, 'moodle/site:maintenanceaccess', 'write', 10, 'moodle', 0),
(225, 'moodle/site:messageanyuser', 'write', 10, 'moodle', 16),
(226, 'moodle/site:managecontextlocks', 'write', 70, 'moodle', 0),
(227, 'moodle/course:togglecompletion', 'write', 70, 'moodle', 0),
(228, 'moodle/analytics:listowninsights', 'read', 10, 'moodle', 0),
(229, 'moodle/h5p:setdisplayoptions', 'write', 70, 'moodle', 0),
(230, 'moodle/h5p:deploy', 'write', 70, 'moodle', 4),
(231, 'moodle/h5p:updatelibraries', 'write', 70, 'moodle', 4),
(232, 'moodle/course:recommendactivity', 'write', 10, 'moodle', 0),
(233, 'moodle/contentbank:access', 'read', 50, 'moodle', 0),
(234, 'moodle/contentbank:upload', 'write', 50, 'moodle', 16),
(235, 'moodle/contentbank:deleteanycontent', 'write', 50, 'moodle', 32),
(236, 'moodle/contentbank:deleteowncontent', 'write', 50, 'moodle', 0),
(237, 'moodle/contentbank:manageanycontent', 'write', 50, 'moodle', 32),
(238, 'moodle/contentbank:manageowncontent', 'write', 50, 'moodle', 0),
(239, 'moodle/contentbank:useeditor', 'write', 50, 'moodle', 16),
(240, 'moodle/contentbank:downloadcontent', 'read', 50, 'moodle', 0),
(241, 'moodle/course:downloadcoursecontent', 'read', 50, 'moodle', 0),
(242, 'moodle/course:configuredownloadcontent', 'write', 50, 'moodle', 0),
(243, 'moodle/payment:manageaccounts', 'write', 50, 'moodle', 42),
(244, 'moodle/payment:viewpayments', 'read', 50, 'moodle', 8),
(245, 'moodle/contentbank:viewunlistedcontent', 'read', 50, 'moodle', 0),
(246, 'mod/assign:view', 'read', 70, 'mod_assign', 0),
(247, 'mod/assign:submit', 'write', 70, 'mod_assign', 0),
(248, 'mod/assign:grade', 'write', 70, 'mod_assign', 4),
(249, 'mod/assign:exportownsubmission', 'read', 70, 'mod_assign', 0),
(250, 'mod/assign:addinstance', 'write', 50, 'mod_assign', 4),
(251, 'mod/assign:editothersubmission', 'write', 70, 'mod_assign', 41),
(252, 'mod/assign:grantextension', 'write', 70, 'mod_assign', 0),
(253, 'mod/assign:revealidentities', 'write', 70, 'mod_assign', 0),
(254, 'mod/assign:reviewgrades', 'write', 70, 'mod_assign', 0),
(255, 'mod/assign:releasegrades', 'write', 70, 'mod_assign', 0),
(256, 'mod/assign:managegrades', 'write', 70, 'mod_assign', 0),
(257, 'mod/assign:manageallocations', 'write', 70, 'mod_assign', 0),
(258, 'mod/assign:viewgrades', 'read', 70, 'mod_assign', 0),
(259, 'mod/assign:viewblinddetails', 'write', 70, 'mod_assign', 8),
(260, 'mod/assign:receivegradernotifications', 'read', 70, 'mod_assign', 0),
(261, 'mod/assign:manageoverrides', 'write', 70, 'mod_assign', 0),
(262, 'mod/assign:showhiddengrader', 'read', 70, 'mod_assign', 0),
(263, 'mod/assign:viewownsubmissionsummary', 'read', 70, 'mod_assign', 0),
(264, 'mod/assignment:view', 'read', 70, 'mod_assignment', 0),
(265, 'mod/assignment:addinstance', 'write', 50, 'mod_assignment', 4),
(266, 'mod/assignment:submit', 'write', 70, 'mod_assignment', 0),
(267, 'mod/assignment:grade', 'write', 70, 'mod_assignment', 4),
(268, 'mod/assignment:exportownsubmission', 'read', 70, 'mod_assignment', 0),
(269, 'mod/book:addinstance', 'write', 50, 'mod_book', 4),
(270, 'mod/book:read', 'read', 70, 'mod_book', 0),
(271, 'mod/book:viewhiddenchapters', 'read', 70, 'mod_book', 0),
(272, 'mod/book:edit', 'write', 70, 'mod_book', 4),
(273, 'mod/chat:addinstance', 'write', 50, 'mod_chat', 4),
(274, 'mod/chat:chat', 'write', 70, 'mod_chat', 16),
(275, 'mod/chat:readlog', 'read', 70, 'mod_chat', 0),
(276, 'mod/chat:deletelog', 'write', 70, 'mod_chat', 0),
(277, 'mod/chat:exportparticipatedsession', 'read', 70, 'mod_chat', 8),
(278, 'mod/chat:exportsession', 'read', 70, 'mod_chat', 8),
(279, 'mod/chat:view', 'read', 70, 'mod_chat', 0),
(280, 'mod/choice:addinstance', 'write', 50, 'mod_choice', 4),
(281, 'mod/choice:choose', 'write', 70, 'mod_choice', 0),
(282, 'mod/choice:readresponses', 'read', 70, 'mod_choice', 0),
(283, 'mod/choice:deleteresponses', 'write', 70, 'mod_choice', 0),
(284, 'mod/choice:downloadresponses', 'read', 70, 'mod_choice', 0),
(285, 'mod/choice:view', 'read', 70, 'mod_choice', 0),
(286, 'mod/data:addinstance', 'write', 50, 'mod_data', 4),
(287, 'mod/data:viewentry', 'read', 70, 'mod_data', 0),
(288, 'mod/data:writeentry', 'write', 70, 'mod_data', 16),
(289, 'mod/data:comment', 'write', 70, 'mod_data', 16),
(290, 'mod/data:rate', 'write', 70, 'mod_data', 0),
(291, 'mod/data:viewrating', 'read', 70, 'mod_data', 0),
(292, 'mod/data:viewanyrating', 'read', 70, 'mod_data', 8),
(293, 'mod/data:viewallratings', 'read', 70, 'mod_data', 8),
(294, 'mod/data:approve', 'write', 70, 'mod_data', 16),
(295, 'mod/data:manageentries', 'write', 70, 'mod_data', 16),
(296, 'mod/data:managecomments', 'write', 70, 'mod_data', 16),
(297, 'mod/data:managetemplates', 'write', 70, 'mod_data', 20),
(298, 'mod/data:viewalluserpresets', 'read', 70, 'mod_data', 0),
(299, 'mod/data:manageuserpresets', 'write', 70, 'mod_data', 20),
(300, 'mod/data:exportentry', 'read', 70, 'mod_data', 8),
(301, 'mod/data:exportownentry', 'read', 70, 'mod_data', 0),
(302, 'mod/data:exportallentries', 'read', 70, 'mod_data', 8),
(303, 'mod/data:exportuserinfo', 'read', 70, 'mod_data', 8),
(304, 'mod/data:view', 'read', 70, 'mod_data', 0),
(305, 'mod/feedback:addinstance', 'write', 50, 'mod_feedback', 4),
(306, 'mod/feedback:view', 'read', 70, 'mod_feedback', 0),
(307, 'mod/feedback:complete', 'write', 70, 'mod_feedback', 16),
(308, 'mod/feedback:viewanalysepage', 'read', 70, 'mod_feedback', 8),
(309, 'mod/feedback:deletesubmissions', 'write', 70, 'mod_feedback', 0),
(310, 'mod/feedback:mapcourse', 'write', 70, 'mod_feedback', 0),
(311, 'mod/feedback:edititems', 'write', 70, 'mod_feedback', 20),
(312, 'mod/feedback:createprivatetemplate', 'write', 70, 'mod_feedback', 16),
(313, 'mod/feedback:createpublictemplate', 'write', 70, 'mod_feedback', 16),
(314, 'mod/feedback:deletetemplate', 'write', 70, 'mod_feedback', 0),
(315, 'mod/feedback:viewreports', 'read', 70, 'mod_feedback', 8),
(316, 'mod/feedback:receivemail', 'read', 70, 'mod_feedback', 8),
(317, 'mod/folder:addinstance', 'write', 50, 'mod_folder', 4),
(318, 'mod/folder:view', 'read', 70, 'mod_folder', 0),
(319, 'mod/folder:managefiles', 'write', 70, 'mod_folder', 20),
(320, 'mod/forum:addinstance', 'write', 50, 'mod_forum', 4),
(321, 'mod/forum:viewdiscussion', 'read', 70, 'mod_forum', 0),
(322, 'mod/forum:viewhiddentimedposts', 'read', 70, 'mod_forum', 0),
(323, 'mod/forum:startdiscussion', 'write', 70, 'mod_forum', 16),
(324, 'mod/forum:replypost', 'write', 70, 'mod_forum', 16),
(325, 'mod/forum:addnews', 'write', 70, 'mod_forum', 16),
(326, 'mod/forum:replynews', 'write', 70, 'mod_forum', 16),
(327, 'mod/forum:viewrating', 'read', 70, 'mod_forum', 0),
(328, 'mod/forum:viewanyrating', 'read', 70, 'mod_forum', 8),
(329, 'mod/forum:viewallratings', 'read', 70, 'mod_forum', 8),
(330, 'mod/forum:rate', 'write', 70, 'mod_forum', 0),
(331, 'mod/forum:postprivatereply', 'write', 70, 'mod_forum', 0),
(332, 'mod/forum:readprivatereplies', 'read', 70, 'mod_forum', 0),
(333, 'mod/forum:createattachment', 'write', 70, 'mod_forum', 16),
(334, 'mod/forum:deleteownpost', 'write', 70, 'mod_forum', 0),
(335, 'mod/forum:deleteanypost', 'write', 70, 'mod_forum', 0),
(336, 'mod/forum:splitdiscussions', 'write', 70, 'mod_forum', 0),
(337, 'mod/forum:movediscussions', 'write', 70, 'mod_forum', 0),
(338, 'mod/forum:pindiscussions', 'write', 70, 'mod_forum', 0),
(339, 'mod/forum:editanypost', 'write', 70, 'mod_forum', 16),
(340, 'mod/forum:viewqandawithoutposting', 'read', 70, 'mod_forum', 0),
(341, 'mod/forum:viewsubscribers', 'read', 70, 'mod_forum', 0),
(342, 'mod/forum:managesubscriptions', 'write', 70, 'mod_forum', 16),
(343, 'mod/forum:postwithoutthrottling', 'write', 70, 'mod_forum', 16),
(344, 'mod/forum:exportdiscussion', 'read', 70, 'mod_forum', 8),
(345, 'mod/forum:exportforum', 'read', 70, 'mod_forum', 8),
(346, 'mod/forum:exportpost', 'read', 70, 'mod_forum', 8),
(347, 'mod/forum:exportownpost', 'read', 70, 'mod_forum', 8),
(348, 'mod/forum:addquestion', 'write', 70, 'mod_forum', 16),
(349, 'mod/forum:allowforcesubscribe', 'read', 70, 'mod_forum', 0),
(350, 'mod/forum:canposttomygroups', 'write', 70, 'mod_forum', 0),
(351, 'mod/forum:canoverridediscussionlock', 'write', 70, 'mod_forum', 0),
(352, 'mod/forum:canoverridecutoff', 'write', 70, 'mod_forum', 0),
(353, 'mod/forum:cantogglefavourite', 'write', 70, 'mod_forum', 0),
(354, 'mod/forum:grade', 'write', 70, 'mod_forum', 0),
(355, 'mod/glossary:addinstance', 'write', 50, 'mod_glossary', 4),
(356, 'mod/glossary:view', 'read', 70, 'mod_glossary', 0),
(357, 'mod/glossary:write', 'write', 70, 'mod_glossary', 16),
(358, 'mod/glossary:manageentries', 'write', 70, 'mod_glossary', 16),
(359, 'mod/glossary:managecategories', 'write', 70, 'mod_glossary', 16),
(360, 'mod/glossary:comment', 'write', 70, 'mod_glossary', 16),
(361, 'mod/glossary:managecomments', 'write', 70, 'mod_glossary', 16),
(362, 'mod/glossary:import', 'write', 70, 'mod_glossary', 16),
(363, 'mod/glossary:export', 'read', 70, 'mod_glossary', 0),
(364, 'mod/glossary:approve', 'write', 70, 'mod_glossary', 16),
(365, 'mod/glossary:rate', 'write', 70, 'mod_glossary', 0),
(366, 'mod/glossary:viewrating', 'read', 70, 'mod_glossary', 0),
(367, 'mod/glossary:viewanyrating', 'read', 70, 'mod_glossary', 8),
(368, 'mod/glossary:viewallratings', 'read', 70, 'mod_glossary', 8),
(369, 'mod/glossary:exportentry', 'read', 70, 'mod_glossary', 8),
(370, 'mod/glossary:exportownentry', 'read', 70, 'mod_glossary', 0),
(371, 'mod/h5pactivity:view', 'read', 70, 'mod_h5pactivity', 0),
(372, 'mod/h5pactivity:addinstance', 'write', 50, 'mod_h5pactivity', 0),
(373, 'mod/h5pactivity:submit', 'write', 70, 'mod_h5pactivity', 0),
(374, 'mod/h5pactivity:reviewattempts', 'read', 70, 'mod_h5pactivity', 0),
(375, 'mod/imscp:view', 'read', 70, 'mod_imscp', 0),
(376, 'mod/imscp:addinstance', 'write', 50, 'mod_imscp', 4),
(377, 'mod/label:addinstance', 'write', 50, 'mod_label', 4),
(378, 'mod/label:view', 'read', 70, 'mod_label', 0),
(379, 'mod/lesson:addinstance', 'write', 50, 'mod_lesson', 4),
(380, 'mod/lesson:edit', 'write', 70, 'mod_lesson', 4),
(381, 'mod/lesson:grade', 'write', 70, 'mod_lesson', 20),
(382, 'mod/lesson:viewreports', 'read', 70, 'mod_lesson', 8),
(383, 'mod/lesson:manage', 'write', 70, 'mod_lesson', 0),
(384, 'mod/lesson:manageoverrides', 'write', 70, 'mod_lesson', 0),
(385, 'mod/lesson:view', 'read', 70, 'mod_lesson', 0),
(386, 'mod/lti:view', 'read', 70, 'mod_lti', 0),
(387, 'mod/lti:addinstance', 'write', 50, 'mod_lti', 4),
(388, 'mod/lti:manage', 'write', 70, 'mod_lti', 8),
(389, 'mod/lti:admin', 'write', 70, 'mod_lti', 8),
(390, 'mod/lti:addcoursetool', 'write', 50, 'mod_lti', 0),
(391, 'mod/lti:addpreconfiguredinstance', 'write', 50, 'mod_lti', 0),
(392, 'mod/lti:addmanualinstance', 'write', 50, 'mod_lti', 0),
(393, 'mod/lti:requesttooladd', 'write', 50, 'mod_lti', 0),
(394, 'mod/page:view', 'read', 70, 'mod_page', 0),
(395, 'mod/page:addinstance', 'write', 50, 'mod_page', 4),
(396, 'mod/quiz:view', 'read', 70, 'mod_quiz', 0),
(397, 'mod/quiz:addinstance', 'write', 50, 'mod_quiz', 4),
(398, 'mod/quiz:attempt', 'write', 70, 'mod_quiz', 16),
(399, 'mod/quiz:reviewmyattempts', 'read', 70, 'mod_quiz', 0),
(400, 'mod/quiz:manage', 'write', 70, 'mod_quiz', 16),
(401, 'mod/quiz:manageoverrides', 'write', 70, 'mod_quiz', 0),
(402, 'mod/quiz:viewoverrides', 'read', 70, 'mod_quiz', 0),
(403, 'mod/quiz:preview', 'write', 70, 'mod_quiz', 0),
(404, 'mod/quiz:grade', 'write', 70, 'mod_quiz', 20),
(405, 'mod/quiz:regrade', 'write', 70, 'mod_quiz', 16),
(406, 'mod/quiz:viewreports', 'read', 70, 'mod_quiz', 8),
(407, 'mod/quiz:deleteattempts', 'write', 70, 'mod_quiz', 32),
(408, 'mod/quiz:ignoretimelimits', 'read', 70, 'mod_quiz', 0),
(409, 'mod/quiz:emailconfirmsubmission', 'read', 70, 'mod_quiz', 0),
(410, 'mod/quiz:emailnotifysubmission', 'read', 70, 'mod_quiz', 0),
(411, 'mod/quiz:emailwarnoverdue', 'read', 70, 'mod_quiz', 0),
(412, 'mod/resource:view', 'read', 70, 'mod_resource', 0),
(413, 'mod/resource:addinstance', 'write', 50, 'mod_resource', 4),
(414, 'mod/scorm:addinstance', 'write', 50, 'mod_scorm', 4),
(415, 'mod/scorm:viewreport', 'read', 70, 'mod_scorm', 0),
(416, 'mod/scorm:skipview', 'read', 70, 'mod_scorm', 0),
(417, 'mod/scorm:savetrack', 'write', 70, 'mod_scorm', 0),
(418, 'mod/scorm:viewscores', 'read', 70, 'mod_scorm', 0),
(419, 'mod/scorm:deleteresponses', 'write', 70, 'mod_scorm', 0),
(420, 'mod/scorm:deleteownresponses', 'write', 70, 'mod_scorm', 0),
(421, 'mod/survey:addinstance', 'write', 50, 'mod_survey', 4),
(422, 'mod/survey:participate', 'read', 70, 'mod_survey', 0),
(423, 'mod/survey:readresponses', 'read', 70, 'mod_survey', 0),
(424, 'mod/survey:download', 'read', 70, 'mod_survey', 0),
(425, 'mod/url:view', 'read', 70, 'mod_url', 0),
(426, 'mod/url:addinstance', 'write', 50, 'mod_url', 4),
(427, 'mod/wiki:addinstance', 'write', 50, 'mod_wiki', 4),
(428, 'mod/wiki:viewpage', 'read', 70, 'mod_wiki', 0),
(429, 'mod/wiki:editpage', 'write', 70, 'mod_wiki', 16),
(430, 'mod/wiki:createpage', 'write', 70, 'mod_wiki', 16),
(431, 'mod/wiki:viewcomment', 'read', 70, 'mod_wiki', 0),
(432, 'mod/wiki:editcomment', 'write', 70, 'mod_wiki', 16),
(433, 'mod/wiki:managecomment', 'write', 70, 'mod_wiki', 0),
(434, 'mod/wiki:managefiles', 'write', 70, 'mod_wiki', 0),
(435, 'mod/wiki:overridelock', 'write', 70, 'mod_wiki', 0),
(436, 'mod/wiki:managewiki', 'write', 70, 'mod_wiki', 0),
(437, 'mod/workshop:view', 'read', 70, 'mod_workshop', 0),
(438, 'mod/workshop:addinstance', 'write', 50, 'mod_workshop', 4),
(439, 'mod/workshop:switchphase', 'write', 70, 'mod_workshop', 0),
(440, 'mod/workshop:editdimensions', 'write', 70, 'mod_workshop', 4),
(441, 'mod/workshop:submit', 'write', 70, 'mod_workshop', 0),
(442, 'mod/workshop:peerassess', 'write', 70, 'mod_workshop', 0),
(443, 'mod/workshop:manageexamples', 'write', 70, 'mod_workshop', 0),
(444, 'mod/workshop:allocate', 'write', 70, 'mod_workshop', 0),
(445, 'mod/workshop:publishsubmissions', 'write', 70, 'mod_workshop', 0),
(446, 'mod/workshop:viewauthornames', 'read', 70, 'mod_workshop', 0),
(447, 'mod/workshop:viewreviewernames', 'read', 70, 'mod_workshop', 0),
(448, 'mod/workshop:viewallsubmissions', 'read', 70, 'mod_workshop', 0),
(449, 'mod/workshop:viewpublishedsubmissions', 'read', 70, 'mod_workshop', 0),
(450, 'mod/workshop:viewauthorpublished', 'read', 70, 'mod_workshop', 0),
(451, 'mod/workshop:viewallassessments', 'read', 70, 'mod_workshop', 0),
(452, 'mod/workshop:overridegrades', 'write', 70, 'mod_workshop', 0),
(453, 'mod/workshop:ignoredeadlines', 'write', 70, 'mod_workshop', 0),
(454, 'mod/workshop:deletesubmissions', 'write', 70, 'mod_workshop', 0),
(455, 'mod/workshop:exportsubmissions', 'read', 70, 'mod_workshop', 0),
(456, 'auth/oauth2:managelinkedlogins', 'write', 30, 'auth_oauth2', 0),
(457, 'enrol/category:synchronised', 'write', 10, 'enrol_category', 0),
(458, 'enrol/category:config', 'write', 50, 'enrol_category', 0),
(459, 'enrol/cohort:config', 'write', 50, 'enrol_cohort', 0),
(460, 'enrol/cohort:unenrol', 'write', 50, 'enrol_cohort', 0),
(461, 'enrol/database:unenrol', 'write', 50, 'enrol_database', 0),
(462, 'enrol/database:config', 'write', 50, 'enrol_database', 0),
(463, 'enrol/fee:config', 'write', 50, 'enrol_fee', 0),
(464, 'enrol/fee:manage', 'write', 50, 'enrol_fee', 0),
(465, 'enrol/fee:unenrol', 'write', 50, 'enrol_fee', 0),
(466, 'enrol/fee:unenrolself', 'write', 50, 'enrol_fee', 0),
(467, 'enrol/flatfile:manage', 'write', 50, 'enrol_flatfile', 0),
(468, 'enrol/flatfile:unenrol', 'write', 50, 'enrol_flatfile', 0),
(469, 'enrol/guest:config', 'write', 50, 'enrol_guest', 0),
(470, 'enrol/imsenterprise:config', 'write', 50, 'enrol_imsenterprise', 0),
(471, 'enrol/ldap:manage', 'write', 50, 'enrol_ldap', 0),
(472, 'enrol/lti:config', 'write', 50, 'enrol_lti', 0),
(473, 'enrol/lti:unenrol', 'write', 50, 'enrol_lti', 0),
(474, 'enrol/manual:config', 'write', 50, 'enrol_manual', 0),
(475, 'enrol/manual:enrol', 'write', 50, 'enrol_manual', 0),
(476, 'enrol/manual:manage', 'write', 50, 'enrol_manual', 0),
(477, 'enrol/manual:unenrol', 'write', 50, 'enrol_manual', 0),
(478, 'enrol/manual:unenrolself', 'write', 50, 'enrol_manual', 0),
(479, 'enrol/meta:config', 'write', 50, 'enrol_meta', 0),
(480, 'enrol/meta:selectaslinked', 'read', 50, 'enrol_meta', 0),
(481, 'enrol/meta:unenrol', 'write', 50, 'enrol_meta', 0),
(482, 'enrol/mnet:config', 'write', 50, 'enrol_mnet', 0),
(483, 'enrol/paypal:config', 'write', 50, 'enrol_paypal', 0),
(484, 'enrol/paypal:manage', 'write', 50, 'enrol_paypal', 0),
(485, 'enrol/paypal:unenrol', 'write', 50, 'enrol_paypal', 0),
(486, 'enrol/paypal:unenrolself', 'write', 50, 'enrol_paypal', 0),
(487, 'enrol/self:config', 'write', 50, 'enrol_self', 0),
(488, 'enrol/self:manage', 'write', 50, 'enrol_self', 0),
(489, 'enrol/self:holdkey', 'write', 50, 'enrol_self', 0),
(490, 'enrol/self:unenrolself', 'write', 50, 'enrol_self', 0),
(491, 'enrol/self:unenrol', 'write', 50, 'enrol_self', 0),
(492, 'enrol/self:enrolself', 'write', 50, 'enrol_self', 0),
(493, 'message/airnotifier:managedevice', 'write', 10, 'message_airnotifier', 0),
(494, 'block/accessreview:addinstance', 'write', 80, 'block_accessreview', 0),
(495, 'block/accessreview:view', 'read', 80, 'block_accessreview', 0),
(496, 'block/activity_modules:addinstance', 'write', 80, 'block_activity_modules', 20),
(497, 'block/activity_results:addinstance', 'write', 80, 'block_activity_results', 20),
(498, 'block/admin_bookmarks:myaddinstance', 'write', 10, 'block_admin_bookmarks', 0),
(499, 'block/admin_bookmarks:addinstance', 'write', 80, 'block_admin_bookmarks', 20),
(500, 'block/badges:addinstance', 'read', 80, 'block_badges', 0),
(501, 'block/badges:myaddinstance', 'read', 10, 'block_badges', 8),
(502, 'block/blog_menu:addinstance', 'write', 80, 'block_blog_menu', 20),
(503, 'block/blog_recent:addinstance', 'write', 80, 'block_blog_recent', 20),
(504, 'block/blog_tags:addinstance', 'write', 80, 'block_blog_tags', 20),
(505, 'block/calendar_month:myaddinstance', 'write', 10, 'block_calendar_month', 0),
(506, 'block/calendar_month:addinstance', 'write', 80, 'block_calendar_month', 20),
(507, 'block/calendar_upcoming:myaddinstance', 'write', 10, 'block_calendar_upcoming', 0),
(508, 'block/calendar_upcoming:addinstance', 'write', 80, 'block_calendar_upcoming', 20),
(509, 'block/comments:myaddinstance', 'write', 10, 'block_comments', 0),
(510, 'block/comments:addinstance', 'write', 80, 'block_comments', 20),
(511, 'block/completionstatus:addinstance', 'write', 80, 'block_completionstatus', 20),
(512, 'block/course_list:myaddinstance', 'write', 10, 'block_course_list', 0),
(513, 'block/course_list:addinstance', 'write', 80, 'block_course_list', 20),
(514, 'block/course_summary:addinstance', 'write', 80, 'block_course_summary', 20),
(515, 'block/feedback:addinstance', 'write', 80, 'block_feedback', 20),
(516, 'block/globalsearch:myaddinstance', 'write', 10, 'block_globalsearch', 0),
(517, 'block/globalsearch:addinstance', 'write', 80, 'block_globalsearch', 0),
(518, 'block/glossary_random:myaddinstance', 'write', 10, 'block_glossary_random', 0),
(519, 'block/glossary_random:addinstance', 'write', 80, 'block_glossary_random', 20),
(520, 'block/html:myaddinstance', 'write', 10, 'block_html', 0),
(521, 'block/html:addinstance', 'write', 80, 'block_html', 20),
(522, 'block/login:addinstance', 'write', 80, 'block_login', 20),
(523, 'block/lp:addinstance', 'write', 10, 'block_lp', 0),
(524, 'block/lp:myaddinstance', 'write', 10, 'block_lp', 0),
(525, 'block/mentees:myaddinstance', 'write', 10, 'block_mentees', 0),
(526, 'block/mentees:addinstance', 'write', 80, 'block_mentees', 20),
(527, 'block/mnet_hosts:myaddinstance', 'write', 10, 'block_mnet_hosts', 0),
(528, 'block/mnet_hosts:addinstance', 'write', 80, 'block_mnet_hosts', 20),
(529, 'block/myoverview:myaddinstance', 'write', 10, 'block_myoverview', 0),
(530, 'block/myprofile:myaddinstance', 'write', 10, 'block_myprofile', 0),
(531, 'block/myprofile:addinstance', 'write', 80, 'block_myprofile', 20),
(532, 'block/navigation:myaddinstance', 'write', 10, 'block_navigation', 0),
(533, 'block/navigation:addinstance', 'write', 80, 'block_navigation', 20),
(534, 'block/news_items:myaddinstance', 'write', 10, 'block_news_items', 0),
(535, 'block/news_items:addinstance', 'write', 80, 'block_news_items', 20),
(536, 'block/online_users:myaddinstance', 'write', 10, 'block_online_users', 0),
(537, 'block/online_users:addinstance', 'write', 80, 'block_online_users', 20),
(538, 'block/online_users:viewlist', 'read', 80, 'block_online_users', 0),
(539, 'block/private_files:myaddinstance', 'write', 10, 'block_private_files', 0),
(540, 'block/private_files:addinstance', 'write', 80, 'block_private_files', 20),
(541, 'block/quiz_results:addinstance', 'write', 80, 'block_quiz_results', 20),
(542, 'block/recent_activity:addinstance', 'write', 80, 'block_recent_activity', 20),
(543, 'block/recent_activity:viewaddupdatemodule', 'read', 50, 'block_recent_activity', 0),
(544, 'block/recent_activity:viewdeletemodule', 'read', 50, 'block_recent_activity', 0),
(545, 'block/recentlyaccessedcourses:myaddinstance', 'write', 10, 'block_recentlyaccessedcourses', 0),
(546, 'block/recentlyaccesseditems:myaddinstance', 'write', 10, 'block_recentlyaccesseditems', 0),
(547, 'block/rss_client:myaddinstance', 'write', 10, 'block_rss_client', 0),
(548, 'block/rss_client:addinstance', 'write', 80, 'block_rss_client', 20),
(549, 'block/rss_client:manageownfeeds', 'write', 80, 'block_rss_client', 0),
(550, 'block/rss_client:manageanyfeeds', 'write', 80, 'block_rss_client', 16),
(551, 'block/search_forums:addinstance', 'write', 80, 'block_search_forums', 20),
(552, 'block/section_links:addinstance', 'write', 80, 'block_section_links', 20),
(553, 'block/selfcompletion:addinstance', 'write', 80, 'block_selfcompletion', 20),
(554, 'block/settings:myaddinstance', 'write', 10, 'block_settings', 0),
(555, 'block/settings:addinstance', 'write', 80, 'block_settings', 20),
(556, 'block/site_main_menu:addinstance', 'write', 80, 'block_site_main_menu', 20),
(557, 'block/social_activities:addinstance', 'write', 80, 'block_social_activities', 20),
(558, 'block/starredcourses:myaddinstance', 'write', 10, 'block_starredcourses', 0),
(559, 'block/tag_flickr:addinstance', 'write', 80, 'block_tag_flickr', 20),
(560, 'block/tag_youtube:addinstance', 'write', 80, 'block_tag_youtube', 20),
(561, 'block/tags:myaddinstance', 'write', 10, 'block_tags', 0),
(562, 'block/tags:addinstance', 'write', 80, 'block_tags', 20),
(563, 'block/timeline:myaddinstance', 'write', 10, 'block_timeline', 0),
(564, 'report/completion:view', 'read', 50, 'report_completion', 8),
(565, 'report/courseoverview:view', 'read', 10, 'report_courseoverview', 8),
(566, 'report/log:view', 'read', 50, 'report_log', 8),
(567, 'report/log:viewtoday', 'read', 50, 'report_log', 8),
(568, 'report/loglive:view', 'read', 50, 'report_loglive', 8),
(569, 'report/outline:view', 'read', 50, 'report_outline', 8),
(570, 'report/outline:viewuserreport', 'read', 50, 'report_outline', 8),
(571, 'report/participation:view', 'read', 50, 'report_participation', 8),
(572, 'report/performance:view', 'read', 10, 'report_performance', 2),
(573, 'report/progress:view', 'read', 50, 'report_progress', 8),
(574, 'report/questioninstances:view', 'read', 10, 'report_questioninstances', 0),
(575, 'report/security:view', 'read', 10, 'report_security', 2),
(576, 'report/stats:view', 'read', 50, 'report_stats', 8),
(577, 'report/status:view', 'read', 10, 'report_status', 2),
(578, 'report/usersessions:manageownsessions', 'write', 30, 'report_usersessions', 0),
(579, 'gradeexport/ods:view', 'read', 50, 'gradeexport_ods', 8),
(580, 'gradeexport/ods:publish', 'read', 50, 'gradeexport_ods', 8),
(581, 'gradeexport/txt:view', 'read', 50, 'gradeexport_txt', 8),
(582, 'gradeexport/txt:publish', 'read', 50, 'gradeexport_txt', 8),
(583, 'gradeexport/xls:view', 'read', 50, 'gradeexport_xls', 8),
(584, 'gradeexport/xls:publish', 'read', 50, 'gradeexport_xls', 8),
(585, 'gradeexport/xml:view', 'read', 50, 'gradeexport_xml', 8),
(586, 'gradeexport/xml:publish', 'read', 50, 'gradeexport_xml', 8),
(587, 'gradeimport/csv:view', 'write', 50, 'gradeimport_csv', 0),
(588, 'gradeimport/direct:view', 'write', 50, 'gradeimport_direct', 0),
(589, 'gradeimport/xml:view', 'write', 50, 'gradeimport_xml', 0),
(590, 'gradeimport/xml:publish', 'write', 50, 'gradeimport_xml', 0),
(591, 'gradereport/grader:view', 'read', 50, 'gradereport_grader', 8),
(592, 'gradereport/history:view', 'read', 50, 'gradereport_history', 8),
(593, 'gradereport/outcomes:view', 'read', 50, 'gradereport_outcomes', 8),
(594, 'gradereport/overview:view', 'read', 50, 'gradereport_overview', 8),
(595, 'gradereport/singleview:view', 'read', 50, 'gradereport_singleview', 8),
(596, 'gradereport/user:view', 'read', 50, 'gradereport_user', 8),
(597, 'webservice/rest:use', 'read', 50, 'webservice_rest', 0),
(598, 'webservice/soap:use', 'read', 50, 'webservice_soap', 0),
(599, 'webservice/xmlrpc:use', 'read', 50, 'webservice_xmlrpc', 0),
(600, 'repository/areafiles:view', 'read', 70, 'repository_areafiles', 0),
(601, 'repository/boxnet:view', 'read', 70, 'repository_boxnet', 0),
(602, 'repository/contentbank:view', 'read', 70, 'repository_contentbank', 0),
(603, 'repository/contentbank:accesscoursecontent', 'read', 50, 'repository_contentbank', 0),
(604, 'repository/contentbank:accesscoursecategorycontent', 'read', 40, 'repository_contentbank', 0),
(605, 'repository/contentbank:accessgeneralcontent', 'read', 40, 'repository_contentbank', 0),
(606, 'repository/coursefiles:view', 'read', 70, 'repository_coursefiles', 0),
(607, 'repository/dropbox:view', 'read', 70, 'repository_dropbox', 0),
(608, 'repository/equella:view', 'read', 70, 'repository_equella', 0),
(609, 'repository/filesystem:view', 'read', 70, 'repository_filesystem', 0),
(610, 'repository/flickr:view', 'read', 70, 'repository_flickr', 0),
(611, 'repository/flickr_public:view', 'read', 70, 'repository_flickr_public', 0),
(612, 'repository/googledocs:view', 'read', 70, 'repository_googledocs', 0),
(613, 'repository/local:view', 'read', 70, 'repository_local', 0),
(614, 'repository/merlot:view', 'read', 70, 'repository_merlot', 0),
(615, 'repository/nextcloud:view', 'read', 70, 'repository_nextcloud', 0),
(616, 'repository/onedrive:view', 'read', 70, 'repository_onedrive', 0),
(617, 'repository/picasa:view', 'read', 70, 'repository_picasa', 0),
(618, 'repository/recent:view', 'read', 70, 'repository_recent', 0),
(619, 'repository/s3:view', 'read', 70, 'repository_s3', 0),
(620, 'repository/skydrive:view', 'read', 70, 'repository_skydrive', 0),
(621, 'repository/upload:view', 'read', 70, 'repository_upload', 0),
(622, 'repository/url:view', 'read', 70, 'repository_url', 0),
(623, 'repository/user:view', 'read', 70, 'repository_user', 0),
(624, 'repository/webdav:view', 'read', 70, 'repository_webdav', 0),
(625, 'repository/wikimedia:view', 'read', 70, 'repository_wikimedia', 0),
(626, 'repository/youtube:view', 'read', 70, 'repository_youtube', 0),
(627, 'tool/brickfield:viewcoursetools', 'read', 50, 'tool_brickfield', 8),
(628, 'tool/brickfield:viewsystemtools', 'read', 10, 'tool_brickfield', 2),
(629, 'tool/customlang:view', 'read', 10, 'tool_customlang', 2),
(630, 'tool/customlang:edit', 'write', 10, 'tool_customlang', 6),
(631, 'tool/customlang:export', 'read', 10, 'tool_customlang', 2),
(632, 'tool/dataprivacy:managedatarequests', 'write', 10, 'tool_dataprivacy', 60),
(633, 'tool/dataprivacy:requestdeleteforotheruser', 'write', 10, 'tool_dataprivacy', 60),
(634, 'tool/dataprivacy:managedataregistry', 'write', 10, 'tool_dataprivacy', 60),
(635, 'tool/dataprivacy:makedatarequestsforchildren', 'write', 30, 'tool_dataprivacy', 24),
(636, 'tool/dataprivacy:makedatadeletionrequestsforchildren', 'write', 30, 'tool_dataprivacy', 24),
(637, 'tool/dataprivacy:downloadownrequest', 'read', 30, 'tool_dataprivacy', 0),
(638, 'tool/dataprivacy:downloadallrequests', 'read', 30, 'tool_dataprivacy', 8),
(639, 'tool/dataprivacy:requestdelete', 'write', 30, 'tool_dataprivacy', 32),
(640, 'tool/lpmigrate:frameworksmigrate', 'write', 10, 'tool_lpmigrate', 0),
(641, 'tool/monitor:subscribe', 'read', 50, 'tool_monitor', 8),
(642, 'tool/monitor:managerules', 'write', 50, 'tool_monitor', 4),
(643, 'tool/monitor:managetool', 'write', 10, 'tool_monitor', 4),
(644, 'tool/policy:accept', 'write', 10, 'tool_policy', 0),
(645, 'tool/policy:acceptbehalf', 'write', 30, 'tool_policy', 8),
(646, 'tool/policy:managedocs', 'write', 10, 'tool_policy', 0),
(647, 'tool/policy:viewacceptances', 'read', 10, 'tool_policy', 0),
(648, 'tool/recyclebin:deleteitems', 'write', 50, 'tool_recyclebin', 32),
(649, 'tool/recyclebin:restoreitems', 'write', 50, 'tool_recyclebin', 0),
(650, 'tool/recyclebin:viewitems', 'read', 50, 'tool_recyclebin', 0),
(651, 'tool/uploaduser:uploaduserpictures', 'write', 10, 'tool_uploaduser', 16),
(652, 'tool/usertours:managetours', 'write', 10, 'tool_usertours', 4),
(653, 'contenttype/h5p:access', 'read', 50, 'contenttype_h5p', 0),
(654, 'contenttype/h5p:upload', 'write', 50, 'contenttype_h5p', 16),
(655, 'contenttype/h5p:useeditor', 'write', 50, 'contenttype_h5p', 16),
(656, 'booktool/exportimscp:export', 'read', 70, 'booktool_exportimscp', 0),
(657, 'booktool/importhtml:import', 'write', 70, 'booktool_importhtml', 4),
(658, 'booktool/print:print', 'read', 70, 'booktool_print', 0),
(659, 'forumreport/summary:view', 'read', 70, 'forumreport_summary', 0),
(660, 'forumreport/summary:viewall', 'read', 70, 'forumreport_summary', 8),
(661, 'quiz/grading:viewstudentnames', 'read', 70, 'quiz_grading', 0),
(662, 'quiz/grading:viewidnumber', 'read', 70, 'quiz_grading', 0),
(663, 'quiz/statistics:view', 'read', 70, 'quiz_statistics', 0),
(664, 'quizaccess/seb:managetemplates', 'write', 10, 'quizaccess_seb', 0),
(665, 'quizaccess/seb:bypassseb', 'read', 70, 'quizaccess_seb', 0),
(666, 'quizaccess/seb:manage_seb_requiresafeexambrowser', 'write', 70, 'quizaccess_seb', 0),
(667, 'quizaccess/seb:manage_seb_templateid', 'read', 70, 'quizaccess_seb', 0),
(668, 'quizaccess/seb:manage_filemanager_sebconfigfile', 'write', 70, 'quizaccess_seb', 0),
(669, 'quizaccess/seb:manage_seb_showsebdownloadlink', 'write', 70, 'quizaccess_seb', 0),
(670, 'quizaccess/seb:manage_seb_allowedbrowserexamkeys', 'write', 70, 'quizaccess_seb', 0),
(671, 'quizaccess/seb:manage_seb_linkquitseb', 'write', 70, 'quizaccess_seb', 0),
(672, 'quizaccess/seb:manage_seb_userconfirmquit', 'write', 70, 'quizaccess_seb', 0),
(673, 'quizaccess/seb:manage_seb_allowuserquitseb', 'write', 70, 'quizaccess_seb', 0),
(674, 'quizaccess/seb:manage_seb_quitpassword', 'write', 70, 'quizaccess_seb', 0),
(675, 'quizaccess/seb:manage_seb_allowreloadinexam', 'write', 70, 'quizaccess_seb', 0),
(676, 'quizaccess/seb:manage_seb_showsebtaskbar', 'write', 70, 'quizaccess_seb', 0),
(677, 'quizaccess/seb:manage_seb_showreloadbutton', 'write', 70, 'quizaccess_seb', 0),
(678, 'quizaccess/seb:manage_seb_showtime', 'write', 70, 'quizaccess_seb', 0),
(679, 'quizaccess/seb:manage_seb_showkeyboardlayout', 'write', 70, 'quizaccess_seb', 0),
(680, 'quizaccess/seb:manage_seb_showwificontrol', 'write', 70, 'quizaccess_seb', 0),
(681, 'quizaccess/seb:manage_seb_enableaudiocontrol', 'write', 70, 'quizaccess_seb', 0),
(682, 'quizaccess/seb:manage_seb_muteonstartup', 'write', 70, 'quizaccess_seb', 0),
(683, 'quizaccess/seb:manage_seb_allowspellchecking', 'write', 70, 'quizaccess_seb', 0),
(684, 'quizaccess/seb:manage_seb_activateurlfiltering', 'write', 70, 'quizaccess_seb', 0),
(685, 'quizaccess/seb:manage_seb_filterembeddedcontent', 'write', 70, 'quizaccess_seb', 0),
(686, 'quizaccess/seb:manage_seb_expressionsallowed', 'write', 70, 'quizaccess_seb', 0),
(687, 'quizaccess/seb:manage_seb_regexallowed', 'write', 70, 'quizaccess_seb', 0),
(688, 'quizaccess/seb:manage_seb_expressionsblocked', 'write', 70, 'quizaccess_seb', 0),
(689, 'quizaccess/seb:manage_seb_regexblocked', 'write', 70, 'quizaccess_seb', 0),
(690, 'atto/h5p:addembed', 'write', 70, 'atto_h5p', 0),
(691, 'atto/recordrtc:recordaudio', 'write', 70, 'atto_recordrtc', 0),
(692, 'atto/recordrtc:recordvideo', 'write', 70, 'atto_recordrtc', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat`
--

CREATE TABLE `[[dbprefix]]chat` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `keepdays` bigint(11) NOT NULL DEFAULT '0',
  `studentlogs` smallint(4) NOT NULL DEFAULT '0',
  `chattime` bigint(10) NOT NULL DEFAULT '0',
  `schedule` smallint(4) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chat_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each of these is a chat room' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat_messages`
--

CREATE TABLE `[[dbprefix]]chat_messages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chatmess_use_ix` (`userid`),
  KEY `[[dbprefix]]chatmess_gro_ix` (`groupid`),
  KEY `[[dbprefix]]chatmess_timcha_ix` (`timestamp`,`chatid`),
  KEY `[[dbprefix]]chatmess_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all the actual chat messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat_messages_current`
--

CREATE TABLE `[[dbprefix]]chat_messages_current` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chatmesscurr_use_ix` (`userid`),
  KEY `[[dbprefix]]chatmesscurr_gro_ix` (`groupid`),
  KEY `[[dbprefix]]chatmesscurr_timcha_ix` (`timestamp`,`chatid`),
  KEY `[[dbprefix]]chatmesscurr_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores current session' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat_users`
--

CREATE TABLE `[[dbprefix]]chat_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(11) NOT NULL DEFAULT '0',
  `userid` bigint(11) NOT NULL DEFAULT '0',
  `groupid` bigint(11) NOT NULL DEFAULT '0',
  `version` varchar(16) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `firstping` bigint(10) NOT NULL DEFAULT '0',
  `lastping` bigint(10) NOT NULL DEFAULT '0',
  `lastmessageping` bigint(10) NOT NULL DEFAULT '0',
  `sid` varchar(32) NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chatuser_use_ix` (`userid`),
  KEY `[[dbprefix]]chatuser_las_ix` (`lastping`),
  KEY `[[dbprefix]]chatuser_gro_ix` (`groupid`),
  KEY `[[dbprefix]]chatuser_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps track of which users are in which chat rooms' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice`
--

CREATE TABLE `[[dbprefix]]choice` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `publish` tinyint(2) NOT NULL DEFAULT '0',
  `showresults` tinyint(2) NOT NULL DEFAULT '0',
  `display` smallint(4) NOT NULL DEFAULT '0',
  `allowupdate` tinyint(2) NOT NULL DEFAULT '0',
  `allowmultiple` tinyint(2) NOT NULL DEFAULT '0',
  `showunanswered` tinyint(2) NOT NULL DEFAULT '0',
  `includeinactive` tinyint(2) NOT NULL DEFAULT '1',
  `limitanswers` tinyint(2) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `showpreview` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  `showavailable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Available choices are stored here' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice_answers`
--

CREATE TABLE `[[dbprefix]]choice_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `optionid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choiansw_use_ix` (`userid`),
  KEY `[[dbprefix]]choiansw_cho_ix` (`choiceid`),
  KEY `[[dbprefix]]choiansw_opt_ix` (`optionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='choices performed by users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice_options`
--

CREATE TABLE `[[dbprefix]]choice_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `text` longtext,
  `maxanswers` bigint(10) DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choiopti_cho_ix` (`choiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='available options to choice' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cohort`
--

CREATE TABLE `[[dbprefix]]cohort` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `name` varchar(254) NOT NULL DEFAULT '',
  `idnumber` varchar(100) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `component` varchar(100) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `theme` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]coho_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each record represents one cohort (aka site-wide group).' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cohort_members`
--

CREATE TABLE `[[dbprefix]]cohort_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cohortid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]cohomemb_cohuse_uix` (`cohortid`,`userid`),
  KEY `[[dbprefix]]cohomemb_coh_ix` (`cohortid`),
  KEY `[[dbprefix]]cohomemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a user to a cohort.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(255) DEFAULT NULL,
  `commentarea` varchar(255) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `content` longtext NOT NULL,
  `format` tinyint(2) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comm_concomite_ix` (`contextid`,`commentarea`,`itemid`),
  KEY `[[dbprefix]]comm_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='moodle comments module' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency`
--

CREATE TABLE `[[dbprefix]]competency` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `idnumber` varchar(100) DEFAULT NULL,
  `competencyframeworkid` bigint(10) NOT NULL,
  `parentid` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `sortorder` bigint(10) NOT NULL,
  `ruletype` varchar(100) DEFAULT NULL,
  `ruleoutcome` tinyint(2) NOT NULL DEFAULT '0',
  `ruleconfig` longtext,
  `scaleid` bigint(10) DEFAULT NULL,
  `scaleconfiguration` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]comp_comidn_uix` (`competencyframeworkid`,`idnumber`),
  KEY `[[dbprefix]]comp_rul_ix` (`ruleoutcome`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains the master record of each competency in ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_coursecomp`
--

CREATE TABLE `[[dbprefix]]competency_coursecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `ruleoutcome` tinyint(2) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compcour_coucom_uix` (`courseid`,`competencyid`),
  KEY `[[dbprefix]]compcour_courul_ix` (`courseid`,`ruleoutcome`),
  KEY `[[dbprefix]]compcour_cou2_ix` (`courseid`),
  KEY `[[dbprefix]]compcour_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a competency to a course.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_coursecompsetting`
--

CREATE TABLE `[[dbprefix]]competency_coursecompsetting` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `pushratingstouserplans` tinyint(2) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains the course specific settings for compete' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_evidence`
--

CREATE TABLE `[[dbprefix]]competency_evidence` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usercompetencyid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `action` tinyint(2) NOT NULL,
  `actionuserid` bigint(10) DEFAULT NULL,
  `descidentifier` varchar(255) NOT NULL DEFAULT '',
  `desccomponent` varchar(255) NOT NULL DEFAULT '',
  `desca` longtext,
  `url` varchar(255) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `note` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]compevid_use_ix` (`usercompetencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The evidence linked to a user competency' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_framework`
--

CREATE TABLE `[[dbprefix]]competency_framework` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `idnumber` varchar(100) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `scaleid` bigint(11) DEFAULT NULL,
  `scaleconfiguration` longtext NOT NULL,
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `taxonomies` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compfram_idn_uix` (`idnumber`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of competency frameworks.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_modulecomp`
--

CREATE TABLE `[[dbprefix]]competency_modulecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cmid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `ruleoutcome` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compmodu_cmicom_uix` (`cmid`,`competencyid`),
  KEY `[[dbprefix]]compmodu_cmirul_ix` (`cmid`,`ruleoutcome`),
  KEY `[[dbprefix]]compmodu_cmi_ix` (`cmid`),
  KEY `[[dbprefix]]compmodu_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a competency to a module.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_plan`
--

CREATE TABLE `[[dbprefix]]competency_plan` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `templateid` bigint(10) DEFAULT NULL,
  `origtemplateid` bigint(10) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `duedate` bigint(10) DEFAULT '0',
  `reviewerid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]compplan_usesta_ix` (`userid`,`status`),
  KEY `[[dbprefix]]compplan_tem_ix` (`templateid`),
  KEY `[[dbprefix]]compplan_stadue_ix` (`status`,`duedate`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Learning plans' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_plancomp`
--

CREATE TABLE `[[dbprefix]]competency_plancomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `planid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compplan_placom_uix` (`planid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Plan competencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_relatedcomp`
--

CREATE TABLE `[[dbprefix]]competency_relatedcomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `competencyid` bigint(10) NOT NULL,
  `relatedcompetencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Related competencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_template`
--

CREATE TABLE `[[dbprefix]]competency_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `description` longtext,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `duedate` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Learning plan templates.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_templatecohort`
--

CREATE TABLE `[[dbprefix]]competency_templatecohort` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `templateid` bigint(10) NOT NULL,
  `cohortid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]comptemp_temcoh_uix` (`templateid`,`cohortid`),
  KEY `[[dbprefix]]comptemp_tem2_ix` (`templateid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_templatecomp`
--

CREATE TABLE `[[dbprefix]]competency_templatecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `templateid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comptemp_tem_ix` (`templateid`),
  KEY `[[dbprefix]]comptemp_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a competency to a learning plan template.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_usercomp`
--

CREATE TABLE `[[dbprefix]]competency_usercomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `reviewerid` bigint(10) DEFAULT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecom_uix` (`userid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='User competencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_usercompcourse`
--

CREATE TABLE `[[dbprefix]]competency_usercompcourse` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecoucom_uix` (`userid`,`courseid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='User competencies in a course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_usercompplan`
--

CREATE TABLE `[[dbprefix]]competency_usercompplan` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `planid` bigint(10) NOT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecompla_uix` (`userid`,`competencyid`,`planid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='User competencies plans' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_userevidence`
--

CREATE TABLE `[[dbprefix]]competency_userevidence` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `descriptionformat` tinyint(1) NOT NULL,
  `url` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]compuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The evidence of prior learning' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_userevidencecomp`
--

CREATE TABLE `[[dbprefix]]competency_userevidencecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userevidenceid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecom2_uix` (`userevidenceid`,`competencyid`),
  KEY `[[dbprefix]]compuser_use2_ix` (`userevidenceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Relationship between user evidence and competencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]conf_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Moodle configuration variables' AUTO_INCREMENT=527 ;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
(2, 'rolesactive', '1'),
(3, 'auth', 'email'),
(4, 'enrol_plugins_enabled', 'manual,guest,self,cohort'),
(5, 'theme', 'boost'),
(6, 'filter_multilang_converted', '1'),
(7, 'siteidentifier', '[[siteidentifier]][[domhost]]'),
(8, 'backup_version', '2008111700'),
(9, 'backup_release', '2.0 dev'),
(10, 'mnet_dispatcher_mode', 'off'),
(11, 'sessiontimeout', '28800'),
(12, 'stringfilters', ''),
(13, 'filterall', '0'),
(14, 'texteditors', 'atto,tinymce,textarea'),
(15, 'antiviruses', ''),
(16, 'media_plugins_sortorder', 'videojs,youtube,swf'),
(17, 'upgrade_extracreditweightsstepignored', '1'),
(18, 'upgrade_calculatedgradeitemsignored', '1'),
(19, 'upgrade_letterboundarycourses', '1'),
(20, 'mnet_localhost_id', '1'),
(21, 'mnet_all_hosts_id', '2'),
(22, 'siteguest', '1'),
(23, 'siteadmins', '2'),
(24, 'themerev', '[[timestamp]]'),
(25, 'jsrev', '[[timestamp]]'),
(26, 'templaterev', '[[timestamp]]'),
(27, 'gdversion', '2'),
(28, 'licenses', 'unknown,allrightsreserved,public,cc,cc-nd,cc-nc-nd,cc-nc,cc-nc-sa,cc-sa'),
(29, 'sitedefaultlicense', 'unknown'),
(30, 'version', '2021051718'),
(31, 'enableuserfeedback', '0'),
(32, 'userfeedback_nextreminder', '1'),
(33, 'userfeedback_remindafter', '90'),
(34, 'enableoutcomes', '0'),
(35, 'usecomments', '1'),
(36, 'usetags', '1'),
(37, 'enablenotes', '1'),
(38, 'enableportfolios', '0'),
(39, 'enablewebservices', '0'),
(40, 'enablestats', '0'),
(41, 'enablerssfeeds', '0'),
(42, 'enableblogs', '1'),
(43, 'enablecompletion', '1'),
(44, 'completiondefault', '1'),
(45, 'enableavailability', '1'),
(46, 'enableplagiarism', '0'),
(47, 'enablebadges', '1'),
(48, 'enableglobalsearch', '0'),
(49, 'allowstealth', '0'),
(50, 'enableanalytics', '1'),
(51, 'allowemojipicker', '1'),
(52, 'userfiltersdefault', 'realname'),
(53, 'defaultpreference_maildisplay', '2'),
(54, 'defaultpreference_mailformat', '1'),
(55, 'defaultpreference_maildigest', '0'),
(56, 'defaultpreference_autosubscribe', '1'),
(57, 'defaultpreference_trackforums', '0'),
(58, 'defaultpreference_core_contentbank_visibility', '1'),
(59, 'autologinguests', '0'),
(60, 'hiddenuserfields', ''),
(61, 'showuseridentity', 'email'),
(62, 'fullnamedisplay', 'language'),
(63, 'alternativefullnameformat', 'language'),
(64, 'maxusersperpage', '100'),
(65, 'enablegravatar', '0'),
(66, 'gravatardefaulturl', 'mm'),
(67, 'agedigitalconsentverification', '0'),
(68, 'agedigitalconsentmap', '*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13'),
(69, 'sitepolicy', ''),
(70, 'sitepolicyguest', ''),
(71, 'downloadcoursecontentallowed', '0'),
(72, 'maxsizeperdownloadcoursefile', '52428800'),
(73, 'enablecourserequests', '1'),
(74, 'defaultrequestcategory', '1'),
(75, 'lockrequestcategory', '0'),
(76, 'courserequestnotify', ''),
(77, 'activitychoosertabmode', '0'),
(78, 'activitychooseractivefooter', 'hidden'),
(79, 'enableasyncbackup', '0'),
(80, 'grade_profilereport', 'user'),
(81, 'grade_aggregationposition', '1'),
(82, 'grade_includescalesinaggregation', '1'),
(83, 'grade_hiddenasdate', '0'),
(84, 'gradepublishing', '0'),
(85, 'grade_export_exportfeedback', '0'),
(86, 'grade_export_displaytype', '1'),
(87, 'grade_export_decimalpoints', '2'),
(88, 'grade_navmethod', '1'),
(89, 'grade_export_userprofilefields', 'firstname,lastname,idnumber,institution,department,email'),
(90, 'grade_export_customprofilefields', ''),
(91, 'recovergradesdefault', '0'),
(92, 'gradeexport', ''),
(93, 'unlimitedgrades', '0'),
(94, 'grade_report_showmin', '1'),
(95, 'gradepointmax', '100'),
(96, 'gradepointdefault', '100'),
(97, 'grade_minmaxtouse', '1'),
(98, 'grade_mygrades_report', 'overview'),
(99, 'gradereport_mygradeurl', ''),
(100, 'grade_hideforcedsettings', '1'),
(101, 'grade_aggregation', '13'),
(102, 'grade_aggregation_flag', '0'),
(103, 'grade_aggregations_visible', '13'),
(104, 'grade_aggregateonlygraded', '1'),
(105, 'grade_aggregateonlygraded_flag', '2'),
(106, 'grade_aggregateoutcomes', '0'),
(107, 'grade_aggregateoutcomes_flag', '2'),
(108, 'grade_keephigh', '0'),
(109, 'grade_keephigh_flag', '3'),
(110, 'grade_droplow', '0'),
(111, 'grade_droplow_flag', '2'),
(112, 'grade_overridecat', '1'),
(113, 'grade_displaytype', '1'),
(114, 'grade_decimalpoints', '2'),
(115, 'grade_item_advanced', 'iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime'),
(116, 'grade_report_studentsperpage', '100'),
(117, 'grade_report_showonlyactiveenrol', '1'),
(118, 'grade_report_quickgrading', '1'),
(119, 'grade_report_showquickfeedback', '0'),
(120, 'grade_report_meanselection', '1'),
(121, 'grade_report_enableajax', '0'),
(122, 'grade_report_showcalculations', '1'),
(123, 'grade_report_showeyecons', '0'),
(124, 'grade_report_showaverages', '1'),
(125, 'grade_report_showlocks', '0'),
(126, 'grade_report_showranges', '0'),
(127, 'grade_report_showanalysisicon', '1'),
(128, 'grade_report_showuserimage', '1'),
(129, 'grade_report_showactivityicons', '1'),
(130, 'grade_report_shownumberofgrades', '0'),
(131, 'grade_report_averagesdisplaytype', 'inherit'),
(132, 'grade_report_rangesdisplaytype', 'inherit'),
(133, 'grade_report_averagesdecimalpoints', 'inherit'),
(134, 'grade_report_rangesdecimalpoints', 'inherit'),
(135, 'grade_report_historyperpage', '50'),
(136, 'grade_report_overview_showrank', '0'),
(137, 'grade_report_overview_showtotalsifcontainhidden', '0'),
(138, 'grade_report_user_showrank', '0'),
(139, 'grade_report_user_showpercentage', '1'),
(140, 'grade_report_user_showgrade', '1'),
(141, 'grade_report_user_showfeedback', '1'),
(142, 'grade_report_user_showrange', '1'),
(143, 'grade_report_user_showweight', '1'),
(144, 'grade_report_user_showaverage', '0'),
(145, 'grade_report_user_showlettergrade', '0'),
(146, 'grade_report_user_rangedecimals', '0'),
(147, 'grade_report_user_showhiddenitems', '1'),
(148, 'grade_report_user_showtotalsifcontainhidden', '0'),
(149, 'grade_report_user_showcontributiontocoursetotal', '1'),
(150, 'badges_defaultissuername', ''),
(151, 'badges_defaultissuercontact', ''),
(152, 'badges_badgesalt', 'badges[[timestamp]]'),
(153, 'badges_allowcoursebadges', '1'),
(154, 'badges_allowexternalbackpack', '1'),
(155, 'rememberuserlicensepref', '1'),
(157, 'forcetimezone', '99'),
(158, 'country', '0'),
(159, 'defaultcity', ''),
(160, 'geoip2file', '[[softdatadir]]/geoip/GeoLite2-City.mmdb'),
(161, 'googlemapkey3', ''),
(162, 'allcountrycodes', ''),
(163, 'autolang', '1'),
(164, 'lang', '[[language]]'),
(165, 'autolangusercreation', '1'),
(166, 'langmenu', '1'),
(167, 'langlist', ''),
(168, 'langrev', '[[timestamp]]'),
(169, 'langcache', '1'),
(170, 'langstringcache', '1'),
(171, 'locale', ''),
(172, 'latinexcelexport', '0'),
(173, 'messaging', '1'),
(174, 'messagingallusers', '0'),
(175, 'messagingdefaultpressenter', '1'),
(176, 'messagingdeletereadnotificationsdelay', '604800'),
(177, 'messagingdeleteallnotificationsdelay', '2620800'),
(178, 'messagingallowemailoverride', '0'),
(179, 'requiremodintro', '0'),
(181, 'authloginviaemail', '0'),
(182, 'allowaccountssameemail', '0'),
(183, 'authpreventaccountcreation', '0'),
(184, 'loginpageautofocus', '0'),
(185, 'guestloginbutton', '1'),
(186, 'limitconcurrentlogins', '0'),
(187, 'alternateloginurl', ''),
(188, 'forgottenpasswordurl', ''),
(189, 'auth_instructions', ''),
(190, 'allowemailaddresses', ''),
(191, 'denyemailaddresses', ''),
(192, 'verifychangedemail', '1'),
(193, 'recaptchapublickey', ''),
(194, 'recaptchaprivatekey', ''),
(195, 'filteruploadedfiles', '0'),
(196, 'filtermatchoneperpage', '0'),
(197, 'filtermatchonepertext', '0'),
(198, 'filternavigationwithsystemcontext', '0'),
(199, 'media_default_width', '400'),
(200, 'media_default_height', '300'),
(201, 'portfolio_moderate_filesize_threshold', '1048576'),
(202, 'portfolio_high_filesize_threshold', '5242880'),
(203, 'portfolio_moderate_db_threshold', '20'),
(204, 'portfolio_high_db_threshold', '50'),
(205, 'repositorycacheexpire', '120'),
(206, 'repositorygetfiletimeout', '30'),
(207, 'repositorysyncfiletimeout', '1'),
(208, 'repositorysyncimagetimeout', '3'),
(209, 'repositoryallowexternallinks', '1'),
(210, 'legacyfilesinnewcourses', '0'),
(211, 'legacyfilesaddallowed', '1'),
(212, 'searchengine', 'simpledb'),
(213, 'searchindexwhendisabled', '0'),
(214, 'searchindextime', '600'),
(215, 'searchallavailablecourses', '0'),
(216, 'searchincludeallcourses', '0'),
(217, 'searchenablecategories', '0'),
(218, 'searchdefaultcategory', 'core-all'),
(219, 'searchhideallcategory', '0'),
(220, 'searchenginequeryonly', ''),
(221, 'searchbannerenable', '0'),
(222, 'searchbanner', ''),
(223, 'allowbeforeblock', '0'),
(224, 'allowedip', ''),
(225, 'blockedip', ''),
(226, 'protectusernames', '1'),
(227, 'forcelogin', '0'),
(228, 'forceloginforprofiles', '1'),
(229, 'forceloginforprofileimage', '0'),
(230, 'opentowebcrawlers', '0'),
(231, 'allowindexing', '0'),
(232, 'maxbytes', '0'),
(233, 'userquota', '104857600'),
(234, 'allowobjectembed', '0'),
(235, 'enabletrusttext', '0'),
(236, 'maxeditingtime', '1800'),
(237, 'extendedusernamechars', '0'),
(238, 'keeptagnamecase', '1'),
(239, 'profilesforenrolledusersonly', '1'),
(240, 'cronclionly', '1'),
(241, 'cronremotepassword', ''),
(242, 'lockoutthreshold', '0'),
(243, 'lockoutwindow', '1800'),
(244, 'lockoutduration', '1800'),
(245, 'passwordpolicy', '1'),
(246, 'minpasswordlength', '8'),
(247, 'minpassworddigits', '1'),
(248, 'minpasswordlower', '1'),
(249, 'minpasswordupper', '1'),
(250, 'minpasswordnonalphanum', '1'),
(251, 'maxconsecutiveidentchars', '0'),
(252, 'passwordpolicycheckonlogin', '0'),
(253, 'passwordreuselimit', '0'),
(254, 'pwresettime', '1800'),
(255, 'passwordchangelogout', '0'),
(256, 'passwordchangetokendeletion', '0'),
(257, 'tokenduration', '7257600'),
(258, 'groupenrolmentkeypolicy', '1'),
(259, 'disableuserimages', '0'),
(260, 'emailchangeconfirmation', '1'),
(261, 'rememberusername', '2'),
(262, 'strictformsrequired', '0'),
(263, 'cookiesecure', '1'),
(264, 'cookiehttponly', '0'),
(265, 'allowframembedding', '0'),
(266, 'curlsecurityblockedhosts', ''),
(267, 'curlsecurityallowedport', ''),
(268, 'referrerpolicy', 'default'),
(269, 'displayloginfailures', '0'),
(270, 'notifyloginfailures', ''),
(271, 'notifyloginthreshold', '10'),
(272, 'themelist', ''),
(273, 'themedesignermode', '0'),
(274, 'allowuserthemes', '0'),
(275, 'allowcoursethemes', '0'),
(276, 'allowcategorythemes', '0'),
(277, 'allowcohortthemes', '0'),
(278, 'allowthemechangeonurl', '0'),
(279, 'allowuserblockhiding', '1'),
(280, 'langmenuinsecurelayout', '0'),
(281, 'logininfoinsecurelayout', '0'),
(282, 'custommenuitems', ''),
(283, 'customusermenuitems', 'grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences'),
(284, 'enabledevicedetection', '1'),
(285, 'devicedetectregex', '[]'),
(286, 'calendartype', 'gregorian'),
(287, 'calendar_adminseesall', '0'),
(288, 'calendar_site_timeformat', '0'),
(289, 'calendar_startwday', '1'),
(290, 'calendar_weekend', '65'),
(291, 'calendar_lookahead', '21'),
(292, 'calendar_maxevents', '10'),
(293, 'enablecalendarexport', '1'),
(294, 'calendar_customexport', '1'),
(295, 'calendar_exportlookahead', '365'),
(296, 'calendar_exportlookback', '5'),
(297, 'calendar_exportsalt', '[[export_salt]]'),
(298, 'calendar_showicalsource', '1'),
(299, 'useblogassociations', '1'),
(300, 'bloglevel', '4'),
(301, 'useexternalblogs', '1'),
(302, 'externalblogcrontime', '86400'),
(303, 'maxexternalblogsperuser', '1'),
(304, 'blogusecomments', '1'),
(305, 'blogshowcommentscount', '1'),
(306, 'defaulthomepage', '1'),
(307, 'allowguestmymoodle', '1'),
(308, 'navshowfullcoursenames', '0'),
(309, 'navshowcategories', '1'),
(310, 'navshowmycoursecategories', '0'),
(311, 'navshowallcourses', '0'),
(312, 'navsortmycoursessort', 'sortorder'),
(313, 'navsortmycourseshiddenlast', '1'),
(314, 'navcourselimit', '10'),
(315, 'usesitenameforsitepages', '0'),
(316, 'linkadmincategories', '1'),
(317, 'linkcoursesections', '1'),
(318, 'navshowfrontpagemods', '1'),
(319, 'navadduserpostslinks', '1'),
(320, 'formatstringstriptags', '1'),
(321, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]'),
(322, 'docroot', 'https://docs.moodle.org'),
(323, 'doclang', ''),
(324, 'doctonewwindow', '0'),
(325, 'coursecontactduplicates', '0'),
(326, 'courselistshortnames', '0'),
(327, 'coursesperpage', '20'),
(328, 'courseswithsummarieslimit', '10'),
(329, 'courseoverviewfileslimit', '1'),
(330, 'courseoverviewfilesext', '.jpg,.gif,.png'),
(331, 'coursegraceperiodbefore', '0'),
(332, 'coursegraceperiodafter', '0'),
(333, 'useexternalyui', '0'),
(334, 'yuicomboloading', '1'),
(335, 'cachejs', '1'),
(336, 'additionalhtmlhead', ''),
(337, 'additionalhtmltopofbody', ''),
(338, 'additionalhtmlfooter', ''),
(339, 'cachetemplates', '1'),
(340, 'pathtophp', ''),
(341, 'pathtodu', ''),
(342, 'aspellpath', ''),
(343, 'pathtodot', ''),
(344, 'pathtogs', '/usr/bin/gs'),
(345, 'pathtopdftoppm', ''),
(346, 'pathtopython', ''),
(347, 'supportname', 'Admin User'),
(348, 'supportemail', ''),
(349, 'supportpage', ''),
(350, 'dbsessions', '0'),
(351, 'sessiontimeoutwarning', '1200'),
(352, 'sessioncookie', ''),
(353, 'sessioncookiepath', ''),
(354, 'sessioncookiedomain', ''),
(355, 'statsfirstrun', 'none'),
(356, 'statsmaxruntime', '0'),
(357, 'statsruntimedays', '31'),
(358, 'statsuserthreshold', '0'),
(359, 'slasharguments', '1'),
(360, 'getremoteaddrconf', '3'),
(361, 'reverseproxyignore', ''),
(362, 'proxyhost', ''),
(363, 'proxyport', '0'),
(364, 'proxytype', 'HTTP'),
(365, 'proxyuser', ''),
(366, 'proxypassword', ''),
(367, 'proxybypass', 'localhost, 127.0.0.1'),
(368, 'maintenance_enabled', '0'),
(369, 'maintenance_message', ''),
(370, 'deleteunconfirmed', '168'),
(371, 'deleteincompleteusers', '0'),
(372, 'disablegradehistory', '0'),
(373, 'gradehistorylifetime', '0'),
(374, 'tempdatafoldercleanup', '168'),
(375, 'filescleanupperiod', '86400'),
(376, 'extramemorylimit', '512M'),
(377, 'maxtimelimit', '0'),
(378, 'curlcache', '120'),
(379, 'curltimeoutkbitrate', '56'),
(380, 'cron_enabled', '1'),
(381, 'task_scheduled_concurrency_limit', '3'),
(382, 'task_scheduled_max_runtime', '1800'),
(383, 'task_adhoc_concurrency_limit', '3'),
(384, 'task_adhoc_max_runtime', '1800'),
(385, 'task_logmode', '1'),
(386, 'task_logtostdout', '1'),
(387, 'task_logretention', '2419200'),
(388, 'task_logretainruns', '20'),
(389, 'smtphosts', ''),
(390, 'smtpsecure', ''),
(391, 'smtpauthtype', 'LOGIN'),
(392, 'smtpuser', ''),
(393, 'smtppass', ''),
(394, 'smtpmaxbulk', '1'),
(395, 'noreplyaddress', '[[admin_email]]'),
(396, 'allowedemaildomains', ''),
(397, 'divertallemailsto', ''),
(398, 'divertallemailsexcept', ''),
(399, 'emaildkimselector', ''),
(400, 'sitemailcharset', '0'),
(401, 'allowusermailcharset', '0'),
(402, 'allowattachments', '1'),
(403, 'mailnewline', 'LF'),
(404, 'emailfromvia', '1'),
(405, 'emailsubjectprefix', ''),
(406, 'emailheaders', ''),
(407, 'updateautocheck', '1'),
(408, 'updateminmaturity', '200'),
(409, 'updatenotifybuilds', '0'),
(410, 'enablewsdocumentation', '0'),
(411, 'dndallowtextandlinks', '0'),
(412, 'pathtosassc', ''),
(413, 'contextlocking', '0'),
(414, 'contextlockappliestoadmin', '1'),
(415, 'forceclean', '0'),
(416, 'enablecourserelativedates', '0'),
(417, 'debug', '0'),
(418, 'debugdisplay', '0'),
(419, 'perfdebug', '7'),
(420, 'debugstringids', '0'),
(421, 'debugsqltrace', '0'),
(422, 'debugvalidators', '0'),
(423, 'debugpageinfo', '0'),
(424, 'profilingenabled', '0'),
(425, 'profilingincluded', ''),
(426, 'profilingexcluded', ''),
(427, 'profilingautofrec', '0'),
(428, 'profilingallowme', '0'),
(429, 'profilingallowall', '0'),
(430, 'profilingslow', '0'),
(431, 'profilinglifetime', '1440'),
(432, 'profilingimportprefix', '(I)'),
(433, 'release', '3.11.18 (Build: 20231211)'),
(434, 'localcachedirpurged', '[[timestamp]]'),
(435, 'scheduledtaskreset', '[[timestamp]]'),
(436, 'paygw_plugins_sortorder', 'paypal'),
(437, 'allversionshash', 'b24f3a7af51714d533b71402092c87a3066e9cec'),
(439, 'registrationpending', '0'),
(440, 'branch', '311'),
(441, 'enableaccessibilitytools', '1'),
(442, 'notloggedinroleid', '6'),
(443, 'guestroleid', '6'),
(444, 'defaultuserroleid', '7'),
(445, 'creatornewroleid', '3'),
(446, 'restorernewroleid', '3'),
(447, 'sitepolicyhandler', ''),
(448, 'gradebookroles', '5'),
(449, 'h5plibraryhandler', 'h5plib_v124'),
(450, 'jabberhost', ''),
(451, 'jabberserver', ''),
(452, 'jabberusername', ''),
(453, 'jabberpassword', ''),
(454, 'jabberport', '5222'),
(455, 'airnotifierurl', 'https://messages.moodle.net'),
(456, 'airnotifierport', '443'),
(457, 'airnotifiermobileappname', 'com.moodle.moodlemobile'),
(458, 'airnotifierappname', 'commoodlemoodlemobile'),
(459, 'airnotifieraccesskey', ''),
(460, 'chat_method', 'ajax'),
(461, 'chat_refresh_userlist', '10'),
(462, 'chat_old_ping', '35'),
(463, 'chat_refresh_room', '5'),
(464, 'chat_normal_updatemode', 'jsupdate'),
(465, 'chat_serverhost', '[[domhost]]'),
(466, 'chat_serverip', '127.0.0.1'),
(467, 'chat_serverport', '9111'),
(468, 'chat_servermax', '100'),
(469, 'data_enablerssfeeds', '0'),
(470, 'feedback_allowfullanonymous', '0'),
(471, 'forum_displaymode', '3'),
(472, 'forum_shortpost', '300'),
(473, 'forum_longpost', '600'),
(474, 'forum_manydiscussions', '100'),
(475, 'forum_maxbytes', '512000'),
(476, 'forum_maxattachments', '9'),
(477, 'forum_subscription', '0'),
(478, 'forum_trackingtype', '1'),
(479, 'forum_trackreadposts', '1'),
(480, 'forum_allowforcedreadtracking', '0'),
(481, 'forum_oldpostdays', '14'),
(482, 'forum_usermarksread', '0'),
(483, 'forum_cleanreadtime', '2'),
(484, 'digestmailtime', '17'),
(485, 'forum_enablerssfeeds', '0'),
(486, 'forum_enabletimedposts', '1'),
(487, 'glossary_entbypage', '10'),
(488, 'glossary_dupentries', '0'),
(489, 'glossary_allowcomments', '0'),
(490, 'glossary_linkbydefault', '1'),
(491, 'glossary_defaultapproval', '1'),
(492, 'glossary_enablerssfeeds', '0'),
(493, 'glossary_linkentries', '0'),
(494, 'glossary_casesensitive', '0'),
(495, 'glossary_fullmatch', '0'),
(496, 'block_course_list_adminview', 'all'),
(497, 'block_course_list_hideallcourseslink', '0'),
(498, 'block_html_allowcssclasses', '0'),
(499, 'block_online_users_timetosee', '5'),
(500, 'block_online_users_onlinestatushiding', '1'),
(501, 'block_rss_client_num_entries', '5'),
(502, 'block_rss_client_timeout', '30'),
(503, 'pathtounoconv', '/usr/bin/unoconv'),
(504, 'filter_multilang_force_old', '0'),
(505, 'filter_censor_badwords', ''),
(506, 'logguests', '1'),
(507, 'loglifetime', '0'),
(508, 'profileroles', '5,4,3'),
(509, 'coursecontact', '3'),
(510, 'frontpage', '6'),
(511, 'frontpageloggedin', '6'),
(512, 'maxcategorydepth', '2'),
(513, 'frontpagecourselimit', '200'),
(514, 'commentsperpage', '15'),
(515, 'defaultfrontpageroleid', '8'),
(516, 'messageinbound_enabled', '0'),
(517, 'messageinbound_mailbox', ''),
(518, 'messageinbound_domain', ''),
(519, 'messageinbound_host', ''),
(520, 'messageinbound_hostssl', 'ssl'),
(521, 'messageinbound_hostuser', ''),
(522, 'messageinbound_hostpass', ''),
(523, 'enablemobilewebservice', '0'),
(524, 'mobilecssurl', ''),
(525, 'timezone', 'America/New_York'),
(526, 'registerauth', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_log`
--

CREATE TABLE `[[dbprefix]]config_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `plugin` varchar(100) DEFAULT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` longtext,
  `oldvalue` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]conflog_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]conflog_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Changes done in server configuration through admin UI' AUTO_INCREMENT=1736 ;

--
-- Dumping data for table `[[dbprefix]]config_log`
--

INSERT INTO `[[dbprefix]]config_log` VALUES
(1, 0, [[timestamp]], NULL, 'enableuserfeedback', '0', NULL),
(2, 0, [[timestamp]], NULL, 'userfeedback_nextreminder', '1', NULL),
(3, 0, [[timestamp]], NULL, 'userfeedback_remindafter', '90', NULL),
(4, 0, [[timestamp]], NULL, 'enableoutcomes', '0', NULL),
(5, 0, [[timestamp]], NULL, 'usecomments', '1', NULL),
(6, 0, [[timestamp]], NULL, 'usetags', '1', NULL),
(7, 0, [[timestamp]], NULL, 'enablenotes', '1', NULL),
(8, 0, [[timestamp]], NULL, 'enableportfolios', '0', NULL),
(9, 0, [[timestamp]], NULL, 'enablewebservices', '0', NULL),
(10, 0, [[timestamp]], NULL, 'enablestats', '0', NULL),
(11, 0, [[timestamp]], NULL, 'enablerssfeeds', '0', NULL),
(12, 0, [[timestamp]], NULL, 'enableblogs', '1', NULL),
(13, 0, [[timestamp]], NULL, 'enablecompletion', '1', NULL),
(14, 0, [[timestamp]], NULL, 'completiondefault', '1', NULL),
(15, 0, [[timestamp]], NULL, 'enableavailability', '1', NULL),
(16, 0, [[timestamp]], NULL, 'enableplagiarism', '0', NULL),
(17, 0, [[timestamp]], NULL, 'enablebadges', '1', NULL),
(18, 0, [[timestamp]], NULL, 'enableglobalsearch', '0', NULL),
(19, 0, [[timestamp]], NULL, 'allowstealth', '0', NULL),
(20, 0, [[timestamp]], NULL, 'enableanalytics', '1', NULL),
(21, 0, [[timestamp]], NULL, 'allowemojipicker', '1', NULL),
(22, 0, [[timestamp]], NULL, 'userfiltersdefault', 'realname', NULL),
(23, 0, [[timestamp]], NULL, 'defaultpreference_maildisplay', '2', NULL),
(24, 0, [[timestamp]], NULL, 'defaultpreference_mailformat', '1', NULL),
(25, 0, [[timestamp]], NULL, 'defaultpreference_maildigest', '0', NULL),
(26, 0, [[timestamp]], NULL, 'defaultpreference_autosubscribe', '1', NULL),
(27, 0, [[timestamp]], NULL, 'defaultpreference_trackforums', '0', NULL),
(28, 0, [[timestamp]], NULL, 'defaultpreference_core_contentbank_visibility', '1', NULL),
(29, 0, [[timestamp]], NULL, 'autologinguests', '0', NULL),
(30, 0, [[timestamp]], NULL, 'hiddenuserfields', '', NULL),
(31, 0, [[timestamp]], NULL, 'showuseridentity', 'email', NULL),
(32, 0, [[timestamp]], NULL, 'fullnamedisplay', 'language', NULL),
(33, 0, [[timestamp]], NULL, 'alternativefullnameformat', 'language', NULL),
(34, 0, [[timestamp]], NULL, 'maxusersperpage', '100', NULL),
(35, 0, [[timestamp]], NULL, 'enablegravatar', '0', NULL),
(36, 0, [[timestamp]], NULL, 'gravatardefaulturl', 'mm', NULL),
(37, 0, [[timestamp]], NULL, 'agedigitalconsentverification', '0', NULL),
(38, 0, [[timestamp]], NULL, 'agedigitalconsentmap', '*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13', NULL),
(39, 0, [[timestamp]], NULL, 'sitepolicy', '', NULL),
(40, 0, [[timestamp]], NULL, 'sitepolicyguest', '', NULL),
(41, 0, [[timestamp]], 'moodlecourse', 'visible', '1', NULL),
(42, 0, [[timestamp]], 'moodlecourse', 'downloadcontentsitedefault', '0', NULL),
(43, 0, [[timestamp]], 'moodlecourse', 'format', 'topics', NULL),
(44, 0, [[timestamp]], 'moodlecourse', 'maxsections', '52', NULL),
(45, 0, [[timestamp]], 'moodlecourse', 'numsections', '4', NULL),
(46, 0, [[timestamp]], 'moodlecourse', 'hiddensections', '0', NULL),
(47, 0, [[timestamp]], 'moodlecourse', 'coursedisplay', '0', NULL),
(48, 0, [[timestamp]], 'moodlecourse', 'courseenddateenabled', '1', NULL),
(49, 0, [[timestamp]], 'moodlecourse', 'courseduration', '31536000', NULL),
(50, 0, [[timestamp]], 'moodlecourse', 'lang', '', NULL),
(51, 0, [[timestamp]], 'moodlecourse', 'newsitems', '5', NULL),
(52, 0, [[timestamp]], 'moodlecourse', 'showgrades', '1', NULL),
(53, 0, [[timestamp]], 'moodlecourse', 'showreports', '0', NULL),
(54, 0, [[timestamp]], 'moodlecourse', 'showactivitydates', '1', NULL),
(55, 0, [[timestamp]], 'moodlecourse', 'maxbytes', '0', NULL),
(56, 0, [[timestamp]], 'moodlecourse', 'enablecompletion', '1', NULL),
(57, 0, [[timestamp]], 'moodlecourse', 'showcompletionconditions', '1', NULL),
(58, 0, [[timestamp]], 'moodlecourse', 'groupmode', '0', NULL),
(59, 0, [[timestamp]], 'moodlecourse', 'groupmodeforce', '0', NULL),
(60, 0, [[timestamp]], NULL, 'downloadcoursecontentallowed', '0', NULL),
(61, 0, [[timestamp]], NULL, 'maxsizeperdownloadcoursefile', '52428800', NULL),
(62, 0, [[timestamp]], NULL, 'enablecourserequests', '1', NULL),
(63, 0, [[timestamp]], NULL, 'defaultrequestcategory', '1', NULL),
(64, 0, [[timestamp]], NULL, 'lockrequestcategory', '0', NULL),
(65, 0, [[timestamp]], NULL, 'courserequestnotify', '', NULL),
(66, 0, [[timestamp]], NULL, 'activitychoosertabmode', '0', NULL),
(67, 0, [[timestamp]], NULL, 'activitychooseractivefooter', 'hidden', NULL),
(68, 0, [[timestamp]], 'backup', 'loglifetime', '30', NULL),
(69, 0, [[timestamp]], 'backup', 'backup_general_users', '1', NULL),
(70, 0, [[timestamp]], 'backup', 'backup_general_users_locked', '', NULL),
(71, 0, [[timestamp]], 'backup', 'backup_general_anonymize', '0', NULL),
(72, 0, [[timestamp]], 'backup', 'backup_general_anonymize_locked', '', NULL),
(73, 0, [[timestamp]], 'backup', 'backup_general_role_assignments', '1', NULL),
(74, 0, [[timestamp]], 'backup', 'backup_general_role_assignments_locked', '', NULL),
(75, 0, [[timestamp]], 'backup', 'backup_general_activities', '1', NULL),
(76, 0, [[timestamp]], 'backup', 'backup_general_activities_locked', '', NULL),
(77, 0, [[timestamp]], 'backup', 'backup_general_blocks', '1', NULL),
(78, 0, [[timestamp]], 'backup', 'backup_general_blocks_locked', '', NULL),
(79, 0, [[timestamp]], 'backup', 'backup_general_files', '1', NULL),
(80, 0, [[timestamp]], 'backup', 'backup_general_files_locked', '', NULL),
(81, 0, [[timestamp]], 'backup', 'backup_general_filters', '1', NULL),
(82, 0, [[timestamp]], 'backup', 'backup_general_filters_locked', '', NULL),
(83, 0, [[timestamp]], 'backup', 'backup_general_comments', '1', NULL),
(84, 0, [[timestamp]], 'backup', 'backup_general_comments_locked', '', NULL),
(85, 0, [[timestamp]], 'backup', 'backup_general_badges', '1', NULL),
(86, 0, [[timestamp]], 'backup', 'backup_general_badges_locked', '', NULL),
(87, 0, [[timestamp]], 'backup', 'backup_general_calendarevents', '1', NULL),
(88, 0, [[timestamp]], 'backup', 'backup_general_calendarevents_locked', '', NULL),
(89, 0, [[timestamp]], 'backup', 'backup_general_userscompletion', '1', NULL),
(90, 0, [[timestamp]], 'backup', 'backup_general_userscompletion_locked', '', NULL),
(91, 0, [[timestamp]], 'backup', 'backup_general_logs', '0', NULL),
(92, 0, [[timestamp]], 'backup', 'backup_general_logs_locked', '', NULL),
(93, 0, [[timestamp]], 'backup', 'backup_general_histories', '0', NULL),
(94, 0, [[timestamp]], 'backup', 'backup_general_histories_locked', '', NULL),
(95, 0, [[timestamp]], 'backup', 'backup_general_questionbank', '1', NULL),
(96, 0, [[timestamp]], 'backup', 'backup_general_questionbank_locked', '', NULL),
(97, 0, [[timestamp]], 'backup', 'backup_general_groups', '1', NULL),
(98, 0, [[timestamp]], 'backup', 'backup_general_groups_locked', '', NULL),
(99, 0, [[timestamp]], 'backup', 'backup_general_competencies', '1', NULL),
(100, 0, [[timestamp]], 'backup', 'backup_general_competencies_locked', '', NULL),
(101, 0, [[timestamp]], 'backup', 'backup_general_contentbankcontent', '1', NULL),
(102, 0, [[timestamp]], 'backup', 'backup_general_contentbankcontent_locked', '', NULL),
(103, 0, [[timestamp]], 'backup', 'backup_general_legacyfiles', '1', NULL),
(104, 0, [[timestamp]], 'backup', 'backup_general_legacyfiles_locked', '', NULL),
(105, 0, [[timestamp]], 'backup', 'import_general_maxresults', '10', NULL),
(106, 0, [[timestamp]], 'backup', 'import_general_duplicate_admin_allowed', '0', NULL),
(107, 0, [[timestamp]], 'backup', 'backup_import_permissions', '0', NULL),
(108, 0, [[timestamp]], 'backup', 'backup_import_permissions_locked', '', NULL),
(109, 0, [[timestamp]], 'backup', 'backup_import_activities', '1', NULL),
(110, 0, [[timestamp]], 'backup', 'backup_import_activities_locked', '', NULL),
(111, 0, [[timestamp]], 'backup', 'backup_import_blocks', '1', NULL),
(112, 0, [[timestamp]], 'backup', 'backup_import_blocks_locked', '', NULL),
(113, 0, [[timestamp]], 'backup', 'backup_import_filters', '1', NULL),
(114, 0, [[timestamp]], 'backup', 'backup_import_filters_locked', '', NULL),
(115, 0, [[timestamp]], 'backup', 'backup_import_calendarevents', '1', NULL),
(116, 0, [[timestamp]], 'backup', 'backup_import_calendarevents_locked', '', NULL),
(117, 0, [[timestamp]], 'backup', 'backup_import_questionbank', '1', NULL),
(118, 0, [[timestamp]], 'backup', 'backup_import_questionbank_locked', '', NULL),
(119, 0, [[timestamp]], 'backup', 'backup_import_groups', '1', NULL),
(120, 0, [[timestamp]], 'backup', 'backup_import_groups_locked', '', NULL),
(121, 0, [[timestamp]], 'backup', 'backup_import_competencies', '1', NULL),
(122, 0, [[timestamp]], 'backup', 'backup_import_competencies_locked', '', NULL),
(123, 0, [[timestamp]], 'backup', 'backup_import_contentbankcontent', '1', NULL),
(124, 0, [[timestamp]], 'backup', 'backup_import_contentbankcontent_locked', '', NULL),
(125, 0, [[timestamp]], 'backup', 'backup_import_legacyfiles', '1', NULL),
(126, 0, [[timestamp]], 'backup', 'backup_import_legacyfiles_locked', '', NULL),
(127, 0, [[timestamp]], 'backup', 'backup_auto_active', '0', NULL),
(128, 0, [[timestamp]], 'backup', 'backup_auto_weekdays', '0000000', NULL),
(129, 0, [[timestamp]], 'backup', 'backup_auto_hour', '0', NULL),
(130, 0, [[timestamp]], 'backup', 'backup_auto_minute', '0', NULL),
(131, 0, [[timestamp]], 'backup', 'backup_auto_storage', '0', NULL),
(132, 0, [[timestamp]], 'backup', 'backup_auto_destination', '', NULL),
(133, 0, [[timestamp]], 'backup', 'backup_auto_max_kept', '1', NULL),
(134, 0, [[timestamp]], 'backup', 'backup_auto_delete_days', '0', NULL),
(135, 0, [[timestamp]], 'backup', 'backup_auto_min_kept', '0', NULL),
(136, 0, [[timestamp]], 'backup', 'backup_shortname', '0', NULL),
(137, 0, [[timestamp]], 'backup', 'backup_auto_skip_hidden', '1', NULL),
(138, 0, [[timestamp]], 'backup', 'backup_auto_skip_modif_days', '30', NULL),
(139, 0, [[timestamp]], 'backup', 'backup_auto_skip_modif_prev', '0', NULL),
(140, 0, [[timestamp]], 'backup', 'backup_auto_users', '1', NULL),
(141, 0, [[timestamp]], 'backup', 'backup_auto_role_assignments', '1', NULL),
(142, 0, [[timestamp]], 'backup', 'backup_auto_activities', '1', NULL),
(143, 0, [[timestamp]], 'backup', 'backup_auto_blocks', '1', NULL),
(144, 0, [[timestamp]], 'backup', 'backup_auto_files', '1', NULL),
(145, 0, [[timestamp]], 'backup', 'backup_auto_filters', '1', NULL),
(146, 0, [[timestamp]], 'backup', 'backup_auto_comments', '1', NULL),
(147, 0, [[timestamp]], 'backup', 'backup_auto_badges', '1', NULL),
(148, 0, [[timestamp]], 'backup', 'backup_auto_calendarevents', '1', NULL),
(149, 0, [[timestamp]], 'backup', 'backup_auto_userscompletion', '1', NULL),
(150, 0, [[timestamp]], 'backup', 'backup_auto_logs', '0', NULL),
(151, 0, [[timestamp]], 'backup', 'backup_auto_histories', '0', NULL),
(152, 0, [[timestamp]], 'backup', 'backup_auto_questionbank', '1', NULL),
(153, 0, [[timestamp]], 'backup', 'backup_auto_groups', '1', NULL),
(154, 0, [[timestamp]], 'backup', 'backup_auto_competencies', '1', NULL),
(155, 0, [[timestamp]], 'backup', 'backup_auto_contentbankcontent', '1', NULL),
(156, 0, [[timestamp]], 'backup', 'backup_auto_legacyfiles', '1', NULL),
(157, 0, [[timestamp]], 'restore', 'restore_general_users', '1', NULL),
(158, 0, [[timestamp]], 'restore', 'restore_general_users_locked', '', NULL),
(159, 0, [[timestamp]], 'restore', 'restore_general_enrolments', '1', NULL),
(160, 0, [[timestamp]], 'restore', 'restore_general_enrolments_locked', '', NULL),
(161, 0, [[timestamp]], 'restore', 'restore_general_role_assignments', '1', NULL),
(162, 0, [[timestamp]], 'restore', 'restore_general_role_assignments_locked', '', NULL),
(163, 0, [[timestamp]], 'restore', 'restore_general_permissions', '1', NULL),
(164, 0, [[timestamp]], 'restore', 'restore_general_permissions_locked', '', NULL),
(165, 0, [[timestamp]], 'restore', 'restore_general_activities', '1', NULL),
(166, 0, [[timestamp]], 'restore', 'restore_general_activities_locked', '', NULL),
(167, 0, [[timestamp]], 'restore', 'restore_general_blocks', '1', NULL),
(168, 0, [[timestamp]], 'restore', 'restore_general_blocks_locked', '', NULL),
(169, 0, [[timestamp]], 'restore', 'restore_general_filters', '1', NULL),
(170, 0, [[timestamp]], 'restore', 'restore_general_filters_locked', '', NULL),
(171, 0, [[timestamp]], 'restore', 'restore_general_comments', '1', NULL),
(172, 0, [[timestamp]], 'restore', 'restore_general_comments_locked', '', NULL),
(173, 0, [[timestamp]], 'restore', 'restore_general_badges', '1', NULL),
(174, 0, [[timestamp]], 'restore', 'restore_general_badges_locked', '', NULL),
(175, 0, [[timestamp]], 'restore', 'restore_general_calendarevents', '1', NULL),
(176, 0, [[timestamp]], 'restore', 'restore_general_calendarevents_locked', '', NULL),
(177, 0, [[timestamp]], 'restore', 'restore_general_userscompletion', '1', NULL),
(178, 0, [[timestamp]], 'restore', 'restore_general_userscompletion_locked', '', NULL),
(179, 0, [[timestamp]], 'restore', 'restore_general_logs', '1', NULL),
(180, 0, [[timestamp]], 'restore', 'restore_general_logs_locked', '', NULL),
(181, 0, [[timestamp]], 'restore', 'restore_general_histories', '1', NULL),
(182, 0, [[timestamp]], 'restore', 'restore_general_histories_locked', '', NULL),
(183, 0, [[timestamp]], 'restore', 'restore_general_groups', '1', NULL),
(184, 0, [[timestamp]], 'restore', 'restore_general_groups_locked', '', NULL),
(185, 0, [[timestamp]], 'restore', 'restore_general_competencies', '1', NULL),
(186, 0, [[timestamp]], 'restore', 'restore_general_competencies_locked', '', NULL),
(187, 0, [[timestamp]], 'restore', 'restore_general_contentbankcontent', '1', NULL),
(188, 0, [[timestamp]], 'restore', 'restore_general_contentbankcontent_locked', '', NULL),
(189, 0, [[timestamp]], 'restore', 'restore_general_legacyfiles', '1', NULL),
(190, 0, [[timestamp]], 'restore', 'restore_general_legacyfiles_locked', '', NULL),
(191, 0, [[timestamp]], 'restore', 'restore_merge_overwrite_conf', '0', NULL),
(192, 0, [[timestamp]], 'restore', 'restore_merge_overwrite_conf_locked', '', NULL),
(193, 0, [[timestamp]], 'restore', 'restore_merge_course_fullname', '1', NULL),
(194, 0, [[timestamp]], 'restore', 'restore_merge_course_fullname_locked', '', NULL),
(195, 0, [[timestamp]], 'restore', 'restore_merge_course_shortname', '1', NULL),
(196, 0, [[timestamp]], 'restore', 'restore_merge_course_shortname_locked', '', NULL),
(197, 0, [[timestamp]], 'restore', 'restore_merge_course_startdate', '1', NULL),
(198, 0, [[timestamp]], 'restore', 'restore_merge_course_startdate_locked', '', NULL),
(199, 0, [[timestamp]], 'restore', 'restore_replace_overwrite_conf', '0', NULL),
(200, 0, [[timestamp]], 'restore', 'restore_replace_overwrite_conf_locked', '', NULL),
(201, 0, [[timestamp]], 'restore', 'restore_replace_course_fullname', '1', NULL),
(202, 0, [[timestamp]], 'restore', 'restore_replace_course_fullname_locked', '', NULL),
(203, 0, [[timestamp]], 'restore', 'restore_replace_course_shortname', '1', NULL),
(204, 0, [[timestamp]], 'restore', 'restore_replace_course_shortname_locked', '', NULL),
(205, 0, [[timestamp]], 'restore', 'restore_replace_course_startdate', '1', NULL),
(206, 0, [[timestamp]], 'restore', 'restore_replace_course_startdate_locked', '', NULL),
(207, 0, [[timestamp]], 'restore', 'restore_replace_keep_roles_and_enrolments', '0', NULL),
(208, 0, [[timestamp]], 'restore', 'restore_replace_keep_roles_and_enrolments_locked', '', NULL),
(209, 0, [[timestamp]], 'restore', 'restore_replace_keep_groups_and_groupings', '0', NULL),
(210, 0, [[timestamp]], 'restore', 'restore_replace_keep_groups_and_groupings_locked', '', NULL),
(211, 0, [[timestamp]], NULL, 'enableasyncbackup', '0', NULL),
(212, 0, [[timestamp]], 'backup', 'backup_async_message_users', '0', NULL),
(213, 0, [[timestamp]], 'backup', 'backup_async_message_subject', 'Moodle {operation} completed successfully', NULL),
(214, 0, [[timestamp]], 'backup', 'backup_async_message', 'Your {operation} (ID: {backupid}) has completed successfully. You can access it here: <a href="{link}">{link}</a>.', NULL),
(215, 0, [[timestamp]], NULL, 'grade_profilereport', 'user', NULL),
(216, 0, [[timestamp]], NULL, 'grade_aggregationposition', '1', NULL),
(217, 0, [[timestamp]], NULL, 'grade_includescalesinaggregation', '1', NULL),
(218, 0, [[timestamp]], NULL, 'grade_hiddenasdate', '0', NULL),
(219, 0, [[timestamp]], NULL, 'gradepublishing', '0', NULL),
(220, 0, [[timestamp]], NULL, 'grade_export_exportfeedback', '0', NULL),
(221, 0, [[timestamp]], NULL, 'grade_export_displaytype', '1', NULL),
(222, 0, [[timestamp]], NULL, 'grade_export_decimalpoints', '2', NULL),
(223, 0, [[timestamp]], NULL, 'grade_navmethod', '1', NULL),
(224, 0, [[timestamp]], NULL, 'grade_export_userprofilefields', 'firstname,lastname,idnumber,institution,department,email', NULL),
(225, 0, [[timestamp]], NULL, 'grade_export_customprofilefields', '', NULL),
(226, 0, [[timestamp]], NULL, 'recovergradesdefault', '0', NULL),
(227, 0, [[timestamp]], NULL, 'gradeexport', '', NULL),
(228, 0, [[timestamp]], NULL, 'unlimitedgrades', '0', NULL),
(229, 0, [[timestamp]], NULL, 'grade_report_showmin', '1', NULL),
(230, 0, [[timestamp]], NULL, 'gradepointmax', '100', NULL),
(231, 0, [[timestamp]], NULL, 'gradepointdefault', '100', NULL),
(232, 0, [[timestamp]], NULL, 'grade_minmaxtouse', '1', NULL),
(233, 0, [[timestamp]], NULL, 'grade_mygrades_report', 'overview', NULL),
(234, 0, [[timestamp]], NULL, 'gradereport_mygradeurl', '', NULL),
(235, 0, [[timestamp]], NULL, 'grade_hideforcedsettings', '1', NULL),
(236, 0, [[timestamp]], NULL, 'grade_aggregation', '13', NULL),
(237, 0, [[timestamp]], NULL, 'grade_aggregation_flag', '0', NULL),
(238, 0, [[timestamp]], NULL, 'grade_aggregations_visible', '13', NULL),
(239, 0, [[timestamp]], NULL, 'grade_aggregateonlygraded', '1', NULL),
(240, 0, [[timestamp]], NULL, 'grade_aggregateonlygraded_flag', '2', NULL),
(241, 0, [[timestamp]], NULL, 'grade_aggregateoutcomes', '0', NULL),
(242, 0, [[timestamp]], NULL, 'grade_aggregateoutcomes_flag', '2', NULL),
(243, 0, [[timestamp]], NULL, 'grade_keephigh', '0', NULL),
(244, 0, [[timestamp]], NULL, 'grade_keephigh_flag', '3', NULL),
(245, 0, [[timestamp]], NULL, 'grade_droplow', '0', NULL),
(246, 0, [[timestamp]], NULL, 'grade_droplow_flag', '2', NULL),
(247, 0, [[timestamp]], NULL, 'grade_overridecat', '1', NULL),
(248, 0, [[timestamp]], NULL, 'grade_displaytype', '1', NULL),
(249, 0, [[timestamp]], NULL, 'grade_decimalpoints', '2', NULL),
(250, 0, [[timestamp]], NULL, 'grade_item_advanced', 'iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime', NULL),
(251, 0, [[timestamp]], NULL, 'grade_report_studentsperpage', '100', NULL),
(252, 0, [[timestamp]], NULL, 'grade_report_showonlyactiveenrol', '1', NULL),
(253, 0, [[timestamp]], NULL, 'grade_report_quickgrading', '1', NULL),
(254, 0, [[timestamp]], NULL, 'grade_report_showquickfeedback', '0', NULL),
(255, 0, [[timestamp]], NULL, 'grade_report_meanselection', '1', NULL),
(256, 0, [[timestamp]], NULL, 'grade_report_enableajax', '0', NULL),
(257, 0, [[timestamp]], NULL, 'grade_report_showcalculations', '1', NULL),
(258, 0, [[timestamp]], NULL, 'grade_report_showeyecons', '0', NULL),
(259, 0, [[timestamp]], NULL, 'grade_report_showaverages', '1', NULL),
(260, 0, [[timestamp]], NULL, 'grade_report_showlocks', '0', NULL),
(261, 0, [[timestamp]], NULL, 'grade_report_showranges', '0', NULL),
(262, 0, [[timestamp]], NULL, 'grade_report_showanalysisicon', '1', NULL),
(263, 0, [[timestamp]], NULL, 'grade_report_showuserimage', '1', NULL),
(264, 0, [[timestamp]], NULL, 'grade_report_showactivityicons', '1', NULL),
(265, 0, [[timestamp]], NULL, 'grade_report_shownumberofgrades', '0', NULL),
(266, 0, [[timestamp]], NULL, 'grade_report_averagesdisplaytype', 'inherit', NULL),
(267, 0, [[timestamp]], NULL, 'grade_report_rangesdisplaytype', 'inherit', NULL),
(268, 0, [[timestamp]], NULL, 'grade_report_averagesdecimalpoints', 'inherit', NULL),
(269, 0, [[timestamp]], NULL, 'grade_report_rangesdecimalpoints', 'inherit', NULL),
(270, 0, [[timestamp]], NULL, 'grade_report_historyperpage', '50', NULL),
(271, 0, [[timestamp]], NULL, 'grade_report_overview_showrank', '0', NULL),
(272, 0, [[timestamp]], NULL, 'grade_report_overview_showtotalsifcontainhidden', '0', NULL),
(273, 0, [[timestamp]], NULL, 'grade_report_user_showrank', '0', NULL),
(274, 0, [[timestamp]], NULL, 'grade_report_user_showpercentage', '1', NULL),
(275, 0, [[timestamp]], NULL, 'grade_report_user_showgrade', '1', NULL),
(276, 0, [[timestamp]], NULL, 'grade_report_user_showfeedback', '1', NULL),
(277, 0, [[timestamp]], NULL, 'grade_report_user_showrange', '1', NULL),
(278, 0, [[timestamp]], NULL, 'grade_report_user_showweight', '1', NULL),
(279, 0, [[timestamp]], NULL, 'grade_report_user_showaverage', '0', NULL),
(280, 0, [[timestamp]], NULL, 'grade_report_user_showlettergrade', '0', NULL),
(281, 0, [[timestamp]], NULL, 'grade_report_user_rangedecimals', '0', NULL),
(282, 0, [[timestamp]], NULL, 'grade_report_user_showhiddenitems', '1', NULL),
(283, 0, [[timestamp]], NULL, 'grade_report_user_showtotalsifcontainhidden', '0', NULL),
(284, 0, [[timestamp]], NULL, 'grade_report_user_showcontributiontocoursetotal', '1', NULL),
(285, 0, [[timestamp]], 'analytics', 'modeinstruction', '', NULL),
(286, 0, [[timestamp]], 'analytics', 'percentonline', '0', NULL),
(287, 0, [[timestamp]], 'analytics', 'typeinstitution', '', NULL),
(288, 0, [[timestamp]], 'analytics', 'levelinstitution', '', NULL),
(289, 0, [[timestamp]], 'analytics', 'predictionsprocessor', '\\mlbackend_php\\processor', NULL),
(290, 0, [[timestamp]], 'analytics', 'defaulttimesplittingsevaluation', '\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range', NULL),
(291, 0, [[timestamp]], 'analytics', 'modeloutputdir', '', NULL),
(292, 0, [[timestamp]], 'analytics', 'onlycli', '1', NULL),
(293, 0, [[timestamp]], 'analytics', 'modeltimelimit', '1200', NULL),
(294, 0, [[timestamp]], 'analytics', 'calclifetime', '35', NULL),
(295, 0, [[timestamp]], 'core_competency', 'enabled', '1', NULL),
(296, 0, [[timestamp]], 'core_competency', 'pushcourseratingstouserplans', '1', NULL),
(297, 0, [[timestamp]], NULL, 'badges_defaultissuername', '', NULL),
(298, 0, [[timestamp]], NULL, 'badges_defaultissuercontact', '', NULL),
(299, 0, [[timestamp]], NULL, 'badges_badgesalt', 'badges[[timestamp]]', NULL),
(300, 0, [[timestamp]], NULL, 'badges_allowcoursebadges', '1', NULL),
(301, 0, [[timestamp]], NULL, 'badges_allowexternalbackpack', '1', NULL),
(302, 0, [[timestamp]], NULL, 'rememberuserlicensepref', '1', NULL),
(303, 0, [[timestamp]], NULL, 'timezone', 'America/New_York', NULL),
(304, 0, [[timestamp]], NULL, 'forcetimezone', '99', NULL),
(305, 0, [[timestamp]], NULL, 'country', '0', NULL),
(306, 0, [[timestamp]], NULL, 'defaultcity', '', NULL),
(307, 0, [[timestamp]], NULL, 'geoip2file', '[[softdatadir]]/geoip/GeoLite2-City.mmdb', NULL),
(308, 0, [[timestamp]], NULL, 'googlemapkey3', '', NULL),
(309, 0, [[timestamp]], NULL, 'allcountrycodes', '', NULL),
(310, 0, [[timestamp]], NULL, 'autolang', '1', NULL),
(311, 0, [[timestamp]], NULL, 'lang', 'en', NULL),
(312, 0, [[timestamp]], NULL, 'autolangusercreation', '1', NULL),
(313, 0, [[timestamp]], NULL, 'langmenu', '1', NULL),
(314, 0, [[timestamp]], NULL, 'langlist', '', NULL),
(315, 0, [[timestamp]], NULL, 'langcache', '1', NULL),
(316, 0, [[timestamp]], NULL, 'langstringcache', '1', NULL),
(317, 0, [[timestamp]], NULL, 'locale', '', NULL),
(318, 0, [[timestamp]], NULL, 'latinexcelexport', '0', NULL),
(319, 0, [[timestamp]], NULL, 'messaging', '1', NULL),
(320, 0, [[timestamp]], NULL, 'messagingallusers', '0', NULL),
(321, 0, [[timestamp]], NULL, 'messagingdefaultpressenter', '1', NULL),
(322, 0, [[timestamp]], NULL, 'messagingdeletereadnotificationsdelay', '604800', NULL),
(323, 0, [[timestamp]], NULL, 'messagingdeleteallnotificationsdelay', '2620800', NULL),
(324, 0, [[timestamp]], NULL, 'messagingallowemailoverride', '0', NULL),
(325, 0, [[timestamp]], NULL, 'requiremodintro', '0', NULL),
(326, 0, [[timestamp]], 'antivirus', 'notifyemail', '', NULL),
(327, 0, [[timestamp]], 'antivirus', 'enablequarantine', '0', NULL),
(328, 0, [[timestamp]], 'antivirus', 'quarantinetime', '2419200', NULL),
(329, 0, [[timestamp]], NULL, 'registerauth', '', NULL),
(330, 0, [[timestamp]], NULL, 'authloginviaemail', '0', NULL),
(331, 0, [[timestamp]], NULL, 'allowaccountssameemail', '0', NULL),
(332, 0, [[timestamp]], NULL, 'authpreventaccountcreation', '0', NULL),
(333, 0, [[timestamp]], NULL, 'loginpageautofocus', '0', NULL),
(334, 0, [[timestamp]], NULL, 'guestloginbutton', '1', NULL),
(335, 0, [[timestamp]], NULL, 'limitconcurrentlogins', '0', NULL),
(336, 0, [[timestamp]], NULL, 'alternateloginurl', '', NULL),
(337, 0, [[timestamp]], NULL, 'forgottenpasswordurl', '', NULL),
(338, 0, [[timestamp]], NULL, 'auth_instructions', '', NULL),
(339, 0, [[timestamp]], NULL, 'allowemailaddresses', '', NULL),
(340, 0, [[timestamp]], NULL, 'denyemailaddresses', '', NULL),
(341, 0, [[timestamp]], NULL, 'verifychangedemail', '1', NULL),
(342, 0, [[timestamp]], NULL, 'recaptchapublickey', '', NULL),
(343, 0, [[timestamp]], NULL, 'recaptchaprivatekey', '', NULL),
(344, 0, [[timestamp]], 'cachestore_apcu', 'testperformance', '0', NULL),
(345, 0, [[timestamp]], 'cachestore_memcached', 'testservers', '', NULL),
(346, 0, [[timestamp]], 'cachestore_mongodb', 'testserver', '', NULL),
(347, 0, [[timestamp]], 'cachestore_redis', 'test_server', '', NULL),
(348, 0, [[timestamp]], 'cachestore_redis', 'test_password', '', NULL),
(349, 0, [[timestamp]], NULL, 'filteruploadedfiles', '0', NULL),
(350, 0, [[timestamp]], NULL, 'filtermatchoneperpage', '0', NULL),
(351, 0, [[timestamp]], NULL, 'filtermatchonepertext', '0', NULL),
(352, 0, [[timestamp]], NULL, 'filternavigationwithsystemcontext', '0', NULL),
(353, 0, [[timestamp]], NULL, 'media_default_width', '400', NULL),
(354, 0, [[timestamp]], NULL, 'media_default_height', '300', NULL),
(355, 0, [[timestamp]], NULL, 'portfolio_moderate_filesize_threshold', '1048576', NULL),
(356, 0, [[timestamp]], NULL, 'portfolio_high_filesize_threshold', '5242880', NULL),
(357, 0, [[timestamp]], NULL, 'portfolio_moderate_db_threshold', '20', NULL),
(358, 0, [[timestamp]], NULL, 'portfolio_high_db_threshold', '50', NULL),
(359, 0, [[timestamp]], 'question_preview', 'behaviour', 'deferredfeedback', NULL),
(360, 0, [[timestamp]], 'question_preview', 'correctness', '1', NULL),
(361, 0, [[timestamp]], 'question_preview', 'marks', '2', NULL),
(362, 0, [[timestamp]], 'question_preview', 'markdp', '2', NULL),
(363, 0, [[timestamp]], 'question_preview', 'feedback', '1', NULL),
(364, 0, [[timestamp]], 'question_preview', 'generalfeedback', '1', NULL),
(365, 0, [[timestamp]], 'question_preview', 'rightanswer', '1', NULL),
(366, 0, [[timestamp]], 'question_preview', 'history', '0', NULL),
(367, 0, [[timestamp]], NULL, 'repositorycacheexpire', '120', NULL),
(368, 0, [[timestamp]], NULL, 'repositorygetfiletimeout', '30', NULL),
(369, 0, [[timestamp]], NULL, 'repositorysyncfiletimeout', '1', NULL),
(370, 0, [[timestamp]], NULL, 'repositorysyncimagetimeout', '3', NULL),
(371, 0, [[timestamp]], NULL, 'repositoryallowexternallinks', '1', NULL),
(372, 0, [[timestamp]], NULL, 'legacyfilesinnewcourses', '0', NULL),
(373, 0, [[timestamp]], NULL, 'legacyfilesaddallowed', '1', NULL),
(374, 0, [[timestamp]], NULL, 'searchengine', 'simpledb', NULL),
(375, 0, [[timestamp]], NULL, 'searchindexwhendisabled', '0', NULL),
(376, 0, [[timestamp]], NULL, 'searchindextime', '600', NULL),
(377, 0, [[timestamp]], NULL, 'searchallavailablecourses', '0', NULL),
(378, 0, [[timestamp]], NULL, 'searchincludeallcourses', '0', NULL),
(379, 0, [[timestamp]], NULL, 'searchenablecategories', '0', NULL),
(380, 0, [[timestamp]], NULL, 'searchdefaultcategory', 'core-all', NULL),
(381, 0, [[timestamp]], NULL, 'searchhideallcategory', '0', NULL),
(382, 0, [[timestamp]], NULL, 'searchenginequeryonly', '', NULL),
(383, 0, [[timestamp]], NULL, 'searchbannerenable', '0', NULL),
(384, 0, [[timestamp]], NULL, 'searchbanner', '', NULL),
(385, 0, [[timestamp]], NULL, 'allowbeforeblock', '0', NULL),
(386, 0, [[timestamp]], NULL, 'allowedip', '', NULL),
(387, 0, [[timestamp]], NULL, 'blockedip', '', NULL),
(388, 0, [[timestamp]], NULL, 'protectusernames', '1', NULL),
(389, 0, [[timestamp]], NULL, 'forcelogin', '0', NULL),
(390, 0, [[timestamp]], NULL, 'forceloginforprofiles', '1', NULL),
(391, 0, [[timestamp]], NULL, 'forceloginforprofileimage', '0', NULL),
(392, 0, [[timestamp]], NULL, 'opentowebcrawlers', '0', NULL),
(393, 0, [[timestamp]], NULL, 'allowindexing', '0', NULL),
(394, 0, [[timestamp]], NULL, 'maxbytes', '0', NULL),
(395, 0, [[timestamp]], NULL, 'userquota', '104857600', NULL),
(396, 0, [[timestamp]], NULL, 'allowobjectembed', '0', NULL),
(397, 0, [[timestamp]], NULL, 'enabletrusttext', '0', NULL),
(398, 0, [[timestamp]], NULL, 'maxeditingtime', '1800', NULL),
(399, 0, [[timestamp]], NULL, 'extendedusernamechars', '0', NULL),
(400, 0, [[timestamp]], NULL, 'keeptagnamecase', '1', NULL),
(401, 0, [[timestamp]], NULL, 'profilesforenrolledusersonly', '1', NULL),
(402, 0, [[timestamp]], NULL, 'cronclionly', '1', NULL),
(403, 0, [[timestamp]], NULL, 'cronremotepassword', '', NULL),
(404, 0, [[timestamp]], 'tool_task', 'enablerunnow', '1', NULL),
(405, 0, [[timestamp]], NULL, 'lockoutthreshold', '0', NULL),
(406, 0, [[timestamp]], NULL, 'lockoutwindow', '1800', NULL),
(407, 0, [[timestamp]], NULL, 'lockoutduration', '1800', NULL),
(408, 0, [[timestamp]], NULL, 'passwordpolicy', '1', NULL),
(409, 0, [[timestamp]], NULL, 'minpasswordlength', '8', NULL),
(410, 0, [[timestamp]], NULL, 'minpassworddigits', '1', NULL),
(411, 0, [[timestamp]], NULL, 'minpasswordlower', '1', NULL),
(412, 0, [[timestamp]], NULL, 'minpasswordupper', '1', NULL),
(413, 0, [[timestamp]], NULL, 'minpasswordnonalphanum', '1', NULL),
(414, 0, [[timestamp]], NULL, 'maxconsecutiveidentchars', '0', NULL),
(415, 0, [[timestamp]], NULL, 'passwordpolicycheckonlogin', '0', NULL),
(416, 0, [[timestamp]], NULL, 'passwordreuselimit', '0', NULL),
(417, 0, [[timestamp]], NULL, 'pwresettime', '1800', NULL),
(418, 0, [[timestamp]], NULL, 'passwordchangelogout', '0', NULL),
(419, 0, [[timestamp]], NULL, 'passwordchangetokendeletion', '0', NULL),
(420, 0, [[timestamp]], NULL, 'tokenduration', '7257600', NULL),
(421, 0, [[timestamp]], NULL, 'groupenrolmentkeypolicy', '1', NULL),
(422, 0, [[timestamp]], NULL, 'disableuserimages', '0', NULL),
(423, 0, [[timestamp]], NULL, 'emailchangeconfirmation', '1', NULL),
(424, 0, [[timestamp]], NULL, 'rememberusername', '2', NULL),
(425, 0, [[timestamp]], NULL, 'strictformsrequired', '0', NULL),
(426, 0, [[timestamp]], NULL, 'cookiesecure', '1', NULL),
(427, 0, [[timestamp]], NULL, 'cookiehttponly', '0', NULL),
(428, 0, [[timestamp]], NULL, 'allowframembedding', '0', NULL),
(429, 0, [[timestamp]], NULL, 'curlsecurityblockedhosts', '', NULL),
(430, 0, [[timestamp]], NULL, 'curlsecurityallowedport', '', NULL),
(431, 0, [[timestamp]], NULL, 'referrerpolicy', 'default', NULL),
(432, 0, [[timestamp]], NULL, 'displayloginfailures', '0', NULL),
(433, 0, [[timestamp]], NULL, 'notifyloginfailures', '', NULL),
(434, 0, [[timestamp]], NULL, 'notifyloginthreshold', '10', NULL),
(435, 0, [[timestamp]], NULL, 'themelist', '', NULL),
(436, 0, [[timestamp]], NULL, 'themedesignermode', '0', NULL),
(437, 0, [[timestamp]], NULL, 'allowuserthemes', '0', NULL),
(438, 0, [[timestamp]], NULL, 'allowcoursethemes', '0', NULL),
(439, 0, [[timestamp]], NULL, 'allowcategorythemes', '0', NULL),
(440, 0, [[timestamp]], NULL, 'allowcohortthemes', '0', NULL),
(441, 0, [[timestamp]], NULL, 'allowthemechangeonurl', '0', NULL),
(442, 0, [[timestamp]], NULL, 'allowuserblockhiding', '1', NULL),
(443, 0, [[timestamp]], NULL, 'langmenuinsecurelayout', '0', NULL),
(444, 0, [[timestamp]], NULL, 'logininfoinsecurelayout', '0', NULL),
(445, 0, [[timestamp]], NULL, 'custommenuitems', '', NULL),
(446, 0, [[timestamp]], NULL, 'customusermenuitems', 'grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences', NULL),
(447, 0, [[timestamp]], NULL, 'enabledevicedetection', '1', NULL),
(448, 0, [[timestamp]], NULL, 'devicedetectregex', '[]', NULL),
(449, 0, [[timestamp]], 'theme_boost', 'preset', 'default.scss', NULL),
(450, 0, [[timestamp]], 'theme_boost', 'presetfiles', '', NULL),
(451, 0, [[timestamp]], 'theme_boost', 'backgroundimage', '', NULL),
(452, 0, [[timestamp]], 'theme_boost', 'brandcolor', '', NULL),
(453, 0, [[timestamp]], 'theme_boost', 'scsspre', '', NULL),
(454, 0, [[timestamp]], 'theme_boost', 'scss', '', NULL),
(455, 0, [[timestamp]], 'theme_classic', 'navbardark', '0', NULL),
(456, 0, [[timestamp]], 'theme_classic', 'preset', 'default.scss', NULL),
(457, 0, [[timestamp]], 'theme_classic', 'presetfiles', '', NULL),
(458, 0, [[timestamp]], 'theme_classic', 'backgroundimage', '', NULL),
(459, 0, [[timestamp]], 'theme_classic', 'brandcolor', '', NULL),
(460, 0, [[timestamp]], 'theme_classic', 'scsspre', '', NULL),
(461, 0, [[timestamp]], 'theme_classic', 'scss', '', NULL),
(462, 0, [[timestamp]], 'core_admin', 'logo', '', NULL),
(463, 0, [[timestamp]], 'core_admin', 'logocompact', '', NULL),
(464, 0, [[timestamp]], 'core_admin', 'coursecolor1', '#81ecec', NULL),
(465, 0, [[timestamp]], 'core_admin', 'coursecolor2', '#74b9ff', NULL),
(466, 0, [[timestamp]], 'core_admin', 'coursecolor3', '#a29bfe', NULL),
(467, 0, [[timestamp]], 'core_admin', 'coursecolor4', '#dfe6e9', NULL),
(468, 0, [[timestamp]], 'core_admin', 'coursecolor5', '#00b894', NULL),
(469, 0, [[timestamp]], 'core_admin', 'coursecolor6', '#0984e3', NULL),
(470, 0, [[timestamp]], 'core_admin', 'coursecolor7', '#b2bec3', NULL),
(471, 0, [[timestamp]], 'core_admin', 'coursecolor8', '#fdcb6e', NULL),
(472, 0, [[timestamp]], 'core_admin', 'coursecolor9', '#fd79a8', NULL),
(473, 0, [[timestamp]], 'core_admin', 'coursecolor10', '#6c5ce7', NULL),
(474, 0, [[timestamp]], NULL, 'calendartype', 'gregorian', NULL),
(475, 0, [[timestamp]], NULL, 'calendar_adminseesall', '0', NULL),
(476, 0, [[timestamp]], NULL, 'calendar_site_timeformat', '0', NULL),
(477, 0, [[timestamp]], NULL, 'calendar_startwday', '1', NULL),
(478, 0, [[timestamp]], NULL, 'calendar_weekend', '65', NULL),
(479, 0, [[timestamp]], NULL, 'calendar_lookahead', '21', NULL),
(480, 0, [[timestamp]], NULL, 'calendar_maxevents', '10', NULL),
(481, 0, [[timestamp]], NULL, 'enablecalendarexport', '1', NULL),
(482, 0, [[timestamp]], NULL, 'calendar_customexport', '1', NULL),
(483, 0, [[timestamp]], NULL, 'calendar_exportlookahead', '365', NULL),
(484, 0, [[timestamp]], NULL, 'calendar_exportlookback', '5', NULL),
(485, 0, [[timestamp]], NULL, 'calendar_exportsalt', '[[export_salt_old]]', NULL),
(486, 0, [[timestamp]], NULL, 'calendar_showicalsource', '1', NULL),
(487, 0, [[timestamp]], NULL, 'useblogassociations', '1', NULL),
(488, 0, [[timestamp]], NULL, 'bloglevel', '4', NULL),
(489, 0, [[timestamp]], NULL, 'useexternalblogs', '1', NULL),
(490, 0, [[timestamp]], NULL, 'externalblogcrontime', '86400', NULL),
(491, 0, [[timestamp]], NULL, 'maxexternalblogsperuser', '1', NULL),
(492, 0, [[timestamp]], NULL, 'blogusecomments', '1', NULL),
(493, 0, [[timestamp]], NULL, 'blogshowcommentscount', '1', NULL),
(494, 0, [[timestamp]], NULL, 'defaulthomepage', '1', NULL),
(495, 0, [[timestamp]], NULL, 'allowguestmymoodle', '1', NULL),
(496, 0, [[timestamp]], NULL, 'navshowfullcoursenames', '0', NULL),
(497, 0, [[timestamp]], NULL, 'navshowcategories', '1', NULL),
(498, 0, [[timestamp]], NULL, 'navshowmycoursecategories', '0', NULL),
(499, 0, [[timestamp]], NULL, 'navshowallcourses', '0', NULL),
(500, 0, [[timestamp]], NULL, 'navsortmycoursessort', 'sortorder', NULL),
(501, 0, [[timestamp]], NULL, 'navsortmycourseshiddenlast', '1', NULL),
(502, 0, [[timestamp]], NULL, 'navcourselimit', '10', NULL),
(503, 0, [[timestamp]], NULL, 'usesitenameforsitepages', '0', NULL),
(504, 0, [[timestamp]], NULL, 'linkadmincategories', '1', NULL),
(505, 0, [[timestamp]], NULL, 'linkcoursesections', '1', NULL),
(506, 0, [[timestamp]], NULL, 'navshowfrontpagemods', '1', NULL),
(507, 0, [[timestamp]], NULL, 'navadduserpostslinks', '1', NULL),
(508, 0, [[timestamp]], NULL, 'formatstringstriptags', '1', NULL),
(509, 0, [[timestamp]], NULL, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]', NULL),
(510, 0, [[timestamp]], NULL, 'docroot', 'https://docs.moodle.org', NULL),
(511, 0, [[timestamp]], NULL, 'doclang', '', NULL),
(512, 0, [[timestamp]], NULL, 'doctonewwindow', '0', NULL),
(513, 0, [[timestamp]], NULL, 'coursecontactduplicates', '0', NULL),
(514, 0, [[timestamp]], NULL, 'courselistshortnames', '0', NULL),
(515, 0, [[timestamp]], NULL, 'coursesperpage', '20', NULL),
(516, 0, [[timestamp]], NULL, 'courseswithsummarieslimit', '10', NULL),
(517, 0, [[timestamp]], NULL, 'courseoverviewfileslimit', '1', NULL),
(518, 0, [[timestamp]], NULL, 'courseoverviewfilesext', '.jpg,.gif,.png', NULL),
(519, 0, [[timestamp]], NULL, 'coursegraceperiodbefore', '0', NULL),
(520, 0, [[timestamp]], NULL, 'coursegraceperiodafter', '0', NULL),
(521, 0, [[timestamp]], NULL, 'useexternalyui', '0', NULL),
(522, 0, [[timestamp]], NULL, 'yuicomboloading', '1', NULL),
(523, 0, [[timestamp]], NULL, 'cachejs', '1', NULL),
(524, 0, [[timestamp]], NULL, 'additionalhtmlhead', '', NULL),
(525, 0, [[timestamp]], NULL, 'additionalhtmltopofbody', '', NULL),
(526, 0, [[timestamp]], NULL, 'additionalhtmlfooter', '', NULL),
(527, 0, [[timestamp]], NULL, 'cachetemplates', '1', NULL),
(528, 0, [[timestamp]], NULL, 'pathtophp', '', NULL),
(529, 0, [[timestamp]], NULL, 'pathtodu', '', NULL),
(530, 0, [[timestamp]], NULL, 'aspellpath', '', NULL),
(531, 0, [[timestamp]], NULL, 'pathtodot', '', NULL),
(532, 0, [[timestamp]], NULL, 'pathtogs', '/usr/bin/gs', NULL),
(533, 0, [[timestamp]], NULL, 'pathtopdftoppm', '', NULL),
(534, 0, [[timestamp]], NULL, 'pathtopython', '', NULL),
(535, 0, [[timestamp]], NULL, 'supportname', 'Admin User', NULL),
(536, 0, [[timestamp]], NULL, 'supportemail', '', NULL),
(537, 0, [[timestamp]], NULL, 'supportpage', '', NULL),
(538, 0, [[timestamp]], NULL, 'dbsessions', '0', NULL),
(539, 0, [[timestamp]], NULL, 'sessiontimeoutwarning', '1200', NULL),
(540, 0, [[timestamp]], NULL, 'sessioncookie', '', NULL),
(541, 0, [[timestamp]], NULL, 'sessioncookiepath', '', NULL),
(542, 0, [[timestamp]], NULL, 'sessioncookiedomain', '', NULL),
(543, 0, [[timestamp]], NULL, 'statsfirstrun', 'none', NULL),
(544, 0, [[timestamp]], NULL, 'statsmaxruntime', '0', NULL),
(545, 0, [[timestamp]], NULL, 'statsruntimedays', '31', NULL),
(546, 0, [[timestamp]], NULL, 'statsuserthreshold', '0', NULL),
(547, 0, [[timestamp]], NULL, 'slasharguments', '1', NULL),
(548, 0, [[timestamp]], NULL, 'getremoteaddrconf', '3', NULL),
(549, 0, [[timestamp]], NULL, 'reverseproxyignore', '', NULL),
(550, 0, [[timestamp]], NULL, 'proxyhost', '', NULL),
(551, 0, [[timestamp]], NULL, 'proxyport', '0', NULL),
(552, 0, [[timestamp]], NULL, 'proxytype', 'HTTP', NULL),
(553, 0, [[timestamp]], NULL, 'proxyuser', '', NULL),
(554, 0, [[timestamp]], NULL, 'proxypassword', '', NULL),
(555, 0, [[timestamp]], NULL, 'proxybypass', 'localhost, 127.0.0.1', NULL),
(556, 0, [[timestamp]], NULL, 'maintenance_enabled', '0', NULL),
(557, 0, [[timestamp]], NULL, 'maintenance_message', '', NULL),
(558, 0, [[timestamp]], NULL, 'deleteunconfirmed', '168', NULL),
(559, 0, [[timestamp]], NULL, 'deleteincompleteusers', '0', NULL),
(560, 0, [[timestamp]], NULL, 'disablegradehistory', '0', NULL),
(561, 0, [[timestamp]], NULL, 'gradehistorylifetime', '0', NULL),
(562, 0, [[timestamp]], NULL, 'tempdatafoldercleanup', '168', NULL),
(563, 0, [[timestamp]], NULL, 'filescleanupperiod', '86400', NULL),
(564, 0, [[timestamp]], NULL, 'extramemorylimit', '512M', NULL),
(565, 0, [[timestamp]], NULL, 'maxtimelimit', '0', NULL),
(566, 0, [[timestamp]], NULL, 'curlcache', '120', NULL),
(567, 0, [[timestamp]], NULL, 'curltimeoutkbitrate', '56', NULL),
(568, 0, [[timestamp]], NULL, 'cron_enabled', '1', NULL),
(569, 0, [[timestamp]], NULL, 'task_scheduled_concurrency_limit', '3', NULL),
(570, 0, [[timestamp]], NULL, 'task_scheduled_max_runtime', '1800', NULL),
(571, 0, [[timestamp]], NULL, 'task_adhoc_concurrency_limit', '3', NULL),
(572, 0, [[timestamp]], NULL, 'task_adhoc_max_runtime', '1800', NULL),
(573, 0, [[timestamp]], NULL, 'task_logmode', '1', NULL),
(574, 0, [[timestamp]], NULL, 'task_logtostdout', '1', NULL),
(575, 0, [[timestamp]], NULL, 'task_logretention', '2419200', NULL),
(576, 0, [[timestamp]], NULL, 'task_logretainruns', '20', NULL),
(577, 0, [[timestamp]], NULL, 'smtphosts', '', NULL),
(578, 0, [[timestamp]], NULL, 'smtpsecure', '', NULL),
(579, 0, [[timestamp]], NULL, 'smtpauthtype', 'LOGIN', NULL),
(580, 0, [[timestamp]], NULL, 'smtpuser', '', NULL),
(581, 0, [[timestamp]], NULL, 'smtppass', '', NULL),
(582, 0, [[timestamp]], NULL, 'smtpmaxbulk', '1', NULL),
(583, 0, [[timestamp]], NULL, 'noreplyaddress', '[[admin_email]]', NULL),
(584, 0, [[timestamp]], NULL, 'allowedemaildomains', '', NULL),
(585, 0, [[timestamp]], NULL, 'divertallemailsto', '', NULL),
(586, 0, [[timestamp]], NULL, 'divertallemailsexcept', '', NULL),
(587, 0, [[timestamp]], NULL, 'emaildkimselector', '', NULL),
(588, 0, [[timestamp]], NULL, 'sitemailcharset', '0', NULL),
(589, 0, [[timestamp]], NULL, 'allowusermailcharset', '0', NULL),
(590, 0, [[timestamp]], NULL, 'allowattachments', '1', NULL),
(591, 0, [[timestamp]], NULL, 'mailnewline', 'LF', NULL),
(592, 0, [[timestamp]], NULL, 'emailfromvia', '1', NULL),
(593, 0, [[timestamp]], NULL, 'emailsubjectprefix', '', NULL),
(594, 0, [[timestamp]], NULL, 'emailheaders', '', NULL),
(595, 0, [[timestamp]], NULL, 'updateautocheck', '1', NULL),
(596, 0, [[timestamp]], NULL, 'updateminmaturity', '200', NULL),
(597, 0, [[timestamp]], NULL, 'updatenotifybuilds', '0', NULL),
(598, 0, [[timestamp]], NULL, 'enablewsdocumentation', '0', NULL),
(599, 0, [[timestamp]], NULL, 'dndallowtextandlinks', '0', NULL),
(600, 0, [[timestamp]], NULL, 'pathtosassc', '', NULL),
(601, 0, [[timestamp]], NULL, 'contextlocking', '0', NULL),
(602, 0, [[timestamp]], NULL, 'contextlockappliestoadmin', '1', NULL),
(603, 0, [[timestamp]], NULL, 'forceclean', '0', NULL),
(604, 0, [[timestamp]], NULL, 'enablecourserelativedates', '0', NULL),
(605, 0, [[timestamp]], NULL, 'debug', '0', NULL),
(606, 0, [[timestamp]], NULL, 'debugdisplay', '0', NULL),
(607, 0, [[timestamp]], NULL, 'perfdebug', '7', NULL),
(608, 0, [[timestamp]], NULL, 'debugstringids', '0', NULL),
(609, 0, [[timestamp]], NULL, 'debugsqltrace', '0', NULL),
(610, 0, [[timestamp]], NULL, 'debugvalidators', '0', NULL),
(611, 0, [[timestamp]], NULL, 'debugpageinfo', '0', NULL),
(612, 0, [[timestamp]], NULL, 'profilingenabled', '0', NULL),
(613, 0, [[timestamp]], NULL, 'profilingincluded', '', NULL),
(614, 0, [[timestamp]], NULL, 'profilingexcluded', '', NULL),
(615, 0, [[timestamp]], NULL, 'profilingautofrec', '0', NULL),
(616, 0, [[timestamp]], NULL, 'profilingallowme', '0', NULL),
(617, 0, [[timestamp]], NULL, 'profilingallowall', '0', NULL),
(618, 0, [[timestamp]], NULL, 'profilingslow', '0', NULL),
(619, 0, [[timestamp]], NULL, 'profilinglifetime', '1440', NULL),
(620, 0, [[timestamp]], NULL, 'profilingimportprefix', '(I)', NULL),
(621, 0, [[timestamp]], NULL, 'calendar_exportsalt', '[[export_salt]]', '[[export_salt_old]]'),
(622, 0, [[timestamp]], 'activitynames', 'filter_active', '1', ''),
(623, 0, [[timestamp]], 'core_filter', 'order', 'activitynames', 'activitynames'),
(624, 0, [[timestamp]], 'displayh5p', 'filter_active', '1', ''),
(625, 0, [[timestamp]], 'core_filter', 'order', 'displayh5p, activitynames', 'activitynames, displayh5p'),
(626, 0, [[timestamp]], 'emoticon', 'filter_active', '1', ''),
(627, 0, [[timestamp]], 'mathjaxloader', 'filter_active', '1', ''),
(628, 0, [[timestamp]], 'core_filter', 'order', 'displayh5p, activitynames, mathjaxloader, emoticon', 'displayh5p, activitynames, emoticon, mathjaxloader'),
(629, 0, [[timestamp]], 'mediaplugin', 'filter_active', '1', ''),
(630, 0, [[timestamp]], 'urltolink', 'filter_active', '1', ''),
(631, 0, [[timestamp]], 'core_filter', 'order', 'displayh5p, activitynames, mathjaxloader, emoticon, urltolink, mediaplugin', 'displayh5p, activitynames, mathjaxloader, emoticon, mediaplugin, urltolink'),
(632, 2, [[timestamp]], NULL, 'enableaccessibilitytools', '1', NULL),
(633, 2, [[timestamp]], NULL, 'notloggedinroleid', '6', NULL),
(634, 2, [[timestamp]], NULL, 'guestroleid', '6', NULL),
(635, 2, [[timestamp]], NULL, 'defaultuserroleid', '7', NULL),
(636, 2, [[timestamp]], NULL, 'creatornewroleid', '3', NULL),
(637, 2, [[timestamp]], NULL, 'restorernewroleid', '3', NULL),
(638, 2, [[timestamp]], 'tool_dataprivacy', 'contactdataprotectionofficer', '0', NULL),
(639, 2, [[timestamp]], 'tool_dataprivacy', 'automaticdataexportapproval', '0', NULL),
(640, 2, [[timestamp]], 'tool_dataprivacy', 'automaticdatadeletionapproval', '0', NULL),
(641, 2, [[timestamp]], 'tool_dataprivacy', 'automaticdeletionrequests', '1', NULL),
(642, 2, [[timestamp]], 'tool_dataprivacy', 'privacyrequestexpiry', '604800', NULL),
(643, 2, [[timestamp]], 'tool_dataprivacy', 'requireallenddatesforuserdeletion', '1', NULL),
(644, 2, [[timestamp]], 'tool_dataprivacy', 'showdataretentionsummary', '1', NULL),
(645, 2, [[timestamp]], 'tool_log', 'exportlog', '1', NULL),
(646, 2, [[timestamp]], NULL, 'sitepolicyhandler', '', NULL),
(647, 2, [[timestamp]], NULL, 'gradebookroles', '5', NULL),
(648, 2, [[timestamp]], 'analytics', 'logstore', 'logstore_standard', NULL),
(649, 2, [[timestamp]], NULL, 'h5plibraryhandler', 'h5plib_v124', NULL),
(650, 2, [[timestamp]], NULL, 'jabberhost', '', NULL),
(651, 2, [[timestamp]], NULL, 'jabberserver', '', NULL),
(652, 2, [[timestamp]], NULL, 'jabberusername', '', NULL),
(653, 2, [[timestamp]], NULL, 'jabberpassword', '', NULL),
(654, 2, [[timestamp]], NULL, 'jabberport', '5222', NULL),
(655, 2, [[timestamp]], NULL, 'airnotifierurl', 'https://messages.moodle.net', NULL),
(656, 2, [[timestamp]], NULL, 'airnotifierport', '443', NULL),
(657, 2, [[timestamp]], NULL, 'airnotifiermobileappname', 'com.moodle.moodlemobile', NULL),
(658, 2, [[timestamp]], NULL, 'airnotifierappname', 'commoodlemoodlemobile', NULL),
(659, 2, [[timestamp]], NULL, 'airnotifieraccesskey', '', NULL),
(660, 2, [[timestamp]], 'assign', 'feedback_plugin_for_gradebook', 'assignfeedback_comments', NULL),
(661, 2, [[timestamp]], 'assign', 'showrecentsubmissions', '0', NULL),
(662, 2, [[timestamp]], 'assign', 'submissionreceipts', '1', NULL),
(663, 2, [[timestamp]], 'assign', 'submissionstatement', 'This submission is my own work, except where I have acknowledged the use of the works of other people.', NULL),
(664, 2, [[timestamp]], 'assign', 'submissionstatementteamsubmission', 'This submission is the work of my group, except where we have acknowledged the use of the works of other people.', NULL),
(665, 2, [[timestamp]], 'assign', 'submissionstatementteamsubmissionallsubmit', 'This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.', NULL),
(666, 2, [[timestamp]], 'assign', 'maxperpage', '-1', NULL),
(667, 2, [[timestamp]], 'assign', 'alwaysshowdescription', '1', NULL),
(668, 2, [[timestamp]], 'assign', 'alwaysshowdescription_adv', '', NULL),
(669, 2, [[timestamp]], 'assign', 'alwaysshowdescription_locked', '', NULL),
(670, 2, [[timestamp]], 'assign', 'allowsubmissionsfromdate', '0', NULL),
(671, 2, [[timestamp]], 'assign', 'allowsubmissionsfromdate_enabled', '1', NULL),
(672, 2, [[timestamp]], 'assign', 'allowsubmissionsfromdate_adv', '', NULL),
(673, 2, [[timestamp]], 'assign', 'duedate', '604800', NULL),
(674, 2, [[timestamp]], 'assign', 'duedate_enabled', '1', NULL),
(675, 2, [[timestamp]], 'assign', 'duedate_adv', '', NULL),
(676, 2, [[timestamp]], 'assign', 'cutoffdate', '1209600', NULL),
(677, 2, [[timestamp]], 'assign', 'cutoffdate_enabled', '', NULL),
(678, 2, [[timestamp]], 'assign', 'cutoffdate_adv', '', NULL),
(679, 2, [[timestamp]], 'assign', 'gradingduedate', '1209600', NULL),
(680, 2, [[timestamp]], 'assign', 'gradingduedate_enabled', '1', NULL),
(681, 2, [[timestamp]], 'assign', 'gradingduedate_adv', '', NULL),
(682, 2, [[timestamp]], 'assign', 'submissiondrafts', '0', NULL),
(683, 2, [[timestamp]], 'assign', 'submissiondrafts_adv', '', NULL),
(684, 2, [[timestamp]], 'assign', 'submissiondrafts_locked', '', NULL),
(685, 2, [[timestamp]], 'assign', 'requiresubmissionstatement', '0', NULL),
(686, 2, [[timestamp]], 'assign', 'requiresubmissionstatement_adv', '', NULL),
(687, 2, [[timestamp]], 'assign', 'requiresubmissionstatement_locked', '', NULL),
(688, 2, [[timestamp]], 'assign', 'attemptreopenmethod', 'none', NULL),
(689, 2, [[timestamp]], 'assign', 'attemptreopenmethod_adv', '', NULL),
(690, 2, [[timestamp]], 'assign', 'attemptreopenmethod_locked', '', NULL),
(691, 2, [[timestamp]], 'assign', 'maxattempts', '-1', NULL),
(692, 2, [[timestamp]], 'assign', 'maxattempts_adv', '', NULL),
(693, 2, [[timestamp]], 'assign', 'maxattempts_locked', '', NULL),
(694, 2, [[timestamp]], 'assign', 'teamsubmission', '0', NULL),
(695, 2, [[timestamp]], 'assign', 'teamsubmission_adv', '', NULL),
(696, 2, [[timestamp]], 'assign', 'teamsubmission_locked', '', NULL),
(697, 2, [[timestamp]], 'assign', 'preventsubmissionnotingroup', '0', NULL),
(698, 2, [[timestamp]], 'assign', 'preventsubmissionnotingroup_adv', '', NULL),
(699, 2, [[timestamp]], 'assign', 'preventsubmissionnotingroup_locked', '', NULL),
(700, 2, [[timestamp]], 'assign', 'requireallteammemberssubmit', '0', NULL);
INSERT INTO `[[dbprefix]]config_log` VALUES
(701, 2, [[timestamp]], 'assign', 'requireallteammemberssubmit_adv', '', NULL),
(702, 2, [[timestamp]], 'assign', 'requireallteammemberssubmit_locked', '', NULL),
(703, 2, [[timestamp]], 'assign', 'teamsubmissiongroupingid', '', NULL),
(704, 2, [[timestamp]], 'assign', 'teamsubmissiongroupingid_adv', '', NULL),
(705, 2, [[timestamp]], 'assign', 'sendnotifications', '0', NULL),
(706, 2, [[timestamp]], 'assign', 'sendnotifications_adv', '', NULL),
(707, 2, [[timestamp]], 'assign', 'sendnotifications_locked', '', NULL),
(708, 2, [[timestamp]], 'assign', 'sendlatenotifications', '0', NULL),
(709, 2, [[timestamp]], 'assign', 'sendlatenotifications_adv', '', NULL),
(710, 2, [[timestamp]], 'assign', 'sendlatenotifications_locked', '', NULL),
(711, 2, [[timestamp]], 'assign', 'sendstudentnotifications', '1', NULL),
(712, 2, [[timestamp]], 'assign', 'sendstudentnotifications_adv', '', NULL),
(713, 2, [[timestamp]], 'assign', 'sendstudentnotifications_locked', '', NULL),
(714, 2, [[timestamp]], 'assign', 'blindmarking', '0', NULL),
(715, 2, [[timestamp]], 'assign', 'blindmarking_adv', '', NULL),
(716, 2, [[timestamp]], 'assign', 'blindmarking_locked', '', NULL),
(717, 2, [[timestamp]], 'assign', 'hidegrader', '0', NULL),
(718, 2, [[timestamp]], 'assign', 'hidegrader_adv', '', NULL),
(719, 2, [[timestamp]], 'assign', 'hidegrader_locked', '', NULL),
(720, 2, [[timestamp]], 'assign', 'markingworkflow', '0', NULL),
(721, 2, [[timestamp]], 'assign', 'markingworkflow_adv', '', NULL),
(722, 2, [[timestamp]], 'assign', 'markingworkflow_locked', '', NULL),
(723, 2, [[timestamp]], 'assign', 'markingallocation', '0', NULL),
(724, 2, [[timestamp]], 'assign', 'markingallocation_adv', '', NULL),
(725, 2, [[timestamp]], 'assign', 'markingallocation_locked', '', NULL),
(726, 2, [[timestamp]], 'assignsubmission_file', 'default', '1', NULL),
(727, 2, [[timestamp]], 'assignsubmission_file', 'maxfiles', '20', NULL),
(728, 2, [[timestamp]], 'assignsubmission_file', 'filetypes', '', NULL),
(729, 2, [[timestamp]], 'assignsubmission_file', 'maxbytes', '0', NULL),
(730, 2, [[timestamp]], 'assignsubmission_onlinetext', 'default', '0', NULL),
(731, 2, [[timestamp]], 'assignfeedback_comments', 'default', '1', NULL),
(732, 2, [[timestamp]], 'assignfeedback_comments', 'inline', '0', NULL),
(733, 2, [[timestamp]], 'assignfeedback_comments', 'inline_adv', '', NULL),
(734, 2, [[timestamp]], 'assignfeedback_comments', 'inline_locked', '', NULL),
(735, 2, [[timestamp]], 'assignfeedback_editpdf', 'default', '1', NULL),
(736, 2, [[timestamp]], 'assignfeedback_editpdf', 'stamps', '', NULL),
(737, 2, [[timestamp]], 'assignfeedback_file', 'default', '0', NULL),
(738, 2, [[timestamp]], 'assignfeedback_offline', 'default', '0', NULL),
(739, 2, [[timestamp]], 'book', 'numberingoptions', '0,1,2,3', NULL),
(740, 2, [[timestamp]], 'book', 'navoptions', '0,1,2', NULL),
(741, 2, [[timestamp]], 'book', 'numbering', '1', NULL),
(742, 2, [[timestamp]], 'book', 'navstyle', '1', NULL),
(743, 2, [[timestamp]], NULL, 'chat_method', 'ajax', NULL),
(744, 2, [[timestamp]], NULL, 'chat_refresh_userlist', '10', NULL),
(745, 2, [[timestamp]], NULL, 'chat_old_ping', '35', NULL),
(746, 2, [[timestamp]], NULL, 'chat_refresh_room', '5', NULL),
(747, 2, [[timestamp]], NULL, 'chat_normal_updatemode', 'jsupdate', NULL),
(748, 2, [[timestamp]], NULL, 'chat_serverhost', '[[domhost]]', NULL),
(749, 2, [[timestamp]], NULL, 'chat_serverip', '127.0.0.1', NULL),
(750, 2, [[timestamp]], NULL, 'chat_serverport', '9111', NULL),
(751, 2, [[timestamp]], NULL, 'chat_servermax', '100', NULL),
(752, 2, [[timestamp]], NULL, 'data_enablerssfeeds', '0', NULL),
(753, 2, [[timestamp]], NULL, 'feedback_allowfullanonymous', '0', NULL),
(754, 2, [[timestamp]], 'resource', 'framesize', '130', NULL),
(755, 2, [[timestamp]], 'resource', 'displayoptions', '0,1,4,5,6', NULL),
(756, 2, [[timestamp]], 'resource', 'printintro', '1', NULL),
(757, 2, [[timestamp]], 'resource', 'display', '0', NULL),
(758, 2, [[timestamp]], 'resource', 'showsize', '0', NULL),
(759, 2, [[timestamp]], 'resource', 'showtype', '0', NULL),
(760, 2, [[timestamp]], 'resource', 'showdate', '0', NULL),
(761, 2, [[timestamp]], 'resource', 'popupwidth', '620', NULL),
(762, 2, [[timestamp]], 'resource', 'popupheight', '450', NULL),
(763, 2, [[timestamp]], 'resource', 'filterfiles', '0', NULL),
(764, 2, [[timestamp]], 'folder', 'showexpanded', '1', NULL),
(765, 2, [[timestamp]], 'folder', 'maxsizetodownload', '0', NULL),
(766, 2, [[timestamp]], NULL, 'forum_displaymode', '3', NULL),
(767, 2, [[timestamp]], NULL, 'forum_shortpost', '300', NULL),
(768, 2, [[timestamp]], NULL, 'forum_longpost', '600', NULL),
(769, 2, [[timestamp]], NULL, 'forum_manydiscussions', '100', NULL),
(770, 2, [[timestamp]], NULL, 'forum_maxbytes', '512000', NULL),
(771, 2, [[timestamp]], NULL, 'forum_maxattachments', '9', NULL),
(772, 2, [[timestamp]], NULL, 'forum_subscription', '0', NULL),
(773, 2, [[timestamp]], NULL, 'forum_trackingtype', '1', NULL),
(774, 2, [[timestamp]], NULL, 'forum_trackreadposts', '1', NULL),
(775, 2, [[timestamp]], NULL, 'forum_allowforcedreadtracking', '0', NULL),
(776, 2, [[timestamp]], NULL, 'forum_oldpostdays', '14', NULL),
(777, 2, [[timestamp]], NULL, 'forum_usermarksread', '0', NULL),
(778, 2, [[timestamp]], NULL, 'forum_cleanreadtime', '2', NULL),
(779, 2, [[timestamp]], NULL, 'digestmailtime', '17', NULL),
(780, 2, [[timestamp]], NULL, 'forum_enablerssfeeds', '0', NULL),
(781, 2, [[timestamp]], NULL, 'forum_enabletimedposts', '1', NULL),
(782, 2, [[timestamp]], NULL, 'glossary_entbypage', '10', NULL),
(783, 2, [[timestamp]], NULL, 'glossary_dupentries', '0', NULL),
(784, 2, [[timestamp]], NULL, 'glossary_allowcomments', '0', NULL),
(785, 2, [[timestamp]], NULL, 'glossary_linkbydefault', '1', NULL),
(786, 2, [[timestamp]], NULL, 'glossary_defaultapproval', '1', NULL),
(787, 2, [[timestamp]], NULL, 'glossary_enablerssfeeds', '0', NULL),
(788, 2, [[timestamp]], NULL, 'glossary_linkentries', '0', NULL),
(789, 2, [[timestamp]], NULL, 'glossary_casesensitive', '0', NULL),
(790, 2, [[timestamp]], NULL, 'glossary_fullmatch', '0', NULL),
(791, 2, [[timestamp]], 'imscp', 'keepold', '1', NULL),
(792, 2, [[timestamp]], 'imscp', 'keepold_adv', '', NULL),
(793, 2, [[timestamp]], 'label', 'dndmedia', '1', NULL),
(794, 2, [[timestamp]], 'label', 'dndresizewidth', '400', NULL),
(795, 2, [[timestamp]], 'label', 'dndresizeheight', '400', NULL),
(796, 2, [[timestamp]], 'mod_lesson', 'mediafile', '', NULL),
(797, 2, [[timestamp]], 'mod_lesson', 'mediafile_adv', '1', NULL),
(798, 2, [[timestamp]], 'mod_lesson', 'mediawidth', '640', NULL),
(799, 2, [[timestamp]], 'mod_lesson', 'mediaheight', '480', NULL),
(800, 2, [[timestamp]], 'mod_lesson', 'mediaclose', '0', NULL),
(801, 2, [[timestamp]], 'mod_lesson', 'progressbar', '0', NULL),
(802, 2, [[timestamp]], 'mod_lesson', 'progressbar_adv', '', NULL),
(803, 2, [[timestamp]], 'mod_lesson', 'ongoing', '0', NULL),
(804, 2, [[timestamp]], 'mod_lesson', 'ongoing_adv', '1', NULL),
(805, 2, [[timestamp]], 'mod_lesson', 'displayleftmenu', '0', NULL),
(806, 2, [[timestamp]], 'mod_lesson', 'displayleftmenu_adv', '', NULL),
(807, 2, [[timestamp]], 'mod_lesson', 'displayleftif', '0', NULL),
(808, 2, [[timestamp]], 'mod_lesson', 'displayleftif_adv', '1', NULL),
(809, 2, [[timestamp]], 'mod_lesson', 'slideshow', '0', NULL),
(810, 2, [[timestamp]], 'mod_lesson', 'slideshow_adv', '1', NULL),
(811, 2, [[timestamp]], 'mod_lesson', 'slideshowwidth', '640', NULL),
(812, 2, [[timestamp]], 'mod_lesson', 'slideshowheight', '480', NULL),
(813, 2, [[timestamp]], 'mod_lesson', 'slideshowbgcolor', '#FFFFFF', NULL),
(814, 2, [[timestamp]], 'mod_lesson', 'maxanswers', '5', NULL),
(815, 2, [[timestamp]], 'mod_lesson', 'maxanswers_adv', '1', NULL),
(816, 2, [[timestamp]], 'mod_lesson', 'defaultfeedback', '0', NULL),
(817, 2, [[timestamp]], 'mod_lesson', 'defaultfeedback_adv', '1', NULL),
(818, 2, [[timestamp]], 'mod_lesson', 'activitylink', '', NULL),
(819, 2, [[timestamp]], 'mod_lesson', 'activitylink_adv', '1', NULL),
(820, 2, [[timestamp]], 'mod_lesson', 'timelimit', '0', NULL),
(821, 2, [[timestamp]], 'mod_lesson', 'timelimit_adv', '', NULL),
(822, 2, [[timestamp]], 'mod_lesson', 'password', '0', NULL),
(823, 2, [[timestamp]], 'mod_lesson', 'password_adv', '1', NULL),
(824, 2, [[timestamp]], 'mod_lesson', 'modattempts', '0', NULL),
(825, 2, [[timestamp]], 'mod_lesson', 'modattempts_adv', '', NULL),
(826, 2, [[timestamp]], 'mod_lesson', 'displayreview', '0', NULL),
(827, 2, [[timestamp]], 'mod_lesson', 'displayreview_adv', '', NULL),
(828, 2, [[timestamp]], 'mod_lesson', 'maximumnumberofattempts', '1', NULL),
(829, 2, [[timestamp]], 'mod_lesson', 'maximumnumberofattempts_adv', '', NULL),
(830, 2, [[timestamp]], 'mod_lesson', 'defaultnextpage', '0', NULL),
(831, 2, [[timestamp]], 'mod_lesson', 'defaultnextpage_adv', '1', NULL),
(832, 2, [[timestamp]], 'mod_lesson', 'numberofpagestoshow', '1', NULL),
(833, 2, [[timestamp]], 'mod_lesson', 'numberofpagestoshow_adv', '1', NULL),
(834, 2, [[timestamp]], 'mod_lesson', 'practice', '0', NULL),
(835, 2, [[timestamp]], 'mod_lesson', 'practice_adv', '', NULL),
(836, 2, [[timestamp]], 'mod_lesson', 'customscoring', '1', NULL),
(837, 2, [[timestamp]], 'mod_lesson', 'customscoring_adv', '1', NULL),
(838, 2, [[timestamp]], 'mod_lesson', 'retakesallowed', '0', NULL),
(839, 2, [[timestamp]], 'mod_lesson', 'retakesallowed_adv', '', NULL),
(840, 2, [[timestamp]], 'mod_lesson', 'handlingofretakes', '0', NULL),
(841, 2, [[timestamp]], 'mod_lesson', 'handlingofretakes_adv', '1', NULL),
(842, 2, [[timestamp]], 'mod_lesson', 'minimumnumberofquestions', '0', NULL),
(843, 2, [[timestamp]], 'mod_lesson', 'minimumnumberofquestions_adv', '1', NULL),
(844, 2, [[timestamp]], 'page', 'displayoptions', '5', NULL),
(845, 2, [[timestamp]], 'page', 'printheading', '1', NULL),
(846, 2, [[timestamp]], 'page', 'printintro', '0', NULL),
(847, 2, [[timestamp]], 'page', 'printlastmodified', '1', NULL),
(848, 2, [[timestamp]], 'page', 'display', '5', NULL),
(849, 2, [[timestamp]], 'page', 'popupwidth', '620', NULL),
(850, 2, [[timestamp]], 'page', 'popupheight', '450', NULL),
(851, 2, [[timestamp]], 'quiz', 'timelimit', '0', NULL),
(852, 2, [[timestamp]], 'quiz', 'timelimit_adv', '', NULL),
(853, 2, [[timestamp]], 'quiz', 'overduehandling', 'autosubmit', NULL),
(854, 2, [[timestamp]], 'quiz', 'overduehandling_adv', '', NULL),
(855, 2, [[timestamp]], 'quiz', 'graceperiod', '86400', NULL),
(856, 2, [[timestamp]], 'quiz', 'graceperiod_adv', '', NULL),
(857, 2, [[timestamp]], 'quiz', 'graceperiodmin', '60', NULL),
(858, 2, [[timestamp]], 'quiz', 'attempts', '0', NULL),
(859, 2, [[timestamp]], 'quiz', 'attempts_adv', '', NULL),
(860, 2, [[timestamp]], 'quiz', 'grademethod', '1', NULL),
(861, 2, [[timestamp]], 'quiz', 'grademethod_adv', '', NULL),
(862, 2, [[timestamp]], 'quiz', 'maximumgrade', '10', NULL),
(863, 2, [[timestamp]], 'quiz', 'questionsperpage', '1', NULL),
(864, 2, [[timestamp]], 'quiz', 'questionsperpage_adv', '', NULL),
(865, 2, [[timestamp]], 'quiz', 'navmethod', 'free', NULL),
(866, 2, [[timestamp]], 'quiz', 'navmethod_adv', '1', NULL),
(867, 2, [[timestamp]], 'quiz', 'shuffleanswers', '1', NULL),
(868, 2, [[timestamp]], 'quiz', 'shuffleanswers_adv', '', NULL),
(869, 2, [[timestamp]], 'quiz', 'preferredbehaviour', 'deferredfeedback', NULL),
(870, 2, [[timestamp]], 'quiz', 'canredoquestions', '0', NULL),
(871, 2, [[timestamp]], 'quiz', 'canredoquestions_adv', '1', NULL),
(872, 2, [[timestamp]], 'quiz', 'attemptonlast', '0', NULL),
(873, 2, [[timestamp]], 'quiz', 'attemptonlast_adv', '1', NULL),
(874, 2, [[timestamp]], 'quiz', 'reviewattempt', '69904', NULL),
(875, 2, [[timestamp]], 'quiz', 'reviewcorrectness', '69904', NULL),
(876, 2, [[timestamp]], 'quiz', 'reviewmarks', '69904', NULL),
(877, 2, [[timestamp]], 'quiz', 'reviewspecificfeedback', '69904', NULL),
(878, 2, [[timestamp]], 'quiz', 'reviewgeneralfeedback', '69904', NULL),
(879, 2, [[timestamp]], 'quiz', 'reviewrightanswer', '69904', NULL),
(880, 2, [[timestamp]], 'quiz', 'reviewoverallfeedback', '4368', NULL),
(881, 2, [[timestamp]], 'quiz', 'showuserpicture', '0', NULL),
(882, 2, [[timestamp]], 'quiz', 'showuserpicture_adv', '', NULL),
(883, 2, [[timestamp]], 'quiz', 'decimalpoints', '2', NULL),
(884, 2, [[timestamp]], 'quiz', 'decimalpoints_adv', '', NULL),
(885, 2, [[timestamp]], 'quiz', 'questiondecimalpoints', '-1', NULL),
(886, 2, [[timestamp]], 'quiz', 'questiondecimalpoints_adv', '', NULL),
(887, 2, [[timestamp]], 'quiz', 'showblocks', '0', NULL),
(888, 2, [[timestamp]], 'quiz', 'showblocks_adv', '1', NULL),
(889, 2, [[timestamp]], 'quiz', 'quizpassword', '', NULL),
(890, 2, [[timestamp]], 'quiz', 'quizpassword_adv', '', NULL),
(891, 2, [[timestamp]], 'quiz', 'quizpassword_required', '', NULL),
(892, 2, [[timestamp]], 'quiz', 'subnet', '', NULL),
(893, 2, [[timestamp]], 'quiz', 'subnet_adv', '1', NULL),
(894, 2, [[timestamp]], 'quiz', 'delay1', '0', NULL),
(895, 2, [[timestamp]], 'quiz', 'delay1_adv', '1', NULL),
(896, 2, [[timestamp]], 'quiz', 'delay2', '0', NULL),
(897, 2, [[timestamp]], 'quiz', 'delay2_adv', '1', NULL),
(898, 2, [[timestamp]], 'quiz', 'browsersecurity', '-', NULL),
(899, 2, [[timestamp]], 'quiz', 'browsersecurity_adv', '1', NULL),
(900, 2, [[timestamp]], 'quiz', 'initialnumfeedbacks', '2', NULL),
(901, 2, [[timestamp]], 'quiz', 'autosaveperiod', '60', NULL),
(902, 2, [[timestamp]], 'quizaccess_seb', 'autoreconfigureseb', '1', NULL),
(903, 2, [[timestamp]], 'quizaccess_seb', 'showseblinks', 'seb,http', NULL),
(904, 2, [[timestamp]], 'quizaccess_seb', 'downloadlink', 'https://safeexambrowser.org/download_en.html', NULL),
(905, 2, [[timestamp]], 'quizaccess_seb', 'quizpasswordrequired', '0', NULL),
(906, 2, [[timestamp]], 'quizaccess_seb', 'displayblocksbeforestart', '0', NULL),
(907, 2, [[timestamp]], 'quizaccess_seb', 'displayblockswhenfinished', '1', NULL),
(908, 2, [[timestamp]], 'scorm', 'displaycoursestructure', '0', NULL),
(909, 2, [[timestamp]], 'scorm', 'displaycoursestructure_adv', '', NULL),
(910, 2, [[timestamp]], 'scorm', 'popup', '0', NULL),
(911, 2, [[timestamp]], 'scorm', 'popup_adv', '', NULL),
(912, 2, [[timestamp]], 'scorm', 'displayactivityname', '1', NULL),
(913, 2, [[timestamp]], 'scorm', 'framewidth', '100', NULL),
(914, 2, [[timestamp]], 'scorm', 'framewidth_adv', '1', NULL),
(915, 2, [[timestamp]], 'scorm', 'frameheight', '500', NULL),
(916, 2, [[timestamp]], 'scorm', 'frameheight_adv', '1', NULL),
(917, 2, [[timestamp]], 'scorm', 'winoptgrp_adv', '1', NULL),
(918, 2, [[timestamp]], 'scorm', 'scrollbars', '0', NULL),
(919, 2, [[timestamp]], 'scorm', 'directories', '0', NULL),
(920, 2, [[timestamp]], 'scorm', 'location', '0', NULL),
(921, 2, [[timestamp]], 'scorm', 'menubar', '0', NULL),
(922, 2, [[timestamp]], 'scorm', 'toolbar', '0', NULL),
(923, 2, [[timestamp]], 'scorm', 'status', '0', NULL),
(924, 2, [[timestamp]], 'scorm', 'skipview', '0', NULL),
(925, 2, [[timestamp]], 'scorm', 'skipview_adv', '1', NULL),
(926, 2, [[timestamp]], 'scorm', 'hidebrowse', '0', NULL),
(927, 2, [[timestamp]], 'scorm', 'hidebrowse_adv', '1', NULL),
(928, 2, [[timestamp]], 'scorm', 'hidetoc', '0', NULL),
(929, 2, [[timestamp]], 'scorm', 'hidetoc_adv', '1', NULL),
(930, 2, [[timestamp]], 'scorm', 'nav', '1', NULL),
(931, 2, [[timestamp]], 'scorm', 'nav_adv', '1', NULL),
(932, 2, [[timestamp]], 'scorm', 'navpositionleft', '-100', NULL),
(933, 2, [[timestamp]], 'scorm', 'navpositionleft_adv', '1', NULL),
(934, 2, [[timestamp]], 'scorm', 'navpositiontop', '-100', NULL),
(935, 2, [[timestamp]], 'scorm', 'navpositiontop_adv', '1', NULL),
(936, 2, [[timestamp]], 'scorm', 'collapsetocwinsize', '767', NULL),
(937, 2, [[timestamp]], 'scorm', 'collapsetocwinsize_adv', '1', NULL),
(938, 2, [[timestamp]], 'scorm', 'displayattemptstatus', '1', NULL),
(939, 2, [[timestamp]], 'scorm', 'displayattemptstatus_adv', '', NULL),
(940, 2, [[timestamp]], 'scorm', 'grademethod', '1', NULL),
(941, 2, [[timestamp]], 'scorm', 'maxgrade', '100', NULL),
(942, 2, [[timestamp]], 'scorm', 'maxattempt', '0', NULL),
(943, 2, [[timestamp]], 'scorm', 'whatgrade', '0', NULL),
(944, 2, [[timestamp]], 'scorm', 'forcecompleted', '0', NULL),
(945, 2, [[timestamp]], 'scorm', 'forcenewattempt', '0', NULL),
(946, 2, [[timestamp]], 'scorm', 'autocommit', '0', NULL),
(947, 2, [[timestamp]], 'scorm', 'masteryoverride', '1', NULL),
(948, 2, [[timestamp]], 'scorm', 'lastattemptlock', '0', NULL),
(949, 2, [[timestamp]], 'scorm', 'auto', '0', NULL),
(950, 2, [[timestamp]], 'scorm', 'updatefreq', '0', NULL),
(951, 2, [[timestamp]], 'scorm', 'scormstandard', '0', NULL),
(952, 2, [[timestamp]], 'scorm', 'allowtypeexternal', '0', NULL),
(953, 2, [[timestamp]], 'scorm', 'allowtypelocalsync', '0', NULL),
(954, 2, [[timestamp]], 'scorm', 'allowtypeexternalaicc', '0', NULL),
(955, 2, [[timestamp]], 'scorm', 'allowaicchacp', '0', NULL),
(956, 2, [[timestamp]], 'scorm', 'aicchacptimeout', '30', NULL),
(957, 2, [[timestamp]], 'scorm', 'aicchacpkeepsessiondata', '1', NULL),
(958, 2, [[timestamp]], 'scorm', 'aiccuserid', '1', NULL),
(959, 2, [[timestamp]], 'scorm', 'forcejavascript', '1', NULL),
(960, 2, [[timestamp]], 'scorm', 'allowapidebug', '0', NULL),
(961, 2, [[timestamp]], 'scorm', 'apidebugmask', '.*', NULL),
(962, 2, [[timestamp]], 'scorm', 'protectpackagedownloads', '0', NULL),
(963, 2, [[timestamp]], 'url', 'framesize', '130', NULL),
(964, 2, [[timestamp]], 'url', 'secretphrase', '', NULL),
(965, 2, [[timestamp]], 'url', 'rolesinparams', '0', NULL),
(966, 2, [[timestamp]], 'url', 'displayoptions', '0,1,5,6', NULL),
(967, 2, [[timestamp]], 'url', 'printintro', '1', NULL),
(968, 2, [[timestamp]], 'url', 'display', '0', NULL),
(969, 2, [[timestamp]], 'url', 'popupwidth', '620', NULL),
(970, 2, [[timestamp]], 'url', 'popupheight', '450', NULL),
(971, 2, [[timestamp]], 'workshop', 'grade', '80', NULL),
(972, 2, [[timestamp]], 'workshop', 'gradinggrade', '20', NULL),
(973, 2, [[timestamp]], 'workshop', 'gradedecimals', '0', NULL),
(974, 2, [[timestamp]], 'workshop', 'maxbytes', '0', NULL),
(975, 2, [[timestamp]], 'workshop', 'strategy', 'accumulative', NULL),
(976, 2, [[timestamp]], 'workshop', 'examplesmode', '0', NULL),
(977, 2, [[timestamp]], 'workshopallocation_random', 'numofreviews', '5', NULL),
(978, 2, [[timestamp]], 'workshopform_numerrors', 'grade0', 'No', NULL),
(979, 2, [[timestamp]], 'workshopform_numerrors', 'grade1', 'Yes', NULL),
(980, 2, [[timestamp]], 'workshopeval_best', 'comparison', '5', NULL),
(981, 2, [[timestamp]], 'tool_brickfield', 'analysistype', '0', NULL),
(982, 2, [[timestamp]], 'tool_brickfield', 'deletehistoricaldata', '1', NULL),
(983, 2, [[timestamp]], 'tool_brickfield', 'batch', '1000', NULL),
(984, 2, [[timestamp]], 'tool_brickfield', 'perpage', '50', NULL),
(985, 2, [[timestamp]], 'tool_recyclebin', 'coursebinenable', '1', NULL),
(986, 2, [[timestamp]], 'tool_recyclebin', 'coursebinexpiry', '604800', NULL),
(987, 2, [[timestamp]], 'tool_recyclebin', 'categorybinenable', '1', NULL),
(988, 2, [[timestamp]], 'tool_recyclebin', 'categorybinexpiry', '604800', NULL),
(989, 2, [[timestamp]], 'tool_recyclebin', 'autohide', '1', NULL),
(990, 2, [[timestamp]], 'antivirus_clamav', 'runningmethod', 'commandline', NULL),
(991, 2, [[timestamp]], 'antivirus_clamav', 'pathtoclam', '', NULL),
(992, 2, [[timestamp]], 'antivirus_clamav', 'pathtounixsocket', '', NULL),
(993, 2, [[timestamp]], 'antivirus_clamav', 'tcpsockethost', '', NULL),
(994, 2, [[timestamp]], 'antivirus_clamav', 'tcpsocketport', '3310', NULL),
(995, 2, [[timestamp]], 'antivirus_clamav', 'clamfailureonupload', 'tryagain', NULL),
(996, 2, [[timestamp]], 'antivirus_clamav', 'tries', '1', NULL),
(997, 2, [[timestamp]], 'auth_cas', 'auth_name', 'CAS', NULL),
(998, 2, [[timestamp]], 'auth_cas', 'auth_logo', '', NULL),
(999, 2, [[timestamp]], 'auth_cas', 'hostname', '', NULL),
(1000, 2, [[timestamp]], 'auth_cas', 'baseuri', '', NULL),
(1001, 2, [[timestamp]], 'auth_cas', 'port', '0', NULL),
(1002, 2, [[timestamp]], 'auth_cas', 'casversion', '2.0', NULL),
(1003, 2, [[timestamp]], 'auth_cas', 'language', 'CAS_Languages_English', NULL),
(1004, 2, [[timestamp]], 'auth_cas', 'proxycas', '0', NULL),
(1005, 2, [[timestamp]], 'auth_cas', 'logoutcas', '0', NULL),
(1006, 2, [[timestamp]], 'auth_cas', 'multiauth', '0', NULL),
(1007, 2, [[timestamp]], 'auth_cas', 'certificate_check', '0', NULL),
(1008, 2, [[timestamp]], 'auth_cas', 'certificate_path', '', NULL),
(1009, 2, [[timestamp]], 'auth_cas', 'curl_ssl_version', '', NULL),
(1010, 2, [[timestamp]], 'auth_cas', 'logout_return_url', '', NULL),
(1011, 2, [[timestamp]], 'auth_cas', 'host_url', '', NULL),
(1012, 2, [[timestamp]], 'auth_cas', 'ldap_version', '3', NULL),
(1013, 2, [[timestamp]], 'auth_cas', 'start_tls', '0', NULL),
(1014, 2, [[timestamp]], 'auth_cas', 'ldapencoding', 'utf-8', NULL),
(1015, 2, [[timestamp]], 'auth_cas', 'pagesize', '250', NULL),
(1016, 2, [[timestamp]], 'auth_cas', 'bind_dn', '', NULL),
(1017, 2, [[timestamp]], 'auth_cas', 'bind_pw', '', NULL),
(1018, 2, [[timestamp]], 'auth_cas', 'user_type', 'default', NULL),
(1019, 2, [[timestamp]], 'auth_cas', 'contexts', '', NULL),
(1020, 2, [[timestamp]], 'auth_cas', 'search_sub', '0', NULL),
(1021, 2, [[timestamp]], 'auth_cas', 'opt_deref', '0', NULL),
(1022, 2, [[timestamp]], 'auth_cas', 'user_attribute', '', NULL),
(1023, 2, [[timestamp]], 'auth_cas', 'memberattribute', '', NULL),
(1024, 2, [[timestamp]], 'auth_cas', 'memberattribute_isdn', '0', NULL),
(1025, 2, [[timestamp]], 'auth_cas', 'objectclass', '', NULL),
(1026, 2, [[timestamp]], 'auth_cas', 'attrcreators', '', NULL),
(1027, 2, [[timestamp]], 'auth_cas', 'groupecreators', '', NULL),
(1028, 2, [[timestamp]], 'auth_cas', 'removeuser', '0', NULL),
(1029, 2, [[timestamp]], 'auth_cas', 'field_map_firstname', '', NULL),
(1030, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_firstname', 'oncreate', NULL),
(1031, 2, [[timestamp]], 'auth_cas', 'field_updateremote_firstname', '0', NULL),
(1032, 2, [[timestamp]], 'auth_cas', 'field_lock_firstname', 'unlocked', NULL),
(1033, 2, [[timestamp]], 'auth_cas', 'field_map_lastname', '', NULL),
(1034, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_lastname', 'oncreate', NULL),
(1035, 2, [[timestamp]], 'auth_cas', 'field_updateremote_lastname', '0', NULL),
(1036, 2, [[timestamp]], 'auth_cas', 'field_lock_lastname', 'unlocked', NULL),
(1037, 2, [[timestamp]], 'auth_cas', 'field_map_email', '', NULL),
(1038, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_email', 'oncreate', NULL),
(1039, 2, [[timestamp]], 'auth_cas', 'field_updateremote_email', '0', NULL),
(1040, 2, [[timestamp]], 'auth_cas', 'field_lock_email', 'unlocked', NULL),
(1041, 2, [[timestamp]], 'auth_cas', 'field_map_city', '', NULL),
(1042, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_city', 'oncreate', NULL),
(1043, 2, [[timestamp]], 'auth_cas', 'field_updateremote_city', '0', NULL),
(1044, 2, [[timestamp]], 'auth_cas', 'field_lock_city', 'unlocked', NULL),
(1045, 2, [[timestamp]], 'auth_cas', 'field_map_country', '', NULL),
(1046, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_country', 'oncreate', NULL),
(1047, 2, [[timestamp]], 'auth_cas', 'field_updateremote_country', '0', NULL),
(1048, 2, [[timestamp]], 'auth_cas', 'field_lock_country', 'unlocked', NULL),
(1049, 2, [[timestamp]], 'auth_cas', 'field_map_lang', '', NULL),
(1050, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_lang', 'oncreate', NULL),
(1051, 2, [[timestamp]], 'auth_cas', 'field_updateremote_lang', '0', NULL),
(1052, 2, [[timestamp]], 'auth_cas', 'field_lock_lang', 'unlocked', NULL),
(1053, 2, [[timestamp]], 'auth_cas', 'field_map_description', '', NULL),
(1054, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_description', 'oncreate', NULL),
(1055, 2, [[timestamp]], 'auth_cas', 'field_updateremote_description', '0', NULL),
(1056, 2, [[timestamp]], 'auth_cas', 'field_lock_description', 'unlocked', NULL),
(1057, 2, [[timestamp]], 'auth_cas', 'field_map_idnumber', '', NULL),
(1058, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1059, 2, [[timestamp]], 'auth_cas', 'field_updateremote_idnumber', '0', NULL),
(1060, 2, [[timestamp]], 'auth_cas', 'field_lock_idnumber', 'unlocked', NULL),
(1061, 2, [[timestamp]], 'auth_cas', 'field_map_institution', '', NULL),
(1062, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_institution', 'oncreate', NULL),
(1063, 2, [[timestamp]], 'auth_cas', 'field_updateremote_institution', '0', NULL),
(1064, 2, [[timestamp]], 'auth_cas', 'field_lock_institution', 'unlocked', NULL),
(1065, 2, [[timestamp]], 'auth_cas', 'field_map_department', '', NULL),
(1066, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_department', 'oncreate', NULL),
(1067, 2, [[timestamp]], 'auth_cas', 'field_updateremote_department', '0', NULL),
(1068, 2, [[timestamp]], 'auth_cas', 'field_lock_department', 'unlocked', NULL),
(1069, 2, [[timestamp]], 'auth_cas', 'field_map_phone1', '', NULL),
(1070, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_phone1', 'oncreate', NULL),
(1071, 2, [[timestamp]], 'auth_cas', 'field_updateremote_phone1', '0', NULL),
(1072, 2, [[timestamp]], 'auth_cas', 'field_lock_phone1', 'unlocked', NULL),
(1073, 2, [[timestamp]], 'auth_cas', 'field_map_phone2', '', NULL),
(1074, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_phone2', 'oncreate', NULL),
(1075, 2, [[timestamp]], 'auth_cas', 'field_updateremote_phone2', '0', NULL),
(1076, 2, [[timestamp]], 'auth_cas', 'field_lock_phone2', 'unlocked', NULL),
(1077, 2, [[timestamp]], 'auth_cas', 'field_map_address', '', NULL),
(1078, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_address', 'oncreate', NULL),
(1079, 2, [[timestamp]], 'auth_cas', 'field_updateremote_address', '0', NULL),
(1080, 2, [[timestamp]], 'auth_cas', 'field_lock_address', 'unlocked', NULL),
(1081, 2, [[timestamp]], 'auth_cas', 'field_map_firstnamephonetic', '', NULL),
(1082, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1083, 2, [[timestamp]], 'auth_cas', 'field_updateremote_firstnamephonetic', '0', NULL),
(1084, 2, [[timestamp]], 'auth_cas', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1085, 2, [[timestamp]], 'auth_cas', 'field_map_lastnamephonetic', '', NULL),
(1086, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1087, 2, [[timestamp]], 'auth_cas', 'field_updateremote_lastnamephonetic', '0', NULL),
(1088, 2, [[timestamp]], 'auth_cas', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1089, 2, [[timestamp]], 'auth_cas', 'field_map_middlename', '', NULL),
(1090, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_middlename', 'oncreate', NULL),
(1091, 2, [[timestamp]], 'auth_cas', 'field_updateremote_middlename', '0', NULL),
(1092, 2, [[timestamp]], 'auth_cas', 'field_lock_middlename', 'unlocked', NULL),
(1093, 2, [[timestamp]], 'auth_cas', 'field_map_alternatename', '', NULL),
(1094, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1095, 2, [[timestamp]], 'auth_cas', 'field_updateremote_alternatename', '0', NULL),
(1096, 2, [[timestamp]], 'auth_cas', 'field_lock_alternatename', 'unlocked', NULL),
(1097, 2, [[timestamp]], 'auth_email', 'recaptcha', '0', NULL),
(1098, 2, [[timestamp]], 'auth_email', 'field_lock_firstname', 'unlocked', NULL),
(1099, 2, [[timestamp]], 'auth_email', 'field_lock_lastname', 'unlocked', NULL),
(1100, 2, [[timestamp]], 'auth_email', 'field_lock_email', 'unlocked', NULL),
(1101, 2, [[timestamp]], 'auth_email', 'field_lock_city', 'unlocked', NULL),
(1102, 2, [[timestamp]], 'auth_email', 'field_lock_country', 'unlocked', NULL),
(1103, 2, [[timestamp]], 'auth_email', 'field_lock_lang', 'unlocked', NULL),
(1104, 2, [[timestamp]], 'auth_email', 'field_lock_description', 'unlocked', NULL),
(1105, 2, [[timestamp]], 'auth_email', 'field_lock_idnumber', 'unlocked', NULL),
(1106, 2, [[timestamp]], 'auth_email', 'field_lock_institution', 'unlocked', NULL),
(1107, 2, [[timestamp]], 'auth_email', 'field_lock_department', 'unlocked', NULL),
(1108, 2, [[timestamp]], 'auth_email', 'field_lock_phone1', 'unlocked', NULL),
(1109, 2, [[timestamp]], 'auth_email', 'field_lock_phone2', 'unlocked', NULL),
(1110, 2, [[timestamp]], 'auth_email', 'field_lock_address', 'unlocked', NULL),
(1111, 2, [[timestamp]], 'auth_email', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1112, 2, [[timestamp]], 'auth_email', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1113, 2, [[timestamp]], 'auth_email', 'field_lock_middlename', 'unlocked', NULL),
(1114, 2, [[timestamp]], 'auth_email', 'field_lock_alternatename', 'unlocked', NULL),
(1115, 2, [[timestamp]], 'auth_db', 'host', '127.0.0.1', NULL),
(1116, 2, [[timestamp]], 'auth_db', 'type', 'mysqli', NULL),
(1117, 2, [[timestamp]], 'auth_db', 'sybasequoting', '0', NULL),
(1118, 2, [[timestamp]], 'auth_db', 'name', '', NULL),
(1119, 2, [[timestamp]], 'auth_db', 'user', '', NULL),
(1120, 2, [[timestamp]], 'auth_db', 'pass', '', NULL),
(1121, 2, [[timestamp]], 'auth_db', 'table', '', NULL),
(1122, 2, [[timestamp]], 'auth_db', 'fielduser', '', NULL),
(1123, 2, [[timestamp]], 'auth_db', 'fieldpass', '', NULL),
(1124, 2, [[timestamp]], 'auth_db', 'passtype', 'plaintext', NULL),
(1125, 2, [[timestamp]], 'auth_db', 'extencoding', 'utf-8', NULL),
(1126, 2, [[timestamp]], 'auth_db', 'setupsql', '', NULL),
(1127, 2, [[timestamp]], 'auth_db', 'debugauthdb', '0', NULL),
(1128, 2, [[timestamp]], 'auth_db', 'changepasswordurl', '', NULL),
(1129, 2, [[timestamp]], 'auth_db', 'removeuser', '0', NULL),
(1130, 2, [[timestamp]], 'auth_db', 'updateusers', '0', NULL),
(1131, 2, [[timestamp]], 'auth_db', 'field_map_firstname', '', NULL),
(1132, 2, [[timestamp]], 'auth_db', 'field_updatelocal_firstname', 'oncreate', NULL),
(1133, 2, [[timestamp]], 'auth_db', 'field_updateremote_firstname', '0', NULL),
(1134, 2, [[timestamp]], 'auth_db', 'field_lock_firstname', 'unlocked', NULL),
(1135, 2, [[timestamp]], 'auth_db', 'field_map_lastname', '', NULL),
(1136, 2, [[timestamp]], 'auth_db', 'field_updatelocal_lastname', 'oncreate', NULL),
(1137, 2, [[timestamp]], 'auth_db', 'field_updateremote_lastname', '0', NULL),
(1138, 2, [[timestamp]], 'auth_db', 'field_lock_lastname', 'unlocked', NULL),
(1139, 2, [[timestamp]], 'auth_db', 'field_map_email', '', NULL),
(1140, 2, [[timestamp]], 'auth_db', 'field_updatelocal_email', 'oncreate', NULL),
(1141, 2, [[timestamp]], 'auth_db', 'field_updateremote_email', '0', NULL),
(1142, 2, [[timestamp]], 'auth_db', 'field_lock_email', 'unlocked', NULL),
(1143, 2, [[timestamp]], 'auth_db', 'field_map_city', '', NULL),
(1144, 2, [[timestamp]], 'auth_db', 'field_updatelocal_city', 'oncreate', NULL),
(1145, 2, [[timestamp]], 'auth_db', 'field_updateremote_city', '0', NULL),
(1146, 2, [[timestamp]], 'auth_db', 'field_lock_city', 'unlocked', NULL),
(1147, 2, [[timestamp]], 'auth_db', 'field_map_country', '', NULL),
(1148, 2, [[timestamp]], 'auth_db', 'field_updatelocal_country', 'oncreate', NULL),
(1149, 2, [[timestamp]], 'auth_db', 'field_updateremote_country', '0', NULL),
(1150, 2, [[timestamp]], 'auth_db', 'field_lock_country', 'unlocked', NULL),
(1151, 2, [[timestamp]], 'auth_db', 'field_map_lang', '', NULL),
(1152, 2, [[timestamp]], 'auth_db', 'field_updatelocal_lang', 'oncreate', NULL),
(1153, 2, [[timestamp]], 'auth_db', 'field_updateremote_lang', '0', NULL),
(1154, 2, [[timestamp]], 'auth_db', 'field_lock_lang', 'unlocked', NULL),
(1155, 2, [[timestamp]], 'auth_db', 'field_map_description', '', NULL),
(1156, 2, [[timestamp]], 'auth_db', 'field_updatelocal_description', 'oncreate', NULL),
(1157, 2, [[timestamp]], 'auth_db', 'field_updateremote_description', '0', NULL),
(1158, 2, [[timestamp]], 'auth_db', 'field_lock_description', 'unlocked', NULL),
(1159, 2, [[timestamp]], 'auth_db', 'field_map_idnumber', '', NULL),
(1160, 2, [[timestamp]], 'auth_db', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1161, 2, [[timestamp]], 'auth_db', 'field_updateremote_idnumber', '0', NULL),
(1162, 2, [[timestamp]], 'auth_db', 'field_lock_idnumber', 'unlocked', NULL),
(1163, 2, [[timestamp]], 'auth_db', 'field_map_institution', '', NULL),
(1164, 2, [[timestamp]], 'auth_db', 'field_updatelocal_institution', 'oncreate', NULL),
(1165, 2, [[timestamp]], 'auth_db', 'field_updateremote_institution', '0', NULL),
(1166, 2, [[timestamp]], 'auth_db', 'field_lock_institution', 'unlocked', NULL),
(1167, 2, [[timestamp]], 'auth_db', 'field_map_department', '', NULL),
(1168, 2, [[timestamp]], 'auth_db', 'field_updatelocal_department', 'oncreate', NULL),
(1169, 2, [[timestamp]], 'auth_db', 'field_updateremote_department', '0', NULL),
(1170, 2, [[timestamp]], 'auth_db', 'field_lock_department', 'unlocked', NULL),
(1171, 2, [[timestamp]], 'auth_db', 'field_map_phone1', '', NULL),
(1172, 2, [[timestamp]], 'auth_db', 'field_updatelocal_phone1', 'oncreate', NULL),
(1173, 2, [[timestamp]], 'auth_db', 'field_updateremote_phone1', '0', NULL),
(1174, 2, [[timestamp]], 'auth_db', 'field_lock_phone1', 'unlocked', NULL),
(1175, 2, [[timestamp]], 'auth_db', 'field_map_phone2', '', NULL),
(1176, 2, [[timestamp]], 'auth_db', 'field_updatelocal_phone2', 'oncreate', NULL),
(1177, 2, [[timestamp]], 'auth_db', 'field_updateremote_phone2', '0', NULL),
(1178, 2, [[timestamp]], 'auth_db', 'field_lock_phone2', 'unlocked', NULL),
(1179, 2, [[timestamp]], 'auth_db', 'field_map_address', '', NULL),
(1180, 2, [[timestamp]], 'auth_db', 'field_updatelocal_address', 'oncreate', NULL),
(1181, 2, [[timestamp]], 'auth_db', 'field_updateremote_address', '0', NULL),
(1182, 2, [[timestamp]], 'auth_db', 'field_lock_address', 'unlocked', NULL),
(1183, 2, [[timestamp]], 'auth_db', 'field_map_firstnamephonetic', '', NULL),
(1184, 2, [[timestamp]], 'auth_db', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1185, 2, [[timestamp]], 'auth_db', 'field_updateremote_firstnamephonetic', '0', NULL),
(1186, 2, [[timestamp]], 'auth_db', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1187, 2, [[timestamp]], 'auth_db', 'field_map_lastnamephonetic', '', NULL),
(1188, 2, [[timestamp]], 'auth_db', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1189, 2, [[timestamp]], 'auth_db', 'field_updateremote_lastnamephonetic', '0', NULL),
(1190, 2, [[timestamp]], 'auth_db', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1191, 2, [[timestamp]], 'auth_db', 'field_map_middlename', '', NULL),
(1192, 2, [[timestamp]], 'auth_db', 'field_updatelocal_middlename', 'oncreate', NULL),
(1193, 2, [[timestamp]], 'auth_db', 'field_updateremote_middlename', '0', NULL),
(1194, 2, [[timestamp]], 'auth_db', 'field_lock_middlename', 'unlocked', NULL),
(1195, 2, [[timestamp]], 'auth_db', 'field_map_alternatename', '', NULL),
(1196, 2, [[timestamp]], 'auth_db', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1197, 2, [[timestamp]], 'auth_db', 'field_updateremote_alternatename', '0', NULL),
(1198, 2, [[timestamp]], 'auth_db', 'field_lock_alternatename', 'unlocked', NULL),
(1199, 2, [[timestamp]], 'auth_ldap', 'host_url', '', NULL),
(1200, 2, [[timestamp]], 'auth_ldap', 'ldap_version', '3', NULL),
(1201, 2, [[timestamp]], 'auth_ldap', 'start_tls', '0', NULL),
(1202, 2, [[timestamp]], 'auth_ldap', 'ldapencoding', 'utf-8', NULL),
(1203, 2, [[timestamp]], 'auth_ldap', 'pagesize', '250', NULL),
(1204, 2, [[timestamp]], 'auth_ldap', 'preventpassindb', '0', NULL),
(1205, 2, [[timestamp]], 'auth_ldap', 'bind_dn', '', NULL),
(1206, 2, [[timestamp]], 'auth_ldap', 'bind_pw', '', NULL),
(1207, 2, [[timestamp]], 'auth_ldap', 'user_type', 'default', NULL),
(1208, 2, [[timestamp]], 'auth_ldap', 'contexts', '', NULL),
(1209, 2, [[timestamp]], 'auth_ldap', 'search_sub', '0', NULL),
(1210, 2, [[timestamp]], 'auth_ldap', 'opt_deref', '0', NULL),
(1211, 2, [[timestamp]], 'auth_ldap', 'user_attribute', '', NULL),
(1212, 2, [[timestamp]], 'auth_ldap', 'suspended_attribute', '', NULL),
(1213, 2, [[timestamp]], 'auth_ldap', 'memberattribute', '', NULL),
(1214, 2, [[timestamp]], 'auth_ldap', 'memberattribute_isdn', '0', NULL),
(1215, 2, [[timestamp]], 'auth_ldap', 'objectclass', '', NULL),
(1216, 2, [[timestamp]], 'auth_ldap', 'forcechangepassword', '0', NULL),
(1217, 2, [[timestamp]], 'auth_ldap', 'stdchangepassword', '0', NULL),
(1218, 2, [[timestamp]], 'auth_ldap', 'passtype', 'plaintext', NULL),
(1219, 2, [[timestamp]], 'auth_ldap', 'changepasswordurl', '', NULL),
(1220, 2, [[timestamp]], 'auth_ldap', 'expiration', '0', NULL),
(1221, 2, [[timestamp]], 'auth_ldap', 'expiration_warning', '', NULL),
(1222, 2, [[timestamp]], 'auth_ldap', 'expireattr', '', NULL),
(1223, 2, [[timestamp]], 'auth_ldap', 'gracelogins', '0', NULL),
(1224, 2, [[timestamp]], 'auth_ldap', 'graceattr', '', NULL),
(1225, 2, [[timestamp]], 'auth_ldap', 'auth_user_create', '0', NULL),
(1226, 2, [[timestamp]], 'auth_ldap', 'create_context', '', NULL),
(1227, 2, [[timestamp]], 'auth_ldap', 'managercontext', '', NULL),
(1228, 2, [[timestamp]], 'auth_ldap', 'coursecreatorcontext', '', NULL),
(1229, 2, [[timestamp]], 'auth_ldap', 'removeuser', '0', NULL),
(1230, 2, [[timestamp]], 'auth_ldap', 'sync_suspended', '0', NULL),
(1231, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_enabled', '0', NULL),
(1232, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_subnet', '', NULL),
(1233, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_ie_fastpath', '0', NULL),
(1234, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_type', 'ntlm', NULL),
(1235, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_remoteuserformat', '', NULL),
(1236, 2, [[timestamp]], 'auth_ldap', 'field_map_firstname', '', NULL),
(1237, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_firstname', 'oncreate', NULL),
(1238, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_firstname', '0', NULL),
(1239, 2, [[timestamp]], 'auth_ldap', 'field_lock_firstname', 'unlocked', NULL),
(1240, 2, [[timestamp]], 'auth_ldap', 'field_map_lastname', '', NULL),
(1241, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_lastname', 'oncreate', NULL),
(1242, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_lastname', '0', NULL),
(1243, 2, [[timestamp]], 'auth_ldap', 'field_lock_lastname', 'unlocked', NULL),
(1244, 2, [[timestamp]], 'auth_ldap', 'field_map_email', '', NULL),
(1245, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_email', 'oncreate', NULL),
(1246, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_email', '0', NULL),
(1247, 2, [[timestamp]], 'auth_ldap', 'field_lock_email', 'unlocked', NULL),
(1248, 2, [[timestamp]], 'auth_ldap', 'field_map_city', '', NULL),
(1249, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_city', 'oncreate', NULL),
(1250, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_city', '0', NULL),
(1251, 2, [[timestamp]], 'auth_ldap', 'field_lock_city', 'unlocked', NULL),
(1252, 2, [[timestamp]], 'auth_ldap', 'field_map_country', '', NULL),
(1253, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_country', 'oncreate', NULL),
(1254, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_country', '0', NULL),
(1255, 2, [[timestamp]], 'auth_ldap', 'field_lock_country', 'unlocked', NULL),
(1256, 2, [[timestamp]], 'auth_ldap', 'field_map_lang', '', NULL),
(1257, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_lang', 'oncreate', NULL),
(1258, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_lang', '0', NULL),
(1259, 2, [[timestamp]], 'auth_ldap', 'field_lock_lang', 'unlocked', NULL),
(1260, 2, [[timestamp]], 'auth_ldap', 'field_map_description', '', NULL),
(1261, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_description', 'oncreate', NULL),
(1262, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_description', '0', NULL),
(1263, 2, [[timestamp]], 'auth_ldap', 'field_lock_description', 'unlocked', NULL),
(1264, 2, [[timestamp]], 'auth_ldap', 'field_map_idnumber', '', NULL),
(1265, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1266, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_idnumber', '0', NULL),
(1267, 2, [[timestamp]], 'auth_ldap', 'field_lock_idnumber', 'unlocked', NULL),
(1268, 2, [[timestamp]], 'auth_ldap', 'field_map_institution', '', NULL),
(1269, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_institution', 'oncreate', NULL),
(1270, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_institution', '0', NULL),
(1271, 2, [[timestamp]], 'auth_ldap', 'field_lock_institution', 'unlocked', NULL),
(1272, 2, [[timestamp]], 'auth_ldap', 'field_map_department', '', NULL),
(1273, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_department', 'oncreate', NULL),
(1274, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_department', '0', NULL),
(1275, 2, [[timestamp]], 'auth_ldap', 'field_lock_department', 'unlocked', NULL),
(1276, 2, [[timestamp]], 'auth_ldap', 'field_map_phone1', '', NULL),
(1277, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_phone1', 'oncreate', NULL),
(1278, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_phone1', '0', NULL),
(1279, 2, [[timestamp]], 'auth_ldap', 'field_lock_phone1', 'unlocked', NULL),
(1280, 2, [[timestamp]], 'auth_ldap', 'field_map_phone2', '', NULL),
(1281, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_phone2', 'oncreate', NULL),
(1282, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_phone2', '0', NULL),
(1283, 2, [[timestamp]], 'auth_ldap', 'field_lock_phone2', 'unlocked', NULL),
(1284, 2, [[timestamp]], 'auth_ldap', 'field_map_address', '', NULL),
(1285, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_address', 'oncreate', NULL),
(1286, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_address', '0', NULL),
(1287, 2, [[timestamp]], 'auth_ldap', 'field_lock_address', 'unlocked', NULL),
(1288, 2, [[timestamp]], 'auth_ldap', 'field_map_firstnamephonetic', '', NULL),
(1289, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1290, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_firstnamephonetic', '0', NULL),
(1291, 2, [[timestamp]], 'auth_ldap', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1292, 2, [[timestamp]], 'auth_ldap', 'field_map_lastnamephonetic', '', NULL),
(1293, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1294, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_lastnamephonetic', '0', NULL),
(1295, 2, [[timestamp]], 'auth_ldap', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1296, 2, [[timestamp]], 'auth_ldap', 'field_map_middlename', '', NULL),
(1297, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_middlename', 'oncreate', NULL),
(1298, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_middlename', '0', NULL),
(1299, 2, [[timestamp]], 'auth_ldap', 'field_lock_middlename', 'unlocked', NULL),
(1300, 2, [[timestamp]], 'auth_ldap', 'field_map_alternatename', '', NULL),
(1301, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1302, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_alternatename', '0', NULL),
(1303, 2, [[timestamp]], 'auth_ldap', 'field_lock_alternatename', 'unlocked', NULL),
(1304, 2, [[timestamp]], 'auth_manual', 'expiration', '0', NULL),
(1305, 2, [[timestamp]], 'auth_manual', 'expirationtime', '30', NULL),
(1306, 2, [[timestamp]], 'auth_manual', 'expiration_warning', '0', NULL),
(1307, 2, [[timestamp]], 'auth_manual', 'field_lock_firstname', 'unlocked', NULL),
(1308, 2, [[timestamp]], 'auth_manual', 'field_lock_lastname', 'unlocked', NULL),
(1309, 2, [[timestamp]], 'auth_manual', 'field_lock_email', 'unlocked', NULL),
(1310, 2, [[timestamp]], 'auth_manual', 'field_lock_city', 'unlocked', NULL),
(1311, 2, [[timestamp]], 'auth_manual', 'field_lock_country', 'unlocked', NULL),
(1312, 2, [[timestamp]], 'auth_manual', 'field_lock_lang', 'unlocked', NULL),
(1313, 2, [[timestamp]], 'auth_manual', 'field_lock_description', 'unlocked', NULL),
(1314, 2, [[timestamp]], 'auth_manual', 'field_lock_idnumber', 'unlocked', NULL),
(1315, 2, [[timestamp]], 'auth_manual', 'field_lock_institution', 'unlocked', NULL),
(1316, 2, [[timestamp]], 'auth_manual', 'field_lock_department', 'unlocked', NULL),
(1317, 2, [[timestamp]], 'auth_manual', 'field_lock_phone1', 'unlocked', NULL),
(1318, 2, [[timestamp]], 'auth_manual', 'field_lock_phone2', 'unlocked', NULL),
(1319, 2, [[timestamp]], 'auth_manual', 'field_lock_address', 'unlocked', NULL),
(1320, 2, [[timestamp]], 'auth_manual', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1321, 2, [[timestamp]], 'auth_manual', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1322, 2, [[timestamp]], 'auth_manual', 'field_lock_middlename', 'unlocked', NULL),
(1323, 2, [[timestamp]], 'auth_manual', 'field_lock_alternatename', 'unlocked', NULL),
(1324, 2, [[timestamp]], 'auth_mnet', 'rpc_negotiation_timeout', '30', NULL),
(1325, 2, [[timestamp]], 'auth_none', 'field_lock_firstname', 'unlocked', NULL),
(1326, 2, [[timestamp]], 'auth_none', 'field_lock_lastname', 'unlocked', NULL),
(1327, 2, [[timestamp]], 'auth_none', 'field_lock_email', 'unlocked', NULL),
(1328, 2, [[timestamp]], 'auth_none', 'field_lock_city', 'unlocked', NULL),
(1329, 2, [[timestamp]], 'auth_none', 'field_lock_country', 'unlocked', NULL),
(1330, 2, [[timestamp]], 'auth_none', 'field_lock_lang', 'unlocked', NULL),
(1331, 2, [[timestamp]], 'auth_none', 'field_lock_description', 'unlocked', NULL),
(1332, 2, [[timestamp]], 'auth_none', 'field_lock_idnumber', 'unlocked', NULL),
(1333, 2, [[timestamp]], 'auth_none', 'field_lock_institution', 'unlocked', NULL),
(1334, 2, [[timestamp]], 'auth_none', 'field_lock_department', 'unlocked', NULL),
(1335, 2, [[timestamp]], 'auth_none', 'field_lock_phone1', 'unlocked', NULL),
(1336, 2, [[timestamp]], 'auth_none', 'field_lock_phone2', 'unlocked', NULL),
(1337, 2, [[timestamp]], 'auth_none', 'field_lock_address', 'unlocked', NULL),
(1338, 2, [[timestamp]], 'auth_none', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1339, 2, [[timestamp]], 'auth_none', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1340, 2, [[timestamp]], 'auth_none', 'field_lock_middlename', 'unlocked', NULL),
(1341, 2, [[timestamp]], 'auth_none', 'field_lock_alternatename', 'unlocked', NULL),
(1342, 2, [[timestamp]], 'auth_oauth2', 'field_lock_firstname', 'unlocked', NULL),
(1343, 2, [[timestamp]], 'auth_oauth2', 'field_lock_lastname', 'unlocked', NULL),
(1344, 2, [[timestamp]], 'auth_oauth2', 'field_lock_email', 'unlocked', NULL),
(1345, 2, [[timestamp]], 'auth_oauth2', 'field_lock_city', 'unlocked', NULL),
(1346, 2, [[timestamp]], 'auth_oauth2', 'field_lock_country', 'unlocked', NULL),
(1347, 2, [[timestamp]], 'auth_oauth2', 'field_lock_lang', 'unlocked', NULL),
(1348, 2, [[timestamp]], 'auth_oauth2', 'field_lock_description', 'unlocked', NULL),
(1349, 2, [[timestamp]], 'auth_oauth2', 'field_lock_idnumber', 'unlocked', NULL),
(1350, 2, [[timestamp]], 'auth_oauth2', 'field_lock_institution', 'unlocked', NULL),
(1351, 2, [[timestamp]], 'auth_oauth2', 'field_lock_department', 'unlocked', NULL),
(1352, 2, [[timestamp]], 'auth_oauth2', 'field_lock_phone1', 'unlocked', NULL),
(1353, 2, [[timestamp]], 'auth_oauth2', 'field_lock_phone2', 'unlocked', NULL),
(1354, 2, [[timestamp]], 'auth_oauth2', 'field_lock_address', 'unlocked', NULL),
(1355, 2, [[timestamp]], 'auth_oauth2', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1356, 2, [[timestamp]], 'auth_oauth2', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1357, 2, [[timestamp]], 'auth_oauth2', 'field_lock_middlename', 'unlocked', NULL),
(1358, 2, [[timestamp]], 'auth_oauth2', 'field_lock_alternatename', 'unlocked', NULL),
(1359, 2, [[timestamp]], 'auth_shibboleth', 'user_attribute', '', NULL),
(1360, 2, [[timestamp]], 'auth_shibboleth', 'convert_data', '', NULL),
(1361, 2, [[timestamp]], 'auth_shibboleth', 'alt_login', 'off', NULL),
(1362, 2, [[timestamp]], 'auth_shibboleth', 'organization_selection', 'urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai', NULL),
(1363, 2, [[timestamp]], 'auth_shibboleth', 'logout_handler', '', NULL),
(1364, 2, [[timestamp]], 'auth_shibboleth', 'logout_return_url', '', NULL),
(1365, 2, [[timestamp]], 'auth_shibboleth', 'login_name', 'Shibboleth Login', NULL),
(1366, 2, [[timestamp]], 'auth_shibboleth', 'auth_logo', '', NULL),
(1367, 2, [[timestamp]], 'auth_shibboleth', 'auth_instructions', 'Use the <a href="[[softurl]]/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.', NULL),
(1368, 2, [[timestamp]], 'auth_shibboleth', 'changepasswordurl', '', NULL),
(1369, 2, [[timestamp]], 'auth_shibboleth', 'field_map_firstname', '', NULL),
(1370, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_firstname', 'oncreate', NULL),
(1371, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_firstname', 'unlocked', NULL),
(1372, 2, [[timestamp]], 'auth_shibboleth', 'field_map_lastname', '', NULL),
(1373, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_lastname', 'oncreate', NULL),
(1374, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_lastname', 'unlocked', NULL),
(1375, 2, [[timestamp]], 'auth_shibboleth', 'field_map_email', '', NULL),
(1376, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_email', 'oncreate', NULL),
(1377, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_email', 'unlocked', NULL),
(1378, 2, [[timestamp]], 'auth_shibboleth', 'field_map_city', '', NULL),
(1379, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_city', 'oncreate', NULL),
(1380, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_city', 'unlocked', NULL),
(1381, 2, [[timestamp]], 'auth_shibboleth', 'field_map_country', '', NULL),
(1382, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_country', 'oncreate', NULL),
(1383, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_country', 'unlocked', NULL),
(1384, 2, [[timestamp]], 'auth_shibboleth', 'field_map_lang', '', NULL),
(1385, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_lang', 'oncreate', NULL),
(1386, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_lang', 'unlocked', NULL),
(1387, 2, [[timestamp]], 'auth_shibboleth', 'field_map_description', '', NULL),
(1388, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_description', 'oncreate', NULL),
(1389, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_description', 'unlocked', NULL),
(1390, 2, [[timestamp]], 'auth_shibboleth', 'field_map_idnumber', '', NULL),
(1391, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1392, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_idnumber', 'unlocked', NULL),
(1393, 2, [[timestamp]], 'auth_shibboleth', 'field_map_institution', '', NULL),
(1394, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_institution', 'oncreate', NULL),
(1395, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_institution', 'unlocked', NULL),
(1396, 2, [[timestamp]], 'auth_shibboleth', 'field_map_department', '', NULL),
(1397, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_department', 'oncreate', NULL),
(1398, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_department', 'unlocked', NULL),
(1399, 2, [[timestamp]], 'auth_shibboleth', 'field_map_phone1', '', NULL),
(1400, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_phone1', 'oncreate', NULL),
(1401, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_phone1', 'unlocked', NULL),
(1402, 2, [[timestamp]], 'auth_shibboleth', 'field_map_phone2', '', NULL),
(1403, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_phone2', 'oncreate', NULL),
(1404, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_phone2', 'unlocked', NULL),
(1405, 2, [[timestamp]], 'auth_shibboleth', 'field_map_address', '', NULL),
(1406, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_address', 'oncreate', NULL),
(1407, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_address', 'unlocked', NULL),
(1408, 2, [[timestamp]], 'auth_shibboleth', 'field_map_firstnamephonetic', '', NULL),
(1409, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1410, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1411, 2, [[timestamp]], 'auth_shibboleth', 'field_map_lastnamephonetic', '', NULL),
(1412, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1413, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1414, 2, [[timestamp]], 'auth_shibboleth', 'field_map_middlename', '', NULL),
(1415, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_middlename', 'oncreate', NULL),
(1416, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_middlename', 'unlocked', NULL),
(1417, 2, [[timestamp]], 'auth_shibboleth', 'field_map_alternatename', '', NULL),
(1418, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1419, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_alternatename', 'unlocked', NULL),
(1420, 2, [[timestamp]], 'block_accessreview', 'whattoshow', 'showboth', NULL),
(1421, 2, [[timestamp]], 'block_accessreview', 'errordisplay', 'showint', NULL),
(1422, 2, [[timestamp]], 'block_accessreview', 'toolpage', 'errors', NULL),
(1423, 2, [[timestamp]], 'block_activity_results', 'config_showbest', '3', NULL),
(1424, 2, [[timestamp]], 'block_activity_results', 'config_showbest_locked', '', NULL),
(1425, 2, [[timestamp]], 'block_activity_results', 'config_showworst', '0', NULL);
INSERT INTO `[[dbprefix]]config_log` VALUES
(1426, 2, [[timestamp]], 'block_activity_results', 'config_showworst_locked', '', NULL),
(1427, 2, [[timestamp]], 'block_activity_results', 'config_usegroups', '0', NULL),
(1428, 2, [[timestamp]], 'block_activity_results', 'config_usegroups_locked', '', NULL),
(1429, 2, [[timestamp]], 'block_activity_results', 'config_nameformat', '1', NULL),
(1430, 2, [[timestamp]], 'block_activity_results', 'config_nameformat_locked', '', NULL),
(1431, 2, [[timestamp]], 'block_activity_results', 'config_gradeformat', '1', NULL),
(1432, 2, [[timestamp]], 'block_activity_results', 'config_gradeformat_locked', '', NULL),
(1433, 2, [[timestamp]], 'block_activity_results', 'config_decimalpoints', '2', NULL),
(1434, 2, [[timestamp]], 'block_activity_results', 'config_decimalpoints_locked', '', NULL),
(1435, 2, [[timestamp]], 'block_myoverview', 'displaycategories', '1', NULL),
(1436, 2, [[timestamp]], 'block_myoverview', 'layouts', 'card,list,summary', NULL),
(1437, 2, [[timestamp]], 'block_myoverview', 'displaygroupingallincludinghidden', '0', NULL),
(1438, 2, [[timestamp]], 'block_myoverview', 'displaygroupingall', '1', NULL),
(1439, 2, [[timestamp]], 'block_myoverview', 'displaygroupinginprogress', '1', NULL),
(1440, 2, [[timestamp]], 'block_myoverview', 'displaygroupingpast', '1', NULL),
(1441, 2, [[timestamp]], 'block_myoverview', 'displaygroupingfuture', '1', NULL),
(1442, 2, [[timestamp]], 'block_myoverview', 'displaygroupingcustomfield', '0', NULL),
(1443, 2, [[timestamp]], 'block_myoverview', 'customfiltergrouping', '', NULL),
(1444, 2, [[timestamp]], 'block_myoverview', 'displaygroupingfavourites', '1', NULL),
(1445, 2, [[timestamp]], 'block_myoverview', 'displaygroupinghidden', '1', NULL),
(1446, 2, [[timestamp]], NULL, 'block_course_list_adminview', 'all', NULL),
(1447, 2, [[timestamp]], NULL, 'block_course_list_hideallcourseslink', '0', NULL),
(1448, 2, [[timestamp]], NULL, 'block_html_allowcssclasses', '0', NULL),
(1449, 2, [[timestamp]], NULL, 'block_online_users_timetosee', '5', NULL),
(1450, 2, [[timestamp]], NULL, 'block_online_users_onlinestatushiding', '1', NULL),
(1451, 2, [[timestamp]], 'block_recentlyaccessedcourses', 'displaycategories', '1', NULL),
(1452, 2, [[timestamp]], NULL, 'block_rss_client_num_entries', '5', NULL),
(1453, 2, [[timestamp]], NULL, 'block_rss_client_timeout', '30', NULL),
(1454, 2, [[timestamp]], 'block_section_links', 'numsections1', '22', NULL),
(1455, 2, [[timestamp]], 'block_section_links', 'incby1', '2', NULL),
(1456, 2, [[timestamp]], 'block_section_links', 'numsections2', '40', NULL),
(1457, 2, [[timestamp]], 'block_section_links', 'incby2', '5', NULL),
(1458, 2, [[timestamp]], 'block_section_links', 'showsectionname', '0', NULL),
(1459, 2, [[timestamp]], 'block_starredcourses', 'displaycategories', '1', NULL),
(1460, 2, [[timestamp]], 'block_tag_youtube', 'apikey', '', NULL),
(1461, 2, [[timestamp]], 'format_singleactivity', 'activitytype', 'forum', NULL),
(1462, 2, [[timestamp]], 'fileconverter_googledrive', 'issuerid', '', NULL),
(1463, 2, [[timestamp]], NULL, 'pathtounoconv', '/usr/bin/unoconv', NULL),
(1464, 2, [[timestamp]], 'enrol_cohort', 'roleid', '5', NULL),
(1465, 2, [[timestamp]], 'enrol_cohort', 'unenrolaction', '0', NULL),
(1466, 2, [[timestamp]], 'enrol_meta', 'nosyncroleids', '', NULL),
(1467, 2, [[timestamp]], 'enrol_meta', 'syncall', '1', NULL),
(1468, 2, [[timestamp]], 'enrol_meta', 'unenrolaction', '3', NULL),
(1469, 2, [[timestamp]], 'enrol_meta', 'coursesort', 'sortorder', NULL),
(1470, 2, [[timestamp]], 'enrol_fee', 'expiredaction', '3', NULL),
(1471, 2, [[timestamp]], 'enrol_fee', 'status', '1', NULL),
(1472, 2, [[timestamp]], 'enrol_fee', 'cost', '0', NULL),
(1473, 2, [[timestamp]], 'enrol_fee', 'currency', 'USD', NULL),
(1474, 2, [[timestamp]], 'enrol_fee', 'roleid', '5', NULL),
(1475, 2, [[timestamp]], 'enrol_fee', 'enrolperiod', '0', NULL),
(1476, 2, [[timestamp]], 'enrol_database', 'dbtype', '', NULL),
(1477, 2, [[timestamp]], 'enrol_database', 'dbhost', 'localhost', NULL),
(1478, 2, [[timestamp]], 'enrol_database', 'dbuser', '', NULL),
(1479, 2, [[timestamp]], 'enrol_database', 'dbpass', '', NULL),
(1480, 2, [[timestamp]], 'enrol_database', 'dbname', '', NULL),
(1481, 2, [[timestamp]], 'enrol_database', 'dbencoding', 'utf-8', NULL),
(1482, 2, [[timestamp]], 'enrol_database', 'dbsetupsql', '', NULL),
(1483, 2, [[timestamp]], 'enrol_database', 'dbsybasequoting', '0', NULL),
(1484, 2, [[timestamp]], 'enrol_database', 'debugdb', '0', NULL),
(1485, 2, [[timestamp]], 'enrol_database', 'localcoursefield', 'idnumber', NULL),
(1486, 2, [[timestamp]], 'enrol_database', 'localuserfield', 'idnumber', NULL),
(1487, 2, [[timestamp]], 'enrol_database', 'localrolefield', 'shortname', NULL),
(1488, 2, [[timestamp]], 'enrol_database', 'localcategoryfield', 'id', NULL),
(1489, 2, [[timestamp]], 'enrol_database', 'remoteenroltable', '', NULL),
(1490, 2, [[timestamp]], 'enrol_database', 'remotecoursefield', '', NULL),
(1491, 2, [[timestamp]], 'enrol_database', 'remoteuserfield', '', NULL),
(1492, 2, [[timestamp]], 'enrol_database', 'remoterolefield', '', NULL),
(1493, 2, [[timestamp]], 'enrol_database', 'remoteotheruserfield', '', NULL),
(1494, 2, [[timestamp]], 'enrol_database', 'defaultrole', '5', NULL),
(1495, 2, [[timestamp]], 'enrol_database', 'ignorehiddencourses', '0', NULL),
(1496, 2, [[timestamp]], 'enrol_database', 'unenrolaction', '0', NULL),
(1497, 2, [[timestamp]], 'enrol_database', 'newcoursetable', '', NULL),
(1498, 2, [[timestamp]], 'enrol_database', 'newcoursefullname', 'fullname', NULL),
(1499, 2, [[timestamp]], 'enrol_database', 'newcourseshortname', 'shortname', NULL),
(1500, 2, [[timestamp]], 'enrol_database', 'newcourseidnumber', 'idnumber', NULL),
(1501, 2, [[timestamp]], 'enrol_database', 'newcoursecategory', '', NULL),
(1502, 2, [[timestamp]], 'enrol_database', 'defaultcategory', '1', NULL),
(1503, 2, [[timestamp]], 'enrol_database', 'templatecourse', '', NULL),
(1504, 2, [[timestamp]], 'enrol_flatfile', 'location', '', NULL),
(1505, 2, [[timestamp]], 'enrol_flatfile', 'encoding', 'UTF-8', NULL),
(1506, 2, [[timestamp]], 'enrol_flatfile', 'mailstudents', '0', NULL),
(1507, 2, [[timestamp]], 'enrol_flatfile', 'mailteachers', '0', NULL),
(1508, 2, [[timestamp]], 'enrol_flatfile', 'mailadmins', '0', NULL),
(1509, 2, [[timestamp]], 'enrol_flatfile', 'unenrolaction', '3', NULL),
(1510, 2, [[timestamp]], 'enrol_flatfile', 'expiredaction', '3', NULL),
(1511, 2, [[timestamp]], 'enrol_guest', 'requirepassword', '0', NULL),
(1512, 2, [[timestamp]], 'enrol_guest', 'usepasswordpolicy', '0', NULL),
(1513, 2, [[timestamp]], 'enrol_guest', 'showhint', '0', NULL),
(1514, 2, [[timestamp]], 'enrol_guest', 'defaultenrol', '1', NULL),
(1515, 2, [[timestamp]], 'enrol_guest', 'status', '1', NULL),
(1516, 2, [[timestamp]], 'enrol_guest', 'status_adv', '', NULL),
(1517, 2, [[timestamp]], 'enrol_imsenterprise', 'imsfilelocation', '', NULL),
(1518, 2, [[timestamp]], 'enrol_imsenterprise', 'logtolocation', '', NULL),
(1519, 2, [[timestamp]], 'enrol_imsenterprise', 'mailadmins', '0', NULL),
(1520, 2, [[timestamp]], 'enrol_imsenterprise', 'createnewusers', '0', NULL),
(1521, 2, [[timestamp]], 'enrol_imsenterprise', 'imsupdateusers', '0', NULL),
(1522, 2, [[timestamp]], 'enrol_imsenterprise', 'imsdeleteusers', '0', NULL),
(1523, 2, [[timestamp]], 'enrol_imsenterprise', 'fixcaseusernames', '0', NULL),
(1524, 2, [[timestamp]], 'enrol_imsenterprise', 'fixcasepersonalnames', '0', NULL),
(1525, 2, [[timestamp]], 'enrol_imsenterprise', 'imssourcedidfallback', '0', NULL),
(1526, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap01', '5', NULL),
(1527, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap02', '3', NULL),
(1528, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap03', '3', NULL),
(1529, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap04', '5', NULL),
(1530, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap05', '0', NULL),
(1531, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap06', '4', NULL),
(1532, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap07', '0', NULL),
(1533, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap08', '4', NULL),
(1534, 2, [[timestamp]], 'enrol_imsenterprise', 'truncatecoursecodes', '0', NULL),
(1535, 2, [[timestamp]], 'enrol_imsenterprise', 'createnewcourses', '0', NULL),
(1536, 2, [[timestamp]], 'enrol_imsenterprise', 'updatecourses', '0', NULL),
(1537, 2, [[timestamp]], 'enrol_imsenterprise', 'createnewcategories', '0', NULL),
(1538, 2, [[timestamp]], 'enrol_imsenterprise', 'nestedcategories', '0', NULL),
(1539, 2, [[timestamp]], 'enrol_imsenterprise', 'categoryidnumber', '0', NULL),
(1540, 2, [[timestamp]], 'enrol_imsenterprise', 'categoryseparator', '', NULL),
(1541, 2, [[timestamp]], 'enrol_imsenterprise', 'imsunenrol', '0', NULL),
(1542, 2, [[timestamp]], 'enrol_imsenterprise', 'imscoursemapshortname', 'coursecode', NULL),
(1543, 2, [[timestamp]], 'enrol_imsenterprise', 'imscoursemapfullname', 'short', NULL),
(1544, 2, [[timestamp]], 'enrol_imsenterprise', 'imscoursemapsummary', 'ignore', NULL),
(1545, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrestricttarget', '', NULL),
(1546, 2, [[timestamp]], 'enrol_imsenterprise', 'imscapitafix', '0', NULL),
(1547, 2, [[timestamp]], 'enrol_ldap', 'host_url', '', NULL),
(1548, 2, [[timestamp]], 'enrol_ldap', 'start_tls', '0', NULL),
(1549, 2, [[timestamp]], 'enrol_ldap', 'ldap_version', '3', NULL),
(1550, 2, [[timestamp]], 'enrol_ldap', 'ldapencoding', 'utf-8', NULL),
(1551, 2, [[timestamp]], 'enrol_ldap', 'pagesize', '250', NULL),
(1552, 2, [[timestamp]], 'enrol_ldap', 'bind_dn', '', NULL),
(1553, 2, [[timestamp]], 'enrol_ldap', 'bind_pw', '', NULL),
(1554, 2, [[timestamp]], 'enrol_ldap', 'course_search_sub', '0', NULL),
(1555, 2, [[timestamp]], 'enrol_ldap', 'memberattribute_isdn', '0', NULL),
(1556, 2, [[timestamp]], 'enrol_ldap', 'user_contexts', '', NULL),
(1557, 2, [[timestamp]], 'enrol_ldap', 'user_search_sub', '0', NULL),
(1558, 2, [[timestamp]], 'enrol_ldap', 'user_type', 'default', NULL),
(1559, 2, [[timestamp]], 'enrol_ldap', 'opt_deref', '0', NULL),
(1560, 2, [[timestamp]], 'enrol_ldap', 'idnumber_attribute', '', NULL),
(1561, 2, [[timestamp]], 'enrol_ldap', 'objectclass', '', NULL),
(1562, 2, [[timestamp]], 'enrol_ldap', 'course_idnumber', '', NULL),
(1563, 2, [[timestamp]], 'enrol_ldap', 'course_shortname', '', NULL),
(1564, 2, [[timestamp]], 'enrol_ldap', 'course_fullname', '', NULL),
(1565, 2, [[timestamp]], 'enrol_ldap', 'course_summary', '', NULL),
(1566, 2, [[timestamp]], 'enrol_ldap', 'ignorehiddencourses', '0', NULL),
(1567, 2, [[timestamp]], 'enrol_ldap', 'unenrolaction', '0', NULL),
(1568, 2, [[timestamp]], 'enrol_ldap', 'autocreate', '0', NULL),
(1569, 2, [[timestamp]], 'enrol_ldap', 'category', '1', NULL),
(1570, 2, [[timestamp]], 'enrol_ldap', 'template', '', NULL),
(1571, 2, [[timestamp]], 'enrol_ldap', 'course_shortname_updateonsync', '0', NULL),
(1572, 2, [[timestamp]], 'enrol_ldap', 'course_fullname_updateonsync', '0', NULL),
(1573, 2, [[timestamp]], 'enrol_ldap', 'course_summary_updateonsync', '0', NULL),
(1574, 2, [[timestamp]], 'enrol_ldap', 'nested_groups', '0', NULL),
(1575, 2, [[timestamp]], 'enrol_ldap', 'group_memberofattribute', '', NULL),
(1576, 2, [[timestamp]], 'enrol_manual', 'expiredaction', '1', NULL),
(1577, 2, [[timestamp]], 'enrol_manual', 'expirynotifyhour', '6', NULL),
(1578, 2, [[timestamp]], 'enrol_manual', 'defaultenrol', '1', NULL),
(1579, 2, [[timestamp]], 'enrol_manual', 'status', '0', NULL),
(1580, 2, [[timestamp]], 'enrol_manual', 'roleid', '5', NULL),
(1581, 2, [[timestamp]], 'enrol_manual', 'enrolstart', '4', NULL),
(1582, 2, [[timestamp]], 'enrol_manual', 'enrolperiod', '0', NULL),
(1583, 2, [[timestamp]], 'enrol_manual', 'expirynotify', '0', NULL),
(1584, 2, [[timestamp]], 'enrol_manual', 'expirythreshold', '86400', NULL),
(1585, 2, [[timestamp]], 'enrol_mnet', 'roleid', '5', NULL),
(1586, 2, [[timestamp]], 'enrol_mnet', 'roleid_adv', '1', NULL),
(1587, 2, [[timestamp]], 'enrol_paypal', 'paypalbusiness', '', NULL),
(1588, 2, [[timestamp]], 'enrol_paypal', 'mailstudents', '0', NULL),
(1589, 2, [[timestamp]], 'enrol_paypal', 'mailteachers', '0', NULL),
(1590, 2, [[timestamp]], 'enrol_paypal', 'mailadmins', '0', NULL),
(1591, 2, [[timestamp]], 'enrol_paypal', 'expiredaction', '3', NULL),
(1592, 2, [[timestamp]], 'enrol_paypal', 'status', '1', NULL),
(1593, 2, [[timestamp]], 'enrol_paypal', 'cost', '0', NULL),
(1594, 2, [[timestamp]], 'enrol_paypal', 'currency', 'USD', NULL),
(1595, 2, [[timestamp]], 'enrol_paypal', 'roleid', '5', NULL),
(1596, 2, [[timestamp]], 'enrol_paypal', 'enrolperiod', '0', NULL),
(1597, 2, [[timestamp]], 'enrol_lti', 'emaildisplay', '2', NULL),
(1598, 2, [[timestamp]], 'enrol_lti', 'city', '', NULL),
(1599, 2, [[timestamp]], 'enrol_lti', 'country', '', NULL),
(1600, 2, [[timestamp]], 'enrol_lti', 'timezone', '99', NULL),
(1601, 2, [[timestamp]], 'enrol_lti', 'lang', 'en', NULL),
(1602, 2, [[timestamp]], 'enrol_lti', 'institution', '', NULL),
(1603, 2, [[timestamp]], 'enrol_self', 'requirepassword', '0', NULL),
(1604, 2, [[timestamp]], 'enrol_self', 'usepasswordpolicy', '0', NULL),
(1605, 2, [[timestamp]], 'enrol_self', 'showhint', '0', NULL),
(1606, 2, [[timestamp]], 'enrol_self', 'expiredaction', '1', NULL),
(1607, 2, [[timestamp]], 'enrol_self', 'expirynotifyhour', '6', NULL),
(1608, 2, [[timestamp]], 'enrol_self', 'defaultenrol', '1', NULL),
(1609, 2, [[timestamp]], 'enrol_self', 'status', '1', NULL),
(1610, 2, [[timestamp]], 'enrol_self', 'newenrols', '1', NULL),
(1611, 2, [[timestamp]], 'enrol_self', 'groupkey', '0', NULL),
(1612, 2, [[timestamp]], 'enrol_self', 'roleid', '5', NULL),
(1613, 2, [[timestamp]], 'enrol_self', 'enrolperiod', '0', NULL),
(1614, 2, [[timestamp]], 'enrol_self', 'expirynotify', '0', NULL),
(1615, 2, [[timestamp]], 'enrol_self', 'expirythreshold', '86400', NULL),
(1616, 2, [[timestamp]], 'enrol_self', 'longtimenosee', '0', NULL),
(1617, 2, [[timestamp]], 'enrol_self', 'maxenrolled', '0', NULL),
(1618, 2, [[timestamp]], 'enrol_self', 'sendcoursewelcomemessage', '1', NULL),
(1619, 2, [[timestamp]], 'filter_urltolink', 'formats', '1,4,0', NULL),
(1620, 2, [[timestamp]], 'filter_urltolink', 'embedimages', '1', NULL),
(1621, 2, [[timestamp]], 'filter_emoticon', 'formats', '1,4,0', NULL),
(1622, 2, [[timestamp]], 'filter_displayh5p', 'allowedsources', '', NULL),
(1623, 2, [[timestamp]], 'filter_mathjaxloader', 'httpsurl', 'https://cdn.jsdelivr.net/npm/mathjax@2.7.9/MathJax.js', NULL),
(1624, 2, [[timestamp]], 'filter_mathjaxloader', 'texfiltercompatibility', '0', NULL),
(1625, 2, [[timestamp]], 'filter_mathjaxloader', 'mathjaxconfig', '\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n', NULL),
(1626, 2, [[timestamp]], 'filter_mathjaxloader', 'additionaldelimiters', '', NULL),
(1627, 2, [[timestamp]], NULL, 'filter_multilang_force_old', '0', NULL),
(1628, 2, [[timestamp]], 'filter_tex', 'latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n', NULL),
(1629, 2, [[timestamp]], 'filter_tex', 'latexbackground', '#FFFFFF', NULL),
(1630, 2, [[timestamp]], 'filter_tex', 'density', '120', NULL),
(1631, 2, [[timestamp]], 'filter_tex', 'pathlatex', '[[default_filter_tex_pathlatex]]', NULL),
(1632, 2, [[timestamp]], 'filter_tex', 'pathdvips', '[[default_filter_tex_pathdvips]]', NULL),
(1633, 2, [[timestamp]], 'filter_tex', 'pathconvert', '[[default_filter_tex_pathconvert]]', NULL),
(1634, 2, [[timestamp]], 'filter_tex', 'pathdvisvgm', '[[default_filter_tex_dvisvgm]]', NULL),
(1635, 2, [[timestamp]], 'filter_tex', 'pathmimetex', '', NULL),
(1636, 2, [[timestamp]], 'filter_tex', 'convertformat', 'gif', NULL),
(1637, 2, [[timestamp]], NULL, 'filter_censor_badwords', '', NULL),
(1638, 2, [[timestamp]], 'logstore_database', 'dbdriver', '', NULL),
(1639, 2, [[timestamp]], 'logstore_database', 'dbhost', '', NULL),
(1640, 2, [[timestamp]], 'logstore_database', 'dbuser', '', NULL),
(1641, 2, [[timestamp]], 'logstore_database', 'dbpass', '', NULL),
(1642, 2, [[timestamp]], 'logstore_database', 'dbname', '', NULL),
(1643, 2, [[timestamp]], 'logstore_database', 'dbtable', '', NULL),
(1644, 2, [[timestamp]], 'logstore_database', 'dbpersist', '0', NULL),
(1645, 2, [[timestamp]], 'logstore_database', 'dbsocket', '', NULL),
(1646, 2, [[timestamp]], 'logstore_database', 'dbport', '', NULL),
(1647, 2, [[timestamp]], 'logstore_database', 'dbschema', '', NULL),
(1648, 2, [[timestamp]], 'logstore_database', 'dbcollation', '', NULL),
(1649, 2, [[timestamp]], 'logstore_database', 'dbhandlesoptions', '0', NULL),
(1650, 2, [[timestamp]], 'logstore_database', 'buffersize', '50', NULL),
(1651, 2, [[timestamp]], 'logstore_database', 'jsonformat', '1', NULL),
(1652, 2, [[timestamp]], 'logstore_database', 'logguests', '0', NULL),
(1653, 2, [[timestamp]], 'logstore_database', 'includelevels', '1,2,0', NULL),
(1654, 2, [[timestamp]], 'logstore_database', 'includeactions', 'c,r,u,d', NULL),
(1655, 2, [[timestamp]], 'logstore_legacy', 'loglegacy', '0', NULL),
(1656, 2, [[timestamp]], NULL, 'logguests', '1', NULL),
(1657, 2, [[timestamp]], NULL, 'loglifetime', '0', NULL),
(1658, 2, [[timestamp]], 'logstore_standard', 'logguests', '1', NULL),
(1659, 2, [[timestamp]], 'logstore_standard', 'jsonformat', '1', NULL),
(1660, 2, [[timestamp]], 'logstore_standard', 'loglifetime', '0', NULL),
(1661, 2, [[timestamp]], 'logstore_standard', 'buffersize', '50', NULL),
(1662, 2, [[timestamp]], 'mlbackend_python', 'useserver', '0', NULL),
(1663, 2, [[timestamp]], 'mlbackend_python', 'host', '', NULL),
(1664, 2, [[timestamp]], 'mlbackend_python', 'port', '0', NULL),
(1665, 2, [[timestamp]], 'mlbackend_python', 'secure', '0', NULL),
(1666, 2, [[timestamp]], 'mlbackend_python', 'username', 'default', NULL),
(1667, 2, [[timestamp]], 'mlbackend_python', 'password', '', NULL),
(1668, 2, [[timestamp]], 'media_videojs', 'videoextensions', 'html_video,media_source,.f4v,.flv', NULL),
(1669, 2, [[timestamp]], 'media_videojs', 'audioextensions', 'html_audio', NULL),
(1670, 2, [[timestamp]], 'media_videojs', 'rtmp', '0', NULL),
(1671, 2, [[timestamp]], 'media_videojs', 'useflash', '0', NULL),
(1672, 2, [[timestamp]], 'media_videojs', 'youtube', '1', NULL),
(1673, 2, [[timestamp]], 'media_videojs', 'videocssclass', 'video-js', NULL),
(1674, 2, [[timestamp]], 'media_videojs', 'audiocssclass', 'video-js', NULL),
(1675, 2, [[timestamp]], 'media_videojs', 'limitsize', '1', NULL),
(1676, 2, [[timestamp]], 'paygw_paypal', 'surcharge', '0', NULL),
(1677, 2, [[timestamp]], 'qtype_multichoice', 'answerhowmany', '1', NULL),
(1678, 2, [[timestamp]], 'qtype_multichoice', 'shuffleanswers', '1', NULL),
(1679, 2, [[timestamp]], 'qtype_multichoice', 'answernumbering', 'abc', NULL),
(1680, 2, [[timestamp]], 'editor_atto', 'toolbar', 'collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html', NULL),
(1681, 2, [[timestamp]], 'editor_atto', 'autosavefrequency', '60', NULL),
(1682, 2, [[timestamp]], 'atto_collapse', 'showgroups', '5', NULL),
(1683, 2, [[timestamp]], 'atto_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n', NULL),
(1684, 2, [[timestamp]], 'atto_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n', NULL),
(1685, 2, [[timestamp]], 'atto_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n', NULL),
(1686, 2, [[timestamp]], 'atto_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n', NULL),
(1687, 2, [[timestamp]], 'atto_recordrtc', 'allowedtypes', 'both', NULL),
(1688, 2, [[timestamp]], 'atto_recordrtc', 'audiobitrate', '128000', NULL),
(1689, 2, [[timestamp]], 'atto_recordrtc', 'videobitrate', '2500000', NULL),
(1690, 2, [[timestamp]], 'atto_recordrtc', 'timelimit', '120', NULL),
(1691, 2, [[timestamp]], 'atto_table', 'allowborders', '0', NULL),
(1692, 2, [[timestamp]], 'atto_table', 'allowbackgroundcolour', '0', NULL),
(1693, 2, [[timestamp]], 'atto_table', 'allowwidth', '0', NULL),
(1694, 2, [[timestamp]], 'editor_tinymce', 'customtoolbar', 'wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen', NULL),
(1695, 2, [[timestamp]], 'editor_tinymce', 'fontselectlist', 'Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings', NULL),
(1696, 2, [[timestamp]], 'editor_tinymce', 'customconfig', '', NULL),
(1697, 2, [[timestamp]], 'tinymce_moodleemoticon', 'requireemoticon', '1', NULL),
(1698, 2, [[timestamp]], 'tinymce_spellchecker', 'spellengine', '', NULL),
(1699, 2, [[timestamp]], 'tinymce_spellchecker', 'spelllanguagelist', '+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv', NULL),
(1700, 2, [[timestamp]], NULL, 'profileroles', '5,4,3', NULL),
(1701, 2, [[timestamp]], NULL, 'coursecontact', '3', NULL),
(1702, 2, [[timestamp]], NULL, 'frontpage', '6', NULL),
(1703, 2, [[timestamp]], NULL, 'frontpageloggedin', '6', NULL),
(1704, 2, [[timestamp]], NULL, 'maxcategorydepth', '2', NULL),
(1705, 2, [[timestamp]], NULL, 'frontpagecourselimit', '200', NULL),
(1706, 2, [[timestamp]], NULL, 'commentsperpage', '15', NULL),
(1707, 2, [[timestamp]], NULL, 'defaultfrontpageroleid', '8', NULL),
(1708, 2, [[timestamp]], NULL, 'messageinbound_enabled', '0', NULL),
(1709, 2, [[timestamp]], NULL, 'messageinbound_mailbox', '', NULL),
(1710, 2, [[timestamp]], NULL, 'messageinbound_domain', '', NULL),
(1711, 2, [[timestamp]], NULL, 'messageinbound_host', '', NULL),
(1712, 2, [[timestamp]], NULL, 'messageinbound_hostssl', 'ssl', NULL),
(1713, 2, [[timestamp]], NULL, 'messageinbound_hostuser', '', NULL),
(1714, 2, [[timestamp]], NULL, 'messageinbound_hostpass', '', NULL),
(1715, 2, [[timestamp]], NULL, 'enablemobilewebservice', '0', NULL),
(1716, 2, [[timestamp]], 'tool_mobile', 'apppolicy', '', NULL),
(1717, 2, [[timestamp]], 'tool_mobile', 'typeoflogin', '1', NULL),
(1718, 2, [[timestamp]], 'tool_mobile', 'qrcodetype', '1', NULL),
(1719, 2, [[timestamp]], 'tool_mobile', 'forcedurlscheme', 'moodlemobile', NULL),
(1720, 2, [[timestamp]], 'tool_mobile', 'minimumversion', '', NULL),
(1721, 2, [[timestamp]], NULL, 'mobilecssurl', '', NULL),
(1722, 2, [[timestamp]], 'tool_mobile', 'enablesmartappbanners', '0', NULL),
(1723, 2, [[timestamp]], 'tool_mobile', 'iosappid', '633359593', NULL),
(1724, 2, [[timestamp]], 'tool_mobile', 'androidappid', 'com.moodle.moodlemobile', NULL),
(1725, 2, [[timestamp]], 'tool_mobile', 'setuplink', 'https://download.moodle.org/mobile', NULL),
(1726, 2, [[timestamp]], 'tool_mobile', 'forcelogout', '0', NULL),
(1727, 2, [[timestamp]], 'tool_mobile', 'disabledfeatures', '', NULL),
(1728, 2, [[timestamp]], 'tool_mobile', 'custommenuitems', '', NULL),
(1729, 2, [[timestamp]], 'tool_mobile', 'filetypeexclusionlist', '', NULL),
(1730, 2, [[timestamp]], 'tool_mobile', 'customlangstrings', '', NULL),
(1731, 2, [[timestamp]], 'tool_moodlenet', 'enablemoodlenet', '0', NULL),
(1732, 2, [[timestamp]], 'tool_moodlenet', 'defaultmoodlenetname', 'MoodleNet Central', NULL),
(1733, 2, [[timestamp]], 'tool_moodlenet', 'defaultmoodlenet', 'https://moodle.net', NULL),
(1734, 2, [[timestamp]], NULL, 'timezone', 'America/New_York', NULL),
(1735, 2, [[timestamp]], NULL, 'registerauth', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_plugins`
--

CREATE TABLE `[[dbprefix]]config_plugins` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) NOT NULL DEFAULT 'core',
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]confplug_plunam_uix` (`plugin`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Moodle modules and plugins configuration variables' AUTO_INCREMENT=2015 ;

--
-- Dumping data for table `[[dbprefix]]config_plugins`
--

INSERT INTO `[[dbprefix]]config_plugins` VALUES
(1, 'question', 'multichoice_sortorder', '1'),
(2, 'question', 'truefalse_sortorder', '2'),
(3, 'question', 'match_sortorder', '3'),
(4, 'question', 'shortanswer_sortorder', '4'),
(5, 'question', 'numerical_sortorder', '5'),
(6, 'question', 'essay_sortorder', '6'),
(7, 'moodlecourse', 'visible', '1'),
(8, 'moodlecourse', 'downloadcontentsitedefault', '0'),
(9, 'moodlecourse', 'format', 'topics'),
(10, 'moodlecourse', 'maxsections', '52'),
(11, 'moodlecourse', 'numsections', '4'),
(12, 'moodlecourse', 'hiddensections', '0'),
(13, 'moodlecourse', 'coursedisplay', '0'),
(14, 'moodlecourse', 'courseenddateenabled', '1'),
(15, 'moodlecourse', 'courseduration', '31536000'),
(16, 'moodlecourse', 'lang', ''),
(17, 'moodlecourse', 'newsitems', '5'),
(18, 'moodlecourse', 'showgrades', '1'),
(19, 'moodlecourse', 'showreports', '0'),
(20, 'moodlecourse', 'showactivitydates', '1'),
(21, 'moodlecourse', 'maxbytes', '0'),
(22, 'moodlecourse', 'enablecompletion', '1'),
(23, 'moodlecourse', 'showcompletionconditions', '1'),
(24, 'moodlecourse', 'groupmode', '0'),
(25, 'moodlecourse', 'groupmodeforce', '0'),
(26, 'backup', 'loglifetime', '30'),
(27, 'backup', 'backup_general_users', '1'),
(28, 'backup', 'backup_general_users_locked', ''),
(29, 'backup', 'backup_general_anonymize', '0'),
(30, 'backup', 'backup_general_anonymize_locked', ''),
(31, 'backup', 'backup_general_role_assignments', '1'),
(32, 'backup', 'backup_general_role_assignments_locked', ''),
(33, 'backup', 'backup_general_activities', '1'),
(34, 'backup', 'backup_general_activities_locked', ''),
(35, 'backup', 'backup_general_blocks', '1'),
(36, 'backup', 'backup_general_blocks_locked', ''),
(37, 'backup', 'backup_general_files', '1'),
(38, 'backup', 'backup_general_files_locked', ''),
(39, 'backup', 'backup_general_filters', '1'),
(40, 'backup', 'backup_general_filters_locked', ''),
(41, 'backup', 'backup_general_comments', '1'),
(42, 'backup', 'backup_general_comments_locked', ''),
(43, 'backup', 'backup_general_badges', '1'),
(44, 'backup', 'backup_general_badges_locked', ''),
(45, 'backup', 'backup_general_calendarevents', '1'),
(46, 'backup', 'backup_general_calendarevents_locked', ''),
(47, 'backup', 'backup_general_userscompletion', '1'),
(48, 'backup', 'backup_general_userscompletion_locked', ''),
(49, 'backup', 'backup_general_logs', '0'),
(50, 'backup', 'backup_general_logs_locked', ''),
(51, 'backup', 'backup_general_histories', '0'),
(52, 'backup', 'backup_general_histories_locked', ''),
(53, 'backup', 'backup_general_questionbank', '1'),
(54, 'backup', 'backup_general_questionbank_locked', ''),
(55, 'backup', 'backup_general_groups', '1'),
(56, 'backup', 'backup_general_groups_locked', ''),
(57, 'backup', 'backup_general_competencies', '1'),
(58, 'backup', 'backup_general_competencies_locked', ''),
(59, 'backup', 'backup_general_contentbankcontent', '1'),
(60, 'backup', 'backup_general_contentbankcontent_locked', ''),
(61, 'backup', 'backup_general_legacyfiles', '1'),
(62, 'backup', 'backup_general_legacyfiles_locked', ''),
(63, 'backup', 'import_general_maxresults', '10'),
(64, 'backup', 'import_general_duplicate_admin_allowed', '0'),
(65, 'backup', 'backup_import_permissions', '0'),
(66, 'backup', 'backup_import_permissions_locked', ''),
(67, 'backup', 'backup_import_activities', '1'),
(68, 'backup', 'backup_import_activities_locked', ''),
(69, 'backup', 'backup_import_blocks', '1'),
(70, 'backup', 'backup_import_blocks_locked', ''),
(71, 'backup', 'backup_import_filters', '1'),
(72, 'backup', 'backup_import_filters_locked', ''),
(73, 'backup', 'backup_import_calendarevents', '1'),
(74, 'backup', 'backup_import_calendarevents_locked', ''),
(75, 'backup', 'backup_import_questionbank', '1'),
(76, 'backup', 'backup_import_questionbank_locked', ''),
(77, 'backup', 'backup_import_groups', '1'),
(78, 'backup', 'backup_import_groups_locked', ''),
(79, 'backup', 'backup_import_competencies', '1'),
(80, 'backup', 'backup_import_competencies_locked', ''),
(81, 'backup', 'backup_import_contentbankcontent', '1'),
(82, 'backup', 'backup_import_contentbankcontent_locked', ''),
(83, 'backup', 'backup_import_legacyfiles', '1'),
(84, 'backup', 'backup_import_legacyfiles_locked', ''),
(85, 'backup', 'backup_auto_active', '0'),
(86, 'backup', 'backup_auto_weekdays', '0000000'),
(87, 'backup', 'backup_auto_hour', '0'),
(88, 'backup', 'backup_auto_minute', '0'),
(89, 'backup', 'backup_auto_storage', '0'),
(90, 'backup', 'backup_auto_destination', ''),
(91, 'backup', 'backup_auto_max_kept', '1'),
(92, 'backup', 'backup_auto_delete_days', '0'),
(93, 'backup', 'backup_auto_min_kept', '0'),
(94, 'backup', 'backup_shortname', '0'),
(95, 'backup', 'backup_auto_skip_hidden', '1'),
(96, 'backup', 'backup_auto_skip_modif_days', '30'),
(97, 'backup', 'backup_auto_skip_modif_prev', '0'),
(98, 'backup', 'backup_auto_users', '1'),
(99, 'backup', 'backup_auto_role_assignments', '1'),
(100, 'backup', 'backup_auto_activities', '1'),
(101, 'backup', 'backup_auto_blocks', '1'),
(102, 'backup', 'backup_auto_files', '1'),
(103, 'backup', 'backup_auto_filters', '1'),
(104, 'backup', 'backup_auto_comments', '1'),
(105, 'backup', 'backup_auto_badges', '1'),
(106, 'backup', 'backup_auto_calendarevents', '1'),
(107, 'backup', 'backup_auto_userscompletion', '1'),
(108, 'backup', 'backup_auto_logs', '0'),
(109, 'backup', 'backup_auto_histories', '0'),
(110, 'backup', 'backup_auto_questionbank', '1'),
(111, 'backup', 'backup_auto_groups', '1'),
(112, 'backup', 'backup_auto_competencies', '1'),
(113, 'backup', 'backup_auto_contentbankcontent', '1'),
(114, 'backup', 'backup_auto_legacyfiles', '1'),
(115, 'restore', 'restore_general_users', '1'),
(116, 'restore', 'restore_general_users_locked', ''),
(117, 'restore', 'restore_general_enrolments', '1'),
(118, 'restore', 'restore_general_enrolments_locked', ''),
(119, 'restore', 'restore_general_role_assignments', '1'),
(120, 'restore', 'restore_general_role_assignments_locked', ''),
(121, 'restore', 'restore_general_permissions', '1'),
(122, 'restore', 'restore_general_permissions_locked', ''),
(123, 'restore', 'restore_general_activities', '1'),
(124, 'restore', 'restore_general_activities_locked', ''),
(125, 'restore', 'restore_general_blocks', '1'),
(126, 'restore', 'restore_general_blocks_locked', ''),
(127, 'restore', 'restore_general_filters', '1'),
(128, 'restore', 'restore_general_filters_locked', ''),
(129, 'restore', 'restore_general_comments', '1'),
(130, 'restore', 'restore_general_comments_locked', ''),
(131, 'restore', 'restore_general_badges', '1'),
(132, 'restore', 'restore_general_badges_locked', ''),
(133, 'restore', 'restore_general_calendarevents', '1'),
(134, 'restore', 'restore_general_calendarevents_locked', ''),
(135, 'restore', 'restore_general_userscompletion', '1'),
(136, 'restore', 'restore_general_userscompletion_locked', ''),
(137, 'restore', 'restore_general_logs', '1'),
(138, 'restore', 'restore_general_logs_locked', ''),
(139, 'restore', 'restore_general_histories', '1'),
(140, 'restore', 'restore_general_histories_locked', ''),
(141, 'restore', 'restore_general_groups', '1'),
(142, 'restore', 'restore_general_groups_locked', ''),
(143, 'restore', 'restore_general_competencies', '1'),
(144, 'restore', 'restore_general_competencies_locked', ''),
(145, 'restore', 'restore_general_contentbankcontent', '1'),
(146, 'restore', 'restore_general_contentbankcontent_locked', ''),
(147, 'restore', 'restore_general_legacyfiles', '1'),
(148, 'restore', 'restore_general_legacyfiles_locked', ''),
(149, 'restore', 'restore_merge_overwrite_conf', '0'),
(150, 'restore', 'restore_merge_overwrite_conf_locked', ''),
(151, 'restore', 'restore_merge_course_fullname', '1'),
(152, 'restore', 'restore_merge_course_fullname_locked', ''),
(153, 'restore', 'restore_merge_course_shortname', '1'),
(154, 'restore', 'restore_merge_course_shortname_locked', ''),
(155, 'restore', 'restore_merge_course_startdate', '1'),
(156, 'restore', 'restore_merge_course_startdate_locked', ''),
(157, 'restore', 'restore_replace_overwrite_conf', '0'),
(158, 'restore', 'restore_replace_overwrite_conf_locked', ''),
(159, 'restore', 'restore_replace_course_fullname', '1'),
(160, 'restore', 'restore_replace_course_fullname_locked', ''),
(161, 'restore', 'restore_replace_course_shortname', '1'),
(162, 'restore', 'restore_replace_course_shortname_locked', ''),
(163, 'restore', 'restore_replace_course_startdate', '1'),
(164, 'restore', 'restore_replace_course_startdate_locked', ''),
(165, 'restore', 'restore_replace_keep_roles_and_enrolments', '0'),
(166, 'restore', 'restore_replace_keep_roles_and_enrolments_locked', ''),
(167, 'restore', 'restore_replace_keep_groups_and_groupings', '0'),
(168, 'restore', 'restore_replace_keep_groups_and_groupings_locked', ''),
(169, 'backup', 'backup_async_message_users', '0'),
(170, 'backup', 'backup_async_message_subject', 'Moodle {operation} completed successfully'),
(171, 'backup', 'backup_async_message', 'Your {operation} (ID: {backupid}) has completed successfully. You can access it here: <a href="{link}">{link}</a>.'),
(172, 'analytics', 'modeinstruction', ''),
(173, 'analytics', 'percentonline', '0'),
(174, 'analytics', 'typeinstitution', ''),
(175, 'analytics', 'levelinstitution', ''),
(176, 'analytics', 'predictionsprocessor', '\\mlbackend_php\\processor'),
(177, 'analytics', 'defaulttimesplittingsevaluation', '\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range'),
(178, 'analytics', 'modeloutputdir', ''),
(179, 'analytics', 'onlycli', '1'),
(180, 'analytics', 'modeltimelimit', '1200'),
(181, 'analytics', 'calclifetime', '35'),
(182, 'core_competency', 'enabled', '1'),
(183, 'core_competency', 'pushcourseratingstouserplans', '1'),
(184, 'antivirus', 'notifyemail', ''),
(185, 'antivirus', 'enablequarantine', '0'),
(186, 'antivirus', 'quarantinetime', '2419200'),
(187, 'cachestore_apcu', 'testperformance', '0'),
(188, 'cachestore_memcached', 'testservers', ''),
(189, 'cachestore_mongodb', 'testserver', ''),
(190, 'cachestore_redis', 'test_server', ''),
(191, 'cachestore_redis', 'test_password', ''),
(192, 'question_preview', 'behaviour', 'deferredfeedback'),
(193, 'question_preview', 'correctness', '1'),
(194, 'question_preview', 'marks', '2'),
(195, 'question_preview', 'markdp', '2'),
(196, 'question_preview', 'feedback', '1'),
(197, 'question_preview', 'generalfeedback', '1'),
(198, 'question_preview', 'rightanswer', '1'),
(199, 'question_preview', 'history', '0'),
(200, 'tool_task', 'enablerunnow', '1'),
(201, 'theme_boost', 'preset', 'default.scss'),
(202, 'theme_boost', 'presetfiles', ''),
(203, 'theme_boost', 'backgroundimage', ''),
(204, 'theme_boost', 'brandcolor', ''),
(205, 'theme_boost', 'scsspre', ''),
(206, 'theme_boost', 'scss', ''),
(207, 'theme_classic', 'navbardark', '0'),
(208, 'theme_classic', 'preset', 'default.scss'),
(209, 'theme_classic', 'presetfiles', ''),
(210, 'theme_classic', 'backgroundimage', ''),
(211, 'theme_classic', 'brandcolor', ''),
(212, 'theme_classic', 'scsspre', ''),
(213, 'theme_classic', 'scss', ''),
(214, 'core_admin', 'logo', ''),
(215, 'core_admin', 'logocompact', ''),
(216, 'core_admin', 'coursecolor1', '#81ecec'),
(217, 'core_admin', 'coursecolor2', '#74b9ff'),
(218, 'core_admin', 'coursecolor3', '#a29bfe'),
(219, 'core_admin', 'coursecolor4', '#dfe6e9'),
(220, 'core_admin', 'coursecolor5', '#00b894'),
(221, 'core_admin', 'coursecolor6', '#0984e3'),
(222, 'core_admin', 'coursecolor7', '#b2bec3'),
(223, 'core_admin', 'coursecolor8', '#fdcb6e'),
(224, 'core_admin', 'coursecolor9', '#fd79a8'),
(225, 'core_admin', 'coursecolor10', '#6c5ce7'),
(226, 'antivirus_clamav', 'version', '2021051700'),
(227, 'availability_completion', 'version', '2021051700'),
(228, 'availability_date', 'version', '2021051700'),
(229, 'availability_grade', 'version', '2021051700'),
(230, 'availability_group', 'version', '2021051700'),
(231, 'availability_grouping', 'version', '2021051700'),
(232, 'availability_profile', 'version', '2021051700'),
(233, 'qtype_calculated', 'version', '2021051700'),
(234, 'qtype_calculatedmulti', 'version', '2021051700'),
(235, 'qtype_calculatedsimple', 'version', '2021051700'),
(236, 'qtype_ddimageortext', 'version', '2021051700'),
(237, 'qtype_ddmarker', 'version', '2021051700'),
(238, 'qtype_ddwtos', 'version', '2021051700'),
(239, 'qtype_description', 'version', '2021051700'),
(240, 'qtype_essay', 'version', '2021051700'),
(241, 'qtype_gapselect', 'version', '2021051700'),
(242, 'qtype_match', 'version', '2021051700'),
(243, 'qtype_missingtype', 'version', '2021051700'),
(244, 'qtype_multianswer', 'version', '2021051701'),
(245, 'qtype_multichoice', 'version', '2021051700'),
(246, 'qtype_numerical', 'version', '2021051700'),
(247, 'qtype_random', 'version', '2021051700'),
(248, 'qtype_randomsamatch', 'version', '2021051700'),
(249, 'qtype_shortanswer', 'version', '2021051700'),
(250, 'qtype_truefalse', 'version', '2021051700'),
(251, 'mod_assign', 'version', '2021051701'),
(252, 'mod_assignment', 'version', '2021051700'),
(254, 'mod_book', 'version', '2021051700'),
(255, 'mod_chat', 'version', '2021051700'),
(256, 'mod_choice', 'version', '2021051700'),
(257, 'mod_data', 'version', '2021051700'),
(258, 'mod_feedback', 'version', '2021051700'),
(260, 'mod_folder', 'version', '2021051700'),
(262, 'mod_forum', 'version', '2021051701'),
(263, 'mod_glossary', 'version', '2021051700'),
(264, 'mod_h5pactivity', 'version', '2021051700'),
(265, 'mod_imscp', 'version', '2021051700'),
(267, 'mod_label', 'version', '2021051701'),
(268, 'mod_lesson', 'version', '2021051700'),
(269, 'mod_lti', 'version', '2021051701'),
(271, 'mod_lti', 'kid', '[[kid]]'),
(272, 'mod_lti', 'privatekey', '[[privatekey]]'),
(273, 'mod_page', 'version', '2021051700'),
(275, 'mod_quiz', 'version', '2021051700'),
(276, 'mod_resource', 'version', '2021051700'),
(277, 'mod_scorm', 'version', '2021051700'),
(278, 'mod_survey', 'version', '2021051700'),
(280, 'mod_url', 'version', '2021051700'),
(282, 'mod_wiki', 'version', '2021051700'),
(284, 'mod_workshop', 'version', '2021051700'),
(285, 'auth_cas', 'version', '2021051700'),
(287, 'auth_db', 'version', '2021051700'),
(289, 'auth_email', 'version', '2021051700'),
(290, 'auth_ldap', 'version', '2021051700'),
(292, 'auth_lti', 'version', '2021051700'),
(293, 'auth_manual', 'version', '2021051700'),
(294, 'auth_mnet', 'version', '2021051700'),
(296, 'auth_nologin', 'version', '2021051700'),
(297, 'auth_none', 'version', '2021051700'),
(298, 'auth_oauth2', 'version', '2021051700'),
(299, 'auth_shibboleth', 'version', '2021051700'),
(301, 'auth_webservice', 'version', '2021051700'),
(302, 'calendartype_gregorian', 'version', '2021051700'),
(303, 'customfield_checkbox', 'version', '2021051700'),
(304, 'customfield_date', 'version', '2021051700'),
(305, 'customfield_select', 'version', '2021051700'),
(306, 'customfield_text', 'version', '2021051700'),
(307, 'customfield_textarea', 'version', '2021051700'),
(308, 'enrol_category', 'version', '2021051700'),
(310, 'enrol_cohort', 'version', '2021051700'),
(311, 'enrol_database', 'version', '2021051700'),
(313, 'enrol_fee', 'version', '2021051700'),
(314, 'enrol_flatfile', 'version', '2021051700'),
(316, 'enrol_flatfile', 'map_1', 'manager'),
(317, 'enrol_flatfile', 'map_2', 'coursecreator'),
(318, 'enrol_flatfile', 'map_3', 'editingteacher'),
(319, 'enrol_flatfile', 'map_4', 'teacher'),
(320, 'enrol_flatfile', 'map_5', 'student'),
(321, 'enrol_flatfile', 'map_6', 'guest'),
(322, 'enrol_flatfile', 'map_7', 'user'),
(323, 'enrol_flatfile', 'map_8', 'frontpage'),
(324, 'enrol_guest', 'version', '2021051700'),
(325, 'enrol_imsenterprise', 'version', '2021051700'),
(327, 'enrol_ldap', 'version', '2021051700'),
(329, 'enrol_lti', 'version', '2021051703'),
(330, 'enrol_manual', 'version', '2021051700'),
(332, 'enrol_meta', 'version', '2021051700'),
(334, 'enrol_mnet', 'version', '2021051700'),
(335, 'enrol_paypal', 'version', '2021051700'),
(336, 'enrol_self', 'version', '2021051700'),
(338, 'message_airnotifier', 'version', '2021051700'),
(340, 'message', 'airnotifier_provider_enrol_flatfile_flatfile_enrolment_permitted', 'permitted'),
(341, 'message', 'airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted', 'permitted'),
(342, 'message', 'airnotifier_provider_enrol_manual_expiry_notification_permitted', 'permitted'),
(343, 'message', 'airnotifier_provider_enrol_paypal_paypal_enrolment_permitted', 'permitted'),
(344, 'message', 'airnotifier_provider_enrol_self_expiry_notification_permitted', 'permitted'),
(345, 'message', 'airnotifier_provider_mod_assign_assign_notification_permitted', 'permitted'),
(346, 'message', 'airnotifier_provider_mod_assignment_assignment_updates_permitted', 'permitted'),
(347, 'message', 'airnotifier_provider_mod_feedback_submission_permitted', 'permitted'),
(348, 'message', 'airnotifier_provider_mod_feedback_message_permitted', 'permitted'),
(349, 'message', 'airnotifier_provider_mod_forum_posts_permitted', 'permitted'),
(350, 'message', 'message_provider_mod_forum_posts_loggedin', 'email,airnotifier'),
(351, 'message', 'message_provider_mod_forum_posts_loggedoff', 'email,airnotifier'),
(352, 'message', 'airnotifier_provider_mod_forum_digests_permitted', 'permitted'),
(353, 'message', 'airnotifier_provider_mod_lesson_graded_essay_permitted', 'permitted'),
(354, 'message', 'message_provider_mod_lesson_graded_essay_loggedin', 'email,airnotifier'),
(355, 'message', 'message_provider_mod_lesson_graded_essay_loggedoff', 'email,airnotifier'),
(356, 'message', 'airnotifier_provider_mod_quiz_submission_permitted', 'permitted'),
(357, 'message', 'airnotifier_provider_mod_quiz_confirmation_permitted', 'permitted'),
(358, 'message', 'message_provider_mod_quiz_confirmation_loggedin', 'email,airnotifier'),
(359, 'message', 'message_provider_mod_quiz_confirmation_loggedoff', 'email,airnotifier'),
(360, 'message', 'airnotifier_provider_mod_quiz_attempt_overdue_permitted', 'permitted'),
(361, 'message', 'message_provider_mod_quiz_attempt_overdue_loggedin', 'email,airnotifier'),
(362, 'message', 'message_provider_mod_quiz_attempt_overdue_loggedoff', 'email,airnotifier'),
(363, 'message', 'airnotifier_provider_moodle_notices_permitted', 'permitted'),
(364, 'message', 'airnotifier_provider_moodle_errors_permitted', 'permitted'),
(365, 'message', 'airnotifier_provider_moodle_availableupdate_permitted', 'permitted'),
(366, 'message', 'airnotifier_provider_moodle_instantmessage_permitted', 'permitted'),
(367, 'message', 'airnotifier_provider_moodle_backup_permitted', 'permitted'),
(368, 'message', 'airnotifier_provider_moodle_courserequested_permitted', 'permitted'),
(369, 'message', 'airnotifier_provider_moodle_courserequestapproved_permitted', 'permitted'),
(370, 'message', 'message_provider_moodle_courserequestapproved_loggedin', 'email,airnotifier'),
(371, 'message', 'message_provider_moodle_courserequestapproved_loggedoff', 'email,airnotifier'),
(372, 'message', 'airnotifier_provider_moodle_courserequestrejected_permitted', 'permitted'),
(373, 'message', 'message_provider_moodle_courserequestrejected_loggedin', 'email,airnotifier'),
(374, 'message', 'message_provider_moodle_courserequestrejected_loggedoff', 'email,airnotifier'),
(375, 'message', 'airnotifier_provider_moodle_coursecompleted_permitted', 'permitted'),
(376, 'message', 'airnotifier_provider_moodle_badgerecipientnotice_permitted', 'permitted'),
(377, 'message', 'message_provider_moodle_badgerecipientnotice_loggedin', 'popup,airnotifier'),
(378, 'message', 'message_provider_moodle_badgerecipientnotice_loggedoff', 'popup,email,airnotifier'),
(379, 'message', 'airnotifier_provider_moodle_badgecreatornotice_permitted', 'permitted'),
(380, 'message', 'airnotifier_provider_moodle_competencyplancomment_permitted', 'permitted'),
(381, 'message', 'airnotifier_provider_moodle_competencyusercompcomment_permitted', 'permitted'),
(382, 'message', 'airnotifier_provider_moodle_insights_permitted', 'permitted'),
(383, 'message', 'message_provider_moodle_insights_loggedin', 'popup,airnotifier'),
(384, 'message', 'message_provider_moodle_insights_loggedoff', 'popup,email,airnotifier'),
(385, 'message', 'airnotifier_provider_moodle_messagecontactrequests_permitted', 'permitted'),
(386, 'message', 'message_provider_moodle_messagecontactrequests_loggedin', 'airnotifier'),
(387, 'message', 'message_provider_moodle_messagecontactrequests_loggedoff', 'email,airnotifier'),
(388, 'message', 'airnotifier_provider_moodle_asyncbackupnotification_permitted', 'permitted'),
(389, 'message', 'airnotifier_provider_moodle_gradenotifications_permitted', 'permitted'),
(390, 'message', 'airnotifier_provider_moodle_infected_permitted', 'permitted'),
(391, 'message_email', 'version', '2021051700'),
(393, 'message', 'email_provider_enrol_flatfile_flatfile_enrolment_permitted', 'permitted'),
(394, 'message', 'message_provider_enrol_flatfile_flatfile_enrolment_loggedin', 'email'),
(395, 'message', 'message_provider_enrol_flatfile_flatfile_enrolment_loggedoff', 'email'),
(396, 'message', 'email_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted', 'permitted'),
(397, 'message', 'message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedin', 'email'),
(398, 'message', 'message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedoff', 'email'),
(399, 'message', 'email_provider_enrol_manual_expiry_notification_permitted', 'permitted'),
(400, 'message', 'message_provider_enrol_manual_expiry_notification_loggedin', 'email'),
(401, 'message', 'message_provider_enrol_manual_expiry_notification_loggedoff', 'email'),
(402, 'message', 'email_provider_enrol_paypal_paypal_enrolment_permitted', 'permitted'),
(403, 'message', 'message_provider_enrol_paypal_paypal_enrolment_loggedin', 'email'),
(404, 'message', 'message_provider_enrol_paypal_paypal_enrolment_loggedoff', 'email'),
(405, 'message', 'email_provider_enrol_self_expiry_notification_permitted', 'permitted'),
(406, 'message', 'message_provider_enrol_self_expiry_notification_loggedin', 'email'),
(407, 'message', 'message_provider_enrol_self_expiry_notification_loggedoff', 'email'),
(408, 'message', 'email_provider_mod_assign_assign_notification_permitted', 'permitted'),
(409, 'message', 'message_provider_mod_assign_assign_notification_loggedin', 'email'),
(410, 'message', 'message_provider_mod_assign_assign_notification_loggedoff', 'email'),
(411, 'message', 'email_provider_mod_assignment_assignment_updates_permitted', 'permitted'),
(412, 'message', 'message_provider_mod_assignment_assignment_updates_loggedin', 'email'),
(413, 'message', 'message_provider_mod_assignment_assignment_updates_loggedoff', 'email'),
(414, 'message', 'email_provider_mod_feedback_submission_permitted', 'permitted'),
(415, 'message', 'message_provider_mod_feedback_submission_loggedin', 'email'),
(416, 'message', 'message_provider_mod_feedback_submission_loggedoff', 'email'),
(417, 'message', 'email_provider_mod_feedback_message_permitted', 'permitted'),
(418, 'message', 'message_provider_mod_feedback_message_loggedin', 'email'),
(419, 'message', 'message_provider_mod_feedback_message_loggedoff', 'email'),
(420, 'message', 'email_provider_mod_forum_posts_permitted', 'permitted'),
(421, 'message', 'email_provider_mod_forum_digests_permitted', 'permitted'),
(422, 'message', 'message_provider_mod_forum_digests_loggedin', 'email'),
(423, 'message', 'message_provider_mod_forum_digests_loggedoff', 'email'),
(424, 'message', 'email_provider_mod_lesson_graded_essay_permitted', 'permitted'),
(425, 'message', 'email_provider_mod_quiz_submission_permitted', 'permitted'),
(426, 'message', 'message_provider_mod_quiz_submission_loggedin', 'email'),
(427, 'message', 'message_provider_mod_quiz_submission_loggedoff', 'email'),
(428, 'message', 'email_provider_mod_quiz_confirmation_permitted', 'permitted'),
(429, 'message', 'email_provider_mod_quiz_attempt_overdue_permitted', 'permitted'),
(430, 'message', 'email_provider_moodle_notices_permitted', 'permitted'),
(431, 'message', 'message_provider_moodle_notices_loggedin', 'email'),
(432, 'message', 'message_provider_moodle_notices_loggedoff', 'email'),
(433, 'message', 'email_provider_moodle_errors_permitted', 'permitted'),
(434, 'message', 'message_provider_moodle_errors_loggedin', 'email'),
(435, 'message', 'message_provider_moodle_errors_loggedoff', 'email'),
(436, 'message', 'email_provider_moodle_availableupdate_permitted', 'permitted'),
(437, 'message', 'message_provider_moodle_availableupdate_loggedin', 'email'),
(438, 'message', 'message_provider_moodle_availableupdate_loggedoff', 'email'),
(439, 'message', 'email_provider_moodle_instantmessage_permitted', 'permitted'),
(440, 'message', 'message_provider_moodle_instantmessage_loggedoff', 'popup,email'),
(441, 'message', 'email_provider_moodle_backup_permitted', 'permitted'),
(442, 'message', 'message_provider_moodle_backup_loggedin', 'email'),
(443, 'message', 'message_provider_moodle_backup_loggedoff', 'email'),
(444, 'message', 'email_provider_moodle_courserequested_permitted', 'permitted'),
(445, 'message', 'message_provider_moodle_courserequested_loggedin', 'email'),
(446, 'message', 'message_provider_moodle_courserequested_loggedoff', 'email'),
(447, 'message', 'email_provider_moodle_courserequestapproved_permitted', 'permitted'),
(448, 'message', 'email_provider_moodle_courserequestrejected_permitted', 'permitted'),
(449, 'message', 'email_provider_moodle_coursecompleted_permitted', 'permitted'),
(450, 'message', 'message_provider_moodle_coursecompleted_loggedin', 'email'),
(451, 'message', 'message_provider_moodle_coursecompleted_loggedoff', 'email'),
(452, 'message', 'email_provider_moodle_badgerecipientnotice_permitted', 'permitted'),
(453, 'message', 'email_provider_moodle_badgecreatornotice_permitted', 'permitted'),
(454, 'message', 'message_provider_moodle_badgecreatornotice_loggedoff', 'email'),
(455, 'message', 'email_provider_moodle_competencyplancomment_permitted', 'permitted'),
(456, 'message', 'message_provider_moodle_competencyplancomment_loggedin', 'email'),
(457, 'message', 'message_provider_moodle_competencyplancomment_loggedoff', 'email'),
(458, 'message', 'email_provider_moodle_competencyusercompcomment_permitted', 'permitted'),
(459, 'message', 'message_provider_moodle_competencyusercompcomment_loggedin', 'email'),
(460, 'message', 'message_provider_moodle_competencyusercompcomment_loggedoff', 'email'),
(461, 'message', 'email_provider_moodle_insights_permitted', 'permitted'),
(462, 'message', 'email_provider_moodle_messagecontactrequests_permitted', 'permitted'),
(463, 'message', 'email_provider_moodle_asyncbackupnotification_permitted', 'permitted'),
(464, 'message', 'message_provider_moodle_asyncbackupnotification_loggedoff', 'popup,email'),
(465, 'message', 'email_provider_moodle_gradenotifications_permitted', 'permitted'),
(466, 'message', 'message_provider_moodle_gradenotifications_loggedoff', 'popup,email'),
(467, 'message', 'email_provider_moodle_infected_permitted', 'permitted'),
(468, 'message', 'message_provider_moodle_infected_loggedin', 'email'),
(469, 'message', 'message_provider_moodle_infected_loggedoff', 'email'),
(470, 'message_jabber', 'version', '2021051700'),
(472, 'message', 'jabber_provider_enrol_flatfile_flatfile_enrolment_permitted', 'permitted'),
(473, 'message', 'jabber_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted', 'permitted'),
(474, 'message', 'jabber_provider_enrol_manual_expiry_notification_permitted', 'permitted'),
(475, 'message', 'jabber_provider_enrol_paypal_paypal_enrolment_permitted', 'permitted'),
(476, 'message', 'jabber_provider_enrol_self_expiry_notification_permitted', 'permitted'),
(477, 'message', 'jabber_provider_mod_assign_assign_notification_permitted', 'permitted'),
(478, 'message', 'jabber_provider_mod_assignment_assignment_updates_permitted', 'permitted'),
(479, 'message', 'jabber_provider_mod_feedback_submission_permitted', 'permitted'),
(480, 'message', 'jabber_provider_mod_feedback_message_permitted', 'permitted'),
(481, 'message', 'jabber_provider_mod_forum_posts_permitted', 'permitted'),
(482, 'message', 'jabber_provider_mod_forum_digests_permitted', 'permitted'),
(483, 'message', 'jabber_provider_mod_lesson_graded_essay_permitted', 'permitted'),
(484, 'message', 'jabber_provider_mod_quiz_submission_permitted', 'permitted'),
(485, 'message', 'jabber_provider_mod_quiz_confirmation_permitted', 'permitted'),
(486, 'message', 'jabber_provider_mod_quiz_attempt_overdue_permitted', 'permitted'),
(487, 'message', 'jabber_provider_moodle_notices_permitted', 'permitted'),
(488, 'message', 'jabber_provider_moodle_errors_permitted', 'permitted'),
(489, 'message', 'jabber_provider_moodle_availableupdate_permitted', 'permitted'),
(490, 'message', 'jabber_provider_moodle_instantmessage_permitted', 'permitted'),
(491, 'message', 'jabber_provider_moodle_backup_permitted', 'permitted'),
(492, 'message', 'jabber_provider_moodle_courserequested_permitted', 'permitted'),
(493, 'message', 'jabber_provider_moodle_courserequestapproved_permitted', 'permitted'),
(494, 'message', 'jabber_provider_moodle_courserequestrejected_permitted', 'permitted'),
(495, 'message', 'jabber_provider_moodle_coursecompleted_permitted', 'permitted'),
(496, 'message', 'jabber_provider_moodle_badgerecipientnotice_permitted', 'permitted'),
(497, 'message', 'jabber_provider_moodle_badgecreatornotice_permitted', 'permitted'),
(498, 'message', 'jabber_provider_moodle_competencyplancomment_permitted', 'permitted'),
(499, 'message', 'jabber_provider_moodle_competencyusercompcomment_permitted', 'permitted'),
(500, 'message', 'jabber_provider_moodle_insights_permitted', 'permitted'),
(501, 'message', 'jabber_provider_moodle_messagecontactrequests_permitted', 'permitted'),
(502, 'message', 'jabber_provider_moodle_asyncbackupnotification_permitted', 'permitted'),
(503, 'message', 'jabber_provider_moodle_gradenotifications_permitted', 'permitted'),
(504, 'message', 'jabber_provider_moodle_infected_permitted', 'permitted'),
(505, 'message_popup', 'version', '2021051700'),
(507, 'message', 'popup_provider_enrol_flatfile_flatfile_enrolment_permitted', 'permitted'),
(508, 'message', 'popup_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted', 'permitted'),
(509, 'message', 'popup_provider_enrol_manual_expiry_notification_permitted', 'permitted'),
(510, 'message', 'popup_provider_enrol_paypal_paypal_enrolment_permitted', 'permitted'),
(511, 'message', 'popup_provider_enrol_self_expiry_notification_permitted', 'permitted'),
(512, 'message', 'popup_provider_mod_assign_assign_notification_permitted', 'permitted'),
(513, 'message', 'popup_provider_mod_assignment_assignment_updates_permitted', 'permitted'),
(514, 'message', 'popup_provider_mod_feedback_submission_permitted', 'permitted'),
(515, 'message', 'popup_provider_mod_feedback_message_permitted', 'permitted'),
(516, 'message', 'popup_provider_mod_forum_posts_permitted', 'permitted'),
(517, 'message', 'popup_provider_mod_forum_digests_permitted', 'permitted'),
(518, 'message', 'popup_provider_mod_lesson_graded_essay_permitted', 'permitted'),
(519, 'message', 'popup_provider_mod_quiz_submission_permitted', 'permitted'),
(520, 'message', 'popup_provider_mod_quiz_confirmation_permitted', 'permitted'),
(521, 'message', 'popup_provider_mod_quiz_attempt_overdue_permitted', 'permitted'),
(522, 'message', 'popup_provider_moodle_notices_permitted', 'permitted'),
(523, 'message', 'popup_provider_moodle_errors_permitted', 'permitted'),
(524, 'message', 'popup_provider_moodle_availableupdate_permitted', 'permitted'),
(525, 'message', 'popup_provider_moodle_instantmessage_permitted', 'permitted'),
(526, 'message', 'message_provider_moodle_instantmessage_loggedin', 'popup'),
(527, 'message', 'popup_provider_moodle_backup_permitted', 'permitted'),
(528, 'message', 'popup_provider_moodle_courserequested_permitted', 'permitted'),
(529, 'message', 'popup_provider_moodle_courserequestapproved_permitted', 'permitted'),
(530, 'message', 'popup_provider_moodle_courserequestrejected_permitted', 'permitted'),
(531, 'message', 'popup_provider_moodle_coursecompleted_permitted', 'permitted'),
(532, 'message', 'popup_provider_moodle_badgerecipientnotice_permitted', 'permitted'),
(533, 'message', 'popup_provider_moodle_badgecreatornotice_permitted', 'permitted'),
(534, 'message', 'popup_provider_moodle_competencyplancomment_permitted', 'permitted'),
(535, 'message', 'popup_provider_moodle_competencyusercompcomment_permitted', 'permitted'),
(536, 'message', 'popup_provider_moodle_insights_permitted', 'permitted'),
(537, 'message', 'popup_provider_moodle_messagecontactrequests_permitted', 'permitted'),
(538, 'message', 'popup_provider_moodle_asyncbackupnotification_permitted', 'permitted'),
(539, 'message', 'message_provider_moodle_asyncbackupnotification_loggedin', 'popup'),
(540, 'message', 'popup_provider_moodle_gradenotifications_permitted', 'permitted'),
(541, 'message', 'message_provider_moodle_gradenotifications_loggedin', 'popup'),
(542, 'message', 'popup_provider_moodle_infected_permitted', 'permitted'),
(543, 'block_accessreview', 'version', '2021051700'),
(544, 'block_activity_modules', 'version', '2021051700'),
(545, 'block_activity_results', 'version', '2021051700'),
(546, 'block_admin_bookmarks', 'version', '2021051700'),
(547, 'block_badges', 'version', '2021051700'),
(548, 'block_blog_menu', 'version', '2021051700'),
(549, 'block_blog_recent', 'version', '2021051700'),
(550, 'block_blog_tags', 'version', '2021051700'),
(551, 'block_calendar_month', 'version', '2021051700'),
(552, 'block_calendar_upcoming', 'version', '2021051700'),
(553, 'block_comments', 'version', '2021051700'),
(554, 'block_completionstatus', 'version', '2021051700'),
(555, 'block_course_list', 'version', '2021051700'),
(556, 'block_course_summary', 'version', '2021051700'),
(557, 'block_feedback', 'version', '2021051700'),
(559, 'block_globalsearch', 'version', '2021051700'),
(560, 'block_glossary_random', 'version', '2021051700'),
(561, 'block_html', 'version', '2021051700'),
(562, 'block_login', 'version', '2021051700'),
(563, 'block_lp', 'version', '2021051700'),
(564, 'block_mentees', 'version', '2021051700'),
(565, 'block_mnet_hosts', 'version', '2021051700'),
(566, 'block_myoverview', 'version', '2021051700'),
(567, 'block_myprofile', 'version', '2021051700'),
(568, 'block_navigation', 'version', '2021051700'),
(569, 'block_news_items', 'version', '2021051700'),
(570, 'block_online_users', 'version', '2021051700'),
(571, 'block_private_files', 'version', '2021051700'),
(572, 'block_quiz_results', 'version', '2021051700'),
(574, 'block_recent_activity', 'version', '2021051700'),
(575, 'block_recentlyaccessedcourses', 'version', '2021051700'),
(577, 'block_recentlyaccesseditems', 'version', '2021051700'),
(578, 'block_rss_client', 'version', '2021051700'),
(579, 'block_search_forums', 'version', '2021051700'),
(580, 'block_section_links', 'version', '2021051700'),
(581, 'block_selfcompletion', 'version', '2021051700'),
(582, 'block_settings', 'version', '2021051700'),
(583, 'block_site_main_menu', 'version', '2021051700'),
(584, 'block_social_activities', 'version', '2021051700'),
(585, 'block_starredcourses', 'version', '2021051700'),
(586, 'block_tag_flickr', 'version', '2021051700'),
(587, 'block_tag_youtube', 'version', '2021051700'),
(589, 'block_tags', 'version', '2021051700'),
(590, 'block_timeline', 'version', '2021051700'),
(592, 'media_html5audio', 'version', '2021051700'),
(593, 'media_html5video', 'version', '2021051700'),
(594, 'media_swf', 'version', '2021051700'),
(595, 'media_videojs', 'version', '2021051700'),
(596, 'media_vimeo', 'version', '2021051700'),
(597, 'media_youtube', 'version', '2021051700'),
(598, 'filter_activitynames', 'version', '2021051700'),
(600, 'filter_algebra', 'version', '2021051700'),
(601, 'filter_censor', 'version', '2021051700'),
(602, 'filter_data', 'version', '2021051700'),
(604, 'filter_displayh5p', 'version', '2021051700'),
(606, 'filter_emailprotect', 'version', '2021051700'),
(607, 'filter_emoticon', 'version', '2021051700'),
(609, 'filter_glossary', 'version', '2021051700'),
(611, 'filter_mathjaxloader', 'version', '2021051700'),
(613, 'filter_mediaplugin', 'version', '2021051700'),
(615, 'filter_multilang', 'version', '2021051700'),
(616, 'filter_tex', 'version', '2021051700'),
(618, 'filter_tidy', 'version', '2021051700'),
(619, 'filter_urltolink', 'version', '2021051700'),
(621, 'editor_atto', 'version', '2021051700'),
(623, 'editor_textarea', 'version', '2021051700'),
(624, 'editor_tinymce', 'version', '2021051700'),
(625, 'format_singleactivity', 'version', '2021051700'),
(626, 'format_social', 'version', '2021051700'),
(627, 'format_topics', 'version', '2021051700'),
(628, 'format_weeks', 'version', '2021051700'),
(629, 'dataformat_csv', 'version', '2021051700'),
(630, 'dataformat_excel', 'version', '2021051700'),
(631, 'dataformat_html', 'version', '2021051700'),
(632, 'dataformat_json', 'version', '2021051700'),
(633, 'dataformat_ods', 'version', '2021051700'),
(634, 'dataformat_pdf', 'version', '2021051700'),
(635, 'profilefield_checkbox', 'version', '2021051700'),
(636, 'profilefield_datetime', 'version', '2021051700'),
(637, 'profilefield_menu', 'version', '2021051700'),
(638, 'profilefield_social', 'version', '2021051700'),
(639, 'profilefield_text', 'version', '2021051700'),
(640, 'profilefield_textarea', 'version', '2021051700'),
(641, 'report_backups', 'version', '2021051700'),
(642, 'report_competency', 'version', '2021051700'),
(643, 'report_completion', 'version', '2021051700'),
(645, 'report_configlog', 'version', '2021051700'),
(646, 'report_courseoverview', 'version', '2021051700'),
(647, 'report_eventlist', 'version', '2021051700'),
(648, 'report_infectedfiles', 'version', '2021051700'),
(649, 'report_insights', 'version', '2021051700'),
(650, 'report_log', 'version', '2021051700'),
(652, 'report_loglive', 'version', '2021051700'),
(653, 'report_outline', 'version', '2021051700'),
(655, 'report_participation', 'version', '2021051700'),
(657, 'report_performance', 'version', '2021051700'),
(658, 'report_progress', 'version', '2021051700'),
(660, 'report_questioninstances', 'version', '2021051700'),
(661, 'report_security', 'version', '2021051700'),
(662, 'report_stats', 'version', '2021051700'),
(664, 'report_status', 'version', '2021051700'),
(665, 'report_usersessions', 'version', '2021051700'),
(666, 'gradeexport_ods', 'version', '2021051700'),
(667, 'gradeexport_txt', 'version', '2021051700'),
(668, 'gradeexport_xls', 'version', '2021051700'),
(669, 'gradeexport_xml', 'version', '2021051700'),
(670, 'gradeimport_csv', 'version', '2021051700'),
(671, 'gradeimport_direct', 'version', '2021051700'),
(672, 'gradeimport_xml', 'version', '2021051700'),
(673, 'gradereport_grader', 'version', '2021051700'),
(674, 'gradereport_history', 'version', '2021051700'),
(675, 'gradereport_outcomes', 'version', '2021051700'),
(676, 'gradereport_overview', 'version', '2021051700'),
(677, 'gradereport_singleview', 'version', '2021051700'),
(678, 'gradereport_user', 'version', '2021051700'),
(679, 'gradingform_guide', 'version', '2021051700'),
(680, 'gradingform_rubric', 'version', '2021051700'),
(681, 'mlbackend_php', 'version', '2021051700'),
(682, 'mlbackend_python', 'version', '2021051700'),
(683, 'mnetservice_enrol', 'version', '2021051700'),
(684, 'webservice_rest', 'version', '2021051700'),
(685, 'webservice_soap', 'version', '2021051700'),
(686, 'webservice_xmlrpc', 'version', '2021051700'),
(687, 'repository_areafiles', 'version', '2021051700'),
(689, 'areafiles', 'enablecourseinstances', '0'),
(690, 'areafiles', 'enableuserinstances', '0'),
(691, 'repository_boxnet', 'version', '2021051700'),
(692, 'repository_contentbank', 'version', '2021051700'),
(694, 'contentbank', 'enablecourseinstances', '0'),
(695, 'contentbank', 'enableuserinstances', '0'),
(696, 'repository_coursefiles', 'version', '2021051700'),
(697, 'repository_dropbox', 'version', '2021051700'),
(698, 'repository_equella', 'version', '2021051700'),
(699, 'repository_filesystem', 'version', '2021051700'),
(700, 'repository_flickr', 'version', '2021051700'),
(701, 'repository_flickr_public', 'version', '2021051700'),
(702, 'repository_googledocs', 'version', '2021051700'),
(703, 'repository_local', 'version', '2021051700'),
(705, 'local', 'enablecourseinstances', '0'),
(706, 'local', 'enableuserinstances', '0'),
(707, 'repository_merlot', 'version', '2021051700'),
(708, 'repository_nextcloud', 'version', '2021051700'),
(709, 'repository_onedrive', 'version', '2021051700'),
(710, 'repository_picasa', 'version', '2021051700'),
(711, 'repository_recent', 'version', '2021051700'),
(713, 'recent', 'enablecourseinstances', '0'),
(714, 'recent', 'enableuserinstances', '0'),
(715, 'repository_s3', 'version', '2021051700'),
(716, 'repository_skydrive', 'version', '2021051700'),
(717, 'repository_upload', 'version', '2021051700'),
(719, 'upload', 'enablecourseinstances', '0'),
(720, 'upload', 'enableuserinstances', '0'),
(721, 'repository_url', 'version', '2021051700'),
(723, 'url', 'enablecourseinstances', '0'),
(724, 'url', 'enableuserinstances', '0'),
(725, 'repository_user', 'version', '2021051700'),
(727, 'user', 'enablecourseinstances', '0'),
(728, 'user', 'enableuserinstances', '0'),
(729, 'repository_webdav', 'version', '2021051700'),
(730, 'repository_wikimedia', 'version', '2021051700'),
(732, 'wikimedia', 'enablecourseinstances', '0'),
(733, 'wikimedia', 'enableuserinstances', '0'),
(734, 'repository_youtube', 'version', '2021051700'),
(736, 'portfolio_boxnet', 'version', '2021051700'),
(737, 'portfolio_download', 'version', '2021051700'),
(738, 'portfolio_flickr', 'version', '2021051700'),
(739, 'portfolio_googledocs', 'version', '2021051700'),
(740, 'portfolio_mahara', 'version', '2021051700'),
(741, 'portfolio_picasa', 'version', '2021051700'),
(742, 'search_simpledb', 'version', '2021051700'),
(744, 'search_solr', 'version', '2021051700'),
(745, 'qbehaviour_adaptive', 'version', '2021051700'),
(746, 'qbehaviour_adaptivenopenalty', 'version', '2021051700'),
(747, 'qbehaviour_deferredcbm', 'version', '2021051700'),
(748, 'qbehaviour_deferredfeedback', 'version', '2021051700'),
(749, 'qbehaviour_immediatecbm', 'version', '2021051700'),
(750, 'qbehaviour_immediatefeedback', 'version', '2021051700'),
(751, 'qbehaviour_informationitem', 'version', '2021051700'),
(752, 'qbehaviour_interactive', 'version', '2021051700'),
(753, 'qbehaviour_interactivecountback', 'version', '2021051700'),
(754, 'qbehaviour_manualgraded', 'version', '2021051700'),
(756, 'question', 'disabledbehaviours', 'manualgraded'),
(757, 'qbehaviour_missing', 'version', '2021051700'),
(758, 'qformat_aiken', 'version', '2021051700'),
(759, 'qformat_blackboard_six', 'version', '2021051700'),
(760, 'qformat_examview', 'version', '2021051700'),
(761, 'qformat_gift', 'version', '2021051700'),
(762, 'qformat_missingword', 'version', '2021051700'),
(763, 'qformat_multianswer', 'version', '2021051700'),
(764, 'qformat_webct', 'version', '2021051700'),
(765, 'qformat_xhtml', 'version', '2021051700'),
(766, 'qformat_xml', 'version', '2021051700'),
(767, 'tool_analytics', 'version', '2021051700'),
(768, 'tool_availabilityconditions', 'version', '2021051700'),
(769, 'tool_behat', 'version', '2021051701'),
(770, 'tool_brickfield', 'version', '2021051700'),
(772, 'tool_capability', 'version', '2021051700'),
(773, 'tool_cohortroles', 'version', '2021051700'),
(774, 'tool_customlang', 'version', '2021051700'),
(776, 'tool_dataprivacy', 'version', '2021051700'),
(777, 'message', 'airnotifier_provider_tool_dataprivacy_contactdataprotectionofficer_permitted', 'permitted'),
(778, 'message', 'email_provider_tool_dataprivacy_contactdataprotectionofficer_permitted', 'permitted'),
(779, 'message', 'jabber_provider_tool_dataprivacy_contactdataprotectionofficer_permitted', 'permitted'),
(780, 'message', 'popup_provider_tool_dataprivacy_contactdataprotectionofficer_permitted', 'permitted'),
(781, 'message', 'message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedin', 'email,popup'),
(782, 'message', 'message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedoff', 'email,popup'),
(783, 'message', 'airnotifier_provider_tool_dataprivacy_datarequestprocessingresults_permitted', 'permitted'),
(784, 'message', 'email_provider_tool_dataprivacy_datarequestprocessingresults_permitted', 'permitted'),
(785, 'message', 'jabber_provider_tool_dataprivacy_datarequestprocessingresults_permitted', 'permitted'),
(786, 'message', 'popup_provider_tool_dataprivacy_datarequestprocessingresults_permitted', 'permitted'),
(787, 'message', 'message_provider_tool_dataprivacy_datarequestprocessingresults_loggedin', 'email,popup'),
(788, 'message', 'message_provider_tool_dataprivacy_datarequestprocessingresults_loggedoff', 'email,popup'),
(789, 'message', 'airnotifier_provider_tool_dataprivacy_notifyexceptions_permitted', 'permitted'),
(790, 'message', 'email_provider_tool_dataprivacy_notifyexceptions_permitted', 'permitted'),
(791, 'message', 'jabber_provider_tool_dataprivacy_notifyexceptions_permitted', 'permitted'),
(792, 'message', 'popup_provider_tool_dataprivacy_notifyexceptions_permitted', 'permitted'),
(793, 'message', 'message_provider_tool_dataprivacy_notifyexceptions_loggedin', 'email'),
(794, 'message', 'message_provider_tool_dataprivacy_notifyexceptions_loggedoff', 'email'),
(795, 'tool_dbtransfer', 'version', '2021051700'),
(796, 'tool_filetypes', 'version', '2021051700'),
(797, 'tool_generator', 'version', '2021051700'),
(798, 'tool_health', 'version', '2021051700'),
(799, 'tool_httpsreplace', 'version', '2021051700'),
(800, 'tool_innodb', 'version', '2021051700'),
(801, 'tool_installaddon', 'version', '2021051700'),
(802, 'tool_langimport', 'version', '2021051700'),
(803, 'tool_licensemanager', 'version', '2021051700'),
(804, 'tool_log', 'version', '2021051700'),
(806, 'tool_log', 'enabled_stores', 'logstore_standard'),
(807, 'tool_lp', 'version', '2021051700'),
(808, 'tool_lpimportcsv', 'version', '2021051700'),
(809, 'tool_lpmigrate', 'version', '2021051700'),
(810, 'tool_messageinbound', 'version', '2021051700'),
(811, 'message', 'airnotifier_provider_tool_messageinbound_invalidrecipienthandler_permitted', 'permitted'),
(812, 'message', 'email_provider_tool_messageinbound_invalidrecipienthandler_permitted', 'permitted'),
(813, 'message', 'jabber_provider_tool_messageinbound_invalidrecipienthandler_permitted', 'permitted'),
(814, 'message', 'popup_provider_tool_messageinbound_invalidrecipienthandler_permitted', 'permitted'),
(815, 'message', 'message_provider_tool_messageinbound_invalidrecipienthandler_loggedin', 'email'),
(816, 'message', 'message_provider_tool_messageinbound_invalidrecipienthandler_loggedoff', 'email'),
(817, 'message', 'airnotifier_provider_tool_messageinbound_messageprocessingerror_permitted', 'permitted'),
(818, 'message', 'email_provider_tool_messageinbound_messageprocessingerror_permitted', 'permitted'),
(819, 'message', 'jabber_provider_tool_messageinbound_messageprocessingerror_permitted', 'permitted'),
(820, 'message', 'popup_provider_tool_messageinbound_messageprocessingerror_permitted', 'permitted'),
(821, 'message', 'message_provider_tool_messageinbound_messageprocessingerror_loggedin', 'email'),
(822, 'message', 'message_provider_tool_messageinbound_messageprocessingerror_loggedoff', 'email'),
(823, 'message', 'airnotifier_provider_tool_messageinbound_messageprocessingsuccess_permitted', 'permitted'),
(824, 'message', 'email_provider_tool_messageinbound_messageprocessingsuccess_permitted', 'permitted'),
(825, 'message', 'jabber_provider_tool_messageinbound_messageprocessingsuccess_permitted', 'permitted'),
(826, 'message', 'popup_provider_tool_messageinbound_messageprocessingsuccess_permitted', 'permitted'),
(827, 'message', 'message_provider_tool_messageinbound_messageprocessingsuccess_loggedin', 'email'),
(828, 'message', 'message_provider_tool_messageinbound_messageprocessingsuccess_loggedoff', 'email'),
(829, 'tool_mobile', 'version', '2021051700'),
(830, 'tool_monitor', 'version', '2021051700'),
(831, 'message', 'airnotifier_provider_tool_monitor_notification_permitted', 'permitted'),
(832, 'message', 'email_provider_tool_monitor_notification_permitted', 'permitted'),
(833, 'message', 'jabber_provider_tool_monitor_notification_permitted', 'permitted'),
(834, 'message', 'popup_provider_tool_monitor_notification_permitted', 'permitted'),
(835, 'message', 'message_provider_tool_monitor_notification_loggedin', 'email'),
(836, 'message', 'message_provider_tool_monitor_notification_loggedoff', 'email'),
(837, 'tool_moodlenet', 'version', '2021051701'),
(838, 'tool_multilangupgrade', 'version', '2021051700'),
(839, 'tool_oauth2', 'version', '2021051700'),
(840, 'tool_phpunit', 'version', '2021051700'),
(841, 'tool_policy', 'version', '2021051700'),
(842, 'tool_profiling', 'version', '2021051700'),
(843, 'tool_recyclebin', 'version', '2021051700'),
(844, 'tool_replace', 'version', '2021051700'),
(845, 'tool_spamcleaner', 'version', '2021051700'),
(846, 'tool_task', 'version', '2021051700'),
(847, 'tool_templatelibrary', 'version', '2021051700'),
(848, 'tool_unsuproles', 'version', '2021051700'),
(850, 'tool_uploadcourse', 'version', '2021051700'),
(851, 'tool_uploaduser', 'version', '2021051700'),
(852, 'tool_usertours', 'version', '2021051700'),
(854, 'tool_xmldb', 'version', '2021051700'),
(855, 'cachestore_apcu', 'version', '2021051700'),
(856, 'cachestore_file', 'version', '2021051700'),
(857, 'cachestore_memcached', 'version', '2021051700'),
(858, 'cachestore_mongodb', 'version', '2021051700');
INSERT INTO `[[dbprefix]]config_plugins` VALUES
(859, 'cachestore_redis', 'version', '2021051700'),
(860, 'cachestore_session', 'version', '2021051700'),
(861, 'cachestore_static', 'version', '2021051700'),
(862, 'cachelock_file', 'version', '2021051700'),
(863, 'fileconverter_googledrive', 'version', '2021051700'),
(864, 'fileconverter_unoconv', 'version', '2021051700'),
(866, 'contenttype_h5p', 'version', '2021051700'),
(867, 'theme_boost', 'version', '2021051700'),
(868, 'theme_classic', 'version', '2021051700'),
(869, 'h5plib_v124', 'version', '2021051700'),
(870, 'paygw_paypal', 'version', '2021051700'),
(872, 'assignsubmission_comments', 'version', '2021051700'),
(874, 'assignsubmission_file', 'sortorder', '1'),
(875, 'assignsubmission_comments', 'sortorder', '2'),
(876, 'assignsubmission_onlinetext', 'sortorder', '0'),
(877, 'assignsubmission_file', 'version', '2021051700'),
(878, 'assignsubmission_onlinetext', 'version', '2021051700'),
(880, 'assignfeedback_comments', 'version', '2021051700'),
(882, 'assignfeedback_comments', 'sortorder', '0'),
(883, 'assignfeedback_editpdf', 'sortorder', '1'),
(884, 'assignfeedback_file', 'sortorder', '3'),
(885, 'assignfeedback_offline', 'sortorder', '2'),
(886, 'assignfeedback_editpdf', 'version', '2021051702'),
(888, 'assignfeedback_file', 'version', '2021051700'),
(890, 'assignfeedback_offline', 'version', '2021051700'),
(891, 'assignment_offline', 'version', '2021051700'),
(892, 'assignment_online', 'version', '2021051700'),
(893, 'assignment_upload', 'version', '2021051700'),
(894, 'assignment_uploadsingle', 'version', '2021051700'),
(895, 'booktool_exportimscp', 'version', '2021051700'),
(896, 'booktool_importhtml', 'version', '2021051700'),
(897, 'booktool_print', 'version', '2021051700'),
(898, 'datafield_checkbox', 'version', '2021051700'),
(899, 'datafield_date', 'version', '2021051700'),
(900, 'datafield_file', 'version', '2021051700'),
(901, 'datafield_latlong', 'version', '2021051700'),
(902, 'datafield_menu', 'version', '2021051700'),
(903, 'datafield_multimenu', 'version', '2021051700'),
(904, 'datafield_number', 'version', '2021051700'),
(905, 'datafield_picture', 'version', '2021051700'),
(906, 'datafield_radiobutton', 'version', '2021051700'),
(907, 'datafield_text', 'version', '2021051700'),
(908, 'datafield_textarea', 'version', '2021051700'),
(909, 'datafield_url', 'version', '2021051700'),
(910, 'datapreset_imagegallery', 'version', '2021051700'),
(911, 'forumreport_summary', 'version', '2021051700'),
(912, 'ltiservice_basicoutcomes', 'version', '2021051700'),
(913, 'ltiservice_gradebookservices', 'version', '2021051700'),
(914, 'ltiservice_memberships', 'version', '2021051700'),
(915, 'ltiservice_profile', 'version', '2021051700'),
(916, 'ltiservice_toolproxy', 'version', '2021051700'),
(917, 'ltiservice_toolsettings', 'version', '2021051700'),
(918, 'quiz_grading', 'version', '2021051700'),
(920, 'quiz_overview', 'version', '2021051700'),
(922, 'quiz_responses', 'version', '2021051700'),
(924, 'quiz_statistics', 'version', '2021051700'),
(926, 'quizaccess_delaybetweenattempts', 'version', '2021051700'),
(927, 'quizaccess_ipaddress', 'version', '2021051700'),
(928, 'quizaccess_numattempts', 'version', '2021051700'),
(929, 'quizaccess_offlineattempts', 'version', '2021051700'),
(930, 'quizaccess_openclosedate', 'version', '2021051700'),
(931, 'quizaccess_password', 'version', '2021051700'),
(932, 'quizaccess_seb', 'version', '2021051700'),
(934, 'quizaccess_securewindow', 'version', '2021051700'),
(935, 'quizaccess_timelimit', 'version', '2021051700'),
(936, 'scormreport_basic', 'version', '2021051700'),
(937, 'scormreport_graphs', 'version', '2021051700'),
(938, 'scormreport_interactions', 'version', '2021051700'),
(939, 'scormreport_objectives', 'version', '2021051700'),
(940, 'workshopform_accumulative', 'version', '2021051700'),
(942, 'workshopform_comments', 'version', '2021051700'),
(944, 'workshopform_numerrors', 'version', '2021051700'),
(946, 'workshopform_rubric', 'version', '2021051700'),
(948, 'workshopallocation_manual', 'version', '2021051700'),
(949, 'workshopallocation_random', 'version', '2021051700'),
(950, 'workshopallocation_scheduled', 'version', '2021051700'),
(951, 'workshopeval_best', 'version', '2021051700'),
(952, 'atto_accessibilitychecker', 'version', '2021051700'),
(953, 'atto_accessibilityhelper', 'version', '2021051700'),
(954, 'atto_align', 'version', '2021051700'),
(955, 'atto_backcolor', 'version', '2021051700'),
(956, 'atto_bold', 'version', '2021051700'),
(957, 'atto_charmap', 'version', '2021051700'),
(958, 'atto_clear', 'version', '2021051700'),
(959, 'atto_collapse', 'version', '2021051700'),
(960, 'atto_emojipicker', 'version', '2021051700'),
(961, 'atto_emoticon', 'version', '2021051700'),
(962, 'atto_equation', 'version', '2021051701'),
(963, 'atto_fontcolor', 'version', '2021051700'),
(964, 'atto_h5p', 'version', '2021051700'),
(965, 'atto_html', 'version', '2021051700'),
(966, 'atto_image', 'version', '2021051700'),
(967, 'atto_indent', 'version', '2021051700'),
(968, 'atto_italic', 'version', '2021051700'),
(969, 'atto_link', 'version', '2021051700'),
(970, 'atto_managefiles', 'version', '2021051700'),
(971, 'atto_media', 'version', '2021051700'),
(972, 'atto_noautolink', 'version', '2021051700'),
(973, 'atto_orderedlist', 'version', '2021051700'),
(974, 'atto_recordrtc', 'version', '2021051700'),
(975, 'atto_rtl', 'version', '2021051700'),
(976, 'atto_strike', 'version', '2021051700'),
(977, 'atto_subscript', 'version', '2021051700'),
(978, 'atto_superscript', 'version', '2021051700'),
(979, 'atto_table', 'version', '2021051700'),
(980, 'atto_title', 'version', '2021051700'),
(981, 'atto_underline', 'version', '2021051700'),
(982, 'atto_undo', 'version', '2021051700'),
(983, 'atto_unorderedlist', 'version', '2021051700'),
(984, 'tinymce_ctrlhelp', 'version', '2021051700'),
(985, 'tinymce_managefiles', 'version', '2021051700'),
(986, 'tinymce_moodleemoticon', 'version', '2021051700'),
(987, 'tinymce_moodleimage', 'version', '2021051700'),
(988, 'tinymce_moodlemedia', 'version', '2021051700'),
(989, 'tinymce_moodlenolink', 'version', '2021051700'),
(990, 'tinymce_pdw', 'version', '2021051700'),
(991, 'tinymce_spellchecker', 'version', '2021051700'),
(993, 'tinymce_wrap', 'version', '2021051700'),
(994, 'logstore_database', 'version', '2021051700'),
(995, 'logstore_legacy', 'version', '2021051700'),
(996, 'logstore_standard', 'version', '2021051700'),
(997, 'tool_dataprivacy', 'contactdataprotectionofficer', '0'),
(998, 'tool_dataprivacy', 'automaticdataexportapproval', '0'),
(999, 'tool_dataprivacy', 'automaticdatadeletionapproval', '0'),
(1000, 'tool_dataprivacy', 'automaticdeletionrequests', '1'),
(1001, 'tool_dataprivacy', 'privacyrequestexpiry', '604800'),
(1002, 'tool_dataprivacy', 'requireallenddatesforuserdeletion', '1'),
(1003, 'tool_dataprivacy', 'showdataretentionsummary', '1'),
(1004, 'tool_log', 'exportlog', '1'),
(1005, 'analytics', 'logstore', 'logstore_standard'),
(1006, 'assign', 'feedback_plugin_for_gradebook', 'assignfeedback_comments'),
(1007, 'assign', 'showrecentsubmissions', '0'),
(1008, 'assign', 'submissionreceipts', '1'),
(1009, 'assign', 'submissionstatement', 'This submission is my own work, except where I have acknowledged the use of the works of other people.'),
(1010, 'assign', 'submissionstatementteamsubmission', 'This submission is the work of my group, except where we have acknowledged the use of the works of other people.'),
(1011, 'assign', 'submissionstatementteamsubmissionallsubmit', 'This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.'),
(1012, 'assign', 'maxperpage', '-1'),
(1013, 'assign', 'alwaysshowdescription', '1'),
(1014, 'assign', 'alwaysshowdescription_adv', ''),
(1015, 'assign', 'alwaysshowdescription_locked', ''),
(1016, 'assign', 'allowsubmissionsfromdate', '0'),
(1017, 'assign', 'allowsubmissionsfromdate_enabled', '1'),
(1018, 'assign', 'allowsubmissionsfromdate_adv', ''),
(1019, 'assign', 'duedate', '604800'),
(1020, 'assign', 'duedate_enabled', '1'),
(1021, 'assign', 'duedate_adv', ''),
(1022, 'assign', 'cutoffdate', '1209600'),
(1023, 'assign', 'cutoffdate_enabled', ''),
(1024, 'assign', 'cutoffdate_adv', ''),
(1025, 'assign', 'gradingduedate', '1209600'),
(1026, 'assign', 'gradingduedate_enabled', '1'),
(1027, 'assign', 'gradingduedate_adv', ''),
(1028, 'assign', 'submissiondrafts', '0'),
(1029, 'assign', 'submissiondrafts_adv', ''),
(1030, 'assign', 'submissiondrafts_locked', ''),
(1031, 'assign', 'requiresubmissionstatement', '0'),
(1032, 'assign', 'requiresubmissionstatement_adv', ''),
(1033, 'assign', 'requiresubmissionstatement_locked', ''),
(1034, 'assign', 'attemptreopenmethod', 'none'),
(1035, 'assign', 'attemptreopenmethod_adv', ''),
(1036, 'assign', 'attemptreopenmethod_locked', ''),
(1037, 'assign', 'maxattempts', '-1'),
(1038, 'assign', 'maxattempts_adv', ''),
(1039, 'assign', 'maxattempts_locked', ''),
(1040, 'assign', 'teamsubmission', '0'),
(1041, 'assign', 'teamsubmission_adv', ''),
(1042, 'assign', 'teamsubmission_locked', ''),
(1043, 'assign', 'preventsubmissionnotingroup', '0'),
(1044, 'assign', 'preventsubmissionnotingroup_adv', ''),
(1045, 'assign', 'preventsubmissionnotingroup_locked', ''),
(1046, 'assign', 'requireallteammemberssubmit', '0'),
(1047, 'assign', 'requireallteammemberssubmit_adv', ''),
(1048, 'assign', 'requireallteammemberssubmit_locked', ''),
(1049, 'assign', 'teamsubmissiongroupingid', ''),
(1050, 'assign', 'teamsubmissiongroupingid_adv', ''),
(1051, 'assign', 'sendnotifications', '0'),
(1052, 'assign', 'sendnotifications_adv', ''),
(1053, 'assign', 'sendnotifications_locked', ''),
(1054, 'assign', 'sendlatenotifications', '0'),
(1055, 'assign', 'sendlatenotifications_adv', ''),
(1056, 'assign', 'sendlatenotifications_locked', ''),
(1057, 'assign', 'sendstudentnotifications', '1'),
(1058, 'assign', 'sendstudentnotifications_adv', ''),
(1059, 'assign', 'sendstudentnotifications_locked', ''),
(1060, 'assign', 'blindmarking', '0'),
(1061, 'assign', 'blindmarking_adv', ''),
(1062, 'assign', 'blindmarking_locked', ''),
(1063, 'assign', 'hidegrader', '0'),
(1064, 'assign', 'hidegrader_adv', ''),
(1065, 'assign', 'hidegrader_locked', ''),
(1066, 'assign', 'markingworkflow', '0'),
(1067, 'assign', 'markingworkflow_adv', ''),
(1068, 'assign', 'markingworkflow_locked', ''),
(1069, 'assign', 'markingallocation', '0'),
(1070, 'assign', 'markingallocation_adv', ''),
(1071, 'assign', 'markingallocation_locked', ''),
(1072, 'assignsubmission_file', 'default', '1'),
(1073, 'assignsubmission_file', 'maxfiles', '20'),
(1074, 'assignsubmission_file', 'filetypes', ''),
(1075, 'assignsubmission_file', 'maxbytes', '0'),
(1076, 'assignsubmission_onlinetext', 'default', '0'),
(1077, 'assignfeedback_comments', 'default', '1'),
(1078, 'assignfeedback_comments', 'inline', '0'),
(1079, 'assignfeedback_comments', 'inline_adv', ''),
(1080, 'assignfeedback_comments', 'inline_locked', ''),
(1081, 'assignfeedback_editpdf', 'default', '1'),
(1082, 'assignfeedback_editpdf', 'stamps', ''),
(1083, 'assignfeedback_file', 'default', '0'),
(1084, 'assignfeedback_offline', 'default', '0'),
(1085, 'book', 'numberingoptions', '0,1,2,3'),
(1086, 'book', 'navoptions', '0,1,2'),
(1087, 'book', 'numbering', '1'),
(1088, 'book', 'navstyle', '1'),
(1089, 'resource', 'framesize', '130'),
(1090, 'resource', 'displayoptions', '0,1,4,5,6'),
(1091, 'resource', 'printintro', '1'),
(1092, 'resource', 'display', '0'),
(1093, 'resource', 'showsize', '0'),
(1094, 'resource', 'showtype', '0'),
(1095, 'resource', 'showdate', '0'),
(1096, 'resource', 'popupwidth', '620'),
(1097, 'resource', 'popupheight', '450'),
(1098, 'resource', 'filterfiles', '0'),
(1099, 'folder', 'showexpanded', '1'),
(1100, 'folder', 'maxsizetodownload', '0'),
(1101, 'imscp', 'keepold', '1'),
(1102, 'imscp', 'keepold_adv', ''),
(1103, 'label', 'dndmedia', '1'),
(1104, 'label', 'dndresizewidth', '400'),
(1105, 'label', 'dndresizeheight', '400'),
(1106, 'mod_lesson', 'mediafile', ''),
(1107, 'mod_lesson', 'mediafile_adv', '1'),
(1108, 'mod_lesson', 'mediawidth', '640'),
(1109, 'mod_lesson', 'mediaheight', '480'),
(1110, 'mod_lesson', 'mediaclose', '0'),
(1111, 'mod_lesson', 'progressbar', '0'),
(1112, 'mod_lesson', 'progressbar_adv', ''),
(1113, 'mod_lesson', 'ongoing', '0'),
(1114, 'mod_lesson', 'ongoing_adv', '1'),
(1115, 'mod_lesson', 'displayleftmenu', '0'),
(1116, 'mod_lesson', 'displayleftmenu_adv', ''),
(1117, 'mod_lesson', 'displayleftif', '0'),
(1118, 'mod_lesson', 'displayleftif_adv', '1'),
(1119, 'mod_lesson', 'slideshow', '0'),
(1120, 'mod_lesson', 'slideshow_adv', '1'),
(1121, 'mod_lesson', 'slideshowwidth', '640'),
(1122, 'mod_lesson', 'slideshowheight', '480'),
(1123, 'mod_lesson', 'slideshowbgcolor', '#FFFFFF'),
(1124, 'mod_lesson', 'maxanswers', '5'),
(1125, 'mod_lesson', 'maxanswers_adv', '1'),
(1126, 'mod_lesson', 'defaultfeedback', '0'),
(1127, 'mod_lesson', 'defaultfeedback_adv', '1'),
(1128, 'mod_lesson', 'activitylink', ''),
(1129, 'mod_lesson', 'activitylink_adv', '1'),
(1130, 'mod_lesson', 'timelimit', '0'),
(1131, 'mod_lesson', 'timelimit_adv', ''),
(1132, 'mod_lesson', 'password', '0'),
(1133, 'mod_lesson', 'password_adv', '1'),
(1134, 'mod_lesson', 'modattempts', '0'),
(1135, 'mod_lesson', 'modattempts_adv', ''),
(1136, 'mod_lesson', 'displayreview', '0'),
(1137, 'mod_lesson', 'displayreview_adv', ''),
(1138, 'mod_lesson', 'maximumnumberofattempts', '1'),
(1139, 'mod_lesson', 'maximumnumberofattempts_adv', ''),
(1140, 'mod_lesson', 'defaultnextpage', '0'),
(1141, 'mod_lesson', 'defaultnextpage_adv', '1'),
(1142, 'mod_lesson', 'numberofpagestoshow', '1'),
(1143, 'mod_lesson', 'numberofpagestoshow_adv', '1'),
(1144, 'mod_lesson', 'practice', '0'),
(1145, 'mod_lesson', 'practice_adv', ''),
(1146, 'mod_lesson', 'customscoring', '1'),
(1147, 'mod_lesson', 'customscoring_adv', '1'),
(1148, 'mod_lesson', 'retakesallowed', '0'),
(1149, 'mod_lesson', 'retakesallowed_adv', ''),
(1150, 'mod_lesson', 'handlingofretakes', '0'),
(1151, 'mod_lesson', 'handlingofretakes_adv', '1'),
(1152, 'mod_lesson', 'minimumnumberofquestions', '0'),
(1153, 'mod_lesson', 'minimumnumberofquestions_adv', '1'),
(1154, 'page', 'displayoptions', '5'),
(1155, 'page', 'printheading', '1'),
(1156, 'page', 'printintro', '0'),
(1157, 'page', 'printlastmodified', '1'),
(1158, 'page', 'display', '5'),
(1159, 'page', 'popupwidth', '620'),
(1160, 'page', 'popupheight', '450'),
(1161, 'quiz', 'timelimit', '0'),
(1162, 'quiz', 'timelimit_adv', ''),
(1163, 'quiz', 'overduehandling', 'autosubmit'),
(1164, 'quiz', 'overduehandling_adv', ''),
(1165, 'quiz', 'graceperiod', '86400'),
(1166, 'quiz', 'graceperiod_adv', ''),
(1167, 'quiz', 'graceperiodmin', '60'),
(1168, 'quiz', 'attempts', '0'),
(1169, 'quiz', 'attempts_adv', ''),
(1170, 'quiz', 'grademethod', '1'),
(1171, 'quiz', 'grademethod_adv', ''),
(1172, 'quiz', 'maximumgrade', '10'),
(1173, 'quiz', 'questionsperpage', '1'),
(1174, 'quiz', 'questionsperpage_adv', ''),
(1175, 'quiz', 'navmethod', 'free'),
(1176, 'quiz', 'navmethod_adv', '1'),
(1177, 'quiz', 'shuffleanswers', '1'),
(1178, 'quiz', 'shuffleanswers_adv', ''),
(1179, 'quiz', 'preferredbehaviour', 'deferredfeedback'),
(1180, 'quiz', 'canredoquestions', '0'),
(1181, 'quiz', 'canredoquestions_adv', '1'),
(1182, 'quiz', 'attemptonlast', '0'),
(1183, 'quiz', 'attemptonlast_adv', '1'),
(1184, 'quiz', 'reviewattempt', '69904'),
(1185, 'quiz', 'reviewcorrectness', '69904'),
(1186, 'quiz', 'reviewmarks', '69904'),
(1187, 'quiz', 'reviewspecificfeedback', '69904'),
(1188, 'quiz', 'reviewgeneralfeedback', '69904'),
(1189, 'quiz', 'reviewrightanswer', '69904'),
(1190, 'quiz', 'reviewoverallfeedback', '4368'),
(1191, 'quiz', 'showuserpicture', '0'),
(1192, 'quiz', 'showuserpicture_adv', ''),
(1193, 'quiz', 'decimalpoints', '2'),
(1194, 'quiz', 'decimalpoints_adv', ''),
(1195, 'quiz', 'questiondecimalpoints', '-1'),
(1196, 'quiz', 'questiondecimalpoints_adv', ''),
(1197, 'quiz', 'showblocks', '0'),
(1198, 'quiz', 'showblocks_adv', '1'),
(1199, 'quiz', 'quizpassword', ''),
(1200, 'quiz', 'quizpassword_adv', ''),
(1201, 'quiz', 'quizpassword_required', ''),
(1202, 'quiz', 'subnet', ''),
(1203, 'quiz', 'subnet_adv', '1'),
(1204, 'quiz', 'delay1', '0'),
(1205, 'quiz', 'delay1_adv', '1'),
(1206, 'quiz', 'delay2', '0'),
(1207, 'quiz', 'delay2_adv', '1'),
(1208, 'quiz', 'browsersecurity', '-'),
(1209, 'quiz', 'browsersecurity_adv', '1'),
(1210, 'quiz', 'initialnumfeedbacks', '2'),
(1211, 'quiz', 'autosaveperiod', '60'),
(1212, 'quizaccess_seb', 'autoreconfigureseb', '1'),
(1213, 'quizaccess_seb', 'showseblinks', 'seb,http'),
(1214, 'quizaccess_seb', 'downloadlink', 'https://safeexambrowser.org/download_en.html'),
(1215, 'quizaccess_seb', 'quizpasswordrequired', '0'),
(1216, 'quizaccess_seb', 'displayblocksbeforestart', '0'),
(1217, 'quizaccess_seb', 'displayblockswhenfinished', '1'),
(1218, 'scorm', 'displaycoursestructure', '0'),
(1219, 'scorm', 'displaycoursestructure_adv', ''),
(1220, 'scorm', 'popup', '0'),
(1221, 'scorm', 'popup_adv', ''),
(1222, 'scorm', 'displayactivityname', '1'),
(1223, 'scorm', 'framewidth', '100'),
(1224, 'scorm', 'framewidth_adv', '1'),
(1225, 'scorm', 'frameheight', '500'),
(1226, 'scorm', 'frameheight_adv', '1'),
(1227, 'scorm', 'winoptgrp_adv', '1'),
(1228, 'scorm', 'scrollbars', '0'),
(1229, 'scorm', 'directories', '0'),
(1230, 'scorm', 'location', '0'),
(1231, 'scorm', 'menubar', '0'),
(1232, 'scorm', 'toolbar', '0'),
(1233, 'scorm', 'status', '0'),
(1234, 'scorm', 'skipview', '0'),
(1235, 'scorm', 'skipview_adv', '1'),
(1236, 'scorm', 'hidebrowse', '0'),
(1237, 'scorm', 'hidebrowse_adv', '1'),
(1238, 'scorm', 'hidetoc', '0'),
(1239, 'scorm', 'hidetoc_adv', '1'),
(1240, 'scorm', 'nav', '1'),
(1241, 'scorm', 'nav_adv', '1'),
(1242, 'scorm', 'navpositionleft', '-100'),
(1243, 'scorm', 'navpositionleft_adv', '1'),
(1244, 'scorm', 'navpositiontop', '-100'),
(1245, 'scorm', 'navpositiontop_adv', '1'),
(1246, 'scorm', 'collapsetocwinsize', '767'),
(1247, 'scorm', 'collapsetocwinsize_adv', '1'),
(1248, 'scorm', 'displayattemptstatus', '1'),
(1249, 'scorm', 'displayattemptstatus_adv', ''),
(1250, 'scorm', 'grademethod', '1'),
(1251, 'scorm', 'maxgrade', '100'),
(1252, 'scorm', 'maxattempt', '0'),
(1253, 'scorm', 'whatgrade', '0'),
(1254, 'scorm', 'forcecompleted', '0'),
(1255, 'scorm', 'forcenewattempt', '0'),
(1256, 'scorm', 'autocommit', '0'),
(1257, 'scorm', 'masteryoverride', '1'),
(1258, 'scorm', 'lastattemptlock', '0'),
(1259, 'scorm', 'auto', '0'),
(1260, 'scorm', 'updatefreq', '0'),
(1261, 'scorm', 'scormstandard', '0'),
(1262, 'scorm', 'allowtypeexternal', '0'),
(1263, 'scorm', 'allowtypelocalsync', '0'),
(1264, 'scorm', 'allowtypeexternalaicc', '0'),
(1265, 'scorm', 'allowaicchacp', '0'),
(1266, 'scorm', 'aicchacptimeout', '30'),
(1267, 'scorm', 'aicchacpkeepsessiondata', '1'),
(1268, 'scorm', 'aiccuserid', '1'),
(1269, 'scorm', 'forcejavascript', '1'),
(1270, 'scorm', 'allowapidebug', '0'),
(1271, 'scorm', 'apidebugmask', '.*'),
(1272, 'scorm', 'protectpackagedownloads', '0'),
(1273, 'url', 'framesize', '130'),
(1274, 'url', 'secretphrase', ''),
(1275, 'url', 'rolesinparams', '0'),
(1276, 'url', 'displayoptions', '0,1,5,6'),
(1277, 'url', 'printintro', '1'),
(1278, 'url', 'display', '0'),
(1279, 'url', 'popupwidth', '620'),
(1280, 'url', 'popupheight', '450'),
(1281, 'workshop', 'grade', '80'),
(1282, 'workshop', 'gradinggrade', '20'),
(1283, 'workshop', 'gradedecimals', '0'),
(1284, 'workshop', 'maxbytes', '0'),
(1285, 'workshop', 'strategy', 'accumulative'),
(1286, 'workshop', 'examplesmode', '0'),
(1287, 'workshopallocation_random', 'numofreviews', '5'),
(1288, 'workshopform_numerrors', 'grade0', 'No'),
(1289, 'workshopform_numerrors', 'grade1', 'Yes'),
(1290, 'workshopeval_best', 'comparison', '5'),
(1291, 'tool_brickfield', 'analysistype', '0'),
(1292, 'tool_brickfield', 'deletehistoricaldata', '1'),
(1293, 'tool_brickfield', 'batch', '1000'),
(1294, 'tool_brickfield', 'perpage', '50'),
(1295, 'tool_recyclebin', 'coursebinenable', '1'),
(1296, 'tool_recyclebin', 'coursebinexpiry', '604800'),
(1297, 'tool_recyclebin', 'categorybinenable', '1'),
(1298, 'tool_recyclebin', 'categorybinexpiry', '604800'),
(1299, 'tool_recyclebin', 'autohide', '1'),
(1300, 'antivirus_clamav', 'runningmethod', 'commandline'),
(1301, 'antivirus_clamav', 'pathtoclam', ''),
(1302, 'antivirus_clamav', 'pathtounixsocket', ''),
(1303, 'antivirus_clamav', 'tcpsockethost', ''),
(1304, 'antivirus_clamav', 'tcpsocketport', '3310'),
(1305, 'antivirus_clamav', 'clamfailureonupload', 'tryagain'),
(1306, 'antivirus_clamav', 'tries', '1'),
(1307, 'auth_cas', 'auth_name', 'CAS'),
(1308, 'auth_cas', 'auth_logo', ''),
(1309, 'auth_cas', 'hostname', ''),
(1310, 'auth_cas', 'baseuri', ''),
(1311, 'auth_cas', 'port', '0'),
(1312, 'auth_cas', 'casversion', '2.0'),
(1313, 'auth_cas', 'language', 'CAS_Languages_English'),
(1314, 'auth_cas', 'proxycas', '0'),
(1315, 'auth_cas', 'logoutcas', '0'),
(1316, 'auth_cas', 'multiauth', '0'),
(1317, 'auth_cas', 'certificate_check', '0'),
(1318, 'auth_cas', 'certificate_path', ''),
(1319, 'auth_cas', 'curl_ssl_version', ''),
(1320, 'auth_cas', 'logout_return_url', ''),
(1321, 'auth_cas', 'host_url', ''),
(1322, 'auth_cas', 'ldap_version', '3'),
(1323, 'auth_cas', 'start_tls', '0'),
(1324, 'auth_cas', 'ldapencoding', 'utf-8'),
(1325, 'auth_cas', 'pagesize', '250'),
(1326, 'auth_cas', 'bind_dn', ''),
(1327, 'auth_cas', 'bind_pw', ''),
(1328, 'auth_cas', 'user_type', 'default'),
(1329, 'auth_cas', 'contexts', ''),
(1330, 'auth_cas', 'search_sub', '0'),
(1331, 'auth_cas', 'opt_deref', '0'),
(1332, 'auth_cas', 'user_attribute', ''),
(1333, 'auth_cas', 'memberattribute', ''),
(1334, 'auth_cas', 'memberattribute_isdn', '0'),
(1335, 'auth_cas', 'objectclass', ''),
(1336, 'auth_cas', 'attrcreators', ''),
(1337, 'auth_cas', 'groupecreators', ''),
(1338, 'auth_cas', 'removeuser', '0'),
(1339, 'auth_cas', 'field_map_firstname', ''),
(1340, 'auth_cas', 'field_updatelocal_firstname', 'oncreate'),
(1341, 'auth_cas', 'field_updateremote_firstname', '0'),
(1342, 'auth_cas', 'field_lock_firstname', 'unlocked'),
(1343, 'auth_cas', 'field_map_lastname', ''),
(1344, 'auth_cas', 'field_updatelocal_lastname', 'oncreate'),
(1345, 'auth_cas', 'field_updateremote_lastname', '0'),
(1346, 'auth_cas', 'field_lock_lastname', 'unlocked'),
(1347, 'auth_cas', 'field_map_email', ''),
(1348, 'auth_cas', 'field_updatelocal_email', 'oncreate'),
(1349, 'auth_cas', 'field_updateremote_email', '0'),
(1350, 'auth_cas', 'field_lock_email', 'unlocked'),
(1351, 'auth_cas', 'field_map_city', ''),
(1352, 'auth_cas', 'field_updatelocal_city', 'oncreate'),
(1353, 'auth_cas', 'field_updateremote_city', '0'),
(1354, 'auth_cas', 'field_lock_city', 'unlocked'),
(1355, 'auth_cas', 'field_map_country', ''),
(1356, 'auth_cas', 'field_updatelocal_country', 'oncreate'),
(1357, 'auth_cas', 'field_updateremote_country', '0'),
(1358, 'auth_cas', 'field_lock_country', 'unlocked'),
(1359, 'auth_cas', 'field_map_lang', ''),
(1360, 'auth_cas', 'field_updatelocal_lang', 'oncreate'),
(1361, 'auth_cas', 'field_updateremote_lang', '0'),
(1362, 'auth_cas', 'field_lock_lang', 'unlocked'),
(1363, 'auth_cas', 'field_map_description', ''),
(1364, 'auth_cas', 'field_updatelocal_description', 'oncreate'),
(1365, 'auth_cas', 'field_updateremote_description', '0'),
(1366, 'auth_cas', 'field_lock_description', 'unlocked'),
(1367, 'auth_cas', 'field_map_idnumber', ''),
(1368, 'auth_cas', 'field_updatelocal_idnumber', 'oncreate'),
(1369, 'auth_cas', 'field_updateremote_idnumber', '0'),
(1370, 'auth_cas', 'field_lock_idnumber', 'unlocked'),
(1371, 'auth_cas', 'field_map_institution', ''),
(1372, 'auth_cas', 'field_updatelocal_institution', 'oncreate'),
(1373, 'auth_cas', 'field_updateremote_institution', '0'),
(1374, 'auth_cas', 'field_lock_institution', 'unlocked'),
(1375, 'auth_cas', 'field_map_department', ''),
(1376, 'auth_cas', 'field_updatelocal_department', 'oncreate'),
(1377, 'auth_cas', 'field_updateremote_department', '0'),
(1378, 'auth_cas', 'field_lock_department', 'unlocked'),
(1379, 'auth_cas', 'field_map_phone1', ''),
(1380, 'auth_cas', 'field_updatelocal_phone1', 'oncreate'),
(1381, 'auth_cas', 'field_updateremote_phone1', '0'),
(1382, 'auth_cas', 'field_lock_phone1', 'unlocked'),
(1383, 'auth_cas', 'field_map_phone2', ''),
(1384, 'auth_cas', 'field_updatelocal_phone2', 'oncreate'),
(1385, 'auth_cas', 'field_updateremote_phone2', '0'),
(1386, 'auth_cas', 'field_lock_phone2', 'unlocked'),
(1387, 'auth_cas', 'field_map_address', ''),
(1388, 'auth_cas', 'field_updatelocal_address', 'oncreate'),
(1389, 'auth_cas', 'field_updateremote_address', '0'),
(1390, 'auth_cas', 'field_lock_address', 'unlocked'),
(1391, 'auth_cas', 'field_map_firstnamephonetic', ''),
(1392, 'auth_cas', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1393, 'auth_cas', 'field_updateremote_firstnamephonetic', '0'),
(1394, 'auth_cas', 'field_lock_firstnamephonetic', 'unlocked'),
(1395, 'auth_cas', 'field_map_lastnamephonetic', ''),
(1396, 'auth_cas', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1397, 'auth_cas', 'field_updateremote_lastnamephonetic', '0'),
(1398, 'auth_cas', 'field_lock_lastnamephonetic', 'unlocked'),
(1399, 'auth_cas', 'field_map_middlename', ''),
(1400, 'auth_cas', 'field_updatelocal_middlename', 'oncreate'),
(1401, 'auth_cas', 'field_updateremote_middlename', '0'),
(1402, 'auth_cas', 'field_lock_middlename', 'unlocked'),
(1403, 'auth_cas', 'field_map_alternatename', ''),
(1404, 'auth_cas', 'field_updatelocal_alternatename', 'oncreate'),
(1405, 'auth_cas', 'field_updateremote_alternatename', '0'),
(1406, 'auth_cas', 'field_lock_alternatename', 'unlocked'),
(1407, 'auth_email', 'recaptcha', '0'),
(1408, 'auth_email', 'field_lock_firstname', 'unlocked'),
(1409, 'auth_email', 'field_lock_lastname', 'unlocked'),
(1410, 'auth_email', 'field_lock_email', 'unlocked'),
(1411, 'auth_email', 'field_lock_city', 'unlocked'),
(1412, 'auth_email', 'field_lock_country', 'unlocked'),
(1413, 'auth_email', 'field_lock_lang', 'unlocked'),
(1414, 'auth_email', 'field_lock_description', 'unlocked'),
(1415, 'auth_email', 'field_lock_idnumber', 'unlocked'),
(1416, 'auth_email', 'field_lock_institution', 'unlocked'),
(1417, 'auth_email', 'field_lock_department', 'unlocked'),
(1418, 'auth_email', 'field_lock_phone1', 'unlocked'),
(1419, 'auth_email', 'field_lock_phone2', 'unlocked'),
(1420, 'auth_email', 'field_lock_address', 'unlocked'),
(1421, 'auth_email', 'field_lock_firstnamephonetic', 'unlocked'),
(1422, 'auth_email', 'field_lock_lastnamephonetic', 'unlocked'),
(1423, 'auth_email', 'field_lock_middlename', 'unlocked'),
(1424, 'auth_email', 'field_lock_alternatename', 'unlocked'),
(1425, 'auth_db', 'host', '127.0.0.1'),
(1426, 'auth_db', 'type', 'mysqli'),
(1427, 'auth_db', 'sybasequoting', '0'),
(1428, 'auth_db', 'name', ''),
(1429, 'auth_db', 'user', ''),
(1430, 'auth_db', 'pass', ''),
(1431, 'auth_db', 'table', ''),
(1432, 'auth_db', 'fielduser', ''),
(1433, 'auth_db', 'fieldpass', ''),
(1434, 'auth_db', 'passtype', 'plaintext'),
(1435, 'auth_db', 'extencoding', 'utf-8'),
(1436, 'auth_db', 'setupsql', ''),
(1437, 'auth_db', 'debugauthdb', '0'),
(1438, 'auth_db', 'changepasswordurl', ''),
(1439, 'auth_db', 'removeuser', '0'),
(1440, 'auth_db', 'updateusers', '0'),
(1441, 'auth_db', 'field_map_firstname', ''),
(1442, 'auth_db', 'field_updatelocal_firstname', 'oncreate'),
(1443, 'auth_db', 'field_updateremote_firstname', '0'),
(1444, 'auth_db', 'field_lock_firstname', 'unlocked'),
(1445, 'auth_db', 'field_map_lastname', ''),
(1446, 'auth_db', 'field_updatelocal_lastname', 'oncreate'),
(1447, 'auth_db', 'field_updateremote_lastname', '0'),
(1448, 'auth_db', 'field_lock_lastname', 'unlocked'),
(1449, 'auth_db', 'field_map_email', ''),
(1450, 'auth_db', 'field_updatelocal_email', 'oncreate'),
(1451, 'auth_db', 'field_updateremote_email', '0'),
(1452, 'auth_db', 'field_lock_email', 'unlocked'),
(1453, 'auth_db', 'field_map_city', ''),
(1454, 'auth_db', 'field_updatelocal_city', 'oncreate'),
(1455, 'auth_db', 'field_updateremote_city', '0'),
(1456, 'auth_db', 'field_lock_city', 'unlocked'),
(1457, 'auth_db', 'field_map_country', ''),
(1458, 'auth_db', 'field_updatelocal_country', 'oncreate'),
(1459, 'auth_db', 'field_updateremote_country', '0'),
(1460, 'auth_db', 'field_lock_country', 'unlocked'),
(1461, 'auth_db', 'field_map_lang', ''),
(1462, 'auth_db', 'field_updatelocal_lang', 'oncreate'),
(1463, 'auth_db', 'field_updateremote_lang', '0'),
(1464, 'auth_db', 'field_lock_lang', 'unlocked'),
(1465, 'auth_db', 'field_map_description', ''),
(1466, 'auth_db', 'field_updatelocal_description', 'oncreate'),
(1467, 'auth_db', 'field_updateremote_description', '0'),
(1468, 'auth_db', 'field_lock_description', 'unlocked'),
(1469, 'auth_db', 'field_map_idnumber', ''),
(1470, 'auth_db', 'field_updatelocal_idnumber', 'oncreate'),
(1471, 'auth_db', 'field_updateremote_idnumber', '0'),
(1472, 'auth_db', 'field_lock_idnumber', 'unlocked'),
(1473, 'auth_db', 'field_map_institution', ''),
(1474, 'auth_db', 'field_updatelocal_institution', 'oncreate'),
(1475, 'auth_db', 'field_updateremote_institution', '0'),
(1476, 'auth_db', 'field_lock_institution', 'unlocked'),
(1477, 'auth_db', 'field_map_department', ''),
(1478, 'auth_db', 'field_updatelocal_department', 'oncreate'),
(1479, 'auth_db', 'field_updateremote_department', '0'),
(1480, 'auth_db', 'field_lock_department', 'unlocked'),
(1481, 'auth_db', 'field_map_phone1', ''),
(1482, 'auth_db', 'field_updatelocal_phone1', 'oncreate'),
(1483, 'auth_db', 'field_updateremote_phone1', '0'),
(1484, 'auth_db', 'field_lock_phone1', 'unlocked'),
(1485, 'auth_db', 'field_map_phone2', ''),
(1486, 'auth_db', 'field_updatelocal_phone2', 'oncreate'),
(1487, 'auth_db', 'field_updateremote_phone2', '0'),
(1488, 'auth_db', 'field_lock_phone2', 'unlocked'),
(1489, 'auth_db', 'field_map_address', ''),
(1490, 'auth_db', 'field_updatelocal_address', 'oncreate'),
(1491, 'auth_db', 'field_updateremote_address', '0'),
(1492, 'auth_db', 'field_lock_address', 'unlocked'),
(1493, 'auth_db', 'field_map_firstnamephonetic', ''),
(1494, 'auth_db', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1495, 'auth_db', 'field_updateremote_firstnamephonetic', '0'),
(1496, 'auth_db', 'field_lock_firstnamephonetic', 'unlocked'),
(1497, 'auth_db', 'field_map_lastnamephonetic', ''),
(1498, 'auth_db', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1499, 'auth_db', 'field_updateremote_lastnamephonetic', '0'),
(1500, 'auth_db', 'field_lock_lastnamephonetic', 'unlocked'),
(1501, 'auth_db', 'field_map_middlename', ''),
(1502, 'auth_db', 'field_updatelocal_middlename', 'oncreate'),
(1503, 'auth_db', 'field_updateremote_middlename', '0'),
(1504, 'auth_db', 'field_lock_middlename', 'unlocked'),
(1505, 'auth_db', 'field_map_alternatename', ''),
(1506, 'auth_db', 'field_updatelocal_alternatename', 'oncreate'),
(1507, 'auth_db', 'field_updateremote_alternatename', '0'),
(1508, 'auth_db', 'field_lock_alternatename', 'unlocked'),
(1509, 'auth_ldap', 'host_url', ''),
(1510, 'auth_ldap', 'ldap_version', '3'),
(1511, 'auth_ldap', 'start_tls', '0'),
(1512, 'auth_ldap', 'ldapencoding', 'utf-8'),
(1513, 'auth_ldap', 'pagesize', '250'),
(1514, 'auth_ldap', 'preventpassindb', '0'),
(1515, 'auth_ldap', 'bind_dn', ''),
(1516, 'auth_ldap', 'bind_pw', ''),
(1517, 'auth_ldap', 'user_type', 'default'),
(1518, 'auth_ldap', 'contexts', ''),
(1519, 'auth_ldap', 'search_sub', '0'),
(1520, 'auth_ldap', 'opt_deref', '0'),
(1521, 'auth_ldap', 'user_attribute', ''),
(1522, 'auth_ldap', 'suspended_attribute', ''),
(1523, 'auth_ldap', 'memberattribute', ''),
(1524, 'auth_ldap', 'memberattribute_isdn', '0'),
(1525, 'auth_ldap', 'objectclass', ''),
(1526, 'auth_ldap', 'forcechangepassword', '0'),
(1527, 'auth_ldap', 'stdchangepassword', '0'),
(1528, 'auth_ldap', 'passtype', 'plaintext'),
(1529, 'auth_ldap', 'changepasswordurl', ''),
(1530, 'auth_ldap', 'expiration', '0'),
(1531, 'auth_ldap', 'expiration_warning', ''),
(1532, 'auth_ldap', 'expireattr', ''),
(1533, 'auth_ldap', 'gracelogins', '0'),
(1534, 'auth_ldap', 'graceattr', ''),
(1535, 'auth_ldap', 'auth_user_create', '0'),
(1536, 'auth_ldap', 'create_context', ''),
(1537, 'auth_ldap', 'managercontext', ''),
(1538, 'auth_ldap', 'coursecreatorcontext', ''),
(1539, 'auth_ldap', 'removeuser', '0'),
(1540, 'auth_ldap', 'sync_suspended', '0'),
(1541, 'auth_ldap', 'ntlmsso_enabled', '0'),
(1542, 'auth_ldap', 'ntlmsso_subnet', ''),
(1543, 'auth_ldap', 'ntlmsso_ie_fastpath', '0'),
(1544, 'auth_ldap', 'ntlmsso_type', 'ntlm'),
(1545, 'auth_ldap', 'ntlmsso_remoteuserformat', ''),
(1546, 'auth_ldap', 'field_map_firstname', ''),
(1547, 'auth_ldap', 'field_updatelocal_firstname', 'oncreate'),
(1548, 'auth_ldap', 'field_updateremote_firstname', '0'),
(1549, 'auth_ldap', 'field_lock_firstname', 'unlocked'),
(1550, 'auth_ldap', 'field_map_lastname', ''),
(1551, 'auth_ldap', 'field_updatelocal_lastname', 'oncreate'),
(1552, 'auth_ldap', 'field_updateremote_lastname', '0'),
(1553, 'auth_ldap', 'field_lock_lastname', 'unlocked'),
(1554, 'auth_ldap', 'field_map_email', ''),
(1555, 'auth_ldap', 'field_updatelocal_email', 'oncreate'),
(1556, 'auth_ldap', 'field_updateremote_email', '0'),
(1557, 'auth_ldap', 'field_lock_email', 'unlocked'),
(1558, 'auth_ldap', 'field_map_city', ''),
(1559, 'auth_ldap', 'field_updatelocal_city', 'oncreate'),
(1560, 'auth_ldap', 'field_updateremote_city', '0'),
(1561, 'auth_ldap', 'field_lock_city', 'unlocked'),
(1562, 'auth_ldap', 'field_map_country', ''),
(1563, 'auth_ldap', 'field_updatelocal_country', 'oncreate'),
(1564, 'auth_ldap', 'field_updateremote_country', '0'),
(1565, 'auth_ldap', 'field_lock_country', 'unlocked'),
(1566, 'auth_ldap', 'field_map_lang', ''),
(1567, 'auth_ldap', 'field_updatelocal_lang', 'oncreate'),
(1568, 'auth_ldap', 'field_updateremote_lang', '0'),
(1569, 'auth_ldap', 'field_lock_lang', 'unlocked'),
(1570, 'auth_ldap', 'field_map_description', ''),
(1571, 'auth_ldap', 'field_updatelocal_description', 'oncreate'),
(1572, 'auth_ldap', 'field_updateremote_description', '0'),
(1573, 'auth_ldap', 'field_lock_description', 'unlocked'),
(1574, 'auth_ldap', 'field_map_idnumber', ''),
(1575, 'auth_ldap', 'field_updatelocal_idnumber', 'oncreate'),
(1576, 'auth_ldap', 'field_updateremote_idnumber', '0'),
(1577, 'auth_ldap', 'field_lock_idnumber', 'unlocked'),
(1578, 'auth_ldap', 'field_map_institution', ''),
(1579, 'auth_ldap', 'field_updatelocal_institution', 'oncreate'),
(1580, 'auth_ldap', 'field_updateremote_institution', '0'),
(1581, 'auth_ldap', 'field_lock_institution', 'unlocked'),
(1582, 'auth_ldap', 'field_map_department', ''),
(1583, 'auth_ldap', 'field_updatelocal_department', 'oncreate'),
(1584, 'auth_ldap', 'field_updateremote_department', '0'),
(1585, 'auth_ldap', 'field_lock_department', 'unlocked'),
(1586, 'auth_ldap', 'field_map_phone1', ''),
(1587, 'auth_ldap', 'field_updatelocal_phone1', 'oncreate'),
(1588, 'auth_ldap', 'field_updateremote_phone1', '0'),
(1589, 'auth_ldap', 'field_lock_phone1', 'unlocked'),
(1590, 'auth_ldap', 'field_map_phone2', ''),
(1591, 'auth_ldap', 'field_updatelocal_phone2', 'oncreate'),
(1592, 'auth_ldap', 'field_updateremote_phone2', '0'),
(1593, 'auth_ldap', 'field_lock_phone2', 'unlocked'),
(1594, 'auth_ldap', 'field_map_address', ''),
(1595, 'auth_ldap', 'field_updatelocal_address', 'oncreate'),
(1596, 'auth_ldap', 'field_updateremote_address', '0'),
(1597, 'auth_ldap', 'field_lock_address', 'unlocked'),
(1598, 'auth_ldap', 'field_map_firstnamephonetic', ''),
(1599, 'auth_ldap', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1600, 'auth_ldap', 'field_updateremote_firstnamephonetic', '0'),
(1601, 'auth_ldap', 'field_lock_firstnamephonetic', 'unlocked'),
(1602, 'auth_ldap', 'field_map_lastnamephonetic', ''),
(1603, 'auth_ldap', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1604, 'auth_ldap', 'field_updateremote_lastnamephonetic', '0'),
(1605, 'auth_ldap', 'field_lock_lastnamephonetic', 'unlocked'),
(1606, 'auth_ldap', 'field_map_middlename', ''),
(1607, 'auth_ldap', 'field_updatelocal_middlename', 'oncreate'),
(1608, 'auth_ldap', 'field_updateremote_middlename', '0'),
(1609, 'auth_ldap', 'field_lock_middlename', 'unlocked'),
(1610, 'auth_ldap', 'field_map_alternatename', ''),
(1611, 'auth_ldap', 'field_updatelocal_alternatename', 'oncreate'),
(1612, 'auth_ldap', 'field_updateremote_alternatename', '0'),
(1613, 'auth_ldap', 'field_lock_alternatename', 'unlocked'),
(1614, 'auth_manual', 'expiration', '0'),
(1615, 'auth_manual', 'expirationtime', '30'),
(1616, 'auth_manual', 'expiration_warning', '0'),
(1617, 'auth_manual', 'field_lock_firstname', 'unlocked'),
(1618, 'auth_manual', 'field_lock_lastname', 'unlocked'),
(1619, 'auth_manual', 'field_lock_email', 'unlocked'),
(1620, 'auth_manual', 'field_lock_city', 'unlocked'),
(1621, 'auth_manual', 'field_lock_country', 'unlocked'),
(1622, 'auth_manual', 'field_lock_lang', 'unlocked'),
(1623, 'auth_manual', 'field_lock_description', 'unlocked'),
(1624, 'auth_manual', 'field_lock_idnumber', 'unlocked'),
(1625, 'auth_manual', 'field_lock_institution', 'unlocked'),
(1626, 'auth_manual', 'field_lock_department', 'unlocked'),
(1627, 'auth_manual', 'field_lock_phone1', 'unlocked'),
(1628, 'auth_manual', 'field_lock_phone2', 'unlocked'),
(1629, 'auth_manual', 'field_lock_address', 'unlocked'),
(1630, 'auth_manual', 'field_lock_firstnamephonetic', 'unlocked'),
(1631, 'auth_manual', 'field_lock_lastnamephonetic', 'unlocked'),
(1632, 'auth_manual', 'field_lock_middlename', 'unlocked'),
(1633, 'auth_manual', 'field_lock_alternatename', 'unlocked'),
(1634, 'auth_mnet', 'rpc_negotiation_timeout', '30'),
(1635, 'auth_none', 'field_lock_firstname', 'unlocked'),
(1636, 'auth_none', 'field_lock_lastname', 'unlocked'),
(1637, 'auth_none', 'field_lock_email', 'unlocked'),
(1638, 'auth_none', 'field_lock_city', 'unlocked'),
(1639, 'auth_none', 'field_lock_country', 'unlocked'),
(1640, 'auth_none', 'field_lock_lang', 'unlocked'),
(1641, 'auth_none', 'field_lock_description', 'unlocked'),
(1642, 'auth_none', 'field_lock_idnumber', 'unlocked'),
(1643, 'auth_none', 'field_lock_institution', 'unlocked'),
(1644, 'auth_none', 'field_lock_department', 'unlocked'),
(1645, 'auth_none', 'field_lock_phone1', 'unlocked'),
(1646, 'auth_none', 'field_lock_phone2', 'unlocked'),
(1647, 'auth_none', 'field_lock_address', 'unlocked'),
(1648, 'auth_none', 'field_lock_firstnamephonetic', 'unlocked'),
(1649, 'auth_none', 'field_lock_lastnamephonetic', 'unlocked'),
(1650, 'auth_none', 'field_lock_middlename', 'unlocked'),
(1651, 'auth_none', 'field_lock_alternatename', 'unlocked'),
(1652, 'auth_oauth2', 'field_lock_firstname', 'unlocked'),
(1653, 'auth_oauth2', 'field_lock_lastname', 'unlocked'),
(1654, 'auth_oauth2', 'field_lock_email', 'unlocked'),
(1655, 'auth_oauth2', 'field_lock_city', 'unlocked'),
(1656, 'auth_oauth2', 'field_lock_country', 'unlocked'),
(1657, 'auth_oauth2', 'field_lock_lang', 'unlocked'),
(1658, 'auth_oauth2', 'field_lock_description', 'unlocked'),
(1659, 'auth_oauth2', 'field_lock_idnumber', 'unlocked'),
(1660, 'auth_oauth2', 'field_lock_institution', 'unlocked'),
(1661, 'auth_oauth2', 'field_lock_department', 'unlocked'),
(1662, 'auth_oauth2', 'field_lock_phone1', 'unlocked'),
(1663, 'auth_oauth2', 'field_lock_phone2', 'unlocked'),
(1664, 'auth_oauth2', 'field_lock_address', 'unlocked'),
(1665, 'auth_oauth2', 'field_lock_firstnamephonetic', 'unlocked'),
(1666, 'auth_oauth2', 'field_lock_lastnamephonetic', 'unlocked'),
(1667, 'auth_oauth2', 'field_lock_middlename', 'unlocked'),
(1668, 'auth_oauth2', 'field_lock_alternatename', 'unlocked'),
(1669, 'auth_shibboleth', 'user_attribute', ''),
(1670, 'auth_shibboleth', 'convert_data', ''),
(1671, 'auth_shibboleth', 'alt_login', 'off'),
(1672, 'auth_shibboleth', 'organization_selection', 'urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai'),
(1673, 'auth_shibboleth', 'logout_handler', ''),
(1674, 'auth_shibboleth', 'logout_return_url', ''),
(1675, 'auth_shibboleth', 'login_name', 'Shibboleth Login'),
(1676, 'auth_shibboleth', 'auth_logo', ''),
(1677, 'auth_shibboleth', 'auth_instructions', 'Use the <a href="[[softurl]]/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.'),
(1678, 'auth_shibboleth', 'changepasswordurl', ''),
(1679, 'auth_shibboleth', 'field_map_firstname', ''),
(1680, 'auth_shibboleth', 'field_updatelocal_firstname', 'oncreate'),
(1681, 'auth_shibboleth', 'field_lock_firstname', 'unlocked'),
(1682, 'auth_shibboleth', 'field_map_lastname', ''),
(1683, 'auth_shibboleth', 'field_updatelocal_lastname', 'oncreate'),
(1684, 'auth_shibboleth', 'field_lock_lastname', 'unlocked'),
(1685, 'auth_shibboleth', 'field_map_email', ''),
(1686, 'auth_shibboleth', 'field_updatelocal_email', 'oncreate'),
(1687, 'auth_shibboleth', 'field_lock_email', 'unlocked'),
(1688, 'auth_shibboleth', 'field_map_city', ''),
(1689, 'auth_shibboleth', 'field_updatelocal_city', 'oncreate'),
(1690, 'auth_shibboleth', 'field_lock_city', 'unlocked'),
(1691, 'auth_shibboleth', 'field_map_country', ''),
(1692, 'auth_shibboleth', 'field_updatelocal_country', 'oncreate'),
(1693, 'auth_shibboleth', 'field_lock_country', 'unlocked'),
(1694, 'auth_shibboleth', 'field_map_lang', ''),
(1695, 'auth_shibboleth', 'field_updatelocal_lang', 'oncreate'),
(1696, 'auth_shibboleth', 'field_lock_lang', 'unlocked'),
(1697, 'auth_shibboleth', 'field_map_description', ''),
(1698, 'auth_shibboleth', 'field_updatelocal_description', 'oncreate'),
(1699, 'auth_shibboleth', 'field_lock_description', 'unlocked'),
(1700, 'auth_shibboleth', 'field_map_idnumber', ''),
(1701, 'auth_shibboleth', 'field_updatelocal_idnumber', 'oncreate'),
(1702, 'auth_shibboleth', 'field_lock_idnumber', 'unlocked'),
(1703, 'auth_shibboleth', 'field_map_institution', ''),
(1704, 'auth_shibboleth', 'field_updatelocal_institution', 'oncreate'),
(1705, 'auth_shibboleth', 'field_lock_institution', 'unlocked'),
(1706, 'auth_shibboleth', 'field_map_department', ''),
(1707, 'auth_shibboleth', 'field_updatelocal_department', 'oncreate'),
(1708, 'auth_shibboleth', 'field_lock_department', 'unlocked'),
(1709, 'auth_shibboleth', 'field_map_phone1', ''),
(1710, 'auth_shibboleth', 'field_updatelocal_phone1', 'oncreate'),
(1711, 'auth_shibboleth', 'field_lock_phone1', 'unlocked'),
(1712, 'auth_shibboleth', 'field_map_phone2', ''),
(1713, 'auth_shibboleth', 'field_updatelocal_phone2', 'oncreate'),
(1714, 'auth_shibboleth', 'field_lock_phone2', 'unlocked'),
(1715, 'auth_shibboleth', 'field_map_address', ''),
(1716, 'auth_shibboleth', 'field_updatelocal_address', 'oncreate'),
(1717, 'auth_shibboleth', 'field_lock_address', 'unlocked'),
(1718, 'auth_shibboleth', 'field_map_firstnamephonetic', ''),
(1719, 'auth_shibboleth', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1720, 'auth_shibboleth', 'field_lock_firstnamephonetic', 'unlocked'),
(1721, 'auth_shibboleth', 'field_map_lastnamephonetic', ''),
(1722, 'auth_shibboleth', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1723, 'auth_shibboleth', 'field_lock_lastnamephonetic', 'unlocked'),
(1724, 'auth_shibboleth', 'field_map_middlename', ''),
(1725, 'auth_shibboleth', 'field_updatelocal_middlename', 'oncreate'),
(1726, 'auth_shibboleth', 'field_lock_middlename', 'unlocked'),
(1727, 'auth_shibboleth', 'field_map_alternatename', ''),
(1728, 'auth_shibboleth', 'field_updatelocal_alternatename', 'oncreate'),
(1729, 'auth_shibboleth', 'field_lock_alternatename', 'unlocked'),
(1730, 'block_accessreview', 'whattoshow', 'showboth'),
(1731, 'block_accessreview', 'errordisplay', 'showint'),
(1732, 'block_accessreview', 'toolpage', 'errors'),
(1733, 'block_activity_results', 'config_showbest', '3'),
(1734, 'block_activity_results', 'config_showbest_locked', ''),
(1735, 'block_activity_results', 'config_showworst', '0'),
(1736, 'block_activity_results', 'config_showworst_locked', ''),
(1737, 'block_activity_results', 'config_usegroups', '0'),
(1738, 'block_activity_results', 'config_usegroups_locked', ''),
(1739, 'block_activity_results', 'config_nameformat', '1'),
(1740, 'block_activity_results', 'config_nameformat_locked', ''),
(1741, 'block_activity_results', 'config_gradeformat', '1'),
(1742, 'block_activity_results', 'config_gradeformat_locked', ''),
(1743, 'block_activity_results', 'config_decimalpoints', '2'),
(1744, 'block_activity_results', 'config_decimalpoints_locked', ''),
(1745, 'block_myoverview', 'displaycategories', '1'),
(1746, 'block_myoverview', 'layouts', 'card,list,summary'),
(1747, 'block_myoverview', 'displaygroupingallincludinghidden', '0'),
(1748, 'block_myoverview', 'displaygroupingall', '1'),
(1749, 'block_myoverview', 'displaygroupinginprogress', '1'),
(1750, 'block_myoverview', 'displaygroupingpast', '1'),
(1751, 'block_myoverview', 'displaygroupingfuture', '1'),
(1752, 'block_myoverview', 'displaygroupingcustomfield', '0'),
(1753, 'block_myoverview', 'customfiltergrouping', ''),
(1754, 'block_myoverview', 'displaygroupingfavourites', '1'),
(1755, 'block_myoverview', 'displaygroupinghidden', '1'),
(1756, 'block_recentlyaccessedcourses', 'displaycategories', '1'),
(1757, 'block_section_links', 'numsections1', '22'),
(1758, 'block_section_links', 'incby1', '2'),
(1759, 'block_section_links', 'numsections2', '40'),
(1760, 'block_section_links', 'incby2', '5'),
(1761, 'block_section_links', 'showsectionname', '0'),
(1762, 'block_starredcourses', 'displaycategories', '1'),
(1763, 'block_tag_youtube', 'apikey', ''),
(1764, 'format_singleactivity', 'activitytype', 'forum'),
(1765, 'fileconverter_googledrive', 'issuerid', ''),
(1766, 'enrol_cohort', 'roleid', '5'),
(1767, 'enrol_cohort', 'unenrolaction', '0'),
(1768, 'enrol_meta', 'nosyncroleids', ''),
(1769, 'enrol_meta', 'syncall', '1'),
(1770, 'enrol_meta', 'unenrolaction', '3'),
(1771, 'enrol_meta', 'coursesort', 'sortorder'),
(1772, 'enrol_fee', 'expiredaction', '3'),
(1773, 'enrol_fee', 'status', '1'),
(1774, 'enrol_fee', 'cost', '0'),
(1775, 'enrol_fee', 'currency', 'USD'),
(1776, 'enrol_fee', 'roleid', '5'),
(1777, 'enrol_fee', 'enrolperiod', '0'),
(1778, 'enrol_database', 'dbtype', ''),
(1779, 'enrol_database', 'dbhost', 'localhost'),
(1780, 'enrol_database', 'dbuser', ''),
(1781, 'enrol_database', 'dbpass', ''),
(1782, 'enrol_database', 'dbname', ''),
(1783, 'enrol_database', 'dbencoding', 'utf-8'),
(1784, 'enrol_database', 'dbsetupsql', ''),
(1785, 'enrol_database', 'dbsybasequoting', '0'),
(1786, 'enrol_database', 'debugdb', '0'),
(1787, 'enrol_database', 'localcoursefield', 'idnumber'),
(1788, 'enrol_database', 'localuserfield', 'idnumber'),
(1789, 'enrol_database', 'localrolefield', 'shortname'),
(1790, 'enrol_database', 'localcategoryfield', 'id'),
(1791, 'enrol_database', 'remoteenroltable', ''),
(1792, 'enrol_database', 'remotecoursefield', ''),
(1793, 'enrol_database', 'remoteuserfield', ''),
(1794, 'enrol_database', 'remoterolefield', ''),
(1795, 'enrol_database', 'remoteotheruserfield', ''),
(1796, 'enrol_database', 'defaultrole', '5'),
(1797, 'enrol_database', 'ignorehiddencourses', '0'),
(1798, 'enrol_database', 'unenrolaction', '0'),
(1799, 'enrol_database', 'newcoursetable', ''),
(1800, 'enrol_database', 'newcoursefullname', 'fullname'),
(1801, 'enrol_database', 'newcourseshortname', 'shortname'),
(1802, 'enrol_database', 'newcourseidnumber', 'idnumber'),
(1803, 'enrol_database', 'newcoursecategory', ''),
(1804, 'enrol_database', 'defaultcategory', '1'),
(1805, 'enrol_database', 'templatecourse', ''),
(1806, 'enrol_flatfile', 'location', ''),
(1807, 'enrol_flatfile', 'encoding', 'UTF-8'),
(1808, 'enrol_flatfile', 'mailstudents', '0'),
(1809, 'enrol_flatfile', 'mailteachers', '0'),
(1810, 'enrol_flatfile', 'mailadmins', '0'),
(1811, 'enrol_flatfile', 'unenrolaction', '3'),
(1812, 'enrol_flatfile', 'expiredaction', '3'),
(1813, 'enrol_guest', 'requirepassword', '0'),
(1814, 'enrol_guest', 'usepasswordpolicy', '0'),
(1815, 'enrol_guest', 'showhint', '0'),
(1816, 'enrol_guest', 'defaultenrol', '1'),
(1817, 'enrol_guest', 'status', '1'),
(1818, 'enrol_guest', 'status_adv', ''),
(1819, 'enrol_imsenterprise', 'imsfilelocation', ''),
(1820, 'enrol_imsenterprise', 'logtolocation', ''),
(1821, 'enrol_imsenterprise', 'mailadmins', '0'),
(1822, 'enrol_imsenterprise', 'createnewusers', '0'),
(1823, 'enrol_imsenterprise', 'imsupdateusers', '0'),
(1824, 'enrol_imsenterprise', 'imsdeleteusers', '0'),
(1825, 'enrol_imsenterprise', 'fixcaseusernames', '0'),
(1826, 'enrol_imsenterprise', 'fixcasepersonalnames', '0'),
(1827, 'enrol_imsenterprise', 'imssourcedidfallback', '0'),
(1828, 'enrol_imsenterprise', 'imsrolemap01', '5'),
(1829, 'enrol_imsenterprise', 'imsrolemap02', '3'),
(1830, 'enrol_imsenterprise', 'imsrolemap03', '3'),
(1831, 'enrol_imsenterprise', 'imsrolemap04', '5'),
(1832, 'enrol_imsenterprise', 'imsrolemap05', '0'),
(1833, 'enrol_imsenterprise', 'imsrolemap06', '4'),
(1834, 'enrol_imsenterprise', 'imsrolemap07', '0'),
(1835, 'enrol_imsenterprise', 'imsrolemap08', '4'),
(1836, 'enrol_imsenterprise', 'truncatecoursecodes', '0'),
(1837, 'enrol_imsenterprise', 'createnewcourses', '0'),
(1838, 'enrol_imsenterprise', 'updatecourses', '0'),
(1839, 'enrol_imsenterprise', 'createnewcategories', '0'),
(1840, 'enrol_imsenterprise', 'nestedcategories', '0'),
(1841, 'enrol_imsenterprise', 'categoryidnumber', '0'),
(1842, 'enrol_imsenterprise', 'categoryseparator', ''),
(1843, 'enrol_imsenterprise', 'imsunenrol', '0'),
(1844, 'enrol_imsenterprise', 'imscoursemapshortname', 'coursecode'),
(1845, 'enrol_imsenterprise', 'imscoursemapfullname', 'short'),
(1846, 'enrol_imsenterprise', 'imscoursemapsummary', 'ignore'),
(1847, 'enrol_imsenterprise', 'imsrestricttarget', ''),
(1848, 'enrol_imsenterprise', 'imscapitafix', '0'),
(1849, 'enrol_ldap', 'host_url', ''),
(1850, 'enrol_ldap', 'start_tls', '0'),
(1851, 'enrol_ldap', 'ldap_version', '3'),
(1852, 'enrol_ldap', 'ldapencoding', 'utf-8'),
(1853, 'enrol_ldap', 'pagesize', '250'),
(1854, 'enrol_ldap', 'bind_dn', ''),
(1855, 'enrol_ldap', 'bind_pw', ''),
(1856, 'enrol_ldap', 'course_search_sub', '0'),
(1857, 'enrol_ldap', 'memberattribute_isdn', '0'),
(1858, 'enrol_ldap', 'user_contexts', ''),
(1859, 'enrol_ldap', 'user_search_sub', '0'),
(1860, 'enrol_ldap', 'user_type', 'default'),
(1861, 'enrol_ldap', 'opt_deref', '0'),
(1862, 'enrol_ldap', 'idnumber_attribute', ''),
(1863, 'enrol_ldap', 'objectclass', ''),
(1864, 'enrol_ldap', 'course_idnumber', ''),
(1865, 'enrol_ldap', 'course_shortname', ''),
(1866, 'enrol_ldap', 'course_fullname', ''),
(1867, 'enrol_ldap', 'course_summary', ''),
(1868, 'enrol_ldap', 'ignorehiddencourses', '0'),
(1869, 'enrol_ldap', 'unenrolaction', '0'),
(1870, 'enrol_ldap', 'autocreate', '0'),
(1871, 'enrol_ldap', 'category', '1'),
(1872, 'enrol_ldap', 'template', ''),
(1873, 'enrol_ldap', 'course_shortname_updateonsync', '0'),
(1874, 'enrol_ldap', 'course_fullname_updateonsync', '0'),
(1875, 'enrol_ldap', 'course_summary_updateonsync', '0'),
(1876, 'enrol_ldap', 'nested_groups', '0'),
(1877, 'enrol_ldap', 'group_memberofattribute', ''),
(1878, 'enrol_manual', 'expiredaction', '1'),
(1879, 'enrol_manual', 'expirynotifyhour', '6'),
(1880, 'enrol_manual', 'defaultenrol', '1'),
(1881, 'enrol_manual', 'status', '0'),
(1882, 'enrol_manual', 'roleid', '5'),
(1883, 'enrol_manual', 'enrolstart', '4'),
(1884, 'enrol_manual', 'enrolperiod', '0'),
(1885, 'enrol_manual', 'expirynotify', '0'),
(1886, 'enrol_manual', 'expirythreshold', '86400'),
(1887, 'enrol_mnet', 'roleid', '5'),
(1888, 'enrol_mnet', 'roleid_adv', '1'),
(1889, 'enrol_paypal', 'paypalbusiness', ''),
(1890, 'enrol_paypal', 'mailstudents', '0');
INSERT INTO `[[dbprefix]]config_plugins` VALUES
(1891, 'enrol_paypal', 'mailteachers', '0'),
(1892, 'enrol_paypal', 'mailadmins', '0'),
(1893, 'enrol_paypal', 'expiredaction', '3'),
(1894, 'enrol_paypal', 'status', '1'),
(1895, 'enrol_paypal', 'cost', '0'),
(1896, 'enrol_paypal', 'currency', 'USD'),
(1897, 'enrol_paypal', 'roleid', '5'),
(1898, 'enrol_paypal', 'enrolperiod', '0'),
(1899, 'enrol_lti', 'emaildisplay', '2'),
(1900, 'enrol_lti', 'city', ''),
(1901, 'enrol_lti', 'country', ''),
(1902, 'enrol_lti', 'timezone', '99'),
(1903, 'enrol_lti', 'lang', 'en'),
(1904, 'enrol_lti', 'institution', ''),
(1905, 'enrol_self', 'requirepassword', '0'),
(1906, 'enrol_self', 'usepasswordpolicy', '0'),
(1907, 'enrol_self', 'showhint', '0'),
(1908, 'enrol_self', 'expiredaction', '1'),
(1909, 'enrol_self', 'expirynotifyhour', '6'),
(1910, 'enrol_self', 'defaultenrol', '1'),
(1911, 'enrol_self', 'status', '1'),
(1912, 'enrol_self', 'newenrols', '1'),
(1913, 'enrol_self', 'groupkey', '0'),
(1914, 'enrol_self', 'roleid', '5'),
(1915, 'enrol_self', 'enrolperiod', '0'),
(1916, 'enrol_self', 'expirynotify', '0'),
(1917, 'enrol_self', 'expirythreshold', '86400'),
(1918, 'enrol_self', 'longtimenosee', '0'),
(1919, 'enrol_self', 'maxenrolled', '0'),
(1920, 'enrol_self', 'sendcoursewelcomemessage', '1'),
(1921, 'filter_urltolink', 'formats', '1,4,0'),
(1922, 'filter_urltolink', 'embedimages', '1'),
(1923, 'filter_emoticon', 'formats', '1,4,0'),
(1924, 'filter_displayh5p', 'allowedsources', ''),
(1925, 'filter_mathjaxloader', 'httpsurl', 'https://cdn.jsdelivr.net/npm/mathjax@2.7.9/MathJax.js'),
(1926, 'filter_mathjaxloader', 'texfiltercompatibility', '0'),
(1927, 'filter_mathjaxloader', 'mathjaxconfig', '\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n'),
(1928, 'filter_mathjaxloader', 'additionaldelimiters', ''),
(1929, 'filter_tex', 'latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n'),
(1930, 'filter_tex', 'latexbackground', '#FFFFFF'),
(1931, 'filter_tex', 'density', '120'),
(1932, 'filter_tex', 'pathlatex', '/usr/bin/latex'),
(1933, 'filter_tex', 'pathdvips', '/usr/bin/dvips'),
(1934, 'filter_tex', 'pathconvert', '/usr/bin/convert'),
(1935, 'filter_tex', 'pathdvisvgm', '/usr/bin/dvisvgm'),
(1936, 'filter_tex', 'pathmimetex', ''),
(1937, 'filter_tex', 'convertformat', 'gif'),
(1938, 'logstore_database', 'dbdriver', ''),
(1939, 'logstore_database', 'dbhost', ''),
(1940, 'logstore_database', 'dbuser', ''),
(1941, 'logstore_database', 'dbpass', ''),
(1942, 'logstore_database', 'dbname', ''),
(1943, 'logstore_database', 'dbtable', ''),
(1944, 'logstore_database', 'dbpersist', '0'),
(1945, 'logstore_database', 'dbsocket', ''),
(1946, 'logstore_database', 'dbport', ''),
(1947, 'logstore_database', 'dbschema', ''),
(1948, 'logstore_database', 'dbcollation', ''),
(1949, 'logstore_database', 'dbhandlesoptions', '0'),
(1950, 'logstore_database', 'buffersize', '50'),
(1951, 'logstore_database', 'jsonformat', '1'),
(1952, 'logstore_database', 'logguests', '0'),
(1953, 'logstore_database', 'includelevels', '1,2,0'),
(1954, 'logstore_database', 'includeactions', 'c,r,u,d'),
(1955, 'logstore_legacy', 'loglegacy', '0'),
(1956, 'logstore_standard', 'logguests', '1'),
(1957, 'logstore_standard', 'jsonformat', '1'),
(1958, 'logstore_standard', 'loglifetime', '0'),
(1959, 'logstore_standard', 'buffersize', '50'),
(1960, 'mlbackend_python', 'useserver', '0'),
(1961, 'mlbackend_python', 'host', ''),
(1962, 'mlbackend_python', 'port', '0'),
(1963, 'mlbackend_python', 'secure', '0'),
(1964, 'mlbackend_python', 'username', 'default'),
(1965, 'mlbackend_python', 'password', ''),
(1966, 'media_videojs', 'videoextensions', 'html_video,media_source,.f4v,.flv'),
(1967, 'media_videojs', 'audioextensions', 'html_audio'),
(1968, 'media_videojs', 'rtmp', '0'),
(1969, 'media_videojs', 'useflash', '0'),
(1970, 'media_videojs', 'youtube', '1'),
(1971, 'media_videojs', 'videocssclass', 'video-js'),
(1972, 'media_videojs', 'audiocssclass', 'video-js'),
(1973, 'media_videojs', 'limitsize', '1'),
(1974, 'paygw_paypal', 'surcharge', '0'),
(1975, 'qtype_multichoice', 'answerhowmany', '1'),
(1976, 'qtype_multichoice', 'shuffleanswers', '1'),
(1977, 'qtype_multichoice', 'answernumbering', 'abc'),
(1978, 'editor_atto', 'toolbar', 'collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html'),
(1979, 'editor_atto', 'autosavefrequency', '60'),
(1980, 'atto_collapse', 'showgroups', '5'),
(1981, 'atto_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n'),
(1982, 'atto_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n'),
(1983, 'atto_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n'),
(1984, 'atto_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n'),
(1985, 'atto_recordrtc', 'allowedtypes', 'both'),
(1986, 'atto_recordrtc', 'audiobitrate', '128000'),
(1987, 'atto_recordrtc', 'videobitrate', '2500000'),
(1988, 'atto_recordrtc', 'timelimit', '120'),
(1989, 'atto_table', 'allowborders', '0'),
(1990, 'atto_table', 'allowbackgroundcolour', '0'),
(1991, 'atto_table', 'allowwidth', '0'),
(1992, 'editor_tinymce', 'customtoolbar', 'wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen'),
(1993, 'editor_tinymce', 'fontselectlist', 'Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings'),
(1994, 'editor_tinymce', 'customconfig', ''),
(1995, 'tinymce_moodleemoticon', 'requireemoticon', '1'),
(1996, 'tinymce_spellchecker', 'spellengine', ''),
(1997, 'tinymce_spellchecker', 'spelllanguagelist', '+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv'),
(1998, 'tool_mobile', 'apppolicy', ''),
(1999, 'tool_mobile', 'typeoflogin', '1'),
(2000, 'tool_mobile', 'qrcodetype', '1'),
(2001, 'tool_mobile', 'forcedurlscheme', 'moodlemobile'),
(2002, 'tool_mobile', 'minimumversion', ''),
(2003, 'tool_mobile', 'enablesmartappbanners', '0'),
(2004, 'tool_mobile', 'iosappid', '633359593'),
(2005, 'tool_mobile', 'androidappid', 'com.moodle.moodlemobile'),
(2006, 'tool_mobile', 'setuplink', 'https://download.moodle.org/mobile'),
(2007, 'tool_mobile', 'forcelogout', '0'),
(2008, 'tool_mobile', 'disabledfeatures', ''),
(2009, 'tool_mobile', 'custommenuitems', ''),
(2010, 'tool_mobile', 'filetypeexclusionlist', ''),
(2011, 'tool_mobile', 'customlangstrings', ''),
(2012, 'tool_moodlenet', 'enablemoodlenet', '0'),
(2013, 'tool_moodlenet', 'defaultmoodlenetname', 'MoodleNet Central'),
(2014, 'tool_moodlenet', 'defaultmoodlenet', 'https://moodle.net');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contentbank_content`
--

CREATE TABLE `[[dbprefix]]contentbank_content` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contenttype` varchar(100) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `visibility` tinyint(1) NOT NULL DEFAULT '1',
  `instanceid` bigint(10) DEFAULT NULL,
  `configdata` longtext,
  `usercreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]contcont_nam_ix` (`name`),
  KEY `[[dbprefix]]contcont_conconins_ix` (`contextid`,`contenttype`,`instanceid`),
  KEY `[[dbprefix]]contcont_con_ix` (`contextid`),
  KEY `[[dbprefix]]contcont_use_ix` (`usermodified`),
  KEY `[[dbprefix]]contcont_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores content data in the content bank.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]context`
--

CREATE TABLE `[[dbprefix]]context` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) DEFAULT NULL,
  `depth` tinyint(2) NOT NULL DEFAULT '0',
  `locked` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]cont_conins_uix` (`contextlevel`,`instanceid`),
  KEY `[[dbprefix]]cont_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]cont_pat_ix` (`path`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='one of these must be set' AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]context`
--

INSERT INTO `[[dbprefix]]context` VALUES
(1, 10, 0, '/1', 1, 0),
(2, 50, 1, '/1/2', 2, 0),
(3, 40, 1, '/1/3', 2, 0),
(4, 30, 1, '/1/4', 2, 0),
(5, 30, 2, '/1/5', 2, 0),
(6, 80, 1, '/1/6', 2, 0),
(7, 80, 2, '/1/7', 2, 0),
(8, 80, 3, '/1/8', 2, 0),
(9, 80, 4, '/1/9', 2, 0),
(10, 80, 5, '/1/10', 2, 0),
(11, 80, 6, '/1/11', 2, 0),
(12, 80, 7, '/1/12', 2, 0),
(13, 80, 8, '/1/13', 2, 0),
(14, 80, 9, '/1/14', 2, 0),
(15, 80, 10, '/1/15', 2, 0),
(16, 80, 11, '/1/5/16', 3, 0),
(17, 80, 12, '/1/5/17', 3, 0),
(18, 80, 13, '/1/5/18', 3, 0),
(19, 80, 14, '/1/5/19', 3, 0),
(20, 80, 15, '/1/5/20', 3, 0),
(21, 80, 16, '/1/5/21', 3, 0),
(22, 80, 17, '/1/5/22', 3, 0),
(23, 80, 18, '/1/5/23', 3, 0),
(24, 80, 19, '/1/5/24', 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]context_temp`
--

CREATE TABLE `[[dbprefix]]context_temp` (
  `id` bigint(10) NOT NULL,
  `path` varchar(255) NOT NULL DEFAULT '',
  `depth` tinyint(2) NOT NULL,
  `locked` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Used by build_context_path() in upgrade and cron to keep con';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course`
--

CREATE TABLE `[[dbprefix]]course` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `fullname` varchar(254) NOT NULL DEFAULT '',
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `summary` longtext,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `format` varchar(21) NOT NULL DEFAULT 'topics',
  `showgrades` tinyint(2) NOT NULL DEFAULT '1',
  `newsitems` mediumint(5) NOT NULL DEFAULT '1',
  `startdate` bigint(10) NOT NULL DEFAULT '0',
  `enddate` bigint(10) NOT NULL DEFAULT '0',
  `relativedatesmode` tinyint(1) NOT NULL DEFAULT '0',
  `marker` bigint(10) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) NOT NULL DEFAULT '0',
  `showreports` smallint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `downloadcontent` tinyint(1) DEFAULT NULL,
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupmodeforce` smallint(4) NOT NULL DEFAULT '0',
  `defaultgroupingid` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) NOT NULL DEFAULT '',
  `calendartype` varchar(30) NOT NULL DEFAULT '',
  `theme` varchar(50) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requested` tinyint(1) NOT NULL DEFAULT '0',
  `enablecompletion` tinyint(1) NOT NULL DEFAULT '0',
  `completionnotify` tinyint(1) NOT NULL DEFAULT '0',
  `cacherev` bigint(10) NOT NULL DEFAULT '0',
  `originalcourseid` bigint(10) DEFAULT NULL,
  `showactivitydates` tinyint(1) NOT NULL DEFAULT '0',
  `showcompletionconditions` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cour_cat_ix` (`category`),
  KEY `[[dbprefix]]cour_idn_ix` (`idnumber`),
  KEY `[[dbprefix]]cour_sho_ix` (`shortname`),
  KEY `[[dbprefix]]cour_sor_ix` (`sortorder`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Central course table' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course`
--

INSERT INTO `[[dbprefix]]course` VALUES
(1, 0, 0, '[[site_name]]', '[[site_desc]]', '', '', 0, 'site', 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 1, NULL, 0, 0, 0, '', '', '', [[timestamp]], [[timestamp]], 0, 0, 0, [[timestamp]], NULL, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_categories`
--

CREATE TABLE `[[dbprefix]]course_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `idnumber` varchar(100) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `coursecount` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `theme` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcate_par_ix` (`parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course categories' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course_categories`
--

INSERT INTO `[[dbprefix]]course_categories` VALUES
(1, 'Miscellaneous', NULL, NULL, 0, 0, 10000, 0, 1, 1, [[timestamp]], 1, '/1', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completions`
--

CREATE TABLE `[[dbprefix]]course_completions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `timeenrolled` bigint(10) NOT NULL DEFAULT '0',
  `timestarted` bigint(10) NOT NULL DEFAULT '0',
  `timecompleted` bigint(10) DEFAULT NULL,
  `reaggregate` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcomp_usecou_uix` (`userid`,`course`),
  KEY `[[dbprefix]]courcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]courcomp_cou_ix` (`course`),
  KEY `[[dbprefix]]courcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course completion records' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_aggr_methd`
--

CREATE TABLE `[[dbprefix]]course_completion_aggr_methd` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '0',
  `value` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcompaggrmeth_co_uix` (`course`,`criteriatype`),
  KEY `[[dbprefix]]courcompaggrmeth_cou_ix` (`course`),
  KEY `[[dbprefix]]courcompaggrmeth_cri_ix` (`criteriatype`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course completion aggregation methods for criteria' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_criteria`
--

CREATE TABLE `[[dbprefix]]course_completion_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) NOT NULL DEFAULT '0',
  `module` varchar(100) DEFAULT NULL,
  `moduleinstance` bigint(10) DEFAULT NULL,
  `courseinstance` bigint(10) DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT NULL,
  `timeend` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) DEFAULT NULL,
  `role` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcompcrit_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course completion criteria' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_crit_compl`
--

CREATE TABLE `[[dbprefix]]course_completion_crit_compl` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriaid` bigint(10) NOT NULL DEFAULT '0',
  `gradefinal` decimal(10,5) DEFAULT NULL,
  `unenroled` bigint(10) DEFAULT NULL,
  `timecompleted` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcompcritcomp_us_uix` (`userid`,`course`,`criteriaid`),
  KEY `[[dbprefix]]courcompcritcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]courcompcritcomp_cou_ix` (`course`),
  KEY `[[dbprefix]]courcompcritcomp_cri_ix` (`criteriaid`),
  KEY `[[dbprefix]]courcompcritcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course completion user records' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_defaults`
--

CREATE TABLE `[[dbprefix]]course_completion_defaults` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL,
  `module` bigint(10) NOT NULL,
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionusegrade` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) NOT NULL DEFAULT '0',
  `customrules` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcompdefa_coumod_uix` (`course`,`module`),
  KEY `[[dbprefix]]courcompdefa_mod_ix` (`module`),
  KEY `[[dbprefix]]courcompdefa_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Default settings for activities completion' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_format_options`
--

CREATE TABLE `[[dbprefix]]course_format_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `format` varchar(21) NOT NULL DEFAULT '',
  `sectionid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courformopti_coufor_uix` (`courseid`,`format`,`sectionid`,`name`),
  KEY `[[dbprefix]]courformopti_cou_ix` (`courseid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores format-specific options for the course or course sect' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course_format_options`
--

INSERT INTO `[[dbprefix]]course_format_options` VALUES
(1, 1, 'site', 0, 'numsections', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules`
--

CREATE TABLE `[[dbprefix]]course_modules` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `module` bigint(10) NOT NULL DEFAULT '0',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `idnumber` varchar(100) DEFAULT NULL,
  `added` bigint(10) NOT NULL DEFAULT '0',
  `score` smallint(4) NOT NULL DEFAULT '0',
  `indent` mediumint(5) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleoncoursepage` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupingid` bigint(10) NOT NULL DEFAULT '0',
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completiongradeitemnumber` bigint(10) DEFAULT NULL,
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) NOT NULL DEFAULT '0',
  `showdescription` tinyint(1) NOT NULL DEFAULT '0',
  `availability` longtext,
  `deletioninprogress` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courmodu_vis_ix` (`visible`),
  KEY `[[dbprefix]]courmodu_cou_ix` (`course`),
  KEY `[[dbprefix]]courmodu_mod_ix` (`module`),
  KEY `[[dbprefix]]courmodu_ins_ix` (`instance`),
  KEY `[[dbprefix]]courmodu_idncou_ix` (`idnumber`,`course`),
  KEY `[[dbprefix]]courmodu_gro_ix` (`groupingid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='course_modules table retrofitted from MySQL' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules_completion`
--

CREATE TABLE `[[dbprefix]]course_modules_completion` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `completionstate` tinyint(1) NOT NULL,
  `viewed` tinyint(1) DEFAULT NULL,
  `overrideby` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courmoducomp_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `[[dbprefix]]courmoducomp_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the completion state (completed or not completed, etc' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_published`
--

CREATE TABLE `[[dbprefix]]course_published` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `huburl` varchar(255) DEFAULT NULL,
  `courseid` bigint(10) NOT NULL,
  `timepublished` bigint(10) NOT NULL,
  `enrollable` tinyint(1) NOT NULL DEFAULT '1',
  `hubcourseid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `timechecked` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about how and when an local courses were publish' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_request`
--

CREATE TABLE `[[dbprefix]]course_request` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(254) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `summary` longtext NOT NULL,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `category` bigint(10) NOT NULL DEFAULT '0',
  `reason` longtext NOT NULL,
  `requester` bigint(10) NOT NULL DEFAULT '0',
  `password` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courrequ_sho_ix` (`shortname`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='course requests' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_sections`
--

CREATE TABLE `[[dbprefix]]course_sections` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `summary` longtext,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `sequence` longtext,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `availability` longtext,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]coursect_cousec_uix` (`course`,`section`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='to define the sections for each course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customfield_category`
--

CREATE TABLE `[[dbprefix]]customfield_category` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `area` varchar(100) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL DEFAULT '0',
  `contextid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]custcate_comareiteso_ix` (`component`,`area`,`itemid`,`sortorder`),
  KEY `[[dbprefix]]custcate_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='core_customfield category table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customfield_data`
--

CREATE TABLE `[[dbprefix]]customfield_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fieldid` bigint(10) NOT NULL,
  `instanceid` bigint(10) NOT NULL,
  `intvalue` bigint(10) DEFAULT NULL,
  `decvalue` decimal(10,5) DEFAULT NULL,
  `shortcharvalue` varchar(255) DEFAULT NULL,
  `charvalue` varchar(1333) DEFAULT NULL,
  `value` longtext NOT NULL,
  `valueformat` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `contextid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]custdata_insfie_uix` (`instanceid`,`fieldid`),
  KEY `[[dbprefix]]custdata_fieint_ix` (`fieldid`,`intvalue`),
  KEY `[[dbprefix]]custdata_fiesho_ix` (`fieldid`,`shortcharvalue`),
  KEY `[[dbprefix]]custdata_fiedec_ix` (`fieldid`,`decvalue`),
  KEY `[[dbprefix]]custdata_fie_ix` (`fieldid`),
  KEY `[[dbprefix]]custdata_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='core_customfield data table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customfield_field`
--

CREATE TABLE `[[dbprefix]]customfield_field` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(400) NOT NULL DEFAULT '',
  `type` varchar(100) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `configdata` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]custfiel_catsor_ix` (`categoryid`,`sortorder`),
  KEY `[[dbprefix]]custfiel_cat_ix` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='core_customfield field table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data`
--

CREATE TABLE `[[dbprefix]]data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `comments` smallint(4) NOT NULL DEFAULT '0',
  `timeavailablefrom` bigint(10) NOT NULL DEFAULT '0',
  `timeavailableto` bigint(10) NOT NULL DEFAULT '0',
  `timeviewfrom` bigint(10) NOT NULL DEFAULT '0',
  `timeviewto` bigint(10) NOT NULL DEFAULT '0',
  `requiredentries` int(8) NOT NULL DEFAULT '0',
  `requiredentriestoview` int(8) NOT NULL DEFAULT '0',
  `maxentries` int(8) NOT NULL DEFAULT '0',
  `rssarticles` smallint(4) NOT NULL DEFAULT '0',
  `singletemplate` longtext,
  `listtemplate` longtext,
  `listtemplateheader` longtext,
  `listtemplatefooter` longtext,
  `addtemplate` longtext,
  `rsstemplate` longtext,
  `rsstitletemplate` longtext,
  `csstemplate` longtext,
  `jstemplate` longtext,
  `asearchtemplate` longtext,
  `approval` smallint(4) NOT NULL DEFAULT '0',
  `manageapproved` smallint(4) NOT NULL DEFAULT '1',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `defaultsort` bigint(10) NOT NULL DEFAULT '0',
  `defaultsortdir` smallint(4) NOT NULL DEFAULT '0',
  `editany` smallint(4) NOT NULL DEFAULT '0',
  `notification` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `config` longtext,
  `completionentries` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]data_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all database activities' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_content`
--

CREATE TABLE `[[dbprefix]]data_content` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fieldid` bigint(10) NOT NULL DEFAULT '0',
  `recordid` bigint(10) NOT NULL DEFAULT '0',
  `content` longtext,
  `content1` longtext,
  `content2` longtext,
  `content3` longtext,
  `content4` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datacont_rec_ix` (`recordid`),
  KEY `[[dbprefix]]datacont_fie_ix` (`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='the content introduced in each record/fields' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_fields`
--

CREATE TABLE `[[dbprefix]]data_fields` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `type` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `param1` longtext,
  `param2` longtext,
  `param3` longtext,
  `param4` longtext,
  `param5` longtext,
  `param6` longtext,
  `param7` longtext,
  `param8` longtext,
  `param9` longtext,
  `param10` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datafiel_typdat_ix` (`type`,`dataid`),
  KEY `[[dbprefix]]datafiel_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='every field available' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_records`
--

CREATE TABLE `[[dbprefix]]data_records` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `approved` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datareco_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='every record introduced' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]editor_atto_autosave`
--

CREATE TABLE `[[dbprefix]]editor_atto_autosave` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `elementid` varchar(255) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `pagehash` varchar(64) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `drafttext` longtext NOT NULL,
  `draftid` bigint(10) DEFAULT NULL,
  `pageinstance` varchar(64) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]editattoauto_elecon_uix` (`elementid`,`contextid`,`userid`,`pagehash`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Draft text that is auto-saved every 5 seconds while an edito' AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol`
--

CREATE TABLE `[[dbprefix]]enrol` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrol` varchar(20) NOT NULL DEFAULT '',
  `status` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT '0',
  `enrolstartdate` bigint(10) DEFAULT '0',
  `enrolenddate` bigint(10) DEFAULT '0',
  `expirynotify` tinyint(1) DEFAULT '0',
  `expirythreshold` bigint(10) DEFAULT '0',
  `notifyall` tinyint(1) DEFAULT '0',
  `password` varchar(50) DEFAULT NULL,
  `cost` varchar(20) DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `roleid` bigint(10) DEFAULT '0',
  `customint1` bigint(10) DEFAULT NULL,
  `customint2` bigint(10) DEFAULT NULL,
  `customint3` bigint(10) DEFAULT NULL,
  `customint4` bigint(10) DEFAULT NULL,
  `customint5` bigint(10) DEFAULT NULL,
  `customint6` bigint(10) DEFAULT NULL,
  `customint7` bigint(10) DEFAULT NULL,
  `customint8` bigint(10) DEFAULT NULL,
  `customchar1` varchar(255) DEFAULT NULL,
  `customchar2` varchar(255) DEFAULT NULL,
  `customchar3` varchar(1333) DEFAULT NULL,
  `customdec1` decimal(12,7) DEFAULT NULL,
  `customdec2` decimal(12,7) DEFAULT NULL,
  `customtext1` longtext,
  `customtext2` longtext,
  `customtext3` longtext,
  `customtext4` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enro_enr_ix` (`enrol`),
  KEY `[[dbprefix]]enro_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Instances of enrolment plugins used in courses, fields marke' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_flatfile`
--

CREATE TABLE `[[dbprefix]]enrol_flatfile` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` varchar(30) NOT NULL DEFAULT '',
  `roleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroflat_cou_ix` (`courseid`),
  KEY `[[dbprefix]]enroflat_use_ix` (`userid`),
  KEY `[[dbprefix]]enroflat_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='enrol_flatfile table retrofitted from MySQL' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_consumer`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_consumer` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `consumerkey256` varchar(255) NOT NULL DEFAULT '',
  `consumerkey` longtext,
  `secret` varchar(1024) NOT NULL DEFAULT '',
  `ltiversion` varchar(10) DEFAULT NULL,
  `consumername` varchar(255) DEFAULT NULL,
  `consumerversion` varchar(255) DEFAULT NULL,
  `consumerguid` varchar(1024) DEFAULT NULL,
  `profile` longtext,
  `toolproxy` longtext,
  `settings` longtext,
  `protected` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `enablefrom` bigint(10) DEFAULT NULL,
  `enableuntil` bigint(10) DEFAULT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltilti2cons_con_uix` (`consumerkey256`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='LTI consumers interacting with moodle' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_context`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_context` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `consumerid` bigint(11) NOT NULL,
  `lticontextkey` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(100) DEFAULT NULL,
  `settings` longtext,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2cont_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about a specific LTI contexts from the consumers' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_nonce`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_nonce` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `consumerid` bigint(11) NOT NULL,
  `value` varchar(64) NOT NULL DEFAULT '',
  `expires` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2nonc_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Nonce used for authentication between moodle and a consumer' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_resource_link`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_resource_link` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(11) DEFAULT NULL,
  `consumerid` bigint(11) DEFAULT NULL,
  `ltiresourcelinkkey` varchar(255) NOT NULL DEFAULT '',
  `settings` longtext,
  `primaryresourcelinkid` bigint(11) DEFAULT NULL,
  `shareapproved` tinyint(1) DEFAULT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2resolink__ix` (`contextid`),
  KEY `[[dbprefix]]enroltilti2resolink2_ix` (`primaryresourcelinkid`),
  KEY `[[dbprefix]]enroltilti2resolink3_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link from the consumer to the tool' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_share_key`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_share_key` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `sharekey` varchar(32) NOT NULL DEFAULT '',
  `resourcelinkid` bigint(11) NOT NULL,
  `autoapprove` tinyint(1) NOT NULL,
  `expires` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltilti2sharkey__uix` (`sharekey`),
  UNIQUE KEY `[[dbprefix]]enroltilti2sharkey2_uix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Resource link share key' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_tool_proxy`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_tool_proxy` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `toolproxykey` varchar(32) NOT NULL DEFAULT '',
  `consumerid` bigint(11) NOT NULL,
  `toolproxy` longtext NOT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltilti2toolprox_uix` (`toolproxykey`),
  KEY `[[dbprefix]]enroltilti2toolprox__ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A tool proxy between moodle and a consumer' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_user_result`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_user_result` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `resourcelinkid` bigint(11) NOT NULL,
  `ltiuserkey` varchar(255) NOT NULL DEFAULT '',
  `ltiresultsourcedid` varchar(1024) NOT NULL DEFAULT '',
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2userresu__ix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Results for each user for each resource link' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_tools`
--

CREATE TABLE `[[dbprefix]]enrol_lti_tools` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrolid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `institution` varchar(40) NOT NULL DEFAULT '',
  `lang` varchar(30) NOT NULL DEFAULT 'en',
  `timezone` varchar(100) NOT NULL DEFAULT '99',
  `maxenrolled` bigint(10) NOT NULL DEFAULT '0',
  `maildisplay` tinyint(2) NOT NULL DEFAULT '2',
  `city` varchar(120) NOT NULL DEFAULT '',
  `country` varchar(2) NOT NULL DEFAULT '',
  `gradesync` tinyint(1) NOT NULL DEFAULT '0',
  `gradesynccompletion` tinyint(1) NOT NULL DEFAULT '0',
  `membersync` tinyint(1) NOT NULL DEFAULT '0',
  `membersyncmode` tinyint(1) NOT NULL DEFAULT '0',
  `roleinstructor` bigint(10) NOT NULL,
  `rolelearner` bigint(10) NOT NULL,
  `secret` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltitool_enr_ix` (`enrolid`),
  KEY `[[dbprefix]]enroltitool_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of tools provided to the remote system' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_tool_consumer_map`
--

CREATE TABLE `[[dbprefix]]enrol_lti_tool_consumer_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `toolid` bigint(11) NOT NULL,
  `consumerid` bigint(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltitoolconsmap_t_ix` (`toolid`),
  KEY `[[dbprefix]]enroltitoolconsmap_c_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table that maps the published tool to tool consumers.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_users`
--

CREATE TABLE `[[dbprefix]]enrol_lti_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `toolid` bigint(10) NOT NULL,
  `serviceurl` longtext,
  `sourceid` longtext,
  `consumerkey` longtext,
  `consumersecret` longtext,
  `membershipsurl` longtext,
  `membershipsid` longtext,
  `lastgrade` decimal(10,5) DEFAULT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltiuser_use_ix` (`userid`),
  KEY `[[dbprefix]]enroltiuser_too_ix` (`toolid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='User access log and gradeback data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_paypal`
--

CREATE TABLE `[[dbprefix]]enrol_paypal` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `business` varchar(255) NOT NULL DEFAULT '',
  `receiver_email` varchar(255) NOT NULL DEFAULT '',
  `receiver_id` varchar(255) NOT NULL DEFAULT '',
  `item_name` varchar(255) NOT NULL DEFAULT '',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `memo` varchar(255) NOT NULL DEFAULT '',
  `tax` varchar(255) NOT NULL DEFAULT '',
  `option_name1` varchar(255) NOT NULL DEFAULT '',
  `option_selection1_x` varchar(255) NOT NULL DEFAULT '',
  `option_name2` varchar(255) NOT NULL DEFAULT '',
  `option_selection2_x` varchar(255) NOT NULL DEFAULT '',
  `payment_status` varchar(255) NOT NULL DEFAULT '',
  `pending_reason` varchar(255) NOT NULL DEFAULT '',
  `reason_code` varchar(30) NOT NULL DEFAULT '',
  `txn_id` varchar(255) NOT NULL DEFAULT '',
  `parent_txn_id` varchar(255) NOT NULL DEFAULT '',
  `payment_type` varchar(30) NOT NULL DEFAULT '',
  `timeupdated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enropayp_bus_ix` (`business`),
  KEY `[[dbprefix]]enropayp_rec_ix` (`receiver_email`),
  KEY `[[dbprefix]]enropayp_cou_ix` (`courseid`),
  KEY `[[dbprefix]]enropayp_use_ix` (`userid`),
  KEY `[[dbprefix]]enropayp_ins_ix` (`instanceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Holds all known information about PayPal transactions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event`
--

CREATE TABLE `[[dbprefix]]event` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `description` longtext NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `repeatid` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) DEFAULT NULL,
  `modulename` varchar(20) NOT NULL DEFAULT '',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `type` smallint(4) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) NOT NULL DEFAULT '',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeduration` bigint(10) NOT NULL DEFAULT '0',
  `timesort` bigint(10) DEFAULT NULL,
  `visible` smallint(4) NOT NULL DEFAULT '1',
  `uuid` varchar(255) NOT NULL DEFAULT '',
  `sequence` bigint(10) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `subscriptionid` bigint(10) DEFAULT NULL,
  `priority` bigint(10) DEFAULT NULL,
  `location` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]even_cou_ix` (`courseid`),
  KEY `[[dbprefix]]even_use_ix` (`userid`),
  KEY `[[dbprefix]]even_tim_ix` (`timestart`),
  KEY `[[dbprefix]]even_tim2_ix` (`timeduration`),
  KEY `[[dbprefix]]even_uui_ix` (`uuid`),
  KEY `[[dbprefix]]even_typtim_ix` (`type`,`timesort`),
  KEY `[[dbprefix]]even_grocoucatvisuse_ix` (`groupid`,`courseid`,`categoryid`,`visible`,`userid`),
  KEY `[[dbprefix]]even_eve_ix` (`eventtype`),
  KEY `[[dbprefix]]even_comeveins_ix` (`component`,`eventtype`,`instance`),
  KEY `[[dbprefix]]even_modinseve_ix` (`modulename`,`instance`,`eventtype`),
  KEY `[[dbprefix]]even_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]even_sub_ix` (`subscriptionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='For everything with a time associated to it' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_handlers`
--

CREATE TABLE `[[dbprefix]]events_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(166) NOT NULL DEFAULT '',
  `component` varchar(166) NOT NULL DEFAULT '',
  `handlerfile` varchar(255) NOT NULL DEFAULT '',
  `handlerfunction` longtext,
  `schedule` varchar(255) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `internal` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]evenhand_evecom_uix` (`eventname`,`component`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table is for storing which components requests what typ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_queue`
--

CREATE TABLE `[[dbprefix]]events_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventdata` longtext NOT NULL,
  `stackdump` longtext,
  `userid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]evenqueu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table is for storing queued events. It stores only one ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_queue_handlers`
--

CREATE TABLE `[[dbprefix]]events_queue_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `queuedeventid` bigint(10) NOT NULL,
  `handlerid` bigint(10) NOT NULL,
  `status` bigint(10) DEFAULT NULL,
  `errormessage` longtext,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]evenqueuhand_que_ix` (`queuedeventid`),
  KEY `[[dbprefix]]evenqueuhand_han_ix` (`handlerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This is the list of queued handlers for processing. The even' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event_subscriptions`
--

CREATE TABLE `[[dbprefix]]event_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL DEFAULT '',
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) NOT NULL DEFAULT '',
  `pollinterval` bigint(10) NOT NULL DEFAULT '0',
  `lastupdated` bigint(10) DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tracks subscriptions to remote calendars.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_functions`
--

CREATE TABLE `[[dbprefix]]external_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `classname` varchar(100) NOT NULL DEFAULT '',
  `methodname` varchar(100) NOT NULL DEFAULT '',
  `classpath` varchar(255) DEFAULT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `capabilities` varchar(255) DEFAULT NULL,
  `services` varchar(1333) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]extefunc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='list of all external functions' AUTO_INCREMENT=619 ;

--
-- Dumping data for table `[[dbprefix]]external_functions`
--

INSERT INTO `[[dbprefix]]external_functions` VALUES
(1, 'core_auth_confirm_user', 'core_auth_external', 'confirm_user', NULL, 'moodle', '', NULL),
(2, 'core_auth_request_password_reset', 'core_auth_external', 'request_password_reset', NULL, 'moodle', '', NULL),
(3, 'core_auth_is_minor', 'core_auth_external', 'is_minor', NULL, 'moodle', '', NULL),
(4, 'core_auth_is_age_digital_consent_verification_enabled', 'core_auth_external', 'is_age_digital_consent_verification_enabled', NULL, 'moodle', '', NULL),
(5, 'core_auth_resend_confirmation_email', 'core_auth_external', 'resend_confirmation_email', NULL, 'moodle', '', NULL),
(6, 'core_backup_get_async_backup_progress', 'core_backup_external', 'get_async_backup_progress', 'backup/externallib.php', 'moodle', '', NULL),
(7, 'core_backup_get_async_backup_links_backup', 'core_backup_external', 'get_async_backup_links_backup', 'backup/externallib.php', 'moodle', '', NULL),
(8, 'core_backup_get_async_backup_links_restore', 'core_backup_external', 'get_async_backup_links_restore', 'backup/externallib.php', 'moodle', '', NULL),
(9, 'core_backup_get_copy_progress', 'core_backup_external', 'get_copy_progress', 'backup/externallib.php', 'moodle', '', NULL),
(10, 'core_backup_submit_copy_form', 'core_backup_external', 'submit_copy_form', 'backup/externallib.php', 'moodle', '', NULL),
(11, 'core_badges_get_user_badges', 'core_badges_external', 'get_user_badges', NULL, 'moodle', 'moodle/badges:viewotherbadges', 'moodle_mobile_app'),
(12, 'core_blog_get_entries', 'core_blog\\external', 'get_entries', NULL, 'moodle', '', 'moodle_mobile_app'),
(13, 'core_blog_view_entries', 'core_blog\\external', 'view_entries', NULL, 'moodle', '', 'moodle_mobile_app'),
(14, 'core_calendar_get_calendar_monthly_view', 'core_calendar_external', 'get_calendar_monthly_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(15, 'core_calendar_get_calendar_day_view', 'core_calendar_external', 'get_calendar_day_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(16, 'core_calendar_get_calendar_upcoming_view', 'core_calendar_external', 'get_calendar_upcoming_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(17, 'core_calendar_update_event_start_day', 'core_calendar_external', 'update_event_start_day', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(18, 'core_calendar_create_calendar_events', 'core_calendar_external', 'create_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(19, 'core_calendar_delete_calendar_events', 'core_calendar_external', 'delete_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(20, 'core_calendar_get_calendar_events', 'core_calendar_external', 'get_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(21, 'core_calendar_get_action_events_by_timesort', 'core_calendar_external', 'get_calendar_action_events_by_timesort', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(22, 'core_calendar_get_action_events_by_course', 'core_calendar_external', 'get_calendar_action_events_by_course', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(23, 'core_calendar_get_action_events_by_courses', 'core_calendar_external', 'get_calendar_action_events_by_courses', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(24, 'core_calendar_get_calendar_event_by_id', 'core_calendar_external', 'get_calendar_event_by_id', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(25, 'core_calendar_submit_create_update_form', 'core_calendar_external', 'submit_create_update_form', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(26, 'core_calendar_get_calendar_access_information', 'core_calendar_external', 'get_calendar_access_information', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(27, 'core_calendar_get_allowed_event_types', 'core_calendar_external', 'get_allowed_event_types', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(28, 'core_calendar_get_timestamps', 'core_calendar_external', 'get_timestamps', 'calendar/externallib.php', 'moodle', '', NULL),
(29, 'core_calendar_get_calendar_export_token', 'core_calendar\\external\\export\\token', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(30, 'core_cohort_add_cohort_members', 'core_cohort_external', 'add_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:assign', NULL),
(31, 'core_cohort_create_cohorts', 'core_cohort_external', 'create_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(32, 'core_cohort_delete_cohort_members', 'core_cohort_external', 'delete_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:assign', NULL),
(33, 'core_cohort_delete_cohorts', 'core_cohort_external', 'delete_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(34, 'core_cohort_get_cohort_members', 'core_cohort_external', 'get_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(35, 'core_cohort_search_cohorts', 'core_cohort_external', 'search_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(36, 'core_cohort_get_cohorts', 'core_cohort_external', 'get_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(37, 'core_cohort_update_cohorts', 'core_cohort_external', 'update_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(38, 'core_comment_get_comments', 'core_comment_external', 'get_comments', NULL, 'moodle', 'moodle/comment:view', 'moodle_mobile_app'),
(39, 'core_comment_add_comments', 'core_comment_external', 'add_comments', NULL, 'moodle', '', 'moodle_mobile_app'),
(40, 'core_comment_delete_comments', 'core_comment_external', 'delete_comments', NULL, 'moodle', '', 'moodle_mobile_app'),
(41, 'core_completion_get_activities_completion_status', 'core_completion_external', 'get_activities_completion_status', NULL, 'moodle', '', 'moodle_mobile_app'),
(42, 'core_completion_get_course_completion_status', 'core_completion_external', 'get_course_completion_status', NULL, 'moodle', 'report/completion:view', 'moodle_mobile_app'),
(43, 'core_completion_mark_course_self_completed', 'core_completion_external', 'mark_course_self_completed', NULL, 'moodle', '', 'moodle_mobile_app'),
(44, 'core_completion_update_activity_completion_status_manually', 'core_completion_external', 'update_activity_completion_status_manually', NULL, 'moodle', '', 'moodle_mobile_app'),
(45, 'core_completion_override_activity_completion_status', 'core_completion_external', 'override_activity_completion_status', NULL, 'moodle', 'moodle/course:overridecompletion', NULL),
(46, 'core_course_create_categories', 'core_course_external', 'create_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(47, 'core_course_create_courses', 'core_course_external', 'create_courses', 'course/externallib.php', 'moodle', 'moodle/course:create, moodle/course:visibility', NULL),
(48, 'core_course_delete_categories', 'core_course_external', 'delete_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(49, 'core_course_delete_courses', 'core_course_external', 'delete_courses', 'course/externallib.php', 'moodle', 'moodle/course:delete', NULL),
(50, 'core_course_delete_modules', 'core_course_external', 'delete_modules', 'course/externallib.php', 'moodle', 'moodle/course:manageactivities', NULL),
(51, 'core_course_duplicate_course', 'core_course_external', 'duplicate_course', 'course/externallib.php', 'moodle', 'moodle/backup:backupcourse, moodle/restore:restorecourse, moodle/course:create', NULL),
(52, 'core_course_get_categories', 'core_course_external', 'get_categories', 'course/externallib.php', 'moodle', 'moodle/category:viewhiddencategories', 'moodle_mobile_app'),
(53, 'core_course_get_contents', 'core_course_external', 'get_course_contents', 'course/externallib.php', 'moodle', 'moodle/course:update, moodle/course:viewhiddencourses', 'moodle_mobile_app'),
(54, 'core_course_get_course_module', 'core_course_external', 'get_course_module', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(55, 'core_course_get_course_module_by_instance', 'core_course_external', 'get_course_module_by_instance', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(56, 'core_course_get_module', 'core_course_external', 'get_module', 'course/externallib.php', 'moodle', '', NULL),
(57, 'core_course_edit_module', 'core_course_external', 'edit_module', 'course/externallib.php', 'moodle', '', NULL),
(58, 'core_course_edit_section', 'core_course_external', 'edit_section', 'course/externallib.php', 'moodle', '', NULL),
(59, 'core_course_get_courses', 'core_course_external', 'get_courses', 'course/externallib.php', 'moodle', 'moodle/course:view, moodle/course:update, moodle/course:viewhiddencourses', 'moodle_mobile_app'),
(60, 'core_course_import_course', 'core_course_external', 'import_course', 'course/externallib.php', 'moodle', 'moodle/backup:backuptargetimport, moodle/restore:restoretargetimport', NULL),
(61, 'core_course_search_courses', 'core_course_external', 'search_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(62, 'core_course_update_categories', 'core_course_external', 'update_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(63, 'core_course_update_courses', 'core_course_external', 'update_courses', 'course/externallib.php', 'moodle', 'moodle/course:update, moodle/course:changecategory, moodle/course:changefullname, moodle/course:changeshortname, moodle/course:changeidnumber, moodle/course:changesummary, moodle/course:visibility', NULL),
(64, 'core_course_view_course', 'core_course_external', 'view_course', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(65, 'core_course_get_user_navigation_options', 'core_course_external', 'get_user_navigation_options', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(66, 'core_course_get_user_administration_options', 'core_course_external', 'get_user_administration_options', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(67, 'core_course_get_courses_by_field', 'core_course_external', 'get_courses_by_field', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(68, 'core_course_check_updates', 'core_course_external', 'check_updates', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(69, 'core_course_get_updates_since', 'core_course_external', 'get_updates_since', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(70, 'core_course_get_enrolled_courses_by_timeline_classification', 'core_course_external', 'get_enrolled_courses_by_timeline_classification', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(71, 'core_course_get_recent_courses', 'core_course_external', 'get_recent_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(72, 'core_course_set_favourite_courses', 'core_course_external', 'set_favourite_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(73, 'core_course_get_enrolled_users_by_cmid', 'core_course_external', 'get_enrolled_users_by_cmid', 'course/externallib.php', 'moodle', '', NULL),
(74, 'core_course_add_content_item_to_user_favourites', 'core_course_external', 'add_content_item_to_user_favourites', 'course/externallib.php', 'moodle', '', NULL),
(75, 'core_course_remove_content_item_from_user_favourites', 'core_course_external', 'remove_content_item_from_user_favourites', 'course/externallib.php', 'moodle', '', NULL),
(76, 'core_course_get_course_content_items', 'core_course_external', 'get_course_content_items', 'course/externallib.php', 'moodle', '', NULL),
(77, 'core_course_get_activity_chooser_footer', 'core_course_external', 'get_activity_chooser_footer', 'course/externallib.php', 'moodle', '', NULL),
(78, 'core_course_toggle_activity_recommendation', 'core_course_external', 'toggle_activity_recommendation', 'course/externallib.php', 'moodle', '', NULL),
(79, 'core_enrol_get_course_enrolment_methods', 'core_enrol_external', 'get_course_enrolment_methods', 'enrol/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(80, 'core_enrol_get_enrolled_users', 'core_enrol_external', 'get_enrolled_users', 'enrol/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups', 'moodle_mobile_app'),
(81, 'core_enrol_get_enrolled_users_with_capability', 'core_enrol_external', 'get_enrolled_users_with_capability', 'enrol/externallib.php', 'moodle', '', NULL),
(82, 'core_enrol_get_potential_users', 'core_enrol_external', 'get_potential_users', 'enrol/externallib.php', 'moodle', 'moodle/course:enrolreview', NULL),
(83, 'core_enrol_search_users', 'core_enrol_external', 'search_users', 'enrol/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(84, 'core_enrol_get_users_courses', 'core_enrol_external', 'get_users_courses', 'enrol/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(85, 'core_enrol_edit_user_enrolment', 'core_enrol_external', 'edit_user_enrolment', 'enrol/externallib.php', 'moodle', '', NULL),
(86, 'core_enrol_submit_user_enrolment_form', 'core_enrol_external', 'submit_user_enrolment_form', 'enrol/externallib.php', 'moodle', '', NULL),
(87, 'core_enrol_unenrol_user_enrolment', 'core_enrol_external', 'unenrol_user_enrolment', 'enrol/externallib.php', 'moodle', '', NULL),
(88, 'core_fetch_notifications', 'core_external', 'fetch_notifications', 'lib/external/externallib.php', 'moodle', '', NULL),
(89, 'core_session_touch', 'core\\session\\external', 'touch_session', NULL, 'moodle', '', NULL),
(90, 'core_session_time_remaining', 'core\\session\\external', 'time_remaining', NULL, 'moodle', '', NULL),
(91, 'core_files_get_files', 'core_files_external', 'get_files', 'files/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(92, 'core_files_upload', 'core_files_external', 'upload', 'files/externallib.php', 'moodle', '', NULL),
(93, 'core_files_delete_draft_files', 'core_files\\external\\delete\\draft', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(94, 'core_files_get_unused_draft_itemid', 'core_files\\external\\get\\unused_draft', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(95, 'core_form_get_filetypes_browser_data', 'core_form\\external', 'get_filetypes_browser_data', NULL, 'moodle', '', NULL),
(96, 'core_form_dynamic_form', 'core_form\\external\\dynamic_form', 'execute', NULL, 'moodle', '', NULL),
(97, 'core_get_component_strings', 'core_external', 'get_component_strings', 'lib/external/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(98, 'core_get_fragment', 'core_external', 'get_fragment', 'lib/external/externallib.php', 'moodle', '', NULL),
(99, 'core_get_string', 'core_external', 'get_string', 'lib/external/externallib.php', 'moodle', '', NULL),
(100, 'core_get_strings', 'core_external', 'get_strings', 'lib/external/externallib.php', 'moodle', '', NULL),
(101, 'core_get_user_dates', 'core_external', 'get_user_dates', 'lib/external/externallib.php', 'moodle', '', NULL),
(102, 'core_grades_get_grades', 'core_grades_external', 'get_grades', NULL, 'moodle', 'moodle/grade:view, moodle/grade:viewall, moodle/grade:viewhidden', NULL),
(103, 'core_grades_update_grades', 'core_grades_external', 'update_grades', NULL, 'moodle', '', NULL),
(104, 'core_grades_grader_gradingpanel_point_fetch', 'core_grades\\grades\\grader\\gradingpanel\\point\\external\\fetch', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(105, 'core_grades_grader_gradingpanel_point_store', 'core_grades\\grades\\grader\\gradingpanel\\point\\external\\store', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(106, 'core_grades_grader_gradingpanel_scale_fetch', 'core_grades\\grades\\grader\\gradingpanel\\scale\\external\\fetch', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(107, 'core_grades_grader_gradingpanel_scale_store', 'core_grades\\grades\\grader\\gradingpanel\\scale\\external\\store', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(108, 'core_grades_create_gradecategory', 'core_grades_external', 'create_gradecategory', NULL, 'moodle', 'moodle/grade:manage', NULL),
(109, 'core_grades_create_gradecategories', 'core_grades\\external\\create_gradecategories', 'execute', NULL, 'moodle', 'moodle/grade:manage', NULL),
(110, 'core_grading_get_definitions', 'core_grading_external', 'get_definitions', NULL, 'moodle', '', NULL),
(111, 'core_grading_get_gradingform_instances', 'core_grading_external', 'get_gradingform_instances', NULL, 'moodle', '', NULL),
(112, 'core_grading_save_definitions', 'core_grading_external', 'save_definitions', NULL, 'moodle', '', NULL),
(113, 'core_group_add_group_members', 'core_group_external', 'add_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(114, 'core_group_assign_grouping', 'core_group_external', 'assign_grouping', 'group/externallib.php', 'moodle', '', NULL),
(115, 'core_group_create_groupings', 'core_group_external', 'create_groupings', 'group/externallib.php', 'moodle', '', NULL),
(116, 'core_group_create_groups', 'core_group_external', 'create_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(117, 'core_group_delete_group_members', 'core_group_external', 'delete_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(118, 'core_group_delete_groupings', 'core_group_external', 'delete_groupings', 'group/externallib.php', 'moodle', '', NULL),
(119, 'core_group_delete_groups', 'core_group_external', 'delete_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(120, 'core_group_get_activity_allowed_groups', 'core_group_external', 'get_activity_allowed_groups', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(121, 'core_group_get_activity_groupmode', 'core_group_external', 'get_activity_groupmode', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(122, 'core_group_get_course_groupings', 'core_group_external', 'get_course_groupings', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(123, 'core_group_get_course_groups', 'core_group_external', 'get_course_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', 'moodle_mobile_app'),
(124, 'core_group_get_course_user_groups', 'core_group_external', 'get_course_user_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', 'moodle_mobile_app'),
(125, 'core_group_get_group_members', 'core_group_external', 'get_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(126, 'core_group_get_groupings', 'core_group_external', 'get_groupings', 'group/externallib.php', 'moodle', '', NULL),
(127, 'core_group_get_groups', 'core_group_external', 'get_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(128, 'core_group_unassign_grouping', 'core_group_external', 'unassign_grouping', 'group/externallib.php', 'moodle', '', NULL),
(129, 'core_group_update_groupings', 'core_group_external', 'update_groupings', 'group/externallib.php', 'moodle', '', NULL),
(130, 'core_group_update_groups', 'core_group_external', 'update_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(131, 'core_message_mute_conversations', 'core_message_external', 'mute_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(132, 'core_message_unmute_conversations', 'core_message_external', 'unmute_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(133, 'core_message_block_user', 'core_message_external', 'block_user', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(134, 'core_message_get_contact_requests', 'core_message_external', 'get_contact_requests', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(135, 'core_message_create_contact_request', 'core_message_external', 'create_contact_request', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(136, 'core_message_confirm_contact_request', 'core_message_external', 'confirm_contact_request', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(137, 'core_message_decline_contact_request', 'core_message_external', 'decline_contact_request', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(138, 'core_message_get_received_contact_requests_count', 'core_message_external', 'get_received_contact_requests_count', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(139, 'core_message_delete_contacts', 'core_message_external', 'delete_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(140, 'core_message_delete_conversations_by_id', 'core_message_external', 'delete_conversations_by_id', 'message/externallib.php', 'moodle', 'moodle/site:deleteownmessage', 'moodle_mobile_app'),
(141, 'core_message_delete_message', 'core_message_external', 'delete_message', 'message/externallib.php', 'moodle', 'moodle/site:deleteownmessage', 'moodle_mobile_app'),
(142, 'core_message_get_blocked_users', 'core_message_external', 'get_blocked_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(143, 'core_message_data_for_messagearea_search_messages', 'core_message_external', 'data_for_messagearea_search_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(144, 'core_message_message_search_users', 'core_message_external', 'message_search_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(145, 'core_message_get_user_contacts', 'core_message_external', 'get_user_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(146, 'core_message_get_conversations', 'core_message_external', 'get_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(147, 'core_message_get_conversation', 'core_message_external', 'get_conversation', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(148, 'core_message_get_conversation_between_users', 'core_message_external', 'get_conversation_between_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(149, 'core_message_get_self_conversation', 'core_message_external', 'get_self_conversation', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(150, 'core_message_get_messages', 'core_message_external', 'get_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(151, 'core_message_get_conversation_counts', 'core_message_external', 'get_conversation_counts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(152, 'core_message_get_unread_conversation_counts', 'core_message_external', 'get_unread_conversation_counts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(153, 'core_message_get_conversation_members', 'core_message_external', 'get_conversation_members', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(154, 'core_message_get_member_info', 'core_message_external', 'get_member_info', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(155, 'core_message_get_unread_conversations_count', 'core_message_external', 'get_unread_conversations_count', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(156, 'core_message_mark_all_notifications_as_read', 'core_message_external', 'mark_all_notifications_as_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(157, 'core_message_mark_all_conversation_messages_as_read', 'core_message_external', 'mark_all_conversation_messages_as_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(158, 'core_message_mark_message_read', 'core_message_external', 'mark_message_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(159, 'core_message_mark_notification_read', 'core_message_external', 'mark_notification_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(160, 'core_message_message_processor_config_form', 'core_message_external', 'message_processor_config_form', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(161, 'core_message_get_message_processor', 'core_message_external', 'get_message_processor', 'message/externallib.php', 'moodle', '', NULL),
(162, 'core_message_search_contacts', 'core_message_external', 'search_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(163, 'core_message_send_instant_messages', 'core_message_external', 'send_instant_messages', 'message/externallib.php', 'moodle', 'moodle/site:sendmessage', 'moodle_mobile_app'),
(164, 'core_message_send_messages_to_conversation', 'core_message_external', 'send_messages_to_conversation', 'message/externallib.php', 'moodle', 'moodle/site:sendmessage', 'moodle_mobile_app'),
(165, 'core_message_get_conversation_messages', 'core_message_external', 'get_conversation_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(166, 'core_message_unblock_user', 'core_message_external', 'unblock_user', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(167, 'core_message_get_user_notification_preferences', 'core_message_external', 'get_user_notification_preferences', 'message/externallib.php', 'moodle', 'moodle/user:editownmessageprofile', 'moodle_mobile_app'),
(168, 'core_message_get_user_message_preferences', 'core_message_external', 'get_user_message_preferences', 'message/externallib.php', 'moodle', 'moodle/user:editownmessageprofile', 'moodle_mobile_app'),
(169, 'core_message_set_favourite_conversations', 'core_message_external', 'set_favourite_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(170, 'core_message_unset_favourite_conversations', 'core_message_external', 'unset_favourite_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(171, 'core_message_delete_message_for_all_users', 'core_message_external', 'delete_message_for_all_users', 'message/externallib.php', 'moodle', 'moodle/site:deleteanymessage', 'moodle_mobile_app'),
(172, 'core_notes_create_notes', 'core_notes_external', 'create_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', 'moodle_mobile_app'),
(173, 'core_notes_delete_notes', 'core_notes_external', 'delete_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', 'moodle_mobile_app'),
(174, 'core_notes_get_course_notes', 'core_notes_external', 'get_course_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', 'moodle_mobile_app'),
(175, 'core_notes_get_notes', 'core_notes_external', 'get_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', NULL),
(176, 'core_notes_update_notes', 'core_notes_external', 'update_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', NULL),
(177, 'core_notes_view_notes', 'core_notes_external', 'view_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', 'moodle_mobile_app'),
(178, 'core_output_load_template', 'core\\output\\external', 'load_template', NULL, 'moodle', '', NULL),
(179, 'core_output_load_template_with_dependencies', 'core\\output\\external', 'load_template_with_dependencies', NULL, 'moodle', '', NULL),
(180, 'core_output_load_fontawesome_icon_map', 'core\\output\\external', 'load_fontawesome_icon_map', NULL, 'moodle', '', NULL),
(181, 'core_output_load_fontawesome_icon_system_map', 'core\\external\\output\\icon_system\\load_fontawesome_map', 'execute', NULL, 'moodle', '', NULL),
(182, 'core_question_update_flag', 'core_question_external', 'update_flag', NULL, 'moodle', 'moodle/question:flag', 'moodle_mobile_app'),
(183, 'core_question_submit_tags_form', 'core_question_external', 'submit_tags_form', NULL, 'moodle', '', NULL),
(184, 'core_question_get_random_question_summaries', 'core_question_external', 'get_random_question_summaries', NULL, 'moodle', '', NULL),
(185, 'core_rating_get_item_ratings', 'core_rating_external', 'get_item_ratings', NULL, 'moodle', 'moodle/rating:view', 'moodle_mobile_app'),
(186, 'core_rating_add_rating', 'core_rating_external', 'add_rating', NULL, 'moodle', 'moodle/rating:rate', 'moodle_mobile_app'),
(187, 'core_role_assign_roles', 'core_role_external', 'assign_roles', 'enrol/externallib.php', 'moodle', 'moodle/role:assign', NULL),
(188, 'core_role_unassign_roles', 'core_role_external', 'unassign_roles', 'enrol/externallib.php', 'moodle', 'moodle/role:assign', NULL),
(189, 'core_search_get_relevant_users', '\\core_search\\external', 'get_relevant_users', NULL, 'moodle', '', NULL),
(190, 'core_tag_get_tagindex', 'core_tag_external', 'get_tagindex', NULL, 'moodle', '', 'moodle_mobile_app'),
(191, 'core_tag_get_tags', 'core_tag_external', 'get_tags', NULL, 'moodle', '', NULL),
(192, 'core_tag_update_tags', 'core_tag_external', 'update_tags', NULL, 'moodle', '', NULL),
(193, 'core_tag_get_tagindex_per_area', 'core_tag_external', 'get_tagindex_per_area', NULL, 'moodle', '', 'moodle_mobile_app'),
(194, 'core_tag_get_tag_areas', 'core_tag_external', 'get_tag_areas', NULL, 'moodle', '', 'moodle_mobile_app'),
(195, 'core_tag_get_tag_collections', 'core_tag_external', 'get_tag_collections', NULL, 'moodle', '', 'moodle_mobile_app'),
(196, 'core_tag_get_tag_cloud', 'core_tag_external', 'get_tag_cloud', NULL, 'moodle', '', 'moodle_mobile_app'),
(197, 'core_update_inplace_editable', 'core_external', 'update_inplace_editable', 'lib/external/externallib.php', 'moodle', '', NULL),
(198, 'core_user_add_user_device', 'core_user_external', 'add_user_device', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(199, 'core_user_add_user_private_files', 'core_user_external', 'add_user_private_files', 'user/externallib.php', 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(200, 'core_user_create_users', 'core_user_external', 'create_users', 'user/externallib.php', 'moodle', 'moodle/user:create', NULL),
(201, 'core_user_delete_users', 'core_user_external', 'delete_users', 'user/externallib.php', 'moodle', 'moodle/user:delete', NULL),
(202, 'core_user_get_course_user_profiles', 'core_user_external', 'get_course_user_profiles', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups', 'moodle_mobile_app'),
(203, 'core_user_get_users', 'core_user_external', 'get_users', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update', NULL),
(204, 'core_user_get_users_by_field', 'core_user_external', 'get_users_by_field', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update', 'moodle_mobile_app'),
(205, 'core_user_search_identity', '\\core_user\\external\\search_identity', 'execute', NULL, 'moodle', 'moodle/user:viewalldetails', NULL),
(206, 'core_user_remove_user_device', 'core_user_external', 'remove_user_device', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(207, 'core_user_update_users', 'core_user_external', 'update_users', 'user/externallib.php', 'moodle', 'moodle/user:update', NULL),
(208, 'core_user_update_user_preferences', 'core_user_external', 'update_user_preferences', 'user/externallib.php', 'moodle', 'moodle/user:editownmessageprofile, moodle/user:editmessageprofile', 'moodle_mobile_app'),
(209, 'core_user_view_user_list', 'core_user_external', 'view_user_list', 'user/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(210, 'core_user_view_user_profile', 'core_user_external', 'view_user_profile', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails', 'moodle_mobile_app'),
(211, 'core_user_get_user_preferences', 'core_user_external', 'get_user_preferences', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(212, 'core_user_update_picture', 'core_user_external', 'update_picture', 'user/externallib.php', 'moodle', 'moodle/user:editownprofile, moodle/user:editprofile', 'moodle_mobile_app'),
(213, 'core_user_set_user_preferences', 'core_user_external', 'set_user_preferences', 'user/externallib.php', 'moodle', 'moodle/site:config', 'moodle_mobile_app'),
(214, 'core_user_agree_site_policy', 'core_user_external', 'agree_site_policy', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(215, 'core_user_get_private_files_info', 'core_user_external', 'get_private_files_info', 'user/externallib.php', 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(216, 'core_competency_create_competency_framework', 'core_competency\\external', 'create_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(217, 'core_competency_read_competency_framework', 'core_competency\\external', 'read_competency_framework', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(218, 'core_competency_duplicate_competency_framework', 'core_competency\\external', 'duplicate_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(219, 'core_competency_delete_competency_framework', 'core_competency\\external', 'delete_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(220, 'core_competency_update_competency_framework', 'core_competency\\external', 'update_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(221, 'core_competency_list_competency_frameworks', 'core_competency\\external', 'list_competency_frameworks', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(222, 'core_competency_count_competency_frameworks', 'core_competency\\external', 'count_competency_frameworks', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(223, 'core_competency_competency_framework_viewed', 'core_competency\\external', 'competency_framework_viewed', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(224, 'core_competency_create_competency', 'core_competency\\external', 'create_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(225, 'core_competency_read_competency', 'core_competency\\external', 'read_competency', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(226, 'core_competency_competency_viewed', 'core_competency\\external', 'competency_viewed', NULL, 'moodle', 'moodle/competency:competencyview', 'moodle_mobile_app'),
(227, 'core_competency_delete_competency', 'core_competency\\external', 'delete_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(228, 'core_competency_update_competency', 'core_competency\\external', 'update_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(229, 'core_competency_list_competencies', 'core_competency\\external', 'list_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(230, 'core_competency_list_competencies_in_template', 'core_competency\\external', 'list_competencies_in_template', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(231, 'core_competency_count_competencies', 'core_competency\\external', 'count_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(232, 'core_competency_count_competencies_in_template', 'core_competency\\external', 'count_competencies_in_template', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(233, 'core_competency_search_competencies', 'core_competency\\external', 'search_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(234, 'core_competency_set_parent_competency', 'core_competency\\external', 'set_parent_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(235, 'core_competency_move_up_competency', 'core_competency\\external', 'move_up_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(236, 'core_competency_move_down_competency', 'core_competency\\external', 'move_down_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(237, 'core_competency_list_course_module_competencies', 'core_competency\\external', 'list_course_module_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(238, 'core_competency_count_course_module_competencies', 'core_competency\\external', 'count_course_module_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(239, 'core_competency_list_course_competencies', 'core_competency\\external', 'list_course_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(240, 'core_competency_count_competencies_in_course', 'core_competency\\external', 'count_competencies_in_course', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(241, 'core_competency_count_courses_using_competency', 'core_competency\\external', 'count_courses_using_competency', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(242, 'core_competency_add_competency_to_course', 'core_competency\\external', 'add_competency_to_course', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(243, 'core_competency_add_competency_to_template', 'core_competency\\external', 'add_competency_to_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(244, 'core_competency_remove_competency_from_course', 'core_competency\\external', 'remove_competency_from_course', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(245, 'core_competency_set_course_competency_ruleoutcome', 'core_competency\\external', 'set_course_competency_ruleoutcome', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(246, 'core_competency_remove_competency_from_template', 'core_competency\\external', 'remove_competency_from_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(247, 'core_competency_reorder_course_competency', 'core_competency\\external', 'reorder_course_competency', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(248, 'core_competency_reorder_template_competency', 'core_competency\\external', 'reorder_template_competency', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(249, 'core_competency_create_template', 'core_competency\\external', 'create_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(250, 'core_competency_duplicate_template', 'core_competency\\external', 'duplicate_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(251, 'core_competency_read_template', 'core_competency\\external', 'read_template', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(252, 'core_competency_delete_template', 'core_competency\\external', 'delete_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(253, 'core_competency_update_template', 'core_competency\\external', 'update_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(254, 'core_competency_list_templates', 'core_competency\\external', 'list_templates', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(255, 'core_competency_list_templates_using_competency', 'core_competency\\external', 'list_templates_using_competency', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(256, 'core_competency_count_templates', 'core_competency\\external', 'count_templates', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(257, 'core_competency_count_templates_using_competency', 'core_competency\\external', 'count_templates_using_competency', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(258, 'core_competency_create_plan', 'core_competency\\external', 'create_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(259, 'core_competency_update_plan', 'core_competency\\external', 'update_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(260, 'core_competency_complete_plan', 'core_competency\\external', 'complete_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(261, 'core_competency_reopen_plan', 'core_competency\\external', 'reopen_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(262, 'core_competency_read_plan', 'core_competency\\external', 'read_plan', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(263, 'core_competency_delete_plan', 'core_competency\\external', 'delete_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(264, 'core_competency_list_user_plans', 'core_competency\\external', 'list_user_plans', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(265, 'core_competency_list_plan_competencies', 'core_competency\\external', 'list_plan_competencies', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(266, 'core_competency_add_competency_to_plan', 'core_competency\\external', 'add_competency_to_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(267, 'core_competency_remove_competency_from_plan', 'core_competency\\external', 'remove_competency_from_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(268, 'core_competency_reorder_plan_competency', 'core_competency\\external', 'reorder_plan_competency', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(269, 'core_competency_plan_request_review', 'core_competency\\external', 'plan_request_review', NULL, 'moodle', 'moodle/competency:planmanagedraft', NULL),
(270, 'core_competency_plan_start_review', 'core_competency\\external', 'plan_start_review', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(271, 'core_competency_plan_stop_review', 'core_competency\\external', 'plan_stop_review', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(272, 'core_competency_plan_cancel_review_request', 'core_competency\\external', 'plan_cancel_review_request', NULL, 'moodle', 'moodle/competency:planmanagedraft', NULL),
(273, 'core_competency_approve_plan', 'core_competency\\external', 'approve_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(274, 'core_competency_unapprove_plan', 'core_competency\\external', 'unapprove_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(275, 'core_competency_template_has_related_data', 'core_competency\\external', 'template_has_related_data', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(276, 'core_competency_get_scale_values', 'core_competency\\external', 'get_scale_values', NULL, 'moodle', 'moodle/competency:competencymanage', 'moodle_mobile_app'),
(277, 'core_competency_add_related_competency', 'core_competency\\external', 'add_related_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(278, 'core_competency_remove_related_competency', 'core_competency\\external', 'remove_related_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(279, 'core_competency_read_user_evidence', 'core_competency\\external', 'read_user_evidence', NULL, 'moodle', 'moodle/competency:userevidenceview', NULL),
(280, 'core_competency_delete_user_evidence', 'core_competency\\external', 'delete_user_evidence', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(281, 'core_competency_create_user_evidence_competency', 'core_competency\\external', 'create_user_evidence_competency', NULL, 'moodle', 'moodle/competency:userevidencemanageown, moodle/competency:competencyview', NULL),
(282, 'core_competency_delete_user_evidence_competency', 'core_competency\\external', 'delete_user_evidence_competency', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(283, 'core_competency_user_competency_cancel_review_request', 'core_competency\\external', 'user_competency_cancel_review_request', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(284, 'core_competency_user_competency_request_review', 'core_competency\\external', 'user_competency_request_review', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(285, 'core_competency_user_competency_start_review', 'core_competency\\external', 'user_competency_start_review', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(286, 'core_competency_user_competency_stop_review', 'core_competency\\external', 'user_competency_stop_review', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(287, 'core_competency_user_competency_viewed', 'core_competency\\external', 'user_competency_viewed', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(288, 'core_competency_user_competency_viewed_in_plan', 'core_competency\\external', 'user_competency_viewed_in_plan', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(289, 'core_competency_user_competency_viewed_in_course', 'core_competency\\external', 'user_competency_viewed_in_course', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(290, 'core_competency_user_competency_plan_viewed', 'core_competency\\external', 'user_competency_plan_viewed', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(291, 'core_competency_grade_competency', 'core_competency\\external', 'grade_competency', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(292, 'core_competency_grade_competency_in_plan', 'core_competency\\external', 'grade_competency_in_plan', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(293, 'core_competency_grade_competency_in_course', 'core_competency\\external', 'grade_competency_in_course', NULL, 'moodle', 'moodle/competency:competencygrade', 'moodle_mobile_app'),
(294, 'core_competency_unlink_plan_from_template', 'core_competency\\external', 'unlink_plan_from_template', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(295, 'core_competency_template_viewed', 'core_competency\\external', 'template_viewed', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(296, 'core_competency_request_review_of_user_evidence_linked_competencies', 'core_competency\\external', 'request_review_of_user_evidence_linked_competencies', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(297, 'core_competency_update_course_competency_settings', 'core_competency\\external', 'update_course_competency_settings', NULL, 'moodle', 'moodle/competency:coursecompetencyconfigure', NULL),
(298, 'core_competency_delete_evidence', 'core_competency\\external', 'delete_evidence', NULL, 'moodle', 'moodle/competency:evidencedelete', 'moodle_mobile_app'),
(299, 'core_webservice_get_site_info', 'core_webservice_external', 'get_site_info', 'webservice/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(300, 'core_block_get_course_blocks', 'core_block_external', 'get_course_blocks', NULL, 'moodle', '', 'moodle_mobile_app'),
(301, 'core_block_get_dashboard_blocks', 'core_block_external', 'get_dashboard_blocks', NULL, 'moodle', '', 'moodle_mobile_app'),
(302, 'core_block_fetch_addable_blocks', 'core_block\\external\\fetch_addable_blocks', 'execute', NULL, 'moodle', 'moodle/site:manageblocks', 'moodle_mobile_app'),
(303, 'core_filters_get_available_in_context', 'core_filters\\external', 'get_available_in_context', NULL, 'moodle', '', 'moodle_mobile_app'),
(304, 'core_customfield_delete_field', 'core_customfield_external', 'delete_field', 'customfield/externallib.php', 'moodle', '', NULL),
(305, 'core_customfield_reload_template', 'core_customfield_external', 'reload_template', 'customfield/externallib.php', 'moodle', '', NULL),
(306, 'core_customfield_create_category', 'core_customfield_external', 'create_category', 'customfield/externallib.php', 'moodle', '', NULL),
(307, 'core_customfield_delete_category', 'core_customfield_external', 'delete_category', 'customfield/externallib.php', 'moodle', '', NULL),
(308, 'core_customfield_move_field', 'core_customfield_external', 'move_field', 'customfield/externallib.php', 'moodle', '', NULL),
(309, 'core_customfield_move_category', 'core_customfield_external', 'move_category', 'customfield/externallib.php', 'moodle', '', NULL),
(310, 'core_h5p_get_trusted_h5p_file', 'core_h5p\\external', 'get_trusted_h5p_file', NULL, 'moodle', '', 'moodle_mobile_app'),
(311, 'core_table_get_dynamic_table_content', 'core_table\\external\\dynamic\\get', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(312, 'core_xapi_statement_post', 'core_xapi\\external\\post_statement', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(313, 'core_contentbank_delete_content', 'core_contentbank\\external\\delete_content', 'execute', NULL, 'moodle', 'moodle/contentbank:deleteanycontent', NULL),
(314, 'core_contentbank_rename_content', 'core_contentbank\\external\\rename_content', 'execute', NULL, 'moodle', 'moodle/contentbank:manageowncontent', NULL),
(315, 'core_contentbank_set_content_visibility', 'core_contentbank\\external\\set_content_visibility', 'execute', NULL, 'moodle', 'moodle/contentbank:manageowncontent', NULL),
(316, 'core_create_userfeedback_action_record', 'core\\external\\record_userfeedback_action', 'execute', NULL, 'moodle', '', NULL),
(317, 'core_payment_get_available_gateways', 'core_payment\\external\\get_available_gateways', 'execute', NULL, 'moodle', '', NULL),
(318, 'mod_assign_copy_previous_attempt', 'mod_assign_external', 'copy_previous_attempt', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:submit', NULL),
(319, 'mod_assign_get_grades', 'mod_assign_external', 'get_grades', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(320, 'mod_assign_get_assignments', 'mod_assign_external', 'get_assignments', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app');
INSERT INTO `[[dbprefix]]external_functions` VALUES
(321, 'mod_assign_get_submissions', 'mod_assign_external', 'get_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(322, 'mod_assign_get_user_flags', 'mod_assign_external', 'get_user_flags', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(323, 'mod_assign_set_user_flags', 'mod_assign_external', 'set_user_flags', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:grade', 'moodle_mobile_app'),
(324, 'mod_assign_get_user_mappings', 'mod_assign_external', 'get_user_mappings', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(325, 'mod_assign_revert_submissions_to_draft', 'mod_assign_external', 'revert_submissions_to_draft', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(326, 'mod_assign_lock_submissions', 'mod_assign_external', 'lock_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(327, 'mod_assign_unlock_submissions', 'mod_assign_external', 'unlock_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(328, 'mod_assign_save_submission', 'mod_assign_external', 'save_submission', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(329, 'mod_assign_submit_for_grading', 'mod_assign_external', 'submit_for_grading', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(330, 'mod_assign_save_grade', 'mod_assign_external', 'save_grade', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(331, 'mod_assign_save_grades', 'mod_assign_external', 'save_grades', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(332, 'mod_assign_save_user_extensions', 'mod_assign_external', 'save_user_extensions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(333, 'mod_assign_reveal_identities', 'mod_assign_external', 'reveal_identities', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(334, 'mod_assign_view_grading_table', 'mod_assign_external', 'view_grading_table', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(335, 'mod_assign_view_submission_status', 'mod_assign_external', 'view_submission_status', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(336, 'mod_assign_get_submission_status', 'mod_assign_external', 'get_submission_status', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(337, 'mod_assign_list_participants', 'mod_assign_external', 'list_participants', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(338, 'mod_assign_submit_grading_form', 'mod_assign_external', 'submit_grading_form', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:grade', 'moodle_mobile_app'),
(339, 'mod_assign_get_participant', 'mod_assign_external', 'get_participant', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(340, 'mod_assign_view_assign', 'mod_assign_external', 'view_assign', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(341, 'mod_book_view_book', 'mod_book_external', 'view_book', NULL, 'mod_book', 'mod/book:read', 'moodle_mobile_app'),
(342, 'mod_book_get_books_by_courses', 'mod_book_external', 'get_books_by_courses', NULL, 'mod_book', '', 'moodle_mobile_app'),
(343, 'mod_chat_login_user', 'mod_chat_external', 'login_user', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(344, 'mod_chat_get_chat_users', 'mod_chat_external', 'get_chat_users', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(345, 'mod_chat_send_chat_message', 'mod_chat_external', 'send_chat_message', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(346, 'mod_chat_get_chat_latest_messages', 'mod_chat_external', 'get_chat_latest_messages', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(347, 'mod_chat_view_chat', 'mod_chat_external', 'view_chat', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(348, 'mod_chat_get_chats_by_courses', 'mod_chat_external', 'get_chats_by_courses', NULL, 'mod_chat', '', 'moodle_mobile_app'),
(349, 'mod_chat_get_sessions', 'mod_chat_external', 'get_sessions', NULL, 'mod_chat', '', 'moodle_mobile_app'),
(350, 'mod_chat_get_session_messages', 'mod_chat_external', 'get_session_messages', NULL, 'mod_chat', '', 'moodle_mobile_app'),
(351, 'mod_choice_get_choice_results', 'mod_choice_external', 'get_choice_results', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(352, 'mod_choice_get_choice_options', 'mod_choice_external', 'get_choice_options', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(353, 'mod_choice_submit_choice_response', 'mod_choice_external', 'submit_choice_response', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(354, 'mod_choice_view_choice', 'mod_choice_external', 'view_choice', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(355, 'mod_choice_get_choices_by_courses', 'mod_choice_external', 'get_choices_by_courses', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(356, 'mod_choice_delete_choice_responses', 'mod_choice_external', 'delete_choice_responses', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(357, 'mod_data_get_databases_by_courses', 'mod_data_external', 'get_databases_by_courses', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(358, 'mod_data_view_database', 'mod_data_external', 'view_database', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(359, 'mod_data_get_data_access_information', 'mod_data_external', 'get_data_access_information', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(360, 'mod_data_get_entries', 'mod_data_external', 'get_entries', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(361, 'mod_data_get_entry', 'mod_data_external', 'get_entry', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(362, 'mod_data_get_fields', 'mod_data_external', 'get_fields', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(363, 'mod_data_search_entries', 'mod_data_external', 'search_entries', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(364, 'mod_data_approve_entry', 'mod_data_external', 'approve_entry', NULL, 'mod_data', 'mod/data:approve', 'moodle_mobile_app'),
(365, 'mod_data_delete_entry', 'mod_data_external', 'delete_entry', NULL, 'mod_data', 'mod/data:manageentries', 'moodle_mobile_app'),
(366, 'mod_data_add_entry', 'mod_data_external', 'add_entry', NULL, 'mod_data', 'mod/data:writeentry', 'moodle_mobile_app'),
(367, 'mod_data_update_entry', 'mod_data_external', 'update_entry', NULL, 'mod_data', 'mod/data:writeentry', 'moodle_mobile_app'),
(368, 'mod_feedback_get_feedbacks_by_courses', 'mod_feedback_external', 'get_feedbacks_by_courses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(369, 'mod_feedback_get_feedback_access_information', 'mod_feedback_external', 'get_feedback_access_information', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(370, 'mod_feedback_view_feedback', 'mod_feedback_external', 'view_feedback', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(371, 'mod_feedback_get_current_completed_tmp', 'mod_feedback_external', 'get_current_completed_tmp', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(372, 'mod_feedback_get_items', 'mod_feedback_external', 'get_items', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(373, 'mod_feedback_launch_feedback', 'mod_feedback_external', 'launch_feedback', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(374, 'mod_feedback_get_page_items', 'mod_feedback_external', 'get_page_items', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(375, 'mod_feedback_process_page', 'mod_feedback_external', 'process_page', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(376, 'mod_feedback_get_analysis', 'mod_feedback_external', 'get_analysis', NULL, 'mod_feedback', 'mod/feedback:viewanalysepage', 'moodle_mobile_app'),
(377, 'mod_feedback_get_unfinished_responses', 'mod_feedback_external', 'get_unfinished_responses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(378, 'mod_feedback_get_finished_responses', 'mod_feedback_external', 'get_finished_responses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(379, 'mod_feedback_get_non_respondents', 'mod_feedback_external', 'get_non_respondents', NULL, 'mod_feedback', 'mod/feedback:viewreports', 'moodle_mobile_app'),
(380, 'mod_feedback_get_responses_analysis', 'mod_feedback_external', 'get_responses_analysis', NULL, 'mod_feedback', 'mod/feedback:viewreports', 'moodle_mobile_app'),
(381, 'mod_feedback_get_last_completed', 'mod_feedback_external', 'get_last_completed', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(382, 'mod_folder_view_folder', 'mod_folder_external', 'view_folder', NULL, 'mod_folder', 'mod/folder:view', 'moodle_mobile_app'),
(383, 'mod_folder_get_folders_by_courses', 'mod_folder_external', 'get_folders_by_courses', NULL, 'mod_folder', 'mod/folder:view', 'moodle_mobile_app'),
(384, 'mod_forum_get_forums_by_courses', 'mod_forum_external', 'get_forums_by_courses', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(385, 'mod_forum_get_discussion_posts', 'mod_forum_external', 'get_discussion_posts', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(386, 'mod_forum_get_forum_discussion_posts', 'mod_forum_external', 'get_forum_discussion_posts', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(387, 'mod_forum_get_forum_discussions_paginated', 'mod_forum_external', 'get_forum_discussions_paginated', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(388, 'mod_forum_get_forum_discussions', 'mod_forum_external', 'get_forum_discussions', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(389, 'mod_forum_view_forum', 'mod_forum_external', 'view_forum', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(390, 'mod_forum_view_forum_discussion', 'mod_forum_external', 'view_forum_discussion', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(391, 'mod_forum_add_discussion_post', 'mod_forum_external', 'add_discussion_post', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:replypost', 'moodle_mobile_app'),
(392, 'mod_forum_add_discussion', 'mod_forum_external', 'add_discussion', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:startdiscussion', 'moodle_mobile_app'),
(393, 'mod_forum_can_add_discussion', 'mod_forum_external', 'can_add_discussion', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(394, 'mod_forum_get_forum_access_information', 'mod_forum_external', 'get_forum_access_information', NULL, 'mod_forum', '', 'moodle_mobile_app'),
(395, 'mod_forum_set_subscription_state', 'mod_forum_external', 'set_subscription_state', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(396, 'mod_forum_set_lock_state', 'mod_forum_external', 'set_lock_state', 'mod/forum/externallib.php', 'mod_forum', 'moodle/course:manageactivities', 'moodle_mobile_app'),
(397, 'mod_forum_toggle_favourite_state', 'mod_forum_external', 'toggle_favourite_state', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(398, 'mod_forum_set_pin_state', 'mod_forum_external', 'set_pin_state', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(399, 'mod_forum_delete_post', 'mod_forum_external', 'delete_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(400, 'mod_forum_get_discussion_posts_by_userid', 'mod_forum_external', 'get_discussion_posts_by_userid', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', NULL),
(401, 'mod_forum_get_discussion_post', 'mod_forum_external', 'get_discussion_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(402, 'mod_forum_prepare_draft_area_for_post', 'mod_forum_external', 'prepare_draft_area_for_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(403, 'mod_forum_update_discussion_post', 'mod_forum_external', 'update_discussion_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(404, 'mod_glossary_get_glossaries_by_courses', 'mod_glossary_external', 'get_glossaries_by_courses', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(405, 'mod_glossary_view_glossary', 'mod_glossary_external', 'view_glossary', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(406, 'mod_glossary_view_entry', 'mod_glossary_external', 'view_entry', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(407, 'mod_glossary_get_entries_by_letter', 'mod_glossary_external', 'get_entries_by_letter', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(408, 'mod_glossary_get_entries_by_date', 'mod_glossary_external', 'get_entries_by_date', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(409, 'mod_glossary_get_categories', 'mod_glossary_external', 'get_categories', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(410, 'mod_glossary_get_entries_by_category', 'mod_glossary_external', 'get_entries_by_category', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(411, 'mod_glossary_get_authors', 'mod_glossary_external', 'get_authors', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(412, 'mod_glossary_get_entries_by_author', 'mod_glossary_external', 'get_entries_by_author', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(413, 'mod_glossary_get_entries_by_author_id', 'mod_glossary_external', 'get_entries_by_author_id', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(414, 'mod_glossary_get_entries_by_search', 'mod_glossary_external', 'get_entries_by_search', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(415, 'mod_glossary_get_entries_by_term', 'mod_glossary_external', 'get_entries_by_term', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(416, 'mod_glossary_get_entries_to_approve', 'mod_glossary_external', 'get_entries_to_approve', NULL, 'mod_glossary', 'mod/glossary:approve', 'moodle_mobile_app'),
(417, 'mod_glossary_get_entry_by_id', 'mod_glossary_external', 'get_entry_by_id', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(418, 'mod_glossary_add_entry', 'mod_glossary_external', 'add_entry', NULL, 'mod_glossary', 'mod/glossary:write', 'moodle_mobile_app'),
(419, 'mod_glossary_delete_entry', 'mod_glossary\\external\\delete_entry', 'execute', NULL, 'mod_glossary', '', 'moodle_mobile_app'),
(420, 'mod_glossary_update_entry', 'mod_glossary\\external\\update_entry', 'execute', NULL, 'mod_glossary', '', 'moodle_mobile_app'),
(421, 'mod_glossary_prepare_entry_for_edition', 'mod_glossary\\external\\prepare_entry', 'execute', NULL, 'mod_glossary', '', 'moodle_mobile_app'),
(422, 'mod_h5pactivity_get_h5pactivity_access_information', 'mod_h5pactivity\\external\\get_h5pactivity_access_information', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(423, 'mod_h5pactivity_view_h5pactivity', 'mod_h5pactivity\\external\\view_h5pactivity', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(424, 'mod_h5pactivity_get_attempts', 'mod_h5pactivity\\external\\get_attempts', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(425, 'mod_h5pactivity_get_results', 'mod_h5pactivity\\external\\get_results', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(426, 'mod_h5pactivity_get_h5pactivities_by_courses', 'mod_h5pactivity\\external\\get_h5pactivities_by_courses', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(427, 'mod_h5pactivity_log_report_viewed', 'mod_h5pactivity\\external\\log_report_viewed', 'execute', NULL, 'mod_h5pactivity', '', 'moodle_mobile_app'),
(428, 'mod_h5pactivity_get_user_attempts', 'mod_h5pactivity\\external\\get_user_attempts', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:reviewattempts', 'moodle_mobile_app'),
(429, 'mod_imscp_view_imscp', 'mod_imscp_external', 'view_imscp', NULL, 'mod_imscp', 'mod/imscp:view', 'moodle_mobile_app'),
(430, 'mod_imscp_get_imscps_by_courses', 'mod_imscp_external', 'get_imscps_by_courses', NULL, 'mod_imscp', 'mod/imscp:view', 'moodle_mobile_app'),
(431, 'mod_label_get_labels_by_courses', 'mod_label_external', 'get_labels_by_courses', NULL, 'mod_label', 'mod/label:view', 'moodle_mobile_app'),
(432, 'mod_lesson_get_lessons_by_courses', 'mod_lesson_external', 'get_lessons_by_courses', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(433, 'mod_lesson_get_lesson_access_information', 'mod_lesson_external', 'get_lesson_access_information', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(434, 'mod_lesson_view_lesson', 'mod_lesson_external', 'view_lesson', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(435, 'mod_lesson_get_questions_attempts', 'mod_lesson_external', 'get_questions_attempts', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(436, 'mod_lesson_get_user_grade', 'mod_lesson_external', 'get_user_grade', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(437, 'mod_lesson_get_user_attempt_grade', 'mod_lesson_external', 'get_user_attempt_grade', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(438, 'mod_lesson_get_content_pages_viewed', 'mod_lesson_external', 'get_content_pages_viewed', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(439, 'mod_lesson_get_user_timers', 'mod_lesson_external', 'get_user_timers', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(440, 'mod_lesson_get_pages', 'mod_lesson_external', 'get_pages', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(441, 'mod_lesson_launch_attempt', 'mod_lesson_external', 'launch_attempt', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(442, 'mod_lesson_get_page_data', 'mod_lesson_external', 'get_page_data', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(443, 'mod_lesson_process_page', 'mod_lesson_external', 'process_page', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(444, 'mod_lesson_finish_attempt', 'mod_lesson_external', 'finish_attempt', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(445, 'mod_lesson_get_attempts_overview', 'mod_lesson_external', 'get_attempts_overview', NULL, 'mod_lesson', 'mod/lesson:viewreports', 'moodle_mobile_app'),
(446, 'mod_lesson_get_user_attempt', 'mod_lesson_external', 'get_user_attempt', NULL, 'mod_lesson', 'mod/lesson:viewreports', 'moodle_mobile_app'),
(447, 'mod_lesson_get_pages_possible_jumps', 'mod_lesson_external', 'get_pages_possible_jumps', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(448, 'mod_lesson_get_lesson', 'mod_lesson_external', 'get_lesson', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(449, 'mod_lti_get_tool_launch_data', 'mod_lti_external', 'get_tool_launch_data', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(450, 'mod_lti_get_ltis_by_courses', 'mod_lti_external', 'get_ltis_by_courses', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(451, 'mod_lti_view_lti', 'mod_lti_external', 'view_lti', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(452, 'mod_lti_get_tool_proxies', 'mod_lti_external', 'get_tool_proxies', NULL, 'mod_lti', 'moodle/site:config', NULL),
(453, 'mod_lti_create_tool_proxy', 'mod_lti_external', 'create_tool_proxy', NULL, 'mod_lti', 'moodle/site:config', NULL),
(454, 'mod_lti_delete_tool_proxy', 'mod_lti_external', 'delete_tool_proxy', NULL, 'mod_lti', 'moodle/site:config', NULL),
(455, 'mod_lti_get_tool_proxy_registration_request', 'mod_lti_external', 'get_tool_proxy_registration_request', NULL, 'mod_lti', 'moodle/site:config', NULL),
(456, 'mod_lti_get_tool_types', 'mod_lti_external', 'get_tool_types', NULL, 'mod_lti', 'moodle/site:config', NULL),
(457, 'mod_lti_create_tool_type', 'mod_lti_external', 'create_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(458, 'mod_lti_update_tool_type', 'mod_lti_external', 'update_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(459, 'mod_lti_delete_tool_type', 'mod_lti_external', 'delete_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(460, 'mod_lti_is_cartridge', 'mod_lti_external', 'is_cartridge', NULL, 'mod_lti', 'moodle/site:config', NULL),
(461, 'mod_page_view_page', 'mod_page_external', 'view_page', NULL, 'mod_page', 'mod/page:view', 'moodle_mobile_app'),
(462, 'mod_page_get_pages_by_courses', 'mod_page_external', 'get_pages_by_courses', NULL, 'mod_page', 'mod/page:view', 'moodle_mobile_app'),
(463, 'mod_quiz_get_quizzes_by_courses', 'mod_quiz_external', 'get_quizzes_by_courses', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(464, 'mod_quiz_view_quiz', 'mod_quiz_external', 'view_quiz', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(465, 'mod_quiz_get_user_attempts', 'mod_quiz_external', 'get_user_attempts', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(466, 'mod_quiz_get_user_best_grade', 'mod_quiz_external', 'get_user_best_grade', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(467, 'mod_quiz_get_combined_review_options', 'mod_quiz_external', 'get_combined_review_options', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(468, 'mod_quiz_start_attempt', 'mod_quiz_external', 'start_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(469, 'mod_quiz_get_attempt_data', 'mod_quiz_external', 'get_attempt_data', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(470, 'mod_quiz_get_attempt_summary', 'mod_quiz_external', 'get_attempt_summary', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(471, 'mod_quiz_save_attempt', 'mod_quiz_external', 'save_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(472, 'mod_quiz_process_attempt', 'mod_quiz_external', 'process_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(473, 'mod_quiz_get_attempt_review', 'mod_quiz_external', 'get_attempt_review', NULL, 'mod_quiz', 'mod/quiz:reviewmyattempts', 'moodle_mobile_app'),
(474, 'mod_quiz_view_attempt', 'mod_quiz_external', 'view_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(475, 'mod_quiz_view_attempt_summary', 'mod_quiz_external', 'view_attempt_summary', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(476, 'mod_quiz_view_attempt_review', 'mod_quiz_external', 'view_attempt_review', NULL, 'mod_quiz', 'mod/quiz:reviewmyattempts', 'moodle_mobile_app'),
(477, 'mod_quiz_get_quiz_feedback_for_grade', 'mod_quiz_external', 'get_quiz_feedback_for_grade', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(478, 'mod_quiz_get_quiz_access_information', 'mod_quiz_external', 'get_quiz_access_information', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(479, 'mod_quiz_get_attempt_access_information', 'mod_quiz_external', 'get_attempt_access_information', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(480, 'mod_quiz_get_quiz_required_qtypes', 'mod_quiz_external', 'get_quiz_required_qtypes', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(481, 'mod_resource_view_resource', 'mod_resource_external', 'view_resource', NULL, 'mod_resource', 'mod/resource:view', 'moodle_mobile_app'),
(482, 'mod_resource_get_resources_by_courses', 'mod_resource_external', 'get_resources_by_courses', NULL, 'mod_resource', 'mod/resource:view', 'moodle_mobile_app'),
(483, 'mod_scorm_view_scorm', 'mod_scorm_external', 'view_scorm', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(484, 'mod_scorm_get_scorm_attempt_count', 'mod_scorm_external', 'get_scorm_attempt_count', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(485, 'mod_scorm_get_scorm_scoes', 'mod_scorm_external', 'get_scorm_scoes', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(486, 'mod_scorm_get_scorm_user_data', 'mod_scorm_external', 'get_scorm_user_data', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(487, 'mod_scorm_insert_scorm_tracks', 'mod_scorm_external', 'insert_scorm_tracks', NULL, 'mod_scorm', 'mod/scorm:savetrack', 'moodle_mobile_app'),
(488, 'mod_scorm_get_scorm_sco_tracks', 'mod_scorm_external', 'get_scorm_sco_tracks', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(489, 'mod_scorm_get_scorms_by_courses', 'mod_scorm_external', 'get_scorms_by_courses', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(490, 'mod_scorm_launch_sco', 'mod_scorm_external', 'launch_sco', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(491, 'mod_scorm_get_scorm_access_information', 'mod_scorm_external', 'get_scorm_access_information', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(492, 'mod_survey_get_surveys_by_courses', 'mod_survey_external', 'get_surveys_by_courses', NULL, 'mod_survey', '', 'moodle_mobile_app'),
(493, 'mod_survey_view_survey', 'mod_survey_external', 'view_survey', NULL, 'mod_survey', 'mod/survey:participate', 'moodle_mobile_app'),
(494, 'mod_survey_get_questions', 'mod_survey_external', 'get_questions', NULL, 'mod_survey', 'mod/survey:participate', 'moodle_mobile_app'),
(495, 'mod_survey_submit_answers', 'mod_survey_external', 'submit_answers', NULL, 'mod_survey', 'mod/survey:participate', 'moodle_mobile_app'),
(496, 'mod_url_view_url', 'mod_url_external', 'view_url', NULL, 'mod_url', 'mod/url:view', 'moodle_mobile_app'),
(497, 'mod_url_get_urls_by_courses', 'mod_url_external', 'get_urls_by_courses', NULL, 'mod_url', 'mod/url:view', 'moodle_mobile_app'),
(498, 'mod_wiki_get_wikis_by_courses', 'mod_wiki_external', 'get_wikis_by_courses', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(499, 'mod_wiki_view_wiki', 'mod_wiki_external', 'view_wiki', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(500, 'mod_wiki_view_page', 'mod_wiki_external', 'view_page', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(501, 'mod_wiki_get_subwikis', 'mod_wiki_external', 'get_subwikis', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(502, 'mod_wiki_get_subwiki_pages', 'mod_wiki_external', 'get_subwiki_pages', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(503, 'mod_wiki_get_subwiki_files', 'mod_wiki_external', 'get_subwiki_files', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(504, 'mod_wiki_get_page_contents', 'mod_wiki_external', 'get_page_contents', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(505, 'mod_wiki_get_page_for_editing', 'mod_wiki_external', 'get_page_for_editing', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(506, 'mod_wiki_new_page', 'mod_wiki_external', 'new_page', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(507, 'mod_wiki_edit_page', 'mod_wiki_external', 'edit_page', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(508, 'mod_workshop_get_workshops_by_courses', 'mod_workshop_external', 'get_workshops_by_courses', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(509, 'mod_workshop_get_workshop_access_information', 'mod_workshop_external', 'get_workshop_access_information', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(510, 'mod_workshop_get_user_plan', 'mod_workshop_external', 'get_user_plan', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(511, 'mod_workshop_view_workshop', 'mod_workshop_external', 'view_workshop', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(512, 'mod_workshop_add_submission', 'mod_workshop_external', 'add_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(513, 'mod_workshop_update_submission', 'mod_workshop_external', 'update_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(514, 'mod_workshop_delete_submission', 'mod_workshop_external', 'delete_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(515, 'mod_workshop_get_submissions', 'mod_workshop_external', 'get_submissions', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(516, 'mod_workshop_get_submission', 'mod_workshop_external', 'get_submission', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(517, 'mod_workshop_get_submission_assessments', 'mod_workshop_external', 'get_submission_assessments', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(518, 'mod_workshop_get_assessment', 'mod_workshop_external', 'get_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(519, 'mod_workshop_get_assessment_form_definition', 'mod_workshop_external', 'get_assessment_form_definition', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(520, 'mod_workshop_get_reviewer_assessments', 'mod_workshop_external', 'get_reviewer_assessments', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(521, 'mod_workshop_update_assessment', 'mod_workshop_external', 'update_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(522, 'mod_workshop_get_grades', 'mod_workshop_external', 'get_grades', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(523, 'mod_workshop_evaluate_assessment', 'mod_workshop_external', 'evaluate_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(524, 'mod_workshop_get_grades_report', 'mod_workshop_external', 'get_grades_report', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(525, 'mod_workshop_view_submission', 'mod_workshop_external', 'view_submission', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(526, 'mod_workshop_evaluate_submission', 'mod_workshop_external', 'evaluate_submission', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(527, 'auth_email_get_signup_settings', 'auth_email_external', 'get_signup_settings', NULL, 'auth_email', '', NULL),
(528, 'auth_email_signup_user', 'auth_email_external', 'signup_user', NULL, 'auth_email', '', NULL),
(529, 'enrol_guest_get_instance_info', 'enrol_guest_external', 'get_instance_info', NULL, 'enrol_guest', '', 'moodle_mobile_app'),
(530, 'enrol_manual_enrol_users', 'enrol_manual_external', 'enrol_users', 'enrol/manual/externallib.php', 'enrol_manual', 'enrol/manual:enrol', NULL),
(531, 'enrol_manual_unenrol_users', 'enrol_manual_external', 'unenrol_users', 'enrol/manual/externallib.php', 'enrol_manual', 'enrol/manual:unenrol', NULL),
(532, 'enrol_self_get_instance_info', 'enrol_self_external', 'get_instance_info', 'enrol/self/externallib.php', 'enrol_self', '', 'moodle_mobile_app'),
(533, 'enrol_self_enrol_user', 'enrol_self_external', 'enrol_user', 'enrol/self/externallib.php', 'enrol_self', '', 'moodle_mobile_app'),
(534, 'message_airnotifier_is_system_configured', 'message_airnotifier_external', 'is_system_configured', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(535, 'message_airnotifier_are_notification_preferences_configured', 'message_airnotifier_external', 'are_notification_preferences_configured', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(536, 'message_airnotifier_get_user_devices', 'message_airnotifier_external', 'get_user_devices', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(537, 'message_airnotifier_enable_device', 'message_airnotifier_external', 'enable_device', 'message/output/airnotifier/externallib.php', 'message_airnotifier', 'message/airnotifier:managedevice', 'moodle_mobile_app'),
(538, 'message_popup_get_popup_notifications', 'message_popup_external', 'get_popup_notifications', 'message/output/popup/externallib.php', 'message_popup', '', 'moodle_mobile_app'),
(539, 'message_popup_get_unread_popup_notification_count', 'message_popup_external', 'get_unread_popup_notification_count', 'message/output/popup/externallib.php', 'message_popup', '', 'moodle_mobile_app'),
(540, 'block_accessreview_get_module_data', 'block_accessreview\\external\\get_module_data', 'execute', NULL, 'block_accessreview', 'block/accessreview:view', NULL),
(541, 'block_accessreview_get_section_data', 'block_accessreview\\external\\get_section_data', 'execute', NULL, 'block_accessreview', 'block/accessreview:view', NULL),
(542, 'block_recentlyaccesseditems_get_recent_items', 'block_recentlyaccesseditems\\external', 'get_recent_items', NULL, 'block_recentlyaccesseditems', '', 'moodle_mobile_app'),
(543, 'block_starredcourses_get_starred_courses', 'block_starredcourses_external', 'get_starred_courses', 'block/starredcourses/classes/external.php', 'block_starredcourses', '', 'moodle_mobile_app'),
(544, 'media_videojs_get_language', 'media_videojs\\external\\get_language', 'execute', NULL, 'media_videojs', '', NULL),
(545, 'report_competency_data_for_report', 'report_competency\\external', 'data_for_report', NULL, 'report_competency', 'moodle/competency:coursecompetencyview', NULL),
(546, 'report_insights_set_notuseful_prediction', 'report_insights\\external', 'set_notuseful_prediction', NULL, 'report_insights', '', 'moodle_mobile_app'),
(547, 'report_insights_set_fixed_prediction', 'report_insights\\external', 'set_fixed_prediction', NULL, 'report_insights', '', 'moodle_mobile_app'),
(548, 'report_insights_action_executed', 'report_insights\\external', 'action_executed', NULL, 'report_insights', '', 'moodle_mobile_app'),
(549, 'gradereport_overview_get_course_grades', 'gradereport_overview_external', 'get_course_grades', NULL, 'gradereport_overview', '', 'moodle_mobile_app'),
(550, 'gradereport_overview_view_grade_report', 'gradereport_overview_external', 'view_grade_report', NULL, 'gradereport_overview', 'gradereport/overview:view', 'moodle_mobile_app'),
(551, 'gradereport_user_get_grades_table', 'gradereport_user_external', 'get_grades_table', 'grade/report/user/externallib.php', 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(552, 'gradereport_user_view_grade_report', 'gradereport_user_external', 'view_grade_report', 'grade/report/user/externallib.php', 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(553, 'gradereport_user_get_grade_items', 'gradereport_user_external', 'get_grade_items', 'grade/report/user/externallib.php', 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(554, 'gradingform_guide_grader_gradingpanel_fetch', 'gradingform_guide\\grades\\grader\\gradingpanel\\external\\fetch', 'execute', NULL, 'gradingform_guide', '', NULL),
(555, 'gradingform_guide_grader_gradingpanel_store', 'gradingform_guide\\grades\\grader\\gradingpanel\\external\\store', 'execute', NULL, 'gradingform_guide', '', NULL),
(556, 'gradingform_rubric_grader_gradingpanel_fetch', 'gradingform_rubric\\grades\\grader\\gradingpanel\\external\\fetch', 'execute', NULL, 'gradingform_rubric', '', NULL),
(557, 'gradingform_rubric_grader_gradingpanel_store', 'gradingform_rubric\\grades\\grader\\gradingpanel\\external\\store', 'execute', NULL, 'gradingform_rubric', '', NULL),
(558, 'tool_analytics_potential_contexts', 'tool_analytics\\external', 'potential_contexts', NULL, 'tool_analytics', '', 'moodle_mobile_app'),
(559, 'tool_behat_get_entity_generator', 'tool_behat\\external\\get_entity_generator', 'execute', NULL, 'tool_behat', 'moodle/site:config', NULL),
(560, 'tool_dataprivacy_cancel_data_request', 'tool_dataprivacy\\external', 'cancel_data_request', NULL, 'tool_dataprivacy', '', NULL),
(561, 'tool_dataprivacy_contact_dpo', 'tool_dataprivacy\\external', 'contact_dpo', NULL, 'tool_dataprivacy', '', NULL),
(562, 'tool_dataprivacy_mark_complete', 'tool_dataprivacy\\external', 'mark_complete', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(563, 'tool_dataprivacy_get_data_request', 'tool_dataprivacy\\external', 'get_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(564, 'tool_dataprivacy_approve_data_request', 'tool_dataprivacy\\external', 'approve_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(565, 'tool_dataprivacy_bulk_approve_data_requests', 'tool_dataprivacy\\external', 'bulk_approve_data_requests', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(566, 'tool_dataprivacy_deny_data_request', 'tool_dataprivacy\\external', 'deny_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(567, 'tool_dataprivacy_bulk_deny_data_requests', 'tool_dataprivacy\\external', 'bulk_deny_data_requests', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(568, 'tool_dataprivacy_get_users', 'tool_dataprivacy\\external', 'get_users', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(569, 'tool_dataprivacy_create_purpose_form', 'tool_dataprivacy\\external', 'create_purpose_form', NULL, 'tool_dataprivacy', '', NULL),
(570, 'tool_dataprivacy_create_category_form', 'tool_dataprivacy\\external', 'create_category_form', NULL, 'tool_dataprivacy', '', NULL),
(571, 'tool_dataprivacy_delete_purpose', 'tool_dataprivacy\\external', 'delete_purpose', NULL, 'tool_dataprivacy', '', NULL),
(572, 'tool_dataprivacy_delete_category', 'tool_dataprivacy\\external', 'delete_category', NULL, 'tool_dataprivacy', '', NULL),
(573, 'tool_dataprivacy_set_contextlevel_form', 'tool_dataprivacy\\external', 'set_contextlevel_form', NULL, 'tool_dataprivacy', '', NULL),
(574, 'tool_dataprivacy_set_context_form', 'tool_dataprivacy\\external', 'set_context_form', NULL, 'tool_dataprivacy', '', NULL),
(575, 'tool_dataprivacy_tree_extra_branches', 'tool_dataprivacy\\external', 'tree_extra_branches', NULL, 'tool_dataprivacy', '', NULL),
(576, 'tool_dataprivacy_confirm_contexts_for_deletion', 'tool_dataprivacy\\external', 'confirm_contexts_for_deletion', NULL, 'tool_dataprivacy', '', NULL),
(577, 'tool_dataprivacy_set_context_defaults', 'tool_dataprivacy\\external', 'set_context_defaults', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(578, 'tool_dataprivacy_get_category_options', 'tool_dataprivacy\\external', 'get_category_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(579, 'tool_dataprivacy_get_purpose_options', 'tool_dataprivacy\\external', 'get_purpose_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(580, 'tool_dataprivacy_get_activity_options', 'tool_dataprivacy\\external', 'get_activity_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(581, 'tool_lp_data_for_competency_frameworks_manage_page', 'tool_lp\\external', 'data_for_competency_frameworks_manage_page', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(582, 'tool_lp_data_for_competency_summary', 'tool_lp\\external', 'data_for_competency_summary', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(583, 'tool_lp_data_for_competencies_manage_page', 'tool_lp\\external', 'data_for_competencies_manage_page', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(584, 'tool_lp_list_courses_using_competency', 'tool_lp\\external', 'list_courses_using_competency', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', NULL),
(585, 'tool_lp_data_for_course_competencies_page', 'tool_lp\\external', 'data_for_course_competencies_page', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(586, 'tool_lp_data_for_template_competencies_page', 'tool_lp\\external', 'data_for_template_competencies_page', NULL, 'tool_lp', 'moodle/competency:templateview', NULL),
(587, 'tool_lp_data_for_templates_manage_page', 'tool_lp\\external', 'data_for_templates_manage_page', NULL, 'tool_lp', 'moodle/competency:templateview', NULL),
(588, 'tool_lp_data_for_plans_page', 'tool_lp\\external', 'data_for_plans_page', NULL, 'tool_lp', 'moodle/competency:planviewown', 'moodle_mobile_app'),
(589, 'tool_lp_data_for_plan_page', 'tool_lp\\external', 'data_for_plan_page', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(590, 'tool_lp_data_for_related_competencies_section', 'tool_lp\\external', 'data_for_related_competencies_section', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(591, 'tool_lp_search_users', 'tool_lp\\external', 'search_users', NULL, 'tool_lp', '', NULL),
(592, 'tool_lp_search_cohorts', 'core_cohort_external', 'search_cohorts', 'cohort/externallib.php', 'tool_lp', 'moodle/cohort:view', NULL),
(593, 'tool_lp_data_for_user_evidence_list_page', 'tool_lp\\external', 'data_for_user_evidence_list_page', NULL, 'tool_lp', 'moodle/competency:userevidenceview', 'moodle_mobile_app'),
(594, 'tool_lp_data_for_user_evidence_page', 'tool_lp\\external', 'data_for_user_evidence_page', NULL, 'tool_lp', 'moodle/competency:userevidenceview', 'moodle_mobile_app'),
(595, 'tool_lp_data_for_user_competency_summary', 'tool_lp\\external', 'data_for_user_competency_summary', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(596, 'tool_lp_data_for_user_competency_summary_in_plan', 'tool_lp\\external', 'data_for_user_competency_summary_in_plan', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(597, 'tool_lp_data_for_user_competency_summary_in_course', 'tool_lp\\external', 'data_for_user_competency_summary_in_course', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(598, 'tool_mobile_get_plugins_supporting_mobile', 'tool_mobile\\external', 'get_plugins_supporting_mobile', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(599, 'tool_mobile_get_public_config', 'tool_mobile\\external', 'get_public_config', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(600, 'tool_mobile_get_config', 'tool_mobile\\external', 'get_config', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(601, 'tool_mobile_get_autologin_key', 'tool_mobile\\external', 'get_autologin_key', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(602, 'tool_mobile_get_content', 'tool_mobile\\external', 'get_content', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(603, 'tool_mobile_call_external_functions', 'tool_mobile\\external', 'call_external_functions', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(604, 'tool_mobile_validate_subscription_key', 'tool_mobile\\external', 'validate_subscription_key', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(605, 'tool_mobile_get_tokens_for_qr_login', 'tool_mobile\\external', 'get_tokens_for_qr_login', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(606, 'tool_moodlenet_verify_webfinger', 'tool_moodlenet\\external', 'verify_webfinger', NULL, 'tool_moodlenet', '', 'moodle_mobile_app'),
(607, 'tool_moodlenet_search_courses', 'tool_moodlenet\\external', 'search_courses', NULL, 'tool_moodlenet', '', 'moodle_mobile_app'),
(608, 'tool_policy_get_policy_version', 'tool_policy\\external', 'get_policy_version', NULL, 'tool_policy', '', NULL),
(609, 'tool_policy_submit_accept_on_behalf', 'tool_policy\\external', 'submit_accept_on_behalf', NULL, 'tool_policy', '', NULL),
(610, 'tool_templatelibrary_list_templates', 'tool_templatelibrary\\external', 'list_templates', NULL, 'tool_templatelibrary', '', NULL),
(611, 'tool_templatelibrary_load_canonical_template', 'tool_templatelibrary\\external', 'load_canonical_template', NULL, 'tool_templatelibrary', '', NULL),
(612, 'tool_usertours_fetch_and_start_tour', 'tool_usertours\\external\\tour', 'fetch_and_start_tour', NULL, 'tool_usertours', '', NULL),
(613, 'tool_usertours_step_shown', 'tool_usertours\\external\\tour', 'step_shown', NULL, 'tool_usertours', '', NULL),
(614, 'tool_usertours_complete_tour', 'tool_usertours\\external\\tour', 'complete_tour', NULL, 'tool_usertours', '', NULL),
(615, 'tool_usertours_reset_tour', 'tool_usertours\\external\\tour', 'reset_tour', NULL, 'tool_usertours', '', NULL),
(616, 'tool_xmldb_invoke_move_action', 'tool_xmldb_external', 'invoke_move_action', NULL, 'tool_xmldb', '', NULL),
(617, 'paygw_paypal_get_config_for_js', 'paygw_paypal\\external\\get_config_for_js', 'execute', NULL, 'paygw_paypal', '', NULL),
(618, 'paygw_paypal_create_transaction_complete', 'paygw_paypal\\external\\transaction_complete', 'execute', NULL, 'paygw_paypal', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services`
--

CREATE TABLE `[[dbprefix]]external_services` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  `requiredcapability` varchar(150) DEFAULT NULL,
  `restrictedusers` tinyint(1) NOT NULL,
  `component` varchar(100) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) DEFAULT NULL,
  `downloadfiles` tinyint(1) NOT NULL DEFAULT '0',
  `uploadfiles` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]exteserv_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='built in and custom external services' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]external_services`
--

INSERT INTO `[[dbprefix]]external_services` VALUES
(1, 'Moodle mobile web service', 0, NULL, 0, 'moodle', [[timestamp]], [[timestamp]], 'moodle_mobile_app', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services_functions`
--

CREATE TABLE `[[dbprefix]]external_services_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `functionname` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]exteservfunc_ext_ix` (`externalserviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='lists functions available in each service group' AUTO_INCREMENT=376 ;

--
-- Dumping data for table `[[dbprefix]]external_services_functions`
--

INSERT INTO `[[dbprefix]]external_services_functions` VALUES
(1, 1, 'core_badges_get_user_badges'),
(2, 1, 'core_blog_get_entries'),
(3, 1, 'core_blog_view_entries'),
(4, 1, 'core_calendar_get_calendar_monthly_view'),
(5, 1, 'core_calendar_get_calendar_day_view'),
(6, 1, 'core_calendar_get_calendar_upcoming_view'),
(7, 1, 'core_calendar_update_event_start_day'),
(8, 1, 'core_calendar_create_calendar_events'),
(9, 1, 'core_calendar_delete_calendar_events'),
(10, 1, 'core_calendar_get_calendar_events'),
(11, 1, 'core_calendar_get_action_events_by_timesort'),
(12, 1, 'core_calendar_get_action_events_by_course'),
(13, 1, 'core_calendar_get_action_events_by_courses'),
(14, 1, 'core_calendar_get_calendar_event_by_id'),
(15, 1, 'core_calendar_submit_create_update_form'),
(16, 1, 'core_calendar_get_calendar_access_information'),
(17, 1, 'core_calendar_get_allowed_event_types'),
(18, 1, 'core_calendar_get_calendar_export_token'),
(19, 1, 'core_comment_get_comments'),
(20, 1, 'core_comment_add_comments'),
(21, 1, 'core_comment_delete_comments'),
(22, 1, 'core_completion_get_activities_completion_status'),
(23, 1, 'core_completion_get_course_completion_status'),
(24, 1, 'core_completion_mark_course_self_completed'),
(25, 1, 'core_completion_update_activity_completion_status_manually'),
(26, 1, 'core_course_get_categories'),
(27, 1, 'core_course_get_contents'),
(28, 1, 'core_course_get_course_module'),
(29, 1, 'core_course_get_course_module_by_instance'),
(30, 1, 'core_course_get_courses'),
(31, 1, 'core_course_search_courses'),
(32, 1, 'core_course_view_course'),
(33, 1, 'core_course_get_user_navigation_options'),
(34, 1, 'core_course_get_user_administration_options'),
(35, 1, 'core_course_get_courses_by_field'),
(36, 1, 'core_course_check_updates'),
(37, 1, 'core_course_get_updates_since'),
(38, 1, 'core_course_get_enrolled_courses_by_timeline_classification'),
(39, 1, 'core_course_get_recent_courses'),
(40, 1, 'core_course_set_favourite_courses'),
(41, 1, 'core_enrol_get_course_enrolment_methods'),
(42, 1, 'core_enrol_get_enrolled_users'),
(43, 1, 'core_enrol_search_users'),
(44, 1, 'core_enrol_get_users_courses'),
(45, 1, 'core_files_get_files'),
(46, 1, 'core_files_delete_draft_files'),
(47, 1, 'core_files_get_unused_draft_itemid'),
(48, 1, 'core_get_component_strings'),
(49, 1, 'core_grades_grader_gradingpanel_point_fetch'),
(50, 1, 'core_grades_grader_gradingpanel_point_store'),
(51, 1, 'core_grades_grader_gradingpanel_scale_fetch'),
(52, 1, 'core_grades_grader_gradingpanel_scale_store'),
(53, 1, 'core_group_get_activity_allowed_groups'),
(54, 1, 'core_group_get_activity_groupmode'),
(55, 1, 'core_group_get_course_groupings'),
(56, 1, 'core_group_get_course_groups'),
(57, 1, 'core_group_get_course_user_groups'),
(58, 1, 'core_message_mute_conversations'),
(59, 1, 'core_message_unmute_conversations'),
(60, 1, 'core_message_block_user'),
(61, 1, 'core_message_get_contact_requests'),
(62, 1, 'core_message_create_contact_request'),
(63, 1, 'core_message_confirm_contact_request'),
(64, 1, 'core_message_decline_contact_request'),
(65, 1, 'core_message_get_received_contact_requests_count'),
(66, 1, 'core_message_delete_contacts'),
(67, 1, 'core_message_delete_conversations_by_id'),
(68, 1, 'core_message_delete_message'),
(69, 1, 'core_message_get_blocked_users'),
(70, 1, 'core_message_data_for_messagearea_search_messages'),
(71, 1, 'core_message_message_search_users'),
(72, 1, 'core_message_get_user_contacts'),
(73, 1, 'core_message_get_conversations'),
(74, 1, 'core_message_get_conversation'),
(75, 1, 'core_message_get_conversation_between_users'),
(76, 1, 'core_message_get_self_conversation'),
(77, 1, 'core_message_get_messages'),
(78, 1, 'core_message_get_conversation_counts'),
(79, 1, 'core_message_get_unread_conversation_counts'),
(80, 1, 'core_message_get_conversation_members'),
(81, 1, 'core_message_get_member_info'),
(82, 1, 'core_message_get_unread_conversations_count'),
(83, 1, 'core_message_mark_all_notifications_as_read'),
(84, 1, 'core_message_mark_all_conversation_messages_as_read'),
(85, 1, 'core_message_mark_message_read'),
(86, 1, 'core_message_mark_notification_read'),
(87, 1, 'core_message_message_processor_config_form'),
(88, 1, 'core_message_search_contacts'),
(89, 1, 'core_message_send_instant_messages'),
(90, 1, 'core_message_send_messages_to_conversation'),
(91, 1, 'core_message_get_conversation_messages'),
(92, 1, 'core_message_unblock_user'),
(93, 1, 'core_message_get_user_notification_preferences'),
(94, 1, 'core_message_get_user_message_preferences'),
(95, 1, 'core_message_set_favourite_conversations'),
(96, 1, 'core_message_unset_favourite_conversations'),
(97, 1, 'core_message_delete_message_for_all_users'),
(98, 1, 'core_notes_create_notes'),
(99, 1, 'core_notes_delete_notes'),
(100, 1, 'core_notes_get_course_notes'),
(101, 1, 'core_notes_view_notes'),
(102, 1, 'core_question_update_flag'),
(103, 1, 'core_rating_get_item_ratings'),
(104, 1, 'core_rating_add_rating'),
(105, 1, 'core_tag_get_tagindex'),
(106, 1, 'core_tag_get_tagindex_per_area'),
(107, 1, 'core_tag_get_tag_areas'),
(108, 1, 'core_tag_get_tag_collections'),
(109, 1, 'core_tag_get_tag_cloud'),
(110, 1, 'core_user_add_user_device'),
(111, 1, 'core_user_add_user_private_files'),
(112, 1, 'core_user_get_course_user_profiles'),
(113, 1, 'core_user_get_users_by_field'),
(114, 1, 'core_user_remove_user_device'),
(115, 1, 'core_user_update_user_preferences'),
(116, 1, 'core_user_view_user_list'),
(117, 1, 'core_user_view_user_profile'),
(118, 1, 'core_user_get_user_preferences'),
(119, 1, 'core_user_update_picture'),
(120, 1, 'core_user_set_user_preferences'),
(121, 1, 'core_user_agree_site_policy'),
(122, 1, 'core_user_get_private_files_info'),
(123, 1, 'core_competency_competency_viewed'),
(124, 1, 'core_competency_list_course_competencies'),
(125, 1, 'core_competency_get_scale_values'),
(126, 1, 'core_competency_user_competency_viewed'),
(127, 1, 'core_competency_user_competency_viewed_in_plan'),
(128, 1, 'core_competency_user_competency_viewed_in_course'),
(129, 1, 'core_competency_user_competency_plan_viewed'),
(130, 1, 'core_competency_grade_competency_in_course'),
(131, 1, 'core_competency_delete_evidence'),
(132, 1, 'core_webservice_get_site_info'),
(133, 1, 'core_block_get_course_blocks'),
(134, 1, 'core_block_get_dashboard_blocks'),
(135, 1, 'core_block_fetch_addable_blocks'),
(136, 1, 'core_filters_get_available_in_context'),
(137, 1, 'core_h5p_get_trusted_h5p_file'),
(138, 1, 'core_table_get_dynamic_table_content'),
(139, 1, 'core_xapi_statement_post'),
(140, 1, 'mod_assign_get_grades'),
(141, 1, 'mod_assign_get_assignments'),
(142, 1, 'mod_assign_get_submissions'),
(143, 1, 'mod_assign_get_user_flags'),
(144, 1, 'mod_assign_set_user_flags'),
(145, 1, 'mod_assign_get_user_mappings'),
(146, 1, 'mod_assign_revert_submissions_to_draft'),
(147, 1, 'mod_assign_lock_submissions'),
(148, 1, 'mod_assign_unlock_submissions'),
(149, 1, 'mod_assign_save_submission'),
(150, 1, 'mod_assign_submit_for_grading'),
(151, 1, 'mod_assign_save_grade'),
(152, 1, 'mod_assign_save_grades'),
(153, 1, 'mod_assign_save_user_extensions'),
(154, 1, 'mod_assign_reveal_identities'),
(155, 1, 'mod_assign_view_grading_table'),
(156, 1, 'mod_assign_view_submission_status'),
(157, 1, 'mod_assign_get_submission_status'),
(158, 1, 'mod_assign_list_participants'),
(159, 1, 'mod_assign_submit_grading_form'),
(160, 1, 'mod_assign_get_participant'),
(161, 1, 'mod_assign_view_assign'),
(162, 1, 'mod_book_view_book'),
(163, 1, 'mod_book_get_books_by_courses'),
(164, 1, 'mod_chat_login_user'),
(165, 1, 'mod_chat_get_chat_users'),
(166, 1, 'mod_chat_send_chat_message'),
(167, 1, 'mod_chat_get_chat_latest_messages'),
(168, 1, 'mod_chat_view_chat'),
(169, 1, 'mod_chat_get_chats_by_courses'),
(170, 1, 'mod_chat_get_sessions'),
(171, 1, 'mod_chat_get_session_messages'),
(172, 1, 'mod_choice_get_choice_results'),
(173, 1, 'mod_choice_get_choice_options'),
(174, 1, 'mod_choice_submit_choice_response'),
(175, 1, 'mod_choice_view_choice'),
(176, 1, 'mod_choice_get_choices_by_courses'),
(177, 1, 'mod_choice_delete_choice_responses'),
(178, 1, 'mod_data_get_databases_by_courses'),
(179, 1, 'mod_data_view_database'),
(180, 1, 'mod_data_get_data_access_information'),
(181, 1, 'mod_data_get_entries'),
(182, 1, 'mod_data_get_entry'),
(183, 1, 'mod_data_get_fields'),
(184, 1, 'mod_data_search_entries'),
(185, 1, 'mod_data_approve_entry'),
(186, 1, 'mod_data_delete_entry'),
(187, 1, 'mod_data_add_entry'),
(188, 1, 'mod_data_update_entry'),
(189, 1, 'mod_feedback_get_feedbacks_by_courses'),
(190, 1, 'mod_feedback_get_feedback_access_information'),
(191, 1, 'mod_feedback_view_feedback'),
(192, 1, 'mod_feedback_get_current_completed_tmp'),
(193, 1, 'mod_feedback_get_items'),
(194, 1, 'mod_feedback_launch_feedback'),
(195, 1, 'mod_feedback_get_page_items'),
(196, 1, 'mod_feedback_process_page'),
(197, 1, 'mod_feedback_get_analysis'),
(198, 1, 'mod_feedback_get_unfinished_responses'),
(199, 1, 'mod_feedback_get_finished_responses'),
(200, 1, 'mod_feedback_get_non_respondents'),
(201, 1, 'mod_feedback_get_responses_analysis'),
(202, 1, 'mod_feedback_get_last_completed'),
(203, 1, 'mod_folder_view_folder'),
(204, 1, 'mod_folder_get_folders_by_courses'),
(205, 1, 'mod_forum_get_forums_by_courses'),
(206, 1, 'mod_forum_get_discussion_posts'),
(207, 1, 'mod_forum_get_forum_discussion_posts'),
(208, 1, 'mod_forum_get_forum_discussions_paginated'),
(209, 1, 'mod_forum_get_forum_discussions'),
(210, 1, 'mod_forum_view_forum'),
(211, 1, 'mod_forum_view_forum_discussion'),
(212, 1, 'mod_forum_add_discussion_post'),
(213, 1, 'mod_forum_add_discussion'),
(214, 1, 'mod_forum_can_add_discussion'),
(215, 1, 'mod_forum_get_forum_access_information'),
(216, 1, 'mod_forum_set_subscription_state'),
(217, 1, 'mod_forum_set_lock_state'),
(218, 1, 'mod_forum_toggle_favourite_state'),
(219, 1, 'mod_forum_set_pin_state'),
(220, 1, 'mod_forum_delete_post'),
(221, 1, 'mod_forum_get_discussion_post'),
(222, 1, 'mod_forum_prepare_draft_area_for_post'),
(223, 1, 'mod_forum_update_discussion_post'),
(224, 1, 'mod_glossary_get_glossaries_by_courses'),
(225, 1, 'mod_glossary_view_glossary'),
(226, 1, 'mod_glossary_view_entry'),
(227, 1, 'mod_glossary_get_entries_by_letter'),
(228, 1, 'mod_glossary_get_entries_by_date'),
(229, 1, 'mod_glossary_get_categories'),
(230, 1, 'mod_glossary_get_entries_by_category'),
(231, 1, 'mod_glossary_get_authors'),
(232, 1, 'mod_glossary_get_entries_by_author'),
(233, 1, 'mod_glossary_get_entries_by_author_id'),
(234, 1, 'mod_glossary_get_entries_by_search'),
(235, 1, 'mod_glossary_get_entries_by_term'),
(236, 1, 'mod_glossary_get_entries_to_approve'),
(237, 1, 'mod_glossary_get_entry_by_id'),
(238, 1, 'mod_glossary_add_entry'),
(239, 1, 'mod_glossary_delete_entry'),
(240, 1, 'mod_glossary_update_entry'),
(241, 1, 'mod_glossary_prepare_entry_for_edition'),
(242, 1, 'mod_h5pactivity_get_h5pactivity_access_information'),
(243, 1, 'mod_h5pactivity_view_h5pactivity'),
(244, 1, 'mod_h5pactivity_get_attempts'),
(245, 1, 'mod_h5pactivity_get_results'),
(246, 1, 'mod_h5pactivity_get_h5pactivities_by_courses'),
(247, 1, 'mod_h5pactivity_log_report_viewed'),
(248, 1, 'mod_h5pactivity_get_user_attempts'),
(249, 1, 'mod_imscp_view_imscp'),
(250, 1, 'mod_imscp_get_imscps_by_courses'),
(251, 1, 'mod_label_get_labels_by_courses'),
(252, 1, 'mod_lesson_get_lessons_by_courses'),
(253, 1, 'mod_lesson_get_lesson_access_information'),
(254, 1, 'mod_lesson_view_lesson'),
(255, 1, 'mod_lesson_get_questions_attempts'),
(256, 1, 'mod_lesson_get_user_grade'),
(257, 1, 'mod_lesson_get_user_attempt_grade'),
(258, 1, 'mod_lesson_get_content_pages_viewed'),
(259, 1, 'mod_lesson_get_user_timers'),
(260, 1, 'mod_lesson_get_pages'),
(261, 1, 'mod_lesson_launch_attempt'),
(262, 1, 'mod_lesson_get_page_data'),
(263, 1, 'mod_lesson_process_page'),
(264, 1, 'mod_lesson_finish_attempt'),
(265, 1, 'mod_lesson_get_attempts_overview'),
(266, 1, 'mod_lesson_get_user_attempt'),
(267, 1, 'mod_lesson_get_pages_possible_jumps'),
(268, 1, 'mod_lesson_get_lesson'),
(269, 1, 'mod_lti_get_tool_launch_data'),
(270, 1, 'mod_lti_get_ltis_by_courses'),
(271, 1, 'mod_lti_view_lti'),
(272, 1, 'mod_page_view_page'),
(273, 1, 'mod_page_get_pages_by_courses'),
(274, 1, 'mod_quiz_get_quizzes_by_courses'),
(275, 1, 'mod_quiz_view_quiz'),
(276, 1, 'mod_quiz_get_user_attempts'),
(277, 1, 'mod_quiz_get_user_best_grade'),
(278, 1, 'mod_quiz_get_combined_review_options'),
(279, 1, 'mod_quiz_start_attempt'),
(280, 1, 'mod_quiz_get_attempt_data'),
(281, 1, 'mod_quiz_get_attempt_summary'),
(282, 1, 'mod_quiz_save_attempt'),
(283, 1, 'mod_quiz_process_attempt'),
(284, 1, 'mod_quiz_get_attempt_review'),
(285, 1, 'mod_quiz_view_attempt'),
(286, 1, 'mod_quiz_view_attempt_summary'),
(287, 1, 'mod_quiz_view_attempt_review'),
(288, 1, 'mod_quiz_get_quiz_feedback_for_grade'),
(289, 1, 'mod_quiz_get_quiz_access_information'),
(290, 1, 'mod_quiz_get_attempt_access_information'),
(291, 1, 'mod_quiz_get_quiz_required_qtypes'),
(292, 1, 'mod_resource_view_resource'),
(293, 1, 'mod_resource_get_resources_by_courses'),
(294, 1, 'mod_scorm_view_scorm'),
(295, 1, 'mod_scorm_get_scorm_attempt_count'),
(296, 1, 'mod_scorm_get_scorm_scoes'),
(297, 1, 'mod_scorm_get_scorm_user_data'),
(298, 1, 'mod_scorm_insert_scorm_tracks'),
(299, 1, 'mod_scorm_get_scorm_sco_tracks'),
(300, 1, 'mod_scorm_get_scorms_by_courses'),
(301, 1, 'mod_scorm_launch_sco'),
(302, 1, 'mod_scorm_get_scorm_access_information'),
(303, 1, 'mod_survey_get_surveys_by_courses'),
(304, 1, 'mod_survey_view_survey'),
(305, 1, 'mod_survey_get_questions'),
(306, 1, 'mod_survey_submit_answers'),
(307, 1, 'mod_url_view_url'),
(308, 1, 'mod_url_get_urls_by_courses'),
(309, 1, 'mod_wiki_get_wikis_by_courses'),
(310, 1, 'mod_wiki_view_wiki'),
(311, 1, 'mod_wiki_view_page'),
(312, 1, 'mod_wiki_get_subwikis'),
(313, 1, 'mod_wiki_get_subwiki_pages'),
(314, 1, 'mod_wiki_get_subwiki_files'),
(315, 1, 'mod_wiki_get_page_contents'),
(316, 1, 'mod_wiki_get_page_for_editing'),
(317, 1, 'mod_wiki_new_page'),
(318, 1, 'mod_wiki_edit_page'),
(319, 1, 'mod_workshop_get_workshops_by_courses'),
(320, 1, 'mod_workshop_get_workshop_access_information'),
(321, 1, 'mod_workshop_get_user_plan'),
(322, 1, 'mod_workshop_view_workshop'),
(323, 1, 'mod_workshop_add_submission'),
(324, 1, 'mod_workshop_update_submission'),
(325, 1, 'mod_workshop_delete_submission'),
(326, 1, 'mod_workshop_get_submissions'),
(327, 1, 'mod_workshop_get_submission'),
(328, 1, 'mod_workshop_get_submission_assessments'),
(329, 1, 'mod_workshop_get_assessment'),
(330, 1, 'mod_workshop_get_assessment_form_definition'),
(331, 1, 'mod_workshop_get_reviewer_assessments'),
(332, 1, 'mod_workshop_update_assessment'),
(333, 1, 'mod_workshop_get_grades'),
(334, 1, 'mod_workshop_evaluate_assessment'),
(335, 1, 'mod_workshop_get_grades_report'),
(336, 1, 'mod_workshop_view_submission'),
(337, 1, 'mod_workshop_evaluate_submission'),
(338, 1, 'enrol_guest_get_instance_info'),
(339, 1, 'enrol_self_get_instance_info'),
(340, 1, 'enrol_self_enrol_user'),
(341, 1, 'message_airnotifier_is_system_configured'),
(342, 1, 'message_airnotifier_are_notification_preferences_configured'),
(343, 1, 'message_airnotifier_get_user_devices'),
(344, 1, 'message_airnotifier_enable_device'),
(345, 1, 'message_popup_get_popup_notifications'),
(346, 1, 'message_popup_get_unread_popup_notification_count'),
(347, 1, 'block_recentlyaccesseditems_get_recent_items'),
(348, 1, 'block_starredcourses_get_starred_courses'),
(349, 1, 'report_insights_set_notuseful_prediction'),
(350, 1, 'report_insights_set_fixed_prediction'),
(351, 1, 'report_insights_action_executed'),
(352, 1, 'gradereport_overview_get_course_grades'),
(353, 1, 'gradereport_overview_view_grade_report'),
(354, 1, 'gradereport_user_get_grades_table'),
(355, 1, 'gradereport_user_view_grade_report'),
(356, 1, 'gradereport_user_get_grade_items'),
(357, 1, 'tool_analytics_potential_contexts'),
(358, 1, 'tool_lp_data_for_course_competencies_page'),
(359, 1, 'tool_lp_data_for_plans_page'),
(360, 1, 'tool_lp_data_for_plan_page'),
(361, 1, 'tool_lp_data_for_user_evidence_list_page'),
(362, 1, 'tool_lp_data_for_user_evidence_page'),
(363, 1, 'tool_lp_data_for_user_competency_summary'),
(364, 1, 'tool_lp_data_for_user_competency_summary_in_plan'),
(365, 1, 'tool_lp_data_for_user_competency_summary_in_course'),
(366, 1, 'tool_mobile_get_plugins_supporting_mobile'),
(367, 1, 'tool_mobile_get_public_config'),
(368, 1, 'tool_mobile_get_config'),
(369, 1, 'tool_mobile_get_autologin_key'),
(370, 1, 'tool_mobile_get_content'),
(371, 1, 'tool_mobile_call_external_functions'),
(372, 1, 'tool_mobile_validate_subscription_key'),
(373, 1, 'tool_mobile_get_tokens_for_qr_login'),
(374, 1, 'tool_moodlenet_verify_webfinger'),
(375, 1, 'tool_moodlenet_search_courses');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services_users`
--

CREATE TABLE `[[dbprefix]]external_services_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `iprestriction` varchar(255) DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]exteservuser_ext_ix` (`externalserviceid`),
  KEY `[[dbprefix]]exteservuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='users allowed to use services with restricted users flag' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_tokens`
--

CREATE TABLE `[[dbprefix]]external_tokens` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(128) NOT NULL DEFAULT '',
  `privatetoken` varchar(64) DEFAULT NULL,
  `tokentype` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `externalserviceid` bigint(10) NOT NULL,
  `sid` varchar(128) DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `creatorid` bigint(10) NOT NULL DEFAULT '1',
  `iprestriction` varchar(255) DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]extetoke_tok_ix` (`token`),
  KEY `[[dbprefix]]extetoke_use_ix` (`userid`),
  KEY `[[dbprefix]]extetoke_ext_ix` (`externalserviceid`),
  KEY `[[dbprefix]]extetoke_con_ix` (`contextid`),
  KEY `[[dbprefix]]extetoke_cre_ix` (`creatorid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Security tokens for accessing of external services' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favourite`
--

CREATE TABLE `[[dbprefix]]favourite` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemtype` varchar(100) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `ordering` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]favo_comiteiteconus_uix` (`component`,`itemtype`,`itemid`,`contextid`,`userid`),
  KEY `[[dbprefix]]favo_con_ix` (`contextid`),
  KEY `[[dbprefix]]favo_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the relationship between an arbitrary item (itemtype,' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback`
--

CREATE TABLE `[[dbprefix]]feedback` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `anonymous` tinyint(1) NOT NULL DEFAULT '1',
  `email_notification` tinyint(1) NOT NULL DEFAULT '1',
  `multiple_submit` tinyint(1) NOT NULL DEFAULT '1',
  `autonumbering` tinyint(1) NOT NULL DEFAULT '1',
  `site_after_submit` varchar(255) NOT NULL DEFAULT '',
  `page_after_submit` longtext NOT NULL,
  `page_after_submitformat` tinyint(2) NOT NULL DEFAULT '0',
  `publish_stats` tinyint(1) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feed_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all feedbacks' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_completed`
--

CREATE TABLE `[[dbprefix]]feedback_completed` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]feedcomp_fee_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='filled out feedback' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_completedtmp`
--

CREATE TABLE `[[dbprefix]]feedback_completedtmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `guestid` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedcomp_use2_ix` (`userid`),
  KEY `[[dbprefix]]feedcomp_fee2_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='filled out feedback' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_item`
--

CREATE TABLE `[[dbprefix]]feedback_item` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `template` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `presentation` longtext NOT NULL,
  `typ` varchar(255) NOT NULL DEFAULT '',
  `hasvalue` tinyint(1) NOT NULL DEFAULT '0',
  `position` smallint(3) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `dependitem` bigint(10) NOT NULL DEFAULT '0',
  `dependvalue` varchar(255) NOT NULL DEFAULT '',
  `options` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feeditem_fee_ix` (`feedback`),
  KEY `[[dbprefix]]feeditem_tem_ix` (`template`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='feedback_items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_sitecourse_map`
--

CREATE TABLE `[[dbprefix]]feedback_sitecourse_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedbackid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedsitemap_cou_ix` (`courseid`),
  KEY `[[dbprefix]]feedsitemap_fee_ix` (`feedbackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='feedback sitecourse map' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_template`
--

CREATE TABLE `[[dbprefix]]feedback_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedtemp_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='templates of feedbackstructures' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_value`
--

CREATE TABLE `[[dbprefix]]feedback_value` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]feedvalu_comitecou_uix` (`completed`,`item`,`course_id`),
  KEY `[[dbprefix]]feedvalu_cou_ix` (`course_id`),
  KEY `[[dbprefix]]feedvalu_ite_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='values of the completeds' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_valuetmp`
--

CREATE TABLE `[[dbprefix]]feedback_valuetmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]feedvalu_comitecou2_uix` (`completed`,`item`,`course_id`),
  KEY `[[dbprefix]]feedvalu_cou2_ix` (`course_id`),
  KEY `[[dbprefix]]feedvalu_ite2_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='values of the completedstmp' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files`
--

CREATE TABLE `[[dbprefix]]files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contenthash` varchar(40) NOT NULL DEFAULT '',
  `pathnamehash` varchar(40) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `filearea` varchar(50) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `filepath` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `userid` bigint(10) DEFAULT NULL,
  `filesize` bigint(10) NOT NULL,
  `mimetype` varchar(100) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `source` longtext,
  `author` varchar(255) DEFAULT NULL,
  `license` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `referencefileid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]file_pat_uix` (`pathnamehash`),
  KEY `[[dbprefix]]file_comfilconite_ix` (`component`,`filearea`,`contextid`,`itemid`),
  KEY `[[dbprefix]]file_con_ix` (`contenthash`),
  KEY `[[dbprefix]]file_lic_ix` (`license`),
  KEY `[[dbprefix]]file_con2_ix` (`contextid`),
  KEY `[[dbprefix]]file_use_ix` (`userid`),
  KEY `[[dbprefix]]file_ref_ix` (`referencefileid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='description of files, content is stored in sha1 file pool' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]files`
--

INSERT INTO `[[dbprefix]]files` VALUES
(1, '5f8e911d0da441e36f47c5c46f4393269211ca56', '508e674d49c30d4fde325fe6c7f6fd3d56b247e1', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'smile.png', 2, 1085, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(2, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '70b7cdade7b4e27d4e83f0cdaad10d6a3c0cccb5', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(3, '75c101cb8cb34ea573cd25ac38f8157b1de901b8', '68317eab56c67d32aeaee5acf509a0c4aa828b6b', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'sad.png', 2, 966, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(4, '0c5190a24c3943966541401c883eacaa20ca20cb', '695a55ff780e61c9e59428aa425430b0d6bde53b', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'tick.png', 2, 1039, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(5, '8c96a486d5801e0f4ab8c411f561f1c687e1f865', '373e63af262a9b8466ba8632551520be793c37ff', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'cross.png', 2, 861, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files_reference`
--

CREATE TABLE `[[dbprefix]]files_reference` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `repositoryid` bigint(10) NOT NULL,
  `lastsync` bigint(10) DEFAULT NULL,
  `reference` longtext,
  `referencehash` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filerefe_refrep_uix` (`referencehash`,`repositoryid`),
  KEY `[[dbprefix]]filerefe_rep_ix` (`repositoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store files references' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_conversion`
--

CREATE TABLE `[[dbprefix]]file_conversion` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `sourcefileid` bigint(10) NOT NULL,
  `targetformat` varchar(100) NOT NULL DEFAULT '',
  `status` bigint(10) DEFAULT '0',
  `statusmessage` longtext,
  `converter` varchar(255) DEFAULT NULL,
  `destfileid` bigint(10) DEFAULT NULL,
  `data` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]fileconv_sou_ix` (`sourcefileid`),
  KEY `[[dbprefix]]fileconv_des_ix` (`destfileid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to track file conversions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_active`
--

CREATE TABLE `[[dbprefix]]filter_active` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `active` smallint(4) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filtacti_confil_uix` (`contextid`,`filter`),
  KEY `[[dbprefix]]filtacti_con_ix` (`contextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores information about which filters are active in which c' AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]filter_active`
--

INSERT INTO `[[dbprefix]]filter_active` VALUES
(1, 'activitynames', 1, 1, 2),
(2, 'displayh5p', 1, 1, 1),
(3, 'emoticon', 1, 1, 4),
(4, 'mathjaxloader', 1, 1, 3),
(5, 'mediaplugin', 1, 1, 6),
(6, 'urltolink', 1, 1, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_config`
--

CREATE TABLE `[[dbprefix]]filter_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filtconf_confilnam_uix` (`contextid`,`filter`,`name`),
  KEY `[[dbprefix]]filtconf_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores per-context configuration settings for filters which ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]folder`
--

CREATE TABLE `[[dbprefix]]folder` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `display` smallint(4) NOT NULL DEFAULT '0',
  `showexpanded` tinyint(1) NOT NULL DEFAULT '1',
  `showdownloadfolder` tinyint(1) NOT NULL DEFAULT '1',
  `forcedownload` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]fold_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='each record is one folder resource' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum`
--

CREATE TABLE `[[dbprefix]]forum` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL DEFAULT 'general',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `duedate` bigint(10) NOT NULL DEFAULT '0',
  `cutoffdate` bigint(10) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `grade_forum` bigint(10) NOT NULL DEFAULT '0',
  `grade_forum_notify` smallint(4) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `maxattachments` bigint(10) NOT NULL DEFAULT '1',
  `forcesubscribe` tinyint(1) NOT NULL DEFAULT '0',
  `trackingtype` tinyint(2) NOT NULL DEFAULT '1',
  `rsstype` tinyint(2) NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `warnafter` bigint(10) NOT NULL DEFAULT '0',
  `blockafter` bigint(10) NOT NULL DEFAULT '0',
  `blockperiod` bigint(10) NOT NULL DEFAULT '0',
  `completiondiscussions` int(9) NOT NULL DEFAULT '0',
  `completionreplies` int(9) NOT NULL DEFAULT '0',
  `completionposts` int(9) NOT NULL DEFAULT '0',
  `displaywordcount` tinyint(1) NOT NULL DEFAULT '0',
  `lockdiscussionafter` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foru_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Forums contain and structure discussion' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_digests`
--

CREATE TABLE `[[dbprefix]]forum_digests` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `forum` bigint(10) NOT NULL,
  `maildigest` tinyint(1) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forudige_forusemai_uix` (`forum`,`userid`,`maildigest`),
  KEY `[[dbprefix]]forudige_use_ix` (`userid`),
  KEY `[[dbprefix]]forudige_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps track of user mail delivery preferences for each forum' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_discussions`
--

CREATE TABLE `[[dbprefix]]forum_discussions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `forum` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `firstpost` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '-1',
  `assessed` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `timelocked` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forudisc_use_ix` (`userid`),
  KEY `[[dbprefix]]forudisc_cou_ix` (`course`),
  KEY `[[dbprefix]]forudisc_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Forums are composed of discussions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_discussion_subs`
--

CREATE TABLE `[[dbprefix]]forum_discussion_subs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `forum` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `discussion` bigint(10) NOT NULL,
  `preference` bigint(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forudiscsubs_usedis_uix` (`userid`,`discussion`),
  KEY `[[dbprefix]]forudiscsubs_for_ix` (`forum`),
  KEY `[[dbprefix]]forudiscsubs_use_ix` (`userid`),
  KEY `[[dbprefix]]forudiscsubs_dis_ix` (`discussion`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Users may choose to subscribe and unsubscribe from specific ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_grades`
--

CREATE TABLE `[[dbprefix]]forum_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `forum` bigint(10) NOT NULL,
  `itemnumber` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `grade` decimal(10,5) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forugrad_foriteuse_uix` (`forum`,`itemnumber`,`userid`),
  KEY `[[dbprefix]]forugrad_use_ix` (`userid`),
  KEY `[[dbprefix]]forugrad_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Grading data for forum instances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_posts`
--

CREATE TABLE `[[dbprefix]]forum_posts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `discussion` bigint(10) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `created` bigint(10) NOT NULL DEFAULT '0',
  `modified` bigint(10) NOT NULL DEFAULT '0',
  `mailed` tinyint(2) NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` longtext NOT NULL,
  `messageformat` tinyint(2) NOT NULL DEFAULT '0',
  `messagetrust` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) NOT NULL DEFAULT '',
  `totalscore` smallint(4) NOT NULL DEFAULT '0',
  `mailnow` bigint(10) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `privatereplyto` bigint(10) NOT NULL DEFAULT '0',
  `wordcount` bigint(20) DEFAULT NULL,
  `charcount` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forupost_use_ix` (`userid`),
  KEY `[[dbprefix]]forupost_cre_ix` (`created`),
  KEY `[[dbprefix]]forupost_mai_ix` (`mailed`),
  KEY `[[dbprefix]]forupost_pri_ix` (`privatereplyto`),
  KEY `[[dbprefix]]forupost_dis_ix` (`discussion`),
  KEY `[[dbprefix]]forupost_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='All posts are stored in this table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_queue`
--

CREATE TABLE `[[dbprefix]]forum_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `discussionid` bigint(10) NOT NULL DEFAULT '0',
  `postid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foruqueu_use_ix` (`userid`),
  KEY `[[dbprefix]]foruqueu_dis_ix` (`discussionid`),
  KEY `[[dbprefix]]foruqueu_pos_ix` (`postid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='For keeping track of posts that will be mailed in digest for' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_read`
--

CREATE TABLE `[[dbprefix]]forum_read` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forumid` bigint(10) NOT NULL DEFAULT '0',
  `discussionid` bigint(10) NOT NULL DEFAULT '0',
  `postid` bigint(10) NOT NULL DEFAULT '0',
  `firstread` bigint(10) NOT NULL DEFAULT '0',
  `lastread` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foruread_usefor_ix` (`userid`,`forumid`),
  KEY `[[dbprefix]]foruread_usedis_ix` (`userid`,`discussionid`),
  KEY `[[dbprefix]]foruread_posuse_ix` (`postid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tracks each users read posts' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_subscriptions`
--

CREATE TABLE `[[dbprefix]]forum_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forum` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forusubs_usefor_uix` (`userid`,`forum`),
  KEY `[[dbprefix]]forusubs_use_ix` (`userid`),
  KEY `[[dbprefix]]forusubs_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps track of who is subscribed to what forum' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_track_prefs`
--

CREATE TABLE `[[dbprefix]]forum_track_prefs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forumid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forutracpref_usefor_ix` (`userid`,`forumid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tracks each users untracked forums' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary`
--

CREATE TABLE `[[dbprefix]]glossary` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `allowduplicatedentries` tinyint(2) NOT NULL DEFAULT '0',
  `displayformat` varchar(50) NOT NULL DEFAULT 'dictionary',
  `mainglossary` tinyint(2) NOT NULL DEFAULT '0',
  `showspecial` tinyint(2) NOT NULL DEFAULT '1',
  `showalphabet` tinyint(2) NOT NULL DEFAULT '1',
  `showall` tinyint(2) NOT NULL DEFAULT '1',
  `allowcomments` tinyint(2) NOT NULL DEFAULT '0',
  `allowprintview` tinyint(2) NOT NULL DEFAULT '1',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  `defaultapproval` tinyint(2) NOT NULL DEFAULT '1',
  `approvaldisplayformat` varchar(50) NOT NULL DEFAULT 'default',
  `globalglossary` tinyint(2) NOT NULL DEFAULT '0',
  `entbypage` smallint(3) NOT NULL DEFAULT '10',
  `editalways` tinyint(2) NOT NULL DEFAULT '0',
  `rsstype` tinyint(2) NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionentries` int(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glos_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all glossaries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_alias`
--

CREATE TABLE `[[dbprefix]]glossary_alias` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `entryid` bigint(10) NOT NULL DEFAULT '0',
  `alias` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosalia_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='entries alias' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_categories`
--

CREATE TABLE `[[dbprefix]]glossary_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gloscate_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all categories for glossary entries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_entries`
--

CREATE TABLE `[[dbprefix]]glossary_entries` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `concept` varchar(255) NOT NULL DEFAULT '',
  `definition` longtext NOT NULL,
  `definitionformat` tinyint(2) NOT NULL DEFAULT '0',
  `definitiontrust` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `teacherentry` tinyint(2) NOT NULL DEFAULT '0',
  `sourceglossaryid` bigint(10) NOT NULL DEFAULT '0',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  `casesensitive` tinyint(2) NOT NULL DEFAULT '0',
  `fullmatch` tinyint(2) NOT NULL DEFAULT '1',
  `approved` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosentr_use_ix` (`userid`),
  KEY `[[dbprefix]]glosentr_con_ix` (`concept`),
  KEY `[[dbprefix]]glosentr_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all glossary entries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_entries_categories`
--

CREATE TABLE `[[dbprefix]]glossary_entries_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `entryid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosentrcate_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]glosentrcate_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='categories of each glossary entry' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_formats`
--

CREATE TABLE `[[dbprefix]]glossary_formats` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `popupformatname` varchar(50) NOT NULL DEFAULT '',
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `showgroup` tinyint(2) NOT NULL DEFAULT '1',
  `showtabs` varchar(100) DEFAULT NULL,
  `defaultmode` varchar(50) NOT NULL DEFAULT '',
  `defaulthook` varchar(50) NOT NULL DEFAULT '',
  `sortkey` varchar(50) NOT NULL DEFAULT '',
  `sortorder` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Setting of the display formats' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]glossary_formats`
--

INSERT INTO `[[dbprefix]]glossary_formats` VALUES
(1, 'continuous', 'continuous', 1, 1, 'standard,category,date', '', '', '', ''),
(2, 'dictionary', 'dictionary', 1, 1, 'standard', '', '', '', ''),
(3, 'encyclopedia', 'encyclopedia', 1, 1, 'standard,category,date,author', '', '', '', ''),
(4, 'entrylist', 'entrylist', 1, 1, 'standard,category,date,author', '', '', '', ''),
(5, 'faq', 'faq', 1, 1, 'standard,category,date,author', '', '', '', ''),
(6, 'fullwithauthor', 'fullwithauthor', 1, 1, 'standard,category,date,author', '', '', '', ''),
(7, 'fullwithoutauthor', 'fullwithoutauthor', 1, 1, 'standard,category,date', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_categories`
--

CREATE TABLE `[[dbprefix]]grade_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `parent` bigint(10) DEFAULT NULL,
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) DEFAULT NULL,
  `fullname` varchar(255) NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradcate_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradcate_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table keeps information about categories, used for grou' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_categories_history`
--

CREATE TABLE `[[dbprefix]]grade_categories_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) NOT NULL,
  `parent` bigint(10) DEFAULT NULL,
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) DEFAULT NULL,
  `fullname` varchar(255) NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `aggregatesubcats` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradcatehist_act_ix` (`action`),
  KEY `[[dbprefix]]gradcatehist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]gradcatehist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradcatehist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradcatehist_par_ix` (`parent`),
  KEY `[[dbprefix]]gradcatehist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History of grade_categories' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_grades`
--

CREATE TABLE `[[dbprefix]]grade_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `exported` bigint(10) NOT NULL DEFAULT '0',
  `overridden` bigint(10) NOT NULL DEFAULT '0',
  `excluded` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext,
  `feedbackformat` bigint(10) NOT NULL DEFAULT '0',
  `information` longtext,
  `informationformat` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `aggregationstatus` varchar(10) NOT NULL DEFAULT 'unknown',
  `aggregationweight` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradgrad_useite_uix` (`userid`,`itemid`),
  KEY `[[dbprefix]]gradgrad_locloc_ix` (`locked`,`locktime`),
  KEY `[[dbprefix]]gradgrad_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]gradgrad_raw_ix` (`rawscaleid`),
  KEY `[[dbprefix]]gradgrad_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='grade_grades  This table keeps individual grades for each us' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_grades_history`
--

CREATE TABLE `[[dbprefix]]grade_grades_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `itemid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `exported` bigint(10) NOT NULL DEFAULT '0',
  `overridden` bigint(10) NOT NULL DEFAULT '0',
  `excluded` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext,
  `feedbackformat` bigint(10) NOT NULL DEFAULT '0',
  `information` longtext,
  `informationformat` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradgradhist_act_ix` (`action`),
  KEY `[[dbprefix]]gradgradhist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]gradgradhist_useitet_ix` (`userid`,`itemid`,`timemodified`),
  KEY `[[dbprefix]]gradgradhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradgradhist_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradgradhist_use_ix` (`userid`),
  KEY `[[dbprefix]]gradgradhist_raw_ix` (`rawscaleid`),
  KEY `[[dbprefix]]gradgradhist_use2_ix` (`usermodified`),
  KEY `[[dbprefix]]gradgradhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_import_newitem`
--

CREATE TABLE `[[dbprefix]]grade_import_newitem` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemname` varchar(255) NOT NULL DEFAULT '',
  `importcode` bigint(10) NOT NULL,
  `importer` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradimponewi_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='temporary table for storing new grade_item names from grade ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_import_values`
--

CREATE TABLE `[[dbprefix]]grade_import_values` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) DEFAULT NULL,
  `newgradeitem` bigint(10) DEFAULT NULL,
  `userid` bigint(10) NOT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `feedback` longtext,
  `importcode` bigint(10) NOT NULL,
  `importer` bigint(10) DEFAULT NULL,
  `importonlyfeedback` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradimpovalu_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradimpovalu_new_ix` (`newgradeitem`),
  KEY `[[dbprefix]]gradimpovalu_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Temporary table for importing grades' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_items`
--

CREATE TABLE `[[dbprefix]]grade_items` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `itemname` varchar(255) DEFAULT NULL,
  `itemtype` varchar(30) NOT NULL DEFAULT '',
  `itemmodule` varchar(30) DEFAULT NULL,
  `iteminstance` bigint(10) DEFAULT NULL,
  `itemnumber` bigint(10) DEFAULT NULL,
  `iteminfo` longtext,
  `idnumber` varchar(255) DEFAULT NULL,
  `calculation` longtext,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) DEFAULT NULL,
  `outcomeid` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]graditem_locloc_ix` (`locked`,`locktime`),
  KEY `[[dbprefix]]graditem_itenee_ix` (`itemtype`,`needsupdate`),
  KEY `[[dbprefix]]graditem_gra_ix` (`gradetype`),
  KEY `[[dbprefix]]graditem_idncou_ix` (`idnumber`,`courseid`),
  KEY `[[dbprefix]]graditem_cou_ix` (`courseid`),
  KEY `[[dbprefix]]graditem_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]graditem_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]graditem_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table keeps information about gradeable items (ie colum' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_items_history`
--

CREATE TABLE `[[dbprefix]]grade_items_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `itemname` varchar(255) DEFAULT NULL,
  `itemtype` varchar(30) NOT NULL DEFAULT '',
  `itemmodule` varchar(30) DEFAULT NULL,
  `iteminstance` bigint(10) DEFAULT NULL,
  `itemnumber` bigint(10) DEFAULT NULL,
  `iteminfo` longtext,
  `idnumber` varchar(255) DEFAULT NULL,
  `calculation` longtext,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) DEFAULT NULL,
  `outcomeid` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]graditemhist_act_ix` (`action`),
  KEY `[[dbprefix]]graditemhist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]graditemhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]graditemhist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]graditemhist_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]graditemhist_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]graditemhist_out_ix` (`outcomeid`),
  KEY `[[dbprefix]]graditemhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History of grade_items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_letters`
--

CREATE TABLE `[[dbprefix]]grade_letters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `lowerboundary` decimal(10,5) NOT NULL,
  `letter` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradlett_conlowlet_uix` (`contextid`,`lowerboundary`,`letter`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Repository for grade letters, for courses and other moodle e' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes`
--

CREATE TABLE `[[dbprefix]]grade_outcomes` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `fullname` longtext NOT NULL,
  `scaleid` bigint(10) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradoutc_cousho_uix` (`courseid`,`shortname`),
  KEY `[[dbprefix]]gradoutc_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutc_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]gradoutc_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table describes the outcomes used in the system. An out' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes_courses`
--

CREATE TABLE `[[dbprefix]]grade_outcomes_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `outcomeid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradoutccour_couout_uix` (`courseid`,`outcomeid`),
  KEY `[[dbprefix]]gradoutccour_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutccour_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='stores what outcomes are used in what courses.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes_history`
--

CREATE TABLE `[[dbprefix]]grade_outcomes_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `fullname` longtext NOT NULL,
  `scaleid` bigint(10) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradoutchist_act_ix` (`action`),
  KEY `[[dbprefix]]gradoutchist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]gradoutchist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradoutchist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutchist_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]gradoutchist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_settings`
--

CREATE TABLE `[[dbprefix]]grade_settings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradsett_counam_uix` (`courseid`,`name`),
  KEY `[[dbprefix]]gradsett_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='gradebook settings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_guide_comments`
--

CREATE TABLE `[[dbprefix]]gradingform_guide_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradguidcomm_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='frequently used comments used in marking guide' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_guide_criteria`
--

CREATE TABLE `[[dbprefix]]gradingform_guide_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  `descriptionmarkers` longtext,
  `descriptionmarkersformat` tinyint(2) DEFAULT NULL,
  `maxscore` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradguidcrit_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the rows of the criteria grid.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_guide_fillings`
--

CREATE TABLE `[[dbprefix]]gradingform_guide_fillings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) NOT NULL,
  `criterionid` bigint(10) NOT NULL,
  `remark` longtext,
  `remarkformat` tinyint(2) DEFAULT NULL,
  `score` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradguidfill_inscri_uix` (`instanceid`,`criterionid`),
  KEY `[[dbprefix]]gradguidfill_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]gradguidfill_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the data of how the guide is filled by a particular r' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_rubric_criteria`
--

CREATE TABLE `[[dbprefix]]gradingform_rubric_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradrubrcrit_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the rows of the rubric grid.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_rubric_fillings`
--

CREATE TABLE `[[dbprefix]]gradingform_rubric_fillings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) NOT NULL,
  `criterionid` bigint(10) NOT NULL,
  `levelid` bigint(10) DEFAULT NULL,
  `remark` longtext,
  `remarkformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradrubrfill_inscri_uix` (`instanceid`,`criterionid`),
  KEY `[[dbprefix]]gradrubrfill_lev_ix` (`levelid`),
  KEY `[[dbprefix]]gradrubrfill_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]gradrubrfill_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the data of how the rubric is filled by a particular ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_rubric_levels`
--

CREATE TABLE `[[dbprefix]]gradingform_rubric_levels` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `criterionid` bigint(10) NOT NULL,
  `score` decimal(10,5) NOT NULL,
  `definition` longtext,
  `definitionformat` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradrubrleve_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the columns of the rubric grid.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grading_areas`
--

CREATE TABLE `[[dbprefix]]grading_areas` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `areaname` varchar(100) NOT NULL DEFAULT '',
  `activemethod` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradarea_concomare_uix` (`contextid`,`component`,`areaname`),
  KEY `[[dbprefix]]gradarea_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Identifies gradable areas where advanced grading can happen.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grading_definitions`
--

CREATE TABLE `[[dbprefix]]grading_definitions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `areaid` bigint(10) NOT NULL,
  `method` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `copiedfromid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usercreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecopied` bigint(10) DEFAULT '0',
  `options` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]graddefi_aremet_uix` (`areaid`,`method`),
  KEY `[[dbprefix]]graddefi_are_ix` (`areaid`),
  KEY `[[dbprefix]]graddefi_use_ix` (`usermodified`),
  KEY `[[dbprefix]]graddefi_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains the basic information about an advanced grading for' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grading_instances`
--

CREATE TABLE `[[dbprefix]]grading_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `raterid` bigint(10) NOT NULL,
  `itemid` bigint(10) DEFAULT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext,
  `feedbackformat` tinyint(2) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradinst_def_ix` (`definitionid`),
  KEY `[[dbprefix]]gradinst_rat_ix` (`raterid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Grading form instance is an assessment record for one gradab' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groupings`
--

CREATE TABLE `[[dbprefix]]groupings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `configdata` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grou_idn2_ix` (`idnumber`),
  KEY `[[dbprefix]]grou_cou2_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A grouping is a collection of groups. WAS: groups_groupings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groupings_groups`
--

CREATE TABLE `[[dbprefix]]groupings_groups` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `groupingid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grougrou_gro_ix` (`groupingid`),
  KEY `[[dbprefix]]grougrou_gro2_ix` (`groupid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a grouping to a group (note, groups can be in multiple ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(254) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `enrolmentkey` varchar(50) DEFAULT NULL,
  `picture` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grou_idn_ix` (`idnumber`),
  KEY `[[dbprefix]]grou_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each record represents a group.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups_members`
--

CREATE TABLE `[[dbprefix]]groups_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]groumemb_usegro_uix` (`userid`,`groupid`),
  KEY `[[dbprefix]]groumemb_gro_ix` (`groupid`),
  KEY `[[dbprefix]]groumemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a user to a group.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p`
--

CREATE TABLE `[[dbprefix]]h5p` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `jsoncontent` longtext NOT NULL,
  `mainlibraryid` bigint(10) NOT NULL,
  `displayoptions` smallint(4) DEFAULT NULL,
  `pathnamehash` varchar(40) NOT NULL DEFAULT '',
  `contenthash` varchar(40) NOT NULL DEFAULT '',
  `filtered` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5p_pat_ix` (`pathnamehash`),
  KEY `[[dbprefix]]h5p_mai_ix` (`mainlibraryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores H5P content information' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5pactivity`
--

CREATE TABLE `[[dbprefix]]h5pactivity` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `grade` bigint(10) DEFAULT '0',
  `displayoptions` smallint(4) NOT NULL DEFAULT '0',
  `enabletracking` tinyint(1) NOT NULL DEFAULT '1',
  `grademethod` smallint(4) NOT NULL DEFAULT '1',
  `reviewmode` smallint(4) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5pa_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the h5pactivity activity module instances.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5pactivity_attempts`
--

CREATE TABLE `[[dbprefix]]h5pactivity_attempts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `h5pactivityid` bigint(10) NOT NULL,
  `userid` bigint(20) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `attempt` mediumint(6) NOT NULL DEFAULT '1',
  `rawscore` bigint(10) DEFAULT '0',
  `maxscore` bigint(10) DEFAULT '0',
  `scaled` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `duration` bigint(10) DEFAULT '0',
  `completion` tinyint(1) DEFAULT NULL,
  `success` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]h5paatte_h5puseatt_uix` (`h5pactivityid`,`userid`,`attempt`),
  KEY `[[dbprefix]]h5paatte_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]h5paatte_h5ptim_ix` (`h5pactivityid`,`timecreated`),
  KEY `[[dbprefix]]h5paatte_h5puse_ix` (`h5pactivityid`,`userid`),
  KEY `[[dbprefix]]h5paatte_h5p_ix` (`h5pactivityid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Users attempts inside H5P activities' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5pactivity_attempts_results`
--

CREATE TABLE `[[dbprefix]]h5pactivity_attempts_results` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `attemptid` bigint(10) NOT NULL,
  `subcontent` varchar(128) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `interactiontype` varchar(128) DEFAULT NULL,
  `description` longtext,
  `correctpattern` longtext,
  `response` longtext NOT NULL,
  `additionals` longtext,
  `rawscore` bigint(10) NOT NULL DEFAULT '0',
  `maxscore` bigint(10) NOT NULL DEFAULT '0',
  `duration` bigint(10) DEFAULT '0',
  `completion` tinyint(1) DEFAULT NULL,
  `success` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5paatteresu_atttim_ix` (`attemptid`,`timecreated`),
  KEY `[[dbprefix]]h5paatteresu_att_ix` (`attemptid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='H5Pactivities_attempts tracking info' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p_contents_libraries`
--

CREATE TABLE `[[dbprefix]]h5p_contents_libraries` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `h5pid` bigint(10) NOT NULL,
  `libraryid` bigint(10) NOT NULL,
  `dependencytype` varchar(10) NOT NULL DEFAULT '',
  `dropcss` tinyint(1) NOT NULL,
  `weight` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5pcontlibr_h5p_ix` (`h5pid`),
  KEY `[[dbprefix]]h5pcontlibr_lib_ix` (`libraryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store which library is used in which content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p_libraries`
--

CREATE TABLE `[[dbprefix]]h5p_libraries` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `machinename` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `majorversion` smallint(4) NOT NULL,
  `minorversion` smallint(4) NOT NULL,
  `patchversion` smallint(4) NOT NULL,
  `runnable` tinyint(1) NOT NULL,
  `fullscreen` tinyint(1) NOT NULL DEFAULT '0',
  `embedtypes` varchar(255) NOT NULL DEFAULT '',
  `preloadedjs` longtext,
  `preloadedcss` longtext,
  `droplibrarycss` longtext,
  `semantics` longtext,
  `addto` longtext,
  `coremajor` smallint(4) DEFAULT NULL,
  `coreminor` smallint(4) DEFAULT NULL,
  `metadatasettings` longtext,
  `tutorial` longtext,
  `example` longtext,
  `enabled` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5plibr_macmajminpat_ix` (`machinename`,`majorversion`,`minorversion`,`patchversion`,`runnable`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores information about libraries used by H5P content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p_libraries_cachedassets`
--

CREATE TABLE `[[dbprefix]]h5p_libraries_cachedassets` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `libraryid` bigint(10) NOT NULL,
  `hash` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5plibrcach_lib_ix` (`libraryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='H5P cached library assets' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p_library_dependencies`
--

CREATE TABLE `[[dbprefix]]h5p_library_dependencies` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `libraryid` bigint(10) NOT NULL,
  `requiredlibraryid` bigint(10) NOT NULL,
  `dependencytype` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5plibrdepe_lib_ix` (`libraryid`),
  KEY `[[dbprefix]]h5plibrdepe_req_ix` (`requiredlibraryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores H5P library dependencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]imscp`
--

CREATE TABLE `[[dbprefix]]imscp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `keepold` bigint(10) NOT NULL DEFAULT '-1',
  `structure` longtext,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]imsc_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='each record is one imscp resource' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]infected_files`
--

CREATE TABLE `[[dbprefix]]infected_files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filename` longtext NOT NULL,
  `quarantinedfile` longtext,
  `userid` bigint(10) NOT NULL,
  `reason` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]infefile_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to store infected file details.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]label`
--

CREATE TABLE `[[dbprefix]]label` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]labe_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines labels' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson`
--

CREATE TABLE `[[dbprefix]]lesson` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `practice` smallint(3) NOT NULL DEFAULT '0',
  `modattempts` smallint(3) NOT NULL DEFAULT '0',
  `usepassword` smallint(3) NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL DEFAULT '',
  `dependency` bigint(10) NOT NULL DEFAULT '0',
  `conditions` longtext NOT NULL,
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `custom` smallint(3) NOT NULL DEFAULT '0',
  `ongoing` smallint(3) NOT NULL DEFAULT '0',
  `usemaxgrade` smallint(3) NOT NULL DEFAULT '0',
  `maxanswers` smallint(3) NOT NULL DEFAULT '4',
  `maxattempts` smallint(3) NOT NULL DEFAULT '5',
  `review` smallint(3) NOT NULL DEFAULT '0',
  `nextpagedefault` smallint(3) NOT NULL DEFAULT '0',
  `feedback` smallint(3) NOT NULL DEFAULT '1',
  `minquestions` smallint(3) NOT NULL DEFAULT '0',
  `maxpages` smallint(3) NOT NULL DEFAULT '0',
  `timelimit` bigint(10) NOT NULL DEFAULT '0',
  `retake` smallint(3) NOT NULL DEFAULT '1',
  `activitylink` bigint(10) NOT NULL DEFAULT '0',
  `mediafile` varchar(255) NOT NULL DEFAULT '',
  `mediaheight` bigint(10) NOT NULL DEFAULT '100',
  `mediawidth` bigint(10) NOT NULL DEFAULT '650',
  `mediaclose` smallint(3) NOT NULL DEFAULT '0',
  `slideshow` smallint(3) NOT NULL DEFAULT '0',
  `width` bigint(10) NOT NULL DEFAULT '640',
  `height` bigint(10) NOT NULL DEFAULT '480',
  `bgcolor` varchar(7) NOT NULL DEFAULT '#FFFFFF',
  `displayleft` smallint(3) NOT NULL DEFAULT '0',
  `displayleftif` smallint(3) NOT NULL DEFAULT '0',
  `progressbar` smallint(3) NOT NULL DEFAULT '0',
  `available` bigint(10) NOT NULL DEFAULT '0',
  `deadline` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionendreached` tinyint(1) DEFAULT '0',
  `completiontimespent` bigint(11) DEFAULT '0',
  `allowofflineattempts` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]less_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_answers`
--

CREATE TABLE `[[dbprefix]]lesson_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `jumpto` bigint(11) NOT NULL DEFAULT '0',
  `grade` smallint(4) NOT NULL DEFAULT '0',
  `score` bigint(10) NOT NULL DEFAULT '0',
  `flags` smallint(3) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `answer` longtext,
  `answerformat` tinyint(2) NOT NULL DEFAULT '0',
  `response` longtext,
  `responseformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessansw_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessansw_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson_answers' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_attempts`
--

CREATE TABLE `[[dbprefix]]lesson_attempts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `answerid` bigint(10) NOT NULL DEFAULT '0',
  `retry` smallint(3) NOT NULL DEFAULT '0',
  `correct` bigint(10) NOT NULL DEFAULT '0',
  `useranswer` longtext,
  `timeseen` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessatte_use_ix` (`userid`),
  KEY `[[dbprefix]]lessatte_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessatte_pag_ix` (`pageid`),
  KEY `[[dbprefix]]lessatte_ans_ix` (`answerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson_attempts' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_branch`
--

CREATE TABLE `[[dbprefix]]lesson_branch` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `retry` bigint(10) NOT NULL DEFAULT '0',
  `flag` smallint(3) NOT NULL DEFAULT '0',
  `timeseen` bigint(10) NOT NULL DEFAULT '0',
  `nextpageid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessbran_use_ix` (`userid`),
  KEY `[[dbprefix]]lessbran_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessbran_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='branches for each lesson/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_grades`
--

CREATE TABLE `[[dbprefix]]lesson_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `grade` double NOT NULL DEFAULT '0',
  `late` smallint(3) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]lessgrad_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson_grades' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_overrides`
--

CREATE TABLE `[[dbprefix]]lesson_overrides` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) DEFAULT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `available` bigint(10) DEFAULT NULL,
  `deadline` bigint(10) DEFAULT NULL,
  `timelimit` bigint(10) DEFAULT NULL,
  `review` smallint(3) DEFAULT NULL,
  `maxattempts` smallint(3) DEFAULT NULL,
  `retake` smallint(3) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessover_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]lessover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The overrides to lesson settings.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_pages`
--

CREATE TABLE `[[dbprefix]]lesson_pages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `prevpageid` bigint(10) NOT NULL DEFAULT '0',
  `nextpageid` bigint(10) NOT NULL DEFAULT '0',
  `qtype` smallint(3) NOT NULL DEFAULT '0',
  `qoption` smallint(3) NOT NULL DEFAULT '0',
  `layout` smallint(3) NOT NULL DEFAULT '1',
  `display` smallint(3) NOT NULL DEFAULT '1',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `contents` longtext NOT NULL,
  `contentsformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lesspage_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson_pages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_timer`
--

CREATE TABLE `[[dbprefix]]lesson_timer` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `starttime` bigint(10) NOT NULL DEFAULT '0',
  `lessontime` bigint(10) NOT NULL DEFAULT '0',
  `completed` tinyint(1) DEFAULT '0',
  `timemodifiedoffline` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lesstime_use_ix` (`userid`),
  KEY `[[dbprefix]]lesstime_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='lesson timer for each lesson' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]license`
--

CREATE TABLE `[[dbprefix]]license` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(255) DEFAULT NULL,
  `fullname` longtext,
  `source` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `version` bigint(10) NOT NULL DEFAULT '0',
  `custom` tinyint(1) NOT NULL DEFAULT '0',
  `sortorder` mediumint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='store licenses used by moodle' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]license`
--

INSERT INTO `[[dbprefix]]license` VALUES
(1, 'unknown', 'Licence not specified', '', 1, 2010033100, 0, 1),
(2, 'allrightsreserved', 'All rights reserved', 'https://en.wikipedia.org/wiki/All_rights_reserved', 1, 2010033100, 0, 2),
(3, 'public', 'Public domain', 'https://en.wikipedia.org/wiki/Public_domain', 1, 2010033100, 0, 3),
(4, 'cc', 'Creative Commons', 'https://creativecommons.org/licenses/by/3.0/', 1, 2010033100, 0, 4),
(5, 'cc-nd', 'Creative Commons - NoDerivs', 'https://creativecommons.org/licenses/by-nd/3.0/', 1, 2010033100, 0, 5),
(6, 'cc-nc-nd', 'Creative Commons - No Commercial NoDerivs', 'https://creativecommons.org/licenses/by-nc-nd/3.0/', 1, 2010033100, 0, 6),
(7, 'cc-nc', 'Creative Commons - No Commercial', 'https://creativecommons.org/licenses/by-nc/3.0/', 1, 2010033100, 0, 7),
(8, 'cc-nc-sa', 'Creative Commons - No Commercial ShareAlike', 'https://creativecommons.org/licenses/by-nc-sa/3.0/', 1, 2010033100, 0, 8),
(9, 'cc-sa', 'Creative Commons - ShareAlike', 'https://creativecommons.org/licenses/by-sa/3.0/', 1, 2010033100, 0, 9);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lock_db`
--

CREATE TABLE `[[dbprefix]]lock_db` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `resourcekey` varchar(255) NOT NULL DEFAULT '',
  `expires` bigint(10) DEFAULT NULL,
  `owner` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]lockdb_res_uix` (`resourcekey`),
  KEY `[[dbprefix]]lockdb_exp_ix` (`expires`),
  KEY `[[dbprefix]]lockdb_own_ix` (`owner`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores active and inactive lock types for db locking method.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `time` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `module` varchar(20) NOT NULL DEFAULT '',
  `cmid` bigint(10) NOT NULL DEFAULT '0',
  `action` varchar(40) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `info` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]log_coumodact_ix` (`course`,`module`,`action`),
  KEY `[[dbprefix]]log_tim_ix` (`time`),
  KEY `[[dbprefix]]log_act_ix` (`action`),
  KEY `[[dbprefix]]log_usecou_ix` (`userid`,`course`),
  KEY `[[dbprefix]]log_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Every action is logged as far as possible' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logstore_standard_log`
--

CREATE TABLE `[[dbprefix]]logstore_standard_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(255) NOT NULL DEFAULT '',
  `component` varchar(100) NOT NULL DEFAULT '',
  `action` varchar(100) NOT NULL DEFAULT '',
  `target` varchar(100) NOT NULL DEFAULT '',
  `objecttable` varchar(50) DEFAULT NULL,
  `objectid` bigint(10) DEFAULT NULL,
  `crud` varchar(1) NOT NULL DEFAULT '',
  `edulevel` tinyint(1) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `contextlevel` bigint(10) NOT NULL,
  `contextinstanceid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `relateduserid` bigint(10) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `other` longtext,
  `timecreated` bigint(10) NOT NULL,
  `origin` varchar(10) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `realuserid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]logsstanlog_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]logsstanlog_couanoti_ix` (`courseid`,`anonymous`,`timecreated`),
  KEY `[[dbprefix]]logsstanlog_useconco_ix` (`userid`,`contextlevel`,`contextinstanceid`,`crud`,`edulevel`,`timecreated`),
  KEY `[[dbprefix]]logsstanlog_con_ix` (`contextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Standard log table' AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]logstore_standard_log`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_display`
--

CREATE TABLE `[[dbprefix]]log_display` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `module` varchar(20) NOT NULL DEFAULT '',
  `action` varchar(40) NOT NULL DEFAULT '',
  `mtable` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(200) NOT NULL DEFAULT '',
  `component` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]logdisp_modact_uix` (`module`,`action`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='For a particular module/action, specifies a moodle table/fie' AUTO_INCREMENT=190 ;

--
-- Dumping data for table `[[dbprefix]]log_display`
--

INSERT INTO `[[dbprefix]]log_display` VALUES
(1, 'course', 'user report', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(2, 'course', 'view', 'course', 'fullname', 'moodle'),
(3, 'course', 'view section', 'course_sections', 'name', 'moodle'),
(4, 'course', 'update', 'course', 'fullname', 'moodle'),
(5, 'course', 'hide', 'course', 'fullname', 'moodle'),
(6, 'course', 'show', 'course', 'fullname', 'moodle'),
(7, 'course', 'move', 'course', 'fullname', 'moodle'),
(8, 'course', 'enrol', 'course', 'fullname', 'moodle'),
(9, 'course', 'unenrol', 'course', 'fullname', 'moodle'),
(10, 'course', 'report log', 'course', 'fullname', 'moodle'),
(11, 'course', 'report live', 'course', 'fullname', 'moodle'),
(12, 'course', 'report outline', 'course', 'fullname', 'moodle'),
(13, 'course', 'report participation', 'course', 'fullname', 'moodle'),
(14, 'course', 'report stats', 'course', 'fullname', 'moodle'),
(15, 'category', 'add', 'course_categories', 'name', 'moodle'),
(16, 'category', 'hide', 'course_categories', 'name', 'moodle'),
(17, 'category', 'move', 'course_categories', 'name', 'moodle'),
(18, 'category', 'show', 'course_categories', 'name', 'moodle'),
(19, 'category', 'update', 'course_categories', 'name', 'moodle'),
(20, 'message', 'write', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(21, 'message', 'read', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(22, 'message', 'add contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(23, 'message', 'remove contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(24, 'message', 'block contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(25, 'message', 'unblock contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(26, 'group', 'view', 'groups', 'name', 'moodle'),
(27, 'tag', 'update', 'tag', 'name', 'moodle'),
(28, 'tag', 'flag', 'tag', 'name', 'moodle'),
(29, 'user', 'view', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(30, 'assign', 'add', 'assign', 'name', 'mod_assign'),
(31, 'assign', 'delete mod', 'assign', 'name', 'mod_assign'),
(32, 'assign', 'download all submissions', 'assign', 'name', 'mod_assign'),
(33, 'assign', 'grade submission', 'assign', 'name', 'mod_assign'),
(34, 'assign', 'lock submission', 'assign', 'name', 'mod_assign'),
(35, 'assign', 'reveal identities', 'assign', 'name', 'mod_assign'),
(36, 'assign', 'revert submission to draft', 'assign', 'name', 'mod_assign'),
(37, 'assign', 'set marking workflow state', 'assign', 'name', 'mod_assign'),
(38, 'assign', 'submission statement accepted', 'assign', 'name', 'mod_assign'),
(39, 'assign', 'submit', 'assign', 'name', 'mod_assign'),
(40, 'assign', 'submit for grading', 'assign', 'name', 'mod_assign'),
(41, 'assign', 'unlock submission', 'assign', 'name', 'mod_assign'),
(42, 'assign', 'update', 'assign', 'name', 'mod_assign'),
(43, 'assign', 'upload', 'assign', 'name', 'mod_assign'),
(44, 'assign', 'view', 'assign', 'name', 'mod_assign'),
(45, 'assign', 'view all', 'course', 'fullname', 'mod_assign'),
(46, 'assign', 'view confirm submit assignment form', 'assign', 'name', 'mod_assign'),
(47, 'assign', 'view grading form', 'assign', 'name', 'mod_assign'),
(48, 'assign', 'view submission', 'assign', 'name', 'mod_assign'),
(49, 'assign', 'view submission grading table', 'assign', 'name', 'mod_assign'),
(50, 'assign', 'view submit assignment form', 'assign', 'name', 'mod_assign'),
(51, 'assign', 'view feedback', 'assign', 'name', 'mod_assign'),
(52, 'assign', 'view batch set marking workflow state', 'assign', 'name', 'mod_assign'),
(53, 'assignment', 'view', 'assignment', 'name', 'mod_assignment'),
(54, 'assignment', 'add', 'assignment', 'name', 'mod_assignment'),
(55, 'assignment', 'update', 'assignment', 'name', 'mod_assignment'),
(56, 'assignment', 'view submission', 'assignment', 'name', 'mod_assignment'),
(57, 'assignment', 'upload', 'assignment', 'name', 'mod_assignment'),
(58, 'book', 'add', 'book', 'name', 'mod_book'),
(59, 'book', 'update', 'book', 'name', 'mod_book'),
(60, 'book', 'view', 'book', 'name', 'mod_book'),
(61, 'book', 'add chapter', 'book_chapters', 'title', 'mod_book'),
(62, 'book', 'update chapter', 'book_chapters', 'title', 'mod_book'),
(63, 'book', 'view chapter', 'book_chapters', 'title', 'mod_book'),
(64, 'chat', 'view', 'chat', 'name', 'mod_chat'),
(65, 'chat', 'add', 'chat', 'name', 'mod_chat'),
(66, 'chat', 'update', 'chat', 'name', 'mod_chat'),
(67, 'chat', 'report', 'chat', 'name', 'mod_chat'),
(68, 'chat', 'talk', 'chat', 'name', 'mod_chat'),
(69, 'choice', 'view', 'choice', 'name', 'mod_choice'),
(70, 'choice', 'update', 'choice', 'name', 'mod_choice'),
(71, 'choice', 'add', 'choice', 'name', 'mod_choice'),
(72, 'choice', 'report', 'choice', 'name', 'mod_choice'),
(73, 'choice', 'choose', 'choice', 'name', 'mod_choice'),
(74, 'choice', 'choose again', 'choice', 'name', 'mod_choice'),
(75, 'data', 'view', 'data', 'name', 'mod_data'),
(76, 'data', 'add', 'data', 'name', 'mod_data'),
(77, 'data', 'update', 'data', 'name', 'mod_data'),
(78, 'data', 'record delete', 'data', 'name', 'mod_data'),
(79, 'data', 'fields add', 'data_fields', 'name', 'mod_data'),
(80, 'data', 'fields update', 'data_fields', 'name', 'mod_data'),
(81, 'data', 'templates saved', 'data', 'name', 'mod_data'),
(82, 'data', 'templates def', 'data', 'name', 'mod_data'),
(83, 'feedback', 'startcomplete', 'feedback', 'name', 'mod_feedback'),
(84, 'feedback', 'submit', 'feedback', 'name', 'mod_feedback'),
(85, 'feedback', 'delete', 'feedback', 'name', 'mod_feedback'),
(86, 'feedback', 'view', 'feedback', 'name', 'mod_feedback'),
(87, 'feedback', 'view all', 'course', 'shortname', 'mod_feedback'),
(88, 'folder', 'view', 'folder', 'name', 'mod_folder'),
(89, 'folder', 'view all', 'folder', 'name', 'mod_folder'),
(90, 'folder', 'update', 'folder', 'name', 'mod_folder'),
(91, 'folder', 'add', 'folder', 'name', 'mod_folder'),
(92, 'forum', 'add', 'forum', 'name', 'mod_forum'),
(93, 'forum', 'update', 'forum', 'name', 'mod_forum'),
(94, 'forum', 'add discussion', 'forum_discussions', 'name', 'mod_forum'),
(95, 'forum', 'add post', 'forum_posts', 'subject', 'mod_forum'),
(96, 'forum', 'update post', 'forum_posts', 'subject', 'mod_forum'),
(97, 'forum', 'user report', 'user', 'CONCAT(firstname, '' '', lastname)', 'mod_forum'),
(98, 'forum', 'move discussion', 'forum_discussions', 'name', 'mod_forum'),
(99, 'forum', 'view subscribers', 'forum', 'name', 'mod_forum'),
(100, 'forum', 'view discussion', 'forum_discussions', 'name', 'mod_forum'),
(101, 'forum', 'view forum', 'forum', 'name', 'mod_forum'),
(102, 'forum', 'subscribe', 'forum', 'name', 'mod_forum'),
(103, 'forum', 'unsubscribe', 'forum', 'name', 'mod_forum'),
(104, 'forum', 'pin discussion', 'forum_discussions', 'name', 'mod_forum'),
(105, 'forum', 'unpin discussion', 'forum_discussions', 'name', 'mod_forum'),
(106, 'glossary', 'add', 'glossary', 'name', 'mod_glossary'),
(107, 'glossary', 'update', 'glossary', 'name', 'mod_glossary'),
(108, 'glossary', 'view', 'glossary', 'name', 'mod_glossary'),
(109, 'glossary', 'view all', 'glossary', 'name', 'mod_glossary'),
(110, 'glossary', 'add entry', 'glossary', 'name', 'mod_glossary'),
(111, 'glossary', 'update entry', 'glossary', 'name', 'mod_glossary'),
(112, 'glossary', 'add category', 'glossary', 'name', 'mod_glossary'),
(113, 'glossary', 'update category', 'glossary', 'name', 'mod_glossary'),
(114, 'glossary', 'delete category', 'glossary', 'name', 'mod_glossary'),
(115, 'glossary', 'approve entry', 'glossary', 'name', 'mod_glossary'),
(116, 'glossary', 'disapprove entry', 'glossary', 'name', 'mod_glossary'),
(117, 'glossary', 'view entry', 'glossary_entries', 'concept', 'mod_glossary'),
(118, 'imscp', 'view', 'imscp', 'name', 'mod_imscp'),
(119, 'imscp', 'view all', 'imscp', 'name', 'mod_imscp'),
(120, 'imscp', 'update', 'imscp', 'name', 'mod_imscp'),
(121, 'imscp', 'add', 'imscp', 'name', 'mod_imscp'),
(122, 'label', 'add', 'label', 'name', 'mod_label'),
(123, 'label', 'update', 'label', 'name', 'mod_label'),
(124, 'lesson', 'start', 'lesson', 'name', 'mod_lesson'),
(125, 'lesson', 'end', 'lesson', 'name', 'mod_lesson'),
(126, 'lesson', 'view', 'lesson_pages', 'title', 'mod_lesson'),
(127, 'lti', 'view', 'lti', 'name', 'mod_lti'),
(128, 'lti', 'launch', 'lti', 'name', 'mod_lti'),
(129, 'lti', 'view all', 'lti', 'name', 'mod_lti'),
(130, 'page', 'view', 'page', 'name', 'mod_page'),
(131, 'page', 'view all', 'page', 'name', 'mod_page'),
(132, 'page', 'update', 'page', 'name', 'mod_page'),
(133, 'page', 'add', 'page', 'name', 'mod_page'),
(134, 'quiz', 'add', 'quiz', 'name', 'mod_quiz'),
(135, 'quiz', 'update', 'quiz', 'name', 'mod_quiz'),
(136, 'quiz', 'view', 'quiz', 'name', 'mod_quiz'),
(137, 'quiz', 'report', 'quiz', 'name', 'mod_quiz'),
(138, 'quiz', 'attempt', 'quiz', 'name', 'mod_quiz'),
(139, 'quiz', 'submit', 'quiz', 'name', 'mod_quiz'),
(140, 'quiz', 'review', 'quiz', 'name', 'mod_quiz'),
(141, 'quiz', 'editquestions', 'quiz', 'name', 'mod_quiz'),
(142, 'quiz', 'preview', 'quiz', 'name', 'mod_quiz'),
(143, 'quiz', 'start attempt', 'quiz', 'name', 'mod_quiz'),
(144, 'quiz', 'close attempt', 'quiz', 'name', 'mod_quiz'),
(145, 'quiz', 'continue attempt', 'quiz', 'name', 'mod_quiz'),
(146, 'quiz', 'edit override', 'quiz', 'name', 'mod_quiz'),
(147, 'quiz', 'delete override', 'quiz', 'name', 'mod_quiz'),
(148, 'quiz', 'view summary', 'quiz', 'name', 'mod_quiz'),
(149, 'resource', 'view', 'resource', 'name', 'mod_resource'),
(150, 'resource', 'view all', 'resource', 'name', 'mod_resource'),
(151, 'resource', 'update', 'resource', 'name', 'mod_resource'),
(152, 'resource', 'add', 'resource', 'name', 'mod_resource'),
(153, 'scorm', 'view', 'scorm', 'name', 'mod_scorm'),
(154, 'scorm', 'review', 'scorm', 'name', 'mod_scorm'),
(155, 'scorm', 'update', 'scorm', 'name', 'mod_scorm'),
(156, 'scorm', 'add', 'scorm', 'name', 'mod_scorm'),
(157, 'survey', 'add', 'survey', 'name', 'mod_survey'),
(158, 'survey', 'update', 'survey', 'name', 'mod_survey'),
(159, 'survey', 'download', 'survey', 'name', 'mod_survey'),
(160, 'survey', 'view form', 'survey', 'name', 'mod_survey'),
(161, 'survey', 'view graph', 'survey', 'name', 'mod_survey'),
(162, 'survey', 'view report', 'survey', 'name', 'mod_survey'),
(163, 'survey', 'submit', 'survey', 'name', 'mod_survey'),
(164, 'url', 'view', 'url', 'name', 'mod_url'),
(165, 'url', 'view all', 'url', 'name', 'mod_url'),
(166, 'url', 'update', 'url', 'name', 'mod_url'),
(167, 'url', 'add', 'url', 'name', 'mod_url'),
(168, 'workshop', 'add', 'workshop', 'name', 'mod_workshop'),
(169, 'workshop', 'update', 'workshop', 'name', 'mod_workshop'),
(170, 'workshop', 'view', 'workshop', 'name', 'mod_workshop'),
(171, 'workshop', 'view all', 'workshop', 'name', 'mod_workshop'),
(172, 'workshop', 'add submission', 'workshop_submissions', 'title', 'mod_workshop'),
(173, 'workshop', 'update submission', 'workshop_submissions', 'title', 'mod_workshop'),
(174, 'workshop', 'view submission', 'workshop_submissions', 'title', 'mod_workshop'),
(175, 'workshop', 'add assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(176, 'workshop', 'update assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(177, 'workshop', 'add example', 'workshop_submissions', 'title', 'mod_workshop'),
(178, 'workshop', 'update example', 'workshop_submissions', 'title', 'mod_workshop'),
(179, 'workshop', 'view example', 'workshop_submissions', 'title', 'mod_workshop'),
(180, 'workshop', 'add reference assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(181, 'workshop', 'update reference assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(182, 'workshop', 'add example assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(183, 'workshop', 'update example assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(184, 'workshop', 'update aggregate grades', 'workshop', 'name', 'mod_workshop'),
(185, 'workshop', 'update clear aggregated grades', 'workshop', 'name', 'mod_workshop'),
(186, 'workshop', 'update clear assessments', 'workshop', 'name', 'mod_workshop'),
(187, 'book', 'exportimscp', 'book', 'name', 'booktool_exportimscp'),
(188, 'book', 'print', 'book', 'name', 'booktool_print'),
(189, 'book', 'print chapter', 'book_chapters', 'title', 'booktool_print');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_queries`
--

CREATE TABLE `[[dbprefix]]log_queries` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `qtype` mediumint(5) NOT NULL,
  `sqltext` longtext NOT NULL,
  `sqlparams` longtext,
  `error` mediumint(5) NOT NULL DEFAULT '0',
  `info` longtext,
  `backtrace` longtext,
  `exectime` decimal(10,5) NOT NULL,
  `timelogged` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Logged database queries.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti`
--

CREATE TABLE `[[dbprefix]]lti` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `typeid` bigint(10) DEFAULT NULL,
  `toolurl` longtext NOT NULL,
  `securetoolurl` longtext,
  `instructorchoicesendname` tinyint(1) DEFAULT NULL,
  `instructorchoicesendemailaddr` tinyint(1) DEFAULT NULL,
  `instructorchoiceallowroster` tinyint(1) DEFAULT NULL,
  `instructorchoiceallowsetting` tinyint(1) DEFAULT NULL,
  `instructorcustomparameters` longtext,
  `instructorchoiceacceptgrades` tinyint(1) DEFAULT NULL,
  `grade` bigint(10) NOT NULL DEFAULT '100',
  `launchcontainer` tinyint(2) NOT NULL DEFAULT '1',
  `resourcekey` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `debuglaunch` tinyint(1) NOT NULL DEFAULT '0',
  `showtitlelaunch` tinyint(1) NOT NULL DEFAULT '0',
  `showdescriptionlaunch` tinyint(1) NOT NULL DEFAULT '0',
  `servicesalt` varchar(40) DEFAULT NULL,
  `icon` longtext,
  `secureicon` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lti_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains Basic LTI activities instances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ltiservice_gradebookservices`
--

CREATE TABLE `[[dbprefix]]ltiservice_gradebookservices` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeitemid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `toolproxyid` bigint(10) DEFAULT NULL,
  `typeid` bigint(10) DEFAULT NULL,
  `baseurl` longtext,
  `ltilinkid` bigint(10) DEFAULT NULL,
  `resourceid` varchar(512) DEFAULT NULL,
  `tag` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltisgrad_lti_ix` (`ltilinkid`),
  KEY `[[dbprefix]]ltisgrad_gracou_ix` (`gradeitemid`,`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This file records the grade items created by the LTI Gradebo' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_access_tokens`
--

CREATE TABLE `[[dbprefix]]lti_access_tokens` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `typeid` bigint(10) NOT NULL,
  `scope` longtext NOT NULL,
  `token` varchar(128) NOT NULL DEFAULT '',
  `validuntil` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]ltiaccetoke_tok_uix` (`token`),
  KEY `[[dbprefix]]ltiaccetoke_typ_ix` (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Security tokens for accessing of LTI services' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_submission`
--

CREATE TABLE `[[dbprefix]]lti_submission` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `ltiid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `datesubmitted` bigint(10) NOT NULL,
  `dateupdated` bigint(10) NOT NULL,
  `gradepercent` decimal(10,5) NOT NULL,
  `originalgrade` decimal(10,5) NOT NULL,
  `launchid` bigint(10) NOT NULL,
  `state` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltisubm_lti_ix` (`ltiid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps track of individual submissions for LTI activities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_tool_proxies`
--

CREATE TABLE `[[dbprefix]]lti_tool_proxies` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT 'Tool Provider',
  `regurl` longtext,
  `state` tinyint(2) NOT NULL DEFAULT '1',
  `guid` varchar(255) DEFAULT NULL,
  `secret` varchar(255) DEFAULT NULL,
  `vendorcode` varchar(255) DEFAULT NULL,
  `capabilityoffered` longtext NOT NULL,
  `serviceoffered` longtext NOT NULL,
  `toolproxy` longtext,
  `createdby` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]ltitoolprox_gui_uix` (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='LTI tool proxy registrations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_tool_settings`
--

CREATE TABLE `[[dbprefix]]lti_tool_settings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `toolproxyid` bigint(10) NOT NULL,
  `typeid` bigint(10) DEFAULT NULL,
  `course` bigint(10) DEFAULT NULL,
  `coursemoduleid` bigint(10) DEFAULT NULL,
  `settings` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltitoolsett_too_ix` (`toolproxyid`),
  KEY `[[dbprefix]]ltitoolsett_typ_ix` (`typeid`),
  KEY `[[dbprefix]]ltitoolsett_cou_ix` (`course`),
  KEY `[[dbprefix]]ltitoolsett_cou2_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='LTI tool setting values' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_types`
--

CREATE TABLE `[[dbprefix]]lti_types` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT 'basiclti Activity',
  `baseurl` longtext NOT NULL,
  `tooldomain` varchar(255) NOT NULL DEFAULT '',
  `state` tinyint(2) NOT NULL DEFAULT '2',
  `course` bigint(10) NOT NULL,
  `coursevisible` tinyint(1) NOT NULL DEFAULT '0',
  `ltiversion` varchar(10) NOT NULL DEFAULT '',
  `clientid` varchar(255) DEFAULT NULL,
  `toolproxyid` bigint(10) DEFAULT NULL,
  `enabledcapability` longtext,
  `parameter` longtext,
  `icon` longtext,
  `secureicon` longtext,
  `createdby` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `description` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]ltitype_cli_uix` (`clientid`),
  KEY `[[dbprefix]]ltitype_cou_ix` (`course`),
  KEY `[[dbprefix]]ltitype_too_ix` (`tooldomain`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Basic LTI pre-configured activities' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_types_config`
--

CREATE TABLE `[[dbprefix]]lti_types_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `typeid` bigint(10) NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltitypeconf_typ_ix` (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Basic LTI types configuration' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message`
--

CREATE TABLE `[[dbprefix]]message` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) NOT NULL DEFAULT '0',
  `useridto` bigint(10) NOT NULL DEFAULT '0',
  `subject` longtext,
  `fullmessage` longtext,
  `fullmessageformat` smallint(4) DEFAULT '0',
  `fullmessagehtml` longtext,
  `smallmessage` longtext,
  `notification` tinyint(1) DEFAULT '0',
  `contexturl` longtext,
  `contexturlname` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timeuserfromdeleted` bigint(10) NOT NULL DEFAULT '0',
  `timeusertodeleted` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) DEFAULT NULL,
  `eventtype` varchar(100) DEFAULT NULL,
  `customdata` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mess_useusetimtim_ix` (`useridfrom`,`useridto`,`timeuserfromdeleted`,`timeusertodeleted`),
  KEY `[[dbprefix]]mess_usetimnot_ix` (`useridfrom`,`timeuserfromdeleted`,`notification`),
  KEY `[[dbprefix]]mess_usetimnot2_ix` (`useridto`,`timeusertodeleted`,`notification`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all unread messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messageinbound_datakeys`
--

CREATE TABLE `[[dbprefix]]messageinbound_datakeys` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `handler` bigint(10) NOT NULL,
  `datavalue` bigint(10) NOT NULL,
  `datakey` varchar(64) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `expires` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messdata_handat_uix` (`handler`,`datavalue`),
  KEY `[[dbprefix]]messdata_han_ix` (`handler`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Inbound Message data item secret keys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messageinbound_handlers`
--

CREATE TABLE `[[dbprefix]]messageinbound_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(100) NOT NULL DEFAULT '',
  `classname` varchar(255) NOT NULL DEFAULT '',
  `defaultexpiration` bigint(10) NOT NULL DEFAULT '86400',
  `validateaddress` tinyint(1) NOT NULL DEFAULT '1',
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messhand_cla_uix` (`classname`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Inbound Message Handler definitions.' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]messageinbound_handlers`
--

INSERT INTO `[[dbprefix]]messageinbound_handlers` VALUES
(1, 'core', '\\core\\message\\inbound\\private_files_handler', 0, 1, 0),
(2, 'mod_forum', '\\mod_forum\\message\\inbound\\reply_handler', 604800, 1, 0),
(3, 'tool_messageinbound', '\\tool_messageinbound\\message\\inbound\\invalid_recipient_handler', 604800, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messageinbound_messagelist`
--

CREATE TABLE `[[dbprefix]]messageinbound_messagelist` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `messageid` longtext NOT NULL,
  `userid` bigint(10) NOT NULL,
  `address` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messmess_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A list of message IDs for existing replies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) NOT NULL,
  `conversationid` bigint(10) NOT NULL,
  `subject` longtext,
  `fullmessage` longtext,
  `fullmessageformat` tinyint(1) NOT NULL DEFAULT '0',
  `fullmessagehtml` longtext,
  `smallmessage` longtext,
  `timecreated` bigint(10) NOT NULL,
  `fullmessagetrust` tinyint(2) NOT NULL DEFAULT '0',
  `customdata` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mess_contim_ix` (`conversationid`,`timecreated`),
  KEY `[[dbprefix]]mess_use_ix` (`useridfrom`),
  KEY `[[dbprefix]]mess_con_ix` (`conversationid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_airnotifier_devices`
--

CREATE TABLE `[[dbprefix]]message_airnotifier_devices` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userdeviceid` bigint(10) NOT NULL,
  `enable` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messairndevi_use_uix` (`userdeviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store information about the devices registered in Airnotifie' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_contacts`
--

CREATE TABLE `[[dbprefix]]message_contacts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `contactid` bigint(10) NOT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messcont_usecon_uix` (`userid`,`contactid`),
  KEY `[[dbprefix]]messcont_use_ix` (`userid`),
  KEY `[[dbprefix]]messcont_con_ix` (`contactid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Maintains lists of contacts between users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_contact_requests`
--

CREATE TABLE `[[dbprefix]]message_contact_requests` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `requesteduserid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messcontrequ_usereq_uix` (`userid`,`requesteduserid`),
  KEY `[[dbprefix]]messcontrequ_use_ix` (`userid`),
  KEY `[[dbprefix]]messcontrequ_req_ix` (`requesteduserid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Maintains list of contact requests between users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_conversations`
--

CREATE TABLE `[[dbprefix]]message_conversations` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` bigint(10) NOT NULL DEFAULT '1',
  `name` varchar(255) DEFAULT NULL,
  `convhash` varchar(40) DEFAULT NULL,
  `component` varchar(100) DEFAULT NULL,
  `itemtype` varchar(100) DEFAULT NULL,
  `itemid` bigint(10) DEFAULT NULL,
  `contextid` bigint(10) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messconv_typ_ix` (`type`),
  KEY `[[dbprefix]]messconv_con_ix` (`convhash`),
  KEY `[[dbprefix]]messconv_comiteiteco_ix` (`component`,`itemtype`,`itemid`,`contextid`),
  KEY `[[dbprefix]]messconv_con2_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all message conversations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_conversation_actions`
--

CREATE TABLE `[[dbprefix]]message_conversation_actions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `conversationid` bigint(10) NOT NULL,
  `action` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messconvacti_use_ix` (`userid`),
  KEY `[[dbprefix]]messconvacti_con_ix` (`conversationid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all per-user actions on individual conversations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_conversation_members`
--

CREATE TABLE `[[dbprefix]]message_conversation_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `conversationid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messconvmemb_con_ix` (`conversationid`),
  KEY `[[dbprefix]]messconvmemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all members in a conversations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_email_messages`
--

CREATE TABLE `[[dbprefix]]message_email_messages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `useridto` bigint(10) NOT NULL,
  `conversationid` bigint(10) NOT NULL,
  `messageid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messemaimess_use_ix` (`useridto`),
  KEY `[[dbprefix]]messemaimess_con_ix` (`conversationid`),
  KEY `[[dbprefix]]messemaimess_mes_ix` (`messageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps track of what emails to send in an email digest' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_popup`
--

CREATE TABLE `[[dbprefix]]message_popup` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `messageid` bigint(10) NOT NULL,
  `isread` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messpopu_mesisr_uix` (`messageid`,`isread`),
  KEY `[[dbprefix]]messpopu_isr_ix` (`isread`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keep state of notifications for the popup message processor' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_popup_notifications`
--

CREATE TABLE `[[dbprefix]]message_popup_notifications` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `notificationid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messpopunoti_not_ix` (`notificationid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of notifications to display in the message output popup' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_processors`
--

CREATE TABLE `[[dbprefix]]message_processors` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(166) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of message output plugins' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]message_processors`
--

INSERT INTO `[[dbprefix]]message_processors` VALUES
(1, 'airnotifier', 1),
(2, 'email', 1),
(3, 'jabber', 1),
(4, 'popup', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_providers`
--

CREATE TABLE `[[dbprefix]]message_providers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `component` varchar(200) NOT NULL DEFAULT '',
  `capability` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messprov_comnam_uix` (`component`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores the message providers (modules and core sy' AUTO_INCREMENT=41 ;

--
-- Dumping data for table `[[dbprefix]]message_providers`
--

INSERT INTO `[[dbprefix]]message_providers` VALUES
(1, 'notices', 'moodle', 'moodle/site:config'),
(2, 'errors', 'moodle', 'moodle/site:config'),
(3, 'availableupdate', 'moodle', 'moodle/site:config'),
(4, 'instantmessage', 'moodle', NULL),
(5, 'backup', 'moodle', 'moodle/site:config'),
(6, 'courserequested', 'moodle', 'moodle/site:approvecourse'),
(7, 'courserequestapproved', 'moodle', 'moodle/course:request'),
(8, 'courserequestrejected', 'moodle', 'moodle/course:request'),
(9, 'coursecompleted', 'moodle', NULL),
(10, 'badgerecipientnotice', 'moodle', 'moodle/badges:earnbadge'),
(11, 'badgecreatornotice', 'moodle', NULL),
(12, 'competencyplancomment', 'moodle', NULL),
(13, 'competencyusercompcomment', 'moodle', NULL),
(14, 'insights', 'moodle', NULL),
(15, 'messagecontactrequests', 'moodle', NULL),
(16, 'asyncbackupnotification', 'moodle', NULL),
(17, 'gradenotifications', 'moodle', NULL),
(18, 'infected', 'moodle', 'moodle/site:config'),
(19, 'assign_notification', 'mod_assign', NULL),
(20, 'assignment_updates', 'mod_assignment', NULL),
(21, 'submission', 'mod_feedback', NULL),
(22, 'message', 'mod_feedback', NULL),
(23, 'posts', 'mod_forum', NULL),
(24, 'digests', 'mod_forum', NULL),
(25, 'graded_essay', 'mod_lesson', NULL),
(26, 'submission', 'mod_quiz', 'mod/quiz:emailnotifysubmission'),
(27, 'confirmation', 'mod_quiz', 'mod/quiz:emailconfirmsubmission'),
(28, 'attempt_overdue', 'mod_quiz', 'mod/quiz:emailwarnoverdue'),
(29, 'flatfile_enrolment', 'enrol_flatfile', NULL),
(30, 'imsenterprise_enrolment', 'enrol_imsenterprise', NULL),
(31, 'expiry_notification', 'enrol_manual', NULL),
(32, 'paypal_enrolment', 'enrol_paypal', NULL),
(33, 'expiry_notification', 'enrol_self', NULL),
(34, 'contactdataprotectionofficer', 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests'),
(35, 'datarequestprocessingresults', 'tool_dataprivacy', NULL),
(36, 'notifyexceptions', 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests'),
(37, 'invalidrecipienthandler', 'tool_messageinbound', NULL),
(38, 'messageprocessingerror', 'tool_messageinbound', NULL),
(39, 'messageprocessingsuccess', 'tool_messageinbound', NULL),
(40, 'notification', 'tool_monitor', 'tool/monitor:subscribe');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_read`
--

CREATE TABLE `[[dbprefix]]message_read` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) NOT NULL DEFAULT '0',
  `useridto` bigint(10) NOT NULL DEFAULT '0',
  `subject` longtext,
  `fullmessage` longtext,
  `fullmessageformat` smallint(4) DEFAULT '0',
  `fullmessagehtml` longtext,
  `smallmessage` longtext,
  `notification` tinyint(1) DEFAULT '0',
  `contexturl` longtext,
  `contexturlname` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timeread` bigint(10) NOT NULL DEFAULT '0',
  `timeuserfromdeleted` bigint(10) NOT NULL DEFAULT '0',
  `timeusertodeleted` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) DEFAULT NULL,
  `eventtype` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messread_useusetimti_ix` (`useridfrom`,`useridto`,`timeuserfromdeleted`,`timeusertodeleted`),
  KEY `[[dbprefix]]messread_nottim_ix` (`notification`,`timeread`),
  KEY `[[dbprefix]]messread_usetimnot_ix` (`useridfrom`,`timeuserfromdeleted`,`notification`),
  KEY `[[dbprefix]]messread_usetimnot2_ix` (`useridto`,`timeusertodeleted`,`notification`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all messages that have been read' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_users_blocked`
--

CREATE TABLE `[[dbprefix]]message_users_blocked` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `blockeduserid` bigint(10) NOT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messuserbloc_useblo_uix` (`userid`,`blockeduserid`),
  KEY `[[dbprefix]]messuserbloc_use_ix` (`userid`),
  KEY `[[dbprefix]]messuserbloc_blo_ix` (`blockeduserid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Maintains lists of blocked users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_user_actions`
--

CREATE TABLE `[[dbprefix]]message_user_actions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `messageid` bigint(10) NOT NULL,
  `action` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messuseracti_usemes_uix` (`userid`,`messageid`,`action`),
  KEY `[[dbprefix]]messuseracti_use_ix` (`userid`),
  KEY `[[dbprefix]]messuseracti_mes_ix` (`messageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all per-user actions on individual messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnetservice_enrol_courses`
--

CREATE TABLE `[[dbprefix]]mnetservice_enrol_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) NOT NULL,
  `remoteid` bigint(10) NOT NULL,
  `categoryid` bigint(10) NOT NULL,
  `categoryname` varchar(255) NOT NULL DEFAULT '',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `fullname` varchar(254) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `summary` longtext NOT NULL,
  `summaryformat` smallint(3) DEFAULT '0',
  `startdate` bigint(10) NOT NULL,
  `roleid` bigint(10) NOT NULL,
  `rolename` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetenrocour_hosrem_uix` (`hostid`,`remoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Caches the information fetched via XML-RPC about courses on ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnetservice_enrol_enrolments`
--

CREATE TABLE `[[dbprefix]]mnetservice_enrol_enrolments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `remotecourseid` bigint(10) NOT NULL,
  `rolename` varchar(255) NOT NULL DEFAULT '',
  `enroltime` bigint(10) NOT NULL DEFAULT '0',
  `enroltype` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetenroenro_use_ix` (`userid`),
  KEY `[[dbprefix]]mnetenroenro_hos_ix` (`hostid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Caches the information about enrolments of our local users i' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_application`
--

CREATE TABLE `[[dbprefix]]mnet_application` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `display_name` varchar(50) NOT NULL DEFAULT '',
  `xmlrpc_server_url` varchar(255) NOT NULL DEFAULT '',
  `sso_land_url` varchar(255) NOT NULL DEFAULT '',
  `sso_jump_url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about applications on remote hosts' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]mnet_application`
--

INSERT INTO `[[dbprefix]]mnet_application` VALUES
(1, 'moodle', 'Moodle', '/mnet/xmlrpc/server.php', '/auth/mnet/land.php', '/auth/mnet/jump.php'),
(2, 'mahara', 'Mahara', '/api/xmlrpc/server.php', '/auth/xmlrpc/land.php', '/auth/xmlrpc/jump.php');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_host`
--

CREATE TABLE `[[dbprefix]]mnet_host` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `wwwroot` varchar(255) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `name` varchar(80) NOT NULL DEFAULT '',
  `public_key` longtext NOT NULL,
  `public_key_expires` bigint(10) NOT NULL DEFAULT '0',
  `transport` tinyint(2) NOT NULL DEFAULT '0',
  `portno` mediumint(5) NOT NULL DEFAULT '0',
  `last_connect_time` bigint(10) NOT NULL DEFAULT '0',
  `last_log_id` bigint(10) NOT NULL DEFAULT '0',
  `force_theme` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(100) DEFAULT NULL,
  `applicationid` bigint(10) NOT NULL DEFAULT '1',
  `sslverification` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnethost_app_ix` (`applicationid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about the local and remote hosts for RPC' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]mnet_host`
--

INSERT INTO `[[dbprefix]]mnet_host` VALUES
(1, 0, '[[softurl]]', '[[serverip]]', '', '', 0, 0, 0, 0, 0, 0, NULL, 1, 0),
(2, 0, '', '', 'All Hosts', '', 0, 0, 0, 0, 0, 0, NULL, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_host2service`
--

CREATE TABLE `[[dbprefix]]mnet_host2service` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) NOT NULL DEFAULT '0',
  `serviceid` bigint(10) NOT NULL DEFAULT '0',
  `publish` tinyint(1) NOT NULL DEFAULT '0',
  `subscribe` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnethost_hosser_uix` (`hostid`,`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about the services for a given host' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_log`
--

CREATE TABLE `[[dbprefix]]mnet_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) NOT NULL DEFAULT '0',
  `remoteid` bigint(10) NOT NULL DEFAULT '0',
  `time` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `coursename` varchar(40) NOT NULL DEFAULT '',
  `module` varchar(20) NOT NULL DEFAULT '',
  `cmid` bigint(10) NOT NULL DEFAULT '0',
  `action` varchar(40) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `info` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetlog_hosusecou_ix` (`hostid`,`userid`,`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store session data from users migrating to other sites' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_remote_rpc`
--

CREATE TABLE `[[dbprefix]]mnet_remote_rpc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `functionname` varchar(40) NOT NULL DEFAULT '',
  `xmlrpcpath` varchar(80) NOT NULL DEFAULT '',
  `plugintype` varchar(20) NOT NULL DEFAULT '',
  `pluginname` varchar(20) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table describes functions that might be called remotely' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]mnet_remote_rpc`
--

INSERT INTO `[[dbprefix]]mnet_remote_rpc` VALUES
(1, 'user_authorise', 'auth/mnet/auth.php/user_authorise', 'auth', 'mnet', 1),
(2, 'keepalive_server', 'auth/mnet/auth.php/keepalive_server', 'auth', 'mnet', 1),
(3, 'kill_children', 'auth/mnet/auth.php/kill_children', 'auth', 'mnet', 1),
(4, 'refresh_log', 'auth/mnet/auth.php/refresh_log', 'auth', 'mnet', 1),
(5, 'fetch_user_image', 'auth/mnet/auth.php/fetch_user_image', 'auth', 'mnet', 1),
(6, 'fetch_theme_info', 'auth/mnet/auth.php/fetch_theme_info', 'auth', 'mnet', 1),
(7, 'update_enrolments', 'auth/mnet/auth.php/update_enrolments', 'auth', 'mnet', 1),
(8, 'keepalive_client', 'auth/mnet/auth.php/keepalive_client', 'auth', 'mnet', 1),
(9, 'kill_child', 'auth/mnet/auth.php/kill_child', 'auth', 'mnet', 1),
(10, 'available_courses', 'enrol/mnet/enrol.php/available_courses', 'enrol', 'mnet', 1),
(11, 'user_enrolments', 'enrol/mnet/enrol.php/user_enrolments', 'enrol', 'mnet', 1),
(12, 'enrol_user', 'enrol/mnet/enrol.php/enrol_user', 'enrol', 'mnet', 1),
(13, 'unenrol_user', 'enrol/mnet/enrol.php/unenrol_user', 'enrol', 'mnet', 1),
(14, 'course_enrolments', 'enrol/mnet/enrol.php/course_enrolments', 'enrol', 'mnet', 1),
(15, 'send_content_intent', 'portfolio/mahara/lib.php/send_content_intent', 'portfolio', 'mahara', 1),
(16, 'send_content_ready', 'portfolio/mahara/lib.php/send_content_ready', 'portfolio', 'mahara', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_remote_service2rpc`
--

CREATE TABLE `[[dbprefix]]mnet_remote_service2rpc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `serviceid` bigint(10) NOT NULL DEFAULT '0',
  `rpcid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetremoserv_rpcser_uix` (`rpcid`,`serviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Group functions or methods under a service' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]mnet_remote_service2rpc`
--

INSERT INTO `[[dbprefix]]mnet_remote_service2rpc` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 2, 8),
(9, 2, 9),
(10, 3, 10),
(11, 3, 11),
(12, 3, 12),
(13, 3, 13),
(14, 3, 14),
(15, 4, 15),
(16, 4, 16);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_rpc`
--

CREATE TABLE `[[dbprefix]]mnet_rpc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `functionname` varchar(40) NOT NULL DEFAULT '',
  `xmlrpcpath` varchar(80) NOT NULL DEFAULT '',
  `plugintype` varchar(20) NOT NULL DEFAULT '',
  `pluginname` varchar(20) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `help` longtext NOT NULL,
  `profile` longtext NOT NULL,
  `filename` varchar(100) NOT NULL DEFAULT '',
  `classname` varchar(150) DEFAULT NULL,
  `static` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetrpc_enaxml_ix` (`enabled`,`xmlrpcpath`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Functions or methods that we may publish or subscribe to' AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]mnet_rpc`
--

INSERT INTO `[[dbprefix]]mnet_rpc` VALUES
(1, 'user_authorise', 'auth/mnet/auth.php/user_authorise', 'auth', 'mnet', 1, 'Return user data for the provided token, compare with user_agent string.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:5:"token";s:4:"type";s:6:"string";s:11:"description";s:37:"The unique ID provided by remotehost.";}i:1;a:3:{s:4:"name";s:9:"useragent";s:4:"type";s:6:"string";s:11:"description";s:18:"User Agent string.";}}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:44:"$userdata Array of user info for remote host";}}', 'auth.php', 'auth_plugin_mnet', 0),
(2, 'keepalive_server', 'auth/mnet/auth.php/keepalive_server', 'auth', 'mnet', 1, 'Receives an array of usernames from a remote machine and prods their\nsessions to keep them alive', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:5:"array";s:4:"type";s:5:"array";s:11:"description";s:21:"An array of usernames";}}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:28:""All ok" or an error message";}}', 'auth.php', 'auth_plugin_mnet', 0),
(3, 'kill_children', 'auth/mnet/auth.php/kill_children', 'auth', 'mnet', 1, 'The IdP uses this function to kill child sessions on other hosts', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:28:"Username for session to kill";}i:1;a:3:{s:4:"name";s:9:"useragent";s:4:"type";s:6:"string";s:11:"description";s:35:"SHA1 hash of user agent to look for";}}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:39:"A plaintext report of what has happened";}}', 'auth.php', 'auth_plugin_mnet', 0),
(4, 'refresh_log', 'auth/mnet/auth.php/refresh_log', 'auth', 'mnet', 1, 'Receives an array of log entries from an SP and adds them to the mnet_log\ntable', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:5:"array";s:4:"type";s:5:"array";s:11:"description";s:21:"An array of usernames";}}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:28:""All ok" or an error message";}}', 'auth.php', 'auth_plugin_mnet', 0),
(5, 'fetch_user_image', 'auth/mnet/auth.php/fetch_user_image', 'auth', 'mnet', 1, 'Returns the user''s profile image info\nIf the user exists and has a profile picture, the returned array will contain keys:\nf1          - the content of the default 100x100px image\nf1_mimetype - the mimetype of the f1 file\nf2          - the content of the 35x35px variant of the image\nf2_mimetype - the mimetype of the f2 file\nThe mimetype information was added in Moodle 2.0. In Moodle 1.x, images are always jpegs.', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:3:"int";s:11:"description";s:18:"The id of the user";}}s:6:"return";a:2:{s:4:"type";s:11:"false|array";s:11:"description";s:84:"false if user not found, empty array if no picture exists, array with data otherwise";}}', 'auth.php', 'auth_plugin_mnet', 0),
(6, 'fetch_theme_info', 'auth/mnet/auth.php/fetch_theme_info', 'auth', 'mnet', 1, 'Returns the theme information and logo url as strings.', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:14:"The theme info";}}', 'auth.php', 'auth_plugin_mnet', 0),
(7, 'update_enrolments', 'auth/mnet/auth.php/update_enrolments', 'auth', 'mnet', 1, 'Invoke this function _on_ the IDP to update it with enrolment info local to\nthe SP right after calling user_authorise()\nNormally called by the SP after calling user_authorise()', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:12:"The username";}i:1;a:3:{s:4:"name";s:7:"courses";s:4:"type";s:5:"array";s:11:"description";s:75:"Assoc array of courses following the structure of mnetservice_enrol_courses";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:0:"";}}', 'auth.php', 'auth_plugin_mnet', 0),
(8, 'keepalive_client', 'auth/mnet/auth.php/keepalive_client', 'auth', 'mnet', 1, 'Poll the IdP server to let it know that a user it has authenticated is still\nonline', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:4:"void";s:11:"description";s:0:"";}}', 'auth.php', 'auth_plugin_mnet', 0),
(9, 'kill_child', 'auth/mnet/auth.php/kill_child', 'auth', 'mnet', 1, 'When the IdP requests that child sessions are terminated,\nthis function will be called on each of the child hosts. The machine that\ncalls the function (over xmlrpc) provides us with the mnethostid we need.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:28:"Username for session to kill";}i:1;a:3:{s:4:"name";s:9:"useragent";s:4:"type";s:6:"string";s:11:"description";s:35:"SHA1 hash of user agent to look for";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:15:"True on success";}}', 'auth.php', 'auth_plugin_mnet', 0),
(10, 'available_courses', 'enrol/mnet/enrol.php/available_courses', 'enrol', 'mnet', 1, 'Returns list of courses that we offer to the caller for remote enrolment of their users\nSince Moodle 2.0, courses are made available for MNet peers by creating an instance\nof enrol_mnet plugin for the course. Hidden courses are not returned. If there are two\ninstances - one specific for the host and one for ''All hosts'', the setting of the specific\none is used. The id of the peer is kept in customint1, no other custom fields are used.', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:0:"";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(11, 'user_enrolments', 'enrol/mnet/enrol.php/user_enrolments', 'enrol', 'mnet', 1, 'This method has never been implemented in Moodle MNet API', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:11:"empty array";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(12, 'enrol_user', 'enrol/mnet/enrol.php/enrol_user', 'enrol', 'mnet', 1, 'Enrol remote user to our course\nIf we do not have local record for the remote user in our database,\nit gets created here.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"userdata";s:4:"type";s:5:"array";s:11:"description";s:43:"user details {@see mnet_fields_to_import()}";}i:1;a:3:{s:4:"name";s:8:"courseid";s:4:"type";s:3:"int";s:11:"description";s:19:"our local course id";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:69:"true if the enrolment has been successful, throws exception otherwise";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(13, 'unenrol_user', 'enrol/mnet/enrol.php/unenrol_user', 'enrol', 'mnet', 1, 'Unenrol remote user from our course\nOnly users enrolled via enrol_mnet plugin can be unenrolled remotely. If the\nremote user is enrolled into the local course via some other enrol plugin\n(enrol_manual for example), the remote host can''t touch such enrolment. Please\ndo not report this behaviour as bug, it is a feature ;-)', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:18:"of the remote user";}i:1;a:3:{s:4:"name";s:8:"courseid";s:4:"type";s:3:"int";s:11:"description";s:19:"of our local course";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:71:"true if the unenrolment has been successful, throws exception otherwise";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(14, 'course_enrolments', 'enrol/mnet/enrol.php/course_enrolments', 'enrol', 'mnet', 1, 'Returns a list of users from the client server who are enrolled in our course\nSuitable instance of enrol_mnet must be created in the course. This method will not\nreturn any information about the enrolments in courses that are not available for\nremote enrolment, even if their users are enrolled into them via other plugin\n(note the difference from {@link self::user_enrolments()}).\nThis method will return enrolment information for users from hosts regardless\nthe enrolment plugin. It does not matter if the user was enrolled remotely by\ntheir admin or locally. Once the course is available for remote enrolments, we\nwill tell them everything about their users.\nIn Moodle 1.x the returned array used to be indexed by username. The side effect\nof MDL-19219 fix is that we do not need to use such index and therefore we can\nreturn all enrolment records. MNet clients 1.x will only use the last record for\nthe student, if she is enrolled via multiple plugins.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"courseid";s:4:"type";s:3:"int";s:11:"description";s:16:"ID of our course";}i:1;a:3:{s:4:"name";s:5:"roles";s:4:"type";s:12:"string|array";s:11:"description";s:58:"comma separated list of role shortnames (or array of them)";}}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:0:"";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(15, 'fetch_file', 'portfolio/mahara/lib.php/fetch_file', 'portfolio', 'mahara', 1, 'xmlrpc (mnet) function to get the file.\nreads in the file and returns it base_64 encoded\nso that it can be enrypted by mnet.', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:5:"token";s:4:"type";s:6:"string";s:11:"description";s:56:"the token recieved previously during send_content_intent";}}s:6:"return";a:2:{s:4:"type";s:4:"void";s:11:"description";s:0:"";}}', 'lib.php', 'portfolio_plugin_mahara', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_service`
--

CREATE TABLE `[[dbprefix]]mnet_service` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` varchar(40) NOT NULL DEFAULT '',
  `apiversion` varchar(10) NOT NULL DEFAULT '',
  `offer` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A service is a group of functions' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]mnet_service`
--

INSERT INTO `[[dbprefix]]mnet_service` VALUES
(1, 'sso_idp', '', '1', 1),
(2, 'sso_sp', '', '1', 1),
(3, 'mnet_enrol', '', '1', 1),
(4, 'pf', '', '1', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_service2rpc`
--

CREATE TABLE `[[dbprefix]]mnet_service2rpc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `serviceid` bigint(10) NOT NULL DEFAULT '0',
  `rpcid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetserv_rpcser_uix` (`rpcid`,`serviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Group functions or methods under a service' AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]mnet_service2rpc`
--

INSERT INTO `[[dbprefix]]mnet_service2rpc` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 2, 8),
(9, 2, 9),
(10, 3, 10),
(11, 3, 11),
(12, 3, 12),
(13, 3, 13),
(14, 3, 14),
(15, 4, 15);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_session`
--

CREATE TABLE `[[dbprefix]]mnet_session` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `username` varchar(100) NOT NULL DEFAULT '',
  `token` varchar(40) NOT NULL DEFAULT '',
  `mnethostid` bigint(10) NOT NULL DEFAULT '0',
  `useragent` varchar(40) NOT NULL DEFAULT '',
  `confirm_timeout` bigint(10) NOT NULL DEFAULT '0',
  `session_id` varchar(40) NOT NULL DEFAULT '',
  `expires` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetsess_tok_uix` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store session data from users migrating to other sites' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_sso_access_control`
--

CREATE TABLE `[[dbprefix]]mnet_sso_access_control` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL DEFAULT '',
  `mnet_host_id` bigint(10) NOT NULL DEFAULT '0',
  `accessctrl` varchar(20) NOT NULL DEFAULT 'allow',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetssoaccecont_mne_uix` (`mnet_host_id`,`username`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Users by host permitted (or not) to login from a remote prov' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `cron` bigint(10) NOT NULL DEFAULT '0',
  `lastcron` bigint(10) NOT NULL DEFAULT '0',
  `search` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]modu_nam_ix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='modules available in the site' AUTO_INCREMENT=24 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
(1, 'assign', 0, 0, '', 1),
(2, 'assignment', 60, 0, '', 0),
(3, 'book', 0, 0, '', 1),
(4, 'chat', 0, 0, '', 1),
(5, 'choice', 0, 0, '', 1),
(6, 'data', 0, 0, '', 1),
(7, 'feedback', 0, 0, '', 1),
(8, 'folder', 0, 0, '', 1),
(9, 'forum', 0, 0, '', 1),
(10, 'glossary', 0, 0, '', 1),
(11, 'h5pactivity', 0, 0, '', 1),
(12, 'imscp', 0, 0, '', 1),
(13, 'label', 0, 0, '', 1),
(14, 'lesson', 0, 0, '', 1),
(15, 'lti', 0, 0, '', 1),
(16, 'page', 0, 0, '', 1),
(17, 'quiz', 0, 0, '', 1),
(18, 'resource', 0, 0, '', 1),
(19, 'scorm', 0, 0, '', 1),
(20, 'survey', 0, 0, '', 1),
(21, 'url', 0, 0, '', 1),
(22, 'wiki', 0, 0, '', 1),
(23, 'workshop', 0, 0, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]my_pages`
--

CREATE TABLE `[[dbprefix]]my_pages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) DEFAULT '0',
  `name` varchar(200) NOT NULL DEFAULT '',
  `private` tinyint(1) NOT NULL DEFAULT '1',
  `sortorder` mediumint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mypage_usepri_ix` (`userid`,`private`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Extra user pages for the My Moodle system' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]my_pages`
--

INSERT INTO `[[dbprefix]]my_pages` VALUES
(1, NULL, '__default', 0, 0),
(2, NULL, '__default', 1, 0),
(3, 2, '__default', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) NOT NULL,
  `useridto` bigint(10) NOT NULL,
  `subject` longtext,
  `fullmessage` longtext,
  `fullmessageformat` tinyint(1) NOT NULL DEFAULT '0',
  `fullmessagehtml` longtext,
  `smallmessage` longtext,
  `component` varchar(100) DEFAULT NULL,
  `eventtype` varchar(100) DEFAULT NULL,
  `contexturl` longtext,
  `contexturlname` longtext,
  `timeread` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `customdata` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]noti_use_ix` (`useridfrom`),
  KEY `[[dbprefix]]noti_use2_ix` (`useridto`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all notifications' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_access_token`
--

CREATE TABLE `[[dbprefix]]oauth2_access_token` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `token` longtext NOT NULL,
  `expires` bigint(10) NOT NULL,
  `scope` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautaccetoke_iss_uix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores access tokens for system accounts in order to be able' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_endpoint`
--

CREATE TABLE `[[dbprefix]]oauth2_endpoint` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `url` longtext NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]oautendp_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Describes the named endpoint for an oauth2 service.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_issuer`
--

CREATE TABLE `[[dbprefix]]oauth2_issuer` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `image` longtext NOT NULL,
  `baseurl` longtext NOT NULL,
  `clientid` longtext NOT NULL,
  `clientsecret` longtext NOT NULL,
  `loginscopes` longtext NOT NULL,
  `loginscopesoffline` longtext NOT NULL,
  `loginparams` longtext NOT NULL,
  `loginparamsoffline` longtext NOT NULL,
  `alloweddomains` longtext NOT NULL,
  `scopessupported` longtext,
  `enabled` tinyint(2) NOT NULL DEFAULT '1',
  `showonloginpage` tinyint(2) NOT NULL DEFAULT '1',
  `basicauth` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL,
  `requireconfirmation` tinyint(2) NOT NULL DEFAULT '1',
  `servicetype` varchar(255) DEFAULT NULL,
  `loginpagename` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Details for an oauth 2 connect identity issuer.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_refresh_token`
--

CREATE TABLE `[[dbprefix]]oauth2_refresh_token` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `token` longtext NOT NULL,
  `scopehash` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautrefrtoke_useiss_uix` (`userid`,`issuerid`,`scopehash`),
  KEY `[[dbprefix]]oautrefrtoke_iss_ix` (`issuerid`),
  KEY `[[dbprefix]]oautrefrtoke_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores refresh tokens which can be exchanged for access toke' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_system_account`
--

CREATE TABLE `[[dbprefix]]oauth2_system_account` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `refreshtoken` longtext NOT NULL,
  `grantedscopes` longtext NOT NULL,
  `email` longtext,
  `username` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautsystacco_iss_uix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stored details used to get an access token as a system user ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_user_field_mapping`
--

CREATE TABLE `[[dbprefix]]oauth2_user_field_mapping` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timemodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `externalfield` varchar(500) NOT NULL DEFAULT '',
  `internalfield` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautuserfielmapp_is_uix` (`issuerid`,`internalfield`),
  KEY `[[dbprefix]]oautuserfielmapp_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Mapping of oauth user fields to moodle fields.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page`
--

CREATE TABLE `[[dbprefix]]page` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `content` longtext,
  `contentformat` smallint(4) NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) NOT NULL DEFAULT '0',
  `legacyfileslast` bigint(10) DEFAULT NULL,
  `display` smallint(4) NOT NULL DEFAULT '0',
  `displayoptions` longtext,
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]page_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each record is one page and its config data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]paygw_paypal`
--

CREATE TABLE `[[dbprefix]]paygw_paypal` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `paymentid` bigint(10) NOT NULL,
  `pp_orderid` varchar(255) NOT NULL DEFAULT 'The ID of the order in PayPal',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]paygpayp_pay_uix` (`paymentid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores PayPal related information' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payments`
--

CREATE TABLE `[[dbprefix]]payments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(100) NOT NULL DEFAULT '',
  `paymentarea` varchar(50) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `amount` varchar(20) NOT NULL DEFAULT '',
  `currency` varchar(3) NOT NULL DEFAULT '',
  `accountid` bigint(10) NOT NULL,
  `gateway` varchar(100) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]paym_gat_ix` (`gateway`),
  KEY `[[dbprefix]]paym_compayite_ix` (`component`,`paymentarea`,`itemid`),
  KEY `[[dbprefix]]paym_use_ix` (`userid`),
  KEY `[[dbprefix]]paym_acc_ix` (`accountid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores information about payments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_accounts`
--

CREATE TABLE `[[dbprefix]]payment_accounts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `idnumber` varchar(100) DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Payment accounts' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_gateways`
--

CREATE TABLE `[[dbprefix]]payment_gateways` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `accountid` bigint(10) NOT NULL,
  `gateway` varchar(100) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `config` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]paymgate_acc_ix` (`accountid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Configuration for one gateway for one payment account' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance`
--

CREATE TABLE `[[dbprefix]]portfolio_instance` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `plugin` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='base table (not including config data) for instances of port' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance_config`
--

CREATE TABLE `[[dbprefix]]portfolio_instance_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instance` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portinstconf_nam_ix` (`name`),
  KEY `[[dbprefix]]portinstconf_ins_ix` (`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='config for portfolio plugin instances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance_user`
--

CREATE TABLE `[[dbprefix]]portfolio_instance_user` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instance` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portinstuser_ins_ix` (`instance`),
  KEY `[[dbprefix]]portinstuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='user data for portfolio instances.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_log`
--

CREATE TABLE `[[dbprefix]]portfolio_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `time` bigint(10) NOT NULL,
  `portfolio` bigint(10) NOT NULL,
  `caller_class` varchar(150) NOT NULL DEFAULT '',
  `caller_file` varchar(255) NOT NULL DEFAULT '',
  `caller_component` varchar(255) DEFAULT NULL,
  `caller_sha1` varchar(255) NOT NULL DEFAULT '',
  `tempdataid` bigint(10) NOT NULL DEFAULT '0',
  `returnurl` varchar(255) NOT NULL DEFAULT '',
  `continueurl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portlog_use_ix` (`userid`),
  KEY `[[dbprefix]]portlog_por_ix` (`portfolio`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='log of portfolio transfers (used to later check for duplicat' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_mahara_queue`
--

CREATE TABLE `[[dbprefix]]portfolio_mahara_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `transferid` bigint(10) NOT NULL,
  `token` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portmahaqueu_tok_ix` (`token`),
  KEY `[[dbprefix]]portmahaqueu_tra_ix` (`transferid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='maps mahara tokens to transfer ids' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_tempdata`
--

CREATE TABLE `[[dbprefix]]portfolio_tempdata` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `data` longtext,
  `expirytime` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `instance` bigint(10) DEFAULT '0',
  `queued` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]porttemp_use_ix` (`userid`),
  KEY `[[dbprefix]]porttemp_ins_ix` (`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='stores temporary data for portfolio exports. the id of this ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post`
--

CREATE TABLE `[[dbprefix]]post` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `module` varchar(20) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `moduleid` bigint(10) NOT NULL DEFAULT '0',
  `coursemoduleid` bigint(10) NOT NULL DEFAULT '0',
  `subject` varchar(128) NOT NULL DEFAULT '',
  `summary` longtext,
  `content` longtext,
  `uniquehash` varchar(255) NOT NULL DEFAULT '',
  `rating` bigint(10) NOT NULL DEFAULT '0',
  `format` bigint(10) NOT NULL DEFAULT '0',
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) DEFAULT NULL,
  `publishstate` varchar(20) NOT NULL DEFAULT 'draft',
  `lastmodified` bigint(10) NOT NULL DEFAULT '0',
  `created` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]post_iduse_uix` (`id`,`userid`),
  KEY `[[dbprefix]]post_las_ix` (`lastmodified`),
  KEY `[[dbprefix]]post_mod_ix` (`module`),
  KEY `[[dbprefix]]post_sub_ix` (`subject`),
  KEY `[[dbprefix]]post_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Generic post table to hold data blog entries etc in differen' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]profiling`
--

CREATE TABLE `[[dbprefix]]profiling` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `runid` varchar(32) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `totalexecutiontime` bigint(10) NOT NULL,
  `totalcputime` bigint(10) NOT NULL,
  `totalcalls` bigint(10) NOT NULL,
  `totalmemory` bigint(10) NOT NULL,
  `runreference` tinyint(2) NOT NULL DEFAULT '0',
  `runcomment` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]prof_run_uix` (`runid`),
  KEY `[[dbprefix]]prof_urlrun_ix` (`url`,`runreference`),
  KEY `[[dbprefix]]prof_timrun_ix` (`timecreated`,`runreference`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the results of all the profiling runs' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddimageortext`
--

CREATE TABLE `[[dbprefix]]qtype_ddimageortext` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddim_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines drag and drop (text or images onto a background imag' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddimageortext_drags`
--

CREATE TABLE `[[dbprefix]]qtype_ddimageortext_drags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `no` bigint(10) NOT NULL DEFAULT '0',
  `draggroup` bigint(10) NOT NULL DEFAULT '0',
  `infinite` smallint(4) NOT NULL DEFAULT '0',
  `label` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddimdrag_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Images to drag. Actual file names are not stored here we use' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddimageortext_drops`
--

CREATE TABLE `[[dbprefix]]qtype_ddimageortext_drops` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `no` bigint(10) NOT NULL DEFAULT '0',
  `xleft` bigint(10) NOT NULL DEFAULT '0',
  `ytop` bigint(10) NOT NULL DEFAULT '0',
  `choice` bigint(10) NOT NULL DEFAULT '0',
  `label` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddimdrop_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Drop boxes' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddmarker`
--

CREATE TABLE `[[dbprefix]]qtype_ddmarker` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  `showmisplaced` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddma_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines drag and drop (text or images onto a background imag' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddmarker_drags`
--

CREATE TABLE `[[dbprefix]]qtype_ddmarker_drags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `no` bigint(10) NOT NULL DEFAULT '0',
  `label` longtext NOT NULL,
  `infinite` smallint(4) NOT NULL DEFAULT '0',
  `noofdrags` bigint(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddmadrag_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Labels for markers to drag.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddmarker_drops`
--

CREATE TABLE `[[dbprefix]]qtype_ddmarker_drops` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `no` bigint(10) NOT NULL DEFAULT '0',
  `shape` varchar(255) DEFAULT NULL,
  `coords` longtext NOT NULL,
  `choice` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddmadrop_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='drop regions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_essay_options`
--

CREATE TABLE `[[dbprefix]]qtype_essay_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL,
  `responseformat` varchar(16) NOT NULL DEFAULT 'editor',
  `responserequired` tinyint(2) NOT NULL DEFAULT '1',
  `responsefieldlines` smallint(4) NOT NULL DEFAULT '15',
  `minwordlimit` bigint(10) DEFAULT NULL,
  `maxwordlimit` bigint(10) DEFAULT NULL,
  `attachments` smallint(4) NOT NULL DEFAULT '0',
  `attachmentsrequired` smallint(4) NOT NULL DEFAULT '0',
  `graderinfo` longtext,
  `graderinfoformat` smallint(4) NOT NULL DEFAULT '0',
  `responsetemplate` longtext,
  `responsetemplateformat` smallint(4) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `filetypeslist` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypessaopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Extra options for essay questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_match_options`
--

CREATE TABLE `[[dbprefix]]qtype_match_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypmatcopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines the question-type specific options for matching ques' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_match_subquestions`
--

CREATE TABLE `[[dbprefix]]qtype_match_subquestions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `questiontext` longtext NOT NULL,
  `questiontextformat` tinyint(2) NOT NULL DEFAULT '0',
  `answertext` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypmatcsubq_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The subquestions that make up a matching question' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_multichoice_options`
--

CREATE TABLE `[[dbprefix]]qtype_multichoice_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `layout` smallint(4) NOT NULL DEFAULT '0',
  `single` smallint(4) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `answernumbering` varchar(10) NOT NULL DEFAULT 'abc',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  `showstandardinstruction` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypmultopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for multiple choice questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_randomsamatch_options`
--

CREATE TABLE `[[dbprefix]]qtype_randomsamatch_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `choose` bigint(10) NOT NULL DEFAULT '4',
  `subcats` tinyint(2) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtyprandopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Info about a random short-answer matching question' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_shortanswer_options`
--

CREATE TABLE `[[dbprefix]]qtype_shortanswer_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `usecase` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypshoropti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for short answer questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question`
--

CREATE TABLE `[[dbprefix]]question` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `questiontext` longtext NOT NULL,
  `questiontextformat` tinyint(2) NOT NULL DEFAULT '0',
  `generalfeedback` longtext NOT NULL,
  `generalfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `defaultmark` decimal(12,7) NOT NULL DEFAULT '1.0000000',
  `penalty` decimal(12,7) NOT NULL DEFAULT '0.3333333',
  `qtype` varchar(20) NOT NULL DEFAULT '',
  `length` bigint(10) NOT NULL DEFAULT '1',
  `stamp` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `createdby` bigint(10) DEFAULT NULL,
  `modifiedby` bigint(10) DEFAULT NULL,
  `idnumber` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]ques_catidn_uix` (`category`,`idnumber`),
  KEY `[[dbprefix]]ques_qty_ix` (`qtype`),
  KEY `[[dbprefix]]ques_cat_ix` (`category`),
  KEY `[[dbprefix]]ques_par_ix` (`parent`),
  KEY `[[dbprefix]]ques_cre_ix` (`createdby`),
  KEY `[[dbprefix]]ques_mod_ix` (`modifiedby`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The questions themselves' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_answers`
--

CREATE TABLE `[[dbprefix]]question_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `answer` longtext NOT NULL,
  `answerformat` tinyint(2) NOT NULL DEFAULT '0',
  `fraction` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  `feedback` longtext NOT NULL,
  `feedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesansw_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Answers, with a fractional grade (0-1) and feedback' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempts`
--

CREATE TABLE `[[dbprefix]]question_attempts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionusageid` bigint(10) NOT NULL,
  `slot` bigint(10) NOT NULL,
  `behaviour` varchar(32) NOT NULL DEFAULT '',
  `questionid` bigint(10) NOT NULL,
  `variant` bigint(10) NOT NULL DEFAULT '1',
  `maxmark` decimal(12,7) NOT NULL,
  `minfraction` decimal(12,7) NOT NULL,
  `maxfraction` decimal(12,7) NOT NULL DEFAULT '1.0000000',
  `flagged` tinyint(1) NOT NULL DEFAULT '0',
  `questionsummary` longtext,
  `rightanswer` longtext,
  `responsesummary` longtext,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesatte_queslo_uix` (`questionusageid`,`slot`),
  KEY `[[dbprefix]]quesatte_beh_ix` (`behaviour`),
  KEY `[[dbprefix]]quesatte_que_ix` (`questionid`),
  KEY `[[dbprefix]]quesatte_que2_ix` (`questionusageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each row here corresponds to an attempt at one question, as ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempt_steps`
--

CREATE TABLE `[[dbprefix]]question_attempt_steps` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionattemptid` bigint(10) NOT NULL,
  `sequencenumber` bigint(10) NOT NULL,
  `state` varchar(13) NOT NULL DEFAULT '',
  `fraction` decimal(12,7) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `userid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesattestep_queseq_uix` (`questionattemptid`,`sequencenumber`),
  KEY `[[dbprefix]]quesattestep_que_ix` (`questionattemptid`),
  KEY `[[dbprefix]]quesattestep_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores one step in in a question attempt. As well as the dat' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempt_step_data`
--

CREATE TABLE `[[dbprefix]]question_attempt_step_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `attemptstepid` bigint(10) NOT NULL,
  `name` varchar(32) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesattestepdata_att_ix` (`attemptstepid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each question_attempt_step has an associative array of the d' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_calculated`
--

CREATE TABLE `[[dbprefix]]question_calculated` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `answer` bigint(10) NOT NULL DEFAULT '0',
  `tolerance` varchar(20) NOT NULL DEFAULT '0.0',
  `tolerancetype` bigint(10) NOT NULL DEFAULT '1',
  `correctanswerlength` bigint(10) NOT NULL DEFAULT '2',
  `correctanswerformat` bigint(10) NOT NULL DEFAULT '2',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quescalc_ans_ix` (`answer`),
  KEY `[[dbprefix]]quescalc_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for questions of type calculated' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_calculated_options`
--

CREATE TABLE `[[dbprefix]]question_calculated_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `synchronize` tinyint(2) NOT NULL DEFAULT '0',
  `single` smallint(4) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '0',
  `correctfeedback` longtext,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `answernumbering` varchar(10) NOT NULL DEFAULT 'abc',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quescalcopti_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for questions of type calculated' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_categories`
--

CREATE TABLE `[[dbprefix]]question_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL DEFAULT '0',
  `info` longtext NOT NULL,
  `infoformat` tinyint(2) NOT NULL DEFAULT '0',
  `stamp` varchar(255) NOT NULL DEFAULT '',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '999',
  `idnumber` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quescate_consta_uix` (`contextid`,`stamp`),
  UNIQUE KEY `[[dbprefix]]quescate_conidn_uix` (`contextid`,`idnumber`),
  KEY `[[dbprefix]]quescate_con_ix` (`contextid`),
  KEY `[[dbprefix]]quescate_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Categories are for grouping questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_datasets`
--

CREATE TABLE `[[dbprefix]]question_datasets` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `datasetdefinition` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdata_quedat_ix` (`question`,`datasetdefinition`),
  KEY `[[dbprefix]]quesdata_que_ix` (`question`),
  KEY `[[dbprefix]]quesdata_dat_ix` (`datasetdefinition`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Many-many relation between questions and dataset definitions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_dataset_definitions`
--

CREATE TABLE `[[dbprefix]]question_dataset_definitions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` bigint(10) NOT NULL DEFAULT '0',
  `options` varchar(255) NOT NULL DEFAULT '',
  `itemcount` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdatadefi_cat_ix` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Organises and stores properties for dataset items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_dataset_items`
--

CREATE TABLE `[[dbprefix]]question_dataset_items` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definition` bigint(10) NOT NULL DEFAULT '0',
  `itemnumber` bigint(10) NOT NULL DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdataitem_def_ix` (`definition`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Individual dataset items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_ddwtos`
--

CREATE TABLE `[[dbprefix]]question_ddwtos` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesddwt_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines drag and drop (words into sentences) questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_gapselect`
--

CREATE TABLE `[[dbprefix]]question_gapselect` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesgaps_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines select missing words questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_hints`
--

CREATE TABLE `[[dbprefix]]question_hints` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL,
  `hint` longtext NOT NULL,
  `hintformat` smallint(4) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(1) DEFAULT NULL,
  `clearwrong` tinyint(1) DEFAULT NULL,
  `options` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]queshint_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the the part of the question definition that gives di' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_multianswer`
--

CREATE TABLE `[[dbprefix]]question_multianswer` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `sequence` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesmult_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for multianswer questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical`
--

CREATE TABLE `[[dbprefix]]question_numerical` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `answer` bigint(10) NOT NULL DEFAULT '0',
  `tolerance` varchar(255) NOT NULL DEFAULT '0.0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesnume_ans_ix` (`answer`),
  KEY `[[dbprefix]]quesnume_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for numerical questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical_options`
--

CREATE TABLE `[[dbprefix]]question_numerical_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `showunits` smallint(4) NOT NULL DEFAULT '0',
  `unitsleft` smallint(4) NOT NULL DEFAULT '0',
  `unitgradingtype` smallint(4) NOT NULL DEFAULT '0',
  `unitpenalty` decimal(12,7) NOT NULL DEFAULT '0.1000000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesnumeopti_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for questions of type numerical This table is also u' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical_units`
--

CREATE TABLE `[[dbprefix]]question_numerical_units` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `multiplier` decimal(38,19) NOT NULL DEFAULT '1.0000000000000000000',
  `unit` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesnumeunit_queuni_uix` (`question`,`unit`),
  KEY `[[dbprefix]]quesnumeunit_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Optional unit options for numerical questions. This table is' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_response_analysis`
--

CREATE TABLE `[[dbprefix]]question_response_analysis` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hashcode` varchar(40) NOT NULL DEFAULT '',
  `whichtries` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL,
  `questionid` bigint(10) NOT NULL,
  `variant` bigint(10) DEFAULT NULL,
  `subqid` varchar(100) NOT NULL DEFAULT '',
  `aid` varchar(100) DEFAULT NULL,
  `response` longtext,
  `credit` decimal(15,5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Analysis of student responses given to questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_response_count`
--

CREATE TABLE `[[dbprefix]]question_response_count` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `analysisid` bigint(10) NOT NULL,
  `try` bigint(10) NOT NULL,
  `rcount` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesrespcoun_ana_ix` (`analysisid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Count for each responses for each try at a question.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_statistics`
--

CREATE TABLE `[[dbprefix]]question_statistics` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hashcode` varchar(40) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL,
  `questionid` bigint(10) NOT NULL,
  `slot` bigint(10) DEFAULT NULL,
  `subquestion` smallint(4) NOT NULL,
  `variant` bigint(10) DEFAULT NULL,
  `s` bigint(10) NOT NULL DEFAULT '0',
  `effectiveweight` decimal(15,5) DEFAULT NULL,
  `negcovar` tinyint(2) NOT NULL DEFAULT '0',
  `discriminationindex` decimal(15,5) DEFAULT NULL,
  `discriminativeefficiency` decimal(15,5) DEFAULT NULL,
  `sd` decimal(15,10) DEFAULT NULL,
  `facility` decimal(15,10) DEFAULT NULL,
  `subquestions` longtext,
  `maxmark` decimal(12,7) DEFAULT NULL,
  `positions` longtext,
  `randomguessscore` decimal(12,7) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Statistics for individual questions used in an activity.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_truefalse`
--

CREATE TABLE `[[dbprefix]]question_truefalse` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `trueanswer` bigint(10) NOT NULL DEFAULT '0',
  `falseanswer` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]questrue_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for True-False questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_usages`
--

CREATE TABLE `[[dbprefix]]question_usages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(255) NOT NULL DEFAULT '',
  `preferredbehaviour` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesusag_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table''s main purpose it to assign a unique id to each a' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz`
--

CREATE TABLE `[[dbprefix]]quiz` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `timelimit` bigint(10) NOT NULL DEFAULT '0',
  `overduehandling` varchar(16) NOT NULL DEFAULT 'autoabandon',
  `graceperiod` bigint(10) NOT NULL DEFAULT '0',
  `preferredbehaviour` varchar(32) NOT NULL DEFAULT '',
  `canredoquestions` smallint(4) NOT NULL DEFAULT '0',
  `attempts` mediumint(6) NOT NULL DEFAULT '0',
  `attemptonlast` smallint(4) NOT NULL DEFAULT '0',
  `grademethod` smallint(4) NOT NULL DEFAULT '1',
  `decimalpoints` smallint(4) NOT NULL DEFAULT '2',
  `questiondecimalpoints` smallint(4) NOT NULL DEFAULT '-1',
  `reviewattempt` mediumint(6) NOT NULL DEFAULT '0',
  `reviewcorrectness` mediumint(6) NOT NULL DEFAULT '0',
  `reviewmarks` mediumint(6) NOT NULL DEFAULT '0',
  `reviewspecificfeedback` mediumint(6) NOT NULL DEFAULT '0',
  `reviewgeneralfeedback` mediumint(6) NOT NULL DEFAULT '0',
  `reviewrightanswer` mediumint(6) NOT NULL DEFAULT '0',
  `reviewoverallfeedback` mediumint(6) NOT NULL DEFAULT '0',
  `questionsperpage` bigint(10) NOT NULL DEFAULT '0',
  `navmethod` varchar(16) NOT NULL DEFAULT 'free',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '0',
  `sumgrades` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `grade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `password` varchar(255) NOT NULL DEFAULT '',
  `subnet` varchar(255) NOT NULL DEFAULT '',
  `browsersecurity` varchar(32) NOT NULL DEFAULT '',
  `delay1` bigint(10) NOT NULL DEFAULT '0',
  `delay2` bigint(10) NOT NULL DEFAULT '0',
  `showuserpicture` smallint(4) NOT NULL DEFAULT '0',
  `showblocks` smallint(4) NOT NULL DEFAULT '0',
  `completionattemptsexhausted` tinyint(1) DEFAULT '0',
  `completionpass` tinyint(1) DEFAULT '0',
  `completionminattempts` bigint(10) NOT NULL DEFAULT '0',
  `allowofflineattempts` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quiz_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The settings for each quiz.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quizaccess_seb_quizsettings`
--

CREATE TABLE `[[dbprefix]]quizaccess_seb_quizsettings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quizid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `templateid` bigint(10) NOT NULL,
  `requiresafeexambrowser` tinyint(1) NOT NULL,
  `showsebtaskbar` tinyint(1) DEFAULT NULL,
  `showwificontrol` tinyint(1) DEFAULT NULL,
  `showreloadbutton` tinyint(1) DEFAULT NULL,
  `showtime` tinyint(1) DEFAULT NULL,
  `showkeyboardlayout` tinyint(1) DEFAULT NULL,
  `allowuserquitseb` tinyint(1) DEFAULT NULL,
  `quitpassword` longtext,
  `linkquitseb` longtext,
  `userconfirmquit` tinyint(1) DEFAULT NULL,
  `enableaudiocontrol` tinyint(1) DEFAULT NULL,
  `muteonstartup` tinyint(1) DEFAULT NULL,
  `allowspellchecking` tinyint(1) DEFAULT NULL,
  `allowreloadinexam` tinyint(1) DEFAULT NULL,
  `activateurlfiltering` tinyint(1) DEFAULT NULL,
  `filterembeddedcontent` tinyint(1) DEFAULT NULL,
  `expressionsallowed` longtext,
  `regexallowed` longtext,
  `expressionsblocked` longtext,
  `regexblocked` longtext,
  `allowedbrowserexamkeys` longtext,
  `showsebdownloadlink` tinyint(1) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizsebquiz_qui_uix` (`quizid`),
  UNIQUE KEY `[[dbprefix]]quizsebquiz_cmi_uix` (`cmid`),
  KEY `[[dbprefix]]quizsebquiz_tem_ix` (`templateid`),
  KEY `[[dbprefix]]quizsebquiz_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the quiz level Safe Exam Browser configuration.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quizaccess_seb_template`
--

CREATE TABLE `[[dbprefix]]quizaccess_seb_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `content` longtext NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizsebtemp_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Templates for Safe Exam Browser configuration.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_attempts`
--

CREATE TABLE `[[dbprefix]]quiz_attempts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quiz` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `attempt` mediumint(6) NOT NULL DEFAULT '0',
  `uniqueid` bigint(10) NOT NULL DEFAULT '0',
  `layout` longtext NOT NULL,
  `currentpage` bigint(10) NOT NULL DEFAULT '0',
  `preview` smallint(3) NOT NULL DEFAULT '0',
  `state` varchar(16) NOT NULL DEFAULT 'inprogress',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timefinish` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `timemodifiedoffline` bigint(10) NOT NULL DEFAULT '0',
  `timecheckstate` bigint(10) DEFAULT '0',
  `sumgrades` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizatte_quiuseatt_uix` (`quiz`,`userid`,`attempt`),
  UNIQUE KEY `[[dbprefix]]quizatte_uni_uix` (`uniqueid`),
  KEY `[[dbprefix]]quizatte_statim_ix` (`state`,`timecheckstate`),
  KEY `[[dbprefix]]quizatte_qui_ix` (`quiz`),
  KEY `[[dbprefix]]quizatte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores users attempts at quizzes.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_feedback`
--

CREATE TABLE `[[dbprefix]]quiz_feedback` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quizid` bigint(10) NOT NULL DEFAULT '0',
  `feedbacktext` longtext NOT NULL,
  `feedbacktextformat` tinyint(2) NOT NULL DEFAULT '0',
  `mingrade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `maxgrade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizfeed_qui_ix` (`quizid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Feedback given to students based on which grade band their o' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_grades`
--

CREATE TABLE `[[dbprefix]]quiz_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quiz` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `grade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]quizgrad_qui_ix` (`quiz`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the overall grade for each user on the quiz, based on' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_overrides`
--

CREATE TABLE `[[dbprefix]]quiz_overrides` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quiz` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) DEFAULT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `timeopen` bigint(10) DEFAULT NULL,
  `timeclose` bigint(10) DEFAULT NULL,
  `timelimit` bigint(10) DEFAULT NULL,
  `attempts` mediumint(6) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizover_qui_ix` (`quiz`),
  KEY `[[dbprefix]]quizover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]quizover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The overrides to quiz settings on a per-user and per-group b' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_overview_regrades`
--

CREATE TABLE `[[dbprefix]]quiz_overview_regrades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionusageid` bigint(10) NOT NULL,
  `slot` bigint(10) NOT NULL,
  `newfraction` decimal(12,7) DEFAULT NULL,
  `oldfraction` decimal(12,7) DEFAULT NULL,
  `regraded` smallint(4) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizoverregr_queslo_ix` (`questionusageid`,`slot`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table records which question attempts need regrading an' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_reports`
--

CREATE TABLE `[[dbprefix]]quiz_reports` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `displayorder` bigint(10) NOT NULL,
  `capability` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizrepo_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Lists all the installed quiz reports and their display order' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]quiz_reports`
--

INSERT INTO `[[dbprefix]]quiz_reports` VALUES
(1, 'grading', 6000, 'mod/quiz:grade'),
(2, 'overview', 10000, NULL),
(3, 'responses', 9000, NULL),
(4, 'statistics', 8000, 'quiz/statistics:view');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_sections`
--

CREATE TABLE `[[dbprefix]]quiz_sections` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quizid` bigint(10) NOT NULL,
  `firstslot` bigint(10) NOT NULL,
  `heading` varchar(1333) DEFAULT NULL,
  `shufflequestions` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizsect_quifir_uix` (`quizid`,`firstslot`),
  KEY `[[dbprefix]]quizsect_qui_ix` (`quizid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores sections of a quiz with section name (heading), from ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_slots`
--

CREATE TABLE `[[dbprefix]]quiz_slots` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `slot` bigint(10) NOT NULL,
  `quizid` bigint(10) NOT NULL DEFAULT '0',
  `page` bigint(10) NOT NULL,
  `requireprevious` smallint(4) NOT NULL DEFAULT '0',
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `questioncategoryid` bigint(10) DEFAULT NULL,
  `includingsubcategories` smallint(4) DEFAULT NULL,
  `maxmark` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizslot_quislo_uix` (`quizid`,`slot`),
  KEY `[[dbprefix]]quizslot_qui_ix` (`quizid`),
  KEY `[[dbprefix]]quizslot_que_ix` (`questionid`),
  KEY `[[dbprefix]]quizslot_que2_ix` (`questioncategoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the question used in a quiz, with the order, and for ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_slot_tags`
--

CREATE TABLE `[[dbprefix]]quiz_slot_tags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `slotid` bigint(10) DEFAULT NULL,
  `tagid` bigint(10) DEFAULT NULL,
  `tagname` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizslottags_slo_ix` (`slotid`),
  KEY `[[dbprefix]]quizslottags_tag_ix` (`tagid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores data about the tags that a question must have so that' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_statistics`
--

CREATE TABLE `[[dbprefix]]quiz_statistics` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hashcode` varchar(40) NOT NULL DEFAULT '',
  `whichattempts` smallint(4) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `firstattemptscount` bigint(10) NOT NULL,
  `highestattemptscount` bigint(10) NOT NULL,
  `lastattemptscount` bigint(10) NOT NULL,
  `allattemptscount` bigint(10) NOT NULL,
  `firstattemptsavg` decimal(15,5) DEFAULT NULL,
  `highestattemptsavg` decimal(15,5) DEFAULT NULL,
  `lastattemptsavg` decimal(15,5) DEFAULT NULL,
  `allattemptsavg` decimal(15,5) DEFAULT NULL,
  `median` decimal(15,5) DEFAULT NULL,
  `standarddeviation` decimal(15,5) DEFAULT NULL,
  `skewness` decimal(15,10) DEFAULT NULL,
  `kurtosis` decimal(15,5) DEFAULT NULL,
  `cic` decimal(15,10) DEFAULT NULL,
  `errorratio` decimal(15,10) DEFAULT NULL,
  `standarderror` decimal(15,10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='table to cache results from analysis done in statistics repo' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]rating`
--

CREATE TABLE `[[dbprefix]]rating` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `ratingarea` varchar(50) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `scaleid` bigint(10) NOT NULL,
  `rating` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]rati_comratconite_ix` (`component`,`ratingarea`,`contextid`,`itemid`),
  KEY `[[dbprefix]]rati_con_ix` (`contextid`),
  KEY `[[dbprefix]]rati_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='moodle ratings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]registration_hubs`
--

CREATE TABLE `[[dbprefix]]registration_hubs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) NOT NULL DEFAULT '',
  `hubname` varchar(255) NOT NULL DEFAULT '',
  `huburl` varchar(255) NOT NULL DEFAULT '',
  `confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `secret` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='hub where the site is registered on with their associated to' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository`
--

CREATE TABLE `[[dbprefix]]repository` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) DEFAULT '1',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains one entry for every configured external ' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]repository`
--

INSERT INTO `[[dbprefix]]repository` VALUES
(1, 'areafiles', 1, 1),
(2, 'contentbank', 1, 2),
(3, 'local', 1, 3),
(4, 'recent', 1, 4),
(5, 'upload', 1, 5),
(6, 'url', 1, 6),
(7, 'user', 1, 7),
(8, 'wikimedia', 1, 8);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_instances`
--

CREATE TABLE `[[dbprefix]]repository_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `typeid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `contextid` bigint(10) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `readonly` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains one entry for every configured external ' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]repository_instances`
--

INSERT INTO `[[dbprefix]]repository_instances` VALUES
(1, '', 1, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(2, '', 2, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(3, '', 3, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(4, '', 4, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(5, '', 5, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(6, '', 6, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(7, '', 7, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(8, '', 8, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_instance_config`
--

CREATE TABLE `[[dbprefix]]repository_instance_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The config for intances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_onedrive_access`
--

CREATE TABLE `[[dbprefix]]repository_onedrive_access` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timemodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `permissionid` varchar(255) NOT NULL DEFAULT '',
  `itemid` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]repoonedacce_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of temporary access grants.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource`
--

CREATE TABLE `[[dbprefix]]resource` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `tobemigrated` smallint(4) NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) NOT NULL DEFAULT '0',
  `legacyfileslast` bigint(10) DEFAULT NULL,
  `display` smallint(4) NOT NULL DEFAULT '0',
  `displayoptions` longtext,
  `filterfiles` smallint(4) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]reso_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each record is one resource and its config data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource_old`
--

CREATE TABLE `[[dbprefix]]resource_old` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `reference` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `alltext` longtext NOT NULL,
  `popup` longtext NOT NULL,
  `options` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `cmid` bigint(10) DEFAULT NULL,
  `newmodule` varchar(50) DEFAULT NULL,
  `newid` bigint(10) DEFAULT NULL,
  `migrated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]resoold_old_uix` (`oldid`),
  KEY `[[dbprefix]]resoold_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='backup of all old resource instances from 1.9' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role`
--

CREATE TABLE `[[dbprefix]]role` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `archetype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]role_sor_uix` (`sortorder`),
  UNIQUE KEY `[[dbprefix]]role_sho_uix` (`shortname`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='moodle roles' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]role`
--

INSERT INTO `[[dbprefix]]role` VALUES
(1, '', 'manager', '', 1, 'manager'),
(2, '', 'coursecreator', '', 2, 'coursecreator'),
(3, '', 'editingteacher', '', 3, 'editingteacher'),
(4, '', 'teacher', '', 4, 'teacher'),
(5, '', 'student', '', 5, 'student'),
(6, '', 'guest', '', 6, 'guest'),
(7, '', 'user', '', 7, 'user'),
(8, '', 'frontpage', '', 8, 'frontpage');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_assign`
--

CREATE TABLE `[[dbprefix]]role_allow_assign` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `allowassign` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloassi_rolall_uix` (`roleid`,`allowassign`),
  KEY `[[dbprefix]]rolealloassi_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloassi_all_ix` (`allowassign`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='this defines what role can assign what role' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_assign`
--

INSERT INTO `[[dbprefix]]role_allow_assign` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 3, 4),
(7, 3, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_override`
--

CREATE TABLE `[[dbprefix]]role_allow_override` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `allowoverride` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloover_rolall_uix` (`roleid`,`allowoverride`),
  KEY `[[dbprefix]]rolealloover_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloover_all_ix` (`allowoverride`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='this defines what role can override what role' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_override`
--

INSERT INTO `[[dbprefix]]role_allow_override` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 1, 8),
(9, 3, 4),
(10, 3, 5),
(11, 3, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_switch`
--

CREATE TABLE `[[dbprefix]]role_allow_switch` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL,
  `allowswitch` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloswit_rolall_uix` (`roleid`,`allowswitch`),
  KEY `[[dbprefix]]rolealloswit_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloswit_all_ix` (`allowswitch`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores which which other roles a user is allowed ' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_switch`
--

INSERT INTO `[[dbprefix]]role_allow_switch` VALUES
(1, 1, 3),
(2, 1, 4),
(3, 1, 5),
(4, 1, 6),
(5, 3, 4),
(6, 3, 5),
(7, 3, 6),
(8, 4, 5),
(9, 4, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_view`
--

CREATE TABLE `[[dbprefix]]role_allow_view` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL,
  `allowview` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloview_rolall_uix` (`roleid`,`allowview`),
  KEY `[[dbprefix]]rolealloview_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloview_all_ix` (`allowview`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores which which other roles a user is allowed ' AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_view`
--

INSERT INTO `[[dbprefix]]role_allow_view` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 1, 8),
(9, 2, 2),
(10, 2, 3),
(11, 2, 4),
(12, 2, 5),
(13, 3, 2),
(14, 3, 3),
(15, 3, 4),
(16, 3, 5),
(17, 4, 2),
(18, 4, 3),
(19, 4, 4),
(20, 4, 5),
(21, 5, 2),
(22, 5, 3),
(23, 5, 4),
(24, 5, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_assignments`
--

CREATE TABLE `[[dbprefix]]role_assignments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `contextid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `modifierid` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]roleassi_sor_ix` (`sortorder`),
  KEY `[[dbprefix]]roleassi_rolcon_ix` (`roleid`,`contextid`),
  KEY `[[dbprefix]]roleassi_useconrol_ix` (`userid`,`contextid`,`roleid`),
  KEY `[[dbprefix]]roleassi_comiteuse_ix` (`component`,`itemid`,`userid`),
  KEY `[[dbprefix]]roleassi_rol_ix` (`roleid`),
  KEY `[[dbprefix]]roleassi_con_ix` (`contextid`),
  KEY `[[dbprefix]]roleassi_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='assigning roles in different context' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_capabilities`
--

CREATE TABLE `[[dbprefix]]role_capabilities` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `capability` varchar(255) NOT NULL DEFAULT '',
  `permission` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `modifierid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolecapa_rolconcap_uix` (`roleid`,`contextid`,`capability`),
  KEY `[[dbprefix]]rolecapa_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolecapa_con_ix` (`contextid`),
  KEY `[[dbprefix]]rolecapa_mod_ix` (`modifierid`),
  KEY `[[dbprefix]]rolecapa_cap_ix` (`capability`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='permission has to be signed, overriding a capability for a p' AUTO_INCREMENT=1448 ;

--
-- Dumping data for table `[[dbprefix]]role_capabilities`
--

INSERT INTO `[[dbprefix]]role_capabilities` VALUES
(1, 1, 1, 'moodle/site:configview', 1, [[timestamp]], 0),
(2, 1, 2, 'moodle/site:configview', 1, [[timestamp]], 0),
(3, 1, 1, 'moodle/site:readallmessages', 1, [[timestamp]], 0),
(4, 1, 3, 'moodle/site:readallmessages', 1, [[timestamp]], 0),
(5, 1, 1, 'moodle/site:manageallmessaging', 1, [[timestamp]], 0),
(6, 1, 1, 'moodle/site:deleteanymessage', 1, [[timestamp]], 0),
(7, 1, 1, 'moodle/site:sendmessage', 1, [[timestamp]], 0),
(8, 1, 7, 'moodle/site:sendmessage', 1, [[timestamp]], 0),
(9, 1, 7, 'moodle/site:senderrormessage', 1, [[timestamp]], 0),
(10, 1, 7, 'moodle/site:deleteownmessage', 1, [[timestamp]], 0),
(11, 1, 1, 'moodle/site:approvecourse', 1, [[timestamp]], 0),
(12, 1, 3, 'moodle/backup:backupcourse', 1, [[timestamp]], 0),
(13, 1, 1, 'moodle/backup:backupcourse', 1, [[timestamp]], 0),
(14, 1, 3, 'moodle/backup:backupsection', 1, [[timestamp]], 0),
(15, 1, 1, 'moodle/backup:backupsection', 1, [[timestamp]], 0),
(16, 1, 3, 'moodle/backup:backupactivity', 1, [[timestamp]], 0),
(17, 1, 1, 'moodle/backup:backupactivity', 1, [[timestamp]], 0),
(18, 1, 3, 'moodle/backup:backuptargetimport', 1, [[timestamp]], 0),
(19, 1, 1, 'moodle/backup:backuptargetimport', 1, [[timestamp]], 0),
(20, 1, 3, 'moodle/backup:downloadfile', 1, [[timestamp]], 0),
(21, 1, 1, 'moodle/backup:downloadfile', 1, [[timestamp]], 0),
(22, 1, 3, 'moodle/backup:configure', 1, [[timestamp]], 0),
(23, 1, 1, 'moodle/backup:configure', 1, [[timestamp]], 0),
(24, 1, 1, 'moodle/backup:userinfo', 1, [[timestamp]], 0),
(25, 1, 1, 'moodle/backup:anonymise', 1, [[timestamp]], 0),
(26, 1, 3, 'moodle/restore:restorecourse', 1, [[timestamp]], 0),
(27, 1, 1, 'moodle/restore:restorecourse', 1, [[timestamp]], 0),
(28, 1, 3, 'moodle/restore:restoresection', 1, [[timestamp]], 0),
(29, 1, 1, 'moodle/restore:restoresection', 1, [[timestamp]], 0),
(30, 1, 3, 'moodle/restore:restoreactivity', 1, [[timestamp]], 0),
(31, 1, 1, 'moodle/restore:restoreactivity', 1, [[timestamp]], 0),
(32, 1, 3, 'moodle/restore:viewautomatedfilearea', 1, [[timestamp]], 0),
(33, 1, 1, 'moodle/restore:viewautomatedfilearea', 1, [[timestamp]], 0),
(34, 1, 3, 'moodle/restore:restoretargetimport', 1, [[timestamp]], 0),
(35, 1, 1, 'moodle/restore:restoretargetimport', 1, [[timestamp]], 0),
(36, 1, 3, 'moodle/restore:uploadfile', 1, [[timestamp]], 0),
(37, 1, 1, 'moodle/restore:uploadfile', 1, [[timestamp]], 0),
(38, 1, 3, 'moodle/restore:configure', 1, [[timestamp]], 0),
(39, 1, 1, 'moodle/restore:configure', 1, [[timestamp]], 0),
(40, 1, 2, 'moodle/restore:rolldates', 1, [[timestamp]], 0),
(41, 1, 1, 'moodle/restore:rolldates', 1, [[timestamp]], 0),
(42, 1, 1, 'moodle/restore:userinfo', 1, [[timestamp]], 0),
(43, 1, 1, 'moodle/restore:createuser', 1, [[timestamp]], 0),
(44, 1, 3, 'moodle/site:manageblocks', 1, [[timestamp]], 0),
(45, 1, 1, 'moodle/site:manageblocks', 1, [[timestamp]], 0),
(46, 1, 3, 'moodle/site:accessallgroups', 1, [[timestamp]], 0),
(47, 1, 1, 'moodle/site:accessallgroups', 1, [[timestamp]], 0),
(48, 1, 1, 'moodle/site:viewanonymousevents', 1, [[timestamp]], 0),
(49, 1, 4, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(50, 1, 3, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(51, 1, 1, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(52, 1, 4, 'moodle/site:viewuseridentity', 1, [[timestamp]], 0),
(53, 1, 3, 'moodle/site:viewuseridentity', 1, [[timestamp]], 0),
(54, 1, 1, 'moodle/site:viewuseridentity', 1, [[timestamp]], 0),
(55, 1, 4, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(56, 1, 3, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(57, 1, 1, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(58, 1, 3, 'moodle/site:trustcontent', 1, [[timestamp]], 0),
(59, 1, 1, 'moodle/site:trustcontent', 1, [[timestamp]], 0),
(60, 1, 1, 'moodle/site:uploadusers', 1, [[timestamp]], 0),
(61, 1, 3, 'moodle/filter:manage', 1, [[timestamp]], 0),
(62, 1, 1, 'moodle/filter:manage', 1, [[timestamp]], 0),
(63, 1, 1, 'moodle/user:create', 1, [[timestamp]], 0),
(64, 1, 1, 'moodle/user:delete', 1, [[timestamp]], 0),
(65, 1, 1, 'moodle/user:update', 1, [[timestamp]], 0),
(66, 1, 6, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(67, 1, 5, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(68, 1, 4, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(69, 1, 3, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(70, 1, 1, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(71, 1, 1, 'moodle/user:viewalldetails', 1, [[timestamp]], 0),
(72, 1, 1, 'moodle/user:viewlastip', 1, [[timestamp]], 0),
(73, 1, 4, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(74, 1, 3, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(75, 1, 1, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(76, 1, 1, 'moodle/user:loginas', 1, [[timestamp]], 0),
(77, 1, 1, 'moodle/user:managesyspages', 1, [[timestamp]], 0),
(78, 1, 7, 'moodle/user:manageownblocks', 1, [[timestamp]], 0),
(79, 1, 7, 'moodle/user:manageownfiles', 1, [[timestamp]], 0),
(80, 1, 1, 'moodle/my:configsyspages', 1, [[timestamp]], 0),
(81, 1, 3, 'moodle/role:assign', 1, [[timestamp]], 0),
(82, 1, 1, 'moodle/role:assign', 1, [[timestamp]], 0),
(83, 1, 4, 'moodle/role:review', 1, [[timestamp]], 0),
(84, 1, 3, 'moodle/role:review', 1, [[timestamp]], 0),
(85, 1, 1, 'moodle/role:review', 1, [[timestamp]], 0),
(86, 1, 1, 'moodle/role:override', 1, [[timestamp]], 0),
(87, 1, 3, 'moodle/role:safeoverride', 1, [[timestamp]], 0),
(88, 1, 1, 'moodle/role:manage', 1, [[timestamp]], 0),
(89, 1, 3, 'moodle/role:switchroles', 1, [[timestamp]], 0),
(90, 1, 1, 'moodle/role:switchroles', 1, [[timestamp]], 0),
(91, 1, 1, 'moodle/category:manage', 1, [[timestamp]], 0),
(92, 1, 6, 'moodle/category:viewcourselist', 1, [[timestamp]], 0),
(93, 1, 7, 'moodle/category:viewcourselist', 1, [[timestamp]], 0),
(94, 1, 2, 'moodle/category:viewhiddencategories', 1, [[timestamp]], 0),
(95, 1, 1, 'moodle/category:viewhiddencategories', 1, [[timestamp]], 0),
(96, 1, 1, 'moodle/cohort:manage', 1, [[timestamp]], 0),
(97, 1, 1, 'moodle/cohort:assign', 1, [[timestamp]], 0),
(98, 1, 3, 'moodle/cohort:view', 1, [[timestamp]], 0),
(99, 1, 1, 'moodle/cohort:view', 1, [[timestamp]], 0),
(100, 1, 2, 'moodle/course:create', 1, [[timestamp]], 0),
(101, 1, 1, 'moodle/course:create', 1, [[timestamp]], 0),
(102, 1, 3, 'moodle/course:creategroupconversations', 1, [[timestamp]], 0),
(103, 1, 1, 'moodle/course:creategroupconversations', 1, [[timestamp]], 0),
(104, 1, 1, 'moodle/course:delete', 1, [[timestamp]], 0),
(105, 1, 3, 'moodle/course:update', 1, [[timestamp]], 0),
(106, 1, 1, 'moodle/course:update', 1, [[timestamp]], 0),
(107, 1, 1, 'moodle/course:view', 1, [[timestamp]], 0),
(108, 1, 3, 'moodle/course:enrolreview', 1, [[timestamp]], 0),
(109, 1, 1, 'moodle/course:enrolreview', 1, [[timestamp]], 0),
(110, 1, 3, 'moodle/course:enrolconfig', 1, [[timestamp]], 0),
(111, 1, 1, 'moodle/course:enrolconfig', 1, [[timestamp]], 0),
(112, 1, 3, 'moodle/course:reviewotherusers', 1, [[timestamp]], 0),
(113, 1, 1, 'moodle/course:reviewotherusers', 1, [[timestamp]], 0),
(114, 1, 4, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(115, 1, 3, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(116, 1, 1, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(117, 1, 4, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(118, 1, 3, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(119, 1, 1, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(120, 1, 2, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(121, 1, 4, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(122, 1, 3, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(123, 1, 1, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(124, 1, 3, 'moodle/course:visibility', 1, [[timestamp]], 0),
(125, 1, 1, 'moodle/course:visibility', 1, [[timestamp]], 0),
(126, 1, 3, 'moodle/course:managefiles', 1, [[timestamp]], 0),
(127, 1, 1, 'moodle/course:managefiles', 1, [[timestamp]], 0),
(128, 1, 1, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(129, 1, 2, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(130, 1, 3, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(131, 1, 4, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(132, 1, 3, 'moodle/course:manageactivities', 1, [[timestamp]], 0),
(133, 1, 1, 'moodle/course:manageactivities', 1, [[timestamp]], 0),
(134, 1, 3, 'moodle/course:activityvisibility', 1, [[timestamp]], 0),
(135, 1, 1, 'moodle/course:activityvisibility', 1, [[timestamp]], 0),
(136, 1, 4, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(137, 1, 3, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(138, 1, 1, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(139, 1, 5, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(140, 1, 4, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(141, 1, 3, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(142, 1, 1, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(143, 1, 3, 'moodle/course:changefullname', 1, [[timestamp]], 0),
(144, 1, 1, 'moodle/course:changefullname', 1, [[timestamp]], 0),
(145, 1, 3, 'moodle/course:changeshortname', 1, [[timestamp]], 0),
(146, 1, 1, 'moodle/course:changeshortname', 1, [[timestamp]], 0),
(147, 1, 1, 'moodle/course:changelockedcustomfields', 1, [[timestamp]], 0),
(148, 1, 3, 'moodle/course:renameroles', 1, [[timestamp]], 0),
(149, 1, 1, 'moodle/course:renameroles', 1, [[timestamp]], 0),
(150, 1, 3, 'moodle/course:changeidnumber', 1, [[timestamp]], 0),
(151, 1, 1, 'moodle/course:changeidnumber', 1, [[timestamp]], 0),
(152, 1, 3, 'moodle/course:changecategory', 1, [[timestamp]], 0),
(153, 1, 1, 'moodle/course:changecategory', 1, [[timestamp]], 0),
(154, 1, 3, 'moodle/course:changesummary', 1, [[timestamp]], 0),
(155, 1, 1, 'moodle/course:changesummary', 1, [[timestamp]], 0),
(156, 1, 3, 'moodle/course:setforcedlanguage', 1, [[timestamp]], 0),
(157, 1, 1, 'moodle/course:setforcedlanguage', 1, [[timestamp]], 0),
(158, 1, 1, 'moodle/site:viewparticipants', 1, [[timestamp]], 0),
(159, 1, 5, 'moodle/course:isincompletionreports', 1, [[timestamp]], 0),
(160, 1, 5, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(161, 1, 4, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(162, 1, 3, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(163, 1, 1, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(164, 1, 3, 'moodle/course:managescales', 1, [[timestamp]], 0),
(165, 1, 1, 'moodle/course:managescales', 1, [[timestamp]], 0),
(166, 1, 3, 'moodle/course:managegroups', 1, [[timestamp]], 0),
(167, 1, 1, 'moodle/course:managegroups', 1, [[timestamp]], 0),
(168, 1, 3, 'moodle/course:reset', 1, [[timestamp]], 0),
(169, 1, 1, 'moodle/course:reset', 1, [[timestamp]], 0),
(170, 1, 3, 'moodle/course:viewsuspendedusers', 1, [[timestamp]], 0),
(171, 1, 1, 'moodle/course:viewsuspendedusers', 1, [[timestamp]], 0),
(172, 1, 1, 'moodle/course:tag', 1, [[timestamp]], 0),
(173, 1, 3, 'moodle/course:tag', 1, [[timestamp]], 0),
(174, 1, 6, 'moodle/blog:view', 1, [[timestamp]], 0),
(175, 1, 7, 'moodle/blog:view', 1, [[timestamp]], 0),
(176, 1, 5, 'moodle/blog:view', 1, [[timestamp]], 0),
(177, 1, 4, 'moodle/blog:view', 1, [[timestamp]], 0),
(178, 1, 3, 'moodle/blog:view', 1, [[timestamp]], 0),
(179, 1, 1, 'moodle/blog:view', 1, [[timestamp]], 0),
(180, 1, 6, 'moodle/blog:search', 1, [[timestamp]], 0),
(181, 1, 7, 'moodle/blog:search', 1, [[timestamp]], 0),
(182, 1, 5, 'moodle/blog:search', 1, [[timestamp]], 0),
(183, 1, 4, 'moodle/blog:search', 1, [[timestamp]], 0),
(184, 1, 3, 'moodle/blog:search', 1, [[timestamp]], 0),
(185, 1, 1, 'moodle/blog:search', 1, [[timestamp]], 0),
(186, 1, 1, 'moodle/blog:viewdrafts', 1, [[timestamp]], 0),
(187, 1, 7, 'moodle/blog:create', 1, [[timestamp]], 0),
(188, 1, 1, 'moodle/blog:create', 1, [[timestamp]], 0),
(189, 1, 4, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(190, 1, 3, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(191, 1, 1, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(192, 1, 5, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(193, 1, 7, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(194, 1, 4, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(195, 1, 3, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(196, 1, 1, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(197, 1, 7, 'moodle/calendar:manageownentries', 1, [[timestamp]], 0),
(198, 1, 1, 'moodle/calendar:manageownentries', 1, [[timestamp]], 0),
(199, 1, 4, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(200, 1, 3, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(201, 1, 1, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(202, 1, 4, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(203, 1, 3, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(204, 1, 1, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(205, 1, 1, 'moodle/user:editprofile', 1, [[timestamp]], 0),
(206, 1, 6, 'moodle/user:editownprofile', -1000, [[timestamp]], 0),
(207, 1, 7, 'moodle/user:editownprofile', 1, [[timestamp]], 0),
(208, 1, 1, 'moodle/user:editownprofile', 1, [[timestamp]], 0),
(209, 1, 6, 'moodle/user:changeownpassword', -1000, [[timestamp]], 0),
(210, 1, 7, 'moodle/user:changeownpassword', 1, [[timestamp]], 0),
(211, 1, 1, 'moodle/user:changeownpassword', 1, [[timestamp]], 0),
(212, 1, 5, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(213, 1, 4, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(214, 1, 3, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(215, 1, 1, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(216, 1, 5, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(217, 1, 4, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(218, 1, 3, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(219, 1, 1, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(220, 1, 1, 'moodle/user:editmessageprofile', 1, [[timestamp]], 0),
(221, 1, 6, 'moodle/user:editownmessageprofile', -1000, [[timestamp]], 0),
(222, 1, 7, 'moodle/user:editownmessageprofile', 1, [[timestamp]], 0),
(223, 1, 1, 'moodle/user:editownmessageprofile', 1, [[timestamp]], 0),
(224, 1, 3, 'moodle/question:managecategory', 1, [[timestamp]], 0),
(225, 1, 1, 'moodle/question:managecategory', 1, [[timestamp]], 0),
(226, 1, 3, 'moodle/question:add', 1, [[timestamp]], 0),
(227, 1, 1, 'moodle/question:add', 1, [[timestamp]], 0),
(228, 1, 3, 'moodle/question:editmine', 1, [[timestamp]], 0),
(229, 1, 1, 'moodle/question:editmine', 1, [[timestamp]], 0),
(230, 1, 3, 'moodle/question:editall', 1, [[timestamp]], 0),
(231, 1, 1, 'moodle/question:editall', 1, [[timestamp]], 0),
(232, 1, 3, 'moodle/question:viewmine', 1, [[timestamp]], 0),
(233, 1, 1, 'moodle/question:viewmine', 1, [[timestamp]], 0),
(234, 1, 3, 'moodle/question:viewall', 1, [[timestamp]], 0),
(235, 1, 1, 'moodle/question:viewall', 1, [[timestamp]], 0),
(236, 1, 3, 'moodle/question:usemine', 1, [[timestamp]], 0),
(237, 1, 1, 'moodle/question:usemine', 1, [[timestamp]], 0),
(238, 1, 3, 'moodle/question:useall', 1, [[timestamp]], 0),
(239, 1, 1, 'moodle/question:useall', 1, [[timestamp]], 0),
(240, 1, 3, 'moodle/question:movemine', 1, [[timestamp]], 0),
(241, 1, 1, 'moodle/question:movemine', 1, [[timestamp]], 0),
(242, 1, 3, 'moodle/question:moveall', 1, [[timestamp]], 0),
(243, 1, 1, 'moodle/question:moveall', 1, [[timestamp]], 0),
(244, 1, 1, 'moodle/question:config', 1, [[timestamp]], 0),
(245, 1, 5, 'moodle/question:flag', 1, [[timestamp]], 0),
(246, 1, 4, 'moodle/question:flag', 1, [[timestamp]], 0),
(247, 1, 3, 'moodle/question:flag', 1, [[timestamp]], 0),
(248, 1, 1, 'moodle/question:flag', 1, [[timestamp]], 0),
(249, 1, 3, 'moodle/question:tagmine', 1, [[timestamp]], 0),
(250, 1, 1, 'moodle/question:tagmine', 1, [[timestamp]], 0),
(251, 1, 3, 'moodle/question:tagall', 1, [[timestamp]], 0),
(252, 1, 1, 'moodle/question:tagall', 1, [[timestamp]], 0),
(253, 1, 4, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(254, 1, 3, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(255, 1, 1, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(256, 1, 3, 'moodle/course:sectionvisibility', 1, [[timestamp]], 0),
(257, 1, 1, 'moodle/course:sectionvisibility', 1, [[timestamp]], 0),
(258, 1, 3, 'moodle/course:useremail', 1, [[timestamp]], 0),
(259, 1, 1, 'moodle/course:useremail', 1, [[timestamp]], 0),
(260, 1, 3, 'moodle/course:viewhiddensections', 1, [[timestamp]], 0),
(261, 1, 1, 'moodle/course:viewhiddensections', 1, [[timestamp]], 0),
(262, 1, 3, 'moodle/course:setcurrentsection', 1, [[timestamp]], 0),
(263, 1, 1, 'moodle/course:setcurrentsection', 1, [[timestamp]], 0),
(264, 1, 3, 'moodle/course:movesections', 1, [[timestamp]], 0),
(265, 1, 1, 'moodle/course:movesections', 1, [[timestamp]], 0),
(266, 1, 4, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(267, 1, 3, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(268, 1, 1, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(269, 1, 5, 'moodle/grade:view', 1, [[timestamp]], 0),
(270, 1, 4, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(271, 1, 3, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(272, 1, 1, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(273, 1, 3, 'moodle/grade:import', 1, [[timestamp]], 0),
(274, 1, 1, 'moodle/grade:import', 1, [[timestamp]], 0),
(275, 1, 4, 'moodle/grade:export', 1, [[timestamp]], 0),
(276, 1, 3, 'moodle/grade:export', 1, [[timestamp]], 0),
(277, 1, 1, 'moodle/grade:export', 1, [[timestamp]], 0),
(278, 1, 3, 'moodle/grade:manage', 1, [[timestamp]], 0),
(279, 1, 1, 'moodle/grade:manage', 1, [[timestamp]], 0),
(280, 1, 3, 'moodle/grade:edit', 1, [[timestamp]], 0),
(281, 1, 1, 'moodle/grade:edit', 1, [[timestamp]], 0),
(282, 1, 3, 'moodle/grade:managegradingforms', 1, [[timestamp]], 0),
(283, 1, 1, 'moodle/grade:managegradingforms', 1, [[timestamp]], 0),
(284, 1, 1, 'moodle/grade:sharegradingforms', 1, [[timestamp]], 0),
(285, 1, 1, 'moodle/grade:managesharedforms', 1, [[timestamp]], 0),
(286, 1, 3, 'moodle/grade:manageoutcomes', 1, [[timestamp]], 0),
(287, 1, 1, 'moodle/grade:manageoutcomes', 1, [[timestamp]], 0),
(288, 1, 3, 'moodle/grade:manageletters', 1, [[timestamp]], 0),
(289, 1, 1, 'moodle/grade:manageletters', 1, [[timestamp]], 0),
(290, 1, 3, 'moodle/grade:hide', 1, [[timestamp]], 0),
(291, 1, 1, 'moodle/grade:hide', 1, [[timestamp]], 0),
(292, 1, 3, 'moodle/grade:lock', 1, [[timestamp]], 0),
(293, 1, 1, 'moodle/grade:lock', 1, [[timestamp]], 0),
(294, 1, 3, 'moodle/grade:unlock', 1, [[timestamp]], 0),
(295, 1, 1, 'moodle/grade:unlock', 1, [[timestamp]], 0),
(296, 1, 7, 'moodle/my:manageblocks', 1, [[timestamp]], 0),
(297, 1, 4, 'moodle/notes:view', 1, [[timestamp]], 0),
(298, 1, 3, 'moodle/notes:view', 1, [[timestamp]], 0),
(299, 1, 1, 'moodle/notes:view', 1, [[timestamp]], 0),
(300, 1, 4, 'moodle/notes:manage', 1, [[timestamp]], 0),
(301, 1, 3, 'moodle/notes:manage', 1, [[timestamp]], 0),
(302, 1, 1, 'moodle/notes:manage', 1, [[timestamp]], 0),
(303, 1, 1, 'moodle/tag:manage', 1, [[timestamp]], 0),
(304, 1, 1, 'moodle/tag:edit', 1, [[timestamp]], 0),
(305, 1, 7, 'moodle/tag:flag', 1, [[timestamp]], 0),
(306, 1, 4, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(307, 1, 3, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(308, 1, 1, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(309, 1, 6, 'moodle/block:view', 1, [[timestamp]], 0),
(310, 1, 7, 'moodle/block:view', 1, [[timestamp]], 0),
(311, 1, 5, 'moodle/block:view', 1, [[timestamp]], 0),
(312, 1, 4, 'moodle/block:view', 1, [[timestamp]], 0),
(313, 1, 3, 'moodle/block:view', 1, [[timestamp]], 0),
(314, 1, 3, 'moodle/block:edit', 1, [[timestamp]], 0),
(315, 1, 1, 'moodle/block:edit', 1, [[timestamp]], 0),
(316, 1, 7, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(317, 1, 5, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(318, 1, 4, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(319, 1, 3, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(320, 1, 8, 'moodle/comment:view', 1, [[timestamp]], 0),
(321, 1, 6, 'moodle/comment:view', 1, [[timestamp]], 0),
(322, 1, 7, 'moodle/comment:view', 1, [[timestamp]], 0),
(323, 1, 5, 'moodle/comment:view', 1, [[timestamp]], 0),
(324, 1, 4, 'moodle/comment:view', 1, [[timestamp]], 0),
(325, 1, 3, 'moodle/comment:view', 1, [[timestamp]], 0),
(326, 1, 1, 'moodle/comment:view', 1, [[timestamp]], 0),
(327, 1, 7, 'moodle/comment:post', 1, [[timestamp]], 0),
(328, 1, 5, 'moodle/comment:post', 1, [[timestamp]], 0),
(329, 1, 4, 'moodle/comment:post', 1, [[timestamp]], 0),
(330, 1, 3, 'moodle/comment:post', 1, [[timestamp]], 0),
(331, 1, 1, 'moodle/comment:post', 1, [[timestamp]], 0),
(332, 1, 3, 'moodle/comment:delete', 1, [[timestamp]], 0),
(333, 1, 1, 'moodle/comment:delete', 1, [[timestamp]], 0),
(334, 1, 1, 'moodle/webservice:createtoken', 1, [[timestamp]], 0),
(335, 1, 7, 'moodle/webservice:createmobiletoken', 1, [[timestamp]], 0),
(336, 1, 7, 'moodle/rating:view', 1, [[timestamp]], 0),
(337, 1, 5, 'moodle/rating:view', 1, [[timestamp]], 0),
(338, 1, 4, 'moodle/rating:view', 1, [[timestamp]], 0),
(339, 1, 3, 'moodle/rating:view', 1, [[timestamp]], 0),
(340, 1, 1, 'moodle/rating:view', 1, [[timestamp]], 0),
(341, 1, 7, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(342, 1, 5, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(343, 1, 4, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(344, 1, 3, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(345, 1, 1, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(346, 1, 7, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(347, 1, 5, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(348, 1, 4, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(349, 1, 3, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(350, 1, 1, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(351, 1, 7, 'moodle/rating:rate', 1, [[timestamp]], 0),
(352, 1, 5, 'moodle/rating:rate', 1, [[timestamp]], 0),
(353, 1, 4, 'moodle/rating:rate', 1, [[timestamp]], 0),
(354, 1, 3, 'moodle/rating:rate', 1, [[timestamp]], 0),
(355, 1, 1, 'moodle/rating:rate', 1, [[timestamp]], 0),
(356, 1, 4, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(357, 1, 3, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(358, 1, 1, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(359, 1, 4, 'moodle/course:overridecompletion', 1, [[timestamp]], 0),
(360, 1, 3, 'moodle/course:overridecompletion', 1, [[timestamp]], 0),
(361, 1, 1, 'moodle/course:overridecompletion', 1, [[timestamp]], 0),
(362, 1, 1, 'moodle/badges:manageglobalsettings', 1, [[timestamp]], 0),
(363, 1, 7, 'moodle/badges:viewbadges', 1, [[timestamp]], 0),
(364, 1, 7, 'moodle/badges:manageownbadges', 1, [[timestamp]], 0),
(365, 1, 7, 'moodle/badges:viewotherbadges', 1, [[timestamp]], 0),
(366, 1, 7, 'moodle/badges:earnbadge', 1, [[timestamp]], 0),
(367, 1, 1, 'moodle/badges:createbadge', 1, [[timestamp]], 0),
(368, 1, 3, 'moodle/badges:createbadge', 1, [[timestamp]], 0),
(369, 1, 1, 'moodle/badges:deletebadge', 1, [[timestamp]], 0),
(370, 1, 3, 'moodle/badges:deletebadge', 1, [[timestamp]], 0),
(371, 1, 1, 'moodle/badges:configuredetails', 1, [[timestamp]], 0),
(372, 1, 3, 'moodle/badges:configuredetails', 1, [[timestamp]], 0),
(373, 1, 1, 'moodle/badges:configurecriteria', 1, [[timestamp]], 0),
(374, 1, 3, 'moodle/badges:configurecriteria', 1, [[timestamp]], 0),
(375, 1, 1, 'moodle/badges:configuremessages', 1, [[timestamp]], 0),
(376, 1, 3, 'moodle/badges:configuremessages', 1, [[timestamp]], 0),
(377, 1, 1, 'moodle/badges:awardbadge', 1, [[timestamp]], 0),
(378, 1, 4, 'moodle/badges:awardbadge', 1, [[timestamp]], 0),
(379, 1, 3, 'moodle/badges:awardbadge', 1, [[timestamp]], 0),
(380, 1, 1, 'moodle/badges:revokebadge', 1, [[timestamp]], 0),
(381, 1, 4, 'moodle/badges:revokebadge', 1, [[timestamp]], 0),
(382, 1, 3, 'moodle/badges:revokebadge', 1, [[timestamp]], 0),
(383, 1, 1, 'moodle/badges:viewawarded', 1, [[timestamp]], 0),
(384, 1, 4, 'moodle/badges:viewawarded', 1, [[timestamp]], 0),
(385, 1, 3, 'moodle/badges:viewawarded', 1, [[timestamp]], 0),
(386, 1, 6, 'moodle/search:query', 1, [[timestamp]], 0),
(387, 1, 7, 'moodle/search:query', 1, [[timestamp]], 0),
(388, 1, 5, 'moodle/search:query', 1, [[timestamp]], 0),
(389, 1, 4, 'moodle/search:query', 1, [[timestamp]], 0),
(390, 1, 3, 'moodle/search:query', 1, [[timestamp]], 0),
(391, 1, 1, 'moodle/search:query', 1, [[timestamp]], 0),
(392, 1, 1, 'moodle/competency:competencymanage', 1, [[timestamp]], 0),
(393, 1, 7, 'moodle/competency:competencyview', 1, [[timestamp]], 0),
(394, 1, 3, 'moodle/competency:competencygrade', 1, [[timestamp]], 0),
(395, 1, 4, 'moodle/competency:competencygrade', 1, [[timestamp]], 0),
(396, 1, 1, 'moodle/competency:competencygrade', 1, [[timestamp]], 0),
(397, 1, 3, 'moodle/competency:coursecompetencymanage', 1, [[timestamp]], 0),
(398, 1, 1, 'moodle/competency:coursecompetencymanage', 1, [[timestamp]], 0),
(399, 1, 1, 'moodle/competency:coursecompetencyconfigure', 1, [[timestamp]], 0),
(400, 1, 5, 'moodle/competency:coursecompetencygradable', 1, [[timestamp]], 0),
(401, 1, 7, 'moodle/competency:coursecompetencyview', 1, [[timestamp]], 0),
(402, 1, 1, 'moodle/competency:planmanage', 1, [[timestamp]], 0),
(403, 1, 1, 'moodle/competency:planmanagedraft', 1, [[timestamp]], 0),
(404, 1, 1, 'moodle/competency:planview', 1, [[timestamp]], 0),
(405, 1, 1, 'moodle/competency:planviewdraft', 1, [[timestamp]], 0),
(406, 1, 7, 'moodle/competency:planviewown', 1, [[timestamp]], 0),
(407, 1, 1, 'moodle/competency:planrequestreview', 1, [[timestamp]], 0),
(408, 1, 7, 'moodle/competency:planrequestreviewown', 1, [[timestamp]], 0),
(409, 1, 1, 'moodle/competency:planreview', 1, [[timestamp]], 0),
(410, 1, 1, 'moodle/competency:plancomment', 1, [[timestamp]], 0),
(411, 1, 7, 'moodle/competency:plancommentown', 1, [[timestamp]], 0),
(412, 1, 1, 'moodle/competency:usercompetencyview', 1, [[timestamp]], 0),
(413, 1, 3, 'moodle/competency:usercompetencyview', 1, [[timestamp]], 0),
(414, 1, 4, 'moodle/competency:usercompetencyview', 1, [[timestamp]], 0),
(415, 1, 1, 'moodle/competency:usercompetencyrequestreview', 1, [[timestamp]], 0),
(416, 1, 7, 'moodle/competency:usercompetencyrequestreviewown', 1, [[timestamp]], 0),
(417, 1, 1, 'moodle/competency:usercompetencyreview', 1, [[timestamp]], 0),
(418, 1, 1, 'moodle/competency:usercompetencycomment', 1, [[timestamp]], 0),
(419, 1, 7, 'moodle/competency:usercompetencycommentown', 1, [[timestamp]], 0),
(420, 1, 1, 'moodle/competency:templatemanage', 1, [[timestamp]], 0),
(421, 1, 4, 'moodle/analytics:listinsights', 1, [[timestamp]], 0),
(422, 1, 3, 'moodle/analytics:listinsights', 1, [[timestamp]], 0),
(423, 1, 1, 'moodle/analytics:listinsights', 1, [[timestamp]], 0),
(424, 1, 1, 'moodle/analytics:managemodels', 1, [[timestamp]], 0),
(425, 1, 1, 'moodle/competency:templateview', 1, [[timestamp]], 0),
(426, 1, 1, 'moodle/competency:userevidencemanage', 1, [[timestamp]], 0),
(427, 1, 7, 'moodle/competency:userevidencemanageown', 1, [[timestamp]], 0),
(428, 1, 1, 'moodle/competency:userevidenceview', 1, [[timestamp]], 0),
(429, 1, 4, 'moodle/site:messageanyuser', 1, [[timestamp]], 0),
(430, 1, 3, 'moodle/site:messageanyuser', 1, [[timestamp]], 0),
(431, 1, 1, 'moodle/site:messageanyuser', 1, [[timestamp]], 0),
(432, 1, 7, 'moodle/course:togglecompletion', 1, [[timestamp]], 0),
(433, 1, 7, 'moodle/analytics:listowninsights', 1, [[timestamp]], 0),
(434, 1, 3, 'moodle/h5p:setdisplayoptions', 1, [[timestamp]], 0),
(435, 1, 1, 'moodle/h5p:deploy', 1, [[timestamp]], 0),
(436, 1, 3, 'moodle/h5p:deploy', 1, [[timestamp]], 0),
(437, 1, 1, 'moodle/h5p:updatelibraries', 1, [[timestamp]], 0),
(438, 1, 1, 'moodle/course:recommendactivity', 1, [[timestamp]], 0),
(439, 1, 1, 'moodle/contentbank:access', 1, [[timestamp]], 0),
(440, 1, 2, 'moodle/contentbank:access', 1, [[timestamp]], 0),
(441, 1, 3, 'moodle/contentbank:access', 1, [[timestamp]], 0),
(442, 1, 1, 'moodle/contentbank:upload', 1, [[timestamp]], 0),
(443, 1, 2, 'moodle/contentbank:upload', 1, [[timestamp]], 0),
(444, 1, 3, 'moodle/contentbank:upload', 1, [[timestamp]], 0),
(445, 1, 1, 'moodle/contentbank:deleteanycontent', 1, [[timestamp]], 0),
(446, 1, 2, 'moodle/contentbank:deleteanycontent', 1, [[timestamp]], 0),
(447, 1, 7, 'moodle/contentbank:deleteowncontent', 1, [[timestamp]], 0),
(448, 1, 1, 'moodle/contentbank:manageanycontent', 1, [[timestamp]], 0),
(449, 1, 2, 'moodle/contentbank:manageanycontent', 1, [[timestamp]], 0),
(450, 1, 1, 'moodle/contentbank:manageowncontent', 1, [[timestamp]], 0),
(451, 1, 2, 'moodle/contentbank:manageowncontent', 1, [[timestamp]], 0),
(452, 1, 3, 'moodle/contentbank:manageowncontent', 1, [[timestamp]], 0),
(453, 1, 1, 'moodle/contentbank:useeditor', 1, [[timestamp]], 0),
(454, 1, 2, 'moodle/contentbank:useeditor', 1, [[timestamp]], 0),
(455, 1, 3, 'moodle/contentbank:useeditor', 1, [[timestamp]], 0),
(456, 1, 1, 'moodle/contentbank:downloadcontent', 1, [[timestamp]], 0),
(457, 1, 2, 'moodle/contentbank:downloadcontent', 1, [[timestamp]], 0),
(458, 1, 3, 'moodle/contentbank:downloadcontent', 1, [[timestamp]], 0),
(459, 1, 5, 'moodle/course:downloadcoursecontent', 1, [[timestamp]], 0),
(460, 1, 4, 'moodle/course:downloadcoursecontent', 1, [[timestamp]], 0),
(461, 1, 3, 'moodle/course:downloadcoursecontent', 1, [[timestamp]], 0),
(462, 1, 1, 'moodle/course:downloadcoursecontent', 1, [[timestamp]], 0),
(463, 1, 3, 'moodle/course:configuredownloadcontent', 1, [[timestamp]], 0),
(464, 1, 1, 'moodle/course:configuredownloadcontent', 1, [[timestamp]], 0),
(465, 1, 1, 'moodle/contentbank:viewunlistedcontent', 1, [[timestamp]], 0),
(466, 1, 2, 'moodle/contentbank:viewunlistedcontent', 1, [[timestamp]], 0),
(467, 1, 6, 'mod/assign:view', 1, [[timestamp]], 0),
(468, 1, 5, 'mod/assign:view', 1, [[timestamp]], 0),
(469, 1, 4, 'mod/assign:view', 1, [[timestamp]], 0),
(470, 1, 3, 'mod/assign:view', 1, [[timestamp]], 0),
(471, 1, 1, 'mod/assign:view', 1, [[timestamp]], 0),
(472, 1, 5, 'mod/assign:submit', 1, [[timestamp]], 0),
(473, 1, 4, 'mod/assign:grade', 1, [[timestamp]], 0),
(474, 1, 3, 'mod/assign:grade', 1, [[timestamp]], 0),
(475, 1, 1, 'mod/assign:grade', 1, [[timestamp]], 0),
(476, 1, 4, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(477, 1, 3, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(478, 1, 1, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(479, 1, 5, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(480, 1, 3, 'mod/assign:addinstance', 1, [[timestamp]], 0),
(481, 1, 1, 'mod/assign:addinstance', 1, [[timestamp]], 0),
(482, 1, 4, 'mod/assign:grantextension', 1, [[timestamp]], 0),
(483, 1, 3, 'mod/assign:grantextension', 1, [[timestamp]], 0),
(484, 1, 1, 'mod/assign:grantextension', 1, [[timestamp]], 0),
(485, 1, 3, 'mod/assign:revealidentities', 1, [[timestamp]], 0),
(486, 1, 1, 'mod/assign:revealidentities', 1, [[timestamp]], 0),
(487, 1, 3, 'mod/assign:reviewgrades', 1, [[timestamp]], 0),
(488, 1, 1, 'mod/assign:reviewgrades', 1, [[timestamp]], 0),
(489, 1, 3, 'mod/assign:releasegrades', 1, [[timestamp]], 0),
(490, 1, 1, 'mod/assign:releasegrades', 1, [[timestamp]], 0),
(491, 1, 3, 'mod/assign:managegrades', 1, [[timestamp]], 0),
(492, 1, 1, 'mod/assign:managegrades', 1, [[timestamp]], 0),
(493, 1, 3, 'mod/assign:manageallocations', 1, [[timestamp]], 0),
(494, 1, 1, 'mod/assign:manageallocations', 1, [[timestamp]], 0),
(495, 1, 3, 'mod/assign:viewgrades', 1, [[timestamp]], 0),
(496, 1, 1, 'mod/assign:viewgrades', 1, [[timestamp]], 0),
(497, 1, 4, 'mod/assign:viewgrades', 1, [[timestamp]], 0),
(498, 1, 1, 'mod/assign:viewblinddetails', 1, [[timestamp]], 0),
(499, 1, 4, 'mod/assign:receivegradernotifications', 1, [[timestamp]], 0),
(500, 1, 3, 'mod/assign:receivegradernotifications', 1, [[timestamp]], 0),
(501, 1, 1, 'mod/assign:receivegradernotifications', 1, [[timestamp]], 0),
(502, 1, 3, 'mod/assign:manageoverrides', 1, [[timestamp]], 0),
(503, 1, 1, 'mod/assign:manageoverrides', 1, [[timestamp]], 0),
(504, 1, 4, 'mod/assign:showhiddengrader', 1, [[timestamp]], 0),
(505, 1, 3, 'mod/assign:showhiddengrader', 1, [[timestamp]], 0),
(506, 1, 1, 'mod/assign:showhiddengrader', 1, [[timestamp]], 0),
(507, 1, 5, 'mod/assign:viewownsubmissionsummary', 1, [[timestamp]], 0),
(508, 1, 6, 'mod/assignment:view', 1, [[timestamp]], 0),
(509, 1, 5, 'mod/assignment:view', 1, [[timestamp]], 0),
(510, 1, 4, 'mod/assignment:view', 1, [[timestamp]], 0),
(511, 1, 3, 'mod/assignment:view', 1, [[timestamp]], 0),
(512, 1, 1, 'mod/assignment:view', 1, [[timestamp]], 0),
(513, 1, 3, 'mod/assignment:addinstance', 1, [[timestamp]], 0),
(514, 1, 1, 'mod/assignment:addinstance', 1, [[timestamp]], 0),
(515, 1, 5, 'mod/assignment:submit', 1, [[timestamp]], 0),
(516, 1, 4, 'mod/assignment:grade', 1, [[timestamp]], 0),
(517, 1, 3, 'mod/assignment:grade', 1, [[timestamp]], 0),
(518, 1, 1, 'mod/assignment:grade', 1, [[timestamp]], 0),
(519, 1, 4, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(520, 1, 3, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(521, 1, 1, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(522, 1, 5, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(523, 1, 3, 'mod/book:addinstance', 1, [[timestamp]], 0),
(524, 1, 1, 'mod/book:addinstance', 1, [[timestamp]], 0),
(525, 1, 6, 'mod/book:read', 1, [[timestamp]], 0),
(526, 1, 8, 'mod/book:read', 1, [[timestamp]], 0),
(527, 1, 5, 'mod/book:read', 1, [[timestamp]], 0),
(528, 1, 4, 'mod/book:read', 1, [[timestamp]], 0),
(529, 1, 3, 'mod/book:read', 1, [[timestamp]], 0),
(530, 1, 1, 'mod/book:read', 1, [[timestamp]], 0),
(531, 1, 4, 'mod/book:viewhiddenchapters', 1, [[timestamp]], 0),
(532, 1, 3, 'mod/book:viewhiddenchapters', 1, [[timestamp]], 0),
(533, 1, 1, 'mod/book:viewhiddenchapters', 1, [[timestamp]], 0),
(534, 1, 3, 'mod/book:edit', 1, [[timestamp]], 0),
(535, 1, 1, 'mod/book:edit', 1, [[timestamp]], 0),
(536, 1, 3, 'mod/chat:addinstance', 1, [[timestamp]], 0),
(537, 1, 1, 'mod/chat:addinstance', 1, [[timestamp]], 0),
(538, 1, 5, 'mod/chat:chat', 1, [[timestamp]], 0),
(539, 1, 4, 'mod/chat:chat', 1, [[timestamp]], 0),
(540, 1, 3, 'mod/chat:chat', 1, [[timestamp]], 0),
(541, 1, 1, 'mod/chat:chat', 1, [[timestamp]], 0),
(542, 1, 5, 'mod/chat:readlog', 1, [[timestamp]], 0),
(543, 1, 4, 'mod/chat:readlog', 1, [[timestamp]], 0),
(544, 1, 3, 'mod/chat:readlog', 1, [[timestamp]], 0),
(545, 1, 1, 'mod/chat:readlog', 1, [[timestamp]], 0),
(546, 1, 4, 'mod/chat:deletelog', 1, [[timestamp]], 0),
(547, 1, 3, 'mod/chat:deletelog', 1, [[timestamp]], 0),
(548, 1, 1, 'mod/chat:deletelog', 1, [[timestamp]], 0),
(549, 1, 4, 'mod/chat:exportparticipatedsession', 1, [[timestamp]], 0),
(550, 1, 3, 'mod/chat:exportparticipatedsession', 1, [[timestamp]], 0),
(551, 1, 1, 'mod/chat:exportparticipatedsession', 1, [[timestamp]], 0),
(552, 1, 4, 'mod/chat:exportsession', 1, [[timestamp]], 0),
(553, 1, 3, 'mod/chat:exportsession', 1, [[timestamp]], 0),
(554, 1, 1, 'mod/chat:exportsession', 1, [[timestamp]], 0),
(555, 1, 7, 'mod/chat:view', 1, [[timestamp]], 0),
(556, 1, 6, 'mod/chat:view', 1, [[timestamp]], 0),
(557, 1, 3, 'mod/choice:addinstance', 1, [[timestamp]], 0),
(558, 1, 1, 'mod/choice:addinstance', 1, [[timestamp]], 0),
(559, 1, 5, 'mod/choice:choose', 1, [[timestamp]], 0),
(560, 1, 4, 'mod/choice:choose', 1, [[timestamp]], 0),
(561, 1, 3, 'mod/choice:choose', 1, [[timestamp]], 0),
(562, 1, 4, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(563, 1, 3, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(564, 1, 1, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(565, 1, 4, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(566, 1, 3, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(567, 1, 1, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(568, 1, 4, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(569, 1, 3, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(570, 1, 1, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(571, 1, 7, 'mod/choice:view', 1, [[timestamp]], 0),
(572, 1, 6, 'mod/choice:view', 1, [[timestamp]], 0),
(573, 1, 3, 'mod/data:addinstance', 1, [[timestamp]], 0),
(574, 1, 1, 'mod/data:addinstance', 1, [[timestamp]], 0),
(575, 1, 8, 'mod/data:viewentry', 1, [[timestamp]], 0),
(576, 1, 6, 'mod/data:viewentry', 1, [[timestamp]], 0),
(577, 1, 5, 'mod/data:viewentry', 1, [[timestamp]], 0),
(578, 1, 4, 'mod/data:viewentry', 1, [[timestamp]], 0),
(579, 1, 3, 'mod/data:viewentry', 1, [[timestamp]], 0),
(580, 1, 1, 'mod/data:viewentry', 1, [[timestamp]], 0),
(581, 1, 5, 'mod/data:writeentry', 1, [[timestamp]], 0),
(582, 1, 4, 'mod/data:writeentry', 1, [[timestamp]], 0),
(583, 1, 3, 'mod/data:writeentry', 1, [[timestamp]], 0),
(584, 1, 1, 'mod/data:writeentry', 1, [[timestamp]], 0),
(585, 1, 5, 'mod/data:comment', 1, [[timestamp]], 0),
(586, 1, 4, 'mod/data:comment', 1, [[timestamp]], 0),
(587, 1, 3, 'mod/data:comment', 1, [[timestamp]], 0),
(588, 1, 1, 'mod/data:comment', 1, [[timestamp]], 0),
(589, 1, 4, 'mod/data:rate', 1, [[timestamp]], 0),
(590, 1, 3, 'mod/data:rate', 1, [[timestamp]], 0),
(591, 1, 1, 'mod/data:rate', 1, [[timestamp]], 0),
(592, 1, 4, 'mod/data:viewrating', 1, [[timestamp]], 0),
(593, 1, 3, 'mod/data:viewrating', 1, [[timestamp]], 0),
(594, 1, 1, 'mod/data:viewrating', 1, [[timestamp]], 0),
(595, 1, 4, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(596, 1, 3, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(597, 1, 1, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(598, 1, 4, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(599, 1, 3, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(600, 1, 1, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(601, 1, 4, 'mod/data:approve', 1, [[timestamp]], 0),
(602, 1, 3, 'mod/data:approve', 1, [[timestamp]], 0),
(603, 1, 1, 'mod/data:approve', 1, [[timestamp]], 0),
(604, 1, 4, 'mod/data:manageentries', 1, [[timestamp]], 0),
(605, 1, 3, 'mod/data:manageentries', 1, [[timestamp]], 0),
(606, 1, 1, 'mod/data:manageentries', 1, [[timestamp]], 0),
(607, 1, 4, 'mod/data:managecomments', 1, [[timestamp]], 0),
(608, 1, 3, 'mod/data:managecomments', 1, [[timestamp]], 0),
(609, 1, 1, 'mod/data:managecomments', 1, [[timestamp]], 0),
(610, 1, 3, 'mod/data:managetemplates', 1, [[timestamp]], 0),
(611, 1, 1, 'mod/data:managetemplates', 1, [[timestamp]], 0),
(612, 1, 4, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(613, 1, 3, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(614, 1, 1, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(615, 1, 1, 'mod/data:manageuserpresets', 1, [[timestamp]], 0),
(616, 1, 1, 'mod/data:exportentry', 1, [[timestamp]], 0),
(617, 1, 4, 'mod/data:exportentry', 1, [[timestamp]], 0),
(618, 1, 3, 'mod/data:exportentry', 1, [[timestamp]], 0),
(619, 1, 1, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(620, 1, 4, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(621, 1, 3, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(622, 1, 5, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(623, 1, 1, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(624, 1, 4, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(625, 1, 3, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(626, 1, 1, 'mod/data:exportuserinfo', 1, [[timestamp]], 0),
(627, 1, 4, 'mod/data:exportuserinfo', 1, [[timestamp]], 0),
(628, 1, 3, 'mod/data:exportuserinfo', 1, [[timestamp]], 0),
(629, 1, 6, 'mod/data:view', 1, [[timestamp]], 0),
(630, 1, 5, 'mod/data:view', 1, [[timestamp]], 0),
(631, 1, 4, 'mod/data:view', 1, [[timestamp]], 0),
(632, 1, 3, 'mod/data:view', 1, [[timestamp]], 0),
(633, 1, 1, 'mod/data:view', 1, [[timestamp]], 0),
(634, 1, 3, 'mod/feedback:addinstance', 1, [[timestamp]], 0),
(635, 1, 1, 'mod/feedback:addinstance', 1, [[timestamp]], 0),
(636, 1, 6, 'mod/feedback:view', 1, [[timestamp]], 0),
(637, 1, 8, 'mod/feedback:view', 1, [[timestamp]], 0),
(638, 1, 5, 'mod/feedback:view', 1, [[timestamp]], 0),
(639, 1, 4, 'mod/feedback:view', 1, [[timestamp]], 0),
(640, 1, 3, 'mod/feedback:view', 1, [[timestamp]], 0),
(641, 1, 1, 'mod/feedback:view', 1, [[timestamp]], 0),
(642, 1, 8, 'mod/feedback:complete', 1, [[timestamp]], 0),
(643, 1, 5, 'mod/feedback:complete', 1, [[timestamp]], 0),
(644, 1, 5, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(645, 1, 3, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(646, 1, 1, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(647, 1, 3, 'mod/feedback:deletesubmissions', 1, [[timestamp]], 0),
(648, 1, 1, 'mod/feedback:deletesubmissions', 1, [[timestamp]], 0),
(649, 1, 1, 'mod/feedback:mapcourse', 1, [[timestamp]], 0),
(650, 1, 3, 'mod/feedback:edititems', 1, [[timestamp]], 0),
(651, 1, 1, 'mod/feedback:edititems', 1, [[timestamp]], 0),
(652, 1, 3, 'mod/feedback:createprivatetemplate', 1, [[timestamp]], 0),
(653, 1, 1, 'mod/feedback:createprivatetemplate', 1, [[timestamp]], 0),
(654, 1, 3, 'mod/feedback:createpublictemplate', 1, [[timestamp]], 0),
(655, 1, 1, 'mod/feedback:createpublictemplate', 1, [[timestamp]], 0),
(656, 1, 3, 'mod/feedback:deletetemplate', 1, [[timestamp]], 0),
(657, 1, 1, 'mod/feedback:deletetemplate', 1, [[timestamp]], 0),
(658, 1, 4, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(659, 1, 3, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(660, 1, 1, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(661, 1, 4, 'mod/feedback:receivemail', 1, [[timestamp]], 0),
(662, 1, 3, 'mod/feedback:receivemail', 1, [[timestamp]], 0),
(663, 1, 3, 'mod/folder:addinstance', 1, [[timestamp]], 0),
(664, 1, 1, 'mod/folder:addinstance', 1, [[timestamp]], 0),
(665, 1, 6, 'mod/folder:view', 1, [[timestamp]], 0),
(666, 1, 7, 'mod/folder:view', 1, [[timestamp]], 0),
(667, 1, 3, 'mod/folder:managefiles', 1, [[timestamp]], 0),
(668, 1, 3, 'mod/forum:addinstance', 1, [[timestamp]], 0),
(669, 1, 1, 'mod/forum:addinstance', 1, [[timestamp]], 0),
(670, 1, 8, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(671, 1, 6, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(672, 1, 5, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(673, 1, 4, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(674, 1, 3, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(675, 1, 1, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(676, 1, 4, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(677, 1, 3, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(678, 1, 1, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(679, 1, 5, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(680, 1, 4, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(681, 1, 3, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(682, 1, 1, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(683, 1, 5, 'mod/forum:replypost', 1, [[timestamp]], 0),
(684, 1, 4, 'mod/forum:replypost', 1, [[timestamp]], 0),
(685, 1, 3, 'mod/forum:replypost', 1, [[timestamp]], 0),
(686, 1, 1, 'mod/forum:replypost', 1, [[timestamp]], 0),
(687, 1, 4, 'mod/forum:addnews', 1, [[timestamp]], 0),
(688, 1, 3, 'mod/forum:addnews', 1, [[timestamp]], 0),
(689, 1, 1, 'mod/forum:addnews', 1, [[timestamp]], 0),
(690, 1, 4, 'mod/forum:replynews', 1, [[timestamp]], 0),
(691, 1, 3, 'mod/forum:replynews', 1, [[timestamp]], 0),
(692, 1, 1, 'mod/forum:replynews', 1, [[timestamp]], 0),
(693, 1, 5, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(694, 1, 4, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(695, 1, 3, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(696, 1, 1, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(697, 1, 4, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(698, 1, 3, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(699, 1, 1, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(700, 1, 4, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(701, 1, 3, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(702, 1, 1, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(703, 1, 4, 'mod/forum:rate', 1, [[timestamp]], 0),
(704, 1, 3, 'mod/forum:rate', 1, [[timestamp]], 0),
(705, 1, 1, 'mod/forum:rate', 1, [[timestamp]], 0),
(706, 1, 4, 'mod/forum:postprivatereply', 1, [[timestamp]], 0),
(707, 1, 3, 'mod/forum:postprivatereply', 1, [[timestamp]], 0),
(708, 1, 1, 'mod/forum:postprivatereply', 1, [[timestamp]], 0),
(709, 1, 4, 'mod/forum:readprivatereplies', 1, [[timestamp]], 0),
(710, 1, 3, 'mod/forum:readprivatereplies', 1, [[timestamp]], 0),
(711, 1, 1, 'mod/forum:readprivatereplies', 1, [[timestamp]], 0),
(712, 1, 5, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(713, 1, 4, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(714, 1, 3, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(715, 1, 1, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(716, 1, 5, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(717, 1, 4, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(718, 1, 3, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(719, 1, 1, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(720, 1, 4, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(721, 1, 3, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(722, 1, 1, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(723, 1, 4, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(724, 1, 3, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(725, 1, 1, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(726, 1, 4, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(727, 1, 3, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(728, 1, 1, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(729, 1, 4, 'mod/forum:pindiscussions', 1, [[timestamp]], 0),
(730, 1, 3, 'mod/forum:pindiscussions', 1, [[timestamp]], 0),
(731, 1, 1, 'mod/forum:pindiscussions', 1, [[timestamp]], 0),
(732, 1, 4, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(733, 1, 3, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(734, 1, 1, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(735, 1, 4, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(736, 1, 3, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(737, 1, 1, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(738, 1, 4, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(739, 1, 3, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(740, 1, 1, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(741, 1, 4, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(742, 1, 3, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(743, 1, 1, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(744, 1, 4, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(745, 1, 3, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(746, 1, 1, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(747, 1, 4, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(748, 1, 3, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(749, 1, 1, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(750, 1, 4, 'mod/forum:exportforum', 1, [[timestamp]], 0),
(751, 1, 3, 'mod/forum:exportforum', 1, [[timestamp]], 0),
(752, 1, 1, 'mod/forum:exportforum', 1, [[timestamp]], 0),
(753, 1, 4, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(754, 1, 3, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(755, 1, 1, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(756, 1, 4, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(757, 1, 3, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(758, 1, 1, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(759, 1, 5, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(760, 1, 4, 'mod/forum:addquestion', 1, [[timestamp]], 0),
(761, 1, 3, 'mod/forum:addquestion', 1, [[timestamp]], 0),
(762, 1, 1, 'mod/forum:addquestion', 1, [[timestamp]], 0),
(763, 1, 5, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(764, 1, 4, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(765, 1, 3, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(766, 1, 8, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(767, 1, 4, 'mod/forum:canposttomygroups', 1, [[timestamp]], 0),
(768, 1, 3, 'mod/forum:canposttomygroups', 1, [[timestamp]], 0),
(769, 1, 1, 'mod/forum:canposttomygroups', 1, [[timestamp]], 0),
(770, 1, 4, 'mod/forum:canoverridediscussionlock', 1, [[timestamp]], 0),
(771, 1, 3, 'mod/forum:canoverridediscussionlock', 1, [[timestamp]], 0),
(772, 1, 1, 'mod/forum:canoverridediscussionlock', 1, [[timestamp]], 0),
(773, 1, 4, 'mod/forum:canoverridecutoff', 1, [[timestamp]], 0),
(774, 1, 3, 'mod/forum:canoverridecutoff', 1, [[timestamp]], 0),
(775, 1, 1, 'mod/forum:canoverridecutoff', 1, [[timestamp]], 0),
(776, 1, 7, 'mod/forum:cantogglefavourite', 1, [[timestamp]], 0),
(777, 1, 4, 'mod/forum:grade', 1, [[timestamp]], 0),
(778, 1, 3, 'mod/forum:grade', 1, [[timestamp]], 0),
(779, 1, 1, 'mod/forum:grade', 1, [[timestamp]], 0),
(780, 1, 3, 'mod/glossary:addinstance', 1, [[timestamp]], 0),
(781, 1, 1, 'mod/glossary:addinstance', 1, [[timestamp]], 0),
(782, 1, 8, 'mod/glossary:view', 1, [[timestamp]], 0),
(783, 1, 6, 'mod/glossary:view', 1, [[timestamp]], 0),
(784, 1, 5, 'mod/glossary:view', 1, [[timestamp]], 0),
(785, 1, 4, 'mod/glossary:view', 1, [[timestamp]], 0),
(786, 1, 3, 'mod/glossary:view', 1, [[timestamp]], 0),
(787, 1, 1, 'mod/glossary:view', 1, [[timestamp]], 0),
(788, 1, 5, 'mod/glossary:write', 1, [[timestamp]], 0),
(789, 1, 4, 'mod/glossary:write', 1, [[timestamp]], 0),
(790, 1, 3, 'mod/glossary:write', 1, [[timestamp]], 0),
(791, 1, 1, 'mod/glossary:write', 1, [[timestamp]], 0),
(792, 1, 4, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(793, 1, 3, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(794, 1, 1, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(795, 1, 4, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(796, 1, 3, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(797, 1, 1, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(798, 1, 5, 'mod/glossary:comment', 1, [[timestamp]], 0),
(799, 1, 4, 'mod/glossary:comment', 1, [[timestamp]], 0),
(800, 1, 3, 'mod/glossary:comment', 1, [[timestamp]], 0),
(801, 1, 1, 'mod/glossary:comment', 1, [[timestamp]], 0),
(802, 1, 4, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(803, 1, 3, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(804, 1, 1, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(805, 1, 4, 'mod/glossary:import', 1, [[timestamp]], 0),
(806, 1, 3, 'mod/glossary:import', 1, [[timestamp]], 0),
(807, 1, 1, 'mod/glossary:import', 1, [[timestamp]], 0),
(808, 1, 4, 'mod/glossary:export', 1, [[timestamp]], 0),
(809, 1, 3, 'mod/glossary:export', 1, [[timestamp]], 0),
(810, 1, 1, 'mod/glossary:export', 1, [[timestamp]], 0),
(811, 1, 4, 'mod/glossary:approve', 1, [[timestamp]], 0),
(812, 1, 3, 'mod/glossary:approve', 1, [[timestamp]], 0),
(813, 1, 1, 'mod/glossary:approve', 1, [[timestamp]], 0),
(814, 1, 4, 'mod/glossary:rate', 1, [[timestamp]], 0),
(815, 1, 3, 'mod/glossary:rate', 1, [[timestamp]], 0),
(816, 1, 1, 'mod/glossary:rate', 1, [[timestamp]], 0),
(817, 1, 4, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(818, 1, 3, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(819, 1, 1, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(820, 1, 4, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(821, 1, 3, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(822, 1, 1, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(823, 1, 4, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(824, 1, 3, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(825, 1, 1, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(826, 1, 4, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(827, 1, 3, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(828, 1, 1, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(829, 1, 4, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(830, 1, 3, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(831, 1, 1, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(832, 1, 5, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(833, 1, 6, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(834, 1, 5, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(835, 1, 4, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(836, 1, 3, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(837, 1, 1, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(838, 1, 3, 'mod/h5pactivity:addinstance', 1, [[timestamp]], 0),
(839, 1, 1, 'mod/h5pactivity:addinstance', 1, [[timestamp]], 0),
(840, 1, 5, 'mod/h5pactivity:submit', 1, [[timestamp]], 0),
(841, 1, 3, 'mod/h5pactivity:reviewattempts', 1, [[timestamp]], 0),
(842, 1, 1, 'mod/h5pactivity:reviewattempts', 1, [[timestamp]], 0),
(843, 1, 6, 'mod/imscp:view', 1, [[timestamp]], 0),
(844, 1, 7, 'mod/imscp:view', 1, [[timestamp]], 0),
(845, 1, 3, 'mod/imscp:addinstance', 1, [[timestamp]], 0),
(846, 1, 1, 'mod/imscp:addinstance', 1, [[timestamp]], 0),
(847, 1, 3, 'mod/label:addinstance', 1, [[timestamp]], 0),
(848, 1, 1, 'mod/label:addinstance', 1, [[timestamp]], 0),
(849, 1, 7, 'mod/label:view', 1, [[timestamp]], 0),
(850, 1, 6, 'mod/label:view', 1, [[timestamp]], 0),
(851, 1, 3, 'mod/lesson:addinstance', 1, [[timestamp]], 0),
(852, 1, 1, 'mod/lesson:addinstance', 1, [[timestamp]], 0),
(853, 1, 3, 'mod/lesson:edit', 1, [[timestamp]], 0),
(854, 1, 1, 'mod/lesson:edit', 1, [[timestamp]], 0),
(855, 1, 4, 'mod/lesson:grade', 1, [[timestamp]], 0),
(856, 1, 3, 'mod/lesson:grade', 1, [[timestamp]], 0),
(857, 1, 1, 'mod/lesson:grade', 1, [[timestamp]], 0),
(858, 1, 4, 'mod/lesson:viewreports', 1, [[timestamp]], 0),
(859, 1, 3, 'mod/lesson:viewreports', 1, [[timestamp]], 0),
(860, 1, 1, 'mod/lesson:viewreports', 1, [[timestamp]], 0),
(861, 1, 4, 'mod/lesson:manage', 1, [[timestamp]], 0),
(862, 1, 3, 'mod/lesson:manage', 1, [[timestamp]], 0),
(863, 1, 1, 'mod/lesson:manage', 1, [[timestamp]], 0),
(864, 1, 3, 'mod/lesson:manageoverrides', 1, [[timestamp]], 0),
(865, 1, 1, 'mod/lesson:manageoverrides', 1, [[timestamp]], 0),
(866, 1, 7, 'mod/lesson:view', 1, [[timestamp]], 0),
(867, 1, 6, 'mod/lesson:view', 1, [[timestamp]], 0),
(868, 1, 5, 'mod/lti:view', 1, [[timestamp]], 0),
(869, 1, 4, 'mod/lti:view', 1, [[timestamp]], 0),
(870, 1, 3, 'mod/lti:view', 1, [[timestamp]], 0),
(871, 1, 1, 'mod/lti:view', 1, [[timestamp]], 0),
(872, 1, 3, 'mod/lti:addinstance', 1, [[timestamp]], 0),
(873, 1, 1, 'mod/lti:addinstance', 1, [[timestamp]], 0),
(874, 1, 4, 'mod/lti:manage', 1, [[timestamp]], 0),
(875, 1, 3, 'mod/lti:manage', 1, [[timestamp]], 0),
(876, 1, 1, 'mod/lti:manage', 1, [[timestamp]], 0);
INSERT INTO `[[dbprefix]]role_capabilities` VALUES
(877, 1, 3, 'mod/lti:addcoursetool', 1, [[timestamp]], 0),
(878, 1, 1, 'mod/lti:addcoursetool', 1, [[timestamp]], 0),
(879, 1, 3, 'mod/lti:addpreconfiguredinstance', 1, [[timestamp]], 0),
(880, 1, 1, 'mod/lti:addpreconfiguredinstance', 1, [[timestamp]], 0),
(881, 1, 3, 'mod/lti:addmanualinstance', 1, [[timestamp]], 0),
(882, 1, 1, 'mod/lti:addmanualinstance', 1, [[timestamp]], 0),
(883, 1, 3, 'mod/lti:requesttooladd', 1, [[timestamp]], 0),
(884, 1, 1, 'mod/lti:requesttooladd', 1, [[timestamp]], 0),
(885, 1, 6, 'mod/page:view', 1, [[timestamp]], 0),
(886, 1, 7, 'mod/page:view', 1, [[timestamp]], 0),
(887, 1, 3, 'mod/page:addinstance', 1, [[timestamp]], 0),
(888, 1, 1, 'mod/page:addinstance', 1, [[timestamp]], 0),
(889, 1, 6, 'mod/quiz:view', 1, [[timestamp]], 0),
(890, 1, 5, 'mod/quiz:view', 1, [[timestamp]], 0),
(891, 1, 4, 'mod/quiz:view', 1, [[timestamp]], 0),
(892, 1, 3, 'mod/quiz:view', 1, [[timestamp]], 0),
(893, 1, 1, 'mod/quiz:view', 1, [[timestamp]], 0),
(894, 1, 3, 'mod/quiz:addinstance', 1, [[timestamp]], 0),
(895, 1, 1, 'mod/quiz:addinstance', 1, [[timestamp]], 0),
(896, 1, 5, 'mod/quiz:attempt', 1, [[timestamp]], 0),
(897, 1, 5, 'mod/quiz:reviewmyattempts', 1, [[timestamp]], 0),
(898, 1, 3, 'mod/quiz:manage', 1, [[timestamp]], 0),
(899, 1, 1, 'mod/quiz:manage', 1, [[timestamp]], 0),
(900, 1, 3, 'mod/quiz:manageoverrides', 1, [[timestamp]], 0),
(901, 1, 1, 'mod/quiz:manageoverrides', 1, [[timestamp]], 0),
(902, 1, 4, 'mod/quiz:viewoverrides', 1, [[timestamp]], 0),
(903, 1, 3, 'mod/quiz:viewoverrides', 1, [[timestamp]], 0),
(904, 1, 1, 'mod/quiz:viewoverrides', 1, [[timestamp]], 0),
(905, 1, 4, 'mod/quiz:preview', 1, [[timestamp]], 0),
(906, 1, 3, 'mod/quiz:preview', 1, [[timestamp]], 0),
(907, 1, 1, 'mod/quiz:preview', 1, [[timestamp]], 0),
(908, 1, 4, 'mod/quiz:grade', 1, [[timestamp]], 0),
(909, 1, 3, 'mod/quiz:grade', 1, [[timestamp]], 0),
(910, 1, 1, 'mod/quiz:grade', 1, [[timestamp]], 0),
(911, 1, 4, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(912, 1, 3, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(913, 1, 1, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(914, 1, 4, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(915, 1, 3, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(916, 1, 1, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(917, 1, 3, 'mod/quiz:deleteattempts', 1, [[timestamp]], 0),
(918, 1, 1, 'mod/quiz:deleteattempts', 1, [[timestamp]], 0),
(919, 1, 6, 'mod/resource:view', 1, [[timestamp]], 0),
(920, 1, 7, 'mod/resource:view', 1, [[timestamp]], 0),
(921, 1, 3, 'mod/resource:addinstance', 1, [[timestamp]], 0),
(922, 1, 1, 'mod/resource:addinstance', 1, [[timestamp]], 0),
(923, 1, 3, 'mod/scorm:addinstance', 1, [[timestamp]], 0),
(924, 1, 1, 'mod/scorm:addinstance', 1, [[timestamp]], 0),
(925, 1, 4, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(926, 1, 3, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(927, 1, 1, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(928, 1, 5, 'mod/scorm:skipview', 1, [[timestamp]], 0),
(929, 1, 5, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(930, 1, 4, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(931, 1, 3, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(932, 1, 1, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(933, 1, 5, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(934, 1, 4, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(935, 1, 3, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(936, 1, 1, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(937, 1, 4, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(938, 1, 3, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(939, 1, 1, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(940, 1, 3, 'mod/survey:addinstance', 1, [[timestamp]], 0),
(941, 1, 1, 'mod/survey:addinstance', 1, [[timestamp]], 0),
(942, 1, 5, 'mod/survey:participate', 1, [[timestamp]], 0),
(943, 1, 4, 'mod/survey:participate', 1, [[timestamp]], 0),
(944, 1, 3, 'mod/survey:participate', 1, [[timestamp]], 0),
(945, 1, 1, 'mod/survey:participate', 1, [[timestamp]], 0),
(946, 1, 4, 'mod/survey:readresponses', 1, [[timestamp]], 0),
(947, 1, 3, 'mod/survey:readresponses', 1, [[timestamp]], 0),
(948, 1, 1, 'mod/survey:readresponses', 1, [[timestamp]], 0),
(949, 1, 4, 'mod/survey:download', 1, [[timestamp]], 0),
(950, 1, 3, 'mod/survey:download', 1, [[timestamp]], 0),
(951, 1, 1, 'mod/survey:download', 1, [[timestamp]], 0),
(952, 1, 6, 'mod/url:view', 1, [[timestamp]], 0),
(953, 1, 7, 'mod/url:view', 1, [[timestamp]], 0),
(954, 1, 3, 'mod/url:addinstance', 1, [[timestamp]], 0),
(955, 1, 1, 'mod/url:addinstance', 1, [[timestamp]], 0),
(956, 1, 3, 'mod/wiki:addinstance', 1, [[timestamp]], 0),
(957, 1, 1, 'mod/wiki:addinstance', 1, [[timestamp]], 0),
(958, 1, 6, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(959, 1, 8, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(960, 1, 5, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(961, 1, 4, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(962, 1, 3, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(963, 1, 1, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(964, 1, 5, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(965, 1, 4, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(966, 1, 3, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(967, 1, 1, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(968, 1, 5, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(969, 1, 4, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(970, 1, 3, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(971, 1, 1, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(972, 1, 5, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(973, 1, 4, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(974, 1, 3, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(975, 1, 1, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(976, 1, 5, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(977, 1, 4, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(978, 1, 3, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(979, 1, 1, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(980, 1, 4, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(981, 1, 3, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(982, 1, 1, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(983, 1, 4, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(984, 1, 3, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(985, 1, 1, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(986, 1, 4, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(987, 1, 3, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(988, 1, 1, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(989, 1, 4, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(990, 1, 3, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(991, 1, 1, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(992, 1, 6, 'mod/workshop:view', 1, [[timestamp]], 0),
(993, 1, 5, 'mod/workshop:view', 1, [[timestamp]], 0),
(994, 1, 4, 'mod/workshop:view', 1, [[timestamp]], 0),
(995, 1, 3, 'mod/workshop:view', 1, [[timestamp]], 0),
(996, 1, 1, 'mod/workshop:view', 1, [[timestamp]], 0),
(997, 1, 3, 'mod/workshop:addinstance', 1, [[timestamp]], 0),
(998, 1, 1, 'mod/workshop:addinstance', 1, [[timestamp]], 0),
(999, 1, 4, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(1000, 1, 3, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(1001, 1, 1, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(1002, 1, 3, 'mod/workshop:editdimensions', 1, [[timestamp]], 0),
(1003, 1, 1, 'mod/workshop:editdimensions', 1, [[timestamp]], 0),
(1004, 1, 5, 'mod/workshop:submit', 1, [[timestamp]], 0),
(1005, 1, 5, 'mod/workshop:peerassess', 1, [[timestamp]], 0),
(1006, 1, 4, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(1007, 1, 3, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(1008, 1, 1, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(1009, 1, 4, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(1010, 1, 3, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(1011, 1, 1, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(1012, 1, 4, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(1013, 1, 3, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(1014, 1, 1, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(1015, 1, 5, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(1016, 1, 4, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(1017, 1, 3, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(1018, 1, 1, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(1019, 1, 4, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(1020, 1, 3, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(1021, 1, 1, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(1022, 1, 4, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(1023, 1, 3, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(1024, 1, 1, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(1025, 1, 5, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(1026, 1, 4, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(1027, 1, 3, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(1028, 1, 1, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(1029, 1, 5, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(1030, 1, 4, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(1031, 1, 3, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(1032, 1, 1, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(1033, 1, 4, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(1034, 1, 3, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(1035, 1, 1, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(1036, 1, 4, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(1037, 1, 3, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(1038, 1, 1, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(1039, 1, 4, 'mod/workshop:ignoredeadlines', 1, [[timestamp]], 0),
(1040, 1, 3, 'mod/workshop:ignoredeadlines', 1, [[timestamp]], 0),
(1041, 1, 1, 'mod/workshop:ignoredeadlines', 1, [[timestamp]], 0),
(1042, 1, 4, 'mod/workshop:deletesubmissions', 1, [[timestamp]], 0),
(1043, 1, 3, 'mod/workshop:deletesubmissions', 1, [[timestamp]], 0),
(1044, 1, 1, 'mod/workshop:deletesubmissions', 1, [[timestamp]], 0),
(1045, 1, 1, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(1046, 1, 4, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(1047, 1, 3, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(1048, 1, 5, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(1049, 1, 7, 'auth/oauth2:managelinkedlogins', 1, [[timestamp]], 0),
(1050, 1, 1, 'enrol/category:config', 1, [[timestamp]], 0),
(1051, 1, 3, 'enrol/category:config', 1, [[timestamp]], 0),
(1052, 1, 3, 'enrol/cohort:config', 1, [[timestamp]], 0),
(1053, 1, 1, 'enrol/cohort:config', 1, [[timestamp]], 0),
(1054, 1, 1, 'enrol/cohort:unenrol', 1, [[timestamp]], 0),
(1055, 1, 1, 'enrol/database:unenrol', 1, [[timestamp]], 0),
(1056, 1, 1, 'enrol/database:config', 1, [[timestamp]], 0),
(1057, 1, 3, 'enrol/database:config', 1, [[timestamp]], 0),
(1058, 1, 1, 'enrol/fee:config', 1, [[timestamp]], 0),
(1059, 1, 1, 'enrol/fee:manage', 1, [[timestamp]], 0),
(1060, 1, 3, 'enrol/fee:manage', 1, [[timestamp]], 0),
(1061, 1, 1, 'enrol/fee:unenrol', 1, [[timestamp]], 0),
(1062, 1, 1, 'enrol/guest:config', 1, [[timestamp]], 0),
(1063, 1, 3, 'enrol/guest:config', 1, [[timestamp]], 0),
(1064, 1, 1, 'enrol/imsenterprise:config', 1, [[timestamp]], 0),
(1065, 1, 3, 'enrol/imsenterprise:config', 1, [[timestamp]], 0),
(1066, 1, 1, 'enrol/ldap:manage', 1, [[timestamp]], 0),
(1067, 1, 1, 'enrol/lti:config', 1, [[timestamp]], 0),
(1068, 1, 3, 'enrol/lti:config', 1, [[timestamp]], 0),
(1069, 1, 1, 'enrol/lti:unenrol', 1, [[timestamp]], 0),
(1070, 1, 3, 'enrol/lti:unenrol', 1, [[timestamp]], 0),
(1071, 1, 1, 'enrol/manual:config', 1, [[timestamp]], 0),
(1072, 1, 1, 'enrol/manual:enrol', 1, [[timestamp]], 0),
(1073, 1, 3, 'enrol/manual:enrol', 1, [[timestamp]], 0),
(1074, 1, 1, 'enrol/manual:manage', 1, [[timestamp]], 0),
(1075, 1, 3, 'enrol/manual:manage', 1, [[timestamp]], 0),
(1076, 1, 1, 'enrol/manual:unenrol', 1, [[timestamp]], 0),
(1077, 1, 3, 'enrol/manual:unenrol', 1, [[timestamp]], 0),
(1078, 1, 1, 'enrol/meta:config', 1, [[timestamp]], 0),
(1079, 1, 3, 'enrol/meta:config', 1, [[timestamp]], 0),
(1080, 1, 1, 'enrol/meta:selectaslinked', 1, [[timestamp]], 0),
(1081, 1, 1, 'enrol/meta:unenrol', 1, [[timestamp]], 0),
(1082, 1, 1, 'enrol/mnet:config', 1, [[timestamp]], 0),
(1083, 1, 3, 'enrol/mnet:config', 1, [[timestamp]], 0),
(1084, 1, 1, 'enrol/paypal:config', 1, [[timestamp]], 0),
(1085, 1, 1, 'enrol/paypal:manage', 1, [[timestamp]], 0),
(1086, 1, 3, 'enrol/paypal:manage', 1, [[timestamp]], 0),
(1087, 1, 1, 'enrol/paypal:unenrol', 1, [[timestamp]], 0),
(1088, 1, 3, 'enrol/self:config', 1, [[timestamp]], 0),
(1089, 1, 1, 'enrol/self:config', 1, [[timestamp]], 0),
(1090, 1, 3, 'enrol/self:manage', 1, [[timestamp]], 0),
(1091, 1, 1, 'enrol/self:manage', 1, [[timestamp]], 0),
(1092, 1, 5, 'enrol/self:unenrolself', 1, [[timestamp]], 0),
(1093, 1, 3, 'enrol/self:unenrol', 1, [[timestamp]], 0),
(1094, 1, 1, 'enrol/self:unenrol', 1, [[timestamp]], 0),
(1095, 1, 7, 'enrol/self:enrolself', 1, [[timestamp]], 0),
(1096, 1, 7, 'message/airnotifier:managedevice', 1, [[timestamp]], 0),
(1097, 1, 3, 'block/accessreview:addinstance', 1, [[timestamp]], 0),
(1098, 1, 1, 'block/accessreview:addinstance', 1, [[timestamp]], 0),
(1099, 1, 3, 'block/accessreview:view', 1, [[timestamp]], 0),
(1100, 1, 1, 'block/accessreview:view', 1, [[timestamp]], 0),
(1101, 1, 3, 'block/activity_modules:addinstance', 1, [[timestamp]], 0),
(1102, 1, 1, 'block/activity_modules:addinstance', 1, [[timestamp]], 0),
(1103, 1, 3, 'block/activity_results:addinstance', 1, [[timestamp]], 0),
(1104, 1, 1, 'block/activity_results:addinstance', 1, [[timestamp]], 0),
(1105, 1, 7, 'block/admin_bookmarks:myaddinstance', 1, [[timestamp]], 0),
(1106, 1, 3, 'block/admin_bookmarks:addinstance', 1, [[timestamp]], 0),
(1107, 1, 1, 'block/admin_bookmarks:addinstance', 1, [[timestamp]], 0),
(1108, 1, 3, 'block/badges:addinstance', 1, [[timestamp]], 0),
(1109, 1, 1, 'block/badges:addinstance', 1, [[timestamp]], 0),
(1110, 1, 7, 'block/badges:myaddinstance', 1, [[timestamp]], 0),
(1111, 1, 3, 'block/blog_menu:addinstance', 1, [[timestamp]], 0),
(1112, 1, 1, 'block/blog_menu:addinstance', 1, [[timestamp]], 0),
(1113, 1, 3, 'block/blog_recent:addinstance', 1, [[timestamp]], 0),
(1114, 1, 1, 'block/blog_recent:addinstance', 1, [[timestamp]], 0),
(1115, 1, 3, 'block/blog_tags:addinstance', 1, [[timestamp]], 0),
(1116, 1, 1, 'block/blog_tags:addinstance', 1, [[timestamp]], 0),
(1117, 1, 7, 'block/calendar_month:myaddinstance', 1, [[timestamp]], 0),
(1118, 1, 3, 'block/calendar_month:addinstance', 1, [[timestamp]], 0),
(1119, 1, 1, 'block/calendar_month:addinstance', 1, [[timestamp]], 0),
(1120, 1, 7, 'block/calendar_upcoming:myaddinstance', 1, [[timestamp]], 0),
(1121, 1, 3, 'block/calendar_upcoming:addinstance', 1, [[timestamp]], 0),
(1122, 1, 1, 'block/calendar_upcoming:addinstance', 1, [[timestamp]], 0),
(1123, 1, 7, 'block/comments:myaddinstance', 1, [[timestamp]], 0),
(1124, 1, 3, 'block/comments:addinstance', 1, [[timestamp]], 0),
(1125, 1, 1, 'block/comments:addinstance', 1, [[timestamp]], 0),
(1126, 1, 3, 'block/completionstatus:addinstance', 1, [[timestamp]], 0),
(1127, 1, 1, 'block/completionstatus:addinstance', 1, [[timestamp]], 0),
(1128, 1, 7, 'block/course_list:myaddinstance', 1, [[timestamp]], 0),
(1129, 1, 3, 'block/course_list:addinstance', 1, [[timestamp]], 0),
(1130, 1, 1, 'block/course_list:addinstance', 1, [[timestamp]], 0),
(1131, 1, 3, 'block/course_summary:addinstance', 1, [[timestamp]], 0),
(1132, 1, 1, 'block/course_summary:addinstance', 1, [[timestamp]], 0),
(1133, 1, 3, 'block/feedback:addinstance', 1, [[timestamp]], 0),
(1134, 1, 1, 'block/feedback:addinstance', 1, [[timestamp]], 0),
(1135, 1, 7, 'block/globalsearch:myaddinstance', 1, [[timestamp]], 0),
(1136, 1, 3, 'block/globalsearch:addinstance', 1, [[timestamp]], 0),
(1137, 1, 1, 'block/globalsearch:addinstance', 1, [[timestamp]], 0),
(1138, 1, 7, 'block/glossary_random:myaddinstance', 1, [[timestamp]], 0),
(1139, 1, 3, 'block/glossary_random:addinstance', 1, [[timestamp]], 0),
(1140, 1, 1, 'block/glossary_random:addinstance', 1, [[timestamp]], 0),
(1141, 1, 7, 'block/html:myaddinstance', 1, [[timestamp]], 0),
(1142, 1, 3, 'block/html:addinstance', 1, [[timestamp]], 0),
(1143, 1, 1, 'block/html:addinstance', 1, [[timestamp]], 0),
(1144, 1, 3, 'block/login:addinstance', 1, [[timestamp]], 0),
(1145, 1, 1, 'block/login:addinstance', 1, [[timestamp]], 0),
(1146, 1, 3, 'block/lp:addinstance', 1, [[timestamp]], 0),
(1147, 1, 1, 'block/lp:addinstance', 1, [[timestamp]], 0),
(1148, 1, 7, 'block/lp:myaddinstance', 1, [[timestamp]], 0),
(1149, 1, 7, 'block/mentees:myaddinstance', 1, [[timestamp]], 0),
(1150, 1, 3, 'block/mentees:addinstance', 1, [[timestamp]], 0),
(1151, 1, 1, 'block/mentees:addinstance', 1, [[timestamp]], 0),
(1152, 1, 7, 'block/mnet_hosts:myaddinstance', 1, [[timestamp]], 0),
(1153, 1, 3, 'block/mnet_hosts:addinstance', 1, [[timestamp]], 0),
(1154, 1, 1, 'block/mnet_hosts:addinstance', 1, [[timestamp]], 0),
(1155, 1, 7, 'block/myoverview:myaddinstance', 1, [[timestamp]], 0),
(1156, 1, 7, 'block/myprofile:myaddinstance', 1, [[timestamp]], 0),
(1157, 1, 3, 'block/myprofile:addinstance', 1, [[timestamp]], 0),
(1158, 1, 1, 'block/myprofile:addinstance', 1, [[timestamp]], 0),
(1159, 1, 7, 'block/navigation:myaddinstance', 1, [[timestamp]], 0),
(1160, 1, 3, 'block/navigation:addinstance', 1, [[timestamp]], 0),
(1161, 1, 1, 'block/navigation:addinstance', 1, [[timestamp]], 0),
(1162, 1, 7, 'block/news_items:myaddinstance', 1, [[timestamp]], 0),
(1163, 1, 3, 'block/news_items:addinstance', 1, [[timestamp]], 0),
(1164, 1, 1, 'block/news_items:addinstance', 1, [[timestamp]], 0),
(1165, 1, 7, 'block/online_users:myaddinstance', 1, [[timestamp]], 0),
(1166, 1, 3, 'block/online_users:addinstance', 1, [[timestamp]], 0),
(1167, 1, 1, 'block/online_users:addinstance', 1, [[timestamp]], 0),
(1168, 1, 7, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1169, 1, 6, 'block/online_users:viewlist', -1, [[timestamp]], 0),
(1170, 1, 5, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1171, 1, 4, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1172, 1, 3, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1173, 1, 1, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1174, 1, 7, 'block/private_files:myaddinstance', 1, [[timestamp]], 0),
(1175, 1, 3, 'block/private_files:addinstance', 1, [[timestamp]], 0),
(1176, 1, 1, 'block/private_files:addinstance', 1, [[timestamp]], 0),
(1177, 1, 3, 'block/quiz_results:addinstance', 1, [[timestamp]], 0),
(1178, 1, 1, 'block/quiz_results:addinstance', 1, [[timestamp]], 0),
(1179, 1, 3, 'block/recent_activity:addinstance', 1, [[timestamp]], 0),
(1180, 1, 1, 'block/recent_activity:addinstance', 1, [[timestamp]], 0),
(1181, 1, 7, 'block/recent_activity:viewaddupdatemodule', 1, [[timestamp]], 0),
(1182, 1, 7, 'block/recent_activity:viewdeletemodule', 1, [[timestamp]], 0),
(1183, 1, 7, 'block/recentlyaccessedcourses:myaddinstance', 1, [[timestamp]], 0),
(1184, 1, 7, 'block/recentlyaccesseditems:myaddinstance', 1, [[timestamp]], 0),
(1185, 1, 7, 'block/rss_client:myaddinstance', 1, [[timestamp]], 0),
(1186, 1, 3, 'block/rss_client:addinstance', 1, [[timestamp]], 0),
(1187, 1, 1, 'block/rss_client:addinstance', 1, [[timestamp]], 0),
(1188, 1, 4, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(1189, 1, 3, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(1190, 1, 1, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(1191, 1, 1, 'block/rss_client:manageanyfeeds', 1, [[timestamp]], 0),
(1192, 1, 3, 'block/search_forums:addinstance', 1, [[timestamp]], 0),
(1193, 1, 1, 'block/search_forums:addinstance', 1, [[timestamp]], 0),
(1194, 1, 3, 'block/section_links:addinstance', 1, [[timestamp]], 0),
(1195, 1, 1, 'block/section_links:addinstance', 1, [[timestamp]], 0),
(1196, 1, 3, 'block/selfcompletion:addinstance', 1, [[timestamp]], 0),
(1197, 1, 1, 'block/selfcompletion:addinstance', 1, [[timestamp]], 0),
(1198, 1, 7, 'block/settings:myaddinstance', 1, [[timestamp]], 0),
(1199, 1, 3, 'block/settings:addinstance', 1, [[timestamp]], 0),
(1200, 1, 1, 'block/settings:addinstance', 1, [[timestamp]], 0),
(1201, 1, 3, 'block/site_main_menu:addinstance', 1, [[timestamp]], 0),
(1202, 1, 1, 'block/site_main_menu:addinstance', 1, [[timestamp]], 0),
(1203, 1, 3, 'block/social_activities:addinstance', 1, [[timestamp]], 0),
(1204, 1, 1, 'block/social_activities:addinstance', 1, [[timestamp]], 0),
(1205, 1, 7, 'block/starredcourses:myaddinstance', 1, [[timestamp]], 0),
(1206, 1, 3, 'block/tag_flickr:addinstance', 1, [[timestamp]], 0),
(1207, 1, 1, 'block/tag_flickr:addinstance', 1, [[timestamp]], 0),
(1208, 1, 3, 'block/tag_youtube:addinstance', 1, [[timestamp]], 0),
(1209, 1, 1, 'block/tag_youtube:addinstance', 1, [[timestamp]], 0),
(1210, 1, 7, 'block/tags:myaddinstance', 1, [[timestamp]], 0),
(1211, 1, 3, 'block/tags:addinstance', 1, [[timestamp]], 0),
(1212, 1, 1, 'block/tags:addinstance', 1, [[timestamp]], 0),
(1213, 1, 7, 'block/timeline:myaddinstance', 1, [[timestamp]], 0),
(1214, 1, 4, 'report/completion:view', 1, [[timestamp]], 0),
(1215, 1, 3, 'report/completion:view', 1, [[timestamp]], 0),
(1216, 1, 1, 'report/completion:view', 1, [[timestamp]], 0),
(1217, 1, 4, 'report/courseoverview:view', 1, [[timestamp]], 0),
(1218, 1, 3, 'report/courseoverview:view', 1, [[timestamp]], 0),
(1219, 1, 1, 'report/courseoverview:view', 1, [[timestamp]], 0),
(1220, 1, 4, 'report/log:view', 1, [[timestamp]], 0),
(1221, 1, 3, 'report/log:view', 1, [[timestamp]], 0),
(1222, 1, 1, 'report/log:view', 1, [[timestamp]], 0),
(1223, 1, 4, 'report/log:viewtoday', 1, [[timestamp]], 0),
(1224, 1, 3, 'report/log:viewtoday', 1, [[timestamp]], 0),
(1225, 1, 1, 'report/log:viewtoday', 1, [[timestamp]], 0),
(1226, 1, 4, 'report/loglive:view', 1, [[timestamp]], 0),
(1227, 1, 3, 'report/loglive:view', 1, [[timestamp]], 0),
(1228, 1, 1, 'report/loglive:view', 1, [[timestamp]], 0),
(1229, 1, 4, 'report/outline:view', 1, [[timestamp]], 0),
(1230, 1, 3, 'report/outline:view', 1, [[timestamp]], 0),
(1231, 1, 1, 'report/outline:view', 1, [[timestamp]], 0),
(1232, 1, 4, 'report/outline:viewuserreport', 1, [[timestamp]], 0),
(1233, 1, 3, 'report/outline:viewuserreport', 1, [[timestamp]], 0),
(1234, 1, 1, 'report/outline:viewuserreport', 1, [[timestamp]], 0),
(1235, 1, 4, 'report/participation:view', 1, [[timestamp]], 0),
(1236, 1, 3, 'report/participation:view', 1, [[timestamp]], 0),
(1237, 1, 1, 'report/participation:view', 1, [[timestamp]], 0),
(1238, 1, 1, 'report/performance:view', 1, [[timestamp]], 0),
(1239, 1, 4, 'report/progress:view', 1, [[timestamp]], 0),
(1240, 1, 3, 'report/progress:view', 1, [[timestamp]], 0),
(1241, 1, 1, 'report/progress:view', 1, [[timestamp]], 0),
(1242, 1, 1, 'report/security:view', 1, [[timestamp]], 0),
(1243, 1, 4, 'report/stats:view', 1, [[timestamp]], 0),
(1244, 1, 3, 'report/stats:view', 1, [[timestamp]], 0),
(1245, 1, 1, 'report/stats:view', 1, [[timestamp]], 0),
(1246, 1, 1, 'report/status:view', 1, [[timestamp]], 0),
(1247, 1, 6, 'report/usersessions:manageownsessions', -1000, [[timestamp]], 0),
(1248, 1, 7, 'report/usersessions:manageownsessions', 1, [[timestamp]], 0),
(1249, 1, 1, 'report/usersessions:manageownsessions', 1, [[timestamp]], 0),
(1250, 1, 4, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(1251, 1, 3, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(1252, 1, 1, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(1253, 1, 1, 'gradeexport/ods:publish', 1, [[timestamp]], 0),
(1254, 1, 4, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(1255, 1, 3, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(1256, 1, 1, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(1257, 1, 1, 'gradeexport/txt:publish', 1, [[timestamp]], 0),
(1258, 1, 4, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(1259, 1, 3, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(1260, 1, 1, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(1261, 1, 1, 'gradeexport/xls:publish', 1, [[timestamp]], 0),
(1262, 1, 4, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(1263, 1, 3, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(1264, 1, 1, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(1265, 1, 1, 'gradeexport/xml:publish', 1, [[timestamp]], 0),
(1266, 1, 3, 'gradeimport/csv:view', 1, [[timestamp]], 0),
(1267, 1, 1, 'gradeimport/csv:view', 1, [[timestamp]], 0),
(1268, 1, 3, 'gradeimport/direct:view', 1, [[timestamp]], 0),
(1269, 1, 1, 'gradeimport/direct:view', 1, [[timestamp]], 0),
(1270, 1, 3, 'gradeimport/xml:view', 1, [[timestamp]], 0),
(1271, 1, 1, 'gradeimport/xml:view', 1, [[timestamp]], 0),
(1272, 1, 1, 'gradeimport/xml:publish', 1, [[timestamp]], 0),
(1273, 1, 4, 'gradereport/grader:view', 1, [[timestamp]], 0),
(1274, 1, 3, 'gradereport/grader:view', 1, [[timestamp]], 0),
(1275, 1, 1, 'gradereport/grader:view', 1, [[timestamp]], 0),
(1276, 1, 4, 'gradereport/history:view', 1, [[timestamp]], 0),
(1277, 1, 3, 'gradereport/history:view', 1, [[timestamp]], 0),
(1278, 1, 1, 'gradereport/history:view', 1, [[timestamp]], 0),
(1279, 1, 4, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(1280, 1, 3, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(1281, 1, 1, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(1282, 1, 7, 'gradereport/overview:view', 1, [[timestamp]], 0),
(1283, 1, 3, 'gradereport/singleview:view', 1, [[timestamp]], 0),
(1284, 1, 1, 'gradereport/singleview:view', 1, [[timestamp]], 0),
(1285, 1, 5, 'gradereport/user:view', 1, [[timestamp]], 0),
(1286, 1, 4, 'gradereport/user:view', 1, [[timestamp]], 0),
(1287, 1, 3, 'gradereport/user:view', 1, [[timestamp]], 0),
(1288, 1, 1, 'gradereport/user:view', 1, [[timestamp]], 0),
(1289, 1, 7, 'repository/areafiles:view', 1, [[timestamp]], 0),
(1290, 1, 7, 'repository/boxnet:view', 1, [[timestamp]], 0),
(1291, 1, 2, 'repository/contentbank:view', 1, [[timestamp]], 0),
(1292, 1, 3, 'repository/contentbank:view', 1, [[timestamp]], 0),
(1293, 1, 1, 'repository/contentbank:view', 1, [[timestamp]], 0),
(1294, 1, 2, 'repository/contentbank:accesscoursecontent', 1, [[timestamp]], 0),
(1295, 1, 3, 'repository/contentbank:accesscoursecontent', 1, [[timestamp]], 0),
(1296, 1, 1, 'repository/contentbank:accesscoursecontent', 1, [[timestamp]], 0),
(1297, 1, 2, 'repository/contentbank:accesscoursecategorycontent', 1, [[timestamp]], 0),
(1298, 1, 1, 'repository/contentbank:accesscoursecategorycontent', 1, [[timestamp]], 0),
(1299, 1, 7, 'repository/contentbank:accessgeneralcontent', 1, [[timestamp]], 0),
(1300, 1, 2, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1301, 1, 4, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1302, 1, 3, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1303, 1, 1, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1304, 1, 7, 'repository/dropbox:view', 1, [[timestamp]], 0),
(1305, 1, 7, 'repository/equella:view', 1, [[timestamp]], 0),
(1306, 1, 2, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1307, 1, 4, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1308, 1, 3, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1309, 1, 1, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1310, 1, 7, 'repository/flickr:view', 1, [[timestamp]], 0),
(1311, 1, 7, 'repository/flickr_public:view', 1, [[timestamp]], 0),
(1312, 1, 7, 'repository/googledocs:view', 1, [[timestamp]], 0),
(1313, 1, 2, 'repository/local:view', 1, [[timestamp]], 0),
(1314, 1, 4, 'repository/local:view', 1, [[timestamp]], 0),
(1315, 1, 3, 'repository/local:view', 1, [[timestamp]], 0),
(1316, 1, 1, 'repository/local:view', 1, [[timestamp]], 0),
(1317, 1, 7, 'repository/merlot:view', 1, [[timestamp]], 0),
(1318, 1, 7, 'repository/nextcloud:view', 1, [[timestamp]], 0),
(1319, 1, 7, 'repository/onedrive:view', 1, [[timestamp]], 0),
(1320, 1, 7, 'repository/picasa:view', 1, [[timestamp]], 0),
(1321, 1, 7, 'repository/recent:view', 1, [[timestamp]], 0),
(1322, 1, 7, 'repository/s3:view', 1, [[timestamp]], 0),
(1323, 1, 7, 'repository/skydrive:view', 1, [[timestamp]], 0),
(1324, 1, 7, 'repository/upload:view', 1, [[timestamp]], 0),
(1325, 1, 7, 'repository/url:view', 1, [[timestamp]], 0),
(1326, 1, 7, 'repository/user:view', 1, [[timestamp]], 0),
(1327, 1, 2, 'repository/webdav:view', 1, [[timestamp]], 0),
(1328, 1, 4, 'repository/webdav:view', 1, [[timestamp]], 0),
(1329, 1, 3, 'repository/webdav:view', 1, [[timestamp]], 0),
(1330, 1, 1, 'repository/webdav:view', 1, [[timestamp]], 0),
(1331, 1, 7, 'repository/wikimedia:view', 1, [[timestamp]], 0),
(1332, 1, 7, 'repository/youtube:view', 1, [[timestamp]], 0),
(1333, 1, 4, 'tool/brickfield:viewcoursetools', 1, [[timestamp]], 0),
(1334, 1, 3, 'tool/brickfield:viewcoursetools', 1, [[timestamp]], 0),
(1335, 1, 1, 'tool/brickfield:viewcoursetools', 1, [[timestamp]], 0),
(1336, 1, 1, 'tool/brickfield:viewsystemtools', 1, [[timestamp]], 0),
(1337, 1, 1, 'tool/customlang:view', 1, [[timestamp]], 0),
(1338, 1, 1, 'tool/customlang:edit', 1, [[timestamp]], 0),
(1339, 1, 1, 'tool/customlang:export', 1, [[timestamp]], 0),
(1340, 1, 7, 'tool/dataprivacy:downloadownrequest', 1, [[timestamp]], 0),
(1341, 1, 7, 'tool/dataprivacy:requestdelete', 1, [[timestamp]], 0),
(1342, 1, 1, 'tool/lpmigrate:frameworksmigrate', 1, [[timestamp]], 0),
(1343, 1, 4, 'tool/monitor:subscribe', 1, [[timestamp]], 0),
(1344, 1, 3, 'tool/monitor:subscribe', 1, [[timestamp]], 0),
(1345, 1, 1, 'tool/monitor:subscribe', 1, [[timestamp]], 0),
(1346, 1, 4, 'tool/monitor:managerules', 1, [[timestamp]], 0),
(1347, 1, 3, 'tool/monitor:managerules', 1, [[timestamp]], 0),
(1348, 1, 1, 'tool/monitor:managerules', 1, [[timestamp]], 0),
(1349, 1, 1, 'tool/monitor:managetool', 1, [[timestamp]], 0),
(1350, 1, 7, 'tool/policy:accept', 1, [[timestamp]], 0),
(1351, 1, 1, 'tool/policy:managedocs', 1, [[timestamp]], 0),
(1352, 1, 1, 'tool/policy:viewacceptances', 1, [[timestamp]], 0),
(1353, 1, 3, 'tool/recyclebin:deleteitems', 1, [[timestamp]], 0),
(1354, 1, 1, 'tool/recyclebin:deleteitems', 1, [[timestamp]], 0),
(1355, 1, 3, 'tool/recyclebin:restoreitems', 1, [[timestamp]], 0),
(1356, 1, 1, 'tool/recyclebin:restoreitems', 1, [[timestamp]], 0),
(1357, 1, 4, 'tool/recyclebin:viewitems', 1, [[timestamp]], 0),
(1358, 1, 3, 'tool/recyclebin:viewitems', 1, [[timestamp]], 0),
(1359, 1, 1, 'tool/recyclebin:viewitems', 1, [[timestamp]], 0),
(1360, 1, 1, 'tool/uploaduser:uploaduserpictures', 1, [[timestamp]], 0),
(1361, 1, 1, 'tool/usertours:managetours', 1, [[timestamp]], 0),
(1362, 1, 1, 'contenttype/h5p:access', 1, [[timestamp]], 0),
(1363, 1, 2, 'contenttype/h5p:access', 1, [[timestamp]], 0),
(1364, 1, 3, 'contenttype/h5p:access', 1, [[timestamp]], 0),
(1365, 1, 1, 'contenttype/h5p:upload', 1, [[timestamp]], 0),
(1366, 1, 2, 'contenttype/h5p:upload', 1, [[timestamp]], 0),
(1367, 1, 3, 'contenttype/h5p:upload', 1, [[timestamp]], 0),
(1368, 1, 1, 'contenttype/h5p:useeditor', 1, [[timestamp]], 0),
(1369, 1, 2, 'contenttype/h5p:useeditor', 1, [[timestamp]], 0),
(1370, 1, 3, 'contenttype/h5p:useeditor', 1, [[timestamp]], 0),
(1371, 1, 3, 'booktool/importhtml:import', 1, [[timestamp]], 0),
(1372, 1, 1, 'booktool/importhtml:import', 1, [[timestamp]], 0),
(1373, 1, 6, 'booktool/print:print', 1, [[timestamp]], 0),
(1374, 1, 8, 'booktool/print:print', 1, [[timestamp]], 0),
(1375, 1, 5, 'booktool/print:print', 1, [[timestamp]], 0),
(1376, 1, 4, 'booktool/print:print', 1, [[timestamp]], 0),
(1377, 1, 3, 'booktool/print:print', 1, [[timestamp]], 0),
(1378, 1, 1, 'booktool/print:print', 1, [[timestamp]], 0),
(1379, 1, 4, 'forumreport/summary:view', 1, [[timestamp]], 0),
(1380, 1, 3, 'forumreport/summary:view', 1, [[timestamp]], 0),
(1381, 1, 1, 'forumreport/summary:view', 1, [[timestamp]], 0),
(1382, 1, 4, 'forumreport/summary:viewall', 1, [[timestamp]], 0),
(1383, 1, 3, 'forumreport/summary:viewall', 1, [[timestamp]], 0),
(1384, 1, 1, 'forumreport/summary:viewall', 1, [[timestamp]], 0),
(1385, 1, 4, 'quiz/grading:viewstudentnames', 1, [[timestamp]], 0),
(1386, 1, 3, 'quiz/grading:viewstudentnames', 1, [[timestamp]], 0),
(1387, 1, 1, 'quiz/grading:viewstudentnames', 1, [[timestamp]], 0),
(1388, 1, 4, 'quiz/grading:viewidnumber', 1, [[timestamp]], 0),
(1389, 1, 3, 'quiz/grading:viewidnumber', 1, [[timestamp]], 0),
(1390, 1, 1, 'quiz/grading:viewidnumber', 1, [[timestamp]], 0),
(1391, 1, 4, 'quiz/statistics:view', 1, [[timestamp]], 0),
(1392, 1, 3, 'quiz/statistics:view', 1, [[timestamp]], 0),
(1393, 1, 1, 'quiz/statistics:view', 1, [[timestamp]], 0),
(1394, 1, 1, 'quizaccess/seb:managetemplates', 1, [[timestamp]], 0),
(1395, 1, 1, 'quizaccess/seb:bypassseb', 1, [[timestamp]], 0),
(1396, 1, 3, 'quizaccess/seb:bypassseb', 1, [[timestamp]], 0),
(1397, 1, 1, 'quizaccess/seb:manage_seb_requiresafeexambrowser', 1, [[timestamp]], 0),
(1398, 1, 3, 'quizaccess/seb:manage_seb_requiresafeexambrowser', 1, [[timestamp]], 0),
(1399, 1, 1, 'quizaccess/seb:manage_seb_templateid', 1, [[timestamp]], 0),
(1400, 1, 3, 'quizaccess/seb:manage_seb_templateid', 1, [[timestamp]], 0),
(1401, 1, 1, 'quizaccess/seb:manage_filemanager_sebconfigfile', 1, [[timestamp]], 0),
(1402, 1, 3, 'quizaccess/seb:manage_filemanager_sebconfigfile', 1, [[timestamp]], 0),
(1403, 1, 1, 'quizaccess/seb:manage_seb_showsebdownloadlink', 1, [[timestamp]], 0),
(1404, 1, 3, 'quizaccess/seb:manage_seb_showsebdownloadlink', 1, [[timestamp]], 0),
(1405, 1, 1, 'quizaccess/seb:manage_seb_allowedbrowserexamkeys', 1, [[timestamp]], 0),
(1406, 1, 3, 'quizaccess/seb:manage_seb_allowedbrowserexamkeys', 1, [[timestamp]], 0),
(1407, 1, 1, 'quizaccess/seb:manage_seb_linkquitseb', 1, [[timestamp]], 0),
(1408, 1, 3, 'quizaccess/seb:manage_seb_linkquitseb', 1, [[timestamp]], 0),
(1409, 1, 1, 'quizaccess/seb:manage_seb_userconfirmquit', 1, [[timestamp]], 0),
(1410, 1, 3, 'quizaccess/seb:manage_seb_userconfirmquit', 1, [[timestamp]], 0),
(1411, 1, 1, 'quizaccess/seb:manage_seb_allowuserquitseb', 1, [[timestamp]], 0),
(1412, 1, 3, 'quizaccess/seb:manage_seb_allowuserquitseb', 1, [[timestamp]], 0),
(1413, 1, 1, 'quizaccess/seb:manage_seb_quitpassword', 1, [[timestamp]], 0),
(1414, 1, 3, 'quizaccess/seb:manage_seb_quitpassword', 1, [[timestamp]], 0),
(1415, 1, 1, 'quizaccess/seb:manage_seb_allowreloadinexam', 1, [[timestamp]], 0),
(1416, 1, 3, 'quizaccess/seb:manage_seb_allowreloadinexam', 1, [[timestamp]], 0),
(1417, 1, 1, 'quizaccess/seb:manage_seb_showsebtaskbar', 1, [[timestamp]], 0),
(1418, 1, 3, 'quizaccess/seb:manage_seb_showsebtaskbar', 1, [[timestamp]], 0),
(1419, 1, 1, 'quizaccess/seb:manage_seb_showreloadbutton', 1, [[timestamp]], 0),
(1420, 1, 3, 'quizaccess/seb:manage_seb_showreloadbutton', 1, [[timestamp]], 0),
(1421, 1, 1, 'quizaccess/seb:manage_seb_showtime', 1, [[timestamp]], 0),
(1422, 1, 3, 'quizaccess/seb:manage_seb_showtime', 1, [[timestamp]], 0),
(1423, 1, 1, 'quizaccess/seb:manage_seb_showkeyboardlayout', 1, [[timestamp]], 0),
(1424, 1, 3, 'quizaccess/seb:manage_seb_showkeyboardlayout', 1, [[timestamp]], 0),
(1425, 1, 1, 'quizaccess/seb:manage_seb_showwificontrol', 1, [[timestamp]], 0),
(1426, 1, 3, 'quizaccess/seb:manage_seb_showwificontrol', 1, [[timestamp]], 0),
(1427, 1, 1, 'quizaccess/seb:manage_seb_enableaudiocontrol', 1, [[timestamp]], 0),
(1428, 1, 3, 'quizaccess/seb:manage_seb_enableaudiocontrol', 1, [[timestamp]], 0),
(1429, 1, 1, 'quizaccess/seb:manage_seb_muteonstartup', 1, [[timestamp]], 0),
(1430, 1, 3, 'quizaccess/seb:manage_seb_muteonstartup', 1, [[timestamp]], 0),
(1431, 1, 1, 'quizaccess/seb:manage_seb_allowspellchecking', 1, [[timestamp]], 0),
(1432, 1, 3, 'quizaccess/seb:manage_seb_allowspellchecking', 1, [[timestamp]], 0),
(1433, 1, 1, 'quizaccess/seb:manage_seb_activateurlfiltering', 1, [[timestamp]], 0),
(1434, 1, 3, 'quizaccess/seb:manage_seb_activateurlfiltering', 1, [[timestamp]], 0),
(1435, 1, 1, 'quizaccess/seb:manage_seb_filterembeddedcontent', 1, [[timestamp]], 0),
(1436, 1, 3, 'quizaccess/seb:manage_seb_filterembeddedcontent', 1, [[timestamp]], 0),
(1437, 1, 1, 'quizaccess/seb:manage_seb_expressionsallowed', 1, [[timestamp]], 0),
(1438, 1, 3, 'quizaccess/seb:manage_seb_expressionsallowed', 1, [[timestamp]], 0),
(1439, 1, 1, 'quizaccess/seb:manage_seb_regexallowed', 1, [[timestamp]], 0),
(1440, 1, 3, 'quizaccess/seb:manage_seb_regexallowed', 1, [[timestamp]], 0),
(1441, 1, 1, 'quizaccess/seb:manage_seb_expressionsblocked', 1, [[timestamp]], 0),
(1442, 1, 3, 'quizaccess/seb:manage_seb_expressionsblocked', 1, [[timestamp]], 0),
(1443, 1, 1, 'quizaccess/seb:manage_seb_regexblocked', 1, [[timestamp]], 0),
(1444, 1, 3, 'quizaccess/seb:manage_seb_regexblocked', 1, [[timestamp]], 0),
(1445, 1, 3, 'atto/h5p:addembed', 1, [[timestamp]], 0),
(1446, 1, 7, 'atto/recordrtc:recordaudio', 1, [[timestamp]], 0),
(1447, 1, 7, 'atto/recordrtc:recordvideo', 1, [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_context_levels`
--

CREATE TABLE `[[dbprefix]]role_context_levels` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL,
  `contextlevel` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolecontleve_conrol_uix` (`contextlevel`,`roleid`),
  KEY `[[dbprefix]]rolecontleve_rol_ix` (`roleid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Lists which roles can be assigned at which context levels. T' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]role_context_levels`
--

INSERT INTO `[[dbprefix]]role_context_levels` VALUES
(1, 1, 10),
(4, 2, 10),
(2, 1, 40),
(5, 2, 40),
(3, 1, 50),
(6, 3, 50),
(8, 4, 50),
(10, 5, 50),
(7, 3, 70),
(9, 4, 70),
(11, 5, 70);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_names`
--

CREATE TABLE `[[dbprefix]]role_names` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `contextid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolename_rolcon_uix` (`roleid`,`contextid`),
  KEY `[[dbprefix]]rolename_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolename_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='role names in native strings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scale`
--

CREATE TABLE `[[dbprefix]]scale` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `scale` longtext NOT NULL,
  `description` longtext NOT NULL,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scal_cou_ix` (`courseid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines grading scales' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]scale`
--

INSERT INTO `[[dbprefix]]scale` VALUES
(1, 0, 0, 'Separate and Connected ways of knowing', 'Mostly separate knowing,Separate and connected,Mostly connected knowing', 'The scale based on the theory of separate and connected knowing. This theory describes two different ways that we can evaluate and learn about the things we see and hear.<ul><li><strong>Separate knowers</strong> remain as objective as possible without including feelings and emotions. In a discussion with other people, they like to defend their own ideas, using logic to find holes in opponent''s ideas.</li><li><strong>Connected knowers</strong> are more sensitive to other people. They are skilled at empathy and tend to listen and ask questions until they feel they can connect and "understand things from their point of view". They learn by trying to share the experiences that led to the knowledge they find in other people.</li></ul>', 0, [[timestamp]]),
(2, 0, 0, 'Default competence scale', 'Not yet competent,Competent', 'A binary rating scale that provides no further information beyond whether someone has demonstrated proficiency or not.', 0, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scale_history`
--

CREATE TABLE `[[dbprefix]]scale_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `scale` longtext NOT NULL,
  `description` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scalhist_act_ix` (`action`),
  KEY `[[dbprefix]]scalhist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]scalhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]scalhist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]scalhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm`
--

CREATE TABLE `[[dbprefix]]scorm` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `scormtype` varchar(50) NOT NULL DEFAULT 'local',
  `reference` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `version` varchar(9) NOT NULL DEFAULT '',
  `maxgrade` double NOT NULL DEFAULT '0',
  `grademethod` tinyint(2) NOT NULL DEFAULT '0',
  `whatgrade` bigint(10) NOT NULL DEFAULT '0',
  `maxattempt` bigint(10) NOT NULL DEFAULT '1',
  `forcecompleted` tinyint(1) NOT NULL DEFAULT '0',
  `forcenewattempt` tinyint(1) NOT NULL DEFAULT '0',
  `lastattemptlock` tinyint(1) NOT NULL DEFAULT '0',
  `masteryoverride` tinyint(1) NOT NULL DEFAULT '1',
  `displayattemptstatus` tinyint(1) NOT NULL DEFAULT '1',
  `displaycoursestructure` tinyint(1) NOT NULL DEFAULT '0',
  `updatefreq` tinyint(1) NOT NULL DEFAULT '0',
  `sha1hash` varchar(40) DEFAULT NULL,
  `md5hash` varchar(32) NOT NULL DEFAULT '',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `launch` bigint(10) NOT NULL DEFAULT '0',
  `skipview` tinyint(1) NOT NULL DEFAULT '1',
  `hidebrowse` tinyint(1) NOT NULL DEFAULT '0',
  `hidetoc` tinyint(1) NOT NULL DEFAULT '0',
  `nav` tinyint(1) NOT NULL DEFAULT '1',
  `navpositionleft` bigint(10) DEFAULT '-100',
  `navpositiontop` bigint(10) DEFAULT '-100',
  `auto` tinyint(1) NOT NULL DEFAULT '0',
  `popup` tinyint(1) NOT NULL DEFAULT '0',
  `options` varchar(255) NOT NULL DEFAULT '',
  `width` bigint(10) NOT NULL DEFAULT '100',
  `height` bigint(10) NOT NULL DEFAULT '600',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionstatusrequired` tinyint(1) DEFAULT NULL,
  `completionscorerequired` bigint(10) DEFAULT NULL,
  `completionstatusallscos` tinyint(1) DEFAULT NULL,
  `displayactivityname` smallint(4) NOT NULL DEFAULT '1',
  `autocommit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scor_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='each table is one SCORM module and its configuration' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_aicc_session`
--

CREATE TABLE `[[dbprefix]]scorm_aicc_session` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `scormid` bigint(10) NOT NULL DEFAULT '0',
  `hacpsession` varchar(255) NOT NULL DEFAULT '',
  `scoid` bigint(10) DEFAULT '0',
  `scormmode` varchar(50) DEFAULT NULL,
  `scormstatus` varchar(255) DEFAULT NULL,
  `attempt` bigint(10) DEFAULT NULL,
  `lessonstatus` varchar(255) DEFAULT NULL,
  `sessiontime` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scoraiccsess_sco_ix` (`scormid`),
  KEY `[[dbprefix]]scoraiccsess_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Used by AICC HACP to store session information' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes`
--

CREATE TABLE `[[dbprefix]]scorm_scoes` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scorm` bigint(10) NOT NULL DEFAULT '0',
  `manifest` varchar(255) NOT NULL DEFAULT '',
  `organization` varchar(255) NOT NULL DEFAULT '',
  `parent` varchar(255) NOT NULL DEFAULT '',
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `launch` longtext NOT NULL,
  `scormtype` varchar(5) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scorscoe_sco_ix` (`scorm`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='each SCO part of the SCORM module' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes_data`
--

CREATE TABLE `[[dbprefix]]scorm_scoes_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scorscoedata_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains variable data get from packages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes_track`
--

CREATE TABLE `[[dbprefix]]scorm_scoes_track` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `scormid` bigint(10) NOT NULL DEFAULT '0',
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `attempt` bigint(10) NOT NULL DEFAULT '1',
  `element` varchar(255) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorscoetrac_usesco_uix` (`userid`,`scormid`,`scoid`,`attempt`,`element`),
  KEY `[[dbprefix]]scorscoetrac_use_ix` (`userid`),
  KEY `[[dbprefix]]scorscoetrac_sco_ix` (`scormid`),
  KEY `[[dbprefix]]scorscoetrac_sco2_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='to track SCOes' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_mapinfo`
--

CREATE TABLE `[[dbprefix]]scorm_seq_mapinfo` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `objectiveid` bigint(10) NOT NULL DEFAULT '0',
  `targetobjectiveid` bigint(10) NOT NULL DEFAULT '0',
  `readsatisfiedstatus` tinyint(1) NOT NULL DEFAULT '1',
  `readnormalizedmeasure` tinyint(1) NOT NULL DEFAULT '1',
  `writesatisfiedstatus` tinyint(1) NOT NULL DEFAULT '0',
  `writenormalizedmeasure` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqmapi_scoidob_uix` (`scoid`,`id`,`objectiveid`),
  KEY `[[dbprefix]]scorseqmapi_sco_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqmapi_obj_ix` (`objectiveid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 objective mapinfo description' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_objective`
--

CREATE TABLE `[[dbprefix]]scorm_seq_objective` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `primaryobj` tinyint(1) NOT NULL DEFAULT '0',
  `objectiveid` varchar(255) NOT NULL DEFAULT '',
  `satisfiedbymeasure` tinyint(1) NOT NULL DEFAULT '1',
  `minnormalizedmeasure` float(11,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqobje_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqobje_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 objective description' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rolluprule`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rolluprule` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `childactivityset` varchar(15) NOT NULL DEFAULT '',
  `minimumcount` bigint(10) NOT NULL DEFAULT '0',
  `minimumpercent` float(11,4) NOT NULL DEFAULT '0.0000',
  `conditioncombination` varchar(3) NOT NULL DEFAULT 'all',
  `action` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqroll_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqroll_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 sequencing rule' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rolluprulecond`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rolluprulecond` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `rollupruleid` bigint(10) NOT NULL DEFAULT '0',
  `operator` varchar(5) NOT NULL DEFAULT 'noOp',
  `cond` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqroll_scoroli_uix` (`scoid`,`rollupruleid`,`id`),
  KEY `[[dbprefix]]scorseqroll_sco2_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqroll_rol_ix` (`rollupruleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 sequencing rule' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rulecond`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rulecond` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `ruleconditionsid` bigint(10) NOT NULL DEFAULT '0',
  `refrencedobjective` varchar(255) NOT NULL DEFAULT '',
  `measurethreshold` float(11,4) NOT NULL DEFAULT '0.0000',
  `operator` varchar(5) NOT NULL DEFAULT 'noOp',
  `cond` varchar(30) NOT NULL DEFAULT 'always',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqrule_idscoru_uix` (`id`,`scoid`,`ruleconditionsid`),
  KEY `[[dbprefix]]scorseqrule_sco2_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqrule_rul_ix` (`ruleconditionsid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 rule condition' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_ruleconds`
--

CREATE TABLE `[[dbprefix]]scorm_seq_ruleconds` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `conditioncombination` varchar(3) NOT NULL DEFAULT 'all',
  `ruletype` tinyint(2) NOT NULL DEFAULT '0',
  `action` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqrule_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqrule_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 rule conditions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_index_requests`
--

CREATE TABLE `[[dbprefix]]search_index_requests` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `searcharea` varchar(255) NOT NULL DEFAULT '',
  `timerequested` bigint(10) NOT NULL,
  `partialarea` varchar(255) NOT NULL DEFAULT '',
  `partialtime` bigint(10) NOT NULL,
  `indexpriority` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]searinderequ_indtim_ix` (`indexpriority`,`timerequested`),
  KEY `[[dbprefix]]searinderequ_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Records requests for (re)indexing of specific contexts. Entr' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_simpledb_index`
--

CREATE TABLE `[[dbprefix]]search_simpledb_index` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `docid` varchar(255) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `title` longtext,
  `content` longtext,
  `contextid` bigint(10) NOT NULL,
  `areaid` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `owneruserid` bigint(10) DEFAULT NULL,
  `modified` bigint(10) NOT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `description1` longtext,
  `description2` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]searsimpinde_doc_uix` (`docid`),
  KEY `[[dbprefix]]searsimpinde_owncon_ix` (`owneruserid`,`contextid`),
  FULLTEXT KEY `[[dbprefix]]search_simpledb_index_index` (`title`,`content`,`description1`,`description2`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='search_simpledb table containing the index data.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `state` bigint(10) NOT NULL DEFAULT '0',
  `sid` varchar(128) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `sessdata` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `firstip` varchar(45) DEFAULT NULL,
  `lastip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]sess_sid_uix` (`sid`),
  KEY `[[dbprefix]]sess_sta_ix` (`state`),
  KEY `[[dbprefix]]sess_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]sess_tim2_ix` (`timemodified`),
  KEY `[[dbprefix]]sess_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Database based session storage - now recommended' AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]sessions`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_daily`
--

CREATE TABLE `[[dbprefix]]stats_daily` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(20) NOT NULL DEFAULT 'activity',
  `stat1` bigint(10) NOT NULL DEFAULT '0',
  `stat2` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statdail_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statdail_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statdail_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='to accumulate daily stats' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_monthly`
--

CREATE TABLE `[[dbprefix]]stats_monthly` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(20) NOT NULL DEFAULT 'activity',
  `stat1` bigint(10) NOT NULL DEFAULT '0',
  `stat2` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statmont_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statmont_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statmont_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate monthly stats' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_daily`
--

CREATE TABLE `[[dbprefix]]stats_user_daily` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `statsreads` bigint(10) NOT NULL DEFAULT '0',
  `statswrites` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statuserdail_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statuserdail_use_ix` (`userid`),
  KEY `[[dbprefix]]statuserdail_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statuserdail_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate daily stats per course/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_monthly`
--

CREATE TABLE `[[dbprefix]]stats_user_monthly` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `statsreads` bigint(10) NOT NULL DEFAULT '0',
  `statswrites` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statusermont_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statusermont_use_ix` (`userid`),
  KEY `[[dbprefix]]statusermont_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statusermont_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate monthly stats per course/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_weekly`
--

CREATE TABLE `[[dbprefix]]stats_user_weekly` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `statsreads` bigint(10) NOT NULL DEFAULT '0',
  `statswrites` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statuserweek_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statuserweek_use_ix` (`userid`),
  KEY `[[dbprefix]]statuserweek_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statuserweek_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate weekly stats per course/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_weekly`
--

CREATE TABLE `[[dbprefix]]stats_weekly` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(20) NOT NULL DEFAULT 'activity',
  `stat1` bigint(10) NOT NULL DEFAULT '0',
  `stat2` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statweek_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statweek_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statweek_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate weekly stats' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey`
--

CREATE TABLE `[[dbprefix]]survey` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `template` bigint(10) NOT NULL DEFAULT '0',
  `days` mediumint(6) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `questions` varchar(255) NOT NULL DEFAULT '',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]surv_cou_ix` (`course`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each record is one SURVEY module with its configuration' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]survey`
--

INSERT INTO `[[dbprefix]]survey` VALUES
(1, 0, 0, 0, 985017600, 985017600, 'collesaname', 'collesaintro', 0, '25,26,27,28,29,30,43,44', 0),
(2, 0, 0, 0, 985017600, 985017600, 'collespname', 'collespintro', 0, '31,32,33,34,35,36,43,44', 0),
(3, 0, 0, 0, 985017600, 985017600, 'collesapname', 'collesapintro', 0, '37,38,39,40,41,42,43,44', 0),
(4, 0, 0, 0, 985017600, 985017600, 'attlsname', 'attlsintro', 0, '65,67,68', 0),
(5, 0, 0, 0, 985017600, 985017600, 'ciqname', 'ciqintro', 0, '69,70,71,72,73', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey_analysis`
--

CREATE TABLE `[[dbprefix]]survey_analysis` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `survey` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `notes` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]survanal_use_ix` (`userid`),
  KEY `[[dbprefix]]survanal_sur_ix` (`survey`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='text about each survey submission' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey_answers`
--

CREATE TABLE `[[dbprefix]]survey_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `survey` bigint(10) NOT NULL DEFAULT '0',
  `question` bigint(10) NOT NULL DEFAULT '0',
  `time` bigint(10) NOT NULL DEFAULT '0',
  `answer1` longtext NOT NULL,
  `answer2` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]survansw_use_ix` (`userid`),
  KEY `[[dbprefix]]survansw_sur_ix` (`survey`),
  KEY `[[dbprefix]]survansw_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='the answers to each questions filled by the users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey_questions`
--

CREATE TABLE `[[dbprefix]]survey_questions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `text` varchar(255) NOT NULL DEFAULT '',
  `shorttext` varchar(30) NOT NULL DEFAULT '',
  `multi` varchar(100) NOT NULL DEFAULT '',
  `intro` varchar(50) NOT NULL DEFAULT '',
  `type` smallint(3) NOT NULL DEFAULT '0',
  `options` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='the questions conforming one survey' AUTO_INCREMENT=74 ;

--
-- Dumping data for table `[[dbprefix]]survey_questions`
--

INSERT INTO `[[dbprefix]]survey_questions` VALUES
(1, 'colles1', 'colles1short', '', '', 1, 'scaletimes5'),
(2, 'colles2', 'colles2short', '', '', 1, 'scaletimes5'),
(3, 'colles3', 'colles3short', '', '', 1, 'scaletimes5'),
(4, 'colles4', 'colles4short', '', '', 1, 'scaletimes5'),
(5, 'colles5', 'colles5short', '', '', 1, 'scaletimes5'),
(6, 'colles6', 'colles6short', '', '', 1, 'scaletimes5'),
(7, 'colles7', 'colles7short', '', '', 1, 'scaletimes5'),
(8, 'colles8', 'colles8short', '', '', 1, 'scaletimes5'),
(9, 'colles9', 'colles9short', '', '', 1, 'scaletimes5'),
(10, 'colles10', 'colles10short', '', '', 1, 'scaletimes5'),
(11, 'colles11', 'colles11short', '', '', 1, 'scaletimes5'),
(12, 'colles12', 'colles12short', '', '', 1, 'scaletimes5'),
(13, 'colles13', 'colles13short', '', '', 1, 'scaletimes5'),
(14, 'colles14', 'colles14short', '', '', 1, 'scaletimes5'),
(15, 'colles15', 'colles15short', '', '', 1, 'scaletimes5'),
(16, 'colles16', 'colles16short', '', '', 1, 'scaletimes5'),
(17, 'colles17', 'colles17short', '', '', 1, 'scaletimes5'),
(18, 'colles18', 'colles18short', '', '', 1, 'scaletimes5'),
(19, 'colles19', 'colles19short', '', '', 1, 'scaletimes5'),
(20, 'colles20', 'colles20short', '', '', 1, 'scaletimes5'),
(21, 'colles21', 'colles21short', '', '', 1, 'scaletimes5'),
(22, 'colles22', 'colles22short', '', '', 1, 'scaletimes5'),
(23, 'colles23', 'colles23short', '', '', 1, 'scaletimes5'),
(24, 'colles24', 'colles24short', '', '', 1, 'scaletimes5'),
(25, 'collesm1', 'collesm1short', '1,2,3,4', 'collesmintro', 1, 'scaletimes5'),
(26, 'collesm2', 'collesm2short', '5,6,7,8', 'collesmintro', 1, 'scaletimes5'),
(27, 'collesm3', 'collesm3short', '9,10,11,12', 'collesmintro', 1, 'scaletimes5'),
(28, 'collesm4', 'collesm4short', '13,14,15,16', 'collesmintro', 1, 'scaletimes5'),
(29, 'collesm5', 'collesm5short', '17,18,19,20', 'collesmintro', 1, 'scaletimes5'),
(30, 'collesm6', 'collesm6short', '21,22,23,24', 'collesmintro', 1, 'scaletimes5'),
(31, 'collesm1', 'collesm1short', '1,2,3,4', 'collesmintro', 2, 'scaletimes5'),
(32, 'collesm2', 'collesm2short', '5,6,7,8', 'collesmintro', 2, 'scaletimes5'),
(33, 'collesm3', 'collesm3short', '9,10,11,12', 'collesmintro', 2, 'scaletimes5'),
(34, 'collesm4', 'collesm4short', '13,14,15,16', 'collesmintro', 2, 'scaletimes5'),
(35, 'collesm5', 'collesm5short', '17,18,19,20', 'collesmintro', 2, 'scaletimes5'),
(36, 'collesm6', 'collesm6short', '21,22,23,24', 'collesmintro', 2, 'scaletimes5'),
(37, 'collesm1', 'collesm1short', '1,2,3,4', 'collesmintro', 3, 'scaletimes5'),
(38, 'collesm2', 'collesm2short', '5,6,7,8', 'collesmintro', 3, 'scaletimes5'),
(39, 'collesm3', 'collesm3short', '9,10,11,12', 'collesmintro', 3, 'scaletimes5'),
(40, 'collesm4', 'collesm4short', '13,14,15,16', 'collesmintro', 3, 'scaletimes5'),
(41, 'collesm5', 'collesm5short', '17,18,19,20', 'collesmintro', 3, 'scaletimes5'),
(42, 'collesm6', 'collesm6short', '21,22,23,24', 'collesmintro', 3, 'scaletimes5'),
(43, 'howlong', '', '', '', 1, 'howlongoptions'),
(44, 'othercomments', '', '', '', 0, NULL),
(45, 'attls1', 'attls1short', '', '', 1, 'scaleagree5'),
(46, 'attls2', 'attls2short', '', '', 1, 'scaleagree5'),
(47, 'attls3', 'attls3short', '', '', 1, 'scaleagree5'),
(48, 'attls4', 'attls4short', '', '', 1, 'scaleagree5'),
(49, 'attls5', 'attls5short', '', '', 1, 'scaleagree5'),
(50, 'attls6', 'attls6short', '', '', 1, 'scaleagree5'),
(51, 'attls7', 'attls7short', '', '', 1, 'scaleagree5'),
(52, 'attls8', 'attls8short', '', '', 1, 'scaleagree5'),
(53, 'attls9', 'attls9short', '', '', 1, 'scaleagree5'),
(54, 'attls10', 'attls10short', '', '', 1, 'scaleagree5'),
(55, 'attls11', 'attls11short', '', '', 1, 'scaleagree5'),
(56, 'attls12', 'attls12short', '', '', 1, 'scaleagree5'),
(57, 'attls13', 'attls13short', '', '', 1, 'scaleagree5'),
(58, 'attls14', 'attls14short', '', '', 1, 'scaleagree5'),
(59, 'attls15', 'attls15short', '', '', 1, 'scaleagree5'),
(60, 'attls16', 'attls16short', '', '', 1, 'scaleagree5'),
(61, 'attls17', 'attls17short', '', '', 1, 'scaleagree5'),
(62, 'attls18', 'attls18short', '', '', 1, 'scaleagree5'),
(63, 'attls19', 'attls19short', '', '', 1, 'scaleagree5'),
(64, 'attls20', 'attls20short', '', '', 1, 'scaleagree5'),
(65, 'attlsm1', 'attlsm1', '45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64', 'attlsmintro', 1, 'scaleagree5'),
(66, '-', '-', '-', '-', 0, '-'),
(67, 'attlsm2', 'attlsm2', '63,62,59,57,55,49,52,50,48,47', 'attlsmintro', -1, 'scaleagree5'),
(68, 'attlsm3', 'attlsm3', '46,54,45,51,60,53,56,58,61,64', 'attlsmintro', -1, 'scaleagree5'),
(69, 'ciq1', 'ciq1short', '', '', 0, NULL),
(70, 'ciq2', 'ciq2short', '', '', 0, NULL),
(71, 'ciq3', 'ciq3short', '', '', 0, NULL),
(72, 'ciq4', 'ciq4short', '', '', 0, NULL),
(73, 'ciq5', 'ciq5short', '', '', 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag`
--

CREATE TABLE `[[dbprefix]]tag` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `tagcollid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `rawname` varchar(255) NOT NULL DEFAULT '',
  `isstandard` tinyint(1) NOT NULL DEFAULT '0',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `flag` smallint(4) DEFAULT '0',
  `timemodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tag_tagnam_uix` (`tagcollid`,`name`),
  KEY `[[dbprefix]]tag_tagiss_ix` (`tagcollid`,`isstandard`),
  KEY `[[dbprefix]]tag_use_ix` (`userid`),
  KEY `[[dbprefix]]tag_tag_ix` (`tagcollid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tag table - this generic table will replace the old "tags" t' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_area`
--

CREATE TABLE `[[dbprefix]]tag_area` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemtype` varchar(100) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `tagcollid` bigint(10) NOT NULL,
  `callback` varchar(100) DEFAULT NULL,
  `callbackfile` varchar(100) DEFAULT NULL,
  `showstandard` tinyint(1) NOT NULL DEFAULT '0',
  `multiplecontexts` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tagarea_comite_uix` (`component`,`itemtype`),
  KEY `[[dbprefix]]tagarea_tag_ix` (`tagcollid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines various tag areas, one area is identified by compone' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]tag_area`
--

INSERT INTO `[[dbprefix]]tag_area` VALUES
(1, 'core', 'user', 1, 1, 'user_get_tagged_users', '/user/lib.php', 2, 0),
(2, 'core', 'course', 1, 1, 'course_get_tagged_courses', '/course/lib.php', 0, 0),
(3, 'core_question', 'question', 1, 1, NULL, NULL, 0, 1),
(4, 'core', 'post', 1, 1, 'blog_get_tagged_posts', '/blog/lib.php', 0, 0),
(5, 'core', 'blog_external', 1, 1, NULL, NULL, 0, 0),
(6, 'core', 'course_modules', 1, 1, 'course_get_tagged_course_modules', '/course/lib.php', 0, 0),
(7, 'mod_book', 'book_chapters', 1, 1, 'mod_book_get_tagged_chapters', '/mod/book/locallib.php', 0, 0),
(8, 'mod_data', 'data_records', 1, 1, 'mod_data_get_tagged_records', '/mod/data/locallib.php', 0, 0),
(9, 'mod_forum', 'forum_posts', 1, 1, 'mod_forum_get_tagged_posts', '/mod/forum/locallib.php', 0, 0),
(10, 'mod_glossary', 'glossary_entries', 1, 1, 'mod_glossary_get_tagged_entries', '/mod/glossary/locallib.php', 0, 0),
(11, 'mod_wiki', 'wiki_pages', 1, 1, 'mod_wiki_get_tagged_pages', '/mod/wiki/locallib.php', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_coll`
--

CREATE TABLE `[[dbprefix]]tag_coll` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `isdefault` tinyint(2) NOT NULL DEFAULT '0',
  `component` varchar(100) DEFAULT NULL,
  `sortorder` mediumint(5) NOT NULL DEFAULT '0',
  `searchable` tinyint(2) NOT NULL DEFAULT '1',
  `customurl` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines different set of tags' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]tag_coll`
--

INSERT INTO `[[dbprefix]]tag_coll` VALUES
(1, NULL, 1, NULL, 0, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_correlation`
--

CREATE TABLE `[[dbprefix]]tag_correlation` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `tagid` bigint(10) NOT NULL,
  `correlatedtags` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tagcorr_tag_ix` (`tagid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The rationale for the ''tag_correlation'' table is performance' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_instance`
--

CREATE TABLE `[[dbprefix]]tag_instance` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `tagid` bigint(10) NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemtype` varchar(100) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `contextid` bigint(10) DEFAULT NULL,
  `tiuserid` bigint(10) NOT NULL DEFAULT '0',
  `ordering` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]taginst_comiteiteco_uix` (`component`,`itemtype`,`itemid`,`contextid`,`tiuserid`,`tagid`),
  KEY `[[dbprefix]]taginst_itecomtagcon_ix` (`itemtype`,`component`,`tagid`,`contextid`),
  KEY `[[dbprefix]]taginst_tag_ix` (`tagid`),
  KEY `[[dbprefix]]taginst_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='tag_instance table holds the information of associations bet' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_adhoc`
--

CREATE TABLE `[[dbprefix]]task_adhoc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(255) NOT NULL DEFAULT '',
  `classname` varchar(255) NOT NULL DEFAULT '',
  `nextruntime` bigint(10) NOT NULL,
  `faildelay` bigint(10) DEFAULT NULL,
  `customdata` longtext,
  `userid` bigint(10) DEFAULT NULL,
  `blocking` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timestarted` bigint(10) DEFAULT NULL,
  `hostname` varchar(255) DEFAULT NULL,
  `pid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]taskadho_nex_ix` (`nextruntime`),
  KEY `[[dbprefix]]taskadho_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of adhoc tasks waiting to run.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_log`
--

CREATE TABLE `[[dbprefix]]task_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` smallint(4) NOT NULL,
  `component` varchar(255) NOT NULL DEFAULT '',
  `classname` varchar(255) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `timestart` decimal(20,10) NOT NULL,
  `timeend` decimal(20,10) NOT NULL,
  `dbreads` bigint(10) NOT NULL,
  `dbwrites` bigint(10) NOT NULL,
  `result` tinyint(2) NOT NULL,
  `output` longtext NOT NULL,
  `hostname` varchar(255) DEFAULT NULL,
  `pid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tasklog_cla_ix` (`classname`),
  KEY `[[dbprefix]]tasklog_tim_ix` (`timestart`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The log table for all tasks' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_scheduled`
--

CREATE TABLE `[[dbprefix]]task_scheduled` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(255) NOT NULL DEFAULT '',
  `classname` varchar(255) NOT NULL DEFAULT '',
  `lastruntime` bigint(10) DEFAULT NULL,
  `nextruntime` bigint(10) DEFAULT NULL,
  `blocking` tinyint(2) NOT NULL DEFAULT '0',
  `minute` varchar(25) NOT NULL DEFAULT '',
  `hour` varchar(25) NOT NULL DEFAULT '',
  `day` varchar(25) NOT NULL DEFAULT '',
  `month` varchar(25) NOT NULL DEFAULT '',
  `dayofweek` varchar(25) NOT NULL DEFAULT '',
  `faildelay` bigint(10) DEFAULT NULL,
  `customised` tinyint(2) NOT NULL DEFAULT '0',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `timestarted` bigint(10) DEFAULT NULL,
  `hostname` varchar(255) DEFAULT NULL,
  `pid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tasksche_cla_uix` (`classname`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of scheduled tasks to be run by cron.' AUTO_INCREMENT=106 ;

--
-- Dumping data for table `[[dbprefix]]task_scheduled`
--

INSERT INTO `[[dbprefix]]task_scheduled` VALUES
(1, 'moodle', '\\core\\task\\session_cleanup_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(2, 'moodle', '\\core\\task\\delete_unconfirmed_users_task', 0, [[timestamp]], 0, '0', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(3, 'moodle', '\\core\\task\\delete_incomplete_users_task', 0, [[timestamp]], 0, '5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(4, 'moodle', '\\core\\task\\backup_cleanup_task', 0, [[timestamp]], 0, '10', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(5, 'moodle', '\\core\\task\\tag_cron_task', 0, [[timestamp]], 0, '25', '3', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(6, 'moodle', '\\core\\task\\context_cleanup_task', 0, [[timestamp]], 0, '25', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(7, 'moodle', '\\core\\task\\cache_cleanup_task', 0, [[timestamp]], 0, '30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(8, 'moodle', '\\core\\task\\messaging_cleanup_task', 0, [[timestamp]], 0, '35', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(9, 'moodle', '\\core\\task\\send_new_user_passwords_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(10, 'moodle', '\\core\\task\\send_failed_login_notifications_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(11, 'moodle', '\\core\\task\\create_contexts_task', 0, [[timestamp_nextday]], 1, '0', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(12, 'moodle', '\\core\\task\\legacy_plugin_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(13, 'moodle', '\\core\\task\\grade_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(14, 'moodle', '\\core\\task\\grade_history_cleanup_task', 0, [[timestamp_nextday]], 0, '*', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(15, 'moodle', '\\core\\task\\completion_regular_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(16, 'moodle', '\\core\\task\\completion_daily_task', 0, [[timestamp_nextday]], 0, '51', '20', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(17, 'moodle', '\\core\\task\\portfolio_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(18, 'moodle', '\\core\\task\\plagiarism_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(19, 'moodle', '\\core\\task\\calendar_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(20, 'moodle', '\\core\\task\\blog_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(21, 'moodle', '\\core\\task\\question_preview_cleanup_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(22, 'moodle', '\\core\\task\\question_stats_cleanup_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(23, 'moodle', '\\core\\task\\registration_cron_task', 0, [[timestamp]], 0, '49', '1', '*', '*', '3', 0, 0, 0, NULL, NULL, NULL),
(24, 'moodle', '\\core\\task\\check_for_updates_task', 0, [[timestamp_nextday]], 0, '56', '12', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(25, 'moodle', '\\core\\task\\cache_cron_task', 0, [[timestamp]], 0, '50', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(26, 'moodle', '\\core\\task\\automated_backup_task', 0, [[timestamp]], 0, '50', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(27, 'moodle', '\\core\\task\\badges_cron_task', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(28, 'moodle', '\\core\\task\\badges_message_task', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(29, 'moodle', '\\core\\task\\file_temp_cleanup_task', 0, [[timestamp]], 0, '55', '*/6', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(30, 'moodle', '\\core\\task\\file_trash_cleanup_task', 0, [[timestamp]], 0, '55', '*/6', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(31, 'moodle', '\\core\\task\\search_index_task', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(32, 'moodle', '\\core\\task\\search_optimize_task', 0, [[timestamp]], 0, '15', '*/12', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(33, 'moodle', '\\core\\task\\stats_cron_task', 0, [[timestamp_nextday]], 0, '0', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(34, 'moodle', '\\core\\task\\password_reset_cleanup_task', 0, [[timestamp]], 0, '0', '*/6', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(35, 'moodle', '\\core\\task\\complete_plans_task', 0, [[timestamp]], 0, '49', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(36, 'moodle', '\\core\\task\\sync_plans_from_template_cohorts_task', 0, [[timestamp]], 0, '45', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(37, 'moodle', '\\core_files\\task\\conversion_cleanup_task', 0, [[timestamp_nextday]], 0, '44', '2', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(38, 'moodle', '\\core\\oauth2\\refresh_system_tokens_task', 0, [[timestamp]], 0, '30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(39, 'moodle', '\\core\\task\\analytics_cleanup_task', 0, [[timestamp]], 0, '42', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(40, 'moodle', '\\core\\task\\task_log_cleanup_task', 0, [[timestamp_nextday]], 0, '43', '2', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(41, 'moodle', '\\core\\task\\h5p_get_content_types_task', 0, [[timestamp_nextday]], 0, '5', '6', '1', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(42, 'moodle', '\\core\\task\\h5p_clean_orphaned_records_task', 0, [[timestamp_nextday]], 0, '52', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(43, 'moodle', '\\core\\task\\antivirus_cleanup_task', 0, [[timestamp_nextday]], 0, '9', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(44, 'qtype_random', '\\qtype_random\\task\\remove_unused_questions', 0, [[timestamp]], 0, '54', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(45, 'mod_assign', '\\mod_assign\\task\\cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(46, 'mod_chat', '\\mod_chat\\task\\cron_task', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(47, 'mod_forum', '\\mod_forum\\task\\cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(48, 'mod_lti', '\\mod_lti\\task\\clean_access_tokens', 0, [[timestamp]], 0, '20', '10', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(49, 'mod_quiz', '\\mod_quiz\\task\\update_overdue_attempts', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(50, 'mod_quiz', '\\mod_quiz\\task\\legacy_quiz_reports_cron', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(51, 'mod_quiz', '\\mod_quiz\\task\\legacy_quiz_accessrules_cron', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(52, 'mod_scorm', '\\mod_scorm\\task\\cron_task', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(53, 'mod_workshop', '\\mod_workshop\\task\\cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(54, 'mod_workshop', '\\mod_workshop\\task\\legacy_workshop_allocation_cron', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(55, 'auth_cas', '\\auth_cas\\task\\sync_task', 0, [[timestamp_nextday]], 0, '0', '0', '*', '*', '*', 0, 0, 1, NULL, NULL, NULL),
(56, 'auth_db', '\\auth_db\\task\\sync_users', 0, [[timestamp]], 0, '10', '13', '*', '*', '*', 0, 0, 1, NULL, NULL, NULL),
(57, 'auth_ldap', '\\auth_ldap\\task\\sync_roles', 0, [[timestamp_nextday]], 0, '0', '0', '*', '*', '*', 0, 0, 1, NULL, NULL, NULL),
(58, 'auth_ldap', '\\auth_ldap\\task\\sync_task', 0, [[timestamp_nextday]], 0, '0', '0', '*', '*', '*', 0, 0, 1, NULL, NULL, NULL),
(59, 'auth_mnet', '\\auth_mnet\\task\\cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(60, 'enrol_category', '\\enrol_category\\task\\enrol_category_sync', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(61, 'enrol_cohort', '\\enrol_cohort\\task\\enrol_cohort_sync', 0, [[timestamp]], 0, '25', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(62, 'enrol_database', '\\enrol_database\\task\\sync_enrolments', 0, [[timestamp]], 0, '51', '19', '*', '*', '*', 0, 0, 1, NULL, NULL, NULL),
(63, 'enrol_flatfile', '\\enrol_flatfile\\task\\flatfile_sync_task', 0, [[timestamp]], 0, '15', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(64, 'enrol_imsenterprise', '\\enrol_imsenterprise\\task\\cron_task', 0, [[timestamp]], 0, '10', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(65, 'enrol_ldap', '\\enrol_ldap\\task\\sync_enrolments', 0, [[timestamp]], 0, '50', '17', '*', '*', '*', 0, 0, 1, NULL, NULL, NULL),
(66, 'enrol_lti', '\\enrol_lti\\task\\sync_grades', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(67, 'enrol_lti', '\\enrol_lti\\task\\sync_members', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(68, 'enrol_manual', '\\enrol_manual\\task\\sync_enrolments', 0, [[timestamp]], 0, '*/10', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(69, 'enrol_manual', '\\enrol_manual\\task\\send_expiry_notifications', 0, [[timestamp]], 0, '*/10', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(70, 'enrol_meta', '\\enrol_meta\\task\\enrol_meta_sync', 0, [[timestamp]], 0, '27', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(71, 'enrol_paypal', '\\enrol_paypal\\task\\process_expirations', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(72, 'enrol_self', '\\enrol_self\\task\\sync_enrolments', 0, [[timestamp]], 0, '*/10', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(73, 'enrol_self', '\\enrol_self\\task\\send_expiry_notifications', 0, [[timestamp]], 0, '*/10', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(74, 'message_email', '\\message_email\\task\\send_email_task', 0, [[timestamp_nextday]], 0, '0', '22', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(75, 'block_recent_activity', '\\block_recent_activity\\task\\cleanup', 0, [[timestamp]], 0, '24', '17', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(76, 'block_rss_client', '\\block_rss_client\\task\\refreshfeeds', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(77, 'editor_atto', '\\editor_atto\\task\\autosave_cleanup_task', 0, [[timestamp_nextday]], 0, '24', '23', '*', '*', '5', 0, 0, 0, NULL, NULL, NULL),
(78, 'repository_dropbox', '\\repository_dropbox\\task\\cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(79, 'repository_filesystem', '\\repository_filesystem\\task\\cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(80, 'repository_onedrive', '\\repository_onedrive\\remove_temp_access_task', 0, [[timestamp_nextday]], 0, '47', '19', '*', '*', '2', 0, 0, 0, NULL, NULL, NULL),
(81, 'tool_analytics', '\\tool_analytics\\task\\train_models', 0, [[timestamp]], 0, '0', '20', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(82, 'tool_analytics', '\\tool_analytics\\task\\predict_models', 0, [[timestamp_nextday]], 0, '0', '23', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(83, 'tool_brickfield', '\\tool_brickfield\\task\\bulk_process_courses', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(84, 'tool_brickfield', '\\tool_brickfield\\task\\bulk_process_caches', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(85, 'tool_brickfield', '\\tool_brickfield\\task\\checkid_validation', 0, [[timestamp]], 0, '05', '9', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(86, 'tool_brickfield', '\\tool_brickfield\\task\\update_summarydata', 0, [[timestamp_nextday]], 0, '50', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(87, 'tool_brickfield', '\\tool_brickfield\\task\\process_analysis_requests', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(88, 'tool_cohortroles', '\\tool_cohortroles\\task\\cohort_role_sync', 0, [[timestamp]], 0, '13', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(89, 'tool_dataprivacy', '\\tool_dataprivacy\\task\\expired_retention_period', 0, [[timestamp]], 0, '0', '14', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(90, 'tool_dataprivacy', '\\tool_dataprivacy\\task\\delete_expired_contexts', 0, [[timestamp]], 0, '0', '5', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(91, 'tool_dataprivacy', '\\tool_dataprivacy\\task\\delete_expired_requests', 0, [[timestamp]], 0, '41', '4', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(92, 'tool_dataprivacy', '\\tool_dataprivacy\\task\\delete_existing_deleted_users', 0, [[timestamp_nextday]], 0, '4', '20', '*', '*', '*', 0, 0, 1, NULL, NULL, NULL),
(93, 'tool_langimport', '\\tool_langimport\\task\\update_langpacks_task', 0, [[timestamp]], 0, '1', '4', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(94, 'tool_messageinbound', '\\tool_messageinbound\\task\\pickup_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(95, 'tool_messageinbound', '\\tool_messageinbound\\task\\cleanup_task', 0, [[timestamp_nextday]], 0, '55', '1', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(96, 'tool_monitor', '\\tool_monitor\\task\\clean_events', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(97, 'tool_monitor', '\\tool_monitor\\task\\check_subscriptions', 0, [[timestamp_nextday]], 0, '57', '14', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(98, 'tool_recyclebin', '\\tool_recyclebin\\task\\cleanup_course_bin', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(99, 'tool_recyclebin', '\\tool_recyclebin\\task\\cleanup_category_bin', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(100, 'assignfeedback_editpdf', '\\assignfeedback_editpdf\\task\\convert_submissions', 0, [[timestamp]], 0, '*/15', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(101, 'ltiservice_gradebookservices', '\\ltiservice_gradebookservices\\task\\cleanup_task', 0, [[timestamp]], 0, '16', '2', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(102, 'quiz_statistics', '\\quiz_statistics\\task\\quiz_statistics_cleanup', 0, [[timestamp]], 0, '27', '*/5', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(103, 'workshopallocation_scheduled', '\\workshopallocation_scheduled\\task\\cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(104, 'logstore_legacy', '\\logstore_legacy\\task\\cleanup_task', 0, [[timestamp]], 0, '15', '5', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(105, 'logstore_standard', '\\logstore_standard\\task\\cleanup_task', 0, [[timestamp]], 0, '52', '4', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_areas`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_areas` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` tinyint(2) NOT NULL DEFAULT '0',
  `contextid` bigint(10) DEFAULT NULL,
  `component` varchar(100) DEFAULT NULL,
  `tablename` varchar(40) DEFAULT NULL,
  `fieldorarea` varchar(50) DEFAULT NULL,
  `itemid` bigint(10) DEFAULT NULL,
  `filename` varchar(1333) DEFAULT NULL,
  `reftable` varchar(40) DEFAULT NULL,
  `refid` bigint(10) DEFAULT NULL,
  `cmid` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolbricarea_coucmi_ix` (`courseid`,`cmid`),
  KEY `[[dbprefix]]toolbricarea_typtabi_ix` (`type`,`tablename`,`itemid`,`fieldorarea`),
  KEY `[[dbprefix]]toolbricarea_typconc_ix` (`type`,`contextid`,`component`,`fieldorarea`,`itemid`),
  KEY `[[dbprefix]]toolbricarea_refreft_ix` (`reftable`,`refid`,`type`),
  KEY `[[dbprefix]]toolbricarea_cou_ix` (`courseid`),
  KEY `[[dbprefix]]toolbricarea_cmi_ix` (`cmid`),
  KEY `[[dbprefix]]toolbricarea_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]toolbricarea_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Areas that have been checked for accessibility problems' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_cache_acts`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_cache_acts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `component` varchar(64) DEFAULT NULL,
  `totalactivities` bigint(10) DEFAULT NULL,
  `failedactivities` bigint(10) DEFAULT NULL,
  `passedactivities` bigint(10) DEFAULT NULL,
  `errorcount` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolbriccachacts_sta_ix` (`status`),
  KEY `[[dbprefix]]toolbriccachacts_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains accessibility summary information per activity.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_cache_check`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_cache_check` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `checkid` bigint(10) DEFAULT NULL,
  `checkcount` bigint(10) DEFAULT NULL,
  `errorcount` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolbriccachchec_sta_ix` (`status`),
  KEY `[[dbprefix]]toolbriccachchec_err_ix` (`errorcount`),
  KEY `[[dbprefix]]toolbriccachchec_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains accessibility summary information per check.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_checks`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_checks` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `checktype` varchar(64) DEFAULT NULL,
  `shortname` varchar(64) DEFAULT NULL,
  `checkgroup` bigint(16) DEFAULT '0',
  `status` smallint(4) NOT NULL,
  `severity` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolbricchec_che_ix` (`checktype`),
  KEY `[[dbprefix]]toolbricchec_che2_ix` (`checkgroup`),
  KEY `[[dbprefix]]toolbricchec_sta_ix` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Checks details' AUTO_INCREMENT=32 ;

--
-- Dumping data for table `[[dbprefix]]tool_brickfield_checks`
--

INSERT INTO `[[dbprefix]]tool_brickfield_checks` VALUES
(1, 'full', 'a_links_dont_open_new_window', 4, 1, 1),
(2, 'full', 'a_must_contain_text', 4, 1, 1),
(3, 'full', 'area_dont_open_new_window', 4, 1, 1),
(4, 'full', 'area_has_alt_value', 4, 1, 1),
(5, 'full', 'a_suspicious_link_text', 4, 1, 1),
(6, 'full', 'basefont_is_not_used', 7, 1, 1),
(7, 'full', 'blink_is_not_used', 7, 1, 1),
(8, 'full', 'bold_is_not_used', 7, 1, 1),
(9, 'full', 'content_too_long', 7, 1, 1),
(10, 'full', 'css_text_has_contrast', 7, 1, 1),
(11, 'full', 'embed_has_associated_no_embed', 7, 1, 1),
(12, 'full', 'header_h3', 3, 1, 1),
(13, 'full', 'headers_have_text', 3, 1, 1),
(14, 'full', 'i_is_not_used', 7, 1, 1),
(15, 'full', 'img_alt_is_different', 2, 1, 1),
(16, 'full', 'img_alt_is_too_long', 2, 1, 1),
(17, 'full', 'img_alt_not_empty_in_anchor', 2, 1, 1),
(18, 'full', 'img_alt_not_place_holder', 2, 1, 1),
(19, 'full', 'img_has_alt', 2, 1, 1),
(20, 'full', 'img_with_map_has_use_map', 2, 1, 1),
(21, 'full', 'legend_text_not_empty', 7, 1, 1),
(22, 'full', 'marquee_is_not_used', 7, 1, 1),
(23, 'full', 'no_headings', 3, 1, 1),
(24, 'full', 'object_must_have_embed', 5, 1, 1),
(25, 'full', 'object_must_have_title', 5, 1, 1),
(26, 'full', 'object_must_have_valid_title', 5, 1, 1),
(27, 'full', 'strike_is_not_used', 7, 1, 1),
(28, 'full', 'table_data_should_have_th', 6, 1, 1),
(29, 'full', 'table_summary_does_not_duplicate_caption', 6, 1, 1),
(30, 'full', 'table_td_should_not_merge', 6, 1, 1),
(31, 'full', 'table_th_should_have_scope', 6, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_content`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_content` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `areaid` bigint(10) NOT NULL,
  `contenthash` varchar(40) NOT NULL DEFAULT '',
  `iscurrent` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL,
  `timechecked` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolbriccont_sta_ix` (`status`),
  KEY `[[dbprefix]]toolbriccont_iscare_ix` (`iscurrent`,`areaid`),
  KEY `[[dbprefix]]toolbriccont_are_ix` (`areaid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Content of an area at a particular time (recognised by a has' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_errors`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_errors` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `resultid` bigint(10) NOT NULL,
  `linenumber` bigint(10) NOT NULL DEFAULT '0',
  `errordata` longtext,
  `htmlcode` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolbricerro_res_ix` (`resultid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Errors during the accessibility checks' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_process`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_process` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `item` varchar(64) DEFAULT NULL,
  `contextid` bigint(10) DEFAULT NULL,
  `innercontextid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(16) DEFAULT NULL,
  `timecompleted` bigint(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolbricproc_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Queued records to initiate new processing of specific target' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_results`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_results` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contentid` bigint(10) DEFAULT NULL,
  `checkid` bigint(10) NOT NULL,
  `errorcount` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolbricresu_conche_ix` (`contentid`,`checkid`),
  KEY `[[dbprefix]]toolbricresu_con_ix` (`contentid`),
  KEY `[[dbprefix]]toolbricresu_che_ix` (`checkid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Results of the accessibility checks' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_schedule`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_schedule` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint(10) NOT NULL DEFAULT '50',
  `instanceid` bigint(10) NOT NULL,
  `contextid` bigint(10) DEFAULT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `timeanalyzed` bigint(10) DEFAULT '0',
  `timemodified` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]toolbricsche_conins_uix` (`contextlevel`,`instanceid`),
  KEY `[[dbprefix]]toolbricsche_sta_ix` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps the per course content analysis schedule.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_brickfield_summary`
--

CREATE TABLE `[[dbprefix]]tool_brickfield_summary` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `activities` bigint(10) DEFAULT NULL,
  `activitiespassed` bigint(10) DEFAULT NULL,
  `activitiesfailed` bigint(10) DEFAULT NULL,
  `errorschecktype1` bigint(10) DEFAULT NULL,
  `errorschecktype2` bigint(10) DEFAULT NULL,
  `errorschecktype3` bigint(10) DEFAULT NULL,
  `errorschecktype4` bigint(10) DEFAULT NULL,
  `errorschecktype5` bigint(10) DEFAULT NULL,
  `errorschecktype6` bigint(10) DEFAULT NULL,
  `errorschecktype7` bigint(10) DEFAULT NULL,
  `failedchecktype1` bigint(10) DEFAULT NULL,
  `failedchecktype2` bigint(10) DEFAULT NULL,
  `failedchecktype3` bigint(10) DEFAULT NULL,
  `failedchecktype4` bigint(10) DEFAULT NULL,
  `failedchecktype5` bigint(10) DEFAULT NULL,
  `failedchecktype6` bigint(10) DEFAULT NULL,
  `failedchecktype7` bigint(10) DEFAULT NULL,
  `percentchecktype1` bigint(10) DEFAULT NULL,
  `percentchecktype2` bigint(10) DEFAULT NULL,
  `percentchecktype3` bigint(10) DEFAULT NULL,
  `percentchecktype4` bigint(10) DEFAULT NULL,
  `percentchecktype5` bigint(10) DEFAULT NULL,
  `percentchecktype6` bigint(10) DEFAULT NULL,
  `percentchecktype7` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolbricsumm_sta_ix` (`status`),
  KEY `[[dbprefix]]toolbricsumm_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains accessibility check results summary information.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_cohortroles`
--

CREATE TABLE `[[dbprefix]]tool_cohortroles` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cohortid` bigint(10) NOT NULL,
  `roleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]toolcoho_cohroluse_uix` (`cohortid`,`roleid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Mapping of users to cohort role assignments.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_customlang`
--

CREATE TABLE `[[dbprefix]]tool_customlang` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lang` varchar(20) NOT NULL DEFAULT '',
  `componentid` bigint(10) NOT NULL,
  `stringid` varchar(255) NOT NULL DEFAULT '',
  `original` longtext NOT NULL,
  `master` longtext,
  `local` longtext,
  `timemodified` bigint(10) NOT NULL,
  `timecustomized` bigint(10) DEFAULT NULL,
  `outdated` smallint(3) DEFAULT '0',
  `modified` smallint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]toolcust_lancomstr_uix` (`lang`,`componentid`,`stringid`),
  KEY `[[dbprefix]]toolcust_com_ix` (`componentid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains the working checkout of all strings and their custo' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_customlang_components`
--

CREATE TABLE `[[dbprefix]]tool_customlang_components` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains the list of all installed plugins that provide thei' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_category`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_category` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(1) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Data categories' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_ctxexpired`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_ctxexpired` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `unexpiredroles` longtext,
  `expiredroles` longtext,
  `defaultexpired` tinyint(1) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tooldatactxe_con_uix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_ctxinstance`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_ctxinstance` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `purposeid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tooldatactxi_con_uix` (`contextid`),
  KEY `[[dbprefix]]tooldatactxi_pur_ix` (`purposeid`),
  KEY `[[dbprefix]]tooldatactxi_cat_ix` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_ctxlevel`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_ctxlevel` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextlevel` smallint(3) NOT NULL,
  `purposeid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tooldatactxl_con_uix` (`contextlevel`),
  KEY `[[dbprefix]]tooldatactxl_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]tooldatactxl_pur_ix` (`purposeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_purpose`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_purpose` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(1) DEFAULT NULL,
  `lawfulbases` longtext NOT NULL,
  `sensitivedatareasons` longtext,
  `retentionperiod` varchar(255) NOT NULL DEFAULT '',
  `protected` tinyint(1) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Data purposes' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_purposerole`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_purposerole` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `purposeid` bigint(10) NOT NULL,
  `roleid` bigint(10) NOT NULL,
  `lawfulbases` longtext,
  `sensitivedatareasons` longtext,
  `retentionperiod` varchar(255) NOT NULL DEFAULT '',
  `protected` tinyint(1) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tooldatapurp_purrol_uix` (`purposeid`,`roleid`),
  KEY `[[dbprefix]]tooldatapurp_pur_ix` (`purposeid`),
  KEY `[[dbprefix]]tooldatapurp_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Data purpose overrides for a specific role' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_request`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_request` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` bigint(10) NOT NULL DEFAULT '0',
  `comments` longtext,
  `commentsformat` tinyint(2) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `requestedby` bigint(10) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `dpo` bigint(10) DEFAULT '0',
  `dpocomment` longtext,
  `dpocommentformat` tinyint(2) NOT NULL DEFAULT '0',
  `systemapproved` smallint(4) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `creationmethod` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tooldatarequ_use_ix` (`userid`),
  KEY `[[dbprefix]]tooldatarequ_req_ix` (`requestedby`),
  KEY `[[dbprefix]]tooldatarequ_dpo_ix` (`dpo`),
  KEY `[[dbprefix]]tooldatarequ_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table for data requests' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_monitor_events`
--

CREATE TABLE `[[dbprefix]]tool_monitor_events` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(254) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `contextlevel` bigint(10) NOT NULL,
  `contextinstanceid` bigint(10) NOT NULL,
  `link` varchar(254) NOT NULL DEFAULT '',
  `courseid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A table that keeps a log of events related to subscriptions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_monitor_history`
--

CREATE TABLE `[[dbprefix]]tool_monitor_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `sid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timesent` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]toolmonihist_siduse_uix` (`sid`,`userid`,`timesent`),
  KEY `[[dbprefix]]toolmonihist_sid_ix` (`sid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to store history of message notifications sent' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_monitor_rules`
--

CREATE TABLE `[[dbprefix]]tool_monitor_rules` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `description` longtext,
  `descriptionformat` tinyint(1) NOT NULL,
  `name` varchar(254) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `plugin` varchar(254) NOT NULL DEFAULT '',
  `eventname` varchar(254) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `templateformat` tinyint(1) NOT NULL,
  `frequency` smallint(4) NOT NULL,
  `timewindow` mediumint(5) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolmonirule_couuse_ix` (`courseid`,`userid`),
  KEY `[[dbprefix]]toolmonirule_eve_ix` (`eventname`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to store rules' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_monitor_subscriptions`
--

CREATE TABLE `[[dbprefix]]tool_monitor_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `ruleid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `lastnotificationsent` bigint(10) NOT NULL DEFAULT '0',
  `inactivedate` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolmonisubs_couuse_ix` (`courseid`,`userid`),
  KEY `[[dbprefix]]toolmonisubs_rul_ix` (`ruleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to store user subscriptions to various rules' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_policy`
--

CREATE TABLE `[[dbprefix]]tool_policy` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `sortorder` mediumint(5) NOT NULL DEFAULT '999',
  `currentversionid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolpoli_cur_ix` (`currentversionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains the list of policy documents defined on the site.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_policy_acceptances`
--

CREATE TABLE `[[dbprefix]]tool_policy_acceptances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `policyversionid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `lang` varchar(30) NOT NULL DEFAULT '',
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `note` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]toolpoliacce_poluse_uix` (`policyversionid`,`userid`),
  KEY `[[dbprefix]]toolpoliacce_pol_ix` (`policyversionid`),
  KEY `[[dbprefix]]toolpoliacce_use_ix` (`userid`),
  KEY `[[dbprefix]]toolpoliacce_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tracks users accepting the policy versions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_policy_versions`
--

CREATE TABLE `[[dbprefix]]tool_policy_versions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(1333) NOT NULL DEFAULT '',
  `type` smallint(3) NOT NULL DEFAULT '0',
  `audience` smallint(3) NOT NULL DEFAULT '0',
  `archived` smallint(3) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `policyid` bigint(10) NOT NULL,
  `agreementstyle` smallint(3) NOT NULL DEFAULT '0',
  `optional` smallint(3) NOT NULL DEFAULT '0',
  `revision` varchar(1333) NOT NULL DEFAULT '',
  `summary` longtext NOT NULL,
  `summaryformat` smallint(3) NOT NULL,
  `content` longtext NOT NULL,
  `contentformat` smallint(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolpolivers_use_ix` (`usermodified`),
  KEY `[[dbprefix]]toolpolivers_pol_ix` (`policyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Holds versions of the policy documents' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_recyclebin_category`
--

CREATE TABLE `[[dbprefix]]tool_recyclebin_category` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `categoryid` bigint(10) NOT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `fullname` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolrecycate_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]toolrecycate_cat_ix` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A list of items in the category recycle bin' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_recyclebin_course`
--

CREATE TABLE `[[dbprefix]]tool_recyclebin_course` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `section` bigint(10) NOT NULL,
  `module` bigint(10) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolrecycour_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]toolrecycour_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A list of items in the course recycle bin' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_usertours_steps`
--

CREATE TABLE `[[dbprefix]]tool_usertours_steps` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `tourid` bigint(10) NOT NULL,
  `title` longtext,
  `content` longtext,
  `targettype` tinyint(2) NOT NULL,
  `targetvalue` longtext NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `configdata` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tooluserstep_tousor_ix` (`tourid`,`sortorder`),
  KEY `[[dbprefix]]tooluserstep_tou_ix` (`tourid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Steps in an tour' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]tool_usertours_steps`
--

INSERT INTO `[[dbprefix]]tool_usertours_steps` VALUES
(1, 1, 'tour_activityinfo_course_teacher_title,tool_usertours', 'tour_activityinfo_course_teacher_content,tool_usertours', 0, '[data-region=activity-information]', 0, '{}'),
(2, 2, 'tour_activityinfo_course_student_title,tool_usertours', 'tour_activityinfo_course_student_content,tool_usertours', 0, '[data-region=activity-information]', 0, '{}'),
(3, 3, 'tour_activityinfo_activity_teacher_title,tool_usertours', 'tour_activityinfo_activity_teacher_content,tool_usertours', 0, '[data-region=activity-information]', 0, '{}'),
(4, 4, 'tour_activityinfo_activity_student_title,tool_usertours', 'tour_activityinfo_activity_student_content,tool_usertours', 0, '[data-region=activity-information]', 0, '{}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_usertours_tours`
--

CREATE TABLE `[[dbprefix]]tool_usertours_tours` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `pathmatch` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `configdata` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of tours' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]tool_usertours_tours`
--

INSERT INTO `[[dbprefix]]tool_usertours_tours` VALUES
(1, 'Activity information in course homepage (Teacher)', 'A tour of the activity information for Teacher display on the course homepage', '/course/view.php%', 1, 3, '{"placement":"bottom","orphan":"0","backdrop":"1","reflex":"0","filtervalues":{"accessdate":{"filter_accessdate":"tool_usertours_accountcreation","filter_accessdate_range":0,"filter_accessdate_enabled":"0"},"category":[],"course":[],"courseformat":[],"role":["manager","teacher","editingteacher"],"theme":[],"cssselector":["[data-region=activity-information]"]},"majorupdatetime":1620109487,"shipped_tour":true,"shipped_filename":"311_activity_information_course_page_teacher.json","shipped_version":2}'),
(2, 'Activity information in course homepage (Student)', 'A tour of the activity information for Student display on the course homepage', '/course/view.php%', 1, 2, '{"placement":"bottom","orphan":"0","backdrop":"1","reflex":"0","filtervalues":{"accessdate":{"filter_accessdate":"tool_usertours_accountcreation","filter_accessdate_range":0,"filter_accessdate_enabled":"0"},"category":[],"course":[],"courseformat":[],"role":["student"],"theme":[],"cssselector":["[data-region=activity-information]"]},"majorupdatetime":1620109487,"shipped_tour":true,"shipped_filename":"311_activity_information_course_page_student.json","shipped_version":2}'),
(3, 'Activity information in activity page (Teacher)', 'A tour of the activity information for Teacher display on the activity page', '/mod/%/view.php%', 1, 1, '{"placement":"bottom","orphan":"0","backdrop":"1","reflex":"0","filtervalues":{"accessdate":{"filter_accessdate":"tool_usertours_accountcreation","filter_accessdate_range":0,"filter_accessdate_enabled":"0"},"category":[],"course":[],"courseformat":[],"role":["manager","teacher","editingteacher"],"theme":[],"cssselector":["[data-region=activity-information]"]},"majorupdatetime":1620110287,"shipped_tour":true,"shipped_filename":"311_activity_information_activity_page_teacher.json","shipped_version":2}'),
(4, 'Activity information in activity page (Student)', 'A tour of the activity information for Student display on the activity page', '/mod/%/view.php%', 1, 0, '{"placement":"bottom","orphan":"0","backdrop":"1","reflex":"0","filtervalues":{"accessdate":{"filter_accessdate":"tool_usertours_accountcreation","filter_accessdate_range":0,"filter_accessdate_enabled":"0"},"category":[],"course":[],"courseformat":[],"role":["student"],"theme":[],"cssselector":["[data-region=activity-information]"]},"majorupdatetime":1620110287,"shipped_tour":true,"shipped_filename":"311_activity_information_activity_page_student.json","shipped_version":2}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]upgrade_log`
--

CREATE TABLE `[[dbprefix]]upgrade_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` bigint(10) NOT NULL,
  `plugin` varchar(100) DEFAULT NULL,
  `version` varchar(100) DEFAULT NULL,
  `targetversion` varchar(100) DEFAULT NULL,
  `info` varchar(255) NOT NULL DEFAULT '',
  `details` longtext,
  `backtrace` longtext,
  `userid` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]upgrlog_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]upgrlog_typtim_ix` (`type`,`timemodified`),
  KEY `[[dbprefix]]upgrlog_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Upgrade logging' AUTO_INCREMENT=1254 ;

--
-- Dumping data for table `[[dbprefix]]upgrade_log`
--

INSERT INTO `[[dbprefix]]upgrade_log` VALUES
(1, 0, 'core', '2021051718', '2021051718', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(2, 0, 'core', '2021051718', '2021051718', 'Core installed', NULL, '', 0, [[timestamp]]),
(3, 0, 'antivirus_clamav', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(4, 0, 'antivirus_clamav', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(5, 0, 'antivirus_clamav', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(6, 0, 'availability_completion', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(7, 0, 'availability_completion', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(8, 0, 'availability_completion', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(9, 0, 'availability_date', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(10, 0, 'availability_date', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(11, 0, 'availability_date', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(12, 0, 'availability_grade', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(13, 0, 'availability_grade', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(14, 0, 'availability_grade', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(15, 0, 'availability_group', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(16, 0, 'availability_group', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(17, 0, 'availability_group', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(18, 0, 'availability_grouping', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(19, 0, 'availability_grouping', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(20, 0, 'availability_grouping', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(21, 0, 'availability_profile', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(22, 0, 'availability_profile', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(23, 0, 'availability_profile', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(24, 0, 'qtype_calculated', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(25, 0, 'qtype_calculated', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(26, 0, 'qtype_calculated', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(27, 0, 'qtype_calculatedmulti', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(28, 0, 'qtype_calculatedmulti', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(29, 0, 'qtype_calculatedmulti', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(30, 0, 'qtype_calculatedsimple', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(31, 0, 'qtype_calculatedsimple', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(32, 0, 'qtype_calculatedsimple', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(33, 0, 'qtype_ddimageortext', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(34, 0, 'qtype_ddimageortext', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(35, 0, 'qtype_ddimageortext', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(36, 0, 'qtype_ddmarker', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(37, 0, 'qtype_ddmarker', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(38, 0, 'qtype_ddmarker', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(39, 0, 'qtype_ddwtos', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(40, 0, 'qtype_ddwtos', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(41, 0, 'qtype_ddwtos', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(42, 0, 'qtype_description', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(43, 0, 'qtype_description', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(44, 0, 'qtype_description', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(45, 0, 'qtype_essay', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(46, 0, 'qtype_essay', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(47, 0, 'qtype_essay', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(48, 0, 'qtype_gapselect', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(49, 0, 'qtype_gapselect', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(50, 0, 'qtype_gapselect', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(51, 0, 'qtype_match', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(52, 0, 'qtype_match', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(53, 0, 'qtype_match', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(54, 0, 'qtype_missingtype', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(55, 0, 'qtype_missingtype', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(56, 0, 'qtype_missingtype', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(57, 0, 'qtype_multianswer', NULL, '2021051701', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(58, 0, 'qtype_multianswer', '2021051701', '2021051701', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(59, 0, 'qtype_multianswer', '2021051701', '2021051701', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(60, 0, 'qtype_multichoice', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(61, 0, 'qtype_multichoice', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(62, 0, 'qtype_multichoice', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(63, 0, 'qtype_numerical', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(64, 0, 'qtype_numerical', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(65, 0, 'qtype_numerical', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(66, 0, 'qtype_random', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(67, 0, 'qtype_random', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(68, 0, 'qtype_random', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(69, 0, 'qtype_randomsamatch', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(70, 0, 'qtype_randomsamatch', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(71, 0, 'qtype_randomsamatch', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(72, 0, 'qtype_shortanswer', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(73, 0, 'qtype_shortanswer', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(74, 0, 'qtype_shortanswer', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(75, 0, 'qtype_truefalse', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(76, 0, 'qtype_truefalse', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(77, 0, 'qtype_truefalse', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(78, 0, 'mod_assign', NULL, '2021051701', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(79, 0, 'mod_assign', '2021051701', '2021051701', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(80, 0, 'mod_assign', '2021051701', '2021051701', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(81, 0, 'mod_assignment', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(82, 0, 'mod_assignment', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(83, 0, 'mod_assignment', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(84, 0, 'mod_book', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(85, 0, 'mod_book', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(86, 0, 'mod_book', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(87, 0, 'mod_chat', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(88, 0, 'mod_chat', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(89, 0, 'mod_chat', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(90, 0, 'mod_choice', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(91, 0, 'mod_choice', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(92, 0, 'mod_choice', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(93, 0, 'mod_data', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(94, 0, 'mod_data', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(95, 0, 'mod_data', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(96, 0, 'mod_feedback', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(97, 0, 'mod_feedback', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(98, 0, 'mod_feedback', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(99, 0, 'mod_folder', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(100, 0, 'mod_folder', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(101, 0, 'mod_folder', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(102, 0, 'mod_forum', NULL, '2021051701', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(103, 0, 'mod_forum', '2021051701', '2021051701', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(104, 0, 'mod_forum', '2021051701', '2021051701', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(105, 0, 'mod_glossary', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(106, 0, 'mod_glossary', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(107, 0, 'mod_glossary', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(108, 0, 'mod_h5pactivity', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(109, 0, 'mod_h5pactivity', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(110, 0, 'mod_h5pactivity', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(111, 0, 'mod_imscp', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(112, 0, 'mod_imscp', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(113, 0, 'mod_imscp', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(114, 0, 'mod_label', NULL, '2021051701', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(115, 0, 'mod_label', '2021051701', '2021051701', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(116, 0, 'mod_label', '2021051701', '2021051701', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(117, 0, 'mod_lesson', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(118, 0, 'mod_lesson', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(119, 0, 'mod_lesson', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(120, 0, 'mod_lti', NULL, '2021051701', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(121, 0, 'mod_lti', '2021051701', '2021051701', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(122, 0, 'mod_lti', '2021051701', '2021051701', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(123, 0, 'mod_page', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(124, 0, 'mod_page', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(125, 0, 'mod_page', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(126, 0, 'mod_quiz', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(127, 0, 'mod_quiz', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(128, 0, 'mod_quiz', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(129, 0, 'mod_resource', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(130, 0, 'mod_resource', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(131, 0, 'mod_resource', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(132, 0, 'mod_scorm', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(133, 0, 'mod_scorm', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(134, 0, 'mod_scorm', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(135, 0, 'mod_survey', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(136, 0, 'mod_survey', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(137, 0, 'mod_survey', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(138, 0, 'mod_url', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(139, 0, 'mod_url', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(140, 0, 'mod_url', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(141, 0, 'mod_wiki', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(142, 0, 'mod_wiki', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(143, 0, 'mod_wiki', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(144, 0, 'mod_workshop', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(145, 0, 'mod_workshop', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(146, 0, 'mod_workshop', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(147, 0, 'auth_cas', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(148, 0, 'auth_cas', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(149, 0, 'auth_cas', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(150, 0, 'auth_db', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(151, 0, 'auth_db', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(152, 0, 'auth_db', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(153, 0, 'auth_email', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(154, 0, 'auth_email', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(155, 0, 'auth_email', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(156, 0, 'auth_ldap', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(157, 0, 'auth_ldap', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(158, 0, 'auth_ldap', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(159, 0, 'auth_lti', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(160, 0, 'auth_lti', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(161, 0, 'auth_lti', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(162, 0, 'auth_manual', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(163, 0, 'auth_manual', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(164, 0, 'auth_manual', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(165, 0, 'auth_mnet', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(166, 0, 'auth_mnet', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(167, 0, 'auth_mnet', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(168, 0, 'auth_nologin', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(169, 0, 'auth_nologin', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(170, 0, 'auth_nologin', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(171, 0, 'auth_none', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(172, 0, 'auth_none', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(173, 0, 'auth_none', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(174, 0, 'auth_oauth2', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(175, 0, 'auth_oauth2', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(176, 0, 'auth_oauth2', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(177, 0, 'auth_shibboleth', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(178, 0, 'auth_shibboleth', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(179, 0, 'auth_shibboleth', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(180, 0, 'auth_webservice', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(181, 0, 'auth_webservice', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(182, 0, 'auth_webservice', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(183, 0, 'calendartype_gregorian', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(184, 0, 'calendartype_gregorian', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(185, 0, 'calendartype_gregorian', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(186, 0, 'customfield_checkbox', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(187, 0, 'customfield_checkbox', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(188, 0, 'customfield_checkbox', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(189, 0, 'customfield_date', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(190, 0, 'customfield_date', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(191, 0, 'customfield_date', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(192, 0, 'customfield_select', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(193, 0, 'customfield_select', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(194, 0, 'customfield_select', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(195, 0, 'customfield_text', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(196, 0, 'customfield_text', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(197, 0, 'customfield_text', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(198, 0, 'customfield_textarea', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(199, 0, 'customfield_textarea', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(200, 0, 'customfield_textarea', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(201, 0, 'enrol_category', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(202, 0, 'enrol_category', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(203, 0, 'enrol_category', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(204, 0, 'enrol_cohort', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(205, 0, 'enrol_cohort', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(206, 0, 'enrol_cohort', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(207, 0, 'enrol_database', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(208, 0, 'enrol_database', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(209, 0, 'enrol_database', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(210, 0, 'enrol_fee', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(211, 0, 'enrol_fee', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(212, 0, 'enrol_fee', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(213, 0, 'enrol_flatfile', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(214, 0, 'enrol_flatfile', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(215, 0, 'enrol_flatfile', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(216, 0, 'enrol_guest', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(217, 0, 'enrol_guest', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(218, 0, 'enrol_guest', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(219, 0, 'enrol_imsenterprise', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(220, 0, 'enrol_imsenterprise', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(221, 0, 'enrol_imsenterprise', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(222, 0, 'enrol_ldap', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(223, 0, 'enrol_ldap', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(224, 0, 'enrol_ldap', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(225, 0, 'enrol_lti', NULL, '2021051703', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(226, 0, 'enrol_lti', '2021051703', '2021051703', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(227, 0, 'enrol_lti', '2021051703', '2021051703', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(228, 0, 'enrol_manual', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(229, 0, 'enrol_manual', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(230, 0, 'enrol_manual', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(231, 0, 'enrol_meta', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(232, 0, 'enrol_meta', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(233, 0, 'enrol_meta', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(234, 0, 'enrol_mnet', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(235, 0, 'enrol_mnet', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(236, 0, 'enrol_mnet', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(237, 0, 'enrol_paypal', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(238, 0, 'enrol_paypal', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(239, 0, 'enrol_paypal', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(240, 0, 'enrol_self', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(241, 0, 'enrol_self', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(242, 0, 'enrol_self', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(243, 0, 'message_airnotifier', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(244, 0, 'message_airnotifier', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(245, 0, 'message_airnotifier', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(246, 0, 'message_email', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(247, 0, 'message_email', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(248, 0, 'message_email', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(249, 0, 'message_jabber', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(250, 0, 'message_jabber', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(251, 0, 'message_jabber', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(252, 0, 'message_popup', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(253, 0, 'message_popup', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(254, 0, 'message_popup', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(255, 0, 'block_accessreview', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(256, 0, 'block_accessreview', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(257, 0, 'block_accessreview', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(258, 0, 'block_activity_modules', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(259, 0, 'block_activity_modules', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(260, 0, 'block_activity_modules', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(261, 0, 'block_activity_results', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(262, 0, 'block_activity_results', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(263, 0, 'block_activity_results', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(264, 0, 'block_admin_bookmarks', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(265, 0, 'block_admin_bookmarks', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(266, 0, 'block_admin_bookmarks', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(267, 0, 'block_badges', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(268, 0, 'block_badges', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(269, 0, 'block_badges', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(270, 0, 'block_blog_menu', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(271, 0, 'block_blog_menu', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(272, 0, 'block_blog_menu', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(273, 0, 'block_blog_recent', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(274, 0, 'block_blog_recent', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(275, 0, 'block_blog_recent', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(276, 0, 'block_blog_tags', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(277, 0, 'block_blog_tags', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(278, 0, 'block_blog_tags', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(279, 0, 'block_calendar_month', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(280, 0, 'block_calendar_month', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(281, 0, 'block_calendar_month', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(282, 0, 'block_calendar_upcoming', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(283, 0, 'block_calendar_upcoming', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(284, 0, 'block_calendar_upcoming', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(285, 0, 'block_comments', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(286, 0, 'block_comments', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(287, 0, 'block_comments', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(288, 0, 'block_completionstatus', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(289, 0, 'block_completionstatus', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(290, 0, 'block_completionstatus', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(291, 0, 'block_course_list', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(292, 0, 'block_course_list', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(293, 0, 'block_course_list', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(294, 0, 'block_course_summary', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(295, 0, 'block_course_summary', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(296, 0, 'block_course_summary', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(297, 0, 'block_feedback', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(298, 0, 'block_feedback', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(299, 0, 'block_feedback', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(300, 0, 'block_globalsearch', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(301, 0, 'block_globalsearch', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(302, 0, 'block_globalsearch', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(303, 0, 'block_glossary_random', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(304, 0, 'block_glossary_random', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(305, 0, 'block_glossary_random', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(306, 0, 'block_html', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(307, 0, 'block_html', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(308, 0, 'block_html', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(309, 0, 'block_login', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(310, 0, 'block_login', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(311, 0, 'block_login', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(312, 0, 'block_lp', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(313, 0, 'block_lp', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(314, 0, 'block_lp', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(315, 0, 'block_mentees', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(316, 0, 'block_mentees', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(317, 0, 'block_mentees', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(318, 0, 'block_mnet_hosts', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(319, 0, 'block_mnet_hosts', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(320, 0, 'block_mnet_hosts', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(321, 0, 'block_myoverview', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(322, 0, 'block_myoverview', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(323, 0, 'block_myoverview', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(324, 0, 'block_myprofile', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(325, 0, 'block_myprofile', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(326, 0, 'block_myprofile', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(327, 0, 'block_navigation', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(328, 0, 'block_navigation', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(329, 0, 'block_navigation', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(330, 0, 'block_news_items', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(331, 0, 'block_news_items', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(332, 0, 'block_news_items', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(333, 0, 'block_online_users', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(334, 0, 'block_online_users', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(335, 0, 'block_online_users', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(336, 0, 'block_private_files', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(337, 0, 'block_private_files', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(338, 0, 'block_private_files', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(339, 0, 'block_quiz_results', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(340, 0, 'block_quiz_results', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(341, 0, 'block_quiz_results', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(342, 0, 'block_recent_activity', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(343, 0, 'block_recent_activity', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(344, 0, 'block_recent_activity', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(345, 0, 'block_recentlyaccessedcourses', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(346, 0, 'block_recentlyaccessedcourses', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(347, 0, 'block_recentlyaccessedcourses', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(348, 0, 'block_recentlyaccesseditems', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(349, 0, 'block_recentlyaccesseditems', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(350, 0, 'block_recentlyaccesseditems', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(351, 0, 'block_rss_client', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(352, 0, 'block_rss_client', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(353, 0, 'block_rss_client', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(354, 0, 'block_search_forums', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(355, 0, 'block_search_forums', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(356, 0, 'block_search_forums', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(357, 0, 'block_section_links', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(358, 0, 'block_section_links', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(359, 0, 'block_section_links', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(360, 0, 'block_selfcompletion', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(361, 0, 'block_selfcompletion', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(362, 0, 'block_selfcompletion', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(363, 0, 'block_settings', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(364, 0, 'block_settings', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(365, 0, 'block_settings', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(366, 0, 'block_site_main_menu', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(367, 0, 'block_site_main_menu', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(368, 0, 'block_site_main_menu', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(369, 0, 'block_social_activities', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(370, 0, 'block_social_activities', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(371, 0, 'block_social_activities', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(372, 0, 'block_starredcourses', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(373, 0, 'block_starredcourses', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(374, 0, 'block_starredcourses', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(375, 0, 'block_tag_flickr', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(376, 0, 'block_tag_flickr', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(377, 0, 'block_tag_flickr', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(378, 0, 'block_tag_youtube', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(379, 0, 'block_tag_youtube', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(380, 0, 'block_tag_youtube', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(381, 0, 'block_tags', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(382, 0, 'block_tags', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(383, 0, 'block_tags', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(384, 0, 'block_timeline', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(385, 0, 'block_timeline', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(386, 0, 'block_timeline', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(387, 0, 'media_html5audio', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(388, 0, 'media_html5audio', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(389, 0, 'media_html5audio', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(390, 0, 'media_html5video', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(391, 0, 'media_html5video', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(392, 0, 'media_html5video', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(393, 0, 'media_swf', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(394, 0, 'media_swf', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(395, 0, 'media_swf', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(396, 0, 'media_videojs', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(397, 0, 'media_videojs', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(398, 0, 'media_videojs', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(399, 0, 'media_vimeo', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(400, 0, 'media_vimeo', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(401, 0, 'media_vimeo', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(402, 0, 'media_youtube', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(403, 0, 'media_youtube', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(404, 0, 'media_youtube', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(405, 0, 'filter_activitynames', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(406, 0, 'filter_activitynames', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(407, 0, 'filter_activitynames', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(408, 0, 'filter_algebra', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(409, 0, 'filter_algebra', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(410, 0, 'filter_algebra', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(411, 0, 'filter_censor', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(412, 0, 'filter_censor', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(413, 0, 'filter_censor', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(414, 0, 'filter_data', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(415, 0, 'filter_data', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(416, 0, 'filter_data', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(417, 0, 'filter_displayh5p', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(418, 0, 'filter_displayh5p', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(419, 0, 'filter_displayh5p', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(420, 0, 'filter_emailprotect', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(421, 0, 'filter_emailprotect', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(422, 0, 'filter_emailprotect', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(423, 0, 'filter_emoticon', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(424, 0, 'filter_emoticon', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(425, 0, 'filter_emoticon', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(426, 0, 'filter_glossary', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(427, 0, 'filter_glossary', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(428, 0, 'filter_glossary', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(429, 0, 'filter_mathjaxloader', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(430, 0, 'filter_mathjaxloader', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(431, 0, 'filter_mathjaxloader', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(432, 0, 'filter_mediaplugin', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(433, 0, 'filter_mediaplugin', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(434, 0, 'filter_mediaplugin', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(435, 0, 'filter_multilang', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(436, 0, 'filter_multilang', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(437, 0, 'filter_multilang', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(438, 0, 'filter_tex', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(439, 0, 'filter_tex', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(440, 0, 'filter_tex', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(441, 0, 'filter_tidy', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(442, 0, 'filter_tidy', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(443, 0, 'filter_tidy', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(444, 0, 'filter_urltolink', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(445, 0, 'filter_urltolink', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(446, 0, 'filter_urltolink', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(447, 0, 'editor_atto', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(448, 0, 'editor_atto', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(449, 0, 'editor_atto', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(450, 0, 'editor_textarea', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(451, 0, 'editor_textarea', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(452, 0, 'editor_textarea', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(453, 0, 'editor_tinymce', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(454, 0, 'editor_tinymce', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(455, 0, 'editor_tinymce', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(456, 0, 'format_singleactivity', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(457, 0, 'format_singleactivity', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(458, 0, 'format_singleactivity', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(459, 0, 'format_social', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(460, 0, 'format_social', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(461, 0, 'format_social', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(462, 0, 'format_topics', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(463, 0, 'format_topics', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(464, 0, 'format_topics', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(465, 0, 'format_weeks', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(466, 0, 'format_weeks', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(467, 0, 'format_weeks', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(468, 0, 'dataformat_csv', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(469, 0, 'dataformat_csv', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(470, 0, 'dataformat_csv', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(471, 0, 'dataformat_excel', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(472, 0, 'dataformat_excel', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(473, 0, 'dataformat_excel', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(474, 0, 'dataformat_html', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(475, 0, 'dataformat_html', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(476, 0, 'dataformat_html', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(477, 0, 'dataformat_json', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(478, 0, 'dataformat_json', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(479, 0, 'dataformat_json', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(480, 0, 'dataformat_ods', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(481, 0, 'dataformat_ods', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]);
INSERT INTO `[[dbprefix]]upgrade_log` VALUES
(482, 0, 'dataformat_ods', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(483, 0, 'dataformat_pdf', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(484, 0, 'dataformat_pdf', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(485, 0, 'dataformat_pdf', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(486, 0, 'profilefield_checkbox', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(487, 0, 'profilefield_checkbox', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(488, 0, 'profilefield_checkbox', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(489, 0, 'profilefield_datetime', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(490, 0, 'profilefield_datetime', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(491, 0, 'profilefield_datetime', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(492, 0, 'profilefield_menu', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(493, 0, 'profilefield_menu', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(494, 0, 'profilefield_menu', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(495, 0, 'profilefield_social', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(496, 0, 'profilefield_social', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(497, 0, 'profilefield_social', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(498, 0, 'profilefield_text', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(499, 0, 'profilefield_text', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(500, 0, 'profilefield_text', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(501, 0, 'profilefield_textarea', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(502, 0, 'profilefield_textarea', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(503, 0, 'profilefield_textarea', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(504, 0, 'report_backups', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(505, 0, 'report_backups', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(506, 0, 'report_backups', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(507, 0, 'report_competency', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(508, 0, 'report_competency', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(509, 0, 'report_competency', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(510, 0, 'report_completion', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(511, 0, 'report_completion', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(512, 0, 'report_completion', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(513, 0, 'report_configlog', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(514, 0, 'report_configlog', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(515, 0, 'report_configlog', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(516, 0, 'report_courseoverview', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(517, 0, 'report_courseoverview', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(518, 0, 'report_courseoverview', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(519, 0, 'report_eventlist', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(520, 0, 'report_eventlist', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(521, 0, 'report_eventlist', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(522, 0, 'report_infectedfiles', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(523, 0, 'report_infectedfiles', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(524, 0, 'report_infectedfiles', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(525, 0, 'report_insights', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(526, 0, 'report_insights', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(527, 0, 'report_insights', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(528, 0, 'report_log', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(529, 0, 'report_log', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(530, 0, 'report_log', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(531, 0, 'report_loglive', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(532, 0, 'report_loglive', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(533, 0, 'report_loglive', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(534, 0, 'report_outline', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(535, 0, 'report_outline', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(536, 0, 'report_outline', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(537, 0, 'report_participation', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(538, 0, 'report_participation', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(539, 0, 'report_participation', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(540, 0, 'report_performance', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(541, 0, 'report_performance', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(542, 0, 'report_performance', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(543, 0, 'report_progress', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(544, 0, 'report_progress', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(545, 0, 'report_progress', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(546, 0, 'report_questioninstances', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(547, 0, 'report_questioninstances', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(548, 0, 'report_questioninstances', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(549, 0, 'report_security', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(550, 0, 'report_security', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(551, 0, 'report_security', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(552, 0, 'report_stats', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(553, 0, 'report_stats', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(554, 0, 'report_stats', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(555, 0, 'report_status', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(556, 0, 'report_status', '2021051700', '2021051700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(557, 0, 'report_status', '2021051700', '2021051700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(558, 0, 'report_usersessions', NULL, '2021051700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(559, 0, 'report_usersessions', '2021051700', '2021051700', 'Upgrade savepoint r