<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'treasurehunt', language 'de', version '3.11'.
 *
 * @package     treasurehunt
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitytoend'] = 'Ausgewählte Aktivität zuerst abschließen';
$string['activitytoend_help'] = 'Die ausgewählte Aktivität muss abgeschlossen sein, bevor der neue Hinweis angezeigt wird. Um Aktivitäten in der Liste anzuzeigen, muss die Abschlussverfolgung aktiviert sein, u.z. für den Kurs und die Aktivität selbst.';
$string['activitytoendovercome'] = 'Aktivität \'<strong>{$a}</strong>\' bestanden';
$string['activitytoendwarning'] = 'Sie müssen zuerst die zu lösende Aktivität abschließen.';
$string['actnotavailableyet'] = 'Die Aktivität ist noch nicht verfügbar.';
$string['add'] = 'Hinzufügen';
$string['addingroad'] = 'Weg wird hinzugefügt';
$string['addingstage'] = 'Station wird hinzugefügt';
$string['addroad_tour'] = 'Fügen Sie einen oder mehrere Wege hinzu, denen die Spieler/innen folgen sollen.';
$string['addsimplequestion'] = 'Einfache Frage hinzufügen';
$string['addsimplequestion_help'] = 'Es muss eine einfache Frage beantwortet werden, bevor der Hinweis für diese Station angezeigt wird.';
$string['addstage_tour'] = 'Jeder Weg muss zwei oder mehr Stationen haben. An jeder Station gibt es einen Hinweis, um die nächste Station zu finden.';
$string['aerialmap'] = 'Luftbild';
$string['aerialview'] = 'Luftbild';
$string['allowattemptsfromdate'] = 'Versuche erlauben ab';
$string['allowattemptsfromdate_help'] = 'Die Option legt den Zeitpunkt fest, ab dem die Spieler/innen spielen dürfen. Wenn die Option deaktiviert ist, können die Spieler/innen jederzeit starten.';
$string['alwaysshowdescription'] = 'Beschreibung immer anzeigen';
$string['alwaysshowdescription_help'] = 'Wenn die Option deaktiviert ist, wird die Beschreibung zur Schatzsuche erst ab dem Termin \'Versuche erlauben ab\' sichtbar.';
$string['answerwarning'] = 'Sie müssen zuerst die Frage beantworten.';
$string['areyousure'] = 'Sind Sie sicher?';
$string['attempt'] = 'Versuch';
$string['attempthistory'] = 'Versuchsverlauf';
$string['attemptsdeleted'] = 'Versuche der Schatzsuche gelöscht';
$string['autolocate_tour'] = 'Zeigen Sie Ihren <b>aktuellen Standort</b> an.
<br>Erlauben Sie deswegen "Standort verwenden", wenn Sie gefragt werden.';
$string['availability'] = 'Verfügbarkeit';
$string['availableplayerstyles'] = 'Spielbildschirme verfügbar';
$string['back'] = 'Zurück';
$string['backtocourse'] = 'Zurück zum Kurs';
$string['baselayers'] = 'Basisebenen';
$string['basemaps'] = 'Basiskarten';
$string['bigbutton_play_tour'] = 'Dies ist Ihr bester Freund.
<br>Mit einem Klick werden <b>Herausforderungen</b> oder wertvolle <b>Hinweise</b> angezeigt.';
$string['browsemode'] = 'Blättern';
$string['cancel'] = 'Abbrechen';
$string['changecamera'] = 'Kamera wechseln';
$string['changetogroupmode'] = 'Der Spielmodus hat sich geändert auf Teamspiel.';
$string['changetoindividualmode'] = 'Der Spielmodus hat sich geändert auf Einzelspiel.';
$string['changetoplaywithmove'] = 'Der Spielmodus hat sich geändert auf dynamisches Spiel.';
$string['changetoplaywithoutmoving'] = 'Der Spielmodus hat sich geändert auf statisches Spiel.';
$string['cleartreasurehunt'] = 'Schatzsuche zurücksetzen';
$string['cleartreasurehunt_done'] = 'Die Schatzsuche wurde zurückgesetzt. Alle Aktivitäten der Spieler/innen sind gelöscht.';
$string['cleartreasurehuntconfirm'] = 'Vorsicht mit dieser Aktion. Alle aufgezeichneten Aktivitäten werden gelöscht. Diese Aktion ist nur erforderlich, wenn Sie die Anzahl der Wege oder Stationen ändern möchten, aber jemand das Spiel begonnen hat und alle Änderungen blockiert sind.';
$string['clue'] = 'Hinweis';
$string['completionfinish'] = 'Notwendig, um den Weg zu abzuschließen';
$string['completionfinish_help'] = 'Abgeschlossen, wenn alle Stationen eines Weges passiert sind.';
$string['configintro'] = 'Die hier festgelegten Werte werden beim Anlegen einer neuen Schatzsuche als Voreinstellung verwendet.';
$string['configmaximumgrade'] = 'Bewertung, auf die die Schatzsuche skaliert wird.';
$string['confirm'] = 'Bestätigen';
$string['confirmdeletestage'] = 'Die Station wurde erfolgreich entfernt.';
$string['continue'] = 'Weiter';
$string['correctanswer'] = 'Richtige Antwort.';
$string['customlayername'] = 'Titel der Ebene';
$string['customlayername_help'] = 'Wenn Sie eine nutzerdefinierte Ebene verwenden, wird ein Titel benötigt, um die Ebene  in den Karten und bei den Spieler/innen anzuzeigen. Wenn der Titel leer ist, wird die Ebene vollständig deaktiviert.';
$string['customlayertype'] = 'Typ der Ebene';
$string['customlayertype_help'] = 'Die Ebene kann die einzige im Hintergrund sichtbare Ebene sein oder sie kann über die Standardkarten gelegt werden.';
$string['customlayerwms'] = 'WMS Dienst';
$string['customlayerwms_help'] = 'Verwenden Sie eine Kartenebene eines OGC WMS-Dienstes.

\'EUNIS Forest Ecosystems WMS\' kann folgendermaßen konfiguriert werden:
WMS: <code style="overflow-wrap: break-word;word-wrap: break-word;">http://bio.discomap.eea.europa.eu/arcgis/services/Ecosystem/Ecosystems/MapServer/WMSServer</code> PARAMS: <code>LAYERS=4</code>)';
$string['custommapbaselayer'] = 'Das Bild wird als zusätzliche Option für den Kartenhintergrund angezeigt.';
$string['custommapimageerror'] = 'Das nutzerdefinierte Bild kann nicht geladen werden. Überprüfen Sie die Aktivitätseinstellungen.';
$string['custommapimagefile'] = 'Nutzerdefiniertes Bild als Karte';
$string['custommapimagefile_help'] = 'Laden Sie ein Bild mit ausreichender Auflösung hoch und tragen Sie die Projektionskoordinaten in die folgenden 4 Felder ein.';
$string['custommapmaxlat'] = 'Nördlicher Breitengrad';
$string['custommapmaxlat_help'] = 'Nördlicher Breitengrad
<br>Wert für die nördlichste Stelle des Bildes. Nutzen Sie "." als Dezimaltrennzeichen. Der Wert muss kleiner als 85 Grad und größer als der südliche Breitengrad sein.';
$string['custommapmaxlon'] = 'Östlicher Längengrad';
$string['custommapmaxlon_help'] = 'Östlicher Längengrad
<br>Wert für die östlichste Stelle des Bildes. Nutzen Sie "." als Dezimaltrennzeichen. Der Wert muss kleiner als 180 Grad und größer als der westliche Längengrad sein.';
$string['custommapminlat'] = 'Südlicher Breitengrad';
$string['custommapminlat_help'] = 'Südlicher Breitengrad
<br>Wert für die südlichste Stelle des Bildes. Nutzen Sie "." als Dezimaltrennzeichen. Der Wert muss größer als -85 Grad und kleiner als der nördliche Breitengrad sein.';
$string['custommapminlon'] = 'Westlicher Längengrad';
$string['custommapminlon_help'] = 'Westlicher Längengrad
<br>Wert für die westlichste Stelle des Bildes. Nutzen Sie "." als Dezimaltrennzeichen. Der Wert muss größer als -180 Grad und kleiner als der östliche Längengrad sein.';
$string['custommapnongeographic'] = 'Das Bild ist nicht geographisch';
$string['custommaponlybaselayer'] = 'Das Bild wird als einzige Option für den Kartenhintergrund angezeigt';
$string['custommapoverlaylayer'] = 'Das Bild wird über die Standardkarte gelegt';
$string['custommapping'] = 'Nutzerdefinierte Karte';
$string['customwmsparams'] = 'WMS Parameter';
$string['customwmsparams_help'] = 'Diese Parameter legen das Aussehen der Karte fest. Die Angabe erfolgt in dieser Schreibweise: "LAYERS=background,streets&STYLES=blue,default"

\'EUNIS Forest Ecosystems WMS\' kann folgendermaßen konfiguriert werden: WMS: <code style="overflow-wrap: break-word;word-wrap: break-word;">http://bio.discomap.eea.europa.eu/arcgis/services/Ecosystem/Ecosystems/MapServer/WMSServer</code> PARAMS: <code>LAYERS=4</code>)';
$string['cutoffdate'] = 'Spielende';
$string['cutoffdate_help'] = 'Diese Option legt fest, dass die Schatzsuche nach diesem Zeitpunkt keine Versuche mehr erlaubt.';
$string['cutoffdatefromdatevalidation'] = 'Das Ende des Spiels muss nach dem Anfang liegen.';
$string['defaultplayerstyle'] = 'Standardmäßiger Spielbildschirm';
$string['discoveredlocation'] = 'Standort entdeckt';
$string['donetutorial'] = 'Ende';
$string['drawmode'] = 'Zeichnen';
$string['editactivity_help'] = 'Eine Schritt-für-Schritt-Anleitung zum Erstellen einer Schatzsuche finden Sie  <a href="http://juacas.github.io/moodle-mod_treasurehunt/create_activity.html"> auf dieser Website</a>.';
$string['editend_tour'] = 'Viel Spaß beim Erstellen spannender Schatzsuchen!';
$string['editingroad'] = 'Weg wird bearbeitet';
$string['editingstage'] = 'Station wird bearbeitet';
$string['editingtreasurehunt'] = 'Schatzsuche wird bearbeitet';
$string['edition'] = 'Bearbeitungsfeld';
$string['edition_help'] = 'Um im Bearbeitungsfeld die Geometrieerstellung und die Schaltflächen zu aktivieren, muss die Station ausgewählt werden, die Sie bearbeiten möchten.';
$string['editmode'] = 'Bearbeiten';
$string['editroad'] = 'Weg bearbeiten';
$string['editstage'] = 'Station bearbeiten';
$string['edittreasurehunt'] = 'Stationen und Wege ändern';
$string['errcorrectanswers'] = 'Sie müssen eine richtige Antwort auswählen.';
$string['errcorrectsetanswerblank'] = 'Die richtige Antwort ist festgelegt, aber die Antwort ist leer.';
$string['erremptystage'] = 'Alle Stationen müssen mindestens eine Geometrie haben, damit der Weg gültig ist.';
$string['errnocorrectanswers'] = 'Es darf nur eine richtige Antwort geben.';
$string['errnumeric'] = 'Sie müssen eine gültige Dezimalzahl eingeben.';
$string['error'] = 'Fehler';
$string['errpenalizationexceed'] = 'Der Abzug kann nicht größer als 100 sein.';
$string['errpenalizationfall'] = 'Der Abzug kann nicht kleiner als 0 sein.';
$string['errsendinganswer'] = 'Der Weg wurde geändert, während Sie die Antwort gesendet haben. Versuchen Sie es noch einmal.';
$string['errsendinglocation'] = 'Der Weg wurde geändert, während Sie den Standort gesendet haben. Versuchen Sie es noch einmal.';
$string['errvalidroad'] = 'Es muss mindestens zwei Stationen geben, die mindestens eine Verbindung haben, damit der Weg gültig ist.';
$string['eventattemptsubmitted'] = 'Versuch abgegeben';
$string['eventattemptsucceded'] = 'Station bestanden';
$string['eventhuntsucceded'] = 'Schatzsuche erfolgreich abgeschlossen';
$string['eventplayerentered'] = 'Spieler/in gestartet';
$string['eventroadcreated'] = 'Weg angelegt';
$string['eventroaddeleted'] = 'Weg gelöscht';
$string['eventroadupdated'] = 'Weg aktualisiert';
$string['eventstagecreated'] = 'Station angelegt';
$string['eventstagedeleted'] = 'Station gelöscht';
$string['eventstageupdated'] = 'Station aktualisiert';
$string['exit'] = 'Zurück zum Kurs';
$string['failedlocation'] = 'Standortbestimmung fehlgeschlagen';
$string['faillocation'] = 'Das ist nicht der richtige Standort.';
$string['findplace'] = 'Ort finden';
$string['gamemode'] = 'Spielmodus';
$string['gamemodeinfo'] = 'Spielmodus: {$a}';
$string['gameupdatetime'] = 'Aktualisierungsintervall';
$string['gameupdatetime_help'] = 'Zeit (in Sekunden) zwischen zwei Aktualisierungen der Spielansicht. Je größer die Zeit ist, desto seltener wird die Spielansicht aktualisiert und desto später werden mögliche Veränderungen festgestellt. Das Zeitintervall muss größer als 0 Sekunden sein.';
$string['geolocation_needed'] = 'Um dieses Spiel spielen zu können, sind Ihre Standortdaten (Geolocation) erforderlich.<p>Erlauben Sie im  Browser die Standortdaten für diese Website. Laden Sie anschließend die Webseite neu und antworten Sie mit "Ja", wenn Sie gefragt werden, ob Sie Ihren Standort teilen möchten.</p>
<p>Um während der Schatzsuche Standortdaten verwenden zu können, muss die Website über HTTPS vom Server kommen. Andernfalls ist nur der Modus "Spielen ohne Bewegung" möglich und die Spieler/innen müssen die Stationen manuell auf der Karte zeigen. Wenden Sie sich an die Administrator/innen, wenn Sie dieses Problem nicht lösen können.</p>';
$string['geolocation_needed_title'] = 'Diese Anwendung benötigt Standortdaten.';
$string['grade_explaination_fromabsolutetime'] = '{$a->rawscore}-{$a->penalization}%: Sie haben die Schatzsuche mit {$a->yourtime} beendet. Die beste Zeit liegt bei {$a->besttime}. Sie erhalten einen Zeitabzug von {$a->penalization}% wegen {$a->nolocationsfailed} falscher Wegpunkte und wegen {$a->noanswersfailed} falscher Antworten.';
$string['grade_explaination_fromposition'] = '{$a->rawscore}-{$a->penalization}%: Sie haben {$a->nosuccessfulstages} Wegpunkte an Position {$a->position} entdeckt. Sie erhalten einen Abzug von {$a->penalization}% wegen {$a->nolocationsfailed} falscher Wegpunkte und wegen {$a->noanswersfailed} falscher Antworten.';
$string['grade_explaination_fromstages'] = '{$a->rawscore}-{$a->penalization}%: Sie haben {$a->nosuccessfulstages} von {$a->nostages} Wegpunkten entdeckt. Sie erhalten einen Abzug von {$a->penalization}% wegen {$a->nolocationsfailed} falscher Wegpunkte und wegen {$a->noanswersfailed} falscher Antworten.';
$string['grade_explaination_fromtime'] = '{$a->rawscore}-{$a->penalization}%: Sie haben {$a->yourtime} gebraucht, um die Schatzsuche zu beenden. Die beste Zeit war {$a->besttime}. Sie erhalten {$a->penalization}% Strafen wegen {$a->nolocationsfailed} falscher Ortsangaben, und {$a->noanswersfailed} wegen falscher Antworten.';
$string['grade_explaination_temporary'] = 'Unvollständige Schatzsuche. Sie erhalten 50% der Wertung für die Wegpunkte: {$a->rawscore}-{$a->penalization}%: Sie haben {$a->nosuccessfulstages} von {$a->nostages} Wegpunkte gefunden. Sie erhalten einen Abzug von  {$a->penalization}% wegen {$a->nolocationsfailed} falscher Wegpunkte und wegen {$a->noanswersfailed} falscher Antworten.';
$string['gradefromabsolutetime'] = 'Bewertung über die Spieldauer';
$string['gradefromposition'] = 'Bewertung über den Rang';
$string['gradefromstages'] = 'Bewertung über die Stationen';
$string['gradefromtime'] = 'Bewertung über die Zielzeit';
$string['grademethod'] = 'Bewertungsmethode';
$string['grademethod_help'] = '<p><b>Bewertung über die Stationen</b>
<br>Jeder Spieler (oder Gruppe) punktet proportional nach der Anzahl der gelösten Stationen. Dabei gibt es 100%, wenn ein Weg vollständig gelöst ist, und 0%, wenn keine Station gelöst ist.</p>

<p><b>Bewertung über die Spieldauer</b>
<br>Der Spieler, der den Weg in kürzerer Zeit beendet, gewinnt die Schatzsuche und bestimmt die beste Zeit. Die Zeit wird ab dem Moment gemessen, in dem die erste Station des Weges freigeschaltet wird. Die Spieler können zu unterschiedlichen Zeitpunkten spielen.
<br>Die Wertung wird durch Interpolation der Position in der Rangliste berechnet. Die beste Spieldauer wird mit 100% bewertet, die letzte Spieldauer mit 50%. Die Spieler, die die Schatzsuche nicht beendet haben, erhalten eine Wertung unter 50%, berechnet über die Anzahl der gelösten Stationen.</p>

<p><b>Bewertung über die Zielzeit</b>
<br>Der Spieler, der zuerst fertig wird, ist der Gewinner der Schatzsuche. Alle Spieler sollten gleichzeitig spielen.
<br>Die Wertung wird durch Interpolation der Position in der Rangliste berechnet. Die beste Zielzeit wird mit 100% bewertet. Die Endzeit der Schatzsuche wird mit 50% bewertet. Die Spieler, die die Schatzsuche nicht beendet haben, erhalten eine Wertung unter 50%, berechnet über die Anzahl der gelösten Stationen.</p>

<p><b>Bewertung über den Rang</b>
<br>Die Wertung wird durch Interpolation der Position in der Rangliste berechnet. Die Wertung für den ersten Spieler in der Rangliste ist 100%, die Wertung für den letzten Spieler 50%. Die Spieler, die die Schatzsuche nicht beendet haben, erhalten eine Wertung unter 50%, berechnet über die Anzahl der gelösten Stationen.</p>';
$string['grademethodinfo'] = 'Bewertungsmethode: {$a->type}. Standortabzug: {$a->gradepenlocation}%. Antwortabzug: {$a->gradepenanswer}%';
$string['gradepenanswer'] = 'Abzug für Antwortfehler';
$string['gradepenlocation'] = 'Abzug für Standortfehler';
$string['gradepenlocation_help'] = 'Der Abzug wird in % von der Bewertung ausgedrückt.
Wenn der Abzug beispielsweise 5.4 beträgt, werden einem Spieler bei 3 Fehlern insgesamt 16.2% (=3*5.4) abgezogen. Der Spieler erhält dann 83.8% der Bewertung, die über die übrigen Kriterien berechnet wird.';
$string['gradesdeleted'] = 'Die Bewertungen der Schatzsuche wurden gelöscht.';
$string['gradingsummary'] = 'Bewertungsübersicht';
$string['group'] = 'Team';
$string['groupactivityovercome'] = 'Aktivität an Station {$a->position} erfolgreich beendet von {$a->user} {$a->date}';
$string['groupid'] = 'Team, das dem Weg zugeordnet ist';
$string['groupid_help'] = 'Spieler/innen in diesem Team sind diesem Weg zugeordnet, wenn das Spiel beginnt. Wenn es nur einen Weg gibt oder die gewählte Option "keine" lautet, wird der Weg von allen Spieler/innen genutzt.';
$string['groupingid'] = 'Gruppierung, die dem Weg zugeordnet ist';
$string['groupingid_help'] = 'Alle Teams dieser Gruppierung sind diesem Weg zugeordnet, wenn das Spiel beginnt.';
$string['groupinvalidroad'] = '{$a} hat einen ungültigen Weg gewählt.';
$string['grouplocationfailed'] = '<b>Fehlerhafte Standortsuche "Station {$a->position}"</b> von {$a->user} {$a->date}';
$string['grouplocationovercome'] = '<b>Erfolgreiche Standortsuche "Station {$a->position}"</b> von {$a->user} {$a->date}';
$string['groupmode'] = 'Spieler/innen spielen in Teams';
$string['groupmode_help'] = 'Die Option legt fest, dass die Spieler/innen entsprechend der Kursgruppen in Teams eingeteilt werden. Jedes Teammitglied kann die aktuelle Station lösen und den Erfolg mit den ganzen Team teilen.
<br/>Dies ermöglicht es, die Schatzsuche zu „parallelisieren“ und eine größere Fläche abzudecken. Die Teilnehmer/innen sehen die gleichen Informationen, aber hier teamorientiert.';
$string['groupmultipleroads'] = '{$a} hat mehr als einen Weg zugeordnet.';
$string['groupquestionfailed'] = '<b>Falsche Antwort "Station {$a->position}"</b> von {$a->user} {$a->date}';
$string['groupquestionovercome'] = '<b>Richtige Antwort "Station {$a->position}"</b> von {$a->user} {$a->date}';
$string['groups'] = 'Teams';
$string['groupstageovercome'] = '<b>Station {$a->position} bestanden </b> von {$a->user} {$a->date}';
$string['hello'] = 'Hallo';
$string['history'] = 'Verlauf';
$string['huntcompleted'] = 'Sie haben diese Schatzsuche bereits abgeschlossen.';
$string['incorrectanswer'] = 'Falsche Antwort';
$string['info'] = 'Info';
$string['infovalidatelocation'] = 'Überprüfen Sie den Standort dieser Station.';
$string['invalidassignedroad'] = 'Der zugeordnete Weg ist nicht bestätigt.';
$string['invalroadid'] = 'Der Weg ist nicht bestätigt.';
$string['lastsuccessfulstage_tour'] = 'In diesem Feld können Sie Ihre letzte erfolgreiche Station finden. Dies ist entweder Ihre eigene Station oder die Ihres Teams.';
$string['layers'] = 'Ebenen';
$string['loading'] = 'Wird geladen';
$string['lockedaclue'] = 'Sie müssen die Aktivität \'<strong>{$a}</strong>\' abschließen, um den Hinweis freizuschalten.';
$string['lockedaqclue'] = 'Sie müssen die Aktivität \'<strong>{$a}</strong>\' abschließen und die folgende Frage richtig beantworten, um den Hinweis freizuschalten';
$string['lockedclue'] = 'Gesperrter Hinweis';
$string['lockedqclue'] = 'Sie müssen die folgende Frage richtig beantworten, um den Hinweis freizuschalten';
$string['locktimeediting'] = 'Sperrzeit bearbeiten';
$string['locktimeediting_help'] = 'Zeit (in Sekunden), für die eine Instanz bearbeitet werden kann, ohne die Bearbeitungssperre zu erneuern.
Je größer die Zeit ist, desto seltener muss die Sperre verlängert werden. Andererseits bleibt die Bearbeitungsseite weiter gesperrt, auch wenn die Bearbeitung bereits fertig ist. Der Wert muss länger als 5 Sekunden sein.';
$string['map_tour'] = 'Auf dieser Karte können Sie die Elemente eines spannenden geografischen Spiels verwalten.';
$string['mapplay_tour'] = 'Die <b>Karte</b> zeigt Ihnen Ihre eigenen Versuche! <br>Erfolgreich: <img src="pix/success_mark.png" width="28" /> <br>Fehlgeschlagen: <img src="pix/failure_mark.png" width="28" />';
$string['mapplaymobile_tour'] = 'Die <b>Karte</b> zeigt Ihnen Ihre eigenen Versuche! <br>Erfolgreich: <img src="{$a->successurl}" width="28" /> <br>Fehlgeschlagen: <img src="{$a->failureurl}" width="28" />';
$string['mapview'] = 'Kartenanzeige';
$string['modify'] = 'Ändern';
$string['modulename'] = 'Schatzsuche';
$string['modulename_help'] = '<p>Die Schatzsuche (TreasureHunt) ist eine Stationensuche mit Geolocation und QR-Codes.</p>
<p>Sie können für Ihre Teilnehmer/innen Spiele organisieren, z.B. eine Schatzsuche draußen im Freien, drinnen im Gebäude oder auf virtuellen Karten.
Die Schatzsuche implementiert ein browserbasiertes Spiel. Es muss keine native App installiert werden. Zum Codieren der Spielphasen gibt es einen geografischen Editor.</p>
<p>Das Spiel wird über zahlreiche Optionen konfiguriert, die sehr flexibel und nützlich sind: Einzelperson/Team, Bewegen-im-Freien, Markieren-am-Bildschirm, Bewertung nach Zeit, Rang, Fertigstellung usw.</p>
<p><b><a href="https://juacas.github.io/moodle-mod_treasurehunt/index.html">Weitere Infos und eine schrittweise Anleitung</a></b></p>';
$string['modulenameplural'] = 'Schatzsuchen';
$string['movingplay'] = 'Dynamisches Spiel';
$string['multiplegroupingsplay'] = 'Ihr Team hat mehr als eine Route gewählt, so dass Sie das Spiel nicht spielen können.';
$string['multiplegroupsplay'] = 'Sie haben mehr als eine Route gewählt, so dass Sie das Spiel nicht spielen können.';
$string['multiplegroupssameroadplay'] = 'Sie gehören zu mehr als einem Team, denen die selbe Strecke zugewiesen wurde und können daher nicht teilnehmen.';
$string['multipleteamsplay'] = 'Mitglied in mehr als einem Team und kann daher nicht teilnehmen.';
$string['mustanswerquestion'] = 'Sie müssen die Frage richtig beantworten, bevor Sie weitermachen können.';
$string['mustcompleteactivity'] = 'Sie müssen die Aktivität bestehen, bevor Sie weitermachen können.';
$string['mustcompleteboth'] = 'Sie müssen die Frage richtig beantworten und die Aktivität bestehen, bevor Sie weitermachen können.';
$string['nextcamera'] = 'Kamera wechseln';
$string['nextstep'] = 'Weiter';
$string['noanswerselected'] = 'Sie müssen eine Antwort auswählen.';
$string['noattempts'] = 'Sie haben bisher keinen Versuch gemacht.';
$string['noexsitsstage'] = 'Es gibt keinen Wegpunkt Nummer {$a} in der Datenbank. Laden Sie die Seite neu.';
$string['nogroupassigned'] = 'Dieser Strecke wurde kein Team zugewiesen.';
$string['nogroupingplay'] = 'Sie haben kein Team für einen Weg zugewiesen, so dass Sie die Aktivität nicht spielen können.';
$string['nogroupplay'] = 'Sie sind keinem Weg zugeordnet, so dass Sie die Aktivität nicht spielen können.';
$string['nogrouproad'] = '{$a} wurde keinem Weg zugewiesen.';
$string['nomarks'] = 'Markieren Sie zuerst den gewünschten Punkt auf der Karte. Platzieren Sie <img src="pix/my_location.png" width="28"/>';
$string['nomarksmobile'] = 'Markieren Sie zuerst den gewünschten Punkt auf der Karte.';
$string['noresults'] = 'Keine Ergebnisse gefunden';
$string['noroads'] = 'Wege wurden bisher nicht hinzugefügt.';
$string['notchangeorderstage'] = 'Sie können die Reihenfolge der Stationen nicht ändern, nachdem Versuche auf dem Weg gemacht wurden.';
$string['notcreatestage'] = 'Es gibt bereits Versuche für diesen Weg. Sie können keine weiteren Stationen hinzufügen.';
$string['notdeletestage'] = 'Es gibt bereits Versuche für diesen Weg. Sie können keine Stationen löschen.';
$string['noteam'] = 'Kein Mitglied eines Teams';
$string['notreasurehunts'] = 'In diesem Kurs ist keine Schatzsuche.';
$string['nouserassigned'] = 'Niemand ist diesem Weg zugeordnet.';
$string['nouserattempts'] = '{$a} hat noch keinen Versuch gemacht.';
$string['nouserroad'] = '{$a} hat keinen Weg zugeordnet.';
$string['nousersprogress'] = 'Niemand bzw. kein Team hat auf diesem Weg Fortschritte gemacht.';
$string['outoftime'] = 'Zeit überschritten';
$string['overcomefirststage'] = 'Um die erste Station zu finden, sollten Sie in dem markierten Gebiet auf der Karte beginnen.';
$string['overlaylayers'] = 'Ebenen überlagern';
$string['pegmanlabel'] = 'Schauen Sie sich bei StreetView um';
$string['play'] = 'Spielen';
$string['playend_tour'] = '<span style="font-size: 1.5rem; font-weight: bold">Viel Spaß bei der Schatzsuche</span><br>zusammen mit Ihren Freunden!';
$string['playerbootstrap'] = 'Bootstrap';
$string['playerclassic'] = 'Classic';
$string['playerfancy'] = 'Fancy';
$string['playerhelp_tour'] = 'Diese Tour kann jederzeit erneut angezeigt werden.';
$string['playerstyle'] = 'Stil des Spielbildschirms';
$string['playerstyle_help'] = 'Trainer/innen können unterschiedliche Stile des Spielbildschirms auswählen.';
$string['playstagewithoutmoving'] = 'Station ohne Bewegung erkennen';
$string['playstagewithoutmoving_help'] = 'Wenn diese Option aktiviert ist, können Spieler/innen diese Station finden, ohne an einen anderen Ort zu wechseln.
Zu diesem Zweck wird jedes Mal eine Markierung gesetzt, wenn man auf die Karte klickt. Dabei wird die jeweils vorherige Markierung gelöscht, die den letzten Punkt anzeigt. Nach Abschluss der Phase wird das Spiel auf die Standardeinstellungen geändert.';
$string['playstagewithqr'] = 'Station durch Lesen dieses QR-Textes erkennen';
$string['playstagewithqr_help'] = 'Wenn diese Option einen Wert hat, können Spieler/innen diese Station erkennen, indem sie einen an diesem Ort verfügbaren QR-Code scannen.';
$string['playwithoutmoving'] = 'Spielen ohne Bewegen';
$string['playwithoutmoving_help'] = 'Wenn diese Option aktiviert ist, können Spieler/innen auf ihren Computern spielen, ohne sich zu bestimmten Orten bewegen zu müssen.
Wenn die Spieler/innen am Bildschirm auf die Karte klicken, wird eine Markierung gesetzt und die jeweils vorherige Markierung wird gelöscht.';
$string['pluginadministration'] = 'Schatzsuche-Administation';
$string['pluginname'] = 'Schatzsuche';
$string['prevstep'] = 'Zurück';
$string['privacy:metadata_treasurehunt_attempts'] = 'Die Schatzsuche speichert Typ, Zeit und Ort aller Versuche, außerdem die Erfolge und Fehler der Nutzer/innen in der Aktivität';
$string['privacy:metadata_treasurehunt_attempts_groupid'] = 'Team, in der die Person die Aktivität gespielt hat.';
$string['privacy:metadata_treasurehunt_attempts_stageid'] = 'Stations-ID, die die Person versucht hat.';
$string['privacy:metadata_treasurehunt_attempts_timecreated'] = 'Zeit, zu der die Person den Versuch gemacht hat.';
$string['privacy:metadata_treasurehunt_attempts_userid'] = 'ID der Person, die den Versuch gemacht hat.';
$string['privacy:metadata_treasurehunt_track'] = 'Die Schatzsuche speichert die Reihenfolge der Standorte, die eine Person während der Aktivität verfolgt hat.';
$string['privacy:metadata_treasurehunt_track_location'] = 'Standort der Person zu einer bestimmten Zeit.';
$string['privacy:metadata_treasurehunt_track_timestamp'] = 'Zeit, zu der die Person getrackt wurde.';
$string['privacy:metadata_treasurehunt_track_treasurehuntid'] = 'ID der Schatzsuche, in der die Person spielt.';
$string['privacy:metadata_treasurehunt_track_userid'] = 'ID der Person, die getrackt wird.';
$string['qrreaded'] = 'Gelesener QR-Code:';
$string['question'] = 'Frage';
$string['remove'] = 'Löschen';
$string['remove_tour'] = 'Sie können Teile der Standortgeometrien löschen. Wählen Sie einfach ein Polygon aus und drücken Sie diese Taste.';
$string['removealltreasurehuntattempts'] = 'Alle Versuche der Schatzsuche löschen';
$string['removedactivitytoend'] = 'Abzuschließende Aktivität wurde entfernt';
$string['removedquestion'] = 'Die Frage wurde entfernt.';
$string['removeroadwarning'] = 'Wenn Sie den Weg entfernen, werden gleichzeitig auch die zugehörigen Stationen entfernt. Sie können dies nicht rückgängig machen.';
$string['removewarning'] = 'Wenn Sie dies entfernen, können Sie es nicht rückgängig machen.';
$string['restrictionsdiscoverstage'] = 'Einschränkungen beim Entdecken der Station';
$string['reviewofplay'] = 'Rückblick auf das Spiel';
$string['road'] = 'Weg';
$string['roadended'] = 'Der Weg ist zu Ende. Herzlichen Glückwünsch! Sie haben die Schatzsuche abgeschlossen. Sie können den Verlauf in der Karte überprüfen.';
$string['roadmap'] = 'Weg';
$string['roadname'] = 'Name des Weges';
$string['roads_tour'] = 'In diesem Bereich finden Sie die verschiedenen Wege Ihres Spiels. Wählen Sie einen Weg aus, um die Stationen zu bearbeiten.';
$string['roadview'] = 'Weg';
$string['save'] = 'Sichern';
$string['save_tour'] = 'Vergessen Sie nicht, nach dem Zeichnen Ihrer Standorte die Änderungen zu speichern.';
$string['saveemptyridle'] = 'Alle veränderten Stationen müssen eine Verbindung haben, bevor Sie speichern können.';
$string['savewarning'] = 'Sie haben ungesicherte Änderungen.';
$string['scanQR_generatebutton'] = 'QR-Code erzeugen';
$string['scanQR_scanbutton'] = 'QR-Code scannen';
$string['search'] = 'Suchen';
$string['searching'] = 'Wird gesucht';
$string['searchlocation'] = 'Standort suchen';
$string['searchlocation_tour'] = 'Mit dieser Suche finden Sie schnell Ihren Weg.';
$string['send'] = 'Senden';
$string['sendlocationcontent'] = 'Diese Aktion kann nicht zurückgenommen werden.';
$string['sendlocationtitle'] = 'Möchten Sie diesen Standort wirklich senden?';
$string['showboard'] = 'Fortschritte der anderen anzeigen';
$string['showboard_help'] = 'Wenn diese Option aktiviert ist, werden die Fortschitte der anderen Teilnehmer/innen auf der Aktivitätsseite angezeigt.';
$string['showclue'] = 'Hinweis anzeigen';
$string['skiptutorial'] = 'Beenden';
$string['stage'] = 'Station';
$string['stageclue'] = 'Hinweis zum Finden der nächsten Station';
$string['stageclue_help'] = 'Im Hinweis sollten Sie genau beschreiben, wie der nächste Ort zu finden ist.
Falls dies die letzte Station ist, müssen Sie mitteilen, dass die Schatzsuche hier zu Ende ist.';
$string['stagename'] = 'Name der Station';
$string['stageovercome'] = 'Station bestanden';
$string['stages'] = 'Stationen';
$string['stages_tour'] = 'In diesem Bereich finden Sie die Stationen des gewählten Weges. Wählen Sie jeweils die Station aus, um auf die tatsächliche Kartenposition zu zoomen. Bearbeiten Sie die Geometrie, indem Sie zuerst auf die Station und dann auf die Tasten "Bearbeiten" oder "Zeichnen" klicken.';
$string['start'] = 'Start';
$string['startfromhere'] = 'Sie können nur hier starten.';
$string['state'] = 'Status';
$string['successlocation'] = 'Das ist der richtige Ort!';
$string['timeago'] = 'vor {$a->shortduration}';
$string['timeagolong'] = 'vor {$a->shortduration} ({$a->date})';
$string['timeat'] = 'am {$a->date}';
$string['timeexceeded'] = 'Sie haben das Zeitlimit für die Aktivität überschritten. Dieser Bildschirm dient nur als Rückblick auf das Spiel.';
$string['timetocome'] = 'in {$a->shortduration}';
$string['timetocomelong'] = 'in {$a->shortduration} ({$a->date})';
$string['totalprogress'] = 'Gesamtfortschritt';
$string['totaltime'] = 'Gesamtzeit';
$string['trackusers'] = 'Bewegungen tracken';
$string['trackusers_help'] = 'Die Wege der Spieler/innen werden kontinuierlich registriert und können mit der Anzeige "Track Viewer" sichtbar gemacht werden. Die Standorte werden auch zwischen den Validierungsversuchen automatisch in jedem Aktualisierungsintervall protokolliert. <br>Wenn diese Option <b>deaktiviert</b> ist, werden nur die Standorte der Validierungsversuche aufgezeichnet.<br><br>
Wenn eine Person ihr GPS deaktiviert hat, kann sie nur die gescannten QR-Codes melden.';
$string['trackviewer'] = 'Track Viewer';
$string['trackviewerrefreshtracks'] = 'Tracking alle {$a} Sekunden aktualisieren';
$string['treasurehunt'] = 'Schatzsuche';
$string['treasurehunt:addinstance'] = 'Neue Schatzsuche hinzufügen';
$string['treasurehunt:addroad'] = 'Weg hinzufügen';
$string['treasurehunt:addstage'] = 'Station hinzufügen';
$string['treasurehunt:editroad'] = 'Weg bearbeiten';
$string['treasurehunt:editstage'] = 'Station bearbeiten';
$string['treasurehunt:managetreasure'] = 'Schatzsuche verwalten';
$string['treasurehunt:managetreasurehunt'] = 'Schatzsuche verwalten';
$string['treasurehunt:play'] = 'Spielen';
$string['treasurehunt:view'] = 'Schatzsuche anzeigen';
$string['treasurehunt:viewusershistoricalattempts'] = 'Versuchsverlauf der Spieler/innen anzeigen';
$string['treasurehuntclosed'] = 'Diese Schatzsuche wurde am {$a} beendet.';
$string['treasurehuntcloses'] = 'Die Schatzsuche endet in Kürze.';
$string['treasurehuntcloseson'] = 'Diese Schatzsuche endet am {$a}.';
$string['treasurehuntislocked'] = 'Die Schatzsuche wird gerade von {$a} bearbeitet. Versuchen Sie es in wenigen Minuten noch einmal.';
$string['treasurehuntname'] = 'Name der Schatzsuche';
$string['treasurehuntnotavailable'] = 'Die Schatzsuche ist erst ab {$a} verfügbar.';
$string['treasurehuntopenedon'] = 'Diese Schatzsuche hat am {$a} begonnen.';
$string['treasurehuntopens'] = 'Die Schatzsuche beginnt.';
$string['updates'] = 'Aktualisierungen';
$string['updatetimes'] = 'Aktualisierungszeiten';
$string['user'] = 'Spieler/in';
$string['useractivityovercome'] = '<b>Aktivität für "Station {$a->position}" erfolgreich abgeschlossen</b> {$a->date}';
$string['userattempthistory'] = 'Versuchsverlauf von {$a}';
$string['userinvalidroad'] = '{$a} hat einen falschen Weg zugeordnet.';
$string['userlocationfailed'] = '<b>Fehlerhafte Standortsuche "Station {$a->position}"</b> {$a->date}';
$string['userlocationovercome'] = '<b>Erfolgreiche Standortsuche "Station {$a->position}"</b> {$a->date}';
$string['usermultipleroads'] = '{$a} hat mehr als einen Weg zugeordnet.';
$string['usermultiplesameroad'] = '{$a} gehört zu mehr als einem Team, das zum gleichen Weg zugeordnet ist.';
$string['userprogress'] = 'Spielerfortschritt erfolgreich aktualisiert';
$string['userquestionfailed'] = '<b>Falsche Antwort "Station {$a->position}"</b> {$a->date}';
$string['userquestionovercome'] = '<b>Richtige Antwort "Station {$a->position}"</b> {$a->date}';
$string['usersprogress'] = 'Spielerfortschritt';
$string['usersprogress_help'] = 'Der Spielerfortschritt wird für alle Spieler/innen oder jedes Teams als Farben angezeigt: <br/>
<b>grün</b> bedeutet, dass die Station ohne Fehler bestanden wurde.<br/>
<b>gelb</b> bedeutet, dass die Station mit Fehlern bestanden wurde.<br/>
 <b>rot</b> bedeutet, dass die Station nicht bestanden wurde und Fehler aufgetreten sind.<br/>
<b>grau</b> bedeutet, dass die Station nicht bestanden wurde und keine Fehler gemacht wurden.';
$string['userstageovercome'] = '<b>Station {$a->position} bestanden</b> {$a->date}';
$string['validatelocation'] = 'Standort prüfen';
$string['validatelocation_tour'] = 'Sind Sie sicher, den richtigen Ort gefunden zu haben?
<br><b>Senden Sie Ihren Standort</b> und finden Sie heraus, ob Sie recht haben.';
$string['validateqr'] = 'QR-Code scannen';
$string['warmatchanswer'] = 'Die Antwort passt nicht zur Frage.';
$string['warnqrscanner'] = '<table><tr><td>Die Schatzsuche enthält {$a} Stationen mit QR-Codes. Stellen Sie sicher, dass Ihr Endgerät diese Codes im Webbrowser scannen kann. Eine Ansicht Ihrer Kamera sollte unten angezeigt werden. Versuchen Sie, einen QR-Code wie diesen hier zu lesen.</td><td><a href="pix/qr.png"><img src="pix/qr.png" align="top" width="100"></a></td> </tr></table>';
$string['warnqrscannererror'] = 'Diese Schatzsuche enthält {$a} Stationen mit QR-Codes.
Scheinbar kann Ihr Endgerät die Kamera mit dieser Anwendung nicht verwenden. Erlauben Sie bitte den Zugriff auf die Kamera.
Wenn Sie die Kamera nicht aktivieren können, ist dieses Endgerät nicht zum Spielen der Schatzsuche geeignet.';
$string['warnqrscannersuccess'] = 'Diese Schatzsuche enthält {$a} Stationen mit QR-Codes.
Es sieht so aus, dass dieses Endgerät den QR-Test bestanden hat.';
$string['warnunsecuregeolocation'] = 'Geolocation funktioniert möglicherweise auf Ihrem Server nicht. Dies ist eine <b>SEVERE misconfiguration</b>, die durch die Konfiguration Ihres Servers verursacht wird.
<br>Geolocation ist für nicht sichere Server verboten, die HTTP anstelle von HTTPS verwenden. Um GPS zur Lokalisierung bei der Schatzsuche nutzen zu können, muss der Server auf HTTPS umgestellt werden. Andernfalls ist nur der Modus "Spielen ohne Bewegung" verfügbar und die Spieler/innen müssen jede Station manuell auf der Karte zeigen. Wenden Sie sich an Ihre Administrator/innen.
<br>Weitere Infos: <a href="https://www.chromestatus.com/feature/5636088701911040">Chrome</a>, <a href="https://blog.mozilla.org/security/2015/04/30/deprecating-non-secure-http/">Firefox</a>';
$string['warnusersgroup'] = 'Folgende Nutzer/innen gehören zu keinem Team und können deswegen das Spiel nicht spielen: {$a}';
$string['warnusersgrouping'] = 'Folgende Teams gehören zu mehr als einer Gruppierung und können deswegen das Spiel nicht spielen: {$a}';
$string['warnusersoutside'] = 'Folgende Nutzer/innen gehören zu keinem Team oder keiner Gruppierung. Sie können deswegen das Spiel nicht spielen: {$a}';
$string['welcome_edit_tour'] = 'Willkommen auf der Bearbeitungsseite der Schatzsuche.';
$string['welcome_play_tour'] = '<span style="font-size: 1.5rem; font-weight: bold">Willkommen bei der Schatzsuche!</span><br>Diese Landkarte und zahlreiche Hinweise werden Sie zum Ziel führen.';
