<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'publication', language 'da', version '3.11'.
 *
 * @package     publication
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_uploads'] = 'Tilføj filer';
$string['allfiles'] = 'Alle filer';
$string['allowedfiletypes'] = 'Accepterede filtyper';
$string['allowedfiletypes_err'] = 'Tjek input! Ugyldigt filtypenavn eller separatorer';
$string['allowedfiletypes_help'] = 'Accepterede filtyper kan begrænses ved at indtaste en komma-separeret liste med mime-typer, fx \'video/mp4, audio/mp3, image/png, image/jpeg\', eller filtypenavne, fx \'.png, .jpg\'. Hvis feltet efterlades tomt er alle filtyper tilladte.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Opgavedetaljer og afleveringsformular er tilgængelig fra <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'fra';
$string['allowsubmissionsfromdate_import'] = 'Godkendelse fra';
$string['allowsubmissionsfromdateh_help'] = 'Du kan bestemme den tidsperiode, hvor studerende kan uploade filer eller give deres godkendelse til filpublicering. I løbet af denne tidsperiode kan studerende redigere deres filer og tilbagetrække deres godkendelse af filpublicering.';
$string['allowsubmissionsfromdatesummary'] = 'Opgaven kan afleveres af <strong>{$a}</strong>';
$string['alwaysshowdescription'] = 'Vis altid beskrivelse';
$string['approval_timeover'] = 'Du kan kun ændre din godkendelse i perioden, hvor ændringer er tilladt.';
$string['approvalchange'] = 'Godkendelsesstatus ændret';
$string['approved'] = 'Godkendt';
$string['assignment'] = 'Opgave';
$string['assignment_help'] = 'Vælg den opgave, der skal importeres filer fra. I øjeblikket er gruppeafleveringer ikke understøttet og derfor ikke valgbart.';
$string['assignment_notfound'] = 'Den opgave som filer er importeret fra, kan ikke længere findes.';
$string['assignment_notset'] = 'Ingen opgave er valgt.';
$string['configautoimport'] = 'Hvis du foretrækker, at afleveringer automatisk importeres til deltagermapper. Denne funktion kan aktiveres/deaktiveres for hver deltagermappe separat.';
$string['configmaxbytes'] = 'Standard maksimum størrelse for alle filer i deltagermappe.';
$string['configmaxfiles'] = 'Standard maksimalt antal af vedhæftede filer tilladt pr. studerende.';
$string['configobtainstudentapproval'] = 'Dokumenter er synlige efter den studerendes samtykke.';
$string['configobtainteacherapproval'] = 'De studerendes dokumenter er som standard synlige for alle deltagere.';
$string['configrequiremodintro'] = 'Deaktiver denne indstilling, hvis du ikke ønsker, at studerende skal indtaste en beskrivelse af hver aktivitet.';
$string['courseuploadlimit'] = 'Kursets upload-grænse';
$string['currentlynotapproved'] = '* Pt ikke godkendt eller afvist.';
$string['cutoffdate'] = 'Skæringsdato';
$string['cutoffdate_help'] = 'Hvis aktiveret, vil opgaven ikke acceptere afleveringer efter denne dato uden en forlængelse.';
$string['cutoffdate_import'] = 'Sidste godkendelse til';
$string['cutoffdatefromdatevalidation'] = 'Skæringsdato skal være efter tillad aflevering fra dato.';
$string['cutoffdatevalidation'] = 'Skæringsdato kan ikke være tidligere end afleveringsdato';
$string['details'] = 'Detaljer';
$string['downloadall'] = 'Download alle filer som ZIP';
$string['duedate'] = 'til';
$string['duedate_help'] = 'Dette gælder når afleveringstidpunktet er indtruffet. Det er stadig tilladt at aflevere efter dette tidspunkt, men afleveringerne vil blive mærket for sent afleveret. For at undgå aflevering efter en given dato - sæt skæringsdato på opgaven.';
$string['duedate_import'] = 'Godkendelse til';
$string['duedatevalidation'] = 'Afleveringsdato skal være efter tillad aflevering fra dato.';
$string['edit_timeover'] = 'Filer kan kun redigeres i den periode hvor ændringer er tilladt.';
$string['emailstudentsmail'] = '{$a->username} har ændret godkendelsessatus på \'{$a->filename}\'
til \'{$a->publication}\' til {$a->apstatus} {$a->dayupdated} kl.  {$a->timeupdated}.

Den er tilgængelig her:

    {$a->url}';
$string['emailstudentsmailhtml'] = '{$a->username} har ændret godkendelsessatus på \'{$a->filename}\'
for <i>\'{$a->publication}\'</i> til <b>{$a->apstatus}</b> {$a->dayupdated} kl. {$a->timeupdated}</i><br /><br />
Den er <a href="{$a->url}">tilgængelig på websiden </a>.';
$string['emailteachermail'] = '---------------------------------------------------------------------\\n{$a->username} har uploaded \'{$a->filename}\'
for \'{$a->publication}\' {$a->dayupdated} kl. {$a->timeupdated}.

Den er tilgængelig her:

    {$a->url}---------------------------------------------------------------------\\n';
$string['notice_uploadnoapproval'] = 'Alle filer er synlige for alle, så snart de er uploadet. Læreren forbeholder sig ret til at skjule filer til hver en tid.';
$string['notice_uploadrequireapproval'] = 'Alle uploadede filer bliver først synlige, når læreren har set dem igennem.';
$string['notifications'] = 'Notifikationer';
$string['notifystudents'] = 'Notificer studerende om godkendelsesændringer';
$string['notifystudents_help'] = 'Hvis aktiveret, modtager den studerende en besked, så snart en af dennes filer ændrer status. Beskedmetoder kan konfigureres.';
$string['obtainstudentapproval'] = 'Opnå godkendelse';
$string['obtainteacherapproval'] = 'Automatisk godkendt.';
$string['optionalsettings'] = 'Indstillinger';
$string['pending'] = 'Afventer';
$string['pluginadministration'] = 'Deltagermappe-administration';
$string['pluginname'] = 'Deltagermappe';
$string['privacy:metadata:approval'] = 'Om gruppemedlemmet har godkendt eller afvist filen eller ej.';
$string['privacy:metadata:contenthash'] = 'SHA1 hash af filens indhold, brugt til at afgøre om filen er blevet ændret.';
$string['privacy:metadata:extduedates'] = 'Lagrer information om overskredene/udskudte afleveringsdatoer til mod_publication.';
$string['privacy:metadata:extensionduedate'] = 'Brugerens faktiske afleveringsdato, da den er blevet overskredet/udskudt.';
$string['privacy:metadata:fileid'] = 'Filens identifikator.';
$string['privacy:metadata:filename'] = 'Filens navn.';
$string['privacy:metadata:files'] = 'Lagrer informationer om uploadede filer til mod_publication. (Identifikator, hvem den tilhører, hvor den kom fra, hash af indhold, filnavn og om den er godkendt af lærer og/eller studerende)';
$string['privacy:metadata:groupapproval'] = 'Lagrer informationer om gruppedeltageres godkendelse eller afvisning af filer, der stammer fra gruppeaflevering.';
$string['privacy:metadata:publicationfileexplanation'] = 'Filer og konverterede onlinetekst-afleveringer til dette plugin lagres via Moodles fil-API.';
$string['privacy:metadata:publicationperpage'] = 'Hvor mange poster skal vises på en enkelt side.';
$string['privacy:metadata:studentapproval'] = 'Om den studerende har godkendt eller afvist filen.';
$string['privacy:metadata:teacherapproval'] = 'Om læreren har godkendt eller afvist filen.';
$string['privacy:metadata:timecreated'] = 'Tidspunkt og dato for oprettelse af dataposten.';
$string['privacy:metadata:timemodified'] = 'Det seneste tidspunkt og dato, hvor dataposten er blevet opdateret/ændret.';
$string['privacy:metadata:type'] = 'Mærker filens oprindelse (uploadet af studerende, importeret fra afleveringsopgave eller konverteret online-tekst-aflevering).';
$string['privacy:metadata:userid'] = 'Brugeridentifikator.';
$string['publication:addinstance'] = 'Tilføj en ny deltagermappe.';
$string['publication:approve'] = 'Beslut om filer skal være synlige for alle studerende.';
$string['publication:grantextension'] = 'Udsæt';
$string['publication:receiveteachernotification'] = 'Modtag lærernotifikationer';
$string['publication:upload'] = 'Upload filer til en deltagermappe';
$string['publication:view'] = 'Se deltagermappe';
$string['publicfiles'] = 'Offentlige filer';
$string['rejected'] = 'Afvist';
$string['requiremodintro'] = 'Forlang beskrivelse af aktivitet';
$string['reset'] = 'Til';
$string['reset_userdata'] = 'Alle data';
$string['resetstudentapproval'] = 'Nulstil status';
$string['save_changes'] = 'Gem ændringer';
$string['search:activity'] = 'Deltagermappe - aktivitetsinformation';
$string['show_details'] = 'Vis detaljer';
$string['status'] = 'Status';
$string['studentapproval'] = 'Status';
$string['studentapproval_help'] = 'Kolonnestatus viser den studerendes svar på godkendelsen:

* ? - godkendelse afventer
* ✓ - godkendelse givet
* ✖ - godkendelse afvist';
$string['teacher_rejected'] = 'afvist';
$string['teacherapproval'] = 'Godkendelse';
$string['teacherapproval_help'] = 'Gældende beslutning om filer, der skal være synlige for alle deltagere:
<br /><ul><li>Vælg... - ikke godkendt eller afvist endnu.</li><li>Ja - godkendt, filerne er synlige.</li><li>Nej - afvist, filerne er ikke synlige.</li></ul>';
$string['updatefiles'] = 'Opdater filer';
$string['updatefileswarning'] = 'En individuel studerendes filer bliver opdateret når han/hun afleverer opgaven. Filer der allerede er synlige vil også blive erstattet. Hvis de slettes eller opdateres - ændrer det ikke den studerendes indstillinger med hensyn til synlighed.';
$string['uploaded'] = 'Uploadet';
$string['visibleforstudents_no'] = 'Denne fil er IKKE synlig for studerende';
$string['warning_changefromobtainstudentapproval'] = 'Hvis du udfører denne ændring, kan kun du beslutte hvilke filer, der er synlige for alle studerende. Studerende bliver ikke spurgt om godkendelse. Alle filer, der er mærket godkendt, er synlige for alle studerende uanset den studerendes beslutning.';
$string['warning_changefromobtainteacherapproval'] = 'Når denne indstilling er aktiveret, vil alle filer være synlige for alle deltagere. Alle uploadede filer bliver synlige. Du kan manuelt gøre filer usynlige for udvalgte studerende.';
$string['warning_changetoobtainstudentapproval'] = 'Når denne indstilling er aktiveret, bliver de studerende bedt om deres godkendelse af alle filer, der er mærket som synlige. De bliver først synlige, når de studerende har godkendt dem.';
$string['warning_changetoobtainteacherapproval'] = 'Når denne indstilling er deaktiveret, er uploadede filer ikke automatisk synlige for andre deltagere. Du skal beslutte hvilke filer, der skal være synlige. Allerede synlige filer bliver usynlige.';
$string['withselected'] = 'Med valgte...';
$string['zipusers'] = 'Download som ZIP';
