<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'da', version '3.11'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Accepter';
$string['accept_grades'] = 'Accepter karakterer fra værktøjet';
$string['accept_grades_admin'] = 'Accepter karakterer fra værktøjet';
$string['accept_grades_admin_help'] = 'Specificer hvorvidt værktøjsudbyderen kan tilføje, opdatere, læse og slette karakterer associeret med forekomster af værktøjet. Nogle værktøjsudbydere understøtter rapportering af karakterer tilbage til Moodle baseret på handlinger foretaget i værktøjet, og giver dermed en mere integreret oplevelse.';
$string['accept_grades_help'] = 'Specificer hvorvidt værktøjsudbyderen kan tilføje, opdatere, læse og slette karakterer associeret alene med denne forekomst af værktøjet.

Nogle værktøjsudbydere understøtter rapportering af karakterer tilbage til Moodle baseret på handlinger foretaget i værktøjet, og giver dermed en mere integreret oplevelse.

Bemærk at denne indstilling kan overskrives i værktøjskonfigurationen.';
$string['accepted'] = 'Accepteret';
$string['action'] = 'Handling';
$string['activate'] = 'Aktiver';
$string['activatetoadddescription'] = 'Du skal aktivere dette værktøj inden du kan tilføje en beskrivelse.';
$string['active'] = 'Aktiv';
$string['activity'] = 'Aktivitet';
$string['addnewapp'] = 'Aktiver ekstern applikation';
$string['addserver'] = 'Tilføj en ny betroet server';
$string['addtype'] = 'Tilføj forudkonfigureret værktøj';
$string['allow'] = 'Tillad';
$string['allowsetting'] = 'Tillad værktøjet at gemme 8K indstillinger i Moodle';
$string['always'] = 'Altid';
$string['autoaddtype'] = 'Tilføj værktøj';
$string['automatic'] = 'Automatisk, baseret på værktøjets URL';
$string['basiclti'] = 'LTI';
$string['basiclti_in_new_window'] = 'Din aktivitet er åbnet i et nyt vindue';
$string['basiclti_in_new_window_open'] = 'Åbn i nyt vindue';
$string['basiclti_parameters'] = 'LTI-opstartsparametre';
$string['basicltiactivities'] = 'LTI-aktiviteter';
$string['basicltifieldset'] = 'Eksempel på et skræddersyet sæt felter';
$string['basicltiintro'] = 'Aktivitetsbeskrivelse';
$string['basicltiname'] = 'Aktivitetsnavn';
$string['basicltisettings'] = 'Indstillinger til Basic Learning Tool Interoperability (LTI)';
$string['cachedef_keyset'] = 'Cachelagrer oplysningerne om nøglesæt for værktøjer';
$string['cancel'] = 'Annuller';
$string['cancelled'] = 'Annulleret';
$string['cannot_delete'] = 'Du kan måske ikke slette denne værktøjskonfiguration.';
$string['cannot_edit'] = 'Du kan måske ikke redigere denne værktøjskonfiguration.';
$string['capabilities'] = 'Beføjelser';
$string['capabilities_help'] = 'Vælg de beføjelser du vil tilbyde værktøjsudbyderen. Der kan vælges flere beføjelser.';
$string['capabilitiesrequired'] = 'Værktøjet kræver adgang til følgende data for at aktiveres:';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Klik for at fortsætte</a>';
$string['clientidadmin'] = 'Klient-id';
$string['comment'] = 'Kommentar';
$string['configpassword'] = 'Standard eksternt værktøjs-adgangskode';
$string['configpreferheight'] = 'Foretrukket standardhøjde';
$string['configpreferwidth'] = 'Foretrukket standardbredde';
$string['configresourceurl'] = 'Standard materiale-URL';
$string['configtoolurl'] = 'Standard ekstern værktøjs-URL';
$string['configtypes'] = 'Aktiver LTI-applikationer';
$string['configured'] = 'Konfigureret';
$string['confirmtoolactivation'] = 'Er du sikker på at du vil aktivere dette værktøj?';
$string['contentitem_deeplinking_help'] = 'Er indstillingen markeret vil muligheden "Vælg indhold" være tilgængelig når et nyt eksternt værktøj tilføjes.';
$string['contentitem_help'] = 'Er indstillingen markeret vil muligheden "Vælg indhold" være tilgængelig når et nyt eksternt værktøj tilføjes.';
$string['contentitem_multiple_description'] = 'Følgende elementer vil blive tilføjet dit kursus:';
$string['contentitem_multiple_graded'] = 'Bedømt aktivitet (højeste karakter: {$a})';
$string['course_tool_types'] = 'Kursusværktøj';
$string['courseactivitiesorresources'] = 'Kursusaktiviteter og -materialer';
$string['courseid'] = 'Kursus-id-nummer';
$string['courseinformation'] = 'Kursusinformation';
$string['courselink'] = 'Gå til kurset';
$string['coursemisconf'] = 'Kurset er miskonfigureret';
$string['createdon'] = 'Oprettet';
$string['curllibrarymissing'] = 'PHP cURL-biblioteket skal være installeret for at bruge det eksterne værktøj.';
$string['custom'] = 'Brugerdefinerede parametre';
$string['custom_config'] = 'Anvender skræddersyet værktøjskonfiguration';
$string['custom_help'] = 'Skræddersyede parametre er indstillinger der bruges af værktøjsudbyderen. En skræddersyet parameter kan for eksempel bruges til at vise et specifikt materiale fra udbyderen. Der kan skrives et parameter per linje i formatet "navn=værdi"; for eksempel "chapter=3".

Du kan lade feltet stå tomt med mindre andet ønskes af værktøjsudbyderen';
$string['custominstr'] = 'Brugerdefinerede parametre';
$string['debuglaunch'] = 'Debug-indstilling';
$string['debuglaunchoff'] = 'Normal lancering';
$string['debuglaunchon'] = 'Fejlfindings-lancering';
$string['default'] = 'Standard';
$string['default_launch_container'] = 'Standard startcontainer';
$string['default_launch_container_help'] = 'Startcontaineren påvirker hvordan værktøjet åbner i et kursus i Moodle.

* **Standard** - Bruger den startcontainer der er specificeret i konfigurationen af værktøjet.
* **Indlejret** - Værktøjet vises i det aktuelle Moodlevindue a la den måde de fleste andre aktiviteter vises på.
* **Indlejret, uden blokke** -  Værktøjet vises i det aktuelle Moodlevindue kun med navigationen og sidehovedet.
* **Nyt vindue** - Værktøjet åbner i et nyt vindue og bruger hele skærmen.
Afhængig af browseren vil det åbne i et nyt faneblad eller i et pop op-vindue.

Det er muligt at browseren vil forhindre åbning i et nyt vindue.';
$string['delegate'] = 'Deleger til lærer';
$string['delete'] = 'Slet';
$string['delete_confirmation'] = 'Er du sikker på at du vil slette dette prækonfigurerede værktøj?';
$string['deletetype'] = 'Slet prækonfigureret eksternt værktøj';
$string['display_description'] = 'Vis beskrivelse af aktiviteten når den starter';
$string['display_description_help'] = 'Hvis indstillingen er aktiveret, vil beskrivelse af aktiviteten (specificeret herover) vises oven over værktøjsudbyderens indhold.

Beskrivelsen kan bruges til ekstra instruktioner til værktøjets \'starter\'.

Beskrivelsen vises aldrig når værktøjet åbnes i et nyt vindue.';
$string['display_name'] = 'Vis aktivitetens navn når den åbner';
$string['display_name_help'] = 'Hvis indstillingen er aktiveret, vil aktivitetens navn (specificeret herover) vises oven over værktøjsudbyderens indhold.

Værktøjsudbyderen vil måske også vise titlen. Indstillingen her kan forhindre at den vises to gange.

Titlen vises aldrig når værktøjet åbner er i et nyt vindue.';
$string['domain_mismatch'] = 'Værktøjets domæne i URL\'en matcher ikke konfigurationen af værktøjet.';
$string['donot'] = 'Send ikke';
$string['donotaccept'] = 'Accepter ikke';
$string['donotallow'] = 'Tillad ikke';
$string['duplicateregurl'] = 'Denne registrerings-URL er allerede i brug';
$string['editdescription'] = 'Klik her for at give dette værktøj en beskrivelse';
$string['edittype'] = 'Rediger eksternt værktøjs konfiguration';
$string['embed'] = 'Indlejr';
$string['embed_no_blocks'] = 'Indlejr uden blokke';
$string['enableemailnotification'] = 'Send underretningsmails';
$string['enableemailnotification_help'] = 'Er indstillingen aktiveret, vil studerende blive underrettet via e-mail når deres afleveringer i værktøjet er bedømt.';
$string['enterkeyandsecret'] = 'Skriv din kundenøgle og delte hemmelige kode';
$string['enterkeyandsecret_help'] = 'Har du fået en kundenøgle og/eller en delt hemmelig kode, skal du skrive den her';
$string['errorincorrectconsumerkey'] = 'Kundenøglen er ikke korrekt';
$string['errorinvaliddata'] = 'Ugyldige data: {$a}';
$string['errorinvalidmediatype'] = 'Ugyldig type medie: {$a}';
$string['errorinvalidresponseformat'] = 'Ugyldigt format til Indholdselements svar';
$string['errormisconfig'] = 'Miskonfigureret værktøj. Bed din Moodleadministrator om at fikse det.';
$string['errortooltypenotfound'] = 'LTI-værktøjstype ikke fundet';
$string['existing_window'] = 'Eksisterende vindue';
$string['extensions'] = 'LTI-udvidelsesservices';
$string['external_tool_type'] = 'Eksternt type værktøj';
$string['external_tool_type_help'] = '* **Automatisk, baseret på værktøjets URL** - Den bedste konfiguration vælges automatisk. Hvis værktøjets URL ikke genkendes, skal konfigurationsoplysningerne indtastes manuelt.
* **Et specifikt forudindstillet værktøj** - Konfiguration for det specificerede værktøj vil blive brugt til kommunikation med den eksterne udbyder. Hvis ikke værktøjets URL ser ud til at tilhøre værktøjsudbyderen, vises en advarsel. Det er ikke altid nødvendigt at indtaste en URL.
* **Skræddersyet konfiguration** - En kundenøgle og en delt hemmelig kode skal nok indtastes manuelt. Kundenøglen og koden kan fås fra værktøjsudbyderen. Ikke alle værktøjer kræver dog kundenøgle og fælles hemmelig kode, i så fald kan felterne efterlades tomme.

### Redigering af prækonfigureret værktøj

Tre ikoner vises efter det prækonfigurerede værktøjs rullemenu:

* **Tilføj** - Opret en værktøjskonfiguration på kursusniveau, som alle eksterne værktøjer på kurset kan bruge
* **Rediger** - Vælg et værktøj på kursusniveau fra rullemenuen, og klik så på dette ikon. Oplysningerne i konfigurationen kan måske redigeres.
* **Slet** - Fjern det valgte værktøj på kursusniveau.';
$string['external_tool_types'] = 'Eksterne værktøjstyper';
$string['failedtoconnect'] = 'Moodle kunne ikke kommunikere med systemet "{$a}"';
$string['failedtocreatetooltype'] = 'Mislykkedes at oprette nyt værktøj. Tjek URL\'en og prøv igen.';
$string['failedtodeletetoolproxy'] = 'Mislykkedes at slette værktøjsregistreringen. Du kan evt. besøge "Administrer registrering af eksterne værktøjer" og slette den manuelt.';
$string['filter_basiclti_configlink'] = 'Konfigurer dine foretrukne sider og deres adgangskoder';
$string['filter_basiclti_password'] = 'Adgangskode er obligatorisk';
$string['filterconfig'] = 'LTI-administration';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Brug en eksisterende konfiguration til det miskonfigurerede værktøj.';
$string['fixnew'] = 'Ny konfiguration';
$string['fixnewconf'] = 'Definer en ny konfiguration til det miskonfigurerede værktøj.';
$string['fixold'] = 'Brug eksisterende';
$string['force_ssl'] = 'Gennemtving SSL';
$string['force_ssl_help'] = 'Vælges denne indstilling tvinges al brug af denne værktøjsudbyder til at bruge SSL.

Endvidere vil alle serviceforespørgsler fra værktøjsudbyderen også bruge SSL.

Bruger du denne mulighed, skal du bekræfte at både denne Moodle og værktøjsudbyderen understøtter SSL.';
$string['forced_help'] = 'Indstillingen er tvunget på kursus- eller site-niveau. Du kan nok ikke ændre det herfra.';
$string['generaltool'] = 'Generelt værktøj';
$string['global_tool_types'] = 'Prækonfigurerede værktøjer';
$string['icon_url'] = 'Ikon-URL';
$string['icon_url_help'] = 'Med ikon-URL\'en kan ikonet, der vises på kursuslisten for denne aktivitet, ændres. I stedet for at bruge LTI\'s standardikon, kan et andet ikon, der bedre udtrykker denne type aktivitet, specificeres.';
$string['id'] = 'Id';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidid'] = 'LTI-id var forkert';
$string['keytype'] = 'Offentlig nøgletype';
$string['keytype_help'] = 'Godkendelsesmetoden der bruges til at validere værktøjet.';
$string['keytype_keyset'] = 'URL til nøglesæt';
$string['keytype_rsa'] = 'RSA-nøgle';
$string['launch_in_moodle'] = 'Start værktøjet i Moodle';
$string['launch_in_popup'] = 'Lancer værktøjet i et pop op vindue';
$string['launch_url'] = 'Værktøjets URL';
$string['launch_url_help'] = 'Værktøjets URL er det eksterne værktøjs webadresse. Den kan indeholde ekstra information, såsom hvilken ressource der skal vises. Tjek med udbyderen hvis du er usikker på adressen.

Du kan opgive en "cartridge URL" hvis du har en, og resten vil blive udfyldt automatisk.

Har du valgt et foruddefineret værktøj, behøver du måske ikke at indtaste en værktøjs-URL. Det gælder formentlig hvis linket skal forbinde til udbyderens system og ikke til en specifik ressource.';
$string['launchinpopup'] = 'Startcontainer';
$string['launchinpopup_help'] = 'Startcontaineren påvirker hvordan værktøjet åbner i et kursus i Moodle.

* **Standard** - Bruger den startcontainer der er specificeret i konfigurationen af værktøjet.
* **Indlejret** - Værktøjet vises i det aktuelle Moodlevindue a la den måde de fleste andre aktiviteter vises på.
* **Indlejret, uden blokke** -  Værktøjet vises i det aktuelle Moodlevindue kun med navigationen og sidehovedet.
* **Nyt vindue** - Værktøjet åbner i et nyt vindue og bruger hele skærmen.
Afhængig af browseren vil det åbne i et nyt faneblad eller i et pop op-vindue.

Det er muligt at browseren vil forhindre åbning i et nyt vindue.';
$string['launchoptions'] = 'Lanceringsindstillinger';
$string['leaveblank'] = 'Lad dem stå tomme hvis ikke du skal bruge dem';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Tilføj kursusspecifikke værktøjsindstillinger';
$string['lti:addinstance'] = 'Tilføj et nyt eksternt værktøj';
$string['lti:addmanualinstance'] = 'Tilføj et manuelt konfigureret værktøj';
$string['lti:addpreconfiguredinstance'] = 'Tilføj et forudkonfigureret værktøj';
$string['lti:admin'] = 'Vær administrator når værktøjet indlæses';
$string['lti:grade'] = 'Vis karakterer opnået i det eksterne værktøj';
$string['lti:manage'] = 'Vær instruktør når værktøjet er startet';
$string['lti:requesttooladd'] = 'Efterspørgsel efter et værktøj er konfigureret på webstedsniveau';
$string['lti:view'] = 'Start eksterne værktøjsaktiviteter';
$string['lti_administration'] = 'Rediger prækonfigureret værktøj';
$string['lti_errormsg'] = 'Værktøjet returnerede denne besked: "{$a}"';
$string['lti_launch_error'] = 'Der opstod en fejl under start af det eksterne værktøj:';
$string['lti_launch_error_tool_request'] = '<p><a href="{$a->admin_request_url}" target="_top">Klik her</a> for at anmode administrator om at færdiggøre værktøjskonfigurationen. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>Denne fejl kan være et resultat af en manglende kundenøgle og delt hemmelig kode til værktøjsudbyderen.</p> <p>Hvis du har en kundenøgle og en delt hemmelig kode, kan du skrive den når du redigerer det eksterne værktøj (sørg for at avancerede indstillinger er synlige).</p> <p>Alternativt kan du <a href="{$a->course_tool_editor}">oprette en konfiguration til værktøjsudbyder på kursusniveau</a>.</p>';
$string['lti_tool_request_added'] = 'Forespørgslen på værktøjskonfigurationen er sendt. Du skal måske kontakte en administrator for at fuldføre konfigurationen.';
$string['lti_tool_request_existing'] = 'Der er allerede en værktøjskonfiguration for værktøjsdomænet.';
$string['ltisettings'] = 'LTI-indstillinger';
$string['ltiunknownserviceapicall'] = 'LTI ukendt kald af service-API.';
$string['main_admin'] = 'Generel help';
$string['main_admin_help'] = 'Med eksterne værktøjer kan Moodlebrugere interagere med læringsmaterialer der hostes eksternt. Gennem en speciel protokol, har fjernværktøjet adgang til generel information om værktøjets bruger, f.eks. institutionens navn, kursus-id, bruger-id og andre informationer såsom brugerens navn eller e-mailadresse.

Værktøjer der ses her, er delt i tre kategorier:

* **Aktiv** - Disse værktøjsudbydere er godkendt og konfigureret af en administrator. De kan bruges fra et vilkårligt kursus på denne Moodleinstallation. Hvis en kundenøgle og delt, hemmelig adgangsfrase angives, etableres et betroet forhold mellem dette site og fjernværktøjet gennem en sikker kommunikationskanal.
* **Afventer** - Disse værktøjsudbydere er kommet via en pakkeimport, men er endnu ikke konfigureret af en administrator. Lærere kan stadig bruge værktøjerne fra disse udbydere hvis de har en kundenøgle og en delt, hemmelig kode, såfremt det kræves.
* **Afvist** - Disse værktøjsudbydere markeret som nogle en administrator ikke påtænker at gøre tilgængelige i denne Moodleinstallation generelt. Lærere kan stadig bruge værktøjerne fra disse udbydere hvis de har en kundenøgle og en delt, hemmelig adgangsfrase, såfremt det kræves.';
$string['manage_external_tools'] = 'Administrer værktøjer';
$string['manage_tool_proxies'] = 'Administrer registrering af eksterne værktøjer.';
$string['manage_tools'] = 'Håndter prækonfigurerede værktøjer';
$string['manuallyaddtype'] = 'Alternativt kan du <a href="{$a}">manuelt konfigurere et værktøj</a>.';
$string['miscellaneous'] = 'Diverse';
$string['misconfiguredtools'] = 'Miskonfigurerede forekomster af værktøjer fundet';
$string['missingparameterserror'] = 'Siden er miskonfigureret: "{$a}"';
$string['module_class_type'] = 'Modultype i Moodle';
$string['modulename'] = 'Eksternt værktøj (LTI)';
$string['modulename_help'] = 'Med modulet "Eksternt værktøj" kan studerende bruge undervisningsmaterialer og -aktiviteter på andre websteder. For eksempel kan et eksternt værktøj give adgang til en ny type aktivitet eller undervisningsmaterialer fra en udbyder.

For at oprette en aktivitet af typen eksternt værktøj, kræves en værktøjsudbyder der understøtter LTI (Learning Tools Interoperability). En lærer kan oprette et eksternt værktøj eller gøre brug af et værktøj konfigureret af administrator.

Eksterne værktøjer adskiller sig fra URL-materialer på nogle få punkter:

* Eksterne værktøjer er "sammenhængsbevidste", dvs. de har adgang til information om brugeren af værktøjet såsom institution, kursus og navn
* Eksterne værktøjer understøtter læsning, opdatering og sletning af karakterer relateret til aktiviteten
* Eksterne værktøjers konfiguration opretter et betroet forhold mellem dit site og værktøjsudbyderen og tillader sikker kommunikation mellem dem.';
$string['modulename_link'] = 'mod/lti/view';
$string['modulenameplural'] = 'Eksterne værktøjer';
$string['modulenamepluralformatted'] = 'LTI-forekomster';
$string['name'] = 'Navn';
$string['never'] = 'Aldrig';
$string['new_window'] = 'Nyt vindue';
$string['no_lti_configured'] = 'Der er ikke konfigureret nogen aktive eksterne værktøjer.';
$string['no_lti_pending'] = 'Der er ingen ventende eksterne værktøjer.';
$string['no_lti_rejected'] = 'Der er ingen afviste eksterne værktøjer.';
$string['no_lti_tools'] = 'Der er ikke konfigureret nogen eksterne værktøjer.';
$string['no_tp_accepted'] = 'Der er ingen accepterede eksterne værktøjsregistreringer.';
$string['no_tp_cancelled'] = 'Der er ingen annullerede eksterne værktøjsregistreringer.';
$string['no_tp_configured'] = 'Der er ingen uregistrerede eksterne værktøjer konfigureret .';
$string['no_tp_pending'] = 'Der er ingen ventende eksterne værktøjsregistreringer.';
$string['no_tp_rejected'] = 'Der er ingen afviste eksterne værktøjsregistreringer.';
$string['noattempts'] = 'Ingen har kørt denne forekomst af værktøjet endnu';
$string['noltis'] = 'Der er ingen forekomster af eksterne værktøjer.';
$string['noprofileservice'] = 'Profilservice ikke fundet';
$string['noservers'] = 'Ingen servere fundet';
$string['notypes'] = 'Der er pt. ikke opsat nogen LTI-værktøjer i Moodle. Klik på Installer-linket herover for at tilføje nogle.';
$string['noviewusers'] = 'Der blev ikke fundet nogen brugere med tilladelse til at bruge dette værktøj';
$string['opensslconfiginvalid'] = 'LTI 1.3 kræver at en gyldig openssl.cnf konfigurers og er tilgængelig på din webserver. Kontakt sidens administrator for at konfigurere og aktivere openssl på dette site';
$string['optionalsettings'] = 'Frivillige indstillinger';
$string['organization'] = 'Organisationsoplysninger';
$string['organizationdescr'] = 'Organisationsbeskrivelse';
$string['organizationid'] = 'Organisations-id';
$string['organizationid_default'] = 'Standard organisations-id';
$string['organizationid_default_help'] = 'Den standardværdi der skal bruges som organisations-id. Websteds-id identificerer denne installation af Moodle.';
$string['organizationid_help'] = 'En unik identifikator til denne Moodleinstallation. Typisk bruges organisationens DNS-navn.

Efterlades feltet tomt, bruges denne Moodles værtsnavn som standardværdi.';
$string['organizationidguid'] = 'Organisations-id';
$string['organizationurl'] = 'Organisations-URL';
$string['organizationurl_help'] = 'Basis-URL\'en til denne Moodleinstallation.

Er feltet tomt bruges standardværdien baseret på sitekonfigurationen.';
$string['pagesize'] = 'Antal afleveringer vist per side';
$string['parameter'] = 'Værktøjsparametre';
$string['parameter_help'] = 'Værktøjsparametre er indstillinger krævet af udbyderen i den accepterede værktøjsproxy.';
$string['password'] = 'Delt hemmelig kode';
$string['password_admin'] = 'Delt hemmelig kode';
$string['password_admin_help'] = 'Den delte hemmelige kode kan betragtes som en kode til godkendelse af adgang til værktøjet. Den skal leveres sammen med kundenøglen fra værktøjsudbyderen.

Værktøjer der ikke kræver sikker kommunikation fra Moodle og ikke tilbyder yderligere tjenester (såsom rapportering), kræver måske ikke en delt hemmelig kode.';
$string['password_help'] = 'Når det gælder prækonfigurerede værktøjer er det ikke nødvendigt at indtaste en delt hemmelig kode her, den vil blive leveret som en del af konfigurationsprocessen.

Feltet skal udfyldes hvis der oprettes link til en udbyder, som ikke allerede er konfigureret. Hvis værktøjsudbyderen skal bruges flere gange på kurset, er det en god idé at  tilføje en værktøjskonfiguration.

Den delte hemmelige kode kan betragtes som en adgangskode til godkendelse af adgang til værktøjet. Den skal leveres sammen med kundenøglen fra udbyder.

Værktøjer som ikke kræver sikker kommunikation fra Moodle og ikke leverer yderligere servicer (såsom en karakterrapport) kræver ikke nødvendigvis en delt kode.';
$string['pending'] = 'Afventer';
$string['pluginadministration'] = 'Ekstern værktøjsadministration';
$string['pluginname'] = 'Eksternt værktøj';
$string['preferheight'] = 'Foretrukken højde';
$string['preferwidget'] = 'Foretræk start af widget';
$string['preferwidth'] = 'Foretrukken bredde';
$string['press_to_submit'] = 'Tryk for at begynde på denne aktivitet';
$string['privacy'] = 'Privatliv';
$string['publickey'] = 'Offentlig nøgle';
$string['publickey_help'] = 'Den offentlige nøgle (i PEM-format) stillet til rådighed af værktøjet for at tillade signaturer på indkomne beskeder og serviceforespørgsler blive verificeret.';
$string['publickeyset'] = 'Offentligt nøglesæt';
$string['publickeyset_help'] = 'Offentlige nøglesæt, hvorfra dette websted henter værktøjets offentlige nøgle for at tillade, at signaturer af indgående meddelelser og serviceanmodninger kan bekræftes.';
$string['quickgrade'] = 'Tillad hurtig-bedømmelse';
$string['quickgrade_help'] = 'Er indstillingen aktiveret, kan flere værktøjer bedømmes på samme side. Tilføj karakterer og kommentarer og klik så på knappen "Gem al min feedback" for at gemme ændringerne på siden.';
$string['redirect'] = 'Du vil blive omdirigeret om få sekunder. Hvis ikke, tryk på knappen.';
$string['redirectionuris'] = 'Omdirigerings-URI(\'er)';
$string['redirectionuris_help'] = 'En liste med URI\'er (en per linje) som værktøjet bruger til godkendelsesforespørgsler. Der skal mindst være en registreret før en besked kan sendes til værktøjet.';
$string['register'] = 'Registrer';
$string['register_warning'] = 'Registreringssiden ser ud til at være længe om at åbne. Kommer den ikke frem, skal du tjekke om konfigurationen indeholder den rigtige URL. Bruger Moodle https, skal du sikre dig at værktøjet understøtter https og at du bruger https i URL\'en.';
$string['registertype'] = 'Konfigurer en ny ekstern værktøjsregistrering.';
$string['registration_options'] = 'Registreringsindstillinger';
$string['registrationname'] = 'Værktøjsudbyders navn';
$string['registrationname_help'] = 'Skriv navnet på værktøjsudbyderen der registreres.';
$string['registrationurl'] = 'Registrerings-URL';
$string['registrationurl_help'] = 'Registrerings-URL\'en bør være tilgængelig fra værktøjsudbyderen hvortil registringer skal sendes.';
$string['reject'] = 'Afvis';
$string['rejected'] = 'Afvist';
$string['resource'] = 'Materiale';
$string['resourcekey'] = 'Kundenøgle';
$string['resourcekey_admin'] = 'Kundenøgle';
$string['resourcekey_admin_help'] = 'Kundenøglen kan betragtes som et brugernavn til godkendelse af adgang til værktøjet. Værktøjsudbyderen kan bruge den til at identificere det Moodle-site hvorfra brugere benytter værktøjet.

Nøglen skal leveres af værktøjsudbyderen. Hvordan leveringen foregår varierer fra udbyder til udbyder. Det kan være en automatiseret proces, eller det kan kræve en dialog med værktøjsudbyderen.

Værktøjer der ikke kræver sikker kommunikation fra Moodle og ikke tilbyder ekstra tjenester (såsom karakterrapportering), kræver måske ikke en nøgle.';
$string['resourcekey_help'] = 'Når der er tale om prækonfigurerede værktøjer er det ikke nødvendigt at angive en ressourcenøgle her, da kundenøglen vil blive leveret som en del af konfigurationsprocessen.

Feltet skal udfyldes hvis der oprettes et link til en værktøjsudbyder som ikke allerede er konfigureret. Bruges værktøjsudbyderen flere gange på dette kursus, er det en god ide at tilføje en konfiguration til kursusværkøj.

Kundenøglen kan betragtes som et brugernavn til godkendelse af adgang til værktøjet. Værktøjsudbyderen kan bruge den til at identificere det Moodle-site hvorfra brugere benytter værktøjet.

Nøglen skal leveres af værktøjsudbyderen. Hvordan leveringen foregår varierer fra udbyder til udbyder. Det kan være en automatiseret proces, eller det kan kræve en dialog med udbyderen.

Værktøjer der ikke kræver sikker kommunikation fra Moodle og ikke tilbyder ekstra tjenester (såsom karakterrapportering) kræver måske ikke en ressourcenøgle.';
$string['resourceurl'] = 'Materiale-URL';
$string['return_to_course'] = '<a href="{$a->link}" target="_top">Klik her</a> for at returnere til kurset.';
$string['saveallfeedback'] = 'Gem al min feedback';
$string['search:activity'] = 'Eksternt værktøj - aktivitetsinformation';
$string['secure_icon_url'] = 'Sikker ikon-URL';
$string['secure_icon_url_help'] = 'Tilsvarende ikon-URL\'en, men bruges hvis brugeren tilgår Moodle over SSL. Dette felt er beregnet til at hindre browseren i at vise en advarsel om et ikke sikkert billede.';
$string['secure_launch_url'] = 'Sikker værktøjs-URL';
$string['secure_launch_url_help'] = 'Tilsvarende værktøjs-URL\'en, men brugt i stedet hvis høj sikkerhed kræves. Moodle vil bruge den sikre URL i stedet for værktøjs-URL\'en hvis adgang til Moodle sker over SSL, eller hvis værktøjskonfigurationen er opsat til altid at bruge SSL.

Værktøjs-URL\'en kan også sættes op til en https-adresse for at tvinge indlæsning gennem SSL, og dette felt kan forblive tomt.';
$string['selectcontent'] = 'Vælg indhold';
$string['send'] = 'Send';
$string['services'] = 'Servicer';
$string['services_help'] = 'Vælg de servicer du vil tilbyde værktøjsudbyderen. Der kan vælges mere end en service.';
$string['setupoptions'] = 'Opsætningsindstillinger';
$string['share_email'] = 'Del opstarters email med værktøjet';
$string['share_email_admin'] = 'Del opstarters email med værktøjet';
$string['share_email_admin_help'] = 'Specificer hvorvidt e-mailadressen på den bruger der starter værktøjet vil blive delt med værktøjsudbyderen. Værktøjsudbyderen behøver den måske til at skelne mellem brugere med det samme navn i UI\'en eller til at sende mail til brugere baseret på handlinger i værktøjet.';
$string['share_email_help'] = 'Specificer hvorvidt e-mailadressen på den bruger der starter værktøjet vil blive delt med værktøjsudbyderen.

Værktøjsudbyderen behøver den måske til at skelne mellem brugere med det samme navn, eller til at sende mail til brugere baseret på handlinger i værktøjet.

Bemærk at indstillingen kan overskrives i værktøjskonfigurationen.';
$string['share_name'] = 'Del opstarterens navn med værktøjet';
$string['share_name_admin'] = 'Del opstarterens navn med værktøj';
$string['share_name_admin_help'] = 'Specificer hvorvidt det fulde navn på brugeren der starter værktøjet skal deles med værktøjsudbyderen. Værktøjsudbyderen skal måske kunne se navnene til visning af meningsfuld information i værktøjet.';
$string['share_name_help'] = 'Specificer hvorvidt det fulde navn på brugeren der starter værktøjet skal deles med værktøjsudbyderen.

Værktøjsudbyderen skal måske kunne se navnene til visning af meningsfuld information i værktøjet.

Bemærk at indstillingen kan overskrives i værktøjskonfigurationen.';
$string['share_roster'] = 'Lad værktøjet få adgang til deltagerlisten';
$string['share_roster_admin'] = 'Værktøjet vil måske se deltagerlisten';
$string['share_roster_admin_help'] = 'Specificer hvorvidt værktøjet har adgang til deltagerlisten på kurset hvorfra værktøjet bruges.';
$string['share_roster_help'] = 'Specificer hvorvidt værktøjet har adgang til deltagerlisten på kurset.

Bemærk at indstillingen kan overskrives i værktøjskonfigurationen.';
$string['show_in_course_activity_chooser'] = 'Vis i aktivitetsvælgeren som et prækonfigureret værktøj';
$string['show_in_course_lti1'] = 'Åbning af værktøjskonfiguration';
$string['show_in_course_lti1_help'] = 'Værktøjet kan vises på listen i aktivitetsvælgeren. Alternativt kan det vises i den prækonfigurerede rullemenu ved tilføjelse af et eksternt værktøj på kurset. En tredje mulighed er at konfiguration af værktøjet kun vises hvis dets URL indtastes når man vil tilføje det.';
$string['show_in_course_lti2'] = 'Åbning af værktøjskonfiguration';
$string['show_in_course_lti2_help'] = 'Værktøjet kan vises på listen i aktivitetsvælgeren eller i den prækonfigurerede rullemenu ved tilføjelse af et eksternt værktøj på kurset.';
$string['show_in_course_no'] = 'Vis ikke, brug det kun når en matchende værktøjs-URL indtastes';
$string['show_in_course_preconfigured'] = 'Vis som prækonfigureret værktøj når eksternt værktøj tilføjes';
$string['size'] = 'Størrelsesparametre';
$string['submission'] = 'Aflevering';
$string['submissions'] = 'Afleveringer';
$string['submissionsfor'] = 'Afleveringer for {$a}';
$string['subplugintype_ltiresource'] = 'LTI-service-ressource';
$string['subplugintype_ltiresource_plural'] = 'LTI-service-ressourcer';
$string['subplugintype_ltiservice'] = 'LTI-service';
$string['subplugintype_ltiservice_plural'] = 'LTI-servicer';
$string['subplugintype_ltisource'] = 'LTI-kilde';
$string['subplugintype_ltisource_plural'] = 'LTI-kilder';
$string['successfullycreatedtooltype'] = 'Nyt værktøj oprettet!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Hentede konfiguration til værktøjet fra det valgte indhold.';
$string['toggle_debug_data'] = 'Skift debug-data';
$string['tool_config_not_found'] = 'Værktøjskonfiguration blev ikke fundet til denne URL.';
$string['tool_settings'] = 'Værktøjsindstillinger';
$string['tooldescription'] = 'Beskrivelse af værktøj';
$string['tooldescription_help'] = 'Beskrivelsen af det værktøj der vises til lærere i aktivitetslisten. Den er til beskrivelse af formålet med værktøjet, hvad det gør og andre relevante oplysninger.';
$string['tooldetailsauthrequesturl'] = 'URL til godkendelsesforespørgsel';
$string['tooldetailsclientid'] = 'Klient-id';
$string['tooldetailsmailtosubject'] = 'LTI-værktøjskonfiguration';
$string['tooldetailsmodalemail'] = 'E-mail';
$string['tooldetailsmodallink'] = 'Se konfigurationsoplysninger';
$string['tooldetailsmodaltitle'] = 'Værktøjets konfigurationsoplysninger';
$string['tooldetailsplatformid'] = 'Platform-id';
$string['tooldetailspublickeyseturl'] = 'URL til offentligt nøglesæt';
$string['toolisbeingused'] = 'Værktøjet bruges {$a} gange';
$string['toolisnotbeingused'] = 'Værktøjet er endnu ikke i brug';
$string['toolproxy'] = 'Eksterne værktøjsregistreringer';
$string['toolproxy_help'] = 'Med ekstern værktøjsregistrering kan Moodle-administratorer konfigurere eksterne værktøjer fra en værktøjsproxy leveret af en udbyder som supporterer LTI 2.0. Det eneste der skal til  for at komme i gang, er en registrerings-URL. De kvalifikationer og servicer udbyderen tilbydes, vælges under konfiguration af registreringen.

Værktøjsregistreringer på denne side er opdelt i fire kategorier:

* **Konfigureret** - Disse registreringer er opsat, men registreringsprocessen er endnu ikke startet.
* **Afventer** - Registreringsprocessen er startet men ikke gennemført. Åbn og gem indstillingerne for at flytte den tilbage til kategorien "Konfigureret".
* **Accepteret** - Godkendte registreringer; de specificerede ressourcer i proxyen vil optræde på den forudkonfigurerede værktøjsside med en startstatus som "afventer".
* **Afvist** - Disse registreringer er blevet afvist under registreringsprocessen. Åbn og gem indstillingerne for at flytte dem tilbage til kategorien "Konfigureret" så registreringen kan starte igen.';
$string['toolproxyregistration'] = 'Ekstern værktøjsregistrering';
$string['toolregistration'] = 'Ekstern værktøjsregistrering';
$string['toolsetup'] = 'Ekstern værktøjskonfiguration';
$string['tooltypeadded'] = 'Prækonfigureret værktøj tilføjet';
$string['tooltypedeleted'] = 'Prækonfigureret værktøj slettet';
$string['tooltypenotdeleted'] = 'Kunne ikke slette prækonfigureret værktøj';
$string['tooltypes'] = 'Værktøjer';
$string['tooltypeupdated'] = 'Prækonfigureret værktøj opdateret';
$string['toolurl'] = 'Værktøjs-URL';
$string['toolurlplaceholder'] = 'Værktøjs-URL...';
$string['typename'] = 'Værktøjsnavn';
$string['typename_help'] = 'Værktøjets navn bruges til at identificere værktøjsudbyderen inde fra Moodle. Navnet vil blive vist til lærere når eksterne værktøjer tilføjes på kurser.';
$string['types'] = 'Typer';
$string['unabletocreatetooltype'] = 'Kan ikke oprette værktøj';
$string['unabletofindtooltype'] = 'Kan ikke finde værktøj for {$a->id}';
$string['unknownstate'] = 'Ukendt status';
$string['update'] = 'Opdater';
$string['useraccountinformation'] = 'Brugerkontoinformation';
$string['userpersonalinformation'] = 'Personlig brugerinformation';
$string['using_tool_configuration'] = 'Anvender værktøjskonfiguration:';
$string['validurl'] = 'En gyldig URL skal starte med http(s)://';
$string['viewsubmissions'] = 'Vis afleverings- og karakterskærm';
