<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'da', version '3.11'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresse';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Indsæt/rediger anker';
$string['advanced:backcolor_desc'] = 'Vælg baggrundsfarve';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Citatblok';
$string['advanced:blockquote_desc'] = 'Citatblok';
$string['advanced:bold_desc'] = 'Fed (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Indsæt/fjern unummereret punktopstilling';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Indsæt specialtegn';
$string['advanced:cleanup_desc'] = 'Ryd op i rodet kode';
$string['advanced:clipboard_msg'] = 'Kopier/klip/indsæt er ikke muligt i Mozilla og Firefox. Vil du have mere information om dette emne?';
$string['advanced:code'] = 'Kode';
$string['advanced:code_desc'] = 'Rediger HTML-kilde';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopier';
$string['advanced:custom1_desc'] = 'Din egen beskrivelse her';
$string['advanced:cut_desc'] = 'Klip';
$string['advanced:dd'] = 'Definitionsbeskrivelse';
$string['advanced:div'] = 'Div';
$string['advanced:dt'] = 'Definitionsterm';
$string['advanced:font_size'] = 'Skriftstørrelse';
$string['advanced:fontdefault'] = 'Skrifttype';
$string['advanced:forecolor_desc'] = 'Vælg tekstfarve';
$string['advanced:h1'] = 'Overskrift 1';
$string['advanced:h2'] = 'Overskrift 2';
$string['advanced:h3'] = 'Overskrift 3';
$string['advanced:h4'] = 'Overskrift 4';
$string['advanced:h5'] = 'Overskrift 5';
$string['advanced:h6'] = 'Overskrift 6';
$string['advanced:help_desc'] = 'Hjælp';
$string['advanced:help_shortcut'] = 'Tryk ALT-F10 for værktøjslinje. Tryk ALT-0 for hjælp';
$string['advanced:hr_desc'] = 'Vandret linje';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Indsæt/rediger billede';
$string['advanced:image_props_desc'] = 'Billedindsillinger';
$string['advanced:indent_desc'] = 'Øg indrykning';
$string['advanced:italic_desc'] = 'Kursiv (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centreret';
$string['advanced:justifyfull_desc'] = 'Lige marginer';
$string['advanced:justifyleft_desc'] = 'Venstrejusteret';
$string['advanced:justifyright_desc'] = 'Højrejusteret';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Indsæt/rediger link';
$string['advanced:more_colors'] = 'Flere farver...';
$string['advanced:newdocument'] = 'Er du sikker på du vil slette alt indhold?';
$string['advanced:newdocument_desc'] = 'Nyt dokument';
$string['advanced:numlist_desc'] = 'Indsæt/fjern nummereret opstilling';
$string['advanced:outdent_desc'] = 'Formindsk indrykning';
$string['advanced:paragraph'] = 'Afsnit';
$string['advanced:paste_desc'] = 'Indsæt';
$string['advanced:path'] = 'Sti';
$string['advanced:pre'] = 'Præformateret';
$string['advanced:redo_desc'] = 'Gendan (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Fjern formatering';
$string['advanced:rich_text_area'] = '"Rich text"-område';
$string['advanced:samp'] = 'Kodeeksempel';
$string['advanced:shortcuts_desc'] = 'Hjælp til tilgængelighed';
$string['advanced:striketrough_desc'] = 'Gennemstreget';
$string['advanced:style_select'] = 'Typografier';
$string['advanced:sub_desc'] = 'Sænket skrift';
$string['advanced:sup_desc'] = 'Hævet skrift';
$string['advanced:toolbar'] = 'Værktøjslinje';
$string['advanced:toolbar_focus'] = 'Spring til værktøjsknapper - Alt+Q, spring til redigering - Alt-Z, spring til elementsti - Alt-X';
$string['advanced:underline_desc'] = 'Understreget (Ctrl+U)';
$string['advanced:undo_desc'] = 'Fortryd (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Fjern link';
$string['advanced:visualaid_desc'] = 'Vis/skjul vejledning/usynlige elementer';
$string['advanced_dlg:about_author'] = 'Forfatter';
$string['advanced_dlg:about_general'] = 'Om';
$string['advanced_dlg:about_help'] = 'Hjælp';
$string['advanced_dlg:about_license'] = 'Licens';
$string['advanced_dlg:about_loaded'] = 'Indlæste udvidelser';
$string['advanced_dlg:about_plugin'] = 'Udvidelse';
$string['advanced_dlg:about_plugins'] = 'Udvidelser';
$string['advanced_dlg:about_title'] = 'Om TinyMCE';
$string['advanced_dlg:about_version'] = 'Version';
$string['advanced_dlg:accessibility_help'] = 'Hjælp til tilgængelighed';
$string['advanced_dlg:accessibility_usage_title'] = 'Generel brug';
$string['advanced_dlg:anchor_invalid'] = 'Skriv et gyldigt ankernavn';
$string['advanced_dlg:anchor_name'] = 'Navn på anker';
$string['advanced_dlg:anchor_title'] = 'Indsæt/rediger anker';
$string['advanced_dlg:charmap_title'] = 'Vælg specialtegn';
$string['advanced_dlg:charmap_usage'] = 'Naviger med højre- og venstrepil';
$string['advanced_dlg:code_title'] = 'Redigering af HTML-kildekode';
$string['advanced_dlg:code_wordwrap'] = 'Tekstombrydning';
$string['advanced_dlg:colorpicker_color'] = 'Farve:';
$string['advanced_dlg:colorpicker_name'] = 'Navn:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Navngivet';
$string['advanced_dlg:colorpicker_named_title'] = 'Navngivet farve';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palette';
$string['advanced_dlg:colorpicker_palette_title'] = 'Palette-farver';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Vælger';
$string['advanced_dlg:colorpicker_picker_title'] = 'Farvevælger';
$string['advanced_dlg:colorpicker_title'] = 'Vælg en farve';
$string['advanced_dlg:image_align'] = 'Justering';
$string['advanced_dlg:image_align_baseline'] = 'Grundlinje';
$string['advanced_dlg:image_align_bottom'] = 'Bunden';
$string['advanced_dlg:image_align_left'] = 'Venstre';
$string['advanced_dlg:image_align_middle'] = 'Midte';
$string['advanced_dlg:image_align_right'] = 'Højre';
$string['advanced_dlg:image_align_textbottom'] = 'Tekst bunden';
$string['advanced_dlg:image_align_texttop'] = 'Tekst toppen';
$string['advanced_dlg:image_align_top'] = 'Toppen';
$string['advanced_dlg:image_alt'] = 'Billedbeskrivelse';
$string['advanced_dlg:image_border'] = 'Ramme';
$string['advanced_dlg:image_dimensions'] = 'Dimensioner';
$string['advanced_dlg:image_hspace'] = 'Vandret afstand';
$string['advanced_dlg:image_list'] = 'Liste over billeder';
$string['advanced_dlg:image_src'] = 'Billed-URL';
$string['advanced_dlg:image_title'] = 'Indsæt/rediger billede';
$string['advanced_dlg:image_vspace'] = 'Lodret afstand';
$string['advanced_dlg:invalid_color_value'] = 'Ugyldig farveværdi';
$string['advanced_dlg:link_is_email'] = 'Den URL der er indtastet, ser ud til at være en e-mailadresse. Vil du have tilføjet det påkrævede mailto: foran?';
$string['advanced_dlg:link_is_external'] = 'Den URL, der er indtastet, ser ud til at være et eksternt link. Vil du tilføje det påkrævede http:// foran?';
$string['advanced_dlg:link_list'] = 'Liste over links';
$string['advanced_dlg:link_target'] = 'Destination';
$string['advanced_dlg:link_target_blank'] = 'Åben link i nyt vindue';
$string['advanced_dlg:link_target_same'] = 'Åben link i samme vindue';
$string['advanced_dlg:link_title'] = 'Indsæt/rediger link';
$string['advanced_dlg:link_titlefield'] = 'Titel';
$string['advanced_dlg:link_url'] = 'Link-URL';
$string['advhr:advhr_desc'] = 'Vandret linje';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Ingen skygge';
$string['advhr_dlg:size'] = 'Højde';
$string['advhr_dlg:width'] = 'Bredde';
$string['advhr_dlg:widthunits'] = 'Enheder';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Indsæt/rediger billede';
$string['advimage_dlg:align'] = 'Justering';
$string['advimage_dlg:align_baseline'] = 'Grundlinje';
$string['advimage_dlg:align_bottom'] = 'Bund';
$string['advimage_dlg:align_left'] = 'Venstre';
$string['advimage_dlg:align_middle'] = 'Midte';
$string['advimage_dlg:align_right'] = 'Højre';
$string['advimage_dlg:align_textbottom'] = 'Tekstbund';
$string['advimage_dlg:align_texttop'] = 'Teksttop';
$string['advimage_dlg:align_top'] = 'Top';
$string['advimage_dlg:alt'] = 'Billedbeskrivelse';
$string['advimage_dlg:alt_image'] = 'Alternativt billede';
$string['advimage_dlg:border'] = 'Ramme';
$string['advimage_dlg:classes'] = 'Klasser';
$string['advimage_dlg:constrain_proportions'] = 'Bevar proportioner';
$string['advimage_dlg:dialog_title'] = 'Indsæt/rediger billede';
$string['advimage_dlg:dimensions'] = 'Dimensioner';
$string['advimage_dlg:example_img'] = 'Forhåndsvisning af billede';
$string['advimage_dlg:general'] = 'Generelt';
$string['advimage_dlg:height'] = 'Højde';
$string['advimage_dlg:hspace'] = 'Vandret afstand';
$string['advimage_dlg:id'] = 'Id';
$string['advimage_dlg:image_list'] = 'Billedliste';
$string['advimage_dlg:langcode'] = 'Sprogkode';
$string['advimage_dlg:langdir'] = 'Sprogretning';
$string['advimage_dlg:list'] = 'Billedliste';
$string['advimage_dlg:long_desc'] = 'Langt beskrivelseslink';
$string['advimage_dlg:ltr'] = 'Venstre til højre';
$string['advimage_dlg:map'] = 'Billed-map';
$string['advimage_dlg:misc'] = 'Diverse';
$string['advimage_dlg:missing_alt'] = 'Er du sikker på, at du vil fortsætte uden at tilføje en billedbeskrivelse? Uden denne er billedet måske ikke tilgængeligt for brugere med handicaps eller for dem der bruger en tekstbrowser eller som browser internettet med billeder slået fra.';
$string['advimage_dlg:mouseout'] = 'for mus-ud';
$string['advimage_dlg:mouseover'] = 'for mus-over';
$string['advimage_dlg:preview'] = 'Forhåndsvisning';
$string['advimage_dlg:rtl'] = 'Højre til venstre';
$string['advimage_dlg:src'] = 'Billed-URL';
$string['advimage_dlg:style'] = 'Stil';
$string['advimage_dlg:swap_image'] = 'Skift billede';
$string['advimage_dlg:tab_advanced'] = 'Avanceret';
$string['advimage_dlg:tab_appearance'] = 'Udseende';
$string['advimage_dlg:tab_general'] = 'Generelt';
$string['advimage_dlg:title'] = 'Titel';
$string['advimage_dlg:vspace'] = 'Lodret afstand';
$string['advimage_dlg:width'] = 'Bredde';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Indsæt/rediger link';
$string['advlink_dlg:accesskey'] = 'Genvejstast';
$string['advlink_dlg:advanced_props'] = 'Avancerede egenskaber';
$string['advlink_dlg:advanced_tab'] = 'Avanceret';
$string['advlink_dlg:anchor_names'] = 'Ankre';
$string['advlink_dlg:classes'] = 'Klasser';
$string['advlink_dlg:encoding'] = 'Kodning af destinationstegn';
$string['advlink_dlg:event_props'] = 'Hændelser';
$string['advlink_dlg:events_tab'] = 'Hændelser';
$string['advlink_dlg:general_props'] = 'Generelle egenskaber';
$string['advlink_dlg:general_tab'] = 'Generelt';
$string['advlink_dlg:height'] = 'Højde';
$string['advlink_dlg:id'] = 'Id';
$string['advlink_dlg:is_email'] = 'Den URL der er indtastet, ser ud til at være en e-mailadresse. Vil du have tilføjet det påkrævede \'mailto:\' foran?';
$string['advlink_dlg:is_external'] = 'Den URL der er indtastet, ser ud til at være et eksternt link. Vil du have tilføjet det påkrævede \'http://\' foran?';
$string['advlink_dlg:langcode'] = 'Sprogkode';
$string['advlink_dlg:langdir'] = 'Sprogretning';
$string['advlink_dlg:link_list'] = 'Liste over links';
$string['advlink_dlg:list'] = 'Liste over links';
$string['advlink_dlg:ltr'] = 'Venstre mod højre';
$string['advlink_dlg:mime'] = 'Destinations-MIME-type';
$string['advlink_dlg:popup'] = 'Javascript-pop op';
$string['advlink_dlg:popup_dependent'] = 'Afhængig (Kun Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Vis adresselinje';
$string['advlink_dlg:popup_menubar'] = 'Vis menulinje';
$string['advlink_dlg:popup_name'] = 'Vinduesnavn';
$string['advlink_dlg:popup_opts'] = 'Indstillinger';
$string['advlink_dlg:popup_position'] = 'Position (X/Y)';
$string['advlink_dlg:popup_props'] = 'Pop op-egenskaber';
$string['advlink_dlg:popup_resizable'] = 'Lad det være muligt at ændre størrelsen på vinduet';
$string['advlink_dlg:popup_return'] = 'Indsæt "return false"';
$string['advlink_dlg:popup_scrollbars'] = 'Vis rullepanel';
$string['advlink_dlg:popup_size'] = 'Størrelse';
$string['advlink_dlg:popup_statusbar'] = 'Vis statuslinje';
$string['advlink_dlg:popup_tab'] = 'Pop op';
$string['advlink_dlg:popup_toolbar'] = 'Vis værktøjslinjer';
$string['advlink_dlg:popup_url'] = 'Pop op-URL';
$string['advlink_dlg:rel'] = 'Relativ side til destination';
$string['advlink_dlg:rev'] = 'Relativ destination til side';
$string['advlink_dlg:rtl'] = 'Højre mod venstre';
$string['advlink_dlg:style'] = 'Stil';
$string['advlink_dlg:tabindex'] = 'TabIndex';
$string['advlink_dlg:target'] = 'Destination';
$string['advlink_dlg:target_blank'] = 'Åben i nyt vindue';
$string['advlink_dlg:target_langcode'] = 'Destinationssprog';
$string['advlink_dlg:target_name'] = 'Destinationsnavn';
$string['advlink_dlg:target_parent'] = 'Åbn i overliggende vindue/ramme';
$string['advlink_dlg:target_same'] = 'Åbn i aktuelle vindue/ramme';
$string['advlink_dlg:target_top'] = 'Åben i øverste vindue/ramme (erstatter alle rammer)';
$string['advlink_dlg:title'] = 'Indsæt/rediger link';
$string['advlink_dlg:titlefield'] = 'Titel';
$string['advlink_dlg:url'] = 'Link-URL';
$string['advlink_dlg:width'] = 'Bredde';
$string['advlist:circle'] = 'Cirkel';
$string['advlist:def'] = 'Standard';
$string['advlist:disc'] = 'Diskos';
$string['advlist:square'] = 'Kvadrat';
$string['advlist:types'] = 'Typer';
$string['aria:rich_text_area'] = '"Rich text"-område';
$string['autosave:restore_content'] = 'Gendan auto-backup af indholdet';
$string['autosave:unload_msg'] = 'Har du foretaget nogle ændringer, vil de gå tabt, hvis du navigerer væk fra denne side.';
$string['autosave:warning_message'] = 'Hvis du genindlæser det gemte indhold, vil du miste det aktuelle indhold i editoren.

Er du sikker på at du vil gendanne det gemte indhold?';
$string['availablebuttons'] = 'Tilgængelige knapper';
$string['colors:000000'] = 'Sort';
$string['colors:000080'] = 'Marineblå';
$string['colors:0000FF'] = 'Blå';
$string['colors:003300'] = 'Mørkegrøn';
$string['colors:003366'] = 'Mørk himmelblå';
$string['colors:008000'] = 'Grøn';
$string['colors:008080'] = 'Petroleum';
$string['colors:00CCFF'] = 'Himmelblå';
$string['colors:00FF00'] = 'Lime';
$string['colors:00FFFF'] = 'Akvamarin';
$string['colors:333300'] = 'Mørk oliven';
$string['colors:333333'] = 'Meget mørk grå';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Kongeblå';
$string['colors:339966'] = 'Havgrøn';
$string['colors:33CCCC'] = 'Turkis';
$string['colors:666699'] = 'Gråblå';
$string['colors:800000'] = 'Kastanjebrun';
$string['colors:800080'] = 'Purpur';
$string['colors:808000'] = 'Oliven';
$string['colors:808080'] = 'Grå';
$string['colors:993300'] = 'Brændt orange';
$string['colors:993366'] = 'Brun';
$string['colors:999999'] = 'Medium grå';
$string['colors:99CC00'] = 'Gulgrøn';
$string['colors:99CCFF'] = 'Lys himmelblå';
$string['colors:C0C0C0'] = 'Sølv';
$string['colors:CC99FF'] = 'Blomme';
$string['colors:CCFFCC'] = 'Bleggrøn';
$string['colors:CCFFFF'] = 'Bleg cyan';
$string['colors:FF0000'] = 'Rød';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Orange';
$string['colors:FF9900'] = 'Ravgul';
$string['colors:FF99CC'] = 'Pink';
$string['colors:FFCC00'] = 'Guld';
$string['colors:FFCC99'] = 'Fersken';
$string['colors:FFFF00'] = 'Gul';
$string['colors:FFFF99'] = 'Lysegul';
$string['colors:FFFFFF'] = 'Hvid';
$string['common:apply'] = 'Anvend';
$string['common:browse'] = 'Gennemse';
$string['common:cancel'] = 'Annuller';
$string['common:class_name'] = 'Klasse';
$string['common:clipboard_msg'] = 'Kopier/klip/indsæt er ikke muligt i Mozilla og Firefox.
Vil du have mere information om dette emne?';
$string['common:clipboard_no_support'] = 'På nuværende tidspunkt ikke supporteret af din browser. Anvend i stedet genvejene på tastaturet.';
$string['common:close'] = 'Luk';
$string['common:edit_confirm'] = 'Vil du bruge den avancerede tekstredigering?';
$string['common:insert'] = 'Indsæt';
$string['common:invalid_data'] = 'Fejl: Forkerte værdier indtastet i felter markeret med rød.';
$string['common:invalid_data_min'] = '{#field} skal være et tal større end {#min}';
$string['common:invalid_data_number'] = '{#field} skal være et tal';
$string['common:invalid_data_size'] = '{#field} skal være en procentsats';
$string['common:more_colors'] = 'Flere farver...';
$string['common:not_set'] = '-- Ikke sat --';
$string['common:popup_blocked'] = 'Undskyld, men din pop op-blokering har forhindret et vindue, der giver programmet funktionalitet, i at åbne. Hvis du vil have den fulde funktionalitet, må du slå pop op-blokeringen fra for dette websted.';
$string['common:update'] = 'Opdater';
$string['common:value'] = '(værdi)';
$string['contextmenu:align'] = 'Justering';
$string['contextmenu:center'] = 'Centreret';
$string['contextmenu:full'] = 'Lige marginer';
$string['contextmenu:left'] = 'Venstre';
$string['contextmenu:right'] = 'Højre';
$string['customconfig'] = 'Brugerdefineret konfiguration';
$string['customconfig_desc'] = 'Tilpasset avanceret TinyMCE-konfiguration i JSON-format, for eksempel: {"option1" : "value2", "option2" : "value2"}. De her definerede valg overskriver standard- og plugin-indstillinger.';
$string['customtoolbar'] = 'Editorværktøjslinje';
$string['customtoolbar_desc'] = 'Hver linje indeholder en kommasepareret liste med navne på knapper, brug "wrap" som gruppeseparator, tomme linjer ignoreres. Se <a href="{$a}" target="_blank">{$a}</a> listen med TinyMCE\'s standardknapper.<br />Den første række vises altid, mens man kan skifte mellem mellem anden og tredje værktøjslinje.';
$string['directionality:ltr_desc'] = 'Retning venstre mod højre';
$string['directionality:rtl_desc'] = 'Retning højre mod venstre';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Humørikoner';
$string['emotions_dlg:cool'] = 'Rolig';
$string['emotions_dlg:cry'] = 'Græde';
$string['emotions_dlg:desc'] = 'Humørikoner';
$string['emotions_dlg:embarassed'] = 'Flov';
$string['emotions_dlg:foot_in_mouth'] = 'Fod i munden';
$string['emotions_dlg:frown'] = 'Forskrækket';
$string['emotions_dlg:innocent'] = 'Uskyldig';
$string['emotions_dlg:kiss'] = 'Kys';
$string['emotions_dlg:laughing'] = 'Grine';
$string['emotions_dlg:money_mouth'] = 'Pengemund';
$string['emotions_dlg:sealed'] = 'Lukket';
$string['emotions_dlg:smile'] = 'Smil';
$string['emotions_dlg:surprised'] = 'Overrasket';
$string['emotions_dlg:title'] = 'Indsæt humørikon';
$string['emotions_dlg:tongue_out'] = 'Tunge ud';
$string['emotions_dlg:undecided'] = 'Ubeslutsom';
$string['emotions_dlg:usage'] = 'Naviger med højre- og venstrepile.';
$string['emotions_dlg:wink'] = 'Vink';
$string['emotions_dlg:yell'] = 'Råb';
$string['fontselectlist'] = 'Liste med tilgængelige fonte';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Dokumentegenskaber';
$string['fullpage_dlg:active_color'] = 'Farve ved museklik';
$string['fullpage_dlg:add'] = 'Tilføj nyt element';
$string['fullpage_dlg:add_base'] = 'Base-element';
$string['fullpage_dlg:add_comment'] = 'Kommentar-node';
$string['fullpage_dlg:add_link'] = 'Link-element';
$string['fullpage_dlg:add_meta'] = 'Meta-element';
$string['fullpage_dlg:add_script'] = 'Script-element';
$string['fullpage_dlg:add_style'] = 'Stil-element';
$string['fullpage_dlg:add_title'] = 'Titelelement';
$string['fullpage_dlg:advanced_props'] = 'Avanceret';
$string['fullpage_dlg:advanced_tab'] = 'Avanceret';
$string['fullpage_dlg:appearance_bgprops'] = 'Baggrundsegenskaber';
$string['fullpage_dlg:appearance_linkprops'] = 'Linkfarver';
$string['fullpage_dlg:appearance_marginprops'] = 'Sidemargener';
$string['fullpage_dlg:appearance_style'] = 'Stilark og stilegenskaber';
$string['fullpage_dlg:appearance_tab'] = 'Udseende';
$string['fullpage_dlg:appearance_textprops'] = 'Tekstegenskaber';
$string['fullpage_dlg:author'] = 'Forfatter';
$string['fullpage_dlg:base_element'] = 'Base-element';
$string['fullpage_dlg:bgcolor'] = 'Baggrundsfarve';
$string['fullpage_dlg:bgimage'] = 'Baggrundsbillede';
$string['fullpage_dlg:bottom_margin'] = 'Bundmargin';
$string['fullpage_dlg:charset'] = 'Tegnsæt';
$string['fullpage_dlg:comment_element'] = 'Kommentar';
$string['fullpage_dlg:content'] = 'Indhold';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Udsæt';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Tegnsæt';
$string['fullpage_dlg:font_face'] = 'Skrifttype';
$string['fullpage_dlg:font_size'] = 'Skriftstørrelse';
$string['fullpage_dlg:fontface'] = 'Skrifttype';
$string['fullpage_dlg:fontsize'] = 'Skriftstørrelse';
$string['fullpage_dlg:general_props'] = 'Generelt';
$string['fullpage_dlg:head_elements'] = 'Hovedelement';
$string['fullpage_dlg:hover_color'] = 'Farve ved pegning med mus';
$string['fullpage_dlg:href'] = 'Href';
$string['fullpage_dlg:hreflang'] = 'Href lang';
$string['fullpage_dlg:info'] = 'Information';
$string['fullpage_dlg:langcode'] = 'Sprogkode';
$string['fullpage_dlg:langdir'] = 'Sprogretning';
$string['fullpage_dlg:langprops'] = 'Sprog og kodning';
$string['fullpage_dlg:language'] = 'Sprog';
$string['fullpage_dlg:left_margin'] = 'Venstre margin';
$string['fullpage_dlg:link_color'] = 'Linkfarve';
$string['fullpage_dlg:link_element'] = 'Link-element';
$string['fullpage_dlg:ltr'] = 'Venstre mod højre';
$string['fullpage_dlg:media'] = 'Medie';
$string['fullpage_dlg:meta_description'] = 'Beskrivelse';
$string['fullpage_dlg:meta_element'] = 'Meta-element';
$string['fullpage_dlg:meta_index_follow'] = 'Indeks og følg links';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indeks og følg ikke links';
$string['fullpage_dlg:meta_keywords'] = 'Nøgleord';
$string['fullpage_dlg:meta_noindex_follow'] = 'Ingen indeks, men følg links';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Indekser ikke og følg ikke links';
$string['fullpage_dlg:meta_props'] = 'Meta-information';
$string['fullpage_dlg:meta_robots'] = 'Robotter';
$string['fullpage_dlg:meta_tab'] = 'Generelt';
$string['fullpage_dlg:meta_title'] = 'Titel';
$string['fullpage_dlg:movedown'] = 'Flyt valgte element ned';
$string['fullpage_dlg:moveup'] = 'Flyt valgte element op';
$string['fullpage_dlg:name'] = 'Navn';
$string['fullpage_dlg:properties'] = 'Egenskaber';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Slet valgte element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Højre margin';
$string['fullpage_dlg:rtl'] = 'Højre mod venstre';
$string['fullpage_dlg:script_element'] = 'Script-element';
$string['fullpage_dlg:src'] = 'Kilde';
$string['fullpage_dlg:style'] = 'Stil';
$string['fullpage_dlg:style_element'] = 'Stil-element';
$string['fullpage_dlg:stylesheet'] = 'Stilark';
$string['fullpage_dlg:target'] = 'Destination';
$string['fullpage_dlg:text_color'] = 'Tekstfarve';
$string['fullpage_dlg:textcolor'] = 'Farve';
$string['fullpage_dlg:title'] = 'Dokumentegenskaber';
$string['fullpage_dlg:title_element'] = 'Titelelement';
$string['fullpage_dlg:top_margin'] = 'Topmargin';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'Værdi';
$string['fullpage_dlg:visited_color'] = 'Farve efter museklik';
$string['fullpage_dlg:xml_pi'] = 'XML-deklaration';
$string['fullscreen:desc'] = 'Aktiver/deaktiver fuldskærmstilstand';
$string['iespell:download'] = 'ieSpell blev ikke fundet. Vil du installere det nu?';
$string['iespell:iespell_desc'] = 'Tjek for stavefejl';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'søndag,mandag,tirsdag,onsdag,torsdag,fredag,lørdag,søndag';
$string['insertdatetime:day_short'] = 'søn,man,tir,ons,tor,fre,lør,søn';
$string['insertdatetime:insertdate_desc'] = 'Indsæt dato';
$string['insertdatetime:inserttime_desc'] = 'Indsæt klokkeslæt';
$string['insertdatetime:months_long'] = 'januar,februar,marts,april,maj,juni,juli,august,september,oktober,november,december';
$string['insertdatetime:months_short'] = 'jan,feb,mar,apr,maj,jun,jul,aug,sep,okt,nov,dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Slå absolut positionering til/fra';
$string['layer:backward_desc'] = 'Flyt bagud';
$string['layer:content'] = 'Nyt lag...';
$string['layer:forward_desc'] = 'Flyt fremad';
$string['layer:insertlayer_desc'] = 'Indsæt nyt lag';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Indsæt/rediger indlejret mediefil';
$string['media:edit'] = 'Rediger indlejret mediefil';
$string['media_dlg:advanced'] = 'Avanceret';
$string['media_dlg:align'] = 'Juster';
$string['media_dlg:align_bottom'] = 'Bund';
$string['media_dlg:align_bottom_left'] = 'Nederste venstre hjørne';
$string['media_dlg:align_bottom_right'] = 'Øverste højre hjørne';
$string['media_dlg:align_center'] = 'Centreret';
$string['media_dlg:align_left'] = 'Venstre';
$string['media_dlg:align_right'] = 'Højret';
$string['media_dlg:align_top'] = 'Top';
$string['media_dlg:align_top_left'] = 'Øverste venstre hjørne';
$string['media_dlg:align_top_right'] = 'Øverste højre hjørne';
$string['media_dlg:altsource1'] = 'Alternativ kilde 1';
$string['media_dlg:altsource2'] = 'Alternativ kilde 2';
$string['media_dlg:audio'] = 'HTML5-lyd';
$string['media_dlg:autogotourl'] = 'Auto gå til URL';
$string['media_dlg:autohref'] = 'Auto href';
$string['media_dlg:autostart'] = 'Afspil automatisk';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'Base-URL';
$string['media_dlg:bgcolor'] = 'Baggrund';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Captioning id';
$string['media_dlg:center'] = 'Center';
$string['media_dlg:class_name'] = 'Klasse';
$string['media_dlg:console'] = 'Konsol';
$string['media_dlg:constrain_proportions'] = 'Bevar proportioner';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Kontrollerer';
$string['media_dlg:correction'] = 'Ingen korrektion';
$string['media_dlg:currentmarker'] = 'Aktuel markør';
$string['media_dlg:currentposition'] = 'Aktuel position';
$string['media_dlg:defaultframe'] = 'Standardramme';
$string['media_dlg:embedded_audio_options'] = 'Egenskaber for indlejret lyd';
$string['media_dlg:embeddedaudio'] = 'Indlejret lyd';
$string['media_dlg:enabled'] = 'Aktiveret';
$string['media_dlg:enablejavascript'] = 'Tillad JavaScript';
$string['media_dlg:endtime'] = 'Sluttidspunkt';
$string['media_dlg:file'] = 'Fil/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash-egenskaber';
$string['media_dlg:flashvars'] = 'Flash vars';
$string['media_dlg:fullscreen'] = 'Fuld skærm';
$string['media_dlg:general'] = 'Generelt';
$string['media_dlg:hidden'] = 'Skjul';
$string['media_dlg:href'] = 'Href';
$string['media_dlg:hspace'] = 'H-afstand';
$string['media_dlg:html5_audio_options'] = 'Lydegenskaber';
$string['media_dlg:html5_video_options'] = 'HTML5-videoegenskaber';
$string['media_dlg:id'] = 'Id';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Billedstatus';
$string['media_dlg:invokeurls'] = 'Aktiver URL\'er';
$string['media_dlg:kioskmode'] = 'Kiosk-tilstand';
$string['media_dlg:list'] = 'Liste';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Gentag';
$string['media_dlg:maintainaspect'] = 'Bevar aspekt';
$string['media_dlg:menu'] = 'Vis menu';
$string['media_dlg:mute'] = 'Lydløs';
$string['media_dlg:name'] = 'Navn';
$string['media_dlg:nojava'] = 'Ingen java';
$string['media_dlg:numloop'] = 'Antal loops';
$string['media_dlg:play'] = 'Afspil automatisk';
$string['media_dlg:playcount'] = 'Afspil indhold';
$string['media_dlg:playeveryframe'] = 'Afspil alle rammer';
$string['media_dlg:poster'] = 'Plakat';
$string['media_dlg:prefetch'] = 'Forhåndshent';
$string['media_dlg:preload'] = 'Forhåndsindlæs';
$string['media_dlg:preload_auto'] = 'Lad brugerens browser bestemme';
$string['media_dlg:preload_metadata'] = 'Forhåndshent videos metadata';
$string['media_dlg:preload_none'] = 'Forhåndshent ikke';
$string['media_dlg:preview'] = 'Forhåndsvisning';
$string['media_dlg:progress'] = 'Progression';
$string['media_dlg:qt_options'] = 'Quicktime-egenskaber';
$string['media_dlg:qt_stream_warn'] = 'Streamede rtsp-materialer skal tilføjes QT kilde-feltet under fanen avanceret. Du bør også føje en ikke streamet version til kildefeltet.';
$string['media_dlg:qtsrc'] = 'QT Kilde';
$string['media_dlg:qtsrcchokespeed'] = 'Choke-hastighed';
$string['media_dlg:quality'] = 'Kvalitet';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Vurder';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real Media Player-egenskaber';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Skaler';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave-egenskaber';
$string['media_dlg:shuffle'] = 'Bland';
$string['media_dlg:size'] = 'Dimensioner';
$string['media_dlg:sound'] = 'Lyd';
$string['media_dlg:source'] = 'Kilde';
$string['media_dlg:starttime'] = 'Starttidspunkt';
$string['media_dlg:stretchtofit'] = 'Stræk for at tilpasse';
$string['media_dlg:swstretchhalign'] = 'Stræk H-justering';
$string['media_dlg:swstretchstyle'] = 'Stræk-stil';
$string['media_dlg:swstretchvalign'] = 'Stræk V-justering';
$string['media_dlg:target'] = 'Destination';
$string['media_dlg:targetcache'] = 'Destinations-cache';
$string['media_dlg:title'] = 'Indsæt/rediger indlejret mediefil';
$string['media_dlg:type'] = 'Type';
$string['media_dlg:uimode'] = 'UI-tilstand';
$string['media_dlg:video'] = 'HTML5-video';
$string['media_dlg:volume'] = 'Lydstyrke';
$string['media_dlg:vspace'] = 'V-afstand';
$string['media_dlg:windowlessvideo'] = 'Vinduesløs video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Egenskaber for Windows Media Player';
$string['nonbreaking:nonbreaking_desc'] = 'Indsæt et mellemrumstegn';
$string['pagebreak:desc'] = 'Indsæt sideskift til udskrift';
$string['paste:paste_text_desc'] = 'Indsæt uformateret tekst';
$string['paste:paste_word_desc'] = 'Indsæt fra  Word';
$string['paste:plaintext_mode'] = 'Indsæt er nu i uformateret teksttilstand. Klik igen for at skifte tilbage til almindelig indsætningstilstand. Når du har indsat noget vil du automatisk vende tilbage til almindelig indsætningstilstand.';
$string['paste:plaintext_mode_stick'] = 'Indsæt er nu i uformateret teksttilstand. Klik igen for at vende tilbage til almindelig indsætningstilstand.';
$string['paste:selectall_desc'] = 'Vælg alle';
$string['paste_dlg:text_linebreaks'] = 'Bevar linjeskift';
$string['paste_dlg:text_title'] = 'Anvend Ctrl+V på tastaturet for at indsætte teksten.';
$string['paste_dlg:word_title'] = 'Anvend Ctrl+V på tastaturet for at indsætte teksten.';
$string['pluginname'] = 'TinyMCE HTML-editor';
$string['preview:preview_desc'] = 'Forhåndsvisning';
$string['print:print_desc'] = 'Udskriv';
$string['privacy:metadata'] = 'Plugin\'et TinyMCE HTML-editor gemmer ingen personlige data.';
$string['save:cancel_desc'] = 'Annuller alle ændringer';
$string['save:save_desc'] = 'Gem';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Søg/erstat';
$string['searchreplace:search_desc'] = 'Søg';
$string['searchreplace_dlg:allreplaced'] = 'Alle forekomster af søgestrengen er erstattet.';
$string['searchreplace_dlg:direction'] = 'Retning';
$string['searchreplace_dlg:down'] = 'Ned';
$string['searchreplace_dlg:findnext'] = 'Find næste';
$string['searchreplace_dlg:findwhat'] = 'Søg efter';
$string['searchreplace_dlg:mcase'] = 'Forskel på store og små bogstaver';
$string['searchreplace_dlg:notfound'] = 'Søgningen gav intet resultat.';
$string['searchreplace_dlg:replace'] = 'Erstat';
$string['searchreplace_dlg:replace_title'] = 'Søg/erstat';
$string['searchreplace_dlg:replaceall'] = 'Erstat alle';
$string['searchreplace_dlg:replacewith'] = 'Erstat med';
$string['searchreplace_dlg:search_title'] = 'Søg';
$string['searchreplace_dlg:searchnext_desc'] = 'Søg igen';
$string['searchreplace_dlg:up'] = 'Op';
$string['settings'] = 'Generelle indstillinger';
$string['simple:bold_desc'] = 'Fed (Ctrl+B)';
$string['simple:bullist_desc'] = 'Indsæt/fjern punktopstilling';
$string['simple:cleanup_desc'] = 'Ryd op i rodet kode';
$string['simple:italic_desc'] = 'Kursiv (Ctrl+I)';
$string['simple:numlist_desc'] = 'Indsæt/fjern punktopstilling';
$string['simple:redo_desc'] = 'Gendan (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Gennemstreget';
$string['simple:underline_desc'] = 'Understreget (Ctrl+U)';
$string['simple:undo_desc'] = 'Fortryd (Ctrl+Z)';
$string['spellchecker:desc'] = 'Aktiver/deaktier stavekontrol';
$string['spellchecker:ignore_word'] = 'Ignorer ord';
$string['spellchecker:ignore_words'] = 'Ignorer alle';
$string['spellchecker:langs'] = 'Sprog';
$string['spellchecker:learn_word'] = 'Lær ord';
$string['spellchecker:menu'] = 'Indstilling af stavekontrol';
$string['spellchecker:no_mpell'] = 'Ingen stavefejl fundet.';
$string['spellchecker:no_sug'] = 'Ingen forslag';
$string['spellchecker:sug'] = 'Forslag';
$string['spellchecker:wait'] = 'Vent...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Rediger CSS';
$string['style_dlg:apply'] = 'Anvend';
$string['style_dlg:background'] = 'Baggrund';
$string['style_dlg:background_attachment'] = 'Bilag';
$string['style_dlg:background_color'] = 'Baggrundsfarve';
$string['style_dlg:background_hpos'] = 'Vandret position';
$string['style_dlg:background_image'] = 'Baggrundsbillede';
$string['style_dlg:background_repeat'] = 'Gentag';
$string['style_dlg:background_tab'] = 'Baggrund';
$string['style_dlg:background_vpos'] = 'Lodret position';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Vis';
$string['style_dlg:block_letterspacing'] = 'Afstand mellem bogstaver';
$string['style_dlg:block_tab'] = 'Blok';
$string['style_dlg:block_text_align'] = 'Tekstjustering';
$string['style_dlg:block_text_indent'] = 'Tekstindrykning';
$string['style_dlg:block_vertical_alignment'] = 'Lodret justering';
$string['style_dlg:block_whitespace'] = 'Mellemrum';
$string['style_dlg:block_wordspacing'] = 'Afstand mellem ord';
$string['style_dlg:border'] = 'Ramme';
$string['style_dlg:border_tab'] = 'Ramme';
$string['style_dlg:bottom'] = 'Bund';
$string['style_dlg:box'] = 'Boks';
$string['style_dlg:box_clear'] = 'Ryd';
$string['style_dlg:box_float'] = 'Flydende';
$string['style_dlg:box_height'] = 'Højde';
$string['style_dlg:box_tab'] = 'Boks';
$string['style_dlg:box_width'] = 'Bredde';
$string['style_dlg:bullet_image'] = 'Punktopstillings-billede';
$string['style_dlg:clip'] = 'Klip';
$string['style_dlg:color'] = 'Farve';
$string['style_dlg:height'] = 'Højde';
$string['style_dlg:left'] = 'Venstre';
$string['style_dlg:list'] = 'Liste';
$string['style_dlg:list_tab'] = 'Liste';
$string['style_dlg:list_type'] = 'Type';
$string['style_dlg:margin'] = 'Margin';
$string['style_dlg:overflow'] = 'Overløb';
$string['style_dlg:padding'] = 'Afstand til indhold';
$string['style_dlg:placement'] = 'Placering';
$string['style_dlg:position'] = 'Position';
$string['style_dlg:positioning_tab'] = 'Positionering';
$string['style_dlg:positioning_type'] = 'Type';
$string['style_dlg:right'] = 'Højre';
$string['style_dlg:same'] = 'Ens for alle';
$string['style_dlg:style'] = 'Stil';
$string['style_dlg:text'] = 'Tekst';
$string['style_dlg:text_blink'] = 'Blink';
$string['style_dlg:text_case'] = 'Versaltilstand';
$string['style_dlg:text_color'] = 'Farve';
$string['style_dlg:text_decoration'] = 'Dekoration';
$string['style_dlg:text_font'] = 'Skrifttype';
$string['style_dlg:text_lineheight'] = 'Linjehøjde';
$string['style_dlg:text_none'] = 'Ingen';
$string['style_dlg:text_overline'] = 'Overstreget';
$string['style_dlg:text_props'] = 'Tekst';
$string['style_dlg:text_size'] = 'Størrelse';
$string['style_dlg:text_striketrough'] = 'Gennemstreget';
$string['style_dlg:text_style'] = 'Stil';
$string['style_dlg:text_tab'] = 'Tekst';
$string['style_dlg:text_underline'] = 'Understreget';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'Vægt';
$string['style_dlg:title'] = 'Rediger CSS';
$string['style_dlg:toggle_insert_span'] = 'Indsæt "span" ved valg';
$string['style_dlg:top'] = 'Top';
$string['style_dlg:visibility'] = 'Synlighed';
$string['style_dlg:width'] = 'Bredde';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Plugin';
$string['subplugintype_tinymce_plural'] = 'Plugins';
$string['table:cell'] = 'Celle';
$string['table:cell_desc'] = 'Celleegenskaber';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Kolonne';
$string['table:col_after_desc'] = 'Indsæt kolonne efter';
$string['table:col_before_desc'] = 'Indsæt kolonne før';
$string['table:copy_row_desc'] = 'Kopier række';
$string['table:cut_row_desc'] = 'Klip række';
$string['table:del'] = 'Slet tabel';
$string['table:delete_col_desc'] = 'Slet kolonne';
$string['table:delete_row_desc'] = 'Slet række';
$string['table:desc'] = 'Indsæt/rediger tabel';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Flet celler';
$string['table:paste_row_after_desc'] = 'Indsæt række under';
$string['table:paste_row_before_desc'] = 'Indsæt række over';
$string['table:props_desc'] = 'Tabelegenskaber';
$string['table:row'] = 'Række';
$string['table:row_after_desc'] = 'Indsæt række under';
$string['table:row_before_desc'] = 'Indsæt række over';
$string['table:row_desc'] = 'Rækkeegenskaber';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Opdel flettede celler';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Avancerede egenskaber';
$string['table_dlg:advanced_tab'] = 'Avanceret';
$string['table_dlg:align'] = 'Justering';
$string['table_dlg:align_bottom'] = 'Bund';
$string['table_dlg:align_default'] = 'Standard';
$string['table_dlg:align_left'] = 'Venstre';
$string['table_dlg:align_middle'] = 'Centreret';
$string['table_dlg:align_right'] = 'Højre';
$string['table_dlg:align_top'] = 'Top';
$string['table_dlg:bgcolor'] = 'Baggrundsfarve';
$string['table_dlg:bgimage'] = 'Baggrundsbillede';
$string['table_dlg:border'] = 'Ramme';
$string['table_dlg:bordercolor'] = 'Rammefarve';
$string['table_dlg:caption'] = 'Tabeloverskrift';
$string['table_dlg:cell_all'] = 'Opdater alle celler i tabellen';
$string['table_dlg:cell_cell'] = 'Opdater aktuelle celle';
$string['table_dlg:cell_col'] = 'Opdater alle celler i kolonnen';
$string['table_dlg:cell_limit'] = 'Du har overskredet antallet af tilladte celler på {$cells}.';
$string['table_dlg:cell_row'] = 'Opdater alle celler i rækken';
$string['table_dlg:cell_title'] = 'Celleegenskaber';
$string['table_dlg:cell_type'] = 'Celletype';
$string['table_dlg:cellpadding'] = 'Afstand til celleindhold';
$string['table_dlg:cellspacing'] = 'Afstand mellem celler';
$string['table_dlg:col_limit'] = 'Du har overskredet antallet af tilladte kolonner på {$cols}.';
$string['table_dlg:colgroup'] = 'Kolonnegruppe';
$string['table_dlg:cols'] = 'Kolonner';
$string['table_dlg:frame'] = 'Ramme';
$string['table_dlg:frame_all'] = 'alle';
$string['table_dlg:frame_cols'] = 'kolonner';
$string['table_dlg:frame_groups'] = 'grupper';
$string['table_dlg:frame_none'] = 'ingen';
$string['table_dlg:frame_rows'] = 'rækker';
$string['table_dlg:general_props'] = 'Generelle egenskaber';
$string['table_dlg:general_tab'] = 'Generelt';
$string['table_dlg:height'] = 'Højde';
$string['table_dlg:id'] = 'Id';
$string['table_dlg:langcode'] = 'Sprogkode';
$string['table_dlg:langdir'] = 'Sprogretning';
$string['table_dlg:ltr'] = 'Venstre mod højre';
$string['table_dlg:merge_cells_title'] = 'Flet celler';
$string['table_dlg:mime'] = 'Destinations-MIME-type';
$string['table_dlg:missing_scope'] = 'Er du sikker på, du vil fortsætte uden at angive område på denne overskriftscelle? Uden områdeangivelse vil det være svært for f.eks. blinde at læse og forstå indholdet i tabellen.';
$string['table_dlg:row_all'] = 'Opdater alle rækker';
$string['table_dlg:row_even'] = 'Opdater lige rækker';
$string['table_dlg:row_limit'] = 'Du har overskredet antallet af tilladte rækker på {$rows}.';
$string['table_dlg:row_odd'] = 'Opdater ulige rækker';
$string['table_dlg:row_row'] = 'Opdater aktuelle celle';
$string['table_dlg:row_title'] = 'Rækkeegenskaber';
$string['table_dlg:rowgroup'] = 'Rækkegruppe';
$string['table_dlg:rows'] = 'Rækker';
$string['table_dlg:rowtype'] = 'Rækketype';
$string['table_dlg:rtl'] = 'Højre mod venstre';
$string['table_dlg:rules'] = 'Regler';
$string['table_dlg:rules_above'] = 'over';
$string['table_dlg:rules_below'] = 'under';
$string['table_dlg:rules_border'] = 'Ramme';
$string['table_dlg:rules_box'] = 'boks';
$string['table_dlg:rules_hsides'] = '<abbr title="horisontale sider">hsides</abbr>';
$string['table_dlg:rules_lhs'] = '<abbr title="venstre-vandrette sider">lhs</abbr>';
$string['table_dlg:rules_rhs'] = '<abbr title="højre-vandrette sider">rhs</abbr>';
$string['table_dlg:rules_void'] = 'ingen';
$string['table_dlg:rules_vsides'] = '<abbr title="lodrette sider">vsides</abbr>';
$string['table_dlg:scope'] = 'Område';
$string['table_dlg:style'] = 'Style';
$string['table_dlg:summary'] = 'Beskrivelse';
$string['table_dlg:tbody'] = 'Tabelkrop';
$string['table_dlg:td'] = 'Data';
$string['table_dlg:tfoot'] = 'Tabelfod';
$string['table_dlg:th'] = 'Hoved';
$string['table_dlg:thead'] = 'Tabelhoved';
$string['table_dlg:title'] = 'Indsæt/rediger tabel';
$string['table_dlg:valign'] = 'Lodret justering';
$string['table_dlg:width'] = 'Bredde';
$string['template:desc'] = 'Indsæt prædefineret skabelonindhold';
$string['template_dlg:cdate_format'] = '%d-%m-%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'søndag,mandag,tirsdag,onsdag,torsdag,fredag,lørdag,søndag';
$string['template_dlg:day_short'] = 'søn,man,tir,ons,tor,fre,lør,søn';
$string['template_dlg:desc'] = 'Indsæt prædefineret skabelonindhold';
$string['template_dlg:desc_label'] = 'Beskrivelse';
$string['template_dlg:label'] = 'Skabelon';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'januar,februar,marts,april,maj,juni,juli,august,september,oktober,november,december';
$string['template_dlg:months_short'] = 'jan,feb,mar,apr,maj,jun,jul,aug,sep,okt,nov,dec';
$string['template_dlg:preview'] = 'Forhåndsvisning';
$string['template_dlg:select'] = 'Vælg en skabelon';
$string['template_dlg:title'] = 'Skabeloner';
$string['template_dlg:warning'] = 'Advarsel: Opdatering af en skabelon med en anden kan betyde datatab.';
$string['visualblocks:desc'] = 'Vis/skjul blokelementer';
$string['visualchars:desc'] = 'Vis/skjul kontroltegn.';
$string['wordcount:words'] = 'Ord:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Forkortelse';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Akronym';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Indsæt/rediger attributter';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citat';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Sletning';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Indsættelse';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attributter';
$string['xhtmlxtras_dlg:attribs_title'] = 'Indsæt/rediger attributter';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attributter';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Hændelser';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Adgangsnøgle';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citat';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klasse';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Dato/tid';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'Id';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Sprog';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Tekstretning';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tab-indeks';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Titel';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Venstre mod højre';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Højre mod venstre';
$string['xhtmlxtras_dlg:events_tab'] = 'Hændelser';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Element-attributter';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Element-hændelser';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Generelle indstillinger';
$string['xhtmlxtras_dlg:general_tab'] = 'Generelt';
$string['xhtmlxtras_dlg:insert_date'] = 'Indsæt nuværende dato/tid';
$string['xhtmlxtras_dlg:option_ltr'] = 'Venstre mod højre';
$string['xhtmlxtras_dlg:option_rtl'] = 'Højre mod venstre';
$string['xhtmlxtras_dlg:remove'] = 'Slet';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Afkortet element';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Akronym-element';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Citationselement';
$string['xhtmlxtras_dlg:title_del_element'] = '';
$string['xhtmlxtras_dlg:title_ins_element'] = '';
