<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fordson', language 'fr', version '3.11'.
 *
 * @package     theme_fordson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconsize'] = 'Taille de l\'icône de l\'activité';
$string['activityiconsize_desc'] = 'Ajuster la taille des icônes d\'activités utilisées dans les cours';
$string['activitylinkstitle'] = 'Activités';
$string['activitylinkstitle_desc'] = 'Voir toutes les activités du cours';
$string['activitymenu'] = 'Afficher les activités du cours dans le menu gestion du cours';
$string['activitymenu_desc'] = 'Affiche la liste des activités du cours dans le tiroir de navigation du cours. Cette option affiche la liste de toutes les activités du cours pour les étudiants et les enseignants.';
$string['advancedsettings'] = 'Paramètres avancés';
$string['alert'] = 'Alerte de la page d\'accueil';
$string['alert_desc'] = 'Ceci est un message d\'alerte qui apparaîtra sur la page d\'accueil.';
$string['backgroundimage'] = 'Image de fond par défaut de la page';
$string['backgroundimage_desc'] = 'Image de fond pour les pages';
$string['backtotop'] = 'Retour en haut de page et Scrollspy';
$string['badges'] = 'Badges';
$string['badges_desc'] = 'Récompensez vos étudiants';
$string['blockdisplay'] = 'Options d\'emplacement des blocs';
$string['blockdisplay_desc'] = 'Choisissez où vous souhaitez voir apparaître les blocs sur la page d\'accueil et dans les cours. Fordson ajoute une zone de blocs escamotable sur 3 colonnes. Celle-ci peut être masquée par l\'utilisateur. Choisissez l\'option « Colonne unique (Boost) » pour n\'avoir qu\'une seule colonne de blocs sur la droite. L\'option « Colonne unique (Boost) » replace également le bouton « Ajouter un bloc » dans le tiroir de navigation (colonne de gauche). Nous vous recommandons de choisir l\'option « Colonne unique (Boost) » si vous utilisez d\'autres options « Boost » dans les paramètres ci-dessus.';
$string['blockdisplay_off'] = 'Colonne unique (Boost)';
$string['blockdisplay_on'] = 'Affichage Fordson en trois colonnes';
$string['blockwidthfordson'] = 'Largeur du bloc de colonne';
$string['blockwidthfordson_desc'] = 'Ajuster la largeur du bloc de colonne.';
$string['blog'] = 'URL du blog';
$string['blogdesc'] = 'Saisir l\'URL du blog de votre institution (ex : http://dearbornschools.org)';
$string['bodybackground'] = 'Couleur d\'arrière-plan du corps';
$string['bodybackground_desc'] = 'Couleur principale de l\'arrière-plan.';
$string['brandColour'] = 'Couleur principale';
$string['brandColour_desc'] = 'Il s\'agit de la couleur principale de votre charte graphique.';
$string['branddanger'] = 'Couleur « danger »';
$string['branddanger_desc'] = 'Il s\'agit de la couleur utilisée par les panneaux et alertes marqués « danger ». Voir par exemple la classe CSS Bootstrap <i>alert-danger</i>';
$string['brandemail'] = 'Courriel de l\'organisation';
$string['brandemaildesc'] = 'Adresse de courriel de l\'organisation apparaissant dans le pied de page.';
$string['brandinfo'] = 'Couleur « Info »';
$string['brandinfo_desc'] = 'Il s\'agit de la couleur utilisée par les panneaux et alertes d\'information. Voir par exemple la classe CSS Bootstrap <i>alert-info</i>';
$string['brandorganization'] = 'Nom de l\'organisation';
$string['brandorganizationdesc'] = 'Nom de l\'organisation apparaissant dans le pied de page.';
$string['brandphone'] = 'Numéro de téléphone de l\'organisation';
$string['brandphonedesc'] = 'Numéro de téléphone apparaissant dans le pied de page.';
$string['brandprimary'] = 'Couleur principale';
$string['brandprimary_desc'] = 'Il s\'agit de la couleur principale de votre charte graphique.';
$string['brandsuccess'] = 'Couleur « succès »';
$string['brandsuccess_desc'] = 'Il s\'agit de la couleur utilisée par les panneaux, alertes et boutons pour marquer le succès et la réussite d\'une action. Voir par exemple la classe CSS Bootstrap <i>alert-success</i>';
$string['brandwarning'] = 'Couleur « attention »';
$string['brandwarning_desc'] = 'Il s\'agit de la couleur utilisée par les panneaux et alertes marqués « attention (warning) ». Voir par exemple la classe CSS Bootstrap <i>alert-warning</i>';
$string['brandwebsite'] = 'Site de votre organisation';
$string['brandwebsitedesc'] = 'Adresse du site web de votre organisation qui apparaîtra dans le pied de page.';
$string['breadcrumbbkg'] = 'Couleur de fond de la piste de navigation';
$string['breadcrumbbkg_desc'] = 'Couleur de fond de la piste de navigation.';
$string['cardbkg'] = 'Couleur d\'arrière-plan du contenu';
$string['cardbkg_desc'] = 'Couleur de fond du contenu pour les cours et les blocs';
$string['catsicon'] = 'Icône de catégorie';
$string['catsicon_desc'] = 'Choisir une icône qui représente les catégories de cours.';
$string['choosereadme'] = 'Fordson apporte une expérience visuelle unique au thème par défaut (Boost) grâce à des fonctionnalités de personnalisation telles que les sélecteurs de couleurs et une expérience améliorée de la page d\'accueil.';
$string['collapsibletopics'] = 'Format de cours sections repliables';
$string['collapsibletopics_desc'] = 'Si vous installez le format de cours sections repliables (<a href="https://moodle.org/plugins/format_collapsibletopics">format_collapsibletopics</a>) le thème Fordson peut fournir une vue améliorée du format du cours et un style spécial qui s’intègre mieux avec l’aspect et l\'état d\'esprit de Fordson. Un soin et une attention particulière ont été développés pour offrir une expérience utilisateur plus fluide pour les utilisateurs de tous âges et de toutes les compétences.';
$string['colours_desc'] = 'Le sélecteur de couleurs permet de personnaliser l\'apparence et le rendu des éléments principaux sur la page. Si vous utilisez un pré-réglage différent de celui par défaut, il vous faudra enlever toute couleur personnalisée en dessous pour un meilleur résultat puisque celle-ci remplacera le pré-réglage par des résultats non-désirés. Généralement, le pré-réglage aura des couleurs par défaut que vous souhaiterez voir avant toute modification ici.';
$string['colours_headingsub'] = 'Paramètres de couleur';
$string['colours_settings'] = 'Couleurs';
$string['configtitle'] = 'Fordson';
$string['contentsettings'] = 'Zones de contenu';
$string['courseactivities'] = 'Activités de cours';
$string['courseblockpanelbtn'] = 'Blocs de cours';
$string['courseblockpanelbtnclose'] = 'Fermer';
$string['courseboxheight'] = 'Hauteur de la tuile de cours';
$string['courseboxheight_desc'] = 'Contrôler la hauteur de la tuile du cours sur la page d\'accueil et les catégories de cours.';
$string['courseeditingcog'] = 'Afficher le menu des paramètres par défaut du cours';
$string['courseeditingcog_desc'] = 'Si le panneau de gestion de cours est utilisé, il est par défaut caché. En cochant cette case, vous pouvez rendre visible le menu par défaut ainsi que le panneau de gestion de cours des enseignants. Cette option est idéale si vous utilisez un plugin tierce utilisant le menu du cours afin d\'accéder aux paramètres.';
$string['coursehome'] = 'Accueil';
$string['courseinfo'] = 'Description du cours';
$string['coursemanage'] = 'Paramètres du cours';
$string['coursemanage_desc'] = 'Gérer tout votre cours';
$string['coursemanagementbutton'] = 'Gestion du cours';
$string['coursemanagementinfo'] = 'Menu du panneau d\'administration du cours';
$string['coursemanagementinfodesc'] = 'Fordson fournit un panneau d\'administration de cours unique et organisé auquel les enseignants peuvent accéder de n\'importe où dans un cours pour accéder à leurs liens de gestion de cours. Les étudiants peuvent également accéder à leur tableau de bord de qui comprend des informations pertinentes pour le cours. Il est fortement recommandé de garder cette option activée.';
$string['coursemanagementtextbox'] = 'Message de gestion de cours';
$string['coursemanagementtextbox_desc'] = 'Ajouter un message pour les enseignants dans le panneau de gestion du cours, dans toutes les pages de cours';
$string['coursemanagementtoggle'] = 'Afficher les panneaux de gestion des cours des étudiants et des enseignants';
$string['coursemanagementtoggle_desc'] = 'Cette option affiche un panneau organisé pour les enseignants qui fournit un tableau de bord de tous les liens dont ils ont besoin pour gérer leur cours et leurs utilisateurs. Un panneau de vue d\'ensemble s\'affichera également pour les étudiants, comprenant leurs notes, l\'achèvement du cours et d\'autres outils du cours.';
$string['coursestaff'] = 'Enseignants du cours';
$string['coursestyle1'] = 'Style de tuile n°1';
$string['coursestyle10'] = 'Affichage Moodle par défaut';
$string['coursestyle2'] = 'Style de tuile n°2';
$string['coursestyle3'] = 'Style de tuile n°3';
$string['coursestyle4'] = 'Style de tuile avec résumé du cours';
$string['coursestyle5'] = 'Style horizontal 1';
$string['coursestyle6'] = 'Horizontal avec image en arrière plan et détails';
$string['coursestyle7'] = 'Horizontal avec image en arrière plan (titre et enseignant uniquement)';
$string['coursestyle8'] = 'Horizontal sur 2 colonnes';
$string['coursestyle9'] = 'Entreprise - minimal avec barre de progression';
$string['coursetileinfo'] = 'Options d\'affichage du cours';
$string['coursetileinfodesc'] = 'Ces paramètres vous permettent de personnaliser la façon dont les cours seront affichés sur la page d\'accueil ainsi que les catégories de cours.';
$string['coursetilestyle'] = 'Style de la vignette d\'affichage du cours';
$string['coursetilestyle_desc'] = 'Lorsque vous consultez les catégories de cours, vous pouvez choisir parmi les styles suivants pour afficher les cours. <a href="https://goo.gl/fMXzSo" target="_new">Instructions for Fordson </a>';
$string['createinfo'] = 'Bouton spécial créateur de cours';
$string['createinfodesc'] = 'Ce bouton apparait sur la page d\'accueil lorsqu\'un utilisateur peut créer de nouveaux cours. Les utilisateurs ayant le rôle de « créateur de cours » à ce niveau du site verront ce bouton.';
$string['currentinparentheses'] = '(actuel)';
$string['customloginheading'] = 'Page de connexion personnalisée';
$string['customlogininfo'] = 'Paramètres de la page de connexion personnalisée';
$string['customlogininfo_desc'] = 'Cela vous permet de créer une page de connexion personnalisée. Les autres paramètres du thème qui s\'afficheront sur la page de connexion sont les suivants :<br>
<b>* Administration du site > Sécurité > Règles du site > Imposer la connexion = Assurez-vous que cette case est cochée afin que les utilisateurs soient redirigés vers votre page de connexion personnalisée. <br>
* Administration du site > Présentation > Logos > Logo = Téléchargez une image ici et elle apparaîtra au-dessus du formulaire de connexion.<br>
* Fordson > Paramètres d\'image personnalisée > L\'image de connexion par défaut peut être utilisée pour modifier l\'image d\'arrière-plan de la page de connexion. <br>
* Fordson > Zones de contenu > La page d\'accueil peut être utilisée pour sélectionner une option en haut de la page. </b>';
$string['dashactivityoverview'] = 'APERÇU DES ACTIVITÉS';
$string['displaybottom'] = 'Afficher en bas de la page';
$string['displaymycourses'] = 'Afficher les cours inscrits';
$string['displaymycoursesdesc'] = 'Afficher les cours inscrits pour les utilisateurs dans la barre de navigation supérieure.';
$string['displaythiscourse'] = 'Afficher le menu de ce cours';
$string['displaythiscoursedesc'] = 'Afficher Saut à la section dans le menu du cours pour les utilisateurs dans la barre de navigation supérieure. Ceci contient des éléments de menu précédemment trouvés dans le tiroir de navigation.';
$string['displaytop'] = 'Afficher en haut de la page';
$string['drawerbkg'] = 'Couleur de fond du tiroir latéral';
$string['drawerbkg_desc'] = 'Il s\'agit de la couleur de fond utilisée par le menu glissant sur le coté gauche de la page.';
$string['easyenrollmentintegration'] = 'Plugin Inscriptions faciles';
$string['easyenrollmentintegration_desc'] = 'Le plugin Inscriptions faciles (<a href="https://moodle.org/plugins/enrol_easy"> Easy Enrollment Plugin</a>) permet aux étudiants de s’inscrire aux cours directement depuis la page d’accueil de Moodle. Le plugin d’inscription utilise un code à 6 chiffres ou un QR code auto-généré avec support webcam pour inscrire les étudiants. L\'étudiant entre le code ou scanne le QR code et est immédiatement inscrit au cours ou au groupe prévu dans le cours. Ce plugin s’active automatiquement une fois que vous avez installé l\'inscription facile et que vous l\'avez activé dans Administration du site. Il n’est activé que si le plugin est installé et correctement configuré.';
$string['editoff'] = 'Quitter le mode édition';
$string['editon'] = 'Activer le mode édition';
$string['enablecategoryicon'] = 'Icônes d\'affichage de catégorie';
$string['enablecategoryicon_desc'] = 'Lorsque cette case est cochée, les catégories de cours s\'affichent sous forme d\'icônes';
$string['enhancedmydashboard'] = 'Tableau de bord amélioré';
$string['enhancedmydashboard_desc'] = 'En activant cette option, vous rajouterez au tableau de bord toutes les fonctionnalités Fordson telles que le formulaire d\'inscription rapide, la possibilité de masquer les blocs, les icônes de navigation, un texte personnalisé, un carrousel d\'images, et bien plus.';
$string['enrollcoursecard'] = 'Accéder';
$string['facebook'] = 'URL Facebook';
$string['facebookdesc'] = 'Saisir l\'URL de votre page Facebook (ex : http://www.facebook.com/).';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Changez le favicon pour Fordson. Les images avec un fond transparent et une hauteur de 32px fonctionneront mieux. Types autorisés : PNG, JPG, ICO';
$string['feature1info'] = 'Élément n°1';
$string['feature2info'] = 'Élément n°2';
$string['feature3info'] = 'Élément n°3';
$string['featureimage'] = 'Image de l\'élément';
$string['featureimage_desc'] = 'Cette image apparaîtra à côté du texte affiché dans une rangée.';
$string['featureinfo_desc'] = 'Un élément consiste en une image et un texte qui apparaîtront en colonne sur la page de connexion personnalisée. Image et texte sont tous deux nécessaires pour afficher l\'élément.';
$string['featuretext'] = 'Texte de l\'élément';
$string['featuretext_desc'] = 'Ce texte apparaîtra dans une colonne à coté de l\'image de l\'élément. Choisir Heading4 pour utiliser un titre spécial à l\'intérieur de la boite de texte. Dans l\'éditeur Atto, H4 correspond à Heading Medium.';
$string['flickr'] = 'URL Flickr';
$string['flickrdesc'] = 'Saisir l\'URL de votre page Flickr (ex : http://www.flickr.com/).';
$string['footerbkg'] = 'Couleur d\'arrière plan pour le pied de page';
$string['footerbkg_desc'] = 'Couleur d\'arrière plan pour la partie inférieure de la page';
$string['footerdesc'] = 'Les options ci-dessous permettent de personnaliser l\'identité de votre marque/organisation dans le pied de page du thème.';
$string['footerheading'] = 'Pied de page';
$string['footerheadingsocial'] = 'Icônes sociales';
$string['footerheadingsub'] = 'Personnaliser le pied de page de la page d\'accueil';
$string['footnote'] = 'Note de bas de page';
$string['footnotedesc'] = 'Éditeur de contenu de note de bas de page pour le pied de page principal';
$string['fploginform'] = 'Couleur du formulaire d\'enregistrement';
$string['fploginform_desc'] = 'Couleur d\'arrière-plan du formulaire de connexion sur la page d\'accueil personnalisée.';
$string['fpsignup'] = 'Se connecter';
$string['fptextbox'] = 'Texte d\'accueil pour les utilisateurs authentifiés';
$string['fptextbox_desc'] = 'Ce champs apparaîtra sur la page d\'accueil après authentification de l\'utilisateur. C\'est l\'endroit idéal pour afficher un message de bienvenue ou pour fournir des instructions aux apprenants.';
$string['fptextboxlogout'] = 'Texte d\'accueil pour les visiteurs';
$string['fptextboxlogout_desc'] = 'Ce champs apparaîtra sur la page d\'accueil pour les visiteurs anonymes. C\'est l\'endroit idéal pour afficher un message de bienvenue ou le lien vers la page de connexion.';
$string['frontpagemycoursessorting'] = 'Bloc « Mes cours » trié par dernier accès';
$string['frontpagemycoursessorting_desc'] = 'Si ce réglage est activé, les cours du bloc « Mes cours » (cours inscrits) sont triés par dernier accès. Ce réglage a priorité sur le paramètre « Trier mes cours » dans Navigation. Si le réglage n\'est pas activé, le bloc « Mes cours » s\'affiche normalement sur la page d\'accueil. Ce réglage n\'a pas d\'effet sur l\'affichage du tableau de bord et de ses blocs.';
$string['generalcontentinfo'] = 'Paramètres d\'affichage du contenu général';
$string['generalcontentinfodesc'] = 'Les options ci-dessous vous permettent de personnaliser la façon dont le contenu est affiché et d\'activer des fonctionnalités supplémentaires pour Fordson.';
$string['generalsettings'] = 'Paramètres généraux';
$string['googleplus'] = 'URL Google+';
$string['googleplusdesc'] = 'Saisir l\'URL de votre profil Google+ (ex : https://google.com/).';
$string['gutterwidth'] = 'Espacement du contenu';
$string['gutterwidth_desc'] = 'Ce paramètre contrôle la quantité d\'espace utilisée à gauche et à droite du contenu principal.';
$string['headerdefaultimage'] = 'Image par défaut de l\'en-tête';
$string['headerdefaultimage_desc'] = 'Image par défaut pour l\'en-tête du cours et des autres pages';
$string['headerimagepadding'] = 'Hauteur de l\'image d\'en-tête';
$string['headerimagepadding_desc'] = 'Contrôler l\'espacement et la hauteur de l\'image d\'en-tête pour les cours.';
$string['headerlogo'] = 'Logo de l\'en-tête';
$string['headerlogo_desc'] = 'Ce logo sera affiché en haut de la page dans la zone d\'en-tête. Il utilise le redimensionnement d\'image adaptatif de bootstrap.';
$string['homemyclasses'] = 'Classe - Accueil';
$string['homemycomp'] = 'Compétences - Accueil';
$string['homemycourses'] = 'Accueil du cours';
$string['homemycred'] = 'Référence - Accueil';
$string['homemylectures'] = 'Conférence - Accueil';
$string['homemylessons'] = 'Leçon - Accueil';
$string['homemymodules'] = 'Module - Accueil';
$string['homemyplans'] = 'Plan - Accueil';
$string['homemyprofessionaldevelopment'] = 'Développement Professionnel - Accueil';
$string['homemyprograms'] = 'Programme - Accueil';
$string['homemytraining'] = 'Formation - Accueil';
$string['homemyunits'] = 'Unité - Accueil';
$string['iconnavheading'] = 'Navigation par icônes';
$string['iconnavheadingsub'] = 'Créer des boutons avec des icônes pour les utiliser sur la page d\'accueil. Les liens peuvent aller n\'importe où.';
$string['iconwidth'] = 'Largeur des icônes de la page d\'accueil';
$string['iconwidth_desc'] = 'Largeur des 8 icônes de la barre de navigation de la page d\'accueil.';
$string['iconwidthinfo'] = 'Largeur des boutons-icônes';
$string['iconwidthinfodesc'] = 'Sélectionner une largeur permettant aux liens textes de s\'adapter aux boutons-icônes de navigation';
$string['ilearnsecurebrowser'] = 'Ce test est sécurisé au moyen de iLearn Secure Browser (l\'utilisation d\'un Chromebook avec l\'application iLearn installée est requise pour effectuer ce test)';
$string['imagesettings'] = 'Paramètres d\'image personnalisés';
$string['instagram'] = 'URL Instagram';
$string['instagramdesc'] = 'Saisir l\'URL de votre page Instagram (ex : http://instagram.com/).';
$string['integrationinfo'] = 'Intégration de plugins';
$string['integrationinfo_desc'] = 'Fordson peut activer des fonctionnalités avancées et mieux s\'intégrer avec certains plugins. Les paramètres ci-dessous vous permettront d’utiliser la gestion de plugin par défaut ou activer les fonctionnalités avancées que les développeurs de Fordson ont implémentées.';
$string['integrationoff'] = 'Désactiver l\'intégration';
$string['integrationon'] = 'Activer l\'intégration';
$string['jitsibuttontext'] = 'Bouton d\'en-tête automatique pour les conférences Web Jitsi';
$string['jitsibuttontextdesc'] = 'Ajoutez le texte et le bouton sera ajouté en haut de chaque cours Moodle.  Ce bouton amènera les utilisateurs à une salle de réunion Jitsi qui utilise l\'URL à partir du nom du cours et du numéro d\'identification du cours.  Vous devez disposer d\'un serveur de conférence Web Jitsi.';
$string['jitsibuttonurl'] = 'URL du serveur Jitsi';
$string['jitsibuttonurldesc'] = 'Exemple de serveur public : https://meet.jit.si <br> NE PAS AJOUTER DE BARRE OBLIQUE A LA FIN <br> Cette URL sera utilisée pour le bouton qui sera automatiquement ajouté à chaque cours Moodle dans la zone d\'en-tête. Nous vous recommandons fortement de configurer votre propre serveur Jitsi et de forcer l\'ouverture de session à la salle de réunion Jitsi.';
$string['layoutinfo'] = 'Paramètres d\'affichage';
$string['layoutinfodesc'] = 'Gérer la disposition de la page en choisissant divers réglages.';
$string['learningcontentpadding'] = 'Espacement du contenu d\'apprentissage';
$string['learningcontentpadding_desc'] = 'Cette option contrôle l\'espacement entre le haut de la page et le contenu du cours. Généralement, vous voulez que la valeur de cette option soit inférieure à la hauteur de l\'image de l\'en-tête.';
$string['linkedin'] = 'URL LinkedIn';
$string['linkedindesc'] = 'Saisir l\'URL de votre page LinkedIn (ex : http://linkedin.com/).';
$string['loginimage'] = 'Image par défaut de connexion';
$string['loginimage_desc'] = 'Image de fond pour la page de connexion';
$string['loginnavicon1'] = 'Icône n°1';
$string['loginnavicon2'] = 'Icône n°2';
$string['loginnavicon3'] = 'Icône n°3';
$string['loginnavicon4'] = 'Icône n°4';
$string['loginnavicontext'] = 'Texte de l\'icône';
$string['loginnavicontextdesc'] = 'Texte qui apparaîtra sous l\'icône. Utiliser un texte court pour de meilleurs résultats.';
$string['loginnavicontitletext'] = 'Titre de l\'icône';
$string['loginnavicontitletextdesc'] = 'Texte à afficher comme titre, sous l\'icône.';
$string['logintopimage'] = 'Image de bannière de la page de connexion';
$string['logintopimage_desc'] = 'Cette image apparaît sur la page de connexion à droite du formulaire de connexion. C\'est idéal pour un logo ou une bannière avec un fond transparent.';
$string['marketboxbuttoncolor'] = 'Couleur de bouton des annonces';
$string['marketboxbuttoncolor_desc'] = 'Il s\'agit de la couleur utilisée pour les boutons des annonces de la page d\'accueil.';
$string['marketboxcolor'] = 'Couleur de fond des annonces';
$string['marketboxcolor_desc'] = 'Il s\'agit de la couleur du fond des annonces de la page d\'accueil.';
$string['marketboxcontentcolor'] = 'Couleur de fond du contenu des annonces';
$string['marketboxcontentcolor_desc'] = 'Il s\'agit de la couleur de fond de la zone de contenu des annonces de la page d\'accueil. Cette couleur permet de mettre le texte de l\'annonce en valeur par rapport à la couleur de fond du cadre.';
$string['marketing1'] = 'Annonce n°1';
$string['marketing2'] = 'Annonce n°2';
$string['marketing3'] = 'Annonce n°3';
$string['marketing4'] = 'Annonce n°4';
$string['marketing5'] = 'Annonce n°5';
$string['marketing6'] = 'Annonce N°6';
$string['marketing7'] = 'Annonce n°7';
$string['marketing8'] = 'Annonce n°8';
$string['marketing9'] = 'Annonce n°9';
$string['marketingbuttontext'] = 'Texte du lien';
$string['marketingbuttontextdesc'] = 'Texte à inscrire sur le bouton.';
$string['marketingbuttonurl'] = 'URL du lien';
$string['marketingbuttonurldesc'] = 'URL vers laquelle le bouton redirigera';
$string['marketingcontent'] = 'Contenu';
$string['marketingcontentdesc'] = 'Texte à afficher dans l\'annonce. Gardez ce texte court et attractif pour une meilleure accroche.';
$string['marketingdesc'] = 'Ce thème permet d\'ajouter jusqu\'à trois « annonces » marketing ou « publicitaires » sous le diaporama. Cela permet de mettre en valeur les informations principales pour vos usagers et de fournir les liens correspondants.';
$string['marketingheading'] = 'Annonces de la page d\'accueil';
$string['marketingheadingsub'] = 'Ajoute 3 emplacements à la page d\'accueil permettant d\'ajouter de l\'information et des liens.';
$string['marketingheight'] = 'Hauteur de l\'image des annonces';
$string['marketingheightdesc'] = 'Si vous souhaitez utiliser des images dans les annonces de la page d\'accueil vous pouvez fixer leur hauteur grâce à cette option.';
$string['marketingicon'] = 'Icône du lien';
$string['marketingicondesc'] = 'Nom de l\'icône que vous souhaitez utiliser pour les boutons des annonces de la page d\'accueil. Vous trouverez la liste des icônes disponibles <a href="https://fontawesome.com/v4/cheatsheet/" target="_new">ici</a>. Il vous suffit de saisir le texte qui suit « fa- ». Par exemple, pour avoir « fa-star », vous choisissez « star ».';
$string['marketingimage'] = 'Image';
$string['marketingimage_desc'] = 'Cette option permet l\'affichage d\'une image dans l\'annonce de la page d\'accueil';
$string['marketinginfodesc'] = 'Paramétrez les options de vos annonces de page d\'accueil. Vous devez avoir un titre pour que l\'annonce apparaisse. Les titres activent/désactivent les différentes annonces de la page d\'accueil.';
$string['marketingstyle'] = 'Sélecteur de style de la zone d\'annonce de la page d\'accueil';
$string['marketingstyle1'] = 'Surlignage de la barre supérieure';
$string['marketingstyle2'] = 'Pense-bête';
$string['marketingstyle3'] = 'Simple';
$string['marketingstyle4'] = 'Ombre encadrée';
$string['marketingstyle_desc'] = 'Choisissez parmi les styles marketing suivants. Ceux-ci changeront l’apparence et le style des boîtes d\'annonce sur la page d’accueil du site.';
$string['marketingtitle'] = 'Titre';
$string['marketingtitledesc'] = 'Titre de cette annonce de la page d\'accueil. Le titre doit être présent pour que l\'annonce s\'affiche sur la page d\'accueil.';
$string['marketingurltarget'] = 'Cible du lien';
$string['marketingurltargetdesc'] = 'Choisir comment ouvrir le lien';
$string['marketingurltargetnew'] = 'Nouvelle page';
$string['marketingurltargetparent'] = 'Cadre parent';
$string['marketingurltargetself'] = 'Page actuelle';
$string['markettextbg'] = 'Couleur de fond du texte des annonces de la page d\'accueil';
$string['markettextbg_desc'] = 'Il s\'agit de la couleur de fond de la zone de texte des annonces de la page d\'accueil.';
$string['menusettings'] = 'Paramètres du menu';
$string['myclasses'] = 'Mes classes';
$string['mycomp'] = 'Mes compétences';
$string['mycourses'] = 'Mes cours';
$string['mycoursesinfo'] = 'Liste dynamique des cours de l\'utilisateur et des menus de navigation de cours';
$string['mycoursesinfodesc'] = 'Affiche une liste dynamique des cours de l\'utilisateur dans la barre de navigation supérieure. Cela contrôlera également la liste déroulante de navigation du cours pour chaque cours individuel.';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Modifie le nom du lien « Mes cours » dans le menu déroulant.';
$string['mycred'] = 'Mes références';
$string['mygradestext'] = 'Mes notes';
$string['mylectures'] = 'Mes conférences';
$string['mylessons'] = 'Mes leçons';
$string['mymodules'] = 'Mes modules';
$string['myplans'] = 'Mes plans';
$string['myprofessionaldevelopment'] = 'Mon développement professionnel';
$string['myprograms'] = 'Mes programmes';
$string['myprogresspercentage'] = '% Complet';
$string['myprogresstext'] = 'Ma progression';
$string['mytraining'] = 'Ma formation';
$string['myunits'] = 'Mes unités';
$string['navbarcolorswitch'] = 'Couleur de la barre de navigation';
$string['navbarcolorswitch_desc'] = 'Cette fonctionnalité modifie la couleur de la barre de navigation en fonction du rôle de l\'utilisateur. Un étudiant verra une couleur et un enseignant verra une autre couleur. Cela est utile lorsqu\'un enseignant change de rôle et permet de faire la distinction entre une vue d\'élève et une vue d\'enseignant.';
$string['navbarcolorswitch_off'] = 'Ne pas changer la couleur de la barre de navigation en fonction du rôle.';
$string['navbarcolorswitch_on'] = 'Changer la couleur de la barre de navigation en fonction du rôle.';
$string['navdrawerbtn'] = 'Navigation';
$string['navicon'] = 'Icône';
$string['navicon1'] = 'Icône de page d\'accueil n°1';
$string['navicon2'] = 'Icône de page d\'accueil n°2';
$string['navicon3'] = 'Icône de page d\'accueil n°3';
$string['navicon4'] = 'Icône de page d\'accueil n°4';
$string['navicon5'] = 'Icône de page d\'accueil n°5';
$string['navicon6'] = 'Icône de page d\'accueil n°6';
$string['navicon7'] = 'Icône de page d\'accueil n°7';
$string['navicon8'] = 'Icône de page d\'accueil n°8';
$string['naviconbutton1textdefault'] = 'Tableau de bord';
$string['naviconbutton2textdefault'] = 'Calendrier';
$string['naviconbutton3textdefault'] = 'Badges';
$string['naviconbutton4textdefault'] = 'Tous les cours';
$string['naviconbuttoncreatetextdefault'] = 'Créer un cours';
$string['naviconbuttontext'] = 'Texte du lien';
$string['naviconbuttontextdesc'] = 'Texte à afficher sous l’icône.';
$string['naviconbuttonurl'] = 'URL du lien';
$string['naviconbuttonurldesc'] = 'URL vers laquelle le bouton dirige. Vous pouvez créer un lien vers n\'importe où, même vers un site web extérieur, il vous suffit de saisir l\'URL correcte. Si votre site Moodle se situe dans un sous-dossier, l\'URL par défaut ne fonctionnera pas. Veuillez ajuster l\'URL pour prendre en compte le sous-dossier. Exemple : si « moodle » est votre sous-dossier, votre URL devra être changée en /moodle/my/';
$string['navicondesc'] = 'Nom de l\'icône que vous souhaitez utiliser. La liste est <a href="https://fontawesome.com/v4/cheatsheet/" target="_new">ici</a>. Il suffit d\'écrire ce qui est après « fa- », ex : « star »';
$string['naviconslidedesc'] = 'Icône-texte suggérée : arrow-circle-down, ou choisir dans la liste <a href="https://fontawesome.com/v4/cheatsheet/" target="_new">ici</a>. Il suffit d\'écrire ce qui est après « fa- », ex : « star ».';
$string['noenrolments'] = 'Vous n\'avez actuellement aucune inscription';
$string['nomycourses'] = 'Vous n\'êtes inscrit à aucun cours.';
$string['pagelayout'] = 'Disposition générale';
$string['pagelayout1'] = 'Disposition Boost par défaut';
$string['pagelayout2'] = 'Largeur maximale, image d\'en-tête au-dessus du titre';
$string['pagelayout3'] = 'Contenu centré, la boîte du titre chevauche l\'image d\'en-tête';
$string['pagelayout4'] = 'Contenu centré, image en arrière plan sur toute la page';
$string['pagelayout5'] = 'Disposition Boost par défaut, image en arrière plan de la boîte de titre';
$string['pagelayout_desc'] = 'Sélectionner une des dispositions suivantes. Certaines dispositions de page nécessitent des ajustements supplémentaires sur la page des ajustements des préréglages. Considérer avec soin : l\'espacement du contenu d\'apprentissage, la hauteur de l\'image d\'en-tête et l\'espacement du contenu, qui permettent l\'ajustement du placement de l\'image d\'en-tête et les espaces à gauche et à droite du contenu d\'apprentissage principal. Voyez la <a href="https://goo.gl/fMXzSo" target="_new">documentation du thème Fordson</a>.';
$string['pinterest'] = 'URL Pinterest';
$string['pinterestdesc'] = 'Saisir l\'URL de votre page Pinterest (i.e. http://pinterest.com/).';
$string['pluginname'] = 'Fordson';
$string['preset'] = 'Préréglages du thème';
$string['preset_desc'] = 'Choisir un pré-réglage pour changer significativement l\'apparence du thème. <a href="https://goo.gl/fMXzSo" target="_new">Instructions for Fordson </a>';
$string['presetadjustmentsettings'] = 'Ajustement des préréglages';
$string['presetfiles'] = 'Fichiers supplémentaires de préréglage du thème';
$string['presetfiles_desc'] = 'Les fichiers de pré-réglages peuvent être utilisés pour changer drastiquement l\'apparence du thème. Voir https://docs.moodle.org/dev/Boost_Presets pour plus d\'informations sur la création et le partage de vos fichiers de pré-réglages.';
$string['presets_settings'] = 'Préréglages';
$string['privacy:metadata'] = 'Le thème Fordson n\'enregistre aucune donnée personnelle.';
$string['qbank'] = 'Banque de questions';
$string['qbank_desc'] = 'Créer et organiser les questions de vos tests';
$string['rawscss'] = 'SCSS brut';
$string['rawscss_desc'] = 'Utiliser ce champ pour fournir du code SCSS qui sera injecté à la fin de la feuille de style';
$string['rawscsspre'] = 'SCSS brut initial';
$string['rawscsspre_desc'] = 'Dans ce champ, vous pouvez fournir un code SCSS initialisable, il sera injecté avant tout le reste.
La plupart du temps vous utiliserez ce paramètre pour définir les variables.';
$string['region-fp-a'] = 'Colonne A';
$string['region-fp-b'] = 'Colonne B';
$string['region-fp-c'] = 'Colonne C';
$string['region-side-pre'] = 'Droite';
$string['section_mods'] = 'Modules :';
$string['sectionlayout'] = 'Style des sections';
$string['sectionlayout1'] = 'Boost';
$string['sectionlayout2'] = 'Style fiche';
$string['sectionlayout3'] = 'Style onglet';
$string['sectionlayout4'] = 'Style intercalaire';
$string['sectionlayout5'] = 'Boîte simple';
$string['sectionlayout6'] = 'Titre de la section en évidence';
$string['sectionlayout7'] = 'Universitaire';
$string['sectionlayout8'] = 'Entreprise';
$string['sectionlayout_desc'] = 'Sélectionner à partir de cette section de style thématique/hebdomadaire. <a href="https://goo.gl/fMXzSo" target="_new">Documentation du thème Fordson</a>';
$string['setting_navdrawersettings'] = 'Paramètres du tiroir de navigation';
$string['setting_navdrawersettings_desc'] = 'Activer la fonctionnalité de zone de navigation Boost. Fordson ne nécessite pas de zone de navigation. Nous l\'avons remplacé par une liste déroulante Jump-to-section. Vous pouvez réactiver la zone de navigation ci-dessous.';
$string['showactivitynav'] = 'Afficher la navigation par activité';
$string['showactivitynav_desc'] = 'Décochez cette option pour désactiver la navigation d’activités au bas des pages d’activités.';
$string['showblockregions'] = 'Afficher des régions de bloc supplémentaires sur la page d\'accueil du site';
$string['showblockregions_desc'] = 'Activez trois autres zones de bloc sur la page d\'accueil du site. Ceux-ci apparaissent juste en dessous de la barre de navigation des icônes.';
$string['showcourseadminstudents'] = 'Afficher l\'icône d\'administration de cours à l\'étudiant';
$string['showcourseadminstudents_desc'] = 'Affiche les paramètres du cours pour les étudiants. Ceci est nécessaire si vous voulez leur permettre de se désinscrire des cours.';
$string['showcourseheaderimage'] = 'Montrer les images du cours';
$string['showcourseheaderimage_desc'] = 'Permettre aux enseignants de personnaliser l\'image d\'en-tête en insérant un fichier image dans les paramètres du cours.';
$string['showcustomlogin'] = 'Activer la connexion personnalisée';
$string['showcustomlogin_desc'] = 'Sélectionner pour activer les paramètres personnalisés ci-dessous.';
$string['showloginform'] = 'Afficher le formulaire de connexion';
$string['showloginform_desc'] = 'Décochez cette option pour cacher le formulaire de connexion personnalisé sur la page d\'accueil pour les utilisateurs déconnectés.';
$string['shownavclosed'] = 'Tiroir de navigation fermé par défaut';
$string['shownavclosed_desc'] = 'Fermer le tiroir de navigation par défaut sur toutes les pages pour tous les utilisateurs.';
$string['shownavdrawer'] = 'Afficher la zone de navigation';
$string['shownavdrawer_desc'] = 'Fordson a éliminé le recourt à la zone de navigation en utilisant un menu déroulant pour la navigation en cours. Si vous devez utiliser la zone de navigation, vous pouvez cocher cette case pour la réactiver.';
$string['showonlygroupteachers'] = 'Montrer uniquement les groupes d\'enseignants';
$string['showonlygroupteachers_desc'] = 'Lorsque cette option est activée, seuls les enseignants du même groupe que l’élève seront affichés sur le Panneau de gestion des cours pour étudiants.';
$string['showslideshow'] = 'Activer le diaporama';
$string['showslideshow_desc'] = 'Cocher cette option pour activer la fonctionnalité « Diaporama »';
$string['showstudentcompletion'] = 'Afficher l\'achèvement de l\'étudiant';
$string['showstudentcompletion_desc'] = 'Affiche l\'infographie radiale correspondant au taux de complétion de l\'étudiant dans le panneau de gestion de cours pour les apprenants. Le suivi d\'achèvement doit être activé pour que cette option fonctionne.';
$string['showstudentgrades'] = 'Montrer les notes de l\'étudiant';
$string['showstudentgrades_desc'] = 'Affiche un lien vers le carnet de notes de l\'étudiant dans le tableau de bord des étudiants. L\'option « Afficher le carnet de notes aux étudiants » doit être activée dans le cours pour que cette option fonctionne.';
$string['siteadminquicklink'] = 'Administration du site';
$string['skype'] = 'Compte Skype';
$string['skypedesc'] = 'Saisir le nom d\'utilisateur du compte Skype de votre organisation';
$string['slide1info'] = 'Diapositive 1';
$string['slide1infodesc'] = 'Détails de la diapositive 1.';
$string['slide2info'] = 'Diapositive 2';
$string['slide2infodesc'] = 'Détails de la diapositive 2.';
$string['slide3info'] = 'Diapositive 3';
$string['slide3infodesc'] = 'Détails de la diapositive 3.';
$string['slidecontent'] = 'Description de la diapositive';
$string['slidecontent_desc'] = 'Ajouter une description pour cette diapositive.';
$string['slideimage'] = 'Image de la diapositive';
$string['slideimage_desc'] = 'Ajouter une image de fond pour cette diapositive.';
$string['sliderinfo'] = 'Bouton-icône spécial';
$string['sliderinfodesc'] = 'Ce bouton montrera/cachera une zone de texte spéciale qui glisse vers le bas depuis la barre de navigation des icônes. C\'est un moyen idéal pour présenter des cours, offrir de l\'aide ou lister des formations requises pour le personnel.';
$string['slideshowheight'] = 'Hauteur du diaporama';
$string['slideshowheight_desc'] = 'Régler la hauteur du diaporama sur les pages Accueil/Tableau de bord. Ce paramètre est ignoré sur la page de connexion personnalisée pour laquelle, la hauteur de la diapositive est déterminée par la taille et la largeur de la page.';
$string['slideshowpages'] = 'Pages du diaporama';
$string['slideshowpages0'] = 'Afficher uniquement sur la page de connexion personnalisée';
$string['slideshowpages1'] = 'Afficher uniquement sur la page d\'accueil du site et sur le tableau de bord';
$string['slideshowpages2'] = 'Afficher partout';
$string['slideshowpages_desc'] = 'Détermine les principales pages sur lesquelles le diaporama doit apparaître. Si vous utilisez le diaporama sur une page de connexion personnalisée, il est recommandé d\'importer des images et de ne pas utiliser les options de texte des diapositives ci-dessous. REMARQUE : le diaporama n\'apparaîtra pas sur les appareils mobiles.';
$string['slideshowsettings'] = 'Diaporama';
$string['slideshowspacer'] = 'Séparateur du diaporama sur la page de connexion personnalisée';
$string['slideshowspacer_desc'] = 'Sur la page de connexion personnalisée, ce paramètre est utilisé pour ajouter une séparation sous le formulaire de connexion dans le cas où vous mettriez du texte dans les diapositives.';
$string['slidetextbox'] = 'Boite à texte de la diapositive';
$string['slidetextbox_desc'] = 'Le contenu de cette boîte à texte sera affiché lorsque le bouton « Slide » est pressé';
$string['slidetitle'] = 'Titre de la diapositive';
$string['slidetitle_desc'] = 'Entrer un titre pour cette diapositive';
$string['sociallink'] = 'Lien social personnalisé';
$string['sociallinkdesc'] = 'Saisir l\'URL de votre lien de réseau social personnalisé. (ex : http://dearbornschools.org)';
$string['sociallinkicon'] = 'Icône du lien';
$string['sociallinkicondesc'] = 'Saisir le nom fontawesome de l\'icône pour votre lien<br />Une liste complète d\'icônes fontawesome peut être trouvée sur https://fontawesome.io/icons';
$string['socialnetworks'] = 'Réseaux sociaux';
$string['studentdashboardtextbox'] = 'Message sur le tableau de bord des étudiants';
$string['studentdashboardtextbox_desc'] = 'Ajouter un message pour les étudiants dans le tableau de bord étudiant sur toutes les pages de cours.';
$string['studentdashbutton'] = 'Tableau de bord du cours';
$string['textcontentinfo'] = 'Contenu personnalisé';
$string['textcontentinfodesc'] = 'Utilisez les zones de texte ci-dessous pour ajouter une information personnalisée pour les utilisateurs.';
$string['thiscourse'] = 'Ce cours';
$string['thismyclasses'] = 'Celle classe';
$string['thismycomp'] = 'Cette compétence';
$string['thismycourses'] = 'Ce cours';
$string['thismycred'] = 'Cette référence';
$string['thismylectures'] = 'Cette conférence';
$string['thismylessons'] = 'Cette leçon';
$string['thismymodules'] = 'Ce module';
$string['thismyplans'] = 'Ce plan';
$string['thismyprofessionaldevelopment'] = 'Ce développement professionnel';
$string['thismyprograms'] = 'Ce programme';
$string['thismytraining'] = 'Cette formation';
$string['thismyunits'] = 'Cette unité';
$string['titletooltip'] = 'Info-bulle du titre du cours';
$string['titletooltip_desc'] = 'Si ce réglage est activé et que le titre du cours est tronqué, le titre complet du cours sera affiché dans une info-bulle.';
$string['togglemarketing'] = 'Position de la zone d\'annonce de la page d\'accueil';
$string['togglemarketing_desc'] = 'Détermine où s\'afficheront les annonces sur la page d\'accueil.';
$string['topnavbarbg'] = 'Barre de navigation supérieure par défaut';
$string['topnavbarbg_desc'] = 'Couleur d\'arrière plan pour la barre de navigation supérieure.';
$string['topnavbarteacherbg'] = 'Rôle de l’enseignant dans la barre de navigation supérieure';
$string['topnavbarteacherbg_desc'] = 'Couleur d\'arrière-plan du contenu de la barre de navigation supérieure lorsque l\'utilisateur est un enseignant. Cette fonctionnalité doit être activée dans les paramètres du menu. Veuillez vous reporter au réglage de la couleur de la barre de navigation';
$string['trimsummary'] = 'Tronquer le résumé du cours';
$string['trimsummary_desc'] = 'Saisir un nombre pour tronquer le résumé. Ce nombre représente les caractères qui seront affichés.';
$string['trimtitle'] = 'Tronquer le nom du cours';
$string['trimtitle_desc'] = 'Saisir un nombre pour tronquer le titre. Ce nombre représente les caractères qui seront affichés.';
$string['tumblr'] = 'URL Tumblr';
$string['tumblrdesc'] = 'Saisir l\'URL de votre page tumblr (ex : http://www.tumblr.com/).';
$string['twitter'] = 'URL Twitter';
$string['twitterdesc'] = 'Saisir l\'URL de votre page Twitter (ex : http://www.twitter.com/).';
$string['userlinks'] = 'Liens utilisateur';
$string['userlinks_desc'] = 'Gérez vos étudiants';
$string['viewfcfmodules'] = 'Voir les activités et les ressources';
$string['viewsectionmodules'] = 'Afficher les modules de la section';
$string['vimeo'] = 'URL Vimeo';
$string['vimeodesc'] = 'Saisir l\'URL de votre chaîne Vimeo (ex : http://vimeo.com/).';
$string['vk'] = 'URL VKontakte';
$string['vkdesc'] = 'Saisir l\'URL de votre page VKontakte (ex : http://www.vk.com/).';
$string['website'] = 'URL du site web';
$string['websitedesc'] = 'Saisir l\'URL de votre propre site web (ex : http://dearbornschools.org).';
$string['youtube'] = 'URL YouTube';
$string['youtubedesc'] = 'Saisir l\'URL de votre chaîne YouTube (ex : http://www.youtube.com/).';
