<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cobra', language 'fr', version '3.11'.
 *
 * @package     cobra
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['CECR_level'] = 'CECRL';
$string['OK'] = 'OK';
$string['addtomyglossary'] = 'Ajouter à mon glossaire';
$string['annotation'] = 'Annotation';
$string['annotationsdisplaymode'] = 'Afficher les annotations';
$string['audioplayer'] = 'Lecteur audio';
$string['audioplayer_help'] = 'Permet d\'afficher un lecteur audio si une version sonore est disponible';
$string['bilingual'] = 'Bilingues';
$string['category'] = 'Catégorie';
$string['categoryshrinked'] = 'Cat.';
$string['clickedin'] = 'Cliqué dans…';
$string['clicnumber'] = 'Nombre de clics';
$string['cobra'] = 'CoBRA';
$string['cobra:addinstance'] = 'Ajouter un texte CoBRA';
$string['cobra:view'] = 'Voir';
$string['cobraname'] = 'Nom';
$string['cobraname_help'] = 'Nom attribué à la ressource CoBRA dans votre cours.';
$string['cobraserviceurl'] = 'URL des webservices';
$string['collection'] = 'Collection';
$string['collectionnamecannotbeempty'] = 'Le champ collection ne peut être vide';
$string['comparetextwithglossary'] = 'Comparer un texte et le glossaire';
$string['conditional'] = 'En l\'absence de concordances';
$string['corpusselection'] = 'Sélection des corpus';
$string['corpusselection_help'] = 'Sélection et ordre d\'affichage par défaut des exemples tirés des corpus (liste séparée par des virgules)<br/>Types disponibles :<br/>
<ul>
<li class="usuel_FUNDP">1 : langue usuelle (édités à l\'UNamur)</li>
<li class="usuel">11 : langue usuelle</li>
<li class="semi-technique">21 : politique</li>
<li class="technique">22 : droit (uniquement néerlandais)</li>
<li class="histoire">32 : art et histoire</li>
<li class="informatique">42 : informatique</li>
<li class="sciences">52 : sciences </li>
<li class="sciences_FUNDP">51 : sciences (édités à l\'UNamur) (uniquement anglais)</li>
<li class="eco">62 : économie </li>
</ul>';
$string['defaultcorpusselection'] = 'Sélection par défaut des corpus';
$string['defaultflag'] = 'Conserver par défaut';
$string['defaultflag_help'] = 'Utiliser par défaut ces paramètres pour les prochains textes';
$string['definition'] = 'Définition';
$string['deletesure'] = 'Voulez-vous vraiment vider votre glossaire personnel pour ce cours ?';
$string['displaysettings'] = 'Paramètres d\'affichage';
$string['emptymyglossary'] = 'Vider mon glossaire';
$string['entries'] = 'Entrées';
$string['entriesfromothertext'] = '* Les entrées grisées ont été rajoutées via un autre texte';
$string['entry'] = 'Entrée';
$string['entry_viewed'] = 'Entrée cliquée';
$string['examplesdisplaymode'] = 'Mode d\'affichage pour les exemples';
$string['examplesdisplaymode_help'] = 'Afficher les exemples uniquement dans la langue source (monolingue) ou dans la langue source et en français (bilingue)';
$string['exportglossary'] = 'Générer un glossaire';
$string['fordutch'] = 'Pour le néerlandais';
$string['fordutch_desc'] = 'Sélection et ordre d\'affichage par défaut des exemples tirés des corpus (liste séparée par des virgules)<br/>Types disponibles :<br/>
<ul style="width:50%;">
<li style="background-color: #CCFFCC">1 : langue usuelle (édités à l\'UNamur)</li>
<li style="background-color: #99FF99">11 : langue usuelle</li>
<li style="background-color: #FFCC99">21 : politique</li>
<li style="background-color: #FF9966">22 : droit</li>
<li style="background-color: #99CCFF">32 : art et histoire</li>
<li style="background-color: #FFFF66">42 : informatique</li>
<li style="background-color: #CCCCFF">52 : sciences </li>
<li style="background-color: #FFCCCC">62 : économie </li>
</ul>';
$string['forenglish'] = 'Pour l\'anglais';
$string['forenglish_desc'] = 'Sélection et ordre d\'affichage par défaut des exemples tirés des corpus (liste séparée par des virgules)<br/>Types disponibles :<br/>
<ul style="width:50%;">
<li style="background-color: #CCFFCC">1 : langue usuelle (édités à l\'UNamur)</li>
<li style="background-color: #99FF99">11 : langue usuelle</li>
<li style="background-color: #FFCC99">21 : politique</li>
<li style="background-color: #99CCFF">32 : art et histoire</li>
<li style="background-color: #FFFF66">42 : informatique</li>
<li style="background-color: #CC99CC">51 : sciences (édités à l\'UNamur)</li>
<li style="background-color: #CCCCFF">52 : sciences</li>
<li style="background-color: #FFCCCC">62 : économie</li>
</ul>';
$string['generalconfig'] = 'Configuration générale';
$string['glossary'] = 'Glossaire';
$string['glossaryempty'] = 'Glossaire vide !';
$string['glossaryemptyfortext'] = 'Glossaire vide pour ce texte !';
$string['inmyglossary'] = 'Présent dans mon glossaire';
$string['language'] = 'Langue';
$string['language_help'] = 'La langue enseignée dans votre cours.

**Attention: ce paramètre ne peut être modifié! **';
$string['languageismandatory'] = 'La langue est obligatoire';
$string['modulename'] = 'CoBRA';
$string['modulename_help'] = 'Le module de lecture CoBRA propose un texte en anglais ou en néerlandais avec une aide lexicale donnant accès à la traduction en contexte de chaque mot, en l’illustrant par des exemples bilingues provenant de sources variées.

L’enseignant peut paramétrer l’outil en ordonnant et en filtrant les exemples selon leur provenance et le public visé.

L’étudiant peut constituer et exporter un glossaire personnel qui est généré à partir d’un ou de plusieurs texte(s) de leçon.';
$string['modulenameplural'] = 'CoBRA';
$string['monolingual'] = 'Monolingues';
$string['myglossary'] = 'Mon glossaire';
$string['mytext'] = 'Mon texte';
$string['newwords'] = 'Nouveaux mots';
$string['noconcordances'] = 'Pas de traductions en contexte';
$string['noentriesforletter'] = 'Aucune entrée commençant par {$a}';
$string['otherforms'] = 'Autres formes';
$string['othertranslations'] = 'Autre(s) traduction(s)';
$string['platformnotallowed'] = 'Votre plateforme n\'est pas autorisée à accéder au service CoBRA';
$string['pluginadministration'] = 'Administration CoBRA';
$string['pluginname'] = 'CoBRA';
$string['possibletranslations'] = 'Traductions possibles';
$string['privacy:metadata:cobra_click'] = 'Information sur les clics réalisés par l\'utilisateur lors de la lecture d\'un text CoBRA.';
$string['privacy:metadata:cobra_click:course'] = 'Identifiant du cours dans lequel le mot a été cliqué.';
$string['privacy:metadata:cobra_click:inglossary'] = 'Drapeau signalant si l\'utilateur a ajouté le mot considéré dans son glossaire personnel.';
$string['privacy:metadata:cobra_click:lingentity'] = 'Identifiant de l\'entrée cliquée.';
$string['privacy:metadata:cobra_click:nbclicks'] = 'Le nombre de fois que l\'utilisateur a cliqué sur le même mot dans le même texte pour le même cours.';
$string['privacy:metadata:cobra_click:textid'] = 'Identifiant du texte dans lequel le mot a été cliqué.';
$string['privacy:metadata:cobra_click:timecreated'] = 'Horodatage du premier clic de l\'utlistateur sur le mot considéré.';
$string['privacy:metadata:cobra_click:userid'] = 'Identifiant de l\'utilisateur qui a cliqué le mot';
$string['registrationrequired'] = 'L\'enregistrement est obligatoire';
$string['registrationwarning'] = '<div class="box errorbox alert alert-danger py-3">Votre plateforme n\'est pas encore enregistrée comme utilisatrice de CoBRA. Afin de pouvoir tester les fonctionnalités de l\'outil vous devez demander à l\'administrateur de votre plateforme de demander une clé d\'API et de l\'ajouter à la configuration du module.</div>';
$string['removefrommyglossary'] = 'Supprimer de mon glossaire';
$string['requestdemokey'] = 'Demander une clé démo';
$string['requestdemokey_desc'] = 'En cliquant sur ce bouton vous enverrez des informations relatives à votre plateforme (shortname, adresse IP, URL, et identifiant de site) afin de vous enregistrer sur CoBRA et obtenir une clé d\'accès de démonstration';
$string['resetclichistory'] = 'Effacer l\'historique des clics.';
$string['resetdefaults'] = 'Remettre les valeurs plateforme par défaut pour les paramètres d\'affichage et la sélection des corpus';
$string['resetglossaries'] = 'Vider tous les glossaires personnels';
$string['serviceunavailable'] = 'Le service CoBRA à l\'adresse {$a} est inaccessible';
$string['showfullglossary'] = 'Afficher tout mon glossaire';
$string['source'] = 'Source';
$string['sourcetext'] = 'Texte source';
$string['text'] = 'Texte';
$string['textreading'] = 'Lecture de textes';
$string['texts'] = 'texte(s)';
$string['totalclicnumber'] = 'Nombre total de clics';
$string['translation'] = 'Traduction(s)';
$string['translations'] = 'Traductions';
$string['translationsdisplaymode'] = 'Afficher les traductions';
$string['unhandledreturntype'] = 'Type de réponse du service CoBRA non supporté - {$a}';
$string['updateglossarycache'] = 'Mise à jour du cache du glossaire';
$string['updatetextinfocache'] = 'Mise à jour du cache des informations sur les textes';
$string['userglossary'] = 'Glossaire personnalisé';
$string['userglossary_help'] = 'Permet aux étudiants de construire leur propre glossaire au fur et à mesure de la lecture des textes';
