<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certification', language 'pt_br', version '3.11'.
 *
 * @package     tool_certification
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['active'] = 'Ativo';
$string['activecertifications'] = 'Certificações ativas';
$string['afteractualcertcompletion'] = 'Após a conclusão da certificação atual';
$string['afteractualcertcompletionwithrelativedate'] = '{$a} após a conclusão da certificação atual';
$string['afterallocationdate'] = 'Após a data de alocação';
$string['afterallocationdatewithrelativedate'] = '{$a} após a data de alocação';
$string['aftercompletion'] = 'Após a conclusão';
$string['aftercompletionwithrelativedate'] = '{$a} após a conclusão';
$string['afterduedate'] = 'Após a data de entrega';
$string['afterduedatewithrelativedate'] = '{$a} após a data de entrega';
$string['afterlatest'] = 'Após a última conclusão ou expiração atual';
$string['afterlatestwithrelativedate'] = '{$a} após a última conclusão ou expiração atual';
$string['afterpreviouscertexpdate'] = 'Após a data de expiração da certificação anterior';
$string['afterpreviouscertexpdatewithrelativedate'] = '{$a} após a data de expiração da certificação anterior';
$string['afterstartdate'] = 'Após a data de início';
$string['afterstartdatewithrelativedate'] = '{$a} após a data de início';
$string['allocateusers'] = 'Alocar usuários';
$string['allocationdate'] = 'Data de alocação';
$string['allocationdateisonorafter'] = 'Data de alocação em ou após';
$string['allocationenddate'] = 'Data de término da alocação';
$string['allocationfor'] = 'Alocação para \'{$a}\'';
$string['allocationsource'] = 'Fonte de alocação';
$string['allocationstartdate'] = 'Data de início da alocação';
$string['allocationwindowenddate'] = 'Data de término';
$string['allocationwindowenddate_help'] = 'Data de término da janela de alocação';
$string['allocationwindowendedon'] = 'A janela de alocação para esta certificação terminou em {$a}.';
$string['allocationwindowstartdate'] = 'Data de início';
$string['allocationwindowstartdate_help'] = 'Data de início da janela de alocação';
$string['allocationwindowstartson'] = 'A janela de alocação para esta certificação começa em {$a}.';
$string['archive'] = 'Arquivo';
$string['archived'] = 'Arquivado';
$string['archivedcertifications'] = 'Certificações arquivadas';
$string['archivedconfirmation'] = 'Tem certeza de que deseja arquivar a certificação \'{$a}\'? A certificação arquivada não estará mais disponível para gerentes ou estudantes e pode ser visualizada apenas em relatórios de históricos.';
$string['archivedon'] = 'Arquivado em';
$string['autocreategroups'] = 'Adicionar a grupos de cursos';
$string['autocreategroups_help'] = 'Quando os usuários estão inscritos nos cursos do programa, eles podem ser adicionados automaticamente ao mesmo grupo. No caso em que "para esta certificação" for selecionado, um grupo separado para esta certificação será usado e será diferente das outras certificações usando o mesmo programa.';
$string['autocreategroupsasinprogram'] = 'Conforme definido no programa';
$string['autocreategroupscertification'] = 'Crie grupos para esta certificação';
$string['basic'] = 'Básico';
$string['basicdetails'] = 'Detalhes básicos';
$string['becamecertified'] = 'Tornou-se certificado';
$string['beforepreviouscertexpdate'] = 'antes da data de expiração da certificação anterior';
$string['calendarduedate'] = 'Data de entrega da certificação {$a}';
$string['calendarexpirydate'] = 'Data de expiração da certificação {$a}';
$string['cannotallocateuser'] = 'Não é possível alocar usuário para certificação {$a}';
$string['certification'] = 'Certificação';
$string['certification:allocateuser'] = 'Permissão para alocar usuário';
$string['certification:configurecustomfields'] = 'Configurar campos personalizados de certificações';
$string['certification:edit'] = 'Permissão para editar';
$string['certification:view'] = 'Permissão para visualizar';
$string['certificationfullname'] = 'Nome completo da certificação';
$string['certificationfullname_help'] = 'Nome completo da certificação';
$string['certificationidnumber'] = 'Número de  ID da certificação';
$string['certificationidnumber_help'] = 'O ID  number de uma certificação é usado apenas ao fazer a correspondência com sistemas externos e não é exibido em nenhum lugar do site. Se a certificação tiver um código oficial, poderá ser inserido aqui, caso contrário o campo poderá ser deixado em branco.';
$string['certificationname'] = 'Nome da certificação';
$string['certificationnamewithlink'] = 'Nome da certificação com link';
$string['certificationprogress'] = 'Progresso da certificação';
$string['certificationrules'] = 'Regras da certificação';
$string['certifications'] = 'Certificações';
$string['certificationscustomfield'] = 'Campos personalizados de certificações';
$string['certificationstatus'] = 'Status de certificação';
$string['certificationstatus_help'] = 'Status da certificação atual';
$string['certificationtags'] = 'Tags de certificação';
$string['certificationtags_help'] = 'Tags para esta certificação';
$string['certificationuserlog'] = 'Registro de atividade de {$a}';
$string['certificationuserlogempty'] = 'Não há logs de eventos para esta certificação de usuário.';
$string['certificationuserlogfilename'] = '{$a->user} logs de atividades {$a->certification}';
$string['certified'] = 'Certificado';
$string['certifiedby'] = 'Certificado por';
$string['certifiedcertificationslink'] = '<a href="{$a->href}">{$a->count} certificações certificadas</a>';
$string['certifieddate'] = 'Data da certificação';
$string['certifieddateisonorafter'] = 'Data da certificação em ou após';
$string['certifiednotification'] = 'O usuário foi certificado com sucesso';
$string['certifiedtype'] = 'Tipo de certificado';
$string['certify'] = 'Certificar';
$string['certifyexpirydate'] = 'Data de expiração';
$string['certifyexpirydate_help'] = 'Selecione uma data de expiração para este usuário certificado entre \'Padrão\' (mostra a configuração de certificação atual), \'Nunca\' ou uma data personalizada.';
$string['certifyuser'] = 'Certificar usuário';
$string['completedtheprogram'] = 'Complete o programa {$a}';
$string['conditioncertificationcertified'] = 'Certificação certificada';
$string['conditioncertificationcertifieddescriptiononrecert'] = 'Executar para cada recertificação';
$string['conditioncertificationcertifieddescriptionstatusonly'] = 'Executar apenas na mudança de status';
$string['conditioncertificationcertifieddescriptionwithdate'] = 'Usuários com status Certificado em certificação \'{$a->fullname}\'<br />
A data da certificação é em ou após \'{$a->conditiondate}\'';
$string['conditioncertificationcertifiedstatusonly'] = 'Execute ações somente quando o status do usuário mudar de "não certificado" para "certificado"';
$string['conditioncertificationcertifiedstatusonly_help'] = 'Neste caso as ações podem ou não ser executadas na recertificação, dependendo se a certificação anterior expirou ou não. Para garantir que as ações <b>nunca</b> sejam executadas durante a recertificação, considere definir o "Limite de ações da regra" nas configurações de regras.';
$string['conditioncertificationexpired'] = 'Certificação expirada';
$string['conditioncertificationexpireddescriptionwithdate'] = 'Usuários com status Expirado na certificação \'{$a->fullname}\'<br />
A data de expiração é em ou após \'{$a->conditiondate}\'';
$string['conditioncertificationnotcertified'] = 'Certificação não certificada';
$string['conditioncertificationoverdue'] = 'Certificação vencida';
$string['conditioncertificationoverduedescriptionwithdate'] = 'Usuários com status Vencida na certificação \'{$a->fullname}\'<br />
Data de vencimento é em ou após \'{$a->conditiondate}\'';
$string['conditioncertificationstatus'] = 'Status de certificação';
$string['conditioncertificationstatusdescription'] = 'Usuários com status';
$string['conditioncertificationstatusdescriptionnegated'] = 'Usuários com status  \'{$a->status}\' na certificação  \'{$a->fullname}\'';
$string['conditioncertificationsuspended'] = 'Certificação suspensa';
$string['conditioncertificationsuspendeddescriptionwithdate'] = 'Usuários com status Suspenso na certificação \'{$a->fullname}\'<br />
A suspensão é em ou após \'{$a->conditiondate}\'';
$string['conditionrecertificationgraceperiod'] = 'O período de carência de recertificação termina';
$string['conditionrecertificationgraceperiodendsdescription'] = 'Usuários cujo período de carência  termina na certificação  \'{$a->fullname}\'';
$string['conditionrecertificationgraceperiodendsdescriptionwithdate'] = 'Usuários cujo período de carência termina na certificação \'{$a->fullname}\'<br />
O período de carência de recertificação termina em ou antes \'{$a->conditiondate}\'';
$string['conditionrecertificationstarted'] = 'Período de recertificação iniciado';
$string['conditionrecertificationstarteddescription'] = 'Usuários que iniciaram um período de recertificação na certificação \'{$a->fullname}\'';
$string['conditionrecertificationstarteddescriptionwithdate'] = 'Usuários que iniciaram um período de recertificação na certificação \'{$a->fullname}\'<br />
A recertificação começou em ou após \'{$a->conditiondate}\'';
$string['conditionuserallocated'] = 'Usuários alocados para certificação';
$string['conditionuserallocateddescription'] = 'Usuários alocados para certificação {$a}';
$string['conditionuserallocateddescriptionwithdate'] = 'Usuários alocados para certificação {$a->fullname}<br />
A data de alocação é em ou após \'{$a->conditiondate}\'';
$string['conditionusernotallocated'] = 'Usuários não alocados para certificação';
$string['conditionusernotallocateddescription'] = 'Usuários não alocados para certificação {$a}';
$string['confirmdeletecertification'] = 'Você tem certeza que deseja deletar a certificação \'{$a}\' e dados associados? Essa ação não pode ser desfeita.';
$string['confirmdeleteuserallocation'] = 'Tem certeza de que deseja excluir completamente a alocação do usuário \'{$a}\' e os dados associados? Essa ação não pode ser desfeita.';
$string['confirmduplicate'] = 'Uma cópia da configuração da certificação será criada e você poderá alterar o programa e outras propriedades. Nenhuma alocação de usuário será transferida para a cópia';
$string['content'] = 'Conteúdo';
$string['coursebackups'] = 'Backups do curso (sem dados do usuário)';
$string['criteriaall'] = 'Todas as certificações selecionadas foram certificadas';
$string['criteriaany'] = 'Pelo menos uma das certificações selecionadas é certificada';
$string['criteriaeach'] = 'Cada vez que um usuário é certificado em alguma das certificações selecionadas';
$string['criteriaeach_help'] = 'Equivalente a criar múltiplas regras, uma para cada uma das certificações selecionadas';
$string['currentprogram'] = 'Programa atual';
$string['currentprogram_help'] = 'Este é o programa atual que este usuário está executando';
$string['dateoverrided'] = 'Data substituída';
$string['dayssinceallocation'] = 'Dias desde a alocação';
$string['daystakingcertification'] = 'Dias fazendo a certificação';
$string['default'] = 'Padrão';
$string['deleteuserallocation'] = 'Excluir alocação de usuário';
$string['displaycertificationdate'] = 'Data da certificação';
$string['displaycertificationid'] = 'ID de certificação interno usado em URLs';
$string['displaycertificationname'] = 'Nome da certificação';
$string['displayexpirydate'] = 'Data de expiração da certificação';
$string['displayexpirydatetimestamp'] = 'Data em que a certificação vence formato timestamp';
$string['duedate'] = 'Data de entrega';
$string['duedate_help'] = 'Data até a qual a certificação deve ser concluída';
$string['duedateisonorafter'] = 'Data de entrega em ou após';
$string['duplicate'] = 'Duplicado';
$string['dynamic'] = 'Dinâmico';
$string['dynamicrules'] = 'Regras dinâmicas';
$string['dynamicrulesplugincheck'] = 'Visualizar a lista de regras dinâmicas é impossível sem o plugin tool_dynamicrules';
$string['dynamicrulewarningdeallocation'] = 'Os usuários só podem ser desalocados se tiverem sido alocados por outra regra dinâmica; as alocações manuais não serão afetadas.';
$string['editcertification'] = 'Editar certificação \'{$a}\'';
$string['editcertificationname'] = 'Editar nome da certificação';
$string['editcertificationsettings'] = 'Editar configurações de certificação';
$string['editcontent'] = 'Editar conteúdo';
$string['editdetails'] = 'Editar Detalhes';
$string['enddate'] = 'Data de término';
$string['entitycertification'] = 'Certificação';
$string['entitycertificationusers'] = 'Alocação e conclusão de usuários de certificação';
$string['errorallocatinguserintorelatedprogram'] = 'Não é possível alocar o usuário para o programa relacionado';
$string['errorallocationsourcenotfound'] = 'Fonte de alocação não encontrada';
$string['erroralreadycertified'] = 'Usuário já certificado nesta certificação com esta data de início.';
$string['errorcannotallocate'] = 'Não foi possível alocar o usuário à certificação (alocação já existe ou não é permitida)';
$string['errorcantallocateuser'] = 'Não foi possível alocar o usuário';
$string['errorcantdeletecertification'] = 'Não é possível excluir a certificação';
$string['errorcantdeletenotarchivedcertification'] = 'Não é possível excluir uma certificação não arquivada';
$string['errorcantmanageusers'] = 'Não pode gerenciar usuários';
$string['errorcantrestorecertification'] = 'Não é possível restaurar a certificação';
$string['errorcertificationsdontexist'] = 'Algumas certificações não existem';
$string['errorcouldnotallocate'] = 'Não foi possível alocar o usuário \'{$a->originaluserfullname}\' para a certificação \'{$a->certification}\'';
$string['errorevaluatinguserallocationstatus'] = 'Erro ao avaliar o status de alocação de usuário';
$string['errorexpirydatepreviousduedate'] = 'A data de entrega não pode ser anterior à data de vencimento';
$string['erroridnumberuniquetenant'] = 'Esse ID number já é usado em outra certificação';
$string['errorinvalidcertification'] = 'Certificação inválida';
$string['errorinvaliddate'] = 'Data inválida';
$string['errorinvalidexpirydate'] = 'Data inválida na certificação, certificado expirado';
$string['errorinvalidpastexpirydate'] = 'Data de expiração não pode estar no passado';
$string['errorinvalidpaststartdate'] = 'A data de início não pode estar no passado';
$string['errorinvalidtimecertified'] = 'O tempo  certificado não pode estar no futuro.';
$string['errormissingassociatedprogram'] = 'Programa associado ausente';
$string['errormustnotcontainsharedcertifications'] = 'Não deve conter certificações compartilhadas';
$string['errornopermissionallocateusers'] = 'Nenhuma permissão para alocar usuários para certificação';
$string['errornopermissionmanagecertifications'] = 'Sem permissão para gerenciar certificações';
$string['errornopermissionviewallocatedusers'] = 'Sem permissão para ver os usuários alocados nessa certificação';
$string['errornopermissionviewreports'] = 'Sem permissão para ver relatórios';
$string['errorrecertificationprogram'] = 'O programa deve ser diferente do programa inicial';
$string['errorreporttypedoesnotexist'] = 'O tipo de relatório não existe';
$string['errorsameidnumber'] = 'Já existe certificação com o mesmo ID number';
$string['erroruseralreadyallocatedincertification'] = 'Usuário já alocado à certificação';
$string['erroruseralreadyallocatedinprogram'] = 'Usuário já alocado ao programa';
$string['errorusernotinsametenant'] = 'Usuário não está no mesmo tenant';
$string['eventcertificationcompleted'] = 'Certificação concluída';
$string['eventcertificationcreated'] = 'Certificação criada';
$string['eventcertificationdeleted'] = 'Certificação deletada';
$string['eventcertificationupdated'] = 'Certificação atualizada';
$string['eventrecertificationgraceperiodended'] = 'Período de carência de recertificação encerrado';
$string['eventrecertificationstarted'] = 'Recertificação iniciada';
$string['eventuserallocated'] = 'Foi alocado à certificação';
$string['eventuserdeallocated'] = 'Usuário desalocado';
$string['eventuserupdated'] = 'Alocação de usuário atualizada';
$string['expired'] = 'Expirado';
$string['expiredcertificationslink'] = '<a href="{$a->href}">Certificações expiradas: {$a->count}</a>';
$string['expireddateisonorafter'] = 'Data de expiração em ou após';
$string['expireson'] = 'Expira em {$a}';
$string['expirydate'] = 'Data de expiração';
$string['expirydate_help'] = 'Data de expiração da certificação';
$string['export_content'] = 'Configurações';
$string['export_content_help'] = 'Certificações, nomes, descrições, datas, tags, etc.';
$string['export_course_backups'] = 'Backups do curso (sem dados do usuário)';
$string['export_course_backups_help'] = 'Backups de todos os cursos adicionados a essas certificações.';
$string['export_dynamic_rules'] = 'Regras dinâmicas';
$string['export_dynamic_rules_help'] = 'Todas as configurações de regras dinâmicas para essas certificações';
$string['export_programs'] = 'Programas associados';
$string['export_programs_help'] = 'Programas, nomes, descrições, datas, tags, etc.';
$string['export_user_allocations'] = 'Alocações de usuários';
$string['export_user_allocations_help'] = 'Inclui alocações de usuários para essas certificações. Uma cópia dos próprios usuários não será incluída.';
$string['exportcertificationsdescription'] = 'Certificações com seus programas, cursos, alocações de usuários e regras dinâmicas de componentes associados';
$string['futureallocation'] = 'Alocação futura';
$string['gotocertification'] = 'Ir para a certificação';
$string['idnumber'] = 'ID number';
$string['import_content'] = 'Configurações';
$string['import_content_help'] = 'Certificações, nomes, descrições, datas, tags, etc.';
$string['import_course_backups'] = 'Backups do curso (sem dados de usuários)';
$string['import_course_backups_help'] = 'Importe os backup de cursos para esses programas.';
$string['import_dynamic_rules'] = 'Regras dinâmicas';
$string['import_dynamic_rules_help'] = 'Toda a configuração de regras dinâmicas para esses programas.';
$string['import_programs'] = 'Programas associados';
$string['import_programs_help'] = 'Programas, nomes, descrições, datas, tags, etc.';
$string['import_user_allocations'] = 'Alocações de usuários';
$string['import_user_allocations_help'] = 'Inclui alocações de usuários para essas certificações.';
$string['importlogfailed'] = 'Não foi possível importar a certificação \'{$a->fullname}\'';
$string['importlogidnumberexists'] = 'Certificação com o ID number \'{$a->originalidnumber}\'  já existe';
$string['importlogsuccess'] = 'Criou nova certificação \'<a href="{$a->url}">{$a->fullname}</a>\'';
$string['importlogsuccessuserallocations'] = 'Usuário \'{$a->userfullname}\' alocado à certificação \'{$a->certification}\'';
$string['include_shared_entities_help'] = 'Ao habilitar essa opção, o arquivo exportado também conterá:

* Todas as certificações compartilhadas disponíveis no tenant atual
* Todos os programas compartilhados vinculados às certificações selecionadas
* Todos os cursos dos programas foram da categoria de curso do tenant atual';
$string['keepcertificationdefaults'] = 'Manter padrões de certificação';
$string['lessthanaday'] = 'Menos de um dia';
$string['manageprograms'] = 'Gerenciar programas';
$string['manual'] = 'Manual';
$string['manuallycertifieduser'] = 'Certificou manualmente {$a->usertarget} ({$a->expirydate})';
$string['mappingerrorcertificationnotfound'] = 'A certificação {$a} não foi encontrada';
$string['mappingnoticenoidnumber'] = 'A certificação foi localizada pelo nome porque o número de identificação estava vazio. É recomendável atribuir números de identificação a certificações';
$string['markcertificationcompletednotice'] = 'Marque a certificação como concluída sem aguardar a conclusão do programa';
$string['messageprovider:certificationcompleted'] = 'Certificação concluída';
$string['messageprovider:certificationuserallocated'] = 'Usuário alocado';
$string['messageprovider:certificationuserdeallocated'] = 'Usuário desalocado';
$string['missingcertification'] = 'Certificação ausente';
$string['missingfullname'] = 'Nome completo ausente';
$string['missingprogram'] = 'Programa ausente';
$string['never'] = 'Nunca';
$string['neverexpires'] = 'Nunca expira';
$string['newcertification'] = 'Nova certificação';
$string['newvaluefor'] = 'Novo valor para';
$string['notavailable'] = 'Não disponível';
$string['notificationcertificationdue'] = 'Este programa faz parte da certificação \'{$a->certificationname}\', que vence em {$a->duedate}.<br /><br />';
$string['notificationcertificationuserdeallocated'] = 'Olá, {$a->userfullname},<br /><br />
O programa \'{$a->programname}\' foi fechado e não pode mais ser acessado.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationwillexpireon'] = 'Sua certificação expirará em {$a}.<br /><br />';
$string['notificationmsgcertificationcompleted'] = 'Parabéns! Você concluiu a certificação \'{$a}\'.';
$string['notificationmsgcertificationuserallocated'] = 'Você foi alocado à certificação \'{$a}\'.';
$string['notificationmsgcertificationuserdeallocated'] = 'Você foi desalocado da certificação \'{$a}\'.';
$string['notificationmsgfooter'] = 'Você pode encontrar todas as suas certificações no seu <a href="{$a}">Painel</a>';
$string['notificationsubjectcertificationcompleted'] = 'Certificação \'{$a}\' concluída';
$string['notificationsubjectcertificationcompletedmanual'] = 'Parabéns - certificação \'{$a}\'!';
$string['notificationsubjectcertificationuserallocated'] = 'Alocado à certificação \'{$a}\'';
$string['notificationsubjectcertificationuserdeallocated'] = 'Desalocado da certificação \'{$a}\'';
$string['notset'] = 'Não configurado';
$string['nousersselected'] = 'Por favor, selecione pelo menos um usuário';
$string['ongoingcertificationslink'] = '<a href="{$a->href}">Certificações em andamento: {$a->count}</a>';
$string['open'] = 'Aberto';
$string['outcomeallocation'] = 'Alocar usuários à certificações';
$string['outcomeallocationdescription'] = 'Alocar usuários a certificações {$a}<br />
Manter a data de início padrão da certificação';
$string['outcomeallocationdescriptionwithdate'] = 'Alocar usuários à certificação {$a->certificationname}<br />
Data de início da certificação: \'{$a->startdate}\'';
$string['outcomedeallocation'] = 'Desalocar usuários de certificações';
$string['outcomedeallocationdescription'] = 'Desalocar usuários de certificações {$a}';
$string['overdue'] = 'Vencidas';
$string['overduecertificationslink'] = '<a href="{$a->href}">Certificações atrasadas: {$a->count}</a>';
$string['pluginname'] = 'Certificações';
$string['previewcertificationname'] = 'Visualização do nome da certificação';
$string['previouscertexpirydate'] = 'Data de expiração da certificação anterior';
$string['privacy:metadata:certification_completions'] = 'Informações sobre a conclusão da certificação.';
$string['privacy:metadata:certification_completions:certificationid'] = 'A certificação que o usuário concluiu.';
$string['privacy:metadata:certification_completions:certifiedby'] = 'O usuário que gerou a certificação';
$string['privacy:metadata:certification_completions:expirydate'] = 'A data de expiração desta certificação concluída.';
$string['privacy:metadata:certification_completions:revokedby'] = 'O usuário que revogou a certificação';
$string['privacy:metadata:certification_completions:timecertified'] = 'A hora em que o usuário concluiu a certificação.';
$string['privacy:metadata:certification_completions:timecreated'] = 'A hora em que o registro de conclusão foi criado.';
$string['privacy:metadata:certification_completions:userid'] = 'O usuário que concluiu a certificação.';
$string['privacy:metadata:certification_users'] = 'Informações sobre a alocação de certificação do usuário.';
$string['privacy:metadata:certification_users:certificationid'] = 'A certificação alocada para.';
$string['privacy:metadata:certification_users:currentprogramid'] = 'O atual programa que o usuário está alocado';
$string['privacy:metadata:certification_users:isrecertification'] = 'Se o usuário estiver em uma recertificação';
$string['privacy:metadata:certification_users:status'] = 'Se o usuário foi suspenso da certificação.';
$string['privacy:metadata:certification_users:timemodified'] = 'O tempo modificado da alocação do usuário.';
$string['privacy:metadata:certification_users:userid'] = 'O usuário alocado.';
$string['privacy:metadata:core_tag'] = 'Tags adicionadas às certificações';
$string['program'] = 'Programa';
$string['programchangewarning'] = 'Os usuários que estão fazendo este programa não serão realocados automaticamente. Isso pode ser feito manualmente por usuário. O status dos usuários que já concluíram o programa ou daqueles que foram marcados manualmente como certificados não será alterado, mas serão desalocados do programa antigo e não o verão mais no painel.';
$string['programcourse'] = 'Cursos do programa';
$string['programuserallocation'] = 'Usuários alocados no programa';
$string['progressreport'] = 'Relatório de progresso';
$string['recertdifferentprogram'] = 'Selecione um programa diferente';
$string['recertdifferentprogram_help'] = 'Selecione \'Sim\' se quer escolher um programa diferente do inicial para a recertificação.';
$string['recertduedaterelative'] = 'Data de entrega';
$string['recertduedaterelative_help'] = 'Essa é a data até a qual o usuário deve concluir a certificação';
$string['recertexpirydate'] = 'Data de expiração';
$string['recertexpirydate_help'] = 'Essa é a data que a re-certificação irá expirar para o usuário.';
$string['recertexpirydatewarning'] = 'A certificação inicial está configurada para nunca expirar; a recertificação somente será possível para usuários cuja data de expiração for definida individualmente.';
$string['recertgraceperiod'] = 'período de carência';
$string['recertgraceperiod_help'] = 'O período de carência é o período extra que concedemos ao usuário para concluir o programa e obter a certificação após o certificação anterior expirar. Esta opção está disponível apenas se o programa de recertificação for diferente do programa inicial.';
$string['recertgraceperiodends'] = 'O período de carência termina';
$string['recertification'] = 'Recertificação';
$string['recertificationgraceperiodendsonorbefore'] = 'O período de carência de recertificação termina em ou antes';
$string['recertificationprogram'] = 'Programa de recertificação';
$string['recertificationprogram_help'] = 'Selecione um programa para ser usado na recertificação. Este programa deve ser diferente do programa de certificação inicial.';
$string['recertificationstartdate'] = 'Data de início da recertificação';
$string['recertificationstartedonorafter'] = 'Recertificação iniciada em ou após';
$string['recertstartdaterelative'] = 'Data de início';
$string['recertstartdaterelative_help'] = 'Esta é a data em que o programa de recertificação estará disponível para o usuário.';
$string['recertstartdatewarning'] = 'Nesta data, o programa de recertificação será redefinido. Certifique-se de que os usuários não estejam inscritos nos cursos do programa em outro lugar, alocados diretamente no mesmo programa ou alocados por outras certificações, pois podem perder seu progresso.';
$string['reg_wpcertifications'] = 'Número de certificações ({$a})';
$string['reportactivecerts'] = 'Relatório do sistema para certificações ativas';
$string['reportarchivedcerts'] = 'Relatório do sistema para certificações arquivadas';
$string['reportbuilderactivecertifications'] = 'A visualização da lista de certificações ativas é impossível sem o plugin tool_reportbuilder';
$string['reportbuilderarchivedcertifications'] = 'A visualização da lista de certificações arquivadas é impossível sem o plugin tool_reportbuilder';
$string['reportbuilderdynamicrules'] = 'A visualização da lista de regras dinâmicas é impossível sem o plugin tool_reportbuilder';
$string['reportbuilderuserallocations'] = 'A visualização da lista de alocações de usuários é impossível sem o plugin tool_reportbuilder';
$string['reportbuilderuserlist'] = 'A visualização da lista de usuários é impossível sem o plugin tool_reportbuilder';
$string['reportcertificationprogress'] = 'Relatório do sistema para o progresso da certificação';
$string['reportcertsusers'] = 'Relatório de sistema para usuários da certificação';
$string['reportusercerts'] = 'Relatório de sistema para a lista de certificações do usuário';
$string['requirerecertification'] = 'Exigir recertificação';
$string['requirerecertification_help'] = 'Selecione \'Sim\' para ativar a recertificação para esta certificação.';
$string['resetadditionalcourses'] = 'Redefinir cursos adicionais';
$string['resetadditionalcourses_help'] = 'Redefinir cursos que fazem parte do novo programa que não faziam parte do programa antigo';
$string['restore'] = 'Restaurar';
$string['revokecertification'] = 'Revogar certificação';
$string['revoked'] = 'Revogada';
$string['revokedby'] = 'Revogada por';
$string['revokednotification'] = 'A certificação foi revogada com sucesso.';
$string['revokedon'] = 'Revogado em';
$string['revokedthisuser'] = 'Revogada a certificação de {$a}';
$string['revokewarning'] = 'Tem certeza de que deseja revogar a certificação de \'{$a}\'? Os prêmios que possam ter sido dados após a conclusão não serão revogados.';
$string['rolemanager'] = 'Gerente de certificação';
$string['rolemanagerdescription'] = 'Permite criar e gerenciar certificações dentro do tenant atual e alocar usuários à elas';
$string['schedule'] = 'Datas da certificação';
$string['scheduleupdatesuccess'] = 'Suas alterações foram salvas com sucesso.';
$string['selectactiveandarchivedcertifications'] = 'Selecionar certificações ativas e arquivadas';
$string['selectadifferentprogram'] = 'Selecionar um programa diferente';
$string['selectallactivecertifications'] = 'Selecionar todas as certificações ativas';
$string['selectallcertificationsinthisfile'] = 'Selecionar todas as certificações neste arquivo';
$string['selectatleastonecertification'] = 'Selecione pelo menos uma certificação';
$string['selectcertificationcondition'] = 'Certificação';
$string['selectcertificationcondition_help'] = 'Selecione a certificação onde essa condição será aplicada';
$string['selectcertificationoutcome'] = 'Certificação';
$string['selectcertificationoutcome_help'] = 'Selecione a certificação onde esta ação será aplicada';
$string['selectcertificationstoallocate'] = 'Certificações';
$string['selectdate'] = 'Selecionar a data';
$string['selectmanually'] = 'Selecionar manualmente...';
$string['selectprogram'] = 'Selecionar o programa';
$string['selectprogram_help'] = 'Selecionar um programa a ser associado a esta certificação';
$string['separatetenantsingroupswarning'] = 'Nos cursos compartilhados entre os tenants, os usuários de cada tenant serão adicionados a grupos separados.';
$string['startdate'] = 'Data de início';
$string['startdate_help'] = 'Data em que a certificação começa';
$string['status'] = 'Estado';
$string['suspended'] = 'Suspensa';
$string['suspendeddateisonorafter'] = 'Data de suspensão a partir de';
$string['system'] = 'Sistema';
$string['tagarea_tool_certification'] = 'Certificações';
$string['tags'] = 'Marcadores';
$string['timecreated'] = 'Criado em';
$string['timemodified'] = 'Modificado pela última vez em';
$string['timesuspended'] = 'Suspenso em';
$string['toomanycertificationstoshow'] = 'Muitas certificações para mostrar';
$string['uponcompletion'] = 'Após a conclusão';
$string['userallocation'] = 'Alocação de usuário';
$string['usercompletion'] = 'Conclusão do usuário';
$string['userduedate'] = 'Data de entrega';
$string['userduedate_help'] = 'Selecione a data de entrega da certificação para este usuário.';
$string['usergotsuspended'] = 'Usuário foi suspenso';
$string['users'] = 'Usuários';
$string['usersallocationnotavailable'] = 'A alocação de usuários não está disponível';
$string['userstartdate'] = 'Data de início';
$string['userstartdate_help'] = 'Selecione a data em que este usuário poderá iniciar a certificação. Esta data será aplicada apenas a este usuário.';
$string['userstatus'] = 'Estado';
$string['userstatus_help'] = 'O estado suspenso oculta essa certificação para esse usuário, enquanto o estado Padrão irá mostrá-la.';
$string['viewcertificationuserlog'] = 'Log de atividades de certificação';
