<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'wiki', language 'ja', version '3.11'.
 *
 * @package     wiki
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'コメントを追加する';
$string['addedbegins'] = '追加開始';
$string['addedends'] = '追加終了';
$string['admin'] = '管理';
$string['adminmenu'] = '管理メニュー';
$string['attachmentattach'] = '添付として追加する';
$string['attachmentimage'] = 'イメージとして追加する';
$string['attachmentlink'] = 'リンクとして追加する';
$string['attachments'] = '添付';
$string['backcomments'] = 'コメントに戻る';
$string['backhistory'] = '履歴に戻る';
$string['backoldversion'] = '古いバージョンに戻る';
$string['backpage'] = 'ページに戻る';
$string['backtomapmenu'] = 'マップメニューに戻る';
$string['cannotcomparenewerversion'] = 'ページのバージョンは古いバージョンとのみ比較することができます。';
$string['cannoteditpage'] = 'あなたはこのページを編集できません。';
$string['cannotmanagefiles'] = 'あなたにはWikiファイルを管理するためのパーミッションがありません。';
$string['cannotviewfiles'] = 'あなたにはWikiファイルを閲覧するためのパーミッションがありません。';
$string['cannotviewpage'] = 'あなたはこのページを閲覧できません。';
$string['changerate'] = '変更してもよろしいですか?';
$string['comments'] = 'コメント';
$string['commentscount'] = 'コメント ({$a})';
$string['comparesel'] = '選択したものを比較する';
$string['comparewith'] = 'バージョン {$a->old} をバージョン {$a->new} と比較する';
$string['contributions'] = '寄稿';
$string['contributions_help'] = 'あなたが編集したページの一覧です。';
$string['createcomment'] = 'コメントを作成する';
$string['createddate'] = '作成日時: {$a->date} by {$a->username}';
$string['createpage'] = 'ページを作成する';
$string['creating'] = 'Wikiページを作成する';
$string['creole'] = 'クレオール';
$string['defaultformat'] = 'デフォルトフォーマット';
$string['defaultformat_help'] = 'この設定ではWikiページの編集時に使用するデフォルトフォーマットを決定します。

* HTML - HTMLエディタを使用できます。
* クレオール - 小さな編集ツールバーの一般的なWikiマークアップ言語を使用できます。
* Nwiki - Nwikiモジュールで使用されるMediawikiのようなマークアップ言語です。';
$string['deleteallpages'] = 'すべてのWikiページを削除する';
$string['deletecomment'] = 'コメントを削除する';
$string['deletecommentcheck'] = 'コメントを削除する';
$string['deletecommentcheckfull'] = '本当にコメントを削除してもよろしいですか?';
$string['deletedbegins'] = '削除開始';
$string['deletedends'] = '削除終了';
$string['deleteupload'] = '削除';
$string['deleteversions'] = 'ページバージョンを削除する';
$string['diff'] = 'Diff';
$string['diff_help'] = '差異を確認するため選択したバージョンのページを比較することができます。';
$string['edit'] = '編集';
$string['editblocks'] = 'ブロック編集モードの開始';
$string['editcomment'] = 'コメントを編集する';
$string['editfiles'] = 'Wikiファイルを編集する';
$string['editing'] = 'Wikiページを編集する';
$string['editingcomment'] = 'コメントを編集する';
$string['editingpage'] = 'このページ「 {$a} 」を編集する';
$string['editsection'] = '編集';
$string['eventdiffviewed'] = 'Wiki diffが閲覧されました。';
$string['eventhistoryviewed'] = 'Wiki履歴が閲覧されました。';
$string['eventmapviewed'] = 'Wikiページマップが閲覧されました。';
$string['eventpagecreated'] = 'Wikiページが作成されました。';
$string['eventpagedeleted'] = 'Wikiページが削除されました。';
$string['eventpagelocksdeleted'] = 'Wikiページロックが削除されました。';
$string['eventpageupdated'] = 'Wikiページが更新されました。';
$string['eventpageversiondeleted'] = 'Wikiページバージョンが削除されました。';
$string['eventpageviewed'] = 'Wikiページが閲覧されました。';
$string['eventversionrestored'] = 'Wikiバージョンがリストアされました。';
$string['eventversionviewed'] = 'Wikiページバージョンが閲覧されました。';
$string['filenotuploadederror'] = 'ファイル「 {$a} 」を正常にアップロードできませんでした。';
$string['files'] = 'ファイル';
$string['filtername'] = 'Wikiオートリンク';
$string['firstpagetitle'] = '先頭ページ名';
$string['firstpagetitle_help'] = 'Wikiの先頭ページのタイトルです。Wikiを作成した場合、タイトルを変更できないようになります。';
$string['forceformat'] = 'フォーマットを強制する';
$string['forceformat_help'] = 'フォーマットが強制 (チェックボックスをチェック) された場合、Wikiページの編集時にフォーマットを選択するオプションは表示されません。';
$string['format'] = 'フォーマット';
$string['format_help'] = '* HTML - HTMLエディタを使用できます。
* クレオール - 小さな編集ツールバーを持った一般的なWikiマークアップ言語を使用できます。
* Nwiki - Nwikiモジュールで使用されるMediawikiのようなマークアップ言語です。';
$string['formatcreole'] = 'クレオールフォーマット';
$string['formatcreole_help'] = 'クレオールフォーマットは適切なマークアップを挿入するための編集ツールバーを持った一般的なWIkiマークアップ言語です。

新しいページを作成するには例えば [[ページ2 ]] のように2重角括弧で閉じたページ名を入力してください。';
$string['formatcreole_link'] = 'mod/wiki/creole';
$string['formathtml'] = 'HTMLフォーマット';
$string['formathtml_help'] = 'HTMLエディタはコンテンツのフォーマットに使用することができます。

新しいページを作成するには例えば [[ページ2 ]] のように2重角括弧で閉じられたページ名を入力します。';
$string['formatnwiki'] = 'NWiki フォーマット';
$string['formatnwiki_help'] = 'NwikiはNwikiモジュール内で使用されるMediawikiのようなマークアップ言語です。

新しいページを作成するには例えば [[ページ2 ]] のように2重角括弧で閉じたページ名を入力します。';
$string['formatnwiki_link'] = 'mod/wiki/nwiki';
$string['history'] = '履歴';
$string['history_help'] = '前のバージョンのページの履歴一覧リンクです。';
$string['html'] = 'HTML';
$string['incorrectdeleteversions'] = '削除するために提供されたページバージョンが正しくありません。';
$string['incorrectpageid'] = 'ページIDが正しくありません。';
$string['incorrectsubwikiid'] = 'Subwiki IDが正しくありません。';
$string['incorrectwikiid'] = 'Wiki IDが正しくありません。';
$string['indicator:cognitivedepth'] = 'Wiki認知的';
$string['indicator:cognitivedepth_help'] = 'この指標はWiki活動で学生が到達した認識深度に基づきます。';
$string['indicator:cognitivedepthdef'] = 'Wiki認知的';
$string['indicator:cognitivedepthdef_help'] = 'この分析間隔中、参加者がWiki活動から提供された認知的関与のこのパーセンテージに到達しました (レベル = 閲覧なし, 閲覧, 送信)。';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Wiki社会的';
$string['indicator:socialbreadth_help'] = 'この指標はWiki活動で学生が到達した社会的広がりに基づきます。';
$string['indicator:socialbreadthdef'] = 'Wiki社会的';
$string['indicator:socialbreadthdef_help'] = 'この分析間隔中、参加者がWiki活動から提供された社会的関与のこのパーセンテージに到達しました (レベル = 参加なし, 個人で参加, 他の人と参加)。';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['individualpagedoesnotexist'] = '個人Wikiページは存在していません。';
$string['insertcomment'] = 'コメントを追加する';
$string['insertimage'] = 'イメージを挿入する ...';
$string['insertimage_help'] = 'ドロップダウンリストによりイメージをWikiエディタに追加することができます。あなたがさらにイメージを追加したい場合、「ファイル」タブを使用してください。';
$string['invalidlock'] = 'このページは別のユーザにすでにロックされています。';
$string['invalidparameters'] = '無効なパラメータが渡されました。';
$string['invalidsection'] = 'セクションが正しくありません。';
$string['invalidsesskey'] = '恐らく、あなたのセッションはタイムアウトしたようです。あなたの編集を書き留めて再度ログインしてください。';
$string['javascriptdisabledlocks'] = 'あなたのブラウザのJavaScriptが無効にされているためロックが動作していません。あなたの変更は正常に保存されない可能性があります。';
$string['links'] = 'リンク';
$string['listall'] = 'すべてを一覧表示する';
$string['listorphan'] = '迷子ページを一覧表示する';
$string['lockingajaxtimeout'] = 'ページロックのリフレッシュタイムを編集する';
$string['lockingtimeout'] = 'ロックタイムアウト';
$string['map'] = 'マップ';
$string['mapmenu'] = 'マップメニュー';
$string['migrationfinished'] = '移行が正常に完了しました。';
$string['migrationfinishednowikis'] = '移行が完了しました。移行されたWikiはありません。';
$string['missingpages'] = 'コンテンツなしページ';
$string['modified'] = '修正日時';
$string['modulename'] = 'Wiki';
$string['modulename_help'] = 'Wiki活動モジュールでは参加者が一群のウェブページを追加および編集することができます。Wikiは個人または誰でも編集できる協力的な場です。誰でも自分たちだけが編集できる自分のWikiを持つことができます。

それぞれのページの編集履歴は保持されます。それぞれの参加者によって編集された内容が一覧表示されます。

Wikiは次のように使用することができます:

* グループ講義ノートまたは学習ガイドとして
* 学科メンバのために作業スキームの計画または会議の議題用として
* 学生が共同でオンラインブックの著者となり教師から設定された主題に関するコンテンツを作成するため
* それぞれの参加者が行または節を執筆しながら共同で物語または詩を作成するため
* 試験ノートのための個人日誌または試験対策として (個人Wikiを使用)';
$string['modulename_link'] = 'mod/wiki/view';
$string['modulenameplural'] = 'Wiki';
$string['navigation'] = 'ナビゲーション';
$string['navigationfrom'] = 'このページのリンク元';
$string['navigationfrom_help'] = 'このページへのWikiページリンク';
$string['navigationto'] = 'このページのリンク先';
$string['navigationto_help'] = '他のページへのリンク';
$string['newpage'] = '新しいページ';
$string['newpagehdr'] = '新しいページ';
$string['newpagetitle'] = '新しいページタイトル';
$string['noattachments'] = '<strong>ファイル添付なし</strong>';
$string['nocomments'] = 'コメントはありません。';
$string['nocontent'] = 'このページにはコンテンツがありません。';
$string['nocontribs'] = 'あなたはこのWikiに寄稿していません。';
$string['nocreatepermission'] = 'ページ作成のパーミッションが必要です。';
$string['noeditcommentpermission'] = 'コメント編集のパーミッションが必要です。';
$string['noeditpermission'] = 'ページ編集のパーミッションが必要です。';
$string['nofrompages'] = 'このページへのリンクはありません。';
$string['nohistory'] = 'このページの履歴はありません。';
$string['nomanagecommentpermission'] = 'コメント管理のパーミッションが必要です。';
$string['nomanagewikipermission'] = 'Wiki管理のパーミッションが必要です。';
$string['noorphanedpages'] = '迷子ページはありません。';
$string['nooverridelockpermission'] = 'ロックをオーバーライドするためのパーミッションが必要です。';
$string['norated'] = 'このページはまだ評価されていません、最初に評価してください!';
$string['norating'] = '評価なし';
$string['nosearchresults'] = '該当なし';
$string['noteditblocks'] = 'ブロック編集モードの終了';
$string['notingroup'] = 'グループ外';
$string['notmigrated'] = 'このWikiはまだ移行されていません。あなたの管理者にご連絡ください。';
$string['notopages'] = 'このページは他のページにリンクしていません。';
$string['noupdatedpages'] = '更新ページはありません。';
$string['noviewcommentpermission'] = 'コメント閲覧のパーミッションが必要です。';
$string['noviewpagepermission'] = 'ページ閲覧のパーミッションが必要です。';
$string['nwiki'] = 'NWiki';
$string['oldversion'] = '古いバージョン';
$string['orphaned'] = '迷子ページ';
$string['orphaned_help'] = '他のページからリンクされていないページを一覧表示します。';
$string['overridelocks'] = 'ロックをオーバーライドする';
$string['overridinglocks'] = 'ロックのオーバーライド ...';
$string['page-mod-wiki-comments'] = 'Wikiモジュールコメントページ';
$string['page-mod-wiki-history'] = 'Wiki履歴ページ';
$string['page-mod-wiki-map'] = 'Wikiマップページ';
$string['page-mod-wiki-view'] = 'Wikiモジュールメインページ';
$string['page-mod-wiki-x'] = 'すべてのWikiモジュールページ';
$string['pageexists'] = 'このページはすでに存在します。';
$string['pageindex'] = 'ページインデックス';
$string['pageindex_help'] = 'このWikiのページツリー';
$string['pageislocked'] = '現在、誰かがこのページを編集しています。数分後に編集をお試しください。';
$string['pagelist'] = 'ページ一覧';
$string['pagelist_help'] = 'アルファベット順のページ一覧';
$string['pagename'] = 'ページ名';
$string['peerreview'] = 'ピアレビュー';
$string['pluginadministration'] = 'Wiki管理';
$string['pluginname'] = 'Wiki';
$string['prettyprint'] = 'プリンタフレンドリーバージョン';
$string['previewwarning'] = 'これはプレビューページです。まだ変更は保存されていません。';
$string['print'] = '印刷';
$string['privacy:metadata:core_comment'] = 'Wikiページのコメントです。';
$string['privacy:metadata:core_files'] = 'サブWikiに添付されたファイルです。';
$string['privacy:metadata:core_tag'] = 'Wikiページに関連するタグです。';
$string['privacy:metadata:wiki_locks'] = 'Wiki編集ロックの一時保存です。';
$string['privacy:metadata:wiki_locks:lockedat'] = 'ロックされた日時です。';
$string['privacy:metadata:wiki_locks:sectionname'] = 'ロックされたーページセクション名です。';
$string['privacy:metadata:wiki_locks:userid'] = 'ページをロックしたユーザです。';
$string['privacy:metadata:wiki_pages'] = 'Wikiページに関する情報です。';
$string['privacy:metadata:wiki_pages:cachedcontent'] = 'HTMLフォーマットのキャッシュコンテンツです。';
$string['privacy:metadata:wiki_pages:pageviews'] = 'ページが閲覧された回数です。';
$string['privacy:metadata:wiki_pages:readonly'] = 'ページがリードオンリーであるか示します';
$string['privacy:metadata:wiki_pages:timecreated'] = 'ページの初回作成日時です。';
$string['privacy:metadata:wiki_pages:timemodified'] = 'ページの最終更新日時です。';
$string['privacy:metadata:wiki_pages:timerendered'] = 'ページの最終表示日時です。';
$string['privacy:metadata:wiki_pages:title'] = 'ページ名です。';
$string['privacy:metadata:wiki_pages:userid'] = '最後にページを修正したユーザです。';
$string['privacy:metadata:wiki_subwikis'] = 'サブWikiに関する情報です (グループまたは個人モードの場合)。';
$string['privacy:metadata:wiki_subwikis:groupid'] = 'サブWikiを所有するグループです。';
$string['privacy:metadata:wiki_subwikis:userid'] = 'サブWikiを所有するユーザです (個人Wiki)。';
$string['privacy:metadata:wiki_versions'] = 'Wikiページ履歴に関する情報です。';
$string['privacy:metadata:wiki_versions:content'] = '改訂版コンテンツ';
$string['privacy:metadata:wiki_versions:contentformat'] = '改訂版コンテンツフォーマット';
$string['privacy:metadata:wiki_versions:timecreated'] = '改訂版が作成された日時です。';
$string['privacy:metadata:wiki_versions:userid'] = '改訂版を作成したユーザです。';
$string['privacy:metadata:wiki_versions:version'] = 'バージョンナンバーです。';
$string['rated'] = 'このページに対するあなたの評価: {$a}';
$string['rating'] = '評価';
$string['ratingmode'] = '評価モード';
$string['removeallwikitags'] = 'すべてのWikiタグを削除する';
$string['removepages'] = 'ページを削除する';
$string['reparsetimeout'] = '再解析デフォルトタイムアウト';
$string['repeatedsection'] = 'Wikiエラー: セクション名を繰り返すことはできません ( {$a} )。';
$string['restore'] = 'リストア';
$string['restoreconfirm'] = '本当にバージョン #{$a} をリストアしてもよろしいですか?';
$string['restoreerror'] = 'バージョン #{$a} をリストアすることができませんでした。';
$string['restorethis'] = 'このバージョンをリストアする';
$string['restoreversion'] = '古いバージョンをリストアする';
$string['restoring'] = 'バージョン #{$a} へのリストア';
$string['return'] = '戻る';
$string['save'] = '保存';
$string['saving'] = 'Wikiページの保存';
$string['savingerror'] = '保存エラー';
$string['search:activity'] = 'Wiki - 活動情報';
$string['search:collaborative_page'] = 'Wikiページ - 共同ページ';
$string['searchcontent'] = 'ページコンテクスト内を検索する';
$string['searchresult'] = '検索結果:';
$string['searchterms'] = '検索語';
$string['searchwikis'] = 'Wikiを検索する';
$string['special'] = '特別';
$string['tableofcontents'] = '目次';
$string['tagarea_wiki_pages'] = 'Wikiページ';
$string['tagsdeleted'] = 'Wikiタグが削除されました。';
$string['teacherrating'] = '教師の評価';
$string['timesrating'] = 'このページは {$a->c} 回評価されました。評価平均は {$a->s} です。';
$string['updatedpages'] = '更新されたページ';
$string['updatedpages_help'] = '最近更新されたWikiページ';
$string['updatedwikipages'] = '更新されたWikiページ';
$string['upload'] = 'アップロード & 削除';
$string['uploadactions'] = '操作';
$string['uploadfiletitle'] = '添付';
$string['uploadname'] = 'ファイル名';
$string['uploadtitle'] = '添付ファイル';
$string['version'] = 'バージョン';
$string['versionerror'] = 'バージョンIDは存在しません。';
$string['versionnum'] = 'バージョン #{$a}';
$string['view'] = '表示';
$string['viewallhistory'] = 'すべての履歴を表示する';
$string['viewcurrent'] = '現在のバージョン';
$string['viewperpage'] = '1ページあたり {$a} バージョンを表示する';
$string['viewversion'] = 'バージョン #{$a} のページを表示中';
$string['wiki'] = 'Wiki';
$string['wiki:addinstance'] = '新しいWikiを追加する';
$string['wiki:createpage'] = '新しいWIkiページを作成する';
$string['wiki:editcomment'] = 'コメントをページに追加する';
$string['wiki:editpage'] = 'Wikiページを編集する';
$string['wiki:managecomment'] = 'Wikiコメントを管理する';
$string['wiki:managefiles'] = 'Wikiファイルを管理する';
$string['wiki:managewiki'] = 'Wiki設定を管理する';
$string['wiki:overridelock'] = 'Wikiロックをオーバーライドする';
$string['wiki:viewcomment'] = 'ページコメントを表示する';
$string['wiki:viewpage'] = 'Wikiページを表示する';
$string['wikiattachments'] = 'Wiki添付';
$string['wikiboldtext'] = '太字テキスト';
$string['wikiexternalurl'] = '外部URL';
$string['wikifiles'] = 'Wikiファイル';
$string['wikifiletable'] = 'アップロード済みファイル一覧';
$string['wikiheader'] = 'レベル {$a} ヘッダ';
$string['wikihr'] = '水平線';
$string['wikiimage'] = 'イメージ';
$string['wikiinternalurl'] = '内部リンク';
$string['wikiintro'] = '説明';
$string['wikiitalictext'] = 'イタリック文字';
$string['wikilockingsettings'] = 'ロックおよび再解析タイムアウト';
$string['wikimode'] = 'Wikiモード';
$string['wikimode_help'] = 'WikiモードではすべてのユーザがWikiを編集できる「共同Wiki」またはユーザのみ自分のWikiを編集できる「個人Wiki」を決定します。';
$string['wikimodecollaborative'] = '共同Wiki';
$string['wikimodeindividual'] = '個人Wiki';
$string['wikiname'] = 'Wiki名';
$string['wikinowikitext'] = '非Wikiテキスト';
$string['wikiorderedlist'] = '順序付きリスト';
$string['wikipages'] = 'Wikiページ';
$string['wikisettings'] = 'Wiki設定';
$string['wikiunorderedlist'] = '番号なしリスト';
$string['wrongversionlock'] = 'あなたが編集している間、別のユーザがこのページを編集しました。そのため、あなたのコンテンツは古くなりました。';
$string['wrongversionsave'] = 'あなたが編集している間、別のユーザが新しいバージョンを作成しました。そのため、あなたはそのユーザのバージョンを上書きしたことになります。ページ履歴をご確認ください。';
