<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'ja', version '3.11'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'すべてのコースを閲覧する';
$string['addon.block_myoverview.nocoursesenrolled'] = 'あなたはまだどのコースにも登録していません。';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = '以下の利用可能なコースを閲覧して学習を始めてください。';
$string['addon.block_myoverview.noresult'] = 'あなたの検索条件に一致するコースはありません。';
$string['addon.block_myoverview.noresultdescription'] = 'あなたのフィルタを調整するか、以下のすべてのコースを閲覧してください。';
$string['addon.blog.errorloadentries'] = 'ブログエントリの読み込み中にエラーが発生しました。';
$string['addon.blog.showonlyyourentries'] = 'あなたのエントリのみ表示する';
$string['addon.calendar.calendarevent'] = 'カレンダーイベント';
$string['addon.calendar.calendarevents'] = 'カレンダーイベント';
$string['addon.calendar.calendarreminders'] = 'カレンダーリマインダ';
$string['addon.calendar.currentmonth'] = '今月';
$string['addon.calendar.defaultnotificationtime'] = 'デフォルト通知時間';
$string['addon.calendar.errorloadevent'] = 'イベントの読み込み時にエラーがありました。';
$string['addon.calendar.errorloadevents'] = 'イベントの読み込み時にエラーがありました。';
$string['addon.calendar.noevents'] = 'イベントはありません';
$string['addon.calendar.reminders'] = 'リマインダ';
$string['addon.calendar.setnewreminder'] = '新しいリマインダを設定する';
$string['addon.calendar.timebefore'] = '{{value}} {{units}} 前';
$string['addon.competency.errornocompetenciesfound'] = 'コンピテンシーが見つかりません';
$string['addon.competency.nocompetencies'] = 'コンピテンシーなし';
$string['addon.coursecompletion.complete'] = '完了';
$string['addon.coursecompletion.couldnotloadreport'] = 'コース完了の読み込みができませんでした。後でもう一度お試しください。';
$string['addon.enrol_self.confirmselfenrol'] = '本当にこのコースにあなたを登録しますか?';
$string['addon.enrol_self.errorselfenrol'] = '自己登録中にエラーが発生しました。';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'デバイスの設定';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'あなたのユーザはこのサイトの通知をモバイルデバイスで受信していません。通知設定ページでモバイル通知を有効にしてください。';
$string['addon.messages.contactlistempty'] = '連絡先リストが空';
$string['addon.messages.contactname'] = '連絡先名称';
$string['addon.messages.deletemessage'] = 'メッセージを削除する';
$string['addon.messages.deletemessageconfirmation'] = '本当にこのメッセージを削除してもよろしいですか? このメッセージはあなたのメッセージ履歴からのみ削除されます。メッセージを送信または受信したユーザは引き続き閲覧できます。';
$string['addon.messages.errordeletemessage'] = 'メッセージ消去中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingcontacts'] = 'サーバから連絡先を取得中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'サーバからディスカッションを受信中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingmessages'] = 'サーバからメッセージを受信中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingusers'] = 'サーバからユーザの検索中にエラーが発生しました。';
$string['addon.messages.messagenotsent'] = 'メッセージは送信されませんでした。後でもう一度お試しください。';
$string['addon.messages.newmessages'] = '新規メッセージ...';
$string['addon.messages.nousersfound'] = 'ユーザが見つかりません';
$string['addon.messages.showdeletemessages'] = 'メッセージの削除を表示する';
$string['addon.messages.type_blocked'] = 'ブロックされています';
$string['addon.messages.type_offline'] = 'オフライン';
$string['addon.messages.type_online'] = 'オンライン';
$string['addon.messages.type_search'] = '結果の検索';
$string['addon.messages.type_strangers'] = 'その他';
$string['addon.messages.useentertosenddescdesktop'] = '無効にした場合、あなたは「Ctrl+Enter」でメッセージを送信できます。';
$string['addon.messages.useentertosenddescmac'] = '無効にした場合、あなたは「Cmd+Enter」でメッセージを送信できます。';
$string['addon.messages.warningconversationmessagenotsent'] = '会話 {{conversation}} にメッセージを送信できませんでした。{{error}}';
$string['addon.messages.warningmessagenotsent'] = 'ユーザ {{user}} へのメッセージ送信ができませんでした。 {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = '提出時宣誓文を受諾してください。';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = '課題詳細および提出フォームは<strong>{{$a}}</strong>から利用できます。';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'この課題は<strong>{{$a}}</strong>から提出を受け付けます。';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'サイトから提出時宣誓文を取得することができなかったため、アプリでは提出物の追加や編集ができません。';
$string['addon.mod_assign.cannotgradefromapp'] = '評定方法にアプリでは未サポートあるいは変更できないものがあります。';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'サイトから提出時宣誓文が取得できなかったため、アプリから評定を提出することができませんでした。';
$string['addon.mod_assign.duedateno'] = '期限なし';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = '提出物の編集がサポートされていないプラグインがあるため、アプリから提出物の追加や編集ができませんでした。';
$string['addon.mod_assign.errorshowinginformation'] = '提出物の情報を表示できません。';
$string['addon.mod_assign.feedbacknotsupported'] = 'このフィードバックはアプリでは未サポートのため、すべての情報が含まれていない可能性があります';
$string['addon.mod_assign.gradenotsynced'] = '評定が同期できませんでした';
$string['addon.mod_assign.notallparticipantsareshown'] = '提出物のない参加者は表示されていません';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = '{{count}} 件の下書きがあります。';
$string['addon.mod_assign.numberofparticipantscountdescription'] = '{{count}} 名の参加者がいます。';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = '評定が必要な {{count}} 件の提出があります。';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = '{{count}} 件の提出済み課題があります。';
$string['addon.mod_assign.numberofteamscountdescription'] = '{{count}} 組のチームがあります。';
$string['addon.mod_assign.submissionnotsupported'] = 'この提出物はアプリでは未サポートのため、すべての情報が含まれていない可能性があります';
$string['addon.mod_assign.syncblockedusercomponent'] = 'ユーザ評定';
$string['addon.mod_assign.warningsubmissiongrademodified'] = '提出物の評定がサイト上で変更されました。';
$string['addon.mod_assign.warningsubmissionmodified'] = 'ユーザの提出物がサイト上で変更されました。';
$string['addon.mod_chat.confirmloss'] = '本当によろしいですか? チャット履歴を失うことになります。';
$string['addon.mod_chat.errorwhileconnecting'] = 'チャットに接続する際にエラーが発生しました。';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'チャットのデータを取得中にエラーが発生しました。';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'チャットのユーザを取得中にエラーが発生しました。';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'サーバからメッセージを取得中にエラーが発生しました。';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'メッセージ送信中にエラーが発生しました。';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'メッセージを送信するにはオンラインでなければなりません。';
$string['addon.mod_chat.nosessionsfound'] = 'セッションは見つかりませんでした。';
$string['addon.mod_chat.showincompletesessions'] = '未完了のセッションを表示する';
$string['addon.mod_choice.errorgetchoice'] = '選択データの取得中にエラーが発生しました。';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% のユーザが選択肢: {{text}} を選択しました。';
$string['addon.mod_choice.resultsnotsynced'] = '結果にあなたの最後のレスポンスが含まれていません。更新のため、同期を行ってください。';
$string['addon.mod_data.edittagsnotsupported'] = '申し訳ございません、アプリではタグの編集はサポートされていません。';
$string['addon.mod_data.errorapproving'] = 'エントリの承認または不承認中にエラーが発生しました。';
$string['addon.mod_data.errordeleting'] = 'エントリの削除中にエラーが発生しました。';
$string['addon.mod_data.gettinglocation'] = 'ロケーションを取得する';
$string['addon.mod_data.locationnotenabled'] = 'ロケーションは有効にされていません。';
$string['addon.mod_data.locationpermissiondenied'] = 'あなたのロケーションへのアクセスが拒否されました。';
$string['addon.mod_data.mylocation'] = 'マイロケーション';
$string['addon.mod_data.searchbytagsnotsupported'] = '申し訳ございません、アプリではタグの検索はサポートされていません。';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Capchaつきのフィードバックは、未設定の場合、オフラインモードの場合、サーバがダウンしている場合には完了できません。';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = '{{count}} 件の送信済み回答があります。';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'このフィードバックを、あとで提出するために保存しました。';
$string['addon.mod_feedback.questionscountdescription'] = '{{count}} 件の質問があります。';
$string['addon.mod_folder.emptyfilelist'] = '表示するファイルがありません。';
$string['addon.mod_forum.errorgetforum'] = 'フォーラムのデータ取得中にエラーが発生しました。';
$string['addon.mod_forum.errorgetgroups'] = 'グループ設定の取得中にエラーが発生しました。';
$string['addon.mod_forum.errorloadingsortingorder'] = 'この並び順ではフォーラムは使用できません。';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'フォーラムを見るには、並び順を変更するか、インターネットに接続してください。';
$string['addon.mod_forum.errorposttoallgroups'] = 'すべてのグループで新しいディスカッションを作成できませんでした。';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'このフォーラムにはまだディスカッショントピックがありません';
$string['addon.mod_forum.group'] = 'グループ';
$string['addon.mod_forum.numdiscussions'] = 'ディスカッション数 {{numdiscussions}}';
$string['addon.mod_forum.numreplies'] = '返信数 {{numreplies}}';
$string['addon.mod_forum.postingroup'] = '{{groupname}}に投稿しています。';
$string['addon.mod_forum.refreshposts'] = 'ディスカッション投稿をリフレッシュ';
$string['addon.mod_glossary.browsemode'] = 'エントリをブラウズ';
$string['addon.mod_glossary.byalphabet'] = 'アルファベット順';
$string['addon.mod_glossary.byauthor'] = '著者でグループ';
$string['addon.mod_glossary.bycategory'] = 'カテゴリでグループ';
$string['addon.mod_glossary.bynewestfirst'] = '新規順';
$string['addon.mod_glossary.byrecentlyupdated'] = '最近の更新';
$string['addon.mod_glossary.bysearch'] = '検索';
$string['addon.mod_glossary.cannoteditentry'] = 'エントリの編集ができませんでした';
$string['addon.mod_glossary.entriestobesynced'] = 'エントリの同期ができませんでした';
$string['addon.mod_glossary.entrypendingapproval'] = 'このエントリは承認待ちです。';
$string['addon.mod_glossary.errordeleting'] = 'エントリの削除中にエラーが発生しました。';
$string['addon.mod_glossary.errorloadingentries'] = 'エントリ読み込み中にエラーが発生しました。';
$string['addon.mod_glossary.errorloadingentry'] = 'エントリ読み込み中にエラーが発生しました。';
$string['addon.mod_glossary.errorloadingglossary'] = '用語集を読み込み中にエラーが発生しました。';
$string['addon.mod_glossary.noentriesfound'] = 'エントリが見つかりませんでした。';
$string['addon.mod_glossary.searchquery'] = '検索内容';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'H5Pファイルをダウンロードする';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'H5P活動データの取得中にエラーが発生しました。';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5Pパッケージはダウンロードされていません。あなたがH5Pパッケージを使用するにはダウンロードする必要があります。';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5Pパッケージは前回ダウンロード後に修正されています。使用するにはあなたは再度ダウンロードする必要があります。';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'あなたがH5Pパッケージを表示するにはオンラインにする必要があります。';
$string['addon.mod_h5pactivity.viewattempt'] = '受験を表示する {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = '説明の表示';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'このレッスンにはランダムなコンテンツページへのジャンプが含まれています。ウェブブラウザで起動するまでアプリでは受験できません。';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'この回答は、別の回答が完了しているため評価できません。';
$string['addon.mod_lesson.finishretakeoffline'] = 'この回答はオフライン状態で完了しました。';
$string['addon.mod_lesson.retakefinishedinsync'] = 'オフラインの回答が同期されました。評価しますか？';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = '回答はサイト内で完了しました。';
$string['addon.mod_lti.errorgetlti'] = 'モジュールデータ取得中にエラーが発生しました。';
$string['addon.mod_lti.errorinvalidlaunchurl'] = '起動するURLが不正です。';
$string['addon.mod_lti.launchactivity'] = 'アクティビティを起動';
$string['addon.mod_page.errorwhileloadingthepage'] = 'ページ内容を読み込み中にエラーが発生しました。';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'この小テストはアプリでも受験できますが、あなたは次の理由でブラウザでの受験の送信が必要です:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'このクイズの回答は、以下の理由で提出できませんでした：';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'この回答は、理由「 {{$a}} 」により、同期できませんでした。もしあなたが別のデバイスで回答を続けていた場合、データが失われている可能性があります。';
$string['addon.mod_quiz.confirmleavequizonerror'] = '回答の保存中にエラーが発生しました。クイズを終了してもよいですか？';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'このクイズは、アプリでサポートされていない動作が含まれているため回答することができません。';
$string['addon.mod_quiz.errordownloading'] = '必要なデータのダウンロード中にエラーが発生しました。';
$string['addon.mod_quiz.errorgetattempt'] = '回答データの取得中にエラーが発生しました。';
$string['addon.mod_quiz.errorgetquestions'] = '質問の取得中にエラーが発生しました。';
$string['addon.mod_quiz.errorgetquiz'] = 'クイズデータの取得中にエラーが発生しました。';
$string['addon.mod_quiz.errorparsequestions'] = '質問の読み込み中にエラーが発生しました。Webブラウザからこのクイズに回答してください。';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'この小テストにはアプリでサポートされない問題を含むため解答ができません。';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'このクイズは、アプリでサポートされていないアクセスルールがあるため回答することができません。';
$string['addon.mod_quiz.errorsaveattempt'] = '回答データの保存中にエラーが発生しました。';
$string['addon.mod_quiz.finishnotsynced'] = '完了しましたが同期されていません。';
$string['addon.mod_quiz.opentoc'] = 'ナビゲーションポップオーバーを開いてください。';
$string['addon.mod_quiz.warningattemptfinished'] = 'オフラインの回答は、サイト上で完了していた、もしくは見当たらなかったため廃棄されました。';
$string['addon.mod_quiz.warningdatadiscarded'] = '質問文がオンラインで変更されたため、一部のオフライン回答が廃棄されました。';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'オフライン回答が廃棄されたため、回答が完了していません。回答内容を確認し、回答を再度提出してください。';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'この小テストはアプリでサポートされていない問題を含みます:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = '内容を読み込み中にエラーが発生しました。';
$string['addon.mod_resource.openthefile'] = '開く';
$string['addon.mod_resource.resourcestatusoutdated'] = 'このファイルはあなたが前回開いた時点から変更されています。';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'このファイルには新しいバージョンがあります。確認するにはあなたのデバイスをインターネットに接続してください。';
$string['addon.mod_scorm.cannotcalculategrade'] = '評定が計算できませんでした。';
$string['addon.mod_scorm.dataattemptshown'] = 'このデータは回答番号 {{number}} に該当します。';
$string['addon.mod_scorm.errorcreateofflineattempt'] = '新たなオフライン回答の作成中にエラーが発生しました。再度実行してください。';
$string['addon.mod_scorm.errordownloadscorm'] = 'SCORM "{{name}}" のダウンロード中にエラーが発生しました。';
$string['addon.mod_scorm.errorgetscorm'] = 'SCORMデータの取得中にエラーが発生しました。';
$string['addon.mod_scorm.errorinvalidversion'] = '申し訳ありません。アプリケーションはSCORM 1.2のみをサポートしています。';
$string['addon.mod_scorm.errornotdownloadable'] = 'あなたのMoodleサイトではSCORMパッケージのダウンロードができません。Moodleサイト管理者に連絡してください。';
$string['addon.mod_scorm.errornovalidsco'] = 'このSCORMはロードに必要な表示できるSCOがありません。';
$string['addon.mod_scorm.errorpackagefile'] = '申し訳ありません。アプリケーションはZIPパッケージのみをサポートしています。';
$string['addon.mod_scorm.errorsyncscorm'] = '同期中にエラーが発生しました。再度実行してください。';
$string['addon.mod_scorm.offlineattemptnote'] = 'この回答には動悸されなかったデータがあります。';
$string['addon.mod_scorm.offlineattemptovermax'] = '受験可能回数を超えたため、この回答を送信できません。';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'このSCORMはダウンロードされていません。これを開くときに、自動的にダウンロードされます。';
$string['addon.mod_scorm.scormstatusoutdated'] = 'このSCORMは最後にダウンロードされた後に更新されています。開くときに、自動的に新しいものがダウンロードされます。';
$string['addon.mod_scorm.warningofflinedatadeleted'] = '回答番号 {{number}} を新しい回答として作成することができなかったため、オフラインデータの一部が消去されました。';
$string['addon.mod_scorm.warningsynconlineincomplete'] = '最終のオンライン回答が完了していないため、一部の回答が同期できませんでした。先にオンライン回答を完了してください。';
$string['addon.mod_survey.cannotsubmitsurvey'] = '申し訳ありません。あなたの調査提出で問題が発生しました。再度提出を実行してください。';
$string['addon.mod_survey.errorgetsurvey'] = '調査データの取得中にエラーが発生しました。';
$string['addon.mod_survey.results'] = '結果';
$string['addon.mod_url.accessurl'] = 'URLへのアクセス';
$string['addon.mod_url.pointingtourl'] = 'このリソースのURL';
$string['addon.mod_wiki.errorloadingpage'] = 'ページの読み込み中にエラーが発生しました。';
$string['addon.mod_wiki.errornowikiavailable'] = 'このwikiにはまだ内容がありません。';
$string['addon.mod_wiki.gowikihome'] = 'Wikiのホームへ移動';
$string['addon.mod_wiki.subwiki'] = 'サブwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = '空のタイトルは受け付けられません';
$string['addon.mod_wiki.viewpage'] = 'ページを表示';
$string['addon.mod_wiki.wikipage'] = 'Wikiページ';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = '評価戦略 {{$a}} はサポートされていません。';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'あなたはタイトルを入力する必要があります。';
$string['addon.mod_workshop.warningassessmentmodified'] = 'このサイトの提出が修正されました。';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'このサイトの評価が修正されました。';
$string['addon.notes.warningnotenotsent'] = 'コース {{course}} にノートを追加することができません。 {{error}}';
$string['addon.notifications.allownotifications'] = '通知を許可する';
$string['addon.notifications.errorgetnotifications'] = '通知の取得中にエラーが発生しました。';
$string['addon.notifications.notifications'] = '通知';
$string['addon.notifications.playsound'] = '音を出力';
$string['addon.notifications.therearentnotificationsyet'] = '通知はありません';
$string['addon.notifications.typeofnotification'] = '通知の種類';
$string['addon.privatefiles.couldnotloadfiles'] = 'ファイル一覧を読み込みませんでした。';
$string['addon.privatefiles.emptyfilelist'] = '表示するファイルはありません。';
$string['addon.privatefiles.erroruploadnotworking'] = '残念ですが現在あなたのサイトにファイルをアップロードできません。';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'すべてのサイトダウンロードデータを削除してもよろしいですか?';
$string['addon.storagemanager.confirmdeletecourses'] = 'すべてのコースからダウンロードデータを削除してもよろしいですか?';
$string['addon.storagemanager.confirmdeletedatafrom'] = '「 {{name}} 」からすべてのダウンロードデータを削除してもよろしいですか?';
$string['addon.storagemanager.coursedownloads'] = 'コースダウンロード';
$string['addon.storagemanager.courseinfo'] = 'オフラインで作業するにはコースコンテンツをダウンロードしてください。デバイスがオンラインに復帰した場合、あなたの活動は自動的に同期されます。';
$string['addon.storagemanager.deleteallsitedata'] = 'すべてのサイトダウンロードデータを削除する';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'あなたがオフラインで作業するため「 {{name}} 」からダウンロードしたダウンロード済みコースおよびデータを含むすべてのダウンロードデータが削除されます。';
$string['addon.storagemanager.deletecourses'] = 'すべてのコースからダウンロードデータを削除する';
$string['addon.storagemanager.deletedata'] = 'ダウンロード済みデータを削除する';
$string['addon.storagemanager.deletedatafrom'] = '「 {{name}} 」からすべてのダウンロードデータを削除する';
$string['addon.storagemanager.downloadedcourses'] = 'ダウンロード済みコース';
$string['addon.storagemanager.downloads'] = 'ダウンロード';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'ダウンロード済みデータの削除中にエラーが発生しました。';
$string['addon.storagemanager.managedownloads'] = 'ダウンロードを管理する';
$string['addon.storagemanager.totaldownloads'] = '合計ダウンロード';
$string['addon.storagemanager.totalspaceusage'] = '合計利用スペース';
$string['appstoredescription'] = '注意：本オフィシャルMoodleモバイルアプリは、その利用許可を設定されたMoodleサイトで「のみ」利用可能です。接続に問題がある場合には、あなたのMoodle管理者に問い合わせてください。

あなたのMoodleサイトがすでに正しくその設定がなされていれば、本アプリから、以下のことができます：

 - あなたのコースコンテンツのブラウズ（オフラインからも）
 - メッセージその他のイベントの即座の通知を受ける
 - あなたのコースに参加している他の人を即座に検索して連絡をとる
 - 画像、オーディオ、動画その他のファイルをあなたのモバイルデバイスからアップロード
 - あなたのコース成績の閲覧
 - その他、もっと多くのこと

最新情報は、 http://docs.moodle.org/en/Mobile_app を参照してください。

私たちは、本アプリの機能その他についての建設的なレビューを心から歓迎します。また、本アプリでできたらよいと思うことがあれば、ぜひ提案してください。

本アプリは、あなたのデバイスに以下の権限を要求します：
オーディオの録音 - オーディオを録音してMoodleへアップロードするため
SDカードの内容の読み取りと変更 - コンテンツをオフラインで閲覧する際に、コンテンツはSDカードにダウンロードされます
ネットワークアクセス - Moodleサイトへ接続できるようにするため、またあなたがサイトへ接続している、あるいはオフラインモードに切り替えていないことを確かめるため
起動時の実行 - アプリがバックグランド動作している間のローカル通知を受信するため
デバイスのスリープ禁止 - いつでもプッシュ通知を受信できるようにするため';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apple Keynoteプレゼンテーション';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Apple Numbersスプレッドシート';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Apple Pagesドキュメント';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Googleドライブオーディオ';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Googleドキュメント';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google図形描画';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Googleドライブファイル';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Googleドライブフォルダ';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Googleフォーム';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Googleスライド';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Script';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Googleサイト';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Googleスプレッドシート';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Googleドライブビデオ';
$string['core.ajaxendpointnotfound'] = '<p>AJAXエンドポイントが見つかりませんでした。これはMoodleサイトが古過ぎるか、このエンドポイントへのアクセスをブロックしている場合に発生する場合があります。MoodleアプリはMoodleシステム {{$a}} 以降のみをサポートします。あなたのサイト管理者にご連絡ください。</p>
<p>{{whoisadmin}}</p>';
$string['core.browser'] = 'ブラウザ';
$string['core.calculating'] = '計算する';
$string['core.cannotconnect'] = '接続できません。';
$string['core.cannotdownloadfiles'] = 'ダウンロードしようとしているファイルは、あなたのモバイルサービスでは無効になっています。あなたのサイト管理者に連絡してください。';
$string['core.cannotinstallapk'] = 'APKファイルをインストールできません。';
$string['core.cannotinstallapkinfo'] = 'セキュリティ上の理由から、あなたのデバイスのこのアプリから不明なアプリをインストールできません。それでもインストールを進めたい場合、あなたはブラウザで開く必要があります。';
$string['core.cannotlogoutpageblocks'] = '続ける前にあなたの変更を保存または破棄してください。';
$string['core.cannotopeninapp'] = 'このファイルはこのデバイスでは期待通りに動作しない可能性があります。とにかく開いてみますか?';
$string['core.cannotopeninappdownload'] = 'このファイルはこのデバイスでは期待通りに動作しない可能性があります。とにかくダウンロードしてみますか?';
$string['core.captureaudio'] = 'オーディオを録音する';
$string['core.capturedimage'] = '撮影写真';
$string['core.captureimage'] = '写真を撮る';
$string['core.capturevideo'] = 'ビデオを録画する';
$string['core.certificaterror'] = '<p>このサイトの証明書はあなたのデバイスでは信頼できません。サイト管理者にご連絡ください。</p>
<p>{{whoisadmin}}</p>';
$string['core.clearsearch'] = '検索のクリア';
$string['core.clearstoreddata'] = 'ストレージをクリアする {{$a}}';
$string['core.clicktoseefull'] = 'クリックで全てのコンテンツを見る';
$string['core.comments.commentsnotworking'] = 'コメントは検索できません。';
$string['core.comments.warningcommentsnotsent'] = 'コメントを同期できませんでした。{{error}}';
$string['core.confirmcanceledit'] = '本当にこのページを離れますか？　全ての変更が失われます。';
$string['core.confirmleaveunknownchanges'] = '本当にこのページを離れてもよろしいですか? 変更を保存していない場合、変更を失うことになります。';
$string['core.confirmloss'] = '本当ですか？　すべての変更が失われます。';
$string['core.confirmopeninbrowser'] = 'これをブラウザで開きますか？';
$string['core.connectionlost'] = 'サイトへの接続が切れました。';
$string['core.contactsupport'] = 'サポート問い合わせ先';
$string['core.contenteditingsynced'] = '編集中のコンテンツが同期されました。';
$string['core.contentlinks.chooseaccount'] = 'アカウントの選択';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'リンクを開くアカウントを選択してください。';
$string['core.contentlinks.confirmurlothersite'] = 'このリンクは別のサイトに属しています。本当に開きますか？';
$string['core.contentlinks.errornoactions'] = 'このリンクを実行するためのアクションが見つかりませんでした。';
$string['core.contentlinks.errornosites'] = 'このリンクをもつサイトが見つかりませんでした。';
$string['core.contentlinks.errorredirectothersite'] = 'リダイレクトURLに異なるサイトを指定できません。';
$string['core.copiedtoclipboard'] = 'クリップボードにコピーされたテキスト';
$string['core.copytoclipboard'] = 'クリップボードにコピーする';
$string['core.course.activitydisabled'] = 'あなたの組織はモバイルアプリでのこの活動の使用を無効にしています。';
$string['core.course.activitynotyetviewableremoteaddon'] = 'あなたの組織はまだサポートされていないプラグインをインストールしました。';
$string['core.course.allsections'] = '全てのセクション';
$string['core.course.aria:sectionprogress'] = 'セクション進捗:';
$string['core.course.availablespace'] = '現在、あなたには約 {{available}} の空き容量があります。';
$string['core.course.cannotdeletewhiledownloading'] = '活動のダウンロード中はファイルを削除できません。ダウンロードが終了するまでお待ちください。';
$string['core.course.confirmdownload'] = 'あなたは {{size}}.{{availableSpace}} をダウンロードしようとしています。本当に続けてもよろしいですか?';
$string['core.course.confirmdownloadunknownsize'] = 'ダウンロードサイズを計算できませんでした。{{availableSpace}} 本当に続けてもよろしいですか?';
$string['core.course.confirmdownloadzerosize'] = 'あなたはダウンロードを開始しようとしています。{{availableSpace}} 本当に続けてもよろしいですか?';
$string['core.course.confirmlimiteddownload'] = '現在あなたはWi-Fiに接続していません。';
$string['core.course.confirmpartialdownloadsize'] = 'あなたは<strong>少なくとも</strong> {{size}} のダウンロードを開始しようとしています。{{availableSpace}} 本当に続けてもよろしいですか?';
$string['core.course.couldnotloadsectioncontent'] = 'セクションコンテンツを読み込めませんでした。後でもう一度お試しください。';
$string['core.course.couldnotloadsections'] = 'セクションを読み込めませんでした。後でもう一度お試しください。';
$string['core.course.downloadcoursesprogressdescription'] = 'コースダウンロード中: ダウンロード済み {{count}} / {{total}}';
$string['core.course.downloadsectionprogressdescription'] = 'セクションダウンロード中: ダウンロード済み {{count}} / {{total}}';
$string['core.course.errordownloadingcourse'] = 'コースのダウンロード中にエラーが発生しました。';
$string['core.course.errordownloadingsection'] = 'セクションのダウンロード中にエラーが発生しました。';
$string['core.course.errorgetmodule'] = '活動データの取得中にエラーが発生しました。';
$string['core.course.insufficientavailablequota'] = 'あなたのデバイスではこのダウンロードを保存するためのスペースを確保できませんでした。アプリおよびシステムアップデートのために容量が確保されている可能性があります。最初にストレージの空き容量を確保してください。';
$string['core.course.insufficientavailablespace'] = 'あなたは {{size}} をダウンロードしようとしています。あなたのデバイスを正常に動作させるために十分なスペースがありません。最初にストレージの空き容量を確保してください。';
$string['core.course.lastaccessedactivity'] = '最後にアクセスした活動';
$string['core.course.manualcompletionnotsynced'] = '手動完了は同期されません。';
$string['core.course.modulenotfound'] = 'リソースまたは活動が見つかりませんでした。あなたがオンラインであること、そしてまだリソースまたは活動が利用可能であることを確認してください。';
$string['core.course.nextactivity'] = '次の活動';
$string['core.course.nextactivitynotfound'] = '次の活動が見つかりませんでした。活動が非表示にされているか、削除されている可能性があります。';
$string['core.course.nocontentavailable'] = '現在、利用できるコンテンツはありません。';
$string['core.course.previousactivity'] = '前の活動';
$string['core.course.previousactivitynotfound'] = '前の活動が見つかりませんでした。活動が非表示にされているか、削除されている可能性があります。';
$string['core.course.refreshcourse'] = 'コースをリフレッシュする';
$string['core.course.useactivityonbrowser'] = 'あなたのデバイスのウェブブラウザでは利用できます。';
$string['core.course.warningmanualcompletionmodified'] = 'サイトの活動の手動完了が修正されました。';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'コース「 {{name}} 」の一部のオフライン手動完了が削除されました。{{error}}';
$string['core.coursenogroups'] = 'あなたはこのコースのどのグループにも属していません。';
$string['core.courses.browserenrolinstructions'] = 'あなたのデバイスのブラウザに移動します。あなたの登録完了後、このアプリに戻ってきてください。';
$string['core.courses.cannotretrievemorecategories'] = 'レベル {{$a}} より深いカテゴリは検索できません。';
$string['core.courses.completeenrolmentbrowser'] = 'ブラウザで登録を完了する';
$string['core.courses.confirmselfenrol'] = '本当にこのコースに登録してもよろしいですか?';
$string['core.courses.downloadcourses'] = 'すべてのコースをダウンロードする';
$string['core.courses.enrolme'] = '私を登録する';
$string['core.courses.errorloadcategories'] = 'カテゴリの読み込み中にエラーが発生しました。';
$string['core.courses.errorloadcourses'] = 'コースの読み込み中にエラーが発生しました。';
$string['core.courses.errorloadplugins'] = 'このコースで必要なプラグインを正しく読み込めませんでした。アプリを再読み込みして再度お試しください。';
$string['core.courses.errorsearching'] = '検索中にエラーが発生しました。';
$string['core.courses.errorselfenrol'] = '自己登録中にエラーが発生しました。';
$string['core.courses.filtermycourses'] = 'マイコースをフィルタする';
$string['core.courses.notenrollable'] = 'あなたはこのコースに自分では登録できません。';
$string['core.courses.otherenrolments'] = '他の登録';
$string['core.courses.password'] = '登録キー';
$string['core.courses.refreshcourses'] = 'コースをリフレッシュする';
$string['core.courses.searchcoursesadvice'] = 'コース検索ボタンを使用してゲストとしてアクセスできるコースを探したり、許可されているコースに自己登録できます。';
$string['core.courses.selfenrolment'] = '自己登録';
$string['core.courses.showonlyenrolled'] = 'マイコースのみ表示する';
$string['core.courses.totalcoursesearchresults'] = '合計コース数: {{$a}}';
$string['core.currentdevice'] = '現在のデバイス';
$string['core.datastoredoffline'] = '送信できなかったため、データはデバイスに保存されました。後で自動的に送信されます。';
$string['core.deletedoffline'] = '削除済みオフライン';
$string['core.deleting'] = '消去中';
$string['core.desktop'] = 'デスクトップ';
$string['core.dfdaymonthyear'] = 'YYYY/MM/DD';
$string['core.dfdayweekmonth'] = 'MMM月D日（ddd）';
$string['core.dffulldate'] = 'YYYY年MMMM月D日（dddd） h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = '無視';
$string['core.dismiss'] = '取消';
$string['core.dontshowagain'] = '再度表示しません。';
$string['core.downloaded'] = 'ダウンロード済み';
$string['core.downloading'] = 'ダウンロード中';
$string['core.editor.hidetoolbar'] = 'ツールバーを隠す';
$string['core.editor.toggle'] = 'エディタを切り替える';
$string['core.emptysplit'] = '左パネルが空またはロード中のため本ページは空白';
$string['core.endingtime'] = '終了時刻:{{$a}}';
$string['core.errorchangecompletion'] = '完了状態の変更中にエラーが発生しました。再度実行してください。';
$string['core.errorcode'] = 'エラーコード:{{errorCode}}';
$string['core.errordeletefile'] = 'ファイル消去中にエラーが発生しました。再度実行してください。';
$string['core.errordetailshide'] = 'エラーの詳細を隠す';
$string['core.errordetailsshow'] = 'エラーの詳細を見る';
$string['core.errordownloading'] = 'ファイルダウンロードのエラー';
$string['core.errordownloadingsomefiles'] = 'モジュールファイルのダウンロード中にエラーが発生しました。欠落しているファイルがあるかもしれません。';
$string['core.errorfileexistssamename'] = '同じ名前のファイルがあります。';
$string['core.errorinvalidform'] = 'フォームに不正なデータが含まれています。必須フィールドすべてが記入され、データが正しいことを確認してください。';
$string['core.errorinvalidresponse'] = '不正な返信を受信しました。エラーが連続する場合、あなたのMoodleサイト管理者に連絡をとってください。';
$string['core.errorloadingcontent'] = 'コンテンツのロード中にエラーが発生しました。';
$string['core.errorofflinedisabled'] = 'あなたのサイトではオフラインブラウジングが無効にされています。あなたがアプリを使用するにはインターネットへの接続が必要です。';
$string['core.erroropenfiledownloading'] = 'ファイルオープンエラー: あなたはダウンロード完了を待つ必要があります。';
$string['core.erroropenfilenoapp'] = 'ファイルを開く際にエラーが発生しました。この種のファイルを開くアプリが見つかりません。';
$string['core.erroropenfilenoextension'] = 'ファイルを開く際にエラーが発生しました。ファイルに拡張子がありません。';
$string['core.erroropenpopup'] = 'このアクティビティはポップアップを開こうとしています。本アプリではサポートされていません。';
$string['core.errorrenamefile'] = 'ファイル名変更でエラーが発生しました。再度実行してください。';
$string['core.errorsitesupport'] = '問題が続く場合、サイトサポートにご連絡ください。';
$string['core.errorsomedatanotdownloaded'] = 'あなたがこの活動をダウンロードした場合、パフォーマンスおよびデータ使用の理由からダウンロード処理中に一部のデータがダウンロードされないことに留意してください。';
$string['core.errorsomethingwrong'] = '問題が発生しました。再度お試しください。';
$string['core.errorsync'] = '同期中にエラーが発生しました。再度実行してください。';
$string['core.errorsyncblocked'] = '実行中のプロセスがあったため、この {{$a}} はすぐに同期できませんでした。後でもう一度お試しください。問題が継続する場合、アプリを再起動してください。';
$string['core.errorurlschemeinvalidscheme'] = 'このURLは別のアプリでの使用を想定しています: {{$a}}';
$string['core.errorurlschemeinvalidsite'] = 'このサイトURLはこのアプリで開けません。';
$string['core.filenameexist'] = 'ファイル名がすでに存在しています：{{$a}}';
$string['core.fileuploader.audio'] = 'オーディオ';
$string['core.fileuploader.camera'] = 'カメラ';
$string['core.fileuploader.confirmuploadfile'] = '{$a}をアップロードしようとしています。続けますか？';
$string['core.fileuploader.confirmuploadunknownsize'] = 'アップロードのサイズを計算できませんでした。本当に続けてもよろしいですか?';
$string['core.fileuploader.discardrecording'] = 'レコーディングを削除する';
$string['core.fileuploader.errorcapturingaudio'] = '音声キャプチャーのエラー';
$string['core.fileuploader.errorcapturingimage'] = 'イメージのキャプチャ中にエラーが発生しました。';
$string['core.fileuploader.errorcapturingvideo'] = 'ビデオキャプチャーのエラー';
$string['core.fileuploader.errorgettingimagealbum'] = 'アルバムからイメージの取得中にエラーが発生しました。';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'ファイルをアップロードする場合、あなたはオンラインである必要があります。';
$string['core.fileuploader.errornoapp'] = 'あなたはこの操作を実行するためのアプリをインストールしていません。';
$string['core.fileuploader.errorreadingfile'] = 'ファイルの読み取りエラー';
$string['core.fileuploader.errorwhileuploading'] = 'ファイルアップロード中にエラーが発生しました。';
$string['core.fileuploader.file'] = 'ファイル';
$string['core.fileuploader.fileuploaded'] = 'アップロードしたファイル';
$string['core.fileuploader.maxbytesfile'] = 'ファイル {{$a.file}} が大きすぎます。あなたがアップロードできる最大サイズは {{$a.size}} です。';
$string['core.fileuploader.microphonepermissiondenied'] = 'マイクへのアクセス許可が拒否されました。';
$string['core.fileuploader.microphonepermissionrestricted'] = 'マイクへのアクセスは制限されています。';
$string['core.fileuploader.pauserecording'] = 'レコーディングを中断する';
$string['core.fileuploader.photoalbums'] = 'フォトアルバム';
$string['core.fileuploader.readingfile'] = 'ファイル読み取り';
$string['core.fileuploader.readingfileperc'] = 'ファイル読み込み中: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'レコーディングを再開';
$string['core.fileuploader.selectafile'] = 'ファイルを選択する';
$string['core.fileuploader.startrecordinginstructions'] = 'タップしてレコーディングを開始';
$string['core.fileuploader.uploadafile'] = 'ファイルをアップロードする';
$string['core.fileuploader.uploading'] = 'アップロード中';
$string['core.fileuploader.uploadingperc'] = 'アップロード中: {{$a}}%';
$string['core.fileuploader.video'] = 'ビデオ';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = '{{$a}} に移動する';
$string['core.h5p.errorgetemail'] = 'ユーザメールの取得中にエラーが発生しました。あなたの接続を確認して再度お試しください。';
$string['core.h5p.offlinedisabled'] = 'サイトではH5Pパッケージをダウンロードできません。';
$string['core.h5p.play'] = 'H5Pを再生する';
$string['core.hasdatatosync'] = 'この {{$a}} には同期すべきオフラインデータがあります。';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'このコンテンツを利用できませんか?';
$string['core.image'] = '画像';
$string['core.imageviewer'] = '画像ビューア';
$string['core.ioscookieshelp'] = '埋め込みコンテンツの動作にはクッキーが必要な場合があります。アプリのiOS設定で「クロスサイトトラッキングを許可する」を有効にして再度お試しください。';
$string['core.lastdownloaded'] = '最終ダウンロード';
$string['core.lastsync'] = '最後の同期';
$string['core.loadmore'] = '続きを読み込む';
$string['core.login.authenticating'] = '認証中';
$string['core.login.changepasswordbutton'] = 'パスワード変更ページを開く';
$string['core.login.changepasswordhelp'] = 'あなたのパスワード変更に問題がある場合、後でもう一度試してみるか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.login.changepasswordinstructions'] = 'アプリではパスワードを変更できません。以下のボタンをクリックしてウェブブラウザでサイトを開いてパスワードを変更してください。パスワード変更後、アプリに遷移しないためブラウザを終了する必要があることに留意してください。';
$string['core.login.changepasswordlogoutinstructions'] = 'あなたがサイトを変更またはログアウトしたい場合、以下のボタンをクリックしてください。';
$string['core.login.changepasswordreconnectinstructions'] = 'サイトに再接続するには以下のボタンをクリックしてください。(パスワード変更が成功しなかった場合、前の画面に戻ることに留意してください)。';
$string['core.login.changepasswordsupportsubject'] = '私のパスワード変更のサポートを必要とする';
$string['core.login.confirmdeletesite'] = '本当に {{sitename}} のアカウントを削除してもよろしいですか?';
$string['core.login.connect'] = '接続する!';
$string['core.login.connecttomoodle'] = 'Moodleに接続する';
$string['core.login.connecttomoodleapp'] = 'あなたは通常のMoodleサイトに接続しようとしています。このサイトにアクセスするには公式Moodleアプリをダウンロードしてください。';
$string['core.login.connecttoworkplaceapp'] = 'あなたはMoodle Workplaceサイトに接続しようとしています。このサイトにアクセスするにはMoodle Workplaceアプリをダウンロードしてください。';
$string['core.login.contactyouradministrator'] = '詳細はサイト管理者にご連絡ください。';
$string['core.login.contactyouradministratorissue'] = '次の問題に関してあなたのサイト管理者にお問い合わせください: {{$a}}';
$string['core.login.credentialsdescription'] = 'ログインするにはユーザ名およびパスワードを入力してください。';
$string['core.login.credentialshelp'] = 'あなたがログインできない場合、後でもう一度試してみるか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.login.credentialssupportsubject'] = 'ログインのサポートを必要とする';
$string['core.login.emailconfirmsentnoemail'] = '<p>あなたのアドレスにメールが送信されました。</p><p>メールには登録を完了するための簡単なインストラクションを含みます。</p><p>問題が解決しない場合、サイト管理者にご連絡ください。</p>';
$string['core.login.emailnotmatch'] = 'メールが合致しません。';
$string['core.login.erroraccesscontrolalloworigin'] = 'あなたが実行を試みているクロスオリジンコールが拒否されました。https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium をご確認ください。';
$string['core.login.errordeletesite'] = 'このアカウントの削除中にエラーが発生しました。再度お試しください。';
$string['core.login.errorexampleurl'] = 'URL https://campus.example.eduはあくまでもURL例であり、実際のサイトではありません。<strong>あなたの学校または組織のサイトURLを使用してください。</strong>';
$string['core.login.errorqrnoscheme'] = 'これは正しいログインURLではありません。';
$string['core.login.errorupdatesite'] = 'サイトトークンの更新中にエラーが発生しました。';
$string['core.login.exceededloginattempts'] = 'ログインのサポートが必要ですか? {{recoverPassword}} を試してみるか、あなたのサイトサポートにご連絡ください。';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'パスワードを復旧しています';
$string['core.login.exceededloginattemptssupportsubject'] = 'ログインできません';
$string['core.login.exceededloginattemptswithoutpassword'] = 'ログインのサポートが必要ですか? あなたのサイトサポートにご連絡ください。';
$string['core.login.exceededloginattemptswithoutsupport'] = 'ログインのサポートが必要ですか? {{recoverPassword}} をお試しください。';
$string['core.login.exceededpasswordresetattempts'] = 'あなたのアカウントへのアクセスに問題があるようです。あなたの教育機関または学習プロバイダに連絡するか、後でもう一度お試しください。';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'パスワードをリセットできない';
$string['core.login.faqcannotconnectanswer'] = 'あなたの管理者にご連絡ください。';
$string['core.login.faqcannotconnectquestion'] = '私のサイトアドレスを正確に入力しましたが、まだ接続できません。';
$string['core.login.faqcannotfindmysiteanswer'] = '名称を正確に入力しましたか? あなたのサイトが私たちの公開サイトディレクトリに含まれていない可能性もあります。それでも見つからない場合、代わりにあなたのサイトのアドレスを入力してください。';
$string['core.login.faqcannotfindmysitequestion'] = '私のサイトが見つかりません。';
$string['core.login.faqcantloginanswer'] = '<p>あなたのMoodleサイトに接続できた場合、いつものユーザ名およびパスワードでログインできるはずです。</p>
<br />
<p>あなたのユーザ名またはパスワードを忘れた場合、<strong>あなたのユーザ名またはパスワードを忘れましたか?</strong>オプションを選択してください。それでもログインできない場合、またはあなたのユーザ名またはパスワードを取得するためのオプションが表示されない場合、あなたの教育機関または学習組織でMoodleを管理している担当者にご連絡ください。</p>';
$string['core.login.faqcantloginquestion'] = 'ログインできません。';
$string['core.login.faqmore'] = '詳細は<a href="https://docs.moodle.org/ja/モバイルMoodle_FAQ#toc" target="_blank">私たちのFAQ</a>をご確認ください。';
$string['core.login.faqsetupsiteanswer'] = 'あなたのMoodleサイトを作成するための異なるオプションを {{$link}} にアクセスして確認してください。';
$string['core.login.faqsetupsitelinktitle'] = '始めます。';
$string['core.login.faqsetupsitequestion'] = '自分のMoodleサイトを設定したい。';
$string['core.login.faqtestappanswer'] = 'Moodleデモサイトでアプリをテストするには「Your site」フィールドに「teacher」または「student」と入力した後、「Connect to your site」ボタンをクリックしてください。';
$string['core.login.faqtestappquestion'] = 'アプリを試したいのですが、どのようにすれば良いですか?';
$string['core.login.faqwhatisurlanswer'] = '<p>すべての組織にはそれぞれのMoodleサイトに固有のアドレスまたはURLを持っています。</p><ol><li>ウェブブラウザを開いてあなたのMoodleサイトのログインページに移動してください。</li><li>ページ上部のアドレスバーにあなたのMoodleサイトのURLが表示されます。 例) campus.example.edu<br>{{$image}}</li><li>アドレスをコピーして (/loginおよびその後の部分はコピーしないでください) Moodleアプリに貼り付けた後、「あなたのサイトに接続する」をクリックしてください。</li><li>あなたのユーザ名およびパスワードを使ってあなたのサイトにログインできます</li></ol>。';
$string['core.login.faqwhatisurlquestion'] = '私のサイトアドレスは何ですか? 私のサイトURLを探すにはどうすれば良いですか?';
$string['core.login.faqwhereisqrcode'] = 'QRコードはどこにありますか?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>あなたの組織がこの機能を有効にしている場合、あなたのウェブサイトのユーザプロファイルページ下部にQRコードが表示されます。</p>{{$image}}';
$string['core.login.findyoursite'] = 'あなたのサイトを探す';
$string['core.login.helpmelogin'] = '<p>世界には何千ものMoodleサイトがあります。このアプリはモバイルアプリのアクセスが有効にされたMoodleサイトにのみ接続できます。</p><p>もし、あなたのMoodleサイトに接続できない場合、あなたのサイト管理者に連絡して<a href="http://docs.moodle. org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a>を確認するようお伝えください。</p><p>Moodleのデモサイトでアプリをテストするには<i>teacher</i>または<i>student</i>を<i>Site address</i>フィールドに入力した後、<b>Connect</b>ボタンをクリックしてください。';
$string['core.login.invalidaccount'] = 'あなたがログインするのに必要な情報を再確認し、サイト管理者にサイトの設定と合致しているか確認するよう依頼してください。';
$string['core.login.invalidmoodleversion'] = '<p>無効なMoodleサイトバージョンです。MoodleアプリはMoodleシステム {{$a}} 以降のみサポートします。</p>
<p>あなたのサイト管理者に連絡してMoodleシステムの更新を依頼できます。</p>
<p>「サイト管理者」はあなたの学校/大学/法人または教育機関でMoodleを管理する人です。サイト管理者への連絡方法が分からない場合、あなたの教師/指導者にご連絡ください。</p>';
$string['core.login.invalidsite'] = 'サイトURLが正しくありません。';
$string['core.login.invalidtime'] = '無効な時間です。';
$string['core.login.invalidvaluemax'] = '最大値は {{$a}} です。';
$string['core.login.invalidvaluemin'] = '最小値は {{$a}} です。';
$string['core.login.loggedoutssodescription'] = 'あなたは再度認証する必要があります。あなたはブラウザウィンドウでサイトにログインする必要があります。';
$string['core.login.loginbutton'] = 'ログイン';
$string['core.login.logininsiterequired'] = 'ブラウザウィンドウからサイトにログインする必要があります。';
$string['core.login.mobileservicesnotenabled'] = 'あなたのサイトではモバイルサービスが有効になっていません。モバイルアクセスが必要と思うなら、あなたのMoodleサイト管理者にその相談をしてください。';
$string['core.login.notloggedin'] = 'あなたはログインする必要があります。';
$string['core.login.onboardingcreatemanagecourses'] = 'あなたのコースを作成および管理する';
$string['core.login.onboardingenrolmanagestudents'] = 'あなたの学生を登録および管理する';
$string['core.login.onboardinggetstarted'] = 'Moodleを始めましょう';
$string['core.login.onboardingialreadyhaveasite'] = '私にはすでにMoodleサイトがあります。';
$string['core.login.onboardingimalearner'] = '私は学習者です。';
$string['core.login.onboardingimaneducator'] = '私は教育者です。';
$string['core.login.onboardingineedasite'] = 'Moodleサイトが必要です。';
$string['core.login.onboardingprovidefeedback'] = 'フィードバックを適時提供する';
$string['core.login.onboardingtoconnect'] = 'あなたがMoodleアプリに接続するにはMoodleサイトが必要です。';
$string['core.login.onboardingwelcome'] = 'Moodleアプリにようこそ!';
$string['core.login.or'] = 'OR';
$string['core.login.passwordrequired'] = 'パスワードがありません';
$string['core.login.policyacceptmandatory'] = '私は必須のサイトポリシーを理解および同意します';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHAチャレンジイメージ';
$string['core.login.recaptchaexpired'] = '検証の有効期限が切れました。再度、セキュリティ質問にお答えください。';
$string['core.login.recaptchaincorrect'] = 'セキュリティ質問の回答が正しくありません。';
$string['core.login.reconnect'] = '再接続';
$string['core.login.reconnecthelp'] = '再接続に問題がある場合、後でもう一度試してみるか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.login.reconnectssodescription'] = '認証トークンが無効または有効期限切れです。あなたはサイトに再接続する必要があります。あなたはブラウザウィンドウでサイトにログインする必要があります。';
$string['core.login.reconnectsupportsubject'] = '再接続のサポートを必要とする';
$string['core.login.reconnecttosite'] = 'サイトに再接続する';
$string['core.login.removeaccount'] = 'アカウントを削除する';
$string['core.login.searchby'] = '検索:';
$string['core.login.selectsite'] = 'あなたのアカウントを選択してください:';
$string['core.login.signupplugindisabled'] = '{{$a}} は有効にされていません。';
$string['core.login.signuprequiredfieldnotsupported'] = 'サインアップフォームにアプリでサポートされていない必須のカスタムフィールドが含まれています。ウェブブラウザを使用してあなたのアカウントを作成してください。';
$string['core.login.siteaddress'] = 'あなたのサイト';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = '{{count}} 件の未読通知があります。';
$string['core.login.sitehasredirect'] = 'あなたのサイトには少なくとも1つのHTTPリダイレクトが含まれています。アプリがリダイレクトに従えないため、これがあなたのサイトへのアプリの接続を妨げている問題である可能性があります。';
$string['core.login.siteinmaintenance'] = 'このサイトはメンテナンス中です';
$string['core.login.sitenotallowed'] = 'このサイトは利用できません。';
$string['core.login.sitepolicynotagreederror'] = 'サイトポリシーに同意されていません。';
$string['core.login.siteurl'] = 'サイトURL';
$string['core.login.siteurlrequired'] = 'サイトURLがありません。書き方例は次の通りです：<i>http://www.yourmoodlesite.abc あるいは https://www.yourmoodlesite.efg</i>';
$string['core.login.stillcantconnect'] = 'まだ接続できませんか?';
$string['core.login.toggleremove'] = 'アカウントリストを編集する';
$string['core.login.usernamerequired'] = 'ユーザー名がありません';
$string['core.login.visitchangepassword'] = 'パスワードの変更のためにサイトにアクセスしますか?';
$string['core.login.webservicesnotenabled'] = 'あなたのサイトではWebサービスが有効されていません。あなたのMoodleサイト管理者にご連絡ください。';
$string['core.login.youcanstillconnectwithcredentials'] = 'あなたはまだユーザ名およびパスワードを入力してサイトに接続できます。';
$string['core.login.yourenteredsite'] = 'あなたのサイトに接続する';
$string['core.lostconnection'] = 'あなたのトークンが無効になったため、再接続に必要な情報がサーバにはありません。';
$string['core.mainmenu.switchaccount'] = 'アカウントをスイッチする';
$string['core.mainmenu.usermenutourdescription'] = 'あなたの成績を確認、プリファレンスを変更またはアカウントを切り替える場所です。';
$string['core.mainmenu.usermenutourtitle'] = 'あなたのパーソナルエリアを探索する';
$string['core.needhelp'] = 'お困りですか?';
$string['core.networkerroriframemsg'] = 'このコンテンツはオフラインでは利用できません。インターネットに接続して再度お試しください。';
$string['core.networkerrormsg'] = 'ネットワークが無効もしくは機能していません';
$string['core.nooptionavailable'] = '利用可能なオプションはありません。';
$string['core.nopasswordchangeforced'] = 'パスワードを変更するまで続きを実行できません。';
$string['core.nopermissionerror'] = '申し訳ございません、現在あなたにはその操作のパーミッションがありません。';
$string['core.notapplicable'] = 'なし';
$string['core.notdownloadable'] = 'ダウンロード不可';
$string['core.notsent'] = '未送信';
$string['core.nummore'] = 'さらに {{$a}}';
$string['core.openfile'] = 'ファイルを開く';
$string['core.openfullimage'] = 'クリックしてフルサイズの画像を表示';
$string['core.openinbrowser'] = 'ブラウザで開く';
$string['core.openinbrowserdescription'] = 'あなたはウェブブラウザに移動します。';
$string['core.openmodinbrowser'] = '{{$a}} をブラウザで開く';
$string['core.opensecurityquestion'] = 'セキュリティ質問を開く';
$string['core.opensettings'] = '設定を開く';
$string['core.openwith'] = '開く ...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = '再生';
$string['core.pulltorefresh'] = 'スワイプで更新';
$string['core.qrscanner'] = 'QRスキャナ';
$string['core.question.cannotdeterminestatus'] = 'ステータスを判定できません。';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'あなたのサイトはまだ回答へのファイル添付をサポートしていません。';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'あなたのサイトはまだ埋め込みファイルの編集をサポートしていません。';
$string['core.question.errorquestionnotsupported'] = 'この問題タイプはアプリでサポートされていません: {{$a}}.';
$string['core.question.howtodraganddrop'] = '選んだものをタッチして、あてはまる所にタッチして入れましょう。';
$string['core.question.questionmessage'] = '問題 {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'サイトにリダイレクトされます。';
$string['core.reminders.atthetime'] = 'イベント時';
$string['core.reminders.custom'] = 'カスタム ...';
$string['core.reminders.customreminder'] = 'カスタムリマインダー';
$string['core.reminders.delete'] = 'リマインダを削除する';
$string['core.reminders.reminderset'] = '{{$a}} にリマインダを設定する';
$string['core.reminders.reminderunset'] = 'リマインダーを削除しました';
$string['core.reminders.setareminder'] = 'リマインダーを設定する';
$string['core.reminders.setareminderfor'] = '「 {{title}} 」 ({{label}}) にリマインダを設定する';
$string['core.reminders.setreminder'] = 'リマインダーを設定する';
$string['core.reminders.timebefore'] = '{{value}} {{units}} 前';
$string['core.reminders.value'] = '値';
$string['core.removefiles'] = 'ファイルを削除する {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'この表示にはフィルタが適用されている場合があります。フィルタを編集または並べ替え順を変更する場合、<a href="{{$a}}">あなたのブラウザでこのレポートを開いてください。</a>';
$string['core.reportbuilder.hidecolumns'] = '列を非表示';
$string['core.reportbuilder.showcolumns'] = '列を表示';
$string['core.requireduserdatamissing'] = 'このユーザは必須のプロフィールデータが欠けています。Moodleでデータを補い、再度開いてください。<br>{{$a}}';
$string['core.resume'] = '再開';
$string['core.retry'] = '再実行';
$string['core.scanqr'] = 'QRコードをスキャンする';
$string['core.scrollbackward'] = '後ろにスクロールする';
$string['core.scrollforward'] = '前にスクロールする';
$string['core.search.allcategories'] = 'すべてのカテゴリ';
$string['core.search.empty'] = '何を探しますか?';
$string['core.search.filtercategories'] = 'フィルタ結果:';
$string['core.search.filtercourses'] = '検索';
$string['core.search.noresults'] = '「 {{$a}} 」の結果はありません。';
$string['core.search.noresultshelp'] = 'タイポをチェックするか、別のキーワードを使ってみる';
$string['core.search.resultby'] = 'By {{$a}}';
$string['core.searching'] = '検索中';
$string['core.serverconnection'] = 'サーバ接続エラー: {{details}}';
$string['core.settings.about'] = 'このアプリについて';
$string['core.settings.appsettings'] = 'アプリ設定';
$string['core.settings.appversion'] = 'アプリバージョン';
$string['core.settings.cannotsyncloggedout'] = 'あなたがログアウトしたためこのサイトは同期できません。あなたがサイトにログインした際に再度お試しください。';
$string['core.settings.cannotsyncoffline'] = 'オフラインを同期できません。';
$string['core.settings.cannotsyncwithoutwifi'] = '現在の設定ではWi-Fi接続時にのみ同期を許可しているため同期できません。Wi-Fiネットワークに接続してください。';
$string['core.settings.changelanguage'] = '{{$a}} に変更する';
$string['core.settings.changelanguagealert'] = '言語を変更した場合、アプリが再起動します。';
$string['core.settings.colorscheme'] = 'カラースキーマ';
$string['core.settings.colorscheme-dark'] = 'ダーク';
$string['core.settings.colorscheme-light'] = 'ライト';
$string['core.settings.colorscheme-system'] = 'システムデフォルト';
$string['core.settings.colorscheme-system-notice'] = 'あなたのデバイスのサポートによりシステムのデフォルトモードは異なります。';
$string['core.settings.compilationinfo'] = 'コンパイル情報';
$string['core.settings.connecttosync'] = 'オフラインです。サイトを同期するため、インターネットに接続してください。';
$string['core.settings.connectwifitosync'] = 'サイトを同期するには、Wi-Fi をオンにするかデータセーバーをオフにしてください。';
$string['core.settings.copyinfo'] = 'デバイス情報をクリップボードにコピーする';
$string['core.settings.cordovadevicemodel'] = 'Cordovaデバイスモデル';
$string['core.settings.cordovadeviceosversion'] = 'CordovaデバイスOSバージョン';
$string['core.settings.cordovadeviceplatform'] = 'Cordovaデバイスプラットフォーム';
$string['core.settings.cordovadeviceuuid'] = 'CordovaデバイスUUID';
$string['core.settings.cordovaversion'] = 'Cordovaバージョン';
$string['core.settings.debugdisplaydescription'] = 'この設定を有効にした場合、可能であればエラーモーダルはエラーに関する詳細データを表示します。';
$string['core.settings.developeroptions'] = '開発者オプション';
$string['core.settings.deviceinfo'] = 'デバイス情報';
$string['core.settings.deviceos'] = 'デバイスOS';
$string['core.settings.displayformat'] = '表示フォーマット';
$string['core.settings.enableanalytics'] = 'アナリティクスを有効にする';
$string['core.settings.enableanalyticsdescription'] = 'この設定を有効にした場合、アプリは匿名の使用データを収集します。';
$string['core.settings.enabledownloadsection'] = 'セクションダウンロードを有効にする';
$string['core.settings.enablefirebaseanalytics'] = 'Firebaseアナリティクスを有効にする';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'この設定を有効にした場合、アプリは匿名のデータ使用状況を収集します。';
$string['core.settings.enablerichtexteditor'] = 'テキストエディタを有効にする';
$string['core.settings.enablerichtexteditordescription'] = 'この設定を有効にした場合、コンテンツ入力時にテキストエディタを利用できます。';
$string['core.settings.enablesyncwifi'] = 'Wi-Fiの場合のみ同期を許可する';
$string['core.settings.encryptedpushsupported'] = '暗号化プッシュ通知サポート';
$string['core.settings.entriesincache'] = 'キャッシュ内に {{$a}} 件のエントリがあります。';
$string['core.settings.errorsyncsite'] = 'サイトデータ同期中にエラーが発生しました。あなたのインターネット接続を確認して再度お試しください。';
$string['core.settings.estimatedfreespace'] = '概算の空き容量';
$string['core.settings.filesystemroot'] = 'ファイルシステムルート';
$string['core.settings.fontsize'] = 'テキストサイズ';
$string['core.settings.forcedsetting'] = 'この設定はあなたのサイト設定により強制されています。';
$string['core.settings.helpusimprove'] = 'このアプリの改善にご協力ください。';
$string['core.settings.ioscookies'] = 'クロスウェブサイトトラッキング';
$string['core.settings.ioscookiesdescription'] = 'サイトからの埋め込みコンテンツには動作にクロスサイトクッキーを必要とする場合があります。この設定を有効にするにはアプリのiOS設定で「クロスサイトトラッキングを許可する」を有効にしてください。';
$string['core.settings.legaldisclaimer'] = '免責事項';
$string['core.settings.localnotifavailable'] = 'ローカル通知利用可';
$string['core.settings.locationhref'] = 'ウェブ表示URL';
$string['core.settings.logintosync'] = 'ログインして同期する';
$string['core.settings.navigatorlanguage'] = 'ナビゲータ言語';
$string['core.settings.navigatoruseragent'] = 'ナビゲータユーザエージェント';
$string['core.settings.networkstatus'] = 'インターネット接続ステータス';
$string['core.settings.opensourcelicenses'] = 'オープンソースライセンス';
$string['core.settings.privacypolicy'] = 'プライバシーポリシー';
$string['core.settings.publisher'] = '発行者';
$string['core.settings.pushid'] = 'プッシュ通知ID';
$string['core.settings.reportinbackground'] = 'エラーを自動的に報告する';
$string['core.settings.screen'] = 'スクリーン情報';
$string['core.settings.showdownloadoptions'] = 'ダウンロード情報を表示する';
$string['core.settings.siteinfo'] = 'サイト情報';
$string['core.settings.sitesyncfailed'] = 'サイト同期に失敗';
$string['core.settings.spaceusage'] = 'ストレージ使用量';
$string['core.settings.syncdatasaver'] = 'データセーバ: Wi-Fi接続時のみ同期する';
$string['core.settings.synchronization'] = '同期';
$string['core.settings.synchronizenow'] = '今すぐ同期する';
$string['core.settings.synchronizenowhelp'] = 'サイトを同期させた場合、保留中の変更およびデバイスに保存されているすべてのオフライン活動が送信されます。また、メッセージおよび通知等の一部のデータが同期されます。';
$string['core.settings.syncsettings'] = '同期設定';
$string['core.settings.wificonnection'] = 'Wi-Fi接続';
$string['core.settings.youradev'] = 'あなたは開発者です。';
$string['core.sharedfiles.chooseaccountstorefile'] = 'ファイルを保存するアカウントを選択してください。';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'この名称のファイルはすでに存在します。既存のファイルを置換または「 {{$a}} 」にリネームしますか?';
$string['core.sharedfiles.errorreceivefilenosites'] = '保存されているサイトはありません。このアプリでファイルを共有するにはサイトを追加してください。';
$string['core.sharedfiles.nosharedfiles'] = 'このサイトに保存されている共有ファイルはありません。';
$string['core.sharedfiles.nosharedfilestoupload'] = 'ここにアップロードするファイルはありません。他のアプリからファイルをアップロードしたい場合、ファイルを探して「開く」ボタンをクリックしてください。';
$string['core.sharedfiles.rename'] = 'リネーム';
$string['core.sharedfiles.replace'] = '置換';
$string['core.sharedfiles.sharedfiles'] = '共有ファイル';
$string['core.sharedfiles.successstorefile'] = 'ファイルが正常に保存されました。あなたのプライベートファイルにアップロードまたは活動で使用するファイルを選択してください。';
$string['core.sitenotfound'] = 'サイトが見つかりませんでした';
$string['core.sitenotfoundhelp'] = '私たちはあなたが入力したサイトを探せませんでした。タイポを確認するか、後でもう一度お試しください。このメッセージが表示され続ける場合、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.siteunavailablehelp'] = 'サイト「 {{site}} 」は現在利用できません。後でもう一度試すか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'すみません...';
$string['core.start'] = 'スタート';
$string['core.startingtime'] = '開始時刻: {{$a}}';
$string['core.storingfiles'] = 'ファイル保存';
$string['core.swipenavigationtourdescription'] = '移動するには左右にスワイプしてください。';
$string['core.tablet'] = 'タブレット';
$string['core.tag.errorareanotsupported'] = 'アプリではこのタグエリアはサポートされません。';
$string['core.tag.tagareabadgedescription'] = '{{count}} 件のアイテムがあります。';
$string['core.tag.warningareasnotsupported'] = 'アプリでサポートされていないため、一部のタグエリアは表示されません。';
$string['core.thereisdatatosync'] = '同期が必要なオフライン {{$a}} があります。';
$string['core.toggledelete'] = '削除ボタンの切り替え';
$string['core.tryagain'] = '再実行';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'おおっと!';
$string['core.unexpectederror'] = '不明なエラー。アプリを閉じて再起動してください。';
$string['core.unicodenotsupported'] = '本サイトでは一部の絵文字がサポートされていません。それらは送信されたメッセージから削除されます。';
$string['core.unicodenotsupportedcleanerror'] = 'Unicode文字をクリアする際に空のテキストがありました。';
$string['core.unknown'] = '不明';
$string['core.unzipping'] = '未展開の';
$string['core.updaterequired'] = '要アプリアップデート';
$string['core.updaterequireddesc'] = 'あなたのアプリをバージョン {{$a}} にアップデートしてください。';
$string['core.user.completeprofile'] = 'プロファイルを完了する';
$string['core.user.completeprofilehelp'] = 'あなたのプロファイル完了に問題がある場合、後でもう一度試してみるか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.user.completeprofilenotice'] = '続ける前に、プロフィールの必須項目に記入してください。';
$string['core.user.completeprofilereconnectinstructions'] = 'あなたのプロファイルが正しく完了されていない場合、後でもう一度お願いすることになります。';
$string['core.user.completeprofilesupportsubject'] = '私のプロファイル完了のサポートを必要とする';
$string['core.user.completeyourprofile'] = 'あなたのプロファイルを完了する';
$string['core.user.contact'] = 'コンタクト';
$string['core.user.detailsnotavailable'] = 'あなたはこのユーザの詳細を利用できません。';
$string['core.user.errorloaduser'] = 'ユーザの読み込み中にエラーが発生しました。';
$string['core.user.sendemail'] = 'メール';
$string['core.user.support'] = 'サイトサポートに連絡する';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'ID {{id}} のユーザ';
$string['core.usernologin'] = 'このアカウントの認証は無効にされました。';
$string['core.viewcode'] = 'コードを表示する';
$string['core.vieweditor'] = 'エディタを表示する';
$string['core.viewembeddedcontent'] = '埋め込みコンテンツを表示する';
$string['core.wanttochangesite'] = 'サイトを変更またはログアウトしますか?';
$string['core.warningofflinedatadeleted'] = '{{component}} 「 {{name}} 」のオフラインデータが削除されました。{{error}}';
$string['core.warningofflinedatadeletedreason'] = 'この活動の新しい変更は別のデバイスから実施されました。';
$string['core.warnopeninbrowser'] = '<p>あなたはアプリから離れてブラウザで次のURLを開こうとしています。続けてもよろしいですか?</p>
<p><b>{{url}}</b></p>';
$string['core.whoissiteadmin'] = '「サイト管理者」はあなたの学校/大学/会社または学習組織でMoodleを管理する人のことです。連絡先がわからない場合、先生/トレーナーにご連絡ください。';
$string['core.whyisthishappening'] = 'なぜこのようなことが発生したのですか?';
$string['core.wsfunctionnotavailable'] = 'ウェブサービス関数は利用できません。';
$string['core.youreoffline'] = 'あなたはオフラインです。';
$string['core.youreonline'] = 'あなたはオンラインに戻りました。';
$string['core.zoomin'] = 'ズームイン';
$string['core.zoomout'] = 'ズームアウト';
$string['freemium.autologoutclosingtheapp'] = 'アプリを離れた直後';
$string['freemium.autologoutcustomtime'] = 'アプリ終了後のカスタム時間';
$string['freemium.autologoutdefault'] = 'デフォルト';
$string['freemium.autologouttitle'] = 'このデバイスから自動的にログアウトする';
$string['freemium.biometriclogin'] = '生体認証ログイン';
$string['freemium.biometriclogindescription'] = 'あなたの指を指紋認証リーダに乗せてください。';
$string['freemium.biometricloginenablefaceid'] = 'FaceIDを有効にする';
$string['freemium.biometricloginenablefingerprint'] = '指紋認証を有効にする';
$string['freemium.biometricloginenabletouchid'] = 'TouchIDを有効にする';
$string['freemium.biometricloginloginwithfaceid'] = 'FaceIDでログインする';
$string['freemium.biometricloginloginwithfingerprint'] = '指紋でログインする';
$string['freemium.biometricloginloginwithtouchid'] = 'TouchIDでログインする';
$string['freemium.biometricloginskip'] = '今はスキップする';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} が有効にされました。';
$string['freemium.biometricloginturnoff'] = 'あなたはこの機能を設定でいつでも有効または無効にできます。';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = '指紋';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'あなたの指紋または顔による生体認証ログインを利用します。';
$string['freemium.change'] = '変更';
$string['freemium.coursesbatchdownloaddisabled'] = 'このサイトではコースの一括ダウンロードは有効にされていません。';
$string['freemium.coursesdownloadlimitreached'] = 'コースのダウンロード制限に達しました! あなたがダウンロードできるコースは {{limit}} のみです。この制限を増やすかダウンロードしたコースの一部をデバイスから削除したい場合、あなたの管理者にご連絡ください。';
$string['freemium.downloadmainapplicationrequired'] = 'あなたはこのサイトに専用アプリでのみ接続可能です。';
$string['freemium.downloadmainapplicationsuggestion'] = 'あなたが接続を試みているサイトには専用アプリがあります。そちらをお試しください。';
$string['freemium.feature_autologout'] = '自動ログアウト';
$string['freemium.feature_biometriclogin'] = '生体認証ログイン';
$string['freemium.feature_coursesdownload'] = 'ダウンロードしたコース';
$string['freemium.feature_multimediapushnotifications'] = 'マルチメディアプッシュ通知';
$string['freemium.feature_pushnotificationsdevices'] = 'プッシュ通知デバイス';
$string['freemium.feature_qrlogin'] = 'QRコードで認証する';
$string['freemium.feature_remotethemes'] = 'リモートテーマ';
$string['freemium.feature_sitelogo'] = 'サイトロゴ';
$string['freemium.notallowed'] = '許可されていません';
$string['freemium.nottoday'] = '今日ではありません';
$string['freemium.qrlogindisabled'] = 'QRコードを使用したアプリでの認証はサイトで有効にされていません:
<br /><br />
{{url}}';
$string['freemium.qrloginexpiredkey'] = 'QRコードの有効期限が切れています。QRコードのあるページを更新して再度スキャンしてください。';
$string['freemium.qrloginipmismatch'] = 'あなたが接続に使用しているデバイスがQRコードを表示するデバイスと同じネットワークにないようです。両方のデバイスが同じネットワーク (例: 同じWiFiネットワーク) に接続されていることを確認してください。エラーが続く場合、あなたのサイト管理者にご連絡ください。';
$string['freemium.ratetheapp'] = '私たちのアプリを楽しんでいますか?';
$string['freemium.ratetheapp_feedbackko'] = '私たちに問題点をお教えください。';
$string['freemium.ratetheapp_feedbackmessage'] = 'あなたのフィードバックは匿名にされます。';
$string['freemium.ratetheapp_feedbackok'] = 'フィードバックを送る';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'ここに記入';
$string['freemium.ratetheapp_feedbacksent'] = 'ご協力ありがとうございます。フィードバックは正常に送信されました。';
$string['freemium.ratetheapp_sendtostore'] = '私たちのアプリを評価していただけませんでしょうか? この評価は私たちのアプリの改善に役立てることができます。';
$string['freemium.remindmelater'] = '私に後で知らせて';
$string['freemium.settingsoptions_autologout'] = '自動ログアウト';
$string['freemium.settingsoptionsfacial'] = '顔認証ログインを有効にする';
$string['freemium.settingsoptionsfingerprint'] = '指紋認証ログインを有効にする';
$string['freemium.subscription'] = 'サイトサブスクリプション';
$string['freemium.subscriptiondetails'] = 'サブスクリプション詳細';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} 件のカスタム言語ストリングは無視されます。';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} 件のカスタムメニューアイテムは無視されます。';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} 件の無効に設定された機能が有効なままです。';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'あなたのカスタムテーマは適用されません。';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'あなたのサイトロゴは適用されません。';
$string['freemium.subscriptionfeature_limited'] = '{{ limit }} に制限する';
$string['freemium.subscriptionfeature_unlimited'] = '無制限';
$string['freemium.subscriptionplan'] = 'サブスクリプションプラン';
$string['freemium.subscriptionplan_bma'] = 'BMA';
$string['freemium.subscriptionplan_expired'] = '期限切れ';
$string['freemium.subscriptionplan_free'] = '無料';
$string['freemium.subscriptionplan_premium'] = 'プレミアム';
$string['freemium.subscriptionplan_pro'] = 'プロ';
$string['freemium.subscriptionplan_upgrade'] = 'あなたのプランをアップグレードする';
$string['freemium.subscriptionplan_validuntil'] = '{{ date }} まで有効';
$string['freemium.subscriptionplandescription'] = 'サブスクリプションプランはこのサイトに適用される制限を示します。';
$string['freemium.subscriptionplanlearnmore'] = 'もっと見る';
$string['freemium.upsell_renewexpired'] = 'あなたのサブスクリプションの有効期限が切れました。';
$string['freemium.upsell_renewexpiring'] = 'あなたのサブスクリプションは {{ days }} 日で有効期限が切れます。';
$string['freemium.upsell_renewtitle'] = 'あなたのサブスクリプションを更新する';
$string['freemium.upsell_upgradefreeaccept'] = 'アップグレード';
$string['freemium.upsell_upgradefreemessage'] = '現在、無料プランを使用中です。アップグレードして、より多くの機能をお試しください。';
$string['freemium.upsell_upgradefreepostpone'] = '後で';
$string['freemium.upsell_upgradefreetitle'] = 'アップグレードする';
$string['pluginname'] = 'Moodle App言語文字列';
$string['privacy_metadata'] = 'このプラグインはユーザーデータを一切保存しません。';
