<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'ja', version '3.11'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'あなたにはまもなく始まるBigBlueButtonBNセッションがあります。';
$string['bbbduetimeoverstartingtime'] = 'この活動の終了日は開始日以降に設定する必要があります。';
$string['bbbdurationwarning'] = 'このセッションの最大継続時間は %duration% 分です。';
$string['bbbrecordallfromstartwarning'] = 'このセッションは開始と同時にレコーディングされます。';
$string['bbbrecordwarning'] = 'このセッションはレコーディングできます。';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = '新しいBigBlueButtonルーム/活動を追加する';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'ライブセッションインスタンスを作成する';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'レコーディングできるインスタンスを作成する';
$string['bigbluebuttonbn:deleterecordings'] = 'レコーディングを削除する';
$string['bigbluebuttonbn:importrecordings'] = 'レコーディングをインポートする';
$string['bigbluebuttonbn:join'] = 'BigBlueButtonミーティングに参加する';
$string['bigbluebuttonbn:managerecordings'] = 'レコーディングを管理する';
$string['bigbluebuttonbn:protectrecordings'] = 'レコーディングを保護する';
$string['bigbluebuttonbn:publishrecordings'] = 'レコーディングを公開する';
$string['bigbluebuttonbn:unprotectrecordings'] = 'レコーディングを保護解除する';
$string['bigbluebuttonbn:unpublishrecordings'] = 'レコーディングを非公開にする';
$string['bigbluebuttonbn:view'] = 'ルーム/活動を表示する';
$string['cachedef_currentfetch'] = '最近取得したデータを一覧表示するデータです。';
$string['cachedef_recordings'] = 'レコーディングメタデータ';
$string['cachedef_serverinfo'] = 'リモートサーバ情報';
$string['cachedef_validatedurls'] = '検証済みURLチェックのキャッシュ';
$string['calendarstarts'] = '{$a} は次にスケジュールされています:';
$string['cannotperformaction'] = 'このレコーディングではアクション {$a} を実行できません。';
$string['completionattendance'] = '学生は次のミーティングに参加する必要があります:';
$string['completionattendance_desc'] = '学生はルームに入って少なくとも {$a} 分はセッションに参加する必要があります。';
$string['completionattendance_event_desc'] = '学生は少なくとも {$a} 分以上ルームに入っているかセッションに参加しています。';
$string['completionattendancegroup'] = '要出席';
$string['completionattendancegroup_help'] = '完了には (n) 分のミーティング参加を要します。';
$string['completionengagement_desc'] = 'ミーティング中、学生は活動に参加する必要があります。';
$string['completionengagementchats'] = 'チャットイベント';
$string['completionengagementchats_desc'] = '完了するには学生は {$a} 件のチャットに参加する必要があります。';
$string['completionengagementchats_event_desc'] = '{$a} 件のチャットを立ち上げました。';
$string['completionengagementemojis'] = '絵文字';
$string['completionengagementemojis_desc'] = '完了するには学生は投票に {$a} 個の絵文字を送信する必要があります。';
$string['completionengagementemojis_event_desc'] = '{$a} 件の絵文字を立ち上げました。';
$string['completionengagementgroup'] = '要関与';
$string['completionengagementgroup_help'] = '完了するにはセッション中の積極的な参加が必要です。';
$string['completionengagementpollvotes'] = '投票結果';
$string['completionengagementpollvotes_desc'] = '完了するには学生は {$a} 回の投票が必要です。';
$string['completionengagementpollvotes_event_desc'] = '{$a} 件の投票を立ち上げました。';
$string['completionengagementraisehand'] = '挙手イベント';
$string['completionengagementraisehand_desc'] = '完了するには学生は {$a} 回挙手する必要があります。';
$string['completionengagementraisehand_event_desc'] = '{$a} 件の挙手を立ち上げました。';
$string['completionengagementtalks'] = 'トークイベント';
$string['completionengagementtalks_desc'] = '完了するには学生は {$a} 回トークする必要があります。';
$string['completionengagementtalks_event_desc'] = '{$a} 件のトークを立ち上げました。';
$string['completionupdatestate'] = '完了更新状況';
$string['completionvalidatestate'] = '完了確認';
$string['completionvalidatestatetriggered'] = '検証完了がトリガーされました。';
$string['completionview'] = '要閲覧';
$string['completionview_desc'] = '完了するには学生はルームを閲覧する必要があります。';
$string['completionview_event_desc'] = 'ルームページを閲覧しました。';
$string['config_checksum_algorithm'] = 'BigBlueButtonチェックサムアルゴリズム';
$string['config_default_messages'] = 'デフォルトメッセージ';
$string['config_default_messages_description'] = '活動のメッセージデフォルトを設定する';
$string['config_disablecam_default'] = '「カメラ有効化」をデフォルトで無効にする';
$string['config_disablecam_default_description'] = 'この設定を有効にした場合、ウェブカメラは無効にされます。';
$string['config_disablecam_editable'] = '「カメラ無効化」を編集できる';
$string['config_disablecam_editable_description'] = 'デフォルトでの「カメラ無効化」はインスタンス追加または更新時に編集できます。';
$string['config_disablemic_default'] = '「マイク有効化」をデフォルトで無効にする';
$string['config_disablemic_default_description'] = 'この設定を有効にした場合、マイクは無効にされます。';
$string['config_disablemic_editable'] = '「マイク無効化」を編集できる';
$string['config_disablemic_editable_description'] = 'デフォルトでの「マイク無効化は」インスタンス追加または更新時に編集できます。';
$string['config_disablenote_default'] = '「共有ノート有効化」をデフォルトで無効にする';
$string['config_disablenote_default_description'] = 'この設定を有効にした場合、共有ノートは無効にされます。';
$string['config_disablenote_editable'] = '「共有ノート無効化」を編集できる';
$string['config_disablenote_editable_description'] = 'デフォルトでの「共有ノート無効化」はインスタンス追加または更新時に編集できます。';
$string['config_disableprivatechat_default'] = '「プライベートチャット有効化」をデフォルトで無効にする';
$string['config_disableprivatechat_default_description'] = 'この設定を有効にした場合、プライベートチャットは無効にされます。';
$string['config_disableprivatechat_editable'] = '「プライベートチャット無効化」を編集できる';
$string['config_disableprivatechat_editable_description'] = 'デフォルトでの「プライベートチャット無効化」はインスタンス追加または更新時に編集できます。';
$string['config_disablepublicchat_default'] = '「パブリックチャット有効化」をデフォルトで無効にする';
$string['config_disablepublicchat_default_description'] = 'この設定を有効にした場合、パブリックチャットは無効にされます。';
$string['config_disablepublicchat_editable'] = '「パブリックチャット無効化」を編集できる';
$string['config_disablepublicchat_editable_description'] = 'デフォルトでの「パブリックチャット無効化」はインスタンス追加または更新時に編集できます。';
$string['config_experimental_features'] = '実験機能設定';
$string['config_experimental_features_description'] = '実験機能設定';
$string['config_extended_capabilities'] = '拡張機能設定';
$string['config_extended_capabilities_description'] = 'BigBlueButtonサーバが提供できる拡張機能の設定です。';
$string['config_general'] = '一般設定';
$string['config_general_description'] = 'これらの設定は<b>常に</b>使用されます。';
$string['config_hideuserlist_default'] = '「ユーザ一覧秘匿」をデフォルトで有効にする';
$string['config_hideuserlist_default_description'] = 'この設定を有効にした場合、セッションユーザ一覧は秘匿されます。';
$string['config_hideuserlist_editable'] = '「ユーザ一覧を秘匿する」を編集できる';
$string['config_hideuserlist_editable_description'] = 'デフォルトでの「ユーザ一覧を秘匿する」はインスタンス追加または更新時に編集できます。';
$string['config_importrecordings'] = '「レコーディングインポート」機能設定';
$string['config_importrecordings_description'] = 'これらの設定は機能ごとに異なります。';
$string['config_importrecordings_enabled'] = 'レコーディングインポート有効';
$string['config_importrecordings_enabled_description'] = 'この設定およびレコーディング機能が有効にされた場合、異なるコースから活動にレコーディングをインポートできます。';
$string['config_importrecordings_from_deleted_enabled'] = '削除済みコースのレコーディングインポート有効化';
$string['config_importrecordings_from_deleted_enabled_description'] = 'この設定およびレコーディングインポート機能が有効にされた場合、コース内に存在しなくなった活動からレコーディングをインポートできます。';
$string['config_lockonjoin_default'] = '「参加時のロック無視」をデフォルトで有効にする';
$string['config_lockonjoin_default_description'] = 'この設定を有効にした場合、ロック設定は無視されます。これを適用するにはロック設定を有効にする必要があります。';
$string['config_lockonjoin_editable'] = '「参加時のロック無視」を編集できる';
$string['config_lockonjoin_editable_description'] = 'デフォルトでの「参加時のロック無視」はインスタンス追加または更新時に編集できます。';
$string['config_locksettings'] = 'ロック設定';
$string['config_locksettings_description'] = 'これらの設定はロック設定のためのUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。';
$string['config_meetingevents_enabled'] = 'ライブイベントを登録する';
$string['config_meetingevents_enabled_description'] = 'セッション終了後にライブイベントを受け付けて処理するプラグインを有効にします。(これは「活動完了」で有効にする必要があります。また、BigBlueButtonサーバがpost_eventsスクリプトを処理できる場合にのみ動作します)';
$string['config_muteonstart'] = '「開始時ミュートする」機能設定';
$string['config_muteonstart_default'] = '「開始時ミュート」をデフォルトで有効にする';
$string['config_muteonstart_default_description'] = 'この設定を有効にした場合、セッションは開始時にミュートされます。';
$string['config_muteonstart_description'] = 'これらの設定はUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。';
$string['config_muteonstart_editable'] = '「開始時ミュート」を編集できる';
$string['config_muteonstart_editable_description'] = 'デフォルトでの「開始時ミュート」はインスタンス追加または更新時に編集できます。';
$string['config_participant'] = '参加者設定';
$string['config_participant_description'] = 'これらの設定ではカンファレンス参加者のデフォルトのロールを定義します。';
$string['config_participant_moderator_default'] = 'デフォルトのモデレータ';
$string['config_participant_moderator_default_description'] = 'このルールは新しいルームの追加時にデフォルトで使用されます。';
$string['config_presentation_default'] = '「プレアップロードプレゼンテーション」機能デフォルト';
$string['config_presentation_default_description'] = '「プレアップロードプレゼンテーション」が有効な場合、この設定ではすべてのBBBインスタンスでデフォルトとして使用するファイルを選択できます。';
$string['config_preuploadpresentation'] = '「プレアップロードプレゼンテーション」機能設定';
$string['config_preuploadpresentation_description'] = 'これらの設定はUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。この機能はMoodleサーバがBigBlueButtonにアクセスできる場合のみ動作します。';
$string['config_preuploadpresentation_editable'] = 'プリアップロードプレゼンテーション編集可';
$string['config_preuploadpresentation_editable_description'] = 'ルームまたはカンファレンスの追加または更新時にUIでプリアップロードプレゼンテーション機能を編集できます。';
$string['config_recording'] = '「ミーティング記録」機能設定';
$string['config_recording_all_from_start_default'] = '最初からすべてレコーディングする';
$string['config_recording_all_from_start_default_description'] = 'この設定を有効にした場合、ミーティングは最初から記録されます。';
$string['config_recording_all_from_start_editable'] = '「最初からすべてレコーディングする」を編集できる';
$string['config_recording_all_from_start_editable_description'] = 'この設定を有効に場合、インターフェースには「最初からすべてレコーディングする」機能を有効または無効にするオプションが含まれます。';
$string['config_recording_default'] = '「レコーディング」機能をデフォルトで有効にする';
$string['config_recording_default_description'] = 'この設定を有効にした場合、BigBlueButtonで作成されたセッションにはレコーディング機能が含まれます。';
$string['config_recording_description'] = 'これらの設定は機能ごとに異なります。';
$string['config_recording_editable'] = '「レコーディング」機能を編集できる';
$string['config_recording_editable_description'] = 'この設定を有効に場合、インターフェースにはレコーディング機能を有効または無効にするオプションが含まれます。';
$string['config_recording_hide_button_default'] = 'レコーディングボタンを秘匿する';
$string['config_recording_hide_button_default_description'] = 'この設定を有効に場合、レコーディングボタンが秘匿されます。';
$string['config_recording_hide_button_editable'] = '「レコーディング秘匿ボタン」を編集できる';
$string['config_recording_hide_button_editable_description'] = 'この設定を有効に場合、インターフェースにはレコーディングボタン秘匿機能を有効または無効にするオプションが含まれます。';
$string['config_recording_protect_editable'] = '保護されたレコーディング状態を編集できる';
$string['config_recording_protect_editable_description'] = 'この設定を有効にした場合、インターフェースにレコーディングの保護/保護解除オプションが含まれます。';
$string['config_recording_refresh_period'] = 'レコーディング更新期間 (秒)';
$string['config_recording_refresh_period_description'] = 'レコーディングのリモート情報を更新するためにどのくらいの頻度でBigBlueButtonサーバに問い合わせしますか?';
$string['config_recordingready_enabled'] = 'レコーディング準備完了時、通知を送信する';
$string['config_recordingready_enabled_description'] = 'レコーディング準備完了時に通知を送信するプラグインを有効にします。(BigBlueButtonサーバでスクリプトpost_publish_recording_ready_callbackが有効にされている場合のみ動作します)';
$string['config_recordings'] = '「レコーディングを表示する」機能設定';
$string['config_recordings_description'] = 'これらの設定は機能ごとに異なります。';
$string['config_recordings_general'] = 'レコーディング設定を表示する';
$string['config_recordings_general_description'] = 'これらの設定はレコーディング表示時のみ使用できます。';
$string['config_recordings_imported_default'] = '「インポートリンクのみ表示する」をデフォルトで有効にする';
$string['config_recordings_imported_default_description'] = 'この設定を有効にした場合、レコーディングテーブルにはインポートされたレコーディングへのリンクのみ含まれます。';
$string['config_recordings_imported_editable'] = '「インポートリンクのみ表示する」機能を編集できる';
$string['config_recordings_imported_editable_description'] = 'デフォルトでの「インポートリンクのみ表示する」はインスタンス追加または更新時に編集できます。';
$string['config_recordings_preview_default'] = '「プレビュー」をデフォルトで有効にする';
$string['config_recordings_preview_default_description'] = 'この設定を有効にした場合、テーブルにプレゼンテーションのプレビュが含まれます。';
$string['config_recordings_preview_editable'] = '「プレビュー」機能を編集できる';
$string['config_recordings_preview_editable_description'] = '「プレビュー」機能はインスタンス追加または更新時に編集できます。';
$string['config_recordings_sortorder'] = 'レコーディングを昇順に並べ替える';
$string['config_recordings_sortorder_description'] = 'デフォルトではレコーディングは降順で表示されます。この設定を有効にした場合、昇順で表示されます。';
$string['config_scheduled'] = '「スケジュールセッション」設定';
$string['config_scheduled_description'] = 'これらの設定ではスケジュールセッションのデフォルトの挙動を設定します。';
$string['config_scheduled_pre_opening'] = 'オープニング時間前にアクセスできる (分)';
$string['config_scheduled_pre_opening_description'] = 'スケジュールオープニング時間前にセッションにアクセス可能な時間 (分) です。';
$string['config_sendnotifications'] = '「通知送信」機能設定';
$string['config_sendnotifications_description'] = 'これらの設定はUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。';
$string['config_sendnotifications_enabled'] = '通知送信有効';
$string['config_sendnotifications_enabled_description'] = 'この設定を有効にした場合、活動を編集するためのUIには活動追加または更新時に登録済みユーザに通知を送信するオプションが含まれます。';
$string['config_server_url'] = 'BigBlueButtonサーバURL';
$string['config_server_url_description'] = 'あなたのBigBlueButtonサーバのURLは「/bigbluebutton/」で終了する必要があります (このデフォルトURLはあなたがテストに利用できるBlindside Networksにより提供されているBigBlueButtonサーバのURLです)。';
$string['config_shared_secret'] = 'BigBlueButton共有秘密鍵';
$string['config_shared_secret_description'] = 'あなたのBigBlueButtonサーバのセキュリティsaltです (このデフォルトsaltはあなたがテストに利用できるBlindside Networksにより提供されているBigBlueButtonサーバのsaltです)。';
$string['config_uidelegation_enabled'] = 'UIデリゲーション有効';
$string['config_uidelegation_enabled_description'] = 'これらの設定はBigBlueButtonサーバへのUIのデリゲーションを有効または無効にします。';
$string['config_userlimit'] = '「ユーザ制限」機能設定';
$string['config_userlimit_default'] = '「ユーザ制限」デフォルトでを有効にする';
$string['config_userlimit_default_description'] = '新しいルームまたはカンファレンス追加時にデフォルトでセッションに許可されるユーザ数を設定します。ゼロに設定した場合、制限は設けられません';
$string['config_userlimit_description'] = 'これらの設定はUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。';
$string['config_userlimit_editable'] = '「ユーザ制限」機能を編集できる';
$string['config_userlimit_editable_description'] = '「ユーザ制限」はルームまたはカンファレンスの追加または更新時に編集できます。';
$string['config_voicebridge'] = '「ボイスブリッジ」機能設定';
$string['config_voicebridge_description'] = 'これらの設定はUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。';
$string['config_voicebridge_editable'] = '「カンファレンスボイスブリッジ」を編集できる';
$string['config_voicebridge_editable_description'] = 'カンファレンスボイスブリッジ番号はルームカンファレンスに恒久的に割り当てできます。割り当てられた番号は他のルームまたはカンファレンスで使用できません。';
$string['config_waitformoderator'] = '「モデレータ待ち」機能設定';
$string['config_waitformoderator_cache_ttl'] = '「モデレータ待ち」キャッシュTTL (秒)';
$string['config_waitformoderator_cache_ttl_description'] = 'このプラグインではクライアントの高負荷をサポートするためキャッシュを使用します。このパラメータは次のリクエストがBigBlueButtonサーバに送信されるまでのキャッシュ保持時間を定義します。';
$string['config_waitformoderator_default'] = '「モデレータ待ちを」デフォルトで有効にする';
$string['config_waitformoderator_default_description'] = '「モデレータ待ち」機能は新しいルームまたはカンファレンス追加時にデフォルトで有効にされます。';
$string['config_waitformoderator_description'] = 'これらの設定は機能ごとに異なります。';
$string['config_waitformoderator_editable'] = '「モデレータ待ち」機能を編集できる';
$string['config_waitformoderator_editable_description'] = '「モデレータ待ち」はルームまたはカンファレンスの追加または更新時に編集できます。';
$string['config_waitformoderator_ping_interval'] = 'モデレータ待ちピング (秒)';
$string['config_waitformoderator_ping_interval_description'] = '「モデレータ待ち」機能が有効にされた場合、クライアントは[number]秒ごとにセッション状態を確認するためpingします。このパラメータはMoodleサーバへのリクエスト間隔を定義します。';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonは非推奨のグローバル変数を持つconfig.phpを使用しています。今後のバージョンではサポートされないため、ファイルを変換してください。';
$string['config_warning_curl_not_installed'] = 'この機能ではPHPのcURL拡張モジュールがインストールおよび有効にされている必要があります。この条件に合致している場合のみ、設定にアクセスすることができます。';
$string['config_welcome_default'] = 'デフォルトウェルカムメッセージ';
$string['config_welcome_default_description'] = 'BigBlueButtonサーバに設定されているデフォルトメッセージを置換します。メッセージには自動的に置換されるキーワード  (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) および次のようなHTMLタグを含めます: <b>...</b> or <i></i>';
$string['config_welcome_editable'] = 'デフォルトのウェルカムメッセージは教師が編集可能です。';
$string['config_welcome_editable_description'] = 'インスタンスの追加または更新時にウェルカムメッセージの編集が可能です。';
$string['email_body_notification_meeting_by'] = 'by';
$string['email_body_notification_meeting_description'] = '説明';
$string['email_body_notification_meeting_details'] = '詳細';
$string['email_body_notification_meeting_end_date'] = '終了日';
$string['email_body_notification_meeting_has_been'] = 'が';
$string['email_body_notification_meeting_start_date'] = '開始日';
$string['email_body_notification_meeting_title'] = 'タイトル';
$string['email_body_recording_ready_for'] = 'レコーディング:';
$string['email_body_recording_ready_in_course'] = 'コース';
$string['email_footer_sent_by'] = 'この自動通知メッセージは次のユーザによって送信されました:';
$string['email_footer_sent_from'] = '- コース';
$string['end_session_confirm'] = '本当にセッションを終了してもよろしいですか?';
$string['end_session_confirm_title'] = '本当にセッションを終了してもよろしいですか?';
$string['end_session_notification'] = 'セッションは終了しました。';
$string['ends_at'] = '終了';
$string['event_activity_created'] = '活動が作成されました。';
$string['event_activity_deleted'] = '活動が削除されました。';
$string['event_activity_updated'] = '活動が更新されました。';
$string['event_live_session'] = 'ライブセッションイベント';
$string['event_meeting_created'] = 'ミーティングが作成されました。';
$string['event_meeting_ended'] = 'ミーティングが強制終了されました。';
$string['event_meeting_joined'] = 'ミーティングに参加しました。';
$string['event_meeting_left'] = 'ミーティングを退出しました。';
$string['event_recording_deleted'] = 'レコーディングが削除されました。';
$string['event_recording_edited'] = 'レコーディングが編集されました。';
$string['event_recording_imported'] = 'レコーディングがインポートされました。';
$string['event_recording_protected'] = 'レコーディングが保護されました。';
$string['event_recording_published'] = 'レコーディングが公開されました。';
$string['event_recording_unprotected'] = 'レコーディングが保護解除されました。';
$string['event_recording_unpublished'] = 'レコーディングが非公開にされました。';
$string['event_recording_viewed'] = 'レコーディングが閲覧されました。';
$string['event_unknown'] = '不明なイベント';
$string['general_error_cannot_create_meeting'] = 'セッションを作成できません。';
$string['general_error_cannot_get_recordings'] = 'レコーディングを取得できません。';
$string['general_error_no_answer'] = 'レスポンスが空です。BigBlueButtonサーバのURLを確認してしてください。また、BigBlueButtonサーバが稼働しているかどうか確認してください。';
$string['general_error_not_allowed_to_create_instances'] = 'ユーザーはすべてのタイプのインスタンスを作成できません。';
$string['general_error_not_found'] = 'エンティティが見つかりませんでした : {$a}';
$string['general_error_unable_connect'] = '接続できません。BigBlueButtonサーバのURLおよびBigBlueButtonサーバの稼働状況を確認してください。';
$string['index_confirm_end'] = '本当にバーチャルクラスを終了してもよろしいですか?';
$string['index_disabled'] = '無効';
$string['index_enabled'] = '有効';
$string['index_ending'] = 'バーチャルクラスルームを終了しています ... お待ちください。';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} が正しくありません。';
$string['index_error_checksum'] = 'チェックサムにエラーが発生しました。あなたが正しいsaltを入力したことを確認してください。';
$string['index_error_forciblyended'] = '手動で終了されたため、このミーティングに参加することはできません。';
$string['index_error_noinstances'] = 'BigBlueButtonのインスタンスはありません。';
$string['index_error_unable_display'] = 'ミーティングを表示できません。BigBlueButtonサーバのURLおよびBigBlueButtonサーバの稼働状況を確認してください。';
$string['index_heading'] = 'BigBlueButtonルーム';
$string['index_heading_actions'] = '操作';
$string['index_heading_group'] = 'グループ';
$string['index_heading_moderator'] = 'モデレータ';
$string['index_heading_name'] = 'ルーム';
$string['index_heading_recording'] = 'レコーディング';
$string['index_heading_users'] = 'ユーザ';
$string['index_heading_viewer'] = '視聴者';
$string['indicator:cognitivedepth'] = 'BigBlueButton設定';
$string['indicator:cognitivedepth_help'] = 'この指標はBigBlueButton活動で学生が到達した認知的な深さに基づきます。';
$string['indicator:socialbreadth'] = 'BigBlueButtonBNソーシャル';
$string['indicator:socialbreadth_help'] = 'この指標はBigBlueButton活動で学生が到達した社会的広がりに基づきます。';
$string['instance_type_default'] = 'ルーム/活動およびレコーディング';
$string['instance_type_recording_only'] = 'レコーディングのみ';
$string['instance_type_room_only'] = 'ルーム/活動のみ';
$string['instanceprofilewithoutrecordings'] = 'このインスタンスプロファイルはレコーディングを表示できません。';
$string['messageprovider:instance_updated'] = 'BigBlueButtonセッションが更新されました。';
$string['messageprovider:recording_ready'] = 'BigBlueButtonセッション利用可能';
$string['minute'] = '分';
$string['minutes'] = '分';
$string['mod_form_block_general'] = '一般設定';
$string['mod_form_block_participants'] = 'ライブセッション中に割り当てられたロール';
$string['mod_form_block_presentation'] = 'プレゼンテーションコンテンツ';
$string['mod_form_block_presentation_default'] = 'プレゼンテーションデフォルトコンテンツ';
$string['mod_form_block_record'] = 'レコーディング設定';
$string['mod_form_block_recordings'] = 'レコーディングを表示する';
$string['mod_form_block_room'] = '活動/ルーム設定';
$string['mod_form_block_schedule'] = 'セッションスケジュール';
$string['mod_form_field_closingtime'] = '参加終了';
$string['mod_form_field_conference_name'] = 'カンファレンス名';
$string['mod_form_field_disablecam'] = 'ウェブカメラを無効にする';
$string['mod_form_field_disablemic'] = 'マイクを無効にする';
$string['mod_form_field_disablenote'] = '共有ノートを無効にする';
$string['mod_form_field_disableprivatechat'] = 'プライベートチャットを無効にする';
$string['mod_form_field_disablepublicchat'] = 'パブリックチャットを無効にする';
$string['mod_form_field_duration'] = '継続時間';
$string['mod_form_field_duration_help'] = 'ミーティングの継続時間を設定することにより、レコーディングが終了するまでのミーティングの最大継続時間を設定します。';
$string['mod_form_field_hideuserlist'] = 'ユーザ一覧を秘匿する';
$string['mod_form_field_instanceprofiles'] = 'インスタンスタイプ';
$string['mod_form_field_instanceprofiles_help'] = 'BigBlueButtonインスタンスのタイプを選択してください。';
$string['mod_form_field_intro'] = '説明';
$string['mod_form_field_intro_help'] = 'ルームまたはカンファレンスの短い説明です。';
$string['mod_form_field_lockonjoin'] = 'ロック設定を無視する';
$string['mod_form_field_muteonstart'] = '開始時ミュートする';
$string['mod_form_field_name'] = 'バーチャルクラスルーム名';
$string['mod_form_field_nosettings'] = '編集できる設定はありません。';
$string['mod_form_field_notification'] = 'この変更を登録済みユーザに通知する';
$string['mod_form_field_notification_created_help'] = 'この活動が作成されたことをすべての登録済みユーザに知らせるため通知を送信します。';
$string['mod_form_field_notification_help'] = 'この活動が作成または修正されたことをすべての登録済みユーザに知らせるため通知を送信します。';
$string['mod_form_field_notification_modified_help'] = 'この活動が修正されたことをすべての登録済みユーザに知らせるため通知を送信します。';
$string['mod_form_field_notification_msg_at'] = '-';
$string['mod_form_field_notification_msg_created'] = '追加';
$string['mod_form_field_notification_msg_modified'] = '更新';
$string['mod_form_field_openingtime'] = '参加開始';
$string['mod_form_field_participant_add'] = '割り当てを追加する';
$string['mod_form_field_participant_bbb_role_moderator'] = 'モデレータ';
$string['mod_form_field_participant_bbb_role_viewer'] = '視聴者';
$string['mod_form_field_participant_list'] = '割り当てリスト';
$string['mod_form_field_participant_list_action_add'] = '追加する';
$string['mod_form_field_participant_list_action_remove'] = '削除する';
$string['mod_form_field_participant_list_text_as'] = '-';
$string['mod_form_field_participant_list_type_all'] = 'すべての登録済みユーザ';
$string['mod_form_field_participant_list_type_owner'] = 'オーナー';
$string['mod_form_field_participant_list_type_role'] = 'ロール';
$string['mod_form_field_participant_list_type_user'] = 'ユーザ';
$string['mod_form_field_record'] = 'セッションをレコーディングできる';
$string['mod_form_field_recordallfromstart'] = '最初からすべてレコーディングする';
$string['mod_form_field_recordhidebutton'] = 'レコーディングボタンを隠す';
$string['mod_form_field_recordings_html'] = 'プレインHTMLでテーブルを表示する';
$string['mod_form_field_recordings_imported'] = 'インポート済みリンクのみ表示する';
$string['mod_form_field_recordings_preview'] = 'レコーディングプレビュを表示する';
$string['mod_form_field_room_name'] = 'ルーム名';
$string['mod_form_field_userlimit'] = 'ユーザ制限';
$string['mod_form_field_userlimit_help'] = 'ミーティングで許可される最大ユーザ制限です。制限にゼロが設定された場合、ユーザ数は無制限となります。';
$string['mod_form_field_voicebridge'] = 'ボイスブリッジ [####]';
$string['mod_form_field_voicebridge_format_error'] = 'フォーマットエラーです。あなたは1から9999までの数字を入力する必要があります。';
$string['mod_form_field_voicebridge_help'] = 'ダイアルインを使用する場合、参加者がボイスカンファレンスに参加するために入力するボイスカンファレンスナンバーです。1から9999までの数字を入力する必要があります。値がゼロの場合、固定ボイスブリッジナンバーは無視されてBigBlueButtonによりランダムナンバーが生成されます。4桁が入力された場合、先頭に「7」が付加されます。';
$string['mod_form_field_voicebridge_notunique_error'] = '値がユニークではありません。このナンバーは別のルームまたはカンファレンスで使用されています。';
$string['mod_form_field_wait'] = 'モデレータを待つ';
$string['mod_form_field_wait_help'] = '視聴者はモデレータがセッションに入るまで待つ必要があります。';
$string['mod_form_field_welcome'] = 'ウェルカムメッセージ';
$string['mod_form_field_welcome_default'] = '<br /><b>%%CONFNAME%%</b>にようこそ!<br /><br />どのようにBigBlueButtonが動作するか理解するため私たちの<a href="event:http://www.bigbluebutton.org/content/videos"><u>チュートリアルビデオ</u></a>をご覧ください。<br /><br />オーディオブリッジに参加するには左上のヘッドセットアイコンをクリックしてください。<b>他の人への騒音を避けるため、ヘッドセットを使用してください。</b>';
$string['mod_form_field_welcome_help'] = 'BigBlueButtonサーバに設定されているデフォルトメッセージを置換します。メッセージには自動的に置換されるキーワード (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) を含むことができます。また次のようなHTMLタグを使用することもできます: <b>...</b> または <i></i>';
$string['mod_form_locksettings'] = 'ロック設定';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'あなたはBigBlueButtonBNを使用してMoodle内のリンクからリアルタイムのオンラインクラスルームを作成することができます。BigBlueButtonはオープンソースの遠隔教育用ウェブカンファレンスシステムです。

BigBlueButtonBNを使用することにより、あなたはタイトル、説明、カレンダーエントリ (セッションに参加できる日付範囲のため)、グループおよびオンラインセッションをレコーディングするための詳細を指定することができます。';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton活動';
$string['nosuchinstance'] = 'そのようなインスタンス {$a->entity} (ID: {$a->id}) は存在しません。';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButtonルームが作成されました。';
$string['notification_instance_created_small'] = '{$a->name} という名称の新しいBigBlueButtonルームが作成されました。';
$string['notification_instance_created_subject'] = '新しいBigBlueButtonルーム活動が作成されました。';
$string['notification_instance_description'] = '説明';
$string['notification_instance_end_date'] = '終了日';
$string['notification_instance_name'] = 'タイトル';
$string['notification_instance_start_date'] = '開始日';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButtonルームが更新されました。';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButtonセッションが更新されました。';
$string['notification_instance_updated_subject'] = 'あなたのBigBlueButtonルームが更新されました。';
$string['notification_recording_ready_html'] = 'BigBlueButtonルーム <a href="{$a->link}">{$a->name}</a> でのセッションのレコーディングが利用可能となりました。';
$string['notification_recording_ready_plain'] = 'BigBlueButtonルーム {$a->name} でのセッションのレコーディングが利用可能となりました。レコーディングリンクにアクセスするには {$a->link} に移動してください。';
$string['notification_recording_ready_small'] = 'BigBlueButton {$a->name} のレコーディングが利用可能となりました。';
$string['notification_recording_ready_subject'] = 'レコーディング利用可能';
$string['pluginadministration'] = 'BigBlueButton管理';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'BigBlueButtonセッションを作成および参加するにはユーザデータをサーバと交換する必要があります。';
$string['privacy:metadata:bigbluebutton:fullname'] = 'BigBlueButtonサーバにアクセスするユーザのフルネームです。';
$string['privacy:metadata:bigbluebutton:userid'] = 'BigBlueButtonサーバにアクセスするユーザのユーザIDです。';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButtonセッションの機能および一般的な動作を定義するルームまたは活動の設定を保持します。';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'ライブミーティングでのユーザのロールを定義するルール一覧です。ロールまたはユーザごとにパーミッションを付与できるため、ユーザIDを保存できます。';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'プラグイン使用時に発生したイベントを保存します。';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'ユーザにより発生したイベントのタイプです。';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ユーザがアクセスしたミーティングIDです。';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'イベントに影響を受けたミーティングまたはレコーディングに関連する追加情報を含めます。';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'ログが作成された時間です。';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'イベントを発生させたユーザのユーザIDです。';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'レコーディングに関するメタデータを保存します。';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = '最後にレコーディングを変更したユーザのユーザIDです。';
$string['recordings_from_deleted_activities'] = '削除された活動のレコーディング';
$string['recordingurlnotfound'] = 'レコーディングURLは有効ではありません。';
$string['removedevents'] = '削除されたイベント';
$string['removedlogs'] = '削除されたカスタムログ';
$string['removedrecordings'] = '削除されたレコーディング';
$string['removedtags'] = '削除されたタグ';
$string['report_join_info'] = 'ルーム参加 {$a} 回';
$string['report_play_recording_info'] = 'レコーディング再生 {$a} 回';
$string['report_room_view'] = 'ルーム閲覧済み';
$string['resetevents'] = 'イベントを削除';
$string['resetlogs'] = 'カスタムログを削除';
$string['resetlogs_help'] = 'ログの削除によりレコーディングへの参照を失うことになります。';
$string['resetrecordings'] = 'レコーディングの削除';
$string['resetrecordings_help'] = 'レコーディングを削除した場合、どこからもアクセスできなくなります。また、レコーディングを元に戻せません。';
$string['resettags'] = 'タグの削除';
$string['search:activity'] = 'BigBlueButton - 活動情報';
$string['search:tags'] = 'BigBlueButton - タグ情報';
$string['sendnotification'] = '通知を送信する';
$string['settings'] = 'BigBlueButton設定';
$string['started_at'] = '開始';
$string['starts_at'] = '開始';
$string['taskname:check_dismissed_recordings'] = 'レコーディングが解除されていないか確認する';
$string['taskname:check_pending_recordings'] = '保留中レコーディングを取得する';
$string['userlimitreached'] = 'セッションに参加できるユーザ数が上限に達しました。';
$string['view_conference_action_end'] = 'セッション終了';
$string['view_conference_action_join'] = 'セッションに参加する';
$string['view_error_action_not_completed'] = 'アクションを完了できませんでした。';
$string['view_error_bigbluebutton'] = 'BigBlueButtonにエラーが発生しました: {$a}';
$string['view_error_create'] = 'BigBlueButtonサーバがエラーメッセージを返しました。ミーティングを作成することはできません。';
$string['view_error_current_state_not_found'] = '現在の状態が見つかりませんでした。レコーディングが削除されたか、実行したアクションにBigBlueButtonサーバが対応していない可能性があります。';
$string['view_error_import_no_courses'] = 'レコーディングのために検索するコースはありません。';
$string['view_error_import_no_recordings'] = 'このコースにはインポートするレコーディングはありません。';
$string['view_error_invalid_session'] = 'セッションの有効期限が切れました。活動メインページに戻ってください。';
$string['view_error_max_concurrent'] = '許可される同時ミーティング数に達しました。';
$string['view_error_meeting_not_running'] = '問題が発生しました。ミーティングが実行されていません。';
$string['view_error_no_group'] = 'まだ設定されているグループはありません。ミーティングに参加する前にグループを準備してください。';
$string['view_error_no_group_student'] = 'あなたはグループに参加していません。あなたの教師または管理者にご連絡ください。';
$string['view_error_no_group_teacher'] = 'またグループは設定されていません。グループを作成するか管理者にご連絡ください。';
$string['view_error_unable_join'] = 'ミーティングに参加できません。BigBlueButtonサーバのURLおよびBigBlueButtonサーバの稼働状況を確認してください。';
$string['view_error_unable_join_student'] = 'BigBlueButtonサーバに接続できません。あなたの教師または管理者にご連絡ください。';
$string['view_error_unable_join_teacher'] = 'BigBlueButtonサーバに接続できません。管理者にご連絡ください。';
$string['view_error_url_missing_parameters'] = 'このURLにはパラメータが不足しています。';
$string['view_error_userlimit_reached'] = 'ミーティングに許可されるユーザ数に達しました。';
$string['view_groups_nogroups_warning'] = 'ルームはグループを使用するよう設定されていますが、コースにはグループが定義されていません。';
$string['view_groups_notenrolled_warning'] = 'ルームはグループを使用するよう設定されていますが、あなたのどのグループにも登録されていません。';
$string['view_groups_selection'] = 'あなたが参加したいグループを選択して操作を確認してください。';
$string['view_groups_selection_join'] = '参加';
$string['view_groups_selection_warning'] = 'それぞれのグループにカンファレンスルームがあります。あなたは2つ以上のカンファレンスルームにアクセスしています。正しいカンファレンスルームを選択してください。';
$string['view_login_moderator'] = 'モデレータとしてログインする ...';
$string['view_login_viewer'] = '視聴者としてログインする ...';
$string['view_message_and'] = 'および';
$string['view_message_conference_has_ended'] = 'このカンファレンスは終了しています。';
$string['view_message_conference_in_progress'] = 'このカンファレンスは開催中です。';
$string['view_message_conference_not_started'] = 'このカンファレンスはまだ開始されていません。';
$string['view_message_conference_room_ready'] = 'このカンファレンスルームの準備が完了しました。あなたはセッションに参加することができます。';
$string['view_message_conference_user_limit_reached'] = 'セッションで許可されるユーザ数に達しました。';
$string['view_message_conference_wait_for_moderator'] = '参加するためのモデレータを待っています。';
$string['view_message_finished'] = 'この活動は終了しました。';
$string['view_message_has_joined'] = '参加しました。';
$string['view_message_have_joined'] = '参加しました。';
$string['view_message_hour'] = '時間';
$string['view_message_hours'] = '時間';
$string['view_message_importrecordings_disabled'] = 'このサーバではレコーディングインポート機能のリンクが無効にされています。';
$string['view_message_minute'] = '分';
$string['view_message_minutes'] = '分';
$string['view_message_moderator'] = 'モデレータ';
$string['view_message_moderators'] = 'モデレータ';
$string['view_message_norecordings'] = '表示するレコーディングはありません。';
$string['view_message_notavailableyet'] = 'このセッションはまだ利用できません。';
$string['view_message_recordings_disabled'] = 'このサーバはレコーディング機能が無効にされています。レコーディング専用のBigBlueButtonインスタンスは利用できません。';
$string['view_message_room_closed'] = 'このルームはクローズされています。';
$string['view_message_room_open'] = 'このルームはオープンされています。';
$string['view_message_room_ready'] = 'このルームの準備が完了しました。';
$string['view_message_session_for'] = 'セッション:';
$string['view_message_session_has_user'] = '&nbsp;';
$string['view_message_session_has_users'] = '&nbsp;';
$string['view_message_session_no_users'] = 'このセッションにはユーザはいません。';
$string['view_message_session_running_for'] = 'このセッションは次の時間開催されています:';
$string['view_message_session_started_at'] = 'このセッションは次の時間に開始しました:';
$string['view_message_tab_close'] = 'タブ/ウィンドウは手動で閉じる必要があります。';
$string['view_message_times'] = '回';
$string['view_message_user'] = 'ユーザ';
$string['view_message_users'] = 'ユーザ';
$string['view_message_viewer'] = '視聴者';
$string['view_message_viewers'] = '視聴者';
$string['view_mobile_message_groups_not_supported'] = 'このインスタンスはグループでの作業が可能ですが、モバイルアプリではサポートされていません。グループサポートを使用したい場合、デスクトップで開いてください。';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'あなたはこのページで45秒を超えました。会議に正しく参加するにはページをリロードしてください。';
$string['view_noguests'] = 'BigBlueButtonBNはゲストには公開されていません。';
$string['view_nojoin'] = 'あなたはこのセッションに参加できるロールではありません。';
$string['view_recording'] = 'レコーディング';
$string['view_recording_actionbar'] = 'ツールバー';
$string['view_recording_activity'] = '活動';
$string['view_recording_button_import'] = 'レコーディングインポートリンク';
$string['view_recording_button_return'] = '戻る';
$string['view_recording_course'] = 'コース';
$string['view_recording_date'] = '日付';
$string['view_recording_delete_confirmation'] = '本当にこの {$a} を削除してもよろしいですか?';
$string['view_recording_delete_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動にインポートされた {$a} のリンクがあります。レコーディングが削除された場合、インポートされたリンクも削除されます。';
$string['view_recording_delete_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動にインポートされた {$a} のリンクがあります。レコーディングが削除された場合、インポートされたリンクも削除されます。';
$string['view_recording_description'] = '説明';
$string['view_recording_description_edithint'] = 'レコーディングを識別するため説明を追加できます。';
$string['view_recording_description_editlabel'] = '説明を編集する';
$string['view_recording_duration'] = '継続時間';
$string['view_recording_duration_min'] = '分';
$string['view_recording_format_errror_unreachable'] = 'このレコーディングフォーマットのURLには到達できません。';
$string['view_recording_format_notes'] = 'ノート';
$string['view_recording_format_podcast'] = 'ポッドキャスト';
$string['view_recording_format_presentation'] = 'プレゼンテーション';
$string['view_recording_format_screenshare'] = 'スクリーン共有';
$string['view_recording_format_statistics'] = '統計';
$string['view_recording_format_video'] = 'ビデオ';
$string['view_recording_import_confirmation'] = '本当にこのレコーディングをインポートしてもよろしいですか?';
$string['view_recording_length'] = '長さ';
$string['view_recording_link'] = 'インポート済みリンク';
$string['view_recording_link_warning'] = 'このリンクは異なるコースまたは活動で作成されたレコーディングを指しています。';
$string['view_recording_list_action_delete'] = '削除';
$string['view_recording_list_action_edit'] = '更新';
$string['view_recording_list_action_play'] = '再生';
$string['view_recording_list_action_process'] = '処理中';
$string['view_recording_list_action_protect'] = '保護中';
$string['view_recording_list_action_publish'] = '公開';
$string['view_recording_list_action_unprotect'] = '保護解除';
$string['view_recording_list_action_unpublish'] = '非公開';
$string['view_recording_list_action_update'] = '更新';
$string['view_recording_list_actionbar'] = 'ツールバー';
$string['view_recording_list_actionbar_delete'] = '削除';
$string['view_recording_list_actionbar_edit'] = '編集';
$string['view_recording_list_actionbar_hide'] = '隠す';
$string['view_recording_list_actionbar_import'] = 'インポート';
$string['view_recording_list_actionbar_protect'] = '非公開にする';
$string['view_recording_list_actionbar_publish'] = '公開する';
$string['view_recording_list_actionbar_show'] = '表示する';
$string['view_recording_list_actionbar_unprotect'] = '公開にする';
$string['view_recording_list_actionbar_unpublish'] = '非公開にする';
$string['view_recording_list_activity'] = '活動';
$string['view_recording_list_course'] = 'コース';
$string['view_recording_list_date'] = '日付';
$string['view_recording_list_description'] = '説明';
$string['view_recording_list_duration'] = '継続時間';
$string['view_recording_list_recording'] = 'レコーディング';
$string['view_recording_meeting'] = 'ミーティング';
$string['view_recording_modal_button'] = '適用';
$string['view_recording_modal_title'] = 'レコーディングの値を設定する';
$string['view_recording_name'] = '名称';
$string['view_recording_name_edithint'] = 'レコーディングを識別するため名称を追加できます。';
$string['view_recording_name_editlabel'] = '名称を編集する';
$string['view_recording_playback'] = 'プレイバック';
$string['view_recording_preview'] = 'プレビュー';
$string['view_recording_preview_help'] = 'フルサイズで表示するにはイメージにカーソルを合わせてください。';
$string['view_recording_protect_confirmation'] = '本当にこの {$a} を保護してもよろしいですか?';
$string['view_recording_protect_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが保護されている場合、インポートされたリンクにも影響します。';
$string['view_recording_protect_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが保護されている場合、インポートされたリンクにも影響します。';
$string['view_recording_publish_confirmation'] = '本当にこの {$a} を公開してもよろしいですか?';
$string['view_recording_publish_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが公開されている場合、インポートされたリンクも公開されます。';
$string['view_recording_publish_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが公開されている場合、インポートされたリンクも公開されます。';
$string['view_recording_publish_link_deleted'] = '現在のBigBlueButtonサーバに実際のレコーディングが存在しないため、このリンクは再公開できません。このリンクは削除してください。';
$string['view_recording_publish_link_not_published'] = '実際のレコーディングが非公開のため、このリンクは再公開できません。';
$string['view_recording_recording'] = 'レコーディング';
$string['view_recording_select_course'] = 'ドロップダウンメニューで最初にコースを選択する';
$string['view_recording_tags'] = 'タグ';
$string['view_recording_unprotect_confirmation'] = '本当にこの {$a} を保護解除してもよろしいですか?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが保護解除された場合、インポートされたリンクにも影響します。';
$string['view_recording_unprotect_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが保護解除された場合、インポートされたリンクにも影響します。';
$string['view_recording_unprotect_link_deleted'] = '現在のBigBlueButtonサーバに実際のレコーディングが存在しないため、このリンクは保護解除できません。このリンクは削除してください。';
$string['view_recording_unprotect_link_not_unprotected'] = '実際のレコーディングが保護されているため、このリンクは保護解除できません。';
$string['view_recording_unpublish_confirmation'] = '本当に {$a} を非公開にしてもよろしいですか?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動にインポートされた {$a} のリンクがあります。レコーディングが非公開にされた場合、インポートされたリンクも非公開にされます。';
$string['view_recording_unpublish_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動にインポートされた {$a} のリンクがあります。レコーディングが非公開にされた場合、インポートされたリンクも非公開にされます。';
$string['view_recording_yui_first'] = '最初';
$string['view_recording_yui_go'] = 'Go';
$string['view_recording_yui_last'] = '最後';
$string['view_recording_yui_next'] = '次へ';
$string['view_recording_yui_page'] = 'ページ';
$string['view_recording_yui_prev'] = '前へ';
$string['view_recording_yui_rows'] = '行';
$string['view_recording_yui_show_all'] = 'すべてを表示する';
$string['view_room'] = 'ルームを表示する';
$string['view_section_title_presentation'] = 'プレゼンテーションファイル';
$string['view_section_title_recordings'] = 'レコーディング';
$string['view_warning_default_server'] = 'このMoodleサーバはデフォルト設定済みのBigBlueButtonテストサーバを使用しています。実運用環境ではこのサーバを置き換える必要があります。';
$string['waitformoderator'] = 'モデレータの参加を待っています。';
