<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'pt', version '3.11'.
 *
 * @package     zoom
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountid'] = 'ID conta Zoom';
$string['actions'] = 'Ações';
$string['addparticipant'] = 'Adicionar um participante';
$string['addparticipantgroup'] = 'Adicionar um grupo de participantes';
$string['addroom'] = 'Adicionar uma sala';
$string['addroomalert'] = 'Adicionar uma sala ao clicar';
$string['addtocalendar'] = 'Adicionar ao calendário';
$string['allmeetings'] = 'Todas as reuniões';
$string['allmeetings_desc'] = 'Com essa configuração, pode controlar se uma hiperligação para a página de índice da atividade Zoom será exibida, ou não, na parte inferior de cada página da visão global da instância da atividade. Esta configuração afeta apenas a apresentação da hiperligação nas páginas da visão global da atividade Zoom. Mesmo que decida não mostrar a hiperligação, o utilizador poderá aceder à página de índice da atividades Zoom através de outras hiperligações da disciplina.';
$string['allmeetings_disable'] = 'Desativar todas as hiperligações de reuniões';
$string['allmeetings_enable'] = 'Ativar todas as hiperligações de reuniões';
$string['alternative_hosts'] = 'Anfitriões alternativos';
$string['alternative_hosts_disable'] = 'Desativar a opção de anfitriões alternativos';
$string['alternative_hosts_inputfield'] = 'Mostrar opção de anfitriões alternativos como campo de entrada simples';
$string['alternative_hosts_picker'] = 'Mostrar opção de anfitriões alternativos como seletor de utilizadores com preenchimento automático';
$string['alternative_hosts_picker_noneselected'] = 'Nenhum anfitrião alternativo selecionado';
$string['alternative_hosts_picker_placeholder'] = 'Selecionar utilizador(es)';
$string['apiurl'] = 'URL da API do Zoom';
$string['audio_both'] = 'Áudio do computador e telefone';
$string['audio_telephony'] = 'Apenas telefone';
$string['audio_voip'] = 'Apenas áudio do computador';
$string['audiodefault'] = 'Predefinição de áudio';
$string['authentication'] = 'Autenticação';
$string['autorecording_cloud'] = 'Nuvem';
$string['autorecording_local'] = 'Local';
$string['autorecording_none'] = 'Nenhum';
$string['autorecording_userdefault'] = 'Usar as configurações predefinidas do Zoom';
$string['autorecordingoptionsupdate'] = 'Opções de atualizar gravação automática';
$string['breakoutrooms'] = 'Salas temáticas';
$string['cachedef_zoomid'] = 'O ID do utilizador do Zoom';
$string['cachedef_zoommeetingsecurity'] = 'Configurações de segurança da reunião, incluindo o cumprimento dos requisitos de senha da conta';
$string['calendardescriptionURL'] = 'URL de acesso à reunião: {$a}.';
$string['calendardescriptionintro'] = '\\nDescrição:\\n{\\$a}';
$string['calendariconalt'] = 'Ícone do calendário';
$string['changehost'] = 'Mudar anfitrião';
$string['clickjoin'] = 'Clicou no botão de aceder à reunião';
$string['clientid'] = 'ID do cliente Zoom';
$string['connectionfailed'] = 'Erro na ligação:';
$string['connectionok'] = 'Ligação em funcionamento.';
$string['connectionsettings'] = 'Configurações da ligação';
$string['connectionsettings_desc'] = 'Estas configurações definem como o Moodle se liga ao Zoom.';
$string['connectionstatus'] = 'Estado da ligação';
$string['day'] = 'Dia(s)';
$string['defaultsettings'] = 'Configurações predefinidas do Zoom';
$string['defaultsettings_help'] = 'Estas configurações definem os valores predefinidos para todas as novas reuniões e webinars Zoom.';
$string['deletemeetingrecordings'] = 'Apagar gravações de reuniões do Moodle';
$string['deleteroom'] = 'Apagar sala';
$string['displayleadtime'] = 'Mostrar tempo de espera';
$string['displayleadtime_desc'] = 'Se ativar esta opção, será exibido aos utilizadores o tempo de espera. Desta forma, os utilizadores são informados de que / quando poderão ingressar na reunião antes do horário de início agendado. Isto pode impedir que os utilizadores recarreguem constantemente a página até que possam participar.';
$string['displayleadtime_nohideif'] = 'Aviso: Esta configuração só é processada se a configuração \'{$a}\' for definida com um valor maior que zero.';
$string['displaypassword'] = 'Mostrar código de acesso';
$string['downloadical'] = 'Descarregar iCal';
$string['downloadical_desc'] = 'Com esta configuração, pode controlar se será, ou não, exibida uma hiperligação para descarregar o ficheiro iCal para a reunião na página de visão global da instância da atividade. Esta configuração afeta apenas a possibilidade de descarregar o ficheiro iCal para ferramentas de calendário de terceiros. Independentemente desta configuração, a atividade de reunião do Zoom adicionará uma entrada de calendário ao calendário do Moodle assim que a data de início da reunião for definida.';
$string['downloadical_disable'] = 'Desativar descarregamento de iCal';
$string['downloadical_enable'] = 'Ativar descarregamento de iCal';
$string['duration'] = 'Duração (minutos)';
$string['encryptiontype'] = 'Tipo de encriptação';
$string['encryptiontype_alwaysshow'] = 'Mostrar sempre o seletor de tipo de encriptação, independentemente do utilizador poder, ou não, usar encriptação de ponto-a-ponto';
$string['encryptiontype_disable'] = 'Desativar o seletor do tipo de encriptação';
$string['encryptiontype_showonlyife2epossible'] = 'Mostrar apenas o seletor de tipo de encriptação se o utilizador puder usar encriptação de ponto-a-ponto';
$string['end_date_option_after'] = 'Depois';
$string['end_date_option_by'] = 'por';
$string['end_date_option_occurrences'] = 'ocorrências';
$string['enddate'] = 'Data de fim';
$string['endtime'] = 'Hora de fim';
$string['err_downloadicaldisabled'] = 'O descarregamento dos ficheiros iCal da reunião do Zoom foi desativado.';
$string['err_downloadicalrecurringempty'] = 'O descarregamento do ficheiro iCal da reunião do Zoom não é possível para esta reunião, um vez que não contém pelo menos uma única ocorrência.';
$string['err_downloadicalrecurringnofixed'] = 'O descarregamento do ficheiro iCal da reunião do Zoom não é possível para esta reunião, um vez que é uma reunião recorrente sem horário fixo.';
$string['err_duration_nonpositive'] = 'A duração deve ser um valor positivo.';
$string['err_duration_too_long'] = 'A duração não pode exceder as 150 horas.';
$string['err_end_date'] = 'A data de fim da recorrência não pode ser no passado';
$string['err_end_date_before_start'] = 'A data de fim da recorrência não pode ser anterior à data de início';
$string['err_invalid_password'] = 'O código de acesso contém caracteres inválidos.';
$string['err_long_timeframe'] = 'Período de tempo solicitado muito longo. A mostrar os resultados do último mês do intervalo.';
$string['err_password'] = 'O código de acesso apenas pode conter os seguintes caracteres: [a-z A-Z 0-9 @ - _ *]. Máximo de 10 caracteres.';
$string['err_password_required'] = 'O código de acesso é obrigatório.';
$string['err_repeat_monthly_interval'] = 'O intervalo máximo para reuniões mensais é de 3 meses';
$string['err_repeat_weekly_interval'] = 'O intervalo máximo para reuniões semanais é de 12 semanas';
$string['err_start_time_past'] = 'A data de início não pode ser no passado';
$string['err_start_time_past_recurring'] = 'Para reuniões recorrentes, a parte da data deste campo é a data mais próxima possível para a próxima reunião. A data deve ser hoje ou no futuro.';
$string['err_weekly_days'] = 'Selecione o(s) dia(s) para a reunião semanal recorrente';
$string['erroraddinstance'] = 'Não foi possível criar uma nova reunião Zoom. Foram selecionadas opções inválidas para uma reunião recorrente.';
$string['errorwebservice'] = 'Erro no web service Zoom: {$a}';
$string['errorwebservice_notfound'] = 'O recurso não existe.';
$string['export'] = 'Exportar';
$string['externaluser'] = 'Utilizador externo';
$string['firstjoin'] = 'Acesso antecipado';
$string['firstjoin_desc'] = 'O mais cedo que um utilizador pode aceder a uma reunião agendada (minutos antes do início).';
$string['getmeetingrecordings'] = 'Obter gravações de reuniões a partir do Zoom';
$string['getmeetingreports'] = 'Obter relatório da reunião Zoom';
$string['globalsettings'] = 'Configurações globais';
$string['globalsettings_desc'] = 'Estas configurações aplicam-se ao módulo Zoom como um todo.';
$string['host'] = 'Anfitrião';
$string['hostintro'] = '<a target="_blank" href="https://support.zoom.us/hc/en-us/articles/208220166">Anfitriões alternativos</a> podem iniciar reuniões Zoom e gerir a sala de espera.';
$string['invalid_status'] = 'Estado inválido. Verifique a base de dados.';
$string['invalidscheduleuser'] = 'Não pode agendar para o utilizador especificado.';
$string['invitation_invite'] = 'Padrão de mensagem de convite';
$string['invitationremoveicallink'] = 'Remover hiperligação iCal do convite zoom';
$string['invitationremoveinvite'] = 'Remover mensagem de convite do zoom';
$string['invitationremoveinvite_help'] = 'Se ativar esta opção, a frase de introdução na mensagem de e-mail da reunião com zoom será removida usando o padrão de regex invitation_invite.';
$string['join'] = 'Aceder';
$string['join_meeting'] = 'Aceder à reunião';
$string['joinbeforehost'] = 'Aceder à reunião antes do anfitrião';
$string['joinbeforehostenable'] = 'Permitir que os participantes acedam a qualquer instante';
$string['joinlink'] = 'Hiperligação de acesso';
$string['jointime'] = 'Hora de acesso';
$string['leavetime'] = 'Hora de saída';
$string['licensesettings'] = 'Configurações da licença';
$string['licensesnumber'] = 'Número de licenças';
$string['lowlicenses'] = 'Se o número das suas licenças exceder as necessárias, quando criar cada nova atividade por um utilizador, será atribuída uma licença PRO à atividade reduzindo o estado do outro utilizador. A opção é efetiva quando o número de licenças PRO ativas é superior a 5.';
$string['maskparticipantdata'] = 'Camuflar dados do participante';
$string['maskparticipantdata_help'] = 'Impede que os dados dos participantes apareçam nos relatórios (útil para sites que mascaram os dados dos participantes, por exemplo, para HIPAA).';
$string['media'] = 'Multimédia';
$string['meeting_finished'] = 'Terminada';
$string['meeting_invite'] = 'Informações sobre telefone/marcação';
$string['meeting_invite_hide'] = 'Ocultar convite para a reunião';
$string['meeting_invite_show'] = 'Mostrar convite para a reunião';
$string['meeting_nonexistent_on_zoom'] = 'Não existe no Zoom';
$string['meeting_not_started'] = 'Não iniciada';
$string['meeting_started'] = 'A decorrer';
$string['meeting_time'] = 'Hora de início';
$string['meetingcapacitywarning'] = 'Aviso da capacidade da reunião';
$string['meetingcapacitywarning_disable'] = 'Desativar aviso da capacidade da reunião';
$string['meetingcapacitywarning_enable'] = 'Ativar aviso da capacidade da reunião';
$string['meetingcapacitywarningheading'] = 'Aviso da capacidade da reunião:';
$string['meetingparticipantsdeleted'] = 'Os dados do participante da reunião foram apagados.';
$string['meetingrecordingviewsdeleted'] = 'Os dados do utilizador que visualizou a gravação da reunião foram apagados.';
$string['modulename'] = 'Reunião Zoom';
$string['modulename_help'] = 'O Zoom é uma plataforma de videoconferência que oferece aos utilizadores autorizados a capacidade de realizar reuniões online.';
$string['modulenameplural'] = 'Reuniões Zoom';
$string['month'] = 'Mês(es)';
$string['month_day_text'] = 'do mês';
$string['newmeetings'] = 'Novas reuniões';
$string['nextoccurrence'] = 'Próxima ocorrência';
$string['nomeetinginstances'] = 'Nenhuma sessão encontrada para esta reunião.';
$string['nooccurrenceleft'] = 'A última ocorrência já ocorreu';
$string['noparticipants'] = 'De momento, não foi encontrado qualquer participante para esta sessão.';
$string['norecordings'] = 'De momento, não foi encontrada qualquer gravação para esta reunião.';
$string['norooms'] = 'Sem salas';
$string['nosessions'] = 'Nenhuma sessão encontrada para o intervalo especificado.';
$string['nozooms'] = 'Sem reuniões';
$string['nozoomsfound'] = 'Nenhuma reunião encontrada para a disciplina indicada.';
$string['occurson'] = 'Ocorrem em';
$string['off'] = 'Off';
$string['oldmeetings'] = 'Reuniões concluídas';
$string['on'] = 'On';
$string['option_allow_recording_change'] = 'Permitir alterar gravação';
$string['option_allow_recording_change_help'] = 'Permitir que o utilizador altere a configuração de gravação no momento da criação da atividade';
$string['option_audio'] = 'Opções do áudio';
$string['option_audio_help'] = 'Com esta opção, pode permitir que os utilizadores liguem usando apenas telefone, apenas áudio do computador ou ambos';
$string['option_authenticated_users'] = 'Requer autenticação para aceder';
$string['option_auto_recording'] = 'Gravação automática';
$string['option_auto_recording_help'] = 'Se ativar esta opção, a reunião será gravada automaticamente';
$string['option_encryption_type'] = 'Encriptação';
$string['option_encryption_type_endtoendencryption'] = 'Encriptação ponto-a-ponto';
$string['option_encryption_type_enhancedencryption'] = 'Encriptação avançada';
$string['option_host_video'] = 'Vídeo do anfitrião';
$string['option_jbh'] = 'Aceder antes do anfitrião';
$string['option_mute_upon_entry'] = 'Silenciar participantes na entrada';
$string['option_mute_upon_entry_help'] = 'Se ativar esta opção, irá silenciar automaticamente todos os participantes quando eles ingressam na reunião.Os participantes podem ativar o som após entrarem na reunião.';
$string['option_participants_video'] = 'Vídeo dos participantes';
$string['option_proxyhost'] = 'Usar proxy';
$string['option_proxyhost_desc'] = 'O proxy definido aqui como \'<code><hostname>:<port></code>\' é usado apenas para comunicação com o Zoom. Deixe em branco para usar as configurações de proxy predefinidas do Moodle. Só precisa de definir se não pretender definir um proxy global no Moodle.';
$string['option_view_recordings'] = 'Permitir ver gravações';
$string['option_waiting_room'] = 'Sala de espera';
$string['participantdatanotavailable'] = 'Detalhes não disponíveis';
$string['participantdatanotavailable_help'] = 'Os dados do participante não estão disponíveis para esta sessão de Zoom (por exemplo, devido à conformidade com HIPAA).';
$string['participantgroups'] = 'Grupos de participantes';
$string['participants'] = 'Participantes';
$string['password'] = 'Código de acesso';
$string['password_allowed_char'] = 'O código de acesso apenas pode conter os seguintes caracteres: [a-z A-Z 0-9 @ - _ *].';
$string['password_consecutive'] = 'Máximo de {$a} caracteres consecutivos (abcd, 1111, 1234, etc.).';
$string['password_length'] = 'Mínimo de {$a} caracteres.';
$string['password_letter'] = 'O código de acesso tem de ter pelo menos 1 letra.';
$string['password_lower_upper'] = 'O código de acesso tem de incluir caracteres maiúsculos e minúsculos.';
$string['password_max_length'] = 'Máximo de 10 caracteres.';
$string['password_number'] = 'O código de acesso tem de ter pelo menos 1 número.';
$string['password_only_numeric'] = 'O código de acesso apenas pode conter números e nenhuns outros caracteres.';
$string['password_special'] = 'O código de acesso tem de ter pelo menos 1 caráter especial (@ -_ *).';
$string['passwordprotected'] = 'Protegido por código de acesso';
$string['pluginadministration'] = 'Gerir reunião Zoom';
$string['pluginname'] = 'Reunião Zoom';
$string['recording'] = 'Gravação';
$string['recordingadd'] = 'Adicionar gravação';
$string['recordingdate'] = 'Data da gravação';
$string['recordingdelete'] = 'Tem a certeza de que pretende apagar a gravação "{$a}"?';
$string['recordinghide'] = 'Ocultar gravação (atualmente visível)';
$string['recordinglink'] = 'Hiperligação da gravação';
$string['recordingname'] = 'Título';
$string['recordingnotfound'] = 'Não foi encontrada a gravação';
$string['recordingnotvisible'] = 'A gravação não está visível. Contacte com o administrador do sistema se tem a certeza de que é um erro';
$string['recordings'] = 'Gravações';
$string['recordingshow'] = 'Mostrar gravação (atualmente oculta)';
$string['recordingshowtoggle'] = 'Alternar Mostrar Gravação';
$string['recordingtypeaudio'] = 'Apenas áudio';
$string['recordingtypevideo'] = 'Vídeo e áudio';
$string['recordingurl'] = 'URL da gravação';
$string['recordingview'] = 'Ver gravações';
$string['recordingvisibility'] = 'As gravações desta reunião são visíveis por predefinição?';
$string['recreatesuccessful'] = 'Reunião recriada com sucesso';
$string['recurrence_option_daily'] = 'Diariamente';
$string['recurrence_option_monthly'] = 'Mensalmente';
$string['recurrence_option_no_time'] = 'Sem prazo definido';
$string['recurrence_option_weekly'] = 'Semanalmente';
$string['recurrencetype'] = 'Recorrência';
$string['recurringmeeting'] = 'Reunião recorrente';
$string['recurringmeeting_help'] = 'Ativar esta opção tornará a reunião uma reunião recorrente sem uma data ou hora de fim. Deste modo pode ser acedida a qualquer momento.';
$string['recurringmeetingexplanation'] = 'A reunião não tem data ou hora de fim';
$string['recurringmeetinglong'] = 'Reunião recorrente (reunião sem data ou hora de fim)';
$string['recurringmeetingthisis'] = 'Esta reunião é recorrente';
$string['recycleonjoin'] = 'Reciclar a licença após aceder';
$string['redefinelicenses'] = 'Redefinir licenças';
$string['refreshreports'] = 'Atualizar relatório da sessão';
$string['register'] = 'Registar';
$string['registration'] = 'Requer registo';
$string['registration_help'] = 'Se ativar esta opção, forçará os participantes a registarem-se na reunião/webinar do Zoom antes de ingressar.';
$string['registration_text'] = 'Forçar os participantes a registarem-se na reunião/webinar';
$string['repeatinterval'] = 'Repetir a cada';
$string['report'] = 'Relatórios';
$string['reportapicalls'] = 'Reportar chamadas da API esgotadas';
$string['requirepasscode'] = 'Código de acesso à reunião obrigatório';
$string['resetapicalls'] = 'Redefinir o número de chamadas disponíveis da API';
$string['room'] = 'Sala';
$string['roomname'] = 'Nome da sala';
$string['rooms'] = 'Salas';
$string['schedule'] = 'Agendamento';
$string['schedulefor'] = 'Agendar reunião para';
$string['scheduleforself'] = 'Tu mesmo';
$string['schedulingprivilege'] = 'Privilégio de agendamento';
$string['schedulingprivilege_disable'] = 'Desativar opção de privilégio de agendamento';
$string['schedulingprivilege_enable'] = 'Ativar opção de privilégio de agendamento';
$string['search:activity'] = 'Reunião Zoom - informações da atividade';
$string['security'] = 'Segurança';
$string['selectionarea'] = 'Sem seleção';
$string['sessions'] = 'Sessões';
$string['sessionsreport'] = 'Relatório das sessões';
$string['sesskeyinvalid'] = 'Sessão inválida detetada. Não é possível prosseguir.';
$string['setpasscode'] = 'Definir código de acesso';
$string['showmedia'] = 'Mostrar a secção Multimédia';
$string['showmedia_help'] = 'Se ativar esta opção, será mostrada a secção Multimédia na página da atividade.';
$string['showmediaonview'] = 'Mostrar a secção Multimédia na página da reunião';
$string['showschedule'] = 'Mostrar a secção Agendamento';
$string['showschedule_help'] = 'Se ativar esta opção, será mostrada a secção Agendamento na página da atividade.';
$string['showscheduleonview'] = 'Mostrar a secção Agendamento na página da reunião';
$string['showsecurity'] = 'Mostrar a secção Segurança';
$string['showsecurity_help'] = 'Se ativar esta opção, será mostrada a secção Segurança na página da atividade.';
$string['showsecurityonview'] = 'Mostrar a secção Segurança na página da reunião';
$string['start'] = 'Iniciar';
$string['start_meeting'] = 'Iniciar reunião';
$string['start_time'] = 'Início';
$string['starthostjoins'] = 'Iniciar vídeo quando o anfitrião acede';
$string['startpartjoins'] = 'Iniciar vídeo quando o participante acede';
$string['starttime'] = 'Hora de início';
$string['status'] = 'Estado';
$string['supplementaryfeaturessettings'] = 'Configurações de funcionalidades complementares';
$string['title'] = 'Título';
$string['topic'] = 'Tópico';
$string['trackingfields_recommendedvalues'] = 'Valores recomendados:';
$string['unavailable'] = 'De momento não é possível aceder.';
$string['unavailablefinished'] = 'A reunião já terminou.';
$string['unavailablefirstjoin'] = 'Pode aceder, no máximo, {$a->mins} minutos antes do horário de início agendado.';
$string['unavailablenotstartedyet'] = 'A reunião ainda não começou.';
$string['updatemeetings'] = 'Atualizar as configurações da reunião a partir do Zoom';
$string['usepersonalmeeting'] = 'Use o ID pessoal da reunião {$a}';
$string['waitingroom'] = 'Sala de espera';
$string['waitingroomenable'] = 'Ativar sala de espera';
$string['webinar'] = 'Webinar';
$string['webinar_already_false'] = '<p><b>Este módulo já foi definido como uma reunião. Não pode alternar esta configuração para webinar depois de criar a reunião.</b></p>';
$string['webinar_already_true'] = '<p><b>Este módulo já foi definido como um webinar. Não pode alternar esta configuração para reunião depois de criar o webinar.</b></p>';
$string['webinar_alwaysshow'] = 'Mostrar sempre a opção de webinar, independentemente do utilizador ter, ou não, uma licença para hospedar webinars';
$string['webinar_by_default'] = 'Webinar por predefinição';
$string['webinar_by_default_desc'] = 'Criar uma instância do Zoom como um webinar, por predefinição.';
$string['webinar_desc'] = 'Com esta configuração, pode controlar se a opção de criar um webinar é, ou não, mostrada aos utilizadores durante a criação de uma reunião. Esta configuração afeta apenas as configurações da instância de atividade do Moodle. Mesmo que decida mostrar sempre a opção, o utilizador tem de ter uma licença válida para webinars para hospedar um webinar.';
$string['webinar_disable'] = 'Desativar webinars';
$string['webinar_help'] = 'Os webinars oferecem aos anfitriões maior controlo e flexibilidade para reuniões com públicos maiores.\\n\\nEsta opção só está disponível para contas Zoom pré-autorizadas.';
$string['webinar_showonlyiflicense'] = 'Mostrar apenas a opção de webinar se o utilizador tiver uma licença para hospedar webinars';
$string['webinarthisis'] = 'Isto é um webinar';
$string['week'] = 'Semana(s)';
$string['weekoption_first'] = 'Primeiro';
$string['weekoption_fourth'] = 'Quarto';
$string['weekoption_last'] = 'Último';
$string['weekoption_second'] = 'Segundo';
$string['weekoption_third'] = 'Terceiro';
$string['zoom:addinstance'] = 'Adicionar nova reunião Zoom';
$string['zoom:eligiblealternativehost'] = 'Selecionável como anfitrião alternativo nas reuniões Zoom';
$string['zoom:refreshsessions'] = 'Atualizar relatórios de reunião do Zoom';
$string['zoom:view'] = 'Ver reuniões Zoom';
$string['zoom:viewdialin'] = 'Ver informações de marcação';
$string['zoom:viewjoinurl'] = 'Ver URL de acesso à reunião';
$string['zoomerr'] = 'Ocorreu um erro com o Zoom.';
$string['zoomerr_alternativehostusernotfound'] = 'O utilizador {$a} não foi encontrado no Zoom.';
$string['zoomerr_apilimit'] = 'Atingiu o limite máximo de taxa diária para esta API. Tente novamente {$a}';
$string['zoomerr_field_missing'] = '{$a} não encontrado';
$string['zoomerr_id_missing'] = 'Tem de especificar um ID do course_module ou um ID da instância';
$string['zoomerr_maxretries'] = 'Foram repetidas {$a->maxretries} vezes as tentativas para estabelecer a ligação, mas não foi possível: {$a->response}';
$string['zoomerr_meetingnotfound'] = 'Não foi possível encontrar esta reunião no Zoom. Pode <a href="{$a->recreate}">recriar a reunião</a> ou <a href="{$a->delete}">apagar a reunião</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Não foi possível encontrar esta reunião no Zoom. Se tiver alguma dúvida, entre em contacto com o organizador da reunião';
$string['zoomerr_usernotfound'] = 'Não foi possível encontrar a sua conta no Zoom. Se estiver a usar o Zoom pela primeira vez, deverá ativar a sua conta do Zoom acedendo à página <a href="{$a}" target="_blank">{$a}</a>. Depois de ativar a sua conta do Zoom, recarregue esta página e continue a configurar a sua reunião. Caso contrário, verifique se o seu e-mail no Zoom corresponde ao seu e-mail neste sistema.';
$string['zoomurl'] = 'URL da página inicial do Zoom';
