<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'pt', version '3.11'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Existem sessões bigbluebuttonbn para breve';
$string['bbbduetimeoverstartingtime'] = 'A data/hora de fim tem de ser posterior à data/hora de início.';
$string['bbbdurationwarning'] = 'A duração máxima para esta sessão é de %duration% minutos.';
$string['bbbrecordallfromstartwarning'] = 'Esta sessão está a ser gravada desde o início.';
$string['bbbrecordwarning'] = 'Esta sessão pode ser gravada.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Adicionar uma nova sala/atividade bigbluebuttonbn';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Criar instâncias de sessão online';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Criar instâncias com gravação';
$string['bigbluebuttonbn:deleterecordings'] = 'Apagar gravações';
$string['bigbluebuttonbn:importrecordings'] = 'Importar gravações';
$string['bigbluebuttonbn:join'] = 'Participar numa sessão bigbluebuttonbn';
$string['bigbluebuttonbn:managerecordings'] = 'Gerir gravações bigbluebuttonbn';
$string['bigbluebuttonbn:protectrecordings'] = 'Proteger gravações';
$string['bigbluebuttonbn:publishrecordings'] = 'Publicar gravações';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Desproteger gravações';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Remover publicação das gravações';
$string['bigbluebuttonbn:view'] = 'Visualizar sala/atividade';
$string['cachedef_currentfetch'] = 'Dados para listar qualquer gravação obtida recentemente.';
$string['cachedef_recordings'] = 'Metadados da gravação';
$string['cachedef_serverinfo'] = 'Informação do servidor remoto';
$string['cachedef_validatedurls'] = 'Cache de verificações de URL validadas';
$string['calendarstarts'] = '{$a} agendada';
$string['cannotperformaction'] = 'Não é possível executar nesta gravação a ação {$a}';
$string['completionattendance'] = 'O aluno deve estar na sessão durante:';
$string['completionattendance_desc'] = 'O aluno tem de entrar na sala e permanecer na sessão por pelo menos {$a} minuto(s)';
$string['completionattendance_event_desc'] = 'O aluno entrou na sala ou permaneceu na sessão por pelo menos {$a} minuto(s)';
$string['completionattendancegroup'] = 'Requer presença';
$string['completionattendancegroup_help'] = 'É necessário estar na sessão por (n) minutos para concluir a atividade';
$string['completionengagement_desc'] = 'O aluno deve envolver-se em atividades durante a sessão';
$string['completionengagementchats'] = 'Eventos da conversação';
$string['completionengagementchats_desc'] = 'O aluno tem de participar em {$a} evento(s) de chat para concluir.';
$string['completionengagementchats_event_desc'] = 'Realizou {$a} chat(s)';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'O aluno tem de enviar {$a} emoji(s) para as sondagens para concluir.';
$string['completionengagementemojis_event_desc'] = 'Realizou {$a} emoji(s)';
$string['completionengagementgroup'] = 'Requer participação';
$string['completionengagementgroup_help'] = 'É necessária a participação ativa durante a sessão para concluir a atividade';
$string['completionengagementpollvotes'] = 'Votos na sondagem';
$string['completionengagementpollvotes_desc'] = 'O aluno tem de votar {$a} vez(es) nas sondagens para concluir.';
$string['completionengagementpollvotes_event_desc'] = 'Realizou {$a} voto(s) na sondagem';
$string['completionengagementraisehand'] = 'Eventos de levantar a mão';
$string['completionengagementraisehand_desc'] = 'O aluno tem de levantar a mão {$a} vez(es) para concluir.';
$string['completionengagementraisehand_event_desc'] = 'Realizou {$a} levantar a mão';
$string['completionengagementtalks'] = 'Eventos de conversa';
$string['completionengagementtalks_desc'] = 'O aluno tem de falar {$a} vez(es) para concluir';
$string['completionengagementtalks_event_desc'] = 'Realizou {$a} conversação(ões)';
$string['completionupdatestate'] = 'Estado da atualização da conclusão';
$string['completionvalidatestate'] = 'Validar conclusão';
$string['completionvalidatestatetriggered'] = 'A validação da conclusão foi acionada.';
$string['completionview'] = 'Requer visualização';
$string['completionview_desc'] = 'O aluno tem visualizar a sala para concluir.';
$string['completionview_event_desc'] = 'Visualizou a página da sala.';
$string['config_checksum_algorithm'] = 'Algoritmo de verificação BigBlueButton';
$string['config_checksum_algorithm_description'] = 'O algoritmo de verificação do seu servidor BigBlueButton.
(SHA1 garante compatibilidade com versões mais antigas do servidor, mas é menos seguro, enquanto SHA512 é compatível com FIPS 140-2.)';
$string['config_default_messages'] = 'Mensagens predefinidas';
$string['config_default_messages_description'] = 'Definir mensagem predefinidas para as atividades';
$string['config_disablecam_default'] = 'Desativar a webcam ativo por predefinição';
$string['config_disablecam_default_description'] = 'Se ativar esta opção, a webcam estará desativada por predefinição.';
$string['config_disablecam_editable'] = 'Desativar a webcam pode ser editado';
$string['config_disablecam_editable_description'] = 'Configuração predefinida para Desativar webcam pode ser editada quando a instância é adicionada ou atualizada.';
$string['config_disablemic_default'] = 'Desativar o microfone ativo por predefinição';
$string['config_disablemic_default_description'] = 'Se ativar esta opção, o microfone estará desativado por predefinição.';
$string['config_disablemic_editable'] = 'Desativar o microfone editável';
$string['config_disablemic_editable_description'] = 'Desativar o microfone por predefinição pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_disablenote_default'] = 'Desativar notas partilhadas ativo por predefinição';
$string['config_disablenote_default_description'] = 'Se ativar esta opção, as notas partilhadas estarão desativadas por predefinição.';
$string['config_disablenote_editable'] = 'Desativar notas partilhadas editável';
$string['config_disablenote_editable_description'] = 'Desativar as notas partilhadas por predefinição pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_disableprivatechat_default'] = 'Desativar conversas privadas ativo por predefinição';
$string['config_disableprivatechat_default_description'] = 'Se ativar esta opção, as conversas privadas estarão desativadas por predefinição.';
$string['config_disableprivatechat_editable'] = 'Desativar chat privado editável';
$string['config_disableprivatechat_editable_description'] = 'Desativar chat privado por predefinição pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_disablepublicchat_default'] = 'Desativar chat público ativo por predefinição';
$string['config_disablepublicchat_default_description'] = 'Se ativar esta opção, as conversas públicas estarão desativadas por predefinição.';
$string['config_disablepublicchat_editable'] = 'Desativar chat público editável';
$string['config_disablepublicchat_editable_description'] = 'Desativar chat público por predefinição pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_experimental_features'] = 'Configuração das funcionalidades experimentais';
$string['config_experimental_features_description'] = '.Configuração das funcionalidades experimentais';
$string['config_extended_capabilities'] = 'Configuração das funcionalidades adicionais';
$string['config_extended_capabilities_description'] = 'Configuração das funcionalidades adicionais (quando é permitido pelo servidor BigBlueButton).';
$string['config_general'] = 'Configurações gerais';
$string['config_general_description'] = 'Estas configurações são <b>sempre</b> utilizadas';
$string['config_hideuserlist_default'] = 'Ocultar lista de participantes ativo por predefinição';
$string['config_hideuserlist_default_description'] = 'Se ativar esta opção, a lista de participantes da sessão estará oculta por predefinição.';
$string['config_hideuserlist_editable'] = 'Ocultar lista de participantes editável';
$string['config_hideuserlist_editable_description'] = 'Ocultar lista de participantes por predefinição pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_importrecordings'] = 'Configurações da funcionalidade "Importar gravações"';
$string['config_importrecordings_description'] = 'Estas configurações referem-se a esta funcionalidade';
$string['config_importrecordings_enabled'] = 'Permitir importar gravações';
$string['config_importrecordings_enabled_description'] = 'Se ativar esta opção e a funcionalidade \'Gravar sessão\' estiver ativa, é possível importar gravações de diferentes disciplinas para uma atividade.';
$string['config_importrecordings_from_deleted_enabled'] = 'Permitir importar gravações de atividades apagadas';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Se ativar esta opção e a funcionalidade \'Importar gravações\' estiver ativa, é possível importar gravações de atividades que já não se encontram na disciplina.';
$string['config_lockonjoin_default'] = 'Ignorar bloqueio ao participar ativo por predefinição';
$string['config_lockonjoin_default_description'] = 'Se ativar esta opção, as configurações de bloqueio serão ignoradas por predefinição. A configuração de bloqueio deve ser ativada para que possa ser aplicada esta opção.';
$string['config_lockonjoin_editable'] = 'Ignorar bloqueio ao participar pode ser editado';
$string['config_lockonjoin_editable_description'] = 'Ignorar bloqueio ao participar por predefinição pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_locksettings'] = 'Configurações das opções de bloqueio';
$string['config_locksettings_description'] = 'Estas configurações ativam ou desativam opções na interface do utilizador (IU) para as configurações de bloqueio e também definem valores predefinidos para essas opções.';
$string['config_meetingevents_enabled'] = 'Registar eventos ao vivo';
$string['config_meetingevents_enabled_description'] = 'Se ativar esta opção, será possível aceitar e processar eventos ao vivo após o fim da sessão. (Apenas funcionará se o servidor BigBlueButton for capaz de processar scripts \'post_events\' e tem de ser ativado na conclusão da atividade)';
$string['config_muteonstart'] = 'Configurações da funcionalidade "Silencioso no início"';
$string['config_muteonstart_default'] = 'Silencioso no início';
$string['config_muteonstart_default_description'] = 'Se ativar esta opção, a sessão estará em modo silencioso no início, por predefinição.';
$string['config_muteonstart_description'] = 'Estas configurações ativam ou desativam opções na interface do utilizador (IU) e também definem os respetivos valores predefinidos.';
$string['config_muteonstart_editable'] = 'Silencioso no início editável';
$string['config_muteonstart_editable_description'] = 'Se ativar esta opção, o modo \'Silencioso no início\' pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_participant'] = 'Configuração dos participantes';
$string['config_participant_description'] = 'Estas configurações definem o papel predefinido dos participantes numa conferência.';
$string['config_participant_moderator_default'] = 'Moderador por predefinição';
$string['config_participant_moderator_default_description'] = 'Esta regra é aplicada, por predefinição, quando é adicionada uma nova sala.';
$string['config_presentation_default'] = 'Ficheiro predefinido de "Pré-carregar a apresentação"';
$string['config_presentation_default_description'] = 'Esta configuração permite selecionar um ficheiro para usar como predefinido em todas as instâncias de BBB, se "Pré-carregar a apresentação" estiver ativa.';
$string['config_preuploadpresentation'] = 'Configurações da funcionalidade "Pré-carregar a apresentação"';
$string['config_preuploadpresentation_description'] = 'Estas configurações ativam ou desativam opções na interface do utilizador (IU) e também definem os respetivos valores predefinidos. Esta funcionalidade apenas funciona se o servidor do Moodle estiver acessível para o BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Pré-carregamento da apresentação editável';
$string['config_preuploadpresentation_editable_description'] = 'O recurso de pré-carregamento da apresentação pode ser editado na IU quando a sala ou conferência é adicionada ou atualizada.';
$string['config_recording'] = 'Configurações da funcionalidade "Gravar sessão"';
$string['config_recording_all_from_start_default'] = 'Gravar tudo desde o início';
$string['config_recording_all_from_start_default_description'] = 'Se ativar esta opção, a sessão será gravada desde o início.';
$string['config_recording_all_from_start_editable'] = 'Gravar tudo desde o início pode ser editado';
$string['config_recording_all_from_start_editable_description'] = 'Se ativar esta opção, a interface inclui a opção de ativar ou desativar a funcionalidade de gravar tudo desde o início.';
$string['config_recording_default'] = 'Funcionalidade de gravação ativa por predefinição';
$string['config_recording_default_description'] = 'Se ativar esta opção, as sessões criadas no BigBlueButton poderão ser gravadas, por predefinição.';
$string['config_recording_description'] = 'Estas configurações referem-se a esta funcionalidade';
$string['config_recording_editable'] = 'A funcionalidade de gravação pode ser editada';
$string['config_recording_editable_description'] = 'Se ativar esta opção, a interface inclui a opção de ativar ou desativar a funcionalidade de gravação.';
$string['config_recording_hide_button_default'] = 'Ocultar botão de gravação';
$string['config_recording_hide_button_default_description'] = 'Se ativar esta opção, o botão de gravação estará oculto';
$string['config_recording_hide_button_editable'] = 'Ocultar botão de gravação pode ser editado';
$string['config_recording_hide_button_editable_description'] = 'Se ativar esta opção, a interface inclui a opção de ativar ou desativar a opção de ocultar o botão de gravação.';
$string['config_recording_protect_editable'] = 'Estado das gravações protegidas editável';
$string['config_recording_protect_editable_description'] = 'Se ativar esta opção, a interface inclui uma opção para proteger/desproteger as gravações.';
$string['config_recording_refresh_period'] = 'Período de atualização da gravação (em segundos)';
$string['config_recording_refresh_period_description'] = 'Com que frequência o servidor BigBlueButton deve ser consultado para atualizar informações remotas de uma gravação?';
$string['config_recordingready_enabled'] = 'Enviar notificações quando a gravação estiver disponível';
$string['config_recordingready_enabled_description'] = 'Se ativar esta opção, serão enviadas notificações quando a gravação estiver disponível.
Só funcionará se o script \'post_publish_recording_ready_callback\' estiver ativado no servidor BigBlueButton.';
$string['config_recordings'] = 'Configurações da funcionalidade "Reproduzir Gravações"';
$string['config_recordings_description'] = 'Estas configurações referem-se a esta funcionalidade';
$string['config_recordings_general'] = 'Mostrar configurações da gravação';
$string['config_recordings_general_description'] = 'Estas configurações são utilizadas apenas ao reproduzir gravações.';
$string['config_recordings_imported_default'] = 'Mostrar apenas hiperligações importadas';
$string['config_recordings_imported_default_description'] = 'Se ativar esta opção, a tabela de gravações incluirá, por predefinição, apenas as hiperligações importadas para as gravações.';
$string['config_recordings_imported_editable'] = 'Mostrar apenas hiperligações importadas editável';
$string['config_recordings_imported_editable_description'] = 'Se ativar esta opção, a funcionalidade \'Mostrar apenas hiperligações importadas\' poderá ser editada quando a instância é adicionada ou atualizada, por predefinição.';
$string['config_recordings_preview_default'] = 'Permitir pré-visualização';
$string['config_recordings_preview_default_description'] = 'Se ativar esta opção, a tabela incluirá uma pré-visualização da apresentação por predefinição.';
$string['config_recordings_preview_editable'] = 'Permitir pré-visualização editável';
$string['config_recordings_preview_editable_description'] = 'Se ativar esta opção, a funcionalidade \'Permitir pré-visualização\' pode ser editada quando a instância é adicionada ou atualizada.';
$string['config_recordings_sortorder'] = 'Ordenar as gravações por ordem crescente';
$string['config_recordings_sortorder_description'] = 'Por predefinição, as gravações são mostradas por ordem decrescente. Se ativar esta opção, as gravações serão mostradas por ordem crescente.';
$string['config_scheduled'] = 'Configuração das "Sessões agendadas"';
$string['config_scheduled_description'] = 'Estas configurações definem alguns dos comportamentos predefinidos para as sessões agendadas.';
$string['config_scheduled_pre_opening'] = 'Disponível antes de hora de início (minutos)';
$string['config_scheduled_pre_opening_description'] = 'Expirou o tempo, em minutos, para que a sessão esteja acessível antes da hora de início programada.';
$string['config_sendnotifications'] = 'Configurações da funcionalidade "Enviar Notificações"';
$string['config_sendnotifications_description'] = 'Estas configurações ativam ou desativam opções na interface do utilizador (IU) e também definem os respetivos valores predefinidos.';
$string['config_sendnotifications_enabled'] = 'Enviar notificações';
$string['config_sendnotifications_enabled_description'] = 'Se ativar esta opção, a interface do utilizador (IU) para editar a atividade inclui uma opção para enviar uma notificação ao utilizador inscrito quando a atividade é adicionada ou atualizada.';
$string['config_server_url'] = 'URL do servidor BigBlueButton';
$string['config_server_url_description'] = 'O URL do servidor BigBlueButton tem de terminar em \'/bigbluebutton/\'. (Este URL predefinido é de um servidor BigBlueButton fornecido por Blindside Networks que pode ser utilizado para testes.)';
$string['config_shared_secret'] = 'Chave secreta partilhada';
$string['config_shared_secret_description'] = 'Chave secreta de segurança do servidor BigBlueButton. (Esta chave predefinida é de um servidor BigBlueButton fornecido por Blindside Networks que pode ser utilizado para testes.)';
$string['config_uidelegation_enabled'] = 'Delegação de IU está ativada';
$string['config_uidelegation_enabled_description'] = 'Estas configurações ativam ou desativam a delegação da interface do utilizador (IU) para o servidor BigBlueButton.';
$string['config_userlimit'] = 'Configurações da funcionalidade "Limite de utilizadores"';
$string['config_userlimit_default'] = 'Limite de utilizadores';
$string['config_userlimit_default_description'] = 'Número predefinido de utilizadores permitidos por sessão quando uma nova sala ou conferência é adicionada. Se o número for 0, não é estabelecido qualquer limite.';
$string['config_userlimit_description'] = 'Estas configurações ativam ou desativam opções na interface do utilizador (IU) e também definem os respetivos valores predefinidos.';
$string['config_userlimit_editable'] = 'Limite de utilizadores editável';
$string['config_userlimit_editable_description'] = 'Se ativar esta opção, o valor predefinido do limite de utilizadores pode ser editado quando uma sala ou conferência é adicionada ou atualizada.';
$string['config_voicebridge'] = 'Configurações da funcionalidade "Elo de voz"';
$string['config_voicebridge_description'] = 'Estas configurações ativam ou desativam opções na interface do utilizador (IU) e também definem os respetivos valores predefinidos.';
$string['config_voicebridge_editable'] = 'Elo de voz da conferência editável';
$string['config_voicebridge_editable_description'] = 'O número do Elo de voz da conferência pode ser atribuído de forma permanente a uma sala de conferência. Quando atribuído, o número não pode ser utilizado por outras salas ou conferências.';
$string['config_waitformoderator'] = 'Configurações da funcionalidade "Aguardar por moderador"';
$string['config_waitformoderator_cache_ttl'] = 'TTL da cache de Aguardar por moderador (segundos)';
$string['config_waitformoderator_cache_ttl_description'] = 'Este módulo utiliza uma cache para suportar a carga de clientes. Este parâmetro define o tempo que a cache será mantida até que o próximo pedido seja enviado ao servidor BigBlueButton.';
$string['config_waitformoderator_default'] = 'Aguardar por moderador';
$string['config_waitformoderator_default_description'] = 'Se ativar esta opção, a funcionalidade \'Aguardar por moderador\' está ativa, por predefinição, ao adicionar uma sala ou conferência.';
$string['config_waitformoderator_description'] = 'Estas configurações referem-se a esta funcionalidade.';
$string['config_waitformoderator_editable'] = 'Aguardar por moderador pode ser editada';
$string['config_waitformoderator_editable_description'] = 'Se ativar esta opção, a funcionalidade \'Aguardar por moderador\' pode ser editada ao adicionar ou atualizar uma sala ou conferência.';
$string['config_waitformoderator_ping_interval'] = 'Ping de Aguardar por moderador (segundos)';
$string['config_waitformoderator_ping_interval_description'] = 'Quando \'Aguardar por moderador\' está ativo, o cliente executa um ping para saber o estado da sessão a cada [número indicado] segundos. Este parâmetro define o intervalo de tempo entre pedidos ao servidor Moodle.';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'O BigBlueButton utiliza o \'config.php\' com uma variável global que foi descontinuada. Por favor, converta o ficheiro, uma vez que não será suportado em versões futuras.';
$string['config_warning_curl_not_installed'] = 'Esta função requer que a extensão CURL para PHP esteja instalada e ativa. Só será possível aceder às configurações se esta condição for verificada.';
$string['config_welcome_default'] = 'Mensagem de boas vindas predefinida';
$string['config_welcome_default_description'] = 'Substitui a mensagem predefinida que está configurada para o servidor BigBlueButton. A mensagem pode incluir palavras-chave (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) que serão substituídas automaticamente e também pode incluir tags html, como por exemplo: &lt;b>...&lt;/b> ou &lt;i>...&lt;/i>';
$string['config_welcome_editable'] = 'A mensagem de boas-vindas predefinida pode ser editada pelos professores';
$string['config_welcome_editable_description'] = 'A mensagem de boas-vindas pode ser editada quando a instância é adicionada ou atualizada';
$string['email_body_notification_meeting_by'] = 'por';
$string['email_body_notification_meeting_description'] = 'Descrição';
$string['email_body_notification_meeting_details'] = 'Detalhes';
$string['email_body_notification_meeting_end_date'] = 'Data de fim';
$string['email_body_notification_meeting_has_been'] = 'foi';
$string['email_body_notification_meeting_start_date'] = 'Data de início';
$string['email_body_notification_meeting_title'] = 'Título';
$string['email_body_recording_ready_for'] = 'Gravar para';
$string['email_body_recording_ready_in_course'] = 'na disciplina';
$string['email_footer_sent_by'] = 'Esta mensagem automática foi enviada por';
$string['email_footer_sent_from'] = 'da disciplina';
$string['end_session_confirm'] = 'Tem a certeza de que pretende encerrar a sessão?';
$string['end_session_confirm_title'] = 'Tem a certeza de que pretende encerrar a sessão?';
$string['end_session_notification'] = 'A sessão foi terminada.';
$string['ends_at'] = 'Termina';
$string['event_activity_created'] = 'A atividade foi criada';
$string['event_activity_deleted'] = 'A atividade foi apagada';
$string['event_activity_updated'] = 'A atividade foi atualizada';
$string['event_live_session'] = 'Evento de sessão ao vivo';
$string['event_meeting_created'] = 'A sessão foi criada';
$string['event_meeting_ended'] = 'A sessão foi forçada a terminar';
$string['event_meeting_joined'] = 'Entrou na sessão';
$string['event_meeting_left'] = 'Saiu da sessão';
$string['event_recording_deleted'] = 'Gravação apagada';
$string['event_recording_edited'] = 'Gravação editada';
$string['event_recording_imported'] = 'Gravação importada';
$string['event_recording_protected'] = 'Gravação protegida';
$string['event_recording_published'] = 'Gravação publicada';
$string['event_recording_unprotected'] = 'Gravação desprotegida';
$string['event_recording_unpublished'] = 'Gravação por publicar';
$string['event_recording_viewed'] = 'Gravação visualizada';
$string['event_unknown'] = 'Evento desconhecido';
$string['general_error_cannot_create_meeting'] = 'Não é possível criar sessão.';
$string['general_error_cannot_get_recordings'] = 'Não é possível obter as reuniões.';
$string['general_error_no_answer'] = 'Resposta em branco. Verifique o url do servidor BigBlueButton E verifique se o servidor BigBlueButton está em execução.';
$string['general_error_not_allowed_to_create_instances'] = 'O utilizador não tem permissão para criar nenhum tipo de instância.';
$string['general_error_not_found'] = 'Entidade não encontrada: {$a}.';
$string['general_error_unable_connect'] = 'Não foi possível estabelecer a ligação. Por favor, verifique o URL do servidor BigBlueButton e garanta que o mesmo está a funcionar corretamente.';
$string['index_confirm_end'] = 'Pretende terminar a aula virtual?';
$string['index_disabled'] = 'desativado';
$string['index_enabled'] = 'ativado';
$string['index_ending'] = 'A terminar a sala de aula virtual. Por favor, aguarde...';
$string['index_error_bbtn'] = 'ID do BigBlueButton {$a} está incorreto';
$string['index_error_checksum'] = 'Ocorreu um erro na verificação. Certifique-se de que digitou a chave correta.';
$string['index_error_forciblyended'] = 'Não é possível participar nesta sessão porque já foi finalizada manualmente.';
$string['index_error_noinstances'] = 'Não existem instâncias de bigbluebuttonbn';
$string['index_error_unable_display'] = 'Não é possível exibir as sessões. Por favor, verifique o URL do servidor BigBlueButton e garanta que o mesmo está a funcionar corretamente.';
$string['index_heading'] = 'Salas BigBlueButton';
$string['index_heading_actions'] = 'Ações';
$string['index_heading_group'] = 'Grupo';
$string['index_heading_moderator'] = 'Moderadores';
$string['index_heading_name'] = 'Sala';
$string['index_heading_recording'] = 'Gravação';
$string['index_heading_users'] = 'Utilizadores';
$string['index_heading_viewer'] = 'Espectadores';
$string['indicator:cognitivedepth'] = 'Compreensão do BigBlueButton';
$string['indicator:cognitivedepth_help'] = 'Este indicador é baseado na capacidade cognitiva alcançada pelo aluno na atividade BigBlueButton';
$string['indicator:socialbreadth'] = 'Socialização do BigBlueButton';
$string['indicator:socialbreadth_help'] = 'Este indicador é baseado na extensão social alcançada pelo aluno na atividade BigBlueButton';
$string['instance_type_default'] = 'Sala/atividade com gravações';
$string['instance_type_recording_only'] = 'Apenas gravações';
$string['instance_type_room_only'] = 'Apenas sala/atividade';
$string['instanceprofilewithoutrecordings'] = 'Este perfil de instância não pode mostrar gravações';
$string['messageprovider:instance_updated'] = 'Sessão BigBlueButton atualizada';
$string['messageprovider:recording_ready'] = 'Gravação BigBlueButton disponível';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['mod_form_block_general'] = 'Configurações gerais';
$string['mod_form_block_participants'] = 'Papel atribuído durante a sessão online';
$string['mod_form_block_presentation'] = 'Conteúdo da apresentação';
$string['mod_form_block_presentation_default'] = 'Conteúdo predefinido da apresentação';
$string['mod_form_block_record'] = 'Configurações da gravação';
$string['mod_form_block_recordings'] = 'Vista para gravação';
$string['mod_form_block_room'] = 'Configurações da sala/atividade';
$string['mod_form_block_schedule'] = 'Agendamento da sessão';
$string['mod_form_field_closingtime'] = 'Data/hora de fim';
$string['mod_form_field_conference_name'] = 'Nome da conferência';
$string['mod_form_field_disablecam'] = 'Desativar webcams';
$string['mod_form_field_disablemic'] = 'Desativar microfones';
$string['mod_form_field_disablenote'] = 'Desativar notas partilhadas';
$string['mod_form_field_disableprivatechat'] = 'Desativar chat privado';
$string['mod_form_field_disablepublicchat'] = 'Desativar chat público';
$string['mod_form_field_duration'] = 'Duração';
$string['mod_form_field_duration_help'] = 'Definir a duração para uma sessão irá estabelecer o tempo máximo de duração da sessão antes que termine a gravação';
$string['mod_form_field_hideuserlist'] = 'Ocultar lista de utilizadores';
$string['mod_form_field_instanceprofiles'] = 'Tipo de instância';
$string['mod_form_field_instanceprofiles_help'] = 'Selecione o tipo de instância BigBlueButton';
$string['mod_form_field_intro'] = 'Descrição';
$string['mod_form_field_intro_help'] = 'Breve descrição da sala ou conferência.';
$string['mod_form_field_lockonjoin'] = 'Ignorar o bloqueio das configurações';
$string['mod_form_field_muteonstart'] = 'Silencioso no início';
$string['mod_form_field_name'] = 'Nome da sala de aula virtual';
$string['mod_form_field_nosettings'] = 'Nenhuma configuração pode ser editada';
$string['mod_form_field_notification'] = 'Enviar notificação desta alteração aos utilizadores inscritos';
$string['mod_form_field_notification_created_help'] = 'Enviar notificação a todos os utilizadores inscritos a informar que esta atividade foi criada';
$string['mod_form_field_notification_help'] = 'Enviar notificação a todos os utilizadores inscritos a informar que esta atividade foi criada ou modificada';
$string['mod_form_field_notification_modified_help'] = 'Enviar notificação a todos os utilizadores inscritos a informar que esta atividade foi modificada';
$string['mod_form_field_notification_msg_at'] = 'em';
$string['mod_form_field_notification_msg_created'] = 'adicionada';
$string['mod_form_field_notification_msg_modified'] = 'atualizada';
$string['mod_form_field_openingtime'] = 'Data/hora de início';
$string['mod_form_field_participant_add'] = 'Adicionar atribuição';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderador';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Espectador';
$string['mod_form_field_participant_list'] = 'Lista das atribuições';
$string['mod_form_field_participant_list_action_add'] = 'Adicionar';
$string['mod_form_field_participant_list_action_remove'] = 'Remover';
$string['mod_form_field_participant_list_text_as'] = 'juntar à sessão como';
$string['mod_form_field_participant_list_type_all'] = 'Todos os utilizadores inscritos';
$string['mod_form_field_participant_list_type_owner'] = 'Proprietário';
$string['mod_form_field_participant_list_type_role'] = 'Papel';
$string['mod_form_field_participant_list_type_user'] = 'Utilizador';
$string['mod_form_field_record'] = 'Sessão pode ser gravada';
$string['mod_form_field_recordallfromstart'] = 'Gravar tudo desde o início';
$string['mod_form_field_recordhidebutton'] = 'Ocultar botão de gravação';
$string['mod_form_field_recordings_html'] = 'Mostrar tabela em HTML';
$string['mod_form_field_recordings_imported'] = 'Mostrar apenas hiperligações importadas';
$string['mod_form_field_recordings_preview'] = 'Mostrar pré-visualização da gravação';
$string['mod_form_field_room_name'] = 'Nome da sala';
$string['mod_form_field_userlimit'] = 'Limite de utilizadores';
$string['mod_form_field_userlimit_help'] = 'Limite máximo de utilizadores autorizados numa sessão. Se o limite for definido como 0, o número de utilizadores será ilimitado.';
$string['mod_form_field_voicebridge'] = 'Número de acesso à conferência  [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Erro de formatação. Deve inserir um número entre 1 e 9999.';
$string['mod_form_field_voicebridge_help'] = 'Número da conferência de voz que os participantes digitam para participar na conferência de voz. O número deve ser entre 1 e 9999. Se o valor for 0, o número de acesso será ignorado e será gerado um número aleatório pelo BigBlueButton. O número 7 irá preceder os quatro dígitos inseridos';
$string['mod_form_field_voicebridge_notunique_error'] = 'O valor não é único. Este número está a ser utilizado noutra sala ou conferência.';
$string['mod_form_field_wait'] = 'Aguardar por moderador';
$string['mod_form_field_wait_help'] = 'Os espectadores devem esperar até que um moderador entre na sessão para que possam entrar';
$string['mod_form_field_welcome'] = 'Mensagem de boas-vindas';
$string['mod_form_field_welcome_default'] = '<br>Bem-vindo(a) à sessão <b>%%CONFNAME%%</b>!<br><br>Para compreender como funciona o BigBlueButton, veja os nossos <a href="event:http://www.bigbluebutton.org/content/videos"><u>vídeos explicativos</u></a>.<br><br>Para ativar a funcionalidade áudio clique no ícone dos auscultadores.<b> Por favor, use auscultadores para evitar incomodar as outras pessoas.</b>';
$string['mod_form_field_welcome_help'] = 'Substitui a mensagem configurada, por predefinição, para o servidor BigBlueButton. A mensagem pode incluir as palavras-chave (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%), que serão automaticamente substituídas, e também tags HTML, tais como &lt;b&gt;...&lt;/b&gt; ou &lt;i&gt;...&lt;/i&gt;';
$string['mod_form_locksettings'] = 'Configurações de bloqueio';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'O BigBlueButton permite criar ligações a salas de aulas virtuais síncronas, a partir do Moodle, usando o BigBlueButton, um sistema livre de conferência web para educação à distância.

Com o BigBlueButton pode especificar o título, a descrição, eventos de calendário (que definem as datas em que pode aceder à sessão), grupos e detalhes acerca da gravação da sessão.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Atividade BigBlueButton';
$string['nosuchinstance'] = 'Não existe a instância {$a->entity} com o ID {$a->id}';
$string['notification_instance_created_intro'] = 'Foi criada a sala BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_instance_created_small'] = 'Foi criada uma nova sala BigBlueButton com o nome \'{$a->name}\'.';
$string['notification_instance_created_subject'] = 'Foi criada uma nova sala BigBlueButton.';
$string['notification_instance_description'] = 'Descrição';
$string['notification_instance_end_date'] = 'Data de fim';
$string['notification_instance_name'] = 'Título';
$string['notification_instance_start_date'] = 'Data de início';
$string['notification_instance_updated_intro'] = 'A sala BigBlueButton <a href="{$a->link}">{$a->name}</a> foi atualizada.';
$string['notification_instance_updated_small'] = 'A sala BigBlueButton \'{$a->name}\' foi atualizada.';
$string['notification_instance_updated_subject'] = 'A sua sala BigBlueButton foi atualizada.';
$string['notification_recording_ready_html'] = 'Já está disponível a gravação da sessão na sala BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'Já está disponível a gravação da sessão na sala BigBlueButton {$a->name}. Consulte a hiperligação {$a->link} para aceder à gravação.';
$string['notification_recording_ready_small'] = 'Já está disponível a gravação da sessão na sala BigBlueButton {$a->name}.';
$string['notification_recording_ready_subject'] = 'Gravação disponível';
$string['pluginadministration'] = 'Administração BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Para aceder e criar sessões do BigBlueButton, é necessário partilhar informação com o servidor';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Nome completo do utilizador a aceder ao servidor BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'ID do utilizador a aceder ao servidor BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Guarda as configurações da a sala ou atividade que definem o comportamento geral e especificações da sessão BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Lista de regras que definem os papéis dos utilizadores na sessão. O ID do utilizador pode ser guardado, mediante as permissões de cada papel ou utilizador.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Guarda eventos acionados quando utiliza o módulo';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Tipo de evento acionado pelo utilizador.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID da sessão a que o utilizador acedeu.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Pode incluir informação extra relacionada com a sessão ou com a gravação afetada pelo evento.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Data e hora de criação do registo.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID do utilizador que acionou o evento.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Armazena metadados sobre gravações.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'ID do utilizador que alterou a gravação pela última vez.';
$string['recordings_from_deleted_activities'] = 'Gravações de atividades apagadas';
$string['recordingurlnotfound'] = 'O URL da gravação é inválido.';
$string['removedevents'] = 'Eventos apagados';
$string['removedlogs'] = 'Registos personalizados apagados';
$string['removedrecordings'] = 'Gravações apagadas';
$string['removedtags'] = 'Palavras-chave apagadas';
$string['report_join_info'] = 'Juntou-se à sala {$a} vez(es)';
$string['report_play_recording_info'] = 'Reproduziu uma gravação {$a} vez(es)';
$string['report_room_view'] = 'Visualizou a sala';
$string['resetevents'] = 'Apagar eventos';
$string['resetlogs'] = 'Apagar registos personalizados';
$string['resetlogs_help'] = 'Ao apagar os registos perderá as referências às gravações';
$string['resetrecordings'] = 'Apagar gravações';
$string['resetrecordings_help'] = 'Se apagar as gravações, torna-as inacessíveis de qualquer lugar e esta operação é irreversível';
$string['resettags'] = 'Apagar palavras-chave';
$string['search:activity'] = 'BigBlueButton - informação da atividade';
$string['search:tags'] = 'BigBlueButton - informação das palavras-chave';
$string['sendnotification'] = 'Enviar notificação';
$string['settings'] = 'Configurações';
$string['started_at'] = 'Iniciado';
$string['starts_at'] = 'Inicia';
$string['taskname:check_dismissed_recordings'] = 'Verificar gravações descartadas';
$string['taskname:check_pending_recordings'] = 'Obter gravações pendentes';
$string['userlimitreached'] = 'Foi atingido o número máximo de utilizadores autorizados numa sessão.';
$string['view_conference_action_end'] = 'Terminar sessão';
$string['view_conference_action_join'] = 'Participar na sessão';
$string['view_error_action_not_completed'] = 'A ação não pôde ser concluída.';
$string['view_error_bigbluebutton'] = 'BigBlueButton respondeu com erros. {$a}';
$string['view_error_create'] = 'O servidor BigBlueButton respondeu com uma mensagem de erro. Não foi possível criar a sessão.';
$string['view_error_current_state_not_found'] = 'O estado atual não foi encontrado. A gravação pode ser sido apagada ou o servidor do BigBlueButton não é compatível com a ação executada.';
$string['view_error_import_no_courses'] = 'Não existem disciplinas para pesquisar gravações.';
$string['view_error_import_no_recordings'] = 'Não existem gravações nesta disciplina para importar.';
$string['view_error_invalid_session'] = 'Esta sessão expirou. Volte à página principal da atividade.';
$string['view_error_max_concurrent'] = 'Foi atingido o número máximo de sessões simultâneas permitidas.';
$string['view_error_meeting_not_running'] = 'Algo correu mal. A sessão não está a decorrer.';
$string['view_error_no_group'] = 'Ainda não existem grupos configurados. Por favor, configure os grupos antes de tentar participar na sessão.';
$string['view_error_no_group_student'] = 'Não está inscrito em nenhum grupo. Por favor, entre em contacto com o seu professor ou com o Administrador.';
$string['view_error_no_group_teacher'] = 'Ainda não existem grupos configurados. Por favor, configure os grupos ou entre em contacto com o Administrador.';
$string['view_error_unable_join'] = 'Não é possível adicioná-lo à sessão. Por favor, verifique o URL do servidor BigBlueButton e garanta que este está a funcionar corretamente.';
$string['view_error_unable_join_student'] = 'Não é possível estabelecer a ligação ao servidor BigBlueButton. Por favor, contacte o seu Professor ou o Administrador.';
$string['view_error_unable_join_teacher'] = 'Não é possível estabelecer a ligação ao servidor BigBlueButton. Por favor, contacte o Administrador.';
$string['view_error_url_missing_parameters'] = 'Existem parâmetros em falta nesta URL';
$string['view_error_userlimit_reached'] = 'Foi atingido o número máximo de utilizadores autorizados numa sessão.';
$string['view_groups_nogroups_warning'] = 'Esta sala foi configurada para utilizar grupos, mas ainda não foram definidos grupos na disciplina.';
$string['view_groups_notenrolled_warning'] = 'A sala foi configurada para utilização por grupo, mas você não está inscrito em nenhum grupo.';
$string['view_groups_selection'] = 'Selecione o grupo ao qual pretende juntar-se e confirme a ação';
$string['view_groups_selection_join'] = 'Entrar';
$string['view_groups_selection_warning'] = 'Existe uma sala de conferência para cada grupo e você tem acesso a mais do que uma. Certifique-se que seleciona a sala correta.';
$string['view_login_moderator'] = 'Entrar como moderador...';
$string['view_login_viewer'] = 'Entrar como espectador...';
$string['view_message_and'] = 'e';
$string['view_message_conference_has_ended'] = 'A conferência já terminou.';
$string['view_message_conference_in_progress'] = 'A conferência está a decorrer.';
$string['view_message_conference_not_started'] = 'A conferência ainda não começou.';
$string['view_message_conference_room_ready'] = 'A sala de conferência está preparada. Pode participar na sessão.';
$string['view_message_conference_user_limit_reached'] = 'Foi atingido o número máximo de utilizadores permitidos na sessão';
$string['view_message_conference_wait_for_moderator'] = 'A aguardar a entrada de um moderador...';
$string['view_message_finished'] = 'Atividade encerrada.';
$string['view_message_has_joined'] = 'entrou';
$string['view_message_have_joined'] = 'entraram';
$string['view_message_hour'] = 'hora';
$string['view_message_hours'] = 'horas';
$string['view_message_importrecordings_disabled'] = 'A função \'Importar hiperligação da gravação\' está desativada neste servidor.';
$string['view_message_minute'] = 'minuto';
$string['view_message_minutes'] = 'minutos';
$string['view_message_moderator'] = 'moderador';
$string['view_message_moderators'] = 'moderadores';
$string['view_message_norecordings'] = 'Não existem gravações para reproduzir.';
$string['view_message_notavailableyet'] = 'Esta sessão ainda não está disponível.';
$string['view_message_recordings_disabled'] = 'As gravações foram desativadas neste servidor. As instâncias de \'Apenas gravações\' não podem ser utilizadas no BigBlueButton.';
$string['view_message_room_closed'] = 'Esta sala está fechada.';
$string['view_message_room_open'] = 'Esta sala está aberta.';
$string['view_message_room_ready'] = 'Esta sala está pronta.';
$string['view_message_session_for'] = 'a sessão para';
$string['view_message_session_has_user'] = 'Na conferência está';
$string['view_message_session_has_users'] = 'Na conferência estão';
$string['view_message_session_no_users'] = 'Não existem utilizadores nesta sessão';
$string['view_message_session_running_for'] = 'Esta sessão está em execução há';
$string['view_message_session_started_at'] = 'Esta sessão começou às';
$string['view_message_tab_close'] = 'Este separador/janela deve ser fechado manualmente.';
$string['view_message_times'] = 'hora';
$string['view_message_user'] = 'utilizador';
$string['view_message_users'] = 'utilizadores';
$string['view_message_viewer'] = 'espectador';
$string['view_message_viewers'] = 'espectadores';
$string['view_mobile_message_groups_not_supported'] = 'Esta instância está ativada para trabalhar com grupos, mas a Aplicação móvel Moodle não tem suporte para tal. Por favor, aceda através de um computador se pretender usar suporte para grupos.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Excedeu os 45 segundos nesta página. Atualize a página para participar corretamente na sessão.';
$string['view_noguests'] = 'O BigBlueButton não está aberto a visitantes';
$string['view_nojoin'] = 'Não está autorizado a participar nesta sessão.';
$string['view_recording'] = 'a gravação';
$string['view_recording_actionbar'] = 'Barra de ferramentas';
$string['view_recording_activity'] = 'Atividade';
$string['view_recording_button_import'] = 'Importar hiperligação da gravação';
$string['view_recording_button_return'] = 'Voltar';
$string['view_recording_course'] = 'Disciplina';
$string['view_recording_date'] = 'Data/hora';
$string['view_recording_delete_confirmation'] = 'Tem a certeza de que pretende apagar {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Esta gravação tem {$a} hiperligações associadas que foram importadas de diferentes disciplinas ou atividades. Se a gravação for apagada, as hiperligações também serão apagadas';
$string['view_recording_delete_confirmation_warning_s'] = 'Esta gravação tem {$a} hiperligação associada que foi importada de uma disciplina ou atividade diferente. Se a gravação for apagada, a hiperligação também será apagada';
$string['view_recording_description'] = 'Descrição';
$string['view_recording_description_edithint'] = 'Pode ser adicionada uma descrição para ajudar a identificar a gravação.';
$string['view_recording_description_editlabel'] = 'Editar descrição';
$string['view_recording_duration'] = 'Duração';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'O URL para este formato de gravação está inacessível.';
$string['view_recording_format_notes'] = 'Observações';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Apresentação';
$string['view_recording_format_screenshare'] = 'Partilha de ecrã';
$string['view_recording_format_statistics'] = 'Estatísticas';
$string['view_recording_format_video'] = 'Vídeo';
$string['view_recording_import_confirmation'] = 'Tem a certeza de que pretende importar esta gravação?';
$string['view_recording_length'] = 'Comprimento';
$string['view_recording_link'] = 'hiperligação importada';
$string['view_recording_link_warning'] = 'Hiperligação que direciona para a gravação que foi criada numa disciplina ou atividade diferente.';
$string['view_recording_list_action_delete'] = 'A apagar';
$string['view_recording_list_action_edit'] = 'A atualizar';
$string['view_recording_list_action_play'] = 'Reproduzir';
$string['view_recording_list_action_process'] = 'A processar';
$string['view_recording_list_action_protect'] = 'A proteger';
$string['view_recording_list_action_publish'] = 'A publicar';
$string['view_recording_list_action_unprotect'] = 'A retirar proteção';
$string['view_recording_list_action_unpublish'] = 'A apagar publicação';
$string['view_recording_list_action_update'] = 'A atualizar';
$string['view_recording_list_actionbar'] = 'Barra de ferramentas';
$string['view_recording_list_actionbar_delete'] = 'Apagar';
$string['view_recording_list_actionbar_edit'] = 'Editar';
$string['view_recording_list_actionbar_hide'] = 'Ocultar';
$string['view_recording_list_actionbar_import'] = 'Importar';
$string['view_recording_list_actionbar_protect'] = 'Tornar privado';
$string['view_recording_list_actionbar_publish'] = 'Publicar';
$string['view_recording_list_actionbar_show'] = 'Mostrar';
$string['view_recording_list_actionbar_unprotect'] = 'Tornar público';
$string['view_recording_list_actionbar_unpublish'] = 'Apagar publicação';
$string['view_recording_list_activity'] = 'Atividade';
$string['view_recording_list_course'] = 'Disciplina';
$string['view_recording_list_date'] = 'Data';
$string['view_recording_list_description'] = 'Descrição';
$string['view_recording_list_duration'] = 'Duração';
$string['view_recording_list_recording'] = 'Gravação';
$string['view_recording_meeting'] = 'Sessão';
$string['view_recording_modal_button'] = 'Aplicar';
$string['view_recording_modal_title'] = 'Definir valores para a gravação';
$string['view_recording_name'] = 'Nome';
$string['view_recording_name_edithint'] = 'Pode ser adicionado um nome para ajudar a identificar a gravação.';
$string['view_recording_name_editlabel'] = 'Editar nome';
$string['view_recording_playback'] = 'Reproduzir';
$string['view_recording_preview'] = 'Pré-visualizar';
$string['view_recording_preview_help'] = 'Passar rato sobre a imagem para visualizar em tamanho real';
$string['view_recording_protect_confirmation'] = 'Tem a certeza de que pretende proteger esta {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Esta gravação tem {$a} hiperligações associadas que foram importadas em disciplinas diferentes ou atividades. Se a gravação estiver protegida também afetará as hiperligações importadas.';
$string['view_recording_protect_confirmation_warning_s'] = 'Esta gravação tem {$a} hiperligação associada que foi importada numa disciplina diferente ou atividade. Se a gravação estiver protegida também afetará as hiperligações importadas.';
$string['view_recording_publish_confirmation'] = 'Tem a certeza de que pretende publicar esta {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Esta gravação tem {$a} hiperligações associadas que foram importadas em disciplinas diferentes ou atividades. Se a gravação estiver publicada as hiperligações também serão publicadas.';
$string['view_recording_publish_confirmation_warning_s'] = 'Esta gravação tem {$a} hiperligação associada que foi importada numa disciplina diferente ou atividade. Se a gravação estiver publicada a hiperligação também será publicada.';
$string['view_recording_publish_link_deleted'] = 'Esta hiperligação não pode ser publicada novamente porque a gravação não existe no servidor BigBlueButton. A hiperligação deverá ser apagada.';
$string['view_recording_publish_link_not_published'] = 'Esta hiperligação não pode ser publicada novamente porque a gravação não está publicada';
$string['view_recording_recording'] = 'Gravação';
$string['view_recording_select_course'] = 'Selecione uma disciplina da lista pendente';
$string['view_recording_tags'] = 'Etiquetas';
$string['view_recording_unprotect_confirmation'] = 'Tem a certeza de que pretende desproteger esta {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Esta gravação tem {$a} hiperligações associadas que foram importadas em disciplinas diferentes ou atividades. Se a gravação estiver desprotegida também afetará as hiperligações importadas.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Esta gravação tem {$a} hiperligação associada que foi importada numa disciplina diferente ou atividade. Se a gravação estiver desprotegida também afetará as hiperligações importadas.';
$string['view_recording_unprotect_link_deleted'] = 'Esta hiperligação não pode ser desprotegida porque a gravação não existe no atual servidor BigBlueButton. A hiperligação deverá ser apagada.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Esta hiperligação não pode ser desprotegida porque a gravação está protegida';
$string['view_recording_unpublish_confirmation'] = 'Tem a certeza de que pretende apagar a publicação {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Esta gravação tem {$a} hiperligações associadas que foram importadas de diferentes disciplinas ou atividades. Se a gravação não estiver publicada, as hiperligações também não serão publicadas';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Esta gravação tem {$a} hiperligação associada que foi importada de uma disciplina ou atividade diferente. Se a gravação não estiver publicada, a hiperligação também não será publicada';
$string['view_recording_yui_first'] = 'Primeira';
$string['view_recording_yui_go'] = 'Iniciar';
$string['view_recording_yui_last'] = 'Última';
$string['view_recording_yui_next'] = 'Seguinte';
$string['view_recording_yui_page'] = 'Página';
$string['view_recording_yui_prev'] = 'Anterior';
$string['view_recording_yui_rows'] = 'Linhas';
$string['view_recording_yui_show_all'] = 'Mostrar tudo';
$string['view_room'] = 'Ver sala';
$string['view_section_title_presentation'] = 'Ficheiro de apresentação';
$string['view_section_title_recordings'] = 'Gravações';
$string['view_warning_default_server'] = 'Este servidor Moodle está a utilizar o servidor BigBlueButton predefinido para testes. Deve ser alterado nos sites em produção.';
$string['waitformoderator'] = 'A aguardar a entrada de um moderador...';
