<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz_answersheets', language 'nl', version '3.11'.
 *
 * @package     quiz_answersheets
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admin_instruction_message'] = 'Instructiebericht';
$string['admin_instruction_message_des'] = 'Indien ingesteld zal dit bericht getoond worden bovenaan het rapport. Je kunt dit gebruiken om bijvoorbeeld naar een beleid van je instituut te linken over het afdrukken van testen.';
$string['answer_sheet_label'] = 'Antwoordpagina met juiste antwoorden';
$string['answer_sheet_title'] = '{$a->courseshortname} - {$a->quizname} - Antwoordpagina';
$string['answersheets'] = 'Exporteer pogingen';
$string['answersheets:bulkdownload'] = 'Download verbeterpagina\'s in bulk';
$string['answersheets:componentname'] = 'Exporteer testpogingen';
$string['answersheets:createattempt'] = 'Maak een poging voor nog een gebruiker';
$string['answersheets:submitresponses'] = 'Stuur antwoorden van leerling in';
$string['answersheets:view'] = 'Bekijk pagina met poging';
$string['answersheets:viewrightanswers'] = 'Bekijk pagina met juiste antwoorden';
$string['answersheetsfilename'] = 'Exporteerbare_test_pogingen';
$string['answersheetsreport'] = 'Exporteer testspogingen';
$string['attempt_sheet_label'] = 'Pogingenpagina';
$string['attempt_sheet_title'] = '{$a->courseshortname} - {$a->quizname} - Pogingenpagina';
$string['bulkdownloadlink'] = 'Download verbeterpagina\'s in bulk';
$string['bulkinstructions'] = 'Om verbeterpagina\'s in bulk te kunnen downloaden heb je de \'bewaar antwoordpagina\'s\'-tool nodig op je computer. Eens je die tool hebt:

1. De pogingen die gedownload zullen worden wanneer je deze instructies volgt, zijn gebaseerd op de instellingen van het rapport dat je net verlaten hebt.
Wat dit proces zal doen is elke link naar een **verbeterpagina** daar volgen. Dus, als je twijfelt, ga dan terug en controleer of het rapport de pogingen toont die je wil exporteren.
2. Eens je daarmee tevreden bent, download [buld download stappenbestand]($a->scripturl) dat  \'save-answersheets\' zal informeren wat er moet gebeuren.
**Let op bovenstaande waarschuwing!**
3. Bewaar dat bestand (dat de naam `{$a->scriptname}-steps.txt` zou moeten hebben) in dezelfde map waar je `save-answersheets` bewaard hebt op je computer.
4. Open een terminalvenster en ga naar die map.
5. Typ het commando `.\\save-answersheets \'{$a->scriptname}-steps.txt\'`  en wacht tot het klaar is. Het commando geeft output over wat het aan het doen is.
6. Eens het script klaar is, zou je een bestand `{$a->scriptname}.zip` in de`output`map moeten hebben.
7. Denk er aan om het bestand  `{$a->scriptname}-steps.txt` te verwijderen.

Als je klaar bent met het bestand te downloaden en je wil de bestanden voor slechts  één leerling, dan kun je een commando laten lopen zoals
`.\\save-answersheets --download-only \'X1234567\' \'{$a->scriptname}-steps.txt\'`

Als je enkel de bijlagen nodig hebt, zonder de PDF van de verbeterpagina, voeg dan  `--skip-pdfs`  toe aan het commando. Dit werkt veel sneller.
Voorbeeldcommando:  `.\\save-answersheets --skip-pdfs \'{$a->scriptname}-steps.txt\'`.

Deze twee opties kunnen gecombineerd worden, bijvoorbeeld `.\\save-answersheets --skip-pdfs --download-only \'X1234567\' \'{$a->scriptname}-steps.txt\'`.

Als je deze commando\'s opnieuw laat lopen, dan ga je alleen de bestanden downloaden die nog niet opgehaald zijn. Dit kan nuttig zijn als bijvoorbeeld enkele bijkomende leerlingen de test afgelegd hebben.';
$string['bulkinstructionstitle'] = 'Instructies voor het downloaden van verbeterpagina\'s in bulk';
$string['bulkinstructionswarning'] = '<b>Waarschuwing!</b> Het bestand dat je downloadt in stap twee van onderstaande instructies bevat genoeg informatie om de tool de testpogingen te laten downloaden en bewaren met je huidige login-sessie. Je <b>moet</b> dat bestand verwijderen wanneer je er klaar mee bent. Het bestand bewaren is een beveiligingsrisico.';
$string['coderunner_instruction'] = 'Schrijf je antwoord op de voorziene plaats.';
$string['column_answer_sheet'] = 'Antwoordpagina\'s';
$string['column_attempt_sheet'] = 'Pogingpagina\'s';
$string['column_submit_student_responses'] = 'Stuur leerlingenantwoorden in';
$string['combine_feedback_correct'] = 'Indien juist:';
$string['combine_feedback_general'] = 'Algemene feedback en verdere informatie:';
$string['combine_feedback_incorrect'] = 'Indien fout:';
$string['combine_feedback_partially_correct'] = 'Indien gedeeltelijk juist:';
$string['create_attempt'] = 'Maak poging';
$string['create_attempt_modal_button'] = 'Maak';
$string['create_attempt_modal_description'] = 'Weet je zeker dat je een testpoging wil maken voor {$a}?';
$string['create_attempt_modal_title'] = 'Bevestiging';
$string['ddimageortext_instruction'] = 'Markeer de punten op de afbeelding en schrijf de letter van het overeenkomstige antwoord (A,B,C,D, ...) er naast.
Achter het item staat het maximaal aantal keer dat het kan gebruikt worden, vb (1) betekent dat het item slechts 1 keer kan gebuikt worden, (2) betekent twee keer enz. Een asterisk (*) betekent dat het item onbeperkt gebruikt kan worden.';
$string['ddmarker_instruction'] = 'Markeer de punten op de afbeelding en schrijf de letter van het overeenkomstige antwoord (A,B,C,D, ...) er naast.
Achter het item staat het maximaal aantal keer dat het kan gebruikt worden, vb (1) betekent dat het item slechts 1 keer kan gebuikt worden, (2) betekent twee keer enz. Een asterisk (*) betekent dat het item onbeperkt gebruikt kan worden.';
$string['ddwtos_instruction'] = 'Schrijf de letter van het overeenkomstige antwoord (A,B,C,D, ...) op de voorziene plaats.
Achter het item staat het maximaal aantal keer dat het kan gebruikt worden, vb (1) betekent dat het item slechts 1 keer kan gebuikt worden, (2) betekent twee keer enz. Een asterisk (*) betekent dat het item onbeperkt gebruikt kan worden.';
$string['essay_instruction'] = 'Schrijf je antwoord op de voorziene plaats.';
$string['event_attempt_created'] = 'Maak een testpoging voor gebruiker';
$string['event_attempt_printed'] = 'Test pogingpagina afgedrukt';
$string['event_attempt_viewed'] = 'Test pogingpagina bekeken';
$string['event_responses_submitted'] = 'Test antwoorden ingestuurd voor gebruiker';
$string['event_right_answer_printed'] = 'Test juiste antwoordenpagina afgedrukt';
$string['event_right_answer_viewed'] = 'Test juiste antwoordenpagina bekeken';
$string['examcode'] = 'Bevestigingscode';
$string['gapselect_instruction'] = 'Schrijf de letter van het overeenkomstige antwoord (A,B,C,D, ...) op de voorziene plaats.';
$string['interactive_content_warning'] = 'Interactieve inhoud is niet beschikbaar in dit formaat';
$string['match_instruction'] = 'Schrijf de letter van het overeenkomstige antwoord (A,B,C,D, ...) op de voorziene plaats.';
$string['multichoice_instruction'] = 'Selecteer het juiste antwoord.';
$string['no_response_recorded'] = 'Geen antwoord bewaard.';
$string['numerical_instruction'] = 'Schrijf je antwoord (in een numerieke waarde) op de voorziene plaats.';
$string['ordering_instruction'] = 'Schrijf de juiste volgorde in onderstaande ruimte.';
$string['oumultiresponse_instruction'] = 'Selecteer de juiste antwoorden';
$string['page_type_answer'] = 'Antwoordpagina';
$string['page_type_attempt'] = 'Pogingpagina';
$string['page_type_review'] = 'Verbeterpagina';
$string['pluginname'] = 'Exporteer testpogingen';
$string['pmatch_instruction'] = 'Schrijf je antwoord op de voorziene plaats. Beperk het tot een paar zinnen.';
$string['pmatchjme_instruction'] = 'Schrijf je antwoord op de voorziene plaats';
$string['print'] = 'Afdrukken';
$string['print_header'] = '{$a->courseshortname} {$a->quizname} voor {$a->studentname} genereerde {$a->generatedtime} - {$a->sheettype}';
$string['print_header_minimised'] = '{$a->courseshortname} {$a->quizname} genereerde {$a->generatedtime} - {$a->sheettype}';
$string['privacy:metadata'] = 'De Exporteer test pogingen-plugin bewaart geen persoonlijke gegevens. Het geeft een bijkomende interface voor het bekijken en beheren van gegevens die eigendom zijn van de test-activiteit.';
$string['response_recorded'] = 'Antwoord bewaard: {$a}';
$string['review_sheet_label'] = 'Verbeterpagina';
$string['review_sheet_title'] = '{$a->courseshortname} - {$a->quizname} - Verbeterpagina';
$string['shortanswer_instruction'] = 'Schrijf je antwoord op de voorziene plaats. Beperk je tot enkele zinnen.';
$string['showquestioninstruction'] = 'Standaard instructietekst tonen?';
$string['showuserinfo'] = 'Identificatie-informatie tonen over gebruikers';
$string['stack_instruction'] = 'Noteer je antwoord in de voorziene ruimte.';
$string['strftime_header'] = '%d %b %Y, %H:%M';
$string['submit_student_responses_dialog_content'] = 'Weet je zeker dat je wil insturen?';
$string['submit_student_responses_label'] = 'Antwoorden insturen ...';
$string['submit_student_responses_on_behalf'] = 'Stuur antwoorden in voor {$a} en beëindig poging';
$string['submit_student_responses_title'] = '{$a}: stuur antwoorden voor leerling in';
$string['truefalse_instruction'] = 'Selecteer het juiste antwoord.';
$string['user_identity_fields'] = '({$a})';
$string['varnumeric_instruction'] = 'Noteer je antwoord in de voorziene ruimte.';
$string['varnumericset_instruction'] = 'Noteer je antwoord in de voorziene ruimte.';
$string['varnumunit_instruction'] = 'Noteer je antwoord in de voorziene ruimte.';
$string['webservicecannotcreateattempts'] = 'Kan poging niet maken';
$string['wordselect_instruction'] = 'Selecteer de antwoorden door de sleutelwoorden te omcirkelen.';
