<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'nl', version '3.11'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'A';
$string['Afull'] = 'Afwezig';
$string['Eacronym'] = 'V';
$string['Efull'] = 'Verontschuldigd';
$string['Lacronym'] = 'L';
$string['Lfull'] = 'Te laat';
$string['Pacronym'] = 'P';
$string['Pfull'] = 'Present';
$string['absenteereport'] = 'Afwezigheidsrapportage';
$string['acronym'] = 'Acroniem';
$string['add'] = 'Voeg toe';
$string['addedrecip'] = '{$a} nieuwe ontvanger toegevoegd';
$string['addedrecips'] = '{$a} nieuwe ontvangers toegevoegd';
$string['addmultiplesessions'] = 'Meerdere sessies';
$string['addsession'] = 'Voeg sessie toe';
$string['adduser'] = 'Gebruiker toevoegen';
$string['addwarning'] = 'Voeg waarschuwing toe';
$string['all'] = 'Alle';
$string['allcourses'] = 'Alle cursussen';
$string['allpast'] = 'Alle vorige';
$string['allsessions'] = 'Alle sessies';
$string['allsessionstotals'] = 'Totalen voor geselecteerde sessies';
$string['attendance:addinstance'] = 'Voeg nieuwe aanwezigheidsactiviteit toe';
$string['attendance:canbelisted'] = 'Verschijnt in het rooster';
$string['attendance:changeattendances'] = 'Wijzig aanwezigheid';
$string['attendance:changepreferences'] = 'Wijzig voorkeuren';
$string['attendance:export'] = 'Exporteer rapporten';
$string['attendance:import'] = 'Sessies importeren uit bestand (CSV)';
$string['attendance:manageattendances'] = 'Beheer aanwezigheid';
$string['attendance:managetemporaryusers'] = 'Beheer tijdelijke gebruikers';
$string['attendance:takeattendances'] = 'Neem aanwezigheid op';
$string['attendance:view'] = 'Bekijk aanwezigheid';
$string['attendance:viewreports'] = 'Rapporten bekijken';
$string['attendance:viewsummaryreports'] = 'Bekijk cursusoverzichtrapportage';
$string['attendance:warningemails'] = 'Kan zich aanmelden om een e-mail te ontvangen van afwezige gebruikers';
$string['attendance_already_submitted'] = 'Je aanwezigheid is al geregistreerd.';
$string['attendance_no_status'] = 'Er is geen geldige status aanwezig - je wil misschien later de aanwezigheid registreren.';
$string['attendancedata'] = 'Aanwezigheids gegevens';
$string['attendancefile'] = 'Aanwezigheidsbestand (CSV format)';
$string['attendancefile_help'] = 'Het bestand moet een CSV-bestand zijn met een regel die de koppen bevat en velden om de gebruiker te identificeren en het tijdstip waarop aanwezigheid geregistreerd werd, bijv. (email, scantime) of (username,time)';
$string['attendanceforthecourse'] = 'Aanwezigheid voor de cursus';
$string['attendancegrade'] = 'Aanwezigheidscijfer';
$string['attendancenotset'] = 'Je moet de aanwezigheid opnemen';
$string['attendancenotstarted'] = 'Aanwezigheid is nog niet gestart voor deze cursus';
$string['attendancepercent'] = 'Percentage aanwezigheid';
$string['attendancereport'] = 'Aanwezigheidsrapport';
$string['attendanceslogged'] = 'Aanwezigheid gelogd';
$string['attendancestaken'] = 'Aanwezigheid opgenomen';
$string['attendancesuccess'] = 'Aanwezigheid is succesvol opgenomen';
$string['attendanceupdated'] = 'Aanwezigheid is succesvol gewijzigd';
$string['attforblockdirstillexists'] = 'Oude mod/attforblock-map bestaat nog steeds - je moet deze map van je server verwijderen voor je deze update uitvoert.';
$string['attrecords'] = 'Aanwezigheids regels';
$string['autoassignstatus'] = 'Selecteer automatisch de hoogste beschikbare status';
$string['autoassignstatus_help'] = 'Wanneer deze instelling is geselecteerd, zullen studenten automatisch het hoogst beschikbare cijfer toegewezen krijgen.';
$string['automark'] = 'Automatisch markeren';
$string['automarkall'] = 'Ja';
$string['automarkclose'] = 'Instellen op niet gemarkeerd aan het einde van de sessie';
$string['automarktask'] = 'Controleren op aanwezigheidssessies die automatisch markeren vereisen';
$string['automarkuseempty'] = 'Afhandelen beschikbaarheid automatisch markeren';
$string['automarkuseempty_desc'] = 'Indien aangevinkt zijn status items met een lege of niet ingestelde instelling "beschikbaar voor" toegestaan tijdens automatisch markeren';
$string['autorecorded'] = 'automatisch opgenomen door systeem';
$string['averageattendance'] = 'Gemiddelde aanwezigheid';
$string['averageattendancegraded'] = 'Gemiddelde aanwezigheid';
$string['backtoparticipants'] = 'Terug naar deelnemerslijst';
$string['below'] = 'Minder dan {$a} %';
$string['calclose'] = 'Sluiten';
$string['calendarevent'] = 'Kalendergebeurtenis maken voor sessie';
$string['calendarevent_help'] = 'Indien ingeschakeld wordt er een kalendergebeurtenis aangemaakt voor deze sessie.
Indien uitgeschakeld wordt een al bestaande kalendergebeurtenis voor deze sessie verwijderd.';
$string['caleventcreated'] = 'Kalendergebeurtenis voor sessie succesvol aangemaakt';
$string['caleventdeleted'] = 'Kalendergebeurtenis voor sessie succesvol verwijderd';
$string['calmonths'] = 'januari,februari,maart,april,mei,juni,juli,augustus,september,oktober,november,december';
$string['calshow'] = 'Kies datum';
$string['calweekdays'] = 'zo,ma,di,wo,do,vr,za,zo';
$string['cannottakeforgroup'] = 'U kan geen aanwezigheid opnemen voor groep "{$a}"';
$string['cannottakethisgroup'] = 'Je bent geen lid van de cursusgroep waarop deze aanwezigheidssessie betrekking heeft, je aanwezigheid is niet opgenomen.';
$string['cantaddstatus'] = 'Stel een acroniem en beschrijving in wanneer je een nieuwe status toevoegt.';
$string['categoryreport'] = 'Cursus categorie rapportage';
$string['changeattendance'] = 'Wijzig aanwezigheid';
$string['changeduration'] = 'Wijzig duur';
$string['changesession'] = 'Wijzig sessie';
$string['checkweekdays'] = 'Selecteer weekdagen die binnen het geselecteerde datumbereik vallen.';
$string['closed'] = 'Deze sessie is op dit moment niet beschikbaar om zelf te markeren';
$string['column'] = 'kolom';
$string['columnmap'] = 'Toewijzing kolommen';
$string['columns'] = 'kolommen';
$string['commonsession'] = 'Alle leerlingen';
$string['commonsessions'] = 'Alle leerlingen';
$string['confirm'] = 'Bevestig';
$string['confirmcolumnmappings'] = 'Toewijzing kolommen bevestigen';
$string['confirmdeletehiddensessions'] = 'Weet je zeker dat je {$a->count} sessies wilt verwijderen die gepland staan voor de cursus datum ({$a->date})?';
$string['confirmdeleteuser'] = 'Weet je zeker dat je gebruiker \'{$a->fullname}\' ({$a->email})?<br/> wilt verwijderen. Al zijn of haar aanwezigheidsregistraties worden permanent verwijderd.';
$string['copyfrom'] = 'Kopieer aanwezigheids gegevens  van';
$string['countofselected'] = 'Aantal geselecteerd.';
$string['course'] = 'Cursus';
$string['coursemessage'] = 'Bericht sturen aan cursusgebruikers';
$string['courseshortname'] = 'Korte naam van de cursus';
$string['coursesummary'] = 'Cursus samenvattingsrapportage';
$string['createmultiplesessions'] = 'Creëer meerdere sessies';
$string['createmultiplesessions_help'] = 'Met deze functie kun je in een keer meerdere sessies aanmaken . De sessies beginnen op de datum van de basissessie en lopen door tot de datum \'Herhaal tot\' is bereikt.
<ul>
<li><strong>Herhaal op</strong>: Selecteer de dag(en) van de week waarop je bijeenkomst plaatsvindt (bijvoorbeeld Maandag/Woensdag/Vrijdag).</li>
<li><strong>Herhaal iedere</strong>:Hiermee kun je de frequentie instellen. Als je bijeenkomst iedere week plaatsvindt, kies je 1; Als dat om de week is, kies je 2; Als dat om de 2 weken is, kies je 3.</li>
<li><strong>Herhaal tot</strong>: Selecteer de laatste dag van de reeks bijeenkomsten (de laatste dag dat je aanwezigheid wilt bijhouden).</li>
</ul>';
$string['createonesession'] = 'Creëer één sessie voor de cursus';
$string['csvdelimiter'] = 'CSV scheidingsteken';
$string['currentlyselectedusers'] = 'Huidige geselecteerde gebruikers';
$string['customexportfields'] = 'Exporteer aangepaste profielvelden van gebruikers';
$string['customexportfields_help'] = 'Aanvullende aangepaste profielvelden van gebruikers om te tonen in de te exporteren rapportage.';
$string['date'] = 'Datum';
$string['days'] = 'Dagen';
$string['defaultdisplaymode'] = 'Standaard presentatie modus';
$string['defaults'] = 'Standaarden';
$string['defaultsessionsettings'] = 'Standaard sessie instellingen';
$string['defaultsessionsettings_help'] = 'Deze instellingen definiëren de standaardwaardes voor alle nieuwe sessies';
$string['defaultsettings'] = 'Standaard aanwezigheidsinstellingen';
$string['defaultsettings_help'] = 'Deze instellingen definiëren de standaardwaardes voor alle nieuwe aanwezigheidsregistraties';
$string['defaultstatus'] = 'Standaard status set';
$string['defaultsubnet'] = 'Standaard netwerkadres';
$string['defaultview'] = 'Standaard weergave bij login';
$string['defaultview_desc'] = 'Dit is de standaardweergave die leraren zien wanneer ze voor het eerst inloggen.';
$string['defaultwarnings'] = 'Standaard waarschuwingsset';
$string['defaultwarningsettings'] = 'Standaard waarschuwingsinstellingen';
$string['defaultwarningsettings_help'] = 'Deze instellingen definiëren de standaardwaardes voor alle nieuwe waarschuwingen';
$string['delete'] = 'Verwijderen';
$string['deletecheckfull'] = 'Weet je heel zeker dat je de {$a} volledig wilt verwijderen, inclusief alle gebruikersgegevens?';
$string['deletedgroup'] = 'De aan deze sessie gekoppelde groep is verwijderd';
$string['deletehiddensessions'] = 'Verwijder alle verborgen sessies';
$string['deletelogs'] = 'Verwijder aanwezigheids-gegevens';
$string['deleteselected'] = 'Verwijder geselecteerde';
$string['deletesession'] = 'Verwijder sessie';
$string['deletesessions'] = 'Verwijder alle sessies';
$string['deleteuser'] = 'Gebruiker verwijderen';
$string['deletewarningconfirm'] = 'Weet je zeker dat je deze waarschuwing wilt verwijderen?';
$string['deletingsession'] = 'Verwijder sessie voor deze cursus';
$string['deletingstatus'] = 'Verwijder status voor deze cursus';
$string['description'] = 'Omschrijving';
$string['display'] = 'Tonen';
$string['displaymode'] = 'Presentatie modus';
$string['donotusepaging'] = 'Gebruik geen paginering';
$string['downloadexcel'] = 'Download in Excel formaat';
$string['downloadooo'] = 'Download in OpenOffice formaat';
$string['downloadtext'] = 'Download in Text formaat';
$string['duration'] = 'Lengte';
$string['editsession'] = 'Wijzig sessie';
$string['edituser'] = 'Gebruiker aanpassen';
$string['emailcontent'] = 'E-mail inhoud';
$string['emailcontent_default'] = 'Hoi %userfirstname%,

Je aanwezigheid in %coursename% %attendancename% is onder %warningpercent% gedaald en is op het moment  %percent% - we hopen dat alles goed gaat met je!

Om te zorgen dat je het meeste haalt uit deze cursus, zal je aanwezigheid moeten verbeteren. Neem alsjeblieft contact met ons op voor verdere ondersteuning.';
$string['emailcontent_help'] = 'Wanneer een waarschuwing gestuurd wordt naar een student, wordt de e-mail inhoud gebruikt dat in dit veld staat. De volgende plaatshouders kunnen gebruikt worden.
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'E-mail onderwerp';
$string['emailsubject_default'] = 'Aanwezigheidswaarschuwing';
$string['emailsubject_help'] = 'Wanneer een waarschuwing wordt gestuurd naar een student, wordt het e-mail onderwerp gebruikt dat in dit veld staat.';
$string['emailuser'] = 'E-mail gebruiker';
$string['emailuser_help'] = 'Indien aangevinkt wordt er een waarschuwing naar de leerling gestuurd.';
$string['emptyacronym'] = 'Lege acroniemen zijn niet toegestaan. Status record niet aangepast.';
$string['emptydescription'] = 'Lege beschrijvingen zijn niet toegestaan. Status record niet aangepast.';
$string['enablecalendar'] = 'Kalendergebeurtenissen aanmaken';
$string['enablewarnings'] = 'Waarschuwingen inschakelen';
$string['encoding'] = 'Codering';
$string['endofperiod'] = 'Einde van Periode';
$string['endtime'] = 'Sessie Eindtijd';
$string['enrolmentend'] = 'Inschrijving gebruiker eindigt op "{$a}"';
$string['enrolmentstart'] = 'Inschrijving gebruiker start op "{$a}"';
$string['enrolmentsuspended'] = 'Inschrijving opgeschort';
$string['enterpassword'] = 'Wachtwoord invoeren';
$string['error:coursehasnoattendance'] = 'De cursus met korte naam {$a} bevat geen activiteiten van het type Aanwezigheid.';
$string['error:coursenotfound'] = 'Er kan geen cursus worden gevonden met de korte naam {$a}.';
$string['error:qrcode'] = 'Leerlingen toestaan hun eigen aanwezigheid te registreren moet zijn ingeschakeld om QR code te kunnen gebruiken! Overslaan.';
$string['error:sessioncourseinvalid'] = 'Er is een sessiecursus ongeldig! Overslaan.';
$string['error:sessiondateinvalid'] = 'Er is een sessiedatum ongeldig! Overslaan.';
$string['error:sessionendinvalid'] = 'Er is een sessie-eindtijd ongeldig! Overslaan.';
$string['error:sessionstartinvalid'] = 'Er is een sessie-starttijd ongeldig! Overslaan.';
$string['errorgroupsnotselected'] = 'Selecteer één of meer groepen';
$string['errorinaddingsession'] = 'Fout in het toevoegen van sessies';
$string['erroringeneratingsessions'] = 'Fout in het genereren van sessies';
$string['eventdurationupdated'] = 'Sessie lengte gewijzigd';
$string['eventreportviewed'] = 'Aanwezigheidsrapport bekeken';
$string['eventscreated'] = 'Kalendergebeurtenissen aangemaakt';
$string['eventsdeleted'] = 'Kalendergebeurtenissen verwijderd';
$string['eventsessionadded'] = 'Sessie toegevoegd';
$string['eventsessiondeleted'] = 'Sessie verwijderd';
$string['eventsessionipshared'] = 'IP conflict bij zelf markeren Aanwezigheid';
$string['eventsessionsimported'] = 'Sessies geïmporteerd';
$string['eventsessionupdated'] = 'Sessie gewijzigd';
$string['eventstatusadded'] = 'Status toegevoegd';
$string['eventstatusupdated'] = 'Status gewijzigd';
$string['eventstudentattendancesessionsupdated'] = 'Sessierapportage bijgewerkt';
$string['eventstudentattendancesessionsviewed'] = 'Sessierapportage bekeken';
$string['eventtaken'] = 'Aanwezigheid opgenomen';
$string['eventtakenbystudent'] = 'Aanwezigheid opgenomen door student';
$string['export'] = 'Exporteer';
$string['extrarestrictions'] = 'Aanvullende beperkingen';
$string['formattexttype'] = 'Opmaak';
$string['from'] = 'van:';
$string['gradebookexplanation'] = 'Cijfer in cijferlijst';
$string['gradebookexplanation_help'] = 'De module Aanwezigheid laat je huidige aanwezigheidscijfer zien gebaseerd op het aantal punten dat je hebt gekregen en het totaal aantal punten dat je tot vandaag had kunnen krijgen; het cijfer bevat geen toekomstige sessies. In de cijferlijst, je aanwezigheidscijfer is gebaseerd op je huidige aanwezigheidspercentage en aantal punten dat kan worden verdiend over de gehele lengte van de cursus, inclusief toekomstige sessies. Dit houdt in dat je aanwezigheidscijfers in de Aanwezigheidsmodule en in de cijfer van elkaar kunnen afwijken maar het percentage is gelijk.

Bijvoorbeeld, als je 8 van 10 punten tot vandaag hebt gehaald (80% aanwezig) en de aanwezigheid voor de complete cursus is 50 punten waard, de Aanwezigheidsmodule zal 8/10 laten zien en de cijferlijst zal 40/50 laten zien. Je hebt nog geen 50 punten behaald maar 40 is het equivalent aantal punten van jouw aanwezigheid tot nu toe: 80%. De punten die je hebt gekregen in de aanwezigheidsmodule kan nooit verminderen omdat het alleen gebaseerd is op de aanwezigheid tot nu toe. Het aantal aanwezigheidspunten in de cijferlijst kan verhoogd of verlaagd worden afhankelijk van je toekomstige aanwezigheid in de gehele cursus.';
$string['graded'] = 'Beoordeelde sessies';
$string['gridcolumns'] = 'Tabel kolommen';
$string['group'] = 'Groep';
$string['groups'] = 'Groepen';
$string['groupsession'] = 'Groep leerlingen';
$string['groupsessionsby'] = 'Sessies groeperen op';
$string['hiddensessions'] = 'Verborgen sessie';
$string['hiddensessions_help'] = 'Sessie vóór de cursus startdatum zijn verborgen. Je kunt deze functie gebruiken om oudere sessie te verbergen in plaats van deze te verwijderen. Alleen zichtbare sessies zullen verschijnen in de cijferlijst.';
$string['hiddensessionsdeleted'] = 'Alle verborgen sessies zijn verwijderd';
$string['hideextrauserdetails'] = 'Aanvullende gebruikersgegevens verbergen';
$string['hidensessiondetails'] = 'Informatie over sessie verbergen';
$string['identifyby'] = 'Identificeer student met';
$string['import'] = 'Importeren';
$string['importfile'] = 'Bestand importeren';
$string['importfile_help'] = 'Bestand importeren';
$string['importsessions'] = 'Sessies importeren';
$string['importstatus'] = 'Statusveld';
$string['includeall'] = 'Selecteer alle sessies';
$string['includedescription'] = 'Beschrijving sessie opnemen';
$string['includenottaken'] = 'Inclusief niet genoteerde sessies';
$string['includeqrcode'] = 'QR code opnemen';
$string['includeremarks'] = 'Inclusief opmerkingen';
$string['incorrectpassword'] = 'Je hebt een onjuist wachtwoord ingevoerd en je aanwezigheid is niet opgenomen. Voer het juiste wachtwoord in.';
$string['incorrectpasswordshort'] = 'Wachtwoord onjuist, aanwezigheid is niet opgenomen.';
$string['indetail'] = 'Details';
$string['indicator:cognitivedepth'] = 'Aanwezigheid cognitief';
$string['indicator:cognitivedepth_help'] = 'Deze indicator is gebaseerd op de cognitieve diepte door de student bereikt in een activiteit Aanwezigheid.';
$string['indicator:cognitivedepthdef'] = 'Aanwezigheid cognitief';
$string['indicator:cognitivedepthdef_help'] = 'De deelnemer heeft dit percentage van cognitieve betrokkenheid bereikt, geboden door de Aanwezigheid tijdens deze analyse-interval (Niveaus = Niet bekeken, Bekeken)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Aanwezigheid sociaal';
$string['indicator:socialbreadth_help'] = 'Deze indicator is gebaseerd op de sociale breedte bereikt door de student in een activiteit Aanwezigheid.';
$string['indicator:socialbreadthdef'] = 'Aanwezigheid sociaal';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Je moet een actie selecteren';
$string['invalidemails'] = 'Je moet adressen opgeven van bestaande gebruikersaccounts, niet gevonden: {$a}';
$string['invalidimportfile'] = 'Ongeldig bestandsformaat.';
$string['invalidsessionenddate'] = 'Deze datum kan niet eerder zijn dan de datum van de sessie';
$string['invalidsessionendtime'] = 'De eindtijd moet later zijn dan de starttijd';
$string['invalidstatus'] = 'Je hebt een ongeldige status geselecteerd, probeer het opnieuw';
$string['iptimemissing'] = 'Ongeldig aantal minuten tot vrijgeven';
$string['jumpto'] = 'Spring naar';
$string['keepsearching'] = 'Blijf zoeken';
$string['maxpossible'] = 'Maximum mogelijk';
$string['maxpossiblepercentage'] = 'Maximaal haalbare percentage';
$string['maxpossiblepoints'] = 'Maximaal haalbare punten';
$string['maxwarn'] = 'Maximum aantal e-mailwaarschuwingen';
$string['maxwarn_help'] = 'Het maximum aantal keren dat er een waarschuwing verstuurd moet worden (er wordt slechts een waarschuwing per sessie verstuurd)';
$string['mergeuser'] = 'Gebruikers samenvoegen';
$string['mobilesessionfrom'] = 'Oudere sessies dan de laatste tonen';
$string['mobilesessionto'] = 'Toekomstige sessies tonen';
$string['mobilesettings'] = 'Instellingen mobiele app';
$string['modulename'] = 'Aanwezigheid';
$string['modulename_help'] = 'De aanwezigheids activiteits module maakt het mogelijk voor een leraar om aanwezigheid op te nemen tijdens een les en studenten om hun aanwezigheid te controleren. De leraar kan meerdere sessies creëren en kan de aanwezigheid markeren als "Present", "Afwezig", "Te Laat" of "Geëxcuseerd" en deze statussen wijzigen. Rapportage zijn aanwezig voor de gehele klas en/of individuele studenten.';
$string['modulenameplural'] = 'Aanwezigheid';
$string['months'] = 'Maanden';
$string['moreattendance'] = 'De aanwezigheid is succesvol opgenomen.';
$string['moveleft'] = 'Naar links';
$string['moveright'] = 'Naar rechts';
$string['multisessionexpanded'] = 'Uitklappen "voeg meerdere sessie toe"';
$string['multisessionexpanded_desc'] = 'Toont de "Voeg meerdere sessies toe" instellingen als uitgeklapt wanneer nieuwe sessies toegevoegd worden.';
$string['mustselectusers'] = 'Je moet gebruikers selecteren voor de export.';
$string['newdate'] = 'Nieuwe datum';
$string['newduration'] = 'Nieuwe lengte';
$string['newstatusset'] = 'Nieuwe statusset';
$string['noabsentstatusset'] = 'De gebruikte statusset heeft geen te gebruiken status wanneer niet gemarkeerd.';
$string['noattendanceusers'] = 'Het is niet mogelijk om data te exporteren omdat er géén studenten aangemeld zijn in deze cursus.';
$string['noattforuser'] = 'Voor deze gebruiker bestaan geen gegevens.';
$string['noautomark'] = 'Uitzetten';
$string['nodescription'] = 'Normale sessie';
$string['noeventstoreset'] = 'Er zijn geen kalender activiteiten die een update nodig hebben.';
$string['nogroups'] = 'Deze activiteit is ingesteld voor gebruik met groepen, maar er zijn geen groepen in deze cursus.';
$string['noguest'] = 'Gasten kunnen aanwezigheid niet zien.';
$string['noofdaysabsent'] = 'Geen dagen "Afwezigheid"';
$string['noofdaysexcused'] = 'Geen dagen "Excuus"';
$string['noofdayslate'] = 'Geen dagen "Te Laat"';
$string['noofdayspresent'] = 'Geen dagen "Present"';
$string['nosessiondayselected'] = 'Geen Sessie dagen geselecteerd';
$string['nosessionexists'] = 'In deze cursus bestaan geen sessies';
$string['nosessionsselected'] = 'Geen sessies geselecteerd';
$string['notfound'] = 'Aanwezigheid activiteit is niet gevonden in deze cursus.';
$string['notifytask'] = 'Stuur waarschuwing naar gebruikers';
$string['notmember'] = 'geen&nbsp;lid';
$string['notset'] = 'niet ingesteld';
$string['noupgradefromthisversion'] = 'De Aanwezigheidsmodule kan niet upgraden van de versie van de attforblock die u hebt geïnstalleeerd. Verwijder de attforblock of upgrade naar de laatste versie voordat de nieuwe aanwezigheidsmodule installeert.';
$string['numsessions'] = 'Het aantal sessies';
$string['olddate'] = 'Oude datum';
$string['onactivitycompletion'] = 'Bij voltooiing activiteit';
$string['onlyselectedusers'] = 'Exporteer geselecteerde gebruikers';
$string['overallsessions'] = 'Over alle sessies';
$string['oversessionstaken'] = 'Over gevolgde sessies';
$string['pageof'] = 'Pagina {$a->page} van {$a->numpages}';
$string['participant'] = 'Deelnemer';
$string['password'] = 'Wachtwoord';
$string['passwordgrp'] = 'Wachtwoord voor leerlingen';
$string['passwordrequired'] = 'Voer het sessiewachtwoord in voordat je je aanwezigheid kunt insturen';
$string['percentage'] = 'Percentage';
$string['percentageallsessions'] = 'Percentage over alle sessies';
$string['percentagesessionscompleted'] = 'Percentage over gevolgde sessies';
$string['pluginadministration'] = 'Aanwezigheidsmodule instellingen';
$string['pluginname'] = 'Aanwezigheid';
$string['points'] = 'Punten';
$string['pointsallsessions'] = 'Punten over alle sessies';
$string['pointssessionscompleted'] = 'Punten over alle gevolgde sessies';
$string['preferences_desc'] = 'Wijzigingen in statussets hebben invloed op alle bestaande sessies in aanwezigheid en kunnen beoordelingen raken.';
$string['preventsharedip'] = 'Voorkomen dat leerlingen hun IP adres delen';
$string['preview'] = 'Voorbeeldweergave bestand';
$string['previewhtml'] = 'Voorbeeldweergave HTML format';
$string['privacy:metadata:duration'] = 'Sessieduur in seconden';
$string['privacy:metadata:groupid'] = 'Groep ID geassocieerd met de sessie.';
$string['privacy:metadata:ipaddress'] = 'IP-adres waarvandaan aanwezigheid is geregistreerd.';
$string['privacy:metadata:lasttaken'] = 'Tijdstip wanneer aanwezigheid het laatst werd opgenomen.';
$string['privacy:metadata:lasttakenby'] = 'Gebruiker ID van de laatste gebruiker die voor deze sessie aanwezigheid opnam.';
$string['privacy:metadata:notifyid'] = 'ID van de aanwezigheidssessie waarmee de waarschuwing is geassocieerd.';
$string['privacy:metadata:remarks'] = 'Opmerkingen over de aanwezigheid van gebruiker.';
$string['privacy:metadata:sessdate'] = 'Tijdstip van start sessie.';
$string['privacy:metadata:sessionid'] = 'ID aanwezigheidssessie.';
$string['processingfile'] = 'Bestand aan het verwerken';
$string['randompassword'] = 'Willekeurig wachtwoord';
$string['remark'] = 'Opmerking voor : {$a}';
$string['remarks'] = 'Opmerkingen';
$string['repeatasfollows'] = 'Herhaal de bovenstaande sessie op de volgend manier';
$string['repeatevery'] = 'Herhaal elke';
$string['repeaton'] = 'Herhaal op';
$string['repeatuntil'] = 'Herhaal tot';
$string['report'] = 'Rapportage';
$string['required'] = 'Vereist*';
$string['requiredentries'] = 'Tijdelijke registraties overschrijven reeds bestaande aanwijzigheidsregistraties van deelnemers.';
$string['requiredentry'] = 'Samenvoegen tijdelijke gebruiker';
$string['requiredentry_help'] = '<p align="center"><b>Attendance</b></p> <p align="left"><strong>Gebruikers samenvoegen</strong></p> <p align="left"> <table border="2" cellpadding="4"> <tr> <th>Moodle gebruiker</th> <th>Tijdelijke gebruiker</th> <th>Actie</th> </tr> <tr> <td>Aanwezigheids data</td> <td>Aanwezigheids data</td> <td>Tijdelijke gebruiker zal gegevens van bestaande gebruiker overschrijven.</td> </tr> <tr> <td>Geen aanwezigheids data</td> <td>Aanwezigheids data</td> <td>Aanwezigheidsdata tijdelijke gebruiker zal worden verplaatst naar bestaande gebruiker.</td> </tr> <tr> <td>Aanwezigheids data</td> <td>Geen aanwezigheids data</td> <td>Tijdelijke gebruiker wordt verwijderd.</td> </tr> <tr> <td>Geen aanwezigheids data</td> <td>Geen aanwezigheids data</td> <td>Tijdelijke gebruiker wordt verwijderd.</td> </tr> </table> </p> <p align="left"><strong> De tijdelijke gebruiker zal in alle gevallen verwijderd worden na de samenvoeg actie.</strong></p>';
$string['requiresubnet'] = 'Vereis netwerkadres';
$string['resetcalendar'] = 'Stel kalender opnieuw in';
$string['resetdescription'] = 'Onthoud dat het verwijderen van aanwezigheidsgegevens alle gegevens in de database zal verwijderen. Het is mogelijk om oudere sessies te verbergen.';
$string['resetstatuses'] = 'Reset statussen naar standaard';
$string['restoredefaults'] = 'Herstel standaarden';
$string['resultsperpage'] = 'Resultaten per pagina';
$string['resultsperpage_desc'] = 'Aantal studenten per pagina';
$string['rotateqrcode'] = 'QR code rouleren';
$string['save'] = 'Sla aanwezigheid op';
$string['selectactivity'] = 'Selecteer activiteit';
$string['session'] = 'Sessie';
$string['session_help'] = 'Sessie';
$string['sessionadded'] = 'Sessie succesvol opgeslagen';
$string['sessionalreadyexists'] = 'De sessie bestaat al voor deze datum';
$string['sessiondate'] = 'Datum';
$string['sessiondays'] = 'Sessie dagen';
$string['sessiondeleted'] = 'Sessie succesvol opgeslagen';
$string['sessionexist'] = 'Sessie niet toegevoegd (bestaat al)!';
$string['sessiongenerated'] = 'Er is met succes een sessie aangemaakt';
$string['sessions'] = 'Sessies';
$string['sessionsallcourses'] = 'Alle cursussen';
$string['sessionsbyactivity'] = 'Instantie van Aanwezigheid';
$string['sessionsbycourse'] = 'Cursus';
$string['sessionsbydate'] = 'Week';
$string['sessionscompleted'] = 'Gevolgde sessies';
$string['sessionscurrentcourses'] = 'Huidige cursussen';
$string['sessionsgenerated'] = '{$a} sessies met succes aangemaakt';
$string['sessionsids'] = 'ID\'s van de sessies';
$string['sessionsnotfound'] = 'Er zijn geen sessie in het gekozen tijdvak';
$string['sessionstartdate'] = 'Sessie startdatum';
$string['sessionstotal'] = 'Totaal aantal sessies';
$string['sessiontype'] = 'Sessie type';
$string['sessiontype_help'] = 'Er zijn twee type sessies : algemeen en groepen. de mogelijkheid om meerdere type sessies toe te voegen is afhankelijk van de groepsmodus van de activiteit.
<ul>
<li>In groepsmodus "Geen groepen" kunt u alleen "algemene" sessies toevoegen.</li>
<li>In groepsmodus "Zichtbare groepen" kunt u zowel algemene als groep sessies toevoegen.</li>
<li>In groepsmodus "Gescheiden groepen" kunt alleen "groepen" sessies toevoegen.</li>
</ul>';
$string['sessiontypeshort'] = 'Type';
$string['sessionupdated'] = 'Sesse succesvol gewijzigd';
$string['set_by_student'] = 'Zelf opgenomen';
$string['setallstatuses'] = 'Status instellen voor alle gebruikers';
$string['setallstatusesto'] = 'Stel status in op  «{$a}»';
$string['settings'] = 'Instellingen';
$string['setunmarked'] = 'Automatisch ingesteld wanneer niet geregistreerd';
$string['showdefaults'] = 'Laat standaard zien';
$string['showduration'] = 'Laat lengte zien';
$string['showextrauserdetails'] = 'Toon aanvullende gebruikersgegevens';
$string['sortedgrid'] = 'Gesorteerde tabel';
$string['sortedlist'] = 'Gesorteerde lijst';
$string['startofperiod'] = 'Start van periode';
$string['starttime'] = 'Starttijd';
$string['status'] = 'Status';
$string['statusdeleted'] = 'Status verwijderd';
$string['statuses'] = 'Statussen';
$string['statusset'] = 'Statusset {$a}';
$string['statussetsettings'] = 'Statusset';
$string['strftimedm'] = '%d-%m';
$string['strftimedmy'] = '%d-%m-%Y';
$string['strftimedmyhm'] = '%d-%m-%Y %H:%M';
$string['strftimedmyw'] = '%d-%m-%y (%a)';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%H:%M';
$string['strftimeshortdate'] = '%d-%m-%Y';
$string['studentavailability'] = 'Beschikbaar voor studenten (minuten)';
$string['studentid'] = 'Student ID';
$string['studentscanmark'] = 'Sta studenten toe om zelf de aanwezigheid te registeren';
$string['studentscanmark_help'] = 'Leerlingen kunnen hun eigen aanwezigheidsstatus wijzigen als aangevinkt';
$string['submitattendance'] = 'Stuur aanwezigheid in';
$string['summary'] = 'Samenvatting';
$string['tablerenamefailed'] = 'Hernoemen van oude "attforblock"-tabel naar "attendance" mislukt';
$string['tactions'] = 'Actie';
$string['takeattendance'] = 'Neem aanwezigheid op';
$string['takensessions'] = 'Gevolgde sessies';
$string['tcreated'] = 'Aangemaakt';
$string['tempaddform'] = 'Tijdelijke gebruiker toevoegen';
$string['tempexists'] = 'Er bestaat al een tijdelijke gebruiker met dit e-mailadres.';
$string['temptable'] = 'Lijst van tijdelijke gebruikers';
$string['tempuser'] = 'Tijdelijke gebruiker';
$string['tempusermerge'] = 'Tijdelijke gebruikers samenvoegen';
$string['tempusers'] = 'Tijdelijke gebruikers';
$string['tempusersedit'] = 'Wijzig tijdelijke gebruiker';
$string['tempuserslist'] = 'Tijdelijke gebruikers';
$string['thirdpartyemails'] = 'Andere gebruikers informeren';
$string['thirdpartyemailsubject'] = 'Aanwezigheidswaarschuwing';
$string['thiscourse'] = 'Deze cursus';
$string['time'] = 'Tijd';
$string['to'] = 'tot:';
$string['tuseremail'] = 'E-mail';
$string['tusername'] = 'Volledige naam';
$string['unknowngroup'] = 'Onbekende groep';
$string['update'] = 'Wijzigen';
$string['usedefaultsubnet'] = 'Gebruik standaard';
$string['userexists'] = 'Er is al een normale gebruiker met dit e-mailadres.';
$string['users'] = 'Kies te exporteren gebruikers';
$string['usestatusset'] = 'Gebruik statusset.';
$string['variable'] = 'variabele';
$string['variablesupdated'] = 'Variabelen succesvol gewijzigd';
$string['versionforprinting'] = 'print versie';
$string['viewmode'] = 'Zichtbaarheidsmodus';
$string['warningdeleted'] = 'Waarschuwing verwijderd';
$string['warnings'] = 'Waarschuwingset';
$string['warningthreshold'] = 'Waarschuwingsdrempel';
$string['warningupdated'] = 'Bijgewerkte waarschuwingen';
$string['week'] = 'week/weken';
$string['weeks'] = 'Weken';
$string['youcantdo'] = 'U kunt niets doen';
