<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'es', version '3.11'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Acción';
$string['activityoverview'] = 'Tiene cuestionarios disponibles';
$string['additionalinfo'] = 'Información adicional';
$string['additionalinfo_help'] = 'Texto a mostrar en la parte superior de la primera página de esta encuesta. (por ejemplo, instrucciones, información general, etc)';
$string['addnewquestion'] = 'Añadir una pregunta del tipo {$a}';
$string['addnewsection'] = 'Añadir nueva sección';
$string['addquestion'] = 'Añadir pregunta ...';
$string['addquestions'] = 'Añadir preguntas';
$string['addquestiontosection'] = 'Añadir pregunta a sección';
$string['addselqtype'] = 'Añadir una pregunta de este tipo';
$string['alignment'] = 'Alineación de los botones de radio';
$string['alignment_help'] = 'Selección de botones de alineación: vertical (por defecto) u horizontal.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Todo';
$string['allnameddegrees'] = 'Grados nombrados';
$string['allnameddegrees_help'] = 'Especificar texto a mostrar para valorar valores en lugar del número. Deje un valor vacío para no usarlo.';
$string['alreadyfilled'] = 'Usted ya ha cumplimentado la encuesta {$a}. Gracias';
$string['andaveragevalues'] = 'y valores medios';
$string['anonymous'] = 'Anónimo';
$string['answer'] = 'Respuesta';
$string['answergiven'] = 'Esta respuesta dada';
$string['answernotgiven'] = 'Esta respuesta no dada';
$string['answerquestions'] = 'Responda a las preguntas...';
$string['answers'] = 'Respuestas';
$string['attempted'] = 'Este cuestionario ha sido enviado';
$string['attemptstillinprogress'] = 'En curso. Guardado en:';
$string['autonumbering'] = 'Numeración automática';
$string['autonumbering_help'] = 'Numeración automática de las preguntas y las páginas. Es posible que desee desactivar la numeración automática de los cuestionarios con la bifurcación condicional.';
$string['autonumberno'] = 'No numerar las preguntas o páginas';
$string['autonumberpages'] = 'Numeración automática de páginas';
$string['autonumberpagesandquestions'] = 'Numeración automática de páginas y preguntas';
$string['autonumberquestions'] = 'Numeración automática de preguntas';
$string['average'] = 'Media';
$string['averageposition'] = 'Posición promedio';
$string['averagerank'] = 'Ranking de la media';
$string['averagesrow'] = 'Promedios (donde aplique)';
$string['bodytext'] = 'Cuerpo del texto';
$string['boxesnbexact'] = 'exactamente {$a} casilla(s).';
$string['boxesnbmax'] = 'un máximo de {$a} casilla(s).';
$string['boxesnbmin'] = 'un mínimo de {$a} casilla(s).';
$string['boxesnbreq'] = 'Para esta pregunta debe marcar la casilla';
$string['by'] = 'por';
$string['cannotviewpublicresponses'] = 'No se pueden ver las respuestas a este cuestionario público.';
$string['chart:bipolar'] = 'Barras bipolares';
$string['chart:hbar'] = 'Barras horizontales';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rosa';
$string['chart:type'] = 'Tipo de gráfica';
$string['chart:type_help'] = 'Seleccione el tipo de gráfico que desea utilizar para esta retroalimentación';
$string['chart:vprogress'] = 'Barra Vertical de progreso';
$string['checkallradiobuttons'] = '¡Por favor, compruebe todos los <strong>{$a}</strong> botones de radio!';
$string['checkboxes'] = 'Comprobar Casillas';
$string['checkboxes_help'] = 'Agregue una opción por línea para que el usuario seleccione una o múltiples respuestas';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Nuevo salto de página(s) que se inserta en la posición(es):';
$string['checkbreaksok'] = 'Todos los saltos de página requeridos están presentes!';
$string['checkbreaksremoved'] = 'Eliminar {$a} salto(s) de página extra.';
$string['checknotstarted'] = 'Seleccione sin iniciar';
$string['checkstarted'] = 'Seleccione iniciado';
$string['clicktoswitch'] = '(Haga click para activar)';
$string['closebeforeopen'] = 'Usted ha especificado una fecha de cierre anterior a la fecha de apertura.';
$string['closed'] = 'La encuesta se cerró el {$a}. Gracias.';
$string['closedate'] = 'Permitir respuestas hasta';
$string['closeson'] = 'El Cuestionario se cierra el {$a}';
$string['completionsubmit'] = 'El participante tiene que enviar la encuesta para completarla';
$string['condition'] = 'Condición';
$string['confalts'] = '- O - <br />Página de confirmación';
$string['configemailreporting'] = 'Permitir reportes por Email';
$string['configemailreportinglong'] = 'Habilitar opciones para que algunos reportes se envíen por Email directamente a las direcciones de Email especificadas.';
$string['configmaxsections'] = 'Máximo número de secciones de retroalimentación';
$string['configusergraph'] = 'Muestre las gráficas para la retroalimentación de la "Encuesta de Personalidad"';
$string['configusergraphlong'] = 'Use la librería <a href="http://www.rgraph.net/">Rgraph</a> para mostrar las gráficas de retroalimentación de la "Encuesta de Personalidad"';
$string['confirmdelallresp'] = '¿Está seguro que quiere eliminar TODAS las respuestas de la encuesta?';
$string['confirmdelchildren'] = 'Si borra esta pregunta, la/s subpregunta/s relacionada/s también serán borradas:';
$string['confirmdeletesection'] = '¿Está seguro de querer eliminar la sección de retroalimentación "{$a}"?';
$string['confirmdelgroupresp'] = '¿Está seguro que quiere eliminar TODAS las respuestas de{$a}?';
$string['confirmdelquestion'] = 'Está seguro que quiere borrar la pregunta de la posición {$a}?';
$string['confirmdelquestionresps'] = 'Esto también borrará la/s {$a} respuesta/s ya dadas a la pregunta.';
$string['confirmdelresp'] = '¿Está seguro que desea eliminar la respuesta de {$a}?';
$string['confirmremovequestion'] = '¿Está seguro de querer eliminar la pregunta"{$a->qname}" de la sección "{$a->sname}"?';
$string['confpage'] = 'Texto de título';
$string['confpage_help'] = 'Título (en negrita) y cuerpo del texto para la página de "confirmación" mostrada después de que el usuario haya finalizado la encuesta. (La URL, si existe, tiene prioridad sobre el texto de confirmación.). Si deja este campo vacío, se mostrará un mensaje sobre la finalización de la encuesta (Gracias por realizar esta encuesta)';
$string['confpagedesc'] = 'Título (en negrita) y cuerpo del texto para la página de "confirmación" mostrada después de que el usuario haya finalizado la encuesta. (La URL, si existe, tiene prioridad sobre el texto de confirmación.)';
$string['contentoptions'] = 'Tipo de Cuestionario';
$string['couldnotcreatenewsurvey'] = 'No se pudo crear una nueva encuesta!';
$string['couldnotdelresp'] = 'No ha sido posible borrar las respuestas';
$string['createcontent'] = 'Definir nuevo contenido';
$string['createcontent_help'] = 'Seleccione una de las opciones del botón de radio. \'Crear nuevo\' es el valor predeterminado.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Crear un nuevo cuestionario';
$string['crontask'] = 'Limpieza de cuestionario';
$string['date'] = 'Fecha';
$string['date_help'] = 'Utilice este tipo de pregunta si espera que la respuesta sea una fecha con el formato correcto.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Usar el formato año-mes-día. Por ejemplo, para el 4 de marzo de 1945: &nbsp; <strong>1945-03-04</strong>';
$string['deleteallresponses'] = 'Borrar TODAS las respuestas';
$string['deletecurrentquestion'] = 'Borrar la pregunta {$a}';
$string['deletedallgroupresp'] = 'Todas las respuestas del grupo {$a} han sido borradas';
$string['deletedallresp'] = 'Respuestas eliminadas';
$string['deletedisabled'] = 'Esta pregunta no se puede eliminar';
$string['deletedresp'] = 'Respuestas borradas';
$string['deleteresp'] = 'Borrar esta respuesta';
$string['deletesection'] = 'Eliminar esta sección';
$string['deletingresp'] = 'Supresión de respuestas';
$string['dependencies'] = 'Dependencias';
$string['dependquestion'] = 'Pregunta Padre';
$string['dependquestion_help'] = 'Usted puede seleccionar una pregunta padre y una opción elegible para esta pregunta. Una pregunta hija solamente se le mostrará al estudiante si su pregunta padre y opción padre han sido previamente seleccionadas.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'No respondió a la pregunta';
$string['directwarnings'] = 'Las dependencias directas a esta pregunta serán removidas. Esto afectará:';
$string['displaymethod'] = 'El método de visualización no se ha definido para este tipo de pregunta.';
$string['download'] = 'Descargar';
$string['downloadpdf'] = 'Descargar PDF';
$string['downloadtextformat'] = 'Descargar';
$string['downloadtextformat_help'] = 'Esta opción permite guardar todas las respuestas de una encuesta en un archivo con formato a elegir entre los formatos soportados).
Usted puede elegir incluir elementos extra en la exportación, así como enviar automáticamente el archivo a los usuarios seleccionados.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Tipo de reporte';
$string['dropdown'] = 'Lista desplegable';
$string['dropdown_help'] = 'No hay ninguna ventaja real de utilizar el cuadro desplegable sobre el uso de los botones de radio, excepto tal vez para las listas bastante largas de opciones, para ahorrar espacio en la pantalla.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Editar';
$string['editingfeedback'] = 'Editando configuraciones de retroalimentación';
$string['editingquestionnaire'] = 'Modificación de cuestionario - página General';
$string['editquestion'] = 'Edición de la pregunta {$a}';
$string['email'] = 'Correo';
$string['emailextra'] = 'Enviar descarga a Emails';
$string['emailextra_help'] = 'Enviará el archivo descargado a las direcciones de Email enlistadas, separadas por comas. Tenga en cuenta que NO se hacen revisiones de seguridad ni privacidad.
 \'allowemailreporting\' debe estar habilitado en las configuraciones del módulo para acceder a esto.';
$string['emailroles'] = 'Enviar descarga a roles';
$string['emailroles_help'] = 'Enviará vía Email el archivo descargado a todos los roles con la capacidad "mod/questionnaire:submissionnotification" .
 \'allowemailreporting\' debe estar habilitado en las configuraciones del módulo para acceder a esto.';
$string['emailsend'] = 'Enviar reportes';
$string['emailsnotspecified'] = 'No se especificó Email(s)';
$string['emailssent'] = 'Descargas enviadas a Email(s) específicado(s)';
$string['errnewname'] = 'Lo sentimos, ese nombre ya está en uso. Seleccione un nuevo nombre.';
$string['erroropening'] = 'Error al abrir el cuestionario.';
$string['errortable'] = 'Error de sistema (tabla corrupta).';
$string['essaybox'] = 'Texto amplio';
$string['essaybox_help'] = 'Esta pregunta se mostrará en un cuadro de texto sin formato con x columnas (ancho) e y filas (líneas de texto).

Si deja ambos valores x e y con valor 0 (su valor por defecto), el editor de texto HTML de Moodle se mostrará con los valores estándar de altura y longitud (si está disponible en contexto de usuario/curso y/o en el perfil del usuario)';
$string['event_all_responses_deleted'] = 'Todas las respuestas fueron borradas';
$string['event_all_responses_saved_as_text'] = 'Todas las Respuestas guardadas como texto';
$string['event_all_responses_viewed'] = 'Reporte de Todas las Respuestas visto';
$string['event_individual_responses_viewed'] = 'Reporte de Respuestas Individuales visto';
$string['event_non_respondents_viewed'] = 'No-respondentes vistos';
$string['event_previewed'] = 'Questionnaire pre-visualizado';
$string['event_question_created'] = 'Pregunta creada';
$string['event_question_deleted'] = 'Pregunta borrada';
$string['event_response_deleted'] = 'Respuesta individual borrada';
$string['event_resumed'] = 'Intento recuperado';
$string['event_saved'] = 'Respuestas guardadas';
$string['event_submitted'] = 'Respuestas enviadas';
$string['feedback'] = 'Retroalimentación';
$string['feedback_help'] = 'Ayuda de retroalimentación';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Agregar {no} campos más de retroalimentación';
$string['feedbackbysection'] = 'Sección de retroalimentación';
$string['feedbackdefaultlabel'] = '[Nueva sección]';
$string['feedbackeditingglobal'] = 'Editar Retroalimentación Global de la encuesta';
$string['feedbackeditingmessages'] = 'Editando Mensajes de Retroalimentación del Questionnaire';
$string['feedbackeditingsections'] = 'Editando Secciones de Retroalimentación del Questionnaire';
$string['feedbackeditmessages'] = 'Guardar configuraciones de Secciones y editar Mensajes de Retroalimentación';
$string['feedbackeditsections'] = 'Guardar configuraciones de Secciones y editar Secciones de Retroalimentación';
$string['feedbackerrorboundaryformat'] = 'Los límites del puntaje de retroalimentación deben ser, o un porcentaje, o un número. El valor que Usted escribió en el límite {$a} no es reconocido.';
$string['feedbackerrorboundaryoutofrange'] = 'Los límites del puntaje de retroalimentación deben ser entre 0% y 100%. El valor que Usted escribió en el límite {$a} está fuera del rango.';
$string['feedbackerrorjunkinboundary'] = 'Usted debe llenar las cajas de límite del puntaje de reatroalimentación sin dejar ningún hueco.';
$string['feedbackerrorjunkinfeedback'] = 'Usted debe llenar las cajas de retroalimentación sin dejar ningún hueco.';
$string['feedbackerrororder'] = 'Los límites de los puntajes de retroalimentación deben de estar en orden, con el más alto primero. El valor que escribió Usted en el límite {$a} está fuera de secuencia.';
$string['feedbackglobal'] = 'Retroalimentación Global';
$string['feedbackglobalheading'] = 'Encabezado de Retroalimentación Global';
$string['feedbackglobalmessages'] = 'Mensajes de Retroalimentación Global';
$string['feedbackhdr'] = 'Retroalimentaciones';
$string['feedbackheading'] = 'Encabezado de retroalimentación';
$string['feedbackheading_help'] = 'En el campo de encabezado de la retroalimentación Usted puede usar 2 variables: $scorepercent y $oppositescorepercent.';
$string['feedbackmessages'] = 'Mensajes de sección {$a}';
$string['feedbacknextsection'] = 'Próxima sección {$a}';
$string['feedbacknone'] = 'Sin mensajes de retroalimentación';
$string['feedbacknotes'] = 'Notas de retroalimentación';
$string['feedbacknotes_help'] = 'El texto escrito aquí se mostrará a los encuestados al final de su Reporte de Retroalimentación';
$string['feedbackoptions'] = 'Opciones de retroalimentación';
$string['feedbackoptions_help'] = 'Las opciones de retroalimentación están disponibles si su cuestionario contiene los siguientes tipos de preguntas y configuraciones de preguntas:
Botones de selección; Caja desplegable, Si/No, o Valorar (normal o escala Osgood). Esas preguntas deberán configurarse como obligatorias; su campo para Nombre de Pregunta NO deberá estar vacío y las opciones para respuestas posibles deben contener un valor.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Esta pregunta es parte de la sección de retroalimentación [{$a}]';
$string['feedbackremovesection'] = 'El remover esta pregunta removerá completamente la sección de retroalimentación [{$a}]';
$string['feedbackreport'] = 'Reporte de Retroalimentación';
$string['feedbackscore'] = 'Puntaje de retroalimentación';
$string['feedbackscoreboundary'] = 'Límite de Puntaje de Retroalimentación';
$string['feedbackscores'] = 'Mostrar Puntajes';
$string['feedbackscores_help'] = 'Mostrar la tabla de puntajes de retroalimentación';
$string['feedbacksection'] = 'Sección';
$string['feedbacksectionheading'] = 'Encabezado de sección {$a}';
$string['feedbacksectionheadingmissing'] = '¡ Usted debe escribir un Encabezado para esta sección de retroalimentación !';
$string['feedbacksectionheadingtext'] = 'Encabezado';
$string['feedbacksectionlabel'] = 'Etiqueta';
$string['feedbacksectionlabel_help'] = 'Esta etiqueta será usada en las gráficas/diagramas. ¡ Por favor hágala tan corta como sea posible !';
$string['feedbacksectionquestions'] = '{$a} preguntas de sección';
$string['feedbacksections'] = 'Secciones de Retroalimentación';
$string['feedbacksectionsselect'] = 'Secciones';
$string['feedbacksectionsselect_help'] = 'Poner sus preguntas dentro de esas Secciones';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Configuraciones de retroalimentación guardadas';
$string['feedbacktype'] = 'Tipo de retroalimentación';
$string['field'] = 'Pregunta {$a}';
$string['fieldlength'] = 'Longitud de la caja de texto';
$string['fieldlength_help'] = 'Para la pregunta de tipo **Caja de Texto**, introduzca el **Largo de Caja de Texto** y la **Longitud Máxima del Texto** para el texto que será tecleado por quien responde.

Los valores por defecto son 20 caracteres para el ancho de la caja de Texto y 25 caracteres para la longitud máxima del texto introducido.';
$string['finished'] = '¡ Ya has respondido todas las preguntas de este cuestionario!';
$string['firstrespondent'] = 'Primera persona en responder';
$string['formateditor'] = 'Editor HTML';
$string['formatplain'] = 'Texto plano';
$string['grade'] = 'Nota para este cuestionario';
$string['gradesdeleted'] = 'Notas del cuestionario eliminadas';
$string['headingtext'] = 'Texto del título';
$string['horizontal'] = 'Horizontal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Incluir los números de las respuestas seleccionadas';
$string['includechoicetext'] = 'Incluir el texto de las respuestas seleccionadas';
$string['includeincomplete'] = 'Incluir repuestas incompletas';
$string['includerankaverages'] = 'Incluir rango de medias de preguntas';
$string['incorrectcourseid'] = 'El identificador (ID) del curso es incorrecto';
$string['incorrectmodule'] = 'El identificador del módulo del curso es incorrecto';
$string['incorrectquestionnaire'] = 'La encuesta es incorrecta';
$string['indirectwarnings'] = 'La lista muestra las preguntas indirectamente dependientes y las dependencias que faltan de las preguntas directamente dependientes:';
$string['invalidresponse'] = 'Respuesta no válida.';
$string['invalidresponserecord'] = 'Registro de respuesta no válida.';
$string['invalidsectionid'] = 'Se ha especificado una sección de retroalimentación inválida.';
$string['invalidsurveyid'] = 'ID de la encuesta no válido';
$string['kindofratescale'] = 'Tipo de escala';
$string['kindofratescale_help'] = 'Clique con el botón derecho del ratón sobre el enlace "Más ayuda" que aparece a continuación.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Último en responder';
$string['length'] = 'Longitud';
$string['managequestions'] = 'Gestionar preguntas';
$string['managequestions_help'] = 'En la esta sección se puede llevar a cabo una serie de operaciones de edición, añadido y borrado de preguntas del cuestionario.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Obligatorio - Deben rellenarse todas estas dependencias.';
$string['maxdigitsallowed'] = 'Número máximo de dígitos permitidos';
$string['maxdigitsallowed_help'] = 'Use ***Número máximo de dígitos permitidos*** para limitar el número de caracteres introducios en una pregunta numérica. ¡Observe que la coma decimal también cuenta como un carácter!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Número máximo de casillas que se pueden seleccionar';
$string['maxforcedresponses_help'] = '';
$string['maxtextlength'] = 'Longitud máxima del texto';
$string['maxtextlength_help'] = 'Para el tipo de pregunta de cuadro de texto, introduzca la longitu del cuadro de entrada y la longitud máxima del texto a ser introducida por el participante.
Los valores por defecto son 20 caracteres para el ancho del cuadro de texto y 25 para la longitud máxima del texto introducido.';
$string['messageprovider:message'] = 'Recordatorio del cuestionario';
$string['messageprovider:notification'] = 'Cuestionario entregado';
$string['minforcedresponses'] = 'Número mínimo de casillas que se han de seleccionar';
$string['minforcedresponses_help'] = 'Use estos parámetros para forzar a los encuestados a marcar un mínimo de **Min.** casillas de verificación y un máximo de **Max** casillas de verificación. Para forzar un número exacto de casillas de verificación marcar ajuste **Min.** y  **Max.** con el mismo valor.
Si sólo desea un valor mínimo o máximo deje el otro valor con el valor **0** predeterminado.
Si establece **Mín.** o **Max.** en un valor diferente al predeterminado **0**, se le mostrará un mensaje de advertencia si el encuestado no cumple con los requisitos. Obviamente es necesario plantear todos los requisitos de forma clara para el encuestado, ya se en las instrucciones generales de la encuesta o en el texto de las correspondientes preguntas.';
$string['misconfigured'] = 'El curso está mal configurado';
$string['missingname'] = 'No se puede utilizar la pregunta {$a} en esta sección de retroalimentación porque no tiene nombre.';
$string['missingnameandrequired'] = 'La pregunta {$a} no se puede usar en esta sección de retroalimentación porque no tiene nombre y no es obligatoria.';
$string['missingquestion'] = 'Por favor, conteste a esta pregunta que es obligatoria';
$string['missingquestions'] = 'Por favor, conteste las preguntas obligatorias:';
$string['missingrequired'] = 'La pregunta {$a} no se pudo usar en esta retroalimentación porque no es obligatoria.';
$string['modulename'] = 'Encuesta';
$string['modulename_help'] = 'El módulo Encuesta le permite construir encuestas empleando diversos tipos de preguntas, con el propósito de recopilar información de sus usuarios.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Encuestas';
$string['movedisabled'] = 'Este elemento no puede ser movido';
$string['myresponses'] = 'Todas sus respuestas';
$string['myresponsetitle'] = 'Sus resultados para {$a} respuestas';
$string['myresults'] = 'Mis resultados';
$string['name'] = 'Nombre';
$string['navigate'] = 'Permitir ramificación de preguntas';
$string['navigate_help'] = 'Habilite preguntas Sí/No y de botones de radio para que puedan tener preguntas hijas dependiendo de las elecciones en su cuestionario.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Ir a la sección de retroalimentación.';
$string['next'] = 'Siguiente';
$string['nextpage'] = 'Página siguiente';
$string['nlines'] = '{$a} líneas';
$string['noanswer'] = 'No respuesta';
$string['noattempts'] = 'No se han realizado intentos en este cuestionario';
$string['nodata'] = 'No se ha enviado ningún dato.';
$string['noduplicates'] = 'Elección única';
$string['noduplicateschoiceserror'] = '¡Usted debe introducir al menos dos respuestas posibles para la opción "No duplicar elecciones"!';
$string['non_respondents'] = 'Usuarios que aún no han respondido el cuestionario';
$string['noneinuse'] = 'Este cuestionario no contiene ninguna pregunta';
$string['nopublicsurveys'] = 'No hay encuestas públicas';
$string['noresponsedata'] = 'No hay respuestas para esta pregunta.';
$string['noresponses'] = 'Sin respuestas';
$string['normal'] = 'Normal';
$string['not_started'] = 'No empezado';
$string['notanumber'] = '<strong>{$a}</strong> no es un formato de número válido.';
$string['notapplicable'] = 'NS/NC';
$string['notapplicablecolumn'] = 'Columna NS/NC';
$string['notavail'] = 'Este cuestionario no esta disponible ya. Consulte con su profesor(a).';
$string['noteligible'] = 'Usted no ha sido seleccionado para responder a esta encuesta';
$string['notemplatesurveys'] = 'No hay plantillas de encuesta';
$string['notenoughscaleitems'] = '¡Usted debe introducir un valor mínimo de dos ítems de escala!';
$string['notificationfull'] = 'Respuesta completa';
$string['notifications'] = 'Enviar notificaciones de entrega';
$string['notifications_help'] = 'Avisa a los roles con el permiso "mod/questionnaire:submissionnotification" cuando se realiza una entrega.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Solo notificación';
$string['notopen'] = 'Esta encuesta no se abrirá hasta {$a}.';
$string['notrequired'] = 'Respuesta no obligatoria';
$string['notset'] = 'sin ajustar';
$string['nousersselected'] = 'Ningún usuario seleccionado';
$string['num'] = 'nº';
$string['numattemptsmade'] = '{$a} intentos realizados en este cuestionario';
$string['numberfloat'] = 'El número que introdujo,<strong>{$a->number}</strong> ha sido redondeado con <strong>{$a->precision}</strong> decimal(es).';
$string['numberofdecimaldigits'] = 'Número de decimales';
$string['numberofdecimaldigits_help'] = 'Use **No. de decimales** para especificar el formato del valor medio contado y mostrado en la página del informe del cuestionario.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Número de ítem en la escala';
$string['numberscaleitems_help'] = 'El número de ítems de escala el el *número de ítems* a usar en su escala de evaluación. Usted probablemente usará algún valor entre 3 y 5. El valor por defecto es **5.**.';
$string['numeric'] = 'Numérico';
$string['numeric_help'] = 'Use este tipo de pregunta si espera que la respuesta sea un número formateado correctamente.';
$string['of'] = 'de';
$string['openafterclose'] = 'Usted ha especificado una fecha de apertura posterior a la fecha de finalización.';
$string['opendate'] = 'Permitir respuestas desde';
$string['option'] = 'opción {$a}';
$string['optional'] = 'Opcional - al menos una de estas dependiencias debe cumplimentarse.';
$string['optionalname'] = 'Nombre de la pregunta';
$string['optionalname_help'] = 'El nombre de pregunta sólo se utiliza al exportar las respuestas al formato CSV/Excel.
Si nunca va a exportar a CSV, entonces no tiene que preocuparse acerca de los nombres de las preguntas.
Si va a exportar regularmente sus datos de las encuestas a CSV, entonces usted tiene dos opciones para nombrar la pregunta.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- O -';
$string['order_ascending'] = 'Ordenación ascendente';
$string['order_default'] = 'Ordenación por defecto';
$string['order_descending'] = 'Ordenación descendente';
$string['orderresponses'] = 'Otras respuestas';
$string['orderresponses_help'] = 'Cuando se muestran todas las respuestas usted puede ordenarlas por número de respuestas (la columna de Media) para los siguientes cuatro tipos de preguntas:

* botón de respuesta única
* lista desplegable con respuesta única
* opción múltiple (casillas de verificación)
* preguntas tipo (incluyendo las escalas de Likert).

Cuando llegue a la página con todas las respuestas, por defecto todas las respuestas se ordenan en el orden en que el creador de la encuesta introdujo las opciones de selección.
Usted puede ordenar en orden ascendente o descendente.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Otro';
$string['otherempty'] = 'Si selecciona esta opción debe escribir algún contenido en la caja de texto.';
$string['overviewnumresplog'] = 'respuestas';
$string['overviewnumresplog1'] = 'respuesta';
$string['overviewnumrespvw'] = 'respuestas';
$string['overviewnumrespvw1'] = 'respuesta';
$string['owner'] = 'Propietario';
$string['page'] = 'Página';
$string['pageof'] = 'Página {$a->page} de {$a->totpages}';
$string['parent'] = 'Padre';
$string['participant'] = 'Participante';
$string['pleasecomplete'] = 'Por favor completa esta elección.';
$string['pluginadministration'] = 'Administración de encuestas';
$string['pluginname'] = 'Encuesta';
$string['position'] = 'posición';
$string['possibleanswers'] = 'Introduzca las respuestas posibles (si es necesario).';
$string['posteddata'] = '<br />Esta página ha sido lograda con los siguientes datos enviados:<br />';
$string['preview_label'] = 'Previsualización';
$string['preview_questionnaire'] = 'Previsualización del Cuestionario';
$string['previewing'] = 'Previsualizando encuesta';
$string['previous'] = 'Previa';
$string['previouspage'] = 'Página anterior';
$string['print'] = 'Imprimir';
$string['printblank'] = 'Imprimir un cuestionario en blanco';
$string['printblanktooltip'] = 'Abre una ventana de impresión con la encuesta en blanco';
$string['printtooltip'] = 'Abrir una ventana preparada para la impresión de un cuestionario en blanco';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Una respuesta a pregunta de opción múltiple.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'El ID de un registro de elección de esta respuesta.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'El ID del registro de la pregunta de esta respuesta.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'El ID del registro de la respuesta de esta respuesta.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Una respuesta a pregunta de respuesta única.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'El ID del registro de elección de esta respuesta.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'El ID del registro de la pregunta de esta respuesta.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'El ID del registro de respuesta de esta respuesta.';
$string['privacy:metadata:questionnaire_response'] = 'Una respuesta en progreso o entregada';
$string['privacy:metadata:questionnaire_response:complete'] = 'El estado de cumplimentación de la respuesta.';
$string['privacy:metadata:questionnaire_response:grade'] = 'La calificacion de esta respuesta.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'El ID del registro de cuestionario de esta respuesta.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'El momento de guardado de más reciente de esta respuesta.';
$string['privacy:metadata:questionnaire_response:userid'] = 'El ID del usuario de esta respuesta.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Una respuesta de pregunta booleana (sí/no).';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'La respuesta booleana (sí/no) específica.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'El ID del registro de la pregunta de esta respuesta.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'El ID del registro de respuesta de esta respuesta.';
$string['privacy:metadata:questionnaire_response_date'] = 'Una fecha de respuesta a la pregunta.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'El ID del registro de pregunta de esta respuesta.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'La fecha específica de la respuesta.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'El ID del registro de respuesta de esta respuesta.';
$string['privacy:metadata:questionnaire_response_other'] = 'Una selección de texto de respuesta "otro".';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'El ID del registro de selección de esta respuesta.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'El ID del registro de la pregunta de esta respuesta.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'El texto específico de respuesta.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'El ID del registro de respuesta de esta respuesta.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Una respuesta de pregunta de rango.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'El ID del registro de selección de esta respuesta.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'El ID del registro de pregunta de esta respuesta.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'El rango específico de la respuesta.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'El ID del registro de respuesta de esta respuesta.';
$string['privacy:metadata:questionnaire_response_text'] = 'Una respuesta de pregunta de texto.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'El ID del registro de pregunta de esta respuesta.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'El texto específico de respuesta.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'El ID del registro de respuesta de esta respuesta.';
$string['private'] = 'Privado';
$string['progressbar'] = 'Mostrar barra de progreso';
$string['progressbar_info'] = 'Cuestionario {$a} completo.';
$string['progresshelp'] = 'Barra de progreso';
$string['progresshelp_help'] = 'Vaya a la siguiente página para rellenar la barra de progreso';
$string['public'] = 'Público';
$string['publiccopy'] = 'Copia:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Frecuencia de participación';
$string['qtype_help'] = 'Selecciones si los usuarios podrán responder una vez, diariamente, semanalmente, mensualmente o un número ilimitado de veces.';
$string['qtypedaily'] = 'responder diariamente';
$string['qtypemonthly'] = 'responder mensualmente';
$string['qtypeonce'] = 'responder una sola vez';
$string['qtypeunlimited'] = 'responder sin límite de intentos';
$string['qtypeweekly'] = 'responder semanalmente';
$string['questionnaire:addinstance'] = 'Añadir una nueva encuesta';
$string['questionnaire:copysurveys'] = 'Copiar plantillas y encuestas privadas';
$string['questionnaire:createpublic'] = 'Crear encuestas públicas';
$string['questionnaire:createtemplates'] = 'Crear plantillas de encuestas';
$string['questionnaire:deleteresponses'] = 'Borrar todas las respuestas';
$string['questionnaire:downloadresponses'] = 'Exportar las respuestas en formato de texto CSV';
$string['questionnaire:editquestions'] = 'Crear y editar preguntas de la encuesta';
$string['questionnaire:manage'] = 'Crear y editar encuestas';
$string['questionnaire:message'] = 'Enviar mensaje a los que no han respondido';
$string['questionnaire:preview'] = 'Vista previa de los cuestionarios';
$string['questionnaire:printblank'] = 'Imprimir encuesta en blanco';
$string['questionnaire:readallresponseanytime'] = 'Ver todas las respuestas en cualquier momento';
$string['questionnaire:readallresponses'] = 'Ver los resúmenes de las respuestas en función de la fecha de apertura del cuestionario';
$string['questionnaire:readownresponses'] = 'Ver las respuestas propias';
$string['questionnaire:submissionnotification'] = 'Recibir notificación por cada encuesta evaluada';
$string['questionnaire:submit'] = 'Cumplimentar y enviar una encuesta';
$string['questionnaire:view'] = 'Ver una encuesta';
$string['questionnaire:viewsingleresponse'] = 'Ver las respuestas individuales';
$string['questionnaireadministration'] = 'Administración de encuestas';
$string['questionnairecloses'] = 'Encuestas cerradas';
$string['questionnaireopens'] = 'Encuestas abiertas';
$string['questionnairereport'] = 'Informe de la encuesta';
$string['questionnum'] = 'Pregunta #';
$string['questions'] = 'Preguntas';
$string['questionsinsection'] = 'Preguntas en esta sección:';
$string['questiontypes'] = 'Tipos de preguntas';
$string['questiontypes_help'] = 'Mira la Documentación de Moodle a continuación';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Botones de radio';
$string['radiobuttons_help'] = 'En este tipo de pregunta el usuario debe seleccionar una de entre las opciones mostradas.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Ranking';
$string['ratescale'] = 'Escala Likert (1..5)';
$string['ratescale_help'] = 'Mira la Documentación de Moodle a continuación';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Tipo de Encuesta';
$string['realm_help'] = '* ** Hay tres tipos de encuesta:**

* Privada  - pertenece solo al curso en el que se ha definido

* Plantilla * - puede ser copiada y editada.

* Pública  - se puede compartir entre cursos.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'La URL a la que el usuario será redireccionado después de completar esta encuesta.';
$string['remove'] = 'Suprimir';
$string['removeallquestionnaireattempts'] = 'Eliminar todas las respuestas del cuestionario';
$string['removenotinuse'] = 'Este cuestionario dependía de un cuestionario público que ha sido borrado. No puede usarse más y debería borrarse.';
$string['required'] = 'Esta respuesta es obligatoria';
$string['required_help'] = 'Si selecciona ***Sí***, la respuesta a esta pregunta será obligatotia, es decir, el encuestado no podrá enviar la encuesta hasta haber contestado esta pregunta.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Falta un parámetro obligatorio.';
$string['reset'] = 'Reinicializar';
$string['respeligiblerepl'] = '(reemplazado por la gestión de roles)';
$string['respondent'] = 'Encuestado';
$string['respondenteligibleall'] = 'Todo el mundo';
$string['respondenteligiblestudents'] = 'Sólamente los estudiantes';
$string['respondenteligibleteachers'] = 'Sólamente los profesores';
$string['respondents'] = 'Encuestados';
$string['respondenttype'] = 'Tipo de encuestado (Anónimo o Nominativo)';
$string['respondenttype_help'] = 'Usted puede mostrar los nombres completos de los usuarios con cada respuesta ajustando esto a "nombre completo".
Usted puede ocultar las identidades de los usuarios en cada respuesa ajustando esto a "anónimo".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anónimo';
$string['respondenttypefullname'] = 'nombre completo';
$string['response'] = 'Respuesta';
$string['responsefieldlines'] = 'Tamaño del cuadro de entrada';
$string['responseformat'] = 'Formato de respuesta';
$string['responseoptions'] = 'Opciones de respuesta';
$string['responses'] = 'Respuestas';
$string['responseview'] = 'Ver las respuestas';
$string['responseview_help'] = 'Puede especificar quién puede ver las respuestas de los encuestados en las encuestas enviados (tablas estadísticas generales).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Siempre';
$string['responseviewstudentsnever'] = 'Nunca';
$string['responseviewstudentswhenanswered'] = 'Después de responder a la encuesta';
$string['responseviewstudentswhenclosed'] = 'Después de que la encuesta se cierre';
$string['restrictedtoteacher'] = 'Estas funciones están restringidas a los profesores';
$string['resume'] = 'Guardar / Continuar';
$string['resume_help'] = 'Esta opción permite a los usuarios guardar sus respuestas a una encuesta antes de enviarla. Los usuarios pueden dejar sin terminar la encuesta y reanudarla posteriormente desde el punto de guardador.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Reanudar encuesta';
$string['return'] = 'Volver';
$string['save'] = 'Guardar';
$string['save_and_exit'] = 'Guardar y salir';
$string['saveasnew'] = 'Guardar como nueva pregunta';
$string['savedbutnotsubmitted'] = 'El cuestionario ha sido guardado pero todavía no ha sido entregado.';
$string['savedprogress'] = 'Su proceso ha sido guardado. Puede regresar en cualquier momento y completar este cuestionario.';
$string['saveeditedquestion'] = 'Guardar la pregunta {$a}';
$string['savesettings'] = 'Guardar la configuración';
$string['search:activity'] = 'Cuestionario - información de la actividad';
$string['search:question'] = 'Cuestionario - preguntas';
$string['section'] = 'Descripción';
$string['sectionbreak'] = '----- Salto de página -----';
$string['sectionbreak_help'] = '----- Salto de página -----';
$string['sectionsnotset'] = '¡Debe seleccionar al menos UNA pregunta por sección!<br />Sección(es) no seleccionada: {$a}';
$string['sectiontext'] = 'Descripción';
$string['sectiontext_help'] = 'Esto no es una pregunta sino un texto (corto) que se mostrará al introducir una serie de preguntas.';
$string['selecttheme'] = 'Seleccione un tema gráfico (css) para utilizar en esta encuesta';
$string['send'] = 'Enviar';
$string['send_message'] = 'Enviar un mensaje a los usuarios seleccionados';
$string['send_message_to'] = 'Enviar mensaje a:';
$string['sendemail'] = 'Envía una copia de cada cuestionario a esta dirección (o déjelo en blanco si no quiere recibir nada).';
$string['sendemail_help'] = 'Envía una copia de cada respuesta a la dirección o direcciones especificadas. Se puede indicar más de una dirección separándolas con comas. Dejar en blanco si no se quiere copia en el correo electrónico. "allowemailreporting" debe estar habilitado el los ajustes del módulo para acceder a esto.';
$string['set'] = 'ajustar';
$string['settings'] = 'Configuración';
$string['settingssaved'] = 'Configuración guardada';
$string['show_nonrespondents'] = 'No respondieron';
$string['started'] = 'comenzado';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Introduzca la fecha usando el siguiente selector de fechas.';
$string['subject'] = 'Asunto';
$string['submissionnotificationhtmlanon'] = 'Hay un nuevo <a href="{$a->submissionurl}">envío</a> de la encuesta "{$a->name}".';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> tiene una nueva <a href="{$a->submissionurl}">entrega</a> del "{$a->name}" cuestionarioi del curso "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Nueva encuesta enviada';
$string['submissionnotificationtextanon'] = 'Hay un nuevo envío ({$a->submissionurl}) de la encuesta "{$a->name}"';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) ha hecho una nueva entrega ({$a->submissionurl}) al "{$a->name}" cuestionario en el curso "{$a->coursename}".';
$string['submitoptions'] = 'Opciones de envío';
$string['submitpreview'] = 'Previsualización del envio';
$string['submitpreviewcorrect'] = 'El envío será aceptado cuando sea rellenado correctamente.';
$string['submitsurvey'] = 'Enviar encuesta';
$string['submitted'] = 'Enviado el:';
$string['subtitle'] = 'Subtítulo';
$string['subtitle_help'] = 'Subtítulo de esta encuesta. Se muestra solo debajo del título de la primera página.';
$string['summary'] = 'Resumen';
$string['summaryreportattached'] = 'Informe de resumen del cuestionario adjunto';
$string['surveynotexists'] = 'la encuesta no existe';
$string['surveyowner'] = 'Debe ser propietario de la encuesta para realizar esta operación';
$string['surveyresponse'] = 'Respuesta a la encuesta';
$string['template'] = 'Plantilla';
$string['templatenotviewable'] = 'No se pueden mostrar las plantillas de encuesta';
$string['text'] = 'Texto';
$string['textareacolumns'] = 'Número de columnas de texto';
$string['textareacolumns_help'] = 'Esta pregunta mostrará un cuadro de texto plano con **x** *columnas de área de texto* o (*ancho* de área) y **y** *filas de texto de área* (núero de *líneas* de texto).
Si deja tanto x como y en sus valores por defecto **0** (o si selecciona **0**), entonces se mostrará el editor HTML con altura y ancho estándar (si está disponible en el contexto del curso/usuario &amp; perfil de usuario).';
$string['textarearows'] = 'Número de filas de texto';
$string['textbox'] = 'Cuadro de texto';
$string['textbox_help'] = 'Para el tipo de pregunta de cuadro de texto, introduczca la longitud del cuadro de texto y la longitud máxima del texto a introducir por el participante.
Los valores por defecto son 20 caracteres para el ancho del cuadro de texto y 25 caracteres para la longitud máxima del texto introducido.';
$string['textdownloadoptions'] = 'Opciones de descarga de CSV';
$string['thank_head'] = 'Gracias por realizar esta encuesta';
$string['theme'] = 'Tema';
$string['thismonth'] = 'este mes';
$string['thisresponse'] = 'Esta respuesta';
$string['thisweek'] = 'esta semana';
$string['thousands'] = 'No use separadores de mil.';
$string['title'] = 'Título';
$string['title_help'] = 'Título de la encuesta que aparecerá en la parte superior de cada página. Por defecto Título será el nombre de la encuesta, pero podrá editarlo si lo desea.';
$string['today'] = 'hoy';
$string['total'] = 'Total';
$string['totalofnumbers'] = 'Total de números introducidos';
$string['totalresponses'] = 'Total de respuestas a la pregunta';
$string['type'] = 'Tipo de pregunta';
$string['undefinedquestiontype'] = 'Tipo de pregunta no definida!';
$string['unknown'] = 'Desconocido';
$string['unknownaction'] = 'Se ha especificado una acción sobre la encuesta no válida...';
$string['url'] = 'URL';
$string['url_help'] = 'La URL a la que el usuario será redireccionado después de completar esta encuesta.';
$string['useprivate'] = 'Copiar existente';
$string['usepublic'] = 'Utilizar un cuestionario público';
$string['usetemplate'] = 'Usar plantilla';
$string['vertical'] = 'Vertical';
$string['view'] = 'Vista';
$string['viewallresponses'] = 'Ver todas las respuestas';
$string['viewallresponses_help'] = 'Si la encuesta está en **Modo de grupo**: *Grupos Visibles* o *Grupos separados* y el usuario actual tiene la capacidad (en el contexto actual)  *moodle/site:accessallgroups* , y se han definido grupos en el curso actual, entonces el usuario tiene acceso a una lista desplegable de grupos.

Esta lista desplegable permite al usuario "filtrar"  las respuestas a la encuesta por grupos.

Si el ajuste es **Modo de grupo**: *Grupos separados *, los usuarios que no tienen la capacidad *moodle/site:accessallgroups capacidad* (por lo general, los  Estudiantes o los Profesores sin capacidad de edición, etc), sólo podrán ver las respuestas de los grupos a los que pertenecen.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Lista de respuestas';
$string['viewindividualresponse'] = 'Respuestas individuales';
$string['viewindividualresponse_help'] = 'Clique en los nombres de los participants de la lista siguiente para ver sus respuestas individuales.';
$string['viewresponses'] = 'Todas las respuestas ({$a})';
$string['viewyourresponses'] = 'Ver su(s) respuesta(s)';
$string['warning'] = 'Atención: se ha encontrado un error.';
$string['wronganswers'] = 'Hay algunas respuestas incorrectas (mira a continuación)';
$string['wrongdateformat'] = 'El formato de fecha introducida: <strong>{$a}</strong> no se corresponde con el mostrado en el ejemplo.';
$string['wrongdaterange'] = '¡ERROR! El año debe estar en el rango comprendido entre 1902 y 2037.';
$string['wrongformat'] = 'Hay algo incorrecto en tu respuesta a la pregunta:&nbsp;';
$string['wrongformats'] = 'Hay algo incorrecto en tu respuesta a las preguntas: ';
$string['yesno'] = 'Sí/No';
$string['yesno_help'] = 'Pregunta simple Sí/No';
$string['yourresponse'] = 'Ver su(s) respuesta(s)';
$string['yourresponses'] = 'Ver su(s) respuesta(s)';
