<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'pt', version '5.0'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Controlo de acessos';
$string['actionaftercorrectanswer'] = 'Ação após resposta correta';
$string['actionaftercorrectanswer_help'] = 'Após responder corretamente a uma pergunta, existem 3 opções quanto à sequência da lição:

* Normal - conforme sequência da lição
* Mostrar página não vista - As páginas são exibidas de forma aleatória sem que a mesma página seja exibida duas vezes
* Mostrar página não respondida - As páginas são exibidas de forma aleatória, sendo as perguntas não respondidas exibidas novamente';
$string['actions'] = 'Ações';
$string['activitylink'] = 'Hiperligação para a atividade seguinte';
$string['activitylink_help'] = 'Mostra, no final duma lição, uma hiperligação para outra atividade da disciplina. Selecione a atividade na lista pendente.';
$string['activitylinkname'] = 'Ir para: {$a}';
$string['activityoverview'] = 'Atenção às suas Lições! Clique aqui para mais informações.';
$string['addabranchtable'] = 'Inserir página de conteúdo';
$string['addanendofbranch'] = 'Inserir fim de sequência';
$string['addanewpage'] = 'Inserir nova página';
$string['addaquestionpage'] = 'Inserir página de pergunta';
$string['addaquestionpagehere'] = 'Inserir página de pergunta aqui';
$string['addbranchtable'] = 'Inserir página de conteúdo';
$string['addcluster'] = 'Inserir início de grupo';
$string['addedabranchtable'] = 'Página conteúdo inserida';
$string['addedanendofbranch'] = 'Fim de sequência inserido';
$string['addedaquestionpage'] = 'Página de pergunta inserida';
$string['addedcluster'] = 'Início de grupo inserido';
$string['addedendofcluster'] = 'Fim de grupo inserido';
$string['addendofbranch'] = 'Adicionar fim de sequência';
$string['addendofcluster'] = 'Inserir fim de grupo';
$string['addessay'] = 'Adicionar página de pergunta de Desenvolvimento';
$string['addmatching'] = 'Adicionar página de pergunta de Correspondência';
$string['addmultichoice'] = 'Adicionar página de pergunta de Escolha múltipla';
$string['addnewgroupoverride'] = 'Adicionar exceção para grupo';
$string['addnewuseroverride'] = 'Adicionar exceção para utilizador';
$string['addnumerical'] = 'Adicionar página de pergunta Numérica';
$string['addpage'] = 'Inserir página';
$string['addshortanswer'] = 'Adicionar página de pergunta de Resposta curta';
$string['addtruefalse'] = 'Adicionar página de pergunta Verdadeiro/falso';
$string['allotheranswers'] = 'Todas as outras respostas';
$string['allotheranswersjump'] = 'Saltar todas as outras respostas';
$string['allotheranswersscore'] = 'Avaliar todas as outras respostas';
$string['allowofflineattempts'] = 'Permitir conclusão em modo offline com a Aplicação móvel';
$string['allowofflineattempts_help'] = 'Se ativar esta opção, um utilizador pode descarregar a lição e tentar fazê-la offline através da Aplicação móvel. Todas as respostas possíveis e respostas corretas serão também descarregadas.
Nota: Não é possível concluir uma lição offline caso esta tenha sido configurada com um limite de tempo.';
$string['anchortitle'] = 'Início do conteúdo principal';
$string['and'] = 'E';
$string['answer'] = 'Resposta';
$string['answeredcorrectly'] = 'respondida(s) corretamente.';
$string['answersfornumerical'] = 'As respostas a perguntas numéricas devem coincidir com pares de valores máximos e mínimos';
$string['arrangebuttonshorizontally'] = 'Alinhar os botões horizontalmente?';
$string['attempt'] = 'Tentativa: {$a}';
$string['attemptheader'] = 'Tentativa';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Tentativas';
$string['attemptsdeleted'] = 'Tentativas apagadas';
$string['attemptsremaining'] = 'Ainda pode realizar {$a} tentativa(s)';
$string['available'] = 'Disponível a partir de';
$string['averagescore'] = 'Pontuação média';
$string['averagetime'] = 'Tempo médio';
$string['branch'] = 'Botão';
$string['branchtable'] = 'Página de conteúdo';
$string['cachedef_overrides'] = 'Informações da exceção para utilizador e para grupo';
$string['cancel'] = 'Cancelar';
$string['cannotfindanswer'] = 'Erro: não foi possível encontrar a resposta';
$string['cannotfindattempt'] = 'Erro: não foi possível encontrar a tentativa';
$string['cannotfindessay'] = 'Erro: não foi possível encontrar o desenvolvimento';
$string['cannotfindfirstgrade'] = 'Erro: não foi possível encontrar as notas';
$string['cannotfindfirstpage'] = 'Não foi possível encontrar a primeira página';
$string['cannotfindgrade'] = 'Erro: não foi possível encontrar as notas';
$string['cannotfindnewestgrade'] = 'Erro: não foi possível encontrar a nota mais recente';
$string['cannotfindnextpage'] = 'Cópia de segurança da lição: Não foi encontrada a página seguinte!';
$string['cannotfindpagerecord'] = 'Inserir fim de sequência: a página não foi encontrada';
$string['cannotfindpages'] = 'Não foi possível encontrar as páginas da lição';
$string['cannotfindpagetitle'] = 'Confirmar eliminação: o título da página não foi encontrado';
$string['cannotfindpreattempt'] = 'Não foi encontrado o registo da tentativa anterior!';
$string['cannotfindrecords'] = 'Erro: não foi possível encontrar registos da lição';
$string['cannotfindtimer'] = 'Erro: não foi possível encontrar tempos de realização da lição';
$string['cannotfinduser'] = 'Erro: não foi possível encontrar utilizadores';
$string['canretake'] = '{$a} pode repetir';
$string['casesensitive'] = 'Usar regular expressions';
$string['casesensitive_help'] = 'Se ativar esta opção, pode definir as respostas possíveis usando \'regular expressions\' para maior flexibilidade na análise das respostas dos alunos';
$string['checkbranchtable'] = 'Assinalar página de conteúdo';
$string['checkedthisone'] = 'Assinalou esta opção.';
$string['checknavigation'] = 'Assinalar navegação';
$string['checkquestion'] = 'Assinalar pergunta';
$string['classstats'] = 'Estatísticas da turma';
$string['clicktodownload'] = 'Clique na hiperligação seguinte para descarregar o ficheiro.';
$string['closebeforeopen'] = 'Não foi possível atualizar a lição porque definiu uma data de fecho anterior à data de abertura.';
$string['cluster'] = 'Grupo';
$string['clusterjump'] = 'Pergunta não vista dentro do grupo';
$string['clustertitle'] = 'Grupo';
$string['collapsed'] = 'Contraído';
$string['comments'] = 'Os seus comentários';
$string['completed'] = 'Completou';
$string['completederror'] = 'Concluir a lição';
$string['completethefollowingconditions'] = 'Tem de cumprir as seguintes condições na lição <b>{$a}</b> antes de poder continuar.';
$string['completiondetail:reachend'] = 'Visualizar a atividade até ao fim';
$string['completiondetail:timespent'] = 'Dispender pelo menos {$a} nesta atividade';
$string['completionendreached'] = 'Exigir conclusão';
$string['completionendreached_desc'] = 'O aluno terá de chegar ao final da lição para concluir esta atividade';
$string['completiontimespentdesc'] = 'O aluno deve fazer esta atividade pelo menos {$a}';
$string['completiontimespentgroup'] = 'Requer tempo mínimo';
$string['conditionsfordependency'] = 'Condições de dependência';
$string['configintro'] = 'Os valores definidos aqui são os valores predefinidos utilizados nas configurações do formulário de criação de uma nova atividade Lição. As configurações especificadas como avançadas só serão mostradas quando clicar na hiperligação \'Mostrar mais...\'.';
$string['configmaxanswers'] = 'Número máximo de respostas por página, por predefinição';
$string['configmediaclose'] = 'Exibe um botão de fechar na janela de pop-up do conteúdo de suporte';
$string['configmediaheight'] = 'Define a altura da janela pop-up do conteúdo de suporte';
$string['configmediawidth'] = 'Define a largura da janela pop-up do conteúdo de suporte';
$string['configpassword_desc'] = 'Se é necessária uma senha para aceder à Lição.';
$string['configslideshowbgcolor'] = 'Cor de fundo da apresentação de slides, se estiver ativa.';
$string['configslideshowheight'] = 'Define a altura da apresentação de slides, se ativa.';
$string['configslideshowwidth'] = 'Define a largura da apresentação de slides, se ativa.';
$string['configtimelimit_desc'] = 'Se for definido um tempo limite para a realização da lição, será mostrado no início da tentativa um aviso sobre o limite de tempo e é exibida uma contagem decrescente. Se definir esta opção como zero, não haverá tempo limite para a realização da lição.';
$string['confirmdelete'] = 'Apagar página';
$string['confirmdeletionofthispage'] = 'Pretende apagar esta página?';
$string['congratulations'] = 'Parabéns - chegou ao fim da lição';
$string['continue'] = 'Continuar';
$string['continuetoanswer'] = 'Continuar para alterar respostas.';
$string['continuetonextpage'] = 'Continuar para a página seguinte';
$string['correctanswerjump'] = 'Seguir para, se resposta correta';
$string['correctanswerscore'] = 'Pontuação da resposta correta';
$string['correctresponse'] = 'Feedback da resposta correta';
$string['createaquestionpage'] = 'Criar uma página de pergunta';
$string['credit'] = 'Crédito';
$string['customscoring'] = 'Pontuação personalizável';
$string['customscoring_help'] = 'Se ativar esta opção, para cada resposta poderá ser dada uma pontuação com um valor numérico inteiro (positivo ou negativo).';
$string['deadline'] = 'Até';
$string['defaultessayresponse'] = 'A sua resposta à pergunta de desenvolvimento será avaliada pelo professor.';
$string['deleteallattempts'] = 'Todas as tentativas de realização da lição';
$string['deletedefaults'] = 'Foram apagados {$a} x valores por predefinição da lição';
$string['deletedpage'] = 'A página foi apagada';
$string['deletepagenamed'] = 'Eliminar página: {$a}';
$string['deleting'] = 'A apagar';
$string['deletingpage'] = 'A apagar página: {$a}';
$string['dependencyon'] = 'Dependente de';
$string['dependencyon_help'] = 'Esta opção permite que o acesso a esta lição dependa do desempenho do aluno noutra lição da mesma disciplina. Como critério pode ser usada qualquer combinação entre o tempo despendido, se completou a lição ou "nota melhor que".';
$string['description'] = 'Designação';
$string['deselectallattempts'] = 'Desselecionar todas as tentativas';
$string['detailedstats'] = 'Estatísticas detalhadas';
$string['didnotanswerquestion'] = 'Não respondeu a esta pergunta';
$string['didnotreceivecredit'] = 'Não obteve qualquer pontuação';
$string['disabled'] = 'Desativado';
$string['displaydefaultfeedback'] = 'Usar feedback predefinido';
$string['displaydefaultfeedback_help'] = 'Se ativar esta opção, quando um feedback não é definido numa pergunta em particular, é exibido o feedback predefinido "A resposta está correta" ou a "A resposta está errada".';
$string['displayinleftmenu'] = 'Exibir no menu';
$string['displayleftif'] = 'Exibir menu apenas se a nota for superior a';
$string['displayleftif_help'] = 'Esta opção determina se um aluno deve obter uma determinada nota para poder visualizar o menu à esquerda. Isso obriga o aluno a percorrer toda a lição na primeira tentativa e depois de obter a nota exigida, pode usar o menu à esquerda para rever a lição.';
$string['displayleftmenu'] = 'Exibir menu';
$string['displayleftmenu_help'] = 'Se ativar esta opção, será exibido um menu que permite aos utilizadores navegar pela lista de páginas da Lição.';
$string['displaymode'] = 'Modo de apresentação';
$string['displayofgrade'] = 'Exibição da nota (disponível apenas para os alunos)';
$string['displayreview'] = 'Mostrar botão de \'Voltar a responder\'';
$string['displayreview_help'] = 'Se ativar esta opção, quando uma pergunta é respondida de forma incorreta, é dado a escolher ao aluno se quer responder de novo sem obter a pontuação ou continuar a lição. Se o aluno clicar para passar para outra pergunta, a resposta selecionada (errada) será seguida. Por predefinição, os saltos de respostas erradas são definidos para "esta página" e têm uma pontuação de 0 e, por isso, é recomendado que defina o salto de resposta errado para uma página diferente para evitar confusão aos seus alunos.';
$string['displayscorewithessays'] = '<p>Obteve {$a->score} num máximo de {$a->tempmaxgrade} nas respostas avaliadas automaticamente.</p>
<p>As suas respostas às perguntas de desenvolvimento ({$a->essayquestions}) serão avaliadas posteriormente e a pontuação correspondente será adicionada à pontuação final.</p>
<p>A sua nota atual, sem as perguntas que faltam avaliar, é de  {$a->score} num máximo de {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Obteve uma pontuação de {$a->score} num máximo de {$a->grade} pontos.';
$string['duplicatepagenamed'] = 'Duplicar página: {$a}';
$string['edit'] = 'Editar';
$string['editbranchtable'] = 'A editar página de conteúdo';
$string['editcluster'] = 'A editar grupo';
$string['editendofbranch'] = 'A editar página de fim de sequência';
$string['editendofcluster'] = 'A editar página de fim de grupo';
$string['editessay'] = 'A editar página de pergunta de Desenvolvimento';
$string['editinglesson'] = 'A editar lição';
$string['editingquestionpage'] = 'A editar página de pergunta {$a}';
$string['editlesson'] = 'Editar lição';
$string['editlessonsettings'] = 'Editar configurações da lição';
$string['editmatching'] = 'A editar página de pergunta de Correspondência';
$string['editmultichoice'] = 'A editar página de pergunta de Escolha múltipla';
$string['editnumerical'] = 'A editar página de pergunta Numérica';
$string['editoverride'] = 'Editar exceções';
$string['editpage'] = 'Editar';
$string['editpagecontent'] = 'Editar';
$string['editquestion'] = 'A editar uma página de pergunta';
$string['editshortanswer'] = 'A editar página de pergunta de Resposta curta';
$string['edittruefalse'] = 'A editar página de pergunta Verdadeiro/falso';
$string['email'] = 'E-mail';
$string['emailallgradedessays'] = 'Enviar notificações das perguntas de desenvolvimento avaliadas';
$string['emailgradedessays'] = 'Enviar notificações das perguntas de desenvolvimento avaliadas';
$string['emailsuccess'] = 'Notificações enviadas com sucesso';
$string['emptypassword'] = 'A palava-chave não pode estar em branco';
$string['enabled'] = 'Ativado';
$string['endofbranch'] = 'Fim da sequência';
$string['endofcluster'] = 'Fim do grupo';
$string['endofclustertitle'] = 'Fim do grupo';
$string['endoflesson'] = 'Fim da lição';
$string['enteredthis'] = 'inseriu isto.';
$string['enterpassword'] = 'Introduza a senha:';
$string['eolstudentoutoftime'] = '<b>Atenção</b>: Terminou o tempo disponível para realizar esta lição. A sua última resposta poderá não ter sido considerada caso tenha sido dada depois do fim do tempo.';
$string['eolstudentoutoftimenoanswers'] = 'Não respondeu a nenhuma pergunta. Obteve uma classificação de 0 para esta lição.';
$string['essay'] = 'Desenvolvimento';
$string['essayemailmessage2'] = '<p>Pergunta de desenvolvimento: {$a->question}</p><p>A sua resposta: <em>{$a->response}</em></p><p>Comentários da avaliação: <em>{$a->comment}</em></p><p>Obteve {$a->earned} num máximo de {$a->outof} nesta pergunta de desenvolvimento.</p><p>A sua nota da lição \'{$a->lesson}\' foi alterada para {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Obteve {$a->earned} de {$a->outof} nesta pergunta de desenvolvimento.</p><p>A sua nota na lição \'{$a->lesson}\' foi alterada para {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'A sua nota da pergunta';
$string['essaynotgradedyet'] = 'Esta pergunta de desenvolvimento ainda não foi avaliada';
$string['essayresponses'] = 'Respostas à pergunta de desenvolvimento';
$string['essays'] = 'Perguntas de desenvolvimento';
$string['essayscore'] = 'Nota da pergunta de desenvolvimento';
$string['eventcontentpageviewed'] = 'Conteúdo da página visualizado';
$string['eventessayassessed'] = 'Ensaio avaliado';
$string['eventessayattemptviewed'] = 'Tentativa de desenvolvimento visualizada';
$string['eventhighscoreadded'] = 'Pontuação máxima da lição adicionada';
$string['eventhighscoresviewed'] = 'Pontuações máximas da lição visualizadas';
$string['eventlessonended'] = 'Lição terminada';
$string['eventlessonrestarted'] = 'Lição reiniciada';
$string['eventlessonresumed'] = 'Continuar a lição';
$string['eventlessonstarted'] = 'Lição iniciada';
$string['eventoverridecreated'] = 'Exceção para lição criada';
$string['eventoverridedeleted'] = 'Exceção para lição eliminada';
$string['eventoverrideupdated'] = 'Exceção para lição atualizada';
$string['eventpagecreated'] = 'Página criada';
$string['eventpagedeleted'] = 'Página eliminada';
$string['eventpagemoved'] = 'Página movida';
$string['eventpageupdated'] = 'Página atualizada';
$string['eventquestionanswered'] = 'Pergunta respondida';
$string['eventquestionviewed'] = 'Pergunta visualizada';
$string['false'] = 'Falso';
$string['fileformat'] = 'Formato de ficheiro';
$string['finalwrong'] = 'Não está bem.';
$string['finish'] = 'Terminar';
$string['firstanswershould'] = '&nbsp;A primeira resposta deverá seguir para a página "correta".';
$string['firstwrong'] = 'Não respondeu corretamente. Gostaria de tentar responder novamente? (se responder corretamente não contará para a sua nota final.)';
$string['flowcontrol'] = 'Opções de controlo';
$string['fractionsaddwrong'] = 'As notas positivas que selecionou não prefazem 100%.<br />A soma é de {$a}%.<br /> Pretende voltar atrás e corrigir esta pergunta?';
$string['fractionsnomax'] = 'Uma das respostas deve ter a nota de 100% para que seja possível obter a pontuação máxima nesta pergunta.<br /> Pretende voltar atrás e corrigir esta pergunta?';
$string['full'] = 'Expandido';
$string['general'] = 'Geral';
$string['gotoendoflesson'] = 'Ir para o fim da lição';
$string['gradebetterthan'] = 'Nota maior que (&#37;)';
$string['gradebetterthanerror'] = 'Obtenha uma nota melhor que {$a} %';
$string['graded'] = 'Avaliado';
$string['gradeessay'] = 'Avaliar perguntas de desenvolvimento ({$a->notgradedcount} por avaliar e {$a->notsentcount} por enviar)';
$string['gradeis'] = 'A nota é {$a}';
$string['gradeoptions'] = 'Opções de avaliação';
$string['groupoverrides'] = 'Exceções para grupos';
$string['groupoverridesdeleted'] = 'Exceções para grupos apagadas';
$string['groupsnone'] = 'Sem grupos a que possa aceder.';
$string['handlingofretakes'] = 'Tratamento das repetições';
$string['handlingofretakes_help'] = 'Se permitir repetições, esta opção define se a nota da lição é a média ou máxima de todas as notas obtidas nas várias repetições da lição.';
$string['havenotgradedyet'] = 'Ainda não avaliou.';
$string['here'] = 'aqui';
$string['highscore'] = 'Melhor nota';
$string['hightime'] = 'Tempo máximo';
$string['importcount'] = 'A importar {$a} perguntas';
$string['importquestions'] = 'Importar questões';
$string['importquestions_help'] = 'Esta opção permite importar perguntas de vários formatos a partir de um ficheiro de texto.';
$string['inactiveoverridehelp'] = '* Esta exceção está inativa porque o acesso do utilizador à atividade é restrito. Pode ser devido às atribuições de papel ou de grupo, outras restrições de acesso ou a atividade está oculta.';
$string['indicator:cognitivedepth'] = 'Compreensão da Lição';
$string['indicator:cognitivedepth_help'] = 'Este indicador é baseado na capacidade cognitiva alcançada pelo aluno na atividade Lição.';
$string['indicator:cognitivedepthdef'] = 'Compreensão da Lição';
$string['indicator:cognitivedepthdef_help'] = 'O participante alcançou esta percentagem da capacidade cognitiva oferecida pelas atividades Lição durante este intervalo de análise (Níveis = Não visualizado, Visualizado, Submetido, Feedback visualizado, Comentários ao feedback, Voltar a submeter após visualizar feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialização da Lição';
$string['indicator:socialbreadth_help'] = 'Este indicador é baseado na extensão social alcançada pelo aluno na atividade Lição.';
$string['indicator:socialbreadthdef'] = 'Socialização da Lição';
$string['indicator:socialbreadthdef_help'] = 'O participante alcançou esta percentagem do relacionamento social oferecido pelas atividades Lição durante esse intervalo de análise (Níveis = Sem participação, Participante individual, Participante com outros)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Página inserida';
$string['invalidfile'] = 'Ficheiro inválido';
$string['invalidid'] = 'Não foi especificado nenhum ID do módulo ou da lição';
$string['invalidlessonid'] = 'ID da lição incorreto';
$string['invalidoverrideid'] = 'O id da exceção não é válido';
$string['invalidpageid'] = 'ID da página inválido';
$string['jump'] = 'Seguir para';
$string['jumps'] = 'Segue para';
$string['jumps_help'] = 'Cada resposta (para as perguntas) ou descrição (para as páginas de conteúdo) seguem para uma página específica. A página seguinte pode ser definida de forma relativa, como \'Esta página\' ou \'Página seguinte\', ou absoluta, especificando uma das páginas da lição.';
$string['jumpsto'] = 'Segue para <em>{$a}</em>';
$string['leftduringtimed'] = 'Interrompeu uma lição com tempo limite.<br />Clique em Continuar para reiniciar à lição.';
$string['leftduringtimednoretake'] = 'Interrompeu uma lição com tempo limite<br />e não lhe é permitido repetir ou continuar a lição.';
$string['leftduringtimedsession'] = 'Saiu durante uma lição com tempo limite';
$string['lesson:addinstance'] = 'Adicionar nova Lição';
$string['lesson:edit'] = 'Editar uma lição';
$string['lesson:grade'] = 'Avaliar perguntas de desenvolvimento da Lição';
$string['lesson:manage'] = 'Gerir uma lição';
$string['lesson:manageoverrides'] = 'Gerir exceções da lição';
$string['lesson:view'] = 'Ver atividade lição';
$string['lesson:viewreports'] = 'Ver os relatórios da lição';
$string['lessonbeingpreviewed'] = 'De momento, a lição está a ser pré-visualizada.';
$string['lessonclosed'] = 'Esta lição fechou {$a}';
$string['lessoncloses'] = 'A lição fecha';
$string['lessoneventcloses'] = 'Fecha \'{$a}\'';
$string['lessoneventopens'] = 'Abre \'{$a}\'';
$string['lessonformating'] = 'Formatação da lição';
$string['lessonmenu'] = 'Menu da lição';
$string['lessonnotready'] = 'Esta lição não está pronta para ser realizada. Contacte o seu {$a}.';
$string['lessonnotready2'] = 'A lição ainda não está disponível.';
$string['lessonopen'] = 'Esta lição ficará disponível {$a}.';
$string['lessonopens'] = 'A lição abre';
$string['lessonpagelinkingbroken'] = 'Não foi encontrada a primeira página. As ligações entre páginas da lição poderão estar erradas. Contacte um administrador.';
$string['lessonstats'] = 'Estatísticas da lição';
$string['linkedmedia'] = 'Conteúdo de suporte';
$string['loginfail'] = 'A autenticação falhou. Tente de novo...';
$string['lowscore'] = 'Nota mais baixa';
$string['lowtime'] = 'Tempo mínimo';
$string['manageoverrides'] = 'Gerir exceções';
$string['manualgrading'] = 'Avaliar perguntas de desenvolvimento';
$string['matchesanswer'] = 'Corresponde a';
$string['matching'] = 'Correspondência';
$string['matchingpair'] = 'Par de correspondência {$a}';
$string['maxgrade'] = 'Nota máxima';
$string['maxgrade_help'] = 'Esta opção define a nota máxima para a lição. Se o valor for 0, a lição não aparece nas páginas relacionadas com a avaliação.';
$string['maximumnumberofanswersbranches'] = 'Número máximo de opções de resposta';
$string['maximumnumberofanswersbranches_help'] = 'Esta opção define o número máximo de opções de resposta que podem ser definidas nas perguntas da Lição. Se forem usadas apenas perguntas do tipo Verdadeiro/Falso, o número máximo de opções de resposta pode ser configurado para 2. Pode alterar esta opção a qualquer momento uma vez que afeta apenas o que o professor vê, e não a informação já guardada.';
$string['maximumnumberofattempts'] = 'Número máximo de tentativas por pergunta';
$string['maximumnumberofattempts_help'] = 'Esta opção define o número máximo de tentativas permitidas para responder a uma pergunta. Se responder repetidamente de forma incorreta, quando o máximo de tentativas é atingido a lição passa automaticamente para a página seguinte.';
$string['maximumnumberofattemptsreached'] = 'Atingiu o número máximo de tentativas permitido - A lição vai avançar para a página seguinte';
$string['mediaclose'] = 'Mostrar botão de fechar';
$string['mediafile'] = 'Ficheiros multimédia relacionados';
$string['mediafile_help'] = 'Podem ser carregados ficheiros para utilização na Lição. Será mostrada uma hiperligação \'Clique aqui para ver\' num bloco com a designação \'Conteúdo de suporte\' em cada página da Lição.';
$string['mediafilepopup'] = 'Clique aqui para ver';
$string['mediaheight'] = 'Altura da janela pop-up';
$string['mediawidth'] = 'Largura da janela pop-up';
$string['messageprovider:graded_essay'] = 'Notificações sobre avaliação de perguntas de desenvolvimento';
$string['minimumnumberofquestions'] = 'Número mínimo de perguntas';
$string['minimumnumberofquestions_help'] = 'Esta opção define o número mínimo de perguntas que será usado para calcular a nota da atividade.';
$string['missingname'] = 'Introduza um nickname';
$string['modattempts'] = 'Permitir revisão';
$string['modattempts_help'] = 'Se ativar esta opção, os alunos podem navegar novamente pela lição desde o início.';
$string['modattemptsnoteacher'] = 'A possibilidade de revisão só funciona para os alunos.';
$string['modulename'] = 'Lição';
$string['modulename_help'] = 'A atividade Lição permite aos professores criarem uma experiência de aprendizagem interessante e adaptável.

A Lição é constituída por uma série de páginas com conteúdo em que cada página pode terminar com uma pergunta. Os tipos de pergunta podem ser de escolha múltipla, correspondência ou resposta curta. Dependendo da escolha correta ou não do aluno, este avança para a página seguinte ou retrocede para a anterior.

Uma lição pode ser avaliada ou ser apenas de treino, sem pontuação.

As Lições podem ser utilizadas:

* Para a aprendizagem de um conteúdo específico;
* Para simulações e exercícios de tomada de decisão;
* Como um meio para proporcionar conteúdos para diferentes estilos de aprendizagem. Por exemplo, os alunos podem optar, de acordo com a sua preferência, por uma página de vídeo, podcast ou texto;
* Para revisão de conhecimentos adaptados ao nível de conhecimento de cada aluno, com diferentes conjuntos de perguntas que são exibidas em função das respostas dadas às perguntas iniciais.';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lições';
$string['move'] = 'Mover página';
$string['movedpage'] = 'Página movida';
$string['movepagehere'] = 'Mover página para aqui';
$string['movepagenamed'] = 'Mover a página: {$a}';
$string['moving'] = 'A mover página: {$a}';
$string['multianswer'] = 'Respostas múltiplas';
$string['multianswer_help'] = 'Ative esta opção se a resposta correta for uma combinação de várias opções de resposta.';
$string['multichoice'] = 'Escolha múltipla';
$string['multipleanswer'] = 'Resposta múltipla';
$string['nameapproved'] = 'O nome foi aprovado';
$string['namereject'] = 'O seu nome foi rejeitado pelo filtro.<br />Tente outro nome.';
$string['new'] = 'novo';
$string['nextpage'] = 'Página seguinte';
$string['noanswer'] = 'Uma ou mais perguntas ainda estão por responder. Por favor, volte atrás e submeta uma resposta.';
$string['noattemptrecordsfound'] = 'Não foram encontrados registos de tentativas: não foi atribuída nota';
$string['nobranchtablefound'] = 'Não foi encontrada nenhuma página de conteúdo';
$string['noclose'] = 'Sem data de fecho';
$string['nocommentyet'] = 'Sem comentário.';
$string['nocoursemods'] = 'Não foram encontradas quaisquer atividades';
$string['nocredit'] = 'Sem crédito';
$string['nodeadline'] = 'Sem data limite';
$string['noessayquestionsfound'] = 'Não foram encontradas perguntas de desenvolvimento nesta lição.';
$string['nohighscores'] = 'Não há melhores notas';
$string['nolessonattempts'] = 'Não houve tentativas de realização desta lição.';
$string['nolessonattemptsgroup'] = 'Não foram realizadas tentativas por membros do grupo {$a} nesta lição.';
$string['none'] = 'Nenhum';
$string['nooneansweredcorrectly'] = 'Ninguém respondeu corretamente.';
$string['nooneansweredthisquestion'] = 'Ninguém respondeu a esta pergunta.';
$string['noonecheckedthis'] = 'Ninguém assinalou esta opção.';
$string['nooneenteredthis'] = 'Ninguém inseriu isto.';
$string['noonehasanswered'] = 'Ninguém respondeu a uma pergunta de desenvolvimento.';
$string['noonehasansweredgroup'] = 'Ainda ninguém em {$a} respondeu a esta pergunta de desenvolvimento.';
$string['noopen'] = 'Sem data de abertura';
$string['nooverridecreated'] = 'Nenhuma exceção criada.';
$string['nooverridedata'] = 'Deverá definir uma exceção em pelo menos uma opção configuração da Lição.';
$string['noretake'] = 'Não pode repetir esta lição.';
$string['normal'] = 'Normal - conforme sequência da lição';
$string['notcompleted'] = 'Incompleta';
$string['notcompletedwithdate'] = 'Não concluída ({$a})';
$string['notdefined'] = 'Indefinido(a)';
$string['notenoughsubquestions'] = 'Não foram definidas subperguntas suficientes!<br />Quer voltar atrás e corrigir a pergunta?';
$string['notenoughtimespent'] = 'Completou esta lição em {$a->timespent}, o que é inferior ao tempo mínimo de realização de {$a->timerequired} . Poderá necessitar de iniciar uma nova tentativa de realização da lição.';
$string['notgraded'] = 'Sem avaliação';
$string['notitle'] = 'Sem título';
$string['notyetcompleted'] = 'A Lição já foi iniciada mas ainda não está concluída';
$string['numberofcorrectanswers'] = 'Número de respostas corretas: {$a}';
$string['numberofcorrectanswersheader'] = 'Número de respostas corretas';
$string['numberofcorrectmatches'] = 'Número de correspondências corretas: {$a}';
$string['numberofpagestoshow'] = 'Número de páginas a mostrar';
$string['numberofpagestoshow_help'] = 'Esta opção define o número de páginas exibidas numa lição. Apenas é aplicável em lições em que as páginas são exibidas aleatoriamente (quando a opção "Ação após resposta correta" está configurada como "Mostrar página não vista" ou "Mostrar página não respondida"). Se selecionar o valor 0 todas as páginas serão exibidas.';
$string['numberofpagesviewed'] = 'Perguntas respondidas: {$a}';
$string['numberofpagesviewedheader'] = 'Número de questões respondidas';
$string['numberofpagesviewednotice'] = 'Número de questões respondidas: {$a->nquestions} (Tem de responder pelo menos a {$a->minquestions} questões)';
$string['numerical'] = 'Numérica';
$string['numericanswer'] = 'Resposta numérica';
$string['numericanswer_help'] = 'Pode especificar um número apenas ou intervalo de números usando dois pontos. Por exemplo, 2:5 significa que qualquer resposta entre 2 e 5, incluindo-os, está correta.';
$string['offlinedatamessage'] = 'Já trabalhou nesta tentativa usando um dispositivo móvel. Os dados foram guardados pela última vez neste site há {$a} atrás. Verifique que não existem trabalhos por guardar.';
$string['ongoing'] = 'Exibir avaliação no decorrer da lição';
$string['ongoing_help'] = 'Se ativar esta opção, cada página da lição exibirá a pontuação obtida pelo aluno e a máxima possível de obter na lição.';
$string['ongoingcustom'] = 'Até agora obteve {$a->score} num máximo de {$a->currenthigh} pontos.';
$string['ongoingnormal'] = 'Respondeu corretamente a {$a->correct} de {$a->viewed} perguntas.';
$string['onpostperpage'] = 'Apenas um registo por nota';
$string['openafterclose'] = 'Indicou uma data de abertura posterior à data de fecho';
$string['options'] = 'Opções';
$string['or'] = 'OU';
$string['ordered'] = 'Por ordem';
$string['other'] = 'Outras Opções';
$string['outof'] = 'Em {$a}';
$string['override'] = 'Exceção';
$string['overridedeletegroupsure'] = 'Tem a certeza de que pretende apagar a exceção para o grupo {$a}?';
$string['overridedeleteusersure'] = 'Tem a certeza de que pretende apagar a exceção para o utilizador {$a}?';
$string['overridegroup'] = 'Exceção para grupo';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Exceções';
$string['overrideuser'] = 'Exceção para o utilizador';
$string['overrideusereventname'] = '{$a->lesson} - Exceção';
$string['overview'] = 'Perspetiva global';
$string['overview_help'] = 'Lição é uma atividade constituída por um conjunto de páginas. Cada página contém um determinado conteúdo e geralmente termina com uma pergunta. Associada a cada resposta está uma página para onde a lição segue. A página a seguir pode ser definida de forma relativa, para a mesma página ou para a seguinte, ou absoluta, seguindo para qualquer outra página na lição. A página de conteúdo é a que contém um conjunto de botões/hiperligações para navegar para outras páginas na Lição, que pode servir como menu/índice da Lição.';
$string['page'] = 'Página: {$a}';
$string['page-mod-lesson-edit'] = 'Editar página da lição';
$string['page-mod-lesson-view'] = 'Ver ou pré-visualizar página';
$string['page-mod-lesson-x'] = 'Qualquer página da atividade lição';
$string['pageanswers'] = 'Página de respostas';
$string['pagecontents'] = 'Conteúdo';
$string['pageresponses'] = 'Página de respostas';
$string['pages'] = 'Páginas';
$string['pagetitle'] = 'Título da página';
$string['password'] = 'Senha';
$string['passwordprotectedlesson'] = '{$a} é uma lição protegida por senha.';
$string['pleasecheckoneanswer'] = 'Assinale uma resposta';
$string['pleasecheckoneormoreanswers'] = 'Assinale pelo menos uma resposta';
$string['pleaseenteryouranswerinthebox'] = 'Introduza a resposta na caixa';
$string['pleasematchtheabovepairs'] = 'Estabeleça a correspondência entre os pares';
$string['pluginadministration'] = 'Administração da Lição';
$string['pluginname'] = 'Lição';
$string['pointsearned'] = 'Pontos obtidos';
$string['postprocesserror'] = 'Ocorreu um erro durante o pós-processamento!';
$string['postsuccess'] = 'Mensagem enviada com sucesso';
$string['practice'] = 'Lição de treino';
$string['practice_help'] = 'Uma lição de treino é apenas para aprender e a sua avaliação não aparece na pauta nem  influencia a nota final do aluno.';
$string['preprocesserror'] = 'Ocorreu um erro durante o pré-processamento!';
$string['prerequisiteisobsolete'] = 'A opção pré-requisito da Lição será eliminada em breve. Por favor, utilize antes a opção restrições de acesso.';
$string['prerequisitelesson'] = 'Pré-requisitos da lição';
$string['preview'] = 'Pré-visualização';
$string['previewlesson'] = 'Pré-visualizar {$a}';
$string['previewpagenamed'] = 'Pré-visualizar a página {$a}';
$string['previouspage'] = 'Página anterior';
$string['privacy:metadata:attempts'] = 'O registo da página de tentativas';
$string['privacy:metadata:attempts:answerid'] = 'O ID da resposta';
$string['privacy:metadata:attempts:correct'] = 'Se a tentativa estava correta';
$string['privacy:metadata:attempts:pageid'] = 'O ID da página';
$string['privacy:metadata:attempts:retry'] = 'Número da tentativa';
$string['privacy:metadata:attempts:timeseen'] = 'A data e hora em que a tentativa foi efetuada';
$string['privacy:metadata:attempts:useranswer'] = 'Detalhes sobre a resposta do utilizador';
$string['privacy:metadata:attempts:userid'] = 'O ID do utilizador';
$string['privacy:metadata:branch'] = 'O registo das visualizações de página';
$string['privacy:metadata:branch:flag'] = 'Se a próxima página deve, ou não, ser calculada de forma aleatória';
$string['privacy:metadata:branch:nextpageid'] = 'O ID da próxima página';
$string['privacy:metadata:branch:pageid'] = 'O ID da página';
$string['privacy:metadata:branch:retry'] = 'O número da tentativa';
$string['privacy:metadata:branch:timeseen'] = 'A data e hora em que a página foi visualizada';
$string['privacy:metadata:branch:userid'] = 'O ID do utilizador';
$string['privacy:metadata:grades'] = 'O registo das avaliações de cada lição';
$string['privacy:metadata:grades:completed'] = 'A data em que a nota foi atribuída';
$string['privacy:metadata:grades:grade'] = 'A avaliação atribuída';
$string['privacy:metadata:grades:userid'] = 'O ID do utilizador';
$string['privacy:metadata:overrides'] = 'O registo de exceções por lição';
$string['privacy:metadata:overrides:available'] = 'Data e hora a que os alunos podem iniciar a tentativa da lição';
$string['privacy:metadata:overrides:deadline'] = 'A data limite para completar a lição.';
$string['privacy:metadata:overrides:maxattempts'] = 'O número máximo de tentativas';
$string['privacy:metadata:overrides:password'] = 'A senha para aceder à lição';
$string['privacy:metadata:overrides:retake'] = 'Se deve permitir repetição';
$string['privacy:metadata:overrides:review'] = 'Se tentar a questão novamente é permitido.';
$string['privacy:metadata:overrides:timelimit'] = 'Tempo limite para completar a lição, em segundos.';
$string['privacy:metadata:overrides:userid'] = 'O ID do utilizador';
$string['privacy:metadata:timer'] = 'O registo da tentativa de lição';
$string['privacy:metadata:timer:completed'] = 'Se a tentativa esta concluída';
$string['privacy:metadata:timer:lessontime'] = 'O último momento em que a atividade foi registada';
$string['privacy:metadata:timer:starttime'] = 'A data e hora em que iniciou a tentativa';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'O último momento em que a atividade foi registada na Aplicação móvel Moodle';
$string['privacy:metadata:timer:userid'] = 'O ID do utilizador';
$string['privacy:metadata:userpref:lessonview'] = 'A preferência do modo de exibição ao editar lições';
$string['privacy:path:essayanswers'] = 'Respostas de desenvolvimento';
$string['privacy:path:essayresponses'] = 'Respostas de desenvolvimento';
$string['privacy:path:pages'] = 'Páginas';
$string['processerror'] = 'Ocorreu um erro durante o processo!';
$string['progressbar'] = 'Barra de progresso';
$string['progressbar_help'] = 'Se ativar esta opção, é exibida uma barra de progresso no fim da página da lição mostrando a percentagem aproximada de conclusão.';
$string['progressbarteacherwarning'] = 'A barra de progresso não é exibida para {$a}';
$string['progressbarteacherwarning2'] = 'Não está a visualizar a barra de progresso porque pode editar esta lição';
$string['progresscompleted'] = 'Completou {$a}% da lição';
$string['qtype'] = 'Tipo de Página';
$string['question'] = 'Inserir página de pergunta';
$string['questionoption'] = 'Opção de pergunta';
$string['questiontype'] = 'Tipo de pergunta';
$string['randombranch'] = 'Página de conteúdo aleatória';
$string['randompageinbranch'] = 'Pergunta aleatória da sequência';
$string['rank'] = 'Posição';
$string['rawgrade'] = 'Nota bruta';
$string['receivedcredit'] = 'Crédito obtido';
$string['redisplaypage'] = 'Voltar a exibir a página';
$string['removeallgroupoverrides'] = 'Todas as exceções para grupos';
$string['removealluseroverrides'] = 'Todas as exceções para utilizadores';
$string['report'] = 'Relatório';
$string['reports'] = 'Relatórios';
$string['response'] = 'Feedback';
$string['retakesallowed'] = 'Permitir repetição';
$string['retakesallowed_help'] = 'Se ativar esta opção, os alunos podem fazer a lição mais que uma vez.';
$string['returnto'] = 'Voltar para {$a}';
$string['returntocourse'] = 'Voltar à disciplina';
$string['reverttodefaults'] = 'Restaurar as predefinições da lição';
$string['review'] = 'Revisão';
$string['reviewlesson'] = 'Rever lição';
$string['reviewquestionback'] = 'Sim, quero tentar novamente';
$string['reviewquestioncontinue'] = 'Não, quero avançar para a pergunta seguinte';
$string['sanitycheckfailed'] = 'Falha na verificação: esta tentativa foi apagada';
$string['save'] = 'Guardar';
$string['savechanges'] = 'Guardar alterações';
$string['savechangesandeol'] = 'Guardar todas as alterações e ir para o fim da lição.';
$string['saveoverrideandstay'] = 'Guardar e adicionar outra exceção';
$string['savepage'] = 'Guardar página';
$string['score'] = 'Nota';
$string['score_help'] = 'Se a pontuação estiver ativada nas configurações da lição, para cada resposta poderá ser dada uma pontuação com um valor numérico inteiro (positivo ou negativo).';
$string['scores'] = 'Notas';
$string['search:activity'] = 'Lição - informações da atividade';
$string['secondpluswrong'] = 'Resposta incorreta. Quer voltar a tentar?';
$string['selectallattempts'] = 'Selecionar todas as tentativas';
$string['selectaqtype'] = 'Selecione tipo de pergunta';
$string['selectreport'] = 'Escolha o relatório';
$string['sent'] = 'Enviado';
$string['shortanswer'] = 'Resposta curta';
$string['showanunansweredpage'] = 'Mostrar página não respondida';
$string['showanunseenpage'] = 'Mostrar página não vista';
$string['singleanswer'] = 'Resposta única';
$string['skip'] = 'Ignorar navegação';
$string['slideshow'] = 'Apresentação de slides';
$string['slideshow_help'] = 'Se ativar esta opção, a lição é exibida como uma apresentação de slides com um ecrã com uma largura e altura predefinidas.';
$string['slideshowbgcolor'] = 'Cor de fundo da apresentação de slides';
$string['slideshowheight'] = 'Altura da apresentação de slides';
$string['slideshowwidth'] = 'Largura da apresentação de slides';
$string['startlesson'] = 'Iniciar lição';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} tentativa número {$a->attempt}';
$string['studentname'] = '{$a} Nome';
$string['studentoneminwarning'] = 'Aviso: Tem um minuto ou menos para terminar a lição.';
$string['studentoutoftimeforreview'] = '<b>Atenção</b>: Terminou o tempo disponível para rever esta lição';
$string['studentresponse'] = 'Resposta de {$a}';
$string['submit'] = 'Submeter';
$string['submitname'] = 'Submeter nome';
$string['teacherjumpwarning'] = 'Nesta lição existem páginas que seguem para {$a->cluster} ou para {$a->unseen}. Esta sequência será ignorada e a lição seguirá para a página seguinte. Para testar a sequência das páginas, assuma o papel de aluno.';
$string['teacherongoingwarning'] = 'A exibição da pontuação no decorrer da lição só é visível para os alunos. Para ver a pontuação no decorrer da lição, assuma o papel de aluno.';
$string['teachertimerwarning'] = 'O temporizador só é visível para os alunos. Para testar esta funcionalidade, entre como aluno.';
$string['thatsthecorrectanswer'] = 'A sua resposta está correta.';
$string['thatsthewronganswer'] = 'A sua resposta <strong>não</strong> está correta.';
$string['thefollowingpagesjumptothispage'] = 'As páginas seguintes seguem para esta página';
$string['thispage'] = 'Esta página';
$string['timeisup'] = 'Terminou o tempo';
$string['timelimit'] = 'Tempo limite';
$string['timelimit_help'] = 'Se ativar esta opção, no início da lição, será mostrado um aviso sobre o tempo limite e é exibida uma contagem decrescente. As respostas dadas depois do tempo terminar não serão avaliadas.';
$string['timelimitwarning'] = 'Tem {$a} para finalizar a lição.';
$string['timeremaining'] = 'Tempo restante';
$string['timespenterror'] = 'Gastou pelo menos {$a} minutos nesta lição.';
$string['timespentminutes'] = 'Tempo despendido (minutos)';
$string['timetaken'] = 'Tempo gasto';
$string['totalpagesviewedheader'] = 'Número de páginas vizualizadas';
$string['true'] = 'Verdadeiro';
$string['truefalse'] = 'Verdadeiro/falso';
$string['unabledtosavefile'] = 'O ficheiro que carregou não pode ser guardado';
$string['unknownqtypesnotimported'] = '{$a} perguntas com tipos de perguntas não suportados não foram importadas';
$string['unseenpageinbranch'] = 'Pergunta não vista da sequência';
$string['unsupportedqtype'] = 'Tipo de pergunta não suportado ({$a})!';
$string['updatedpage'] = 'A página foi atualizada';
$string['updatefailed'] = 'A atualização falhou';
$string['updatepagenamed'] = 'Atualizar página {$a}';
$string['usemaximum'] = 'Usar máximo';
$string['usemean'] = 'Usar média';
$string['usepassword'] = 'Lição protegida por senha';
$string['usepassword_help'] = 'Se ativar esta opção, é necessário inserir uma senha para aceder à lição.';
$string['useroverrides'] = 'Exceções para utilizadores';
$string['useroverridesdeleted'] = 'Exceções para utilizadores apagadas';
$string['usersnone'] = 'Nenhum aluno tem acesso a esta lição';
$string['viewessayanswers'] = 'Ver respostas à pergunta de desenvolvimento';
$string['viewgrades'] = 'Ver notas';
$string['viewreports'] = 'Ver {$a->attempts} tentativas concluídas de {$a->student}';
$string['viewreports2'] = 'Ver {$a} tentativas concluídas';
$string['warning'] = 'Aviso';
$string['welldone'] = 'Muito bem!';
$string['whatdofirst'] = 'O que pretende fazer para começar?';
$string['withselectedattempts'] = 'Com as tentativas selecionadas...';
$string['wronganswerjump'] = 'Seguir para, se resposta errada';
$string['wronganswerscore'] = 'Pontuação';
$string['wrongresponse'] = 'Feedback para resposta errada';
$string['youhaveseen'] = 'Já viu mais do que uma página desta lição.<br />Quer continuar a partir da última página que viu?';
$string['youranswer'] = 'A sua resposta';
$string['yourcurrentgradeis'] = 'A sua nota atual é {$a}';
$string['yourcurrentgradeisoutof'] = 'A sua nota atual é {$a->grade} em {$a->total}';
$string['youshouldview'] = 'Deve responder a pelo menos: {$a}';
