<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'message', language 'ja', version '5.0'.
 *
 * @package     message
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptandaddcontact'] = '承認およびコンタクトに追加する';
$string['addcontact'] = 'コンタクトに追加する';
$string['addcontactconfirm'] = '本当にあなたのコンタクトに {$a} を追加してもよろしいですか?';
$string['addtofavourites'] = '会話に星を付ける';
$string['addtoyourcontacts'] = 'コンタクトに追加する';
$string['addtoyourcontactsandmessage'] = 'コンタクトおよびメッセージに追加する';
$string['ago'] = '{$a} 前';
$string['allusers'] = 'すべてのユーザからのすべてのメッセージ';
$string['backto'] = '{$a} に戻る';
$string['backupmessageshelp'] = 'この設定を有効にした場合、サイト自動バックアップにインスタントメッセージが含まれます。';
$string['blockcontact'] = '受信拒否';
$string['blockedusers'] = 'ブロック済みユーザ';
$string['blocknoncontacts'] = '不明なユーザをブロックする';
$string['blockuser'] = 'ユーザをブロックする';
$string['blockuserconfirm'] = '本当に {$a} をブロックしてもよろしいですか?';
$string['blockuserconfirmbutton'] = 'ブロック';
$string['cancelselection'] = 'メッセージ選択を解除する';
$string['cantblockuser'] = 'すべてのユーザにメッセージを送信できるパーミッションのロールであるため、あなたは {$a} をブロックできません。';
$string['contactableprivacy'] = '受け入れるメッセージの送信元:';
$string['contactableprivacy_coursemember'] = 'マイコンタクトおよびマイコースの誰でも';
$string['contactableprivacy_onlycontacts'] = 'マイコンタクトのみ';
$string['contactableprivacy_site'] = 'サイトの誰でも';
$string['contactblocked'] = 'コンタクトブロック済み';
$string['contactrequests'] = 'コンタクトリクエスト';
$string['contactrequestsent'] = 'コンタクトリクエストが送信されました。';
$string['contacts'] = 'コンタクト';
$string['conversationactions'] = '会話アクションメニュー';
$string['decline'] = '拒否';
$string['defaultmessageoutputs'] = '通知設定';
$string['deleteallconfirm'] = '本当にこの会話すべてを削除してもよろしいですか? これで他の会話参加者の会話が削除されるこはありません。';
$string['deleteallmessages'] = 'すべてのメッセージを削除する';
$string['deleteallselfconfirm'] = '本当にこのプライベートな会話全体を削除してもよろしいですか?';
$string['deleteconversation'] = '会話を削除する';
$string['deleteforeveryone'] = '私および他の人のために削除する';
$string['deleteforeveryoneselectedmessagesconfirm'] = '本当に選択されたメッセージを削除してもよろしいですか?';
$string['deleteselectedmessages'] = '選択したメッセージを削除する';
$string['deleteselectedmessagesconfirm'] = '本当に選択したメッセージを削除してもよろしいですか? これで他の会話参加者のメッセージが削除されることはありません。';
$string['deleteselectedmessagesconfirmselfconversation'] = '本当に選択したパーソナルメッセージを削除してもよろしいですか?';
$string['disableall'] = '通知を無効にする';
$string['disabled'] = 'このサイトではメッセージングが無効にされています。';
$string['disallowed'] = 'ロック解除';
$string['editmessages'] = 'メッセージを編集する';
$string['emailtagline'] = 'これはあなた宛に {$a->sitename} で送信されたメッセージのコピーです。返信するには {$a->url} にアクセスしてください。';
$string['enabled'] = '有効';
$string['errorcallingprocessor'] = '定義されたアウトプットのコールにエラーが発生しました。';
$string['errorconversationdoesnotexist'] = '会話はありません。';
$string['errormessagetoolong'] = 'メッセージが最大許可長を超えています。';
$string['errortranslatingdefault'] = 'プラグインから提供されているデフォルト設定の変換にエラーが発生しました。代わりにシステムデフォルトを使用します。';
$string['eventgroupmessagesent'] = 'グループメッセージが送信されました。';
$string['eventmessagecontactadded'] = 'メッセージコンタクトが追加されました。';
$string['eventmessagecontactremoved'] = 'メッセージコンタクトが削除されました。';
$string['eventmessagedeleted'] = 'メッセージが削除されました。';
$string['eventmessagesent'] = 'メッセージが送信されました。';
$string['eventmessageuserblocked'] = 'ユーザがブロックされました。';
$string['eventmessageuserunblocked'] = 'ユーザのブロックが解除されました。';
$string['eventmessageviewed'] = 'メッセージが閲覧されました。';
$string['eventnotificationsent'] = '通知が送信されました。';
$string['eventnotificationviewed'] = '通知が閲覧されました。';
$string['forced'] = 'ロック';
$string['forcedmessage'] = 'ロック';
$string['groupconversations'] = 'グループ';
$string['groupinfo'] = 'グループ情報';
$string['guestnoeditmessage'] = 'ゲストユーザはメッセージングオプションを編集できません。';
$string['guestnoeditmessageother'] = 'ゲストユーザは他のユーザのメッセージングオプションを編集できません。';
$string['hidemessagewindow'] = 'メッセージウィンドウを隠す';
$string['hidenotificationwindow'] = '通知ウィンドウを隠す';
$string['individualconversations'] = 'プライベート';
$string['info'] = 'ユーザ情報';
$string['isnotinyourcontacts'] = 'あなたのコンタクトに {$a} は登録されていません。';
$string['loadmore'] = 'さらに読み込む';
$string['loggedin'] = 'オンライン';
$string['loggedoff'] = 'オフライン';
$string['managemessageoutputs'] = 'デフォルト通知プレファレンス';
$string['message'] = 'メッセージ';
$string['messagecontactrequest'] = '{$a->user} がコンタクトに追加するようリクエストしています。リクエストに返答するにはあなたの<a href="{$a->url}">コンタクトリクエスト</a>ページにアクセスしてください。';
$string['messagecontactrequestsubject'] = '{$a->sitename}: {$a->user} によるコンタクトリクエスト';
$string['messagecontentaudio'] = 'オーディオ';
$string['messagecontentimage'] = 'イメージ';
$string['messagecontentmultimediageneral'] = 'その他のメディア';
$string['messagecontentvideo'] = 'ビデオ';
$string['messagedrawerviewcontact'] = '{$a} のユーザ詳細';
$string['messagedrawerviewcontacts'] = 'メッセージコンタクト';
$string['messagedrawerviewconversation'] = '{$a} との会話';
$string['messagedrawerviewgroupinfo'] = '{$a} のグループ詳細';
$string['messagedrawerviewoverview'] = 'メッセージ概要';
$string['messagedrawerviewsearch'] = '{$a} のメッセージ検索結果';
$string['messagedrawerviewsettings'] = 'メッセージ設定';
$string['messageoutputs'] = '通知プラグイン';
$string['messagepreferences'] = 'メッセージプレファレンス';
$string['messages'] = 'メッセージ';
$string['messagesselected:'] = '選択済みメッセージ:';
$string['messagetextrequired'] = 'メッセージテキストを入力してください。';
$string['messagingdatahasnotbeenmigrated'] = 'メッセージング機能のアップグレードのため、あなたのメッセージは一時的に利用できません。移行完了までお待ちください。';
$string['muteconversation'] = 'ミュート';
$string['mutedconversation'] = 'ミュート済み会話';
$string['newmessage'] = '新しいメッセージ';
$string['newmessagesearch'] = '新しいメッセージの送信先をコンタクトから選択または検索してください。';
$string['newonlymsg'] = '新しいメッセージのみ表示する';
$string['nocontactrequests'] = 'コンタクトリストはありません。';
$string['nocontacts'] = 'コンタクトはありません。';
$string['nocontactsgetstarted'] = 'コンタクトなし';
$string['nofavourites'] = '星付きの会話はありません。';
$string['noframesjs'] = 'アクセシビリティの高いインタフェースを使用する';
$string['nogroupconversations'] = 'グループ会話なし';
$string['noindividualconversations'] = 'プライベート会話なし';
$string['nomessagesfound'] = 'メッセージが見つかりませんでした。';
$string['noncontacts'] = '非コンタクト';
$string['nonotifications'] = 'あなたに通知はありません。';
$string['noparticipants'] = '参加者はいません。';
$string['noreply'] = 'このメッセージに返信しないでください。';
$string['notificationdatahasnotbeenmigrated'] = '通知機能のアップグレードのため、あなたの通知は一時的に利用できません。移行完了までお待ちください。';
$string['notificationimage'] = '通知イメージ';
$string['notificationpreferences'] = '通知プレファレンス';
$string['notifications'] = '通知';
$string['notificationsmarkedasread'] = 'すべての通知が既読マークされました。';
$string['notificationwindow'] = '通知ウィンドウ';
$string['notincontacts'] = 'メッセージを送信するにはあなたのコンタクトに {$a} を追加する必要があります。';
$string['notincontactsheading'] = 'あなたのコンタクトに {$a} は登録されていません。';
$string['notsupported'] = '未対応';
$string['numparticipants'] = '{$a} 参加者';
$string['off'] = 'Off';
$string['offline'] = 'オフライン';
$string['on'] = 'On';
$string['online'] = 'オンライン';
$string['otherparticipants'] = '他の参加者';
$string['outputnotavailable'] = '利用不可';
$string['page-message-x'] = 'すべてのメッセージページ';
$string['participants'] = '参加者';
$string['pendingcontactrequests'] = '{$a} 件の保留コンタクトリクエストがあります。';
$string['permitted'] = '許可';
$string['privacy'] = 'プライバシー';
$string['privacy:export:conversationprefix'] = '会話:';
$string['privacy:metadata:core_favourites'] = 'ユーザにより星が付けられた会話';
$string['privacy:metadata:message_contact_requests'] = 'コンタクトリクエスト一覧です。';
$string['privacy:metadata:message_contact_requests:requesteduserid'] = 'コンタクトリクエストを受信したユーザのIDです。';
$string['privacy:metadata:message_contact_requests:timecreated'] = 'コンタクトリクエストが作成された日時です。';
$string['privacy:metadata:message_contact_requests:userid'] = 'コンタクトリクエストを送信したユーザのIDです。';
$string['privacy:metadata:message_contacts'] = 'コンタクト一覧です。';
$string['privacy:metadata:message_contacts:contactid'] = 'コンタクトのユーザのIDです。';
$string['privacy:metadata:message_contacts:timecreated'] = 'コンタクトが作成された日時です。';
$string['privacy:metadata:message_contacts:userid'] = '私たちが閲覧しているコンタクト一覧のユーザのIDです。';
$string['privacy:metadata:message_conversation_actions'] = '会話ユーザアクション一覧';
$string['privacy:metadata:message_conversation_actions:action'] = '実行されたアクション';
$string['privacy:metadata:message_conversation_actions:conversationid'] = 'このアクションが属する会話ID';
$string['privacy:metadata:message_conversation_actions:timecreated'] = 'アクションが作成された時間';
$string['privacy:metadata:message_conversation_actions:userid'] = 'このアクションを実行したユーザのID';
$string['privacy:metadata:message_conversation_members'] = '会話のユーザの一覧です。';
$string['privacy:metadata:message_conversation_members:conversationid'] = '会話のIDです。';
$string['privacy:metadata:message_conversation_members:timecreated'] = 'メンバが作成された日時です。';
$string['privacy:metadata:message_conversation_members:userid'] = '会話のユーザのIDです。';
$string['privacy:metadata:message_user_actions'] = 'メッセージ一覧のユーザのアクションです。';
$string['privacy:metadata:message_user_actions:action'] = '実行されたアクションです。';
$string['privacy:metadata:message_user_actions:messageid'] = 'このアクションが属するメッセージのIDです。';
$string['privacy:metadata:message_user_actions:timecreated'] = 'アクションが作成された日時です。';
$string['privacy:metadata:message_user_actions:userid'] = 'このアクションを実行したユーザのIDです。';
$string['privacy:metadata:message_users_blocked'] = 'ブロック済みユーザ一覧です。';
$string['privacy:metadata:message_users_blocked:blockeduserid'] = 'ブロックされたユーザのIDです。';
$string['privacy:metadata:message_users_blocked:timecreated'] = 'ブロックアクションが作成された日時です。';
$string['privacy:metadata:message_users_blocked:userid'] = 'ブロックアクションが実行されたユーザのIDです。';
$string['privacy:metadata:messages'] = 'メッセージです。';
$string['privacy:metadata:messages:conversationid'] = '会話のIDです。';
$string['privacy:metadata:messages:customdata'] = 'カスタムデータです。通常、内部IDおよび送信者イメージ (ユーザまたはグループ) のパブリックURLを含みます。';
$string['privacy:metadata:messages:fullmessage'] = '完全なメッセージです。';
$string['privacy:metadata:messages:fullmessageformat'] = '完全なメッセージのフォーマットです。';
$string['privacy:metadata:messages:fullmessagehtml'] = '完全なメッセージのHTMLフォーマットです。';
$string['privacy:metadata:messages:smallmessage'] = 'メッセージのスモールバージョンです。';
$string['privacy:metadata:messages:subject'] = 'メッセージの件名です。';
$string['privacy:metadata:messages:timecreated'] = 'メッセージが作成された日時です。';
$string['privacy:metadata:messages:useridfrom'] = 'メッセージを送信したユーザのIDです。';
$string['privacy:metadata:notifications'] = '通知です。';
$string['privacy:metadata:notifications:component'] = '通知を送信するコンポーネントです。';
$string['privacy:metadata:notifications:contexturl'] = 'この通知に関連するURLです。';
$string['privacy:metadata:notifications:contexturlname'] = 'コンテクスト名です。';
$string['privacy:metadata:notifications:customdata'] = 'カスタムデータです。通常、内部IDおよび送信者画像 (ある場合) のパブリックURLを含みます。';
$string['privacy:metadata:notifications:eventtype'] = 'イベントタイプです。';
$string['privacy:metadata:notifications:fullmessage'] = '完全な通知です。';
$string['privacy:metadata:notifications:fullmessageformat'] = '通知フォーマットです。';
$string['privacy:metadata:notifications:fullmessagehtml'] = '通知のHTMLです。';
$string['privacy:metadata:notifications:smallmessage'] = '通知のスモールメッセージです。';
$string['privacy:metadata:notifications:subject'] = '通知の件名です。';
$string['privacy:metadata:notifications:timecreated'] = '通知が作成された日時です。';
$string['privacy:metadata:notifications:timeread'] = '通知が読まれた日時です。';
$string['privacy:metadata:notifications:useridfrom'] = '通知を送信したユーザのDです。';
$string['privacy:metadata:notifications:useridto'] = '通知を受信したユーザのIDです。';
$string['privacy:metadata:preference:core_message_settings'] = 'メッセージングに関連する設定です。';
$string['privacy:request:preference:set'] = '設定「 {$a->name} 」の値は「 {$a->value} 」でした。';
$string['privacy_desc'] = 'あなたにメッセージを送信する人を制限できます。';
$string['processorsettings'] = 'プロセッサ設定';
$string['providerenabled'] = '「 {$a} 」有効ステータスを送信する';
$string['providerprocesorisdisallowed'] = '「 {$a->processor} 」の「 {$a->provider} 」はロック解除されています。';
$string['providerprocesorislocked'] = '「 {$a->processor} 」の「 {$a->provider} 」はロックされています。';
$string['removecontact'] = 'コンタクトから削除する';
$string['removecontactconfirm'] = '本当にあなたのコンタクトから {$a} を削除してもよろしいですか?';
$string['removecoursefilter'] = 'コース {$a} のフィルタを削除する';
$string['removefromfavourites'] = '会話から星を解除する';
$string['removefromyourcontacts'] = 'コンタクトから削除する';
$string['requirecontacttomessage'] = 'あなたがメッセージを送信できるようにするには {$a} にコンタクトへの追加をリクエストする必要があります。';
$string['requiresconfiguration'] = '要設定';
$string['searchcombined'] = '人およびメッセージを検索する';
$string['searchforuser'] = 'ユーザを検索する';
$string['searchforuserorcourse'] = 'ユーザまたはコースを検索する';
$string['searchmessages'] = 'メッセージを検索する';
$string['seeall'] = 'すべてを表示する';
$string['selectmessagestodelete'] = '削除するメッセージを選択する';
$string['selectnotificationtoview'] = '詳細を表示するには横の通知一覧から選択してください。';
$string['selfconversation'] = 'パーソナルスペース';
$string['selfconversationdefaultmessage'] = '後でアクセスするため、下書きメッセージ、リンク、ノート等を保存します。';
$string['send'] = '送信';
$string['sendbulkmessage'] = '{$a} 名にメッセージを送信する';
$string['sendbulkmessagesent'] = '{$a} 名にメッセージが送信されました。';
$string['sendbulkmessagesentsingle'] = '1 名にメッセージが送信されました。';
$string['sendbulkmessagesingle'] = '1 名にメッセージを送信する';
$string['sendcontactrequest'] = 'コンタクトリクエストを送信する';
$string['sender'] = '{$a}:';
$string['sendingviaenabled'] = '「 {$a->processor} 」経由で「 {$a->provider} 」有効ステータスを送信する';
$string['sendingvialocked'] = '「 {$a->processor} 」経由で「 {$a->provider} 」ロックステータスを送信する';
$string['sendmessage'] = 'メッセージを送信する';
$string['sendmessageto'] = '{$a} にメッセージを送信する';
$string['sendmessagetopopup'] = '{$a} にメッセージを送信する - 新しいウィンドウ';
$string['settings'] = '設定';
$string['showmessagewindownonew'] = '新しいメッセージのないメッセージウィンドウを表示する';
$string['showmessagewindowwithcount'] = '{$a} 件の新しいメッセージのあるメッセージウィンドウを表示する';
$string['shownotificationwindownonew'] = '新しい通知のない通知ウィンドウを表示する';
$string['shownotificationwindowwithcount'] = '{$a} 件の新しい通知のある通知ウィンドウを表示する';
$string['successproviderenabled'] = '「 {$a->provider} 」の「 {$a->processor} 」が更新されました。';
$string['successproviderlocked'] = '「 {$a->provider} 」の「 {$a->processor} 」がロックされました。';
$string['successproviderunlocked'] = '「 {$a->provider} 」の「 {$a->processor} 」がロック解除されました。';
$string['successproviderupdate'] = '「 {$a} 」が更新されました。';
$string['togglemessagemenu'] = 'メッセージドロワに切り替える';
$string['togglenotificationmenu'] = '通知メニューに切り替える';
$string['totalconversations'] = '{$a} 合計会話数';
$string['touserdoesntexist'] = 'あなたは存在しないユーザID ({$a}) にメッセージを送信できません。';
$string['unabletomessage'] = 'あなたはこのユーザにメッセージを送信できません。';
$string['unblock'] = 'ブロック解除';
$string['unblockcontact'] = 'コンタクトの拒否を解除する';
$string['unblockuser'] = 'ユーザのブロックを解除する';
$string['unblockuserconfirm'] = '本当に {$a} をブロック解除してもよろしいですか?';
$string['unknownuser'] = '不明なユーザです。';
$string['unmuteconversation'] = 'ミュート解除';
$string['unreadconversations'] = '{$a} 件の未読会話があります。';
$string['unreadmessages'] = '{$a} 件の未読メッセージがあります。';
$string['unreadnewgroupconversationmessage'] = '{$a->conversationname} 内の {$a->name} からの新しいメッセージ';
$string['unreadnewmessage'] = '{$a} からの新しいメッセージ';
$string['unreadnotification'] = '未読通知: {$a}';
$string['unreadnotifications'] = '{$a} 件の未読通知があります。';
$string['unsentmessagenotification'] = 'あなたには未送信のメッセージがあります。あなたがこのページを離れた場合、メッセージは消えてしまいます。';
$string['useentertosend'] = 'Enterで送信する';
$string['usercantbemessaged'] = 'ユーザのメッセージプレファレンスのため、あなたはこのユーザにメッセージを送信できません。連絡先として追加してみてください。';
$string['userwouldliketocontactyou'] = '{$a} があなたにコンタクトしたいようです。';
$string['viewfullnotification'] = '通知詳細を表示する';
$string['viewmessageswith'] = '{$a} のメッセージを表示する';
$string['viewnotificationresource'] = '移動する: {$a}';
$string['viewunreadmessageswith'] = '{$a} の未読メッセージを表示する';
$string['waitingforcontactaccept'] = '連絡先への追加を待っています。';
$string['wouldliketocontactyou'] = 'あなたへのコンタクト希望';
$string['writeamessage'] = 'メッセージを書く ...';
$string['you'] = 'あなた:';
$string['youhaveblockeduser'] = 'あなたはこのユーザをブロックしました。';
$string['yourcontactrequestpending'] = 'あなたのコンタクトリクエストは {$a} により保留されています。';
