<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'pl', version '5.0'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akcje';
$string['activate'] = 'Włącz dostęp';
$string['activatesuccess'] = 'Dostęp do odznaki \'{$a}\' włączony.';
$string['addalignment'] = 'Dodaj umiejętności zewnętrzne lub standard';
$string['addbadge'] = 'Dodaj odznaki';
$string['addbadge_help'] = 'Wybierz wszystkie odznaki, które powinny zostać dodane do tego wymogu. Przytrzymaj klawisz CTRL, aby wybrać wiele pozycji.';
$string['addbadgecriteria'] = 'Dodaj kryteria odznak';
$string['addcohort'] = 'Dodaj kohortę';
$string['addcohort_help'] = 'Wybierz wszystkie odznaki, które powinny zostać dodane do tego wymogu. Przytrzymaj klawisz CTRL, aby wybrać wiele pozycji.';
$string['addcompetency'] = 'Dodaj kompetencje';
$string['addcompetency_help'] = 'Wybierz wszystkie kompetencje, które należy dodać do wymagań tej odznaki. Przytrzymaj klawisz CTRL, aby wybrać wiele elementów.';
$string['addcourse'] = 'Dodaj kursy';
$string['addcourse_help'] = 'Wybierz wszystkie kursy, które powinny zostać dodane do tego wymagania odznaki. Przytrzymaj klawisz CTRL aby wybrać wiele pozycji.';
$string['addcriteria'] = 'Dodaj kryteria';
$string['addcriteriatext'] = 'Aby rozpocząć dodawanie kryteriów, wybierz jedną z opcji z menu rozwijanego.';
$string['addedtobackpack'] = 'Dodaj odznakę do plecaka';
$string['addrelated'] = 'Dodaj powiązaną odznakę';
$string['addtobackpack'] = 'Dodaj do plecaka';
$string['adminonly'] = 'Ta strona przeznaczona jest tylko dla administratorów.';
$string['after'] = 'od daty wystawienia.';
$string['aggregationmethod'] = 'Metoda agregacji';
$string['alignment'] = 'Dostosowanie';
$string['all'] = 'Wszystkie';
$string['allmethod'] = 'Wszystkie wybrane warunki są spełnione';
$string['allmethodactivity'] = 'Wszystkie wybrane aktywności zostały ukończone';
$string['allmethodbadges'] = 'Wszystkie wybrane odznaki zostały zdobyte';
$string['allmethodcohort'] = 'Członkostwo we wszystkich wybranych kohortach';
$string['allmethodcompetencies'] = 'Wszystkie wybrane kompetencje zostały ukończone';
$string['allmethodcourseset'] = 'Wszystkie wybrane kursy są kompletne';
$string['allmethodmanual'] = 'Wszystkie wybrane role przyznają odznakę';
$string['allmethodprofile'] = 'Wszystkie wybrane pola profilu zostały wypełnione';
$string['allowcoursebadges'] = 'Włącz odznaki kursu';
$string['allowcoursebadges_desc'] = 'Pozwól na tworzenie i przyznawanie odznak w ramach kursu';
$string['allowexternalbackpack'] = 'Połączenie do zewnętrznych plecaków';
$string['allowexternalbackpack_desc'] = 'Zezwalaj użytkownikom na stworzenie połączenia i wyświetlanie odznak z ich zewnętrznymi dostawcami plecaków. Uwaga: Zaleca się, aby pozostawić tę opcję wyłączoną, jeśli strona nie jest dostępna w Internecie (np. ze względu na zaporę sieciową).';
$string['any'] = 'Dowolne';
$string['anymethod'] = 'Dowolny z wybranych warunków jest spełniony';
$string['anymethodactivity'] = 'Dowolne z wybranych aktywności zostały ukończone';
$string['anymethodbadges'] = 'Dowolne wybrane odznaki zostały zdobyte';
$string['anymethodcohort'] = 'Członkostwo w dowolnej z wybranych kohort';
$string['anymethodcompetencies'] = 'Każda z wybranych kompetencji została ukończona';
$string['anymethodcourseset'] = 'Dowolny z wybranych kursów jest zakończony';
$string['anymethodmanual'] = 'Dowolna z wybranych ról nagradza odznaką';
$string['anymethodprofile'] = 'Cokolwiek z wybranych pól profilu zostało wypełnione';
$string['apiversion'] = 'Obsługiwana wersja interfejsu API';
$string['archivebadge'] = 'Chcesz usunąć odznakę "{$a}", zachowując te dotychczas przyznane?';
$string['archiveconfirm'] = 'Usuń i zachowaj dotychczas przyznane odznaki';
$string['archivehelp'] = '<p>Ta opcja oznacza, że odznaka zostanie oznaczona jako "wycofana" i nie będzie dłużej pojawiać się na liście odznaczeń. Użytkownicy nie będą mogli dłużej zdobyć tej odznaki, jednakże ci, którzy zdobyli tą odznakę, będą mogli ją wyświetlać na swoich stronach profilowych i umieszczać w zewnętrznych plecakach.</p>
<p>Jeżeli chcesz aby twoi użytkownicy mieli dostęp do zdobytych odznak, ważne jest wybranie tej opcji zamiast pełnego usuwania.</p>';
$string['attachment'] = 'Dołącz odznakę do wiadomości';
$string['attachment_help'] = 'Jeśli ta opcja jest włączona, do wiadomości e-mail odbiorcy zostanie dołączona odznaka do pobrania. (Załączniki muszą być włączone w Administracja serwisu/Serwer/Email/Konfiguracja poczty wychodzącej, aby użyć tej opcji).';
$string['award'] = 'Przyznaj odznakę';
$string['awardedto'] = 'Przyznane dla {$a}';
$string['awardedtoyou'] = 'Przyznano mi';
$string['awardoncron'] = 'Duża liczba użytkowników otrzymuje odznakę \'{$a->badgename}\'. Może minąć trochę czasu, zanim wszyscy użytkownicy ją otrzymają.';
$string['awards'] = 'Beneficjenci';
$string['backpackapiurl'] = 'URL API plecaka';
$string['backpackavailability'] = 'Zewnętrzna weryfikacja odznaki';
$string['backpackavailability_help'] = 'Aby odbiorcy mogli udowodnić, że zdobyli od Ciebie odznaki, zewnętrzny serwis plecakowy powinien mieć możliwość dostępu do Twojej strony i weryfikacji przyznanych odznak. Twoja strona nie wydaje się obecnie dostępna, co oznacza, że odznaki, które już przyznałeś lub będziesz przyznawać w przyszłości, nie mogą być zweryfikowane.

**Dlaczego widzę tę wiadomość?**

Może się zdarzyć, że Twój firewall uniemożliwi dostęp użytkownikom spoza Twojej sieci, Twoja strona będzie chroniona hasłem, lub uruchomisz stronę na komputerze, który nie jest dostępny z Internetu (np. lokalnej maszynie rozwojowej).

**Czy jest to problem?**

Powinieneś rozwiązać ten problem na każdej produkcyjnej stronie, na której planujesz przyznawać odznaki. W przeciwnym razie odbiorcy nie będą w stanie udowodnić, że zdobyli u Ciebie swoje odznaki. Jeśli Twoja strona nie jest jeszcze na żywo, możesz tworzyć i przyznawać odznaki testowe, pod warunkiem, że strona jest dostępna zanim przejdziesz na żywo.

**Co zrobić, jeśli nie mogę sprawić, że cała moja strona będzie publicznie dostępna?**

Jedynym adresem URL wymaganym do weryfikacji jest [your-site-url]/badges/assertion.php, więc jeśli jesteś w stanie zmodyfikować swój firewall, aby umożliwić dostęp do tego pliku z zewnątrz, weryfikacja identyfikatora będzie nadal działać.';
$string['backpackbadgessettings'] = 'Zmień ustawienia plecaka';
$string['backpackbadgessummary'] = 'Masz {$a->totalbadges} odznak z {$a->totalcollections} kolekcji';
$string['backpackcannotsendverification'] = 'Wysyłanie e-maila weryfikującego nie powiodło się';
$string['backpackconnected'] = 'Plecak jest podłączony';
$string['backpackconnection'] = 'Połącz z plecakiem';
$string['backpackconnection_connected'] = 'Twój plecak';
$string['backpackconnection_help'] = 'Możesz przechowywać i udostępniać w swoim profilu odznaki uzyskane na tej witrynie a także wyświetlać odznaki dostępne publicznie uzyskane na innych stronach WWW.';
$string['backpackconnectioncancelattempt'] = 'Połącz się przy użyciu innego adresu e-mail';
$string['backpackconnectionconnect'] = 'Połącz z plecakiem';
$string['backpackconnectionnottested'] = 'Nie można przetestować połączenia do tego plecaka, ponieważ obsługiwane są tylko plecaki w systemie Open Badges v2.0.';
$string['backpackconnectionok'] = 'Połączenie z plecakiem zakończone sukcesem';
$string['backpackconnectionresendemail'] = 'Wyślij wiadomość weryfikującą ponownie';
$string['backpackconnectionunexpectedmessage'] = 'Plecak zwrócił błąd: "{$a}”.';
$string['backpackconnectionunexpectedresult'] = 'Podczas łączenia z plecakiem wystąpił problem. Zewnętrzny dostawca plecaka wysyła taki komunikat: \'{$a}\'.';
$string['backpackdetails'] = 'Ustawienia plecaka';
$string['backpackdisconnected'] = 'Plecak nie jest podłączony';
$string['backpackemail_required'] = 'Adres e-mail nie może być pusty';
$string['backpackemailverificationpending'] = 'Oczekiwanie na weryfikację';
$string['backpackemailverifyemailbody'] = 'Witaj {$a->userfirstname},

Prawie skończyłeś łączyć się z plecakiem na odznaki na \'{$a->sitename}\'.

Aby zakończyć łączenie się z plecakiem, zweryfikuj swój adres e-mail za pomocą poniższego przycisku:

{$a->buttonlink}

Jeśli przycisk nie działa, możesz skopiować i wkleić następujący adres URL do swojej przeglądarki:
{$a->link}


Jeśli nie próbowałeś połączyć się z plecakiem na odznaki, możesz bezpiecznie zignorować tę wiadomość.

Aby uzyskać dodatkową pomoc, skontaktuj się z obsługą witryny,

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Weryfikacja e-mail plecaka.';
$string['backpackemailverifypending'] = 'E-mail z prośbą o weryfikację został wysłany na adres <strong>{$a}</strong>. Kliknij w link w wiadomości e-mail, aby aktywować połączenie z plecakiem.';
$string['backpackemailverifysuccess'] = 'Masz teraz połączenie z plecakiem.';
$string['backpackemailverifytokenmismatch'] = 'Token w klikniętym łączu nie pasuje do zapisanego w pamięci. Upewnij się, że kliknąłeś link w ostatnio otrzymanej wiadomości e-mail.';
$string['backpackexporterror'] = 'Nie można wyeksportować odznaki do plecaka';
$string['backpackexporterrorwithinfo'] = 'Nie można wyeksportować odznaki „{$a->badgename}” do plecaka. Błąd: {$a->error}';
$string['backpackimport'] = 'Ustawienia importu odznak';
$string['backpackimport_help'] = 'Po pomyślnym nawiązaniu połączenia z plecakiem, odznaki z plecaka mogą być wyświetlane na stronie z odznakami i na stronie profilu.

W tym obszarze możesz wybrać kolekcje odznak z plecaka, które chciałbyś wyświetlić w swoim profilu.';
$string['backpackprovider'] = 'Zewnętrzny dostawca plecaka';
$string['backpacksettings'] = 'Ustawienia plecaka';
$string['backpackweburl'] = 'URL plecaka';
$string['badgedetails'] = 'Szczegóły odznaki';
$string['badgeimage'] = 'Obraz';
$string['badgeimage_help'] = 'Rozmiar obrazu powinien wynosić co najmniej 300 x 300 pikseli. Będzie wyświetlany w rozmiarze 300 x 300 pikseli na stronie odznaki i 100 x 100 pikseli na stronie profilu użytkownika.';
$string['badgeimageinfo'] = 'Aby uzyskać najlepsze wyniki, prześlij kwadratowy obraz o minimalnym rozmiarze 300 x 300 pikseli.';
$string['badgeissued'] = 'Wydana odznak';
$string['badgeprivacysetting'] = 'Ustawienia prywatności odznak';
$string['badgeprivacysetting_help'] = 'Zdobyte odznaki można wyświetlić na stronie profilu konta. To ustawienie pozwala automatycznie ustawić widoczność nowo zdobytych odznak.

Nadal możesz kontrolować indywidualne ustawienia prywatności na stronie odznak.';
$string['badgeprivacysetting_str'] = 'Automatyczne wyświetl odznaki, które zdobyłem, na mojej stronie profilu';
$string['badges'] = 'Odznaki';
$string['badgesalt'] = 'Sól do mieszania adresu e-mail odbiorcy';
$string['badgesalt_desc'] = 'Użycie kodowania pozwala usłudze plecaka na potwierdzanie zdobytych odznak bez konieczności ujawnienia adresów email posiadacza. To ustawienie powinno używać tylko cyfr i liter.

Uwaga: w celu weryfikacji odbiorcy należy unikać zmiany tego ustawienia po rozpoczęciu wydawania odznak.';
$string['badgesdisabled'] = 'Odznaki nie są włączone na tej stronie.';
$string['badgesearned'] = 'Liczba zdobytych odznak: {$a}';
$string['badgesettings'] = 'Ustawienia odznak';
$string['badgestatus_0'] = 'Niedostępne';
$string['badgestatus_1'] = 'Dostępne';
$string['badgestatus_2'] = 'Niedostępne (kryteria zablokowane)';
$string['badgestatus_3'] = 'Dostępne (kryteria zablokowane)';
$string['badgestatus_4'] = 'Zarchiwizowany';
$string['badgestoearn'] = 'Liczba dostępnych odznak: {$a}';
$string['badgesview'] = 'Odznaki kursu';
$string['badgetags'] = 'Tagi odznak';
$string['badgeurl'] = 'Link przyznanej odznaki';
$string['balignment'] = 'Dostosowania {{$a}}';
$string['bawards'] = 'Beneficjenci ({$a})';
$string['bcriteria'] = 'Kryteria';
$string['bdetails'] = 'Edytuj szczegóły';
$string['bendorsement'] = 'Adnotacja';
$string['bmessage'] = 'Wiadomość';
$string['boverview'] = 'Przegląd';
$string['brelated'] = 'Powiązane odznaki ({$a})';
$string['bydate'] = 'ukończone do';
$string['claim'] = 'Wniosek';
$string['claimcomment'] = 'Komentarz do zatwierdzenia';
$string['claimid'] = 'URL wniosku';
$string['clearsettings'] = 'Wyczyść ustawienia';
$string['completioninfo'] = 'Ta odznaka została przyznana za ukończenie:';
$string['completionnotenabled'] = 'Ukończenie kursu nie jest włączone w tym kursie, więc nie można go uwzględnić w kryteriach odznaki. W ustawieniach kursu można włączyć ukończenie kursu.';
$string['configenablebadges'] = 'Kiedy ta funkcja jest włączona, umożliwia tworzenie odznak i przyznawanie ich użytkownikom witryny.';
$string['configuremessage'] = 'Wiadomość odznaki';
$string['connect'] = 'Połącz';
$string['connected'] = 'Połączono';
$string['connecting'] = 'Łączenie ...';
$string['contact'] = 'Email';
$string['contact_help'] = 'Adres e-mail powiązany z wydawcą odznaki.';
$string['copy'] = 'Kopiuj';
$string['copyof'] = 'Kopia {$a}';
$string['course'] = 'Kurs: {$a}';
$string['coursebadges'] = 'Odznaki';
$string['coursebadgesdisabled'] = 'Odznaki kursu nie są włączone na tej stronie.';
$string['coursebadgetitle'] = 'Odznaka kursu {$a}';
$string['coursecompletion'] = 'Użytkownicy muszą ukończyć ten kurs.';
$string['create'] = 'Nowa odznaka';
$string['createbutton'] = 'Utwórz odznakę';
$string['creatorbody'] = '<p>{$a->user} ukończył wszystkie wymagania i został wyróżniony odznaką. Zobacz przyznaną odznakę na {$a->link}</p>';
$string['creatorsubject'] = '\'{$a}\' został(a) nagrodzony(a)!';
$string['criteria_0'] = 'Ta odznaka jest przyznawana, gdy ..';
$string['criteria_1'] = 'Ukończenie aktywności';
$string['criteria_1_help'] = 'Umożliwia przyznanie odznaki użytkownikom w oparciu o ukończenie zestawu aktywności w ramach kursu.';
$string['criteria_2'] = 'Ręczne przyznanie przez rolę';
$string['criteria_2_help'] = 'Umożliwia ręczne przyznawanie odznaki przez użytkowników, którzy mają określoną rolę w witrynie lub kursie.';
$string['criteria_3'] = 'Udział społeczny';
$string['criteria_3_help'] = 'Społeczny';
$string['criteria_4'] = 'Ukończenie kursu';
$string['criteria_4_help'] = 'Umożliwia przyznanie odznaki użytkownikom, którzy ukończyli kurs. To kryterium może mieć dodatkowe parametry, takie jak minimalna ocena i data ukończenia kursu.';
$string['criteria_5'] = 'Ukończenie zestawu kursów';
$string['criteria_5_help'] = 'Umożliwia przyznanie odznaki użytkownikom, którzy ukończyli zestaw kursów. Każdy kurs może mieć dodatkowe parametry, takie jak minimalna ocena i data ukończenia kursu.';
$string['criteria_6'] = 'Ukończenie profilu';
$string['criteria_6_help'] = 'Umożliwia przyznanie odznaki użytkownikom za wypełnienie określonych pól w swoim profilu. Możesz wybrać domyślne i niestandardowe pola profilu, które są dostępne dla użytkowników.';
$string['criteria_7'] = 'Przyznane odznaki';
$string['criteria_7_help'] = 'Umożliwia przyznanie odznaki użytkownikom na podstawie innych zdobytych odznak.';
$string['criteria_8'] = 'Członkostwo w kohorcie';
$string['criteria_8_help'] = 'Umożliwia przyznanie odznaki użytkownikom na podstawie członkostwa kohortowego.';
$string['criteria_9'] = 'Kompetencje';
$string['criteria_9_help'] = 'Umożliwia przyznanie odznaki użytkownikom na podstawie posiadanych kompetencji.';
$string['criteria_descr'] = 'Użytkownicy otrzymują tę odznakę po spełnieniu następujących wymogów:';
$string['criteria_descr_0'] = 'Należy spełnić <strong>{$a</strong> z wymienionych wymagań.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> z następujących aktywności są ukończone:';
$string['criteria_descr_2'] = 'Ta odznaka może być przyznawana przez użytkowników <strong>{$a}</strong> z poniższymi rolami:';
$string['criteria_descr_4'] = 'Użytkownicy muszą ukończyć kurs';
$string['criteria_descr_5'] = '<strong>{$a}</strong> następujących kursów musi być ukończone:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> z następujących pól w profilu użytkownika musi być kompletne:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> odznak musi zostać zdobytych:';
$string['criteria_descr_8'] = 'Wymagane jest członkostwo w <strong>{$a}</strong> kohortach:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> z wymienionych kompetencji należy uzuepłnić:';
$string['criteria_descr_bydate'] = 'do <em>{$a}</em>';
$string['criteria_descr_grade'] = 'z minimalną oceną <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Ukończono <strong>{$a}</strong> z:';
$string['criteria_descr_short1'] = 'Ukończono <strong>{$a}</strong> z:';
$string['criteria_descr_short2'] = 'Przyznawany przez <strong>{$a}</strong> z:';
$string['criteria_descr_short4'] = 'Ukończony kurs';
$string['criteria_descr_short5'] = 'Ukończono <strong>{$a}</strong> z:';
$string['criteria_descr_short6'] = 'Ukończono <strong>{$a}</strong> z:';
$string['criteria_descr_short7'] = 'Spełnione <strong>{$a}</strong> z:';
$string['criteria_descr_short8'] = 'Członkostwo kohortowe w <strong>{$a}</strong> z:';
$string['criteria_descr_short9'] = 'Uzupełnij <strong> {$a} </strong> z:';
$string['criteria_descr_single_1'] = 'Następująca aktywność musi być ukończona:';
$string['criteria_descr_single_2'] = 'Odznaka ta musi być przyznana przez użytkownika z następującą rolą:';
$string['criteria_descr_single_4'] = 'Użytkownicy muszą ukończyć kurs';
$string['criteria_descr_single_5'] = 'Następujące kursy muszą być ukończone:';
$string['criteria_descr_single_6'] = 'Poniższe pole w profilu użytkownika musi być wypełnione:';
$string['criteria_descr_single_7'] = 'Musisz zdobyć następującą odznakę:';
$string['criteria_descr_single_8'] = 'Wymagane jest członkostwo w następującej kohorcie:';
$string['criteria_descr_single_9'] = 'Należy uzupełnić następujące kompetencje:';
$string['criteria_descr_single_short1'] = 'Ukończony:';
$string['criteria_descr_single_short2'] = 'Przyznawane przez:';
$string['criteria_descr_single_short4'] = 'Ukończony kurs';
$string['criteria_descr_single_short5'] = 'Ukończone:';
$string['criteria_descr_single_short6'] = 'Ukończone:';
$string['criteria_descr_single_short7'] = 'Ukończono:';
$string['criteria_descr_single_short8'] = 'Członkostwo w:';
$string['criteria_descr_single_short9'] = 'Uzupełnij:';
$string['criteriacreated'] = 'Pomyślnie utworzono kryteria odznaki';
$string['criteriadeleted'] = 'Pomyślnie skasowano kryteria odznaki';
$string['criteriasummary'] = 'Podsumowanie kryteriów';
$string['criteriaupdated'] = 'Pomyślnie zaktualizowano kryteria odznaki';
$string['criterror'] = 'Aktualne problemy parametrów';
$string['criterror_help'] = 'Ten zestaw pól pokazuje wszystkie parametry, które zostały początkowo dodane do tych wymagań odznaki, ale nie są dłużej dostępne. Jest zalecane, abyś odznaczył takie parametry, aby mieć pewność, że użytkownicy będą mogli w przyszłości otrzymać tą odznakę.';
$string['currentimage'] = 'Aktualny obraz';
$string['currentstatus'] = 'Aktualny status';
$string['dateawarded'] = 'Data przyznania';
$string['dateearned'] = 'Data: {$a}';
$string['day'] = 'Dzień/dni';
$string['deactivate'] = 'Wyłącz dostęp';
$string['deactivatesuccess'] = 'Dostęp do odznaki \'{$a}\' jest wyłączony.';
$string['defaultissuercontact'] = 'Adres e-mail wystawcy odznaki';
$string['defaultissuercontact_desc'] = 'Adres e-mail powiązany z wydawcą odznaki. W przypadku plecaka Open Badges v2.0 służy do uwierzytelniania podczas publikowania odznak w plecaku.';
$string['defaultissuername'] = 'Nazwa wystawcy odznaki';
$string['defaultissuername_desc'] = 'Imię i nazwisko agenta lub nazwa organu wydającego.';
$string['defaultissuerpassword'] = 'Hasło wystawcy odznaki';
$string['defaultissuerpassword_help'] = 'Wymagane jest konto na stronie plecaka z adresem e-mail określonym w ustawieniu „Adres e-mail wystawcy odznaki” w Ustawieniach Administracja witryny / Odznaki / Ustawienia odznak. W tym miejscu należy wpisać hasło do konta.';
$string['delbadge'] = 'Chcesz usunąć odznakę "{$a}" wraz ze wszystkimi dotychczas przyznanymi?';
$string['delconfirm'] = 'Usuń dotychczas przyznane odznaki';
$string['delcritconfirm'] = 'Czy jesteś pewien, że chcesz usunąć to kryterium?';
$string['deletehelp'] = '<p>Pełne skasowanie odznaki oznacza, że wszystkie informacje i rekordy kryterium na jej temat zostaną bezpowrotnie usunięte. Użytkownicy, którzy zdobyli tę odznakę nie będą mieli do niej dostępu.</p>
<p>Uwaga: Użytkownicy, którzy zdobyli tę odznakę i mają umieszczoną ją w zewnętrznym plecaku, nadal mają dostęp do tej odznaki w tym plecaku. Nie będą oni jednak mogli uzyskać dostępu do stron z kryteriami i dowodami, które prowadzą do tej strony.</p>';
$string['delexternalbackpack'] = 'Usuń plecak witryny';
$string['delexternalbackpackconfirm'] = 'Czy usunąć plecak witryny \'{$a}\'?';
$string['delparamconfirm'] = 'Czy jesteś pewien, że chcesz usunąć ten parametr?';
$string['description'] = 'Opis';
$string['descriptioninfo'] = 'Co przedstawia ta odznaka?';
$string['disconnect'] = 'Rozłącz';
$string['donotaward'] = 'Obecnie ta odznaka nie jest aktywna, więc nie może być przyznana użytkownikom. Jeśli chcesz przyznać tą odznakę, ustaw jej status na aktywny.';
$string['enablebadges'] = 'Włącz odznaki';
$string['endorsement'] = 'Zatwierdzający';
$string['error:backpackdatainvalid'] = 'Zwrócone dane z plecaka są niepoprawne.';
$string['error:backpackemailnotfound'] = 'Email \'{$a}\'  nie jest przypisany do plecaka. Musisz <a href="http://backpack.openbadges.org">utworzyć plecak</a> dla tego konta lub zalogować się z innym emailem.';
$string['error:badgeawardnotfound'] = 'Nie można zweryfikować przyznanej odznaki. Mogła zostać unieważniona.';
$string['error:badgenotfound'] = 'Nie znaleziony odznaki';
$string['error:cannotact'] = 'Nie można aktywować odznak.';
$string['error:cannotawardbadge'] = 'Nie można przyznać odznaki użytkownikowi.';
$string['error:cannotdeletecriterion'] = 'To kryterium nie może być usunięte.';
$string['error:cannotrevokebadge'] = 'Nie można odebrać odznaki użytkownikowi.';
$string['error:clone'] = 'Nie można sklonować odznaki.';
$string['error:connectionunknownreason'] = 'Połączenie nie powiodło się, ale nie wiadomo z jakiego powodu.';
$string['error:duplicatename'] = 'Odznaka o takiej nazwie już istnieje w systemie.';
$string['error:externalbadgedoesntexist'] = 'Nie znaleziono odznaki';
$string['error:guestuseraccess'] = 'Jesteś zalogowany jako gość. Aby zobaczyć odznaki musisz zalogować się na swoje konto użytkownika.';
$string['error:invalidcriteriatype'] = 'Nieprawidłowy typ kryterium.';
$string['error:invalidexpiredate'] = 'Data ważności musi wskazywać na przyszłość.';
$string['error:invalidexpireperiod'] = 'Okres ważności nie może być wartością ujemną lub równą 0.';
$string['error:invalidparambadge'] = 'Odznaka nie istnieje.';
$string['error:invalidparamcohort'] = 'Kohorta nie istnieje.';
$string['error:noactivities'] = 'Tutaj nie ma aktywności z włączonym kryterium ukończenia w tym kursie.';
$string['error:nobadges'] = 'Nie ma żadnych odznak kursów ani stron z włączonym dostępem, które mogłyby być dodawane jako kryteria.';
$string['error:nocohorts'] = 'Brak kohort';
$string['error:nocourses'] = 'Ukończenie kursu nie jest włączone dla żadnego z kursów na tej stronie, więc nic nie może być wyświetlone. W ustawieniach kursu można włączyć ukończenie kursu.';
$string['error:nogroupslink'] = '<p>Wyświetlane są tylko kolekcje publiczne. <a href="{$a}" target="_blank" rel="nofollow">Odwiedź swój plecak</a>, aby utworzyć kolekcje publiczne.</p>';
$string['error:nogroupssummary'] = '<p>W twoim plecaku nie ma publicznych kolekcji odznak.</p>';
$string['error:nopermissiontoview'] = 'Nie masz uprawnień, aby zobaczyć beneficjentów odznaki.';
$string['error:nosuchbadge'] = 'Odznaka o identyfikatorze {$a} nie istnieje.';
$string['error:nosuchcohort'] = 'Uwaga: Ta kohorta nie jest już dostępna.';
$string['error:nosuchcourse'] = 'Ostrzeżenie: Ten kurs nie jest już dostępny.';
$string['error:nosuchfield'] = 'Ostrzeżenie: To pole profilu użytkownika nie jest już dostępne.';
$string['error:nosuchmod'] = 'Ostrzeżenie: Ta aktywność nie jest już dostępna.';
$string['error:nosuchrole'] = 'Ostrzeżenie: Ta rola nie jest już dostępna.';
$string['error:nosuchuser'] = 'Użytkownik z tym adresem email, nie ma konta u obecnego dostawcy plecaka.';
$string['error:notifycoursedate'] = 'Odznaki powiązane z ukończeniem kursu i aktywności nie będą wydawane do daty rozpoczęcia kursu ({$a}).';
$string['error:parameter'] = 'Ostrzeżenie: co najmniej jeden parametr powinien być wybrany w celu zapewnienia poprawnej pracy wydającego odznakę.';
$string['error:relatedbadgedoesntexist'] = 'Nie ma publicznej odznaki z tym identyfikatorem';
$string['error:requesterror'] = 'Żądanie połączenia nie powiodło się (kod błędu {$a}).';
$string['error:requesttimeout'] = 'Upłynął limit czasu żądania połączenia przed jego wykonaniem.';
$string['error:save'] = 'Nie można zapisać odznaki.';
$string['error:userdeleted'] = '{$a->user} (Ten użytkownik nie istnieje już na {$a->site})';
$string['eventbadgearchived'] = 'Otrzymana odznaka';
$string['eventbadgeawarded'] = 'Odznaka przyznana';
$string['eventbadgecreated'] = 'Utworzona odznaka';
$string['eventbadgecriteriacreated'] = 'Utworzono kryterium odznaki';
$string['eventbadgecriteriadeleted'] = 'Kryteria odznaki usunięte';
$string['eventbadgecriteriaupdated'] = 'Kryteria odznaki zaktualizowane';
$string['eventbadgedeleted'] = 'Odznaka usunięta';
$string['eventbadgedisabled'] = 'Odznaka wyłączona';
$string['eventbadgeduplicated'] = 'Odznaka zduplikowana';
$string['eventbadgeenabled'] = 'Odznaka włączona';
$string['eventbadgelistingviewed'] = 'Wyświetlono listę odznak';
$string['eventbadgerevoked'] = 'Odznaka anulowana';
$string['eventbadgeupdated'] = 'Odznaka zaktualizowana';
$string['eventbadgeviewed'] = 'Odznaka została wyświetlona';
$string['existingrecipients'] = 'Istniejący odbiorcy odznaki';
$string['existsinbackpack'] = 'Odznaka już istnieje w plecaku';
$string['expired'] = 'Wygasła';
$string['expiredate'] = 'Ta odznaka wygasa {$a}.';
$string['expireddate'] = 'Ta odznaka wygasa {$a}.';
$string['expiredin'] = 'Wygasł {$a}';
$string['expireperiod'] = 'Ta odznaka wygasa {$a} dni po wystawieniu.';
$string['expireperiodh'] = 'Ta odznaka wygasa {$a} godzin po wystawieniu.';
$string['expireperiodm'] = 'Ta odznaka wygasa {$a} minut po wystawieniu.';
$string['expireperiods'] = 'Ta odznaka wygasa {$a} sekund po wystawieniu.';
$string['expiresin'] = 'Wygasa {$a}';
$string['expirydate'] = 'Data ważności';
$string['expirydate_help'] = 'Opcjonalnie, odznaki mogą wygasać o określonej dacie, lub dacie obliczonej na podstawie daty przyznania odznaki użytkownikowi.';
$string['externalbackpack_required'] = 'Dostawca plecaka nie może być pusty';
$string['externalbadges'] = 'Moje odznaki z innych stron internetowych';
$string['externalbadges_help'] = 'Ten obszar wyświetla odznaki z twojego zewnętrznego plecaka.';
$string['externalbadgesp'] = 'Odznaki z innych stron internetowych:';
$string['externalconnectto'] = 'Aby wyświetlić zewnętrzne odznaki musisz <a href="{$a}">połączyć się z plecakiem</a>.';
$string['fixed'] = 'Data: ta odznaka wygasa:';
$string['hidden'] = 'Ukryte';
$string['hiddenbadge'] = 'Niestety, właściciel odznaki nie wpisał żadnych informacji.';
$string['hostedurl'] = 'Zewnętrzny adres URL';
$string['hostedurldescription'] = 'Zewnętrzny adres URL, pod którym przechowywana jest odznaka';
$string['imageauthoremail'] = 'E-mail autora grafiki';
$string['imageauthoremail_help'] = 'Jeśli określono, adres e-mail autora grafiki odznaki jest wyświetlany na stronie odznaki.';
$string['imageauthorname'] = 'Imię i nazwisko autora grafiki';
$string['imageauthorname_help'] = 'Jeśli określono, imię i nazwisko autora grafiki odznaki jest wyświetlane na stronie odznaki.';
$string['imageauthorurl'] = 'Adres URL autora grafiki';
$string['imageauthorurl_help'] = 'Jeśli określono, na stronie odznaki zostanie wyświetlony link do strony autora grafiki odznaki. Adres URL powinien mieć prefiks http:// lub https://.';
$string['imagecaption'] = 'Podpis grafiki';
$string['imagecaption_help'] = 'Jeśli określono, podpis grafiki jest wyświetlany na stronie odznaki.';
$string['includeauthdetails'] = 'Dołącz dane uwierzytelniające do plecaka';
$string['invalidurl'] = 'Nieprawidłowy URL';
$string['issuancedetails'] = 'Wygaśnięcie odznaki';
$string['issuedbadge'] = 'Informacje o przyznanej odznace';
$string['issuedby'] = 'Wydane przez {$a}';
$string['issuedon'] = 'Wydane {$a}';
$string['issuerdetails'] = 'Dane wystawcy';
$string['issueremail'] = 'E-mail';
$string['issueremail_help'] = 'Kontaktowy adres e-mail organizacji zatwierdzającej.';
$string['issuername'] = 'Nazwa';
$string['issuername_endorsement'] = 'Zatwierdzający';
$string['issuername_endorsement_help'] = 'Nazwa podmiotu zatwierdzającego.';
$string['issuername_help'] = 'Imię i nazwisko agenta lub nazwa organu wydającego.';
$string['issuerurl'] = 'URL';
$string['issuerurl_help'] = 'Strona internetowa organizacji wydającej zatwierdzenie. Adres URL powinien mieć prefiks http:// lub https://.';
$string['language'] = 'Język';
$string['language_help'] = 'Język używany na stronie odznaki.';
$string['listbackpacks'] = 'Lista plecaków';
$string['localbadges'] = 'Moje odznaki ze strony internetowej {$a}';
$string['localbadgesh'] = 'Moje odznaki z tej strony';
$string['localbadgesh_help'] = 'Wszystkie odznaki na tej stronie są zdobyte przez ukończenie kursów, aktywności w kursie i innych wymagań.

Możesz tutaj zarządzać swoimi odznakami przez stworzenie ich jako odznaki publiczne lub prywatne na swojej stronie profilu.

Możesz ściągnąć wszystkie swoje odznaki lub każdą odznakę oddzielnie i zapisać je na komputerze. Ściągnięte odznaki mogą być dodane do twojej zewnętrznej usługi plecaka.';
$string['localbadgesp'] = 'Odznaki od: {$a}';
$string['localconnectto'] = 'Aby udostępnić te odznaki na zewnątrz tej strony musisz <a href="{$a}">połączyć się z plecakiem</a>.';
$string['loginbackpacktitle'] = '<strong>Zaloguj się do swojego plecaka</strong>';
$string['makeprivate'] = 'Zrób prywatne';
$string['makepublic'] = 'Zrób publiczne';
$string['managebackpacks'] = 'Zarządzaj plecakami';
$string['managebadges'] = 'Zarządzaj odznakami';
$string['message'] = 'Treść wiadomości';
$string['messagebody'] = '<p>Otrzymałeś odznakę "%badgename%"!</p>
<p>Więcej informacji możesz znaleźć na stronie odznaki %badgelink%.</p>
<p>Możesz zarządzać i pobrać odznakę ze strony {$a}.</p>';
$string['messagesubject'] = 'Gratulacje! Właśnie zdobyłeś odznakę!';
$string['method'] = 'To kryterium jest spełnione, gdy...';
$string['mingrade'] = 'Minimalna wymagana ocena';
$string['month'] = 'Miesiąc(e)';
$string['moredetails'] = 'Więcej szczegółów';
$string['mybackpack'] = 'Moje ustawienia plecaka';
$string['mybadges'] = 'Moje odznaki';
$string['namewithlink'] = 'Nazwa z linkiem';
$string['never'] = 'Nigdy: ta odznaka nie traci ważności.';
$string['newbackpack'] = 'Dodaj nowy plecak';
$string['newbadge'] = 'Dodaj nową odznakę';
$string['newimage'] = 'Nowy obraz';
$string['noalignment'] = 'Ta odznaka nie ma żadnych zewnętrznych umiejętności ani standardów.';
$string['noawards'] = 'Ta odznaka nie została jeszcze zdobyta.';
$string['nobackpack'] = 'Nie ma tu żadnej usługi plecaka podłączonej do tego konta.<br/>';
$string['nobackpackbadgessummary'] = 'W wybranych przez Ciebie kolekcjach nie ma odznak.';
$string['nobackpackcollectionssummary'] = 'Nie wybrano żadnych kolekcji odznak.';
$string['nobackpacks'] = 'Brak dostępnych plecaków';
$string['nobadges'] = 'Obecnie nie są dostępne żadne odznaki, które użytkownicy mogliby zdobyć.';
$string['nocompetencies'] = 'Nie wybrano kompetencji.';
$string['nocriteria'] = 'Kryteria dla tej odznaki nie zostały jeszcze skonfigurowane.';
$string['noendorsement'] = 'Ta odznaka nie ma zatwierdzenia.';
$string['noexpiry'] = 'Ta odznaka nie ma daty ważności.';
$string['nomatchingawards'] = 'Nie znaleziono jeszcze żadnych pasujących odbiorców, którzy otrzymali tę odznakę.';
$string['nomatchingbadges'] = 'Użytkownicy nie mogą zdobyć żadnych pasujących odznak.';
$string['noparamstoadd'] = 'Nie istnieją żadne dodatkowe parametru dostępne do dodania do tego wymogu odznaki.';
$string['norelated'] = 'Ta odznaka nie ma żadnych powiązanych odznak.';
$string['notacceptedrole'] = 'Twoja obecnie przypisana rola nie należy do ról, które pozwalają ręcznie przyznać tą odznakę.<br/>
Jeżeli chcesz zobaczyć użytkowników, którzy zdobyli już tą odznakę, możesz odwiedzić stronę {$a}.';
$string['notconnected'] = 'Nie podłączony';
$string['notealignment'] = 'Można określić zewnętrzne umiejętności lub standardy, do których dostosowano odznakę. Wszelkie zewnętrzne umiejętności i standardy są wyświetlane na stronie z odznaką.';
$string['noteendorsement'] = 'W celu zwiększenia wartości odznaki można użyć zatwierdzenia strony trzeciej. Na przykład, odznaka przyznana przez nauczyciela może zostać zatwierdzona przez szkołę lub odznaka przyznana przez lokalny organ przyznający może zostać zatwierdzona przez krajowy organ przyznający.';
$string['noterelated'] = 'Odznaki z połączeniem mogą być oznaczone jako powiązane. Na przykład odznaki z tymi samymi kryteriami, które są wyświetlane w różnych językach, mogą być oznaczone jako powiązane. Wszelkie powiązane odznaki są wyświetlane na stronie odznaki.';
$string['nothingtoadd'] = 'Brak kryteriów do dodania.';
$string['notification'] = 'Powiadomienie twórcy odznaki';
$string['notification_help'] = 'To ustawienie zarządza powiadomieniami wysyłanymi do twórcy odznaki, aby dać mu znać, że odznaka została przyznana.

Dostępne są poniższe opcje:

* **NIGDY** - nie wysyła powiadomień.

* **ZA KAŻDYM RAZEM** - wysyła powiadomienia za każdym razem kiedy ta odznaka jest przyznawana.

* **CODZIENNIE** - wysyła powiadomienia raz na dzień.

* **TYGODNIOWO** - wysyła powiadomienia raz na tydzień.

* **MIESIĘCZNIE** - wysyła powiadomienia raz na miesiąc.';
$string['notifydaily'] = 'przyznanaCodziennie';
$string['notifyevery'] = 'Za każdym razem';
$string['notifymonthly'] = 'Miesięcznie';
$string['notifyweekly'] = 'Tygodniowo';
$string['numawards'] = 'Użytkownicy, którym przyznano odznakę \'{$a->badgename}\': <a href="{$a->link}">{$a->count</a>.';
$string['numawardstat'] = 'Użytkownicy, którym przyznano odznakę \'{$a->badgename}\': {$a->awards}.';
$string['oauth2issuer'] = 'Usługi OAuth 2';
$string['othernavigation'] = 'Inna nawigacja...';
$string['overallcrit'] = 'z wybranych kryteriów są spełnione.';
$string['password_required'] = 'Hasło nie może być puste';
$string['potentialrecipients'] = 'Potencjalni beneficjenci odznak';
$string['preferences'] = 'Preferencje odznak';
$string['privacy:metadata:backpack'] = 'Informacje o plecakach użytkownika';
$string['privacy:metadata:backpack:backpackuid'] = 'Unikalny identyfikator plecaka';
$string['privacy:metadata:backpack:email'] = 'Adres e-mail powiązany z plecakiem';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Identyfikator plecaka';
$string['privacy:metadata:backpack:userid'] = 'Identyfikator użytkownika do którego należy plecak';
$string['privacy:metadata:backpackoauth2'] = 'Informacje OAuth 2, gdy użytkownik łączy się z zewnętrznym plecakiem';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'Identyfikator usługi OAuth 2';
$string['privacy:metadata:backpackoauth2:token'] = 'Token połączenia z plecakiem';
$string['privacy:metadata:backpackoauth2:userid'] = 'Identyfikator użytkownika, który łączy się z plecakiem';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Identyfikator użytkownika, który zmodyfikował połączenie';
$string['privacy:metadata:badge'] = 'Kolekcja odznak';
$string['privacy:metadata:badge:timecreated'] = 'Data i godzina utworzenia odznaki';
$string['privacy:metadata:badge:timemodified'] = 'Data i godzina ostatniej modyfikacji odznaki';
$string['privacy:metadata:badge:usercreated'] = 'Identyfikator użytkownika, który utworzył odznakę';
$string['privacy:metadata:badge:usermodified'] = 'Identyfikator użytkownika, który zmodyfikował odznakę';
$string['privacy:metadata:criteriamet'] = 'Zbiór kryteriów, które zostały spełnione';
$string['privacy:metadata:criteriamet:datemet'] = 'Data spełnienia kryteriów';
$string['privacy:metadata:criteriamet:userid'] = 'Identyfikator użytkownika, który spełnił kryteria';
$string['privacy:metadata:external:backpacks'] = 'Informacje udostępniane, gdy użytkownicy przesyłają swoje odznaki do zewnętrznego plecaka';
$string['privacy:metadata:external:backpacks:badge'] = 'Nazwa odznaki';
$string['privacy:metadata:external:backpacks:description'] = 'Opis odznaki';
$string['privacy:metadata:external:backpacks:image'] = 'Obraz odznaki';
$string['privacy:metadata:external:backpacks:issuer'] = 'Niektóre informacje o wydającym';
$string['privacy:metadata:external:backpacks:url'] = 'Adres URL Moodle, gdzie można zobaczyć informacje o przyznana odznace';
$string['privacy:metadata:issued'] = 'Informacje o przyznanych odznakach';
$string['privacy:metadata:issued:dateexpire'] = 'Data wygaśnięcia odznaki';
$string['privacy:metadata:issued:dateissued'] = 'Data przyznania';
$string['privacy:metadata:issued:userid'] = 'Identyfikator użytkownika, któremu przyznano odznakę';
$string['privacy:metadata:manualaward'] = 'Informację o ręcznych przyznaniach';
$string['privacy:metadata:manualaward:datemet'] = 'Data przyznania odznaki użytkownikowi';
$string['privacy:metadata:manualaward:issuerid'] = 'Identyfikator użytkownika przyznającego odznakę';
$string['privacy:metadata:manualaward:issuerrole'] = 'Rola użytkownika przyznającego odznakę';
$string['privacy:metadata:manualaward:recipientid'] = 'Identyfikator użytkownika, któremu ręcznie przyznano odznakę';
$string['recipient'] = 'Odbiorca odznaki';
$string['recipients'] = 'Beneficjenci odznak';
$string['recipientvalidationproblem'] = 'Obecny użytkownik nie może zostać zweryfikowany jako odbiorca tej odznaki.';
$string['relatedbages'] = 'Powiązane odznaki';
$string['relative'] = 'Data względna: ta odznaka wygasa po upływie określonego czasu:';
$string['requiredbadge'] = 'Przynajmniej jedna odznaka powinna zostać dodana do kryterium odznak.';
$string['requiredcohort'] = 'Co najmniej jedna kohorta powinna zostać dodana do kryterium kohortowego.';
$string['requiredcompetency'] = 'Do kryterium kompetencji należy dodać przynajmniej jedną kompetencję.';
$string['requiredcourse'] = 'Przynajmniej jeden kurs należy dodać do kryterium zestawu kursów.';
$string['reviewbadge'] = 'Zmiany w dostępie do odznak';
$string['reviewconfirm'] = '<p>To sprawi, że Twoja odznaka będzie widoczna dla użytkowników i pozwoli im zacząć ją otrzymywać.</p>

<p>Możliwe, że niektórzy użytkownicy już spełniają kryteria tej odznaki i otrzymają ją natychmiast po jej włączeniu.</ p>

<p>Po otrzymaniu odznaka zostanie <strong>zablokowana</strong> - niektóre ustawienia, w tym kryteria i ustawienia wygasania, nie będą już mogły być zmienione.</p>

<p>Czy na pewno chcesz włączyć dostęp do odznaki \'{$a}\'?</p>';
$string['revoke'] = 'Odbierz odznakę';
$string['save'] = 'Zapisz';
$string['searchname'] = 'Szukaj według nazwy';
$string['selectaward'] = 'Proszę wybrać rolę, którą chcesz używać do nadawania tej odznaki:';
$string['selectgroup_end'] = 'Wyświetlane są tylko kolekcje publiczne. <a href="{$a}">Odwiedź swój plecak</a>, aby stworzyć więcej publicznych kolekcji.';
$string['selectgroup_start'] = 'Wybierz kolekcje ze swojego plecaka do wyświetlenia na tej stronie:';
$string['selecting'] = 'Z wybranymi odznakami ...';
$string['setup'] = 'Skonfiguruj połączenie';
$string['sitebackpackdeleted'] = 'Plecak witryny został usunięty.';
$string['sitebackpacknotdeleted'] = 'Nie można usunąć tego plecaka, ponieważ jest on obecnie ustawiony jako domyślny plecak witryny.';
$string['sitebackpackwarning'] = 'Nie można połączyć się z plecakiem. <br/><br/>Sprawdź, czy ustawienie administratora „Adres e-mail wystawcy odznaki” jest prawidłowym adresem e-mail konta w witrynie dostarczającej plecak. <br/><br/>Sprawdź, czy „Hasło wystawcy odznaki” na <a href="{$a->url}">stronie ustawień plecaka</a> jest prawidłowym hasłem do konta w witrynie plecaka. <br/><br/>Ostrzeżenia z witryny plecaka: „{$a->warning}”';
$string['sitebadges'] = 'Strona odznak';
$string['sitebadges_help'] = 'Odznaki strony mogą być tylko przyznawane użytkownikom za aktywność na innych powiązanych stronach. Są to ukończenia zestawu kursów lub wypełnienie pól w profilu użytkownika. Odznaki strony mogą także być przyznawane ręcznie przez jednego użytkownika innemu użytkownikowi.

Odznaki dla aktywności powiązanych kursów muszą być utworzone na poziomie kursu. Odznaki kursu mogą być znalezione w Administracji kursu > Odznaki.';
$string['sitebadgetitle'] = 'Odznaka witryny {$a}';
$string['status'] = 'Status odznaki';
$string['status_help'] = 'Status odznaki określa jej zachowanie w systemie:

* **DOSTĘPNY** - oznacza, że ta odznaka może być zdobyta przez użytkowników. Dopóki odznaka jest dostępna dla użytkowników, jej kryteria nie mogą być zmienione.

* **NIEDOSTĘPNY** - oznacza, że ta odznaka nie jest dostępna użytkownikom i nie może być zdobyta lub ręcznie przyznana. Jeżeli taka odznaka nie została przedtem nigdy przyznana, jej kryteria mogą być zmieniane.

Jeżeli jedna z odznak zostanie przyznana przynajmniej jednemu użytkownikowi, staje się automatycznie **ZABLOKOWANA**. Odznaki zablokowane nadal mogą być zdobyte przez użytkowników, ale ich kryteria nie mogą być dłużej zmieniane. Jeżeli potrzebujesz zmienić dane lub kryteria tej zablokowanej odznaki, możesz dokonać zdublowania tej odznaki i dokonać wtedy zmian na jej duplikacie.

*Dlaczego odznaki sa blokowane?*

Chcemy się upewnić, że wszyscy użytkownicy spełnili te same wymagania zdobycia odznaki. Obecnie nie jest możliwe wycofanie odznaki. Jeżeli zezwolono na zmianę wymagań dla odznak w różnym czasie, prawdopodobnie użytkownicy otrzymają tą samą odznakę w wyniku spełnienia różnych wymogów.';
$string['statusmessage_0'] = 'Ta odznaka nie jest obecnie dostępna dla użytkowników. Włącz dostęp, jeśli chcesz, aby użytkownicy mogli otrzymać tę odznakę.';
$string['statusmessage_1'] = 'Ta odznaka jest obecnie dostępna dla użytkowników. Wyłącz do niej dostęp, by wprowadzić zmiany.';
$string['statusmessage_2'] = 'Ta odznaka nie jest obecnie dostępna dla użytkowników, a jej kryteria są zablokowane. Włącz do niej dostęp, jeśli chcesz, aby użytkownicy mogli ją zarobić.';
$string['statusmessage_3'] = 'Ta odznaka jest obecnie dostępna dla użytkowników, a jej kryteria są zablokowane.';
$string['statusmessage_4'] = 'Ta odznaka jest obecnie w archiwum.';
$string['subject'] = 'Temat wiadomości';
$string['tagarea_badge'] = 'Odznaki';
$string['tags'] = 'Tagi';
$string['targetcode'] = 'Kod';
$string['targetcode_help'] = 'Unikalny identyfikator łańcucha dla odniesienia zewnętrznej umiejętności lub standardu w jego ramach.';
$string['targetdescription'] = 'Opis';
$string['targetdescription_help'] = 'Krótki opis zewnętrznej umiejętności lub standardu.';
$string['targetframework'] = 'Ramy';
$string['targetframework_help'] = 'Nazwa ram zewnętrznej kompetencji lub standardu.';
$string['targetname'] = 'Nazwa';
$string['targetname_help'] = 'Zewnętrzna umiejętność lub standard, do którego dostosowana jest odznaka.';
$string['targeturl'] = 'Adres URL';
$string['targeturl_help'] = 'Link do strony opisującej zewnętrzną kompetencję lub standard. Adres URL powinien mieć prefiks http:// lub https://';
$string['testbackpack'] = 'Testuj plecak \'{$a}\'';
$string['testsettings'] = 'Testuj ustawienia';
$string['type'] = 'Typ';
$string['userbadges'] = 'Odznaki użytkownika';
$string['variablesubstitution'] = 'Zastępowanie zmiennych w wiadomościach.';
$string['variablesubstitution_help'] = 'W wiadomościach odnośnie odznak, niektóre zmienne mogą być wstawiane do tematu i/lub treści wiadomości, aby zostały zastąpione rzeczywistymi wartościami, gdy wiadomość zostanie wysłana. Zmienne należy wstawić do tekstu dokładnie tak, jak pokazano poniżej. Można użyć następujących zmiennych:

%badgename%
:  zostanie zastąpione pełną nazwą odznaki.

%username%
:  zostanie zastąpione pełną nazwą odbiorcy.

%badgelink%
:  zostanie zastąpione przez publiczny URL z informacją o przyznanej odznace.';
$string['verifyemail'] = 'Zweryfikuj adres email';
$string['version'] = 'Wersja';
$string['version_help'] = 'Pole wersji może być używane do śledzenia prac nad odznaką. Jeśli określono, wersja jest wyświetlana na stronie odznaki.';
$string['viewbadge'] = 'Zobacz przyznaną odznakę';
$string['visible'] = 'Widoczne';
$string['warnexpired'] = '(Ta odznaka wygasła!)';
$string['year'] = 'Rok/lata';
