<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'mn', version '5.0'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Үйлдэл';
$string['actionsmenu'] = 'Үйлдлийн цэс';
$string['add'] = 'Бичлэг нэмэх';
$string['addcomment'] = 'Тайлбар нэмэх';
$string['addtemplate'] = 'Бичлэгийн загвар нэмэх';
$string['advancedsearch'] = 'Дэлгэрэнгүй хайлт';
$string['allowcomments'] = 'Бичлэгүүдэд тайлбар оруулахыг зөвшөөрөх';
$string['alttext'] = 'Солигдох бичвэр';
$string['approvalstatus'] = 'Зөвшөөрлийн төлөв';
$string['approve'] = 'Зөвшөөрөх';
$string['approved'] = 'Зөвшөөрсөн';
$string['areacontent'] = 'Талбарууд';
$string['ascending'] = 'Өгсөх дарааллаар';
$string['asearchtemplate'] = 'Нарийвчилсан хайлтын загвар';
$string['atmaxentry'] = 'Та зөвшөөрөгдөх хамгийн их хэмжээний бичлэг оруулсан байна!';
$string['authorfirstname'] = 'Нэр';
$string['authorlastname'] = 'Овог';
$string['autogenallforms'] = 'Бүх өгөгдмөл загваруудыг үүсгэх';
$string['autolinkurl'] = 'URL зам руу автоматаар холбох';
$string['availablefromdate'] = 'Эхлэх огноо:';
$string['availabletags'] = 'Боломжтой тагууд';
$string['availabletags_help'] = 'Таг нь загвар дах оруулагч бөгөөд бичлэгийг засварлах эсвэл үзэх үед таг нь харгалзах өгөгдөл эсвэл бусад зүйлсээр (жишээлбэл, засварлах дүрст тэмдэг) солигддог.

Талбар нь [[fieldname]] хэлбэртэй байна. бусад бүх таг нь ##sometag## хэлбэртэй байна.

Одоо ашиглаж байгаа загварт зөвхөн "Боломжтой тагууд" жагсаалтад байгаа тагийг ашиглаж болно.';
$string['availabletodate'] = 'Дуусах огноо:';
$string['availabletodatevalidation'] = 'Дуусах хугацаа нь эхлэх хугацаанаас өмнө байж болохгүй.';
$string['bynameondate'] = '{$a->name} - {$a->date} -р';
$string['calendarend'] = '{$a} -д хаагдана';
$string['calendarstart'] = '{$a} -д нээгдэнэ';
$string['cancel'] = 'Цуцлах';
$string['cannotaccesspresentsother'] = 'Таныг бусад хэрэглэгчдийн урьдчилан тохируулсан мэдээлэлд хандахыг зөвшөөрөөгүй байна';
$string['cannotadd'] = 'Бичлэг нэмэх боломжгүй!';
$string['cannotapplypreset'] = 'Урьдчилсан тохируулгыг хэрэглэхэд алдаа гарлаа.';
$string['cannotdeletepreset'] = 'Урьдчилсан тохируулгыг устгахад алдаа гарлаа';
$string['cannotoverwritepreset'] = 'Урьдчилсан тохируулгыг дарж бичихэд алдаа гарлаа';
$string['cannotunziptopreset'] = 'Урьдчилан тохируулгын хавтаст задлах боломжгүй';
$string['checkbox'] = 'Чагтан-нүднүүд';
$string['chooseexportfields'] = 'Экспорт хийх талбаруудыг сонгоно уу';
$string['chooseexportformat'] = 'Экспорт хийх файлын форматыг сонгоно уу';
$string['chooseorupload'] = 'Файлаа сонгоно уу';
$string['choosepreset'] = 'Файлаа урьдчилан тохируулна уу';
$string['closebeforeopen'] = 'Дуусах хугацааг эхлэх хугацаанаас өмнө тодорхойлсон байна.';
$string['columns'] = 'Баганууд';
$string['comment'] = 'Тайлбар';
$string['commentdeleted'] = 'Тайлбар устгагдсан';
$string['commentempty'] = 'Тайлбар хоосон байна';
$string['comments'] = 'Сэтгэгдэлүүд';
$string['commentsaved'] = 'Тайлбар хадгалагдлаа';
$string['commentsn'] = '{$a} тайлбар байна';
$string['commentsoff'] = 'Тайлбар бичих боломжийг идэвхжүүлээгүй байна';
$string['completiondetail:entries'] = 'Бичлэг хийх: {$a}';
$string['completionentriescount'] = 'Бичлэгийн тоо';
$string['completionentriesdesc'] = 'Шаардлагатай бичлэгийн хамгийн бага тоо: {$a}';
$string['configenablerssfeeds'] = 'Энэ шилжүүлэгч нь бүх өгөгдлийн сангийн RSS мэдэгдлийн боломжийг идэвхжүүлнэ. Та өгөгдлийн сан тус бүрийн тохиргоонд мэдэгдлийг гараар аргаар идэвхтэй болгох хэрэгтэй.';
$string['confirmdeletefield'] = 'Та энэ талбарыг устгах гэж байна. Итгэлтэй байна уу?';
$string['confirmdeleterecord'] = 'Та энэ бичлэгийг устгахдаа итгэлтэй байна уу?';
$string['confirmdeleterecords'] = 'Та эдгээр бичлэгийг устгахдаа итгэлтэй байна уу?';
$string['createactivity'] = 'Өгөгдөл цуглуулахын тулд өөрийн талбаруудыг үүсгэх эсвэл аль хэдийнэ талбаруудыг агуулсан урьдчилан тохируулгыг ашиглана уу.';
$string['createfields'] = 'Ялгаатай төрлийн өгөгдөл цуглуулах талбарууд үүсгэх.';
$string['createtemplates'] = 'Загвар нь таны үйл ажиллагааны интерфейсийг тодорхойлно. Талбар үүсгэсний дараа загвар автоматаар үүснэ. Эсвэл та талбар болон загварыг агуулсан урьдчилан тохируулгыг ашиглаж болно.';
$string['csstemplate'] = 'Хэрэглэгчийн CSS загвар';
$string['csvfailed'] = 'CSV файлаас түүхий өгөгдлийг унших боломжгүй';
$string['csvfile'] = 'CSV файл';
$string['csvimport'] = 'CSV файл импортлох';
$string['csvimport_help'] = 'Бичлэгийг эхний мөрөнд талбарын нэрийн жагсаалт, дараа нь өгөгдлүүд нь нэг мөрөнд нэг бичлэг байх энгийн бичвэр файлаас импортолж болно.';
$string['csvwithselecteddelimiter'] = '<abbr title="Comma Separated Values">CSV</abbr>';
$string['data:addinstance'] = 'Шинэ өгөгдлийн сан нэмэх';
$string['data:approve'] = 'Бичлэгийг зөвшөөрөх эсвэл зөвшөөрөхгүй болгох';
$string['data:comment'] = 'Тайлбар бичих';
$string['data:exportallentries'] = 'Өгөгдлийн сангийн бүх бичлэгийг экспортлох';
$string['data:exportentry'] = 'Өгөгдлийн сангийн бичлэгийг экспортлох';
$string['data:exportownentry'] = 'Өөрийн өгөгдлийн сангийн бичлэгийг экспортлох';
$string['data:exportuserinfo'] = 'Хэрэглэгчийн мэдээллийг экспортлох';
$string['data:managecomments'] = 'Тайлбарыг удирдах';
$string['data:manageentries'] = 'Бичлэгийг удирдах';
$string['data:managetemplates'] = 'Загварыг удирдах';
$string['data:manageuserpresets'] = 'Урьдчилсан тохируулгыг удирдах';
$string['data:rate'] = 'Бичлэгийг үнэлэх';
$string['data:readentry'] = 'Бичлэгийг унших';
$string['data:view'] = 'Өгөгдлийн сангийн үйл ажиллагааг харах';
$string['data:viewallratings'] = 'Хувь хүмүүсийн өгсөн бүх (түүхий) үнэлгээг харах';
$string['data:viewalluserpresets'] = 'Бүх хэрэглэгчийн урьдчилсан тохируулгуудыг харах';
$string['data:viewanyrating'] = 'Хүн бүрийн авсан нийт үнэлгээг харах';
$string['data:viewentry'] = 'Бичлэгүүдийг харах';
$string['data:viewrating'] = 'Таны авсан нийт үнэлгээг харах';
$string['data:writeentry'] = 'Бичлэгүүд бичих';
$string['date'] = 'Огноо';
$string['dateentered'] = 'Оруулсан огноо';
$string['datemodified'] = 'Сүүлд засварласан:';
$string['defaultfielddelimiter'] = '(өгөгдмөлөөр таслал байна)';
$string['defaultfieldenclosure'] = '(өгөгдмөлөөр хоосон байна)';
$string['defaultsortfield'] = 'Өгөгдмөл эрэмбэлэх талбар';
$string['delcheck'] = 'Бөөнөөр устгах чагтан-нүд';
$string['delete'] = 'Устгах';
$string['deleteallentries'] = 'Бүх бичлэгийг устгах';
$string['deletecomment'] = 'Та энэ тайлбарыг устгахдаа итгэлтэй байна уу?';
$string['deleteconfirm'] = '{$a} урьдчилсан тохируулгыг устгах уу?';
$string['deleted'] = 'Устгагдсан';
$string['deleteentry'] = 'Бичлэгийг устгах';
$string['deletefield'] = 'Талбарыг устгах';
$string['deletenotenrolled'] = 'Бүртгүүлээгүй хэрэглэгчдийн бичлэгийг устгах';
$string['deletewarning'] = 'Урьдчилсан тохируулгыг устгаснаар бүх хичээлд байгаа урьдчилан тохируулгын жагсаалтаас хасагдана.';
$string['descending'] = 'Буурах дарааллаар';
$string['directorynotapreset'] = '{$a->directory} Урьдчилан тохируулаагүй: дутуу файлууд: {$a->missing_files}';
$string['disapprove'] = 'Зөвшөөрснийг буцаах';
$string['download'] = 'Татаж авах';
$string['edit'] = 'Засварлах';
$string['editcomment'] = 'Тайлбарыг засварлах';
$string['editentry'] = 'Бичлэгийг засварлах';
$string['editfield'] = 'Талбарыг засварлах';
$string['editordisable'] = 'Засварлагчийг идэвхгүй болгох';
$string['editorenable'] = 'Код засварлагчийг идэвхжүүлэх';
$string['editpreset'] = 'Урьдчилсан тохируулгыг засварлах';
$string['emptyadd'] = 'Загвар хоосон байна, өгөгдмөл маягт үүсгэж байна...';
$string['emptyaddform'] = 'Та ямар нэгэн талбар бөглөөгүй байна!';
$string['emptypresetname'] = 'Урьдчилсан тохируулгын нэр эсвэл файл хоосон байж болохгүй';
$string['enabletemplateeditorcheck'] = 'Та засварлагчийг идэвхжүүлэхдээ итгэлтэй байна уу? Энэ нь загварыг хадгалах үед агуулгыг өөрчлөхөд хүргэж магадгүй.';
$string['entries'] = 'Бичлэгүүд';
$string['entrieslefttoadd'] = 'Энэ үйл ажиллагааг дуусгахын тулд {$a->entriesleft}  бичлэг/бичлэгүүд нэмэх шаардлагатай.';
$string['entrieslefttoaddtoview'] = 'Бусад оролцогчдын бичлэгийг харахаас өмнө
{$a->entrieslefttoview} бичлэг/бичлэгүүд нэмэх шаардлагатай.';
$string['entry'] = 'Бичлэг';
$string['entrysaved'] = 'Таны бичлэг хадгалагдлаа';
$string['errormustbeteacher'] = 'Энэ хуудсыг ашиглахын тулд та Багш эрхтэй байх ёстой!';
$string['errormustsupplyvalue'] = 'Энд утга оруулах ёстой.';
$string['errorpresetexists'] = 'Ийм нэртэй урьдчилсан тохируулга байна.';
$string['errorpresetexistsbutnotoverwrite'] = 'Ийм нэртэй урьдчилсан тохируулга байна. Өөр нэр сонгоно уу.';
$string['errorpresetnotfound'] = '{$a} нэртэй урьдчилсан тохируулга олдсонгүй.';
$string['eventfieldcreated'] = 'Талбарыг үүсгэсэн';
$string['eventfielddeleted'] = 'Талбарыг устгасан';
$string['eventfieldupdated'] = 'Талбарыг шинэчилсэн';
$string['eventrecordcreated'] = 'Бичлэгийг үүсгэсэн';
$string['eventrecorddeleted'] = 'Бичлэгийг устгасан';
$string['eventrecordupdated'] = 'Бичлэгийг шинэчилсэн';
$string['eventtemplateupdated'] = 'Загварыг шинэчилсэн';
$string['eventtemplateviewed'] = 'Загварыг үзсэн';
$string['example'] = 'Өгөгдлийн сангийн модулийн жишээ';
$string['excel'] = 'Excel';
$string['expired'] = 'Уучлаарай, энэ үйлдэл {$a}-д хаагдсан тул цаашид боломжгүй';
$string['export'] = 'Экспортлох';
$string['exportaszip'] = 'Шахсан файл хэлбэрээр экспортлох';
$string['exportaszip_help'] = 'Шахсан файл хэлбэрээр экспортлох функц нь загвар болон талбарыг урьдчилсан тохируулгын шахсан файл болгон татаж авахаар хадгалах боломжийг олгодог.';
$string['exportedtozip'] = 'Түр зуурын шахсан файл руу экспортолсон...';
$string['exportentries'] = 'Бичлэгийг экспортлох';
$string['exportformat'] = 'Экспортлох формат';
$string['exportoptions'] = 'Экспортлох тохиргоо';
$string['exportownentries'] = 'Та зөвхөн өөрийн бичлэгийг экспортлох уу?  ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Урьдчилсан тохируулгыг экспортлох';
$string['failedpresetdelete'] = 'Урьдчилсан тохируулгыг устгахыг оролдох үед алдаа гарлаа.';
$string['fieldadded'] = 'Талбар нэмэгдлээ';
$string['fieldallowautolink'] = 'Автоматаар холбогдохыг зөвшөөрөх';
$string['fielddeleted'] = 'Талбар устгагдлаа';
$string['fielddelimiter'] = 'Талбар тусгаарлагч';
$string['fielddescription'] = 'Талбарын тодорхойлолт';
$string['fieldenclosure'] = 'Талбар хаагч';
$string['fieldheight'] = 'Өндөр';
$string['fieldheightlistview'] = 'Жагсааж харах өндөр (цэгээр)';
$string['fieldheightsingleview'] = 'Ганцаарчилж харах өндөр (цэгээр)';
$string['fieldmappings'] = 'Талбарыг харгалзуулан тохируулах';
$string['fieldmappings_help'] = 'Энэ цэс нь одоо байгаа өгөгдлийн сангаас өгөгдөл хадгалах боломжийг олгодог. Талбар дахь өгөгдлийг хадгалахын тулд тус талбарыг өгөгдөл гарч ирэх шинэ талбартай харгалзуулах ёстой. Дурын талбарыг хоосон орхиж, мэдээлэл хуулалгүй орхиж болно. Шинэ талбарт харгалзуулаагүй хуучин талбарууд болон бүх өгөгдөл нь устах болно.
Та зөвхөн ижил төрлийн талбаруудыг харгалзуулах боломжтой тул нээгдэх жагсаалт нь өөр өөр талбаруудтай байх болно. Мөн нэг хуучин талбарыг нэгээс олон шинэ талбарт харгалзуулахаас сэргийлэх хэрэгтэй.';
$string['fieldname'] = 'Талбарын нэр';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Таны файлын дараах талбарууд энэ өгөгдлийн санд байхгүй байна: {$a}';
$string['fieldoptions'] = 'Сонголтууд(мөр бүрт нэг)';
$string['fields'] = 'Талбарууд';
$string['fieldshelp'] = 'Ялгаатай төрлийн өгөгдөл цуглуулах талбар үүсгэх. Талбарууд нь таны өгөгдлийн сан дахь бичлэгийн бүтцийг тодорхойлдог.';
$string['fieldsinformationtags'] = 'Талбарын мэдээлэл';
$string['fieldsnavigation'] = 'Гуравдагч удирдлагын мөрний талбарууд';
$string['fieldtagdescription'] = '{$a} тайлбар';
$string['fieldtagid'] = '{$a} ID';
$string['fieldtagname'] = '{$a} нэр';
$string['fieldupdated'] = 'Талбар шинэчлэгдлээ';
$string['fieldwidth'] = 'Өргөн';
$string['fieldwidthlistview'] = 'Жагсаалтаар харах өргөн (цэгээр)';
$string['fieldwidthsingleview'] = 'Ганцаарчилж харах өргөн (цэгээр)';
$string['file'] = 'Файл';
$string['fileencoding'] = 'Шифрлэлт';
$string['filesnotgenerated'] = 'Бүх файлыг үүсгээгүй: {$a}';
$string['filtername'] = 'Өгөгдлийн сантай автоматаар холбох';
$string['footer'] = 'Хөл';
$string['forcelinkname'] = 'Холбоосны заавал байх ёстой нэр';
$string['foundnorecords'] = 'Бичлэг олдсонгүй. <a href="{$a->reseturl}">Бүгдийг цэвэрлэх</a>';
$string['foundrecords'] = 'Бичлэг олдсон: {$a->num}/{$a->max} <a href="{$a->reseturl}">Бүгдийг цэвэрлэх</a>';
$string['fromfile'] = 'Шахсан файлаас импортлох';
$string['fromfile_help'] = 'Шахсан файлаас импортлох функц нь загвар болон талбаруудын шахсан урьдчилсан тохируулгыг сонгох, байршуулах боломжийг олгодог.';
$string['generateerror'] = 'Бүх файлыг үүсгээгүй!';
$string['header'] = 'Толгой';
$string['headeraddtemplate'] = 'Бичлэг нэмэх, засварлах интерфейсийг тодорхойлно уу.';
$string['headerasearchtemplate'] = 'Дэлгэрэнгүй хайлтын интерфейсийг тодорхойлно уу.';
$string['headercsstemplate'] = 'CSS загвар нэмэх';
$string['headerjstemplate'] = 'Жагсааж харах, ганцаарчилж харах, нэмэх бичлэгийн загварт зориулсан тусгай javascript нэмэх.';
$string['headerlisttemplate'] = 'Жагсаалтаар харагдах байдлыг тодорхойлно уу.';
$string['headerrsstemplate'] = 'RSS мэдэгдэл дэх бичлэгүүдийн харагдах байдлыг тодорхойлно уу.';
$string['headersingletemplate'] = 'Ганцаарчлан харах харагдах байдлыг тодорхойлно уу.';
$string['id'] = 'Бичлэгийн ID';
$string['importandapply'] = 'Урьдчилсан тохируулгыг импортлох, хэрэглэх';
$string['importapreset'] = 'Урьдчилсан тохируулгыг импортлох';
$string['importentries'] = 'Бичлэгүүдийг импортлох';
$string['importpreset'] = 'Урьдчилсан тохируулгыг импортлох';
$string['importpreset_desc'] = 'Урьдчилсан тохируулгыг энэ үйл ажиллагаанд хэрэглэж, талбарууд болон загваруудыг үүсгэнэ.
  Энэ нь урьдчилан тохируулгын жагсаалтад харагдахгүй.';
$string['importpresetmissingcapability'] = 'Та урьдчилсан тохируулгыг импортлох эрхгүй байна.';
$string['importsuccess'] = 'Урьдчилсан тохируулгыг хэрэглэсэн.';
$string['includeapproval'] = 'Зөвшөөрлийн төлөвийг оруулах';
$string['includetags'] = 'Тагуудыг оруулах';
$string['includetime'] = 'Нэмсэн болон өөрчилсөн хугацааг оруулах';
$string['includeuserdetails'] = 'Хэрэглэгчийн дэлгэрэнгүйг оруулах';
$string['indicator:cognitivedepth'] = 'Өгөгдлийн сангийн танин мэдэхүйн гүн';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь суралцагчийн өгөгдлийн сангийн үйл ажиллагаанд хүрсэн танин мэдэхүйн гүнд суурилдаг.';
$string['indicator:cognitivedepthdef'] = 'Өгөгдлийн сангийн танин мэдэхүйн гүн';
$string['indicator:cognitivedepthdef_help'] = 'Энэ шинжилгээний интервалын хугацаанд өгөгдлийн сангийн үйл ажиллагаанаас санал болгож буй танин мэдэхүйн оролцоонд оролцогчийн хүрсэн хувь (Түвшин = Харагдахгүй, Харах, Илгээх)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Өгөгдлийн сангийн нийгмийн хүрээ';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь суралцагчийн өгөгдлийн сангийн үйл ажиллагаанд хүрсэн нийгмийн хүрээнд суурилдаг.';
$string['indicator:socialbreadthdef'] = 'Өгөгдлийн сангийн нийгмийн хүрээ';
$string['indicator:socialbreadthdef_help'] = 'Энэ шинжилгээний интервалын хугацаанд өгөгдлийн сангийн үйл ажиллагаанаас санал болгож буй нийгмийн оролцоонд оролцогчийн хүрсэн хүрсэн хувь (Түвшин = Оролцоогүй, Ганцаар оролцсон)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'өгөгдлийн санг үзэхийн тулд нэмэлт бичлэгүүд хэрэгтэй';
$string['intro'] = 'Тайлбар';
$string['invalidaccess'] = 'Энэ хуудсанд зөв хандсангүй';
$string['invalidfieldid'] = 'Талбарын ID буруу байна';
$string['invalidfieldname'] = 'Энэ талбарт өөр нэр өгнө үү';
$string['invalidfieldtype'] = 'Талбарын төрөл буруу байна';
$string['invalidid'] = 'Өгөгдлийн ID буруу байна';
$string['invalidpreset'] = '{$a} -ийг урьдчилан тохируулаагүй байна.';
$string['invalidrecord'] = 'Бичлэг буруу байна';
$string['invalidurl'] = 'Таны оруулсан URL хүчингүй хаяг байна';
$string['jstemplate'] = 'Тусгай Javascript';
$string['latitude'] = 'Өргөрөг';
$string['latlong'] = 'Координат';
$string['latlongboth'] = 'Өргөрөг, уртраг аль алиныг оруулах шаардлагатай';
$string['latlongdownloadallhint'] = 'Бүх бичлэгүүдийн холбоосыг KML хэлбэртэйгээр татаж авах';
$string['latlongkmllabelling'] = 'KML файл дахь зүйлсийг хэрхэн шошголох вэ (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Харуулах холбогдсон үйлчилгээнүүд';
$string['latlongotherfields'] = 'Бусад талбарууд';
$string['list'] = 'Жагсаалт харах';
$string['listtemplate'] = 'Жагсаалтаар харах загварууд';
$string['listview'] = 'Жагсаалтаар харах';
$string['longitude'] = 'Уртраг';
$string['manageapproved'] = 'Зөвшөөрөгдсөн бичлэгүүдийг засварлахыг зөвшөөрөх';
$string['manageapproved_help'] = 'Суралцагчд зөвшөөрсөн бичлэгүүдээ засах эсвэл устгахыг зөвшөөрнө үү. Зассан бичлэгүүдийг дахин батлах шаардлагатай.';
$string['managefields'] = 'Талбарыг удирдах';
$string['mapexistingfield'] = '{$a}-тай харгалзуулах';
$string['mapnewfield'] = 'Шинэ талбар үүсгэх';
$string['mapping:applypresets'] = 'Урьдчилсан тохируулгыг хэрэглэх';
$string['mapping:dialogtitle:usepreset'] = '{$a} урьдчилсан тохируулгыг хэрэглэх үү?';
$string['mapping:fieldstocreate'] = 'Үүсгэх талбарууд: {$a}';
$string['mapping:fieldstodelete'] = 'Одоо байгаа устгах талбарууд: {$a}';
$string['mapping:mapfields'] = 'Харгалзуулах талбарууд';
$string['mapping:warningmessagedelete'] = 'Устгагдах талбарууд нь таны хэрэглэж буй урьдчилан тохируулсан шинэ талбаруудтай ижил төрлийн байвал тэдгээрийг Харгалзуулах талбаруудад харгалзуулах боломжтой болно.';
$string['mapping:warningmessagedeleteandcreate'] = 'Устгагдах талбарууд нь үүсгэх талбаруудтай ижил төрлийн байвал тэдгээрийг Харгалзуулах талбаруудад харгалзуулах боломжтой болно.';
$string['mappingwarning'] = 'Шинэ талбарт харгалзуулаагүй бүх хуучин талбарууд, тэдгээрийн өгөгдлүүд устгагдана.';
$string['maxentries'] = 'Бичлэгийг хамгийн их тоо';
$string['maxentries_help'] = 'Бичлэгийн хамгийн их тоо нь суралцагчийн энэ үйл ажиллагаанд илгээж болох бичлэгийн дээд хязгаар юм.';
$string['maxsize'] = 'Хамгийн их хэмжээ';
$string['menu'] = 'Цэс';
$string['menuchoose'] = 'Сонгоно уу...';
$string['missingdata'] = 'Талбарын ангилалд өгөгдлийн ID эсвэл объектыг оруулах ёстой.';
$string['missingfield'] = 'Программчлалын алдаа: Талбарын ангиллыг тодорхойлохдоо талбар ба/эсвэл өгөгдлийг зааж өгөх ёстой.';
$string['missingfieldtype'] = '{$a->name} талбарын төрөл олдсонгүй';
$string['missingfieldtypeimport'] = 'Дараах талбаруудад тохирох талбарын төрлийг суулгаагүй учир тэдгээрийг импортлоогүй.';
$string['missingfieldtypes'] = 'Дараах талбаруудад тохирох талбарын төрлийг суулгаагүй, мөн тэдгээрийг Бичлэг нэмэх маягтад оруулаагүй байна. Та Бичлэг нэмэх загварыг шалгаж, талбарын нэрийг хасах хэрэгтэй.';
$string['modulename'] = 'Өгөгдлийн сан';
$string['modulename_help'] = 'Өгөгдлийн сан нь оролцогчдод бичлэгийн цуглуулга үүсгэх, хадгалах, хайх боломжийг олгодог.

Бичлэгийн бүтцийг богино бичвэр, задрах жагсаалт, бичвэр талбар, URL, зураг, файл гэх мэт өөр өөр төрлийн талбаруудыг ашиглан тодорхойлно.

Багшийн хувьд бичлэгт сэтгэгдэл бичиж, үнэлгээ өгөх боломжтой. Мөн оюутнуудад бичлэгийг үнэлэх, сэтгэгдэл бичихийг зөвшөөрөх боломжтой (чацуутны үнэлгээ). Үнэлгээг нэгтгэн эцсийн дүн гаргах боломжтой бөгөөд үүнийг журналд тэмдэглэнэ.

Өгөгдлийн сангийн автомат холболтын шүүлтүүрийг идэвхжүүлсэн тохиолдолд өгөгдлийн санд байгаа аливаа бичлэг нь хичээл дотор үг, хэллэгүүд гарч ирэхэд автоматаар холбогдоно.

Өгөгдлийн санг дараахад ашиглах боломжтой:

* Холбоос, ном, номын шүүмж, сэтгүүлийн лавлагаа гэх мэт хамтын цуглуулга үүсгэх.
* Чацуутны үнэлгээнд зориулан суралцагчийн бүтээсэн зураг, зурагт хуудас, вэб-хуудас эсвэл шүлгийг үзүүлэх';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Өгөгдлийн сангууд';
$string['more'] = 'Өөр';
$string['moreurl'] = 'Өөр URL';
$string['movezipfailed'] = 'Шахсан файлыг зөөх боломжгүй';
$string['multientry'] = 'Давтагдсан бичлэг';
$string['multimenu'] = 'Цэс (Олонг сонгох)';
$string['multipletags'] = 'Хэт олон таг байна. Загвар хадгалагдсангүй';
$string['newentry'] = 'Шинэ бичлэг';
$string['newfield'] = 'Талбар үүсгэх';
$string['newfield_help'] = 'Талбар нь өгөгдөл оруулах боломжийг олгодог. Өгөгдлийн сангийн үйл ажиллагааны бичлэг бүр нь задрах цэсээс өдөр, сар, жилийг сонгох боломжтой огноо талбар, зургийн файл байршуулах боломжтой зургийн талбар, нэг эсвэл хэд хэдэн сонголтыг сонгох боломжтой чагтан-нүд талбар гэх мэт олон төрлийн олон талбартай байж болно.

Талбар бүр дахин давтагдахгүй талбарын нэртэй байх ёстой. Хүсвэл талбарын тайлбар оруулж болно.';
$string['noaccess'] = 'Та энэ хуудасанд эрхгүй байна';
$string['nodefinedfields'] = 'Шинэ урьдчилан тохируулсан талбар байхгүй байна!';
$string['nofieldcontent'] = 'Талбарын агуулга олдсонгүй';
$string['nofieldindatabase'] = 'Энэ өгөгдлийн санд тодорхойлсон талбар байхгүй байна.';
$string['nofields'] = 'Одоогоор талбар байхгүй байна';
$string['nolisttemplate'] = 'Жагсаалтаар харах загварыг хараахан тодорхойлоогүй байна.';
$string['nomatch'] = 'Тохирох бичлэг олдсонгүй!';
$string['nomaximum'] = 'Дээд хязгаар байхгүй';
$string['nopreviewavailable'] = '{$a}-г урьдчилан харах боломжгүй';
$string['norecords'] = 'Одоогоор Бичлэг байхгүй байна';
$string['notapproved'] = 'Зөвшөөрөл хүлээж байна';
$string['notapprovederror'] = 'Бичлэгийг хараахан зөвшөөрөөгүй байна.';
$string['notemplates'] = 'Одоогоор загвар байхгүй байна';
$string['notinjectivemap'] = 'Хүчинтэй харгалзаа байхгүй байна';
$string['notopenyet'] = 'Уучлаарай, энэ үйлдэл {$a} хүртэл боломжгүй';
$string['number'] = 'Тоо';
$string['numberrssarticles'] = 'RSS мэдэгдэл дэх бичлэгүүд';
$string['numnotapproved'] = 'Хүлээж байна';
$string['numrecords'] = '{$a} бичлэгүүд';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Нээх огноог хаах огнооноос хойш тодорхойлсон байна';
$string['optionaldescription'] = 'Товч тайлбар (заавал биш)';
$string['optionalfilename'] = 'Файлын нэр (заавал биш)';
$string['other'] = 'Бусад';
$string['otherfields'] = 'Бусад бүх талбар';
$string['overrwritedesc'] = 'Ийм нэртэй урьдчилсан тохируулга аль хэдийн байгаа бол агуулгыг дарж бичих';
$string['overwrite'] = 'Дарж бичих';
$string['overwritesettings'] = 'Сэтгэгдэл, үнэлгээ гэх мэт одоогийн тохиргоог дарж бичих';
$string['page-mod-data-x'] = 'Өгөгдлийн сангийн үйл ажиллагааны модулийн дурын хуудас';
$string['pagesize'] = 'Хуудас бүр дэх бичлэгүүд';
$string['participants'] = 'Оролцогчид';
$string['picture'] = 'Зураг';
$string['pluginadministration'] = 'Өгөгдлийн сангийн үйл ажиллагааны удирдлага';
$string['pluginname'] = 'Өгөгдлийн сан';
$string['portfolionotfile'] = 'Файлаас илүү багц руу экспортлох (зөвхөн csv болон leap2a)';
$string['presetdeleted'] = 'Урьдчилсан тохируулгыг устгасан.';
$string['presetinfo'] = 'Урьдчилан тохируулга байдлаар хадгалснаар энэ загварыг нийтлэх болно. Бусад хэрэглэгчид үүнийг өгөгдлийн сандаа ашиглах боломжтой.';
$string['presetnotselected'] = 'Урьдчилсан тохируулга сонгоогүй байна';
$string['presets'] = 'Урьдчилсан тохируулгууд';
$string['presetshelp'] = 'Эхлэл болгон ашиглах урьдчилсан тохируулгыг сонгох.';
$string['preview'] = '{$a}-г урьдчилан харах';
$string['previewaction'] = 'Урьдчилан харах';
$string['privacy:metadata:commentpurpose'] = 'Өгөгдлийн сангийн бичлэгийн талаарх сэтгэгдэл';
$string['privacy:metadata:data_content'] = 'Тайлбарын агуулга';
$string['privacy:metadata:data_content:content'] = 'Агуулга';
$string['privacy:metadata:data_content:content1'] = 'Нэмэлт агуулга 1';
$string['privacy:metadata:data_content:content2'] = 'Нэмэлт агуулга 2';
$string['privacy:metadata:data_content:content3'] = 'Нэмэлт агуулга 3';
$string['privacy:metadata:data_content:content4'] = 'Нэмэлт агуулга 4';
$string['privacy:metadata:data_content:fieldid'] = 'Талбарын тодорхойлолтын ID';
$string['privacy:metadata:data_records'] = 'Өгөгдлийн сангийн үйл ажиллагааны бичлэг';
$string['privacy:metadata:data_records:approved'] = 'Зөвшөөрлийн төлөв';
$string['privacy:metadata:data_records:groupid'] = 'Бүлэг';
$string['privacy:metadata:data_records:timecreated'] = 'Бичлэгийг үүсгэсэн цаг';
$string['privacy:metadata:data_records:timemodified'] = 'Бичлэгийг сүүлд өөрчилсөн цаг';
$string['privacy:metadata:data_records:userid'] = 'Бичлэгийг үүсгэсэн хэрэглэгч';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Өгөгдлийн сангийн үйл ажиллагааны модулийн талбарууд';
$string['privacy:metadata:filepurpose'] = 'Өгөгдлийн сангийн бичлэгт хавсаргасан файл';
$string['privacy:metadata:ratingpurpose'] = 'Өгөгдлийн сангийн бичлэгийн үнэлгээ';
$string['privacy:metadata:tagpurpose'] = 'Өгөгдлийн сангийн бичлэгийн тагууд';
$string['radiobutton'] = 'Сэлгэх товчнууд';
$string['recordapproved'] = 'Бичлэгийг зөвшөөрсөн';
$string['recorddeleted'] = 'Бичлэгийг устгасан';
$string['recorddisapproved'] = 'Бичлэгийг зөвшөөрөөгүй';
$string['recordsnotsaved'] = 'Бичлэг хадгалсангүй. Серверт байршуулсан файлын форматыг шалгана уу.';
$string['recordssaved'] = 'Бичлэг хадгалагдлаа';
$string['removealldatatags'] = 'Бүх өгөгдлийн сангийн тагийг устгах';
$string['requireapproval'] = 'Зөвшөөрөл шаардлагатай';
$string['requireapproval_help'] = 'Бичлэгийг бүгдэд харуулахаас өмнө багш зөвшөөрнө.';
$string['required'] = 'Шаардлагатай';
$string['requiredentries'] = 'Дуусгахад шаардлагатай бичлэгүүд (хуучин)';
$string['requiredentries_help'] = 'Хэрэв тохируулсан бол дуусгахад шаардлагатай бичлэгийн тоог харуулсан зурвас гарч ирнэ. Энэ тохиргоо нь үйл ажиллагааг дуусгахтай холбогдоогүй гэдгийг анхаарна уу.

Үйл ажиллагааг дуусгахад шаардлагатай бичлэгийн хувьд  шинэ Үйл ажиллагаа дуусгах "Бичлэг шаардах" гэсэн тохиргоог ашиглах ёстой. Энэ тохиргоог бүрмөсөн устгахын тулд хоосон гэж тохируулаад өөрчлөлтүүдийг хадгална уу.
Оронд нь Үйл ажиллагааг дуусгах хэсэгт оруулах шаардлагатай талбаруудыг ашиглана уу.';
$string['requiredentriestoview'] = 'Харахаас өмнө бичлэг шаардлагатай';
$string['requiredentriestoview_help'] = 'Суралцагч бусад суралцагчийн бичлэгийг үзэхийг зөвшөөрөхөөс өмнө тэднийг хэдэн бичлэг нэмсэн байх ёстой тоог зааж өгнө.

Энэ нь өгөгдлийн санг автоматаар холбох шүүлтүүрт тохирохгүй.';
$string['requiredentrieswarning'] = 'Энэ тохиргоог Үйл ажиллагааг дуусгахад "Бичлэг шаардах" тохиргоогоор сольсон.';
$string['requiredfield'] = 'Шаардлагатай талбар';
$string['resetalltemplates'] = 'Бүх загварыг дахин тохируулах';
$string['resetalltemplatesconfirm'] = 'Та урьдчилан тохируулсан бүх загвараа устгах гэж байна. Хэрэв та загваруудыг дараа нь сэргээхийг хүсвэл \'Урьдчилан тохируулах\' таб дээрээс дахин урьдчилан тохируулахыг сонгох хэрэгтэй.';
$string['resetalltemplatesconfirmtitle'] = 'Бүх загварыг дахин тохируулах уу?';
$string['resetsettings'] = 'Шүүлтүүрүүдийг дахин тохируулах';
$string['resettemplate'] = 'Одоогийн загварыг дахин тохируулах';
$string['resettemplateconfirm'] = 'Энэ нь таны одоогийн урьдчилан тохируулсан {$a}-г бүрмөсөн устгах болно.';
$string['resettemplateconfirmtitle'] = 'Загварыг дахин тохируулах уу?';
$string['resizingimages'] = 'Зургийн жижигрүүлсэн хувилбарын хэмжээг өөрчилж байна...';
$string['rows'] = 'мөрүүд';
$string['rssglobaldisabled'] = 'Идэвхгүй болгосон. Хуудасны тохиргооны хувьсагчуудыг харна уу..';
$string['rsstemplate'] = 'RSS загвар';
$string['rsstitletemplate'] = 'RSS гарчгийн загвар';
$string['rsstype'] = 'Энэ ажилд зориулсан RSS мэдэгдэл';
$string['save'] = 'Хадгалах';
$string['saveandadd'] = 'Хадгалаад өөрийг нэмэх';
$string['saveandview'] = 'Хадгалаад харах';
$string['saveaspreset'] = 'Энэ хуудсанд урьдчилсан тохируулгыг нийтлэх';
$string['saveaspreset_help'] = 'Урьдчилан тохируулга байдлаар хадгалах функц нь загвар болон талбаруудыг хуудас дээрх бусад хүмүүс ашиглах боломжтой урьдчилан тохируулга байдлаар нийтэлдэг. (Үүнийг урьдчилан тохируулгын жагсаалтаас хүссэн үедээ устгах боломжтой.)';
$string['saveaspresetmissingcapability'] = 'Хэрэглэгч өгөгдлийн санг урьдчилан тохируулсан байдлаар хадгалах эрхгүй байна.';
$string['savedataaspreset'] = 'Бүх талбар, загварыг хадгалж энэ хуудсанд урьдчилсан тохируулга байдлаар нийтлэх';
$string['savesettings'] = 'Тохиргоог хадгалах';
$string['savesuccess'] = 'Урьдчилсан тохируулгыг хадгалсан. <a href="{$a->url}">Урьдчилсан тохируулгыг харах</a>';
$string['search'] = 'Хайх';
$string['search:activity'] = 'Өгөгдлийн сан - үйл ажиллагааны мэдээлэл';
$string['search:entry'] = 'Өгөгдлийн сан - бичлэгүүд';
$string['selectedrequired'] = 'Бүгдийг идэвхижүүлсэн байх шаардлагатай';
$string['selectexportoptions'] = 'Экспортлох тохиргоог сонго';
$string['selectfields'] = 'Талбаруудыг сонго';
$string['showall'] = 'Бүх бичлэгийг харуулах';
$string['showmore'] = 'Илүү ихийг харуулах';
$string['single'] = 'Ганцаарчилж харах';
$string['singletemplate'] = 'Ганцаарчлан харах загвар';
$string['singleview'] = 'Ганцаарчлан харах';
$string['startbuilding'] = 'Үйл ажиллагаагаа эхлүүлэх';
$string['subplugintype_datafield'] = 'Өгөгдлийн сангийн талбарын төрөл';
$string['subplugintype_datafield_plural'] = 'Өгөгдлийн сангийн талбарын төрлүүд';
$string['subplugintype_datapreset'] = 'Урьдчилсан тохируулга';
$string['subplugintype_datapreset_plural'] = 'Урьдчилсан тохируулгууд';
$string['tagarea_data_records'] = 'Өгөгдлийн бичлэгүүд';
$string['tags'] = 'Таг';
$string['tagsdeleted'] = 'Өгөгдлийн сангийн тагуудыг устгасан';
$string['teachersandstudents'] = '{$a->teachers} болон {$a->students}';
$string['templatereset'] = 'Загварыг дахин тохируулах';
$string['templateresetall'] = 'Бүх загварыг дахин тохируулах';
$string['templates'] = 'Загварууд';
$string['templatesaved'] = 'Загвар хадгалагдлаа';
$string['templatesnavigation'] = 'Гуравдагч удирдлагын мөрний загварууд';
$string['text'] = 'Бичвэр';
$string['textarea'] = 'Бичвэр талбар';
$string['timeadded'] = 'Цаг нэмэгдсэн';
$string['timemodified'] = 'Цагийг өөрчлсөн';
$string['type'] = 'Талбарын төрөл';
$string['undefinedprocessactionmethod'] = '"{$a}" үйлдлийг гүйцэтгэхийн тулд Data_Preset-д тодорхойлсон үйлдлийн арга байхгүй.';
$string['unknown'] = 'Үл мэдэх талбар';
$string['unsupportedfields'] = 'Дэмжигдээгүй талбарууд';
$string['unsupportedfieldslist'] = 'Дараах талбаруудыг экспортлох боломжгүй:';
$string['updatefield'] = 'Одоогийн талбарыг шинэчлэх';
$string['uploadfile'] = 'Файл байршуулах';
$string['uploadrecords'] = 'Файлаас бичлэг байршуулах';
$string['uploadrecords_help'] = 'Бичлэгүүдийг бичвэр файлаар байршуулж болно. Файлын бүтэц нь дараах байдалтай байх ёстой:

* Файлын мөр бүр нэг бичлэг агуулна
* Бичлэг бүр нь сонгосон тусгаарлагчаар тусгаарлагдсан өгөгдлийн цувраа байна
* Эхний бичлэг нь бусад файлын форматад тодорхойлсон шиг талбарын нэрийн жагсаалтыг агуулна

Талбарын хаалт нь бичлэг бүрийн талбар бүрийг тойрсон тэмдэгт юм. Үүнийг ихэвчлэн тохируулах орхиж болно.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Хайлтад оруул';
$string['usepredefinedset'] = 'Өмнө тодорхойлсон тохиргоог ашиглах';
$string['usepreset'] = 'Энэ урьдчилсан тохируулгыг ашиглах';
$string['usestandard'] = 'Урьдчилсан тохируулга ашиглах';
$string['usestandard_help'] = 'Веб-хуудсанд бүхэлд нь ашиглах боломжтой урьдчилсан тохируулгыг ашиглахын тулд жагсаалтаас сонгоно уу. (Хэрэв та урьдчилсан тохируулга байдлаар хадгалах функцийг ашиглан жагсаалтад урьдчилсан тохируулга нэмсэн бол устгах боломжтой.)';
$string['viewfromdate'] = 'Харж, уншиж болох эхлэл огноо:';
$string['viewnavigation'] = 'Гуравдагч удирдлагын мөрнийг харах горим';
$string['viewtemplates'] = 'Загваруудыг харах';
$string['viewtodate'] = 'Харж, уншиж болох дуусах огноо:';
$string['viewtodatevalidation'] = 'Уншиж болох эхлэл огноо нь дуусах огнооноос сүүлд байж болохгүй.';
$string['wrongdataid'] = 'Өгөгдлийн ID буруу байна';
