<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_tenant', language 'id', version '5.0'.
 *
 * @package     tool_tenant
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountalreadyconfirmedinfo'] = 'Akun {$a} dilewati karena sudah dikonfirmasi';
$string['accountconfirmedfail'] = 'Akun {$a} tidak ditemukan atau tidak dapat dikonfirmasi';
$string['accountconfirmedsuccess'] = 'Akun {$a} dikonfirmasi';
$string['activateusers'] = 'Aktifkan pengguna';
$string['activateusersintotenant'] = 'Aktifkan pengguna menjadi penyewa...';
$string['activateusersintotenantdescription'] = 'Harap pilih penyewa yang ingin Anda alokasikan penggunanya. Semua pengguna akan tetap memiliki peran mereka sebelumnya di penyewa baru yang dipilih, termasuk administrator penyewa.';
$string['activateusersintotenantfail'] = 'Pengguna {$a->users} tidak dapat dialokasikan ke \'{$a->tenant}\'!';
$string['activateusersintotenantsuccess'] = 'Semua pengguna sekarang aktif dan dialokasikan ke \'{$a->tenant}\'! <a href="{$a->link}">Kelola pengguna</a>';
$string['activateusersintotenantsuccesswithfails'] = 'Pengguna {$a->users} telah dialokasikan ke \'{$a->tenant}\' dan pengguna {$a->unsuspendedusers} sekarang aktif! <a href="{$a->link}">Kelola pengguna</a>';
$string['activetenants'] = 'Penyewa aktif';
$string['activeusers'] = 'Aktifkan akun pengguna';
$string['addtenant'] = 'Penyewa baru';
$string['adduser'] = 'Pengguna baru';
$string['admin'] = 'Administrator';
$string['administrators'] = 'Administrator';
$string['advanced'] = 'Lanjutan';
$string['advancedbrandingwarning'] = 'Perubahan apa pun yang Anda buat di sini dapat memengaruhi aksesibilitas situs dan pengalaman pengguna.';
$string['allocateusers'] = 'Alokasikan pengguna';
$string['alltenants'] = 'Semua penyewa';
$string['alltenantsselected'] = 'Pengguna di semua penyewa (termasuk yang akan datang)';
$string['allusers'] = 'Semua pengguna';
$string['alluserslegacy'] = 'Semua pengguna (lama)';
$string['andxmoretenants'] = 'dan {$a} lainnya...';
$string['archive'] = 'Arsip';
$string['archivedon'] = 'Diarsip pada';
$string['archivedtenants'] = 'Penyewa yang diarsip';
$string['assigntenantadmins'] = 'Tambahkan ke administrator penyewa';
$string['authdisabledavailable'] = 'Dinonaktifkan, tersedia';
$string['autheditstatus'] = 'Sunting status';
$string['authenabledoptional'] = 'Diaktifkan, opsional';
$string['authmethod'] = 'Metode autentikasi';
$string['authnewstatusfor'] = 'Status baru untuk {$a}';
$string['authpluginsettings'] = '{$a}. Pengaturan';
$string['authtypeofloginwarning'] = 'Beberapa penyewa menggunakan metode autentikasi tertentu. Untuk memberikan pengalaman yang konsisten bagi pengguna aplikasi seluler, sebaiknya ubah pengaturan \'typeoflogin\' dari \'Via the app\' ke opsi lain di <a href="{$a}">Halaman autentikasi seluler</a>.';
$string['availableinalltenants'] = 'Tersedia di semua penyewa';
$string['availableinalltenants_help'] = 'Bila diaktifkan, pengguna (dengan izin yang sesuai) di semua penyewa akan dapat melihat laporan ini. Sebagian besar sumber laporan akan secara otomatis membatasi pengguna dan entitas lain yang ditampilkan (program, sertifikasi, kursus) ke yang terlihat di dalam penyewa.';
$string['basicinformation'] = 'Informasi dasar';
$string['brand'] = 'Warna utama';
$string['brand_help'] = 'Warna semua tautan dan warna aksen situs';
$string['brandgraytones'] = 'Cocokkan warna abu-abu dengan warna utama';
$string['brandgraytones_help'] = 'Pilih warna merek, dan serangkaian warna pelengkap akan dibuat secara otomatis. Warna-warna ini akan menyorot berbagai bagian antarmuka pengguna seperti tautan, tombol, dll.';
$string['branding'] = 'Merek';
$string['buttoncolour'] = 'Warna tombol utama';
$string['buttoncolour_help'] = 'Tombol warna utama';
$string['cachedef_mytenant'] = 'Informasi tentang penyewa saat ini';
$string['cachedef_tenants'] = 'Daftar penyewa';
$string['cannotallocateusertotenant'] = 'Tidak dapat mengalokasikan pengguna ke penyewa yang diberikan';
$string['cannotarchivetenant'] = 'Tidak dapat mengarsip penyewa bawaan.';
$string['category'] = 'Kategori kursus';
$string['category_help'] = 'Administrator penyewa akan secara otomatis diberi peran \'Administrator penyewa dalam kategori kursus\' dalam kategori kursus ini, mereka akan dapat membuat kursus, menetapkan peran, dll.
Semua pengguna penyewa akan secara otomatis diberi peran \'Pengguna penyewa\' dalam kategori ini.<br><br>Hanya kategori di tingkat atas yang dapat dipilih sebagai kategori Penyewa.<br>
Jika \'Kategori baru\' dipilih, kategori dengan nama yang sama dengan nama Penyewa akan dibuat.';
$string['categorynameexist'] = 'Kategori dengan nama \'{$a}\' sudah ada di tingkat atas. Silakan pilih kategori ini atau pilih nama lain';
$string['categorynameexistws'] = 'Kategori dengan nama \'{$a}\' sudah ada di tingkat atas. Harap ubah nama penyewa atau buat tanpa kategori';
$string['categorynotfound'] = 'Kategori tidak ditemukan atau tidak berada di tingkat atas';
$string['categorytaken'] = 'Kategori ini ditugaskan ke penyewa lain.';
$string['changesite'] = 'Ubah situs';
$string['chooseexistingcategory'] = 'Pilih kategori yang ada';
$string['colours'] = 'Warna';
$string['conditionuserallocateddescription'] = 'Pengguna dialokasikan ke penyewa \'{$a}\'';
$string['conditionusernotallocateddescription'] = 'Pengguna tidak dialokasikan ke penyewa \'{$a}\'';
$string['configoverride'] = 'Timpakan';
$string['configoverrideellipsis'] = 'Timpakan...';
$string['configureoauth2link'] = 'Konfigurasikan layanan OAuth 2';
$string['configusedefault'] = 'Gunakan bawaan';
$string['confirmaccounts'] = 'Konfirmasi akun';
$string['confirmactivateuser'] = 'Apakah Anda yakin ingin mengaktifkan pengguna ini?';
$string['confirmactivateusers'] = 'Apakah Anda yakin ingin mengaktifkan pengguna yang dipilih?';
$string['confirmallocateusers'] = 'Apakah Anda yakin ingin mengalokasikan pengguna yang dipilih ke penyewa yang dipilih?';
$string['confirmarchivetenant'] = 'Apakah Anda yakin ingin mengarsip penyewa \'{$a}\'? Semua pengguna yang dialokasikan ke penyewa ini akan dipindahkan ke penyewa bawaan.';
$string['confirmarchivetenantwarning'] = 'Administrator penyewa akan menjadi pengguna reguler dan peran administrator penyewa tidak akan dipulihkan jika penyewa dipulihkan.';
$string['confirmarchivetenantwithoutusers'] = 'Apakah Anda yakin ingin mengarsip penyewa \'{$a}\'?';
$string['confirmarchivetenantwithusers'] = 'Apakah Anda yakin ingin mengarsip penyewa \'{$a->tenant}\'? Pengguna {$a->users} yang dialokasikan untuk penyewa ini akan ditangguhkan.';
$string['confirmassigntenantadmins'] = 'Apakah Anda yakin ingin menambahkan pengguna yang dipilih ke daftar administrator penyewa?';
$string['confirmdeletetenant'] = 'Apakah Anda yakin ingin menghapus penyewa \'{$a}\' secara permanen? Semua pengguna yang dialokasikan untuk penyewa ini akan dihapus.';
$string['confirmdeleteuser'] = 'Apakah Anda yakin ingin menghapus pengguna ini? Tindakan ini tidak dapat dibatalkan.';
$string['confirmdeleteusers'] = 'Apakah Anda yakin ingin menghapus pengguna yang dipilih? Tindakan ini tidak dapat dibatalkan.';
$string['confirmresendemailuser'] = 'Apakah Anda yakin ingin mengirim ulang surel konfirmasi ke pengguna ini?';
$string['confirmresendemailusers'] = 'Apakah Anda yakin ingin mengirim ulang surel konfirmasi ke pengguna terpilih? Tindakan ini tidak dapat dibatalkan.';
$string['confirmrestoretenant'] = 'Apakah Anda yakin ingin memulihkan penyewa \'{$a}\'? Semua pengguna yang dialokasikan ke penyewa ini akan menjadi aktif.';
$string['confirmsuspenduser'] = 'Apakah Anda yakin ingin menangguhkan pengguna ini?';
$string['confirmsuspendusers'] = 'Apakah Anda yakin ingin menangguhkan pengguna yang dipilih?';
$string['confirmunassigntenantadmins'] = 'Apakah Anda yakin ingin menghapus pengguna yang dipilih dari daftar administrator penyewa?';
$string['confirmunsuspenduser'] = 'Apakah Anda yakin ingin membatalkan penangguhan pengguna ini?';
$string['confirmunsuspendusers'] = 'Apakah Anda yakin ingin membatalkan penangguhan pengguna yang dipilih?';
$string['confirmuser'] = 'Konfirmasi pengguna';
$string['confirmusers'] = 'Konfirmasi pengguna';
$string['createnewcategory'] = 'Buat kategori baru';
$string['current'] = 'Saat ini';
$string['currentlysetting'] = 'Saat ini: {$a}';
$string['customcss'] = 'SCSS kustom';
$string['defaultdashboardconfiguration'] = 'Konfigurasi dasbor bawaan';
$string['defaultname'] = 'Penyewa bawaan';
$string['defaultsitedashboardpage'] = 'Halaman dasbor situs bawaan';
$string['defaulttenantmobileconfig'] = 'Ini adalah penyewa bawaan, oleh karena itu konfigurasinya akan selalu digunakan oleh aplikasi seluler.';
$string['deleteuser'] = 'Hapus pengguna';
$string['deleteusers'] = 'Hapus pengguna';
$string['editdashboard'] = 'Sunting dasbor';
$string['editdashboarddescription'] = 'Sunting dasbor untuk penyewa ini saja.';
$string['editdetailsinsharedspace'] = 'Sunting di Ruang bersama';
$string['editeachtenantoverride'] = 'Sunting pengaturan ini untuk setiap penyewa...';
$string['editeachtenantoverridetitle'] = 'Sunting \'{$a->setting}\' untuk setiap penyewa';
$string['editingdashboard'] = 'Anda sedang menyunting dasbor untuk \'{$a}\'';
$string['editingsitedashboard'] = 'Anda sedang menyunting halaman dasbor situs bawaan';
$string['editsettingfortenantoverride'] = 'Sunting \'{$a->setting}\' untuk {$a->tenant}';
$string['editspecifictenantoverride'] = 'Sunting pengaturan ini untuk \'{$a}\'...';
$string['edittenantname'] = 'Sunting nama';
$string['edittenantoverride'] = 'Sunting...';
$string['edituser'] = 'Sunting akun pengguna';
$string['edituserwithname'] = 'Sunting pengguna \'{$a}\'';
$string['emailsconfirmationresend'] = 'Kirim ulang surel konfirmasi';
$string['empty'] = 'Kosong';
$string['enablesharedspace'] = 'Aktifkan Ruang bersama';
$string['enrolinseparategroups'] = 'Kursus ini dapat dibagikan dengan penyewa lain tetapi pengguna dari penyewa yang berbeda akan dialokasikan ke grup terpisah';
$string['enrolwithoutgroups'] = 'Pengguna dari penyewa lain dapat terdaftar dalam kursus ini dan dapat saling melihat karena kursus ini tidak dalam mode grup terpisah';
$string['errorcannotallocate'] = 'Tidak dapat mengalokasikan ke penyewa';
$string['errorexperimentalmultidomain'] = 'Fitur percobaan domain individual per penyewa tidak lagi didukung. Harap sesuaikan konfigurasi - lihat <a href="{$a}">Memigrasikan konfigurasi multidomain</a>';
$string['errorinvalidtenant'] = 'Penyewa \'{$a}\' tidak valid';
$string['errormultidomainandtenant'] = 'Konfigurasi multi-penyewaan tidak valid. Harap sesuaikan konfigurasi - lihat <a href="{$a}">Memigrasikan konfigurasi multi-domain</a>';
$string['errornewcategorytenant'] = 'Parameter \'autocreatecategory\' dan \'categoryid\' tidak dapat digunakan bersamaan';
$string['errornopermissionaddcondition'] = 'Maaf, tetapi saat ini Anda tidak memiliki izin untuk melihat daftar penyewa';
$string['errornopermissionallocateusers'] = 'Tidak ada izin untuk mengalokasikan pengguna ke penyewa ini';
$string['errortenantarchived'] = 'Penyewa ini telah diarsip';
$string['errortenantidnumberunique'] = 'Nomor ID ini sudah digunakan di penyewa lain';
$string['errortenantnotfound'] = 'Penyewa ini tidak ada';
$string['errorurlnotavailable'] = 'Setidaknya satu URL Login harus tersedia.';
$string['errorwwwroot'] = 'Domain kustom harus berupa URL yang valid yang dimulai dengan http:// atau https:// tanpa tanda / di akhir. Domain kustom tidak boleh berisi jalur atau port.';
$string['eventtenantcreated'] = 'Penyewa dibuat';
$string['eventtenantdeleted'] = 'Penyewa dihapus';
$string['eventtenantupdated'] = 'Penyewa diperbarui';
$string['eventtenantusercreated'] = 'Pengguna dialokasikan ke penyewa';
$string['eventtenantuserupdated'] = 'Alokasi pengguna ke penyewa telah diubah';
$string['favicon'] = 'Favicon';
$string['footertext'] = 'Teks footer';
$string['forceforalltenants'] = 'Paksakan untuk semua penyewa';
$string['gotosharedspace'] = 'Pergi ke Ruang bersama';
$string['headerlogo'] = 'Logo header';
$string['headerlogo_help'] = 'Versi ringkas dari logo, seperti lambang, perisai, atau ikon yang digunakan di bilah navigasi atas.';
$string['idnumber'] = 'Nomor ID';
$string['idnumber_help'] = 'Nomor ID penyewa hanya digunakan saat mencocokkan dengan sistem eksternal atau di alat Unggah pengguna dan tidak ditampilkan di mana pun di situs. Jika penyewa memiliki nama kode resmi, nama tersebut dapat dimasukkan, jika tidak, kolom tersebut dapat dibiarkan kosong.';
$string['images'] = 'Gambar';
$string['invalidcolour'] = 'Kode warna ini tidak dalam format yang benar. Harap gunakan format #000 atau #000000.';
$string['ismultitenant'] = 'Multi-penyewa';
$string['issuernologin'] = 'Penerbit ini tidak dapat digunakan untuk masuk';
$string['linkalltenants'] = 'Tautkan semua penyewa...';
$string['linkalltenantscheckbox'] = 'Setel ulang dasbor untuk semua pengguna di penyewa yang terpengaruh';
$string['linkalltenantsdescription'] = 'Tindakan ini akan mengatur ulang semua penyewa yang tidak tertaut ke halaman dasbor situs Bawaan dan akan tetap menautkannya ke halaman ini mulai sekarang.';
$string['linkalltenantsmessage'] = 'Semua penyewa berhasil dihubungkan.';
$string['linkdashboard'] = 'Hapus dasbor yang dipersonalisasi, gunakan dasbor bawaan situs...';
$string['linkdashboarddescription'] = 'Saat ini, dasbor penyewa ini tidak disinkronkan dengan konten yang ditetapkan dalam \'Halaman dasbor situs bawaan\'. Klik tombol ini untuk menyinkronkannya kembali. Dengan demikian, setiap perubahan yang dibuat dalam \'Halaman dasbor situs bawaan\' akan memengaruhi dasbor penyewa ini.<br>Tindakan ini dapat dibatalkan di masa mendatang.';
$string['linkdashboarddescriptionforadmin'] = 'Saat ini, dasbor ini tidak disinkronkan dengan konten yang ditetapkan dalam \'Halaman dasbor situs bawaan\'. Klik tombol ini untuk menyinkronkannya kembali. Dengan demikian, perubahan apa pun yang dibuat dalam \'Halaman dasbor situs bawaan\' akan memengaruhi dasbor ini.<br>Tindakan ini dapat dibatalkan di masa mendatang.';
$string['linkdashboarddialog'] = 'Dengan melanjutkan, dasbor yang dipersonalisasi akan dihapus dan ditautkan ke konten yang ditentukan dalam \'Halaman dasbor situs bawaan\'. Tidak akan ada perubahan pada dasbor pengguna yang ada. Namun, dasbor tersebut dapat diatur ulang secara manual nanti.<br><br>Dasbor untuk pengguna baru akan dibuat dari \'Halaman dasbor situs bawaan\' yang dikontrol oleh administrator global.<br><br>Tindakan ini dapat dibatalkan di masa mendatang.';
$string['linkdashboarddialogforadmin'] = 'Dengan melanjutkan, dasbor penyewa ini akan ditautkan kembali ke konten yang ditentukan dalam \'Halaman dasbor situs bawaan\'. Mulai sekarang, setiap perubahan yang dibuat dalam \'Halaman dasbor situs bawaan\' akan memengaruhi dasbor penyewa ini. <br><br>Tidak akan ada perubahan pada dasbor pengguna yang sudah ada. Namun, dasbor tersebut dapat diatur ulang secara manual nanti.<br><br>Dasbor untuk pengguna baru dalam penyewa ini akan dibuat dari \'Halaman dasbor situs bawaan\'.<br><br>Tindakan ini dapat dibatalkan di masa mendatang.';
$string['linkdashboardmessage'] = 'Dasbor berhasil ditautkan';
$string['linkeddashboard'] = 'Tertaut ke \'Halaman dasbor situs bawaan\'.';
$string['loginbackground'] = 'Gambar latar belakang login';
$string['loginlogo'] = 'Logo login';
$string['loginlogo_help'] = 'Logo lengkap untuk digunakan sebagai dekorasi di halaman login.';
$string['loginurl'] = 'URL login';
$string['loginurl_help'] = 'URL yang dipilih akan ditampilkan kepada administrator penyewa dan mereka dapat meneruskannya kepada pengguna mereka agar tema penyewa dapat diterapkan sejak awal. Jika \'nomor ID\' tidak ditentukan, tautan idnumber tidak akan tersedia meskipun dipilih. Perhatikan bahwa selama pembuatan penyewa, id penyewa tidak tersedia.';
$string['lookingfordifferentsite'] = 'Cari situs lain?';
$string['management'] = 'Pengelolaan';
$string['managetenants'] = 'Kelola penyewa';
$string['migrationcoursecategories'] = 'Kategori kursus, dengan kelompok dan struktur kursus';
$string['migrationcreate'] = 'Buat penyewa baru';
$string['migrationdestinationsummary'] = 'Destinasi: {$a}';
$string['migrationexporterdescription'] = 'Penyewa beserta seluruh entitas yang ada di dalamnya';
$string['migrationlogerror'] = 'Tidak dapat mengimpor penyewa \'{$a}\'';
$string['migrationlogsuccess'] = 'Penyewa yang diimpor \'<a href="{$a->url}">{$a->name}</a>\'';
$string['migrationmappingerror'] = 'Beberapa penyewa tidak ada';
$string['migrationmappingerrorlog'] = 'Penyewa {$a} tidak ditemukan';
$string['migrationmerge'] = 'Gabungkan ke penyewa yang ada...';
$string['migrationmerge_help'] = 'Gabungkan informasi penyewa beserta entitas yang dipilih ke dalam penyewa yang sudah ada. Perhatikan bahwa detail dan tampilan (jika dipilih) akan ditimpa.';
$string['migrationmergeselecttenant'] = 'Pilih penyewa untuk menggabungkan';
$string['migrationmergetoomany'] = 'Hanya satu contoh yang dapat dipilih untuk digabungkan ke penyewa yang sudah ada';
$string['migrationselectalltenants'] = 'Pilih semua penyewa';
$string['migrationselectexcludingarchived'] = 'Pilih semua penyewa (kecuali yang diarsip)';
$string['migrationselectincludingarchived'] = 'Pilih semua penyewa (termasuk yang diarsip)';
$string['migrationselectmanually'] = 'Pilih penyewa secara manual...';
$string['missingtenant'] = 'Penyewa hilang';
$string['modurl:configtenantdata'] = 'Aktifkan jika Anda ingin menyertakan ID penyewa dan nomor ID dalam daftar variabel parameter yang tersedia.';
$string['modurl:tenantdata'] = 'Data penyewa';
$string['modurl:tenantdatadesc'] = 'Data penyewa dapat ditambahkan ke aktivitas URL';
$string['modurl:tenantid'] = 'ID penyewa';
$string['modurl:tenantidnumber'] = 'Nomor ID penyewa';
$string['movebetweentenants'] = 'Pindah antar penyewa';
$string['movetenant'] = 'Pindahkan penyewa \'{$a}\'';
$string['name'] = 'Nama penyewa';
$string['namewithempty'] = 'Nama penyewa (termasuk bukan penyewa)';
$string['navbarcolour'] = 'Warna bilah navigasi';
$string['navbarcolour_help'] = 'Warna latar belakang bilah navigasi atas';
$string['newname'] = 'Penyewa \'{$a}\' baru';
$string['newnamefor'] = 'Nama baru untuk \'{$a}\'';
$string['nocategory'] = 'Tidak ada kategori';
$string['nomanualassignment'] = 'Peran ini tidak dapat ditetapkan secara manual dalam konteks apa pun';
$string['noreplyaddressdescription'] = 'Surel noreply dikonfigurasikan di tingkat situs secara bawaan. Dengan memilih \'Timpakan\', surel baru dapat diberikan';
$string['notavailablefortenants'] = 'Tidak tersedia di penyewa mana pun';
$string['notnow'] = 'Tidak sekarang';
$string['notspecified'] = 'Tidak ditentukan';
$string['oauth2_alltenants'] = 'Layanan ini tersedia untuk semua penyewa (termasuk yang mendatang)';
$string['oauth2_exceptfollowingtenants'] = 'Layanan ini tersedia untuk semua penyewa kecuali yang berikut ini';
$string['oauth2_onlyfollowingtenants'] = 'Layanan ini hanya tersedia untuk penyewa berikut';
$string['oauth2_tenantavailability_success'] = 'Ketersediaan penyewa layanan diperbarui dengan benar';
$string['oauth2availableforlogin'] = 'Layanan OAuth 2 tersedia untuk login.';
$string['organisationadmintab'] = 'Organisasi';
$string['outcomeallocation'] = 'Alokasikan pengguna ke penyewa';
$string['outcomeallocationdescription'] = 'Alokasikan pengguna ke penyewa \'{$a}\'';
$string['overridden'] = 'Ditimpa';
$string['overrideerror'] = 'Terjadi galat dengan proses penimpaan pengaturan';
$string['overridesetting'] = 'Izinkan penyewa untuk menimpa \'{$a}\'';
$string['overridesetting_help'] = '**Pengaturan multi-penyewa**

Jika situs ini berisi lebih dari satu penyewa, nilai yang ditetapkan untuk pengaturan ini akan berfungsi sebagai **nilai bawaan untuk semua penyewa**.

Dengan mengaktifkan atau menonaktifkan opsi ini, Anda dapat mengizinkan atau membatasi penyewa lain untuk menimpa nilai pengaturan ini:

* **Diaktifkan**: Administrator penyewa dapat menimpa pengaturan ini untuk penyewa tertentu, yang hanya memengaruhi penyewa tersebut.

* **Dinonaktifkan**: Nilai pengaturan ini akan ditetapkan sebagai nilai bawaan untuk semua penyewa, dan administrator penyewa tidak akan dapat menimpa nilainya untuk penyewa tertentu.';
$string['pluginname'] = 'Multi-penyewaan';
$string['privacy:metadata:user'] = 'Alokasi pengguna ke penyewa';
$string['privacy:metadata:user:component'] = 'Komponen yang bertanggung jawab untuk alokasi';
$string['privacy:metadata:user:id'] = 'ID';
$string['privacy:metadata:user:reason'] = 'Alasan untuk alokasi';
$string['privacy:metadata:user:tenantid'] = 'Penyewa';
$string['privacy:metadata:user:timecreated'] = 'Waktu dialokasi';
$string['privacy:metadata:user:timemodified'] = 'Waktu dimodifikasi';
$string['privacy:metadata:user:userid'] = 'Pengguna';
$string['privacy:metadata:user:usermodified'] = 'Pengguna yang mengubah rekaman';
$string['profilecategory_alltenants'] = 'Kategori ini tersedia untuk semua penyewa (termasuk yang mendatang)';
$string['profilecategory_exceptfollowingtenants'] = 'Kategori ini tersedia untuk semua penyewa kecuali yang berikut ini';
$string['profilecategory_onlyfollowingtenants'] = 'Kategori ini hanya tersedia untuk penyewa berikut';
$string['reg_wpmultitenantsettingsoverridden'] = 'Jumlah nilai pengaturan yang telah ditimpa dalam penyewa ({$a})';
$string['reg_wpsharedspaceenabled'] = 'Ruang bersama diaktifkan ({$a})';
$string['reg_wptenantdomains'] = 'Jumlah penyewa dengan domain kustom yang ditetapkan ({$a})';
$string['reg_wptenants'] = 'Jumlah penyewa ({$a})';
$string['resendemailsentfail'] = '{$a} pengguna tidak ditemukan atau tidak dapat dikirimi surel konfirmasi';
$string['resendemailsentsuccess'] = 'Surel konfirmasi dikirim ke {$a} pengguna';
$string['resendemailuser'] = 'Kirim ulang surel ke pengguna';
$string['resetappearance'] = 'Setel ulang tampilan';
$string['resetdashboard'] = 'Setel ulang dasbor untuk semua pengguna...';
$string['resetdashboarddescription'] = 'Setel ulang dasbor untuk semua pengguna di penyewa ini saja.';
$string['resetdashboarddialog'] = 'Dengan melanjutkan, dasbor akan disetel ulang untuk semua pengguna.<br><br>Tindakan ini tidak dapat dibatalkan.';
$string['resetdashboarddialogforadmin'] = 'Dengan melanjutkan, dasbor akan disetel ulang untuk semua pengguna di penyewa ini.<br><br>Tindakan ini tidak dapat dibatalkan.';
$string['resetdashboardmessage'] = 'Dasbor berhasil disetel ulang untuk semua pengguna.';
$string['resetlinkeddashboard'] = 'Setel ulang dasbor untuk semua pengguna di penyewa yang tertaut...';
$string['resetlinkeddashboarddialog'] = 'Dengan melanjutkan, dasbor akan disetel ulang untuk semua pengguna di penyewa yang terhubung.<br><br>Tindakan ini tidak dapat dibatalkan';
$string['resetlinkeddashboardmessage'] = 'Semua dasbor pengguna berhasil disetel ulang.';
$string['resettenantappearance'] = 'Setel ulang tampilan penyewa';
$string['resettenantappearancecolours'] = 'Setel ulang semua warna kustom';
$string['resettenantappearancecss'] = 'Hapus SCSS kustom';
$string['resettenantappearancedesc'] = 'Dengan mengklik tombol ini, Anda akan dapat memilih elemen mana (gambar, warna, dll.) yang akan dikembalikan ke standar aksesibilitas.';
$string['resettenantappearancefooter'] = 'Hapus teks footer';
$string['resettenantappearanceformend'] = 'Tindakan ini tidak dapat dibatalkan';
$string['resettenantappearanceformintro'] = 'Setel ulang konfigurasi penyewa ini ke konfigurasi akses bawaan. <br> Tindakan ini akan:';
$string['resettenantappearanceimages'] = 'Hapus semua gambar yang diunggah (logo, latar belakang)';
$string['saml2_alltenants'] = 'IdP ini tersedia untuk semua penyewa (termasuk yang mendatang)';
$string['saml2_exceptfollowingtenants'] = 'IdP ini tersedia untuk semua penyewa kecuali yang berikut ini';
$string['saml2_onlyfollowingtenants'] = 'IdP ini hanya tersedia untuk penyewa berikut';
$string['saml2_tenantavailability_success'] = 'Ketersediaan penyewa IdP berhasil diperbarui';
$string['saml2availableforlogin'] = 'Penyedia identitas SAML2 tersedia untuk masuk.';
$string['seealltenants'] = 'Lihat semua';
$string['selecttenant'] = 'Pilih penyewa';
$string['selecttenantoutcome'] = 'Pilih penyewa';
$string['selecttenants'] = 'Pilih penyewa';
$string['selectuser'] = 'Pilih pengguna \'{$a}\'';
$string['settingnotoverriden'] = 'Penyewa tidak dapat menimpa pengaturan ini sekarang';
$string['settingoverriden'] = 'Penyewa dapat menimpa pengaturan ini sekarang';
$string['settingoverridensaved'] = 'Pengaturan berhasil disimpan untuk: {$a}';
$string['settingoverridensavedselectedtenant'] = 'Pengaturan berhasil disimpan untuk penyewa yang dipilih';
$string['settingtenantvalue'] = '{$a->tenantname}: <i>{$a->tenantvalue}</i>';
$string['sharedspace'] = 'Ruang bersama';
$string['sharedspaceconfirmationtext'] = 'Ruang bersama adalah tempat bagi Anda untuk berbagi entitas dan konten di antara semua penyewa. Semua yang Anda buat di dalam ruang ini akan langsung tersedia bagi pengguna di setiap penyewa jika mereka memiliki izin yang benar. <br/> Setelah Ruang bersama diaktifkan, ruang tersebut tidak dapat dinonaktifkan. <br/> Apakah Anda ingin mengaktifkan Ruang bersama?';
$string['sharedspaceenabledmessage'] = 'Ruang bersama berhasil diaktifkan. Gunakan alih penyewa di bilah navigasi untuk mengaksesnya.';
$string['showintenantselector'] = 'Tampilkan penyewa ini di pemilih login';
$string['showintenantselector_help'] = 'Dengan mengaktifkan opsi ini, penyewa ini akan dicantumkan pada halaman login setiap penyewa sebagai halaman login alternatif.';
$string['showtenantselector'] = 'Tampilkan pemilih penyewa di halaman login';
$string['showtenantselector_help'] = 'Dengan mengaktifkan opsi ini, pengguna akan dapat beralih di antara penyewa yang berbeda di halaman login. Setiap penyewa dapat mengatur visibilitasnya secara individual dalam daftar ini.';
$string['siteleveldefault'] = 'Bawaan tingkat situs';
$string['sitelevelsetting'] = 'Gunakan pengaturan tingkat situs';
$string['sitename'] = 'Nama situs';
$string['sitename_help'] = 'Memungkinkan penggantian nama bawaan situs untuk pengguna dari penyewa ini';
$string['siteshortname'] = 'Nama pendek situs';
$string['siteshortname_help'] = 'Memungkinkan penimpaan nama pendek bawaan situs untuk pengguna dari penyewa ini. <br> Nama pendek situs akan ditampilkan di header jika bidang \'Logo header\' (dalam konfigurasi merek penyewa) dibiarkan kosong.';
$string['siteshortnamedesc'] = 'Nama pendek situs akan ditampilkan di header jika kolom \'Logo header\' (dalam konfigurasi merek penyewa) dibiarkan kosong.';
$string['siteuserlimit'] = 'Batasan pengguna situs';
$string['siteuserlimit_desc'] = 'Jumlah maksimum akun pengguna yang diizinkan di situs';
$string['siteuserlimitenabled'] = 'Aktifkan batas pengguna situs';
$string['status'] = 'Status';
$string['supportavailability'] = 'Ketersediaan dukungan';
$string['supportavailabilitydescription'] = 'Ketersediaan dukungan dikonfigurasikan di tingkat situs secara bawaan. Dengan memilih \'Timpa\', ketersediaan baru dapat disediakan';
$string['supportemail'] = 'Surel dukungan';
$string['supportemaildescription'] = 'Surel dukungan dikonfigurasikan di tingkat situs secara bawaan. Dengan memilih \'Timpa\', email baru dapat diberikan';
$string['supportname'] = 'Nama dukungan';
$string['supportnamedescription'] = 'Nama dukungan dikonfigurasikan di tingkat situs secara bawaan. Dengan memilih \'Timpa\', nama baru dapat diberikan';
$string['supportpage'] = 'Tautkan ke \'Hubungi dukungan situs\'';
$string['supportpagedescription'] = 'URL untuk \'Hubungi dukungan situs\' dikonfigurasikan di tingkat situs secara bawaan. Dengan memilih \'Timpa\', URL baru dapat diberikan';
$string['suspendedusers'] = 'Pengguna yang ditangguhkan';
$string['suspenduser'] = 'Tangguhkan pengguna';
$string['suspendusers'] = 'Tangguhkan pengguna';
$string['switchedto'] = 'Anda telah beralih ke \'{$a}\'';
$string['switchtenant'] = 'Alih penyewa';
$string['tenant'] = 'Penyewa';
$string['tenant:allocate'] = 'Alokasikan pengguna ke semua penyewa';
$string['tenant:authconfig'] = 'Sunting pengaturan autentikasi penyewa';
$string['tenant:browseusers'] = 'Telusuri pengguna di penyewa saat ini';
$string['tenant:manage'] = 'Kelola penambahan dan penyuntingan penyewa';
$string['tenant:managedashboard'] = 'Kelola pengaturan dasbor untuk penyewa saat ini';
$string['tenant:managetheme'] = 'Kelola pengaturan tema untuk penyewa saat ini';
$string['tenant:managethemeadvanced'] = 'Kelola pengaturan tema lanjutan untuk penyewa saat ini';
$string['tenant:manageusers'] = 'Tambahkan dan sunting pengguna untuk penyewa saat ini';
$string['tenant:mobileconfig'] = 'Sunting pengaturan seluler penyewa';
$string['tenantadmin'] = 'Administrator penyewa';
$string['tenantadminalreadyassigned'] = '{$a} pengguna dilewati karena mereka sudah menjadi administrator penyewa';
$string['tenantadminalreadyunassigned'] = '{$a} pengguna dilewati karena mereka bukan administrator penyewa';
$string['tenantadmincapabilitieslimit'] = 'Kapabilitas yang tidak kompatibel dengan Multi-penyewaan tidak tercantum di sini. <a href="{$a}">Info selengkapnya</a>';
$string['tenantadmindescription'] = 'Peran administrator penyewa tempat kerja. Ditetapkan secara otomatis kepada administrator penyewa dalam konteks sistem.';
$string['tenantadministration'] = 'Administrasi penyewa';
$string['tenantadministrator'] = 'Pengguna ini adalah administrator penyewa';
$string['tenantadmins'] = 'Administrasi penyewa';
$string['tenantarchivedsuccess'] = 'Penyewa \'{$a}\' telah diarsip! Semua pengguna yang dialokasikan telah ditangguhkan.';
$string['tenantavailability'] = 'Sunting ketersediaan penyewa';
$string['tenantavailabilityfor'] = 'Ketersediaan penyewa untuk \'{$a}\'';
$string['tenantcategorycapabilitieslimit'] = 'Hanya kapabilitas yang dapat diatur dalam konteks kategori kursus yang tercantum di sini';
$string['tenantdeleted'] = 'Penyewa \'{$a}\' telah dihapus.';
$string['tenantdetails'] = 'Rincian';
$string['tenantlimit'] = 'Batasan penyewa';
$string['tenantlimit_desc'] = 'Jumlah maksimum penyewa yang diizinkan dalam sistem, baik penyewa yang aktif maupun yang diarsip dihitung.';
$string['tenantlimitenabled'] = 'Aktifkan batas penyewa';
$string['tenantlimitenabled_desc'] = 'Jika ini diaktifkan, dimungkinkan untuk membatasi jumlah penyewa di situs ini.';
$string['tenantlimitreached'] = 'Batas penyewa tercapai';
$string['tenantlimitreached1'] = 'Fitur multi-penyewaan tidak diaktifkan di situs ini';
$string['tenantlimitreachedmult'] = 'Anda hanya dapat membuat {$a} penyewa di situs ini. Harap perhatikan bahwa penyewa yang diarsip juga dihitung dalam batasan ini';
$string['tenantmanager'] = 'Administrator penyewa dalam kategori kursus';
$string['tenantmanagerdescription'] = 'Peran administrator penyewa tempat kerja kedua. Ditugaskan secara otomatis kepada administrator penyewa dalam konteks kategori kursus mereka.';
$string['tenantnotfound'] = 'Penyewa tidak ditemukan';
$string['tenantrestoredsuccess'] = 'Penyewa \'{$a->tenant}\' telah dipulihkan! Semua pengguna yang dialokasikan ke penyewa ini sekarang aktif. <a href="{$a->link}">Kelola pengguna</a>.';
$string['tenants'] = 'Penyewa';
$string['tenantselectorlogo'] = 'Logo pemilih penyewa';
$string['tenantselectorlogo_help'] = 'Logo ini akan membantu mengidentifikasi penyewa ini di pemilih penyewa login (jika fitur pemilih penyewa diaktifkan). Jika tidak ditentukan, logo login akan digunakan.';
$string['tenantsexceptselected'] = 'Pengguna di semua penyewa kecuali berikut ini';
$string['tenantsexceptselecteddesc'] = 'Pengguna di semua penyewa kecuali berikut ini:  {$a}';
$string['tenantsselected'] = 'Pengguna di penyewa berikut';
$string['tenantsselecteddesc'] = 'Pengguna di penyewa berikut: {$a}';
$string['tenantuser'] = 'Pengguna penyewa';
$string['tenantuserdescription'] = 'Peran pengguna penyewa tempat kerja. Ditugaskan secara otomatis kepada semua pengguna penyewa dalam konteks pada kategori kursus mereka.';
$string['tenantuserlimit'] = 'Batasan pengguna penyewa';
$string['tenantuserlimit_desc'] = 'Jumlah maksimum akun pengguna yang diizinkan per penyewa.';
$string['tenantuserlimitenabled'] = 'Aktifkan batas pengguna penyewa';
$string['tenantusers'] = 'Pengguna penyewa';
$string['themesettingssaved'] = 'Pengaturan tema telah disimpan. Mungkin perlu waktu beberapa menit sebelum perubahan terlihat di situs.';
$string['toomanytenantstoshow'] = 'Terlalu banyak penyewa untuk ditampilkan';
$string['unassigntenantadmins'] = 'Hapus dari administrator penyewa';
$string['unlinkdashboard'] = 'Buat dasbor yang dipersonalisasi...';
$string['unlinkdashboarddescription'] = 'Saat ini, dasbor penyewa ini ditautkan ke konten yang ditentukan dalam \'Halaman dasbor situs bawaan\'. Klik tombol ini untuk membuat halaman dasbor untuk penyewa ini yang dapat dikonfigurasi secara individual.<br>Tindakan ini dapat dibatalkan di masa mendatang.';
$string['unlinkdashboarddescriptionforadmin'] = 'Saat ini, dasbor ini ditautkan ke konten yang ditetapkan dalam \'Halaman dasbor situs bawaan\'. Klik tombol ini untuk membuat halaman dasbor independen yang dapat dikonfigurasi secara individual.<br>Tindakan ini dapat dibatalkan di masa mendatang.';
$string['unlinkdashboarddialog'] = 'Dengan melanjutkan, dasbor ini tidak akan lagi ditautkan ke konten yang ditetapkan dalam \'Halaman dasbor situs bawaan\'. Sebaliknya, dasbor ini akan menjadi halaman dasbor independen yang dapat dikonfigurasi secara individual.<br><br>Dasbor individual dari pengguna yang ada tidak akan diubah.<br><br>Tindakan ini dapat dibatalkan di masa mendatang';
$string['unlinkdashboarddialogforadmin'] = 'Dengan melanjutkan, dasbor penyewa ini tidak akan lagi ditautkan ke konten yang ditetapkan dalam \'Halaman dasbor situs bawaan\'. Sebaliknya, dasbor ini akan menjadi halaman dasbor independen yang dapat dikonfigurasi secara individual.<br><br>Dasbor tidak akan segera disetel ulang untuk pengguna di penyewa ini. Namun, hal itu dapat dilakukan secara manual nanti.<br><br>Tindakan ini dapat dibatalkan di masa mendatang';
$string['unlinkdashboardmessage'] = 'Dasbor berhasil dibatalkan tautan';
$string['unlinkeddashboard'] = 'Dibatalkan tautan';
$string['unrecognisedaction'] = 'Tindakan tidak dikenal';
$string['unsuspenduser'] = 'Batal tangguhkan pengguna';
$string['unsuspendusers'] = 'Batal tangguhkan pengguna';
$string['useractivatedsuccess'] = 'Pengguna berhasil diaktifkan';
$string['useralreadyconfirmedinfo'] = '{$a} pengguna dilewati karena sudah dikonfirmasi';
$string['userconfirmedfail'] = '{$a} pengguna tidak ditemukan atau tidak dapat dikonfirmasi';
$string['userconfirmedsuccess'] = '{$a} pengguna dikonfirmasi';
$string['userdeletedfail'] = '{$a} pengguna tidak ditemukan atau tidak dapat dihapus';
$string['userdeletedsuccess'] = '{$a} pengguna dihapus';
$string['usermanagement'] = 'Manajemen pengguna';
$string['usermovetotenant'] = '{$a->count} pengguna dipindahkan ke penyewa: {$a->tenant}';
$string['usernotmovetotenant'] = '{$a->count} pengguna tidak dapat dipindahkan ke penyewa: {$a->tenant}';
$string['usersactivatedfail'] = '{$a} pengguna tidak ditemukan atau tidak dapat diaktifkan';
$string['usersactivatedsuccess'] = '{$a} pengguna diaktifkan';
$string['usersallocatedtotenant'] = 'Pengguna yang dialokasikan ke penyewa';
$string['usersassignedtenantadminfail'] = 'Tidak dapat menambahkan {$a} pengguna ke daftar administrator penyewa';
$string['usersassignedtenantadminsuccess'] = 'Menambahkan {$a} pengguna ke daftar administrator penyewa';
$string['userscount'] = 'Pengguna';
$string['userslimitreached'] = 'Batas akun pengguna telah tercapai';
$string['usersnotallocatedtotenant'] = 'Pengguna tidak dialokasikan ke penyewa';
$string['userssuspendedfail'] = '{$a} pengguna tidak ditemukan atau tidak dapat ditangguhkan';
$string['userssuspendedsuccess'] = '{$a} pengguna ditangguhkan';
$string['usersunassignedtenantadminfail'] = 'Tidak dapat menghapus {$a} pengguna dari daftar administrator penyewa';
$string['usersunassignedtenantadminsuccess'] = 'Menghapus {$a} pengguna dari daftar administrator penyewa';
$string['usersunsuspendedfail'] = '{$a} pengguna tidak ditemukan atau tidak dapat dibatalkan penangguhannya';
$string['usersunsuspendedsuccess'] = '{$a} pengguna tidak ditangguhkan';
$string['usersuspendedsuccess'] = 'Pengguna berhasil ditangguhkan';
$string['usertenant'] = 'Pengguna penyewa';
$string['userunsuspendedsuccess'] = 'Pengguna berhasil dibatal tangguhannya';
$string['value'] = 'Nilai';
$string['wwwroot'] = 'Domain kustom';
$string['wwwroot_help'] = 'Tentukan URL yang harus digunakan untuk penyewa ini. Sebelum melakukannya, pastikan DNS sudah diatur sehingga URL mengarah ke situs yang sama.';
