<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'cs', version '5.0'.
 *
 * @package     facetoface
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = 'Přidat nový termín cvičení v {$a}';
$string['addmanageremailaddress'] = 'Přidat e-mailovou adresu managera';
$string['addmanageremailinstruction'] = 'Dosud jste nezadali e-mailovou adresu svého manažera. Chcete-li se přihlásit na tento termín cvičení, zadejte ji níže.';
$string['addnewfield'] = 'Přidat nové vlastní pole';
$string['addnewfieldlink'] = 'Vytvořit nové vlastní pole';
$string['addnewnotice'] = 'Přidat nové oznámení stránek';
$string['addnewnoticelink'] = 'Vytvořit nové oznámení stránek';
$string['addremoveattendees'] = 'Přidat / odebrat účastníky';
$string['addsession'] = 'Přidat nový termín cvičení';
$string['addstudent'] = 'Přidat studenta';
$string['addtoallsessions'] = 'Přidejte uživatele do všech (nadcházejících) cvičení';
$string['addtoallsessions_help'] = 'Tuto možnost použijte, pokud chcete přidat uživatele do všech nadcházejících cvičení Face-to-Face. Když je tato volba přepnuta, vybraní uživatelé budou přidáni do cvičení  a všech dalších budoucích cvičení v aktivitě.';
$string['alllocations'] = 'Všechny lokality';
$string['allowcancellations'] = 'Povolit zrušení registrace';
$string['allowcancellations_help'] = 'Pokud je zaškrtnuto, budou účastníci praktického cvičení moci zrušit své registrace';
$string['allowcancellationsdefault'] = 'Povolit výchozí zrušení registrace';
$string['allowcancellationsdefault_help'] = 'Pokud je zaškrtnuto, bude při vytváření nových termínů cvičení pro tuto aktivitu výchozím nastavením povoleno zrušení registrace';
$string['allowoverbook'] = 'Povolit přihlášení nad limit';
$string['allowoverbook_help'] = 'Pokud je zaškrtnuto políčko „Povolit zápis přes limit“, studenti se budou moci přihlásit k termínu cvičení, i když je již plné. <br />

Když se student přihlásí na praktické cvičení, která je již plné, obdrží e-mail s upozorněním, že byl zařazen do čekací listiny a bude upozorněn, jakmile bude rezervace k dispozici.';
$string['allsessionsin'] = 'Všechna praktická cvičení v {$a}';
$string['alreadysignedup'] = 'Pro tuto aktivitu praktické cvičení jste se již zaregistrovali.';
$string['answer'] = 'Přihlásit se';
$string['answercancel'] = 'Odhlásit se';
$string['approvalreqd'] = 'Povinné schválení';
$string['approvalreqd_help'] = 'Je-li zaškrtnuto políčko „Povinné schválení “, bude student potřebovat souhlas svého manažera, aby se mohl praktického cvičení zúčastnit .';
$string['approve'] = 'Schválit';
$string['assessmentyour'] = 'Vaše hodnocení';
$string['attendance'] = 'Hodnocení';
$string['attendanceinstructions'] = 'Vyberte uživatele, kteří se zúčastnili praktického cvičení:';
$string['attendedsession'] = 'Hodnocení praktického cvičení';
$string['attendees'] = 'Účastníci';
$string['attendeesexporttofileheading'] = 'Export účastníků do souboru';
$string['booked'] = 'Rezervováno';
$string['bookingcancelled'] = 'Vaše rezervace byla zrušena.';
$string['bookingcompleted'] = 'Vaše rezervace byla dokončena.';
$string['bookingfull'] = 'Rezervace je obsazena';
$string['bookingopen'] = 'Rezervace je otevřena';
$string['bookingstatus'] = 'Máte rezervaci na následující termín praktického cvičení';
$string['calendareventdescriptionbooking'] = 'Máte rezervaci na toto <a href="{$a}">termín praktického cvičení</a>.';
$string['calendareventdescriptionsession'] = 'Vytvořili jste tento <a href="{$a}">termín praktického cvičení </a>.';
$string['calendaroptions'] = 'Možnosti kalendáře';
$string['cancelbooking'] = 'Zrušit rezervaci';
$string['cancelbookingfor'] = 'Zrušit rezervaci na {$a}';
$string['cancellation'] = 'Zrušení';
$string['cancellationconfirm'] = 'Opravdu chcete zrušit rezervaci na tento termín praktického cvičení?';
$string['cancellationinstrmngr'] = '# Oznámení pro manažera';
$string['cancellationinstrmngr_help'] = 'Když je zaškrtnuto ** Odeslat oznámení manažerovi **, text v poli ** Oznámení pro manažera ** bude zasláno manažerovi studentů upozornění, že zrušili rezervaci na praktické cvičení.';
$string['cancellationmessage'] = 'Zrušení zpráv';
$string['cancellationmessage_help'] = 'Tato zpráva se odešle pokaždé, když uživatelé zruší svou rezervaci na praktické cvičení.';
$string['cancellations'] = 'Zrušení';
$string['cancellationsent'] = 'Okamžitě byste měli obdržet e-mail o zrušení.';
$string['cancellationsentmgr'] = 'Vy a váš manažer byste měli okamžitě obdržet e-mail o zrušení.';
$string['cancellationstablesummary'] = 'Seznam lidí, kteří zrušili přihlášení k praktickému cvičení.';
$string['cancelreason'] = 'Důvod';
$string['cannotapproveatcapacity'] = 'Nelze schválit žádné další účastníky, protože tento termín praktického cvičení je obsazen.';
$string['cannotsignupsessioninprogress'] = 'Nemůžete se zaregistrovat, toto praktické cvičení probíhá';
$string['cannotsignupsessionover'] = 'Nemůžete se zaregistrovat, toto praktické cvičení skončilo.';
$string['capacity'] = 'Kapacita';
$string['capacity_help'] = '**Capacity** je dostupný počet míst v termínu praktického cvičení.

Když termín praktického cvičení dosáhne kapacity, podrobnosti praktického cvičení se nezobrazí na stránce kurzu. Podrobnosti se zobrazí šedě na stránce „Zobrazit všechny termíny cvičení“ a student se nemůže přihlásit.
 ';
$string['caseinsensitive'] = 'Nerozlišují se malá a velká písmena';
$string['changemanageremailaddress'] = 'Změnit e-mailovou adresu manažera';
$string['changemanageremailinstruction'] = 'Zadejte e-mailovou adresu svého současného manažera';
$string['clearall'] = 'Vymazat vše';
$string['closed'] = 'Uzavřeno';
$string['completiondetail:attendance'] = 'Vyžadovat účast';
$string['completiondetail:attendance_disabled'] = 'Účast není nutná';
$string['completiondetail:attendance_full'] = 'Je nutná plná účast';
$string['completiondetail:attendance_partial'] = 'Je nutná alespoň částečná účast';
$string['conditions'] = 'Podmínky';
$string['conditionsexplanation'] = 'Aby bylo oznámení uvedeno v kalendáři školení, musí být splněna všechna tato kritéria:';
$string['confirm'] = 'Potvrdit';
$string['confirmanager'] = 'Potvrdit e-mailovou adresu manažera';
$string['confirmation'] = 'Potvrzení';
$string['confirmationinstrmngr'] = '# Oznámení pro manažera';
$string['confirmationinstrmngr_help'] = 'Je-li zaškrtnuto políčko „Odeslat oznámení manažerovi“, text v poli „Oznámení pro manažera“ se odešle manažerovi s upozorněním, že se zaměstnanec zaregistroval na termín praktického cvičení.';
$string['confirmationmessage'] = 'Potvrzovací zpráva';
$string['confirmationmessage_help'] = 'Tato zpráva se odešle pokaždé, když se uživatelé přihlásí na praktické cvičení.';
$string['confirmationsent'] = 'Okamžitě byste měli obdržet potvrzovací e-mail.';
$string['confirmationsentmgr'] = 'Vy a váš manažer byste měli okamžitě obdržet potvrzovací e-mail.';
$string['confirmmanageremailaddress'] = 'Potvrdit e-mailovou adresu manažera';
$string['confirmmanageremailaddressquestion'] = 'Je stále <b> {$a} </b> e-mailovou adresou manažera?';
$string['confirmmanageremailinstruction1'] = 'Jako e-mailovou adresu manažera jste zadali následující údaje:';
$string['confirmmanageremailinstruction2'] = 'Je to stále e-mailová adresa manažera?';
$string['continuetologin'] = 'Klepnutím na tlačítko Pokračovat se přihlásíte';
$string['copy'] = 'Kopírovat';
$string['copyingsession'] = 'Kopírovat jako nový termín praktického cvičení v {$a}';
$string['copysession'] = 'Kopírovat termín praktického cvičení';
$string['cost'] = 'Cena';
$string['costheading'] = 'Cena';
$string['crontask'] = 'Úkoly údržby modulu Praktické cvičení';
$string['currentstatus'] = 'Aktuální stav';
$string['customfieldid'] = 'ID vlastního pole';
$string['customfieldnewshortname'] = 'Nový krátký název vlastního pole';
$string['customfieldoriginalshortname'] = 'Původní zkrácený název vlastního pole';
$string['customfieldsheading'] = 'Vlastní pole cvičení';
$string['date'] = 'Termín';
$string['dateadd'] = 'Přidat nový termín';
$string['dateremove'] = 'Odebrat tento termín';
$string['datesignedup'] = 'Termín registrován';
$string['datetext'] = 'Jste přihlášeni na termín';
$string['decidelater'] = 'Rozhodnout později';
$string['decline'] = 'Odmítnout';
$string['delete'] = 'Odstranit';
$string['deleteall'] = 'Odstranit vše';
$string['deletesession'] = 'Odstranit termín cvičení';
$string['deletesessionconfirm'] = 'Opravdu chcete tento termín praktického cvičení a všechna přihlášení k tomuto cvičení smazat?';
$string['deletingsession'] = 'Odstranit termín cvičení v {$a}';
$string['description'] = 'Úvodní text';
$string['description_help'] = '** Popis ** je popis kurzu, který se zobrazí, když se student zapíše na termín praktického cvičení.

** Popis ** se také zobrazí v tréninkovém kalendáři.';
$string['details'] = 'Podrobnosti';
$string['details_help'] = 'Podrobnosti jsou sledovány na základě termínu cvičení.
Pokud je text vyplněn v poli podrobností, text podrobností se zobrazí na stránce registrace uživatele.
Ve výchozím nastavení se text podrobností zobrazí také v e-mailových zprávách s potvrzením, připomenutím, čekací listinou a zrušením.';
$string['discountcode'] = 'Slevový kód';
$string['discountcode_help'] = 'Diskontní kód je kód požadovaný pro sledování diskontních nákladů při školení zaměstnance.
Pokud zaměstnanec nezadá slevový kód, objeví se v záznamu o školení běžné náklady.';
$string['discountcodelearner'] = 'Slevový kód';
$string['discountcodelearner_help'] = 'Pokud znáte slevový kód, zadejte jej sem. Pokud toto pole necháte prázdné, bude vám za tuto událost účtována běžná cena';
$string['discountcost'] = 'Sleva';
$string['discountcost_help'] = 'Diskontní cena je částka dolaru účtovaná zaměstnancům, kteří mají členské číslo ID.
Pokud zaměstnanec při přihlášení k termínu cvičení zadá identifikační číslo člena, zobrazí se diskontní cena ve sloupci nákladů ve třídě kurzu.';
$string['due'] = 'termín do';
$string['duration'] = 'Doba trvání';
$string['duration_help'] = '** Trvání ** je celková délka cvičení v hodinách.

Například:
* „2 hodiny“ se zadává jako ** 2 ** nebo ** 2: 00 **
* „1 hodina a 30 minut“ se zadává jako ** 1: 30 **
* "45 minut" je zadáno jako ** 0: 45 **
* „20 minut“ se zadává jako ** 0: 20 **.

Dojde-li ke cvičení ve dvou nebo více časových termínech, je doba trvání součtem.';
$string['early'] = '{$a} dříve';
$string['edit'] = 'Upravit';
$string['editingsession'] = 'Upravit termín praktického cvičení v {$a}';
$string['editsession'] = 'Upravit termín praktického cvičení';
$string['email:instrmngr'] = 'Oznámení pro manažera';
$string['email:message'] = 'Zpráva';
$string['email:subject'] = 'Předmět';
$string['emailmanager'] = 'Odeslat oznámení manažerovi';
$string['emailmanagercancellation'] = '# Odeslat oznámení manažerovi';
$string['emailmanagercancellation_help'] = 'Je-li zaškrtnuto políčko „Odeslat oznámení manažerovi“, bude manažerovi studenta zaslán e-mail s upozorněním, že rezervace praktického cvičení byla zrušena.';
$string['emailmanagerconfirmation'] = '# Odeslat oznámení manažerovi';
$string['emailmanagerconfirmation_help'] = 'Je-li zaškrtnuto políčko „Odeslat oznámení manažerovi“, bude manažerovi studenta zaslán potvrzovací e-mail, když se student zaregistruje na termín praktického cvičení.';
$string['emailmanagerreminder'] = '# Odeslat oznámení manažerovi';
$string['emailmanagerreminder_help'] = 'Pokud je zaškrtnuto políčko „Odeslat oznámení manažerovi“, bude manažerovi studenta zasláno upozornění několik dní před datem zahájení praktického cvičení.';
$string['emptylocation'] = 'Lokalita byla prázdná';
$string['enrolled'] = 'zapsán';
$string['error:addalreadysignedupattendee'] = '{$a} je již zaregistrován pro tuto aktivitu Praktické cvičení.';
$string['error:addattendee'] = 'Do cvičení nelze přidat {$a}.';
$string['error:bookingsuploadfileerrorsfound'] = 'V nahraném souboru bylo nalezeno {$a} chyb. Rezervace nelze zpracovat, dokud nebudou vyřešeny.';
$string['error:bookingsuploadfileheaderfieldmismatch'] = 'Neodpovídající počet polí v nahraném souboru na řádku {$a}.';
$string['error:cancelbooking'] = 'Při zrušení rezervace došlo k potížím';
$string['error:cancellationsnotallowed'] = 'Toto přihlášení není povoleno zrušit.';
$string['error:cancellationtooclose'] = 'Tuto registraci nemůžete zrušit. Rezervace lze zrušit pouze {$a} před začátkem sezení.';
$string['error:cannotemailmanager'] = 'Odeslaný připomínkový mail ID {$a-> submitid} uživateli {$a-> userid}, ale nemohla odeslat zprávu pro e-mailovou adresu manažera uživatele ({$a-> manageremail}).';
$string['error:cannotemailuser'] = 'Nelze odeslat e-mail  příspěvku ID {$a->submissionid} uživateli {$a->userid} ({$a->useremail}).';
$string['error:cannotloadfile'] = 'Soubor nelze načíst, zkontrolujte soubor a zkuste to znovu.';
$string['error:cannotprocessbookingsvalidationerrorsexist'] = 'Existují chyby ověření, které je třeba vyřešit před úplným zpracováním souboru. Opravte je a zkuste to znovu.';
$string['error:cannotsendconfirmationmanager'] = 'Na váš e-mailový účet byla odeslána potvrzovací zpráva, ale při odesílání potvrzovací zprávy na e-mailovou adresu manažera došlo k potížím.';
$string['error:cannotsendconfirmationthirdparty'] = 'Na váš e-mailový účet a na e-mailový účet vašeho manažera byla odeslána potvrzovací zpráva, ale při odesílání potvrzovacích zpráv na e-mailovou adresu třetí strany se vyskytl problém.';
$string['error:cannotsendconfirmationuser'] = 'Při odesílání potvrzovací zprávy na váš e-mailový účet došlo k potížím.';
$string['error:cannotsendconfirmationusermanager'] = 'Na vaši e-mailovou adresu a na e-mailovou adresu manažera se nepodařilo odeslat potvrzovací zprávu.';
$string['error:cannotsendrequestmanager'] = 'Při odesílání zprávy s požadavkem na registraci na e-mailový účet manažera došlo k potížím.';
$string['error:cannotsendrequestuser'] = 'Při odesílání zprávy s požadavkem na registraci do vašeho e-mailového účtu došlo k potížím.';
$string['error:canttakeattendanceforunstartedsession'] = 'Nelze se zúčastnit cvičení, které ještě nezačalo.';
$string['error:couldnotaddfield'] = 'Nelze přidat vlastní pole cvičení.';
$string['error:couldnotaddnotice'] = 'Oznámení stránek nelze přidat.';
$string['error:couldnotaddsession'] = 'Nelze přidat termín praktického cvičení';
$string['error:couldnotaddtrainer'] = 'Nový trenér termínu praktického cvičení nelze uložit';
$string['error:couldnotcopysession'] = 'Cvičení nelze kopírovat';
$string['error:couldnotdeletefield'] = 'Vlastní pole cvičení se nepodařilo odstranit';
$string['error:couldnotdeletenotice'] = 'Oznámení stránek nelze smazat';
$string['error:couldnotdeletesession'] = 'Cvičení nelze odstranit';
$string['error:couldnotdeletetrainer'] = 'Trenér termínu praktického cvičení nelze odstranit';
$string['error:couldnotfindsession'] = 'Nově vložený termín cvičení nelze najít';
$string['error:couldnotsavecustomfield'] = 'Vlastní pole nelze uložit';
$string['error:couldnotupdatecalendar'] = 'Událost termínu cvičení nelze v kalendáři aktualizovat.';
$string['error:couldnotupdatef2frecord'] = 'Nelze aktualizovat registrační záznam Praktického cvičení v databázi';
$string['error:couldnotupdatefield'] = 'Vlastní pole cvičení nelze aktualizovat.';
$string['error:couldnotupdatemanageremail'] = 'E-mailovou adresu manažera nelze aktualizovat.';
$string['error:couldnotupdatenotice'] = 'Oznámení stránek nelze aktualizovat.';
$string['error:couldnotupdatesession'] = 'Praktické cvičení nelze aktualizovat';
$string['error:coursemisconfigured'] = 'Kurz je nesprávně nakonfigurován';
$string['error:cronprefix'] = 'Chyba:  cron Praktické cvičení:';
$string['error:emptylocation'] = 'Lokalita byla prázdná.';
$string['error:emptymanageremail'] = 'E-mailová adresa manažera je prázdná.';
$string['error:emptyvenue'] = 'Místo konání bylo prázdné.';
$string['error:enrolmentfailed'] = 'Do kurzu se nelze přihlásit {$a}.';
$string['error:eventoccurred'] = 'Nemůžete zrušit událost, která již nastala.';
$string['error:f2ffailedupdatestatus'] = 'Praktickému cvičení se nepodařilo aktualizovat stav uživatele';
$string['error:fieldidincorrect'] = 'ID pole je nesprávné: {$a}';
$string['error:incorrectcoursemodule'] = 'Modul kurzu je chybný';
$string['error:incorrectcoursemoduleid'] = 'ID modulu kurzu bylo chybné';
$string['error:incorrectcoursemodulesession'] = 'Modulu kurzu termín Praktického cvičení byl chybný';
$string['error:incorrectfacetofaceid'] = 'ID Praktického cvičení bylo nesprávné';
$string['error:incorrectnotificationtype'] = 'Byl dodán nesprávný typ oznámení';
$string['error:invalidnotificationtypespecified'] = 'Byl zadán neplatný typ oznámení. Očekává se "ical", \'email\', "obě" nebo "", ale skutečný byl "{\\$a}"';
$string['error:invalidstatusspecified'] = 'Zadán neplatný stav. Očekává se "rezervováno", "zrušeno", "nezobrazovat", "částečná_účast" nebo "plná_účast". Výchozí hodnota je „rezervováno“, pokud je prázdné. Zadaná hodnota byla "{\\$a}"';
$string['error:invaliduserid'] = 'Neplatné ID uživatele';
$string['error:manageremailaddressmissing'] = 'Momentálně nejste v systému přiřazeni k manažerovi. Obraťte se na správce webu.';
$string['error:multipleusersessions'] = 'Uživatel {$a} má více než jedno cvičení';
$string['error:multipleusersmatched'] = 'Více uživatelů odpovídá identifikátoru {$a}';
$string['error:mustspecifycoursemodulefacetoface'] = 'Musíte určit modul kurzu nebo ID Praktického cvičení';
$string['error:nomanageremail'] = 'Nezadali jste e-mailovou adresu svého manažera';
$string['error:nomanagersemailset'] = 'Není nastaven žádný e-mail manažera';
$string['error:nopermissiontosignup'] = 'Nemáte oprávnění k přihlášení do tohoto termín Praktického cvičení.';
$string['error:noticeidincorrect'] = 'ID oznámení je chybné: {$a}';
$string['error:problemsigningup'] = 'Při registraci se vyskytl problém.';
$string['error:removeattendee'] = '{$a}} nelze z termínu cvičení odebrat.';
$string['error:sessionalreadystarted'] = 'Nelze použít cvičení  {$a}, protože již začalo.';
$string['error:sessiondoesnotexist'] = 'ID cvičení {$a} neexistuje';
$string['error:sessionoverbooked'] = 'ID cvičení {$a->session} přerezervováno {$a->amount} osobami.';
$string['error:sessionstartafterend'] = 'Datum / čas zahájení cvičení je po skončení.';
$string['error:shortnametaken'] = 'Vlastní pole s tímto krátkým názvem již existuje.';
$string['error:signedupinothersession'] = 'Pro tuto aktivitu jste již přihlášeni v jiném termínu. Na každou aktivitu Praktického cvičení se můžete zaregistrovat pouze na jeden termín.';
$string['error:tryingtoupdatesessionfromanothermodule'] = 'Nelze aktualizovat id cvičení {$a->session}, které patří jiné aktivitě tváří v tvář s id {$a->f}.';
$string['error:unknownbuttonclicked'] = 'S tlačítkem, na které jste klikli, nebyla přidružena žádná akce';
$string['error:userdoesnotexist'] = 'Uživatel {$a} neexistuje';
$string['error:userisnotenrolledintocourse'] = 'Uživatel {$a} není zapsán do tohoto kurzu.';
$string['eventaddsession'] = 'Cvičení předáno';
$string['eventaddsessionfailed'] = 'Přidání cvičení (CHYBA)';
$string['eventapproverequests'] = 'Termín požaduje schválení';
$string['eventattendancetaken'] = 'Účast na cvičení byla zaregistrována';
$string['eventattendeesviewed'] = 'Zobrazeni účastníci cvičení';
$string['eventcancelbooking'] = 'Zrušení rezervace termínu cvičení';
$string['eventcancelbookingfailed'] = 'Zrušení rezervace termínu cvičení (CHYBA)';
$string['eventcoursef2fviewed'] = 'Zobrazena instance kurzu Praktické cvičení';
$string['eventcoursemoduleviewed'] = 'Zobrazena instance modulu Praktické cvičení';
$string['eventcsvprocessed'] = 'CSV zpracováno';
$string['eventdeletesession'] = 'Cvičení odstraněno';
$string['eventdeletesessionfailed'] = 'Cvičení odstraněno (CHYBA)';
$string['eventsignup'] = 'Registrace termínu cvičení';
$string['eventsignupfailed'] = 'Registrace termínu cvičení (CHYBA)';
$string['eventtakeattendancefailed'] = 'Účast na cvičení (CHYBA)';
$string['eventupdatemanageremailfailed'] = 'Aktualizace e-mailu manažera (CHYBA)';
$string['eventupdatesession'] = 'Cvičení aktualizováno';
$string['eventupdatesessionfailed'] = 'Cvičení aktualizováno (CHYBA)';
$string['excelformat'] = 'Excel';
$string['export'] = 'Export';
$string['exportattendance'] = 'Export docházky';
$string['exporttofile'] = 'Export do souboru';
$string['facetoface'] = 'Praktická cvičení';
$string['facetoface:addattendees'] = 'Přidat účastníky na termín Praktického cvičení';
$string['facetoface:addinstance'] = 'Přidat instanci';
$string['facetoface:configurecancellation'] = 'Povolte konfiguraci zrušení registrace po přidání / úpravě aktivity Praktické cvičení';
$string['facetoface:confirmandprocess'] = 'Potvrdit a zpracovat';
$string['facetoface:createsitewideevent'] = 'Povolit vytváření událostí kalendáře celého webu';
$string['facetoface:csvprocessed'] = 'Záznamy byly úspěšně zpracovány.';
$string['facetoface:editsessions'] = 'Přidat , upravovat, kopírovat a odstranit termíny Praktického cvičení';
$string['facetoface:examplecsv'] = 'Příklad textového souboru';
$string['facetoface:overbook'] = 'Zaregistrovat se na plné termíny.';
$string['facetoface:removeattendees'] = 'Termín Praktického cvičení';
$string['facetoface:signup'] = 'Registrace na termín praktického cvičení';
$string['facetoface:takeattendance'] = 'Zadat docházku';
$string['facetoface:uploadandpreview'] = 'Nahrát a ověřit rezervace';
$string['facetoface:uploadbookings'] = 'Nahrát rezervace';
$string['facetoface:uploadbookingsfile'] = 'Soubor rezervací';
$string['facetoface:uploadbookingsfiledesc'] = 'Očekávaná pole:
- e-mailová adresa (vyžadováno)
– Číslo relace (povinné)
- slevový kód (volitelné)
– Typ oznámení (volitelné – platné možnosti jsou „email“, „ical“ nebo „obě“)';
$string['facetoface:uploadreadytoprocess'] = 'Nahraný soubor byl ověřen a připraven ke zpracování.';
$string['facetoface:validatebookings'] = 'Potvrdit rezervace';
$string['facetoface:view'] = 'Zobrazit aktivity a termíny Praktického cvičení';
$string['facetoface:viewattendees'] = 'Zobrazit seznam účastníků a účastníky';
$string['facetoface:viewcancellations'] = 'Zobrazit zrušení';
$string['facetoface:viewemptyactivities'] = 'Zobrazit prázdné aktivity Praktické cvičení';
$string['facetofacebooking'] = 'Rezervace Praktického cvičení';
$string['facetofacename'] = 'Název Praktického cvičení';
$string['facetofacesession'] = 'Termín Praktického cvičení';
$string['feedback'] = 'Zpětná vazba';
$string['feedbackupdated'] = 'Zpětná vazba byla aktualizována pro \\{$a} lidí';
$string['field:multiselect'] = 'Vícenásobný výběr';
$string['field:select'] = 'Nabídka možností';
$string['field:text'] = 'Text';
$string['fielddeleteconfirm'] = 'Smazat pole "{$a}" a všechna související data termínu cvičení?';
$string['floor'] = 'Patro';
$string['format'] = 'Formát';
$string['full'] = 'Termín je plně obsazen';
$string['goback'] = 'Zpět';
$string['guestsno'] = 'Je nám líto, hosté se nemohou přihlásit k termínům cvičení.';
$string['icalendarheading'] = 'Přílohy iCalendar';
$string['import'] = 'Import';
$string['info'] = 'Informace';
$string['late'] = '\\{$a} později';
$string['location'] = 'Lokalita';
$string['location_help'] = '**Lokalita** popisuje lokalitu cvičení(město, kraj, region atd.).

** Lokalita** se zobrazí na stránce kurzu, na stránce „Registrace“, na stránce „Zobrazit všechny termíny“ a ve všech e-mailových oznámeních.

Na stránce „Zobrazit všechny termíny“ lze uvedené relace filtrovat podle místa.';
$string['lookfor'] = 'Vyhledat';
$string['manageradded'] = 'E-mailová adresa vašeho manažera byla přijata.';
$string['managerchanged'] = 'E-mailová adresa vašeho manažera byla změněna.';
$string['manageremail'] = 'E-mail manažera';
$string['manageremailaddress'] = 'E-mailová adresa manažera';
$string['manageremaildisabled'] = 'Nastavení e-mailu správce nejsou k dispozici, pokud není povoleno schvalování správce.';
$string['manageremailformat'] = 'Aby mohla být E-mailová adresa přijata, musí být ve formátu „{$a}“.';
$string['manageremailheading'] = 'E-maily manažera';
$string['manageremailinstruction'] = 'Chcete-li se přihlásit na školení, musíte na vaši e-mailovou adresu zaslat potvrzovací e-mail a zkopírovat na e-mailovou adresu manažera.';
$string['manageremailinstructionconfirm'] = 'Potvrďte, že se jedná o e-mailovou adresu manažera:';
$string['managername'] = 'Jméno manažera';
$string['managerupdated'] = 'E-mailová adresa manažera byla aktualizována.';
$string['maximumpoints'] = 'Maximální počet bodů';
$string['maximumsize'] = 'Maximální počet účastníků';
$string['message'] = 'Změna rezervace v kurzu {$a->coursename}!

V kurzu {$a-> coursename}  bylo v rámci termínu  {$a->duedate} ({$a->name}) volné místo.
Byli jste zaregistrováni. Pokud vám datum již nevyhovuje, zrušte registraci na <a href=\'{$a->url}\'>{$a->url}</a>.';
$string['mods_help'] = 'Aktivity Praktické cvičení se používají k sledování presenčních školení, která vyžadují rezervaci předem.

Každá aktivita je nabízena v jedné nebo více identických termínech. Tyto běhy mohou probíhat po více dní.

Zprávy s připomenutím jsou uživatelům a jejich manažerům zasílány několik dní před plánovaným termínem. Potvrzovací zprávy se odesílají, když se uživatel přihlásí nebo zruší termín.';
$string['modulename'] = 'Praktická cvičení';
$string['modulename_help'] = 'Modul aktivity Praktické cvičení umožňuje učiteli nastavit dobrovolný rezervační systém pro jeden nebo více presenčních termínů v učebně.

Každý termín v rámci aktivity Praktické cvičení může mít přizpůsobená nastavení lokalitu, místa konání, času zahájení, času dokončení, nákladů, kapacity atd. Lze je nastavit tak, aby probíhalo více dní nebo umožňovalo neplánované a nečekané termíny.

Aktivita může být nastavena tak, aby vyžadovala souhlas manažera a učitelé mohou konfigurovat automatická oznámení a připomenutí termínu účastníkům.

Studenti si mohou zobrazit a registrovat se na termíny s jejich sledovanou a zaznamenanou docházkou.';
$string['modulenameplural'] = 'Praktická cvičení';
$string['moreinfo'] = 'Další informace';
$string['multidate'] = '(multi-date)';
$string['multiple'] = 'Násobně';
$string['multiplesignupmethod'] = 'Metoda vícenásobného přihlášení';
$string['multiplesignupmethod_help'] = 'Když je nastaveno na „Na cvičení“, studenti se přihlašují na každé cvičení v rámci osobní aktivity jednotlivě. Když je nastaveno na „Na aktivitu“, studenti budou mít pouze možnost přihlásit se na každé cvičení v rámci osobní aktivity.';
$string['multiplesignupperactivity'] = 'Na aktivitu';
$string['multiplesignuppersession'] = 'Na cvičení';
$string['newmanageremailaddress'] = 'E-mailová adresa manažera';
$string['noactionableunapprovedrequests'] = 'Žádné aktivní neschválené žádosti';
$string['nocustomfields'] = '<p> Nejsou definována žádná vlastní pole. </p>';
$string['nofacetofaces'] = 'Neexistují žádné aktivity Praktické cvičení';
$string['none'] = 'nic';
$string['noremindersneedtobesent'] = 'Není třeba zasílat žádné připomenutí.';
$string['normalcost'] = 'Normální cena';
$string['normalcost_help'] = 'Normální cena je částka účtovaná zaměstnancům, kteří nemají členské číslo.

Normální náklady se objeví ve sloupci nákladů v kurzu pro každého zaměstnance, který se účastní termínu (pokud není zadán diskontní cena a zaměstnanec zadá při podpisu relace identifikační číslo člena).';
$string['nosignedupusers'] = 'K tomuto termínu cvičení se nepřihlásili žádní uživatelé.';
$string['nositenotices'] = '<p> Nejsou definována žádná oznámení stránekh. </p>';
$string['note'] = 'Poznámka';
$string['notefull'] = 'I když je termín cvičení plně obsazen, stále se můžete zaregistrovat. Budete ve frontě (označeni červeně). Pokud se někdo odhlásí, první student ve frontě bude přesunut do registrovaných studentů a poštou mu bude zasláno oznámení.';
$string['noteinfo'] = 'Během posledního upgradu webu byl upraven modul face-to-face. To teď vyžaduje, aby vlastní pole relace měla jedinečné krátké názvy. Od některých vašich vlastní pole měla duplicitní krátké názvy, byla přejmenována za účelem odstranění duplikáty (viz tabulka níže). To by mohlo mít vliv na vaše e-mailové zprávy odkazujte na tato vlastní pole v šablonách zpráv.';
$string['noticedeleteconfirm'] = 'Smazat oznámení stránek "{$a->name}"?<br/><blockquote>{$a->text}</blockquote>';
$string['noticetext'] = 'Text poznámky';
$string['notificationboth'] = 'E-mailové oznámení a schůzka iCalendar';
$string['notificationemail'] = 'Pouze e-mailové oznámení';
$string['notificationical'] = 'Pouze schůzka iCalendar';
$string['notificationtype'] = 'Typ oznámení';
$string['notificationtype_help'] = 'Typ oznámení umožňuje studentovi vybrat, jak by chtěl být informován o své rezervaci.

* Pouze schůzka iCalendar
* Pouze e-mailové oznámení
* E-mailové oznámení a schůzka iCalendar';
$string['notsignedup'] = 'Nejste přihlášeni k tomuto termínu cvičení.';
$string['notsubmittedyet'] = 'Dosud nehodnoceno';
$string['noupcoming'] = '<p> <i> Žádný nadcházející termín cvičení</i> </p>';
$string['odsformat'] = 'OpenDocument';
$string['onehour'] = '1 hodina';
$string['oneminute'] = '1 minuta';
$string['options'] = 'Možnosti';
$string['or'] = 'nebo';
$string['order'] = 'Objednat';
$string['place'] = 'Místnost';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:cost'] = '[cost]';
$string['placeholder:details'] = '[details]';
$string['placeholder:duration'] = '[duration]';
$string['placeholder:facetofacename'] = '[facetofacename]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['pluginadministration'] = 'Správa Praktických cvičení';
$string['pluginname'] = 'Praktická cvičení';
$string['points'] = 'Body';
$string['pointsplural'] = 'Bodů';
$string['potentialattendees'] = 'Potenciální účastníci';
$string['previoussessions'] = 'Předchozí termíny';
$string['printversionid'] = 'Verze pro tisk: bez jména';
$string['printversionname'] = 'Verze pro tisk: se jménem';
$string['privacy:metadata:facetoface_session_roles'] = 'Seznam uživatelů s rolí trenéra v termínu praktického cvičení';
$string['privacy:metadata:facetoface_signups'] = 'Přihlášení uživatele k termínu praktického cvičení';
$string['privacy:metadata:facetoface_signups:discountcode'] = 'Slevový kód zadaný uživatelem';
$string['privacy:metadata:facetoface_signups:id'] = 'ID přihlášení';
$string['privacy:metadata:facetoface_signups:mailedreminder'] = 'Čas posledního odeslání připomenutí';
$string['privacy:metadata:facetoface_signups:notificationtype'] = 'Jak chce být uživatel upozorněn.';
$string['privacy:metadata:facetoface_signups:sessionid'] = 'ID termínu cvičení';
$string['privacy:metadata:facetoface_signups_status'] = 'Stav přihlášení uživatele k termínu cvičení';
$string['privacy:metadata:facetoface_signups_status:grade'] = 'Známka z účasti na praktickém cvičení';
$string['privacy:metadata:facetoface_signups_status:note'] = 'Uloží důvod zrušené termínu cvičení';
$string['privacy:metadata:facetoface_signups_status:signupid'] = 'ID přihlášení';
$string['privacy:metadata:facetoface_signups_status:statuscode'] = 'Stav registrace, např. zrušeno, odmítnuto, plně obsazeno';
$string['privacy:metadata:facetoface_signups_status:timecreated'] = 'Čas vytvoření registrace.';
$string['privacy:metadata:roleid'] = 'ID role uživatele.';
$string['privacy:metadata:userid'] = 'ID uživatele, který vstoupil do aktivity Praktické cvičení';
$string['really'] = 'Opravdu chcete smazat všechny výsledky pro toto Praktické cvičení?';
$string['registeredon'] = 'Registrováno dne';
$string['registrations'] = 'Registrace';
$string['reminder'] = 'Připomenutí';
$string['reminderinstrmngr'] = '# Oznámení pro manažera';
$string['reminderinstrmngr_help'] = 'Když je zaškrtnuto ** Odeslat oznámení manažerovi **, text v poli ** Oznámení pro manažera ** bude zaslán manažerovi studenta s upozorněním, že se zaregistrovali k termínu praktického cvičení.';
$string['remindermessage'] = 'Zpráva připomenutí';
$string['remindermessage_help'] = 'Tato zpráva je odeslána několik dní před datem zahájení cvičení.';
$string['reminderperiod'] = 'Dny před odesláním zprávy';
$string['reminderperiod_help'] = 'Připomínková zpráva bude odeslána mnoho dní před zahájením cvičení.';
$string['requestmessage'] = 'Vyžádat zprávu';
$string['requestmessage_help'] = 'Když je povoleno ** Povinné schválení **, je k dispozici sekce ** Žádost o zprávu **.

Sekce ** Žádost ** zobrazuje oznámení zaslaná žákovi a jeho vedoucímu ohledně schvalovacího procesu, ve kterém se žák může zúčastnit termínu Praktického cvičení.

** Předmět: ** je předmětový řádek, který se objeví na e-mailech se žádostí o schválení odeslaných manažerovi a studentovi.

** Zpráva: ** je e-mailový text zaslaný žákovi, který jim sděluje, že jeho žádost o účast na setkání tváří v tvář byla odeslána jeho manažerovi ke schválení.

** Oznámení pro manažera: ** je text e-mailu zaslaný manažerovi žáka, který požaduje schválení, aby se mohl zúčastnit  termínu Praktického cvičení.';
$string['room'] = 'Místnost';
$string['room_help'] = '** Místnost ** je název / číslo / identifikátor místnosti používané pro školení.

** Místnost ** se zobrazí na stránce „Registrace“, na stránce „Zobrazit všechny termíny“ a ve všech e-mailových oznámeních.';
$string['saveallfeedback'] = 'Uložit všechny odpovědi';
$string['saveattendance'] = 'Uložit hodnocení';
$string['scheduledsession'] = 'Naplánované termíny cvičení';
$string['scheduledsessions'] = 'Naplánované termíny cvičení';
$string['search:activity'] = 'Aktivity Praktické cvičení';
$string['seatsavailable'] = 'Místa k dispozici';
$string['seeattendees'] = 'Zobrazit účastníky';
$string['sentremindermanager'] = 'Odeslaný e-mail s upomínkou manažera uživatelů';
$string['sentreminderuser'] = 'Uživateli byl odeslán e-mail s připomenutím';
$string['sessiondate'] = 'Datum cvičení je datum, kdy ke cvičení dojde.';
$string['sessiondateandtime'] = '{$a->startdatetime} - {$a->enddatetime} (časová zóna: {$a->timezone})';
$string['sessiondatetime'] = 'Datum / čas termínu cvičení';
$string['sessiondatetimeknown'] = 'Datum / čas termínu cvičení je znám';
$string['sessiondatetimeknown_help'] = '** Je-li známé datum / čas termínu**

Pokud pro toto nastavení zadáte „Ano“, zobrazí se na stránce kurzu datum a čas termínu (je-li termín nadcházející a dostupná), „Zobrazit stránku všech termínů“, stránku registrace termínu a všechna e-mailová oznámení související s termínem.

Když se zaměstnanec přihlásí na termín se známým datem a časem:

* Zaměstnanci a jeho vedoucímu bude zaslán potvrzovací e-mail (tj. Ten, který je naformátován v části „Potvrzovací zpráva“ v nastavení instance Praktické cvičení ).
* Zaměstnanci bude zaslána e-mailová zpráva s připomenutím (tj. Ta, která je naformátována v části „Připomenutí“ v nastavení instance Praktické cvičení ). Připomenutí bude zasláno několik dní před termínem podle nastavení „Dny před odesláním zprávy“ také v části „Připomenutí zprávy“ v nastavení instance Praktické cvičení .

** Pokud datum / čas termínu není znám (nebo je uveden v seznamu) **

Pokud je pro toto nastavení zadáno „Ne“, zobrazí se na stránce kurzu text „čekající seznam“, stránka „Zobrazit všechny termíny“, stránka registrace termínu a všechna e-mailová oznámení související s termínem.

Když se zaměstnanec zaregistruje na čekací termín:

* Zaměstnanci bude zaslána potvrzovací e-mail (tj. Ten, který je naformátován v části „Čekající zpráva“ v nastavení instance Praktické cvičení ).
* Zaměstnanci nebude zaslána e-mailová zpráva s upomínkou.
* Manažerovi zaměstnance nebudou zaslány potvrzovací a stornovací e-mailové zprávy.';
$string['sessionfinishtime'] = 'Čas skončení cvičení';
$string['sessioninprogress'] = 'probíhající praktická cvičení';
$string['sessionisfull'] = 'Toto cvičení je nyní plné. Budete si muset vybrat jiný čas nebo si promluvit s instruktorem.';
$string['sessionnumber'] = '#';
$string['sessionover'] = 'praktické cvičení skončilo';
$string['sessionrequiresmanagerapproval'] = 'Toto cvičení vyžaduje k rezervaci schválení manažerem.';
$string['sessionroles'] = 'Role praktického cvičení';
$string['sessions'] = 'Praktická cvičení';
$string['sessionsoncoursepage'] = 'Termíny cvičení zobrazené na stránce kurzu';
$string['sessionsoncoursepage_help'] = 'Toto je počet termínů cvičení pro každou aktivitu Praktického cvičení, které se zobrazí na hlavní stránce kurzu.';
$string['sessionstartdate'] = 'Datum zahájení praktického cvičení';
$string['sessionstarttime'] = 'Čas zahájení praktického cvičení';
$string['sessionvenue'] = 'Místo praktického cvičení';
$string['setting:addchangemanageremail'] = 'Požádat uživatele o e-mailovou adresu svého manažera.';
$string['setting:addchangemanageremail_caption'] = 'E-mail manažera:';
$string['setting:addchangemanageremaildefault'] = 'Požádat uživatele o e-mailovou adresu svého manažera.';
$string['setting:attendeesexportfields'] = 'Vyberte pole, která mají být zahrnuta do exportovaného seznamu účastníků cvičení. To bude kromě jména a příjmení účastníka.';
$string['setting:attendeesexportfields_caption'] = 'Exportní pole účastníků';
$string['setting:cancelrestriction'] = 'Minimální doba před začátkem kurzu, kdy mohou studenti zrušit svou rezervaci. V této lhůtě není zrušení rezervace možné.';
$string['setting:cancelrestriction_caption'] = 'Omezení zrušení';
$string['setting:defaultcancellationinstrmngr'] = 'Výchozí zpráva o zrušení odeslaná manažerům.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'Zrušení zprávy (manažeři)';
$string['setting:defaultcancellationinstrmngrdefault'] = '*** Pouze upozornění ****

Toto je upozornění, že  [firstname] [lastname] již není přihlášen k následujícímu kurzu a uvedl vás jako jejich vedoucího týmu / manažera.

*** Zrušení rezervace [firstname] [lastname] je zkopírováno níže ****';
$string['setting:defaultcancellationmessage'] = 'Výchozí zpráva o zrušení odeslaná uživateli.';
$string['setting:defaultcancellationmessage_caption'] = 'Zpráva o zrušení';
$string['setting:defaultcancellationmessagedefault'] = 'Toto je upozornění, že vaše rezervace v následujícím kurzu byla zrušena:

*** ZRUŠENÍ REZERVACE ***

Účastník:  [firstname] [lastname]
Kurz:   [facetofacename]


Trvání:   [duration]
Termíny:
[alldates]

Lokalita:   [session:location]
Místo konání:   [session:venue]
Místnost:   [session:room]';
$string['setting:defaultcancellationsubject'] = 'Výchozí předmět pro stornovací e-maily.';
$string['setting:defaultcancellationsubject_caption'] = 'Předmět zrušení';
$string['setting:defaultcancellationsubjectdefault'] = 'Zrušení rezervace kurzu';
$string['setting:defaultconfirmationinstrmngr'] = 'Výchozí potvrzovací zpráva zaslaná manažerům.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Potvrzovací zpráva (manažeři)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** Pouze upozornění ****

Toto je upozornění, že  [firstname] [lastname] má rezervaci do následujícího kurzu a uvedl vás jako jejich vedoucího týmu / manažera.

Pokud nejste jejich vedoucím / manažerem týmu a domníváte se, že jste tento e-mail dostali omylem, odpovězte na tento e-mail. Pokud máte obavy z toho, že váš zaměstnanec absolvoval tento kurz, prodiskutujte to přímo s ním.

*** Zrušení rezervace [firstname] [lastname] je zkopírováno níže ****';
$string['setting:defaultconfirmationmessage'] = 'Výchozí potvrzovací zpráva odeslaná uživatelům.';
$string['setting:defaultconfirmationmessage_caption'] = 'Potvrzovací zpráva';
$string['setting:defaultconfirmationmessagedefault'] = 'Toto je potvrzení, že jste nyní přihlášeni k následujícímu kurzu:

Účastník:  [firstname] [lastname]
Kurz:   [facetofacename]
Cena:   [cost]

Trvání:   [duration]
Termíny:
[alldates]

Lokalita:   [session:location]
Místo konání:   [session:venue]
Místnost:   [session:room]

*** Prosím, přijeďte deset minut před začátkem kurzu ***

Chcete-li znovu naplánovat nebo zrušit rezervaci
Chcete-li naplánovat svou rezervaci, musíte tuto rezervaci zrušit a znovu zarezervovat nový termín. Chcete-li rezervaci zrušit, vraťte se na stránku, poté na stránku tohoto kurzu a poté na obrazovce s informacemi o rezervaci vyberte možnost „Zrušit“.

[details]

Před tímto kurzem obdržíte upomínku [reminderperiod] pracovní dny.';
$string['setting:defaultconfirmationmessagedefault2'] = '<p><b>Děkujeme, že jste se zaregistrovali!</b></p>';
$string['setting:defaultconfirmationsubject'] = 'Výchozí řádek předmětu pro potvrzovací e-maily.';
$string['setting:defaultconfirmationsubject_caption'] = 'Předmět potvrzení';
$string['setting:defaultconfirmationsubjectdefault'] = 'Potvrzení rezervace kurzu: [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'Výchozí upomínková zpráva zaslaná manažerům.';
$string['setting:defaultreminderinstrmngr_caption'] = 'Upomínková zpráva (manažeři)';
$string['setting:defaultreminderinstrmngrdefault'] = '*** Pouze připomenutí ****

Váš zaměstnanec  [firstname] [lastname] má rezervaci k účasti v kurzu a také obdržel tento e-mail s upomínkou.

Pokud nejste jeho vedoucím / manažerem týmu a domníváte se, že jste tento e-mail dostali omylem, odpovězte na tento e-mail.

*** E-mail s upomínkou [firstname] [lastname] je zkopírováno níže ****';
$string['setting:defaultremindermessage'] = 'Výchozí připomenutí odeslané uživatelům.';
$string['setting:defaultremindermessage_caption'] = 'Předmět připomenutí';
$string['setting:defaultremindermessagedefault'] = 'Toto je připomínka, že máte rezervaci v následujícím kurzu:

Účastník:  [firstname] [lastname]
Kurz:   [facetofacename]
Cena:   [cost]

Trvání:   [duration]
Termíny:
[alldates]

Lokalita:   [session:location]
Místo konání:   [session:venue]
Místnost:   [session:room]

*** Prosím, přijeďte deset minut před začátkem kurzu ***

Chcete-li znovu naplánovat nebo zrušit rezervaci

Chcete-li naplánovat svou rezervaci, musíte tuto rezervaci zrušit a znovu zarezervovat nový termín. Chcete-li rezervaci zrušit, vraťte se na stránku, poté na stránku tohoto kurzu a poté na obrazovce s informacemi o rezervaci vyberte možnost „Zrušit“.

[details]';
$string['setting:defaultremindersubject'] = 'Výchozí řádek předmětu pro e-maily s upomínkou.';
$string['setting:defaultremindersubject_caption'] = 'Předmět pro připomenutí';
$string['setting:defaultremindersubjectdefault'] = 'Připomenutí rezervace kurzu: [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestinstrmngrdefault'] = 'Toto je upozornění, že [firstname] [lastname] požádal o rezervaci do následujícího kurzu a vy jste uvedeni jako jejich vedoucí týmu / manažer.

Kurz:   [facetofacename]
Cena:   [cost]

Trvání:   [duration]
Termíny:
[alldates]

Lokalita:   [session:location]
Místo konání:   [session:venue]
Místnost:   [session:room]

Žádost schválíte kliknutím na níže uvedený odkaz:
[attendeeslink]#unapproved


*** Žádost o rezervaci [firstname] [lastname] e zkopírována níž ****';
$string['setting:defaultrequestmessagedefault'] = 'Váš požadavek na rezervaci do následujícího kurzu byl zaslán vašemu manažerovi:

Účastník:  [firstname] [lastname]
Kurz:   [facetofacename]
Cena:   [cost]

Trvání:   [duration]
Termíny:
[alldates]

Lokalita:   [session:location]
Místo konání:   [session:venue]
Místnost:   [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Žádost o rezervaci kurzu: [facetofacename], [starttime]-[finishtime]';
$string['setting:defaultvalue'] = 'Výchozí hodnota';
$string['setting:defaultwaitlistedmessage'] = 'Výchozí zpráva o zařazení na čekací listinu odeslaná uživatelům.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Zpráva o zařazení na čekací listinu';
$string['setting:defaultwaitlistedmessagedefault'] = 'Toto je upozornění, že jste byli přidáni do čekacího seznamu pro:

Kurz:   [facetofacename]
Lokalita:   [session:location]
Účastník:  [firstname] [lastname]

*** Upozorňujeme, že se nejedná o potvrzení rezervace kurzu ***

Čekací listinou jste zaregistrovali svůj zájem o tento kurz a budete kontaktováni přímo, jakmile budou termíny k dispozici.

Chcete-li se odstranit z čekací listiny, vraťte se do tohoto kurzu a klikněte na Zrušit rezervaci. Vezměte prosím na vědomí, že e-mail s potvrzením o odstranění z čekací listiny neexistuje.';
$string['setting:defaultwaitlistedsubject'] = 'Výchozí řádek předmětu pro  zprávu o zařazení na čekací listinu e-maily.';
$string['setting:defaultwaitlistedsubject_caption'] = 'Předmět zprávu o zařazení na čekací listinu';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Čekací listina pro  [facetofacename]';
$string['setting:disableicalcancel'] = 'Zakažte stornovací e-maily s přílohou iCalendar.';
$string['setting:disableicalcancel_caption'] = 'Zakázat zrušení iCalendar:';
$string['setting:enableapprovals'] = 'Když je tato možnost zakázána, možnost přidávat schválení prostřednictvím nastavení aktivity již není k dispozici.';
$string['setting:enableapprovals_caption'] = 'Povolit schvalování správcem:';
$string['setting:fromaddress'] = 'Co se objeví v poli Od: e-mailových připomenutí odeslaných tímto modulem.';
$string['setting:fromaddress_caption'] = 'Adresa odesílatele:';
$string['setting:fromaddressdefault'] = 'moodle@example.com';
$string['setting:hidecost'] = 'Skrýt pole nákladů a kódu slev.';
$string['setting:hidecost_caption'] = 'Skrýt náklady a slevy:';
$string['setting:hidediscount'] = 'Skrýt pouze pole kódu slev.';
$string['setting:hidediscount_caption'] = 'Skrýt slevu:';
$string['setting:isfilter'] = 'Zobrazit jako filtr';
$string['setting:limit_candidates'] = 'Omezte kandidáty na uživatele zapsané do kurzu';
$string['setting:limit_candidates_caption'] = 'Omezit kandidáty';
$string['setting:manageraddressformat'] = 'Přípona, která musí být přítomna v e-mailové adrese manažera, aby byla považována za platnou.';
$string['setting:manageraddressformat_caption'] = 'Požadovaná přípona:';
$string['setting:manageraddressformatreadable'] = 'Stručný popis omezení e-mailové adresy manažera. Toto nastavení nemá žádný účinek, pokud předchozí není nastaveno.';
$string['setting:manageraddressformatreadable_caption'] = 'Příklad formátu:';
$string['setting:manageraddressformatreadabledefault'] = 'firstname.lastname@company.com';
$string['setting:oneemailperday'] = 'Pošlete více potvrzovacích e-mailů pro vícedenní události.';
$string['setting:oneemailperday_caption'] = 'Jedna zpráva denně:';
$string['setting:possiblevalues'] = 'Seznam možných hodnot';
$string['setting:sessionroles'] = 'Uživatelé přiřazení k vybraným rolím v kurzu mohou být sledováni při každém termínu Praktického cvičení';
$string['setting:sessionroles_caption'] = 'Role cvičení:';
$string['setting:showinsummary'] = 'Zobrazit v exportech a seznamech';
$string['setting:type'] = 'Typ pole';
$string['shortname'] = '# Krátký název';
$string['shortname_help'] = '**Short name** je popis termínu cvičení, která se zobrazí v tréninkovém kalendáři, když je povolena **Show on the calendar**.';
$string['showbylocation'] = 'Zobrazit podle lokality';
$string['showoncalendar'] = 'Nastavení zobrazení kalendáře';
$string['showoncalendar_help'] = 'Pokud je vybrána možnost ** Místo **, budou se v kalendáři webu zobrazovat termíny aktivit Praktické cvičení jako globální událost. Tyto termíny si budou moci zobrazit všichni uživatelé webu.

Pokud je vybrána možnost ** Kurz **, budou se všechny termíny aktivit Praktické cvičení zobrazeny v kalendáři kurzu a jako událost kurzu v kalendáři na úrovni stránek a viditelné pro všechny uživatele zapsané do kurzu.

Je-li vybrána možnost ** Žádný**, budou se termíny aktivit Praktické cvičení zobrazeny jako uživatelské události v potvrzeném kalendáři účastníka, pokud byla vybrána možnost ** Zobrazit v uživatelském kalendáři **.';
$string['sign-ups'] = 'Přihlášení';
$string['signup'] = 'Přihlášení';
$string['signupfor'] = 'Přihlášení {$a}';
$string['signupforsession'] = 'Zaregistrujte se na dostupné nadcházející termíny cvičení';
$string['signupforstream'] = 'Přihlásit se do streamu';
$string['signupforthissession'] = 'Zaregistrujte se na tyto termíny Praktických cvičení';
$string['signups'] = 'Přihlášení';
$string['signuptype'] = 'Typ registrace';
$string['signuptype_help'] = 'Při nastavení na „Jedna“ se student může zaregistrovat pouze na jedno cvičení na jednu osobní aktivitu. Při nastavení na „Násobně“ se student může zaregistrovat na více cvičení na aktivitu.';
$string['signuptypemismatch'] = 'Typ registrace musí být "Násobně", pokud je metoda registrace na aktivitu';
$string['single'] = 'Jedna';
$string['sitenoticesheading'] = 'Oznámení stránek';
$string['somesessionsfull'] = 'Nejste přihlášeni k některým cvičením ve streamu, protože jejich kapacita je vyčerpána.';
$string['status'] = 'Status';
$string['status_approved'] = 'Schváleno';
$string['status_booked'] = 'Rezervováno';
$string['status_declined'] = 'Odmítnuto';
$string['status_fully_attended'] = 'Splněno (100)';
$string['status_no_show'] = 'Nesplněno (0)';
$string['status_partially_attended'] = 'Splněno částečně (50)';
$string['status_requested'] = 'Požadováno';
$string['status_session_cancelled'] = 'Termín cvičení zrušen';
$string['status_user_cancelled'] = 'Uživatel byl zrušen';
$string['status_waitlisted'] = 'Čekací listina';
$string['subject'] = 'Změna rezervace v kurzu {$a->coursename} ({$a->duedate})';
$string['submissions'] = 'Příspěvky';
$string['submit'] = 'Odeslat';
$string['submitted'] = 'Odesláno';
$string['summary'] = 'Souhrn';
$string['suppressemail'] = 'Potlačit e-mailové oznámení';
$string['suppressemail_help'] = 'Tuto možnost použijte, pokud chcete bezobslužně přidat nebo odebrat uživatele z termínu Praktického cvičení. Když je tato možnost přepnuta,  vybraným uživatelům není zaslán obvyklý e-mail s potvrzením.';
$string['takeattendance'] = 'Záznam hodnocení účasti';
$string['thirdpartyemailaddress'] = 'E-mailová adresa nebo adresy třetích stran';
$string['thirdpartyemailaddress_help'] = '** E-mailová adresa (adresy) třetích stran ** je volitelné pole, které se používá k určení e-mailové adresy třetí strany (například externího instruktora), která pak obdrží potvrzovací zprávy, kdykoli se uživatel přihlásí k relaci.
Při zadávání ** více e-mailových adres ** oddělte každou adresu čárkou. Například: bob@example.com, joe@example.com';
$string['thirdpartywaitlist'] = 'Upozornit třetí stranu o termínech cvičení se seznamem čekajících';
$string['thirdpartywaitlist_help'] = 'Pokud je vybrána možnost ** Upozornit třetí stranu o termínech cvičení se seznamem čekajících **, bude třetí strana informována, když se student zaregistruje na seznam čekajících na cvičení. Když

** Upozornit třetí stranu o termínech cvičení se seznamem čekajících ** není povoleno. Třetí strana (y) budou upozorněny, až když se uživatel zaregistruje (nebo zruší) pro naplánovaný termín cvičení.';
$string['time'] = 'Čas';
$string['timecancelled'] = 'Čas zrušení';
$string['timedue'] = 'Termín ukončení registrace';
$string['timefinish'] = 'Čas ukončení';
$string['timefinish_help'] = 'Čas ukončení je čas, kdy cvičení končí.';
$string['timerequested'] = 'Požadovaný čas';
$string['timesignedup'] = 'Čas registrace';
$string['timestart'] = 'Čas zahájení';
$string['timestart_help'] = 'Čas zahájení je čas zahájení cvičení.';
$string['unapprovedrequests'] = 'Neschválené žádosti';
$string['unknowndate'] = '(unknown date)';
$string['unknowntime'] = '(unknown time)';
$string['upcomingsessions'] = 'Nadcházející termíny cvičení';
$string['upcomingsessionslist'] = 'Seznam všech nadcházejících termínů pro tuto aktivitu Praktická cvičení';
$string['updaterequests'] = 'Požadavky na aktualizaci';
$string['upgradeinfofacetoface'] = '{$a}: Informace o upgradu Face to Face';
$string['upgradeprocessinggrades'] = 'Zpracování známek Praktického cvičení může chvíli trvat, pokud je mnoho termínů...';
$string['uploadbookings'] = 'Nahrát rezervace';
$string['usercalentry'] = 'Zobrazit záznam v kalendáři uživatele';
$string['usercalentry_help'] = 'Pokud je toto nastavení aktivní, přidá položku událost uživatele do kalendáře účastníka termín Praktického cvičení. Pokud je tato možnost vypnuta, zabrání se tomu, aby se v kalendáři účastníka objevila duplicitní událost, kde máte nastavení zobrazení kalendáře nastaveno na kurz nebo web.';
$string['usercancelledon'] = 'Uživatel zrušen dne {$a}';
$string['userdeletedcancel'] = 'Uživatel byl smazán';
$string['usernotsignedup'] = 'Stav: není přihlášen';
$string['usersignedup'] = 'Stav: přihlášen';
$string['usersignedupon'] = 'Uživatel se přihlásil dne {$a}';
$string['userwillbewaitlisted'] = 'Tento termín je aktuálně plný. Kliknutím na tlačítko „Přihlásit“ se dostanete na čekací listinu termínu.';
$string['validation:needatleastonedate'] = 'Alespoň jedno datum nebo termín musíte označit jako čekací listinu .';
$string['venue'] = 'Místo konání';
$string['venue_help'] = '** Místo konání** je budova, ve které se bude cvičení konat.

** Místo konání** se zobrazí na stránce „Registrace“, na stránce „Zobrazit všechny termíny“ a ve všech e-mailových oznámeních.';
$string['viewallsessions'] = 'Zobrazit všechna cvičení';
$string['viewsubmissions'] = 'Zobrazit příspěvky';
$string['wait-list'] = 'Čekací listina';
$string['wait-listed'] = 'Na čekací listině';
$string['waitlistedmessage'] = 'Zpráva pro čekací listinu';
$string['waitlistedmessage_help'] = 'Tato zpráva se odešle pokaždé, když se uživatelé zaregistrují do čekací listinu.';
$string['waitliststatus'] = 'Máte místo na čekací listině následujícího termínu';
$string['xhours'] = '{$a} hodin';
$string['xminutes'] = '{$a} minut';
$string['youarebooked'] = 'Máte rezervaci na následující termín';
$string['youremailaddress'] = 'Vaše emailová adresa';
