<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'hu', version '5.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Hamarosan BigBlueButton foglalkozásai lesznek';
$string['bbbduetimeoverstartingtime'] = 'A tevékenység nem érhet véget annak kezdete előtt.';
$string['bbbdurationwarning'] = 'Az óra maximális időtartama %duration% perc.';
$string['bbbrecordallfromstartwarning'] = 'Az órát annak kezdete óta rögzítjük.';
$string['bbbrecordwarning'] = 'Az óra rögzíthető.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Új BigBlueButton foglalkozás hozzáadása';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Élő munkamenetek létrehozása';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Esemény létrehozása felvételekkel -';
$string['bigbluebuttonbn:deleterecordings'] = 'Felvételek törlése';
$string['bigbluebuttonbn:importrecordings'] = 'Felvételek importálása';
$string['bigbluebuttonbn:join'] = 'Csatlakozás egy BigBlueButton foglalkozáshoz.';
$string['bigbluebuttonbn:managerecordings'] = 'Felvételek kezelése';
$string['bigbluebuttonbn:protectrecordings'] = 'Felvételek védelemmel való ellátása';
$string['bigbluebuttonbn:publishrecordings'] = 'Felvételek közzététele';
$string['bigbluebuttonbn:seepresentation'] = 'Mindig nézd meg a prezentációs fájlt a tevékenység oldalon.';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Felvételek védelmének visszavonása';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Felvételek közzétételének visszavonása';
$string['bigbluebuttonbn:view'] = 'BigBlueButton tanterem megtekintése';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Felvételi formátumok megtekintése';
$string['cachedef_currentfetch'] = 'Újabb felvétel listázásához való adatok';
$string['cachedef_recordings'] = 'Metaadatok rögzítése';
$string['cachedef_serverinfo'] = 'Távoli szerver adatai';
$string['cachedef_subplugins'] = 'A szubplugin rutinok által használt gyorsítótár, amely felgyorsítja a plugin felfedezési folyamatát, ha szükséges.';
$string['cachedef_validatedurls'] = 'Hitelesített webcímellenőrzések gyorsítótárazása';
$string['calendarstarts'] = 'A(z) {a} időzítve ekkorra:';
$string['cannotperformaction'] = 'A felvételen a(z) {$a} lépés nem hajtható végre';
$string['completionattendance'] = 'A tanulónak ezen a foglalkozáson részt kell vennie:';
$string['completionattendance_desc'] = 'A tanulónak a foglalkozáson részt kell vennie és legalább {$a} percig a munkamenetben kell maradnia';
$string['completionattendance_event_desc'] = 'A tanuló a foglalkozáson részt vett vagy legalább {$a} percig a munkamenetben maradt';
$string['completionattendancegroup'] = 'Részvétel előírása';
$string['completionengagement_desc'] = 'A foglalkozás során a tanulónak tevékenységekbe kell bekapcsolódnia';
$string['completionengagementchats'] = 'Megbeszélések';
$string['completionengagementchats_desc'] = 'A teljesítéshez a tanulónak {$a} megbeszélésben kell részt vennie';
$string['completionengagementchats_event_desc'] = '{$a} megbeszélést kezdeményezett';
$string['completionengagementemojis'] = 'Hangulatjelek';
$string['completionengagementemojis_desc'] = 'A teljesítéshez a tanulónak {$a} hangulatjellel kell szavaznia';
$string['completionengagementemojis_event_desc'] = '{$a} hangulatjellel szavazott';
$string['completionengagementgroup'] = 'Bekapcsolódás előírása';
$string['completionengagementpollvotes'] = 'Szavazatok';
$string['completionengagementpollvotes_desc'] = 'A tanulónak a teljesítéshez {$a} alkalommal kell szavaznia';
$string['completionengagementpollvotes_event_desc'] = '{$a} alkalommal szavazott';
$string['completionengagementraisehand'] = 'Kézfeltartás előírása';
$string['completionengagementraisehand_desc'] = 'A tanulónak a teljesítéshez {$a} alkalommal kell a kezét feltartania';
$string['completionengagementraisehand_event_desc'] = '{$a} alkalommal tartotta fel a kezét';
$string['completionengagementtalks'] = 'Beszélgetés';
$string['completionengagementtalks_desc'] = 'A tanulónak a teljesítéshez {$a} alkalommal kell felszólalnia';
$string['completionengagementtalks_event_desc'] = '{$a} beszélgetést kezdeményezett';
$string['completionupdatestate'] = 'Teljesítés frissítési állapota';
$string['completionvalidatestate'] = 'Teljesítés hitelesítése';
$string['completionvalidatestatetriggered'] = 'Teljesítés hitelesítése elindítva';
$string['completionview_event_desc'] = 'Részt vett a foglalkozáson vagy {$a} alkalommal lejátszott egy felvételt.';
$string['config_checksum_algorithm'] = 'BigBlueButton szerver ellenőrzőösszeg algoritmus';
$string['config_checksum_algorithm_description'] = 'A SHA1 kompatibilis a régebbi szerverekkel. A SHA256 és a SHA512 biztonságosabb. A SHA512 megfelel a FIPS 140-2 szabványnak.';
$string['config_default_messages'] = 'Alapüzenetek';
$string['config_default_messages_description'] = 'Tevékenységekhez tartozó üzenetek alapbeállítása';
$string['config_disablecam_default'] = 'Alapesetben bekapcsolt kamera kikapcsolása';
$string['config_disablecam_default_description'] = 'A bekapcsolt webkamerákat kikapcsolja';
$string['config_disablecam_editable'] = 'A kikapcsolt kamera szerkeszthető';
$string['config_disablecam_editable_description'] = 'Az alapesetben kikapcsolt kamera esemény hozzáadásakor vagy frissítésekor szerkeszthető.';
$string['config_disablemic_default'] = 'Alapesetben bekapcsolt mikrofon kikapcsolása';
$string['config_disablemic_default_description'] = 'A bekapcsolt mikrofonokat kikapcsolja';
$string['config_disablemic_editable'] = 'A kikapcsolt mikrofon szerkeszthető';
$string['config_disablemic_editable_description'] = 'Az alapesetben kikapcsolt mikrofon esemény hozzáadásakor vagy frissítésekor szerkeszthető.';
$string['config_disablenote_default'] = 'Alapesetben bekapcsolt megosztott jegyzetek kikapcsolása';
$string['config_disablenote_default_description'] = 'A bekapcsolt megosztott jegyzeteket kikapcsolja';
$string['config_disablenote_editable'] = 'A kikapcsolt megosztott jegyzetek szerkeszthetők';
$string['config_disablenote_editable_description'] = 'Az alapesetben kikapcsolt megosztott jegyzetek  esemény hozzáadásakor vagy frissítésekor szerkeszthetők.';
$string['config_disableprivatechat_default'] = 'Alapesetben bekapcsolt magáncsevegés kikapcsolása';
$string['config_disableprivatechat_default_description'] = 'A bekapcsolt magáncsevegést kikapcsolja';
$string['config_disableprivatechat_editable'] = 'A kikapcsolt magáncsevegés szerkeszthető';
$string['config_disableprivatechat_editable_description'] = 'Az alapesetben kikapcsolt magáncsevegés esemény hozzáadásakor vagy frissítésekor szerkeszthető.';
$string['config_disablepublicchat_default'] = 'Alapesetben bekapcsolt nyilvános csevegés kikapcsolása';
$string['config_disablepublicchat_default_description'] = 'A bekapcsolt nyilvános csevegést kikapcsolja';
$string['config_disablepublicchat_editable'] = 'A kikapcsolt nyilvános csevegés szerkeszthető';
$string['config_disablepublicchat_editable_description'] = 'Az alapesetben kikapcsolt nyilvános csevegés esemény hozzáadásakor vagy frissítésekor szerkeszthető.';
$string['config_experimental_features'] = 'Kísérleti funkciók';
$string['config_experimental_features_description'] = 'Kísérleti funkciókhoz kapcsolódó beállítás.';
$string['config_extended_capabilities'] = 'Kibővített készségek';
$string['config_extended_capabilities_description'] = 'Kibővített képességek beállítása, amennyiben a BigBlueButton szerver felajánlja azokat.';
$string['config_general'] = 'Általános beállítások';
$string['config_general_description'] = 'A BigBlueButton beállításához használhatja saját BigBlueButton szerverét és hitelesítő adatait, vagy szerezze be a hitelesítő adatokat a(z) <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Blindside Networks regisztrációs portálon (új ablakban nyílik meg)</a>.';
$string['config_guestaccess_enabled'] = 'Külső vendég hozzáférés';
$string['config_guestaccess_enabled_description'] = 'Engedélyezze a fiók nélküli felhasználók számára a szoba elérését a webhelyén.';
$string['config_hideuserlist_default'] = 'Alapesetben bekapcsolt felhasználói lista elrejtése';
$string['config_hideuserlist_default_description'] = 'A munkamenethez tartozó bekapcsolt felhasználói lista rejtve lesz.';
$string['config_hideuserlist_editable'] = 'A rejtett felhasználói szerkeszthető';
$string['config_hideuserlist_editable_description'] = 'Az alapesetben rejtett felhasználói lista esemény hozzáadásakor vagy frissítésekor szerkeszthető.';
$string['config_importrecordings'] = 'Felvételek importálása';
$string['config_importrecordings_description'] = 'Ezek a beállítások funkciófüggőek.';
$string['config_importrecordings_enabled'] = 'Felvételek importálása bekapcsolva';
$string['config_importrecordings_enabled_description'] = 'Amikor ez és a rögzítési lehetőség engedélyezve van, különböző kurzusokból importálhat felvételeket egy tevékenységbe.';
$string['config_importrecordings_from_deleted_enabled'] = 'Felvételek importálása törölt tevékenységekből';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Amikor ez és a rögzítési lehetőség engedélyezve van, olyan tevékenységekből  importálhat felvételeket, amelyek már nem találhatók meg a kurzusban.';
$string['config_locksettings'] = 'A zárolási beállítások konfigurációja';
$string['config_locksettings_description'] = 'A beállításokkal a felhasználói felület zárolását be-/kikapcsolhatja és a lehetőségekhez alapértékeket adhat meg.';
$string['config_meetingevents_enabled'] = 'Élő munkamenetek regisztrálása';
$string['config_meetingevents_enabled_description'] = 'Bekapcsolása esetén az élő munkameneteket befejezésük után a rendszer rögzíti. Erre a tevékenység teljesítéséhez van szükség, és csak akkor működik, ha a  BigBlueButton szerver fel tudja dolgozni a post_events kódokat.';
$string['config_muteonstart'] = 'Némítás kezdéskor';
$string['config_muteonstart_default'] = 'A Némítás kezdéskor alapértelmezés szerint engedélyezett';
$string['config_muteonstart_default_description'] = 'Ha engedélyezve van, az órák kezdésekor mindenki mikrofonja le lesz némítva.';
$string['config_muteonstart_description'] = 'Ezek a beállítások engedélyezik vagy letiltják a felület tulajdonságainak a beállítását, illetve ezekhez alapértelmezett értékeket határoznak meg.';
$string['config_muteonstart_editable'] = 'A Némítás kezdéskor beállítása módosítható';
$string['config_muteonstart_editable_description'] = 'A Némítás kezdéskor beállítása alapesetben a tanterem hozzáadásakor vagy frissítésekor módosítható.';
$string['config_participant'] = 'Résztvevők';
$string['config_participant_description'] = 'Ezek a beállítások a konferencia résztvevőinek alapértelmezés szerinti szerepét határozzák meg.';
$string['config_participant_moderator_default'] = 'Moderátor';
$string['config_participant_moderator_default_description'] = 'Ez az alapértelmezés szerinti szerep új tanterem hozzáadásakor.';
$string['config_poll_interval'] = '';
$string['config_poll_interval_description'] = 'A lekérdezési intervallumnak legalább 2 másodpercnek kell lennie. Szükség esetén növelheti az intervallumot, hogy csökkentse a távoli kiszolgáló terhelését.';
$string['config_presentation_default'] = 'Alapértelmezett prezentációs fájl';
$string['config_presentation_default_description'] = 'Egy fájlt választhat ki az összes tanterem számára.';
$string['config_preuploadpresentation'] = 'Feltöltés előtti prezentáció';
$string['config_preuploadpresentation_description'] = 'Ezek a beállítások engedélyezik vagy letiltják a felület tulajdonságainak a beállítását, illetve ezekhez alapértelmezett értékeket határoznak meg. Ez a funkció csak akkor használható, ha a Moodle-szerver elérhető a BigBlueButton számára.';
$string['config_profile_picture_enabled_description'] = 'A résztvevők profilképei megjelenjenek a BigBlueButton találkozókon?';
$string['config_recording'] = 'Felvétel';
$string['config_recording_all_from_start_default'] = 'Felvétel rögzítése a kezdetektől';
$string['config_recording_all_from_start_default_description'] = 'Új BigBlueButton tanterem hozzáadásakor alapesetben bekapcsolva legyen-e a \'Felvétel rögzítése a kezdetektől\'?';
$string['config_recording_all_from_start_editable'] = 'A \'Felvétel rögzítése a kezdetektől\' szerkeszthető';
$string['config_recording_all_from_start_editable_description'] = 'A \'Felvétel rögzítése a kezdetektől\' szerkeszthető legyen-e a  BigBlueButton tevékenységbeállításai között?';
$string['config_recording_default'] = 'A felvétel alapesetben bekapcsolva';
$string['config_recording_default_description'] = 'Új BigBlueButton tanterem hozzáadásakor alapesetben bekapcsolva legyen-e a \'Felvétel rögzíthető\'?';
$string['config_recording_description'] = 'Ezek a beállítások funkciófüggőek';
$string['config_recording_editable'] = 'A munkamenet rögzítése szerkeszthető';
$string['config_recording_editable_description'] = 'A \'Munkamenet rögzítése\' szerkeszthető legyen-e a  BigBlueButton tevékenységbeállításai között?';
$string['config_recording_hide_button_default'] = 'A rögzítés gombjának elrejtése';
$string['config_recording_hide_button_default_description'] = 'Bejelölése esetén a rögzítés gombja nem látszik';
$string['config_recording_hide_button_editable'] = 'A rögzítés gombjának elrejtése szerkeszthető';
$string['config_recording_hide_button_editable_description'] = 'A \'A rögzítés gombjának elrejtése\' szerkeszthető legyen-e a  BigBlueButton tevékenységbeállításai között?';
$string['config_recording_protect_editable'] = 'A védett felvételi állapot szerkeszthető';
$string['config_recording_protect_editable_description'] = 'Bejelölése esetén a felület hozzáférést ad a védett/nem védett felvételekhez';
$string['config_recording_refresh_period'] = 'Felvétel frissítési időszaka (másodpercben)';
$string['config_recording_refresh_period_description'] = 'A BigBlueButton szerver lekérdezésére milyen gyakran kerüljön sor rögzítendő távoli információ frissítéséhez?';
$string['config_recording_safe_formats'] = 'Mindenki számára megtekinthető felvételi formátumok.';
$string['config_recordingready_enabled'] = 'Értesítés küldése a elérhetőségéről';
$string['config_recordingready_enabled_description'] = 'Értesítés küldése, amikor a felvétel elérhető. Ehhez a BigBlueButton szerveren be kell kapcsolni a post_publish_recording_ready_callback kódot.';
$string['config_recordings'] = 'Felvételek megjelenítése';
$string['config_recordings_asc_sort'] = 'A felvételeket rendezze fordított időrendbe.';
$string['config_recordings_asc_sort_description'] = 'Alapértelmezésként a felvételek időrendben vannak rendezve. Ha bejelöli, fordított időrendbe rendezheti őket.';
$string['config_recordings_deleted_default'] = 'A törölt tevékenységek felvételeinek alapértelmezés szerinti megjelenítése';
$string['config_recordings_deleted_default_description'] = 'Bekapcsolása esetén a felvételeket tartalmazó tábla adott esetben a már törölt tevékenységekhez tartozó felvételeket is tartalmazni fogja.';
$string['config_recordings_deleted_editable'] = 'A törölt tevékenységek felvételeinek megjelenítése beállítható';
$string['config_recordings_deleted_editable_description'] = 'A törölt tevékenységek felvételeinek alapértelmezés szerinti megjelenítése a tanterem hozzáadásakor vagy frissítésekor módosítható.';
$string['config_recordings_description'] = 'Ezek a beállítások funkicófüggőek';
$string['config_recordings_general'] = 'Rögzítési beállítások megjelenítése';
$string['config_recordings_general_description'] = 'Ezek a beállítások csak a felvételek megjelenítésekor használatosak.';
$string['config_recordings_imported_default'] = 'Csak az alapesetben engedélyezett hivatkozások megjelenítése';
$string['config_recordings_imported_default_description'] = 'Bekapcsolásával a felvételek táblázat csak a felvételek hivatkozásait fogja tartalmazni.';
$string['config_recordings_imported_editable'] = 'Csak az importált hivatkozások megjelenítése lehetőség szerkeszthető';
$string['config_recordings_imported_editable_description'] = 'Csak az importált hivatkozások megjelenítése lehetőség szerkeszthető alkalmak létrehozásakor vagy szerkesztésekor.';
$string['config_recordings_preview_default'] = 'Előnézet alapból bekapcsolva';
$string['config_recordings_preview_default_description'] = 'Ha be van kapcsolva, a táblázatban megjelenik a bemutató előnézete.';
$string['config_recordings_preview_editable'] = 'Előnézet használata módosítható';
$string['config_recordings_preview_editable_description'] = 'Előnézet használata módosítható alkalmak létrehozásakor vagy szerkesztésekor.';
$string['config_scheduled'] = 'Ütemezett munkamenetek';
$string['config_scheduled_description'] = 'Ezekkel a beállításokkal lehet az időzített munkamenetek alapértelmezett viselkedését megadni.';
$string['config_scheduled_pre_opening'] = 'Elérhető a kezdési idő előtt';
$string['config_scheduled_pre_opening_description'] = 'Az a percben megadott idő, amennyivel a kezdő időpont előtt a tanterem elérhetővé.';
$string['config_server_url'] = 'A BigBlueButton kiszolgáló webcíme';
$string['config_server_url_description'] = 'Az <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">ingyenes BigBlueButton szolgáltatást a Moodle számára (új ablakban)</a> a Blindside Networks az alábbi feltételekkel bocsátja rendelkezésre:
<ol>
<li>Az egyes munkamenetek maximális hossza 60 perc</li>
<li>Az egyes munkamenetekben részt vevők maximális száma 25 fő</li>
<li>A felvételek 7 napig tárolódnak és nem tölthetők le</li>
<li>A tzanulói webkamerákat csak a moderátor látja.</li>
</ol>';
$string['config_shared_secret'] = 'A BigBlueButton megosztott biztonsági kulcsa';
$string['config_shared_secret_description'] = 'A BigBlueButton szerver kiszolgáló biztonsági kulcsa. Ez az alapértelmezett kulcs a Blindside Networks által ingyenesen biztosított szerver kulcsa.';
$string['config_uidelegation_enabled'] = 'Felhasználói felület hozzárendelése engedélyezve';
$string['config_uidelegation_enabled_description'] = 'Ezekkel a beállításokkal lehet a BigBlueButton szerver felhasználói felületéről történő beállítások láthatóságát szabályozni.';
$string['config_userlimit'] = 'Felhasználói korlát';
$string['config_userlimit_default'] = 'Felhasználói korlát bekapcsolva alapértelmezésként';
$string['config_userlimit_default_description'] = 'Az alapértelmezetten engedélyezett résztvevők száma alkalmanként új terem létrehozásakor. Ha a szám 0, a felhasználók száma korlátlan.';
$string['config_userlimit_description'] = 'Ezek a beállítások a felhasználói felületen lehetőségek ki-/bekapcsolására és alapértékeik megadására szolgálnak.';
$string['config_userlimit_editable'] = 'Felhasználói korlát szerkeszthető';
$string['config_userlimit_editable_description'] = 'Az alapértelmezett felhasználói korlát a terem vagy a megbeszélés hozzáadásakor vagy frissítésekor szerkeszthető.';
$string['config_voicebridge'] = 'Hanghíd';
$string['config_voicebridge_description'] = 'Ezek a beállítások a felhasználói felületen lehetőségek ki-/bekapcsolására és alapértékeik megadására szolgálnak.';
$string['config_voicebridge_editable'] = 'A megbeszéléshez tartozó hanghíd szerkeszthető';
$string['config_voicebridge_editable_description'] = 'A megbeszéléshez tartozó hanghíd véglegesen hozzárendelhető egy teremhez. A hozzárendelés után a számot másik terem vagy megbeszélés nem használhatja.';
$string['config_waitformoderator'] = 'Várakozás a moderátorra';
$string['config_waitformoderator_cache_ttl'] = 'Várakozás a moderátorra gyorsítótár TTL (másodperc)';
$string['config_waitformoderator_cache_ttl_description'] = 'A kiszolgálót leterhelő nagyszámú egyidejű lekérdezéshez a segédprogram gyorsítótárazza az adatokat. Az itt megadott idő határozza meg a gyorsítótár következő lekérdezésig való megőrzésének az idejét.';
$string['config_waitformoderator_default'] = 'Várakozás a moderátorra alapértelmezésként bekapcsolva';
$string['config_waitformoderator_default_description'] = 'A \'Várakozás a moderátorra\' új terem hozzáadásakor alapesetben bekapcsolva legyen-e?';
$string['config_waitformoderator_description'] = 'Ezek a paraméterek funkciótól függőek.';
$string['config_waitformoderator_editable'] = 'A várakozás a moderátorra funkció szerkeszthető';
$string['config_waitformoderator_editable_description'] = 'A \'Várakozás a moderátorra\' szerkeszthető legyen-e a  BigBlueButton tevékenységbeállításai között?';
$string['config_waitformoderator_ping_interval'] = 'Várakozás a moderátorra lekérdezés (másodpercben)';
$string['config_waitformoderator_ping_interval_description'] = 'Milyen gyakran ellenőrizze a szerver, hogy a felhasználó belépett-e a terembe?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'A BigBlueButtonBN egy már elavult globális paraméterrel használja a config.php. Konvertálja a fájlt, mert a következő verziókban már nem lesz használható.';
$string['config_warning_curl_not_installed'] = 'Ehhez a funkcióhoz telepített és engedélyezett php CURL-kiterjesztés szükséges. A beállítások csak akkor válnak szerkeszthetővé, ha ez a feltétel teljesül.';
$string['config_welcome_default'] = 'Üdvözlési alapüzenet';
$string['config_welcome_default_description'] = 'Felülírja a BigBlueButton szerver alapüzenetét. Az üzenetben szerepelhetnek automatikusan lecserélődő kulcsszavak (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) , valamint html-címkék, pl. <b>...</b> vagy <i></i>';
$string['config_welcome_editable'] = 'Tanárok által szerkeszthető üdvözlő szöveg';
$string['config_welcome_editable_description'] = 'Az üdvözlő szöveg hozzáadás vagy frissítés alkalmával szerkeszthető';
$string['end_session_confirm'] = 'Biztosan befejezi a virtuális tantermi órát?';
$string['end_session_confirm_title'] = 'Befejezi az órát?';
$string['end_session_notification'] = 'Az óra lezárva.';
$string['ends_at'] = 'Befejezés';
$string['event_activity_created'] = 'Tevékenység létrehozva';
$string['event_activity_deleted'] = 'Tevékenység törölve';
$string['event_activity_updated'] = 'Tevékenység frissítve';
$string['event_live_session'] = 'Élő előadás';
$string['event_meeting_created'] = 'Találkozó létrehozva';
$string['event_meeting_ended'] = 'Találkozó kényszerítéssel befejezve';
$string['event_meeting_joined'] = 'Találkozóhoz csatlakozva';
$string['event_meeting_left'] = 'Találkozóból kilépve';
$string['event_recording_deleted'] = 'Felvétel törölve';
$string['event_recording_edited'] = 'Felvétel szerkesztve';
$string['event_recording_imported'] = 'Felvétel importálva';
$string['event_recording_protected'] = 'Védett felvétel';
$string['event_recording_published'] = 'Felvétel közzétéve';
$string['event_recording_unprotected'] = 'Nem védett felvétel';
$string['event_recording_unpublished'] = 'Közzé nem tett felvétel';
$string['event_recording_viewed'] = 'Felvétel megtekintve';
$string['event_unknown'] = 'Ismeretlen esemény';
$string['general_error_cannot_create_meeting'] = 'A foglalkozás nem hozható létre.';
$string['general_error_cannot_get_recordings'] = 'Felvételek nem érhetők el.';
$string['general_error_no_answer'] = 'Üres válasz. Ellenőrizze a BigBlueButton szerver webcímét ÉS azt is, hogy a szerver üzemel-e.';
$string['general_error_not_allowed_to_create_instances'] = 'A felhasználó számára nem engedélyezett semmilyen alkalom létrehozása.';
$string['general_error_not_found'] = 'Nem található tétel: {$a}.';
$string['general_error_unable_connect'] = 'Nem lehet csatlakozni. Ellenőrizze a BigBlueButton szervert ÉS azt, hogy üzemel-e.
Részletek: {$a}';
$string['index_confirm_end'] = 'Befejezi a virtuális osztályt?';
$string['index_disabled'] = 'kikapcsolva';
$string['index_enabled'] = 'bekapcsolva';
$string['index_ending'] = 'A virtuális osztály befejeződik... várjon...';
$string['index_error_bbtn'] = 'Hibás BigBlueButton {$a} azonosító';
$string['index_error_checksum'] = 'Ellenőrzőösszeg-hiba lépett föl. Ellenőrizze, hogy helyes biztonsági kulcsot adott-e meg.';
$string['index_error_forciblyended'] = 'Nem lehet a megbeszéléshez csatlakozni, mert kézi úton befejezték..';
$string['index_error_noinstances'] = 'Nincsenek BigBlueButton találkozók';
$string['index_error_unable_display'] = 'A megbeszéléseket nem lehet megjeleníteni. Ellenőrizze a BigBlueButton szerver URL-jét ÉS azt, hogy a szerver fut-e.';
$string['index_heading'] = 'BigBlueButton termek';
$string['index_heading_actions'] = 'Műveletek';
$string['index_heading_group'] = 'Csoport';
$string['index_heading_moderator'] = 'Moderátorok';
$string['index_heading_name'] = 'Terem';
$string['index_heading_recording'] = 'Felvétel';
$string['index_heading_users'] = 'Felhasználók';
$string['index_heading_viewer'] = 'Nézők';
$string['indicator:cognitivedepth'] = 'BigBlueButtonBN kognitív';
$string['indicator:cognitivedepth_help'] = 'Ez a jelölő a BigBlueButtonBN tevékenység során a tanuló által elért kognitív mélységen alapszik.';
$string['indicator:socialbreadth'] = 'BigBlueButtonBN szociális';
$string['indicator:socialbreadth_help'] = 'Ez az indikátor a BigBlueButtonBN tevékenység során a tanuló által elért közösségi jelenlétet jelöli.';
$string['instance_type_default'] = 'Terem/tevékenység felvételekkel';
$string['instance_type_recording_only'] = 'Csak felvételek';
$string['instance_type_room_only'] = 'Csak terem/tevékenység';
$string['instanceprofilewithoutrecordings'] = 'Az esemény profilja nem képes felvételeket megjeleníteni.';
$string['messageprovider:instance_updated'] = 'BigBlueButton foglalkozás frissítve';
$string['messageprovider:recording_ready'] = 'BigBlueButton felvétel megtekintésre kész';
$string['minute'] = 'perc';
$string['minutes'] = 'perc';
$string['mod_form_block_general'] = 'Általános beállítások';
$string['mod_form_block_participants'] = 'Résztvevők';
$string['mod_form_block_presentation'] = 'Bemutató tartalma';
$string['mod_form_block_presentation_default'] = 'Bemutató alapértelmezett tartalma';
$string['mod_form_block_record'] = 'Felvétel beállításai';
$string['mod_form_block_recordings'] = 'Rögzítési beállítások';
$string['mod_form_block_room'] = 'Tevékenység/terem beállításai';
$string['mod_form_block_schedule'] = 'Találkozó ütemezése';
$string['mod_form_field_closingtime'] = 'Csatlakozás vége';
$string['mod_form_field_conference_name'] = 'Értekezlet neve';
$string['mod_form_field_disablecam'] = 'Webkamerák kikapcsolása';
$string['mod_form_field_disablemic'] = 'Mikrofonok kikapcsolása';
$string['mod_form_field_disablenote'] = 'Megosztott jegyzetek kikapcsolása';
$string['mod_form_field_disableprivatechat'] = 'Magáncsevegés kikapcsolása';
$string['mod_form_field_disablepublicchat'] = 'Nyilvános csevegés kikapcsolása';
$string['mod_form_field_duration'] = 'Időtartam';
$string['mod_form_field_duration_help'] = 'A találkozó időtartama azt a maximális időtartamot állítja be, ameddig  a találkozó a felvétel vége előtt tart.';
$string['mod_form_field_hideuserlist'] = 'Felhasználói lista elrejtése';
$string['mod_form_field_instanceprofiles'] = 'Találkozó típusa';
$string['mod_form_field_instanceprofiles_help'] = 'Válassza ki a BigBlueButtonBN példány típusát.';
$string['mod_form_field_intro'] = 'Leírás';
$string['mod_form_field_intro_help'] = 'A terem vagy értekezlet rövid leírása';
$string['mod_form_field_muteonstart'] = 'Némítás induláskor';
$string['mod_form_field_name'] = 'A virtuális tanterem neve';
$string['mod_form_field_nosettings'] = 'Nincsenek szerkeszthető beállítások';
$string['mod_form_field_openingtime'] = 'Csatlakozás kezdete';
$string['mod_form_field_participant_add'] = 'Résztvevő hozzáadása';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderátor';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Néző';
$string['mod_form_field_participant_list'] = 'Résztvevők listája';
$string['mod_form_field_participant_list_action_add'] = 'Hozzáad';
$string['mod_form_field_participant_list_action_remove'] = 'Töröl';
$string['mod_form_field_participant_list_text_as'] = 'mint';
$string['mod_form_field_participant_list_type_all'] = 'Minden beiratkozott felhasználó';
$string['mod_form_field_participant_list_type_owner'] = 'Tulajdonos';
$string['mod_form_field_participant_list_type_role'] = 'Szerep';
$string['mod_form_field_participant_list_type_user'] = 'Felhasználó';
$string['mod_form_field_record'] = 'A találkozóról felvétel készíhető';
$string['mod_form_field_recordallfromstart'] = 'Felvétel az elejétől kezdve';
$string['mod_form_field_recordhidebutton'] = 'Felvétel gombjának elrejtése';
$string['mod_form_field_recordings_deleted'] = 'Törölt tevékenységek felvételeivel együtt';
$string['mod_form_field_recordings_html'] = 'A táblázat megjelenítése sima HTML-ként';
$string['mod_form_field_recordings_imported'] = 'Csak az importált hivatkozások megjelenítése';
$string['mod_form_field_recordings_preview'] = 'Felvétel előnézetének megjelenítése';
$string['mod_form_field_room_name'] = 'Terem neve';
$string['mod_form_field_userlimit'] = 'Felhasználói korlát';
$string['mod_form_field_userlimit_help'] = 'A találkozóba bekapcsolódó résztvevők maximális száma. Ha ez a szám 0, nem lesz korlátozva a résztvevők száma.';
$string['mod_form_field_voicebridge'] = 'Hanghíd [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Formátumhiba. 1-9999 közötti számot kell megadnia.';
$string['mod_form_field_voicebridge_help'] = 'Hangkonferencia száma azon résztvevők számára, akik betelefonálással kapcsolódnak be a találkozóba. A szám 1 és 9999 közötti lehet. Ha a szám 0, a mezőt figyelmen kívül hagyja a rendszer és véletlenszerűen választ számot. A négy beírt számjegyet megelőzi a 7-es szám.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Nem egyedi érték. Ezt a számot már egy másik értekezlet vagy terem használja.';
$string['mod_form_field_wait'] = 'Várakozás moderátorra';
$string['mod_form_field_wait_help'] = 'A nézőknek várniuk kell, amíg egy moderátor be nem lép';
$string['mod_form_field_welcome'] = 'Üdvözlő szöveg';
$string['mod_form_field_welcome_default'] = '<br>Üdvözöljük a(z) <b>%%CONFNAME%%</b> megbeszélésen!<br><br>A BigBlueButton használatához segítségképpen nézze meg ezeket a (rövid)  <a href="event:http://www.bigbluebutton.org/content/videos"><u> angol nyelvű videóbemutatókat</u></a>.<br><br>A hanghídhoz csatlakozáshoz kattintson a telefon ikonra (középen fent). <b>A zavaró háttérzajok kiiktatása érdekében használjon fülhallgatót.</b>';
$string['mod_form_field_welcome_help'] = 'Kicseréli a BigBlueButton kiszolgáló által megjelenített alapértelmezett üdvözlő szöveget. Az üzenet tartalmazhat kulcsszavakat  (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%), melyek automatikusan kicserélődnek, illetve html-címkéket, pl. <b>...</b> vagy <i>...</i>';
$string['mod_form_locksettings'] = 'Zárolási beállítások';
$string['modulename'] = 'BigBlueButtonBN';
$string['modulename_help'] = 'A BigBlueButtonBN olyan nyílt forráskódú távoktatási webes konferenciarendszer, amely lehetővé teszi valósidejű online osztálytermek használatát a Moodle-rendszerben.

A BigBlueButtonBN használatakor megadhatja a találkozó címét, leírását, naptári időpontját, a résztvevők csoportját, illetve az online találkozóról felvételt is készíthet.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButtonBN';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton-tevékenység';
$string['nosuchinstance'] = 'Nincs  {$a->id} azonosítójú {$a->entity} esemény';
$string['notification_instance_created_intro'] = 'A(z) <a href="{$a->link}">{$a->name}</a> BigBlueButton tevékenység létrehozva.';
$string['notification_instance_created_small'] = 'Új BigBlueButton foglalkozás {$a->name} névvel létrehozva';
$string['notification_instance_created_subject'] = 'Új BigBlueButton foglalkozás létrehozva';
$string['notification_instance_description'] = 'Leírás';
$string['notification_instance_end_date'] = 'Befejezési időpont';
$string['notification_instance_name'] = 'Cím';
$string['notification_instance_start_date'] = 'Kezdési időpont';
$string['notification_instance_updated_intro'] = 'A(z) <a href="{$a->link}">{$a->name}</a> BigBlueButton tevékenység frissítve.';
$string['notification_instance_updated_small'] = 'A(z) {$a->name} BigBlueButton foglalkozás frissítve';
$string['notification_instance_updated_subject'] = 'BigBlueButton foglalkozása frissítve';
$string['notification_recording_ready_html'] = '<b><a href="{$a->link}">{$a->name}</a></b foglalkozás esetén felvétel áll rendelkezésre';
$string['notification_recording_ready_plain'] = '{$a->name} foglalkozás esetén felvétel áll rendelkezésre. A foglalkozás megtekintéséhez látogasson el ide: {$a->link}';
$string['notification_recording_ready_small'] = 'A(z) {$a->name} BigBlueButton foglalkozás esetén új felvétel áll rendelkezésre.';
$string['notification_recording_ready_subject'] = 'Felvétel kész';
$string['pluginadministration'] = 'BigBlueButton adminisztráció';
$string['pluginname'] = 'BigBlueButtonBN';
$string['privacy:metadata:bigbluebutton'] = 'BigBlueButton megbeszélés létrehozásához vagy azon való részvételhez felhasználói adatok cseréjére kerül sor a kiszolgálóval.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'A BigBlueButton kiszolgálóhoz kapcsolódó felhasználó teljes neve.';
$string['privacy:metadata:bigbluebutton:userid'] = 'A BigBlueButton kiszolgálóhoz kapcsolódó felhasználó azonosítója.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Tárolja a terem vagy tevékenység azon beállításait, amelyek a BigBlueButton esemény funkcióit és általános viselkedését határozzák meg.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Szabálylista, amely meghatározza hogy a találkozón részt vevő felhasználók szerepét. A felhasználói azonosító tárolásra kerülhet, mivel a jogok kiosztása szerepek vagy felhasználók szerint történhet.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Tárolja azokat az eseményeket, amelyekre a segédprogram használata esetén kerül sor.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'A felhasználó által kezdeményezett esemény típusa.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'A felhasználó által elért találkozó azonosítója.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Tartalmazhat a találkozóval vagy felvétellel kapcsolatos további információkat.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'A napló létrehozásának ideje.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Az eseményt kezdeményező felhasználó azonosítója.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Metaadatokat tárol a felvételektről';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'A felvételt utoljára módosító felhasználó azonosítója';
$string['recordings_from_deleted_activities'] = 'Törölt tevékenységek felvételei';
$string['recordingurlnotfound'] = 'A felvétel webcíme érvénytelen';
$string['removedevents'] = 'Törölt események';
$string['removedlogs'] = 'Törölt egyedi naplók';
$string['removedrecordings'] = 'Törölt felvételek';
$string['removedtags'] = 'Törölt címkék';
$string['resetevents'] = 'Események törlése';
$string['resetlogs'] = 'Egyedi naplók törlése';
$string['resetlogs_help'] = 'Naplók törlésével a felvételekre mutató hivatkozások is eltűnnek';
$string['resetrecordings'] = 'Felvételek törlése';
$string['resetrecordings_help'] = 'A felvételek törlés után nem elérhetőek, és a művelet nem érvényteleníthető';
$string['resettags'] = 'Címkék törlése';
$string['search:activity'] = 'BigBlueButtonBN - tevékenységgel kapcsolatos információk';
$string['search:tags'] = 'BigBlueButtonBN - címkékkel kapcsolatos információk';
$string['sendnotification'] = 'Értesítés küldése';
$string['settings'] = 'A BigBlueButton beállításai';
$string['started_at'] = 'Elkezdve';
$string['starts_at'] = 'Kezdés';
$string['taskname:check_pending_recordings'] = 'Folyamatban lévő felvételek elérése';
$string['userlimitreached'] = 'A foglalkozás részt vevő felhasználók maximális számát elérte.';
$string['view_conference_action_end'] = 'Befejezés';
$string['view_conference_action_join'] = 'Csatlakozás a találkozóhoz';
$string['view_error_action_not_completed'] = 'A művelet végrehajtása sikertelen';
$string['view_error_bigbluebutton'] = 'A BigBlueButton hibákkal válaszolt. {$a}';
$string['view_error_create'] = 'A BigBlueButton kiszolgáló hibaüzenettel válaszolt, a találkozót nem lehetett létrehozni.';
$string['view_error_current_state_not_found'] = 'Jelenlegi állapot nem található. A felvétel valószínűleg törölve lett, vagy a BigBlueButton kiszolgáló nem kompatibilis a végrehajtott művelettel.';
$string['view_error_import_no_courses'] = 'Nincsenek kurzusok felvételek kereséséhez.';
$string['view_error_import_no_recordings'] = 'Ehhez a kurzushoz nem tartoznak importálható felvételek';
$string['view_error_invalid_session'] = 'A munkamenet lejárt. Térjen vissza a tevékenység kezdőoldalára.';
$string['view_error_max_concurrent'] = 'Elérte az egyidejűleg tartható találkozók korlátját.';
$string['view_error_meeting_not_running'] = 'Valami nem stimmel, a találkozó nem működik.';
$string['view_error_no_group'] = 'Még nincsenek csoportok definiálva. Csatlakozás előtt hozzon létre csoportokat.';
$string['view_error_no_group_student'] = 'Ön nincs hozzárendelve csoporthoz. Forduljon a tanárához vagy a rendszergazdához.';
$string['view_error_no_group_teacher'] = 'Még nincsenek beállított csoportok. Előbb hozzon létre egy csoportot vagy lépjen kapcsolatba a rendszergazdával.';
$string['view_error_unable_join'] = 'Nem lehet csatlakozni a találkozóhoz. Ellenőrizze a BigBlueButton kiszolgáló webcímét ÉS azt is, hogy a BigBlueButton kiszolgáló működik-e.';
$string['view_error_unable_join_student'] = 'Sikertelen a csatlakozás a BigBlueButton kiszolgálóhoz. Forduljon a tanárához vagy a rendszergazdához.';
$string['view_error_unable_join_teacher'] = 'Sikertelen a csatlakozás a BigBlueButton kiszolgálóhoz. Forduljon a rendszergazdához.';
$string['view_error_url_missing_parameters'] = 'A webcím hiányos.';
$string['view_error_userlimit_reached'] = 'A találkozóhoz csatlakozott résztvevők száma elérte az engedélyezett résztvevők számát.';
$string['view_groups_nogroups_warning'] = 'A termet csoportokhoz állították be, de a kurzusban egy csoport sincs megadva.';
$string['view_groups_notenrolled_warning'] = 'A termet csoportokhoz állították be, de Ön nem tagja egyik csoportnak sem.';
$string['view_groups_selection'] = 'Válassza ki a csoportot, amelyikhez csatlakozni kíván, és hagyja jóvá';
$string['view_groups_selection_join'] = 'Csatlakozás';
$string['view_groups_selection_warning'] = 'Minden csoportnak egy terme van, de Ön többhöz van beosztva. Mindig a helyes termet válassza ki.';
$string['view_login_moderator'] = 'Belépés moderátorként...';
$string['view_login_viewer'] = 'Belépés nézőként...';
$string['view_message_and'] = 'és';
$string['view_message_conference_has_ended'] = 'A találkozó befejeződött.';
$string['view_message_conference_in_progress'] = 'A találkozó folyamatban.';
$string['view_message_conference_not_started'] = 'A találkozó még nem kezdődött el.';
$string['view_message_conference_room_ready'] = 'A terem készen áll. Csatlakozhat a találkozóhoz.';
$string['view_message_conference_wait_for_moderator'] = 'Várakozás egy moderátor csatlakozására.';
$string['view_message_finished'] = 'A tevékenység befejeződött.';
$string['view_message_has_joined'] = 'csatlakozott';
$string['view_message_have_joined'] = 'csatlakozott';
$string['view_message_hour'] = 'óra';
$string['view_message_hours'] = 'óra';
$string['view_message_importrecordings_disabled'] = 'A felvételek hivatkozásainak importálása lehetőség a kiszolgálón le lett tiltva.';
$string['view_message_minute'] = 'perc';
$string['view_message_minutes'] = 'perc';
$string['view_message_moderator'] = 'moderátor';
$string['view_message_moderators'] = 'moderátor';
$string['view_message_norecordings'] = 'Nincsenek megjeleníthető felvételek.';
$string['view_message_notavailableyet'] = 'A találkozó még nem elérhető.';
$string['view_message_recordings_disabled'] = 'A felvételrögzítés le lett a kiszolgálón tiltva. A csak felvételekhez létrehozott BigBlueButtonBN találkozók nem használhatóak.';
$string['view_message_room_closed'] = 'A terem zárva van.';
$string['view_message_room_open'] = 'A terem nyitva van.';
$string['view_message_room_ready'] = 'A terem kész.';
$string['view_message_session_for'] = 'ehhez kapcsolódó munkamenet';
$string['view_message_session_has_user'] = 'Összesen';
$string['view_message_session_has_users'] = 'Összesen';
$string['view_message_session_no_users'] = 'Nincsenek résztvevők a találkozón.';
$string['view_message_session_running_for'] = 'A találkozó ennyi ideje tart';
$string['view_message_session_started_at'] = 'A találkozó ekkor kezdődött';
$string['view_message_tab_close'] = 'A fület/ablakot kézzel kell bezárni';
$string['view_message_times'] = 'alkalommal';
$string['view_message_user'] = 'felhasználó';
$string['view_message_users'] = 'felhasználó';
$string['view_message_viewer'] = 'néző';
$string['view_message_viewers'] = 'néző';
$string['view_mobile_message_groups_not_supported'] = 'Ez a találkozó csoportok számára lett létrehozva, amit a mobil alkalmazás nem támogat. Az asztalon nyissa meg a felületet, ha a csoporthoz kíván csatlakozni.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Elérte az oldalon töltött ideje a 45 másodpercet. Töltse újra az oldalt a böngésző segítségével, hogy csatlakozni tudjon a találkozóhoz.';
$string['view_noguests'] = 'A BigBlueButtonBN nem elérhető vendégek számára.';
$string['view_nojoin'] = 'Ön a csatlakozáshoz nem rendelkezik megfelelő szerepkörrel.';
$string['view_recording'] = 'felvétel';
$string['view_recording_actionbar'] = 'Eszköztár';
$string['view_recording_activity'] = 'Tevékenység';
$string['view_recording_button_import'] = 'Felvételhivatkozások importálása';
$string['view_recording_button_return'] = 'Visszatérés';
$string['view_recording_course'] = 'Kurzus';
$string['view_recording_date'] = 'Dátum';
$string['view_recording_delete_confirmation'] = 'Biztosan törölni akarja ezt {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'A felvételhez tartozó {$a} hivatkozás másik kurzusban vagy tevékenységben lett importálva. Ha a felvételt törli, ezek a hivatkozások szintén el lesznek távolítva';
$string['view_recording_delete_confirmation_warning_s'] = 'A felvételhez tartozó {$a} hivatkozás másik kurzusban vagy tevékenységben lett importálva. Ha a felvételt törli, a hivatkozás szintén el lesz távolítva';
$string['view_recording_description'] = 'Leírás';
$string['view_recording_description_edithint'] = 'Szerkessze a leírást. Ez segít a felvétel későbbi megtalálásában.';
$string['view_recording_description_editlabel'] = 'Leírás szerkesztése';
$string['view_recording_duration'] = 'Időtartam';
$string['view_recording_duration_min'] = 'perc';
$string['view_recording_format_errror_unreachable'] = 'A felvételformátumhoz tartozó webcím nem elérhető.';
$string['view_recording_format_notes'] = 'Jegyzetek';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Bemutató';
$string['view_recording_format_screenshare'] = 'Képernyőmegosztás';
$string['view_recording_format_statistics'] = 'Statisztika';
$string['view_recording_format_video'] = 'Videó';
$string['view_recording_import_confirmation'] = 'Biztosan importálja ezt a felvételt?';
$string['view_recording_length'] = 'Hossz';
$string['view_recording_link_warning'] = 'Ez a hivatkozás egy másik kurzusban vagy tevékenység során létrehozott felvételre mutat';
$string['view_recording_list_action_delete'] = 'Törlés';
$string['view_recording_list_action_edit'] = 'Frissítés';
$string['view_recording_list_action_play'] = 'Lejátszás';
$string['view_recording_list_action_process'] = 'Feldolgozás';
$string['view_recording_list_action_protect'] = 'Védetté tétel';
$string['view_recording_list_action_publish'] = 'Közzététel';
$string['view_recording_list_action_unprotect'] = 'Védelem törlése';
$string['view_recording_list_action_unpublish'] = 'Közzétételt visszavon';
$string['view_recording_list_action_update'] = 'Frissítés';
$string['view_recording_list_actionbar'] = 'Eszköztár';
$string['view_recording_list_actionbar_delete'] = 'Törlés';
$string['view_recording_list_actionbar_edit'] = 'Szerkesztés';
$string['view_recording_list_actionbar_hide'] = 'Elrejtés';
$string['view_recording_list_actionbar_import'] = 'Importálás';
$string['view_recording_list_actionbar_protect'] = 'Privátként beállít';
$string['view_recording_list_actionbar_publish'] = 'Közzététel';
$string['view_recording_list_actionbar_show'] = 'Mutatás';
$string['view_recording_list_actionbar_unprotect'] = 'Publikusként beállít';
$string['view_recording_list_actionbar_unpublish'] = 'Közzététel visszavonása';
$string['view_recording_list_activity'] = 'Tevékenység';
$string['view_recording_list_course'] = 'Kurzus';
$string['view_recording_list_date'] = 'Dátum';
$string['view_recording_list_description'] = 'Leírás';
$string['view_recording_list_duration'] = 'Időtartam';
$string['view_recording_list_recording'] = 'Felvétel';
$string['view_recording_meeting'] = 'Találkozó';
$string['view_recording_modal_button'] = 'Alkalmaz';
$string['view_recording_modal_title'] = 'Felvételhez értékek megadása';
$string['view_recording_name'] = 'Név';
$string['view_recording_name_edithint'] = 'Szerkessze a címét. Ez segít a felvétel későbbi megtalálásában.';
$string['view_recording_name_editlabel'] = 'Cím  szerkesztése';
$string['view_recording_playback'] = 'Lejátszás';
$string['view_recording_preview'] = 'Előnézet';
$string['view_recording_preview_help'] = 'Húzza az egeret a kép fölé a teljes méretű megtekintéshez';
$string['view_recording_protect_confirmation'] = 'Biztosan védelemmel látja el ezt:  {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'A felvétel {$a} különféle kurzusokból vagy tevékenységekből importált hivatkozást tartalmaz. A védelem érinteni fogja az importált hivatkozásokat is.';
$string['view_recording_protect_confirmation_warning_s'] = 'A felvétel {$a} más kurzusból vagy tevékenységből importált hivatkozást tartalmaz. A védelem érinteni fogja az importált hivatkozásokat is.';
$string['view_recording_publish_confirmation'] = 'Biztosan közzé teszi ezt:  {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'A felvétel {$a} különféle kurzusokból vagy tevékenységekből importált hivatkozást tartalmaz. A közzététellel a hivatkozásokat is közzé teszi.';
$string['view_recording_publish_confirmation_warning_s'] = 'A felvétel {$a} más kurzusból vagy tevékenységből importált hivatkozást tartalmaz. A közzététellel a hivatkozást is közzé teszi.';
$string['view_recording_publish_link_deleted'] = 'Ezt a hivatkozást nem lehet újra elérhetővé tenni, mert a felvétel már nem található a jelenlegi BigBlueButton kiszolgálón. A hivatkozást javasolt törölni.';
$string['view_recording_publish_link_not_published'] = 'Ezt a hivatkozást nem lehet újra elérhetővé tenni, mert a felvétel közzétételét visszavonták.';
$string['view_recording_recording'] = 'Felvétel';
$string['view_recording_select_course'] = 'Előbb válasszon kurzust a lenyíló menüből.';
$string['view_recording_tags'] = 'Címkék';
$string['view_recording_unprotect_confirmation'] = 'Biztosan feloldja ennek a védelmét:  {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'A felvétel {$a} különféle kurzusokból vagy tevékenységekből importált hivatkozást tartalmaz. A védelem feloldása érinteni fogja az importált hivatkozásokat is.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'A felvétel {$a} más kurzusból vagy tevékenységből importált hivatkozást tartalmaz. A védelem feloldása érinteni fogja az importált hivatkozásokat is.';
$string['view_recording_unprotect_link_deleted'] = 'Ezt a hivatkozást nem lehet újra hozzáférhetővé tenni, mert a felvétel már nem található a jelenlegi BigBlueButton kiszolgálón. A hivatkozást javasolt törölni.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Ezt a hivatkozást nem lehet hozzáférhetővé tenni, mert a felvétel védett.';
$string['view_recording_unpublish_confirmation'] = 'Biztosan visszavonja {$a} publikus elérhetőségét?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Az ehhez a felvételhez tartozó {$a} hivatkozások már másik kurzushoz vagy tevékenységhez lettek importálva. Ha a felvétel elérhetőségét visszavonják, a hivatkozások szintén elérhetetlenné válnak';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Az ehhez a felvételhez tartozó {$a} hivatkozás már másik kurzushoz vagy tevékenységhez lett csatolva. Ha a felvétel elérhetőségét visszavonják, a hivatkozás szintén elérhetetlenné válik';
$string['view_recording_yui_first'] = 'Első';
$string['view_recording_yui_go'] = 'Indít';
$string['view_recording_yui_last'] = 'Utolsó';
$string['view_recording_yui_next'] = 'Következő';
$string['view_recording_yui_page'] = 'Oldal';
$string['view_recording_yui_prev'] = 'Előző';
$string['view_recording_yui_rows'] = 'Sor';
$string['view_recording_yui_show_all'] = 'Az összes mutatása';
$string['view_room'] = 'Terem megtekintése';
$string['view_section_title_presentation'] = 'Bemutató állománya';
$string['view_section_title_recordings'] = 'Felvételek';
$string['waitformoderator'] = 'Várakozás egy moderátor bekapcsolódására.';
